
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `elgg625`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]access_collections`
--

CREATE TABLE `[[dbprefix]]access_collections` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8mb4_general_ci NOT NULL,
  `owner_guid` int unsigned NOT NULL,
  `subtype` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `owner_guid` (`owner_guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]access_collections`
--

INSERT INTO `[[dbprefix]]access_collections` VALUES
(3, 'friends', 46, 'friends');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]access_collection_membership`
--

CREATE TABLE `[[dbprefix]]access_collection_membership` (
  `user_guid` int unsigned NOT NULL,
  `access_collection_id` int NOT NULL,
  PRIMARY KEY (`user_guid`,`access_collection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]annotations`
--

CREATE TABLE `[[dbprefix]]annotations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `entity_guid` int unsigned NOT NULL,
  `name` text COLLATE utf8mb4_general_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_general_ci NOT NULL,
  `value_type` enum('integer','text','bool') COLLATE utf8mb4_general_ci DEFAULT NULL,
  `owner_guid` int unsigned NOT NULL,
  `access_id` int NOT NULL,
  `time_created` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `entity_guid` (`entity_guid`),
  KEY `name` (`name`(50)),
  KEY `value` (`value`(50)),
  KEY `owner_guid` (`owner_guid`),
  KEY `access_id` (`access_id`),
  KEY `time_created` (`time_created`),
  KEY `entity_guid_name` (`entity_guid`,`name`(255))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]api_users`
--

CREATE TABLE `[[dbprefix]]api_users` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `api_key` varchar(40) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `secret` varchar(40) COLLATE utf8mb4_general_ci NOT NULL,
  `active` int DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `api_key` (`api_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
('allow_registration', 'b:0;'),
('allow_user_default_access', 's:0:"";'),
('default_access', 's:1:"2";'),
('default_limit', 'i:10;'),
('installed', 'i:[[timestamp]];'),
('language', 's:2:"en";'),
('lastcache', 'i:[[timestamp]];'),
('require_admin_validation', 'b:0;'),
('simplecache_enabled', 'i:1;'),
('simplecache_minify_css', 'b:1;'),
('simplecache_minify_js', 'b:1;'),
('system_cache_enabled', 'i:1;'),
('walled_garden', 'b:0;'),
('__site_secret__', 's:32:"[[site_secret]]";');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]delayed_email_queue`
--

CREATE TABLE `[[dbprefix]]delayed_email_queue` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `recipient_guid` bigint unsigned NOT NULL,
  `delivery_interval` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `data` mediumblob NOT NULL,
  `timestamp` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `recipient_guid` (`recipient_guid`),
  KEY `delivery_interval` (`delivery_interval`),
  KEY `recipient_interval` (`recipient_guid`,`delivery_interval`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]entities`
--

CREATE TABLE `[[dbprefix]]entities` (
  `guid` int unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('object','user','group','site') COLLATE utf8mb4_general_ci NOT NULL,
  `subtype` varchar(252) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `owner_guid` int unsigned NOT NULL,
  `container_guid` int unsigned NOT NULL,
  `access_id` int NOT NULL,
  `time_created` int NOT NULL,
  `time_updated` int NOT NULL,
  `last_action` int NOT NULL DEFAULT '0',
  `enabled` enum('yes','no') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'yes',
  `deleted` enum('yes','no') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'no',
  `time_deleted` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`guid`),
  KEY `type` (`type`),
  KEY `owner_guid` (`owner_guid`),
  KEY `container_guid` (`container_guid`),
  KEY `access_id` (`access_id`),
  KEY `time_created` (`time_created`),
  KEY `time_updated` (`time_updated`),
  KEY `subtype` (`subtype`(50)),
  KEY `type_subtype` (`type`,`subtype`(50)),
  KEY `type_subtype_owner` (`type`,`subtype`(50),`owner_guid`),
  KEY `type_subtype_container` (`type`,`subtype`(50),`container_guid`),
  KEY `deleted` (`deleted`),
  KEY `time_deleted` (`time_deleted`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=53 ;

--
-- Dumping data for table `[[dbprefix]]entities`
--

INSERT INTO `[[dbprefix]]entities` VALUES
(1, 'site', 'site', 0, 0, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(2, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(3, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(4, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(5, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(6, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(7, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(8, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(9, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(10, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(11, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(12, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(13, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(14, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(15, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(16, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(17, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(18, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(19, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(20, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(21, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(22, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(23, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(24, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(25, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(26, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(27, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(28, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(29, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(30, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(31, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(32, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(33, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(34, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(35, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(36, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(37, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(38, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(39, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(40, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(41, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(42, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(43, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(44, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(45, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(46, 'user', 'user', 0, 0, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(47, 'object', 'widget', 46, 46, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(48, 'object', 'widget', 46, 46, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(49, 'object', 'widget', 46, 46, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(50, 'object', 'widget', 46, 46, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(51, 'object', 'widget', 46, 46, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0),
(52, 'object', 'admin_notice', 46, 46, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes', 'no', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]entity_relationships`
--

CREATE TABLE `[[dbprefix]]entity_relationships` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `guid_one` int unsigned NOT NULL,
  `relationship` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `guid_two` int unsigned NOT NULL,
  `time_created` int NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `guid_one` (`guid_one`,`relationship`,`guid_two`),
  KEY `relationship` (`relationship`),
  KEY `guid_two` (`guid_two`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=24 ;

--
-- Dumping data for table `[[dbprefix]]entity_relationships`
--

INSERT INTO `[[dbprefix]]entity_relationships` VALUES
(1, 2, 'active_plugin', 1, [[timestamp]]),
(2, 3, 'active_plugin', 1, [[timestamp]]),
(3, 4, 'active_plugin', 1, [[timestamp]]),
(4, 5, 'active_plugin', 1, [[timestamp]]),
(5, 6, 'active_plugin', 1, [[timestamp]]),
(6, 9, 'active_plugin', 1, [[timestamp]]),
(7, 11, 'active_plugin', 1, [[timestamp]]),
(8, 12, 'active_plugin', 1, [[timestamp]]),
(9, 13, 'active_plugin', 1, [[timestamp]]),
(10, 14, 'active_plugin', 1, [[timestamp]]),
(11, 15, 'active_plugin', 1, [[timestamp]]),
(12, 16, 'active_plugin', 1, [[timestamp]]),
(13, 17, 'active_plugin', 1, [[timestamp]]),
(14, 18, 'active_plugin', 1, [[timestamp]]),
(15, 19, 'active_plugin', 1, [[timestamp]]),
(16, 20, 'active_plugin', 1, [[timestamp]]),
(17, 21, 'active_plugin', 1, [[timestamp]]),
(18, 22, 'active_plugin', 1, [[timestamp]]),
(19, 23, 'active_plugin', 1, [[timestamp]]),
(20, 24, 'active_plugin', 1, [[timestamp]]),
(21, 26, 'active_plugin', 1, [[timestamp]]),
(22, 29, 'active_plugin', 1, [[timestamp]]),
(23, 30, 'active_plugin', 1, [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hmac_cache`
--

CREATE TABLE `[[dbprefix]]hmac_cache` (
  `hmac` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `ts` int NOT NULL,
  PRIMARY KEY (`hmac`),
  KEY `ts` (`ts`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]metadata`
--

CREATE TABLE `[[dbprefix]]metadata` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `entity_guid` int unsigned NOT NULL,
  `name` text COLLATE utf8mb4_general_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_general_ci NOT NULL,
  `value_type` enum('integer','text','bool') COLLATE utf8mb4_general_ci DEFAULT NULL,
  `time_created` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `entity_guid` (`entity_guid`),
  KEY `name` (`name`(50)),
  KEY `value` (`value`(50))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=212 ;

--
-- Dumping data for table `[[dbprefix]]metadata`
--

INSERT INTO `[[dbprefix]]metadata` VALUES
(1, 1, 'name', '[[site_name]]', 'text', [[timestamp]]),
(2, 1, 'email', '[[site_email]]', 'text', [[timestamp]]),
(3, 2, 'title', 'activity', 'text', [[timestamp]]),
(4, 2, 'elgg:internal:priority', '2', 'integer', [[timestamp]]),
(5, 3, 'title', 'blog', 'text', [[timestamp]]),
(6, 3, 'elgg:internal:priority', '3', 'integer', [[timestamp]]),
(7, 4, 'title', 'bookmarks', 'text', [[timestamp]]),
(8, 4, 'elgg:internal:priority', '4', 'integer', [[timestamp]]),
(9, 5, 'title', 'ckeditor', 'text', [[timestamp]]),
(10, 5, 'elgg:internal:priority', '5', 'integer', [[timestamp]]),
(11, 6, 'title', 'custom_index', 'text', [[timestamp]]),
(12, 6, 'elgg:internal:priority', '6', 'integer', [[timestamp]]),
(13, 7, 'title', 'dashboard', 'text', [[timestamp]]),
(14, 7, 'elgg:internal:priority', '7', 'integer', [[timestamp]]),
(15, 8, 'title', 'developers', 'text', [[timestamp]]),
(16, 8, 'elgg:internal:priority', '8', 'integer', [[timestamp]]),
(17, 9, 'title', 'discussions', 'text', [[timestamp]]),
(18, 9, 'elgg:internal:priority', '9', 'integer', [[timestamp]]),
(19, 10, 'title', 'externalpages', 'text', [[timestamp]]),
(20, 10, 'elgg:internal:priority', '10', 'integer', [[timestamp]]),
(21, 11, 'title', 'file', 'text', [[timestamp]]),
(22, 11, 'elgg:internal:priority', '11', 'integer', [[timestamp]]),
(23, 12, 'title', 'friends', 'text', [[timestamp]]),
(24, 12, 'elgg:internal:priority', '12', 'integer', [[timestamp]]),
(25, 13, 'title', 'friends_collections', 'text', [[timestamp]]),
(26, 13, 'elgg:internal:priority', '13', 'integer', [[timestamp]]),
(27, 14, 'title', 'garbagecollector', 'text', [[timestamp]]),
(28, 14, 'elgg:internal:priority', '14', 'integer', [[timestamp]]),
(29, 15, 'title', 'groups', 'text', [[timestamp]]),
(30, 15, 'elgg:internal:priority', '15', 'integer', [[timestamp]]),
(31, 16, 'title', 'invitefriends', 'text', [[timestamp]]),
(32, 16, 'elgg:internal:priority', '16', 'integer', [[timestamp]]),
(33, 17, 'title', 'likes', 'text', [[timestamp]]),
(34, 17, 'elgg:internal:priority', '17', 'integer', [[timestamp]]),
(35, 18, 'title', 'members', 'text', [[timestamp]]),
(36, 18, 'elgg:internal:priority', '18', 'integer', [[timestamp]]),
(37, 19, 'title', 'messageboard', 'text', [[timestamp]]),
(38, 19, 'elgg:internal:priority', '19', 'integer', [[timestamp]]),
(39, 20, 'title', 'messages', 'text', [[timestamp]]),
(40, 20, 'elgg:internal:priority', '20', 'integer', [[timestamp]]),
(41, 21, 'title', 'pages', 'text', [[timestamp]]),
(42, 21, 'elgg:internal:priority', '21', 'integer', [[timestamp]]),
(43, 22, 'title', 'profile', 'text', [[timestamp]]),
(44, 22, 'elgg:internal:priority', '22', 'integer', [[timestamp]]),
(45, 23, 'title', 'reportedcontent', 'text', [[timestamp]]),
(46, 23, 'elgg:internal:priority', '23', 'integer', [[timestamp]]),
(47, 24, 'title', 'search', 'text', [[timestamp]]),
(48, 24, 'elgg:internal:priority', '24', 'integer', [[timestamp]]),
(49, 25, 'title', 'site_notifications', 'text', [[timestamp]]),
(50, 25, 'elgg:internal:priority', '25', 'integer', [[timestamp]]),
(51, 26, 'title', 'system_log', 'text', [[timestamp]]),
(52, 26, 'elgg:internal:priority', '26', 'integer', [[timestamp]]),
(53, 27, 'title', 'tagcloud', 'text', [[timestamp]]),
(54, 27, 'elgg:internal:priority', '27', 'integer', [[timestamp]]),
(55, 28, 'title', 'theme_sandbox', 'text', [[timestamp]]),
(56, 28, 'elgg:internal:priority', '28', 'integer', [[timestamp]]),
(57, 29, 'title', 'thewire', 'text', [[timestamp]]),
(58, 29, 'elgg:internal:priority', '29', 'integer', [[timestamp]]),
(59, 30, 'title', 'uservalidationbyemail', 'text', [[timestamp]]),
(60, 30, 'elgg:internal:priority', '30', 'integer', [[timestamp]]),
(61, 31, 'title', 'web_services', 'text', [[timestamp]]),
(62, 31, 'elgg:internal:priority', '31', 'integer', [[timestamp]]),
(63, 32, 'id', 'core:2017080900', 'text', [[timestamp]]),
(64, 32, 'class', 'Elgg\\Upgrades\\AlterDatabaseToMultiByteCharset', 'text', [[timestamp]]),
(65, 32, 'title', 'core:upgrade:2017080900:title', 'text', [[timestamp]]),
(66, 32, 'description', 'core:upgrade:2017080900:description', 'text', [[timestamp]]),
(67, 32, 'offset', '0', 'integer', [[timestamp]]),
(68, 32, 'is_completed', '1', 'bool', [[timestamp]]),
(69, 33, 'id', 'core:2021040701', 'text', [[timestamp]]),
(70, 33, 'class', 'Elgg\\Upgrades\\ChangeUserNotificationSettingsNamespace', 'text', [[timestamp]]),
(71, 33, 'title', 'core:upgrade:2021040701:title', 'text', [[timestamp]]),
(72, 33, 'description', 'core:upgrade:2021040701:description', 'text', [[timestamp]]),
(73, 33, 'offset', '0', 'integer', [[timestamp]]),
(74, 33, 'is_completed', '1', 'bool', [[timestamp]]),
(75, 34, 'id', 'core:2021060401', 'text', [[timestamp]]),
(76, 34, 'class', 'Elgg\\Upgrades\\ContentOwnerSubscriptions', 'text', [[timestamp]]),
(77, 34, 'title', 'core:upgrade:2021060401:title', 'text', [[timestamp]]),
(78, 34, 'description', 'core:upgrade:2021060401:description', 'text', [[timestamp]]),
(79, 34, 'offset', '0', 'integer', [[timestamp]]),
(80, 34, 'is_completed', '1', 'bool', [[timestamp]]),
(81, 35, 'id', 'core:2020102301', 'text', [[timestamp]]),
(82, 35, 'class', 'Elgg\\Upgrades\\DeleteDiagnosticsPlugin', 'text', [[timestamp]]),
(83, 35, 'title', 'core:upgrade:2020102301:title', 'text', [[timestamp]]),
(84, 35, 'description', 'core:upgrade:2020102301:description', 'text', [[timestamp]]),
(85, 35, 'offset', '0', 'integer', [[timestamp]]),
(86, 35, 'is_completed', '1', 'bool', [[timestamp]]),
(87, 36, 'id', 'core:2021041901', 'text', [[timestamp]]),
(88, 36, 'class', 'Elgg\\Upgrades\\DeleteNotificationsPlugin', 'text', [[timestamp]]),
(89, 36, 'title', 'core:upgrade:2021041901:title', 'text', [[timestamp]]),
(90, 36, 'description', 'core:upgrade:2021041901:description', 'text', [[timestamp]]),
(91, 36, 'offset', '0', 'integer', [[timestamp]]),
(92, 36, 'is_completed', '1', 'bool', [[timestamp]]),
(93, 37, 'id', 'core:2021040801', 'text', [[timestamp]]),
(94, 37, 'class', 'Elgg\\Upgrades\\MigrateACLNotificationPreferences', 'text', [[timestamp]]),
(95, 37, 'title', 'core:upgrade:2021040801:title', 'text', [[timestamp]]),
(96, 37, 'description', 'core:upgrade:2021040801:description', 'text', [[timestamp]]),
(97, 37, 'offset', '0', 'integer', [[timestamp]]),
(98, 37, 'is_completed', '1', 'bool', [[timestamp]]),
(99, 38, 'id', 'core:2024020101', 'text', [[timestamp]]),
(100, 38, 'class', 'Elgg\\Upgrades\\MigrateEntityIconCroppingCoordinates', 'text', [[timestamp]]),
(101, 38, 'title', 'core:upgrade:2024020101:title', 'text', [[timestamp]]),
(102, 38, 'description', 'core:upgrade:2024020101:description', 'text', [[timestamp]]),
(103, 38, 'offset', '0', 'integer', [[timestamp]]),
(104, 38, 'is_completed', '1', 'bool', [[timestamp]]),
(105, 39, 'id', 'core:2021022401', 'text', [[timestamp]]),
(106, 39, 'class', 'Elgg\\Upgrades\\NotificationsPrefix', 'text', [[timestamp]]),
(107, 39, 'title', 'core:upgrade:2021022401:title', 'text', [[timestamp]]),
(108, 39, 'description', 'core:upgrade:2021022401:description', 'text', [[timestamp]]),
(109, 39, 'offset', '0', 'integer', [[timestamp]]),
(110, 39, 'is_completed', '1', 'bool', [[timestamp]]),
(111, 40, 'id', 'core:2024020901', 'text', [[timestamp]]),
(112, 40, 'class', 'Elgg\\Upgrades\\RemoveIcontime', 'text', [[timestamp]]),
(113, 40, 'title', 'core:upgrade:2024020901:title', 'text', [[timestamp]]),
(114, 40, 'description', 'core:upgrade:2024020901:description', 'text', [[timestamp]]),
(115, 40, 'offset', '0', 'integer', [[timestamp]]),
(116, 40, 'is_completed', '1', 'bool', [[timestamp]]),
(117, 41, 'id', 'core:2023011701', 'text', [[timestamp]]),
(118, 41, 'class', 'Elgg\\Upgrades\\RemoveOrphanedThreadedComments', 'text', [[timestamp]]),
(119, 41, 'title', 'core:upgrade:2023011701:title', 'text', [[timestamp]]),
(120, 41, 'description', 'core:upgrade:2023011701:description', 'text', [[timestamp]]),
(121, 41, 'offset', '0', 'integer', [[timestamp]]),
(122, 41, 'is_completed', '1', 'bool', [[timestamp]]),
(123, 42, 'id', 'core:2024070201', 'text', [[timestamp]]),
(124, 42, 'class', 'Elgg\\Upgrades\\MigrateDebugConfig', 'text', [[timestamp]]),
(125, 42, 'title', 'core:upgrade:2024070201:title', 'text', [[timestamp]]),
(126, 42, 'description', 'core:upgrade:2024070201:description', 'text', [[timestamp]]),
(127, 42, 'offset', '0', 'integer', [[timestamp]]),
(128, 42, 'is_completed', '1', 'bool', [[timestamp]]),
(129, 43, 'id', 'core:2024071001', 'text', [[timestamp]]),
(130, 43, 'class', 'Elgg\\Upgrades\\MigrateAdminValidationNotificationPreference', 'text', [[timestamp]]),
(131, 43, 'title', 'core:upgrade:2024071001:title', 'text', [[timestamp]]),
(132, 43, 'description', 'core:upgrade:2024071001:description', 'text', [[timestamp]]),
(133, 43, 'offset', '0', 'integer', [[timestamp]]),
(134, 43, 'is_completed', '1', 'bool', [[timestamp]]),
(135, 44, 'id', 'core:2025060201', 'text', [[timestamp]]),
(136, 44, 'class', 'Elgg\\Upgrades\\UpdateMetastringBoolDatabaseValue', 'text', [[timestamp]]),
(137, 44, 'title', 'core:upgrade:2025060201:title', 'text', [[timestamp]]),
(138, 44, 'description', 'core:upgrade:2025060201:description', 'text', [[timestamp]]),
(139, 44, 'offset', '0', 'integer', [[timestamp]]),
(140, 44, 'is_completed', '1', 'bool', [[timestamp]]),
(141, 45, 'id', 'file:2022092801', 'text', [[timestamp]]),
(142, 45, 'class', 'Elgg\\File\\Upgrades\\MoveFiles', 'text', [[timestamp]]),
(143, 45, 'title', 'file:upgrade:2022092801:title', 'text', [[timestamp]]),
(144, 45, 'description', 'file:upgrade:2022092801:description', 'text', [[timestamp]]),
(145, 45, 'offset', '0', 'integer', [[timestamp]]),
(146, 45, 'is_completed', '1', 'bool', [[timestamp]]),
(147, 32, 'start_time', '[[timestamp]]', 'integer', [[timestamp]]),
(148, 32, 'completed_time', '[[timestamp]]', 'integer', [[timestamp]]),
(149, 33, 'start_time', '[[timestamp]]', 'integer', [[timestamp]]),
(150, 33, 'completed_time', '[[timestamp]]', 'integer', [[timestamp]]),
(151, 34, 'start_time', '[[timestamp]]', 'integer', [[timestamp]]),
(152, 34, 'completed_time', '[[timestamp]]', 'integer', [[timestamp]]),
(153, 35, 'start_time', '[[timestamp]]', 'integer', [[timestamp]]),
(154, 35, 'completed_time', '[[timestamp]]', 'integer', [[timestamp]]),
(155, 36, 'start_time', '[[timestamp]]', 'integer', [[timestamp]]),
(156, 36, 'completed_time', '[[timestamp]]', 'integer', [[timestamp]]),
(157, 37, 'start_time', '[[timestamp]]', 'integer', [[timestamp]]),
(158, 37, 'completed_time', '[[timestamp]]', 'integer', [[timestamp]]),
(159, 38, 'start_time', '[[timestamp]]', 'integer', [[timestamp]]),
(160, 38, 'completed_time', '[[timestamp]]', 'integer', [[timestamp]]),
(161, 39, 'start_time', '[[timestamp]]', 'integer', [[timestamp]]),
(162, 39, 'completed_time', '[[timestamp]]', 'integer', [[timestamp]]),
(163, 40, 'start_time', '[[timestamp]]', 'integer', [[timestamp]]),
(164, 40, 'completed_time', '[[timestamp]]', 'integer', [[timestamp]]),
(165, 41, 'start_time', '[[timestamp]]', 'integer', [[timestamp]]),
(166, 41, 'completed_time', '[[timestamp]]', 'integer', [[timestamp]]),
(167, 42, 'start_time', '[[timestamp]]', 'integer', [[timestamp]]),
(168, 42, 'completed_time', '[[timestamp]]', 'integer', [[timestamp]]),
(169, 43, 'start_time', '[[timestamp]]', 'integer', [[timestamp]]),
(170, 43, 'completed_time', '[[timestamp]]', 'integer', [[timestamp]]),
(171, 44, 'start_time', '[[timestamp]]', 'integer', [[timestamp]]),
(172, 44, 'completed_time', '[[timestamp]]', 'integer', [[timestamp]]),
(173, 45, 'start_time', '[[timestamp]]', 'integer', [[timestamp]]),
(174, 45, 'completed_time', '[[timestamp]]', 'integer', [[timestamp]]),
(175, 46, 'banned', 'no', 'text', [[timestamp]]),
(176, 46, 'admin', 'yes', 'text', [[timestamp]]),
(177, 46, 'language', '[[language]]', 'text', [[timestamp]]),
(178, 46, 'prev_last_action', '[[timestamp]]', 'integer', [[timestamp]]),
(179, 46, 'last_login', '[[timestamp]]', 'integer', [[timestamp]]),
(180, 46, 'prev_last_login', '0', 'integer', [[timestamp]]),
(181, 46, 'username', '[[admin_username]]', 'text', [[timestamp]]),
(182, 46, 'email', '[[admin_email]]', 'text', [[timestamp]]),
(183, 46, 'name', '[[admin_realname]]', 'text', [[timestamp]]),
(184, 46, 'password_hash', '[[admin_pass]]', 'text', [[timestamp]]),
(185, 46, 'notification:default:email', '1', 'integer', [[timestamp]]),
(186, 46, 'validated', '1', 'bool', [[timestamp]]),
(187, 46, 'validated_method', 'admin_user', 'text', [[timestamp]]),
(188, 46, 'validated_ts', '[[timestamp]]', 'integer', [[timestamp]]),
(189, 47, 'handler', 'admin_welcome', 'text', [[timestamp]]),
(190, 47, 'context', 'admin', 'text', [[timestamp]]),
(191, 47, 'column', '1', 'integer', [[timestamp]]),
(192, 47, 'order', '0', 'integer', [[timestamp]]),
(193, 48, 'handler', 'elgg_blog', 'text', [[timestamp]]),
(194, 48, 'context', 'admin', 'text', [[timestamp]]),
(195, 48, 'order', '10', 'integer', [[timestamp]]),
(196, 48, 'column', '1', 'integer', [[timestamp]]),
(197, 49, 'handler', 'content_stats', 'text', [[timestamp]]),
(198, 49, 'context', 'admin', 'text', [[timestamp]]),
(199, 49, 'order', '20', 'integer', [[timestamp]]),
(200, 49, 'column', '1', 'integer', [[timestamp]]),
(201, 50, 'handler', 'online_users', 'text', [[timestamp]]),
(202, 50, 'context', 'admin', 'text', [[timestamp]]),
(203, 50, 'column', '2', 'integer', [[timestamp]]),
(204, 50, 'order', '0', 'integer', [[timestamp]]),
(205, 51, 'handler', 'new_users', 'text', [[timestamp]]),
(206, 51, 'context', 'admin', 'text', [[timestamp]]),
(207, 51, 'order', '10', 'integer', [[timestamp]]),
(208, 51, 'column', '2', 'integer', [[timestamp]]),
(209, 46, 'first_login', '[[timestamp]]', 'integer', [[timestamp]]),
(210, 52, 'admin_notice_id', 'fresh_install', 'text', [[timestamp]]),
(211, 52, 'description', '<p>[[site_desc]] For more options, see the <a href="[[softurl]]/admin/site_settings" class="elgg-anchor"><span class="elgg-anchor-label">settings pages</span></a>.</p><p>We enabled the Front Page Demo plugin so you can manage your homepage. Configure it here: <a href="[[softurl]]/admin/plugin_settings/custom_index" class="elgg-anchor"><span class="elgg-anchor-label">Plugin Settings</span></a>.</p>', 'text', [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]migrations`
--

CREATE TABLE `[[dbprefix]]migrations` (
  `version` bigint NOT NULL,
  `migration_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_time` timestamp NULL DEFAULT NULL,
  `end_time` timestamp NULL DEFAULT NULL,
  `breakpoint` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]migrations`
--

INSERT INTO `[[dbprefix]]migrations` VALUES
(20170728010000, 'RemoveSiteGuid', '[[regtime]]', '[[regtime]]', 0),
(20170728020000, 'MigrateDatalistsToConfig', '[[regtime]]', '[[regtime]]', 0),
(20170728030000, 'DenormalizeMetastrings', '[[regtime]]', '[[regtime]]', 0),
(20170728040000, 'ChangeTableEngine', '[[regtime]]', '[[regtime]]', 0),
(20170728050000, 'ExpandTextColumnsToLongtext', '[[regtime]]', '[[regtime]]', 0),
(20170728060000, 'RemoveLegacyPasswordHashes', '[[regtime]]', '[[regtime]]', 0),
(20170728072548, 'CreateAccessCollectionsTable', '[[regtime]]', '[[regtime]]', 0),
(20170728073540, 'CreateAccessCollectionMembershipTable', '[[regtime]]', '[[regtime]]', 0),
(20170728073706, 'CreateAnnotationsTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074504, 'CreateApiUsersTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074600, 'CreateEntitiesTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074645, 'CreateEntityRelationshipsTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074729, 'CreateEntitySubtypesTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074757, 'CreateGeoCacheTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074828, 'CreateGroupsEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074857, 'CreateHmacCacheTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074925, 'CreateMetadataTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074959, 'CreateObjectsEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075027, 'CreatePrivateSettingsTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075056, 'CreateQueueTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075129, 'CreateRiverTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075155, 'CreateSitesEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075232, 'CreateSystemLogTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075306, 'CreateUsersApiSessionsTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075337, 'CreateUsersEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075418, 'CreateUsersRememberMeCookiesTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075454, 'CreateUsersSessionsTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075716, 'CreateConfigTable', '[[regtime]]', '[[regtime]]', 0),
(20170808084728, 'DropGeocodeCache', '[[regtime]]', '[[regtime]]', 0),
(20171006111953, 'DropSitesEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20171006131622, 'DropGroupsEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20171009115032, 'DropObjectsEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20171010095648, 'DropUsersEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20171016113827, 'UpdateMetadataColumns', '[[regtime]]', '[[regtime]]', 0),
(20171021111005, 'AddSubtypeIndexToRiverTable', '[[regtime]]', '[[regtime]]', 0),
(20171021111059, 'DenormalizeEntitySubtypes', '[[regtime]]', '[[regtime]]', 0),
(20171021111132, 'AlignSubtypeColumns', '[[regtime]]', '[[regtime]]', 0),
(20171106100916, 'AddAclSubtype', '[[regtime]]', '[[regtime]]', 0),
(20180109135052, 'DropTypeSubtypeFromRiverTable', '[[regtime]]', '[[regtime]]', 0),
(20180609152817, 'CreateSiteSecret', '[[regtime]]', '[[regtime]]', 0),
(20181107091651, 'AddEntitiesSubtypeIndex', '[[regtime]]', '[[regtime]]', 0),
(20190125082345, 'EntitiesAddTypeSubtypeIndex', '[[regtime]]', '[[regtime]]', 0),
(20190606111641, 'EntitiesAddTypeSubtypeContainerAndOwnerIndexes', '[[regtime]]', '[[regtime]]', 0),
(20191015125417, 'SetRiverEnabledToYes', '[[regtime]]', '[[regtime]]', 0),
(20200130161435, 'RemoveMetadataColumns', '[[regtime]]', '[[regtime]]', 0),
(20200130162616, 'RemoveRiverEnabledColumn', '[[regtime]]', '[[regtime]]', 0),
(20200303122949, 'AddTimeCreatedIndexToAnnotationsTable', '[[regtime]]', '[[regtime]]', 0),
(20200331083912, 'AddEntityGuidNameIndexToAnnotations', '[[regtime]]', '[[regtime]]', 0),
(20210225131119, 'IncreaseRelationshipColumnLength', '[[regtime]]', '[[regtime]]', 0),
(20210412110921, 'CreateDelayedEmailQueueTable', '[[regtime]]', '[[regtime]]', 0),
(20211224075815, 'SetCommentsLevelOne', '[[regtime]]', '[[regtime]]', 0),
(20220125084422, 'AddBooleanValueTypes', '[[regtime]]', '[[regtime]]', 0),
(20220825064811, 'MergePrivateSettingsInMetadata', '[[regtime]]', '[[regtime]]', 0),
(20221110111653, 'AddRiverLastAction', '[[regtime]]', '[[regtime]]', 0),
(20230606155735, 'AddDeleteColumnsToEntitiesTables', '[[regtime]]', '[[regtime]]', 0),
(20240318105727, 'RemoveAnnotationsEnabledColumn', '[[regtime]]', '[[regtime]]', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queue`
--

CREATE TABLE `[[dbprefix]]queue` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `data` mediumblob NOT NULL,
  `timestamp` int NOT NULL,
  `worker` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `retrieve` (`timestamp`,`worker`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]queue`
--

INSERT INTO `[[dbprefix]]queue` VALUES
(1, 'notifications', 'O:48:"Elgg\\Notifications\\SubscriptionNotificationEvent":4:{s:6:"action";s:10:"make_admin";s:9:"object_id";i:46;s:11:"object_type";s:4:"user";s:14:"object_subtype";s:4:"user";}', [[timestamp]], NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]river`
--

CREATE TABLE `[[dbprefix]]river` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `action_type` varchar(32) COLLATE utf8mb4_general_ci NOT NULL,
  `view` text COLLATE utf8mb4_general_ci NOT NULL,
  `subject_guid` int unsigned NOT NULL,
  `object_guid` int unsigned NOT NULL,
  `target_guid` int unsigned NOT NULL,
  `annotation_id` int NOT NULL,
  `posted` int NOT NULL,
  `last_action` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `action_type` (`action_type`),
  KEY `subject_guid` (`subject_guid`),
  KEY `object_guid` (`object_guid`),
  KEY `target_guid` (`target_guid`),
  KEY `annotation_id` (`annotation_id`),
  KEY `posted` (`posted`),
  KEY `last_action` (`last_action`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_log`
--

CREATE TABLE `[[dbprefix]]system_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `object_id` int NOT NULL,
  `object_class` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `object_type` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `object_subtype` varchar(252) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `event` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `performed_by_guid` int unsigned NOT NULL,
  `owner_guid` int unsigned NOT NULL,
  `access_id` int NOT NULL,
  `enabled` enum('yes','no') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'yes',
  `time_created` int NOT NULL,
  `ip_address` varchar(46) COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `object_id` (`object_id`),
  KEY `object_class` (`object_class`),
  KEY `object_type` (`object_type`),
  KEY `object_subtype` (`object_subtype`),
  KEY `event` (`event`),
  KEY `performed_by_guid` (`performed_by_guid`),
  KEY `access_id` (`access_id`),
  KEY `time_created` (`time_created`),
  KEY `river_key` (`object_type`,`object_subtype`,`event`(25))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_apisessions`
--

CREATE TABLE `[[dbprefix]]users_apisessions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_guid` int unsigned NOT NULL,
  `token` varchar(40) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `expires` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_guid` (`user_guid`),
  KEY `token` (`token`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_remember_me_cookies`
--

CREATE TABLE `[[dbprefix]]users_remember_me_cookies` (
  `code` varchar(32) COLLATE utf8mb4_general_ci NOT NULL,
  `guid` int unsigned NOT NULL,
  `timestamp` int unsigned NOT NULL,
  PRIMARY KEY (`code`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_sessions`
--

CREATE TABLE `[[dbprefix]]users_sessions` (
  `session` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `ts` int unsigned NOT NULL DEFAULT '0',
  `data` mediumblob,
  PRIMARY KEY (`session`),
  KEY `ts` (`ts`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `[[dbprefix]]users_sessions`
--


/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
