<?php

/**
 * Controls access levels on \ElggEntity entities, metadata, and annotations.
 *
 * @warning ACCESS_DEFAULT and ACCESS_FRIENDS are placeholders for the input/access view.
 * Do not use them when saving or updating an entity.
 */
const ACCESS_DEFAULT = -1;
const ACCESS_PRIVATE = 0;
const ACCESS_LOGGED_IN = 1;
const ACCESS_PUBLIC = 2;
const ACCESS_FRIENDS = -2;

/**
 * Constant to request the value of a parameter be ignored in elgg_get_*() functions
 *
 * @see elgg_get_entities()
 * @since 1.7
 */
const ELGG_ENTITIES_ANY_VALUE = null;

/**
 * Constant to request the value of a parameter be nothing in elgg_get_*() functions.
 *
 * @see elgg_get_entities()
 * @since 1.7
 */
const ELGG_ENTITIES_NO_VALUE = 0;

/**
 * Used in calls to forward() to specify the browser should be redirected to the
 * referring page.
 *
 * @see forward
 */
const REFERRER = '__elgg_referrer';

/**
 * HTTP Response codes
 */
const ELGG_HTTP_CONTINUE = 100;
const ELGG_HTTP_SWITCHING_PROTOCOLS = 101;
const ELGG_HTTP_PROCESSING = 102;// RFC2518
const ELGG_HTTP_OK = 200;
const ELGG_HTTP_CREATED = 201;
const ELGG_HTTP_ACCEPTED = 202;
const ELGG_HTTP_NON_AUTHORITATIVE_INFORMATION = 203;
const ELGG_HTTP_NO_CONTENT = 204;
const ELGG_HTTP_RESET_CONTENT = 205;
const ELGG_HTTP_PARTIAL_CONTENT = 206;
const ELGG_HTTP_MULTI_STATUS = 207; // RFC4918
const ELGG_HTTP_ALREADY_REPORTED = 208; // RFC5842
const ELGG_HTTP_IM_USED = 226; // RFC3229
const ELGG_HTTP_MULTIPLE_CHOICES = 300;
const ELGG_HTTP_MOVED_PERMANENTLY = 301;
const ELGG_HTTP_FOUND = 302;
const ELGG_HTTP_SEE_OTHER = 303;
const ELGG_HTTP_NOT_MODIFIED = 304;
const ELGG_HTTP_USE_PROXY = 305;
const ELGG_HTTP_RESERVED = 306;
const ELGG_HTTP_TEMPORARY_REDIRECT = 307;
const ELGG_HTTP_PERMANENTLY_REDIRECT = 308; // RFC7238
const ELGG_HTTP_BAD_REQUEST = 400;
const ELGG_HTTP_UNAUTHORIZED = 401;
const ELGG_HTTP_PAYMENT_REQUIRED = 402;
const ELGG_HTTP_FORBIDDEN = 403;
const ELGG_HTTP_NOT_FOUND = 404;
const ELGG_HTTP_METHOD_NOT_ALLOWED = 405;
const ELGG_HTTP_NOT_ACCEPTABLE = 406;
const ELGG_HTTP_PROXY_AUTHENTICATION_REQUIRED = 407;
const ELGG_HTTP_REQUEST_TIMEOUT = 408;
const ELGG_HTTP_CONFLICT = 409;
const ELGG_HTTP_GONE = 410;
const ELGG_HTTP_LENGTH_REQUIRED = 411;
const ELGG_HTTP_PRECONDITION_FAILED = 412;
const ELGG_HTTP_REQUEST_ENTITY_TOO_LARGE = 413;
const ELGG_HTTP_REQUEST_URI_TOO_LONG = 414;
const ELGG_HTTP_UNSUPPORTED_MEDIA_TYPE = 415;
const ELGG_HTTP_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
const ELGG_HTTP_EXPECTATION_FAILED = 417;
const ELGG_HTTP_I_AM_A_TEAPOT = 418; // RFC2324
const ELGG_HTTP_UNPROCESSABLE_ENTITY = 422;// RFC4918
const ELGG_HTTP_LOCKED = 423; // RFC4918
const ELGG_HTTP_FAILED_DEPENDENCY = 424; // RFC4918
const ELGG_HTTP_RESERVED_FOR_WEBDAV_ADVANCED_COLLECTIONS_EXPIRED_PROPOSAL = 425; // RFC2817
const ELGG_HTTP_UPGRADE_REQUIRED = 426;// RFC2817
const ELGG_HTTP_PRECONDITION_REQUIRED = 428; // RFC6585
const ELGG_HTTP_TOO_MANY_REQUESTS = 429; // RFC6585
const ELGG_HTTP_REQUEST_HEADER_FIELDS_TOO_LARGE = 431; // RFC6585
const ELGG_HTTP_INTERNAL_SERVER_ERROR = 500;
const ELGG_HTTP_NOT_IMPLEMENTED = 501;
const ELGG_HTTP_BAD_GATEWAY = 502;
const ELGG_HTTP_SERVICE_UNAVAILABLE = 503;
const ELGG_HTTP_GATEWAY_TIMEOUT = 504;
const ELGG_HTTP_VERSION_NOT_SUPPORTED = 505;
const ELGG_HTTP_VARIANT_ALSO_NEGOTIATES_EXPERIMENTAL = 506;// RFC2295
const ELGG_HTTP_INSUFFICIENT_STORAGE = 507;// RFC4918
const ELGG_HTTP_LOOP_DETECTED = 508; // RFC5842
const ELGG_HTTP_NOT_EXTENDED = 510;// RFC2774
const ELGG_HTTP_NETWORK_AUTHENTICATION_REQUIRED = 511; // RFC6585

/**
 * Default JSON encoding
 */
const ELGG_JSON_ENCODING = JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_AMP | JSON_HEX_QUOT;

/**
 * Value types
 */
const ELGG_VALUE_INTEGER = 'integer';
const ELGG_VALUE_STRING = 'string';
const ELGG_VALUE_GUID = 'guid';
const ELGG_VALUE_ID = 'id';
const ELGG_VALUE_TIMESTAMP = 'timestamp';
const ELGG_VALUE_BOOL = 'bool';

/**
 * Cache init values
 */
const ELGG_CACHE_BLACK_HOLE = 1;
const ELGG_CACHE_RUNTIME = 2;
const ELGG_CACHE_FILESYSTEM = 4;
const ELGG_CACHE_PERSISTENT = 8;
const ELGG_CACHE_LOCALFILESYSTEM = 32;

/**
 * elgg_call() flags
 */
const ELGG_IGNORE_ACCESS = 1;
const ELGG_ENFORCE_ACCESS = 2;
const ELGG_SHOW_DISABLED_ENTITIES = 4;
const ELGG_HIDE_DISABLED_ENTITIES = 8;
const ELGG_DISABLE_SYSTEM_LOG = 16;
const ELGG_ENABLE_SYSTEM_LOG = 32;
