
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `fengofc31180`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]address_types`
--

CREATE TABLE `[[dbprefix]]address_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_system` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]address_types`
--

INSERT INTO `[[dbprefix]]address_types` VALUES
(1, 'home', 1),
(2, 'work', 1),
(3, 'other', 1),
(4, 'postal', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]administration_logs`
--

CREATE TABLE `[[dbprefix]]administration_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_on` datetime NOT NULL,
  `title` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `log_data` text COLLATE utf8_unicode_ci,
  `category` enum('system','security') COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_on` (`created_on`),
  KEY `category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]administration_tools`
--

CREATE TABLE `[[dbprefix]]administration_tools` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `controller` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `action` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]administration_tools`
--

INSERT INTO `[[dbprefix]]administration_tools` VALUES
(1, 'test_mail_settings', 'administration', 'tool_test_email', 1, 1),
(2, 'mass_mailer', 'administration', 'tool_mass_mailer', 2, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]application_logs`
--

CREATE TABLE `[[dbprefix]]application_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `taken_by_id` int(10) unsigned DEFAULT NULL,
  `rel_object_id` int(10) NOT NULL DEFAULT '0',
  `object_name` text COLLATE utf8_unicode_ci,
  `created_on` datetime NOT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `action` enum('upload','open','close','delete','edit','add','trash','untrash','subscribe','unsubscribe','tag','comment','link','unlink','login','logout','untag','archive','unarchive','move','copy','read','download','checkin','checkout','relation_added','relation_edited','relation_removed') COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_private` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_silent` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_mail_rule` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `member_id` int(10) NOT NULL DEFAULT '0',
  `log_data` text COLLATE utf8_unicode_ci,
  `full_request` text COLLATE utf8_unicode_ci,
  `request_channel` varchar(511) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `created_on` USING BTREE (`created_on`,`is_silent`),
  KEY `object` (`rel_object_id`,`created_on`,`is_silent`),
  KEY `member` (`member_id`,`created_on`,`is_silent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]application_log_details`
--

CREATE TABLE `[[dbprefix]]application_log_details` (
  `application_log_id` int(11) NOT NULL,
  `property` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8_unicode_ci,
  `new_value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`application_log_id`,`property`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]application_read_logs`
--

CREATE TABLE `[[dbprefix]]application_read_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `taken_by_id` int(10) NOT NULL DEFAULT '0',
  `rel_object_id` int(10) NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `action` enum('read','download') COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_on` (`created_on`),
  KEY `object_key` (`rel_object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billings`
--

CREATE TABLE `[[dbprefix]]billings` (
  `object_id` int(10) unsigned NOT NULL,
  `value` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]billing_categories`
--

CREATE TABLE `[[dbprefix]]billing_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `description` text COLLATE utf8_unicode_ci,
  `default_value` float NOT NULL DEFAULT '0',
  `report_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `created_on` datetime DEFAULT NULL,
  `created_by_id` int(10) unsigned NOT NULL DEFAULT '0',
  `updated_on` datetime NOT NULL,
  `updated_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `object_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rel_object_id` int(10) unsigned NOT NULL DEFAULT '0',
  `text` text COLLATE utf8_unicode_ci,
  `author_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `author_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `author_homepage` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`object_id`),
  KEY `object_id` (`rel_object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config_categories`
--

CREATE TABLE `[[dbprefix]]config_categories` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_system` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `category_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `order` (`category_order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]config_categories`
--

INSERT INTO `[[dbprefix]]config_categories` VALUES
(1, 'system', 1, 0),
(2, 'general', 0, 1),
(3, 'mailing', 0, 2),
(4, 'brand_colors', 0, 3),
(5, 'passwords', 0, 4),
(6, 'reports', 0, 5),
(7, 'mail module', 0, 60);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config_options`
--

CREATE TABLE `[[dbprefix]]config_options` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `category_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` text COLLATE utf8_unicode_ci,
  `config_handler_class` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_system` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `option_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `dev_comment` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `options` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `order` (`option_order`),
  KEY `category_id` (`category_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=104 ;

--
-- Dumping data for table `[[dbprefix]]config_options`
--

INSERT INTO `[[dbprefix]]config_options` VALUES
(1, 'system', 'project_logs_per_page', '10', 'IntegerConfigHandler', 1, 0, NULL, ''),
(2, 'system', 'messages_per_page', '5', 'IntegerConfigHandler', 1, 0, NULL, ''),
(3, 'system', 'max_avatar_width', '50', 'IntegerConfigHandler', 1, 0, NULL, ''),
(4, 'system', 'max_avatar_height', '50', 'IntegerConfigHandler', 1, 0, NULL, ''),
(5, 'system', 'logs_per_project', '5', 'IntegerConfigHandler', 1, 0, NULL, ''),
(6, 'system', 'max_logo_width', '50', 'IntegerConfigHandler', 1, 0, NULL, ''),
(7, 'system', 'max_logo_height', '50', 'IntegerConfigHandler', 1, 0, NULL, ''),
(8, 'system', 'files_per_page', '50', 'IntegerConfigHandler', 1, 0, NULL, ''),
(9, 'system', 'notification_from_address', '', 'StringConfigHandler', 1, 0, 'Address to use as from field in email notifications. If empty, users address is used', ''),
(10, 'system', 'min_chars_for_match', '3', 'IntegerConfigHandler', 1, 0, 'If search criteria len is less than this, then use always LIKE', ''),
(11, 'system', 'getting_started_step', '1', 'IntegerConfigHandler', 1, 0, '', ''),
(12, 'general', 'upgrade_last_check_datetime', '2006-09-02 13:46:47', 'DateTimeConfigHandler', 1, 0, 'Date and time of the last upgrade check', ''),
(13, 'general', 'upgrade_last_check_new_version', '0', 'BoolConfigHandler', 1, 0, 'True if system checked for the new version and found it. This value is used to hightligh upgrade tab in the administration', ''),
(14, 'general', 'file_storage_adapter', 'fs', 'FileStorageConfigHandler', 0, 0, 'What storage adapter should be used? fs or mysql', ''),
(15, 'general', 'theme', 'default', 'ThemeConfigHandler', 0, 0, NULL, ''),
(16, 'general', 'days_on_trash', '30', 'IntegerConfigHandler', 0, 0, 'Days before a file is deleted from trash. 0 = Not deleted', ''),
(17, 'general', 'show_pause_time_action', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(18, 'mailing', 'exchange_compatible', '0', 'BoolConfigHandler', 1, 0, NULL, ''),
(19, 'mailing', 'mail_transport', 'mail()', 'MailTransportConfigHandler', 0, 0, 'Values: ''mail()'' - try to emulate mail() function, ''smtp'' - use SMTP connection', ''),
(20, 'mailing', 'smtp_server', '', 'StringConfigHandler', 0, 0, '', ''),
(21, 'mailing', 'smtp_port', '25', 'IntegerConfigHandler', 0, 0, NULL, ''),
(22, 'mailing', 'smtp_address', '', 'StringConfigHandler', 0, 0, '', ''),
(23, 'mailing', 'notification_from_name', '', 'StringConfigHandler', 0, 0, '', ''),
(24, 'mailing', 'smtp_authenticate', '0', 'BoolConfigHandler', 0, 0, 'Use SMTP authentication', ''),
(25, 'mailing', 'smtp_username', '', 'StringConfigHandler', 0, 0, NULL, ''),
(26, 'mailing', 'smtp_password', '', 'PasswordConfigHandler', 0, 0, NULL, ''),
(27, 'mailing', 'smtp_secure_connection', 'no', 'SecureSmtpConnectionConfigHandler', 0, 0, 'Values: no, ssl, tls', ''),
(28, 'mailing', 'show images in document notifications', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(29, 'mailing', 'show company logo in notifications', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(30, 'mailing', 'notification_recipients_field', 'to', 'MailFieldConfigHandler', 0, 10, NULL, ''),
(31, 'mailing', 'disable_notifications_for_object_type', '', 'MultipleObjectTypeConfigHandler', 0, 0, NULL, ''),
(32, 'mailing', 'notifications_add_members_in_subject', '', 'ManageableDimensionsConfigHandler', 0, 0, NULL, ''),
(33, 'passwords', 'min_password_length', '8', 'IntegerConfigHandler', 0, 1, NULL, ''),
(34, 'passwords', 'password_numbers', '1', 'IntegerConfigHandler', 0, 2, NULL, ''),
(35, 'passwords', 'password_uppercase_characters', '1', 'IntegerConfigHandler', 0, 3, NULL, ''),
(36, 'passwords', 'password_metacharacters', '1', 'IntegerConfigHandler', 0, 4, NULL, ''),
(37, 'passwords', 'password_expiration', '90', 'IntegerConfigHandler', 0, 5, NULL, ''),
(38, 'passwords', 'password_expiration_notification', '5', 'IntegerConfigHandler', 0, 6, NULL, ''),
(39, 'passwords', 'account_block', '0', 'BoolConfigHandler', 0, 7, NULL, ''),
(40, 'passwords', 'new_password_char_difference', '0', 'BoolConfigHandler', 0, 8, NULL, ''),
(41, 'passwords', 'validate_password_history', '0', 'BoolConfigHandler', 0, 9, NULL, ''),
(42, 'passwords', 'block_login_after_x_tries', '1', 'BoolConfigHandler', 0, 20, NULL, ''),
(43, 'general', 'checkout_notification_dialog', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(44, 'general', 'file_revision_comments_required', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(45, 'general', 'currency_code', '$', 'StringConfigHandler', 0, 0, NULL, ''),
(46, 'general', 'checkout_for_editing_online', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(47, 'general', 'show_feed_links', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(48, 'general', 'use_owner_company_logo_at_header', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(49, 'general', 'ask_administration_autentification', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(50, 'general', 'use tasks dependencies', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(51, 'general', 'use_task_work_performed', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(52, 'general', 'use_task_estimated_time', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(53, 'general', 'use_task_pending_time', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(54, 'general', 'use_task_percent_completed', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(55, 'general', 'untitled_notes', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(56, 'general', 'repeating_task', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(57, 'general', 'working_days', '1,2,3,4,5,6,7', 'StringConfigHandler', 0, 0, NULL, ''),
(58, 'general', 'wysiwyg_tasks', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(59, 'general', 'wysiwyg_messages', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(60, 'general', 'wysiwyg_projects', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(61, 'general', 'use_milestones', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(62, 'general', 'apply_milestone_subtasks', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(63, 'general', 'show_tab_icons', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(64, 'general', 'can_assign_tasks_to_companies', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(65, 'general', 'use_object_properties', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(66, 'general', 'let_users_create_objects_in_root', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(67, 'general', 'add_default_permissions_for_users', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(68, 'general', 'inherit_permissions_from_parent_member', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(69, 'general', 'give_member_permissions_to_new_users', '2,4,3,1', 'UserTypeMultipleConfigHandler', 0, 0, NULL, ''),
(70, 'general', 'milestone_selector_filter', 'current_and_parents', 'MilestoneSelectorFilterConfigHandler', 0, 0, NULL, ''),
(71, 'general', 'show_owner_company_name_header', '0', 'BoolConfigHandler', 1, 100, '', ''),
(72, 'general', 'enabled_dimensions', ',2', 'RootDimensionsConfigHandler', 1, 0, NULL, ''),
(73, 'general', 'last_sharing_table_rebuild', '', 'StringConfigHandler', 1, 0, NULL, ''),
(74, 'general', 'check_unique_mail_contact_comp', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(75, 'general', 'mandatory_address_fields', '', 'AddressFieldsConfigHandler', 0, 0, NULL, ''),
(76, 'system', 'last_template_instantiation_id', '0', 'IntegerConfigHandler', 1, 0, NULL, ''),
(77, 'brand_colors', 'brand_colors_head_back', '424242', 'ColorPickerConfigHandler', 0, 0, NULL, ''),
(78, 'brand_colors', 'brand_colors_texture', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(79, 'brand_colors', 'brand_colors_head_font', 'FFFFFF', 'ColorPickerConfigHandler', 0, 0, NULL, ''),
(80, 'brand_colors', 'brand_colors_tabs_back', 'e7e7e7', 'ColorPickerConfigHandler', 1, 0, NULL, ''),
(81, 'brand_colors', 'brand_colors_tabs_font', '333333', 'ColorPickerConfigHandler', 1, 0, NULL, ''),
(82, 'reports', 'reports_inherit_company_address', '', 'BoolConfigHandler', 0, 0, NULL, ''),
(83, 'reports', 'reports_inherit_company_phones', '', 'BoolConfigHandler', 0, 0, NULL, ''),
(84, 'reports', 'show_company_info_report_print', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(85, 'general', 'use_time_quick_add_row', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(86, 'general', 'reclassify_time_when_linking_task', '1', 'BoolConfigHandler', 0, 0, '', ''),
(87, 'general', 'ignored_dims_task_related_objs', '', 'ManageableDimensionsConfigHandler', 0, 0, '', ''),
(88, 'system', 'default_timezone', '', 'TimezoneConfigHandler', 1, 0, '', ''),
(89, 'system', 'users_that_can_mark_as_invoiced', '', 'StringConfigHandler', 0, 0, '', ''),
(90, 'clients_and_contacts', 'default_type_address', '1', 'DefaultTypeAddressConfigHandler', 0, 0, '', ''),
(91, 'clients_and_contacts', 'default_country_address', 'us', 'DefaultCountryAddressConfigHandler', 0, 0, '', ''),
(92, 'clients_and_contacts', 'default_type_phone', '1', 'DefaultTypePhoneConfigHandler', 0, 0, '', ''),
(93, 'clients_and_contacts', 'default_type_email', '1', 'DefaultTypeEmailConfigHandler', 0, 0, '', ''),
(94, 'clients_and_contacts', 'mandatory_email_on_contacts', '0', 'BoolConfigHandler', 0, 0, '', ''),
(95, 'general', 'minimum_characters_dimension_search', '3', 'IntegerConfigHandler', 0, 0, 'Minimum number of characters for dimension search', ''),
(96, 'system', 'hide_people_vinculations', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(97, 'mail module', 'user_email_fetch_count', '10', 'IntegerConfigHandler', 0, 0, 'How many emails to fetch when checking for email', ''),
(98, 'mail module', 'sent_mails_sync', '0', 'BoolConfigHandler', 0, 0, 'imap email accounts synchronization possibility', ''),
(99, 'mail module', 'check_spam_in_subject', '0', 'BoolConfigHandler', 0, 0, '', ''),
(100, 'mail module', 'use_mail_accounts_to_send_nots', '0', 'BoolConfigHandler', 0, 0, '', ''),
(101, 'mail module', 'send_outbox_emails_in_background', '0', 'BoolConfigHandler', 0, 0, '', ''),
(102, 'mail module', 'spam_deletion_days', '30', 'IntegerConfigHandler', 0, 10, '', ''),
(103, 'mail module', 'spam_delete_limit_per_run', '100', 'IntegerConfigHandler', 0, 11, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contacts`
--

CREATE TABLE `[[dbprefix]]contacts` (
  `object_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `surname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_company` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `company_id` int(10) unsigned DEFAULT NULL,
  `department` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `job_title` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `birthday` datetime DEFAULT NULL,
  `timezone` decimal(3,1) NOT NULL DEFAULT '0.0',
  `user_type` smallint(5) unsigned NOT NULL DEFAULT '0',
  `is_active_user` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `token` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salt` varchar(13) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `twister` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `display_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permission_group_id` int(10) unsigned NOT NULL,
  `username` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact_passwords_id` int(10) unsigned NOT NULL,
  `picture_file` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `picture_file_small` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `picture_file_medium` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `avatar_file` varchar(44) COLLATE utf8_unicode_ci DEFAULT NULL,
  `comments` text COLLATE utf8_unicode_ci,
  `last_login` datetime DEFAULT NULL,
  `last_visit` datetime DEFAULT NULL,
  `last_activity` datetime DEFAULT NULL,
  `token_disabled` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `personal_member_id` int(10) unsigned DEFAULT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `default_billing_id` int(10) NOT NULL DEFAULT '0',
  `user_timezone_id` int(10) unsigned NOT NULL DEFAULT '0',
  `default_hour_type_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`),
  KEY `first_name` USING BTREE (`first_name`,`surname`),
  KEY `surname` USING BTREE (`surname`,`first_name`),
  KEY `company` (`is_company`,`company_id`,`department`),
  KEY `username` (`user_type`,`username`),
  KEY `perm_group` USING HASH (`permission_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]contacts`
--

INSERT INTO `[[dbprefix]]contacts` VALUES
(1, '[[site_name]]', '', 1, 0, '', '', '0000-00-00 00:00:00', '0.0', 0, 0, '', '', '', '', 0, '', 0, '', '', '', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 0, 0, 0, 0, 0),
(2, '[[admin_username]]', '', 0, 1, '', '', '0000-00-00 00:00:00', '0.0', 1, 0, '[[admin_pass]]', '[[salt]]', '[[twister]]', '', 14, '[[admin_username]]', 0, '', '', '', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_addresses`
--

CREATE TABLE `[[dbprefix]]contact_addresses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `address_type_id` int(10) unsigned NOT NULL,
  `street` text COLLATE utf8_unicode_ci,
  `city` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `state` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `zip_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_main` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `by_contact` USING HASH (`contact_id`,`is_main`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_config_categories`
--

CREATE TABLE `[[dbprefix]]contact_config_categories` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_system` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `category_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `located_under` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `order` (`category_order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `[[dbprefix]]contact_config_categories`
--

INSERT INTO `[[dbprefix]]contact_config_categories` VALUES
(1, 'general', 0, 0, 0, 0),
(2, 'task panel', 0, 0, 2, 0),
(3, 'calendar panel', 0, 0, 4, 0),
(4, 'context help', 1, 0, 5, 0),
(5, 'time panel', 0, 0, 3, 0),
(6, 'contact panel', 0, 0, 8, 0),
(7, 'listing preferences', 0, 0, 10, 0),
(8, 'reporting', 0, 0, 15, 0),
(9, 'connected systems', 0, 0, 9, 0),
(10, 'mails panel', 0, 0, 5, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_config_options`
--

CREATE TABLE `[[dbprefix]]contact_config_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default_value` text COLLATE utf8_unicode_ci,
  `config_handler_class` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_system` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `option_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `dev_comment` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `options` varchar(511) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `order` (`option_order`),
  KEY `category_id` USING BTREE (`category_name`,`is_system`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=231 ;

--
-- Dumping data for table `[[dbprefix]]contact_config_options`
--

INSERT INTO `[[dbprefix]]contact_config_options` VALUES
(1, 'task panel', 'tasksDateStart', '0000-00-00 00:00:00', 'DateTimeConfigHandler', 1, 0, 'date from to filter out task list', ''),
(2, 'task panel', 'tasksDateEnd', '0000-00-00 00:00:00', 'DateTimeConfigHandler', 1, 0, 'the date up to filter the list of tasks', ''),
(3, 'task panel', 'show_notify_checkbox_in_quick_add', '1', 'BoolConfigHandler', 1, 0, 'Show notification checkbox in quick add task view', ''),
(4, 'task panel', 'can notify from quick add', '1', 'BoolConfigHandler', 0, 0, 'Notification checkbox default value', ''),
(5, 'task panel', 'can notify subscribers', '1', 'BoolConfigHandler', 0, 0, 'Notification checkbox default value', ''),
(6, 'task panel', 'tasksShowWorkspaces', '1', 'BoolConfigHandler', 1, 0, '', ''),
(7, 'task panel', 'tasksShowTime', '1', 'BoolConfigHandler', 1, 0, '', ''),
(8, 'task panel', 'tasksShowTimeQuick', '1', 'BoolConfigHandler', 1, 0, '', ''),
(9, 'task panel', 'tasksShowDates', '1', 'BoolConfigHandler', 1, 0, '', ''),
(10, 'task panel', 'tasksShowPercentCompletedBar', '0', 'BoolConfigHandler', 1, 0, '', ''),
(11, 'task panel', 'tasksShowTimeEstimates', '1', 'BoolConfigHandler', 1, 0, '', ''),
(12, 'task panel', 'tasksShowTotalTimeEstimates', '0', 'BoolConfigHandler', 1, 0, '', ''),
(13, 'task panel', 'tasksShowTimePending', '0', 'BoolConfigHandler', 1, 0, '', ''),
(14, 'task panel', 'tasksShowTimeWorked', '0', 'BoolConfigHandler', 1, 0, '', ''),
(15, 'task panel', 'tasksShowTotalTimeWorked', '0', 'BoolConfigHandler', 1, 0, '', ''),
(16, 'task panel', 'tasksShowRemainingTime', '0', 'BoolConfigHandler', 1, 0, '', ''),
(17, 'task panel', 'tasksShowTotalRemainingTime', '0', 'BoolConfigHandler', 1, 0, '', ''),
(18, 'task panel', 'tasksShowQuickEdit', '1', 'BoolConfigHandler', 1, 0, '', ''),
(19, 'task panel', 'tasksShowQuickComplete', '0', 'BoolConfigHandler', 1, 0, '', ''),
(20, 'task panel', 'tasksShowQuickComment', '0', 'BoolConfigHandler', 1, 0, '', ''),
(21, 'task panel', 'tasksShowQuickMarkAsStarted', '1', 'BoolConfigHandler', 1, 0, '', ''),
(22, 'task panel', 'tasksShowStartDates', '0', 'BoolConfigHandler', 1, 0, '', ''),
(23, 'task panel', 'tasksShowAssignedBy', '0', 'BoolConfigHandler', 1, 0, '', ''),
(24, 'task panel', 'tasksShowClassification', '1', 'BoolConfigHandler', 1, 0, '', ''),
(25, 'task panel', 'tasksShowSubtasksStructure', '1', 'BoolConfigHandler', 1, 0, '', ''),
(26, 'task panel', 'tasksShowEndDates', '1', 'BoolConfigHandler', 1, 0, '', ''),
(27, 'task panel', 'tasksShowQuickAddSubTasks', '0', 'BoolConfigHandler', 1, 0, '', ''),
(28, 'task panel', 'tasksShowDescriptionOnTimeForms', '1', 'BoolConfigHandler', 0, 0, '', ''),
(29, 'task panel', 'tasksShowTags', '1', 'BoolConfigHandler', 1, 0, '', ''),
(30, 'task panel', 'tasksShowEmptyMilestones', '1', 'BoolConfigHandler', 1, 0, '', ''),
(31, 'task panel', 'tasksPreviousPendingTasks', '1', 'BoolConfigHandler', 1, 0, '', ''),
(32, 'task panel', 'tasksGroupBy', 'due_date', 'StringConfigHandler', 1, 0, '', ''),
(33, 'task panel', 'tasksOrderBy', 'priority', 'StringConfigHandler', 1, 0, '', ''),
(34, 'task panel', 'tasksListingOrder', 'ASC', 'StringConfigHandler', 1, 0, '', ''),
(35, 'task panel', 'task panel status', '1', 'IntegerConfigHandler', 1, 0, '', ''),
(36, 'task panel', 'task panel filter', 'assigned_to', 'StringConfigHandler', 1, 0, '', ''),
(37, 'task panel', 'task panel filter value', '0', 'UserCompanyConfigHandler', 1, 0, '', ''),
(38, 'task panel', 'noOfTasks', '15', 'IntegerConfigHandler', 0, 100, NULL, ''),
(39, 'task panel', 'task_display_limit', '500', 'IntegerConfigHandler', 0, 200, NULL, ''),
(40, 'task panel', 'pushUseWorkingDays', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(41, 'task panel', 'tasksShowDimensionCols', '', 'StringConfigHandler', 1, 0, '', ''),
(42, 'task panel', 'tasksUseDateFilters', '1', 'BoolConfigHandler', 0, 0, '', ''),
(43, 'task panel', 'tasksShowAssignedToName', '0', 'BoolConfigHandler', 0, 0, '', ''),
(44, 'task panel', 'tasksGroupsPaginationCount', '5', 'IntegerConfigHandler', 0, 0, '', ''),
(45, 'general', 'listingContactsBy', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(46, 'general', 'localization', '', 'LocalizationConfigHandler', 0, 100, '', ''),
(47, 'general', 'search_engine', 'match', 'SearchEngineConfigHandler', 0, 700, '', ''),
(48, 'general', 'lastAccessedWorkspace', '0', 'IntegerConfigHandler', 1, 0, '', ''),
(49, 'general', 'work_day_start_time', '9:00', 'TimeConfigHandler', 0, 400, 'Work day start time', ''),
(50, 'general', 'work_day_end_time', '18:00', 'TimeConfigHandler', 0, 410, 'Work day end time', ''),
(51, 'general', 'time_format_use_24', '0', 'BoolConfigHandler', 0, 500, 'Use 24 hours time format', ''),
(52, 'general', 'date_format', 'd/m/Y', 'DateFormatConfigHandler', 0, 600, 'Date objects will be displayed using this format.', ''),
(53, 'general', 'descriptive_date_format', 'F j, Y (l)', 'StringConfigHandler', 0, 700, 'Descriptive dates will be displayed using this format.', ''),
(54, 'general', 'custom_report_tab', '5', 'StringConfigHandler', 1, 0, NULL, ''),
(55, 'general', 'last_mail_format', 'html', 'StringConfigHandler', 1, 0, NULL, ''),
(56, 'general', 'amount_objects_to_show', '5', 'IntegerConfigHandler', 0, 0, NULL, ''),
(57, 'general', 'reset_password', '', 'StringConfigHandler', 1, 0, 'Used to store per-user tokens to validate password reset requests', ''),
(58, 'general', 'autodetect_time_zone', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(59, 'general', 'detect_mime_type_from_extension', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(60, 'general', 'root_dimensions', ',2', 'RootDimensionsConfigHandler', 0, 0, NULL, ''),
(61, 'general', 'show_object_direct_url', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(62, 'general', 'drag_drop_prompt', 'prompt', 'DragDropPromptConfigHandler', 0, 0, NULL, ''),
(63, 'general', 'notify_myself_too', '0', 'BoolConfigHandler', 0, 100, '', ''),
(64, 'calendar panel', 'calendar view type', 'viewweek', 'StringConfigHandler', 1, 0, '', ''),
(65, 'calendar panel', 'calendar user filter', '0', 'IntegerConfigHandler', 1, 0, '', ''),
(66, 'calendar panel', 'calendar status filter', '', 'StringConfigHandler', 1, 0, '', ''),
(67, 'calendar panel', 'start_monday', '', 'BoolConfigHandler', 0, 0, '', ''),
(68, 'calendar panel', 'show_week_numbers', '', 'BoolConfigHandler', 0, 0, '', ''),
(69, 'calendar panel', 'show_birthdays_in_calendar', '1', 'BoolConfigHandler', 0, 0, '', ''),
(70, 'calendar panel', 'show_multiple_color_events', '1', 'BoolConfigHandler', 0, 0, '', ''),
(71, 'calendar panel', 'displayed events amount', '3', 'IntegerConfigHandler', 0, 0, '', ''),
(72, 'context help', 'show_tasks_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(73, 'context help', 'show_account_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(74, 'context help', 'show_active_tasks_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(75, 'context help', 'show_general_timeslots_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(76, 'context help', 'show_late_tasks_widget_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(77, 'context help', 'show_pending_tasks_widget_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(78, 'context help', 'show_documents_widget_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(79, 'context help', 'show_active_tasks_widget_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(80, 'context help', 'show_calendar_widget_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(81, 'context help', 'show_messages_widget_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(82, 'context help', 'show_dashboard_info_widget_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(83, 'context help', 'show_comments_widget_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(84, 'context help', 'show_emails_widget_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(85, 'context help', 'show_reporting_panel_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(86, 'context help', 'show_add_file_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(87, 'context help', 'show_administration_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(88, 'context help', 'show_member_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(89, 'context help', 'show_add_contact_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(90, 'context help', 'show_add_company_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(91, 'context help', 'show_upload_file_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(92, 'context help', 'show_upload_file_workspace_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(93, 'context help', 'show_upload_file_tags_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(94, 'context help', 'show_upload_file_description_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(95, 'context help', 'show_upload_file_custom_properties_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(96, 'context help', 'show_upload_file_subscribers_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(97, 'context help', 'show_upload_file_linked_objects_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(98, 'context help', 'show_add_note_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(99, 'context help', 'show_add_note_workspace_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(100, 'context help', 'show_add_note_tags_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(101, 'context help', 'show_add_note_custom_properties_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(102, 'context help', 'show_add_note_subscribers_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(103, 'context help', 'show_add_note_linked_object_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(104, 'context help', 'show_add_milestone_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(105, 'context help', 'show_add_milestone_workspace_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(106, 'context help', 'show_add_milestone_tags_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(107, 'context help', 'show_add_milestone_description_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(108, 'context help', 'show_add_milestone_reminders_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(109, 'context help', 'show_add_milestone_custom_properties_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(110, 'context help', 'show_add_milestone_linked_object_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(111, 'context help', 'show_add_milestone_subscribers_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(112, 'context help', 'show_add_workspace_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(113, 'context help', 'show_print_report_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(114, 'context help', 'show_add_task_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(115, 'context help', 'show_add_task_workspace_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(116, 'context help', 'show_add_task_tags_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(117, 'context help', 'show_add_task_reminders_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(118, 'context help', 'show_add_task_custom_properties_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(119, 'context help', 'show_add_task_linked_objects_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(120, 'context help', 'show_add_task_subscribers_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(121, 'context help', 'show_list_task_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(122, 'context help', 'show_time_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(123, 'context help', 'show_add_webpage_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(124, 'context help', 'show_add_webpage_workspace_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(125, 'context help', 'show_add_webpage_tags_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(126, 'context help', 'show_add_webpage_description_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(127, 'context help', 'show_add_webpage_custom_properties_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(128, 'context help', 'show_add_webpage_subscribers_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(129, 'context help', 'show_add_webpage_linked_objects_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(130, 'context help', 'show_add_event_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(131, 'context help', 'show_add_event_workspace_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(132, 'context help', 'show_add_event_tag_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(133, 'context help', 'show_add_event_description_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(134, 'context help', 'show_add_event_repeat_options_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(135, 'context help', 'show_add_event_reminders_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(136, 'context help', 'show_add_event_custom_properties_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(137, 'context help', 'show_add_event_subscribers_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(138, 'context help', 'show_add_event_linked_objects_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(139, 'context help', 'show_add_event_inivitation_context_help', '1', 'BoolConfigHandler', 1, 0, NULL, ''),
(140, 'time panel', 'TM show time type', '0', 'IntegerConfigHandler', 1, 0, '', ''),
(141, 'time panel', 'TM report show time type', '0', 'IntegerConfigHandler', 1, 0, '', ''),
(142, 'time panel', 'TM user filter', '0', 'IntegerConfigHandler', 1, 0, '', ''),
(143, 'time panel', 'TM tasks user filter', '0', 'IntegerConfigHandler', 1, 0, '', ''),
(144, 'time panel', 'show_start_time_action', '1', 'BoolConfigHandler', 0, 0, '', ''),
(145, 'time panel', 'add_timeslot_view_dimensions_combos', '2,3,', 'ManageableDimensionsConfigHandler', 0, 0, 'dimensions ids for skip', ''),
(146, 'time panel', 'show_pause_time_action', '1', 'BoolConfigHandler', 0, 0, '', ''),
(147, 'time panel', 'stop_running_timeslots', '3', 'ListConfigHandler', 0, 0, '', '{"no_empty_value":1, "option": [{"value": "1","text": "config_allow_stop_timer"},{"value": "2","text": "config_allow_pause_timer"},{"value": "3","text": "config_let_timer_continue"}]}'),
(148, 'general', 'show_context_help', 'until_close', 'ShowContextHelpConfigHandler', 0, 0, NULL, ''),
(149, 'dashboard', 'show charts widget', '1', 'BoolConfigHandler', 0, 600, '', ''),
(150, 'dashboard', 'show dashboard info widget', '1', 'BoolConfigHandler', 0, 900, '', ''),
(151, 'general', 'rememberGUIState', '1', 'RememberGUIConfigHandler', 0, 300, '', ''),
(152, 'calendar panel', 'calendar task filter', 'pending', 'StringConfigHandler', 1, 0, '', ''),
(153, 'task panel', 'close timeslot open', '1', 'BoolConfigHandler', 0, 0, '', ''),
(154, 'calendar panel', 'reminders_events', 'reminder_email,1,60', 'StringConfigHandler', 0, 0, NULL, ''),
(155, 'dashboard', 'filters_dashboard', '0,0,10,0', 'StringConfigHandler', 0, 0, 'first position: entry to see the dimension, second position: view timeslot, third position: recent activities to show, fourth position: view views and downloads', ''),
(156, 'task panel', 'reminders_tasks', 'reminder_email,1,1440', 'StringConfigHandler', 0, 23, NULL, ''),
(157, 'task panel', 'add_task_autoreminder', '0', 'BoolConfigHandler', 0, 21, NULL, ''),
(158, 'task panel', 'add_self_task_autoreminder', '1', 'BoolConfigHandler', 0, 22, NULL, ''),
(159, 'task panel', 'add_task_default_reminder', '1', 'BoolConfigHandler', 0, 20, NULL, ''),
(160, 'task panel', 'quick_add_task_view_dimensions_combos', '2,3,', 'ManageableDimensionsConfigHandler', 0, 0, 'dimensions ids for skip', ''),
(161, 'calendar panel', 'add_event_autoreminder', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(162, 'calendar panel', 'autoassign_events', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(163, 'calendar panel', 'event_send_invitations', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(164, 'calendar panel', 'event_subscribe_invited', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(165, 'mails panel', 'mails_per_page', '50', 'IntegerConfigHandler', 0, 0, NULL, ''),
(166, 'mails panel', 'attach_to_notification', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(167, 'general', 'access_member_after_add', '1', 'BoolConfigHandler', 0, 1300, NULL, ''),
(168, 'general', 'access_member_after_add_remember', '0', 'BoolConfigHandler', 0, 1301, NULL, ''),
(169, 'general', 'sendEmailNotification', '1', 'BoolConfigHandler', 0, 0, 'Send email notification to new user', ''),
(170, 'general', 'viewContactsChecked', '1', 'BoolConfigHandler', 1, 0, 'in people panel is view contacts checked', ''),
(171, 'general', 'viewUsersChecked', '1', 'BoolConfigHandler', 1, 0, 'in people panel is view users checked', ''),
(172, 'general', 'viewCompaniesChecked', '1', 'BoolConfigHandler', 1, 0, 'in people panel is view companies checked', ''),
(173, 'general', 'updateOnLinkedObjects', '1', 'BoolConfigHandler', 0, 0, 'Update objects when linking others', ''),
(174, 'dashboard', 'overviewAsList', '0', 'BoolConfigHandler', 1, 0, 'View Overview as list', ''),
(175, 'general', 'contacts_per_page', '50', 'IntegerConfigHandler', 0, 1200, NULL, ''),
(176, 'listing preferences', 'breadcrumb_member_count', '5', 'IntegerConfigHandler', 0, 5, NULL, ''),
(177, 'general', 'timeReportDate', '4', 'IntegerConfigHandler', 1, 0, '', ''),
(178, 'general', 'timeReportDateStart', '1900-01-01 00:00:00', 'DateTimeConfigHandler', 1, 0, '', ''),
(179, 'general', 'timeReportDateEnd', '1900-01-01 00:00:00', 'DateTimeConfigHandler', 1, 0, '', ''),
(180, 'general', 'timeReportPerson', '0', 'IntegerConfigHandler', 1, 0, '', ''),
(181, 'general', 'timeReportTimeslotType', '2', 'IntegerConfigHandler', 1, 0, '', ''),
(182, 'general', 'timeReportGroupBy', '0,0,0', 'StringConfigHandler', 1, 0, '', ''),
(183, 'general', 'timeReportAltGroupBy', '0,0,0', 'StringConfigHandler', 1, 0, '', ''),
(184, 'general', 'timeReportShowEstimatedTime', '1', 'BoolConfigHandler', 1, 0, '', ''),
(185, 'general', 'timeReportTaskStatus', 'all', 'StringConfigHandler', 1, 0, '', ''),
(186, 'general', 'can_modify_navigation_panel', '1', 'BoolConfigHandler', 1, 0, '', ''),
(187, 'general', 'view_mail_attachs_expanded', '1', 'BoolConfigHandler', 1, 0, '', ''),
(188, 'general', 'timeReportShowBilling', '0', 'BoolConfigHandler', 1, 0, '', ''),
(189, 'general', 'settings_closed', '0', 'BoolConfigHandler', 1, 0, '', ''),
(190, 'contact panel', 'show_inactive_users_in_list', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(191, 'general', 'enable_trash_confirmation', '1', 'BoolConfigHandler', 0, 0, '', ''),
(192, 'general', 'enable_archive_confirmation', '1', 'BoolConfigHandler', 0, 0, '', ''),
(193, 'general', 'trash_objects_in_member_after_delete', '0', 'BoolConfigHandler', 1, 0, '', ''),
(194, 'system', 'widget_dimensions', '', 'AllDimensionsConfigHandler', 1, 0, '', ''),
(195, 'reporting', 'report_time_colums_display', 'friendly', 'TimeFormatConfigHandler', 0, 1, '', ''),
(196, 'reporting', 'pdf_page_layout', 'Portrait', 'ListConfigHandler', 0, 0, '', '{"option": [{"value": "Portrait","text": "config_pdf_layout_portrait"},{"value": "Landscape","text": "config_pdf_layout_landscape"}]}'),
(197, 'reporting', 'pdf_page_size', 'A4', 'ListConfigHandler', 0, 0, '', '{"option": [{"value": "A0","text": "config_pdf_size_A0"},{"value": "A1","text": "config_pdf_size_A1"},{"value": "A2","text": "config_pdf_size_A2"},{"value": "A3","text": "config_pdf_size_A3"},{"value": "A4","text": "config_pdf_size_A4"},{"value": "A5","text": "config_pdf_size_A5"},{"value": "Legal","text": "config_pdf_size_legal"},{"value": "Letter","text": "config_pdf_size_letter"}]}'),
(198, 'time panel', 'automatic_calculation_time', '1', 'ListConfigHandler', 0, 0, ' ', '{"option": [{"value": "1","text": "config_start_calc"},{"value": "2","text": "config_end_calc"},{"value": "3","text": "always_show_modal"}]}'),
(199, 'contact panel', 'properties_for_contact_component', '', 'ContactPropertySelectorConfigHandler', 0, 0, '', 'contact'),
(200, 'time panel', 'automatic_calculation_start_time', '1', 'ListConfigHandler', 0, 0, ' ', '{"option": [{"value": "1","text": "config_dates_calc"},{"value": "2","text": "config_hours_calc"},{"value": "3","text": "always_show_modal"}]}'),
(201, 'general', 'decimals_separator', '.', 'ListConfigHandler', 0, 0, ' ', '{"option": [{"value": ".","text": "."},{"value": ",","text": ","}]}'),
(202, 'general', 'thousand_separator', ',', 'ListConfigHandler', 0, 0, ' ', '{"option": [{"value": ".","text": "."},{"value": ",","text": ","}]}'),
(203, 'general', 'decimal_digits', '2', 'IntegerConfigHandler', 0, 0, ' ', ''),
(204, 'listing preferences', 'lp_dim_workspaces_show_as_column', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(205, 'listing preferences', 'lp_dim_tags_show_as_column', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(206, 'mails panel', 'view deleted accounts emails', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(207, 'mails panel', 'check_is_defult_account', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(208, 'mails panel', 'block_email_images', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(209, 'mails panel', 'draft_autosave_timeout', '60', 'IntegerConfigHandler', 0, 100, NULL, ''),
(210, 'mails panel', 'default_mail_font_size', '14', 'IntegerConfigHandler', 0, 100, NULL, ''),
(211, 'mails panel', 'attach_docs_content', '1', 'BoolConfigHandler', 0, 0, NULL, ''),
(212, 'mails panel', 'email_polling', '0', 'IntegerConfigHandler', 1, 0, NULL, ''),
(213, 'mails panel', 'show_unread_on_title', '0', 'BoolConfigHandler', 1, 0, NULL, ''),
(214, 'mails panel', 'max_spam_level', '5', 'IntegerConfigHandler', 0, 100, NULL, ''),
(215, 'mails panel', 'create_contacts_from_email_recipients', '0', 'BoolConfigHandler', 0, 101, NULL, ''),
(216, 'mails panel', 'mail_drag_drop_prompt', 'prompt', 'MailDragDropPromptConfigHandler', 0, 102, NULL, ''),
(217, 'mails panel', 'auto_classify_attachments', '1', 'BoolConfigHandler', 0, 103, NULL, ''),
(218, 'mails panel', 'show_emails_as_conversations', '0', 'BoolConfigHandler', 0, 0, NULL, ''),
(219, 'mails panel', 'mails account filter', '', 'StringConfigHandler', 1, 0, NULL, ''),
(220, 'mails panel', 'mails classification filter', 'all', 'StringConfigHandler', 1, 0, NULL, ''),
(221, 'mails panel', 'mails read filter', 'all', 'StringConfigHandler', 1, 0, NULL, ''),
(222, 'mails panel', 'hide_quoted_text_in_emails', '0', 'BoolConfigHandler', 0, 110, NULL, ''),
(223, 'mails panel', 'mail_account_err_check_interval', '300', 'IntegerConfigHandler', 0, 120, NULL, ''),
(224, 'mails panel', 'classify_mail_with_conversation', '1', 'BoolConfigHandler', 0, 130, NULL, ''),
(225, 'mails panel', 'folder_received_columns', 'from,subject,account,date,folder,actions', 'StringConfigHandler', 1, 0, NULL, ''),
(226, 'mails panel', 'folder_sent_columns', 'to,subject,account,date,folder,actions', 'StringConfigHandler', 1, 0, NULL, ''),
(227, 'mails panel', 'folder_draft_columns', 'to,subject,account,date,folder,actions', 'StringConfigHandler', 1, 0, NULL, ''),
(228, 'mails panel', 'folder_junk_columns', 'from,subject,account,date,folder,actions', 'StringConfigHandler', 1, 0, NULL, ''),
(229, 'mails panel', 'folder_outbox_columns', 'to,subject,account,date,folder,actions', 'StringConfigHandler', 1, 0, NULL, ''),
(230, 'mails panel', 'check_attach_word', '1', 'BoolConfigHandler', 0, 0, NULL, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_config_option_values`
--

CREATE TABLE `[[dbprefix]]contact_config_option_values` (
  `option_id` int(10) unsigned NOT NULL DEFAULT '0',
  `contact_id` int(10) unsigned NOT NULL DEFAULT '0',
  `value` text COLLATE utf8_unicode_ci,
  `member_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`option_id`,`contact_id`,`member_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_dimension_permissions`
--

CREATE TABLE `[[dbprefix]]contact_dimension_permissions` (
  `permission_group_id` int(10) unsigned NOT NULL,
  `dimension_id` int(10) unsigned NOT NULL,
  `permission_type` enum('allow all','deny all','check') COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`permission_group_id`,`dimension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]contact_dimension_permissions`
--

INSERT INTO `[[dbprefix]]contact_dimension_permissions` VALUES
(1, 2, 'allow all'),
(14, 1, 'allow all'),
(14, 2, 'allow all');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_emails`
--

CREATE TABLE `[[dbprefix]]contact_emails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `email_type_id` int(10) unsigned NOT NULL,
  `email_address` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_main` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `by_contact` (`contact_id`,`is_main`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]contact_emails`
--

INSERT INTO `[[dbprefix]]contact_emails` VALUES
(1, 2, 2, '[[admin_email]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_external_tokens`
--

CREATE TABLE `[[dbprefix]]contact_external_tokens` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `token` text COLLATE utf8_unicode_ci,
  `type` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `external_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `external_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `created_date` datetime NOT NULL,
  `expired_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_im_values`
--

CREATE TABLE `[[dbprefix]]contact_im_values` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `im_type_id` int(10) unsigned NOT NULL,
  `value` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_main` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `by_contact` (`contact_id`,`is_main`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_member_cache`
--

CREATE TABLE `[[dbprefix]]contact_member_cache` (
  `contact_id` int(10) unsigned NOT NULL,
  `member_id` int(10) unsigned NOT NULL,
  `parent_member_id` int(10) unsigned NOT NULL DEFAULT '0',
  `last_activity` datetime NOT NULL,
  PRIMARY KEY (`contact_id`,`member_id`),
  KEY `by_contact` USING HASH (`contact_id`),
  KEY `by_parent` USING HASH (`parent_member_id`),
  KEY `last_activity` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_member_permissions`
--

CREATE TABLE `[[dbprefix]]contact_member_permissions` (
  `permission_group_id` int(10) unsigned NOT NULL,
  `member_id` int(10) unsigned NOT NULL,
  `object_type_id` int(10) unsigned NOT NULL,
  `can_write` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_delete` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_group_id`,`member_id`,`object_type_id`),
  KEY `member_id` (`member_id`),
  KEY `obj_type` (`object_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]contact_member_permissions`
--

INSERT INTO `[[dbprefix]]contact_member_permissions` VALUES
(14, 0, 3, 1, 1),
(14, 0, 4, 1, 1),
(14, 0, 5, 1, 1),
(14, 0, 6, 1, 1),
(14, 0, 9, 1, 1),
(14, 0, 10, 1, 1),
(14, 0, 11, 1, 1),
(14, 0, 15, 1, 1),
(14, 0, 17, 1, 1),
(14, 1, 3, 1, 1),
(14, 1, 4, 1, 1),
(14, 1, 5, 1, 1),
(14, 1, 6, 1, 1),
(14, 1, 9, 1, 1),
(14, 1, 10, 1, 1),
(14, 1, 11, 1, 1),
(14, 1, 12, 1, 1),
(14, 1, 13, 1, 1),
(14, 1, 15, 1, 1),
(14, 1, 16, 1, 1),
(14, 1, 17, 1, 1),
(14, 1, 18, 1, 1),
(14, 1, 19, 1, 1),
(14, 1, 22, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_passwords`
--

CREATE TABLE `[[dbprefix]]contact_passwords` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) NOT NULL,
  `password` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `password_date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]contact_passwords`
--

INSERT INTO `[[dbprefix]]contact_passwords` VALUES
(1, 2, '[[contact_pass]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_permission_groups`
--

CREATE TABLE `[[dbprefix]]contact_permission_groups` (
  `contact_id` int(10) unsigned NOT NULL,
  `permission_group_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`contact_id`,`permission_group_id`),
  KEY `contact_id` (`contact_id`),
  KEY `permission_group_id` (`permission_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]contact_permission_groups`
--

INSERT INTO `[[dbprefix]]contact_permission_groups` VALUES
(2, 14);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_telephones`
--

CREATE TABLE `[[dbprefix]]contact_telephones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `telephone_type_id` int(10) unsigned NOT NULL,
  `number` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(256) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_main` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `by_contact` (`contact_id`,`is_main`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_web_pages`
--

CREATE TABLE `[[dbprefix]]contact_web_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `web_type_id` int(10) unsigned NOT NULL,
  `url` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `by_contact` USING HASH (`contact_id`,`web_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_widgets`
--

CREATE TABLE `[[dbprefix]]contact_widgets` (
  `widget_name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `contact_id` int(11) NOT NULL,
  `section` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `order` int(11) NOT NULL,
  `options` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY USING BTREE (`widget_name`,`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]contact_widget_options`
--

CREATE TABLE `[[dbprefix]]contact_widget_options` (
  `widget_name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `contact_id` int(11) NOT NULL,
  `member_type_id` int(11) NOT NULL DEFAULT '0',
  `option` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `config_handler_class` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `is_system` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY USING BTREE (`widget_name`,`contact_id`,`member_type_id`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]contact_widget_options`
--

INSERT INTO `[[dbprefix]]contact_widget_options` VALUES
('calendar', 0, 0, 'filter_by_myself', '1', 'BooleanConfigHandler', 0),
('overdue_upcoming', 0, 0, 'assigned_to_user', '0', 'UserCompanyConfigHandler', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]countries`
--

CREATE TABLE `[[dbprefix]]countries` (
  `code` char(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`code`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]countries`
--

INSERT INTO `[[dbprefix]]countries` VALUES
('AF', 'Afghanistan'),
('AX', 'Aland Islands'),
('AL', 'Albania'),
('DZ', 'Algeria'),
('AS', 'American Samoa'),
('AD', 'Andorra'),
('AO', 'Angola'),
('AI', 'Anguilla'),
('AQ', 'Antarctica'),
('AG', 'Antigua and Barbuda'),
('AR', 'Argentina'),
('AM', 'Armenia'),
('AW', 'Aruba'),
('AU', 'Australia'),
('AT', 'Austria'),
('AZ', 'Azerbaijan'),
('BS', 'Bahamas'),
('BH', 'Bahrain'),
('BD', 'Bangladesh'),
('BB', 'Barbados'),
('BY', 'Belarus'),
('BE', 'Belgium'),
('BZ', 'Belize'),
('BJ', 'Benin'),
('BM', 'Bermuda'),
('BT', 'Bhutan'),
('BO', 'Bolivia'),
('BQ', 'Bonaire, Saint Eustatius and Saba '),
('BA', 'Bosnia and Herzegovina'),
('BW', 'Botswana'),
('BV', 'Bouvet Island'),
('BR', 'Brazil'),
('IO', 'British Indian Ocean Territory'),
('VG', 'British Virgin Islands'),
('BN', 'Brunei'),
('BG', 'Bulgaria'),
('BF', 'Burkina Faso'),
('BI', 'Burundi'),
('KH', 'Cambodia'),
('CM', 'Cameroon'),
('CA', 'Canada'),
('CV', 'Cape Verde'),
('KY', 'Cayman Islands'),
('CF', 'Central African Republic'),
('TD', 'Chad'),
('CL', 'Chile'),
('CN', 'China'),
('CX', 'Christmas Island'),
('CC', 'Cocos Islands'),
('CO', 'Colombia'),
('KM', 'Comoros'),
('CK', 'Cook Islands'),
('CR', 'Costa Rica'),
('HR', 'Croatia'),
('CU', 'Cuba'),
('CW', 'Cura├ºao'),
('CY', 'Cyprus'),
('CZ', 'Czech Republic'),
('CD', 'Democratic Republic of the Congo'),
('DK', 'Denmark'),
('DJ', 'Djibouti'),
('DM', 'Dominica'),
('DO', 'Dominican Republic'),
('TL', 'East Timor'),
('EC', 'Ecuador'),
('EG', 'Egypt'),
('SV', 'El Salvador'),
('GQ', 'Equatorial Guinea'),
('ER', 'Eritrea'),
('EE', 'Estonia'),
('ET', 'Ethiopia'),
('FK', 'Falkland Islands'),
('FO', 'Faroe Islands'),
('FJ', 'Fiji'),
('FI', 'Finland'),
('FR', 'France'),
('GF', 'French Guiana'),
('PF', 'French Polynesia'),
('TF', 'French Southern Territories'),
('GA', 'Gabon'),
('GM', 'Gambia'),
('GE', 'Georgia'),
('DE', 'Germany'),
('GH', 'Ghana'),
('GI', 'Gibraltar'),
('GR', 'Greece'),
('GL', 'Greenland'),
('GD', 'Grenada'),
('GP', 'Guadeloupe'),
('GU', 'Guam'),
('GT', 'Guatemala'),
('GG', 'Guernsey'),
('GN', 'Guinea'),
('GW', 'Guinea-Bissau'),
('GY', 'Guyana'),
('HT', 'Haiti'),
('HM', 'Heard Island and McDonald Islands'),
('HN', 'Honduras'),
('HK', 'Hong Kong'),
('HU', 'Hungary'),
('IS', 'Iceland'),
('IN', 'India'),
('ID', 'Indonesia'),
('IR', 'Iran'),
('IQ', 'Iraq'),
('IE', 'Ireland'),
('IM', 'Isle of Man'),
('IL', 'Israel'),
('IT', 'Italy'),
('CI', 'Ivory Coast'),
('JM', 'Jamaica'),
('JP', 'Japan'),
('JE', 'Jersey'),
('JO', 'Jordan'),
('KZ', 'Kazakhstan'),
('KE', 'Kenya'),
('KI', 'Kiribati'),
('XK', 'Kosovo'),
('KW', 'Kuwait'),
('KG', 'Kyrgyzstan'),
('LA', 'Laos'),
('LV', 'Latvia'),
('LB', 'Lebanon'),
('LS', 'Lesotho'),
('LR', 'Liberia'),
('LY', 'Libya'),
('LI', 'Liechtenstein'),
('LT', 'Lithuania'),
('LU', 'Luxembourg'),
('MO', 'Macao'),
('MK', 'Macedonia'),
('MG', 'Madagascar'),
('MW', 'Malawi'),
('MY', 'Malaysia'),
('MV', 'Maldives'),
('ML', 'Mali'),
('MT', 'Malta'),
('MH', 'Marshall Islands'),
('MQ', 'Martinique'),
('MR', 'Mauritania'),
('MU', 'Mauritius'),
('YT', 'Mayotte'),
('MX', 'Mexico'),
('FM', 'Micronesia'),
('MD', 'Moldova'),
('MC', 'Monaco'),
('MN', 'Mongolia'),
('ME', 'Montenegro'),
('MS', 'Montserrat'),
('MA', 'Morocco'),
('MZ', 'Mozambique'),
('MM', 'Myanmar'),
('NA', 'Namibia'),
('NR', 'Nauru'),
('NP', 'Nepal'),
('NL', 'Netherlands'),
('AN', 'Netherlands Antilles'),
('NC', 'New Caledonia'),
('NZ', 'New Zealand'),
('NI', 'Nicaragua'),
('NE', 'Niger'),
('NG', 'Nigeria'),
('NU', 'Niue'),
('NF', 'Norfolk Island'),
('KP', 'North Korea'),
('MP', 'Northern Mariana Islands'),
('NO', 'Norway'),
('OM', 'Oman'),
('PK', 'Pakistan'),
('PW', 'Palau'),
('PS', 'Palestinian Territory'),
('PA', 'Panama'),
('PG', 'Papua New Guinea'),
('PY', 'Paraguay'),
('PE', 'Peru'),
('PH', 'Philippines'),
('PN', 'Pitcairn'),
('PL', 'Poland'),
('PT', 'Portugal'),
('PR', 'Puerto Rico'),
('QA', 'Qatar'),
('CG', 'Republic of the Congo'),
('RE', 'Reunion'),
('RO', 'Romania'),
('RU', 'Russia'),
('RW', 'Rwanda'),
('BL', 'Saint Barth├®lemy'),
('SH', 'Saint Helena'),
('KN', 'Saint Kitts and Nevis'),
('LC', 'Saint Lucia'),
('MF', 'Saint Martin'),
('PM', 'Saint Pierre and Miquelon'),
('VC', 'Saint Vincent and the Grenadines'),
('WS', 'Samoa'),
('SM', 'San Marino'),
('ST', 'Sao Tome and Principe'),
('SA', 'Saudi Arabia'),
('SN', 'Senegal'),
('RS', 'Serbia'),
('CS', 'Serbia and Montenegro'),
('SC', 'Seychelles'),
('SL', 'Sierra Leone'),
('SG', 'Singapore'),
('SX', 'Sint Maarten'),
('SK', 'Slovakia'),
('SI', 'Slovenia'),
('SB', 'Solomon Islands'),
('SO', 'Somalia'),
('ZA', 'South Africa'),
('GS', 'South Georgia and the South Sandwich Islands'),
('KR', 'South Korea'),
('SS', 'South Sudan'),
('ES', 'Spain'),
('LK', 'Sri Lanka'),
('SD', 'Sudan'),
('SR', 'Suriname'),
('SJ', 'Svalbard and Jan Mayen'),
('SZ', 'Swaziland'),
('SE', 'Sweden'),
('CH', 'Switzerland'),
('SY', 'Syria'),
('TW', 'Taiwan'),
('TJ', 'Tajikistan'),
('TZ', 'Tanzania'),
('TH', 'Thailand'),
('TG', 'Togo'),
('TK', 'Tokelau'),
('TO', 'Tonga'),
('TT', 'Trinidad and Tobago'),
('TN', 'Tunisia'),
('TR', 'Turkey'),
('TM', 'Turkmenistan'),
('TC', 'Turks and Caicos Islands'),
('TV', 'Tuvalu'),
('VI', 'U.S. Virgin Islands'),
('UG', 'Uganda'),
('UA', 'Ukraine'),
('AE', 'United Arab Emirates'),
('GB', 'United Kingdom'),
('US', 'United States'),
('UM', 'United States Minor Outlying Islands'),
('UY', 'Uruguay'),
('UZ', 'Uzbekistan'),
('VU', 'Vanuatu'),
('VA', 'Vatican'),
('VE', 'Venezuela'),
('VN', 'Vietnam'),
('WF', 'Wallis and Futuna'),
('EH', 'Western Sahara'),
('YE', 'Yemen'),
('ZM', 'Zambia'),
('ZW', 'Zimbabwe');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cron_events`
--

CREATE TABLE `[[dbprefix]]cron_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `recursive` tinyint(1) NOT NULL DEFAULT '1',
  `delay` int(10) unsigned NOT NULL DEFAULT '0',
  `is_system` tinyint(1) NOT NULL DEFAULT '0',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]cron_events`
--

INSERT INTO `[[dbprefix]]cron_events` VALUES
(1, 'purge_trash', 1, 1440, 1, 1, '1900-01-01 00:00:00'),
(2, 'send_reminders', 1, 10, 0, 1, '1900-01-01 00:00:00'),
(3, 'send_password_expiration_reminders', 1, 1440, 1, 1, '1900-01-01 00:00:00'),
(4, 'send_notifications_through_cron', 1, 1, 0, 0, '1900-01-01 00:00:00'),
(5, 'delete_mails_from_server', 1, 1440, 1, 1, '1900-01-01 00:00:00'),
(6, 'clear_tmp_folder', 1, 1440, 1, 1, '1900-01-01 00:00:00'),
(7, 'check_upgrade', 1, 1440, 1, 0, '1900-01-01 00:00:00'),
(8, 'import_google_calendar', 1, 10, 0, 0, '1900-01-01 00:00:00'),
(9, 'export_google_calendar', 1, 10, 0, 0, '1900-01-01 00:00:00'),
(10, 'sharing_table_partial_rebuild', 1, 1440, 1, 1, '1900-01-01 00:00:00'),
(11, 'check_sharing_table_flags', 1, 10, 1, 1, '1900-01-01 00:00:00'),
(12, 'clean_object_selector_temp_selection', 1, 360, 1, 1, '1900-01-01 00:00:00'),
(13, 'send_outbox_mails', 1, 1, 1, 1, '1900-01-01 00:00:00'),
(14, 'rebuild_contact_member_cache', 1, 1440, 1, 1, '1900-01-01 00:00:00'),
(15, 'check_mail', 1, 10, 0, 1, '[[regtime]]'),
(16, 'delete_spam_emails', 1, 60, 1, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]currencies`
--

CREATE TABLE `[[dbprefix]]currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `symbol` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `short_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL,
  `external_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]currencies`
--

INSERT INTO `[[dbprefix]]currencies` VALUES
(1, '$', 'Dollar', 'USD', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_properties`
--

CREATE TABLE `[[dbprefix]]custom_properties` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `object_type_id` int(10) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `values` text COLLATE utf8_unicode_ci NOT NULL,
  `default_value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `default_currency_id` int(2) NOT NULL DEFAULT '1',
  `is_required` tinyint(1) NOT NULL DEFAULT '0',
  `is_multiple_values` tinyint(1) NOT NULL DEFAULT '0',
  `property_order` int(10) NOT NULL DEFAULT '0',
  `visible_by_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_special` tinyint(1) NOT NULL DEFAULT '0',
  `is_disabled` tinyint(1) NOT NULL DEFAULT '0',
  `show_in_lists` tinyint(1) NOT NULL DEFAULT '0',
  `contact_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'all',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]custom_properties`
--

INSERT INTO `[[dbprefix]]custom_properties` VALUES
(1, 15, 'Job title', 'job_title', 'text', '', '', '', 1, 0, 0, 0, 1, 1, 0, 0, 'all'),
(2, 15, 'Prefix', 'prefix_code', 'text', '', '', '', 1, 0, 0, 0, 0, 1, 0, 0, 'all'),
(3, 1, 'Color', 'color_special', 'color', '', '', '', 1, 0, 0, 30, 1, 1, 0, 0, 'all'),
(4, 1, 'Description', 'description_special', 'memo', '', '', '', 1, 0, 0, 31, 1, 1, 0, 0, 'all');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_property_values`
--

CREATE TABLE `[[dbprefix]]custom_property_values` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `object_id` int(10) NOT NULL,
  `custom_property_id` int(10) NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  `currency_id` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `object_id` (`object_id`),
  KEY `custom_property_id` (`custom_property_id`),
  KEY `value` (`value`(255))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dimensions`
--

CREATE TABLE `[[dbprefix]]dimensions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_root` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_manageable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `allows_multiple_selection` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `defines_permissions` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_system` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `default_order` int(10) NOT NULL DEFAULT '0',
  `options` text COLLATE utf8_unicode_ci,
  `permission_query_method` enum('mandatory','not_mandatory') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'mandatory',
  `is_required` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` USING BTREE (`code`),
  KEY `by_name` (`name`),
  KEY `defines_perm` (`defines_permissions`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]dimensions`
--

INSERT INTO `[[dbprefix]]dimensions` VALUES
(1, 'feng_persons', 'People', 1, 0, 0, 1, 1, 0, 99, '{"useLangs":true,"defaultAjax":{"controller":"dashboard", "action": "main_dashboard"},"quickAdd":{"formAction":"?c=contact&a=quick_add"}}', 'not_mandatory', 0),
(2, 'workspaces', 'Workspaces', 1, 1, 0, 1, 1, 0, 2, '{"defaultAjax":{"controller":"dashboard", "action": "main_dashboard"}, "quickAdd":true,"showInPaths":true,"useLangs":true}', 'mandatory', 0),
(3, 'tags', 'Tags', 1, 1, 0, 0, 1, 0, 3, '{"defaultAjax":{"controller":"dashboard", "action": "main_dashboard"},"quickAdd":true,"showInPaths":true,"useLangs":true}', 'not_mandatory', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dimension_associations_config`
--

CREATE TABLE `[[dbprefix]]dimension_associations_config` (
  `association_id` int(10) unsigned NOT NULL,
  `config_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'boolean',
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`association_id`,`config_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dimension_member_associations`
--

CREATE TABLE `[[dbprefix]]dimension_member_associations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dimension_id` int(10) unsigned NOT NULL,
  `object_type_id` int(10) unsigned NOT NULL,
  `associated_dimension_id` int(10) unsigned NOT NULL,
  `associated_object_type_id` int(10) unsigned NOT NULL,
  `is_required` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_multiple` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `keeps_record` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `allows_default_selection` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `by_associated` USING HASH (`associated_dimension_id`,`associated_object_type_id`),
  KEY `by_dimension_objtype` USING HASH (`dimension_id`,`object_type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]dimension_member_associations`
--

INSERT INTO `[[dbprefix]]dimension_member_associations` VALUES
(1, 2, 1, 1, 20, 0, 1, 0, 0, ''),
(2, 2, 1, 1, 21, 0, 1, 0, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dimension_member_association_default_selections`
--

CREATE TABLE `[[dbprefix]]dimension_member_association_default_selections` (
  `association_id` int(10) unsigned NOT NULL,
  `member_id` int(10) unsigned NOT NULL,
  `selected_member_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`association_id`,`member_id`,`selected_member_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dimension_member_restriction_definitions`
--

CREATE TABLE `[[dbprefix]]dimension_member_restriction_definitions` (
  `dimension_id` int(10) unsigned NOT NULL,
  `object_type_id` int(10) unsigned NOT NULL,
  `restricted_dimension_id` int(10) unsigned NOT NULL,
  `restricted_object_type_id` int(10) unsigned NOT NULL,
  `is_orderable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `enforce_order_progression` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_required` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`dimension_id`,`object_type_id`,`restricted_dimension_id`,`restricted_object_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dimension_object_types`
--

CREATE TABLE `[[dbprefix]]dimension_object_types` (
  `dimension_id` int(10) unsigned NOT NULL,
  `object_type_id` int(10) unsigned NOT NULL,
  `is_root` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `options` text COLLATE utf8_unicode_ci,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`dimension_id`,`object_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]dimension_object_types`
--

INSERT INTO `[[dbprefix]]dimension_object_types` VALUES
(1, 20, 1, '{"defaultAjax":{"controller":"contact", "action": "card"}}', 1),
(1, 21, 1, '{"defaultAjax":{"controller":"contact", "action": "company_card"}}', 1),
(2, 1, 1, '{"defaultAjax":{"controller":"dashboard", "action": "main_dashboard"}}', 1),
(3, 2, 1, '{"defaultAjax":{"controller":"dashboard", "action": "main_dashboard"}}', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dimension_object_type_contents`
--

CREATE TABLE `[[dbprefix]]dimension_object_type_contents` (
  `dimension_id` int(10) unsigned NOT NULL,
  `dimension_object_type_id` int(10) unsigned NOT NULL,
  `content_object_type_id` int(10) unsigned NOT NULL,
  `is_required` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_multiple` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`dimension_id`,`dimension_object_type_id`,`content_object_type_id`),
  KEY `by_co_obj_type` USING HASH (`content_object_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]dimension_object_type_contents`
--

INSERT INTO `[[dbprefix]]dimension_object_type_contents` VALUES
(1, 20, 3, 0, 1),
(1, 20, 4, 0, 1),
(1, 20, 5, 0, 1),
(1, 20, 6, 0, 1),
(1, 20, 9, 0, 1),
(1, 20, 10, 0, 1),
(1, 20, 11, 0, 1),
(1, 20, 12, 0, 1),
(1, 20, 13, 0, 1),
(1, 20, 15, 0, 1),
(1, 20, 16, 0, 1),
(1, 20, 17, 0, 1),
(1, 20, 18, 0, 1),
(1, 20, 19, 0, 1),
(1, 20, 22, 0, 1),
(1, 21, 3, 0, 1),
(1, 21, 4, 0, 1),
(1, 21, 5, 0, 1),
(1, 21, 6, 0, 1),
(1, 21, 9, 0, 1),
(1, 21, 10, 0, 1),
(1, 21, 11, 0, 1),
(1, 21, 12, 0, 1),
(1, 21, 13, 0, 1),
(1, 21, 15, 0, 1),
(1, 21, 16, 0, 1),
(1, 21, 17, 0, 1),
(1, 21, 18, 0, 1),
(1, 21, 19, 0, 1),
(1, 21, 22, 0, 1),
(2, 1, 3, 0, 1),
(2, 1, 4, 0, 1),
(2, 1, 5, 0, 1),
(2, 1, 6, 0, 1),
(2, 1, 9, 0, 1),
(2, 1, 10, 0, 1),
(2, 1, 11, 0, 1),
(2, 1, 12, 0, 1),
(2, 1, 13, 0, 1),
(2, 1, 15, 0, 1),
(2, 1, 16, 0, 1),
(2, 1, 17, 0, 1),
(2, 1, 18, 0, 1),
(2, 1, 19, 0, 1),
(2, 1, 22, 0, 1),
(3, 2, 3, 0, 1),
(3, 2, 4, 0, 1),
(3, 2, 5, 0, 1),
(3, 2, 6, 0, 1),
(3, 2, 9, 0, 1),
(3, 2, 10, 0, 1),
(3, 2, 11, 0, 1),
(3, 2, 12, 0, 1),
(3, 2, 13, 0, 1),
(3, 2, 15, 0, 1),
(3, 2, 16, 0, 1),
(3, 2, 17, 0, 1),
(3, 2, 18, 0, 1),
(3, 2, 19, 0, 1),
(3, 2, 22, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dimension_object_type_hierarchies`
--

CREATE TABLE `[[dbprefix]]dimension_object_type_hierarchies` (
  `dimension_id` int(10) unsigned NOT NULL,
  `parent_object_type_id` int(10) unsigned NOT NULL,
  `child_object_type_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`dimension_id`,`parent_object_type_id`,`child_object_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]dimension_object_type_hierarchies`
--

INSERT INTO `[[dbprefix]]dimension_object_type_hierarchies` VALUES
(1, 21, 20),
(2, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dimension_object_type_options`
--

CREATE TABLE `[[dbprefix]]dimension_object_type_options` (
  `dimension_id` int(10) unsigned NOT NULL,
  `object_type_id` int(10) unsigned NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`dimension_id`,`object_type_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]dimension_object_type_options`
--

INSERT INTO `[[dbprefix]]dimension_object_type_options` VALUES
(2, 1, 'select_after_creation', '1'),
(3, 1, 'select_after_creation', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]dimension_options`
--

CREATE TABLE `[[dbprefix]]dimension_options` (
  `dimension_id` int(10) unsigned NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`dimension_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]dimension_options`
--

INSERT INTO `[[dbprefix]]dimension_options` VALUES
(1, 'useLangs', '1'),
(2, 'showInPaths', '1'),
(2, 'useLangs', '1'),
(3, 'showInPaths', '1'),
(3, 'useLangs', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_types`
--

CREATE TABLE `[[dbprefix]]email_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_system` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]email_types`
--

INSERT INTO `[[dbprefix]]email_types` VALUES
(1, 'user', 1),
(2, 'personal', 1),
(3, 'work', 1),
(4, 'other', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]event_invitations`
--

CREATE TABLE `[[dbprefix]]event_invitations` (
  `event_id` int(10) unsigned NOT NULL DEFAULT '0',
  `contact_id` int(10) unsigned NOT NULL DEFAULT '0',
  `invitation_state` int(10) unsigned NOT NULL DEFAULT '0',
  `synced` int(1) DEFAULT '0',
  `special_id` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`event_id`,`contact_id`),
  KEY `contact_id` (`contact_id`,`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_calendars`
--

CREATE TABLE `[[dbprefix]]external_calendars` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ext_cal_user_id` int(10) unsigned NOT NULL,
  `original_calendar_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `calendar_visibility` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `calendar_name` text COLLATE utf8_unicode_ci NOT NULL,
  `calendar_feng` tinyint(1) NOT NULL DEFAULT '0',
  `sync` tinyint(1) NOT NULL DEFAULT '0',
  `related_to` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_calendar_properties`
--

CREATE TABLE `[[dbprefix]]external_calendar_properties` (
  `external_calendar_id` int(10) unsigned NOT NULL,
  `key` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`external_calendar_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]external_calendar_users`
--

CREATE TABLE `[[dbprefix]]external_calendar_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `auth_user` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `auth_pass` text COLLATE utf8_unicode_ci NOT NULL,
  `type` text COLLATE utf8_unicode_ci NOT NULL,
  `sync` tinyint(1) DEFAULT '0',
  `related_to` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_repo`
--

CREATE TABLE `[[dbprefix]]file_repo` (
  `id` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `content` longblob NOT NULL,
  `order` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `order` (`order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_repo_attributes`
--

CREATE TABLE `[[dbprefix]]file_repo_attributes` (
  `id` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `attribute` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`,`attribute`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_types`
--

CREATE TABLE `[[dbprefix]]file_types` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `icon` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_searchable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_image` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_allow` tinyint(1) NOT NULL DEFAULT '1',
  `friendly_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `extension` (`extension`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=37 ;

--
-- Dumping data for table `[[dbprefix]]file_types`
--

INSERT INTO `[[dbprefix]]file_types` VALUES
(1, 'zip', 'archive.png', 0, 0, 1, 'compressed archive file zip'),
(2, 'rar', 'archive.png', 0, 0, 1, 'compressed archive file rar'),
(3, 'bz', 'archive.png', 0, 0, 1, 'compressed archive file bz'),
(4, 'bz2', 'archive.png', 0, 0, 1, 'compressed archive file bz'),
(5, 'gz', 'archive.png', 0, 0, 1, 'compressed archive file gz'),
(6, 'ace', 'archive.png', 0, 0, 1, 'compressed archive file ace'),
(7, 'mp3', 'audio.png', 0, 0, 1, 'audio mp3'),
(8, 'wma', 'audio.png', 0, 0, 1, 'Windows Media audio'),
(9, 'ogg', 'audio.png', 0, 0, 1, 'vorbis audio file'),
(10, 'doc', 'doc.png', 0, 0, 1, 'microsoft word file'),
(11, 'xls', 'xls.png', 0, 0, 1, 'microsoft excel spreadsheet'),
(12, 'docx', 'doc.png', 1, 0, 1, 'microsoft word xml document'),
(13, 'xlsx', 'xls.png', 0, 0, 1, 'microsoft excel xml spreadsheet'),
(14, 'gif', 'image.png', 0, 1, 1, 'gif image'),
(15, 'jpg', 'image.png', 0, 1, 1, 'jpg image'),
(16, 'jpeg', 'image.png', 0, 1, 1, 'jpeg image'),
(17, 'png', 'image.png', 0, 1, 1, 'png image'),
(18, 'mov', 'mov.png', 0, 0, 1, 'quicktime movie file'),
(19, 'pdf', 'pdf.png', 1, 0, 1, 'pdf file'),
(20, 'psd', 'psd.png', 0, 0, 1, 'adobe photoshop document'),
(21, 'rm', 'rm.png', 0, 0, 1, 'real media file'),
(22, 'svg', 'svg.png', 0, 0, 1, 'vector graphics file'),
(23, 'swf', 'swf.png', 0, 0, 1, 'shockwave flash movie'),
(24, 'avi', 'video.png', 0, 0, 1, 'microsoft audio/visual interleaved'),
(25, 'mpeg', 'video.png', 0, 0, 1, 'motion picture experts group file'),
(26, 'mpg', 'video.png', 0, 0, 1, 'video stream'),
(27, 'qt', 'mov.png', 0, 0, 1, 'apple quicktime movie'),
(28, 'vob', 'video.png', 0, 0, 1, 'dvd video object file'),
(29, 'txt', 'text.png', 1, 0, 1, 'raw text file'),
(30, 'html', 'html.png', 1, 0, 1, 'hypertext markup language file'),
(31, 'slim', 'ppt.png', 1, 0, 1, 'slim presentation file'),
(32, 'ppt', 'ppt.png', 0, 0, 1, 'powerpoint presentation file'),
(33, 'webfile', 'webfile.png', 0, 0, 1, 'web file'),
(34, 'odt', 'doc.png', 0, 0, 1, 'opendocument text document'),
(35, 'fodt', 'doc.png', 0, 0, 1, 'fodt'),
(36, 'ics', 'ics.png', 0, 0, 1, 'icalendar file');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]guistate`
--

CREATE TABLE `[[dbprefix]]guistate` (
  `contact_id` int(10) unsigned NOT NULL DEFAULT '1',
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`contact_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]historic_values`
--

CREATE TABLE `[[dbprefix]]historic_values` (
  `object_id` int(10) unsigned NOT NULL,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `created_on` datetime NOT NULL,
  `created_by_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`object_id`,`created_on`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]im_types`
--

CREATE TABLE `[[dbprefix]]im_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `icon` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]im_types`
--

INSERT INTO `[[dbprefix]]im_types` VALUES
(1, 'ICQ', 'icq.gif', 1),
(2, 'AIM', 'aim.gif', 1),
(3, 'MSN', 'msn.gif', 1),
(4, 'Yahoo!', 'yahoo.gif', 1),
(5, 'Skype', 'skype.gif', 1),
(6, 'Jabber', 'jabber.gif', 1),
(7, 'Twitter', 'twitter.svg', 0),
(8, 'Facebook', 'facebook.svg', 0),
(9, 'LinkedIn', 'linkedin.svg', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]linked_objects`
--

CREATE TABLE `[[dbprefix]]linked_objects` (
  `rel_object_id` int(10) unsigned NOT NULL DEFAULT '0',
  `object_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`rel_object_id`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_accounts`
--

CREATE TABLE `[[dbprefix]]mail_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `email_addr` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(40) COLLATE utf8_unicode_ci DEFAULT '',
  `server` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_imap` int(1) NOT NULL DEFAULT '0',
  `incoming_ssl` int(1) NOT NULL DEFAULT '0',
  `incoming_ssl_port` int(11) DEFAULT '995',
  `incoming_ssl_verify_peer` tinyint(1) NOT NULL DEFAULT '0',
  `smtp_server` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `smtp_use_auth` int(10) unsigned NOT NULL DEFAULT '0',
  `smtp_username` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `smtp_password` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `smtp_port` int(10) unsigned NOT NULL DEFAULT '25',
  `del_from_server` int(11) NOT NULL DEFAULT '0',
  `mark_read_on_server` int(11) NOT NULL DEFAULT '1',
  `get_read_state_from_server` tinyint(1) NOT NULL DEFAULT '1',
  `exclude_from_synchronizing` tinyint(1) NOT NULL DEFAULT '0',
  `outgoing_transport_type` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `last_checked` datetime NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `signature` text COLLATE utf8_unicode_ci NOT NULL,
  `sender_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `last_error_date` datetime NOT NULL,
  `last_error_msg` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sync_addr` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `sync_pass` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `sync_server` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `sync_ssl` tinyint(1) NOT NULL DEFAULT '0',
  `sync_ssl_port` int(11) NOT NULL DEFAULT '993',
  `sync_folder` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `member_id` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `can_detect_special_folders` tinyint(1) NOT NULL DEFAULT '0',
  `oauth2_access_token` text COLLATE utf8_unicode_ci NOT NULL,
  `oauth2_provider` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `uses_oauth2` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `contact_id` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_account_contacts`
--

CREATE TABLE `[[dbprefix]]mail_account_contacts` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `account_id` int(10) NOT NULL,
  `contact_id` int(10) NOT NULL,
  `can_edit` tinyint(1) NOT NULL DEFAULT '0',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `signature` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `sender_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `last_error_state` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '0:no error,1:err unread, 2:err read',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_contactacc` (`account_id`,`contact_id`),
  KEY `ix_contact` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_account_imap_folder`
--

CREATE TABLE `[[dbprefix]]mail_account_imap_folder` (
  `account_id` int(10) unsigned NOT NULL DEFAULT '0',
  `folder_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `check_folder` tinyint(1) NOT NULL DEFAULT '0',
  `last_uid_in_folder` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `special_use` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`account_id`,`folder_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_contents`
--

CREATE TABLE `[[dbprefix]]mail_contents` (
  `object_id` int(10) unsigned NOT NULL,
  `account_id` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `from` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `from_name` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sent_date` datetime NOT NULL,
  `received_date` datetime NOT NULL,
  `has_attachments` int(1) NOT NULL DEFAULT '0',
  `size` int(10) NOT NULL DEFAULT '0',
  `state` int(1) NOT NULL DEFAULT '0' COMMENT '0:nothing, 1:sent, 2:draft',
  `is_deleted` int(1) NOT NULL DEFAULT '0',
  `is_shared` int(1) NOT NULL DEFAULT '0',
  `imap_folder_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `content_file_id` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `message_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Message-Id header',
  `in_reply_to_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Message-Id header of the previous email in the conversation',
  `conversation_id` int(10) unsigned NOT NULL DEFAULT '0',
  `conversation_last` int(1) NOT NULL DEFAULT '1',
  `sync` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`),
  KEY `account_id` (`account_id`,`uid`),
  KEY `sent_date` (`sent_date`),
  KEY `received_date` (`received_date`),
  KEY `uid` (`uid`),
  KEY `conversation_id` (`conversation_id`),
  KEY `message_id` (`message_id`),
  KEY `state` (`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_content_imap_folders`
--

CREATE TABLE `[[dbprefix]]mail_content_imap_folders` (
  `account_id` int(10) unsigned NOT NULL,
  `message_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `folder` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `uid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `object_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`,`folder`,`object_id`),
  KEY `account_id_folder_object_id` (`account_id`,`folder`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_conversations`
--

CREATE TABLE `[[dbprefix]]mail_conversations` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_datas`
--

CREATE TABLE `[[dbprefix]]mail_datas` (
  `id` int(10) unsigned NOT NULL,
  `to` text COLLATE utf8_unicode_ci NOT NULL,
  `cc` text COLLATE utf8_unicode_ci NOT NULL,
  `bcc` text COLLATE utf8_unicode_ci NOT NULL,
  `subject` text COLLATE utf8_unicode_ci,
  `content` text COLLATE utf8_unicode_ci,
  `body_plain` longtext COLLATE utf8_unicode_ci,
  `body_html` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_spam_filters`
--

CREATE TABLE `[[dbprefix]]mail_spam_filters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL,
  `text_type` enum('email_address','subject') COLLATE utf8_unicode_ci NOT NULL,
  `text` text COLLATE utf8_unicode_ci NOT NULL,
  `spam_state` enum('no spam','spam') COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]max_role_object_type_permissions`
--

CREATE TABLE `[[dbprefix]]max_role_object_type_permissions` (
  `role_id` int(10) unsigned NOT NULL,
  `object_type_id` int(10) unsigned NOT NULL,
  `can_delete` tinyint(1) NOT NULL,
  `can_write` tinyint(1) NOT NULL,
  PRIMARY KEY (`role_id`,`object_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]max_role_object_type_permissions`
--

INSERT INTO `[[dbprefix]]max_role_object_type_permissions` VALUES
(1, 3, 1, 1),
(1, 4, 1, 1),
(1, 5, 1, 1),
(1, 6, 1, 1),
(1, 9, 1, 1),
(1, 10, 1, 1),
(1, 11, 1, 1),
(1, 15, 1, 1),
(1, 17, 1, 1),
(1, 22, 1, 1),
(2, 3, 1, 1),
(2, 4, 1, 1),
(2, 5, 1, 1),
(2, 6, 1, 1),
(2, 9, 1, 1),
(2, 10, 1, 1),
(2, 11, 1, 1),
(2, 15, 1, 1),
(2, 17, 1, 1),
(2, 22, 1, 1),
(3, 3, 1, 1),
(3, 4, 1, 1),
(3, 5, 1, 1),
(3, 6, 1, 1),
(3, 9, 1, 1),
(3, 10, 1, 1),
(3, 11, 1, 1),
(3, 15, 1, 1),
(3, 17, 1, 1),
(3, 22, 1, 1),
(4, 3, 1, 1),
(4, 4, 1, 1),
(4, 5, 1, 1),
(4, 6, 1, 1),
(4, 9, 1, 1),
(4, 10, 1, 1),
(4, 11, 1, 1),
(4, 15, 1, 1),
(4, 17, 1, 1),
(4, 22, 1, 1),
(5, 3, 0, 1),
(5, 4, 0, 1),
(5, 5, 0, 0),
(5, 6, 0, 1),
(5, 9, 0, 0),
(5, 10, 0, 0),
(5, 11, 0, 1),
(5, 15, 0, 1),
(5, 17, 0, 1),
(5, 22, 0, 0),
(6, 3, 0, 1),
(6, 4, 0, 1),
(6, 5, 0, 0),
(6, 6, 0, 1),
(6, 9, 0, 0),
(6, 10, 0, 0),
(6, 11, 0, 1),
(6, 15, 0, 1),
(6, 17, 0, 1),
(6, 22, 0, 0),
(7, 3, 0, 1),
(7, 4, 0, 1),
(7, 5, 0, 0),
(7, 6, 0, 1),
(7, 9, 0, 0),
(7, 10, 0, 0),
(7, 11, 0, 1),
(7, 15, 0, 1),
(7, 17, 0, 1),
(7, 22, 0, 0),
(11, 3, 0, 0),
(11, 4, 0, 0),
(11, 5, 0, 0),
(11, 6, 0, 0),
(11, 9, 0, 0),
(11, 10, 0, 0),
(11, 11, 0, 0),
(11, 15, 0, 0),
(11, 17, 0, 0),
(11, 22, 0, 0),
(12, 3, 0, 0),
(12, 4, 0, 0),
(12, 5, 0, 0),
(12, 6, 0, 0),
(12, 9, 0, 0),
(12, 10, 0, 0),
(12, 11, 0, 0),
(12, 15, 0, 0),
(12, 17, 0, 0),
(13, 3, 0, 0),
(13, 4, 0, 0),
(13, 5, 0, 0),
(13, 6, 0, 0),
(13, 9, 0, 0),
(13, 10, 0, 0),
(13, 11, 0, 0),
(13, 15, 0, 0),
(13, 17, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]max_system_permissions`
--

CREATE TABLE `[[dbprefix]]max_system_permissions` (
  `permission_group_id` int(10) unsigned NOT NULL,
  `can_manage_security` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_configuration` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_templates` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_time` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_add_mail_accounts` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_dimensions` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_dimension_members` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_tasks` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_task_assignee` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_billing` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_view_billing` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_see_assigned_to_other_tasks` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `can_see_others_timeslots` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `can_manage_contacts` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_update_other_users_invitations` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_link_objects` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_instantiate_templates` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_repetitive_properties_of_tasks` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_reopen_task` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]max_system_permissions`
--

INSERT INTO `[[dbprefix]]max_system_permissions` VALUES
(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
(2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
(3, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
(4, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1),
(5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0),
(6, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1),
(7, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0),
(12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0),
(13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members`
--

CREATE TABLE `[[dbprefix]]members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dimension_id` int(10) unsigned NOT NULL,
  `object_type_id` int(10) unsigned NOT NULL,
  `parent_member_id` int(10) unsigned NOT NULL DEFAULT '0',
  `depth` int(2) unsigned NOT NULL,
  `name` varchar(511) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `display_name` varchar(511) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8_unicode_ci,
  `object_id` int(10) unsigned DEFAULT NULL,
  `order` int(10) unsigned NOT NULL DEFAULT '0',
  `color` int(10) unsigned NOT NULL DEFAULT '0',
  `archived_on` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `archived_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `by_parent` USING HASH (`parent_member_id`),
  KEY `by_dimension` (`dimension_id`,`parent_member_id`,`name`),
  KEY `by_object_id` (`object_id`),
  KEY `archived_on` (`archived_on`),
  KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]members`
--

INSERT INTO `[[dbprefix]]members` VALUES
(1, 1, 20, 0, 1, '[[admin_username]]', '', '', 2, 0, 0, '0000-00-00 00:00:00', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]member_property_members`
--

CREATE TABLE `[[dbprefix]]member_property_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `association_id` int(10) unsigned NOT NULL,
  `member_id` int(10) unsigned NOT NULL,
  `property_member_id` int(10) unsigned NOT NULL,
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `member_id_property_member_id` (`member_id`,`property_member_id`),
  KEY `property_member_id_member_id` (`property_member_id`,`member_id`),
  KEY `is_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]member_restrictions`
--

CREATE TABLE `[[dbprefix]]member_restrictions` (
  `member_id` int(10) unsigned NOT NULL,
  `restricted_member_id` int(10) unsigned NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`member_id`,`restricted_member_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]objects`
--

CREATE TABLE `[[dbprefix]]objects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `object_type_id` int(10) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `created_on` datetime NOT NULL,
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `updated_on` datetime NOT NULL,
  `updated_by_id` int(10) unsigned DEFAULT NULL,
  `trashed_on` datetime DEFAULT NULL,
  `trashed_by_id` int(10) unsigned DEFAULT NULL,
  `archived_on` datetime DEFAULT NULL,
  `archived_by_id` int(10) unsigned DEFAULT NULL,
  `timezone_id` int(10) unsigned NOT NULL DEFAULT '0',
  `timezone_value` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `created_on` (`created_on`),
  KEY `updated_on` (`updated_on`),
  KEY `trashed_on` (`trashed_on`),
  KEY `archived_on` (`archived_on`),
  KEY `object_type` (`object_type_id`),
  KEY `name` USING HASH (`name`),
  KEY `type_trash_arch` (`object_type_id`,`trashed_on`,`archived_on`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]objects`
--

INSERT INTO `[[dbprefix]]objects` VALUES
(1, 15, '[[site_name]]', '[[regtime]]', 2, '[[regtime]]', 2, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 0, 0),
(2, 15, '[[admin_username]]', '[[regtime]]', 0, '[[regtime]]', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 0, 0),
(3, 11, 'task time report', '[[regtime]]', 2, '[[regtime]]', 2, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]object_contact_permissions`
--

CREATE TABLE `[[dbprefix]]object_contact_permissions` (
  `rel_object_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `can_read` tinyint(1) unsigned NOT NULL,
  `can_write` tinyint(1) unsigned NOT NULL,
  `can_delete` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`rel_object_id`,`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]object_members`
--

CREATE TABLE `[[dbprefix]]object_members` (
  `object_id` int(10) unsigned NOT NULL,
  `member_id` int(10) unsigned NOT NULL,
  `is_optimization` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`member_id`),
  KEY `member_id` (`member_id`),
  KEY `is_optimization` (`is_optimization`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]object_properties`
--

CREATE TABLE `[[dbprefix]]object_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rel_object_id` int(10) unsigned NOT NULL,
  `name` text COLLATE utf8_unicode_ci,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `ObjectID` (`rel_object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]object_reminders`
--

CREATE TABLE `[[dbprefix]]object_reminders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` int(10) unsigned NOT NULL DEFAULT '0',
  `contact_id` int(10) unsigned NOT NULL DEFAULT '0',
  `type` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `context` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `minutes_before` int(10) DEFAULT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_date` (`type`,`date`),
  KEY `obj_date` (`object_id`,`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]object_reminder_types`
--

CREATE TABLE `[[dbprefix]]object_reminder_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]object_reminder_types`
--

INSERT INTO `[[dbprefix]]object_reminder_types` VALUES
(1, 'reminder_email'),
(2, 'reminder_popup');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]object_selector_temp_values`
--

CREATE TABLE `[[dbprefix]]object_selector_temp_values` (
  `user_id` int(11) NOT NULL DEFAULT '0',
  `identifier` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `updated_on` datetime NOT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`,`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]object_subscriptions`
--

CREATE TABLE `[[dbprefix]]object_subscriptions` (
  `object_id` int(10) unsigned NOT NULL DEFAULT '0',
  `contact_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]object_types`
--

CREATE TABLE `[[dbprefix]]object_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `handler_class` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `table_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` enum('content_object','dimension_object','dimension_group','located','comment','') COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `plugin_id` int(10) unsigned NOT NULL DEFAULT '0',
  `uses_order` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `plugin_id` USING HASH (`plugin_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=23 ;

--
-- Dumping data for table `[[dbprefix]]object_types`
--

INSERT INTO `[[dbprefix]]object_types` VALUES
(1, 'workspace', 'Workspaces', 'workspaces', 'dimension_object', 'workspace', 0, 0),
(2, 'tag', '', '', 'dimension_group', 'tag', 0, 0),
(3, 'message', 'ProjectMessages', 'project_messages', 'content_object', 'message', 0, 0),
(4, 'weblink', 'ProjectWebpages', 'project_webpages', 'content_object', 'weblink', 0, 0),
(5, 'task', 'ProjectTasks', 'project_tasks', 'content_object', 'task', 0, 0),
(6, 'file', 'ProjectFiles', 'project_files', 'content_object', 'file', 0, 0),
(7, 'form', 'ProjectForms', 'project_forms', '', '', 0, 0),
(8, 'chart', 'ProjectCharts', 'project_charts', '', '', 0, 0),
(9, 'milestone', 'ProjectMilestones', 'project_milestones', 'content_object', 'milestone', 0, 0),
(10, 'event', 'ProjectEvents', 'project_events', 'content_object', 'event', 0, 0),
(11, 'report', 'Reports', 'reports', 'located', 'reporting', 0, 0),
(12, 'template', 'COTemplates', 'templates', 'located', 'template', 0, 0),
(13, 'comment', 'Comments', 'comments', 'comment', 'comment', 0, 0),
(14, 'billing', 'Billings', 'billings', '', '', 0, 0),
(15, 'contact', 'Contacts', 'contacts', 'content_object', 'contact', 0, 0),
(16, 'file revision', 'ProjectFileRevisions', 'project_file_revisions', 'content_object', 'file', 0, 0),
(17, 'timeslot', 'Timeslots', 'timeslots', 'located', 'time', 0, 0),
(18, 'template_task', 'TemplateTasks', 'template_tasks', 'content_object', 'task', 0, 0),
(19, 'template_milestone', 'TemplateMilestones', 'template_milestones', 'content_object', 'milestone', 0, 0),
(20, 'person', 'Contacts', 'contacts', 'dimension_object', 'contact', 1, 0),
(21, 'company', 'Contacts', 'contacts', 'dimension_object', 'company', 1, 0),
(22, 'mail', 'MailContents', 'mail_contents', 'content_object', 'mail', 4, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]object_type_dependencies`
--

CREATE TABLE `[[dbprefix]]object_type_dependencies` (
  `object_type_id` int(10) unsigned NOT NULL,
  `dependant_object_type_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`object_type_id`,`dependant_object_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]object_type_hierarchies`
--

CREATE TABLE `[[dbprefix]]object_type_hierarchies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_object_type_id` int(10) unsigned NOT NULL DEFAULT '0',
  `child_object_type_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]object_type_hierarchy_options`
--

CREATE TABLE `[[dbprefix]]object_type_hierarchy_options` (
  `hierarchy_id` int(10) unsigned NOT NULL DEFAULT '0',
  `dimension_id` int(10) unsigned NOT NULL DEFAULT '0',
  `member_type_id` int(10) unsigned NOT NULL DEFAULT '0',
  `option` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  PRIMARY KEY (`hierarchy_id`,`dimension_id`,`member_type_id`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permission_contexts`
--

CREATE TABLE `[[dbprefix]]permission_contexts` (
  `contact_id` int(10) unsigned NOT NULL,
  `permission_group_id` int(10) unsigned NOT NULL,
  `member_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`contact_id`,`permission_group_id`,`member_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permission_groups`
--

CREATE TABLE `[[dbprefix]]permission_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact_id` int(10) unsigned DEFAULT NULL,
  `is_context` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `plugin_id` int(10) unsigned NOT NULL DEFAULT '0',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `type` enum('roles','permission_groups','user_groups') COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=15 ;

--
-- Dumping data for table `[[dbprefix]]permission_groups`
--

INSERT INTO `[[dbprefix]]permission_groups` VALUES
(1, 'Super Administrator', 0, 0, 0, 8, 'roles'),
(2, 'Administrator', 0, 0, 0, 8, 'roles'),
(3, 'Manager', 0, 0, 0, 8, 'roles'),
(4, 'Executive', 0, 0, 0, 8, 'roles'),
(5, 'Collaborator Customer', 0, 0, 0, 9, 'roles'),
(6, 'Internal Collaborator', 0, 0, 0, 9, 'roles'),
(7, 'External Collaborator', 0, 0, 0, 9, 'roles'),
(8, 'ExecutiveGroup', 0, 0, 0, 0, 'roles'),
(9, 'CollaboratorGroup', 0, 0, 0, 0, 'roles'),
(10, 'GuestGroup', 0, 0, 0, 0, 'roles'),
(11, 'Guest Customer', 0, 0, 0, 10, 'roles'),
(12, 'Guest', 0, 0, 0, 10, 'roles'),
(13, 'Non-Exec Director', 0, 0, 0, 10, 'roles'),
(14, 'Account Owner', 2, 0, 0, 0, 'permission_groups');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugins`
--

CREATE TABLE `[[dbprefix]]plugins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_installed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_activated` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `priority` smallint(5) unsigned NOT NULL DEFAULT '0',
  `activated_on` datetime NOT NULL,
  `activated_by_id` int(10) unsigned DEFAULT NULL,
  `version` int(10) unsigned DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]plugins`
--

INSERT INTO `[[dbprefix]]plugins` VALUES
(1, 'core_dimensions', 1, 1, 0, '[[regtime]]', NULL, 20),
(3, 'workspaces', 1, 1, 0, '[[regtime]]', NULL, 15),
(4, 'mail', 1, 1, 0, '[[regtime]]', NULL, 37);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_charts`
--

CREATE TABLE `[[dbprefix]]project_charts` (
  `object_id` int(10) unsigned NOT NULL,
  `type_id` int(10) unsigned DEFAULT NULL,
  `display_id` int(10) unsigned DEFAULT NULL,
  `show_in_project` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `show_in_parents` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_chart_params`
--

CREATE TABLE `[[dbprefix]]project_chart_params` (
  `id` int(10) unsigned NOT NULL,
  `chart_id` int(10) unsigned NOT NULL,
  `value` varchar(80) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`,`chart_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_co_types`
--

CREATE TABLE `[[dbprefix]]project_co_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `object_manager` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `created_by_id` int(10) unsigned NOT NULL,
  `created_on` datetime NOT NULL,
  `updated_by_id` int(10) unsigned NOT NULL,
  `updated_on` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `object_manager` (`object_manager`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_events`
--

CREATE TABLE `[[dbprefix]]project_events` (
  `object_id` int(10) unsigned NOT NULL,
  `start` datetime DEFAULT NULL,
  `duration` datetime DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `private` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `repeat_end` date DEFAULT NULL,
  `repeat_forever` tinyint(1) unsigned NOT NULL,
  `repeat_num` mediumint(9) NOT NULL DEFAULT '0',
  `repeat_d` smallint(6) NOT NULL DEFAULT '0',
  `repeat_m` smallint(6) NOT NULL DEFAULT '0',
  `repeat_y` smallint(6) NOT NULL DEFAULT '0',
  `repeat_h` smallint(6) NOT NULL DEFAULT '0',
  `repeat_dow` int(10) unsigned NOT NULL DEFAULT '0',
  `repeat_wnum` int(10) unsigned NOT NULL DEFAULT '0',
  `repeat_mjump` int(10) unsigned NOT NULL DEFAULT '0',
  `type_id` int(11) NOT NULL DEFAULT '0',
  `special_id` text COLLATE utf8_unicode_ci,
  `update_sync` datetime DEFAULT NULL,
  `ext_cal_id` int(10) unsigned NOT NULL,
  `original_event_id` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`object_id`),
  KEY `start` (`start`),
  KEY `repeat_h` (`repeat_h`),
  KEY `type_id` (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_files`
--

CREATE TABLE `[[dbprefix]]project_files` (
  `object_id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `is_locked` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_visible` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `expiration_time` datetime NOT NULL,
  `checked_out_on` datetime NOT NULL,
  `checked_out_by_id` int(10) unsigned DEFAULT '0',
  `was_auto_checked_out` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `type` int(1) NOT NULL DEFAULT '0',
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL DEFAULT '0',
  `attach_to_notification` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `default_subject` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_file_revisions`
--

CREATE TABLE `[[dbprefix]]project_file_revisions` (
  `object_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `file_id` int(10) unsigned NOT NULL DEFAULT '0',
  `file_type_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `repository_id` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `thumb_filename` varchar(44) COLLATE utf8_unicode_ci DEFAULT NULL,
  `revision_number` int(10) unsigned NOT NULL DEFAULT '0',
  `comment` text COLLATE utf8_unicode_ci,
  `type_string` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filesize` int(10) unsigned NOT NULL DEFAULT '0',
  `hash` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`object_id`),
  KEY `filesize` (`filesize`),
  KEY `file_id` USING BTREE (`file_id`,`revision_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_forms`
--

CREATE TABLE `[[dbprefix]]project_forms` (
  `object_id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `success_message` text COLLATE utf8_unicode_ci NOT NULL,
  `action` enum('add_comment','add_task') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'add_comment',
  `in_object_id` int(10) unsigned NOT NULL DEFAULT '0',
  `is_visible` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `order` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_messages`
--

CREATE TABLE `[[dbprefix]]project_messages` (
  `object_id` int(10) unsigned NOT NULL,
  `text` text COLLATE utf8_unicode_ci,
  `type_content` enum('text','html') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'text',
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_milestones`
--

CREATE TABLE `[[dbprefix]]project_milestones` (
  `object_id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `due_date` datetime NOT NULL,
  `is_urgent` tinyint(1) NOT NULL DEFAULT '0',
  `completed_on` datetime NOT NULL,
  `completed_by_id` int(10) unsigned DEFAULT NULL,
  `is_template` tinyint(1) NOT NULL DEFAULT '0',
  `from_template_id` int(10) NOT NULL DEFAULT '0',
  `from_template_object_id` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`object_id`),
  KEY `due_date` (`due_date`),
  KEY `completed_on` (`completed_on`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_tasks`
--

CREATE TABLE `[[dbprefix]]project_tasks` (
  `object_id` int(10) unsigned NOT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `parents_path` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `depth` int(2) unsigned NOT NULL DEFAULT '0',
  `text` text COLLATE utf8_unicode_ci,
  `due_date` datetime NOT NULL,
  `start_date` datetime NOT NULL,
  `assigned_to_contact_id` int(10) unsigned DEFAULT NULL,
  `assigned_on` datetime DEFAULT NULL,
  `assigned_by_id` int(10) unsigned DEFAULT NULL,
  `time_estimate` int(10) unsigned NOT NULL DEFAULT '0',
  `completed_on` datetime NOT NULL,
  `completed_by_id` int(10) unsigned DEFAULT NULL,
  `started_on` datetime DEFAULT NULL,
  `started_by_id` int(10) unsigned NOT NULL,
  `priority` int(10) unsigned DEFAULT '200',
  `state` int(10) unsigned DEFAULT NULL,
  `order` int(10) unsigned DEFAULT '0',
  `milestone_id` int(10) unsigned DEFAULT NULL,
  `is_template` tinyint(1) NOT NULL DEFAULT '0',
  `from_template_id` int(10) NOT NULL DEFAULT '0',
  `from_template_object_id` int(10) unsigned DEFAULT '0',
  `repeat_end` datetime NOT NULL,
  `repeat_forever` tinyint(1) NOT NULL,
  `repeat_num` int(10) unsigned NOT NULL DEFAULT '0',
  `repeat_d` int(10) unsigned NOT NULL,
  `repeat_m` int(10) unsigned NOT NULL,
  `repeat_y` int(10) unsigned NOT NULL,
  `repeat_by` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `object_subtype` int(10) unsigned NOT NULL DEFAULT '0',
  `percent_completed` int(10) unsigned NOT NULL DEFAULT '0',
  `use_due_time` tinyint(1) DEFAULT '0',
  `use_start_time` tinyint(1) DEFAULT '0',
  `original_task_id` int(10) unsigned DEFAULT '0',
  `instantiation_id` int(10) unsigned NOT NULL DEFAULT '0',
  `type_content` enum('text','html') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'text',
  `total_worked_time` int(10) unsigned NOT NULL DEFAULT '0',
  `remaining_time` int(10) NOT NULL DEFAULT '0',
  `mark_as_started` tinyint(1) NOT NULL DEFAULT '0',
  `move_direction_non_working_days` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'advance',
  `overall_worked_time_plus_subtasks` int(10) unsigned NOT NULL DEFAULT '0',
  `total_time_estimate` int(10) unsigned NOT NULL DEFAULT '0',
  `total_remaining_time` int(10) NOT NULL DEFAULT '0',
  `is_manual_percent_completed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`),
  KEY `parent_id` (`parent_id`),
  KEY `completed_on` (`completed_on`),
  KEY `order` (`order`),
  KEY `milestone_id` (`milestone_id`),
  KEY `priority` (`priority`),
  KEY `assigned_to` USING HASH (`assigned_to_contact_id`),
  KEY `total_worked_time` (`total_worked_time`),
  KEY `start_date` (`start_date`),
  KEY `due_date` (`due_date`),
  KEY `completed_by_id` (`completed_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_task_dependencies`
--

CREATE TABLE `[[dbprefix]]project_task_dependencies` (
  `previous_task_id` int(10) unsigned NOT NULL,
  `task_id` int(10) unsigned NOT NULL,
  `created_on` datetime NOT NULL,
  `created_by_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`previous_task_id`,`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]project_webpages`
--

CREATE TABLE `[[dbprefix]]project_webpages` (
  `object_id` int(10) unsigned NOT NULL,
  `url` text COLLATE utf8_unicode_ci,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queued_emails`
--

CREATE TABLE `[[dbprefix]]queued_emails` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `to` text COLLATE utf8_unicode_ci,
  `cc` text COLLATE utf8_unicode_ci,
  `bcc` text COLLATE utf8_unicode_ci,
  `from` text COLLATE utf8_unicode_ci,
  `subject` text COLLATE utf8_unicode_ci,
  `body` text COLLATE utf8_unicode_ci,
  `attachments` text COLLATE utf8_unicode_ci,
  `timestamp` datetime NOT NULL,
  `object_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]read_objects`
--

CREATE TABLE `[[dbprefix]]read_objects` (
  `rel_object_id` int(10) unsigned NOT NULL DEFAULT '0',
  `contact_id` int(10) unsigned NOT NULL DEFAULT '0',
  `is_read` int(1) NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL,
  PRIMARY KEY (`rel_object_id`,`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reports`
--

CREATE TABLE `[[dbprefix]]reports` (
  `object_id` int(10) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `report_object_type_id` int(10) unsigned NOT NULL,
  `order_by` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_order_by_asc` tinyint(1) NOT NULL,
  `ignore_context` tinyint(1) NOT NULL DEFAULT '1',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `function_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`object_id`),
  KEY `object_type` (`report_object_type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]reports`
--

INSERT INTO `[[dbprefix]]reports` VALUES
(3, 'task time report description', 17, '', 1, 1, 1, 'total_task_times_report', '?c=reporting&a=total_task_times_p');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]report_columns`
--

CREATE TABLE `[[dbprefix]]report_columns` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `report_id` int(10) NOT NULL,
  `custom_property_id` int(10) NOT NULL,
  `field_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]report_conditions`
--

CREATE TABLE `[[dbprefix]]report_conditions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `report_id` int(10) NOT NULL,
  `custom_property_id` int(10) NOT NULL,
  `field_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `condition` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `is_parametrizable` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role_object_type_permissions`
--

CREATE TABLE `[[dbprefix]]role_object_type_permissions` (
  `role_id` int(10) unsigned NOT NULL,
  `object_type_id` int(10) unsigned NOT NULL,
  `can_delete` tinyint(1) NOT NULL,
  `can_write` tinyint(1) NOT NULL,
  PRIMARY KEY (`role_id`,`object_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]role_object_type_permissions`
--

INSERT INTO `[[dbprefix]]role_object_type_permissions` VALUES
(1, 3, 1, 1),
(1, 4, 1, 1),
(1, 5, 1, 1),
(1, 6, 1, 1),
(1, 9, 1, 1),
(1, 10, 1, 1),
(1, 11, 1, 1),
(1, 15, 1, 1),
(1, 17, 1, 1),
(1, 22, 1, 1),
(2, 3, 1, 1),
(2, 4, 1, 1),
(2, 5, 1, 1),
(2, 6, 1, 1),
(2, 9, 1, 1),
(2, 10, 1, 1),
(2, 11, 1, 1),
(2, 15, 1, 1),
(2, 17, 1, 1),
(2, 22, 1, 1),
(3, 3, 1, 1),
(3, 4, 1, 1),
(3, 5, 1, 1),
(3, 6, 1, 1),
(3, 9, 1, 1),
(3, 10, 1, 1),
(3, 11, 1, 1),
(3, 15, 1, 1),
(3, 17, 1, 1),
(3, 22, 1, 1),
(4, 3, 0, 1),
(4, 4, 0, 1),
(4, 5, 0, 1),
(4, 6, 0, 1),
(4, 9, 0, 1),
(4, 10, 0, 1),
(4, 11, 0, 1),
(4, 15, 0, 1),
(4, 17, 0, 1),
(4, 22, 0, 1),
(5, 5, 0, 0),
(5, 6, 0, 1),
(5, 9, 0, 0),
(5, 10, 0, 0),
(5, 11, 0, 0),
(5, 15, 0, 0),
(5, 17, 0, 1),
(6, 5, 0, 0),
(6, 6, 0, 1),
(6, 9, 0, 0),
(6, 10, 0, 0),
(6, 11, 0, 0),
(6, 15, 0, 0),
(6, 17, 0, 1),
(7, 5, 0, 0),
(7, 6, 0, 0),
(7, 9, 0, 0),
(7, 17, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]searchable_objects`
--

CREATE TABLE `[[dbprefix]]searchable_objects` (
  `rel_object_id` int(10) unsigned NOT NULL DEFAULT '0',
  `column_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8_unicode_ci NOT NULL,
  `contact_id` int(10) unsigned NOT NULL DEFAULT '0',
  `assoc_member_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`rel_object_id`,`column_name`),
  KEY `assoc_member_id` (`assoc_member_id`),
  KEY `rel_obj_id` (`rel_object_id`),
  FULLTEXT KEY `content` (`content`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]searchable_objects`
--

INSERT INTO `[[dbprefix]]searchable_objects` VALUES
(1, 'first_name', '[[site_name]]', 0, 0),
(1, 'name', '[[site_name]]', 0, 0),
(1, 'object_id', '1', 0, 0),
(2, 'email_addres0', '[[admin_email]]', 0, 0),
(2, 'first_name', '[[admin_username]]', 0, 0),
(2, 'name', '[[admin_username]]', 0, 0),
(2, 'object_id', '2', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sent_notifications`
--

CREATE TABLE `[[dbprefix]]sent_notifications` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `queued_email_id` int(10) NOT NULL DEFAULT '0',
  `sent_date` datetime NOT NULL,
  `to` text COLLATE utf8_unicode_ci,
  `cc` text COLLATE utf8_unicode_ci,
  `bcc` text COLLATE utf8_unicode_ci,
  `from` text COLLATE utf8_unicode_ci,
  `subject` text COLLATE utf8_unicode_ci,
  `body` text COLLATE utf8_unicode_ci,
  `attachments` text COLLATE utf8_unicode_ci,
  `timestamp` datetime NOT NULL,
  `object_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sharing_table`
--

CREATE TABLE `[[dbprefix]]sharing_table` (
  `group_id` int(10) unsigned NOT NULL,
  `object_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`group_id`,`object_id`),
  KEY `object_id` (`object_id`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sharing_table_flags`
--

CREATE TABLE `[[dbprefix]]sharing_table_flags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `permission_group_id` int(10) unsigned NOT NULL,
  `member_id` int(10) unsigned NOT NULL,
  `object_id` int(10) unsigned NOT NULL,
  `execution_date` datetime NOT NULL,
  `permission_string` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `created_by_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]specific_permissions`
--

CREATE TABLE `[[dbprefix]]specific_permissions` (
  `permission_group_id` int(10) unsigned NOT NULL,
  `can_change_project_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_revert_project_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_assign_supervisor` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_extend_quota` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_permissions`
--

CREATE TABLE `[[dbprefix]]system_permissions` (
  `permission_group_id` int(10) unsigned NOT NULL,
  `can_manage_security` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_configuration` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_templates` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_time` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_add_mail_accounts` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_dimensions` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_dimension_members` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_tasks` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_task_assignee` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_billing` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_view_billing` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_see_assigned_to_other_tasks` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `can_see_others_timeslots` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `can_manage_contacts` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_update_other_users_invitations` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_link_objects` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_instantiate_templates` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_manage_repetitive_properties_of_tasks` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `can_reopen_task` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]system_permissions`
--

INSERT INTO `[[dbprefix]]system_permissions` VALUES
(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
(2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1),
(3, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1),
(4, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1),
(5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(6, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(7, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0),
(14, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tab_panels`
--

CREATE TABLE `[[dbprefix]]tab_panels` (
  `id` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `icon_cls` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `refresh_on_context_change` tinyint(1) NOT NULL,
  `default_controller` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `default_action` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `initial_controller` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `initial_action` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `type` enum('system','plugin') COLLATE utf8_unicode_ci NOT NULL,
  `ordering` int(10) NOT NULL,
  `plugin_id` int(10) unsigned NOT NULL DEFAULT '0',
  `object_type_id` int(10) unsigned NOT NULL DEFAULT '0',
  `url_params` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `enabled` (`enabled`,`type`,`plugin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]tab_panels`
--

INSERT INTO `[[dbprefix]]tab_panels` VALUES
('calendar-panel', 'calendar', 'ico-calendar', 1, 'event', 'view_calendar', '', '', 0, 'system', 7, 0, 10, ''),
('contacts-panel', 'contacts', 'ico-contacts', 1, 'contact', 'init', '', '', 0, 'system', 4, 0, 15, ''),
('documents-panel', 'documents', 'ico-documents', 1, 'files', 'init', '', '', 1, 'system', 3, 0, 6, ''),
('mails-panel', 'email tab', 'ico-mails', 1, 'mail', 'init', '', '', 1, 'system', 12, 4, 22, ''),
('messages-panel', 'messages', 'ico-messages', 1, 'message', 'init', '', '', 0, 'system', 10, 0, 3, ''),
('more-panel', 'getting started', 'ico-more-tab', 0, 'more', 'index', '', '', 1, 'system', 100, 0, 0, ''),
('overview-panel', 'overview', 'ico-overview', 1, 'dashboard', 'main_dashboard', 'dashboard', 'main_dashboard', 1, 'system', 1, 0, 0, ''),
('reporting-panel', 'reporting', 'ico-reporting', 1, 'reporting', 'index', '', '', 1, 'system', 8, 0, 11, ''),
('tags-panel', 'tags', 'ico-tags', 1, 'member', 'init', '', '', 0, 'system', 20, 3, 2, '{"dim_id":3, "type_id":2}'),
('tasks-panel', 'tasks', 'ico-tasks', 1, 'task', 'new_list_tasks', '', '', 1, 'system', 2, 0, 5, ''),
('time-panel', 'time', 'ico-time-layout', 1, 'time', 'index', '', '', 1, 'system', 5, 0, 0, ''),
('webpages-panel', 'web pages', 'ico-webpages', 1, 'webpage', 'init', '', '', 0, 'system', 9, 0, 4, ''),
('workspaces-panel', 'workspaces', 'ico-workspaces', 1, 'member', 'init', '', '', 0, 'system', 20, 3, 1, '{"dim_id":2, "type_id":1}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tab_panel_permissions`
--

CREATE TABLE `[[dbprefix]]tab_panel_permissions` (
  `permission_group_id` int(10) unsigned NOT NULL,
  `tab_panel_id` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`permission_group_id`,`tab_panel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]tab_panel_permissions`
--

INSERT INTO `[[dbprefix]]tab_panel_permissions` VALUES
(1, 'calendar-panel'),
(1, 'contacts-panel'),
(1, 'documents-panel'),
(1, 'mails-panel'),
(1, 'messages-panel'),
(1, 'more-panel'),
(1, 'overview-panel'),
(1, 'reporting-panel'),
(1, 'tags-panel'),
(1, 'tasks-panel'),
(1, 'time-panel'),
(1, 'webpages-panel'),
(1, 'workspaces-panel'),
(2, 'calendar-panel'),
(2, 'contacts-panel'),
(2, 'documents-panel'),
(2, 'mails-panel'),
(2, 'messages-panel'),
(2, 'more-panel'),
(2, 'overview-panel'),
(2, 'reporting-panel'),
(2, 'tags-panel'),
(2, 'tasks-panel'),
(2, 'time-panel'),
(2, 'webpages-panel'),
(2, 'workspaces-panel'),
(3, 'calendar-panel'),
(3, 'contacts-panel'),
(3, 'documents-panel'),
(3, 'mails-panel'),
(3, 'messages-panel'),
(3, 'more-panel'),
(3, 'overview-panel'),
(3, 'reporting-panel'),
(3, 'tags-panel'),
(3, 'tasks-panel'),
(3, 'time-panel'),
(3, 'webpages-panel'),
(3, 'workspaces-panel'),
(4, 'calendar-panel'),
(4, 'contacts-panel'),
(4, 'documents-panel'),
(4, 'mails-panel'),
(4, 'messages-panel'),
(4, 'more-panel'),
(4, 'overview-panel'),
(4, 'reporting-panel'),
(4, 'tags-panel'),
(4, 'tasks-panel'),
(4, 'time-panel'),
(4, 'webpages-panel'),
(4, 'workspaces-panel'),
(5, 'calendar-panel'),
(5, 'contacts-panel'),
(5, 'documents-panel'),
(5, 'messages-panel'),
(5, 'more-panel'),
(5, 'overview-panel'),
(5, 'reporting-panel'),
(5, 'tasks-panel'),
(5, 'time-panel'),
(5, 'webpages-panel'),
(6, 'calendar-panel'),
(6, 'documents-panel'),
(6, 'messages-panel'),
(6, 'more-panel'),
(6, 'overview-panel'),
(6, 'tasks-panel'),
(6, 'time-panel'),
(6, 'webpages-panel'),
(7, 'calendar-panel'),
(7, 'documents-panel'),
(7, 'messages-panel'),
(7, 'more-panel'),
(7, 'overview-panel'),
(7, 'tasks-panel'),
(7, 'time-panel'),
(7, 'webpages-panel'),
(11, 'calendar-panel'),
(11, 'documents-panel'),
(11, 'messages-panel'),
(11, 'overview-panel'),
(11, 'webpages-panel'),
(12, 'calendar-panel'),
(12, 'messages-panel'),
(12, 'overview-panel'),
(12, 'webpages-panel'),
(13, 'calendar-panel'),
(13, 'contacts-panel'),
(13, 'documents-panel'),
(13, 'messages-panel'),
(13, 'more-panel'),
(13, 'overview-panel'),
(13, 'reporting-panel'),
(13, 'tasks-panel'),
(13, 'time-panel'),
(13, 'webpages-panel'),
(14, 'calendar-panel'),
(14, 'contacts-panel'),
(14, 'documents-panel'),
(14, 'mails-panel'),
(14, 'messages-panel'),
(14, 'more-panel'),
(14, 'overview-panel'),
(14, 'reporting-panel'),
(14, 'tags-panel'),
(14, 'tasks-panel'),
(14, 'time-panel'),
(14, 'webpages-panel'),
(14, 'workspaces-panel');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]telephone_types`
--

CREATE TABLE `[[dbprefix]]telephone_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_system` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]telephone_types`
--

INSERT INTO `[[dbprefix]]telephone_types` VALUES
(1, 'home', 1),
(2, 'work', 1),
(3, 'other', 1),
(4, 'assistant', 0),
(5, 'callback', 0),
(6, 'mobile', 1),
(7, 'pager', 0),
(8, 'fax', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]templates`
--

CREATE TABLE `[[dbprefix]]templates` (
  `object_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8_unicode_ci,
  `can_instance_from_mail` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]template_instantiated_parameters`
--

CREATE TABLE `[[dbprefix]]template_instantiated_parameters` (
  `template_id` int(10) unsigned NOT NULL,
  `instantiation_id` int(10) unsigned NOT NULL,
  `parameter_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`template_id`,`instantiation_id`,`parameter_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]template_milestones`
--

CREATE TABLE `[[dbprefix]]template_milestones` (
  `template_id` int(10) unsigned DEFAULT NULL,
  `session_id` int(10) DEFAULT NULL,
  `object_id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `due_date` datetime NOT NULL,
  `is_urgent` tinyint(1) NOT NULL DEFAULT '0',
  `completed_on` datetime NOT NULL,
  `completed_by_id` int(10) unsigned DEFAULT NULL,
  `is_template` tinyint(1) NOT NULL DEFAULT '0',
  `from_template_id` int(10) NOT NULL DEFAULT '0',
  `from_template_object_id` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`object_id`),
  KEY `due_date` (`due_date`),
  KEY `completed_on` (`completed_on`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]template_objects`
--

CREATE TABLE `[[dbprefix]]template_objects` (
  `template_id` int(10) unsigned NOT NULL DEFAULT '0',
  `object_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_id` int(10) unsigned DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`template_id`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]template_object_properties`
--

CREATE TABLE `[[dbprefix]]template_object_properties` (
  `template_id` int(10) NOT NULL,
  `object_id` int(10) NOT NULL,
  `property` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`template_id`,`object_id`,`property`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]template_parameters`
--

CREATE TABLE `[[dbprefix]]template_parameters` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `template_id` int(10) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `default_value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]template_tasks`
--

CREATE TABLE `[[dbprefix]]template_tasks` (
  `template_id` int(10) unsigned DEFAULT NULL,
  `session_id` int(10) DEFAULT NULL,
  `object_id` int(10) unsigned NOT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `parents_path` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `depth` int(2) unsigned NOT NULL DEFAULT '0',
  `text` text COLLATE utf8_unicode_ci,
  `due_date` datetime NOT NULL,
  `start_date` datetime NOT NULL,
  `assigned_to_contact_id` int(10) unsigned DEFAULT NULL,
  `assigned_on` datetime DEFAULT NULL,
  `assigned_by_id` int(10) unsigned DEFAULT NULL,
  `time_estimate` int(10) unsigned NOT NULL DEFAULT '0',
  `completed_on` datetime NOT NULL,
  `completed_by_id` int(10) unsigned DEFAULT NULL,
  `started_on` datetime DEFAULT NULL,
  `started_by_id` int(10) unsigned NOT NULL,
  `priority` int(10) unsigned DEFAULT '200',
  `state` int(10) unsigned DEFAULT NULL,
  `order` int(10) unsigned DEFAULT '0',
  `milestone_id` int(10) unsigned DEFAULT NULL,
  `is_template` tinyint(1) NOT NULL DEFAULT '0',
  `from_template_id` int(10) NOT NULL DEFAULT '0',
  `from_template_object_id` int(10) unsigned DEFAULT '0',
  `repeat_end` datetime NOT NULL,
  `repeat_forever` tinyint(1) NOT NULL,
  `repeat_num` int(10) unsigned NOT NULL DEFAULT '0',
  `repeat_d` int(10) unsigned NOT NULL,
  `repeat_m` int(10) unsigned NOT NULL,
  `repeat_y` int(10) unsigned NOT NULL,
  `repeat_by` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `object_subtype` int(10) unsigned NOT NULL DEFAULT '0',
  `percent_completed` int(10) unsigned NOT NULL DEFAULT '0',
  `use_due_time` tinyint(1) DEFAULT '0',
  `use_start_time` tinyint(1) DEFAULT '0',
  `original_task_id` int(10) unsigned DEFAULT '0',
  `type_content` enum('text','html') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'text',
  `is_manual_percent_completed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`),
  KEY `parent_id` (`parent_id`),
  KEY `completed_on` (`completed_on`),
  KEY `order` (`order`),
  KEY `milestone_id` (`milestone_id`),
  KEY `priority` (`priority`),
  KEY `assigned_to` USING HASH (`assigned_to_contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]timeslots`
--

CREATE TABLE `[[dbprefix]]timeslots` (
  `object_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rel_object_id` int(10) unsigned NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `paused_on` datetime NOT NULL,
  `subtract` int(10) unsigned NOT NULL DEFAULT '0',
  `fixed_billing` decimal(20,3) NOT NULL DEFAULT '0.000',
  `hourly_billing` decimal(20,3) NOT NULL DEFAULT '0.000',
  `is_fixed_billing` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `rate_currency_id` int(10) unsigned NOT NULL DEFAULT '0',
  `billing_id` int(10) unsigned NOT NULL DEFAULT '0',
  `worked_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`),
  KEY `rel_obj_id` USING BTREE (`rel_object_id`),
  KEY `end_time` (`end_time`),
  KEY `contact_end` (`contact_id`,`end_time`),
  KEY `contact_start` (`contact_id`,`start_time`),
  KEY `start_time` (`start_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]timezones`
--

CREATE TABLE `[[dbprefix]]timezones` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `country_code` char(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `has_dst` tinyint(1) NOT NULL DEFAULT '0',
  `gmt_offset` int(10) NOT NULL DEFAULT '0',
  `gmt_dst_offset` int(10) NOT NULL DEFAULT '0',
  `using_dst` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_country_code` (`country_code`),
  KEY `idx_zone_name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=422 ;

--
-- Dumping data for table `[[dbprefix]]timezones`
--

INSERT INTO `[[dbprefix]]timezones` VALUES
(1, 'AD', 'Europe/Andorra', 1, 3600, 7200, 0),
(2, 'AE', 'Asia/Dubai', 0, 14400, 14400, 0),
(3, 'AF', 'Asia/Kabul', 0, 16200, 16200, 0),
(4, 'AG', 'America/Antigua', 0, -14400, -14400, 0),
(5, 'AI', 'America/Anguilla', 0, -14400, -14400, 0),
(6, 'AL', 'Europe/Tirane', 1, 3600, 7200, 0),
(7, 'AM', 'Asia/Yerevan', 0, 14400, 18000, 0),
(8, 'AO', 'Africa/Luanda', 0, 3600, 3600, 0),
(9, 'AQ', 'Antarctica/McMurdo', 1, 43200, 46800, 1),
(10, 'AQ', 'Antarctica/Casey', 0, 28800, 28800, 0),
(11, 'AQ', 'Antarctica/Davis', 0, 25200, 25200, 0),
(12, 'AQ', 'Antarctica/DumontDUrville', 0, 36000, 36000, 0),
(13, 'AQ', 'Antarctica/Mawson', 0, 18000, 18000, 0),
(14, 'AQ', 'Antarctica/Palmer', 1, -14400, -10800, 1),
(15, 'AQ', 'Antarctica/Rothera', 0, -10800, -10800, 0),
(16, 'AQ', 'Antarctica/Syowa', 0, 10800, 10800, 0),
(17, 'AQ', 'Antarctica/Troll', 0, 0, 7200, 0),
(18, 'AQ', 'Antarctica/Vostok', 0, 21600, 21600, 0),
(19, 'AR', 'America/Argentina/Buenos_Aires', 0, -10800, -7200, 0),
(20, 'AR', 'America/Argentina/Cordoba', 0, -10800, -7200, 0),
(21, 'AR', 'America/Argentina/Salta', 0, -10800, -7200, 0),
(22, 'AR', 'America/Argentina/Jujuy', 0, -10800, -7200, 0),
(23, 'AR', 'America/Argentina/Tucuman', 0, -10800, -7200, 0),
(24, 'AR', 'America/Argentina/Catamarca', 0, -10800, -7200, 0),
(25, 'AR', 'America/Argentina/La_Rioja', 0, -10800, -7200, 0),
(26, 'AR', 'America/Argentina/San_Juan', 0, -10800, -7200, 0),
(27, 'AR', 'America/Argentina/Mendoza', 0, -10800, -7200, 0),
(28, 'AR', 'America/Argentina/San_Luis', 0, -10800, -10800, 0),
(29, 'AR', 'America/Argentina/Rio_Gallegos', 0, -10800, -7200, 0),
(30, 'AR', 'America/Argentina/Ushuaia', 0, -10800, -7200, 0),
(31, 'AS', 'Pacific/Pago_Pago', 0, -39600, -39600, 0),
(32, 'AT', 'Europe/Vienna', 1, 3600, 7200, 0),
(33, 'AU', 'Australia/Lord_Howe', 1, 37800, 39600, 1),
(34, 'AU', 'Antarctica/Macquarie', 0, 39600, 39600, 0),
(35, 'AU', 'Australia/Hobart', 1, 36000, 39600, 1),
(36, 'AU', 'Australia/Currie', 1, 36000, 39600, 1),
(37, 'AU', 'Australia/Melbourne', 1, 36000, 39600, 1),
(38, 'AU', 'Australia/Sydney', 1, 36000, 39600, 1),
(39, 'AU', 'Australia/Broken_Hill', 1, 34200, 37800, 1),
(40, 'AU', 'Australia/Brisbane', 0, 36000, 39600, 0),
(41, 'AU', 'Australia/Lindeman', 0, 36000, 39600, 0),
(42, 'AU', 'Australia/Adelaide', 1, 34200, 37800, 1),
(43, 'AU', 'Australia/Darwin', 0, 34200, 37800, 0),
(44, 'AU', 'Australia/Perth', 0, 28800, 32400, 0),
(45, 'AU', 'Australia/Eucla', 0, 31500, 35100, 0),
(46, 'AW', 'America/Aruba', 0, -14400, -14400, 0),
(47, 'AX', 'Europe/Mariehamn', 1, 7200, 10800, 0),
(48, 'AZ', 'Asia/Baku', 1, 14400, 18000, 0),
(49, 'BA', 'Europe/Sarajevo', 1, 3600, 7200, 0),
(50, 'BB', 'America/Barbados', 0, -14400, -10800, 0),
(51, 'BD', 'Asia/Dhaka', 0, 21600, 25200, 0),
(52, 'BE', 'Europe/Brussels', 1, 3600, 7200, 0),
(53, 'BF', 'Africa/Ouagadougou', 0, 0, 0, 0),
(54, 'BG', 'Europe/Sofia', 1, 7200, 10800, 0),
(55, 'BH', 'Asia/Bahrain', 0, 10800, 10800, 0),
(56, 'BI', 'Africa/Bujumbura', 0, 7200, 7200, 0),
(57, 'BJ', 'Africa/Porto-Novo', 0, 3600, 3600, 0),
(58, 'BL', 'America/St_Barthelemy', 0, -14400, -14400, 0),
(59, 'BM', 'Atlantic/Bermuda', 1, -14400, -10800, 0),
(60, 'BN', 'Asia/Brunei', 0, 28800, 28800, 0),
(61, 'BO', 'America/La_Paz', 0, -14400, -12756, 0),
(62, 'BQ', 'America/Kralendijk', 0, -14400, -14400, 0),
(63, 'BR', 'America/Noronha', 0, -7200, -3600, 0),
(64, 'BR', 'America/Belem', 0, -10800, -7200, 0),
(65, 'BR', 'America/Fortaleza', 0, -10800, -7200, 0),
(66, 'BR', 'America/Recife', 0, -10800, -7200, 0),
(67, 'BR', 'America/Araguaina', 1, -10800, -7200, 0),
(68, 'BR', 'America/Maceio', 0, -10800, -7200, 0),
(69, 'BR', 'America/Bahia', 0, -10800, -7200, 0),
(70, 'BR', 'America/Sao_Paulo', 1, -10800, -7200, 1),
(71, 'BR', 'America/Campo_Grande', 1, -14400, -10800, 1),
(72, 'BR', 'America/Cuiaba', 1, -14400, -10800, 1),
(73, 'BR', 'America/Santarem', 0, -10800, -10800, 0),
(74, 'BR', 'America/Porto_Velho', 0, -14400, -10800, 0),
(75, 'BR', 'America/Boa_Vista', 0, -14400, -10800, 0),
(76, 'BR', 'America/Manaus', 0, -14400, -10800, 0),
(77, 'BR', 'America/Eirunepe', 0, -18000, -14400, 0),
(78, 'BR', 'America/Rio_Branco', 0, -18000, -14400, 0),
(79, 'BS', 'America/Nassau', 1, -18000, -14400, 0),
(80, 'BT', 'Asia/Thimphu', 0, 21600, 21600, 0),
(81, 'BW', 'Africa/Gaborone', 0, 7200, 7200, 0),
(82, 'BY', 'Europe/Minsk', 0, 10800, 10800, 0),
(83, 'BZ', 'America/Belize', 0, -21600, -18000, 0),
(84, 'CA', 'America/St_Johns', 1, -12600, -9000, 0),
(85, 'CA', 'America/Halifax', 1, -14400, -10800, 0),
(86, 'CA', 'America/Glace_Bay', 1, -14400, -10800, 0),
(87, 'CA', 'America/Moncton', 1, -14400, -10800, 0),
(88, 'CA', 'America/Goose_Bay', 1, -14400, -10800, 0),
(89, 'CA', 'America/Blanc-Sablon', 0, -14400, -10800, 0),
(90, 'CA', 'America/Toronto', 1, -18000, -14400, 0),
(91, 'CA', 'America/Nipigon', 1, -18000, -14400, 0),
(92, 'CA', 'America/Thunder_Bay', 1, -18000, -14400, 0),
(93, 'CA', 'America/Iqaluit', 1, -18000, -14400, 0),
(94, 'CA', 'America/Pangnirtung', 1, -18000, -14400, 0),
(95, 'CA', 'America/Atikokan', 0, -18000, -18000, 0),
(96, 'CA', 'America/Winnipeg', 1, -21600, -18000, 0),
(97, 'CA', 'America/Rainy_River', 1, -21600, -18000, 0),
(98, 'CA', 'America/Resolute', 1, -21600, -18000, 0),
(99, 'CA', 'America/Rankin_Inlet', 1, -21600, -18000, 0),
(100, 'CA', 'America/Regina', 0, -21600, -21600, 0),
(101, 'CA', 'America/Swift_Current', 0, -21600, -21600, 0),
(102, 'CA', 'America/Edmonton', 1, -25200, -21600, 0),
(103, 'CA', 'America/Cambridge_Bay', 1, -25200, -21600, 0),
(104, 'CA', 'America/Yellowknife', 1, -25200, -21600, 0),
(105, 'CA', 'America/Inuvik', 1, -25200, -21600, 0),
(106, 'CA', 'America/Creston', 0, -25200, -25200, 0),
(107, 'CA', 'America/Dawson_Creek', 0, -25200, -25200, 0),
(108, 'CA', 'America/Fort_Nelson', 1, -25200, -25200, 0),
(109, 'CA', 'America/Vancouver', 1, -28800, -25200, 0),
(110, 'CA', 'America/Whitehorse', 1, -28800, -25200, 0),
(111, 'CA', 'America/Dawson', 1, -28800, -25200, 0),
(112, 'CC', 'Indian/Cocos', 0, 23400, 23400, 0),
(113, 'CD', 'Africa/Kinshasa', 0, 3600, 3600, 0),
(114, 'CD', 'Africa/Lubumbashi', 0, 7200, 7200, 0),
(115, 'CF', 'Africa/Bangui', 0, 3600, 3600, 0),
(116, 'CG', 'Africa/Brazzaville', 0, 3600, 3600, 0),
(117, 'CH', 'Europe/Zurich', 1, 3600, 7200, 0),
(118, 'CI', 'Africa/Abidjan', 0, 0, 0, 0),
(119, 'CK', 'Pacific/Rarotonga', 0, -36000, -34200, 0),
(120, 'CL', 'America/Santiago', 1, -14400, -10800, 1),
(121, 'CL', 'Pacific/Easter', 1, -21600, -18000, 1),
(122, 'CM', 'Africa/Douala', 0, 3600, 3600, 0),
(123, 'CN', 'Asia/Shanghai', 0, 28800, 32400, 0),
(124, 'CN', 'Asia/Urumqi', 0, 21600, 21600, 0),
(125, 'CO', 'America/Bogota', 0, -18000, -14400, 0),
(126, 'CR', 'America/Costa_Rica', 0, -21600, -18000, 0),
(127, 'CU', 'America/Havana', 1, -18000, -14400, 0),
(128, 'CV', 'Atlantic/Cape_Verde', 0, -3600, -3600, 0),
(129, 'CW', 'America/Curacao', 0, -14400, -14400, 0),
(130, 'CX', 'Indian/Christmas', 0, 25200, 25200, 0),
(131, 'CY', 'Asia/Nicosia', 1, 7200, 10800, 0),
(132, 'CZ', 'Europe/Prague', 1, 3600, 7200, 0),
(133, 'DE', 'Europe/Berlin', 1, 3600, 7200, 0),
(134, 'DE', 'Europe/Busingen', 1, 3600, 7200, 0),
(135, 'DJ', 'Africa/Djibouti', 0, 10800, 10800, 0),
(136, 'DK', 'Europe/Copenhagen', 1, 3600, 7200, 0),
(137, 'DM', 'America/Dominica', 0, -14400, -14400, 0),
(138, 'DO', 'America/Santo_Domingo', 0, -14400, -16200, 0),
(139, 'DZ', 'Africa/Algiers', 0, 3600, 3600, 0),
(140, 'EC', 'America/Guayaquil', 0, -18000, -18000, 0),
(141, 'EC', 'Pacific/Galapagos', 0, -21600, -21600, 0),
(142, 'EE', 'Europe/Tallinn', 1, 7200, 10800, 0),
(143, 'EG', 'Africa/Cairo', 1, 7200, 10800, 0),
(144, 'EH', 'Africa/El_Aaiun', 1, 0, 3600, 0),
(145, 'ER', 'Africa/Asmara', 0, 10800, 10800, 0),
(146, 'ES', 'Europe/Madrid', 1, 3600, 7200, 0),
(147, 'ES', 'Africa/Ceuta', 1, 3600, 7200, 0),
(148, 'ES', 'Atlantic/Canary', 1, 0, 3600, 0),
(149, 'ET', 'Africa/Addis_Ababa', 0, 10800, 10800, 0),
(150, 'FI', 'Europe/Helsinki', 1, 7200, 10800, 0),
(151, 'FJ', 'Pacific/Fiji', 1, 43200, 46800, 1),
(152, 'FK', 'Atlantic/Stanley', 0, -10800, -10800, 0),
(153, 'FM', 'Pacific/Chuuk', 0, 36000, 36000, 0),
(154, 'FM', 'Pacific/Pohnpei', 0, 39600, 39600, 0),
(155, 'FM', 'Pacific/Kosrae', 0, 39600, 39600, 0),
(156, 'FO', 'Atlantic/Faroe', 1, 0, 3600, 0),
(157, 'FR', 'Europe/Paris', 1, 3600, 7200, 0),
(158, 'GA', 'Africa/Libreville', 0, 3600, 3600, 0),
(159, 'GB', 'Europe/London', 1, 0, 3600, 1),
(160, 'GD', 'America/Grenada', 0, -14400, -14400, 0),
(161, 'GE', 'Asia/Tbilisi', 0, 14400, 14400, 0),
(162, 'GF', 'America/Cayenne', 0, -10800, -10800, 0),
(163, 'GG', 'Europe/Guernsey', 1, 0, 3600, 0),
(164, 'GH', 'Africa/Accra', 0, 0, 1200, 0),
(165, 'GI', 'Europe/Gibraltar', 1, 3600, 7200, 0),
(166, 'GL', 'America/Godthab', 1, -10800, -7200, 0),
(167, 'GL', 'America/Danmarkshavn', 0, 0, -7200, 0),
(168, 'GL', 'America/Scoresbysund', 1, -3600, 0, 0),
(169, 'GL', 'America/Thule', 1, -14400, -10800, 0),
(170, 'GM', 'Africa/Banjul', 0, 0, 0, 0),
(171, 'GN', 'Africa/Conakry', 0, 0, 0, 0),
(172, 'GP', 'America/Guadeloupe', 0, -14400, -14400, 0),
(173, 'GQ', 'Africa/Malabo', 0, 3600, 3600, 0),
(174, 'GR', 'Europe/Athens', 1, 7200, 10800, 0),
(175, 'GS', 'Atlantic/South_Georgia', 0, -7200, -7200, 0),
(176, 'GT', 'America/Guatemala', 0, -21600, -18000, 0),
(177, 'GU', 'Pacific/Guam', 0, 36000, 36000, 0),
(178, 'GW', 'Africa/Bissau', 0, 0, 0, 0),
(179, 'GY', 'America/Guyana', 0, -14400, -14400, 0),
(180, 'HK', 'Asia/Hong_Kong', 0, 28800, 32400, 0),
(181, 'HN', 'America/Tegucigalpa', 0, -21600, -18000, 0),
(182, 'HR', 'Europe/Zagreb', 1, 3600, 7200, 0),
(183, 'HT', 'America/Port-au-Prince', 1, -18000, -14400, 0),
(184, 'HU', 'Europe/Budapest', 1, 3600, 7200, 0),
(185, 'ID', 'Asia/Jakarta', 0, 25200, 25200, 0),
(186, 'ID', 'Asia/Pontianak', 0, 25200, 25200, 0),
(187, 'ID', 'Asia/Makassar', 0, 28800, 28800, 0),
(188, 'ID', 'Asia/Jayapura', 0, 32400, 32400, 0),
(189, 'IE', 'Europe/Dublin', 1, 0, 3600, 0),
(190, 'IL', 'Asia/Jerusalem', 1, 7200, 10800, 0),
(191, 'IM', 'Europe/Isle_of_Man', 1, 0, 3600, 0),
(192, 'IN', 'Asia/Kolkata', 0, 19800, 23400, 0),
(193, 'IO', 'Indian/Chagos', 0, 21600, 21600, 0),
(194, 'IQ', 'Asia/Baghdad', 0, 10800, 14400, 0),
(195, 'IR', 'Asia/Tehran', 1, 12600, 16200, 0),
(196, 'IS', 'Atlantic/Reykjavik', 0, 0, 0, 0),
(197, 'IT', 'Europe/Rome', 1, 3600, 7200, 0),
(198, 'JE', 'Europe/Jersey', 1, 0, 3600, 0),
(199, 'JM', 'America/Jamaica', 0, -18000, -14400, 0),
(200, 'JO', 'Asia/Amman', 1, 7200, 10800, 0),
(201, 'JP', 'Asia/Tokyo', 0, 32400, 36000, 0),
(202, 'KE', 'Africa/Nairobi', 0, 10800, 10800, 0),
(203, 'KG', 'Asia/Bishkek', 0, 18000, 21600, 0),
(204, 'KH', 'Asia/Phnom_Penh', 0, 25200, 25200, 0),
(205, 'KI', 'Pacific/Tarawa', 0, 43200, 43200, 0),
(206, 'KI', 'Pacific/Enderbury', 0, 46800, 46800, 0),
(207, 'KI', 'Pacific/Kiritimati', 0, 50400, 50400, 0),
(208, 'KM', 'Indian/Comoro', 0, 10800, 10800, 0),
(209, 'KN', 'America/St_Kitts', 0, -14400, -14400, 0),
(210, 'KP', 'Asia/Pyongyang', 0, 30600, 30600, 0),
(211, 'KR', 'Asia/Seoul', 0, 32400, 36000, 0),
(212, 'KW', 'Asia/Kuwait', 0, 10800, 10800, 0),
(213, 'KY', 'America/Cayman', 0, -18000, -18000, 0),
(214, 'KZ', 'Asia/Almaty', 0, 21600, 25200, 0),
(215, 'KZ', 'Asia/Qyzylorda', 0, 18000, 21600, 0),
(216, 'KZ', 'Asia/Aqtobe', 0, 18000, 21600, 0),
(217, 'KZ', 'Asia/Aqtau', 0, 14400, 18000, 0),
(218, 'KZ', 'Asia/Oral', 0, 14400, 18000, 0),
(219, 'LA', 'Asia/Vientiane', 0, 25200, 25200, 0),
(220, 'LB', 'Asia/Beirut', 1, 7200, 10800, 0),
(221, 'LC', 'America/St_Lucia', 0, -14400, -14400, 0),
(222, 'LI', 'Europe/Vaduz', 1, 3600, 7200, 0),
(223, 'LK', 'Asia/Colombo', 0, 19800, 23400, 0),
(224, 'LR', 'Africa/Monrovia', 0, 0, 0, 0),
(225, 'LS', 'Africa/Maseru', 0, 7200, 10800, 0),
(226, 'LT', 'Europe/Vilnius', 1, 7200, 10800, 0),
(227, 'LU', 'Europe/Luxembourg', 1, 3600, 7200, 0),
(228, 'LV', 'Europe/Riga', 1, 7200, 10800, 0),
(229, 'LY', 'Africa/Tripoli', 1, 7200, 7200, 0),
(230, 'MA', 'Africa/Casablanca', 1, 0, 3600, 0),
(231, 'MC', 'Europe/Monaco', 1, 3600, 7200, 0),
(232, 'MD', 'Europe/Chisinau', 1, 7200, 10800, 0),
(233, 'ME', 'Europe/Podgorica', 1, 3600, 7200, 0),
(234, 'MF', 'America/Marigot', 0, -14400, -14400, 0),
(235, 'MG', 'Indian/Antananarivo', 0, 10800, 10800, 0),
(236, 'MH', 'Pacific/Majuro', 0, 43200, 43200, 0),
(237, 'MH', 'Pacific/Kwajalein', 0, 43200, 43200, 0),
(238, 'MK', 'Europe/Skopje', 1, 3600, 7200, 0),
(239, 'ML', 'Africa/Bamako', 0, 0, 0, 0),
(240, 'MM', 'Asia/Yangon', 0, 23400, 23400, 0),
(241, 'MN', 'Asia/Ulaanbaatar', 1, 28800, 32400, 0),
(242, 'MN', 'Asia/Hovd', 1, 25200, 28800, 0),
(243, 'MN', 'Asia/Choibalsan', 1, 28800, 32400, 0),
(244, 'MO', 'Asia/Macau', 0, 28800, 32400, 0),
(245, 'MP', 'Pacific/Saipan', 0, 36000, 36000, 0),
(246, 'MQ', 'America/Martinique', 0, -14400, -10800, 0),
(247, 'MR', 'Africa/Nouakchott', 0, 0, 0, 0),
(248, 'MS', 'America/Montserrat', 0, -14400, -14400, 0),
(249, 'MT', 'Europe/Malta', 1, 3600, 7200, 0),
(250, 'MU', 'Indian/Mauritius', 0, 14400, 18000, 0),
(251, 'MV', 'Indian/Maldives', 0, 18000, 18000, 0),
(252, 'MW', 'Africa/Blantyre', 0, 7200, 7200, 0),
(253, 'MX', 'America/Mexico_City', 1, -21600, -18000, 0),
(254, 'MX', 'America/Cancun', 1, -18000, -18000, 0),
(255, 'MX', 'America/Merida', 1, -21600, -18000, 0),
(256, 'MX', 'America/Monterrey', 1, -21600, -18000, 0),
(257, 'MX', 'America/Matamoros', 1, -21600, -18000, 0),
(258, 'MX', 'America/Mazatlan', 1, -25200, -21600, 0),
(259, 'MX', 'America/Chihuahua', 1, -25200, -21600, 0),
(260, 'MX', 'America/Ojinaga', 1, -25200, -21600, 0),
(261, 'MX', 'America/Hermosillo', 0, -25200, -21600, 0),
(262, 'MX', 'America/Tijuana', 1, -28800, -25200, 0),
(263, 'MX', 'America/Bahia_Banderas', 1, -21600, -18000, 0),
(264, 'MY', 'Asia/Kuala_Lumpur', 0, 28800, 26400, 0),
(265, 'MY', 'Asia/Kuching', 0, 28800, 30000, 0),
(266, 'MZ', 'Africa/Maputo', 0, 7200, 7200, 0),
(267, 'NA', 'Africa/Windhoek', 1, 3600, 7200, 1),
(268, 'NC', 'Pacific/Noumea', 0, 39600, 43200, 0),
(269, 'NE', 'Africa/Niamey', 0, 3600, 3600, 0),
(270, 'NF', 'Pacific/Norfolk', 0, 39600, 45000, 0),
(271, 'NG', 'Africa/Lagos', 0, 3600, 3600, 0),
(272, 'NI', 'America/Managua', 0, -21600, -18000, 0),
(273, 'NL', 'Europe/Amsterdam', 1, 3600, 7200, 0),
(274, 'NO', 'Europe/Oslo', 1, 3600, 7200, 0),
(275, 'NP', 'Asia/Kathmandu', 0, 20700, 20700, 0),
(276, 'NR', 'Pacific/Nauru', 0, 43200, 43200, 0),
(277, 'NU', 'Pacific/Niue', 0, -39600, -39600, 0),
(278, 'NZ', 'Pacific/Auckland', 1, 43200, 46800, 1),
(279, 'NZ', 'Pacific/Chatham', 1, 45900, 49500, 1),
(280, 'OM', 'Asia/Muscat', 0, 14400, 14400, 0),
(281, 'PA', 'America/Panama', 0, -18000, -18000, 0),
(282, 'PE', 'America/Lima', 0, -18000, -14400, 0),
(283, 'PF', 'Pacific/Tahiti', 0, -36000, -36000, 0),
(284, 'PF', 'Pacific/Marquesas', 0, -34200, -34200, 0),
(285, 'PF', 'Pacific/Gambier', 0, -32400, -32400, 0),
(286, 'PG', 'Pacific/Port_Moresby', 0, 36000, 36000, 0),
(287, 'PG', 'Pacific/Bougainville', 0, 39600, 39600, 0),
(288, 'PH', 'Asia/Manila', 0, 28800, 32400, 0),
(289, 'PK', 'Asia/Karachi', 0, 18000, 21600, 0),
(290, 'PL', 'Europe/Warsaw', 1, 3600, 7200, 0),
(291, 'PM', 'America/Miquelon', 1, -10800, -7200, 0),
(292, 'PN', 'Pacific/Pitcairn', 0, -28800, -28800, 0),
(293, 'PR', 'America/Puerto_Rico', 0, -14400, -10800, 0),
(294, 'PS', 'Asia/Gaza', 1, 7200, 10800, 0),
(295, 'PS', 'Asia/Hebron', 1, 7200, 10800, 0),
(296, 'PT', 'Europe/Lisbon', 1, 0, 3600, 0),
(297, 'PT', 'Atlantic/Madeira', 1, 0, 3600, 0),
(298, 'PT', 'Atlantic/Azores', 1, -3600, 0, 0),
(299, 'PW', 'Pacific/Palau', 0, 32400, 32400, 0),
(300, 'PY', 'America/Asuncion', 1, -14400, -10800, 1),
(301, 'QA', 'Asia/Qatar', 0, 10800, 10800, 0),
(302, 'RE', 'Indian/Reunion', 0, 14400, 14400, 0),
(303, 'RO', 'Europe/Bucharest', 1, 7200, 10800, 0),
(304, 'RS', 'Europe/Belgrade', 1, 3600, 7200, 0),
(305, 'RU', 'Europe/Kaliningrad', 0, 7200, 10800, 0),
(306, 'RU', 'Europe/Moscow', 0, 10800, 14400, 0),
(307, 'RU', 'Europe/Simferopol', 1, 10800, 10800, 0),
(308, 'RU', 'Europe/Volgograd', 0, 10800, 14400, 0),
(309, 'RU', 'Europe/Kirov', 0, 10800, 14400, 0),
(310, 'RU', 'Europe/Astrakhan', 0, 14400, 14400, 0),
(311, 'RU', 'Europe/Samara', 0, 14400, 18000, 0),
(312, 'RU', 'Europe/Ulyanovsk', 0, 14400, 14400, 0),
(313, 'RU', 'Asia/Yekaterinburg', 0, 18000, 21600, 0),
(314, 'RU', 'Asia/Omsk', 0, 21600, 25200, 0),
(315, 'RU', 'Asia/Novosibirsk', 0, 25200, 25200, 0),
(316, 'RU', 'Asia/Barnaul', 0, 25200, 25200, 0),
(317, 'RU', 'Asia/Tomsk', 0, 25200, 25200, 0),
(318, 'RU', 'Asia/Novokuznetsk', 0, 25200, 28800, 0),
(319, 'RU', 'Asia/Krasnoyarsk', 0, 25200, 28800, 0),
(320, 'RU', 'Asia/Irkutsk', 0, 28800, 32400, 0),
(321, 'RU', 'Asia/Chita', 0, 32400, 36000, 0),
(322, 'RU', 'Asia/Yakutsk', 0, 32400, 36000, 0),
(323, 'RU', 'Asia/Khandyga', 0, 32400, 39600, 0),
(324, 'RU', 'Asia/Vladivostok', 0, 36000, 39600, 0),
(325, 'RU', 'Asia/Ust-Nera', 0, 36000, 43200, 0),
(326, 'RU', 'Asia/Magadan', 0, 39600, 43200, 0),
(327, 'RU', 'Asia/Sakhalin', 0, 39600, 39600, 0),
(328, 'RU', 'Asia/Srednekolymsk', 0, 39600, 43200, 0),
(329, 'RU', 'Asia/Kamchatka', 0, 43200, 46800, 0),
(330, 'RU', 'Asia/Anadyr', 0, 43200, 46800, 0),
(331, 'RW', 'Africa/Kigali', 0, 7200, 7200, 0),
(332, 'SA', 'Asia/Riyadh', 0, 10800, 10800, 0),
(333, 'SB', 'Pacific/Guadalcanal', 0, 39600, 39600, 0),
(334, 'SC', 'Indian/Mahe', 0, 14400, 14400, 0),
(335, 'SD', 'Africa/Khartoum', 0, 10800, 10800, 0),
(336, 'SE', 'Europe/Stockholm', 1, 3600, 7200, 0),
(337, 'SG', 'Asia/Singapore', 0, 28800, 26400, 0),
(338, 'SH', 'Atlantic/St_Helena', 0, 0, 0, 0),
(339, 'SI', 'Europe/Ljubljana', 1, 3600, 7200, 0),
(340, 'SJ', 'Arctic/Longyearbyen', 1, 3600, 7200, 0),
(341, 'SK', 'Europe/Bratislava', 1, 3600, 7200, 0),
(342, 'SL', 'Africa/Freetown', 0, 0, 0, 0),
(343, 'SM', 'Europe/San_Marino', 1, 3600, 7200, 0),
(344, 'SN', 'Africa/Dakar', 0, 0, 0, 0),
(345, 'SO', 'Africa/Mogadishu', 0, 10800, 10800, 0),
(346, 'SR', 'America/Paramaribo', 0, -10800, -10800, 0),
(347, 'SS', 'Africa/Juba', 0, 10800, 10800, 0),
(348, 'ST', 'Africa/Sao_Tome', 0, 0, 0, 0),
(349, 'SV', 'America/El_Salvador', 0, -21600, -18000, 0),
(350, 'SX', 'America/Lower_Princes', 0, -14400, -14400, 0),
(351, 'SY', 'Asia/Damascus', 1, 7200, 10800, 0),
(352, 'SZ', 'Africa/Mbabane', 0, 7200, 10800, 0),
(353, 'TC', 'America/Grand_Turk', 1, -14400, -14400, 0),
(354, 'TD', 'Africa/Ndjamena', 0, 3600, 7200, 0),
(355, 'TF', 'Indian/Kerguelen', 0, 18000, 18000, 0),
(356, 'TG', 'Africa/Lome', 0, 0, 0, 0),
(357, 'TH', 'Asia/Bangkok', 0, 25200, 25200, 0),
(358, 'TJ', 'Asia/Dushanbe', 0, 18000, 25200, 0),
(359, 'TK', 'Pacific/Fakaofo', 0, 46800, 46800, 0),
(360, 'TL', 'Asia/Dili', 0, 32400, 32400, 0),
(361, 'TM', 'Asia/Ashgabat', 0, 18000, 21600, 0),
(362, 'TN', 'Africa/Tunis', 0, 3600, 7200, 0),
(363, 'TO', 'Pacific/Tongatapu', 0, 46800, 50400, 0),
(364, 'TR', 'Europe/Istanbul', 1, 10800, 10800, 0),
(365, 'TT', 'America/Port_of_Spain', 0, -14400, -14400, 0),
(366, 'TV', 'Pacific/Funafuti', 0, 43200, 43200, 0),
(367, 'TW', 'Asia/Taipei', 0, 28800, 32400, 0),
(368, 'TZ', 'Africa/Dar_es_Salaam', 0, 10800, 10800, 0),
(369, 'UA', 'Europe/Kiev', 1, 7200, 10800, 0),
(370, 'UA', 'Europe/Uzhgorod', 1, 7200, 10800, 0),
(371, 'UA', 'Europe/Zaporozhye', 1, 7200, 10800, 0),
(372, 'UG', 'Africa/Kampala', 0, 10800, 10800, 0),
(373, 'UM', 'Pacific/Johnston', 0, -36000, -34200, 0),
(374, 'UM', 'Pacific/Midway', 0, -39600, -39600, 0),
(375, 'UM', 'Pacific/Wake', 0, 43200, 43200, 0),
(376, 'US', 'America/New_York', 1, -18000, -14400, 0),
(377, 'US', 'America/Detroit', 1, -18000, -14400, 0),
(378, 'US', 'America/Kentucky/Louisville', 1, -18000, -14400, 0),
(379, 'US', 'America/Kentucky/Monticello', 1, -18000, -14400, 0),
(380, 'US', 'America/Indiana/Indianapolis', 1, -18000, -14400, 0),
(381, 'US', 'America/Indiana/Vincennes', 1, -18000, -14400, 0),
(382, 'US', 'America/Indiana/Winamac', 1, -18000, -14400, 0),
(383, 'US', 'America/Indiana/Marengo', 1, -18000, -14400, 0),
(384, 'US', 'America/Indiana/Petersburg', 1, -18000, -14400, 0),
(385, 'US', 'America/Indiana/Vevay', 1, -18000, -14400, 0),
(386, 'US', 'America/Chicago', 1, -21600, -18000, 0),
(387, 'US', 'America/Indiana/Tell_City', 1, -21600, -18000, 0),
(388, 'US', 'America/Indiana/Knox', 1, -21600, -18000, 0),
(389, 'US', 'America/Menominee', 1, -21600, -18000, 0),
(390, 'US', 'America/North_Dakota/Center', 1, -21600, -18000, 0),
(391, 'US', 'America/North_Dakota/New_Salem', 1, -21600, -18000, 0),
(392, 'US', 'America/North_Dakota/Beulah', 1, -21600, -18000, 0),
(393, 'US', 'America/Denver', 1, -25200, -21600, 0),
(394, 'US', 'America/Boise', 1, -25200, -21600, 0),
(395, 'US', 'America/Phoenix', 0, -25200, -21600, 0),
(396, 'US', 'America/Los_Angeles', 1, -28800, -25200, 0),
(397, 'US', 'America/Anchorage', 1, -32400, -28800, 0),
(398, 'US', 'America/Juneau', 1, -32400, -28800, 0),
(399, 'US', 'America/Sitka', 1, -32400, -28800, 0),
(400, 'US', 'America/Metlakatla', 1, -32400, -28800, 0),
(401, 'US', 'America/Yakutat', 1, -32400, -28800, 0),
(402, 'US', 'America/Nome', 1, -32400, -28800, 0),
(403, 'US', 'America/Adak', 1, -36000, -32400, 0),
(404, 'US', 'Pacific/Honolulu', 0, -36000, -34200, 0),
(405, 'UY', 'America/Montevideo', 1, -10800, -7200, 0),
(406, 'UZ', 'Asia/Samarkand', 0, 18000, 21600, 0),
(407, 'UZ', 'Asia/Tashkent', 0, 18000, 25200, 0),
(408, 'VA', 'Europe/Vatican', 1, 3600, 7200, 0),
(409, 'VC', 'America/St_Vincent', 0, -14400, -14400, 0),
(410, 'VE', 'America/Caracas', 0, -14400, -14400, 0),
(411, 'VG', 'America/Tortola', 0, -14400, -14400, 0),
(412, 'VI', 'America/St_Thomas', 0, -14400, -14400, 0),
(413, 'VN', 'Asia/Ho_Chi_Minh', 0, 25200, 25200, 0),
(414, 'VU', 'Pacific/Efate', 0, 39600, 43200, 0),
(415, 'WF', 'Pacific/Wallis', 0, 43200, 43200, 0),
(416, 'WS', 'Pacific/Apia', 1, 46800, 50400, 1),
(417, 'YE', 'Asia/Aden', 0, 10800, 10800, 0),
(418, 'YT', 'Indian/Mayotte', 0, 10800, 10800, 0),
(419, 'ZA', 'Africa/Johannesburg', 0, 7200, 10800, 0),
(420, 'ZM', 'Africa/Lusaka', 0, 7200, 7200, 0),
(421, 'ZW', 'Africa/Harare', 0, 7200, 7200, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]webpage_types`
--

CREATE TABLE `[[dbprefix]]webpage_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_system` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]webpage_types`
--

INSERT INTO `[[dbprefix]]webpage_types` VALUES
(1, 'personal', 1),
(2, 'work', 1),
(3, 'other', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]widgets`
--

CREATE TABLE `[[dbprefix]]widgets` (
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `plugin_id` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `default_options` text COLLATE utf8_unicode_ci,
  `default_section` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `default_order` int(10) NOT NULL,
  `icon_cls` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]widgets`
--

INSERT INTO `[[dbprefix]]widgets` VALUES
('active_context_info', 'active_context_info', 0, '', '', 'left', 1, 'ico-summary'),
('activity_feed', 'activity_feed', 0, '', '', 'left', 10, 'ico-properties'),
('calendar', 'upcoming events milestones and tasks', 0, '', '', 'top', 0, 'ico-event'),
('comments', 'comments', 0, '', '', 'left', 15, 'ico-comment'),
('completed_tasks_list', 'completed tasks list', 0, '', '', 'right', 150, 'ico-task'),
('documents', 'documents', 0, '', '', 'right', 1100, 'ico-file'),
('emails', 'emails', 0, '', '', 'right', 10, 'ico-email'),
('messages', 'notes', 0, '', '', 'right', 1000, 'ico-message'),
('overdue_upcoming', 'overdue and upcoming', 0, '', '', 'left', 3, 'ico-task'),
('people', 'people', 0, '', '', 'right', -1, 'ico-contact'),
('workspaces', 'workspaces', 3, '', '', 'left', 3, 'ico-workspace');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]workspaces`
--

CREATE TABLE `[[dbprefix]]workspaces` (
  `object_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8_unicode_ci,
  `show_description_in_overview` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `color` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
