<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);



return [
    // general stuff:
    'stored_in_tz'                                                              => 'stored in ":timezone"',
    'displayed_in_tz'                                                           => 'displayed in ":timezone"',
    'close'                                                                     => '닫기',
    'actions'                                                                   => '액션',
    'edit'                                                                      => '수정',
    'transaction_journal_id'                                                    => 'Transaction journal ID',
    'delete'                                                                    => '삭제',
    'split'                                                                     => '나누기',
    'single_split'                                                              => '나누기',
    'clone'                                                                     => '복사',
    'clone_and_edit'                                                            => '복제 및 수정',
    'confirm_action'                                                            => '액션 확인',
    'last_seven_days'                                                           => '최근 7일',
    'last_thirty_days'                                                          => '최근 30일',
    'last_180_days'                                                             => '최근 180일',
    'month_to_date'                                                             => '월간 누계',
    'year_to_date'                                                              => '연간 누계',
    'YTD'                                                                       => 'YTD',
    'welcome_back'                                                              => '무슨 일이죠?',
    'main_dashboard_page_title'                                                 => 'Home',
    'everything'                                                                => '모든 것',
    'today'                                                                     => '오늘',
    'customRange'                                                               => '맞춤 범위',
    'date_range'                                                                => '날짜 범위',
    'apply'                                                                     => '적용',
    'select_date'                                                               => '날짜 선택',
    'cancel'                                                                    => '취소',
    'from'                                                                      => '에서',
    'to'                                                                        => '에게',
    'structure'                                                                 => '구조',
    'help_translating'                                                          => '이 도움말 텍스트는 아직 귀하의 언어를 지원하지 않습니다. <a href="https://crowdin.com/project/firefly-iii-help">번역을 도와 주시겠습니까?</a>',
    'showEverything'                                                            => '모두 보기',
    'never'                                                                     => '절대',
    'no_results_for_empty_search'                                               => '검색 조건이 비어서 아무것도 찾을 수 없습니다.',
    'removed_amount'                                                            => ':amount 삭제됨',
    'added_amount'                                                              => ':amount 추가됨',
    'asset_account_role_help'                                                   => '선택에 따른 추가 옵션은 나중에 설정할 수 있습니다.',
    'Opening balance'                                                           => '초기 잔고',
    'create_new_stuff'                                                          => '새로 만들기',
    'new_withdrawal'                                                            => '신규 출금',
    'create_new_transaction'                                                    => '새로운 거래 만들기',
    'sidebar_frontpage_create'                                                  => '생성',
    'new_transaction'                                                           => '새 거래',
    'no_rules_for_bill'                                                         => 'This subscription has no rules associated to it.',
    'go_to_asset_accounts'                                                      => '자산 계정 보기',
    'go_to_budgets'                                                             => '예산으로 이동',
    'go_to_withdrawals'                                                         => '출금으로 이동',
    'clones_journal_x'                                                          => '이 거래는 ":description" (#:id)의 복제본입니다.',
    'go_to_categories'                                                          => '카테고리로 이동',
    'go_to_bills'                                                               => 'Go to your subscriptions',
    'go_to_expense_accounts'                                                    => '지출 계정 보기',
    'go_to_revenue_accounts'                                                    => '수익 계정 보기',
    'go_to_piggies'                                                             => '저금통으로 이동',
    'new_deposit'                                                               => '신규 입금',
    'new_transfer'                                                              => '신규 이체',
    'new_transfers'                                                             => '신규 이체',
    'new_asset_account'                                                         => '새 자산 계정',
    'new_expense_account'                                                       => '새 지출 계정',
    'new_revenue_account'                                                       => '새 수익 계정',
    'new_liabilities_account'                                                   => '새 부채',
    'new_budget'                                                                => '새 예산',
    'new_bill'                                                                  => 'New subscription',
    'block_account_logout'                                                      => '로그아웃되었습니다. 차단된 계정은 이 사이트를 사용할 수 없습니다. 유효한 이메일 주소로 등록하셨습니까?',
    'flash_success'                                                             => '성공!',
    'flash_info'                                                                => '메시지',
    'flash_warning'                                                             => '경고!',
    'flash_error'                                                               => '오류!',
    'flash_danger'                                                              => '위험!',
    'flash_info_multiple'                                                       => '메시지가 하나 있습니다|매시지가 :count개 있습니다',
    'flash_error_multiple'                                                      => '오류가 하나 있습니다|오류가 :count개 있습니다',
    'net_worth'                                                                 => '순자산',
    'help_for_this_page'                                                        => '이 페이지에 대한 도움말',
    'help_for_this_page_body'                                                   => '이 페이지에 대한 자세한 정보는 <a href="https://docs.firefly-iii.org/">문서</a>에서 확인할 수 있습니다.',
    'two_factor_welcome'                                                        => '안녕하세요!',
    'two_factor_enter_code'                                                     => '계속하려면 2단계 인증 코드를 입력하세요. 애플리케이션에서 자동으로 생성할 수 있습니다.',
    'two_factor_code_here'                                                      => '여기에 코드 입력',
    'two_factor_title'                                                          => '2단계 인증',
    'authenticate'                                                              => '인증',
    'two_factor_forgot_title'                                                   => '2단계 인증 분실',
    'two_factor_forgot'                                                         => '2단계 인증을 잊었습니다.',
    'two_factor_lost_header'                                                    => '2단계 인증을 분실하셨나요?',
    'two_factor_lost_intro'                                                     => '백업 코드도 분실하셨다면 운이 나쁘신 것입니다. 이 문제는 웹 인터페이스에서 해결할 수 있는 문제가 아닙니다. 두 가지 선택지가 있습니다.',
    'two_factor_lost_fix_self'                                                  => 'If you run your own instance of Firefly III, read <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">this entry in the FAQ</a> for instructions.',
    'two_factor_lost_fix_owner'                                                 => '그렇지 않은 경우 사이트 소유자 <a href="mailto::site_owner">:site_owner</a>에게 이메일을 보내 2단계 인증을 재설정해 달라고 요청하세요.',
    'mfa_backup_code'                                                           => '백업 코드를 사용하여 Firefly III에 로그인했습니다. 코드는 다시 사용할 수 없으므로 목록에서 삭제하세요.',
    'pref_two_factor_new_backup_codes'                                          => '새 백업 코드 얻기',
    'pref_two_factor_backup_code_count'                                         => ':count개의 유효한 백업코드가 있습니다.|:count개의 유효한 백업코드가 있습니다.',
    '2fa_i_have_them'                                                           => '저장했습니다!',
    'warning_much_data'                                                         => ':days일의 데이터를 로드하는데 시간이 걸릴 수 있습니다.',
    'registered'                                                                => '성공적으로 등록되었습니다!',
    'Default asset account'                                                     => '기본 자산 계정',
    'no_budget_pointer'                                                         => '예산이 아직 없는 것 같습니다. <a href="budgets">예산</a> 페이지에서 예산을 만들어야 합니다. 예산은 지출을 추적하는데 도움이 됩니다.',
    'no_bill_pointer'                                                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                                                           => '예금 계좌',
    'Credit card'                                                               => '신용카드',
    'source_accounts'                                                           => '소스 계정|소스 계정',
    'destination_accounts'                                                      => '대상 계정|대상 계정',
    'user_id_is'                                                                => '사용자 Id는 <strong>:user</strong>입니다',
    'field_supports_markdown'                                                   => '이 필드는 <a href="https://en.support.wordpress.com/markdown-quick-reference/">마크다운</a>을 지원합니다.',
    'need_more_help'                                                            => 'Firefly III를 사용하는데 도움이 필요하다면 <a href="https://github.com/firefly-iii/firefly-iii/issues">Github에서 티켓을 열어주세요</a>.',
    'reenable_intro_text'                                                       => '<a href="#" id="reenableGuidance">소개 안내</a>를 다시 활성화할 수도 있습니다.',
    'intro_boxes_after_refresh'                                                 => '페이지를 새로고침하면 소개 상자가 다시 나타납니다.',
    'show_all_no_filter'                                                        => '날짜별로 그룹화하지 않고 모든 거래를 표시합니다.',
    'expenses_by_category'                                                      => '카테고리별 지출',
    'expenses_by_budget'                                                        => '예산별 지출',
    'income_by_category'                                                        => '카테고리별 수입',
    'expenses_by_asset_account'                                                 => '자산 계정별 지출',
    'expenses_by_expense_account'                                               => 'Expenses by destination account',
    'cannot_redirect_to_account'                                                => 'Firefly III가 올바른 페이지로 리디렉션할 수 없습니다. 죄송합니다.',
    'sum_of_expenses'                                                           => '지출 합계',
    'sum_of_income'                                                             => '수입 합계',
    'liabilities'                                                               => '부채',
    'spent_in_specific_budget'                                                  => '":budget" 예산에서 지출',
    'spent_in_specific_double'                                                  => '":account" 계정에서 지출',
    'earned_in_specific_double'                                                 => '":account" 계정에서 소득',
    'source_account'                                                            => '소스 계정',
    'source_account_reconciliation'                                             => '조정 거래의 소스 계정은 편집할 수 없습니다.',
    'destination_account'                                                       => '대상 계정',
    'destination_account_reconciliation'                                        => '조정 거래의 대상 계정은 편집할 수 없습니다.',
    'sum_of_expenses_in_budget'                                                 => '":budget" 예산에서 총 지출',
    'left_in_budget_limit'                                                      => '예산 책정에 따른 남은 지출',
    'current_period'                                                            => '현재 기간',
    'show_the_current_period_and_overview'                                      => '현재 기간 및 걔요 표시',
    'pref_languages_locale'                                                     => '영어 외의 언어가 제대로 동작하려면 운영 체제에 올바른 로케일 정보가 있어야 합니다. 그렇지 않은 경우 통화 데이터, 날짜 및 금액의 형식이 잘못 지정될 수 있습니다.',
    'budget_in_period'                                                          => ':currency에서 :start와 :end 사이의 예산 ":name"에 대한 모든 거래',
    'chart_budget_in_period'                                                    => ':currency에서 :start와 :end 사이의 예산 ":name"에 대한 모든 거래에 대한 차트',
    'chart_budget_in_period_only_currency'                                      => '예산을 책정한 금액은 :currency이므로 이 차트에는 :currency의 거래만 표시됩니다.',
    'chart_account_in_period'                                                   => ':start와 :end 동안 ":name" (:balance) 계정의 모든 거래에 대한 차트',
    'chart_category_in_period'                                                  => ':start와 :end 동안 ":name" 카테고리의 모든 거래에 대한 차트',
    'chart_category_all'                                                        => '":name" 카테고리의 모든 거래에 대한 차트',
    'clone_withdrawal'                                                          => '이 출금을 복제합니다',
    'clone_deposit'                                                             => '이 입금을 복제합니다',
    'clone_transfer'                                                            => '이 이체를 복제합니다',
    'multi_select_no_selection'                                                 => '선택하지 않음',
    'multi_select_select_all'                                                   => '전체 선택',
    'multi_select_n_selected'                                                   => '선택됨',
    'multi_select_all_selected'                                                 => '모두 선택됨',
    'multi_select_filter_placeholder'                                           => '찾기..',
    'intro_next_label'                                                          => '다음',
    'intro_prev_label'                                                          => '이전',
    'intro_skip_label'                                                          => '건너뛰기',
    'intro_done_label'                                                          => '완료',
    'between_dates_breadcrumb'                                                  => ':start와 :end 사이',
    'all_journals_without_budget'                                               => '예산이 없는 모든 거래',
    'journals_without_budget'                                                   => '예산이 없는 거래',
    'all_journals_without_category'                                             => '카테고리가 없는 모든 거래',
    'journals_without_category'                                                 => '카테고리가 없는 거래',
    'all_journals_for_account'                                                  => ':name 계정에 대한 모든 거래',
    'chart_all_journals_for_account'                                            => ':name 계정에 대한 모든 거래 차트',
    'journals_in_period_for_account'                                            => ':start와 :end 동안 ":name" 계정의 모든 거래',
    'journals_in_period_for_account_js'                                         => '{start} 와 {end} 동안 {title} 계정의 모든 거래',
    'transferred'                                                               => '이체',
    'all_withdrawal'                                                            => '모든 지출',
    'all_transactions'                                                          => '모든 거래',
    'title_withdrawal_between'                                                  => ':start와 :end 사이의 모든 지출',
    'all_deposit'                                                               => '모든 수익',
    'title_deposit_between'                                                     => ':start와 :end 사이의 모든 수익',
    'all_transfers'                                                             => '모든 이체',
    'title_transfers_between'                                                   => ':start와 :end 사이의 모든 이체',
    'all_transfer'                                                              => '모든 이체',
    'all_journals_for_tag'                                                      => '":tag" 태그에 대한 모든 거래',
    'title_transfer_between'                                                    => ':start와 :end 사이의 모든 이체',
    'all_journals_for_category'                                                 => ':name 카테고리에 대한 모든 거래',
    'all_journals_for_budget'                                                   => ':name 예산에 대한 모든 거래',
    'chart_all_journals_for_budget'                                             => ':name 예산에 대한 모든 거래 차트',
    'journals_in_period_for_category'                                           => ':start와 :end 동안 ":name" 카테고리의 모든 거래',
    'journals_in_period_for_tag'                                                => ':start와 :end 동안 :tag 태그의 모든 거래',
    'not_available_demo_user'                                                   => '액세스하려는 기능은 데모 사용자가 사용할 수 없습니다.',
    'exchange_rate_instructions'                                                => '자산 계정 "@name"은 @native_currency 로만 거래할 수 있습니다. @foreign_currency 를 대신 사용하려면 @native_currency 도 알고 있어야 합니다:',
    'transfer_exchange_rate_instructions'                                       => '소스 자산 계정 "@source_name"은 @source_currency 의 거래만 허용합니다. 대상 자산 계정 "@dest_name"은 @dest_currency 의 거래만 허용합니다. 두 통화로 이체 금액을 정확하게 제공해야 합니다.',
    'transaction_data'                                                          => '거래 데이터',
    'invalid_server_configuration'                                              => '유효하지 않은 서버 설정',
    'invalid_locale_settings'                                                   => '필요한 패키지가 누락되어, Firefly III가 화폐의 금액을 포맷팅 할 수 없습니다. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instruction how to do this</a>를 참고하십시오.',
    'quickswitch'                                                               => '퀵스위치',
    'sign_in_to_start'                                                          => '세션을 시작하려면 로그인하세요.',
    'sign_in'                                                                   => '로그인',
    'register_new_account'                                                      => '새로운 계정 등록',
    'forgot_my_password'                                                        => '비밀번호를 잊어버렸습니다',
    'problems_with_input'                                                       => '입력에 오류가 있습니다.',
    'reset_password'                                                            => '비밀번호 초기화',
    'button_reset_password'                                                     => '비밀번호 초기화',
    'reset_button'                                                              => '초기화',
    'want_to_login'                                                             => '로그인하고 싶습니다',
    'login_page_title'                                                          => 'Firefly III 로그인',
    'register_page_title'                                                       => 'Firefly III 등록하기',
    'forgot_pw_page_title'                                                      => 'Firefly III 비밀번호를 잊어버렸습니다',
    'reset_pw_page_title'                                                       => 'Firefly III의 비밀번호 재설정',
    'cannot_reset_demo_user'                                                    => '데모 사용자의 비밀번호는 재설정할 수 없습니다.',
    'no_att_demo_user'                                                          => '데모 유저는 첨부 파일을 업로드할 수 없습니다.',
    'button_register'                                                           => '등록',
    'authorization'                                                             => '인증',
    'active_bills_only'                                                         => 'active subscription only',
    'active_bills_only_total'                                                   => 'all active subscriptions',
    'active_exp_bills_only'                                                     => 'active and expected subscriptions only',
    'active_exp_bills_only_total'                                               => 'all active expected subscriptions only',
    'per_period_sum_1D'                                                         => '일간 예상 비용',
    'per_period_sum_1W'                                                         => '주간 예상 비용',
    'per_period_sum_1M'                                                         => '월간 예상 비용',
    'per_period_sum_3M'                                                         => '분기 예상 비용',
    'per_period_sum_6M'                                                         => '반기 예상 비용',
    'per_period_sum_1Y'                                                         => '년간 예상 비용',
    'average_per_bill'                                                          => 'average per subscription',
    'expected_total'                                                            => '예상 합계',
    'reconciliation_account_name'                                               => ':name 조정 (:currency)',
    'saved'                                                                     => '저장 완료',
    'advanced_options'                                                          => '고급 옵션',
    'advanced_options_explain'                                                  => 'Firefly III의 일부 페이지에는 이 버튼 뒤에 고급 옵션이 숨겨져 있습니다. 이 페이지에는 멋진 옵션이 없지만 다른 페이지도 확인해 보세요!',
    'here_be_dragons'                                                           => 'Hic sunt dracones',

    // Webhooks
    'webhooks'                                                                  => '웹훅',
    'webhooks_breadcrumb'                                                       => '웹훅',
    'webhooks_menu_disabled'                                                    => '비활성화',
    'no_webhook_messages'                                                       => '웹훅 메시지 없음',
    'webhook_trigger_STORE_TRANSACTION'                                         => '거래 생성 이후',
    'webhook_trigger_UPDATE_TRANSACTION'                                        => '거래 업데이트 이후',
    'webhook_trigger_DESTROY_TRANSACTION'                                       => '거래 삭제 이후',
    'webhook_response_TRANSACTIONS'                                             => '거래 세부 정보',
    'webhook_response_ACCOUNTS'                                                 => '계정 정보',
    'webhook_response_none_NONE'                                                => '상세정보 없음',
    'webhook_delivery_JSON'                                                     => 'JSON',
    'inspect'                                                                   => '검사',
    'create_new_webhook'                                                        => '웹훅 만들기',
    'webhooks_create_breadcrumb'                                                => '웹훅 만들기',
    'webhook_trigger_form_help'                                                 => '웹훅이 트리거할 이벤트를 표시합니다',
    'webhook_response_form_help'                                                => '웹훅이 URL에 제출해야 하는 내용을 표시합니다.',
    'webhook_delivery_form_help'                                                => '웹훅이 데이터를 전달해야 하는 형식입니다.',
    'webhook_active_form_help'                                                  => '웹훅이 활성화되어 있어야 하며 그렇지 않으면 호출되지 않습니다.',
    'stored_new_webhook'                                                        => '새로운 ":title" 웹훅 저장됨',
    'delete_webhook'                                                            => '웹훅 삭제',
    'deleted_webhook'                                                           => '":title" 웹훅 삭제됨',
    'edit_webhook'                                                              => '":title" 웹훅 수정',
    'updated_webhook'                                                           => '":title" 웹훅 업데이트됨',
    'edit_webhook_js'                                                           => '"{title}" 웹훅 수정',
    'show_webhook'                                                              => '":title" 웹훅',
    'webhook_was_triggered'                                                     => '표시된 거래에서 웹훅이 트리거되었습니다. 결과가 나타날 때까지 기다려주세요.',
    'webhook_messages'                                                          => '웹훅 메시지',
    'view_message'                                                              => '메시지 보기',
    'view_attempts'                                                             => '실패한 시도 보기',
    'message_content_title'                                                     => '웹훅 메시지 내용',
    'message_content_help'                                                      => '이 웹훅을 사용하여 전송된(또는 시도한) 메시지의 내용입니다.',
    'attempt_content_title'                                                     => '웹훅 시도',
    'attempt_content_help'                                                      => '구성된 URL에 제출하려는 이 웹훅 메시지의 모든 실패한 시도입니다. 잠시 후 Firefly III가 시도를 중지합니다.',
    'no_attempts'                                                               => '실패한 시도가 없습니다. 좋은 일이네요!',
    'webhook_attempt_at'                                                        => '{moment}에 시도',
    'logs'                                                                      => '로그',
    'response'                                                                  => '응답',
    'visit_webhook_url'                                                         => '웹훅 URL 방문',
    'reset_webhook_secret'                                                      => '웹훅 시크릿 재설정',
    'webhook_stored_link'                                                       => '<a href="webhooks/show/{ID}">웹훅 #{ID} ("{title}")</a>이 저장되었습니다.',
    'webhook_updated_link'                                                      => '<a href="webhooks/show/{ID}">웹훅 #{ID}</a> ("{title}")이 업데이트 되었습니다.',

    // API access
    'authorization_request'                                                     => 'Firefly III v:version 인증 요청',
    'authorization_request_intro'                                               => '응용 프로그램 "<strong>:client</strong>"에서 재무 관리에 액세스할 수 있는 권한을 요청하고 있습니다. <strong>:client</strong>에게 이러한 기록에 액세스할 수 있는 권한을 부여하시겠습니까?',
    'authorization_request_site'                                                => '<code>:url</code>로 리디렉션되며, 이 페이지에서 Firefly III 데이터에 액세스할 수 있습니다.',
    'authorization_request_invalid'                                             => '이 액세스 요청은 유효하지 않습니다. 다시는 이 링크를 클릭하지 마세요.',
    'scopes_will_be_able'                                                       => '이 응용 프로그램은 다음을 수행 할 수 있습니다:',
    'button_authorize'                                                          => '인증',
    'none_in_select_list'                                                       => '(없음)',
    'no_piggy_bank'                                                             => '(저금통 없음)',
    'name_in_currency'                                                          => ':currency :name',
    'paid_in_currency'                                                          => ':currency로 지불됨',
    'unpaid_in_currency'                                                        => ':currency로 미지불',
    'is_alpha_warning'                                                          => '알파 버전을 실행 중입니다. 버그와 문제에 주의하십시오.',
    'is_beta_warning'                                                           => '베타 버전을 실행 중입니다. 버그와 문제에 주의하십시오.',
    'all_destination_accounts'                                                  => '대상 계정',
    'all_source_accounts'                                                       => '소스 계정',
    'back_to_index'                                                             => '목록으로 돌아가기',
    'cant_logout_guard'                                                         => 'Firefly III에서 로그아웃할 수 없습니다.',
    'internal_reference'                                                        => '내부 참조',

    // check for updates:
    'update_check_title'                                                        => '업데이트 확인',
    'admin_update_check_title'                                                  => '업데이트 자동 확인',
    'admin_update_check_explain'                                                => 'Firefly III가 자동으로 업데이트를 확인할 수 있습니다. 이 설정을 활성화하면 Firefly III 업데이트 서버에 연결하여 Firefly III의 새 버전을 사용할 수 있는지 확인합니다. 업데이트가 완료되면 알림을 받게 됩니다. 오른쪽의 버튼을 사용하여 이 알림을 테스트할 수 있습니다. Firefly III가 업데이트를 확인하도록 하려면 아래에 표시해 주세요.',
    'check_for_updates_permission'                                              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                                                      => '나중에 다시 확인',
    'updates_do_not_check'                                                      => '업데이트 확인하지 않기',
    'updates_enable_check'                                                      => '업데이트 확인 사용',
    'admin_update_check_now_title'                                              => '지금 업데이트 확인',
    'admin_update_check_now_explain'                                            => '버튼을 누르면 Firefly III의 버전이 최신 버전인지 확인합니다.',
    'check_for_updates_button'                                                  => '지금 확인!',
    'update_new_version_alert'                                                  => 'Firefly III의 새 버전을 사용할 수 있습니다. 현재 실행 중인 버전은 :your_version이며, 최신 버전은 :date에 릴리스된 :new_version입니다.',
    'update_version_beta'                                                       => '이 버전은 베타 버전입니다. 문제가 발생할 수 있습니다.',
    'update_version_alpha'                                                      => '이 버전은 알파 버전입니다. 문제가 발생할 수 있습니다.',
    'update_current_dev_older'                                                  => '최신 버전 ":new_version"의 이전 개발 버전 ":version"을 사용하고 있습니다. 업데이트 해주십시오.',
    'update_current_dev_newer'                                                  => '최신 버전 ":new_version"의 이후 개발 버전 ":version"을 사용하고 있습니다.',
    'update_current_version_alert'                                              => '사용 가능한 최신 릴리스인 :version을 실행 중입니다.',
    'update_newer_version_alert'                                                => '최신 릴리스인 :new_version보다 최신 버전인 :your_version을 실행중입니다.',
    'update_check_error'                                                        => '업데이트 확인 중 오류가 발생했습니다: :error',
    'unknown_error'                                                             => '알 수 없는 오류입니다. 죄송합니다.',
    'disabled_but_check'                                                        => '업데이트 확인을 비활성화했습니다. 가끔씩 업데이트를 직접 확인하는 것을 잊지 마세요. 감사합니다!',
    'admin_update_channel_title'                                                => '업데이트 채널',
    'admin_update_channel_explain'                                              => 'Firefly III에는 세 가지 업데이트 "채널"이 있으며, 기능, 개선 사항 및 버그에 대해 얼마나 앞서 있는지 결정합니다. 모험심이 강하다면 "베타" 채널을, 위험한 삶을 원하신다면 "알파" 채널을 사용하세요.',
    'update_channel_stable'                                                     => '안정 버전입니다. 모든 것이 예상대로 작동합니다.',
    'update_channel_beta'                                                       => '베타 버전입니다. 새로운 기능이 추가되었지만 일부 기능이 손상될 수 있습니다.',
    'update_channel_alpha'                                                      => '알파 버전입니다. 새로운 기능은 무엇이든 추가해 봅니다.',

    // search
    'search'                                                                    => '검색',
    'search_query'                                                              => '쿼리',
    'search_found_transactions'                                                 => 'Firefly III가 :time초 동안 :count개의 거래를 찾았습니다.|Firefly III가 :time초 동안 :count개의 거래를 찾았습니다.',
    'search_found_more_transactions'                                            => 'Firefly III는 :time초 동안 :count개 이상의 거래를 찾았습니다.',
    'search_for_overview'                                                       => 'Firefly III is searching for transactions that fulfill <b>all</b> of the following conditions:',
    'search_for_query'                                                          => 'All of these words must be present: <span class="text-info">:query</span>',
    'search_for_excluded_words'                                                 => 'None of these words may be present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                                                    => '이 검색 매개변수는 유효하지 않으며 무시되었습니다.',

    // old



    'search_modifier_date_on'                                                   => '거래 날짜는 ":value"입니다',
    'search_modifier_not_date_on'                                               => '거래 날짜는 ":value"가 아닙니다.',
    'search_modifier_reconciled'                                                => '거래가 조정됨',
    'search_modifier_not_reconciled'                                            => '거래가 조정되지 않음',
    'search_modifier_id'                                                        => '거래 ID는 ":value"입니다',
    'search_modifier_not_id'                                                    => '거래 ID는 ":value"가 아닙니다',
    'search_modifier_date_before'                                               => '거래일이 ":value" 이전이거나 해당 날짜입니다',
    'search_modifier_date_after'                                                => '거래일이 ":value" 이후거나 해당 날짜입니다',
    'search_modifier_external_id_is'                                            => '외부 ID는 ":value"입니다',
    'search_modifier_not_external_id_is'                                        => '외부 ID는 ":value"가 아닙니다',
    'search_modifier_no_external_url'                                           => '거래에 외부 URL이 없습니다',
    'search_modifier_no_external_id'                                            => '거래에 외부 ID가 없습니다',
    'search_modifier_not_any_external_url'                                      => '거래에 외부 URL이 없습니다',
    'search_modifier_not_any_external_id'                                       => '거래에 외부 ID가 없습니다',
    'search_modifier_any_external_url'                                          => '거래는 반드시 하나 이상의 외부 URL이 있어야 합니다',
    'search_modifier_any_external_id'                                           => '거래는 반드시 하나 이상의 외부 ID가 있어야 합니다',
    'search_modifier_not_no_external_url'                                       => '거래는 반드시 하나 이상의 외부 URL이 있어야 합니다',
    'search_modifier_not_no_external_id'                                        => '거래는 반드시 하나 이상의 외부 ID가 있어야 합니다',
    'search_modifier_internal_reference_is'                                     => '내부 참조는 ":value"입니다',
    'search_modifier_not_internal_reference_is'                                 => '내부 참조가 ":value"가 아닙니다',
    'search_modifier_description_starts'                                        => '설명이 ":value"로 시작합니다',
    'search_modifier_not_description_starts'                                    => '설명이 ":value"로 시작하지 않습니다',
    'search_modifier_description_ends'                                          => '설명은 ":value"에서 끝납니다',
    'search_modifier_not_description_ends'                                      => '설명은 ":value"에서 끝나지 않습니다',
    'search_modifier_description_contains'                                      => '설명에 ":value" 포함',
    'search_modifier_not_description_contains'                                  => '설명에 ":value" 포함되지 않음',
    'search_modifier_description_is'                                            => '설명은 정확히 ":value"입니다',
    'search_modifier_not_description_is'                                        => '설명이 정확히 ":value"가 아닙니다',
    'search_modifier_currency_is'                                               => '거래 (외화) 통화는 ":value"',
    'search_modifier_not_currency_is'                                           => '거래 (외화) 통화가 ":value"가 아님',
    'search_modifier_foreign_currency_is'                                       => '거래 외화 통화는 ":value"',
    'search_modifier_not_foreign_currency_is'                                   => '거래 외화 통화는 ":value"가 아님',
    'search_modifier_has_attachments'                                           => '거래에는 첨부 파일이 있어야 합니다',
    'search_modifier_has_no_category'                                           => '거래에는 카테고리가 없어야 합니다',
    'search_modifier_not_has_no_category'                                       => '거래는 반드시 하나 이상의 카테고리가 있어야 합니다',
    'search_modifier_not_has_any_category'                                      => '거래에는 카테고리가 없어야 합니다',
    'search_modifier_has_any_category'                                          => '거래는 반드시 하나 이상의 카테고리가 있어야 합니다',
    'search_modifier_has_no_budget'                                             => '거래에는 예산이 없어야 합니다',
    'search_modifier_not_has_any_budget'                                        => '거래에는 예산이 없어야 합니다',
    'search_modifier_has_any_budget'                                            => '거래는 반드시 하나 이상의 예산이 있어야 합니다',
    'search_modifier_not_has_no_budget'                                         => '거래는 반드시 하나 이상의 예산이 있어야 합니다',
    'search_modifier_has_no_bill'                                               => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                                           => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                                              => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                                          => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                                                => '거래에는 태그가 없어야 합니다',
    'search_modifier_not_has_any_tag'                                           => '거래에는 태그가 없어야 합니다',
    'search_modifier_not_has_no_tag'                                            => '거래는 반드시 하나 이상의 태그가 있어야 합니다',
    'search_modifier_has_any_tag'                                               => '거래는 반드시 하나 이상의 태그가 있어야 합니다',
    'search_modifier_notes_contains'                                            => '거래 노트는 ":value"를 포함합니다',
    'search_modifier_not_notes_contains'                                        => '거래 노트는 ":value"를 포함하지 않습니다',
    'search_modifier_notes_starts'                                              => '거래 노트는 ":value"로 시작합니다',
    'search_modifier_not_notes_starts'                                          => '거래 노트는 ":value"로 시작하지 않습니다',
    'search_modifier_notes_ends'                                                => '거래 노트는 ":value"로 끝납니다',
    'search_modifier_not_notes_ends'                                            => '거래 노트는 ":value"로 끝나지 않습니다',
    'search_modifier_notes_is'                                                  => '거래 노트는 정확히 ":value"입니다',
    'search_modifier_not_notes_is'                                              => '거래 노트가 정확히 ":value"가 아닙니다',
    'search_modifier_no_notes'                                                  => '거래에 노트가 없습니다',
    'search_modifier_not_no_notes'                                              => '거래에는 노트가 없어야 합니다',
    'search_modifier_any_notes'                                                 => '거래에는 노트가 없어야 합니다',
    'search_modifier_not_any_notes'                                             => '거래에 노트가 없습니다',
    'search_modifier_amount_is'                                                 => '금액은 정확히 :value입니다',
    'search_modifier_not_amount_is'                                             => '금액은 :value가 아닙니다',
    'search_modifier_amount_less'                                               => '금액이 :value보다 작거나 같음',
    'search_modifier_not_amount_more'                                           => '금액이 :value보다 작거나 같음',
    'search_modifier_amount_more'                                               => '금액이 :value보다 크거나 같음',
    'search_modifier_not_amount_less'                                           => '금액이 :value보다 크거나 같음',
    'search_modifier_source_account_is'                                         => '소스 계정 이름은 정확히 ":value"입니다',
    'search_modifier_not_source_account_is'                                     => '소스 계정 이름은 ":value"가 아닙니다',
    'search_modifier_source_account_contains'                                   => '소스 계정 이름은 ":value"를 포함합니다',
    'search_modifier_not_source_account_contains'                               => '소스 계정 이름은 ":value"를 포함하지 않습니다',
    'search_modifier_source_account_starts'                                     => '소스 계정 이름은 ":value"로 시작합니다',
    'search_modifier_not_source_account_starts'                                 => '소스 계정 이름은 ":value"로 시작하지 않습니다',
    'search_modifier_source_account_ends'                                       => '소스 계정 이름은 ":value"로 끝납니다',
    'search_modifier_not_source_account_ends'                                   => '소스 계정 이름은 ":value"로 끝나지 않습니다',
    'search_modifier_source_account_id'                                         => '소스 계정 ID는 ":value"입니다',
    'search_modifier_not_source_account_id'                                     => '소스 계정 ID는 ":value"가 아닙니다',
    'search_modifier_source_account_nr_is'                                      => '소스 계정 번호(IBAN)는 ":value"입니다',
    'search_modifier_not_source_account_nr_is'                                  => '소스 계정 번호(IBAN)는 ":value"가 아닙니다',
    'search_modifier_source_account_nr_contains'                                => '소스 계정 번호(IBAN)는 ":value"를 포함합니다',
    'search_modifier_not_source_account_nr_contains'                            => '소스 계정 번호(IBAN)는 ":value"를 포함하지 않습니다',
    'search_modifier_source_account_nr_starts'                                  => '소스 계정 번호(IBAN)는 ":value"로 시작합니다',
    'search_modifier_not_source_account_nr_starts'                              => '소스 계정 번호(IBAN)는 ":value"로 시작하지 않습니다',
    'search_modifier_source_account_nr_ends'                                    => '소스 계정 번호(IBAN)는 ":value"로 끝납니다',
    'search_modifier_not_source_account_nr_ends'                                => '소스 계정 번호(IBAN)는 ":value"로 끝나지 않습니다',
    'search_modifier_destination_account_is'                                    => '대상 계정 이름은 정확히 ":value"입니다',
    'search_modifier_not_destination_account_is'                                => '대상 계정 이름은 ":value"가 아닙니다',
    'search_modifier_destination_account_contains'                              => '대상 계정 이름은 ":value"를 포함합니다',
    'search_modifier_not_destination_account_contains'                          => '대상 계정 이름은 ":value"를 포함하지 않습니다',
    'search_modifier_destination_account_starts'                                => '대상 계정 이름은 ":value"로 시작합니다',
    'search_modifier_not_destination_account_starts'                            => '대상 계정 이름은 ":value"로 시작하지 않습니다',
    'search_modifier_destination_account_ends'                                  => '대상 계정 이름은 ":value"로 끝납니다',
    'search_modifier_not_destination_account_ends'                              => '대상 계정 이름은 ":value"로 끝나지 않습니다',
    'search_modifier_destination_account_id'                                    => '대상 계정 ID는 ":value"입니다',
    'search_modifier_not_destination_account_id'                                => '대상 계정 ID는 ":value"가 아닙니다',
    'search_modifier_destination_is_cash'                                       => '대상 계정은 "(현금)" 계정 입니다',
    'search_modifier_not_destination_is_cash'                                   => '대상 계정은 "(현금)" 계정이 아닙니다',
    'search_modifier_source_is_cash'                                            => '소스 계정은 "(현금)" 계정입니다',
    'search_modifier_not_source_is_cash'                                        => '원본 계정이 "(현금)" 계정이 아닙니다',
    'search_modifier_destination_account_nr_is'                                 => '대상 계정 번호(IBAN)는 ":value"입니다',
    'search_modifier_not_destination_account_nr_is'                             => '대상 계정 번호(IBAN)는 ":value"입니다',
    'search_modifier_destination_account_nr_contains'                           => '대상 계정 번호(IBAN)는 ":value"를 포함합니다',
    'search_modifier_not_destination_account_nr_contains'                       => '대상 계정 번호(IBAN)는 ":value"를 포함하지 않습니다',
    'search_modifier_destination_account_nr_starts'                             => '대상 계정 번호(IBAN)는 ":value"로 시작합니다',
    'search_modifier_not_destination_account_nr_starts'                         => '대상 계정 번호(IBAN)는 ":value"로 시작하지 않습니다',
    'search_modifier_destination_account_nr_ends'                               => '대상 계정 번호(IBAN)는 ":value"으로 끝납니다',
    'search_modifier_not_destination_account_nr_ends'                           => '대상 계정 번호(IBAN)는 ":value"으로 끝나지 않습니다',
    'search_modifier_account_id'                                                => '소스 또는 대상 계정 ID는 :value입니다',
    'search_modifier_not_account_id'                                            => '소스 또는 대상 계정 ID는 :value가 아닙니다',
    'search_modifier_category_is'                                               => '카테고리는 ":value" 입니다',
    'search_modifier_not_category_is'                                           => '카테고리는 ":value" 가 아닙니다',
    'search_modifier_budget_is'                                                 => '예산은 ":value" 입니다',
    'search_modifier_not_budget_is'                                             => '예산은 ":value" 가 아닙니다',
    'search_modifier_bill_is'                                                   => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                                               => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                                          => '거래 유형은 ":value" 입니다',
    'search_modifier_not_transaction_type'                                      => '거래 유형은 ":value"가 아닙니다',
    'search_modifier_tag_is'                                                    => '태그는 ":value" 입니다',
    'search_modifier_tag_contains'                                              => '태그는 ":value"를 포함합니다',
    'search_modifier_not_tag_contains'                                          => '태그는 ":value"를 포함하지 않습니다',
    'search_modifier_tag_ends'                                                  => '태그는 ":value"로 끝납니다',
    'search_modifier_tag_starts'                                                => '태그는 ":value"로 시작합니다',
    'search_modifier_not_tag_is'                                                => '":value" 태그가 없습니다.',
    'search_modifier_date_on_year'                                              => '거래는 ":value" 연도에 있습니다',
    'search_modifier_not_date_on_year'                                          => '거래는 ":value" 연도에 있지 않습니다',
    'search_modifier_date_on_month'                                             => '거래는 ":value" 월에 있습니다',
    'search_modifier_not_date_on_month'                                         => '거래는 ":value" 월에 있지 않습니다',
    'search_modifier_date_on_day'                                               => '거래는 ":value" 일에 있습니다',
    'search_modifier_not_date_on_day'                                           => '거래는 ":value" 일에 있지 않습니다',
    'search_modifier_date_before_year'                                          => '거래는 ":value"년 이거나 이전입니다',
    'search_modifier_date_before_month'                                         => '거래는 ":value"월 이거나 이전입니다',
    'search_modifier_date_before_day'                                           => '거래는 ":value"일 이거나 이전입니다',
    'search_modifier_date_after_year'                                           => '거래는 ":value"년 이거나 이후입니다',
    'search_modifier_date_after_month'                                          => '거래는 ":value"월 이거나 이후입니다',
    'search_modifier_date_after_day'                                            => '거래는 ":value"일 이거나 이후입니다',

    // new
    'search_modifier_tag_is_not'                                                => '":value" 태그가 없습니다',
    'search_modifier_not_tag_is_not'                                            => '태그는 ":value" 입니다',
    'search_modifier_account_is'                                                => '계정중 하나는 ":value" 입니다',
    'search_modifier_not_account_is'                                            => '두 계정 모두 ":value"가 아닙니다',
    'search_modifier_account_contains'                                          => '계정중 하나는 ":value"를 포함합니다',
    'search_modifier_not_account_contains'                                      => '두 계정 모두 ":value"를 포함하지 않습니다',
    'search_modifier_account_ends'                                              => '계정중 하나는 ":value"로 끝납니다',
    'search_modifier_not_account_ends'                                          => '두 계정 모두 ":value"로 끝나지 않습니다',
    'search_modifier_account_starts'                                            => '계정중 하나는 ":value"로 시작합니다',
    'search_modifier_not_account_starts'                                        => '두 계정 모두 ":value"로 시작하지 않습니다',
    'search_modifier_account_nr_is'                                             => '계정 번호 / IBAN 중 하나는 ":value"입니다',
    'search_modifier_not_account_nr_is'                                         => '두 계정의 번호 / IBAN은 모두 ":value"가 아닙니다',
    'search_modifier_account_nr_contains'                                       => '계정 번호 / IBAN 중 하나가 ":value"를 포함합니다',
    'search_modifier_not_account_nr_contains'                                   => '두 계정의 번호 / IBAN은 모두 ":value"를 포함하지 않습니다',
    'search_modifier_account_nr_ends'                                           => '계정 번호 / IBAN 중 하나가 ":value"로 끝납니다',
    'search_modifier_not_account_nr_ends'                                       => '두 계정의 번호 / IBAN은 모두 ":value"로 끝나지 않습니다',
    'search_modifier_account_nr_starts'                                         => '계정 번호 / IBAN 중 하나가 ":value"로 시작합니다',
    'search_modifier_not_account_nr_starts'                                     => '두 계정의 번호 / IBAN은 모두 ":value"로 시작하지 않습니다',
    'search_modifier_category_contains'                                         => '카테고리는 ":value"를 포함합니다',
    'search_modifier_not_category_contains'                                     => '카테고리는 ":value"를 포함하지 않습니다',
    'search_modifier_category_ends'                                             => '카테고리는 ":value"로 끝납니다',
    'search_modifier_not_category_ends'                                         => '카테고리는 ":value"로 끝나지 않습니다',
    'search_modifier_category_starts'                                           => '카테고리는 ":value"로 시작합니다',
    'search_modifier_not_category_starts'                                       => '카테고리는 ":value"로 시작하지 않습니다',
    'search_modifier_budget_contains'                                           => '예산은 ":value"를 포함합니다',
    'search_modifier_not_budget_contains'                                       => '예산은 ":value"를 포함하지 않습니다',
    'search_modifier_budget_ends'                                               => '예산은 ":value"로 끝납니다',
    'search_modifier_not_budget_ends'                                           => '예산은 ":value"로 끝나지 않습니다',
    'search_modifier_budget_starts'                                             => '예산은 ":value"로 시작합니다',
    'search_modifier_not_budget_starts'                                         => '예산은 ":value"로 시작하지 않습니다',
    'search_modifier_bill_contains'                                             => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                                         => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                                                 => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                                             => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                                               => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                                           => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                                      => '외부 ID는 ":value"를 포함합니다',
    'search_modifier_not_external_id_contains'                                  => '외부 ID는 ":value"를 포함하지 않습니다',
    'search_modifier_external_id_ends'                                          => '외부 ID는 ":value"로 끝납니다',
    'search_modifier_not_external_id_ends'                                      => '외부 ID는 ":value"로 끝나지 않습니다',
    'search_modifier_external_id_starts'                                        => '외부 ID는 ":value"로 시작합니다',
    'search_modifier_not_external_id_starts'                                    => '외부 ID는 ":value"로 시작하지 않습니다',
    'search_modifier_internal_reference_contains'                               => '내부 참조는 ":value"를 포함합니다',
    'search_modifier_not_internal_reference_contains'                           => '내부 참조는 ":value"를 포함하지 않습니다',
    'search_modifier_internal_reference_ends'                                   => '내부 참조는 ":value"로 끝납니다',
    'search_modifier_internal_reference_starts'                                 => '내부 참조는 ":value"로 시작합니다',
    'search_modifier_not_internal_reference_ends'                               => '내부 참조는 ":value"로 끝나지 않습니다',
    'search_modifier_not_internal_reference_starts'                             => '내부 참조는 ":value"로 시작하지 않습니다',
    'search_modifier_external_url_is'                                           => '외부 URL은 ":value"입니다',
    'search_modifier_not_external_url_is'                                       => '외부 URL은 ":value"가 아닙니다',
    'search_modifier_external_url_contains'                                     => '외부 URL은 ":value"를 포함합니다',
    'search_modifier_not_external_url_contains'                                 => '외부 URL은 ":value"를 포함하지 않습니다',
    'search_modifier_external_url_ends'                                         => '외부 URL은 ":value"로 끝납니다',
    'search_modifier_not_external_url_ends'                                     => '외부 URL은 ":value"로 끝나지 않습니다',
    'search_modifier_external_url_starts'                                       => '외부 URL은 ":value"로 시작합니다',
    'search_modifier_not_external_url_starts'                                   => '외부 URL은 ":value"로 시작하지 않습니다',
    'search_modifier_has_no_attachments'                                        => '거래에 첨부 파일이 없음',
    'search_modifier_not_has_no_attachments'                                    => '거래에 첨부 파일이 있음',
    'search_modifier_not_has_attachments'                                       => '거래에 첨부 파일이 없음',
    'search_modifier_account_is_cash'                                           => '두 계정 중 하나는 "(현금)" 계정입니다.',
    'search_modifier_not_account_is_cash'                                       => '두 계정 모두 "(현금)" 계정이 아닙니다.',
    'search_modifier_journal_id'                                                => '저널 ID는 ":value"입니다',
    'search_modifier_not_journal_id'                                            => '저널 ID는 ":value"가 아닙니다',
    'search_modifier_recurrence_id'                                             => '반복 거래 ID는 ":value"입니다',
    'search_modifier_not_recurrence_id'                                         => '반복 거래 ID는 ":value"가 아닙니다',
    'search_modifier_foreign_amount_is'                                         => '외화 금액은 ":value"입니다',
    'search_modifier_not_foreign_amount_is'                                     => '외화 금액은 ":value"가 아닙니다',
    'search_modifier_foreign_amount_less'                                       => '외화 금액은 ":value" 보다 작습니다',
    'search_modifier_not_foreign_amount_more'                                   => '외화 금액은 ":value" 보다 작습니다',
    'search_modifier_not_foreign_amount_less'                                   => '외화 금액은 ":value" 보다 큽니다',
    'search_modifier_foreign_amount_more'                                       => '외화 금액은 ":value" 보다 큽니다',
    'search_modifier_exists'                                                    => '거래 존재(모든 거래)',
    'search_modifier_not_exists'                                                => '거래가 존재하지 않음(거래 없음)',

    // date fields
    'search_modifier_interest_date_on'                                          => '거래 이자 날짜는 ":value"입니다',
    'search_modifier_not_interest_date_on'                                      => '거래 이자 날짜는 ":value"가 아닙니다',
    'search_modifier_interest_date_on_year'                                     => '거래 이자 날짜는 ":value"년 입니다',
    'search_modifier_not_interest_date_on_year'                                 => '거래 이자 날짜는 ":value"년이 아닙니다',
    'search_modifier_interest_date_on_month'                                    => '거래 이자 날짜는 ":value"월 입니다',
    'search_modifier_not_interest_date_on_month'                                => '거래 이자 날짜는 ":value"월이 아닙니다',
    'search_modifier_interest_date_on_day'                                      => '거래 이자 날짜는 ":value"일 입니다',
    'search_modifier_not_interest_date_on_day'                                  => '거래 이자 날짜는 ":value"일이 아닙니다',
    'search_modifier_interest_date_before_year'                                 => '거래 이자 날짜는 ":value"년 혹은 이전입니다',
    'search_modifier_interest_date_before_month'                                => '거래 이자 날짜는 ":value"월 혹은 이전입니다',
    'search_modifier_interest_date_before_day'                                  => '거래 이자 날짜는 ":value"일 혹은 이전입니다',
    'search_modifier_interest_date_after_year'                                  => '거래 이자 날짜는 ":value"년 혹은 이후입니다',
    'search_modifier_interest_date_after_month'                                 => '거래 이자 날짜는 ":value"월 혹은 이후입니다',
    'search_modifier_interest_date_after_day'                                   => '거래 이자 날짜는 ":value"일 혹은 이후입니다',
    'search_modifier_book_date_on_year'                                         => '거래 장부 날짜는 ":value"년 입니다',
    'search_modifier_book_date_on_month'                                        => '거래 장부 날짜는 ":value"월 입니다',
    'search_modifier_book_date_on_day'                                          => '거래 장부 날짜는 ":value"일 입니다',
    'search_modifier_not_book_date_on_year'                                     => '거래 장부 날짜는 ":value"년이 아닙니다',
    'search_modifier_not_book_date_on_month'                                    => '거래 장부 날짜는 ":value"월이 아닙니다',
    'search_modifier_not_book_date_on_day'                                      => '거래 장부 날짜는 ":value"일이 아닙니다',
    'search_modifier_book_date_before_year'                                     => '거래 장부 날짜는 ":value"년 혹은 이전입니다',
    'search_modifier_book_date_before_month'                                    => '거래 장부 날짜는 ":value"월 혹은 이전입니다',
    'search_modifier_book_date_before_day'                                      => '거래 장부 날짜는 ":value"일 혹은 이전입니다',
    'search_modifier_book_date_after_year'                                      => '거래 장부 날짜는 ":value"년 혹은 이후입니다',
    'search_modifier_book_date_after_month'                                     => '거래 장부 날짜는 ":value"월 혹은 이후입니다',
    'search_modifier_book_date_after_day'                                       => '거래 장부 날짜는 ":value"일 혹은 이후입니다',
    'search_modifier_process_date_on_year'                                      => '거래 처리 날짜는 ":value"년 입니다',
    'search_modifier_process_date_on_month'                                     => '거래 처리 날짜는 ":value"월 입니다',
    'search_modifier_process_date_on_day'                                       => '거래 처리 날짜는 ":value"일입니다',
    'search_modifier_not_process_date_on_year'                                  => '거리 처리 날짜가 ":value"년이 아닙니다',
    'search_modifier_not_process_date_on_month'                                 => '거리 처리 날짜가 ":value"월이 아닙니다',
    'search_modifier_not_process_date_on_day'                                   => '거래 처리 날짜가 ":value"일이 아닙니다',
    'search_modifier_process_date_before_year'                                  => '거래 처리 날짜가 ":value"년 혹은 이전입니다',
    'search_modifier_process_date_before_month'                                 => '거래 처리 날짜가 ":value"월 혹은 이전입니다',
    'search_modifier_process_date_before_day'                                   => '거래 처리 날짜가 ":value"일 혹은 이전입니다',
    'search_modifier_process_date_after_year'                                   => '거래 처리 날짜가 ":value"년 혹은 이후입니다',
    'search_modifier_process_date_after_month'                                  => '거래 처리 날짜가 ":value"월 혹은 이후입니다',
    'search_modifier_process_date_after_day'                                    => '거래 처리 날짜가 ":value"일 혹은 이후입니다',
    'search_modifier_due_date_on_year'                                          => '거래 마감일은 ":value"년입니다',
    'search_modifier_due_date_on_month'                                         => '거래 마감일은 ":value"월입니다',
    'search_modifier_due_date_on_day'                                           => '거래 마감일은 ":value"일입니다',
    'search_modifier_not_due_date_on_year'                                      => '거래 마감일이 ":value"년이 아닙니다',
    'search_modifier_not_due_date_on_month'                                     => '거래 마감일이 ":value"월이 아닙니다',
    'search_modifier_not_due_date_on_day'                                       => '거래 마감일이 ":value"일이 아닙니다',
    'search_modifier_due_date_before_year'                                      => '거래 마감일이 ":value"년 혹은 이전입니다',
    'search_modifier_due_date_before_month'                                     => '거래 마감일이 ":value"월 혹은 이전입니다',
    'search_modifier_due_date_before_day'                                       => '거래 마감일이 ":value"일 혹은 이전입니다',
    'search_modifier_due_date_after_year'                                       => '거래 마감일이 ":value"년 혹은 이후입니다',
    'search_modifier_due_date_after_month'                                      => '거래 마감일이 ":value"월 혹은 이후입니다',
    'search_modifier_due_date_after_day'                                        => '거래 마감일이 ":value"일 혹은 이후입니다',
    'search_modifier_payment_date_on_year'                                      => '거래 결제일은 ":value"년입니다',
    'search_modifier_payment_date_on_month'                                     => '거래 결제일은 ":value"월입니다',
    'search_modifier_payment_date_on_day'                                       => '거래 결제일은 ":value"일입니다',
    'search_modifier_not_payment_date_on_year'                                  => '거래 결제일은 ":value"년이 아닙니다',
    'search_modifier_not_payment_date_on_month'                                 => '거래 결제일은 ":value"월이 아닙니다',
    'search_modifier_not_payment_date_on_day'                                   => '거래 결제일은 ":value"일이 아닙니다',
    'search_modifier_payment_date_before_year'                                  => '거래 결제일은 ":value"년 혹은 이전입니다',
    'search_modifier_payment_date_before_month'                                 => '거래 결제일은 ":value"월 혹은 이전입니다',
    'search_modifier_payment_date_before_day'                                   => '거래 결제일은 ":value"일 혹은 이전입니다',
    'search_modifier_payment_date_after_year'                                   => '거래 결제일은 ":value"년 혹은 이후입니다',
    'search_modifier_payment_date_after_month'                                  => '거래 결제일은 ":value"월 혹은 이후입니다',
    'search_modifier_payment_date_after_day'                                    => '거래 결제일은 ":value"일 혹은 이후입니다',
    'search_modifier_invoice_date_on_year'                                      => '거래 송장 날짜는 ":value"년입니다',
    'search_modifier_invoice_date_on_month'                                     => '거래 송장 날짜는 ":value"월입니다',
    'search_modifier_invoice_date_on_day'                                       => '거래 송장 날짜는 ":value"일입니다',
    'search_modifier_not_invoice_date_on_year'                                  => '거래 송장 날짜는 ":value"년이 아닙니다',
    'search_modifier_not_invoice_date_on_month'                                 => '거래 송장 날짜는 ":value"월이 아닙니다',
    'search_modifier_not_invoice_date_on_day'                                   => '거래 송장 날짜는 ":value"일이 아닙니다',
    'search_modifier_invoice_date_before_year'                                  => '거래 송장 날짜는 ":value"년 혹은 이전입니다',
    'search_modifier_invoice_date_before_month'                                 => '거래 송장 날짜는 ":value"월 혹은 이전입니다',
    'search_modifier_invoice_date_before_day'                                   => '거래 송장 날짜는 ":value"일 혹은 이전입니다',
    'search_modifier_invoice_date_after_year'                                   => '거래 송장 날짜는 ":value"년 혹은 이후입니다',
    'search_modifier_invoice_date_after_month'                                  => '거래 송장 날짜는 ":value"월 혹은 이후입니다',
    'search_modifier_invoice_date_after_day'                                    => '거래 송장 날짜는 ":value"일 혹은 이후입니다',
    // other dates
    'search_modifier_updated_at_on_year'                                        => '거래가 ":value"년에 마지막으로 업데이트되었습니다',
    'search_modifier_updated_at_on_month'                                       => '거래가 ":value"월에 마지막으로 업데이트되었습니다',
    'search_modifier_updated_at_on_day'                                         => '거래가 ":value"일에 마지막으로 업데이트되었습니다',
    'search_modifier_not_updated_at_on_year'                                    => '거래가 ":value"년에 마지막으로 업데이트되지 않았습니다',
    'search_modifier_not_updated_at_on_month'                                   => '거래가 ":value"월에 마지막으로 업데이트되지 않았습니다',
    'search_modifier_not_updated_at_on_day'                                     => '거래가 ":value"일에 마지막으로 업데이트되지 않았습니다',
    'search_modifier_updated_at_before_year'                                    => '거래가 ":value"년 혹은 이전에 마지막으로 업데이트되었습니다',
    'search_modifier_updated_at_before_month'                                   => '거래가 ":value"월 혹은 이전에 마지막으로 업데이트되었습니다',
    'search_modifier_updated_at_before_day'                                     => '거래가 ":value"일 혹은 이전에 마지막으로 업데이트되었습니다',
    'search_modifier_updated_at_after_year'                                     => '거래가 ":value"년 혹은 이후에 마지막으로 업데이트되었습니다',
    'search_modifier_updated_at_after_month'                                    => '거래가 ":value"월 혹은 이후에 마지막으로 업데이트되었습니다',
    'search_modifier_updated_at_after_day'                                      => '거래가 ":value"일 혹은 이후에 마지막으로 업데이트되었습니다',
    'search_modifier_created_at_on_year'                                        => '거래가 ":value"년에 생성되었습니다',
    'search_modifier_created_at_on_month'                                       => '거래가 ":value"월에 생성되었습니다',
    'search_modifier_created_at_on_day'                                         => '거래가 ":value"일에 생성되었습니다',
    'search_modifier_not_created_at_on_year'                                    => '거래가 ":value"년에 생성되지 않았습니다',
    'search_modifier_not_created_at_on_month'                                   => '거래가 ":value"월에 생성되지 않았습니다',
    'search_modifier_not_created_at_on_day'                                     => '거래가 ":value"일에 생성되지 않았습니다',
    'search_modifier_created_at_before_year'                                    => '거래가 ":value"년 혹은 이전에 생성되었습니다',
    'search_modifier_created_at_before_month'                                   => '거래가 ":value"월 혹은 이전에 생성되었습니다',
    'search_modifier_created_at_before_day'                                     => '거래가 ":value"일 혹은 이전에 생성되었습니다',
    'search_modifier_created_at_after_year'                                     => '거래가 ":value"년 혹은 이후에 생성되었습니다',
    'search_modifier_created_at_after_month'                                    => '거래가 ":value"월 혹은 이후에 생성되었습니다',
    'search_modifier_created_at_after_day'                                      => '거래가 ":value"일 혹은 이후에 생성되었습니다',
    'search_modifier_interest_date_before'                                      => '거래 이자 날짜가 ":value" 또는 그 이전입니다',
    'search_modifier_interest_date_after'                                       => '거래 이자 날짜가 ":value" 또는 그 이후입니다',
    'search_modifier_book_date_on'                                              => '거래 장부 날짜는 ":value"입니다',
    'search_modifier_not_book_date_on'                                          => '거래 장부 날짜는 ":value"가 아닙니다',
    'search_modifier_book_date_before'                                          => '거래 장부 날짜가 ":value" 또는 그 이전입니다',
    'search_modifier_book_date_after'                                           => '거래 장부 날짜가 ":value" 또는 그 이후입니다',
    'search_modifier_process_date_on'                                           => '거래 처리 날짜는 ":value"입니다',
    'search_modifier_not_process_date_on'                                       => '거래 처리 날짜는 ":value"가 아닙니다',
    'search_modifier_process_date_before'                                       => '거래 처리 날짜가 ":value" 또는 그 이전입니다',
    'search_modifier_process_date_after'                                        => '거래 처리 날짜가 ":value" 또는 그 이후입니다',
    'search_modifier_due_date_on'                                               => '거래 마감일은 ":value"입니다',
    'search_modifier_not_due_date_on'                                           => '거래 마감일은 ":value"가 아닙니다',
    'search_modifier_due_date_before'                                           => '거래 마감일이 ":value" 또는 그 이전 입니다',
    'search_modifier_due_date_after'                                            => '거래 마감일이 ":value" 또는 그 이후 입니다',
    'search_modifier_payment_date_on'                                           => '거래 결제일은 ":value"입니다',
    'search_modifier_not_payment_date_on'                                       => '거래 결제일은 ":value"가 아닙니다',
    'search_modifier_payment_date_before'                                       => '거래 결제일은 ":value" 또는 그 이전입니다',
    'search_modifier_payment_date_after'                                        => '거래 결제일은 ":value" 또는 그 이후입니다',
    'search_modifier_invoice_date_on'                                           => '거래 송장 날짜는 ":value"입니다',
    'search_modifier_not_invoice_date_on'                                       => '거래 송장 날짜는 ":value"가 아닙니다',
    'search_modifier_invoice_date_before'                                       => '거래 송장 날짜는 ":value" 또는 그 이전입니다',
    'search_modifier_invoice_date_after'                                        => '거래 송장 날짜는 ":value" 또는 그 이후입니다',
    'search_modifier_created_at_on'                                             => '거래가 ":value"에 생성되었습니다',
    'search_modifier_not_created_at_on'                                         => '거래가 ":value"에 생성되지 않았습니다',
    'search_modifier_created_at_before'                                         => '거래가 ":value" 혹은 이전에 생성되었습니다',
    'search_modifier_created_at_after'                                          => '거래가 ":value" 혹은 이후에 생성되었습니다',
    'search_modifier_updated_at_on'                                             => '거래가 ":value"에 업데이트되었습니다',
    'search_modifier_not_updated_at_on'                                         => '거래가 ":value"에 업데이트되지 않았습니다',
    'search_modifier_updated_at_before'                                         => '거래가 ":value" 또는 이전에 업데이트되었습니다',
    'search_modifier_updated_at_after'                                          => '거래가 ":value" 이후에 마지막으로 업데이트되었습니다',

    'search_modifier_attachment_name_is'                                        => '첨부 파일의 이름은 ":value"입니다',
    'search_modifier_attachment_name_contains'                                  => '첨부 파일의 이름은 ":value"를 포함합니다',
    'search_modifier_attachment_name_starts'                                    => '첨부 파일의 이름은 ":value"로 시작합니다',
    'search_modifier_attachment_name_ends'                                      => '첨부 파일의 이름은 ":value"로 끝납니다',
    'search_modifier_attachment_notes_are'                                      => '첨부 파일의 노트는 ":value"입니다',
    'search_modifier_attachment_notes_contains'                                 => '첨부 파일의 노트는 ":value"를 포함합니다',
    'search_modifier_attachment_notes_starts'                                   => '첨부 파일의 노트는 ":value"로 시작합니다',
    'search_modifier_attachment_notes_ends'                                     => '첨부 파일의 노트는 ":value"로 끝납니다',
    'search_modifier_not_attachment_name_is'                                    => '첨부 파일의 이름은 ":value"가 아닙니다',
    'search_modifier_not_attachment_name_contains'                              => '첨부 파일의 이름은 ":value"를 포함하지 않습니다',
    'search_modifier_not_attachment_name_starts'                                => '첨부 파일의 이름은 ":value"로 시작하지 않습니다',
    'search_modifier_not_attachment_name_ends'                                  => '첨부 파일의 이름은 ":value"로 끝나지 않습니다',
    'search_modifier_not_attachment_notes_are'                                  => '첨부 파일의 노트는 ":value"가 아닙니다',
    'search_modifier_not_attachment_notes_contains'                             => '첨부 파일의 노트는 ":value"를 포함하지 않습니다',
    'search_modifier_not_attachment_notes_starts'                               => '첨부 파일의 노트는 ":value"로 시작합니다',
    'search_modifier_not_attachment_notes_ends'                                 => '첨부 파일의 노트는 ":value"로 끝나지 않습니다',
    'search_modifier_sepa_ct_is'                                                => 'SEPA CT는 ":value"입니다',
    'update_rule_from_query'                                                    => '검색 쿼리에서 ":rule" 규칙 업데이트하기',
    'create_rule_from_query'                                                    => '검색 쿼리에서 새 규칙 만들기',
    'rule_from_search_words'                                                    => '규칙 엔진은 ":string"을 처리하는 데 어려움을 겪습니다. 검색 쿼리에 맞는 제안된 규칙이 다른 결과를 제공할 수 있습니다. 규칙 트리거를 주의 깊게 확인하세요.',

    // more new stuff
    'search_modifier_destination_balance_is'                                    => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'                                => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'                                         => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'                                     => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'                                   => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte'                               => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'                                        => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'                                    => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'                                    => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt'                                => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'                                         => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'                                     => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'                                   => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte'                               => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'                                        => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'                                    => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'                                    => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'                                => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                                         => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'                                     => 'Source account balance is less than or equal to ":value"',




    // END
    'general_search_error'                                                      => '검색하는 동안 오류가 발생했습니다. 자세한 내용은 로그 파일을 확인해 주세요.',
    'search_box'                                                                => '검색',
    'search_box_intro'                                                          => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                                              => '검색 중 오류',
    'search_searching'                                                          => '검색중...',
    'search_results'                                                            => '검색 결과',

    // repeat frequencies:
    'repeat_freq_yearly'                                                        => '연간',
    'repeat_freq_half-year'                                                     => '반년마다',
    'repeat_freq_quarterly'                                                     => '분기별',
    'repeat_freq_monthly'                                                       => '월간',
    'repeat_freq_weekly'                                                        => '주간',
    'repeat_freq_daily'                                                         => '일별',
    'daily'                                                                     => '일별',
    'weekly'                                                                    => '주간',
    'quarterly'                                                                 => '분기별',
    'half-year'                                                                 => '반년마다',
    'yearly'                                                                    => '연간',

    // rules
    'is_not_rule_trigger'                                                       => '제외',
    'cannot_fire_inactive_rules'                                                => '비활성 규칙을 실행할 수 없습니다.',
    'show_triggers'                                                             => '트리거 보기',
    'show_actions'                                                              => '액션 보기',
    'rules'                                                                     => '규칙',
    'rule_name'                                                                 => '규칙 이름',
    'rule_triggers'                                                             => '규칙이 트리거되는 경우',
    'rule_actions'                                                              => '규칙은 다음과 같습니다',
    'new_rule'                                                                  => '새 규칙',
    'new_rule_group'                                                            => '새 규칙 그룹',
    'rule_priority_up'                                                          => '규칙 우선 순위 올림',
    'rule_priority_down'                                                        => '규칙 우선 순위 내림',
    'make_new_rule_group'                                                       => '새 규칙 그룹 만들기',
    'store_new_rule_group'                                                      => '새 규칙 그룹 저장',
    'created_new_rule_group'                                                    => '새 규칙 그룹 ":title"이(가) 저장되었습니다!',
    'updated_rule_group'                                                        => '":title" 규칙 그룹을 성공적으로 업데이트했습니다.',
    'edit_rule_group'                                                           => '":title" 규칙 그룹 수정',
    'duplicate_rule'                                                            => '중복 규칙 ":title"',
    'rule_copy_of'                                                              => '":title" 복사',
    'duplicated_rule'                                                           => '":title" 규칙을 ":newTitle"으로 복제했습니다',
    'delete_rule_group'                                                         => '규칙 그룹 ":title" 삭제',
    'deleted_rule_group'                                                        => '삭제된 규칙 그룹 ":title"',
    'update_rule_group'                                                         => '규칙 그룹 업데이트',
    'no_rules_in_group'                                                         => '이 그룹에는 규칙이 없습니다',
    'move_rule_group_up'                                                        => '규칙 그룹 위로 이동',
    'move_rule_group_down'                                                      => '규칙 그룹 아래로 이동',
    'save_rules_by_moving'                                                      => '이 규칙을 다른 규칙 그룹으로 이동하여 저장합니다:|이 규칙들을 다른 규칙 그룹으로 이동하여 저장합니다:',
    'make_new_rule'                                                             => '규칙 그룹 ":title"에서 새 규칙 만들기',
    'make_new_rule_no_group'                                                    => '새 규칙 만들기',
    'instructions_rule_from_bill'                                               => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                                            => '거래 중 하나를 기반으로 규칙을 만듭니다. 아래 양식을 보완하거나 제출하세요.',
    'rule_is_strict'                                                            => '엄격한 규칙',
    'rule_is_not_strict'                                                        => '엄격하지 않은 규칙',
    'rule_help_stop_processing'                                                 => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                                          => '엄격한 규칙은 모든 트리거가 실행되어야 액션이 실행됩니다. 엄격한 규칙이 아닌 경우, 하나의 트리거만 실행되더라도 액션이 실행될 수 있습니다.',
    'rule_help_active'                                                          => '비활성화된 규칙은 절대 실행되지 않습니다.',
    'stored_new_rule'                                                           => '제목 ":title"을 사용하여 새 규칙 저장',
    'deleted_rule'                                                              => '제목이 ":title"인 규칙을 삭제했습니다',
    'store_new_rule'                                                            => '새 규칙 저장',
    'updated_rule'                                                              => '제목 ":title"으로 규칙 업데이트',
    'default_rule_group_name'                                                   => '기본 규칙',
    'default_rule_group_description'                                            => '특정 그룹에 속하지 않은 모든 규칙.',
    'trigger'                                                                   => '트리거',
    'trigger_value'                                                             => '값 트리거',
    'stop_processing_other_triggers'                                            => '다른 트리거 처리 중지',
    'add_rule_trigger'                                                          => '새 트리거 추가',
    'action'                                                                    => '액션',
    'action_value'                                                              => '액션 값',
    'stop_executing_other_actions'                                              => '다른 액션 실행 중지',
    'add_rule_action'                                                           => '새 액션 추가',
    'edit_rule'                                                                 => 'Edit rule #:nr ":title"',
    'delete_rule'                                                               => '":title" 규칙 삭제',
    'update_rule'                                                               => '규칙 업데이트',
    'test_rule_triggers'                                                        => '일치하는 거래 보기',
    'warning_no_matching_transactions'                                          => '일치하는 거래가 없습니다.',
    'warning_no_valid_triggers'                                                 => '유효한 트리거가 제공되지 않았습니다.',
    'apply_rule_selection'                                                      => '선택한 거래에 ":title" 규칙 적용',
    'apply_rule_selection_intro'                                                => '":title"과 같은 규칙은 일반적으로 새 거래나 업데이트된 거래에만 적용되지만, 기존 거래 중 일부에 대해 이 규칙을 실행하도록 Firefly III에 지시할 수 있습니다. 이 기능은 규칙을 업데이트한 후 다른 모든 거래에 변경 사항을 적용해야 할 때 유용합니다.',
    'include_transactions_from_accounts'                                        => '이 계정의 거래 포함',
    'include'                                                                   => '포함되었나요?',
    'applied_rule_selection'                                                    => '{0} 선택 항목의 거래가 규칙 ":title"에 의해 변경되지 않았습니다.|[1] 선택 항목의 하나의 거래가 규칙 ":title"에 의해 변경되었습니다.|[2,*] 선택 항목의 :count개의 거래가 규칙 ":title"에 의해 변경되었습니다.',
    'execute'                                                                   => '실행',
    'apply_rule_group_selection'                                                => '선택한 거래에 규칙 그룹 ":title"을 적용합니다',
    'apply_rule_group_selection_intro'                                          => '":title"과 같은 규칙 그룹은 일반적으로 새 거래나 업데이트된 거래에만 적용되지만, 기존 거래 중 일부에 대해 이 그룹의 모든 규칙을 실행하도록 Firefly III에 지시할 수 있습니다. 이 기능은 규칙 그룹을 업데이트하고 변경 사항을 다른 모든 거래에 적용해야 할 때 유용할 수 있습니다.',
    'applied_rule_group_selection'                                              => '선택 항목에 규칙 그룹 ":title"이 적용되었습니다.',

    // actions and triggers
    'rule_trigger_store_journal'                                                => '거래가 생성될 때',
    'rule_trigger_update_journal'                                               => '거래가 업데이트될 때',
    'rule_trigger_manual'                                                       => 'Only when user-activated',
    'rule_trigger_user_action'                                                  => '사용자 액션은 ":trigger_value" 입니다',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'                                 => '소스 계정 이름은 ...로 시작합니다.',
    'rule_trigger_source_account_starts'                                        => '소스 계정 이름은 ":trigger_value"로 시작합니다',
    'rule_trigger_source_account_ends_choice'                                   => '소스 계정 이름은 ...로 끝납니다.',
    'rule_trigger_source_account_ends'                                          => '소스 계정 이름은 ":trigger_value"로 끝납니다',
    'rule_trigger_source_account_is_choice'                                     => '소스 계정 이름은...',
    'rule_trigger_source_account_is'                                            => '소스 계정 이름은 ":trigger_value"입니다',
    'rule_trigger_source_account_contains_choice'                               => '소스 계정 이름에는 다음이 포함됩니다.',
    'rule_trigger_source_account_contains'                                      => '소스 계정 이름에 ":trigger_value"가 포함됩니다',
    'rule_trigger_account_id_choice'                                            => '계정중 하나의 ID는 정확히..',
    'rule_trigger_account_id'                                                   => '계정중 하나의 ID가 정확히 :trigger_value와 일치합니다',
    'rule_trigger_source_account_id_choice'                                     => '소스 계정 ID는 정확히..',
    'rule_trigger_source_account_id'                                            => '소스 계정 ID가 정확히 :trigger_value와 일치합니다.',
    'rule_trigger_destination_account_id_choice'                                => '대상 계정 ID는 정확히..',
    'rule_trigger_destination_account_id'                                       => '대상 계정 ID가 정확히 :trigger_value와 일치합니다.',
    'rule_trigger_account_is_cash_choice'                                       => '계정중 하나는 현금입니다',
    'rule_trigger_account_is_cash'                                              => '계정중 하나는 현금입니다',
    'rule_trigger_source_is_cash_choice'                                        => '소스 계정은 (현금) 계정입니다',
    'rule_trigger_source_is_cash'                                               => '소스 계정은 (현금) 계정입니다',
    'rule_trigger_destination_is_cash_choice'                                   => '대상 계정은 (현금) 계정입니다',
    'rule_trigger_destination_is_cash'                                          => '대상 계정은 (현금) 계정입니다',
    'rule_trigger_source_account_nr_starts_choice'                              => '소스 계좌 번호/IBAN은...로 시작합니다.',
    'rule_trigger_source_account_nr_starts'                                     => '소스 계정 번호 / IBAN은 ":trigger_value"로 시작합니다',
    'rule_trigger_source_account_nr_ends_choice'                                => '소스 계정 번호 / IBAN은 ...로 끝납니다',
    'rule_trigger_source_account_nr_ends'                                       => '소스 계정 번호 / IBAN은 ":trigger_value"로 끝납니다',
    'rule_trigger_source_account_nr_is_choice'                                  => '소스 계정 번호 / IBAN은..',
    'rule_trigger_source_account_nr_is'                                         => '소스 계정 번호 / IBAN은 ":trigger_value"입니다',
    'rule_trigger_source_account_nr_contains_choice'                            => '소스 계정 번호 / IBAN은 ..를 포함합니다',
    'rule_trigger_source_account_nr_contains'                                   => '소스 계정 번호 / IBAN은 ":trigger_value"를 포함합니다',
    'rule_trigger_destination_account_starts_choice'                            => '대상 계정 이름은 ...로 시작합니다.',
    'rule_trigger_destination_account_starts'                                   => '대상 계정 이름은 ":trigger_value"로 시작합니다',
    'rule_trigger_destination_account_ends_choice'                              => '대상 계정 이름은 ...로 끝납니다',
    'rule_trigger_destination_account_ends'                                     => '대상 계정 이름은 ":trigger_value"로 끝납니다',
    'rule_trigger_destination_account_is_choice'                                => '대상 계정 이름은..',
    'rule_trigger_destination_account_is'                                       => '대상 계정 이름은 ":trigger_value"입니다',
    'rule_trigger_destination_account_contains_choice'                          => '대상 계정 이름은 ...를 포함합니다',
    'rule_trigger_destination_account_contains'                                 => '대상 계정 이름은 ":trigger_value"를 포함합니다',
    'rule_trigger_destination_account_nr_starts_choice'                         => '대상 계좌 번호 / IBAN은...로 시작합니다',
    'rule_trigger_destination_account_nr_starts'                                => '대상 계정 번호 / IBAN은 ":trigger_value"로 시작합니다',
    'rule_trigger_destination_account_nr_ends_choice'                           => '대상 계좌 번호 / IBAN은...로 끝납니다',
    'rule_trigger_destination_account_nr_ends'                                  => '대상 계정 번호 / IBAN은 ":trigger_value"로 끝납니다',
    'rule_trigger_destination_account_nr_is_choice'                             => '대상 계정 번호 / IBAN은..',
    'rule_trigger_destination_account_nr_is'                                    => '대상 계정 번호 / IBAN은 ":trigger_value"입니다',
    'rule_trigger_destination_account_nr_contains_choice'                       => '대상 계좌 번호 / IBAN은...를 포함합니다',
    'rule_trigger_destination_account_nr_contains'                              => '대상 계정 번호 / IBAN은 ":trigger_value"를 포함합니다',
    'rule_trigger_transaction_type_choice'                                      => '거래는 .. 유형입니다',
    'rule_trigger_transaction_type'                                             => '거래는 ":trigger_value" 유형입니다',
    'rule_trigger_category_is_choice'                                           => '카테고리는 ..',
    'rule_trigger_category_is'                                                  => '카테고리는 ":trigger_value"입니다',
    'rule_trigger_amount_less_choice'                                           => '금액이 .. 와 작거나 같음',
    'rule_trigger_amount_less'                                                  => '금액이 :trigger_value와 작거나 같음',
    'rule_trigger_amount_is_choice'                                             => '금액은..',
    'rule_trigger_amount_is'                                                    => '금액은 :trigger_value입니다',
    'rule_trigger_amount_more_choice'                                           => '금액이 .. 와 크거나 같음',
    'rule_trigger_amount_more'                                                  => '금액이 :trigger_value와 크거나 같음',
    'rule_trigger_description_starts_choice'                                    => '설명이 ..로 시작합니다',
    'rule_trigger_description_starts'                                           => '설명이 ":trigger_value"로 시작합니다',
    'rule_trigger_description_ends_choice'                                      => '설명이 ..로 끝납니다',
    'rule_trigger_description_ends'                                             => '설명이 ":trigger_value"로 끝납니다',
    'rule_trigger_description_contains_choice'                                  => '설명은 ..를 포함합니다',
    'rule_trigger_description_contains'                                         => '설명은 ":trigger_value"를 포함합니다',
    'rule_trigger_description_is_choice'                                        => '설명은..',
    'rule_trigger_description_is'                                               => '설명은 ":trigger_value"입니다',
    'rule_trigger_date_on_choice'                                               => '거래 날짜는..',
    'rule_trigger_date_on'                                                      => '거래 날짜는 ":trigger_value"입니다',
    'rule_trigger_date_before_choice'                                           => '거래 날짜는 .. 이전입니다',
    'rule_trigger_date_before'                                                  => '거래 날짜는 ":trigger_value" 이전입니다',
    'rule_trigger_date_after_choice'                                            => '거래 날짜는 .. 이후입니다',
    'rule_trigger_date_after'                                                   => '거래 날짜는 ":trigger_value" 이후입니다',
    'rule_trigger_created_at_on_choice'                                         => '거래가 이루어진 날짜는..',
    'rule_trigger_created_at_on'                                                => '거래가 이루어진 날짜는 ":trigger_value"입니다',
    'rule_trigger_updated_at_on_choice'                                         => '거래가 마지막으로 수정된 날짜는...',
    'rule_trigger_updated_at_on'                                                => '거래가 마지막으로 수정된 날짜는 ":trigger_value"입니다',
    'rule_trigger_budget_is_choice'                                             => '예산은..',
    'rule_trigger_budget_is'                                                    => '예산은 ":trigger_value"입니다',
    'rule_trigger_tag_is_choice'                                                => '모든 태그는...',
    'rule_trigger_tag_is'                                                       => '모든 태그는 ":trigger_value"입니다',
    'rule_trigger_tag_contains_choice'                                          => '..을 포함하는 태그',
    'rule_trigger_tag_contains'                                                 => '태그는 ":trigger_value"을 포함합니다.',
    'rule_trigger_tag_ends_choice'                                              => '..로 끝나는 태그',
    'rule_trigger_tag_ends'                                                     => '태그는 ":trigger_value"로 끝납니다.',
    'rule_trigger_tag_starts_choice'                                            => '..으로 시작하는 태그',
    'rule_trigger_tag_starts'                                                   => '태그는 ":trigger_value"로 시작합니다.',
    'rule_trigger_currency_is_choice'                                           => '거래 통화는..',
    'rule_trigger_currency_is'                                                  => '거래 통화는 ":trigger_value"입니다',
    'rule_trigger_foreign_currency_is_choice'                                   => '거래 외화 통화는..',
    'rule_trigger_foreign_currency_is'                                          => '거래 외화 통화는 ":trigger_value"입니다',
    'rule_trigger_has_attachments_choice'                                       => 'Has any attachments',
    'rule_trigger_has_attachments'                                              => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                                       => '카테고리가 없음',
    'rule_trigger_has_no_category'                                              => '거래에 카테고리가 없음',
    'rule_trigger_has_any_category_choice'                                      => '카테고리가 있음',
    'rule_trigger_has_any_category'                                             => '거래에 카테고리가 있음',
    'rule_trigger_has_no_budget_choice'                                         => '예산이 없음',
    'rule_trigger_has_no_budget'                                                => '거레에 예산이 없음',
    'rule_trigger_has_any_budget_choice'                                        => '예산이 있음',
    'rule_trigger_has_any_budget'                                               => '거래에 예산이 있음',
    'rule_trigger_has_no_bill_choice'                                           => 'Has no subscription',
    'rule_trigger_has_no_bill'                                                  => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                                          => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                                                 => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                                            => '태그 없음',
    'rule_trigger_has_no_tag'                                                   => '거래에 태그가 없음',
    'rule_trigger_has_any_tag_choice'                                           => '하나 이상의 태그가 있음',
    'rule_trigger_has_any_tag'                                                  => '거래에 하나 이상의 태그가 있음',
    'rule_trigger_any_notes_choice'                                             => '메모가 있음',
    'rule_trigger_any_notes'                                                    => '거래에 메모가 있음',
    'rule_trigger_no_notes_choice'                                              => '메모가 없음',
    'rule_trigger_no_notes'                                                     => '거래에 메모가 없음',
    'rule_trigger_notes_is_choice'                                              => '메모는..',
    'rule_trigger_notes_is'                                                     => '메모는 ":trigger_value" 입니다',
    'rule_trigger_notes_contains_choice'                                        => '노트는 다음을 포함',
    'rule_trigger_notes_contains'                                               => '노트는 ":trigger_value"를 포함',
    'rule_trigger_notes_starts_choice'                                          => '노트는 다음으로 시작',
    'rule_trigger_notes_starts'                                                 => '노트는 ":trigger_value"로 시작',
    'rule_trigger_notes_ends_choice'                                            => '노트는 다음으로 끝남',
    'rule_trigger_notes_ends'                                                   => '노트는 ":trigger_value"로 끝남',
    'rule_trigger_bill_is_choice'                                               => 'Subscription is..',
    'rule_trigger_bill_is'                                                      => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                                        => '외부 ID는..',
    'rule_trigger_external_id_is'                                               => '외부 ID는 ":trigger_value"임',
    'rule_trigger_internal_reference_is_choice'                                 => '내부 참조는..',
    'rule_trigger_internal_reference_is'                                        => '내부 참조는 ":trigger_value"임',
    'rule_trigger_journal_id_choice'                                            => '거래 저널 ID는..',
    'rule_trigger_journal_id'                                                   => '거래 저널 ID는 ":trigger_value"임',
    'rule_trigger_any_external_url'                                             => '거래에 (어떤) 외부 URL이 있음',
    'rule_trigger_any_external_url_choice'                                      => '거래에 (어떤) 외부 URL이 있음',
    'rule_trigger_any_external_id'                                              => '거래에 (어떤) 외부 ID가 있음',
    'rule_trigger_any_external_id_choice'                                       => '거래에 (어떤) 외부 ID가 있음',
    'rule_trigger_no_external_url_choice'                                       => '거래에 외부 URL이 없습니다',
    'rule_trigger_no_external_url'                                              => '거래에 외부 URL이 없습니다',
    'rule_trigger_no_external_id_choice'                                        => '거래에 외부 ID가 없음',
    'rule_trigger_no_external_id'                                               => '거래에 외부 ID가 없음',
    'rule_trigger_id_choice'                                                    => '거래 ID는..',
    'rule_trigger_id'                                                           => '거래 ID는 ":trigger_value"임',
    'rule_trigger_sepa_ct_is_choice'                                            => 'SEPA CT는..',
    'rule_trigger_sepa_ct_is'                                                   => 'SEPA CT는 ":trigger_value"임',

    // new values:
    'rule_trigger_user_action_choice'                                           => '사용자 액션은 ":trigger_value" 입니다',
    'rule_trigger_tag_is_not_choice'                                            => '태그가 없습니다.',
    'rule_trigger_tag_is_not'                                                   => '":trigger_value" 태그가 없습니다',
    'rule_trigger_account_is_choice'                                            => '계정중 하나는 정확히 .. 입니다',
    'rule_trigger_account_is'                                                   => '계정중 하나는 정확히 ":trigger_value"입니다',
    'rule_trigger_account_contains_choice'                                      => '계정중 하나는 ..를 포함합니다',
    'rule_trigger_account_contains'                                             => '계정중 하나는 ":trigger_value"를 포함합니다',
    'rule_trigger_account_ends_choice'                                          => '계정중 하나는 ..로 끝납니다',
    'rule_trigger_account_ends'                                                 => '계정중 하나는 ":trigger_value"로 끝납니다',
    'rule_trigger_account_starts_choice'                                        => '계정중 하나는 ..로 시작합니다',
    'rule_trigger_account_starts'                                               => '계정중 하나는 ":trigger_value"로 시작합니다',
    'rule_trigger_account_nr_is_choice'                                         => '계정 번호 / IBAN 중 하나는 .. 입니다',
    'rule_trigger_account_nr_is'                                                => '계정 번호 / IBAN 중 하나는 ":trigger_value"입니다',
    'rule_trigger_account_nr_contains_choice'                                   => '계정 번호 / IBAN 중 하나는 ..를 포함합니다',
    'rule_trigger_account_nr_contains'                                          => '계정 번호 / IBAN 중 하나는 ":trigger_value"를 포함합니다',
    'rule_trigger_account_nr_ends_choice'                                       => '계정 번호 / IBAN 중 하나가 ..로 끝납니다',
    'rule_trigger_account_nr_ends'                                              => '계정 번호 / IBAN 중 하나가 ":trigger_value"로 끝납니다',
    'rule_trigger_account_nr_starts_choice'                                     => '계정 번호 / IBAN 중 하나가 ..로 시작합니다',
    'rule_trigger_account_nr_starts'                                            => '계정 번호 / IBAN 중 하나가 ":trigger_value"로 시작합니다',
    'rule_trigger_category_contains_choice'                                     => '카테고리는 ..를 포함합니다',
    'rule_trigger_category_contains'                                            => '카테고리는 ":trigger_value"를 포함합니다',
    'rule_trigger_category_ends_choice'                                         => '카테고리는 ..로 끝납니다',
    'rule_trigger_category_ends'                                                => '카테고리는 ":trigger_value"로 끝납니다',
    'rule_trigger_category_starts_choice'                                       => '카테고리는 ..로 시작합니다',
    'rule_trigger_category_starts'                                              => '카테고리는 ":trigger_value"로 시작합니다',
    'rule_trigger_budget_contains_choice'                                       => '예산은 ..를 포함합니다',
    'rule_trigger_budget_contains'                                              => '예산은 ":trigger_value"를 포함합니다',
    'rule_trigger_budget_ends_choice'                                           => '예산은 ..로 끝납니다',
    'rule_trigger_budget_ends'                                                  => '예산은 ":trigger_value"로 끝납니다',
    'rule_trigger_budget_starts_choice'                                         => '예산은 ..로 시작합니다',
    'rule_trigger_budget_starts'                                                => '예산은 ":trigger_value"로 시작합니다',
    'rule_trigger_bill_contains_choice'                                         => 'Subscription contains..',
    'rule_trigger_bill_contains'                                                => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                                             => 'Subscription ends with..',
    'rule_trigger_bill_ends'                                                    => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                                           => 'Subscription starts with..',
    'rule_trigger_bill_starts'                                                  => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'                                  => '외부 ID는 ..를 포함합니다',
    'rule_trigger_external_id_contains'                                         => '외부 ID는 ":trigger_value"를 포함합니다',
    'rule_trigger_external_id_ends_choice'                                      => '외부 ID는 ..로 끝납니다',
    'rule_trigger_external_id_ends'                                             => '외부 ID는 ":trigger_value"로 끝납니다',
    'rule_trigger_external_id_starts_choice'                                    => '외부 ID는 ..로 시작합니다',
    'rule_trigger_external_id_starts'                                           => '외부 ID는 ":trigger_value"로 시작합니다',
    'rule_trigger_internal_reference_contains_choice'                           => '내부 참조는 ..를 포함합니다',
    'rule_trigger_internal_reference_contains'                                  => '내부 참조는 ":trigger_value"를 포함합니다',
    'rule_trigger_internal_reference_ends_choice'                               => '내부 참조는 ..로 끝납니다',
    'rule_trigger_internal_reference_ends'                                      => '내부 참조는 ":trigger_value"로 끝납니다',
    'rule_trigger_internal_reference_starts_choice'                             => '내부 참조는 ..로 시작합니다',
    'rule_trigger_internal_reference_starts'                                    => '내부 참조는 ":trigger_value"로 시작합니다',
    'rule_trigger_external_url_is_choice'                                       => '외부 URL은 ..입니다',
    'rule_trigger_external_url_is'                                              => '외부 URL은 ":trigger_value"입니다',
    'rule_trigger_external_url_contains_choice'                                 => '외부 URL은 ..를 포함합니다',
    'rule_trigger_external_url_contains'                                        => '외부 URL은 ":trigger_value"를 포함합니다',
    'rule_trigger_external_url_ends_choice'                                     => '외부 URL은 ..로 끝납니다',
    'rule_trigger_external_url_ends'                                            => '외부 URL은 ":trigger_value"로 끝납니다',
    'rule_trigger_external_url_starts_choice'                                   => '외부 URL은 ..로 시작합니다',
    'rule_trigger_external_url_starts'                                          => '외부 URL은 ":trigger_value"로 시작합니다',
    'rule_trigger_has_no_attachments_choice'                                    => '첨부 파일이 없음',
    'rule_trigger_has_no_attachments'                                           => '거래에 첨부 파일이 없음',
    'rule_trigger_recurrence_id_choice'                                         => '반복 거래 ID는 ..입니다',
    'rule_trigger_recurrence_id'                                                => '반복 거래 ID는 ":trigger_value"입니다',
    'rule_trigger_interest_date_on_choice'                                      => '이자 날짜는 .. 입니다',
    'rule_trigger_interest_date_on'                                             => '이자 날짜는 ":trigger_value"입니다',
    'rule_trigger_interest_date_before_choice'                                  => '이자 날짜는 .. 이전입니다',
    'rule_trigger_interest_date_before'                                         => '이자 날짜는 ":trigger_value" 이전입니다',
    'rule_trigger_interest_date_after_choice'                                   => '이자 날짜는 .. 이후입니다',
    'rule_trigger_interest_date_after'                                          => '이자 날짜는 ":trigger_value" 이후입니다',
    'rule_trigger_book_date_on_choice'                                          => '예약 날짜는 .. 입니다',
    'rule_trigger_book_date_on'                                                 => '예약 날짜는 ":trigger_value" 입니다',
    'rule_trigger_book_date_before_choice'                                      => '예약 날짜는 .. 이전입니다',
    'rule_trigger_book_date_before'                                             => '예약 날짜는 ":trigger_value" 이전입니다',
    'rule_trigger_book_date_after_choice'                                       => '예약 날짜는 .. 이후입니다',
    'rule_trigger_book_date_after'                                              => '예약 날짜는 ":trigger_value" 이후입니다',
    'rule_trigger_process_date_on_choice'                                       => '처리 날짜는 .. 입니다',
    'rule_trigger_process_date_on'                                              => '처리 날짜는 ":trigger_value"입니다',
    'rule_trigger_process_date_before_choice'                                   => '처리 날짜는 .. 이전입니다',
    'rule_trigger_process_date_before'                                          => '처리 날짜는 ":trigger_value" 이전입니다',
    'rule_trigger_process_date_after_choice'                                    => '처리 날짜는 .. 이후입니다',
    'rule_trigger_process_date_after'                                           => '처리 날짜는 ":trigger_value" 이후입니다',
    'rule_trigger_due_date_on_choice'                                           => '마감 날짜는 .. 입니다',
    'rule_trigger_due_date_on'                                                  => '마감 날짜는 ":trigger_value" 입니다',
    'rule_trigger_due_date_before_choice'                                       => '마감 날짜는 .. 이전입니다',
    'rule_trigger_due_date_before'                                              => '마감 날짜는 ":trigger_value" 이전입니다',
    'rule_trigger_due_date_after_choice'                                        => '마감 날짜는 .. 이후입니다',
    'rule_trigger_due_date_after'                                               => '마감 날짜는 ":trigger_value" 이후입니다',
    'rule_trigger_payment_date_on_choice'                                       => '결제 날짜는 .. 입니다',
    'rule_trigger_payment_date_on'                                              => '결제 날짜는 ":trigger_value"입니다',
    'rule_trigger_payment_date_before_choice'                                   => '결제 날짜는 .. 이전입니다',
    'rule_trigger_payment_date_before'                                          => '결제 날짜는 ":trigger_value" 이전입니다',
    'rule_trigger_payment_date_after_choice'                                    => '결제 날짜는 .. 이후입니다',
    'rule_trigger_payment_date_after'                                           => '결제 날짜는 ":trigger_value" 이후입니다',
    'rule_trigger_invoice_date_on_choice'                                       => '송장 날짜는 .. 입니다',
    'rule_trigger_invoice_date_on'                                              => '송장 날짜는 ":trigger_value"입니다',
    'rule_trigger_invoice_date_before_choice'                                   => '송장 날짜는 .. 이전입니다',
    'rule_trigger_invoice_date_before'                                          => '송장 날짜는 ":trigger_value" 이전입니다',
    'rule_trigger_invoice_date_after_choice'                                    => '송장 날짜는 .. 이후입니다',
    'rule_trigger_invoice_date_after'                                           => '송장 날짜는 ":trigger_value" 이후입니다',
    'rule_trigger_created_at_before_choice'                                     => '.. 이전에 거래가 생성되었습니다',
    'rule_trigger_created_at_before'                                            => '":trigger_value" 이전에 거래가 생성되었습니다',
    'rule_trigger_created_at_after_choice'                                      => '.. 이후에 거래가 생성되었습니다',
    'rule_trigger_created_at_after'                                             => '":trigger_value" 이후에 거래가 생성되었습니다',
    'rule_trigger_updated_at_before_choice'                                     => '.. 이전에 거래가 마지막으로 업데이트되었습니다',
    'rule_trigger_updated_at_before'                                            => '":trigger_value" 이전에 거래가 마지막으로 업데이트되었습니다',
    'rule_trigger_updated_at_after_choice'                                      => '.. 이후에 거래가 마지막으로 업데이트되었습니다',
    'rule_trigger_updated_at_after'                                             => '":trigger_value" 이후에 거래가 마지막으로 업데이트되었습니다',
    'rule_trigger_foreign_amount_is_choice'                                     => '외화 금액은 정확히 ..입니다',
    'rule_trigger_foreign_amount_is'                                            => '외화 금액은 정확히 ":trigger_value"입니다',
    'rule_trigger_foreign_amount_less_choice'                                   => '외화 금액은  .. 보다 작습니다',
    'rule_trigger_foreign_amount_less'                                          => '외화 금액은 ":trigger_value" 보다 작습니다',
    'rule_trigger_foreign_amount_more_choice'                                   => '외화 금액은 .. 보다 큽니다',
    'rule_trigger_foreign_amount_more'                                          => '외화 금액은 ":trigger_value" 보다 큽니다',
    'rule_trigger_attachment_name_is_choice'                                    => '첨부 파일의 이름은 ..',
    'rule_trigger_attachment_name_is'                                           => '첨부 파일의 이름은 ":trigger_value"입니다',
    'rule_trigger_attachment_name_contains_choice'                              => '첨부 파일의 이름은 ..를 포함합니다',
    'rule_trigger_attachment_name_contains'                                     => '첨부 파일의 이름은 ":trigger_value"를 포함합니다',
    'rule_trigger_attachment_name_starts_choice'                                => '첨부 파일의 이름은 ..로 시작합니다',
    'rule_trigger_attachment_name_starts'                                       => '첨부 파일의 이름은 ":trigger_value"로 시작합니다',
    'rule_trigger_attachment_name_ends_choice'                                  => '첨부 파일의 이름은 ..로 끝납니다',
    'rule_trigger_attachment_name_ends'                                         => '첨부 파일의 이름은 ":trigger_value"로 끝납니다',
    'rule_trigger_attachment_notes_are_choice'                                  => '첨부 파일의 노트는 ..',
    'rule_trigger_attachment_notes_are'                                         => '첨부 파일의 노트는 ":trigger_value"입니다',
    'rule_trigger_attachment_notes_contains_choice'                             => '첨부 파일의 노트는 ..를 포함합니다',
    'rule_trigger_attachment_notes_contains'                                    => '첨부 파일의 노트는 ":trigger_value"를 포함합니다',
    'rule_trigger_attachment_notes_starts_choice'                               => '첨부 파일의 노트는 ..로 시작합니다',
    'rule_trigger_attachment_notes_starts'                                      => '첨부 파일의 노트는 ":trigger_value"로 시작합니다',
    'rule_trigger_attachment_notes_ends_choice'                                 => '첨부 파일의 노트는 ..로 끝납니다',
    'rule_trigger_attachment_notes_ends'                                        => '첨부 파일의 노트는 ":trigger_value"로 끝납니다',
    'rule_trigger_reconciled_choice'                                            => '거래가 조정됨',
    'rule_trigger_reconciled'                                                   => '거래가 조정됨',
    'rule_trigger_exists_choice'                                                => '모든 거래 일치(!)',
    'rule_trigger_exists'                                                       => '모든 거래 일치',

    // more values for new types:
    'rule_trigger_not_account_id'                                               => '계정 ID는 ":trigger_value"가 아닙니다',
    'rule_trigger_not_source_account_id'                                        => '소스 계정 ID는 ":trigger_value"가 아닙니다',
    'rule_trigger_not_destination_account_id'                                   => '대상 계정 ID는 ":trigger_value"가 아닙니다',
    'rule_trigger_not_transaction_type'                                         => '거래 유형은 ":trigger_value"가 아닙니다',
    'rule_trigger_not_tag_is'                                                   => '태그는 ":trigger_value" 가 아닙니다',
    'rule_trigger_not_tag_is_not'                                               => '태그는 ":trigger_value"입니다',
    'rule_trigger_not_description_is'                                           => '설명은 ":trigger_value"가 아닙니다',
    'rule_trigger_not_description_contains'                                     => '설명이 포함되지 않음',
    'rule_trigger_not_description_ends'                                         => '설명은 ":trigger_value"로 끝나지 않습니다',
    'rule_trigger_not_description_starts'                                       => '설명은 ":trigger_value"로 시작하지 않습니다',
    'rule_trigger_not_notes_is'                                                 => '노트는 ":trigger_value"가 아닙니다',
    'rule_trigger_not_notes_contains'                                           => '노트는 ":trigger_value"를 포함하지 않습니다',
    'rule_trigger_not_notes_ends'                                               => '노트는 ":trigger_value"로 끝나지 않습니다',
    'rule_trigger_not_notes_starts'                                             => '노트는 ":trigger_value"로 시작하지 않습니다',
    'rule_trigger_not_source_account_is'                                        => '소스 계정은 ":trigger_value"가 아닙니다',
    'rule_trigger_not_source_account_contains'                                  => '소스 계정은 ":trigger_value"를 포함하지 않습니다',
    'rule_trigger_not_source_account_ends'                                      => '소스 계정은 ":trigger_value"로 끝나지 않습니다',
    'rule_trigger_not_source_account_starts'                                    => '소스 계정은 ":trigger_value"로 시작하지 않습니다',
    'rule_trigger_not_source_account_nr_is'                                     => '소스 계정 번호 / IBAN은 ":trigger_value"가 아닙니다',
    'rule_trigger_not_source_account_nr_contains'                               => '소스 계정 번호 / IBAN은 ":trigger_value"를 포함하지 않습니다',
    'rule_trigger_not_source_account_nr_ends'                                   => '소스 계정 번호 / IBAN은 ":trigger_value"로 끝나지 않습니다',
    'rule_trigger_not_source_account_nr_starts'                                 => '소스 계정 번호 / IBAN은 ":trigger_value"로 시작하지 않습니다',
    'rule_trigger_not_destination_account_is'                                   => '대상 계정은 ":trigger_value"가 아닙니다',
    'rule_trigger_not_destination_account_contains'                             => '대상 계정은 ":trigger_value"를 포함하지 않습니다',
    'rule_trigger_not_destination_account_ends'                                 => '대상 계정은 ":trigger_value"로 끝나지 않습니다',
    'rule_trigger_not_destination_account_starts'                               => '대상 계정은 ":trigger_value"로 시작하지 않습니다',
    'rule_trigger_not_destination_account_nr_is'                                => '대상 계정 번호 / IBAN은 ":trigger_value"가 아닙니다',
    'rule_trigger_not_destination_account_nr_contains'                          => '대 계정 번호 / IBAN은 ":trigger_value"를 포함하지 않습니다',
    'rule_trigger_not_destination_account_nr_ends'                              => '대상 계정 번호 / IBAN은 ":trigger_value"로 끝나지 않습니다',
    'rule_trigger_not_destination_account_nr_starts'                            => '대상 계정 번호 / IBAN은 ":trigger_value"로 시작하지 않습니다',
    'rule_trigger_not_account_is'                                               => '두 계정 모두 ":trigger_value"가 아닙니다',
    'rule_trigger_not_account_contains'                                         => '두 계정 모두 ":trigger_value"를 포함하지 않습니다',
    'rule_trigger_not_account_ends'                                             => '두 계정 모두 ":trigger_value"로 끝나지 않습니다',
    'rule_trigger_not_account_starts'                                           => '두 계정 모두 ":trigger_value"로 시작하지 않습니다',
    'rule_trigger_not_account_nr_is'                                            => '두 계정의 번호 / IBAN은 모두 ":trigger_value"가 아닙니다',
    'rule_trigger_not_account_nr_contains'                                      => '두 계정의 번호 / IBAN은 모두 ":trigger_value"를 포함하지 않습니다',
    'rule_trigger_not_account_nr_ends'                                          => '두 계정의 번호 / IBAN은 모두 ":trigger_value"로 끝나지 않습니다',
    'rule_trigger_not_account_nr_starts'                                        => '두 계정의 번호 / IBAN은 모두 ":trigger_value"로 시작하지 않습니다',
    'rule_trigger_not_category_is'                                              => '카테고리는 ":trigger_value" 가 아닙니다',
    'rule_trigger_not_category_contains'                                        => '카테고리에 ":trigger_value"가 포함되어 있지 않습니다',
    'rule_trigger_not_category_ends'                                            => '카테고리가 ":trigger_value"로 끝나지 않습니다',
    'rule_trigger_not_category_starts'                                          => '카테고리가 ":trigger_value"로 시작하지 않습니다.',
    'rule_trigger_not_budget_is'                                                => '예산은 ":trigger_value" 가 아닙니다',
    'rule_trigger_not_budget_contains'                                          => '예산에 ":trigger_value"가 포함되어 있지 않습니다',
    'rule_trigger_not_budget_ends'                                              => '예산이 ":trigger_value"로 끝나지 않습니다',
    'rule_trigger_not_budget_starts'                                            => '예산이 ":trigger_value"로 시작하지 않습니다',
    'rule_trigger_not_bill_is'                                                  => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                                            => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                                                => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                                              => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                                           => '외부 ID는 ":trigger_value"가 아닙니다',
    'rule_trigger_not_external_id_contains'                                     => '외부 ID는 ":trigger_value"를 포함하지 않습니다',
    'rule_trigger_not_external_id_ends'                                         => '외부 ID는 ":trigger_value"에 끝나지 않습니다',
    'rule_trigger_not_external_id_starts'                                       => '외부 ID는 ":trigger_value"로 시작하지 않습니다',
    'rule_trigger_not_internal_reference_is'                                    => '내부 참조는 ":trigger_value"가 아닙니다',
    'rule_trigger_not_internal_reference_contains'                              => '내부 참조는 ":trigger_value"를 포함하지 않습니다',
    'rule_trigger_not_internal_reference_ends'                                  => '내부 참조는 ":trigger_value"에 끝나지 않습니다',
    'rule_trigger_not_internal_reference_starts'                                => '내부 참조는 ":trigger_value"로 시작하지 않습니다',
    'rule_trigger_not_external_url_is'                                          => '외부 URL은 ":trigger_value"가 아닙니다',
    'rule_trigger_not_external_url_contains'                                    => '외부 URL은 ":trigger_value"를 포함하지 않습니다',
    'rule_trigger_not_external_url_ends'                                        => '외부 URL은 ":trigger_value"로 끝나지 않습니다',
    'rule_trigger_not_external_url_starts'                                      => '외부 URL은 ":trigger_value"로 시작하지 않습니다',
    'rule_trigger_not_currency_is'                                              => '통화는 ":trigger_value" 가 아닙니다',
    'rule_trigger_not_foreign_currency_is'                                      => '외화는 ":trigger_value" 가 아닙니다',
    'rule_trigger_not_id'                                                       => '거래 ID는 ":trigger_value"가 아닙니다',
    'rule_trigger_not_journal_id'                                               => '거래 저널 ID는 ":trigger_value"가 아닙니다',
    'rule_trigger_not_recurrence_id'                                            => '반복 ID는 ":trigger_value"가 아닙니다',
    'rule_trigger_not_date_on'                                                  => '날짜가 ":trigger_value"에 없습니다',
    'rule_trigger_not_date_before'                                              => '날짜가 ":trigger_value" 이전이 아닙니다',
    'rule_trigger_not_date_after'                                               => '날짜가 ":trigger_value" 이후가 아닙니다',
    'rule_trigger_not_interest_date_on'                                         => '이자 날짜가 ":trigger_value"에 없습니다',
    'rule_trigger_not_interest_date_before'                                     => '이자 날짜가 ":trigger_value" 이전이 아닙니다',
    'rule_trigger_not_interest_date_after'                                      => '이자 날짜가 ":trigger_value" 이후가 아닙니다',
    'rule_trigger_not_book_date_on'                                             => '예약 날짜가 ":trigger_value"에 없습니다',
    'rule_trigger_not_book_date_before'                                         => '예약 날짜가 ":trigger_value" 이전이 아닙니다',
    'rule_trigger_not_book_date_after'                                          => '예약 날짜가 ":trigger_value" 이후가 아닙니다',
    'rule_trigger_not_process_date_on'                                          => '처리 날짜가 ":trigger_value"에 없습니다',
    'rule_trigger_not_process_date_before'                                      => '처리 날짜가 ":trigger_value" 이전이 아닙니다',
    'rule_trigger_not_process_date_after'                                       => '처리 날짜가 ":trigger_value" 이후가 아닙니다',
    'rule_trigger_not_due_date_on'                                              => '마감 날짜가 ":trigger_value"에 없습니다',
    'rule_trigger_not_due_date_before'                                          => '마감 날짜가 ":trigger_value" 이전이 아닙니다',
    'rule_trigger_not_due_date_after'                                           => '마감 날짜가 ":trigger_value" 이후가 아닙니다',
    'rule_trigger_not_payment_date_on'                                          => '결제 날짜가 ":trigger_value"에 없습니다',
    'rule_trigger_not_payment_date_before'                                      => '결제 날짜가 ":trigger_value" 이전이 아닙니다',
    'rule_trigger_not_payment_date_after'                                       => '결제 날짜가 ":trigger_value" 이후가 아닙니다',
    'rule_trigger_not_invoice_date_on'                                          => '송장 날짜가 ":trigger_value"에 없습니다',
    'rule_trigger_not_invoice_date_before'                                      => '송장 날짜가 ":trigger_value" 이전이 아닙니다',
    'rule_trigger_not_invoice_date_after'                                       => '송장 날짜가 ":trigger_value" 이후가 아닙니다',
    'rule_trigger_not_created_at_on'                                            => '거래가 ":trigger_value"에 생성되지 않았습니다',
    'rule_trigger_not_created_at_before'                                        => '거래가 ":trigger_value" 이전에 생성되지 않았습니다',
    'rule_trigger_not_created_at_after'                                         => '거래가 ":trigger_value" 이후에 생성되지 않았습니다',
    'rule_trigger_not_updated_at_on'                                            => '거래가 ":trigger_value"에 업데이트되지 않았습니다',
    'rule_trigger_not_updated_at_before'                                        => '거래가 ":trigger_value" 이전에 업데이트되지 않았습니다',
    'rule_trigger_not_updated_at_after'                                         => '거래가 ":trigger_value" 이후에 업데이트되지 않았습니다',
    'rule_trigger_not_amount_is'                                                => '거래 금액이 ":trigger_value"가 아닙니다',
    'rule_trigger_not_amount_less'                                              => '거래 금액은 ":trigger_value" 보다 큽니다',
    'rule_trigger_not_amount_more'                                              => '거래 금액은 ":trigger_value" 보다 작습니다',
    'rule_trigger_not_foreign_amount_is'                                        => '외화 거래 금액은 ":trigger_value"가 아닙니다',
    'rule_trigger_not_foreign_amount_less'                                      => '외화 거래 금액은 ":trigger_value" 보다 큽니다',
    'rule_trigger_not_foreign_amount_more'                                      => '외화 거래 금액은 ":trigger_value" 보다 작습니다',
    'rule_trigger_not_attachment_name_is'                                       => '이름이 ":trigger_value"인 첨부 파일이 없습니다',
    'rule_trigger_not_attachment_name_contains'                                 => '":trigger_value"를 포함하는 첨부 파일 이름이 없습니다',
    'rule_trigger_not_attachment_name_starts'                                   => '":trigger_value"로 시작하는 첨부 파일 이름이 없습니다',
    'rule_trigger_not_attachment_name_ends'                                     => '":trigger_value"로 끝나는 첨부 파일 이름이 없습니다',
    'rule_trigger_not_attachment_notes_are'                                     => '첨부 파일 노트가 ":trigger_value"가 아닙니다',
    'rule_trigger_not_attachment_notes_contains'                                => '":trigger_value"를 포함하는 첨부 파일 노트가 없습니다',
    'rule_trigger_not_attachment_notes_starts'                                  => '":trigger_value"로 시작하는 첨부 파일 노트가 없습니다',
    'rule_trigger_not_attachment_notes_ends'                                    => '":trigger_value"에 끝나는 첨부 파일 노트가 없습니다',
    'rule_trigger_not_reconciled'                                               => '거래가 조정되지 않음',
    'rule_trigger_not_exists'                                                   => '거래가 존재하지 않습니다',
    'rule_trigger_not_has_attachments'                                          => '거래에 첨부 파일이 없음',
    'rule_trigger_not_has_any_category'                                         => '거래에 카테고리가 없음',
    'rule_trigger_not_has_any_budget'                                           => '거레에 예산이 없음',
    'rule_trigger_not_has_any_bill'                                             => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                                              => '거래에 태그가 없음',
    'rule_trigger_not_any_notes'                                                => '거래에 메모가 없음',
    'rule_trigger_not_any_external_url'                                         => '거래에 외부 URL이 없음',
    'rule_trigger_not_has_no_attachments'                                       => '거래에 첨부 파일이 있음',
    'rule_trigger_not_has_no_category'                                          => '거래에 카테고리가 있음',
    'rule_trigger_not_has_no_budget'                                            => '거래에 예산이 있음',
    'rule_trigger_not_has_no_bill'                                              => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                                               => '거레에 태그가 있음',
    'rule_trigger_not_no_notes'                                                 => '거래에 메모가 있음',
    'rule_trigger_not_no_external_url'                                          => '거래에 외부 URL이 있음',
    'rule_trigger_not_source_is_cash'                                           => '소스 계정이 현금 계정이 아닙니다',
    'rule_trigger_not_destination_is_cash'                                      => '대상 계정이 현금 계정이 아닙니다',
    'rule_trigger_not_account_is_cash'                                          => '두 계정 모두 현금 계정이 아닙니다',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'                                => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'                               => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'                                => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'                                => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'                               => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'                                     => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice'                                    => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'                                     => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'                                     => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice'                                    => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'                                       => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte'                                      => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'                                       => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'                                       => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte'                                      => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'                                            => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'                                           => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'                                            => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'                                            => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'                                           => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'                                   => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte'                                  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'                                   => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'                                   => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte'                                  => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'                                        => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'                                       => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'                                        => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'                                        => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'                                       => 'Source account balance is more than :trigger_value',



    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'                                     => '거래 삭제(!)',
    'rule_action_delete_transaction'                                            => '거래 삭제(!)',
    'rule_action_set_category'                                                  => '카테고리를 ":action_value"로 설정',
    'rule_action_clear_category'                                                => '카테고리 지우기',
    'rule_action_set_budget'                                                    => '예산을 ":action_value"로 설정',
    'rule_action_clear_budget'                                                  => '예산 지우기',
    'rule_action_add_tag'                                                       => '":action_value" 태그 추가',
    'rule_action_remove_tag'                                                    => '":action_value" 태그 제거',
    'rule_action_remove_all_tags'                                               => '모든 태그 제거',
    'rule_action_set_description'                                               => '설명을 ":action_value"로 설정',
    'rule_action_append_description'                                            => '":action_value"로 설명을 추가',
    'rule_action_prepend_description'                                           => '설명 앞에 ":action_value" 추가',
    'rule_action_set_category_choice'                                           => '카테고리를 .. 로 설정',
    'rule_action_clear_category_choice'                                         => '카테고리 지우기',
    'rule_action_set_budget_choice'                                             => '예산을 .. 로 설정',
    'rule_action_clear_budget_choice'                                           => '예산 지우기',
    'rule_action_add_tag_choice'                                                => '태그 추가...',
    'rule_action_remove_tag_choice'                                             => '태그 제거 ..',
    'rule_action_remove_all_tags_choice'                                        => '모든 태그 제거',
    'rule_action_set_description_choice'                                        => '설명을 ..으로 설정',
    'rule_action_update_piggy_choice'                                           => '저금통에 거래금액 추가/제거 ..',
    'rule_action_update_piggy'                                                  => '저금통 ":action_value"에 거래 금액 추가/제거',
    'rule_action_append_description_choice'                                     => '..로 설명 추가',
    'rule_action_prepend_description_choice'                                    => '..로 설명앞에 추가',
    'rule_action_set_source_account_choice'                                     => '소스 계정을 ..로 설정',
    'rule_action_set_source_account'                                            => '소스 계정을 :action_value로 설정',
    'rule_action_set_destination_account_choice'                                => '대상 계정을 ..로 설정',
    'rule_action_set_destination_account'                                       => '대상 계정을 :action_value로 설정',
    'rule_action_append_notes_choice'                                           => '..로 메모 추가',
    'rule_action_append_notes'                                                  => '":action_value"로 메모 추가',
    'rule_action_prepend_notes_choice'                                          => '노트 앞에 .. 추가',
    'rule_action_prepend_notes'                                                 => '노트 앞에 ":action_value" 추가',
    'rule_action_clear_notes_choice'                                            => '노트 제거',
    'rule_action_clear_notes'                                                   => '노트 제거',
    'rule_action_set_notes_choice'                                              => '노트를 ..로 설정',
    'rule_action_link_to_bill_choice'                                           => 'Link to a subscription ..',
    'rule_action_link_to_bill'                                                  => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'                                        => '소스와 대상 계정 전환 (이체 만!)',
    'rule_action_switch_accounts'                                               => '소스와 대상 계정 전환',
    'rule_action_set_notes'                                                     => '노트를 ":action_value"로 설정',
    'rule_action_convert_deposit_choice'                                        => '거래를 입금으로 전환',
    'rule_action_convert_deposit'                                               => '":action_value"에서 거래를 입금으로 전환합니다',
    'rule_action_convert_withdrawal_choice'                                     => '거래를 출금으로 전환',
    'rule_action_convert_withdrawal'                                            => '거래를 ":action_value"로 출금으로 전환합니다',
    'rule_action_convert_transfer_choice'                                       => '거래를 이체로 전환',
    'rule_action_convert_transfer'                                              => '":action_value"를 사용하여 거래를 이체로 전환합니다',
    'rule_action_append_descr_to_notes_choice'                                  => '거래 노트에 설명을 추가합니다',
    'rule_action_append_notes_to_descr_choice'                                  => '설명에 거래 노트를 추가합니다',
    'rule_action_move_descr_to_notes_choice'                                    => '현재 거래 노트를 설명으로 바꿉니다',
    'rule_action_move_notes_to_descr_choice'                                    => '현재 설명을 거래 메모로 바꿉니다',
    'rule_action_append_descr_to_notes'                                         => '노트에 설명 추가',
    'rule_action_append_notes_to_descr'                                         => '설명에 메모 추가',
    'rule_action_move_descr_to_notes'                                           => '노트를 설명으로 바꾸기',
    'rule_action_move_notes_to_descr'                                           => '설명을 노트로 바꾸기',
    'rule_action_set_amount_choice'                                             => 'Set amount to ..',
    'rule_action_set_amount'                                                    => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice'                                => '대상 계좌를 (cash) 로 설정',
    'rule_action_set_source_to_cash_choice'                                     => '소스 계정을 (cash) 로 설정',
    'rulegroup_for_bills_title'                                                 => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'                                           => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                                                       => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                                                 => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                                                      => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                                                  => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                                                   => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'                                             => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                                                => '거래 ":description" 기반 규칙',
    'new_rule_for_journal_description'                                          => '이 규칙은 거래 ":description"을 기반으로 합니다. 정확히 동일한 거래를 매칭할 것입니다.',

    // tags
    'store_new_tag'                                                             => '새 태그 저장',
    'update_tag'                                                                => '태그 업데이트',
    'no_location_set'                                                           => '설정된 위치가 없습니다.',
    'meta_data'                                                                 => '메타데이터',
    'location'                                                                  => '위치',
    'location_first_split'                                                      => '이 거래를 위한 위치는 분할 거래에 설정될 수 있습니다.',
    'without_date'                                                              => '날짜 없음',
    'result'                                                                    => '결과',
    'sums_apply_to_range'                                                       => '모든 합계는 선택한 범위에 적용됩니다',
    'mapbox_api_key'                                                            => '지도를 사용하려면 <a href="https://www.mapbox.com/">Mapbox</a>에서 API 키를 받습니다. <code>.env</code> 파일을 열고 <code>MAPBOX_API_KEY=</code> 뒤에 이 코드를 입력합니다.',
    'press_object_location'                                                     => '마우스 오른쪽 버튼을 클릭이나 롱 클릭으로 개체의 위치를 설정합니다.',
    'click_tap_location'                                                        => '위치를 추가하기 위해 맵을 클릭하거나 탭하십시오.',
    'clear_location'                                                            => '위치 지우기',
    'delete_all_selected_tags'                                                  => '선택된 모든 태그를 삭제',
    'select_tags_to_delete'                                                     => '태그를 선택하는 것을 잊지 마세요.',
    'deleted_x_tags'                                                            => ':count개의 태그가 삭제되었습니다.|:count개의 태그가 삭제되었습니다.',
    'create_rule_from_transaction'                                              => '거래 기반 규칙 생성',
    'create_recurring_from_transaction'                                         => '거래를 기반으로 반복 거래 만들기',

    // preferences
    'test_notifications_buttons'                                                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                                                  => '브라우저에 맡기세요',
    'dark_mode_option_light'                                                    => '항상 라이트',
    'dark_mode_option_dark'                                                     => '항상 다크',
    'equal_to_language'                                                         => '(언어와 동일)',
    'dark_mode_preference'                                                      => '다크 모드',
    'dark_mode_preference_help'                                                 => 'Firefly III가 언제 다크 모드를 사용할지 알려주세요.',
    'pref_home_screen_accounts'                                                 => '홈 화면 계정',
    'pref_home_screen_accounts_help'                                            => '홈 페이지에 어떤 계정을 표시해야 하나요?',
    'pref_view_range'                                                           => '보기 범위',
    'pref_view_range_help'                                                      => '일부 차트는 자동으로 기간별로 그룹화됩니다. 예산도 기간별로 그룹화됩니다. 어떤 기간을 원하시나요?',
    'pref_1D'                                                                   => '하루',
    'pref_1W'                                                                   => '일주일',
    'pref_1M'                                                                   => '한달',
    'pref_3M'                                                                   => '3개월 (분기)',
    'pref_6M'                                                                   => '6개월',
    'pref_1Y'                                                                   => '1년',
    'pref_last365'                                                              => '지난 해',
    'pref_last90'                                                               => '최근 90일',
    'pref_last30'                                                               => '최근 30일',
    'pref_last7'                                                                => '최근 7일',
    'pref_YTD'                                                                  => '연간 누계',
    'pref_QTD'                                                                  => '분기 누계',
    'pref_MTD'                                                                  => '월간 누계',
    'pref_languages'                                                            => '언어',
    'pref_locale'                                                               => '로케일 설정',
    'pref_languages_help'                                                       => 'Firefly III는 여러 언어를 지원합니다. 어떤 언어를 선호하시나요?',
    'pref_locale_help'                                                          => 'Firefly III에서는 통화, 숫자, 날짜 서식 지정 방법 등 기타 로컬 설정을 변경할 수 있습니다. 사용 중인 시스템에서 지원하지 않는 항목이 있을 수 있습니다. Firefly III는 모든 로케일에 대해 올바른 날짜 설정을 제공하지 않으므로 개선이 필요한 경우 저에게 문의하세요.',
    'pref_locale_no_demo'                                                       => '이 기능은 데모 사용자에게는 동작하지 않습니다.',
    'pref_convert_to_native'                                                    => 'Display amounts in your native currency',
    'pref_convert_to_native_help'                                               => 'This option will make Firefly III try to display and show your native currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_native_help'                                                  => 'Display native amounts',
    'pref_custom_fiscal_year'                                                   => '회계연도 설정',
    'pref_custom_fiscal_year_label'                                             => '활성화',
    'pref_custom_fiscal_year_help'                                              => '1월 1일에서 12월 31일과 다른 회계 연도를 사용하는 나라에서는 해당 설정을 켜고 회계 연도의 시작과 끝을 지정할 수 있습니다',
    'pref_fiscal_year_start_label'                                              => '회계 연도 시작일',
    'pref_two_factor_auth'                                                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                                                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'                                               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'                                             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'                                            => '인증 앱에서 계정을 제거하는 것을 잊지 마세요!',
    'pref_two_factor_auth_code'                                                 => '코드 확인',
    'pref_two_factor_auth_code_help'                                            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'                                           => '인증 코드 재설정',
    'pref_two_factor_auth_disable_2fa'                                          => 'Disable MFA',
    '2fa_use_secret_instead'                                                    => 'QR 코드를 스캔할 수 없다면 <code>:secret</code> 시크릿을 대신 사용하세요.',
    '2fa_backup_codes'                                                          => '장치를 분실한 경우에 액세스할 수 있도록 이 백업 코드를 저장하십시오.',
    '2fa_already_enabled'                                                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                                                            => '이 MFA 코드는 유효하지 않습니다.',
    'pref_save_settings'                                                        => '설정 저장',
    'saved_preferences'                                                         => '설정 저장됨!',
    'preferences_general'                                                       => '일반',
    'preferences_frontpage'                                                     => '홈 화면',
    'preferences_security'                                                      => '보안',
    'preferences_layout'                                                        => '레이아웃',
    'preferences_notifications'                                                 => '알림',
    'pref_home_show_deposits'                                                   => '홈 화면에 입금 표시',
    'pref_home_show_deposits_info'                                              => '홈 화면에는 이미 지출 계정이 표시되고 있습니다. 수익 계정도 표시할까요?',
    'pref_home_do_show_deposits'                                                => '네, 보여주세요',
    'successful_count'                                                          => '이 중 :count개 성공',
    'list_page_size_title'                                                      => '페이지 크기',
    'list_page_size_help'                                                       => '모든 항목(계정, 거래 등) 목록은 페이지당 최대 이 수만큼 표시됩니다.',
    'list_page_size_label'                                                      => '페이지 크기',
    'between_dates'                                                             => '(:start와 :end)',
    'pref_optional_fields_transaction'                                          => '거래의 옵션 항목',
    'pref_optional_fields_transaction_help'                                     => '기본적으로 새 거래를 만들 때 (복잡하기 때문에) 모든 항목이 활성화되어 있지는 않습니다. 아래에서 유용하다고 생각되는 항목을 활성화할 수 있습니다. 비활성화되어 있지만 이미 입력되어 있는 항목은 설정과 관계없이 모두 표시됩니다.',
    'optional_tj_date_fields'                                                   => '날짜 항목',
    'optional_tj_other_fields'                                                  => '기타 항목',
    'optional_tj_attachment_fields'                                             => '첨부 파일 항목',
    'pref_optional_tj_interest_date'                                            => '이자 날짜',
    'pref_optional_tj_book_date'                                                => '예약 날짜',
    'pref_optional_tj_process_date'                                             => '처리 날짜',
    'pref_optional_tj_due_date'                                                 => '마감 날짜',
    'pref_optional_tj_payment_date'                                             => '결제일',
    'pref_optional_tj_invoice_date'                                             => '청구서 날짜',
    'pref_optional_tj_internal_reference'                                       => '내부 참조',
    'pref_optional_tj_notes'                                                    => '노트',
    'pref_optional_tj_attachments'                                              => '첨부 파일',
    'pref_optional_tj_external_url'                                             => '외부 URL',
    'pref_optional_tj_location'                                                 => '위치',
    'pref_optional_tj_links'                                                    => '거래 링크',
    'optional_field_meta_dates'                                                 => '날짜',
    'optional_field_meta_business'                                              => '비즈니스',
    'optional_field_attachments'                                                => '첨부 파일',
    'optional_field_meta_data'                                                  => '선택적 메타 데이터',
    'external_url'                                                              => '외부 URL',
    'pref_notification_login_failure'                                           => 'Login failure',
    'pref_notification_bill_reminder'                                           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'                                        => '새 API 액세스 토큰이 생성되면 알림 받기',
    'pref_notification_transaction_creation'                                    => '거래가 자동으로 생성될 때 알림',
    'pref_notification_user_login'                                              => '새 위치에서 로그인할 때 알림',
    'pref_notification_rule_action_failures'                                    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'                                            => 'Your password changed',
    'pref_notification_enabled_mfa'                                             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'                                            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'                                            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'                                             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'                                         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'                                        => 'New backup codes have been generated',
    'pref_notifications'                                                        => '알림',
    'pref_notifications_help'                                                   => '수신할 알림인지 여부를 표시합니다. 일부 알림에는 민감한 금융 정보가 포함될 수 있습니다.',
    'pref_notifications_settings'                                               => 'Notifications settings',
    'pref_notifications_settings_help'                                          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                                                           => 'Slack "수신 웹훅" URL',
    'discord_url_label'                                                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                                                 => 'Exchange rates',
    'header_exchange_rates'                                                     => 'Exchange rates',
    'exchange_rates_intro'                                                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                                                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'                                               => 'Exchange rates',
    'exchange_rates_intro_rates'                                                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'                                               => 'Table with exchange rates',
    'help_rate_form'                                                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                                                             => 'Save new rate',
    'add_new_rate'                                                              => 'Add a new exchange rate',
    'not_enough_currencies'                                                     => 'Not enough currencies',
    'not_enough_currencies_enabled'                                             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                                                      => '재정 관리',
    'administrations_breadcrumb'                                                => 'Financial administrations',
    'administrations_page_title'                                                => 'Financial administrations',
    'administrations_index_menu'                                                => 'Financial administrations',
    'administrations_page_sub_title'                                            => 'Overview',
    'create_administration'                                                     => 'Create new administration',
    'administration_owner'                                                      => 'Administration owner: {{email}}',
    'administration_you'                                                        => 'Your role: {{role}}',
    'other_users_in_admin'                                                      => 'Other users in this administration',
    'administrations_create_breadcrumb'                                         => 'Create new financial administration',
    'administrations_page_create_sub_title'                                     => 'Create new financial administration',
    'basic_administration_information'                                          => 'Basic administration information',
    'new_administration_created'                                                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'                                            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'                                       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'                                    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'                                         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its native currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'                                    => 'Currently, you can only set the "native currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'                                         => 'It may take a long time for the page to load if you change the native currency because transaction may need to be converted to your (new) native currency.',
    'flash_administration_updated'                                              => 'Administration ":title" has been updated',
    'flash_administration_created'                                              => 'Administration ":title" has been created',
    'flash_administration_deleted'                                              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                                                 => 'Owner',
    'administration_role_ro'                                                    => 'Read-only',
    'administration_role_mng_trx'                                               => 'Manage transactions',
    'administration_role_mng_meta'                                              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'                                           => 'Manage budgets',
    'administration_role_mng_piggies'                                           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'                                     => 'Manage subscriptions',
    'administration_role_mng_rules'                                             => 'Manage rules',
    'administration_role_mng_recurring'                                         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'                                          => 'Manage webhooks',
    'administration_role_mng_currencies'                                        => 'Manage currencies',
    'administration_role_view_reports'                                          => 'View reports',
    'administration_role_full'                                                  => 'Full access',

    // mfa
    'enable_mfa'                                                                => 'Enable multi-factor authentication',
    'mfa_index_title'                                                           => 'Multi-factor authentication',
    'mfa_index_intro'                                                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                                                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                                                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                                                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'                                              => 'Enter your current password',
    'mfa_warning_code_changes'                                                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                                                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                                                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                                                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                                                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                                                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                                                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                                                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                                                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'                                               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                                                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                                                          => 'Firefly III에서 데이터 제거',
    'purge_data_expl'                                                           => '"제거"는 "이미 삭제된 것을 삭제하는 것"을 의미합니다. 일반적인 상황에서 Firefly III는 아무것도 영구적으로 삭제하지 않습니다. 단지 숨길 뿐입니다. 아래 버튼을 누르면 이전에 "삭제된" 모든 기록이 영원히 제거됩니다.',
    'delete_stuff_header'                                                       => '데이터 삭제 및 제거',
    'purge_all_data'                                                            => '삭제된 모든 기록 제거',
    'purge_data'                                                                => '데이터 제거',
    'purged_all_records'                                                        => '모든 삭제된 항목이 제거 되었습니다.',
    'delete_data_title'                                                         => 'Firefly III에서 데이터 삭제',
    'permanent_delete_stuff'                                                    => 'Firefly III에서 항목을 삭제할 수 있습니다. 아래 버튼을 사용하면 항목이 보기에서 숨겨집니다. 이 경우 실행 취소 버튼은 없지만 항목은 여전히 데이터베이스에 남아 있기 때문에 필요한 경우 복구할 수 있습니다.',
    'other_sessions_logged_out'                                                 => '다른 모든 세션이 로그아웃되었습니다.',
    'delete_unused_accounts'                                                    => '사용하지 않는 계정을 삭제하면 자동 완성 목록이 정리됩니다.',
    'delete_all_unused_accounts'                                                => '사용하지 않는 계정 삭제',
    'deleted_all_unused_accounts'                                               => '사용하지 않는 모든 계정이 삭제되었습니다',
    'delete_all_budgets'                                                        => '모든 예산 삭제',
    'delete_all_categories'                                                     => '모든 카테고리 삭제',
    'delete_all_tags'                                                           => '모든 태그 삭제',
    'delete_all_bills'                                                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                                                    => '모든 저금통 삭제',
    'delete_all_rules'                                                          => '모든 규칙 삭제',
    'delete_all_recurring'                                                      => '모든 반복 거래 삭제',
    'delete_all_object_groups'                                                  => '모든 객체 그룹 삭제',
    'delete_all_accounts'                                                       => '모든 계정 삭제',
    'delete_all_asset_accounts'                                                 => '모든 자산 계정 삭제',
    'delete_all_expense_accounts'                                               => '모든 지출 계정 삭제',
    'delete_all_revenue_accounts'                                               => '모든 수익 계정 삭제',
    'delete_all_liabilities'                                                    => '모든 부채 삭제',
    'delete_all_transactions'                                                   => '모든 거래 삭제',
    'delete_all_withdrawals'                                                    => '모든 출금 삭제',
    'delete_all_deposits'                                                       => '모든 입금 삭제',
    'delete_all_transfers'                                                      => '모든 이체 삭제',
    'also_delete_transactions'                                                  => '계정을 삭제하면 관련된 모든 출금, 입금 및 이체도 삭제됩니다!',
    'deleted_all_budgets'                                                       => '모든 예산이 삭제되었습니다',
    'deleted_all_categories'                                                    => '모든 카테고리가 삭제되었습니다',
    'deleted_all_tags'                                                          => '모든 태그가 삭제되었습니다',
    'deleted_all_bills'                                                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                                                   => '모든 저금통이 삭제되었습니다',
    'deleted_all_rules'                                                         => '모든 규칙과 규칙 그룹이 삭제되었습니다',
    'deleted_all_object_groups'                                                 => '모든 그룹이 삭제되었습니다',
    'deleted_all_accounts'                                                      => '모든 계정이 삭제되었습니다',
    'deleted_all_asset_accounts'                                                => '모든 자산 계정이 삭제되었습니다',
    'deleted_all_expense_accounts'                                              => '모든 지출 계정이 삭제되었습니다',
    'deleted_all_revenue_accounts'                                              => '모든 수익 계정이 삭제되었습니다',
    'deleted_all_liabilities'                                                   => '모든 부채가 삭제되었습니다',
    'deleted_all_transactions'                                                  => '모든 트랜잭션이 삭제되었습니다',
    'deleted_all_withdrawals'                                                   => '모든 출금이 삭제되었습니다',
    'deleted_all_deposits'                                                      => '모든 입금이 삭제되었습니다',
    'deleted_all_transfers'                                                     => '모든 이체가 삭제되었습니다',
    'deleted_all_recurring'                                                     => '모든 반복 거래가 삭제되었습니다',
    'change_your_password'                                                      => '비밀번호 변경',
    'delete_account'                                                            => '계정 삭제',
    'current_password'                                                          => '현재 비밀번호',
    'new_password'                                                              => '새 비밀번호',
    'new_password_again'                                                        => '새 비밀번호 확인',
    'delete_your_account'                                                       => '계정 삭제',
    'delete_your_account_help'                                                  => '계정을 삭제하면 Firefly III에 저장한 모든 계정, 거래, <em>모든 항목</em>도 삭제됩니다. 모두 사라집니다.',
    'delete_your_account_password'                                              => '계속하려면 비밀번호를 입력하세요.',
    'password'                                                                  => '비밀번호',
    'are_you_sure'                                                              => '정말로요? 되돌릴 수 없습니다.',
    'are_you_sure_confirm'                                                      => 'Are you sure?',
    'delete_account_button'                                                     => '계정 삭제하기',
    'invalid_current_password'                                                  => '현재 비밀번호가 잘못되었습니다!',
    'password_changed'                                                          => '비밀번호가 변경되었습니다!',
    'should_change'                                                             => '비밀번호를 변경하는 것이 좋습니다.',
    'invalid_password'                                                          => '비밀번호가 잘못되었습니다!',
    'what_is_pw_security'                                                       => '"비밀번호 보안 확인"이란 무엇인가요?',
    'secure_pw_title'                                                           => '안전한 비밀번호를 선택하는 방법',
    'forgot_password_response'                                                  => '감사합니다. 이 이메일 주소를 사용하는 계정이 있는 경우 받은 편지함에서 지침을 찾을 수 있습니다.',
    'secure_pw_history'                                                         => '매주 사용자의 암호를 잃어버린 사이트에 대한 뉴스를 접하게 됩니다. 해커와 도둑은 이러한 비밀번호를 사용하여 개인 정보를 훔치려고 시도합니다. 이 정보는 매우 중요합니다.',
    'secure_pw_ff'                                                              => '인터넷에서 모두 동일한 비밀번호를 사용하시나요? 한 사이트에서 비밀번호를 분실하면 해커가 모든 데이터에 액세스할 수 있습니다. Firefly III에서는 사용자의 금융 기록을 보호하기 위해 강력하고 고유한 비밀번호를 지정해야 합니다.',
    'secure_pw_check_box'                                                       => '이를 위해 Firefly III는 사용하려는 비밀번호가 과거에 도용된 적이 있는지 확인할 수 있습니다. 도용된 적이 있는 경우 Firefly III는 해당 비밀번호를 사용하지 말 것을 권고합니다.',
    'secure_pw_working_title'                                                   => '어떻게 작동하나요?',
    'secure_pw_working'                                                         => '이 확인란을 선택하면 Firefly III가 비밀번호의 SHA1 해시 중 처음 다섯 문자를 <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">트로이 헌트 웹사이트</a>로 전송하여 목록에 있는지 확인합니다. 이렇게 하면 이 주제에 관한 최신 <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">NIST 특별 간행물</a>에서 권장하는 대로 안전하지 않은 비밀번호를 사용하는 것을 방지할 수 있습니다.',
    'secure_pw_should'                                                          => '확인란을 선택해야 하나요?',
    'secure_pw_long_password'                                                   => '예. 비밀번호가 안전한지 항상 확인하세요.',
    'command_line_token'                                                        => '명령줄 토큰',
    'explain_command_line_token'                                                => '데이터 내보내기와 같은 명령줄 옵션을 수행하려면 이 토큰이 필요합니다. 이 토큰이 없으면 민감한 명령이 작동하지 않습니다. 명령줄 토큰을 공유하지 마세요. 저를 포함해 그 누구도 이 토큰을 요구하지 않습니다. 분실할까 봐 걱정되거나 불안한 경우에는 버튼을 사용하여 토큰을 다시 생성하세요.',
    'regenerate_command_line_token'                                             => '명령줄 토큰 다시 생성',
    'token_regenerated'                                                         => '새로운 명령줄 토큰이 생성되었습니다',
    'change_your_email'                                                         => '이메일 주소 변경',
    'email_verification'                                                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                                                      => '이메일 주소를 인증할 때까지 로그인할 수 없습니다.',
    'login_with_new_email'                                                      => '이제 새 이메일 주소로 로그인할 수 있습니다.',
    'login_with_old_email'                                                      => '이제 이전 이메일 주소로 다시 로그인할 수 있습니다.',
    'login_provider_local_only'                                                 => '":login_provider"를 통해 인증하는 경우에는 이 작업을 사용할 수 없습니다.',
    'external_user_mgt_disabled'                                                => 'Firefly III가 사용자 관리 또는 인증 처리를 담당하지 않는 경우 이 작업을 사용할 수 없습니다.',
    'external_auth_disabled'                                                    => 'Firefly III가 인증 처리를 담당하지 않는 경우 이 작업을 사용할 수 없습니다.',
    'delete_local_info_only'                                                    => "Firefly III는 사용자 관리 또는 인증 처리를 담당하지 않기 때문에 이 기능은 로컬 Firefly III 정보만 삭제합니다.",
    'oauth'                                                                     => 'OAuth',
    'profile_oauth_clients'                                                     => 'OAuth 클라이언트',
    'profile_oauth_no_clients'                                                  => 'OAuth 클라이언트를 만들지 않았습니다.',
    'profile_oauth_clients_external_auth'                                       => 'Authelia와 같은 외부 인증 제공업체를 사용하는 경우 OAuth 클라이언트가 작동하지 않습니다. 개인 액세스 토큰만 사용할 수 있습니다.',
    'profile_oauth_clients_header'                                              => '클라이언트',
    'profile_oauth_client_id'                                                   => '클라이언트 ID',
    'profile_oauth_client_name'                                                 => '이름',
    'profile_oauth_client_secret'                                               => '시크릿',
    'profile_oauth_create_new_client'                                           => '새로운 클라이언트 만들기',
    'profile_oauth_create_client'                                               => '클라이언트 만들기',
    'profile_oauth_edit_client'                                                 => '클라이언트 수정',
    'profile_oauth_name_help'                                                   => '사용자가 인지하고 신뢰할 수 있는 것.',
    'profile_oauth_redirect_url'                                                => '리디렉션 URL',
    'profile_oauth_redirect_url_help'                                           => '애플리케이션의 인증 콜백 URL입니다.',
    'profile_authorized_apps'                                                   => '인증된 애플리케이션',
    'profile_authorized_clients'                                                => '인증된 클라이언트',
    'profile_scopes'                                                            => '범위',
    'profile_revoke'                                                            => '취소',
    'profile_oauth_client_secret_title'                                         => '클라이언트 시크릿',
    'profile_oauth_client_secret_expl'                                          => '다음은 새 클라이언트 암호입니다. 이번 한 번만 표시되니 놓치지 마세요! 이제 이 비밀 번호를 사용하여 API 요청을 할 수 있습니다.',
    'profile_personal_access_tokens'                                            => '개인 액세스 토큰',
    'profile_personal_access_token'                                             => '개인 액세스 토큰',
    'profile_oauth_confidential'                                                => '비밀',
    'profile_oauth_confidential_help'                                           => '클라이언트가 시크릿으로 인증하도록 요구합니다. 기밀 클라이언트는 권한이 없는 사람에게 자격 증명을 노출하지 않고 안전한 방식으로 자격 증명을 보관할 수 있습니다. 기본 데스크톱 또는 JavaScript SPA 애플리케이션과 같은 공개 애플리케이션은 시크릿을 안전하게 보관할 수 없습니다.',
    'profile_personal_access_token_explanation'                                 => '다음은 새 개인용 액세스 토큰입니다. 이번 한 번만 표시되니 놓치지 마세요! 이제 이 토큰을 사용하여 API 요청을 할 수 있습니다.',
    'profile_no_personal_access_token'                                          => '개인 액세스 토큰을 생성하지 않았습니다.',
    'profile_create_new_token'                                                  => '새로운 토큰 만들기',
    'profile_create_token'                                                      => '토큰 생성',
    'profile_create'                                                            => '생성',
    'profile_save_changes'                                                      => '변경사항 저장',
    'profile_whoops'                                                            => '이런!',
    'profile_something_wrong'                                                   => '문제가 발생했습니다!',
    'profile_try_again'                                                         => '문제가 발생했습니다. 다시 시도해주세요.',
    'amounts'                                                                   => '금액',
    'multi_account_warning_unknown'                                             => '생성한 거래 유형에 따라 뒤따르는 분할의 소스 및/또는 대상 계정은 대상 계정 거래의 첫 번째 분할에 정의된 내용에 따라 무시될 수 있습니다.',
    'multi_account_warning_withdrawal'                                          => '뒤따르는 분할의 소스 계정은 첫 번째 출금 분할에 정의된 내용에 따라 재정의된다는 점에 유의하시기 바랍니다.',
    'multi_account_warning_deposit'                                             => '뒤따르는 분할의 대상 계정은 첫 번째 입금 분할에 정의된 내용에 따라 재정의된다는 점에 유의하시기 바랍니다.',
    'multi_account_warning_transfer'                                            => '뒤따르는 분할의 소스 + 대상 계정은 첫 번째 이체 분할에 정의된 내용에 따라 재정의된다는 점에 유의하시기 바랍니다.',



    // export data:
    'export_data_title'                                                         => 'Firefly III에서 데이터 내보내기',
    'export_data_menu'                                                          => '데이터 내보내기',
    'export_data_bc'                                                            => 'Firefly III에서 데이터 내보내기',
    'export_data_main_title'                                                    => 'Firefly III에서 데이터 내보내기',
    'export_data_expl'                                                          => '이 링크를 통해 Firefly III에서 모든 거래 + 메타 데이터를 내보낼 수 있습니다. 프로세스에 대한 자세한 내용은 도움말(오른쪽 상단(?)-아이콘)을 참조하세요.',
    'export_data_all_transactions'                                              => '모든 거래 내보내기',
    'export_data_advanced_expl'                                                 => '고급 또는 특정 유형의 내보내기가 필요한 경우 콘솔 명령 <code>php artisan help firefly-iii:export-data</code> 으로 사용법에 대한 도움말을 읽으십시오.',

    // attachments
    'nr_of_attachments'                                                         => '하나의 첨부 파일|:count개의 첨부 파일',
    'attachments'                                                               => '첨부 파일',
    'edit_attachment'                                                           => '":name" 첨부파일 수정',
    'update_attachment'                                                         => '첨부파일 업데이트',
    'delete_attachment'                                                         => '":name" 첨부파일 삭제',
    'attachment_deleted'                                                        => '":name" 첨부파일 삭제됨',
    'liabilities_deleted'                                                       => '":name" 부채 삭제됨',
    'attachment_updated'                                                        => '":name" 첨부파일 업데이트됨',
    'upload_max_file_size'                                                      => '최대 파일 크기: :size',
    'list_all_attachments'                                                      => '모든 첨부 파일 목록',

    // transaction index
    'is_reconciled_fields_dropped'                                              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                                                             => 'Is reconciled',
    'title_expenses'                                                            => '지출',
    'title_withdrawal'                                                          => '지출',
    'title_revenue'                                                             => '수익 / 수입',
    'title_deposit'                                                             => '수익 / 수입',
    'title_transfer'                                                            => '이체',
    'title_transfers'                                                           => '이체',
    'submission_options'                                                        => '제출 옵션',
    'apply_rules_checkbox'                                                      => '규칙 적용',
    'fire_webhooks_checkbox'                                                    => '웹훅 실행',
    'select_source_account'                                                     => '유효한 소스 계정 내역을 선택 또는 타입을 선택하십시오.',
    'select_dest_account'                                                       => '유효한 대상 계정 내역을 선택 또는 타입을 선택하십시오.',

    // convert stuff:
    'convert_is_already_type_Withdrawal'                                        => '이 거래는 이미 출금되었습니다',
    'convert_is_already_type_Deposit'                                           => '이 거래는 이미 입금되었습니다',
    'convert_is_already_type_Transfer'                                          => '이 거래는 이미 이체되었습니다',
    'convert_to_Withdrawal'                                                     => '":description"을 출금으로 전환',
    'convert_to_Deposit'                                                        => '":description"을 입금으로 전환',
    'convert_to_Transfer'                                                       => '":description"을 이체로 전환',
    'convert_options_WithdrawalDeposit'                                         => '출금을 입금으로 전환',
    'convert_options_WithdrawalTransfer'                                        => '출금을 이체로 전환',
    'convert_options_DepositTransfer'                                           => '입금을 이체로 전환',
    'convert_options_DepositWithdrawal'                                         => '입금을 출금으로 전환',
    'convert_options_TransferWithdrawal'                                        => '이체를 출금으로 전환',
    'convert_options_TransferDeposit'                                           => '이체를 입금으로 전환',
    'convert_Withdrawal_to_deposit'                                             => '이 출금을 입금으로 전환',
    'convert_Withdrawal_to_transfer'                                            => '이 출금을 이체로 전환',
    'convert_Deposit_to_withdrawal'                                             => '이 입금을 출금으로 전환',
    'convert_Deposit_to_transfer'                                               => '이 입금을 이체로 전환',
    'convert_Transfer_to_deposit'                                               => '이 이체를 입금으로 전환',
    'convert_Transfer_to_withdrawal'                                            => '이 이체를 출금으로 전환',
    'convert_please_set_revenue_source'                                         => '돈이 나올 수익 계정을 선택하세요.',
    'convert_please_set_asset_destination'                                      => '돈이 들어갈 자산 계정을 선택하세요.',
    'convert_please_set_expense_destination'                                    => '돈이 들어갈 비용 계정을 선택하세요.',
    'convert_please_set_asset_source'                                           => '돈이 나올 자산 계정을 선택하세요.',
    'convert_expl_w_d'                                                          => '출금에서 입금으로 변환할 때는 금액이 인출되지 않고 표시된 대상 계좌로 입금됩니다.|출금에서 입금으로 변환할 때는 금액이 출금되지 않고 표시된 대상 계좌로 입금됩니다.',
    'convert_expl_w_t'                                                          => '출금을 이체로 전환하는 경우, 해당 금액은 원래의 비용 계정에서 지출되지 않고 소스 계정에서 다른 자산 또는 부채 계정으로 이체됩니다.|인출을 이체로 전환하는 경우, 해당 금액은 원래의 비용 계정에서 지출되지 않고 소스 계정에서 다른 자산 또는 부채 계정으로 이체됩니다.',
    'convert_expl_d_w'                                                          => '입금을 출금으로 전환하는 경우 표시된 소스 계좌에 입금되지 않고 표시된 소스 계좌에서 출금됩니다.|입금을 출금으로 전환하는 경우 표시된 소스 계좌에 입금되지 않고 표시된 소스 계좌에서 출금됩니다.',
    'convert_expl_d_t'                                                          => '입금을 이체로 전환하는 경우 자산 또는 부채 계좌에서 나열된 대상 계좌로 금액이 입금됩니다.|입금을 이체로 전환하는 경우 자산 또는 부채 계좌에서 나열된 대상 계좌로 금액이 입금됩니다.',
    'convert_expl_t_w'                                                          => '이체를 출금으로 전환하는 경우 이 금액은 다른 계좌로 이체되지 않고 여기에서 설정한 대상 계좌에서 지출됩니다.|이체를 출금으로 전환하는 경우 이 금액은 다른 계좌로 이체되지 않고 여기에서 설정한 대상 계좌에서 지출됩니다.',
    'convert_expl_t_d'                                                          => '이체를 입금으로 전환하는 경우 돈이 이체되는 대신 여기에 표시된 대상 계좌로 입금됩니다.|이체를 입금으로 전환하는 경우 돈이 이체되는 대신 여기에 표시된 대상 계좌로 입금됩니다.',
    'convert_select_sources'                                                    => '전환을 완료하려면 아래에 새 소스 계정을 설정하세요.|전환을 완료하려면 아래에 새 소스 계정들을 설정하세요.',
    'convert_select_destinations'                                               => '전환을 완료하려면 아래에 새 대상 계정을 설정하세요.|전환을 완료하려면 아래에 새 대상 계정들을 설정하세요.',
    'converted_to_Withdrawal'                                                   => '거래가 출금으로 전환되었습니다',
    'converted_to_Deposit'                                                      => '거래가 입금으로 전환되었습니다',
    'converted_to_Transfer'                                                     => '거래가 이체로 전환되었습니다',
    'invalid_convert_selection'                                                 => '선택한 계정이 이 거래에서 이미 사용 중이거나 존재하지 않습니다.',
    'source_or_dest_invalid'                                                    => '올바른 거래 세부정보를 찾을 수 없습니다. 변환할 수 없습니다.',
    'convert_to_withdrawal'                                                     => '출금으로 전환',
    'convert_to_deposit'                                                        => '입금으로 전환',
    'convert_to_transfer'                                                       => '이체로 전환',

    // create new stuff:
    'create_new_withdrawal'                                                     => '새로운 출금 생성',
    'create_new_deposit'                                                        => '새로운 입금 생성',
    'create_new_transfer'                                                       => '새로운 이체 생성',
    'create_new_asset'                                                          => '새 자산 계정 생성',
    'create_new_liabilities'                                                    => '새 부채 생성',
    'create_new_expense'                                                        => '새 지출 계정 생성',
    'create_new_revenue'                                                        => '새 수익 계정 생성',
    'create_new_piggy_bank'                                                     => '새 저금통 만들기',
    'create_new_bill'                                                           => 'Create new subscription',
    'create_new_subscription'                                                   => '새 구독 생성하기',
    'create_new_rule'                                                           => '새 규칙 만들기',

    // currencies:
    'create_currency'                                                           => '새로운 통화 생성',
    'store_currency'                                                            => '새 통화 저장',
    'update_currency'                                                           => '통화 업데이트',
    'new_default_currency'                                                      => '기본 통화는 이제 ":name" 입니다.',
    'default_currency_failed'                                                   => '기본 통화 ":name"을 만들 수 없습니다. 로그를 확인해 주십시오.',
    'cannot_delete_currency'                                                    => ':name을(를) 아직 사용 중이므로 삭제할 수 없습니다.',
    'cannot_delete_fallback_currency'                                           => ':name은 시스템 대체 통화이며 삭제할 수 없습니다.',
    'cannot_disable_currency_journals'                                          => '거래가 여전히 :name을 사용하고 있으므로 비활성화할 수 없습니다.',
    'cannot_disable_currency_last_left'                                         => ':name은 마지막으로 활성화한 통화이므로 비활성화할 수 없습니다.',
    'cannot_disable_currency_account_meta'                                      => ':name은 자산 계정에서 사용되므로 비활성화할 수 없습니다.',
    'cannot_disable_currency_bills'                                             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'                                         => ':name은 반복 거래에서 사용되므로 비활성화할 수 없습니다.',
    'cannot_disable_currency_available_budgets'                                 => ':name은 사용가능한 예산에서 사용되므로 비활성화할 수 없습니다.',
    'cannot_disable_currency_budget_limits'                                     => '예산 한도에서 사용되므로 :name을 비활성화할 수 없습니다.',
    'cannot_disable_currency_current_default'                                   => ':name은 현재 기본 통화이므로 비활성화 할 수 없습니다.',
    'cannot_disable_currency_system_fallback'                                   => ':name은 시스템 기본 통화이므로 비활성화할 수 없습니다.',
    'disable_EUR_side_effects'                                                  => '유로화는 시스템의 비상 대체 통화입니다. 이를 비활성화하면 의도하지 않은 부작용이 발생할 수 있으며 보증이 무효화될 수 있습니다.',
    'deleted_currency'                                                          => ':name 통화 삭제됨',
    'created_currency'                                                          => ':name 통화 생성됨',
    'could_not_store_currency'                                                  => '새 통화를 저장할 수 없습니다.',
    'updated_currency'                                                          => ':name 통화 업데이트됨',
    'ask_site_owner'                                                            => '통화를 추가, 제거 또는 수정하려면 :owner에게 문의하세요.',
    'currencies_intro'                                                          => 'Firefly III는 여기에서 설정하고 활성화할 수 있는 다양한 통화를 지원합니다.',
    'currencies_switch_default'                                                 => 'You can switch the native currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                                                     => '기본값으로 설정',
    'default_currency'                                                          => '기본값',
    'native_currency_button'                                                    => 'native',
    'currency_is_disabled'                                                      => '비활성화됨',
    'enable_currency'                                                           => '활성화',
    'disable_currency'                                                          => '비활성화',
    'currencies_default_disabled'                                               => '이러한 통화는 대부분 기본적으로 비활성화되어 있습니다. 사용하려면 먼저 활성화해야 합니다.',
    'currency_is_now_enabled'                                                   => '":name" 통화가 활성화되었습니다',
    'could_not_enable_currency'                                                 => '통화 ":name"을 활성화 할 수 없습니다. 로그를 확인해 주십시오.',
    'currency_is_now_disabled'                                                  => '":name" 통화가 비활성화되었습니다',
    'could_not_disable_currency'                                                => '통화 ":name"을 비활성화 할 수 없습니다. 여전히 통화가 사용되고 있을 수 있습니다.',

    // forms:
    'mandatoryFields'                                                           => '필수 입력 항목',
    'optionalFields'                                                            => '선택 입력 항목',
    'options'                                                                   => '옵션',

    // budgets:
    'daily_budgets'                                                             => '일일 예산',
    'weekly_budgets'                                                            => '주간 예산',
    'monthly_budgets'                                                           => '월간 예산',
    'quarterly_budgets'                                                         => '분기별 예산',
    'half_year_budgets'                                                         => '반기 예산',
    'yearly_budgets'                                                            => '연간 예산',
    'other_budgets'                                                             => '사용자 정의 시간 예산',
    'budget_limit_not_in_range'                                                 => '이 금액은 :start부터 :end까지 적용됩니다',
    'total_available_budget'                                                    => '사용 가능한 총 예산 (:start에서 :end 사이)',
    'total_available_budget_in_currency'                                        => ':currency로 사용 가능한 총 예산',
    'see_below'                                                                 => '아래를 참조하세요.',
    'create_new_budget'                                                         => '새로운 예산 생성',
    'store_new_budget'                                                          => '새 예산 저장',
    'stored_new_budget'                                                         => '새 예산 ":name" 저장됨',
    'available_between'                                                         => ':start와 :end 사이에서 사용 가능',
    'transactionsWithoutBudget'                                                 => '예산이 없는 지출',
    'transactions_no_budget'                                                    => ':start과 :end 사이에 예산이 없는 지출',
    'spent_between'                                                             => ':start와 :end 사이에 이미 사용되었습니다',
    'spent_between_left'                                                        => ':left를 제외한 :start 부터 :end 까지 지출 :spent',
    'set_available_amount'                                                      => '사용 가능한 금액 설정',
    'update_available_amount'                                                   => '사용 가능한 금액 업데이트',
    'ab_basic_modal_explain'                                                    => '이 양식을 사용하여 지정한 기간에 예산을 책정할 수 있을 것으로 예상되는 금액(총액, :currency)을 표시하세요.',
    'createBudget'                                                              => '새 예산',
    'invalid_currency'                                                          => '유효하지 않은 통화입니다',
    'invalid_amount'                                                            => '금액을 입력하세요',
    'set_ab'                                                                    => '사용 가능한 예산 금액이 설정되었습니다',
    'updated_ab'                                                                => '사용 가능한 예산 금액이 업데이트되었습니다',
    'deleted_ab'                                                                => '사용 가능한 예산 금액이 삭제되었습니다',
    'deleted_bl'                                                                => '예산 금액이 제거되었습니다',
    'alt_currency_ab_create'                                                    => '사용 가능한 예산을 다른 통화로 설정',
    'bl_create_btn'                                                             => '다른 통화로 예산 설정',
    'inactiveBudgets'                                                           => '비활성 예산',
    'without_budget_between'                                                    => ':start과 :end 사이에 예산이 없는 거래',
    'delete_budget'                                                             => '":name" 예산 삭제',
    'deleted_budget'                                                            => '":name" 예산 삭제됨',
    'edit_budget'                                                               => '":name" 예산 수정',
    'updated_budget'                                                            => '":name" 예산 업데이트됨',
    'update_amount'                                                             => '금액 업데이트',
    'update_budget'                                                             => '예산 업데이트',
    'update_budget_amount_range'                                                => ':start과 :end 사이의 사용 가능한 금액 업데이트 (예상)',
    'set_budget_limit_title'                                                    => ':start과 :end 사이에 예산 :budget에 대한 예산 금액 설정',
    'set_budget_limit'                                                          => '예산 금액 설정',
    'budget_period_navigator'                                                   => '기간 탐색기',
    'info_on_available_amount'                                                  => '무엇을 사용할 수 있나요?',
    'available_amount_indication'                                               => '이 금액을 사용하여 총 예산이 얼마인지 파악할 수 있습니다.',
    'suggested'                                                                 => '추천',
    'average_between'                                                           => ':start과 :end 사이의 평균',
    'transferred_in'                                                            => '전송됨 (입)',
    'transferred_away'                                                          => '전송됨 (출)',
    'auto_budget_none'                                                          => '자동 예산 없음',
    'auto_budget_reset'                                                         => '매 기간마다 고정 금액 설정',
    'auto_budget_rollover'                                                      => '기간마다 금액 추가',
    'auto_budget_adjusted'                                                      => '초과 지출을 수정하기 위해 매 기간마다 금액을 추가합니다.',
    'auto_budget_period_daily'                                                  => '매일',
    'auto_budget_period_weekly'                                                 => '매주',
    'auto_budget_period_monthly'                                                => '월간',
    'auto_budget_period_quarterly'                                              => '분기별',
    'auto_budget_period_half_year'                                              => '반년마다',
    'auto_budget_period_yearly'                                                 => '연간',
    'auto_budget_help'                                                          => '이 기능에 대한 자세한 내용은 도움말에서 확인할 수 있습니다. 오른쪽 상단의 (?) 아이콘을 클릭합니다.',
    'auto_budget_reset_icon'                                                    => '이 예산은 주기적으로 설정됩니다.',
    'auto_budget_rollover_icon'                                                 => '예산 금액은 주기적으로 증가합니다.',
    'auto_budget_adjusted_icon'                                                 => '예산 금액은 주기적으로 증가하고, 초과지출을 수정합니다.',
    'remove_budgeted_amount'                                                    => ':currency에서 예산 금액 제거',

    // bills:
    'skip_help_text'                                                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                                                              => '구독',
    'not_expected_period'                                                       => '이 기간에는 예상되지 않음',
    'subscriptions_in_group'                                                    => '그룹 "%{title}" 내 구독',
    'subscr_expected_x_times'                                                   => '이 기간에 %{amount} 를 %{times} 번 예상됩니다.',
    'not_or_not_yet'                                                            => '아니요 (아직)',
    'visit_bill'                                                                => 'Visit subscription ":name" at Firefly III',
    'match_between_amounts'                                                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                                                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                                                        => 'Rules related to this subscription',
    'repeats'                                                                   => '반복',
    'bill_end_date_help'                                                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                                                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                                                       => 'This subscription ends on :date',
    'bill_extension_index_line'                                                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                                                        => '연결된 거래',
    'auto_match_on'                                                             => 'Firefly III에 의해 자동 매칭',
    'auto_match_off'                                                            => 'Firefly III에 의해 자동 매칭되지 않음',
    'next_expected_match'                                                       => '다음 예상 지불일',
    'delete_bill'                                                               => 'Delete subscription ":name"',
    'deleted_bill'                                                              => 'Deleted subscription ":name"',
    'edit_bill'                                                                 => 'Edit subscription ":name"',
    'more'                                                                      => '더보기',
    'rescan_old'                                                                => '모든 거래에서 규칙을 다시 실행합니다',
    'update_bill'                                                               => 'Update subscription',
    'updated_bill'                                                              => 'Updated subscription ":name"',
    'store_new_bill'                                                            => 'Store new subscription',
    'stored_new_bill'                                                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                                                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                                                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                                                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'                                               => 'Average subscription amount (overall)',
    'bill_is_active'                                                            => 'Subscription is active',
    'bill_expected_between'                                                     => ':start와 :end 사이에 예상됨',
    'bill_will_automatch'                                                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                                                => '건너뛰기',
    'bill_store_error'                                                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                                                        => '비활성 규칙',
    'bill_edit_rules'                                                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                                                        => ':date 예정',
    'bill_expected_date_js'                                                     => '{date} 예정',
    'expected_amount'                                                           => '(예상) 금액',
    'bill_paid_on'                                                              => '{date}에 결제',
    'bill_repeats_weekly'                                                       => '매주 반복',
    'bill_repeats_monthly'                                                      => '매달 반복',
    'bill_repeats_quarterly'                                                    => '분기별 반복',
    'bill_repeats_half-year'                                                    => '반년마다 반복',
    'bill_repeats_yearly'                                                       => '매년 반복',
    'bill_repeats_weekly_other'                                                 => '격주 반복',
    'bill_repeats_monthly_other'                                                => '격월 반복',
    'bill_repeats_quarterly_other'                                              => '격분기 반복',
    'bill_repeats_half-year_other'                                              => '매년 반복',
    'bill_repeats_yearly_other'                                                 => '격년 반복',
    'bill_repeats_weekly_skip'                                                  => '{skip} 주마다 반복',
    'bill_repeats_monthly_skip'                                                 => '{skip} 월마다 반복',
    'bill_repeats_quarterly_skip'                                               => '{skip} 분기마다 반복',
    'bill_repeats_half-year_skip'                                               => '{skip} 반년마다 반복',
    'bill_repeats_yearly_skip'                                                  => '{skip} 년마다 반복',
    'subscriptions'                                                             => '구독',
    'go_to_subscriptions'                                                       => '구독으로 이동하기',
    'forever'                                                                   => '무기한',
    'extension_date_is'                                                         => '연장 날짜는 {date}입니다',

    // accounts:
    'account_locked_currency'                                                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                                                          => '미납 금액',
    'i_owe_amount'                                                              => '미납 금액',
    'inactive_account_link'                                                     => '비활성(보관된) 계정이 :count개가 있으며, 이 별도 페이지에서 확인할 수 있습니다.|비활성(보관된) 계정이 :count개가 있으며, 이 별도 페이지에서 확인할 수 있습니다.',
    'all_accounts_inactive'                                                     => '귀하의 비활성 계정입니다.',
    'active_account_link'                                                       => '이 링크는 활성 계정으로 돌아갑니다.',
    'account_missing_transaction'                                               => '계정 #:id(":name")를 직접 볼 수 없지만 Firefly에 리디렉션 정보가 누락되어 있습니다.',
    'cc_monthly_payment_date_help'                                              => '연도와 월을 선택해도 무시됩니다. 해당 월의 날짜만 관련이 있습니다.',
    'details_for_asset'                                                         => '자산 계정 ":name"에 대한 세부 정보',
    'details_for_expense'                                                       => '지출 계정 ":name"에 대한 세부 정보',
    'details_for_revenue'                                                       => '수익 계정 ":name"에 대한 세부 정보',
    'details_for_cash'                                                          => '현금 계정 ":name"에 대한 세부 정보',
    'store_new_asset_account'                                                   => '새 자산 계정 저장',
    'store_new_expense_account'                                                 => '새 지출 계정 저장',
    'store_new_revenue_account'                                                 => '새 수익 계정 저장',
    'edit_asset_account'                                                        => '":name" 자산 계정 수정',
    'edit_expense_account'                                                      => '":name" 지출 계정 수정',
    'edit_revenue_account'                                                      => '":name" 수익 계정 수정',
    'delete_asset_account'                                                      => '":name" 자산 계정 삭제',
    'delete_expense_account'                                                    => '":name" 지출 계정 삭제',
    'delete_revenue_account'                                                    => '":name" 수익 계정 삭제',
    'delete_liabilities_account'                                                => '":name" 부채 삭제',
    'asset_deleted'                                                             => '":name" 자산 계정 삭제 성공',
    'account_deleted'                                                           => '":name" 계정 삭제 성공',
    'expense_deleted'                                                           => '":name" 지출 계정 삭제 성공',
    'revenue_deleted'                                                           => '":name" 수익 계정 삭제 성공',
    'update_asset_account'                                                      => '자산 계정 업데이트',
    'update_undefined_account'                                                  => '계정 업데이트',
    'update_liabilities_account'                                                => '부채 업데이트',
    'update_expense_account'                                                    => '지출 계정 업데이트',
    'update_revenue_account'                                                    => '수익 계정 업데이트',
    'make_new_asset_account'                                                    => '새 자산 계정 생성',
    'make_new_expense_account'                                                  => '새 지출 계정 생성',
    'make_new_revenue_account'                                                  => '새 수익 계정 생성',
    'make_new_liabilities_account'                                              => '새 부채 생성',
    'asset_accounts'                                                            => '자산 계정',
    'undefined_accounts'                                                        => '계정',
    'asset_accounts_inactive'                                                   => '자산 계정 (비활성)',
    'expense_account'                                                           => '지출 계정',
    'expense_accounts'                                                          => '지출 계정',
    'expense_accounts_inactive'                                                 => '지출 계정 (비활성)',
    'revenue_account'                                                           => '수익 계정',
    'revenue_accounts'                                                          => '수익 계정',
    'revenue_accounts_inactive'                                                 => '수익 계정 (비활성)',
    'cash_accounts'                                                             => '현금 계정',
    'Cash account'                                                              => '현금 계정',
    'liabilities_accounts'                                                      => '부채',
    'liabilities_accounts_inactive'                                             => '부채 (비활성)',
    'reconcile_account'                                                         => '":account" 계정 조정',
    'overview_of_reconcile_modal'                                               => '조정 개요',
    'delete_reconciliation'                                                     => '조정 삭제',
    'update_reconciliation'                                                     => '조정 업데이트',
    'amount_cannot_be_zero'                                                     => '금액은 0이 될 수 없습니다',
    'end_of_reconcile_period'                                                   => '조정 기간 종료: :period',
    'start_of_reconcile_period'                                                 => '조정 기간 시작: :period',
    'start_balance'                                                             => '시작 잔액',
    'end_balance'                                                               => '종료 잔액',
    'update_balance_dates_instruction'                                          => '위의 금액과 날짜를 은행 명세서와 일치시키고 \'조정 시작\'을 누릅니다.',
    'select_transactions_instruction'                                           => '은행 명세서에 표시되는 거래를 선택합니다.',
    'select_range_and_balance'                                                  => '먼저 날짜 범위와 잔액을 확인합니다. 그런 다음 "조정 시작"을 누릅니다.',
    'date_change_instruction'                                                   => '지금 날짜 범위를 변경하면 진행 상황을 모두 잃어버립니다.',
    'update_selection'                                                          => '선택 항목 업데이트',
    'store_reconcile'                                                           => '조정 저장',
    'reconciliation_transaction'                                                => '조정 거래',
    'Reconciliation'                                                            => '조정',
    'reconciliation'                                                            => '조정',
    'reconcile_options'                                                         => '조정 옵션',
    'reconcile_range'                                                           => '조정 범위',
    'start_reconcile'                                                           => '조정 시작',
    'cash_account_type'                                                         => '현금',
    'cash'                                                                      => '현금',
    'cant_find_redirect_account'                                                => 'Firefly III가 리디렉션을 시도했지만 실패했습니다. 죄송합니다. 색인으로 돌아갑니다.',
    'account_type'                                                              => '계정 유형',
    'save_transactions_by_moving'                                               => '이 거래를 다른 계정으로 이동하여 저장:|이 거래들을 다른 계정으로 이동하여 저장:',
    'save_transactions_by_moving_js'                                            => '거래가 없음|이 거래를 다른 계정으로 이동하여 저장합니다.|이 거래들을 다른 계정으로 이동하여 저장합니다.',
    'stored_new_account'                                                        => '새 계정 ":name"이 저장되었습니다!',
    'stored_new_account_js'                                                     => '새로운 "<a href="accounts/show/{ID}">{name}</a>" 계정이 저장되었습니다!',
    'updated_account'                                                           => '":name" 계정 업데이트됨',
    'updated_account_js'                                                        => '"<a href="accounts/show/{ID}">{title}</a>" 계정이 업데이트 되었습니다.',
    'credit_card_options'                                                       => '신용 카드 옵션',
    'no_transactions_account'                                                   => '자산 계정 ":name"에 대한 거래가 (이 기간 동안) 없습니다.',
    'no_transactions_period'                                                    => '(이 기간 동안) 거래가 없습니다.',
    'no_data_for_chart'                                                         => '이 차트를 생성하기 위한 정보가 (아직) 충분하지 않습니다.',
    'select_at_least_one_account'                                               => '자산 계정을 하나 이상 선택해 주세요',
    'select_at_least_one_category'                                              => '카테고리를 하나 이상 선택해 주세요',
    'select_at_least_one_budget'                                                => '예산을 하나 이상 선택해 주세요',
    'select_at_least_one_tag'                                                   => '태그를 하나 이상 선택해 주세요',
    'select_at_least_one_expense'                                               => '비용/수익 계정 조합을 하나 이상 선택해 주세요. 없는 경우(목록이 비어 있는 경우) 이 보고서를 사용할 수 없습니다.',
    'account_default_currency'                                                  => '이것은 이 계정과 연결된 기본 통화가 됩니다.',
    'piggy_default_currency'                                                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'                                              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                                                        => 'Firefly III 원장에 은행에서 청구한 금액보다 더 많은 금액이 있습니다. 몇 가지 옵션이 있습니다. 수행할 작업을 선택하십시오. 그런 다음 "조정 확인"을 누릅니다.',
    'reconcile_has_less'                                                        => 'Firefly III 원장에 은행에서 청구한 금액보다 더 적은 금액이 있습니다. 몇 가지 옵션이 있습니다. 수행할 작업을 선택하십시오. 그런 다음 "조정 확인"을 누릅니다.',
    'reconcile_is_equal'                                                        => 'Firefly III 원장과 은행 명세서가 일치합니다. 추가로 할 일이 없습니다. "조정 확인"을 눌러 입력 내용을 확인하십시오.',
    'create_pos_reconcile_transaction'                                          => '선택한 거래를 지우고 이 자산 계정에 :amount을 추가하는 정정을 생성합니다.',
    'create_neg_reconcile_transaction'                                          => '선택한 거래를 지우고 이 자산 계정에서 :amount을 제거하는 정정을 생성합니다.',
    'reconcile_do_nothing'                                                      => '선택한 거래를 지우지만 수정하지는 않습니다.',
    'reconcile_go_back'                                                         => '나중에 언제든지 수정 내용을 수정하거나 삭제할 수 있습니다.',
    'must_be_asset_account'                                                     => '자산 계정만 조정할 수 있습니다',
    'reconciliation_stored'                                                     => '조정이 저장됨',
    'reconciliation_error'                                                      => '거래가 조정된 것으로 표시되었지만 오류로 인해 수정 사항이 저장되지 않았습니다: :error',
    'reconciliation_transaction_title'                                          => '조정 (:from에서 :to로)',
    'sum_of_reconciliation'                                                     => '조정 합계',
    'reconcile_this_account'                                                    => '이 계정 조정하기',
    'reconcile'                                                                 => '조정',
    'show'                                                                      => '표시',
    'confirm_reconciliation'                                                    => '조정 확인',
    'submitted_start_balance'                                                   => '제출된 시작 잔고',
    'selected_transactions'                                                     => '선택한 거래 (:count)',
    'already_cleared_transactions'                                              => '이미 지워진 거래 (:count)',
    'submitted_end_balance'                                                     => '제출된 최종 잔고',
    'initial_balance_description'                                               => '":account"의 초기 잔고',
    'liability_credit_description'                                              => '":account"에 대한 부채 크레딧',
    'interest_calc_'                                                            => '알 수 없음',
    'interest_calc_daily'                                                       => '일별',
    'interest_calc_monthly'                                                     => '월별',
    'interest_calc_yearly'                                                      => '연간',
    'interest_calc_weekly'                                                      => '주당',
    'interest_calc_half-year'                                                   => '반기당',
    'interest_calc_quarterly'                                                   => '분기당',
    'initial_balance_account'                                                   => ':account의 초기 잔액 계정',
    'list_options'                                                              => '목록 옵션',
    'account_column_opt_drag_and_drop'                                          => 'Drag and drop',
    'account_column_opt_active'                                                 => 'Active',
    'account_column_opt_name'                                                   => 'Name',
    'account_column_opt_type'                                                   => 'Type',
    'account_column_opt_liability_type'                                         => 'Liability type',
    'account_column_opt_liability_direction'                                    => 'Liability direction',
    'account_column_opt_liability_interest'                                     => 'Liability interest',
    'account_column_opt_number'                                                 => 'Account number',
    'account_column_opt_current_balance'                                        => 'Current balance',
    'account_column_opt_amount_due'                                             => 'Amount due',
    'account_column_opt_last_activity'                                          => 'Last activity',
    'account_column_opt_balance_difference'                                     => 'Balance difference',
    'account_column_opt_menu'                                                   => 'Menu',

    // categories:
    'new_category'                                                              => '새 카테고리',
    'create_new_category'                                                       => '새 카테고리 생성',
    'without_category'                                                          => '카테고리 없음',
    'update_category'                                                           => '카테고리 업데이트',
    'updated_category'                                                          => '":name" 카테고리 업데이트됨',
    'categories'                                                                => '카테고리',
    'edit_category'                                                             => '":name" 카테고리 수정',
    'no_category'                                                               => '(카테고리 없음)',
    'unknown_category_plain'                                                    => '카테고리 없음',
    'category'                                                                  => '카테고리',
    'delete_category'                                                           => '":name" 카테고리 삭제',
    'deleted_category'                                                          => '":name" 카테고리 삭제됨',
    'store_category'                                                            => '새 카테고리 저장',
    'stored_category'                                                           => '새로운":name" 카테고리가 저장되었습니다',
    'without_category_between'                                                  => ':start와 :end 사이에 카테고리가 없음',



    // transactions:
    'wait_loading_transaction'                                                  => '폼을 로드하는 동안 기다려주세요.',
    'wait_loading_data'                                                         => '정보를 로드하는 동안 기다려주세요.',
    'wait_attachments'                                                          => '첨부 파일을 업로드하는 동안 기다려주세요.',
    'errors_upload'                                                             => '업로드에 실패했습니다. 브라우저 콘솔을 확인해 주십시오.',
    'amount_foreign_if'                                                         => '(있는 경우) 외화 금액',
    'amount_destination_account'                                                => '대상 계정의 통화로 표시된 금액',
    'edit_transaction_title'                                                    => '거래 ":description" 수정',
    'unreconcile'                                                               => '조정 되돌리기',
    'update_withdrawal'                                                         => '출금 업데이트',
    'update_deposit'                                                            => '입금 업데이트',
    'update_transaction'                                                        => '거래 업데이트',
    'update_transfer'                                                           => '이체 업데이트',
    'updated_withdrawal'                                                        => '":description" 출금이 업데이트됨',
    'updated_deposit'                                                           => '":description" 입금이 업데이트됨',
    'updated_transfer'                                                          => '":description" 이체가 업데이트됨',
    'no_changes_withdrawal'                                                     => '":description" 출금이 변경되지 않았습니다.',
    'no_changes_deposit'                                                        => '":description" 입금이 변경되지 않았습니다.',
    'no_changes_transfer'                                                       => '":description" 이체가 변경되지 않았습니다.',
    'delete_withdrawal'                                                         => '":description" 출금 삭제',
    'delete_deposit'                                                            => '":description" 입금 삭제',
    'delete_transfer'                                                           => '":description" 이체 삭제',
    'deleted_withdrawal'                                                        => '":description" 출금 삭제 성공',
    'deleted_deposit'                                                           => '":description" 입금 삭제 성공',
    'deleted_transfer'                                                          => '":description" 이체 삭제 성공',
    'deleted_reconciliation'                                                    => '":description" 조정 거래 삭제 성공',
    'stored_journal'                                                            => '새로운 ":description" 거래 생성 성공',
    'stored_journal_js'                                                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                                                   => '새로운 거래 생성 성공',
    'updated_journal_no_descr'                                                  => '거래 업데이트 성공',
    'select_transactions'                                                       => '거래 선택',
    'rule_group_select_transactions'                                            => '거래에 ":title" 적용',
    'rule_select_transactions'                                                  => '거래에 ":title" 적용',
    'stop_selection'                                                            => '거래 선택 중지',
    'reconcile_selected'                                                        => '조정',
    'mass_delete_journals'                                                      => '여러 거래 삭제',
    'mass_edit_journals'                                                        => '여러 거래 수정',
    'mass_bulk_journals'                                                        => '여러 거래 일괄 수정',
    'mass_bulk_journals_explain'                                                => '이 양식을 사용하면 아래 나열된 거래의 속성을 한 번에 업데이트할 수 있습니다. 여기에 표시되는 매개변수를 변경하면 표에 있는 모든 거래가 업데이트됩니다.',
    'part_of_split'                                                             => '이 거래는 분할된 거래 중 일부입니다. 모든 분할을 선택하지 않은 경우 거래의 절반만 변경될 수 있습니다.',
    'bulk_set_new_values'                                                       => '아래 입력을 사용하여 새 값을 설정합니다. 입력란을 비워두면 모두에게 비워집니다. 또한 출금에 대해서만 예산이 부여된다는 점에 유의하세요.',
    'no_bulk_category'                                                          => '카테고리 업데이트 안 함',
    'no_bulk_budget'                                                            => '예산 업데이트 안 함',
    'no_bulk_tags'                                                              => '태그 업데이트 안 함',
    'replace_with_these_tags'                                                   => '다음 태그로 바꾸기',
    'append_these_tags'                                                         => '다음 태그 추가',
    'mass_edit'                                                                 => '선택한 항목 개별 편집',
    'bulk_edit'                                                                 => '선택한 항목 일괄 편집',
    'mass_delete'                                                               => '선택항목 삭제',
    'cannot_edit_other_fields'                                                  => '표시할 공간이 없어서 여기에 표시된 항목 이외의 다른 항목은 대량 편집할 수 없습니다. 이러한 항목을 편집하려면 링크를 따라 하나씩 편집하세요.',
    'cannot_change_amount_reconciled'                                           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                                                 => '(예산 없음)',
    'no_bill'                                                                   => '(no subscription)',
    'account_per_budget'                                                        => '예산당 계정',
    'account_per_category'                                                      => '카테고리당 계정',
    'create_new_object'                                                         => '생성',
    'empty'                                                                     => '(비어 있음)',
    'all_other_budgets'                                                         => '(다른 모든 예산)',
    'all_other_accounts'                                                        => '(다른 모든 계정)',
    'expense_per_source_account'                                                => '소스 계정당 지출',
    'expense_per_destination_account'                                           => '대상 계정당 지출',
    'income_per_destination_account'                                            => '대상 계정당 수입',
    'spent_in_specific_category'                                                => '":category" 카테고리의 지출',
    'earned_in_specific_category'                                               => '":category" 카테고리의 수입',
    'spent_in_specific_tag'                                                     => '":tag" 태그의 지출',
    'earned_in_specific_tag'                                                    => '":tag" 태그의 수입',
    'income_per_source_account'                                                 => '소스 계정당 수입',
    'average_spending_per_destination'                                          => '대상 계정당 평균 지출',
    'average_spending_per_source'                                               => '소스 계정당 평균 지출',
    'average_earning_per_source'                                                => '소스 계정당 평균 수익',
    'average_earning_per_destination'                                           => '대상 계정당 평균 수익',
    'account_per_tag'                                                           => '태그당 계정',
    'tag_report_expenses_listed_once'                                           => '지출과 수입은 두 번 표시되지 않습니다. 거래에 여러 개의 태그가 있는 경우 해당 태그 중 하나만 표시될 수 있습니다. 이 목록에는 데이터가 누락된 것처럼 보일 수 있지만 금액은 정확합니다.',
    'double_report_expenses_charted_once'                                       => '지출과 수입은 두 번 표시되지 않습니다. 거래에 여러 개의 태그가 있는 경우 해당 태그 중 하나에만 표시될 수 있습니다. 이 차트에는 데이터가 누락된 것처럼 보일 수 있지만 금액은 정확합니다.',
    'tag_report_chart_single_tag'                                               => '이 차트는 단일 태그에 적용됩니다. 거래에 여러 개의 태그가 있는 경우 여기에 표시되는 내용이 다른 태그의 차트에도 반영될 수 있습니다.',
    'tag'                                                                       => '태그',
    'no_budget_squared'                                                         => '(예산 없음)',
    'perm-delete-many'                                                          => '한 번에 많은 항목을 삭제하면 매우 혼란스러울 수 있으니 주의하시기 바랍니다. 이 페이지에서 분할 거래의 일부만 삭제할 수 있으므로 주의하세요.',
    'mass_deleted_transactions_success'                                         => ':count개 거래가 삭제되었습니다.|:count개 거래가 삭제되었습니다.',
    'mass_edited_transactions_success'                                          => ':count개 거래가 업데이트되었습니다.|:count개 거래가 업데이트되었습니다.',
    'opt_group_'                                                                => '(계정 유형 없음)',
    'opt_group_no_account_type'                                                 => '(계정 유형 없음)',
    'opt_group_defaultAsset'                                                    => '기본 자산 계정',
    'opt_group_savingAsset'                                                     => '예금 계좌',
    'opt_group_sharedAsset'                                                     => '공유 자산 계정',
    'opt_group_ccAsset'                                                         => '신용카드',
    'opt_group_cashWalletAsset'                                                 => '현금 지갑',
    'opt_group_expense_account'                                                 => '지출 계정',
    'opt_group_revenue_account'                                                 => '수익 계정',
    'opt_group_l_Loan'                                                          => '부채: 대출',
    'opt_group_cash_account'                                                    => '현금 계정',
    'opt_group_l_Debt'                                                          => '부채: 빚',
    'opt_group_l_Mortgage'                                                      => '부채: 모기지',
    'opt_group_l_Credit card'                                                   => '부채: 신용카드',
    'notes'                                                                     => '노트',
    'view_notes'                                                                => 'View notes',
    'set_budget_limit_notes'                                                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                                                             => 'Edit notes',
    'update_bl_notes'                                                           => 'Update notes',
    'unknown_journal_error'                                                     => '거래를 저장할 수 없습니다. 로그 파일을 확인해 주세요.',
    'attachment_not_found'                                                      => '이 첨부 파일을 찾을 수 없습니다.',
    'journal_link_bill'                                                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                                                   => '<a href="transactions/show/{ID}">거래 #{ID} ("{title}")</a>가 저장되었습니다.',
    'transaction_new_stored_link'                                               => '<a href="transactions/show/{ID}">거래 #{ID}</a>가 저장되었습니다.',
    'transaction_updated_link'                                                  => '<a href="transactions/show/{ID}">거래 #{ID}</a> ("{title}") 이 업데이트 되었습니다.',
    'transaction_updated_no_changes'                                            => '<a href="transactions/show/{ID}">거래 #{ID}</a>("{title}")에 변경 사항이 적용되지 않았습니다.',
    'first_split_decides'                                                       => '첫 번째 분할은 이 항목의 값을 결정합니다.',
    'first_split_overrules_source'                                              => '첫 번째 분할은 소스 계정을 무시할 수 있습니다.',
    'first_split_overrules_destination'                                         => '첫 번째 분할은 대상 계정을 무시할 수 있습니다.',
    'spent_x_of_y'                                                              => '{total} 중 {amount} 지출',

    // new user:
    'welcome'                                                                   => 'Firefly III에 오신 것을 환영합니다!',
    'submit'                                                                    => '제출',
    'submission'                                                                => '제출',
    'submit_yes_really'                                                         => '제출 (내가 무엇을 하는지 알고 있습니다)',
    'getting_started'                                                           => '시작하기',
    'to_get_started'                                                            => 'Firefly III를 성공적으로 설치하셨다니 다행입니다. 이 도구를 시작하려면 은행 이름과 주 당좌 예금 계좌의 잔액을 입력하세요. 여러 개의 계좌가 있어도 걱정하지 마세요. 나중에 추가할 수 있습니다. Firefly III에는 시작할 무언가가 필요합니다.',
    'savings_balance_text'                                                      => 'Firefly III는 자동으로 저축 계좌를 생성합니다. 기본적으로 저축 계좌에는 돈이 없지만, Firefly III에 잔액을 알려주면 잔액이 그대로 저장됩니다.',
    'finish_up_new_user'                                                        => '끝났습니다! <strong>제출</strong>을 눌러 계속할 수 있습니다. Firefly III의 색인으로 이동합니다.',
    'stored_new_accounts_new_user'                                              => '야호! 새 계정이 저장되었습니다.',
    'set_preferred_language'                                                    => '다른 언어로 Firefly III를 사용하시려면 여기에 표시해 주세요.',
    'language'                                                                  => '언어',
    'new_savings_account'                                                       => ':bank_name 저축 계좌',
    'cash_wallet'                                                               => '현금 지갑',
    'currency_not_present'                                                      => '일반적으로 사용하는 통화가 목록에 없더라도 걱정하지 마세요. 옵션 > 통화에서 직접 통화를 생성할 수 있습니다.',

    // home page:
    'transaction_table_description'                                             => '거래가 포함된 테이블',
    'opposing_account'                                                          => '반대 계정',
    'yourAccounts'                                                              => '계정',
    'your_accounts'                                                             => '계정 개요',
    'category_overview'                                                         => '카테고리 개요',
    'expense_overview'                                                          => '지출 계정 개요',
    'revenue_overview'                                                          => '수익 계정 개요',
    'budgetsAndSpending'                                                        => '예산 및 지출',
    'budgets_and_spending'                                                      => '예산 및 지출',
    'go_to_budget'                                                              => '"{budget}" 예산으로 이동',
    'go_to_deposits'                                                            => '입금으로 이동',
    'go_to_expenses'                                                            => '지출로 이동',
    'savings'                                                                   => '예금',
    'newWithdrawal'                                                             => '신규 비용',
    'newDeposit'                                                                => '신규 입금',
    'newTransfer'                                                               => '신규 이체',
    'bills_to_pay'                                                              => 'Subscriptions to pay',
    'per_day'                                                                   => '일별',
    'left_to_spend_per_day'                                                     => '남은 하루 지출',
    'bills_paid'                                                                => 'Subscriptions paid',
    'custom_period'                                                             => '사용자 지정 기간',
    'reset_to_current'                                                          => '현재 기간으로 재설정',
    'select_period'                                                             => '기간 선택',

    // menu and titles, should be recycled as often as possible:
    'currency'                                                                  => '통화',
    'preferences'                                                               => '환경 설정',
    'logout'                                                                    => '로그아웃',
    'logout_other_sessions'                                                     => '다른 모든 세션 로그아웃',
    'toggleNavigation'                                                          => '토글 내비게이션',
    'toggle_dropdown'                                                           => 'Toggle dropdown',
    'searchPlaceholder'                                                         => '검색...',
    'version'                                                                   => '버전',
    'dashboard'                                                                 => '대시보드',
    'income_and_expense'                                                        => '수입과 지출',
    'all_money'                                                                 => '모든 돈',
    'unknown_source_plain'                                                      => '알 수 없는 소스 계정',
    'unknown_dest_plain'                                                        => '알 수 없는 대상 계정',
    'unknown_any_plain'                                                         => '알 수 없는 계정',
    'unknown_budget_plain'                                                      => '예산 없음',
    'available_budget'                                                          => '사용 가능한 예산 ({currency})',
    'currencies'                                                                => '통화',
    'activity'                                                                  => '활동',
    'usage'                                                                     => '사용법',
    'accounts'                                                                  => '계정',
    'Asset account'                                                             => '자산 계정',
    'Default account'                                                           => '자산 계정',
    'Expense account'                                                           => '지출 계정',
    'Revenue account'                                                           => '수익 계정',
    'Initial balance account'                                                   => '초기 잔액 계정',
    'account_type_Asset account'                                                => '자산 계정',
    'account_type_Expense account'                                              => '지출 계정',
    'account_type_Revenue account'                                              => '수익 계정',
    'account_type_Debt'                                                         => '대출',
    'account_type_Loan'                                                         => '빚',
    'account_type_Mortgage'                                                     => '모기지',
    'account_type_debt'                                                         => '대출',
    'account_type_loan'                                                         => '빚',
    'account_type_mortgage'                                                     => '모기지',
    'account_type_Credit card'                                                  => '신용카드',
    'credit_card_type_monthlyFull'                                              => '매월 전액 결제',
    'liability_direction_credit'                                                => '나는 이 대출을 가지고 있다',
    'liability_direction_debit'                                                 => '나는 이 빚을 다른 사람에게 빚지고 있다',
    'liability_direction_credit_short'                                          => '이 빚을 지고 있습니다',
    'liability_direction_debit_short'                                           => '이 빚을 지고 있습니다',
    'liability_direction__short'                                                => '알 수 없음',
    'liability_direction_null_short'                                            => '알 수 없음',
    'Liability credit'                                                          => '부채 신용',
    'budgets'                                                                   => '예산',
    'tags'                                                                      => '태그',
    'reports'                                                                   => '보고서',
    'transactions'                                                              => '거래',
    'expenses'                                                                  => '지출',
    'income'                                                                    => '수익 / 수입',
    'transfers'                                                                 => '이체',
    'moneyManagement'                                                           => '돈 관리',
    'money_management'                                                          => '돈 관리',
    'tools'                                                                     => '도구',
    'piggyBanks'                                                                => '저금통',
    'piggy_banks'                                                               => '저금통',
    'amount_x_of_y'                                                             => '{total} 중 {current}',
    'bills'                                                                     => 'Subscriptions',
    'withdrawal'                                                                => '출금',
    'opening_balance'                                                           => '초기 잔고',
    'deposit'                                                                   => '입금',
    'account'                                                                   => '계정',
    'transfer'                                                                  => '이체',
    'Withdrawal'                                                                => '출금',
    'Deposit'                                                                   => '입금',
    'Transfer'                                                                  => '이체',
    'bill'                                                                      => 'Subscription',
    'yes'                                                                       => '네',
    'no'                                                                        => '아니오',
    'amount'                                                                    => '금액',
    'overview'                                                                  => '개요',
    'saveOnAccount'                                                             => '계정 저장',
    'saveOnAccounts'                                                            => 'Save on account(s)',
    'unknown'                                                                   => '알 수 없음',
    'monthly'                                                                   => '월간',
    'profile'                                                                   => '프로필',
    'errors'                                                                    => '오류',
    'debt_start_date'                                                           => '빚 시작일',
    'debt_start_amount'                                                         => '빚 금액',
    'debt_start_amount_help'                                                    => '이 값은 항상 음수로 설정하는 것이 가장 좋습니다. 자세한 내용은 도움말 페이지(오른쪽 상단(?)-아이콘)를 참조하세요.',
    'interest_period_help'                                                      => '이 항목은 순전히 장식용이며 계산되지 않습니다. 은행은 매우 교활하기 때문에 Firefly III는 결코 제대로 계산하지 못합니다.',
    'store_new_liabilities_account'                                             => '새 부채 저장',
    'edit_liabilities_account'                                                  => '":name" 부채 수정',
    'financial_control'                                                         => '재정 관리',
    'accounting'                                                                => '회계',
    'automation'                                                                => '자동화',
    'others'                                                                    => '기타',
    'classification'                                                            => '분류',
    'store_transaction'                                                         => '거래 저장',



    // reports:
    'report_default'                                                            => ':start와 :end 사이의 기본 재정 보고서',
    'report_audit'                                                              => ':start과 :end 사이의 거래 내역 개요',
    'report_category'                                                           => ':start과 :end 사이의 카테고리 보고서',
    'report_double'                                                             => ':start과 :end 사이의 비용/수익 계정 보고서',
    'report_budget'                                                             => ':start과 :end 사이의 예산 보고서',
    'report_tag'                                                                => ':start과 :end 사이의 태그 보고서',
    'quick_link_reports'                                                        => '빠른 링크',
    'quick_link_examples'                                                       => '다음은 시작하는 데 도움이 되는 몇 가지 예시 링크입니다. 모든 보고서에 대한 정보와 사용할 수 있는 마법의 단어는 (?) 버튼 아래의 도움말 페이지를 확인하십시오.',
    'quick_link_default_report'                                                 => '기본 재무 보고서',
    'quick_link_audit_report'                                                   => '거래 내역 개요',
    'report_this_month_quick'                                                   => '이번 달, 모든 계정',
    'report_last_month_quick'                                                   => '지난 달, 모든 계정',
    'report_this_year_quick'                                                    => '현재 연도, 모든 계정',
    'report_this_fiscal_year_quick'                                             => '현재 회계연도, 모든 계정',
    'report_all_time_quick'                                                     => '모든 시간, 모든 계정',
    'reports_can_bookmark'                                                      => '보고서를 북마크할 수 있다는 점을 기억하세요.',
    'incomeVsExpenses'                                                          => '수입 vs 지출',
    'accountBalances'                                                           => '계정 잔액',
    'balanceStart'                                                              => '기간 시작 시점의 잔액',
    'balanceEnd'                                                                => '기간 종료 시점의 잔액',
    'splitByAccount'                                                            => '계정별로 분할',
    'coveredWithTags'                                                           => '태그로 덮여 있음',
    'leftInBudget'                                                              => '예산에 남음',
    'left_in_debt'                                                              => '납부 금액',
    'sumOfSums'                                                                 => '합계의 합계',
    'noCategory'                                                                => '(카테고리 없음)',
    'notCharged'                                                                => '(아직) 청구되지 않음',
    'inactive'                                                                  => '비활성화',
    'active'                                                                    => '활성화',
    'difference'                                                                => '차이',
    'money_flowing_in'                                                          => '들어옴',
    'money_flowing_out'                                                         => '나감',
    'topX'                                                                      => '상위 :number',
    'show_full_list'                                                            => '전체 목록 표시',
    'show_only_top'                                                             => '상위 :number개만 보기',
    'report_type'                                                               => '보고서 유형',
    'report_type_default'                                                       => '기본 재무 보고서',
    'report_type_audit'                                                         => '거래 내역 개요 (감사)',
    'report_type_category'                                                      => '카테고리 보고서',
    'report_type_budget'                                                        => '예산 보고서',
    'report_type_tag'                                                           => '태그 보고서',
    'report_type_double'                                                        => '비용/수익 계정 보고서',
    'more_info_help'                                                            => '이러한 유형의 보고서에 대한 자세한 내용은 도움말 페이지에서 확인할 수 있습니다. 오른쪽 상단의 (?) 아이콘을 누릅니다.',
    'report_included_accounts'                                                  => '포함된 계정',
    'report_date_range'                                                         => '날짜 범위',
    'report_preset_ranges'                                                      => '사전 설정 범위',
    'shared'                                                                    => '공유',
    'fiscal_year'                                                               => '회계 연도',
    'income_entry'                                                              => ':start와 :end 사이의 ":name" 계정의 수입',
    'expense_entry'                                                             => ':start와 :end 사이의 ":name" 계정의 지출',
    'category_entry'                                                            => ':start과 :end 사이의 ":name" 카테고리의 비용 및 수입',
    'budget_spent_amount'                                                       => ':start와 :end 사이의 ":budget" 예산에 포함된 비용',
    'balance_amount'                                                            => ':start와 :end 사이에 ":account" 계정에서 지불한 ":budget" 예산 내의 지출',
    'no_audit_activity'                                                         => ':start와 :end 사이에 <a href=":url" title=":account_name">:account_name</a> 계정에 기록된 활동이 없습니다.',
    'audit_end_balance'                                                         => ':end 끝에서 <a href=":url" title=":account_name">:account_name</a>의 계정 잔액: :balance',
    'reports_extra_options'                                                     => '추가 옵션',
    'report_has_no_extra_options'                                               => '이 보고서에는 추가 옵션이 없습니다',
    'reports_submit'                                                            => '보고서 보기',
    'end_after_start_date'                                                      => '보고서 종료일은 시작일 이후여야 합니다.',
    'select_category'                                                           => '카테고리 선택',
    'select_budget'                                                             => '예산 선택',
    'select_tag'                                                                => '태그 선택',
    'income_per_category'                                                       => '카테고리별 수입',
    'expense_per_category'                                                      => '카테고리별 지출',
    'expense_per_budget'                                                        => '예산별 지출',
    'income_per_account'                                                        => '계정별 수입',
    'expense_per_account'                                                       => '계정별 지출',
    'expense_per_tag'                                                           => '태그별 지출',
    'income_per_tag'                                                            => '태그별 수입',
    'include_expense_not_in_budget'                                             => '선택한 예산에 포함되지 않은 지출 포함',
    'include_expense_not_in_account'                                            => '선택한 계정에 포함되지 않은 지출 포함',
    'include_expense_not_in_category'                                           => '선택한 카테고리에 포함되지 않은 지출 포함',
    'include_income_not_in_category'                                            => '선택한 카테고리에 포함되지 않은 수입 포함',
    'include_income_not_in_account'                                             => '선택한 계정에 포함되지 않은 수입 포함',
    'include_income_not_in_tags'                                                => '선택한 태그에 포함되지 않은 수입 포함',
    'include_expense_not_in_tags'                                               => '선택한 태그에 포함되지 않은 지출 포함',
    'everything_else'                                                           => '기타 모든 것',
    'income_and_expenses'                                                       => '수입 및 지출',
    'spent_average'                                                             => '지출 (평균)',
    'income_average'                                                            => '수입 (평균)',
    'transaction_count'                                                         => '거래 횟수',
    'average_spending_per_account'                                              => '계정당 평균 지출',
    'average_income_per_account'                                                => '계정당 평균 수입',
    'total'                                                                     => '합계',
    'description'                                                               => '설명',
    'sum_of_period'                                                             => '기간의 합계',
    'average_in_period'                                                         => '기간의 평균',
    'no_account_role'                                                           => '(no role)',
    'account_role_defaultAsset'                                                 => '기본 자산 계정',
    'account_role_sharedAsset'                                                  => '공유 자산 계정',
    'account_role_savingAsset'                                                  => '예금 계좌',
    'account_role_ccAsset'                                                      => '신용카드',
    'account_role_cashWalletAsset'                                              => '현금 지갑',
    'budget_chart_click'                                                        => '차트를 보려면 위 표에서 예산 이름을 클릭하세요.',
    'category_chart_click'                                                      => '차트를 보려면 위 표에서 카테고리 이름을 클릭하세요.',
    'in_out_accounts'                                                           => '조합당 수입 및 지출',
    'in_out_accounts_per_asset'                                                 => '수입 및 지출 (자산 계정당)',
    'in_out_per_category'                                                       => '카테고리당 수입 및 지출',
    'out_per_budget'                                                            => '예산당 지출',
    'select_expense_revenue'                                                    => '비용/수익 계정 선택',
    'multi_currency_report_sum'                                                 => '이 목록에는 여러 통화를 사용하는 계정이 포함되어 있으므로 표시되는 금액이 합리적이지 않을 수 있습니다. 보고서는 항상 기본 통화로 돌아갑니다.',
    'sum_in_default_currency'                                                   => '합계는 항상 기본 통화로 표시됩니다.',
    'net_filtered_prefs'                                                        => '이 차트에는 \'순자산에 포함\' 옵션이 선택되지 않은 계정은 포함되지 않습니다.',



    // charts:
    'chart'                                                                     => '차트',
    'month'                                                                     => '월',
    'budget'                                                                    => '예산',
    'spent'                                                                     => '지출',
    'spent_capped'                                                              => '지출 (한도)',
    'spent_in_budget'                                                           => '예산내 지출',
    'left_to_spend'                                                             => '남은 지출',
    'earned'                                                                    => '수입',
    'overspent'                                                                 => '초과 지출',
    'left'                                                                      => '남음',
    'max-amount'                                                                => '최대 금액',
    'min-amount'                                                                => '최소 금액',
    'journal-amount'                                                            => 'Current subscription entry',
    'name'                                                                      => '이름',
    'expires_at'                                                                => 'Expires at',
    'date'                                                                      => '날짜',
    'date_and_time'                                                             => '날짜와 시간',
    'time'                                                                      => '시간',
    'paid'                                                                      => '지불됨',
    'unpaid'                                                                    => '미지불',
    'day'                                                                       => '일',
    'budgeted'                                                                  => '예산',
    'period'                                                                    => '기간',
    'balance'                                                                   => '잔고',
    'in_out_period'                                                             => '이 기간의 수입 지출',
    'sum'                                                                       => '합계',
    'summary'                                                                   => '요약',
    'average'                                                                   => '평균',
    'balanceFor'                                                                => ':name 잔고',
    'no_tags'                                                                   => '(태그 없음)',
    'nothing_found'                                                             => '(아무 것도 발견되지 않음)',

    // page settings and wizard dialogs

    'page_settings_header'                                                      => 'Page settings',
    'visible_columns'                                                           => 'Visible columns',
    'accounts_to_show'                                                          => 'Accounts to show',
    'active_accounts_only'                                                      => 'Active accounts only',
    'in_active_accounts_only'                                                   => 'Inactive accounts only',
    'show_all_accounts'                                                         => 'Show all accounts',
    'group_accounts'                                                            => 'Group accounts',

    // piggy banks:
    'event_history'                                                             => '이벤트 기록',
    'add_money_to_piggy'                                                        => '":name" 저금통애 금액 추가',
    'piggy_bank'                                                                => '저금통',
    'new_piggy_bank'                                                            => '새 저금통',
    'store_piggy_bank'                                                          => '새 저금통 저장',
    'stored_piggy_bank'                                                         => '새 저금통 ":name" 저장',
    'account_status'                                                            => '계정 상태',
    'left_for_piggy_banks'                                                      => '저금통 잔액',
    'sum_of_piggy_banks'                                                        => '저금통 합계',
    'saved_so_far'                                                              => '지금까지 저장됨',
    'saved_so_far_total'                                                        => 'Saved so far in total',
    'reset_history'                                                             => 'reset history',
    'reset_history_confirm'                                                     => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'                                                       => 'The piggy bank history has been reset',
    'left_to_save'                                                              => '남은 금액',
    'suggested_amount'                                                          => '월별 권장 절약 금액',
    'add_money_to_piggy_title'                                                  => '":name" 저금통애 금액 추가',
    'remove_money_from_piggy_title'                                             => '":name" 저금통에서 금액 제거',
    'add'                                                                       => '추가',
    'no_money_for_piggy'                                                        => '이 돼지 저금통에 넣을 돈이 없습니다.',
    'suggested_savings_per_month'                                               => '월별 제안',

    'remove'                                                                    => '삭제',
    'max_amount_add'                                                            => '추가할 수 있는 최대 금액은',
    'max_amount_remove'                                                         => '제거할 수 있는 최대 금액은',
    'update_piggy_button'                                                       => '저금통 업데이트',
    'update_piggy_title'                                                        => '":name" 저금통 업데이트',
    'updated_piggy_bank'                                                        => '":name" 저금통 업데이트됨',
    'details'                                                                   => '세부 정보',
    'events'                                                                    => '이벤트',
    'target_amount'                                                             => '목표 금액',
    'start_date'                                                                => '시작일',
    'no_start_date'                                                             => '시작일이 지정되지 않음',
    'target_date'                                                               => '목표일',
    'no_target_date'                                                            => '목표일이 지정되지 않음',
    'table'                                                                     => '표',
    'delete_piggy_bank'                                                         => '":name" 저금통 삭제',
    'cannot_add_amount_piggy'                                                   => '":name"에 :amount을 추가할 수 없습니다.',
    'cannot_remove_from_piggy'                                                  => '":name"에 :amount을 제거할 수 없습니다.',
    'deleted_piggy_bank'                                                        => '":name" 저금통 삭제됨',
    'added_amount_to_piggy'                                                     => '":name"에 :amount를 추가함',
    'removed_amount_from_piggy'                                                 => '":name"에서 :amount 제거됨',
    'piggy_events'                                                              => '관련 저금통',

    // tags
    'delete_tag'                                                                => '":tag" 태그 삭제',
    'deleted_tag'                                                               => '":tag" 태그 삭제됨',
    'new_tag'                                                                   => '새 태그 만들기',
    'edit_tag'                                                                  => '":tag" 태그 수정',
    'updated_tag'                                                               => '":tag" 태그 업데이트됨',
    'created_tag'                                                               => '":tag" 태그가 생성되었습니다!',

    'transaction_journal_information'                                           => '거래 정보',
    'transaction_journal_amount'                                                => '금액 정보',
    'transaction_journal_meta'                                                  => '메타 정보',
    'transaction_journal_more'                                                  => '추가 정보',
    'basic_journal_information'                                                 => '기본 거래 정보',
    'transaction_journal_extra'                                                 => '추가 정보',
    'att_part_of_journal'                                                       => '":journal"에 저장됨',
    'total_amount'                                                              => '전체 금액',
    'number_of_decimals'                                                        => '소수 자릿수',



    // administration
    'invite_is_already_redeemed'                                                => '":address"로의 초대는 이미 사용되었습니다.',
    'invite_is_deleted'                                                         => '":address"에 대한 초대가 삭제되었습니다.',
    'invite_new_user_title'                                                     => '새 사용자 초대',
    'invite_new_user_text'                                                      => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                                                         => '이메일 주소',
    'invite_user'                                                               => '사용자 초대',
    'user_is_invited'                                                           => '":address" 이메일 주소가 Firefly III에 초대되었습니다',
    'administration'                                                            => '관리',
    'system_settings'                                                           => '시스템 설정',
    'code_already_used'                                                         => '초대 코드가 사용되었습니다',
    'user_administration'                                                       => '사용자 관리',
    'list_all_users'                                                            => '모든 사용자',
    'all_users'                                                                 => '모든 사용자',
    'instance_configuration'                                                    => '환경 설정',
    'firefly_instance_configuration'                                            => 'Firefly III configuration',
    'setting_single_user_mode'                                                  => '단일 사용자 모드',
    'setting_single_user_mode_explain'                                          => '기본적으로 Firefly III는 사용자 한 명(1)의 등록만 허용합니다. 이는 보안을 위한 조치로, 사용자가 허용하지 않는 한 다른 사람이 인스턴스를 사용할 수 없도록 합니다. 향후 등록은 차단됩니다. 이 확인란을 선택 해제하면 다른 사람도 인스턴스에 연결할 수 있는 경우(인터넷에 연결되어 있는 경우) 인스턴스를 사용할 수 있습니다.',
    'store_configuration'                                                       => '환경설정 저장',
    'single_user_administration'                                                => ':email에 대한 사용자 관리',
    'edit_user'                                                                 => ':email 사용자 수정',
    'hidden_fields_preferences'                                                 => '<a href="preferences">환경설정</a>에서 더 많은 거래 옵션을 활성화할 수 있습니다.',
    'user_data_information'                                                     => '사용자 데이터',
    'user_information'                                                          => '사용자 정보',
    'total_size'                                                                => '총 크기',
    'budget_or_budgets'                                                         => ':count개 예산|:count개 예산',
    'budgets_with_limits'                                                       => '구성된 금액이 있는 :count개 예산|구성된 금액이 있는 :count개 예산',
    'nr_of_rules_in_total_groups'                                               => ':count_groups 규칙 그룹의 :count_rules 규칙',
    'tag_or_tags'                                                               => ':count 태그|:count 태그',
    'configuration_updated'                                                     => '환경설정이 업데이트 되었습니다',
    'setting_is_demo_site'                                                      => '데모 사이트',
    'setting_is_demo_site_explain'                                              => '이 확인란을 선택하면 이 설치가 데모 사이트인 것처럼 작동하므로 이상한 부작용이 발생할 수 있습니다.',
    'block_code_bounced'                                                        => '이메일 메시지가 반송됨',
    'block_code_expired'                                                        => '데모 계정이 만료됨',
    'no_block_code'                                                             => '차단 사유가 없거나 차단되지 않은 사용자',
    'demo_user_export'                                                          => '데모 유저는 데이터를 내보낼 수 없습니다.',
    'block_code_email_changed'                                                  => '사용자가 아직 새 이메일 주소를 확인하지 않았습니다',
    'admin_update_email'                                                        => '프로필 페이지와 달리 이메일 주소가 변경되었다는 알림은 사용자에게 전송되지 않습니다!',
    'update_user'                                                               => '사용자 업데이트',
    'updated_user'                                                              => '사용자 데이터가 변경되었습니다.',
    'delete_user'                                                               => ':email 사용자 삭제',
    'user_deleted'                                                              => '사용자가 삭제되었습니다',
    'send_test_email'                                                           => '테스트 이메일 메시지 보내기',
    'send_test_email_text'                                                      => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                                              => '메시지 보내기',
    'send_test_triggered'                                                       => '테스트가 트리거되었습니다. 받은 편지함과 로그 파일을 확인합니다.',
    'give_admin_careful'                                                        => '관리자 권한을 부여받은 사용자는 내 관리자 권한을 빼앗을 수 있습니다. 조심하세요.',
    'admin_maintanance_title'                                                   => '유지 보수',
    'admin_maintanance_expl'                                                    => 'Firefly III 유지 관리를 위한 몇 개의 멋진 버튼',
    'admin_maintenance_clear_cache'                                             => '캐시 지우기',
    'owner_notifications'                                                       => 'Admin notifications',
    'owner_notifications_expl'                                                  => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                                                          => 'Settings for notification channels',
    'notification_test_failed'                                                  => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                                                => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                                                    => 'Settings for notifications',
    'title_owner_notifications'                                                 => 'Owner notifications',
    'owner_notification_check_user_new_reg'                                     => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'                                    => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'                                      => 'A new version is available',
    'owner_notification_check_invite_created'                                   => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'                                  => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt'                             => 'An unknown user tries to login',
    'all_invited_users'                                                         => '초대된 모든 사용자',
    'save_notification_settings'                                                => '설정 저장',
    'notification_settings'                                                     => 'Settings for notifications',
    'notification_settings_saved'                                               => '알림 설정이 저장되었습니다',
    'available_channels_title'                                                  => 'Available channels',
    'available_channels_expl'                                                   => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'                                           => 'Email',
    'slack_discord_double'                                                      => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'                                           => 'Slack',
    'notification_channel_name_ntfy'                                            => 'Ntfy.sh',
    'notification_channel_name_pushover'                                        => 'Pushover',
    'notification_channel_name_gotify'                                          => 'Gotify',
    'notification_channel_name_pushbullet'                                      => 'Pushbullet',
    'channel_not_available'                                                     => 'not available',
    'configure_channel_in_env'                                                  => 'needs environment variables',
    'test_notification_channel_name_email'                                      => 'Test email',
    'test_notification_channel_name_slack'                                      => 'Test Slack',
    'test_notification_channel_name_ntfy'                                       => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'                                   => 'Test Pushover',
    'test_notification_channel_name_gotify'                                     => 'Test Gotify',
    'test_notification_channel_name_pushbullet'                                 => 'Test Pushbullet',

    'split_transaction_title'                                                   => '분할 거래에 대한 설명',
    'split_transaction_title_help'                                              => '분할 거래를 생성하는 경우 거래의 모든 분할에 대한 전체 설명이 있어야 합니다.',
    'split_title_help'                                                          => '분할 거래를 생성하는 경우 거래의 모든 분할에 대한 전체 설명이 있어야 합니다.',
    'you_create_transfer'                                                       => '전송을 생성하고 있습니다.',
    'you_create_withdrawal'                                                     => '출금을 생성하고 있습니다.',
    'you_create_deposit'                                                        => '입금을 생성하고 있습니다.',

    // links
    'journal_link_configuration'                                                => '거래 링크 구성',
    'create_new_link_type'                                                      => '새 링크 유형 만들기',
    'store_new_link_type'                                                       => '새 링크 유형 저장',
    'update_link_type'                                                          => '링크 유형 업데이트',
    'edit_link_type'                                                            => '":name" 링크 유형 수정',
    'updated_link_type'                                                         => '":name" 링크 유형 업데이트됨',
    'delete_link_type'                                                          => '":name" 링크 유형 삭제',
    'deleted_link_type'                                                         => '":name" 링크 유형 삭제됨',
    'stored_new_link_type'                                                      => '새 링크 유형 ":name" 저장',
    'cannot_edit_link_type'                                                     => '":name" 링크 유형 수정할 수 없음',
    'link_type_help_name'                                                       => '즉. "중복"',
    'link_type_help_inward'                                                     => '즉. "중복"',
    'link_type_help_outward'                                                    => '즉. "에 의해 중복됨"',
    'save_connections_by_moving'                                                => '이러한 거래 간의 링크를 다른 링크 유형으로 이동하여 저장합니다:',
    'do_not_save_connection'                                                    => '(연결 저장하지 않음)',
    'link_transaction'                                                          => '거래 연결',
    'link_to_other_transaction'                                                 => '이 거래를 다른 거래에 연결',
    'select_transaction_to_link'                                                => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                                                          => '이 거래',
    'transaction'                                                               => '거래',
    'comments'                                                                  => '코멘트',
    'link_notes'                                                                => '링크와 함께 저장하고 싶은 모든 노트.',
    'invalid_link_selection'                                                    => '이러한 거래를 연결할 수 없습니다',
    'selected_transaction'                                                      => '선택한 거래',
    'journals_linked'                                                           => '거래가 연결됩니다.',
    'journals_error_linked'                                                     => '이러한 거래는 이미 연결되어 있습니다.',
    'journals_link_to_self'                                                     => '거래를 자기자신에게 연결할 수 없습니다',
    'journal_links'                                                             => '거래 링크',
    'this_withdrawal'                                                           => '이 출금',
    'this_deposit'                                                              => '이 입금',
    'this_transfer'                                                             => '이 이체',
    'overview_for_link'                                                         => '":name" 링크 유형에 대한 개요',
    'source_transaction'                                                        => '소스 거래',
    'link_description'                                                          => '링크 설명',
    'destination_transaction'                                                   => '대상 거래',
    'delete_journal_link'                                                       => '<a href=":source_link">:source</a>와 <a href=":destination_link">:destination</a> 사이의 링크를 삭제합니다',
    'deleted_link'                                                              => '링크 삭제됨',

    // link translations:
    'Paid_name'                                                                 => '지불됨',
    'Refund_name'                                                               => '환불',
    'Reimbursement_name'                                                        => '상환',
    'Related_name'                                                              => '관련',
    'relates to_inward'                                                         => '다음과 관련',
    'is (partially) refunded by_inward'                                         => '에 의해 (부분적으로) 환불됨',
    'is (partially) paid for by_inward'                                         => '에 의해 (부분적으로) 지불됨',
    'is (partially) reimbursed by_inward'                                       => '에 의해 (부분적으로) 환급됨',
    'inward_transaction'                                                        => '내부 거래',
    'outward_transaction'                                                       => '외부 거래',
    'relates to_outward'                                                        => '다음과 관련',
    '(partially) refunds_outward'                                               => '(부분) 환불',
    '(partially) pays for_outward'                                              => '(부분적으로) 지불',
    '(partially) reimburses_outward'                                            => '(부분적으로) 환급',
    'is (partially) refunded by'                                                => '에 의해 (부분적으로) 환불됨',
    'is (partially) paid for by'                                                => '에 의해 (부분적으로) 지불됨',
    'is (partially) reimbursed by'                                              => '에 의해 (부분적으로) 환급됨',
    'relates to'                                                                => '다음과 관련',
    '(partially) refunds'                                                       => '(부분) 환불',
    '(partially) pays for'                                                      => '(부분적으로) 지불',
    '(partially) reimburses'                                                    => '(부분적으로) 환급',

    // split a transaction:
    'splits'                                                                    => '나누기',
    'add_another_split'                                                         => '다른 분할 추가',
    'cannot_edit_opening_balance'                                               => '계정의 개설 잔액은 수정할 수 없습니다.',
    'no_edit_multiple_left'                                                     => '수정할 유효한 거래를 선택하지 않았습니다.',
    'breadcrumb_convert_group'                                                  => '거래 전환',
    'convert_invalid_source'                                                    => '거래 #%d에 대한 소스 정보가 잘못되었습니다.',
    'convert_invalid_destination'                                               => '거래 #%d에 대한 대상 정보가 잘못되었습니다.',
    'create_another'                                                            => '저장후 이 페이지로 돌아와 다른 것을 만듭니다.',
    'after_update_create_another'                                               => '업데이트 후 여기로 돌아와서 수정을 계속합니다.',
    'store_as_new'                                                              => '업데이트하는 대신 새 거래로 저장합니다.',
    'reset_after'                                                               => '제출 후 양식 재설정',
    'errors_submission'                                                         => '제출한 내용에 문제가 있습니다. 아래 오류를 확인해 주세요.',
    'errors_submission_v2'                                                      => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'                                                  => '분할 확장',
    'transaction_remove_split'                                                  => 'Remove split',
    'transaction_collapse_split'                                                => '분할 축소',

    // object groups
    'default_group_title_name'                                                  => '(그룹화 해제)',
    'default_group_title_name_plain'                                            => '그룹 해제됨',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'                                                   => '자산 계정을 만들어 봅시다!',
    'no_accounts_intro_asset'                                                   => '아직 자산 계정이 없습니다. 자산 계정은 당좌 예금 계좌, 저축 계좌, 공유 계좌 또는 신용 카드와 같은 기본 계좌입니다.',
    'no_accounts_imperative_asset'                                              => 'Firefly III를 사용하려면 자산 계정을 하나 이상 만들어야 합니다. 지금 생성해 보겠습니다:',
    'no_accounts_create_asset'                                                  => '자산 계정 만들기',
    'no_accounts_title_expense'                                                 => '지출 계정을 만들어 봅시다!',
    'no_accounts_intro_expense'                                                 => '아직 지출 계정이 없습니다. 지출 계정은 상점이나 슈퍼마켓과 같이 돈을 쓰는 곳입니다.',
    'no_accounts_imperative_expense'                                            => '지출 계정은 거래를 생성할 때 자동으로 생성되지만 원한다면 수동으로도 만들 수 있습니다. 지금 하나 만들어 보겠습니다:',
    'no_accounts_create_expense'                                                => '지출 계정 만들기',
    'no_accounts_title_revenue'                                                 => '수익 계정을 만들어 봅시다!',
    'no_accounts_intro_revenue'                                                 => '아직 수익 계정이 없습니다. 수익 계정은 고용주 등으로부터 돈을 받는 곳입니다.',
    'no_accounts_imperative_revenue'                                            => '수익 계정은 거래를 생성할 때 자동으로 생성되지만 원한다면 수동으로도 만들 수 있습니다. 지금 하나 만들어 보겠습니다:',
    'no_accounts_create_revenue'                                                => '수익 계정 만들기',
    'no_accounts_title_liabilities'                                             => '부채를 만들어 봅시다!',
    'no_accounts_intro_liabilities'                                             => '아직 부채가 없습니다. 부채는 (학자금) 대출 및 기타 부채를 등록하는 계정입니다.',
    'no_accounts_imperative_liabilities'                                        => '이 기능을 반드시 사용할 필요는 없지만, 이러한 사항을 추적하고 싶을 때 유용하게 사용할 수 있습니다.',
    'no_accounts_create_liabilities'                                            => '부채 만들기',
    'no_budgets_title_default'                                                  => '예산을 만들어 봅시다',
    'no_rules_title_default'                                                    => '규칙을 만들어 봅시다',
    'no_budgets_intro_default'                                                  => '예산이 아직 없습니다. 예산은 소프트캡을 설정하여 지출을 제한할 수 있도록, 지출을 논리적인 그룹으로 정리하는 데 사용됩니다.',
    'no_rules_intro_default'                                                    => '아직 규칙이 없습니다. 규칙은 거래를 처리할 수 있는 강력한 자동화 기능입니다.',
    'no_rules_imperative_default'                                               => '규칙은 거래를 관리할 때 매우 유용할 수 있습니다. 지금 규칙을 만들어 보겠습니다:',
    'no_budgets_imperative_default'                                             => '예산은 재무 관리의 기본 도구입니다. 지금 만들어봅시다:',
    'no_budgets_create_default'                                                 => '예산 만들기',
    'no_rules_create_default'                                                   => '규칙 만들기',
    'no_categories_title_default'                                               => '카테고리를 만들어 봅시다!',
    'no_categories_intro_default'                                               => '아직 카테고리가 없습니다. 카테고리는 거래를 미세 조정하고 지정된 카테고리로 레이블을 지정하는 데 사용됩니다.',
    'no_categories_imperative_default'                                          => '카테고리는 거래를 생성할 때 자동으로 생성되지만 수동으로도 만들 수 있습니다. 지금 하나 만들어 보겠습니다:',
    'no_categories_create_default'                                              => '카테고리 만들기',
    'no_tags_title_default'                                                     => '태그를 만들어 봅시다!',
    'no_tags_intro_default'                                                     => '태그가 아직 없습니다. 태그는 거래를 미세 조정하고 특정 키워드로 레이블을 지정하는데 사용됩니다.',
    'no_tags_imperative_default'                                                => '태그는 거래를 생성할 때 자동으로 생성되지만 수동으로도 만들 수 있습니다. 지금 하나 만들어 보겠습니다:',
    'no_tags_create_default'                                                    => '태그 생성',
    'no_transactions_title_withdrawal'                                          => '지출을 만들어 봅시다!',
    'no_transactions_intro_withdrawal'                                          => '아직 지출이 없습니다. 재정 관리를 시작하려면 지출을 만들어야 합니다.',
    'no_transactions_imperative_withdrawal'                                     => '돈을 좀 사용하셨나요? 그렇다면 적어 두어야 합니다:',
    'no_transactions_create_withdrawal'                                         => '지출 만들기',
    'no_transactions_title_deposit'                                             => '수입을 만들어 봅시다!',
    'no_transactions_intro_deposit'                                             => '아직 기록된 수입이 없습니다. 재정 관리를 시작하려면 수입 항목을 만들어야 합니다.',
    'no_transactions_imperative_deposit'                                        => '돈을 받았나요? 그렇다면 적어 두어야 합니다:',
    'no_transactions_create_deposit'                                            => '입금 만들기',
    'no_transactions_title_transfers'                                           => '이체를 만들어 봅시다!',
    'no_transactions_intro_transfers'                                           => '아직 이체가 없습니다. 자산 계정 간에 돈을 이동하면 이체로 기록됩니다.',
    'no_transactions_imperative_transfers'                                      => '돈을 이리저리 옮기셨나요? 그렇다면 적어 두어야 합니다:',
    'no_transactions_create_transfers'                                          => '이체 만들기',
    'no_piggies_title_default'                                                  => '저금통을 만들어 봅시다!',
    'no_piggies_intro_default'                                                  => '저금통이 아직 없습니다. 저금통을 만들어 저축을 나누고 무엇을 위해 저축하는지 추적할 수 있습니다.',
    'no_piggies_imperative_default'                                             => '저축하고 있는 항목이 있나요? 저금통을 만들어 추적하세요:',
    'no_piggies_create_default'                                                 => '새 저금통 만들기',
    'no_bills_title_default'                                                    => 'Let\'s create a subscription!',
    'no_bills_intro_default'                                                    => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'                                               => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'                                                   => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                                                      => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                                                          => '지금 바로 만들기',
    'no_new_transaction_in_recurrence'                                          => '새 거래가 생성되지 않았습니다. 이 날짜에 이미 해지된 것일까요?',
    'recurrences'                                                               => '반복 거래',
    'repeat_until_in_past'                                                      => '이 반복 거래는 :date에 반복이 중지되었습니다.',
    'recurring_calendar_view'                                                   => '달력',
    'no_recurring_title_default'                                                => '반복 거래를 만들어 봅시다!',
    'no_recurring_intro_default'                                                => '아직 반복 거래가 없습니다. 이를 사용하여 Firefly III가 자동으로 거래를 생성하도록 할 수 있습니다.',
    'no_recurring_imperative_default'                                           => '이 기능은 꽤 고급 기능이지만 매우 유용할 수 있습니다. 계속하기 전에 오른쪽 상단에 있는 문서((?) 아이콘)를 읽어보시기 바랍니다.',
    'no_recurring_create_default'                                               => '반복 거래 만들기',
    'make_new_recurring'                                                        => '반복 거래 만들기',
    'recurring_daily'                                                           => '매일',
    'recurring_weekly'                                                          => '매주 :weekday',
    'recurring_weekly_skip'                                                     => '매 :skip(st/nd/rd/th) 주 :weekday',
    'recurring_monthly'                                                         => '매월 :dayOfMonth(st/nd/rd/th) 일',
    'recurring_monthly_skip'                                                    => ':skip(st/nd/rd/th) 월마다 :dayOfMonth(st/nd/rd/th) 일에',
    'recurring_ndom'                                                            => '매월 :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                                                          => '매년 :date에',
    'overview_for_recurrence'                                                   => '":title" 반복 거래 개요',
    'warning_duplicates_repetitions'                                            => '드물지만 이 목록에 날짜가 두 번 표시되는 경우가 있습니다. 이는 여러 반복이 충돌할 때 발생할 수 있습니다. Firefly III는 항상 하루에 하나의 트랜잭션을 생성합니다.',
    'created_transactions'                                                      => '관련 거래',
    'expected_withdrawals'                                                      => '예상 출금액',
    'expected_deposits'                                                         => '예상 입금',
    'expected_transfers'                                                        => '예상 이체',
    'created_withdrawals'                                                       => '출금 생성',
    'created_deposits'                                                          => '입금 생성',
    'created_transfers'                                                         => '이체 생성',
    'recurring_info'                                                            => '반복 거래 :count / :total',
    'created_from_recurrence'                                                   => '":title" (#:id) 반복 거래에서 생성됨',
    'recurring_never_cron'                                                      => '반복 거래를 지원하는 데 필요한 cron 작업이 실행된 적이 없는 것 같습니다. 물론 Firefly III를 방금 설치한 경우라면 정상적인 현상이지만, 가능한 한 빨리 설정해야 합니다. 페이지 오른쪽 상단의 (?) 아이콘을 사용하여 도움말 페이지를 확인하시기 바랍니다.',
    'recurring_cron_long_ago'                                                   => '반복 거래를 지원하는 cron 작업이 마지막으로 실행된 후 36시간이 넘은 것 같습니다. 올바르게 설정된 것이 맞나요? 페이지 오른쪽 상단의 (?) 아이콘을 사용하여 도움말 페이지를 확인하세요.',

    'create_new_recurrence'                                                     => '새 반복 거래 만들기',
    'help_first_date'                                                           => '첫 번째 예상 반복을 나타냅니다. 이것은 미래에 이루어져야 합니다.',
    'help_first_date_no_past'                                                   => '첫 번째 예상 반복을 나타냅니다. Firefly III는 과거의 거래를 생성하지 않습니다.',
    'no_currency'                                                               => '(통화 없음)',
    'mandatory_for_recurring'                                                   => '필수 반복 정보',
    'mandatory_for_transaction'                                                 => '필수 거래 정보',
    'optional_for_recurring'                                                    => '선택적 반복 정보',
    'optional_for_transaction'                                                  => '선택적 거래 정보',
    'change_date_other_options'                                                 => '더 많은 옵션을 보려면 "첫 번째 날짜"를 변경하세요.',
    'mandatory_fields_for_tranaction'                                           => '여기의 값은 생성되는 거래에 최종적으로 반영됩니다',
    'click_for_calendar'                                                        => '거래가 반복되는 시기를 보여주는 달력을 보려면 여기를 클릭하세요.',
    'repeat_forever'                                                            => '영원히 반복',
    'repeat_until_date'                                                         => '날짜까지 반복',
    'repeat_times'                                                              => '여러 번 반복',
    'recurring_skips_one'                                                       => '다른 모든',
    'recurring_skips_more'                                                      => '건너뛰기 :count 발생',
    'store_new_recurrence'                                                      => '반복 거래 저장',
    'stored_new_recurrence'                                                     => '":title" 반복 거래가 성공적으로 저장되었습니다.',
    'edit_recurrence'                                                           => '":title" 반복 거래 수정',
    'recurring_repeats_until'                                                   => ':date 까지 반복',
    'recurring_repeats_forever'                                                 => '영원히 반복',
    'recurring_repeats_x_times'                                                 => ':count 회 반복|:count 회 반복',
    'update_recurrence'                                                         => '반복 거래 업데이트',
    'updated_recurrence'                                                        => '":title" 반복 거래 업데이트됨',
    'recurrence_is_inactive'                                                    => '이 반복 거래는 활성화되어 있지 않으며 새 거래를 생성하지 않습니다.',
    'delete_recurring'                                                          => '":title" 반복 거래 삭제',
    'new_recurring_transaction'                                                 => '새 반복 거래',
    'help_weekend'                                                              => '반복 거래가 토요일이나 일요일에 해당하는 경우 Firefly III는 어떻게 해야 하나요?',
    'do_nothing'                                                                => '그냥 트랜잭션을 생성',
    'skip_transaction'                                                          => '발생 건너뛰기',
    'jump_to_friday'                                                            => '대신 이전 금요일에 거래를 생성합니다',
    'jump_to_monday'                                                            => '대신 다음 월요일에 거래를 생성합니다',
    'will_jump_friday'                                                          => '주말이 아닌 금요일에 생성됩니다.',
    'will_jump_monday'                                                          => '주말이 아닌 월요일에 생성됩니다.',
    'except_weekends'                                                           => '주말 제외',
    'recurrence_deleted'                                                        => '반복 거래 ":title" 삭제됨',



    // new lines for summary controller.
    'box_balance_in_currency'                                                   => '잔고 (:currency)',
    'box_spent_in_currency'                                                     => '지출 (:currency)',
    'box_earned_in_currency'                                                    => '수입 (:currency)',
    'box_budgeted_in_currency'                                                  => '예산 (:currency)',
    'box_bill_paid_in_currency'                                                 => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'                                               => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'                                             => '남은 지출 (:currency)',
    'box_net_worth_in_currency'                                                 => '순자산 (:currency)',
    'box_spend_per_day'                                                         => '하루 남은 지출: :amount',

    // debug page
    'debug_page'                                                                => '디버그 페이지',
    'debug_submit_instructions'                                                 => '문제가 발생하면 이 상자의 정보를 디버그 정보로 사용할 수 있습니다. 이 정보를 복사하여 신규 또는 기존 <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub 이슈</a>에 붙여넣으세요. 문제를 빠르게 진단하는 데 사용할 수 있는 멋진 표가 생성됩니다.',
    'debug_pretty_table'                                                        => '아래 상자를 GitHub 이슈에 복사/붙여넣으면 표가 생성됩니다. 이 텍스트를 백틱(`)이나 따옴표(\')로 둘러싸지 마세요.',
    'debug_additional_data'                                                     => '아래 상자의 내용을 공유할 수도 있습니다. 이 내용을 복사하여 신규 또는 기존 <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub 이슈</a>에 붙여넣을 수도 있습니다. 단, 이 상자의 내용에는 계정 이름, 거래 세부 정보 또는 이메일 주소와 같은 개인 정보가 포함될 수 있습니다.',

    // object groups
    'object_groups_menu_bar'                                                    => '그룹',
    'object_groups_page_title'                                                  => '그룹',
    'object_groups_breadcrumb'                                                  => '그룹',
    'object_groups_index'                                                       => '개요',
    'object_groups'                                                             => '그룹',
    'object_groups_empty_explain'                                               => 'Firefly III의 일부 항목은 그룹으로 나눌 수 있습니다. 예를 들어 저금통은 편집 및 생성 화면에 "그룹" 항목이 있습니다. 이 항목을 설정하면 이 페이지에서 그룹의 이름과 순서를 편집할 수 있습니다. 자세한 내용은 오른쪽 상단 모서리의 (?) 아이콘 아래에 있는 도움말 페이지를 확인하세요.',
    'object_group_title'                                                        => '제목',
    'edit_object_group'                                                         => '그룹 ":title" 수정',
    'delete_object_group'                                                       => '그룹 ":title" 삭제',
    'update_object_group'                                                       => '그룹 업데이트',
    'updated_object_group'                                                      => '그룹 ":title" 업데이트 성공',
    'deleted_object_group'                                                      => '그룹 ":title" 삭제 성공',
    'object_group'                                                              => '그룹',

    // other stuff
    'placeholder'                                                               => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                                                         => '감사 로그 항목',
    'ale_action_log_add'                                                        => '":name" 저금통에 :amount 추가',
    'ale_action_log_remove'                                                     => '":name" 저금통에서 :amount 제거',
    'ale_action_clear_budget'                                                   => '예산에서 제거됨',
    'ale_action_update_group_title'                                             => '분할거래 설명 변경',
    'ale_action_update_date'                                                    => '거래 날짜 변경',
    'ale_action_update_order'                                                   => '거래 순서 변경',
    'ale_action_clear_category'                                                 => '카테고리에서 제거됨',
    'ale_action_clear_notes'                                                    => '제거된 노트',
    'ale_action_clear_tag'                                                      => '삭제된 태그',
    'ale_action_clear_all_tags'                                                 => '모든 태그 지우기',
    'ale_action_set_bill'                                                       => 'Linked to subscription',
    'ale_action_switch_accounts'                                                => '소스와 대상 계정 전환',
    'ale_action_set_budget'                                                     => '예산 설정',
    'ale_action_set_category'                                                   => '카테고리 설정',
    'ale_action_set_source'                                                     => '소스 계정 설정',
    'ale_action_set_destination'                                                => '대상 계정 설정',
    'ale_action_update_transaction_type'                                        => '변경된 거래 유형',
    'ale_action_update_notes'                                                   => '변경된 노트',
    'ale_action_update_description'                                             => '변경된 설명',
    'ale_action_add_to_piggy'                                                   => '저금통',
    'ale_action_remove_from_piggy'                                              => '저금통',
    'ale_action_add_tag'                                                        => '태그 추가',
    'ale_action_update_amount'                                                  => 'Updated amount',

    // dashboard
    'enable_auto_convert'                                                       => '통화 변환 활성화',
    'disable_auto_convert'                                                      => '통화 변환 비활성화',
];
