<?php

/**
 * email.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // common items
    'greeting'                                    => 'Ahoj,',
    'closing'                                     => 'Píp píp,',
    'signature'                                   => 'Firefly III E-mail Robot',
    'footer_ps'                                   => 'PS: Táto správa bola odoslaná na základe požiadavky z IP :ipAddress.',

    // admin test
    'admin_test_subject'                          => 'Testovacia správa z vašej inštalácie Firefly III',
    'admin_test_body'                             => 'Toto je testovacia správa z vašej inštancie Firefly III. Bola odoslaná na :email.',
    'admin_test_message'                          => 'This is a test message from your Firefly III instance over channel ":channel".',



    // invite
    'invitation_created_subject'                  => 'An invitation has been created',
    'invitation_created_body'                     => 'Admin user ":email" created a user invitation which can be used by whoever is behind email address ":invitee". The invite will be valid for 48hrs.',
    'invite_user_subject'                         => 'You\'ve been invited to create a Firefly III account.',
    'invitation_introduction'                     => 'You\'ve been invited to create a Firefly III account on **:host**. Firefly III  is a personal, self-hosted, private personal finance manager. All the cool kids are using it.',
    'invitation_invited_by'                       => 'You\'ve been invited by ":admin" and this invitation was sent to ":invitee". That\'s you, right?',
    'invitation_url'                              => 'The invitation is valid for 48 hours and can be redeemed by surfing to [Firefly III](:url). Enjoy!',

    // new IP
    'login_from_new_ip'                           => 'Nové prihlásenie do Firefly III',
    'slack_login_from_new_ip'                     => 'New Firefly III login from IP :ip (:host)',
    'new_ip_body'                                 => 'Firefly III zachytil nové prihlásenie do Vášho účtu z neznámej IP adresy. Ak ste sa tejto adresy nikdy neprihlásili, alebo to bolo pred viac, než 6 mesiacmi, Firefly III Vás na to upozorní.',
    'new_ip_warning'                              => 'Ak túto poznáte túto IP adresu alebo prihlásenie, ignorujte túto správu. Ak ste sa neprihlásili, alebo netušíte, o čo ide, overte si bezpečnosť Vášho hesla, zmeňte ho, a odhláste sa zo všetkých sedení. Môžete tak spraviť na stránke svojho profilu. Máte už zapnuté 2FA overenie, však? Buďte v bezpečí!',
    'ip_address'                                  => 'IP adresa',
    'host_name'                                   => 'Hostiteľ',
    'date_time'                                   => 'Dátum a čas',
    'user_agent'                                  => 'Browser',

    // access token created
    'access_token_created_subject'                => 'Token prístupu bol vytvorený',
    'access_token_created_body'                   => 'Niekto (dúfajme že vy) vytvoril pre váš účet nový prístupový token pre Firefly III API.',
    'access_token_created_explanation'            => 'With this token, they can access **all** of your financial records through the Firefly III API.',
    'access_token_created_revoke'                 => 'If this wasn\'t you, please revoke this token as soon as possible at :url',

    // unknown user login attempt
    'unknown_user_subject'                        => 'An unknown user tried to log in',
    'unknown_user_body'                           => 'An unknown user (:ip) tried to log in to Firefly III. The email address they used was ":address".',
    'unknown_user_message'                        => 'The email address they (:ip) used was ":address".',

    // known user login attempt
    'failed_login_subject'                        => 'Firefly III detected a failed login attempt',
    'failed_login_body'                           => 'Firefly III detected that somebody (you?) failed to login with your account ":email". Please verify that this was you.',
    'failed_login_message'                        => 'A failed login attempt (:ip) on your Firefly III account ":email" was detected.',
    'failed_login_warning'                        => 'If you recognize this IP address or the login attempt, you can ignore this message. If you didn\'t try to login, of if you have no idea what this is about, verify your password security, change it, and log out all other sessions. To do this, go to your profile page. Of course you have 2FA enabled already, right? Stay safe!',

    // registered
    'registered_subject'                          => 'Vitajte vo Firefly III!',
    'registered_subject_admin'                    => 'A new user has registered',
    'admin_new_user_registered'                   => 'A new user has registered. User **:email** was given user ID #:id.',
    'registered_welcome'                          => 'Welcome to [Firefly III](:address). Your registration has made it, and this email is here to confirm it. Yay!',
    'registered_pw'                               => 'If you have forgotten your password already, please reset it using [the password reset tool](:address/password/reset).',
    'registered_help'                             => 'V pravom hornom rohu každej stánky je ikonka pomocníka. Ak potrebujete pomoc, kliknite na ňu!',
    'registered_closing'                          => 'Užite si to!',
    'registered_firefly_iii_link'                 => 'Firefly III:',
    'registered_pw_reset_link'                    => 'Obnova hesla:',
    'registered_doc_link'                         => 'Dokumentácia:',



    // new version
    'new_version_email_subject'                   => 'A new Firefly III version is available',

    // email change
    'email_change_subject'                        => 'Vaša e-mailová adresa Firefly III bola zmenená',
    'email_change_body_to_new'                    => 'Vy, alebo niekto s prístupom k vášmu účtu Firefly III zmenil vašu e-mailovú adresu. Ak ste túto správu nečakali, môžete ju ignorovať a zmazať.',
    'email_change_body_to_old'                    => 'You or somebody with access to your Firefly III account has changed your email address. If you did not expect this to happen, you **must** follow the "undo"-link below to protect your account!',
    'email_change_ignore'                         => 'Ak o tejto zmene viete, môžete túto správu pokojne ignorovať.',
    'email_change_old'                            => 'Pôvodná e-mailová adresa bola :email',
    'email_change_old_strong'                     => 'Pôvodná e-mailová adresa bola **:email**',
    'email_change_new'                            => 'Nová e-mailová adresa je: :email',
    'email_change_new_strong'                     => 'The new email address is: **:email**',
    'email_change_instructions'                   => 'Kým túto zmenu nepotvrdíte, nemôžete používať svoj Firefly III účet. Pokračujte kliknutím na linku nižšie.',
    'email_change_undo_link'                      => 'Zmenu vrátite späť kliknutím na túto linku:',

    // OAuth token created
    'oauth_created_subject'                       => 'Bol vytvorený nový OAuth klient',
    'oauth_created_body'                          => 'Niekto (dúfajme, že vy) vytvoril pre váš účet nového OAuth klienta pre Firefly III API. Bol nazvaný ":name" a má spätnú URL `:url`.',
    'oauth_created_explanation'                   => 'S týmto klientom je možné cez Firefly III API pristupovať ku **všetkým** vašim finančným záznamom.',
    'oauth_created_undo'                          => 'Ak ste to neboli vy, čo najskôr tohto klienta zneplatnite na `:url`',

    // reset password
    'reset_pw_subject'                            => 'Žiadosť o zmenu hesla',
    'reset_pw_message'                            => 'You have received password reset instructions in your email. If this was you, please follow the instructions.',
    'reset_pw_instructions'                       => 'Niekto sa pokúsil obnoviť vaše heslo. Ak ste to boli vy, pokračujte kliknutím na linku nižšie.',
    'reset_pw_warning'                            => '**PLEASE** verify that the link actually goes to the Firefly III you expect it to go!',

    // error
    'error_subject'                               => 'Zachytená chyba vo Firefly III',
    'error_intro'                                 => 'Firefly III v:version narazil na chybu: <span style="font-family: monospace;">:errorMessage</span>.',
    'error_type'                                  => 'Trieda chyby ":class".',
    'error_timestamp'                             => 'Chyba nastala: :time.',
    'error_location'                              => 'Chyba nastala v súbore "<span style="font-family: monospace;">:file</span>" na riadku :line s kódom :code.',
    'error_user'                                  => 'Chyba sa zobrazila používateľovi #:id, <a href="mailto::email">:email</a>.',
    'error_no_user'                               => 'Pri vyskytnutí chyby nebol prihlásený žiadny používateľ alebo žiadny nebol zistený.',
    'error_ip'                                    => 'IP adresa súvisiaca s touto chybou: :ip',
    'error_url'                                   => 'URL je: :url',
    'error_user_agent'                            => 'User agent: :userAgent',
    'error_stacktrace'                            => 'The full stacktrace is below. If you think this is a bug in Firefly III, you can forward this message to <a href="mailto:james@firefly-iii.org?subject=I%20found%20a%20bug!">james@firefly-iii.org</a>. This can help fix the bug you just encountered.',
    'error_github_html'                           => 'Prípadne môžete vytvoriť hlásenie na <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub</a>.',
    'error_github_text'                           => 'Prípadne môžete vytvoriť hlásenie na https://github.com/firefly-iii/firefly-iii/issues.',
    'error_stacktrace_below'                      => 'Celý zásobník je nižšie:',
    'error_headers'                               => 'The following headers may also be relevant:',
    'error_post'                                  => 'This was submitted by the user:',



    // report new journals
    'new_journals_subject'                        => 'Firefly III vytvoril novú transakciu|Firefly III :count nových transakcií',
    'new_journals_header'                         => 'Firefly III pre vás vytvoril transakciu. Nájdete ju vo svojej inštalácii Firefly III:|Firefly III pre vás vytvoríl :count transakcií. Nájdete ich vo svojej inštalácii Firefly III:',

    // bill warning
    'bill_warning_subject_end_date'               => 'Your subscription ":name" is due to end in :diff days',
    'bill_warning_subject_now_end_date'           => 'Your subscription ":name" is due to end TODAY',
    'bill_warning_subject_extension_date'         => 'Your subscription ":name" is due to be extended or cancelled in :diff days',
    'bill_warning_subject_now_extension_date'     => 'Your subscription ":name" is due to be extended or cancelled TODAY',
    'bill_warning_end_date'                       => 'Your subscription **":name"** is due to end on :date. This moment will pass in about **:diff days**.',
    'bill_warning_extension_date'                 => 'Your subscription **":name"** is due to be extended or cancelled on :date. This moment will pass in about **:diff days**.',
    'bill_warning_end_date_zero'                  => 'Your subscription **":name"** is due to end on :date. This moment will pass **TODAY!**',
    'bill_warning_extension_date_zero'            => 'Your subscription **":name"** is due to be extended or cancelled on :date. This moment will pass **TODAY!**',
    'bill_warning_please_action'                  => 'Please take the appropriate action.',

    // user has enabled MFA
    'enabled_mfa_subject'                         => 'You have enabled multi-factor authentication',
    'enabled_mfa_slack'                           => 'You (:email) have enabled multi-factor authentication. Is this not correct? Check your settings!',
    'have_enabled_mfa'                            => 'You have enabled multi-factor authentication on your Firefly III account ":email". This means that you will need to use an authenticator app to log in from now on.',
    'enabled_mfa_warning'                         => 'If you did not enable this, please contact your administrator immediately or check out the Firefly III documentation.',

    'disabled_mfa_subject'                        => 'You have disabled multi-factor authentication!',
    'disabled_mfa_slack'                          => 'You (:email) have disabled multi-factor authentication. Is this not correct? Check your settings!',
    'have_disabled_mfa'                           => 'You have disabled multi-factor authentication on your Firefly III account ":email".',
    'disabled_mfa_warning'                        => 'If you did not disable this, please contact your administrator immediately or check out the Firefly III documentation.',

    'new_backup_codes_subject'                    => 'You have generated new back-up codes',
    'new_backup_codes_slack'                      => 'You (:email) have generated new back-up codes. These can be used to login to Firefly III. Is this not correct? Check your settings!',
    'new_backup_codes_intro'                      => 'You (:email) have generated new back-up codes. These can be used to login to Firefly III if you lose access to your authenticator app.',
    'new_backup_codes_warning'                    => 'Please store these codes in a safe place. If you lose them, you will not be able to log in to Firefly III. If you did not do this, please contact your administrator immediately or check out the Firefly III documentation.',

    'used_backup_code_subject'                    => 'You have used a back-up code to login',
    'used_backup_code_slack'                      => 'You (:email) have used a back-up code to login',

    'used_backup_code_intro'                      => 'You (:email) have used a back-up code to login to Firefly III. You now have one less back-up code to login with. Please remove it from your list.',
    'used_backup_code_warning'                    => 'If you did not do this, please contact your administrator immediately or check out the Firefly III documentation.',

    // few left:
    'mfa_few_backups_left_subject'                => 'You have only :count backup code(s) left!',
    'mfa_few_backups_left_slack'                  => 'You (:email) have only :count backup code(s) left!',
    'few_backup_codes_intro'                      => 'You (:email) have used most of your backup codes, and now have only :count left. Please generate new ones as soon as possible.',
    'few_backup_codes_warning'                    => 'Without backup codes, you cannot recover your MFA login if you lose access to your code generator.',

    // NO left:
    'mfa_no_backups_left_subject'                 => 'You have NO backup codes left!',
    'mfa_no_backups_left_slack'                   => 'You (:email) NO backup codes left!',
    'no_backup_codes_intro'                       => 'You (:email) have used ALL of your backup codes. Please generate new ones as soon as possible.',
    'no_backup_codes_warning'                     => 'Without backup codes, you cannot recover your MFA login if you lose access to your code generator.',

    // many failed MFA attempts
    'mfa_many_failed_subject'                     => 'You have tried and failed to use multi-factor authentication :count times now!',
    'mfa_many_failed_slack'                       => 'You (:email) have tried and failed to use multi-factor authentication :count times now. Is this not correct? Check your settings!',
    'mfa_many_failed_attempts_intro'              => 'You (:email) have tried :count times to use a multi-factor authentication code, but these login attempts have failed. Are you sure you are using the right MFA code? Are you sure the time on the server is correct?',
    'mfa_many_failed_attempts_warning'            => 'If you did not do this, please contact your administrator immediately or check out the Firefly III documentation.',

];
