<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);



return [
    // general stuff:
    'stored_in_tz'                                                              => 'stored in ":timezone"',
    'displayed_in_tz'                                                           => 'displayed in ":timezone"',
    'close'                                                                     => 'Đóng',
    'actions'                                                                   => 'Hành động',
    'edit'                                                                      => 'Sửa',
    'transaction_journal_id'                                                    => 'Transaction journal ID',
    'delete'                                                                    => 'Xóa',
    'split'                                                                     => 'Chia ra',
    'single_split'                                                              => 'Chia ra',
    'clone'                                                                     => 'Nhân ra',
    'clone_and_edit'                                                            => 'Nhân bản và sửa',
    'confirm_action'                                                            => 'Xác nhận thao tác',
    'last_seven_days'                                                           => 'Bảy ngày gần đây',
    'last_thirty_days'                                                          => 'Ba mươi ngày gần đây',
    'last_180_days'                                                             => '180 ngày qua',
    'month_to_date'                                                             => 'Tháng đến ngày',
    'year_to_date'                                                              => 'Năm đến ngày',
    'YTD'                                                                       => 'NĐN',
    'welcome_back'                                                              => 'Chào mừng trở lại?',
    'main_dashboard_page_title'                                                 => 'Trang chủ',
    'everything'                                                                => 'Tất cả mọi thứ',
    'today'                                                                     => 'hôm nay',
    'customRange'                                                               => 'Chọn trong khoảng',
    'date_range'                                                                => 'Khoảng thời gian',
    'apply'                                                                     => 'Áp dụng',
    'select_date'                                                               => 'Chọn ngày..',
    'cancel'                                                                    => 'Hủy',
    'from'                                                                      => 'Từ',
    'to'                                                                        => 'Đến',
    'structure'                                                                 => 'Kết cấu',
    'help_translating'                                                          => 'Văn bản trợ giúp này hiện chưa hỗ trợ ngôn ngữ của bạn. <a href="https://crowdin.com/project/firefly-iii-help"> Bạn sẽ dịch giúp chứ?</a>',
    'showEverything'                                                            => 'Hiện mọi thứ',
    'never'                                                                     => 'Không bao giờ',
    'no_results_for_empty_search'                                               => 'Không tìm gặp thứ bạn cần tìm.',
    'removed_amount'                                                            => 'Đã xóa :amount',
    'added_amount'                                                              => 'Đã thêm :amount',
    'asset_account_role_help'                                                   => 'Bất kỳ tùy chọn bổ sung nào do bạn chọn có thể được đặt sau.',
    'Opening balance'                                                           => 'Số dư đầu kỳ',
    'create_new_stuff'                                                          => 'Tạo công cụ mới',
    'new_withdrawal'                                                            => 'Rút tiền mới',
    'create_new_transaction'                                                    => 'Tạo giao dịch mới',
    'sidebar_frontpage_create'                                                  => 'Tạo',
    'new_transaction'                                                           => 'Giao dịch mới',
    'no_rules_for_bill'                                                         => 'Gói đăng ký này không có gán quy tắc nào.',
    'go_to_asset_accounts'                                                      => 'Xem tài khoản của bạn',
    'go_to_budgets'                                                             => 'Chuyển đến ngân sách của bạn',
    'go_to_withdrawals'                                                         => 'Chuyển đến mục rút tiền của bạn',
    'clones_journal_x'                                                          => 'Giao dịch này là một bản sao của ":description" (#:id)',
    'go_to_categories'                                                          => 'Đi đến danh mục của bạn',
    'go_to_bills'                                                               => 'Đi tới gói đăng ký của bạn',
    'go_to_expense_accounts'                                                    => 'Xem tài khoản chi phí của bạn',
    'go_to_revenue_accounts'                                                    => 'Xem tài khoản doanh thu của bạn',
    'go_to_piggies'                                                             => 'Tới heo đất của bạn',
    'new_deposit'                                                               => 'Tiền gửi mới',
    'new_transfer'                                                              => 'Chuyển khoản mới',
    'new_transfers'                                                             => 'Chuyển khoản mới',
    'new_asset_account'                                                         => 'tài khoản mới',
    'new_expense_account'                                                       => 'Tài khoản chi phí mới',
    'new_revenue_account'                                                       => 'Tài khoản doanh thu mới',
    'new_liabilities_account'                                                   => 'Nợ mới',
    'new_budget'                                                                => 'Ngân sách mới',
    'new_bill'                                                                  => 'Gói đăng ký mới',
    'block_account_logout'                                                      => 'Bạn đã đăng xuất. Tài khoản bị chặn không thể sử dụng. Bạn đã đăng ký với một địa chỉ email hợp lệ?',
    'flash_success'                                                             => 'Thành công!',
    'flash_info'                                                                => 'Tin nhắn',
    'flash_warning'                                                             => 'Cảnh báo!',
    'flash_error'                                                               => 'Lỗi!',
    'flash_danger'                                                              => 'Nguy hiểm!',
    'flash_info_multiple'                                                       => 'Có tin nhắn :tin nhắn',
    'flash_error_multiple'                                                      => 'Có lỗi :lỗi',
    'net_worth'                                                                 => 'Tài sản thực',
    'help_for_this_page'                                                        => 'Trợ giúp cho trang này',
    'help_for_this_page_body'                                                   => 'Bạn có thể tìm thêm thông tin về trang này trong <a href="https://docs.firefly-iii.org/">liên kết này</a>.',
    'two_factor_welcome'                                                        => 'Xin chào!',
    'two_factor_enter_code'                                                     => 'Để tiếp tục, vui lòng nhập mã xác thực hai yếu tố của bạn. Ứng dụng của bạn có thể tạo ra nó cho bạn.',
    'two_factor_code_here'                                                      => 'Nhập mã vào đây',
    'two_factor_title'                                                          => 'Xác thực hai yếu tố',
    'authenticate'                                                              => 'Xác thực',
    'two_factor_forgot_title'                                                   => 'Mất xác thực hai yếu tố',
    'two_factor_forgot'                                                         => 'Tôi quên mất hai yếu tố.',
    'two_factor_lost_header'                                                    => 'Mất xác thực hai yếu tố của bạn?',
    'two_factor_lost_intro'                                                     => 'Nếu bạn bị mất mã dự phòng. Bạn có hai lựa chọn.',
    'two_factor_lost_fix_self'                                                  => 'If you run your own instance of Firefly III, read <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">this entry in the FAQ</a> for instructions.',
    'two_factor_lost_fix_owner'                                                 => 'Nếu không, gửi email cho chủ sở hữu trang web, <a href="mailto::site_owner">:site_owner</a> và yêu cầu họ đặt lại xác thực hai yếu tố của bạn.',
    'mfa_backup_code'                                                           => 'Bạn đã sử dụng mã dự phòng để đăng nhập vào Firefly III. Nó không thể được sử dụng lại, vì vậy hãy gạch chéo nó khỏi danh sách của bạn.',
    'pref_two_factor_new_backup_codes'                                          => 'Nhận mã dự phòng mới',
    'pref_two_factor_backup_code_count'                                         => 'Bạn có :count mã dự phòng hợp lệ. | Bạn có :count mã dự phòng hợp lệ.',
    '2fa_i_have_them'                                                           => 'Tôi đã lưu trữ chúng!',
    'warning_much_data'                                                         => ': ngày ngày dữ liệu có thể mất một lúc để tải.',
    'registered'                                                                => 'Bạn đã đăng ký thành công!',
    'Default asset account'                                                     => 'Mặc định tài khoản',
    'no_budget_pointer'                                                         => 'Dường như bạn chưa có ngân sách. Bạn nên tạo vài cái tại trang <a href="budgets">ngân sách</a>-. Ngân sách có thể giúp bạn theo dõi chi tiêu.',
    'no_bill_pointer'                                                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                                                           => 'Tài khoản tiết kiệm',
    'Credit card'                                                               => 'Thẻ tín dụng',
    'source_accounts'                                                           => 'Tài khoản gửi',
    'destination_accounts'                                                      => 'Tài khoản nhận',
    'user_id_is'                                                                => 'ID người dùng của bạn là <strong>:user</strong>',
    'field_supports_markdown'                                                   => 'Trường này hỗ trợ <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                                                            => 'Nếu bạn cần thêm trợ giúp khi sử dụng Firefly III, vui lòng <a href="https://github.com/firefly-iii/firefly-iii/issues">open a ticket on Github</a>.',
    'reenable_intro_text'                                                       => 'Bạn cũng có thể kích hoạt lại <a href="#" id="reenableGuidance">the introduction guidance</a>.',
    'intro_boxes_after_refresh'                                                 => 'Các giới thiệu sẽ xuất hiện lại khi bạn tải lại trang.',
    'show_all_no_filter'                                                        => 'Hiển thị tất cả các giao dịch mà không nhóm chúng theo ngày.',
    'expenses_by_category'                                                      => 'Chi phí theo danh mục',
    'expenses_by_budget'                                                        => 'Chi phí theo ngân sách',
    'income_by_category'                                                        => 'Thu nhập theo danh mục',
    'expenses_by_asset_account'                                                 => 'Chi phí bằng tài khoản',
    'expenses_by_expense_account'                                               => 'Expenses by destination account',
    'cannot_redirect_to_account'                                                => 'Firefly III không thể chuyển hướng bạn đến đúng trang. Lời xin lỗi.',
    'sum_of_expenses'                                                           => 'Tổng chi phí',
    'sum_of_income'                                                             => 'Tổng thu nhập',
    'liabilities'                                                               => 'Nợ phải trả',
    'spent_in_specific_budget'                                                  => 'Chi ngân sách ":budget"',
    'spent_in_specific_double'                                                  => 'Đã chi trong tài khoản ":account"',
    'earned_in_specific_double'                                                 => 'Kiếm được trong tài khoản ":account"',
    'source_account'                                                            => 'Nguồn tài khoản',
    'source_account_reconciliation'                                             => 'Bạn không thể chỉnh sửa tài khoản nguồn của giao dịch đối chiếu.',
    'destination_account'                                                       => 'Tài khoản đích',
    'destination_account_reconciliation'                                        => 'Bạn không thể chỉnh sửa tài khoản đích của giao dịch đối chiếu.',
    'sum_of_expenses_in_budget'                                                 => 'Tổng chi trong ngân sách ":budget"',
    'left_in_budget_limit'                                                      => 'Còn lại để chi tiêu theo ngân sách',
    'current_period'                                                            => 'Giai đoạn hiện tại',
    'show_the_current_period_and_overview'                                      => 'Hiển thị giai đoạn hiện tại và tổng quan',
    'pref_languages_locale'                                                     => 'Để một ngôn ngữ khác tiếng Anh hoạt động chính xác, hệ điều hành của bạn phải được cài đặt ngôn ngữ và đơn vị chính xác. Nếu không có, dữ liệu tiền tệ, ngày và số tiền có thể được định dạng sai.',
    'budget_in_period'                                                          => 'Tất cả các giao dịch cho ngân sách ":name" giữa :start và :end bằng :currency',
    'chart_budget_in_period'                                                    => 'Biểu đồ cho tất cả các giao dịch theo ngân sách ":name" giữa :start và :end bằng :currency',
    'chart_budget_in_period_only_currency'                                      => 'Số tiền bạn đã lập ngân sách bằng :currency, vì vậy biểu đồ này sẽ chỉ hiển thị các giao dịch bằng :currency.',
    'chart_account_in_period'                                                   => 'Biểu đồ cho tất cả các giao dịch theo tài khoản ":name" (:balance) giữa :start và :end',
    'chart_category_in_period'                                                  => 'Biểu đồ cho tất cả các giao dịch theo danh mục ":name" giữa :start và :end',
    'chart_category_all'                                                        => 'Biểu đồ cho tất cả các giao dịch cho danh mục ":name"',
    'clone_withdrawal'                                                          => 'Nhân bản khoản rút tiền này',
    'clone_deposit'                                                             => 'Nhân bản khoản tiền gửi này',
    'clone_transfer'                                                            => 'Nhân bản chuyển khoản này',
    'multi_select_no_selection'                                                 => 'Không được chọn',
    'multi_select_select_all'                                                   => 'Chọn tất cả',
    'multi_select_n_selected'                                                   => 'đã chọn',
    'multi_select_all_selected'                                                 => 'Tất cả được chọn',
    'multi_select_filter_placeholder'                                           => 'Tìm thấy..',
    'intro_next_label'                                                          => 'Kế tiếp',
    'intro_prev_label'                                                          => 'Trước',
    'intro_skip_label'                                                          => 'Bỏ qua',
    'intro_done_label'                                                          => 'Xong',
    'between_dates_breadcrumb'                                                  => 'Giữa: bắt đầu và: kết thúc',
    'all_journals_without_budget'                                               => 'Tất cả các giao dịch không có ngân sách',
    'journals_without_budget'                                                   => 'Giao dịch không có ngân sách',
    'all_journals_without_category'                                             => 'Tất cả các giao dịch không có danh mục',
    'journals_without_category'                                                 => 'Giao dịch không có danh mục',
    'all_journals_for_account'                                                  => 'Tất cả các giao dịch của tài khoản :name',
    'chart_all_journals_for_account'                                            => 'Biểu đồ của tất cả các giao dịch cho tài khoản :name',
    'journals_in_period_for_account'                                            => 'Tất cả các giao dịch cho tài khoản :name giữa :start và :end',
    'journals_in_period_for_account_js'                                         => 'Tất cả giao dịch của tài khoản {title} giữa {start} và {end}',
    'transferred'                                                               => 'Chuyển nhượng',
    'all_withdrawal'                                                            => 'Mọi chi phí',
    'all_transactions'                                                          => 'Tất cả các giao dịch',
    'title_withdrawal_between'                                                  => 'Tất cả các chi phí giữa :start và :end',
    'all_deposit'                                                               => 'Tất cả doanh thu',
    'title_deposit_between'                                                     => 'Tất cả doanh thu giữa :start và :end',
    'all_transfers'                                                             => 'Tất cả chuyển khoản',
    'title_transfers_between'                                                   => 'Tất cả chuyển giữa: bắt đầu và: kết thúc',
    'all_transfer'                                                              => 'Tất cả chuyển khoản',
    'all_journals_for_tag'                                                      => 'Tất cả các giao dịch cho nhãn":tag"',
    'title_transfer_between'                                                    => 'Tất cả chuyển giữa :start và :end',
    'all_journals_for_category'                                                 => 'Tất cả các giao dịch cho thể loại :name',
    'all_journals_for_budget'                                                   => 'Tất cả các giao dịch cho ngân sách :name',
    'chart_all_journals_for_budget'                                             => 'Biểu đồ của tất cả các giao dịch cho ngân sách :name',
    'journals_in_period_for_category'                                           => 'Tất cả các giao dịch cho danh mục :name giữa :start và :end',
    'journals_in_period_for_tag'                                                => 'Tất cả các giao dịch cho nhãn :tag giữa :start và :end',
    'not_available_demo_user'                                                   => 'Tính năng bạn cố gắng truy cập không khả dụng cho người dùng demo.',
    'exchange_rate_instructions'                                                => 'tài khoản "@name" chỉ chấp nhận giao dịch bằng tiền bản địa. Nếu bạn muốn sử dụng ngoại tệ, hãy đảm bảo rằng số tiền bằng tiền bản địa cũng được biết đến:',
    'transfer_exchange_rate_instructions'                                       => 'Tài khoản nguồn tài sản "@source_name" chỉ chấp nhận giao dịch bằng tiền tệ nguồn. tài khoản đícht "@dest_name" chỉ chấp nhận giao dịch bằng tiền tệ. Bạn phải cung cấp số tiền được chuyển chính xác bằng cả hai loại tiền tệ.',
    'transaction_data'                                                          => 'Dữ liệu giao dịch',
    'invalid_server_configuration'                                              => 'Cấu hình máy chủ không hợp lệ',
    'invalid_locale_settings'                                                   => 'Firefly III is unable to format monetary amounts because your server is missing the required packages. There are <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instructions how to do this</a>.',
    'quickswitch'                                                               => 'Chuyển đổi nhanh',
    'sign_in_to_start'                                                          => 'Đăng nhập để bắt đầu',
    'sign_in'                                                                   => 'Đăng nhập',
    'register_new_account'                                                      => 'Đăng ký tài khoản mới',
    'forgot_my_password'                                                        => 'Tôi quên mật khẩu của tôi',
    'problems_with_input'                                                       => 'Có một số vấn đề với đầu vào của bạn.',
    'reset_password'                                                            => 'Đặt lại mật khẩu của bạn',
    'button_reset_password'                                                     => 'Đặt lại mật khẩu',
    'reset_button'                                                              => 'Đặt lại',
    'want_to_login'                                                             => 'Tôi muốn đăng nhập',
    'login_page_title'                                                          => 'Đăng nhập vào Firefly III',
    'register_page_title'                                                       => 'Đăng ký tại Firefly III',
    'forgot_pw_page_title'                                                      => 'Quên mật khẩu của bạn cho Firefly III',
    'reset_pw_page_title'                                                       => 'Đặt lại mật khẩu của bạn cho Firefly III',
    'cannot_reset_demo_user'                                                    => 'Bạn không thể đặt lại mật khẩu của người dùng demo.',
    'no_att_demo_user'                                                          => 'Người dùng thử không được phép tải file lên.',
    'button_register'                                                           => 'Đăng ký',
    'authorization'                                                             => 'Ủy quyền',
    'active_bills_only'                                                         => 'chỉ kích hoạt gói đăng ký',
    'active_bills_only_total'                                                   => 'tất cả gói đăng ký đang hoạt động',
    'active_exp_bills_only'                                                     => 'active and expected subscriptions only',
    'active_exp_bills_only_total'                                               => 'all active expected subscriptions only',
    'per_period_sum_1D'                                                         => 'Chi phí hàng ngày dự kiến',
    'per_period_sum_1W'                                                         => 'Chi phí hàng tuần dự kiến',
    'per_period_sum_1M'                                                         => 'Chi phí hàng tháng dự kiến',
    'per_period_sum_3M'                                                         => 'Chi phí hàng quý dự kiến',
    'per_period_sum_6M'                                                         => 'Chi phí nửa năm dự kiến',
    'per_period_sum_1Y'                                                         => 'Chi phí hàng năm dự kiến',
    'average_per_bill'                                                          => 'average per subscription',
    'expected_total'                                                            => 'tổng dự kiến',
    'reconciliation_account_name'                                               => ':name reconciliation (:currency)',
    'saved'                                                                     => 'Đã lưu',
    'advanced_options'                                                          => 'Tùy chọn nâng cao',
    'advanced_options_explain'                                                  => 'Một số trang trong Firefly III có các tùy chọn nâng cao ẩn sau nút này. Trang này không có gì lạ mắt ở đây, nhưng hãy kiểm tra các trang khác!',
    'here_be_dragons'                                                           => 'Hic sunt dracones',

    // Webhooks
    'webhooks'                                                                  => 'Webhooks',
    'webhooks_breadcrumb'                                                       => 'Webhooks',
    'webhooks_menu_disabled'                                                    => 'đã vô hiệu hóa',
    'no_webhook_messages'                                                       => 'Không có tin nhắn webhook',
    'webhook_trigger_STORE_TRANSACTION'                                         => 'Sau khi tạo giao dịch',
    'webhook_trigger_UPDATE_TRANSACTION'                                        => 'Sau khi cập nhật giao dịch',
    'webhook_trigger_DESTROY_TRANSACTION'                                       => 'Sau khi xóa giao dịch',
    'webhook_response_TRANSACTIONS'                                             => 'Chi tiết giao dịch',
    'webhook_response_ACCOUNTS'                                                 => 'Chi tiết tài khoản',
    'webhook_response_none_NONE'                                                => 'Không có chi tiết',
    'webhook_delivery_JSON'                                                     => 'JSON',
    'inspect'                                                                   => 'Kiểm tra',
    'create_new_webhook'                                                        => 'Tạo webhook mới',
    'webhooks_create_breadcrumb'                                                => 'Tạo webhook mới',
    'webhook_trigger_form_help'                                                 => 'Chọn loại sự kiện nào webhook sẽ kích hoạt',
    'webhook_response_form_help'                                                => 'Chọn URL nào webhook sẽ gửi thông tin.',
    'webhook_delivery_form_help'                                                => 'Loại định dạng webhook gửi dữ liệu vào.',
    'webhook_active_form_help'                                                  => 'Webhook phải được kích hoạt hoặc nó sẽ được gọi.',
    'stored_new_webhook'                                                        => 'Lưu trữ webhook mới ":title"',
    'delete_webhook'                                                            => 'Xóa webhook',
    'deleted_webhook'                                                           => 'Webhook đã bị xóa ":title"',
    'edit_webhook'                                                              => 'Sửa webhook ":title"',
    'updated_webhook'                                                           => 'Cập nhật webhook ":title"',
    'edit_webhook_js'                                                           => 'Sửa webhook "{title}"',
    'show_webhook'                                                              => 'Webhook ":title"',
    'webhook_was_triggered'                                                     => 'Webhook sẽ kích hoạt trên những giao dịch này. Xin đợi một lúc để kết quả hiện ra.',
    'webhook_messages'                                                          => 'Tin nhắn webhook',
    'view_message'                                                              => 'Xem tin nhắn',
    'view_attempts'                                                             => 'Xem những lần thử lỗi',
    'message_content_title'                                                     => 'Nội dung tin nhắn webhook',
    'message_content_help'                                                      => 'Đây là nội dung của tin nhắn đã được gửi (hay đã thử) bằng những webhook này.',
    'attempt_content_title'                                                     => 'Các lần thử webhook',
    'attempt_content_help'                                                      => 'Đây là tất cả những lần thử gửi các tin nhắn webhook đến URL chỉ định nhưng không thành công. Sau một khoảng thời gian Firefly III sẽ dừng thử.',
    'no_attempts'                                                               => 'Không có lần thử không thành công nào. Thật là tốt!',
    'webhook_attempt_at'                                                        => 'Thử lúc {moment}',
    'logs'                                                                      => 'Nhật ký',
    'response'                                                                  => 'Đáp lại',
    'visit_webhook_url'                                                         => 'Đi đến webhook URL',
    'reset_webhook_secret'                                                      => 'Cài lại khóa webhook',
    'webhook_stored_link'                                                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> đã được lưu trữ.',
    'webhook_updated_link'                                                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") đã được cập nhật.',

    // API access
    'authorization_request'                                                     => 'Firefly III v: phiên bản Yêu cầu ủy quyền',
    'authorization_request_intro'                                               => 'Ứng dụng <strong>:client</strong> đang yêu cầu sự cho phép truy cập quản trị tài chính của bạn. Bạn có muốn ủy quyền <strong>:client</strong> để truy cập những hồ sơ này?',
    'authorization_request_site'                                                => 'Bạn sẽ được điều hướng đến <code>:url</code> nơi mà có thể truy cập thông tin Firefly III của bạn.',
    'authorization_request_invalid'                                             => 'Yêu cầu truy cập này không hợp lệ. Vui lòng không bao giờ vào liên kết này nữa.',
    'scopes_will_be_able'                                                       => 'Ứng dụng này sẽ có thể:',
    'button_authorize'                                                          => 'Ủy quyền',
    'none_in_select_list'                                                       => '(Trống)',
    'no_piggy_bank'                                                             => '(chưa có heo đất)',
    'name_in_currency'                                                          => ':name trong :currency',
    'paid_in_currency'                                                          => 'Được trả bằng :currency',
    'unpaid_in_currency'                                                        => 'Chưa thanh toán bằng :currency',
    'is_alpha_warning'                                                          => 'Bạn đang sử dụng phiên bản ALPHA.',
    'is_beta_warning'                                                           => 'Bạn đang sử dụng phiên bản BETA.',
    'all_destination_accounts'                                                  => 'Tài khoản nhận',
    'all_source_accounts'                                                       => 'Tài khoản gửi',
    'back_to_index'                                                             => 'Quay lại chỉ mục',
    'cant_logout_guard'                                                         => 'Firefly III không thể đăng xuất.',
    'internal_reference'                                                        => 'Tài liệu tham khảo nội bộ',

    // check for updates:
    'update_check_title'                                                        => 'Kiểm tra cập nhật',
    'admin_update_check_title'                                                  => 'Tự động kiểm tra cập nhật',
    'admin_update_check_explain'                                                => 'Firefly III có thể kiểm tra cập nhật tự động. Khi bạn bật cài đặt này, nó sẽ liên hệ với Github để xem có phiên bản mới của Firefly III không. Khi đó, bạn sẽ nhận được một thông báo. Bạn có thể kiểm tra thông báo này bằng nút bên phải. Vui lòng cho biết bên dưới nếu bạn muốn Firefly III kiểm tra cập nhật.',
    'check_for_updates_permission'                                              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                                                      => 'Hãy hỏi tôi sau',
    'updates_do_not_check'                                                      => 'Không kiểm tra cập nhật',
    'updates_enable_check'                                                      => 'Cho phép kiểm tra cập nhật',
    'admin_update_check_now_title'                                              => 'Kiểm tra cập nhật ngay bây giờ',
    'admin_update_check_now_explain'                                            => 'Nếu bạn nhấn nút, Firefly III sẽ xem phiên bản hiện tại của bạn có phải là phiên bản mới nhất không.',
    'check_for_updates_button'                                                  => 'Kiểm tra ngay!',
    'update_new_version_alert'                                                  => 'Một phiên bản mới của Firefly III có sẵn. Bạn đang chạy :your_version, phiên bản mới nhất là :new_version được phát hành vào :date.',
    'update_version_beta'                                                       => 'Phiên bản này là phiên bản BETA. Bạn có thể gặp vấn đề.',
    'update_version_alpha'                                                      => 'Phiên bản này là phiên bản ALPHA. Bạn có thể gặp vấn đề.',
    'update_current_dev_older'                                                  => 'You are running development release ":version", which is older than the latest release :new_version. Please update!',
    'update_current_dev_newer'                                                  => 'You are running development release ":version", which is newer than the latest release :new_version.',
    'update_current_version_alert'                                              => 'Bạn đang chạy :version , đây là phiên bản mới nhất có sẵn.',
    'update_newer_version_alert'                                                => 'Bạn đang chạy :your_version, mới hơn bản phát hành mới nhất , :new_version.',
    'update_check_error'                                                        => 'Đã xảy ra lỗi trong khi kiểm tra cập nhật: :error',
    'unknown_error'                                                             => 'Không xác định được lỗi. Xin lỗi vì điều này.',
    'disabled_but_check'                                                        => 'Bạn đã tắt kiểm tra cập nhật. Vì vậy, đừng quên kiểm tra cập nhật cho mình mọi lúc mọi nơi. Cảm ơn bạn!',
    'admin_update_channel_title'                                                => 'Cập nhật kênh',
    'admin_update_channel_explain'                                              => 'Firefly III có ba "kênh" cập nhật xác định mức độ vượt trội của bạn về các tính năng, cải tiến và lỗi. Sử dụng kênh "beta" nếu bạn thích phiêu lưu và "alpha" khi bạn muốn sống một cách nguy hiểm.',
    'update_channel_stable'                                                     => 'Ổn định. Mọi thứ hoạt động như mong đợi.',
    'update_channel_beta'                                                       => 'Beta. Các tính năng mới nhưng mọi thứ có thể bị lỗi.',
    'update_channel_alpha'                                                      => 'Alpha. Chúng tôi ném đồ vào, và sử dụng bất cứ thứ gì.',

    // search
    'search'                                                                    => 'Tìm kiếm',
    'search_query'                                                              => 'Truy vấn',
    'search_found_transactions'                                                 => 'Tìm thấy Firefly III :count giao dịch trong :time giây. | Firefly III được tìm thấy :count giao dịch trong :time giây.',
    'search_found_more_transactions'                                            => 'Firefly III đã tìm thấy hơn :count giao dịch trong :time giây.',
    'search_for_overview'                                                       => 'Firefly III is searching for transactions that fulfill <b>all</b> of the following conditions:',
    'search_for_query'                                                          => 'All of these words must be present: <span class="text-info">:query</span>',
    'search_for_excluded_words'                                                 => 'None of these words may be present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                                                    => 'These search parameters are not valid and have been ignored.',

    // old



    'search_modifier_date_on'                                                   => 'Ngày giao dịch là ":value"',
    'search_modifier_not_date_on'                                               => 'Ngày giao dịch không phải ":value"',
    'search_modifier_reconciled'                                                => 'Giao dịch đã đối chiếu',
    'search_modifier_not_reconciled'                                            => 'Giao dịch chưa đối chiếu',
    'search_modifier_id'                                                        => 'ID giao dịch là ":value"',
    'search_modifier_not_id'                                                    => 'ID giao dịch không phải ":value"',
    'search_modifier_date_before'                                               => 'Ngày giao dịch phải trước hoặc ngay ":value"',
    'search_modifier_date_after'                                                => 'Ngày giao dịch phải sau hoặc ngay ":value"',
    'search_modifier_external_id_is'                                            => 'ID ngoài là ":value"',
    'search_modifier_not_external_id_is'                                        => 'ID ngoài không phải ":value"',
    'search_modifier_no_external_url'                                           => 'Giao dịch không có URL bên ngoài',
    'search_modifier_no_external_id'                                            => 'Giao dịch không có ID bên ngoài',
    'search_modifier_not_any_external_url'                                      => 'Giao dịch không có URL bên ngoài',
    'search_modifier_not_any_external_id'                                       => 'Giao dịch không có ID bên ngoài',
    'search_modifier_any_external_url'                                          => 'Giao dịch phải có 1 (hoặc nhiều) URL bên ngoài',
    'search_modifier_any_external_id'                                           => 'Giao dịch phải có 1 (hoặc nhiều) ID ngoài',
    'search_modifier_not_no_external_url'                                       => 'Giao dịch phải có 1 (hoặc nhiều) URL bên ngoài',
    'search_modifier_not_no_external_id'                                        => 'Giao dịch phải có 1 (bất kì) ID ngoài',
    'search_modifier_internal_reference_is'                                     => 'Tham chiếu nội bộ là ":value"',
    'search_modifier_not_internal_reference_is'                                 => 'Tham chiếu nội bộ không phải ":value"',
    'search_modifier_description_starts'                                        => 'Mô tả bắt đầu bằng ":value"',
    'search_modifier_not_description_starts'                                    => 'Mô tả không bắt đầu bằng ":value"',
    'search_modifier_description_ends'                                          => 'Mô tả kết thúc bằng ":value"',
    'search_modifier_not_description_ends'                                      => 'Mô tả không kết thúc bằng ":value"',
    'search_modifier_description_contains'                                      => 'Mô tả có chứa ":value"',
    'search_modifier_not_description_contains'                                  => 'Mô tả không có chứa ":value"',
    'search_modifier_description_is'                                            => 'Mô tả chính xác ":value"',
    'search_modifier_not_description_is'                                        => 'Mô tả chắc chắn không phải ":value"',
    'search_modifier_currency_is'                                               => 'Đơn vị tiền tệ của giao dịch (nước ngoài) là ":value"',
    'search_modifier_not_currency_is'                                           => 'Tiền (ngoại tệ) giao dịch không phải là ":value"',
    'search_modifier_foreign_currency_is'                                       => 'Ngoại tệ giao dịch là ":value"',
    'search_modifier_not_foreign_currency_is'                                   => 'Ngoại tệ của giao dịch không phải là ":value"',
    'search_modifier_has_attachments'                                           => 'Giao dịch phải có tệp đính kèm',
    'search_modifier_has_no_category'                                           => 'Giao dịch phải không có danh mục',
    'search_modifier_not_has_no_category'                                       => 'Giao dịch phải có 1 (bất kì) danh mục',
    'search_modifier_not_has_any_category'                                      => 'Giao dịch phải không có danh mục',
    'search_modifier_has_any_category'                                          => 'Giao dịch phải có danh mục',
    'search_modifier_has_no_budget'                                             => 'Giao dịch phải không có ngân sách',
    'search_modifier_not_has_any_budget'                                        => 'Giao dịch phải không có ngân sách',
    'search_modifier_has_any_budget'                                            => 'Giao dịch có ngân sách (bất kỳ)',
    'search_modifier_not_has_no_budget'                                         => 'Giao dịch có 1 (bất kỳ) ngân sách',
    'search_modifier_has_no_bill'                                               => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                                           => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                                              => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                                          => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                                                => 'Giao dịch phải không có thẻ',
    'search_modifier_not_has_any_tag'                                           => 'Giao dịch phải không có thẻ',
    'search_modifier_not_has_no_tag'                                            => 'Giao dịch phải có 1 (bất kì) thẻ',
    'search_modifier_has_any_tag'                                               => 'Giao dịch phải có thẻ',
    'search_modifier_notes_contains'                                            => 'Các ghi chú giao dịch chứa ":value"',
    'search_modifier_not_notes_contains'                                        => 'Các ghi chú giao dịch không chứa ":value"',
    'search_modifier_notes_starts'                                              => 'Các ghi chú giao dịch bắt đầu bằng ":value"',
    'search_modifier_not_notes_starts'                                          => 'Các ghi chú giao dịch không bắt đầu bằng ":value"',
    'search_modifier_notes_ends'                                                => 'Các ghi chú giao dịch kết thúc bằng ":value"',
    'search_modifier_not_notes_ends'                                            => 'Các ghi chú giao dịch không kết thúc bằng ":value"',
    'search_modifier_notes_is'                                                  => 'Các ghi chú giao dịch chính xác là ":value"',
    'search_modifier_not_notes_is'                                              => 'Các ghi chú giao dịch không chính xác là ":value"',
    'search_modifier_no_notes'                                                  => 'Giao dịch không có ghi chú',
    'search_modifier_not_no_notes'                                              => 'Giao dịch phải có ghi chú',
    'search_modifier_any_notes'                                                 => 'Giao dịch phải có ghi chú',
    'search_modifier_not_any_notes'                                             => 'Giao dịch không có ghi chú',
    'search_modifier_amount_is'                                                 => 'Số lượng chính xác là :value',
    'search_modifier_not_amount_is'                                             => 'Số tiền không phải :value',
    'search_modifier_amount_less'                                               => 'Số tiền phải nhỏ hơn hoặc bằng :value',
    'search_modifier_not_amount_more'                                           => 'Số tiền phải nhỏ hơn hoặc bằng :value',
    'search_modifier_amount_more'                                               => 'Số tiền phải lớn hơn hoặc bằng :value',
    'search_modifier_not_amount_less'                                           => 'Số tiền phải lớn hơn hoặc bằng :value',
    'search_modifier_source_account_is'                                         => 'Tên tài khoản chính xác là ":value"',
    'search_modifier_not_source_account_is'                                     => 'Tên tài khoản gửi không phải ":value"',
    'search_modifier_source_account_contains'                                   => 'Tên tài khoản bao gồm ":value"',
    'search_modifier_not_source_account_contains'                               => 'Source account name does not contain ":value"',
    'search_modifier_source_account_starts'                                     => 'Source account name starts with ":value"',
    'search_modifier_not_source_account_starts'                                 => 'Source account name does not start with ":value"',
    'search_modifier_source_account_ends'                                       => 'Source account name ends with ":value"',
    'search_modifier_not_source_account_ends'                                   => 'Source account name does not end with ":value"',
    'search_modifier_source_account_id'                                         => 'Source account ID is :value',
    'search_modifier_not_source_account_id'                                     => 'Source account ID is not :value',
    'search_modifier_source_account_nr_is'                                      => 'Source account number (IBAN) is ":value"',
    'search_modifier_not_source_account_nr_is'                                  => 'Source account number (IBAN) is not ":value"',
    'search_modifier_source_account_nr_contains'                                => 'Source account number (IBAN) contains ":value"',
    'search_modifier_not_source_account_nr_contains'                            => 'Source account number (IBAN) does not contain ":value"',
    'search_modifier_source_account_nr_starts'                                  => 'Source account number (IBAN) starts with ":value"',
    'search_modifier_not_source_account_nr_starts'                              => 'Source account number (IBAN) does not start with ":value"',
    'search_modifier_source_account_nr_ends'                                    => 'Source account number (IBAN) ends on ":value"',
    'search_modifier_not_source_account_nr_ends'                                => 'Source account number (IBAN) does not end on ":value"',
    'search_modifier_destination_account_is'                                    => 'Destination account name is exactly ":value"',
    'search_modifier_not_destination_account_is'                                => 'Destination account name is not ":value"',
    'search_modifier_destination_account_contains'                              => 'Destination account name contains ":value"',
    'search_modifier_not_destination_account_contains'                          => 'Destination account name does not contain ":value"',
    'search_modifier_destination_account_starts'                                => 'Destination account name starts with ":value"',
    'search_modifier_not_destination_account_starts'                            => 'Destination account name does not start with ":value"',
    'search_modifier_destination_account_ends'                                  => 'Destination account name ends on ":value"',
    'search_modifier_not_destination_account_ends'                              => 'Destination account name does not end on ":value"',
    'search_modifier_destination_account_id'                                    => 'Destination account ID is :value',
    'search_modifier_not_destination_account_id'                                => 'Destination account ID is not :value',
    'search_modifier_destination_is_cash'                                       => 'Destination account is the "(cash)" account',
    'search_modifier_not_destination_is_cash'                                   => 'Destination account is not the "(cash)" account',
    'search_modifier_source_is_cash'                                            => 'Source account is the "(cash)" account',
    'search_modifier_not_source_is_cash'                                        => 'Source account is not the "(cash)" account',
    'search_modifier_destination_account_nr_is'                                 => 'Destination account number (IBAN) is ":value"',
    'search_modifier_not_destination_account_nr_is'                             => 'Destination account number (IBAN) is ":value"',
    'search_modifier_destination_account_nr_contains'                           => 'Destination account number (IBAN) contains ":value"',
    'search_modifier_not_destination_account_nr_contains'                       => 'Destination account number (IBAN) does not contain ":value"',
    'search_modifier_destination_account_nr_starts'                             => 'Destination account number (IBAN) starts with ":value"',
    'search_modifier_not_destination_account_nr_starts'                         => 'Destination account number (IBAN) does not start with ":value"',
    'search_modifier_destination_account_nr_ends'                               => 'Destination account number (IBAN) ends with ":value"',
    'search_modifier_not_destination_account_nr_ends'                           => 'Destination account number (IBAN) does not end with ":value"',
    'search_modifier_account_id'                                                => 'Source or destination account ID\'s is/are: :value',
    'search_modifier_not_account_id'                                            => 'Source or destination account ID\'s is/are not: :value',
    'search_modifier_category_is'                                               => 'Category is ":value"',
    'search_modifier_not_category_is'                                           => 'Category is not ":value"',
    'search_modifier_budget_is'                                                 => 'Ngân sách là ":value"',
    'search_modifier_not_budget_is'                                             => 'Budget is not ":value"',
    'search_modifier_bill_is'                                                   => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                                               => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                                          => 'Transaction type is ":value"',
    'search_modifier_not_transaction_type'                                      => 'Transaction type is not ":value"',
    'search_modifier_tag_is'                                                    => 'Nhãn là ":value"',
    'search_modifier_tag_contains'                                              => 'Tag contains ":value"',
    'search_modifier_not_tag_contains'                                          => 'Tag does not contain ":value"',
    'search_modifier_tag_ends'                                                  => 'Tag ends with ":value"',
    'search_modifier_tag_starts'                                                => 'Tag starts with ":value"',
    'search_modifier_not_tag_is'                                                => 'No tag is ":value"',
    'search_modifier_date_on_year'                                              => 'Transaction is in year ":value"',
    'search_modifier_not_date_on_year'                                          => 'Transaction is not in year ":value"',
    'search_modifier_date_on_month'                                             => 'Transaction is in month ":value"',
    'search_modifier_not_date_on_month'                                         => 'Transaction is not in month ":value"',
    'search_modifier_date_on_day'                                               => 'Transaction is on day of month ":value"',
    'search_modifier_not_date_on_day'                                           => 'Transaction is not on day of month ":value"',
    'search_modifier_date_before_year'                                          => 'Transaction is before or in year ":value"',
    'search_modifier_date_before_month'                                         => 'Transaction is before or in month ":value"',
    'search_modifier_date_before_day'                                           => 'Transaction is before or on day of month ":value"',
    'search_modifier_date_after_year'                                           => 'Transaction is in or after year ":value"',
    'search_modifier_date_after_month'                                          => 'Transaction is in or after month ":value"',
    'search_modifier_date_after_day'                                            => 'Transaction is after or on day of month ":value"',

    // new
    'search_modifier_tag_is_not'                                                => 'No tag is ":value"',
    'search_modifier_not_tag_is_not'                                            => 'Tag is ":value"',
    'search_modifier_account_is'                                                => 'Either account is ":value"',
    'search_modifier_not_account_is'                                            => 'Neither account is ":value"',
    'search_modifier_account_contains'                                          => 'Either account contains ":value"',
    'search_modifier_not_account_contains'                                      => 'Neither account contains ":value"',
    'search_modifier_account_ends'                                              => 'Either account ends with ":value"',
    'search_modifier_not_account_ends'                                          => 'Neither account ends with ":value"',
    'search_modifier_account_starts'                                            => 'Either account starts with ":value"',
    'search_modifier_not_account_starts'                                        => 'Neither account starts with ":value"',
    'search_modifier_account_nr_is'                                             => 'Either account number / IBAN is ":value"',
    'search_modifier_not_account_nr_is'                                         => 'Neither account number / IBAN is ":value"',
    'search_modifier_account_nr_contains'                                       => 'Either account number / IBAN contains ":value"',
    'search_modifier_not_account_nr_contains'                                   => 'Neither account number / IBAN contains ":value"',
    'search_modifier_account_nr_ends'                                           => 'Either account number / IBAN ends with ":value"',
    'search_modifier_not_account_nr_ends'                                       => 'Neither account number / IBAN ends with ":value"',
    'search_modifier_account_nr_starts'                                         => 'Either account number / IBAN starts with ":value"',
    'search_modifier_not_account_nr_starts'                                     => 'Neither account number / IBAN starts with ":value"',
    'search_modifier_category_contains'                                         => 'Category contains ":value"',
    'search_modifier_not_category_contains'                                     => 'Category does not contain ":value"',
    'search_modifier_category_ends'                                             => 'Category ends on ":value"',
    'search_modifier_not_category_ends'                                         => 'Category does not end on ":value"',
    'search_modifier_category_starts'                                           => 'Category starts with ":value"',
    'search_modifier_not_category_starts'                                       => 'Category does not start with ":value"',
    'search_modifier_budget_contains'                                           => 'Ngân sách chứa ":value"',
    'search_modifier_not_budget_contains'                                       => 'Budget does not contain ":value"',
    'search_modifier_budget_ends'                                               => 'Budget ends with ":value"',
    'search_modifier_not_budget_ends'                                           => 'Budget does not end on ":value"',
    'search_modifier_budget_starts'                                             => 'Budget starts with ":value"',
    'search_modifier_not_budget_starts'                                         => 'Budget does not start with ":value"',
    'search_modifier_bill_contains'                                             => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                                         => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                                                 => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                                             => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                                               => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                                           => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                                      => 'External ID contains ":value"',
    'search_modifier_not_external_id_contains'                                  => 'External ID does not contain ":value"',
    'search_modifier_external_id_ends'                                          => 'External ID ends with ":value"',
    'search_modifier_not_external_id_ends'                                      => 'External ID does not end with ":value"',
    'search_modifier_external_id_starts'                                        => 'External ID starts with ":value"',
    'search_modifier_not_external_id_starts'                                    => 'External ID does not start with ":value"',
    'search_modifier_internal_reference_contains'                               => 'Internal reference contains ":value"',
    'search_modifier_not_internal_reference_contains'                           => 'Internal reference does not contain ":value"',
    'search_modifier_internal_reference_ends'                                   => 'Internal reference ends with ":value"',
    'search_modifier_internal_reference_starts'                                 => 'Internal reference starts with ":value"',
    'search_modifier_not_internal_reference_ends'                               => 'Internal reference does not end with ":value"',
    'search_modifier_not_internal_reference_starts'                             => 'Internal reference does not start with ":value"',
    'search_modifier_external_url_is'                                           => 'External URL is ":value"',
    'search_modifier_not_external_url_is'                                       => 'External URL is not ":value"',
    'search_modifier_external_url_contains'                                     => 'External URL contains ":value"',
    'search_modifier_not_external_url_contains'                                 => 'External URL does not contain ":value"',
    'search_modifier_external_url_ends'                                         => 'External URL ends with ":value"',
    'search_modifier_not_external_url_ends'                                     => 'External URL does not end with ":value"',
    'search_modifier_external_url_starts'                                       => 'External URL starts with ":value"',
    'search_modifier_not_external_url_starts'                                   => 'External URL does not start with ":value"',
    'search_modifier_has_no_attachments'                                        => 'Transaction has no attachments',
    'search_modifier_not_has_no_attachments'                                    => 'Transaction has attachments',
    'search_modifier_not_has_attachments'                                       => 'Transaction has no attachments',
    'search_modifier_account_is_cash'                                           => 'Either account is the "(cash)" account.',
    'search_modifier_not_account_is_cash'                                       => 'Neither account is the "(cash)" account.',
    'search_modifier_journal_id'                                                => 'The journal ID is ":value"',
    'search_modifier_not_journal_id'                                            => 'The journal ID is not ":value"',
    'search_modifier_recurrence_id'                                             => 'The recurring transaction ID is ":value"',
    'search_modifier_not_recurrence_id'                                         => 'The recurring transaction ID is not ":value"',
    'search_modifier_foreign_amount_is'                                         => 'The foreign amount is ":value"',
    'search_modifier_not_foreign_amount_is'                                     => 'The foreign amount is not ":value"',
    'search_modifier_foreign_amount_less'                                       => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_more'                                   => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_less'                                   => 'The foreign amount is more than ":value"',
    'search_modifier_foreign_amount_more'                                       => 'The foreign amount is more than ":value"',
    'search_modifier_exists'                                                    => 'Transaction exists (any transaction)',
    'search_modifier_not_exists'                                                => 'Transaction does not exist (no transaction)',

    // date fields
    'search_modifier_interest_date_on'                                          => 'Transaction interest date is ":value"',
    'search_modifier_not_interest_date_on'                                      => 'Transaction interest date is not ":value"',
    'search_modifier_interest_date_on_year'                                     => 'Transaction interest date is in year ":value"',
    'search_modifier_not_interest_date_on_year'                                 => 'Transaction interest date is not in year ":value"',
    'search_modifier_interest_date_on_month'                                    => 'Transaction interest date is in month ":value"',
    'search_modifier_not_interest_date_on_month'                                => 'Transaction interest date is not in month ":value"',
    'search_modifier_interest_date_on_day'                                      => 'Transaction interest date is on day of month ":value"',
    'search_modifier_not_interest_date_on_day'                                  => 'Transaction interest date is not on day of month ":value"',
    'search_modifier_interest_date_before_year'                                 => 'Transaction interest date is before or in year ":value"',
    'search_modifier_interest_date_before_month'                                => 'Transaction interest date is before or in month ":value"',
    'search_modifier_interest_date_before_day'                                  => 'Transaction interest date is before or on day of month ":value"',
    'search_modifier_interest_date_after_year'                                  => 'Transaction interest date is after or in year ":value"',
    'search_modifier_interest_date_after_month'                                 => 'Transaction interest date is after or in month ":value"',
    'search_modifier_interest_date_after_day'                                   => 'Transaction interest date is after or on day of month ":value"',
    'search_modifier_book_date_on_year'                                         => 'Transaction book date is in year ":value"',
    'search_modifier_book_date_on_month'                                        => 'Transaction book date is in month ":value"',
    'search_modifier_book_date_on_day'                                          => 'Transaction book date is on day of month ":value"',
    'search_modifier_not_book_date_on_year'                                     => 'Transaction book date is not in year ":value"',
    'search_modifier_not_book_date_on_month'                                    => 'Transaction book date is not in month ":value"',
    'search_modifier_not_book_date_on_day'                                      => 'Transaction book date is not on day of month ":value"',
    'search_modifier_book_date_before_year'                                     => 'Transaction book date is before or in year ":value"',
    'search_modifier_book_date_before_month'                                    => 'Transaction book date is before or in month ":value"',
    'search_modifier_book_date_before_day'                                      => 'Transaction book date is before or on day of month ":value"',
    'search_modifier_book_date_after_year'                                      => 'Transaction book date is after or in year ":value"',
    'search_modifier_book_date_after_month'                                     => 'Transaction book date is after or in month ":value"',
    'search_modifier_book_date_after_day'                                       => 'Transaction book date is after or on day of month ":value"',
    'search_modifier_process_date_on_year'                                      => 'Transaction process date is in year ":value"',
    'search_modifier_process_date_on_month'                                     => 'Transaction process date is in month ":value"',
    'search_modifier_process_date_on_day'                                       => 'Transaction process date is on day of month ":value"',
    'search_modifier_not_process_date_on_year'                                  => 'Transaction process date is not in year ":value"',
    'search_modifier_not_process_date_on_month'                                 => 'Transaction process date is not in month ":value"',
    'search_modifier_not_process_date_on_day'                                   => 'Transaction process date is not on day of month ":value"',
    'search_modifier_process_date_before_year'                                  => 'Transaction process date is before or in year ":value"',
    'search_modifier_process_date_before_month'                                 => 'Transaction process date is before or in month ":value"',
    'search_modifier_process_date_before_day'                                   => 'Transaction process date is before or on day of month ":value"',
    'search_modifier_process_date_after_year'                                   => 'Transaction process date is after or in year ":value"',
    'search_modifier_process_date_after_month'                                  => 'Transaction process date is after or in month ":value"',
    'search_modifier_process_date_after_day'                                    => 'Transaction process date is after or on day of month ":value"',
    'search_modifier_due_date_on_year'                                          => 'Transaction due date is in year ":value"',
    'search_modifier_due_date_on_month'                                         => 'Transaction due date is in month ":value"',
    'search_modifier_due_date_on_day'                                           => 'Transaction due date is on day of month ":value"',
    'search_modifier_not_due_date_on_year'                                      => 'Transaction due date is not in year ":value"',
    'search_modifier_not_due_date_on_month'                                     => 'Transaction due date is not in month ":value"',
    'search_modifier_not_due_date_on_day'                                       => 'Transaction due date is not on day of month ":value"',
    'search_modifier_due_date_before_year'                                      => 'Transaction due date is before or in year ":value"',
    'search_modifier_due_date_before_month'                                     => 'Transaction due date is before or in month ":value"',
    'search_modifier_due_date_before_day'                                       => 'Transaction due date is before or on day of month ":value"',
    'search_modifier_due_date_after_year'                                       => 'Transaction due date is after or in year ":value"',
    'search_modifier_due_date_after_month'                                      => 'Transaction due date is after or in month ":value"',
    'search_modifier_due_date_after_day'                                        => 'Transaction due date is after or on day of month ":value"',
    'search_modifier_payment_date_on_year'                                      => 'Transaction payment date is in year ":value"',
    'search_modifier_payment_date_on_month'                                     => 'Transaction payment date is in month ":value"',
    'search_modifier_payment_date_on_day'                                       => 'Transaction payment date is on day of month ":value"',
    'search_modifier_not_payment_date_on_year'                                  => 'Transaction payment date is not in year ":value"',
    'search_modifier_not_payment_date_on_month'                                 => 'Transaction payment date is not in month ":value"',
    'search_modifier_not_payment_date_on_day'                                   => 'Transaction payment date is not on day of month ":value"',
    'search_modifier_payment_date_before_year'                                  => 'Transaction payment date is before or in year ":value"',
    'search_modifier_payment_date_before_month'                                 => 'Transaction payment date is before or in month ":value"',
    'search_modifier_payment_date_before_day'                                   => 'Transaction payment date is before or on day of month ":value"',
    'search_modifier_payment_date_after_year'                                   => 'Transaction payment date is after or in year ":value"',
    'search_modifier_payment_date_after_month'                                  => 'Transaction payment date is after or in month ":value"',
    'search_modifier_payment_date_after_day'                                    => 'Transaction payment date is after or on day of month ":value"',
    'search_modifier_invoice_date_on_year'                                      => 'Transaction invoice date is in year ":value"',
    'search_modifier_invoice_date_on_month'                                     => 'Transaction invoice date is in month ":value"',
    'search_modifier_invoice_date_on_day'                                       => 'Transaction invoice date is on day of month ":value"',
    'search_modifier_not_invoice_date_on_year'                                  => 'Transaction invoice date is not in year ":value"',
    'search_modifier_not_invoice_date_on_month'                                 => 'Transaction invoice date is not in month ":value"',
    'search_modifier_not_invoice_date_on_day'                                   => 'Transaction invoice date is not on day of month ":value"',
    'search_modifier_invoice_date_before_year'                                  => 'Transaction invoice date is before or in year ":value"',
    'search_modifier_invoice_date_before_month'                                 => 'Transaction invoice date is before or in month ":value"',
    'search_modifier_invoice_date_before_day'                                   => 'Transaction invoice date is before or on day of month ":value"',
    'search_modifier_invoice_date_after_year'                                   => 'Transaction invoice date is after or in year ":value"',
    'search_modifier_invoice_date_after_month'                                  => 'Transaction invoice date is after or in month ":value"',
    'search_modifier_invoice_date_after_day'                                    => 'Transaction invoice date is after or on day of month ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                                        => 'Transaction was last updated in year ":value"',
    'search_modifier_updated_at_on_month'                                       => 'Transaction was last updated in month ":value"',
    'search_modifier_updated_at_on_day'                                         => 'Transaction was last updated on day of month ":value"',
    'search_modifier_not_updated_at_on_year'                                    => 'Transaction was not last updated in year ":value"',
    'search_modifier_not_updated_at_on_month'                                   => 'Transaction was not last updated in month ":value"',
    'search_modifier_not_updated_at_on_day'                                     => 'Transaction was not last updated on day of month ":value"',
    'search_modifier_updated_at_before_year'                                    => 'Transaction was last updated in or before year ":value"',
    'search_modifier_updated_at_before_month'                                   => 'Transaction was last updated in or before month ":value"',
    'search_modifier_updated_at_before_day'                                     => 'Transaction was last updated on or before day of month ":value"',
    'search_modifier_updated_at_after_year'                                     => 'Transaction was last updated in or after year ":value"',
    'search_modifier_updated_at_after_month'                                    => 'Transaction was last updated in or after month ":value"',
    'search_modifier_updated_at_after_day'                                      => 'Transaction was last updated on or after day of month ":value"',
    'search_modifier_created_at_on_year'                                        => 'Transaction was created in year ":value"',
    'search_modifier_created_at_on_month'                                       => 'Transaction was created in month ":value"',
    'search_modifier_created_at_on_day'                                         => 'Transaction was created on day of month ":value"',
    'search_modifier_not_created_at_on_year'                                    => 'Transaction was not created in year ":value"',
    'search_modifier_not_created_at_on_month'                                   => 'Transaction was not created in month ":value"',
    'search_modifier_not_created_at_on_day'                                     => 'Transaction was not created on day of month ":value"',
    'search_modifier_created_at_before_year'                                    => 'Transaction was created in or before year ":value"',
    'search_modifier_created_at_before_month'                                   => 'Transaction was created in or before month ":value"',
    'search_modifier_created_at_before_day'                                     => 'Transaction was created on or before day of month ":value"',
    'search_modifier_created_at_after_year'                                     => 'Transaction was created in or after year ":value"',
    'search_modifier_created_at_after_month'                                    => 'Transaction was created in or after month ":value"',
    'search_modifier_created_at_after_day'                                      => 'Transaction was created on or after day of month ":value"',
    'search_modifier_interest_date_before'                                      => 'Transaction interest date is on or before ":value"',
    'search_modifier_interest_date_after'                                       => 'Transaction interest date is on or after ":value"',
    'search_modifier_book_date_on'                                              => 'Transaction book date is on ":value"',
    'search_modifier_not_book_date_on'                                          => 'Transaction book date is not on ":value"',
    'search_modifier_book_date_before'                                          => 'Transaction book date is on or before ":value"',
    'search_modifier_book_date_after'                                           => 'Transaction book date is on or after ":value"',
    'search_modifier_process_date_on'                                           => 'Transaction process date is on ":value"',
    'search_modifier_not_process_date_on'                                       => 'Transaction process date is not on ":value"',
    'search_modifier_process_date_before'                                       => 'Transaction process date is on or before ":value"',
    'search_modifier_process_date_after'                                        => 'Transaction process date is on or after ":value"',
    'search_modifier_due_date_on'                                               => 'Transaction due date is on ":value"',
    'search_modifier_not_due_date_on'                                           => 'Transaction due date is not on ":value"',
    'search_modifier_due_date_before'                                           => 'Transaction due date is on or before ":value"',
    'search_modifier_due_date_after'                                            => 'Transaction due date is on or after ":value"',
    'search_modifier_payment_date_on'                                           => 'Transaction payment date is on ":value"',
    'search_modifier_not_payment_date_on'                                       => 'Transaction payment date is not on ":value"',
    'search_modifier_payment_date_before'                                       => 'Transaction payment date is on or before ":value"',
    'search_modifier_payment_date_after'                                        => 'Transaction payment date is on or after ":value"',
    'search_modifier_invoice_date_on'                                           => 'Transaction invoice date is on ":value"',
    'search_modifier_not_invoice_date_on'                                       => 'Transaction invoice date is not on ":value"',
    'search_modifier_invoice_date_before'                                       => 'Transaction invoice date is on or before ":value"',
    'search_modifier_invoice_date_after'                                        => 'Transaction invoice date is on or after ":value"',
    'search_modifier_created_at_on'                                             => 'Transaction was created on ":value"',
    'search_modifier_not_created_at_on'                                         => 'Transaction was not created on ":value"',
    'search_modifier_created_at_before'                                         => 'Transaction was created on or before ":value"',
    'search_modifier_created_at_after'                                          => 'Transaction was created on or after ":value"',
    'search_modifier_updated_at_on'                                             => 'Transaction was updated on ":value"',
    'search_modifier_not_updated_at_on'                                         => 'Transaction was not updated on ":value"',
    'search_modifier_updated_at_before'                                         => 'Transaction was updated on or before ":value"',
    'search_modifier_updated_at_after'                                          => 'Transaction was updated on or after ":value"',

    'search_modifier_attachment_name_is'                                        => 'Any attachment\'s name is ":value"',
    'search_modifier_attachment_name_contains'                                  => 'Any attachment\'s name contains ":value"',
    'search_modifier_attachment_name_starts'                                    => 'Any attachment\'s name starts with ":value"',
    'search_modifier_attachment_name_ends'                                      => 'Any attachment\'s name ends with ":value"',
    'search_modifier_attachment_notes_are'                                      => 'Any attachment\'s notes are ":value"',
    'search_modifier_attachment_notes_contains'                                 => 'Any attachment\'s notes contain ":value"',
    'search_modifier_attachment_notes_starts'                                   => 'Any attachment\'s notes start with ":value"',
    'search_modifier_attachment_notes_ends'                                     => 'Any attachment\'s notes end with ":value"',
    'search_modifier_not_attachment_name_is'                                    => 'Any attachment\'s name is not ":value"',
    'search_modifier_not_attachment_name_contains'                              => 'Any attachment\'s name does not contain ":value"',
    'search_modifier_not_attachment_name_starts'                                => 'Any attachment\'s name does not start with ":value"',
    'search_modifier_not_attachment_name_ends'                                  => 'Any attachment\'s name does not end with ":value"',
    'search_modifier_not_attachment_notes_are'                                  => 'Any attachment\'s notes are not ":value"',
    'search_modifier_not_attachment_notes_contains'                             => 'Any attachment\'s notes do not contain ":value"',
    'search_modifier_not_attachment_notes_starts'                               => 'Any attachment\'s notes start with ":value"',
    'search_modifier_not_attachment_notes_ends'                                 => 'Any attachment\'s notes do not end with ":value"',
    'search_modifier_sepa_ct_is'                                                => 'SEPA CT is ":value"',
    'update_rule_from_query'                                                    => 'Update rule ":rule" from search query',
    'create_rule_from_query'                                                    => 'Tạo quy tắc mới từ truy vấn tìm kiếm',
    'rule_from_search_words'                                                    => 'The rule engine has a hard time handling ":string". The suggested rule that fits your search query may give different results. Please verify the rule triggers carefully.',

    // more new stuff
    'search_modifier_destination_balance_is'                                    => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'                                => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'                                         => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'                                     => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'                                   => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte'                               => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'                                        => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'                                    => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'                                    => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt'                                => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'                                         => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'                                     => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'                                   => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte'                               => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'                                        => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'                                    => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'                                    => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'                                => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                                         => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'                                     => 'Source account balance is less than or equal to ":value"',




    // END
    'general_search_error'                                                      => 'Đã xảy ra lỗi trong khi tìm kiếm. Vui lòng kiểm tra các tệp nhật ký để biết thêm thông tin.',
    'search_box'                                                                => 'Tìm kiếm',
    'search_box_intro'                                                          => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                                              => 'Lỗi trong khi tìm kiếm',
    'search_searching'                                                          => 'Đang tìm kiếm ...',
    'search_results'                                                            => 'Kết quả tìm kiếm',

    // repeat frequencies:
    'repeat_freq_yearly'                                                        => 'hàng năm',
    'repeat_freq_half-year'                                                     => 'mỗi nửa năm',
    'repeat_freq_quarterly'                                                     => 'hàng quý',
    'repeat_freq_monthly'                                                       => 'hàng tháng',
    'repeat_freq_weekly'                                                        => 'hàng tuần',
    'repeat_freq_daily'                                                         => 'hằng ngày',
    'daily'                                                                     => 'hằng ngày',
    'weekly'                                                                    => 'hàng tuần',
    'quarterly'                                                                 => 'hàng quý',
    'half-year'                                                                 => 'mỗi nửa năm',
    'yearly'                                                                    => 'hàng năm',

    // rules
    'is_not_rule_trigger'                                                       => 'Not',
    'cannot_fire_inactive_rules'                                                => 'Bạn không thể thực thi các quy tắc không hoạt động.',
    'show_triggers'                                                             => 'Show triggers',
    'show_actions'                                                              => 'Show actions',
    'rules'                                                                     => 'Quy tắc',
    'rule_name'                                                                 => 'Tên của quy tắc',
    'rule_triggers'                                                             => 'Quy tắc kích hoạt khi',
    'rule_actions'                                                              => 'Quy tắc sẽ',
    'new_rule'                                                                  => 'Quy tắc mới',
    'new_rule_group'                                                            => 'Nhóm quy tắc mới',
    'rule_priority_up'                                                          => 'Ưu tiên quy tắc hơn',
    'rule_priority_down'                                                        => 'Đưa ra quy tắc ít ưu tiên',
    'make_new_rule_group'                                                       => 'Tạo nhóm quy tắc mới',
    'store_new_rule_group'                                                      => 'Lưu trữ nhóm quy tắc mới',
    'created_new_rule_group'                                                    => 'Nhóm quy tắc mới ":title" được lưu trữ!',
    'updated_rule_group'                                                        => 'Nhóm quy tắc được cập nhật thành công ":title".',
    'edit_rule_group'                                                           => 'Chỉnh sửa nhóm quy tắc ":title"',
    'duplicate_rule'                                                            => 'Trùng quy tắc ":title"',
    'rule_copy_of'                                                              => 'Sao chép ":title"',
    'duplicated_rule'                                                           => 'Trùng quy tắc ":title" với ":newTitle"',
    'delete_rule_group'                                                         => 'Xóa nhóm quy tắc ":title"',
    'deleted_rule_group'                                                        => 'Đã xóa nhóm quy tắc ":title"',
    'update_rule_group'                                                         => 'Cập nhật nhóm quy tắc',
    'no_rules_in_group'                                                         => 'Không có quy tắc nào trong nhóm này',
    'move_rule_group_up'                                                        => 'Di chuyển nhóm quy tắc lên',
    'move_rule_group_down'                                                      => 'Di chuyển nhóm quy tắc xuống',
    'save_rules_by_moving'                                                      => 'Lưu quy tắc này bằng cách di chuyển nó sang nhóm quy tắc khác: | Lưu các quy tắc này bằng cách di chuyển chúng sang nhóm quy tắc khác:',
    'make_new_rule'                                                             => 'Tạo quy tắc mới trong nhóm quy tắc ":title"',
    'make_new_rule_no_group'                                                    => 'Tạo một quy tắc mới',
    'instructions_rule_from_bill'                                               => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                                            => 'Tạo quy tắc dựa trên một trong các giao dịch của bạn. Bổ sung hoặc gửi mẫu dưới đây.',
    'rule_is_strict'                                                            => 'quy tắc nghiêm ngặt',
    'rule_is_not_strict'                                                        => 'quy tắc không nghiêm ngặt',
    'rule_help_stop_processing'                                                 => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                                          => 'Trong các quy tắc nghiêm ngặt TẤT CẢ các kích hoạt phải kích hoạt để (các) hành động được thực thi. Trong các quy tắc không nghiêm ngặt, BẤT KỲ kích hoạt nào cũng đủ để (các) hành động được thực thi.',
    'rule_help_active'                                                          => 'Quy tắc không hoạt động sẽ không bao giờ bắn.',
    'stored_new_rule'                                                           => 'Lưu trữ quy tắc mới với tiêu đề ":title"',
    'deleted_rule'                                                              => 'Xóa quy tắc với tiêu đề ":title"',
    'store_new_rule'                                                            => 'Lưu trữ quy tắc mới',
    'updated_rule'                                                              => 'Quy tắc cập nhật với tiêu đề ":title"',
    'default_rule_group_name'                                                   => 'Quy tắc mặc định',
    'default_rule_group_description'                                            => 'Tất cả các quy tắc của bạn không nằm trong một nhóm cụ thể.',
    'trigger'                                                                   => 'Kích hoạt',
    'trigger_value'                                                             => 'Kích hoạt giá trị',
    'stop_processing_other_triggers'                                            => 'Ngừng xử lý các kích hoạt khác',
    'add_rule_trigger'                                                          => 'Thêm kích hoạt mới',
    'action'                                                                    => 'Hành động',
    'action_value'                                                              => 'Giá trị hành động',
    'stop_executing_other_actions'                                              => 'Ngừng thực hiện các hành động khác',
    'add_rule_action'                                                           => 'Thêm hành động mới',
    'edit_rule'                                                                 => 'Edit rule #:nr ":title"',
    'delete_rule'                                                               => 'Xóa quy tắc ":title"',
    'update_rule'                                                               => 'Cập nhật quy tắc',
    'test_rule_triggers'                                                        => 'Xem các giao dịch khớp',
    'warning_no_matching_transactions'                                          => 'Không tìm thấy giao dịch phù hợp.',
    'warning_no_valid_triggers'                                                 => 'Không có kích hoạt hợp lệ được cung cấp.',
    'apply_rule_selection'                                                      => 'Áp dụng quy tắc ":title" cho giao dịch bạn lựa chọn',
    'apply_rule_selection_intro'                                                => 'Quy tắc như ":title" thường chỉ được áp dụng cho các giao dịch mới hoặc được cập nhật, nhưng bạn có thể yêu cầu Firefly III chạy nó trên một lựa chọn các giao dịch hiện tại của bạn. Điều này có thể hữu ích khi bạn đã cập nhật quy tắc và bạn cần thay đổi để áp dụng cho tất cả các giao dịch khác của mình.',
    'include_transactions_from_accounts'                                        => 'Bao gồm các giao dịch từ các tài khoản này',
    'include'                                                                   => 'Bao gồm?',
    'applied_rule_selection'                                                    => '{0} No transactions in your selection were changed by rule ":title".|[1] One transaction in your selection was changed by rule ":title".|[2,*] :count transactions in your selection were changed by rule ":title".',
    'execute'                                                                   => 'Hoàn thành',
    'apply_rule_group_selection'                                                => 'Áp dụng nhóm quy tắc ":title" để lựa chọn các giao dịch của bạn',
    'apply_rule_group_selection_intro'                                          => 'Các nhóm quy tắc như ":title" thường chỉ được áp dụng cho các giao dịch mới hoặc được cập nhật, nhưng bạn có thể yêu cầu Firefly III chạy tất cả các quy tắc trong nhóm này trên một lựa chọn các giao dịch hiện tại của bạn. Điều này có thể hữu ích khi bạn đã cập nhật một nhóm quy tắc và bạn cần thay đổi để áp dụng cho tất cả các giao dịch khác của mình.',
    'applied_rule_group_selection'                                              => 'Nhóm quy tắc ":title" đã được áp dụng cho lựa chọn của bạn.',

    // actions and triggers
    'rule_trigger_store_journal'                                                => 'Khi một giao dịch được tạo',
    'rule_trigger_update_journal'                                               => 'Khi một giao dịch được cập nhật',
    'rule_trigger_manual'                                                       => 'Only when user-activated',
    'rule_trigger_user_action'                                                  => 'Hành động của người dùng là ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'                                 => 'Source account name starts with..',
    'rule_trigger_source_account_starts'                                        => 'Source account name starts with ":trigger_value"',
    'rule_trigger_source_account_ends_choice'                                   => 'Source account name ends with..',
    'rule_trigger_source_account_ends'                                          => 'Source account name ends with ":trigger_value"',
    'rule_trigger_source_account_is_choice'                                     => 'Source account name is..',
    'rule_trigger_source_account_is'                                            => 'Source account name is ":trigger_value"',
    'rule_trigger_source_account_contains_choice'                               => 'Tên tài khoản chứa..',
    'rule_trigger_source_account_contains'                                      => 'Source account name contains ":trigger_value"',
    'rule_trigger_account_id_choice'                                            => 'Either account ID is exactly..',
    'rule_trigger_account_id'                                                   => 'Either account ID is exactly :trigger_value',
    'rule_trigger_source_account_id_choice'                                     => 'Source account ID is exactly..',
    'rule_trigger_source_account_id'                                            => 'Source account ID is exactly :trigger_value',
    'rule_trigger_destination_account_id_choice'                                => 'Destination account ID is exactly..',
    'rule_trigger_destination_account_id'                                       => 'Destination account ID is exactly :trigger_value',
    'rule_trigger_account_is_cash_choice'                                       => 'Either account is cash',
    'rule_trigger_account_is_cash'                                              => 'Either account is cash',
    'rule_trigger_source_is_cash_choice'                                        => 'Source account is (cash) account',
    'rule_trigger_source_is_cash'                                               => 'Source account is (cash) account',
    'rule_trigger_destination_is_cash_choice'                                   => 'Destination account is (cash) account',
    'rule_trigger_destination_is_cash'                                          => 'Destination account is (cash) account',
    'rule_trigger_source_account_nr_starts_choice'                              => 'Source account number / IBAN starts with..',
    'rule_trigger_source_account_nr_starts'                                     => 'Source account number / IBAN starts with ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'                                => 'Source account number / IBAN ends with..',
    'rule_trigger_source_account_nr_ends'                                       => 'Source account number / IBAN ends with ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'                                  => 'Số tài khoản nguồn / IBAN là..',
    'rule_trigger_source_account_nr_is'                                         => 'Số tài khoản nguồn / IBAN là ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'                            => 'Số tài khoản nguồn / IBAN chứa..',
    'rule_trigger_source_account_nr_contains'                                   => 'Số tài khoản nguồn / IBAN chứa ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'                            => 'Tên tài khoản đích bắt đầu bằng..',
    'rule_trigger_destination_account_starts'                                   => 'Tên tài khoản đích bắt đầu bằng ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'                              => 'Tên tài khoản đích kết thúc bằng..',
    'rule_trigger_destination_account_ends'                                     => 'Tên tài khoản đích kết thúc bằng ":trigger_value"',
    'rule_trigger_destination_account_is_choice'                                => 'Tên tài khoản đích là..',
    'rule_trigger_destination_account_is'                                       => 'Tên tài khoản đích là ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'                          => 'Destination account name contains..',
    'rule_trigger_destination_account_contains'                                 => 'Destination account name contains ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'                         => 'Destination account number / IBAN starts with..',
    'rule_trigger_destination_account_nr_starts'                                => 'Destination account number / IBAN starts with ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'                           => 'Destination account number / IBAN ends with..',
    'rule_trigger_destination_account_nr_ends'                                  => 'Destination account number / IBAN ends with ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'                             => 'Destination account number / IBAN is..',
    'rule_trigger_destination_account_nr_is'                                    => 'Destination account number / IBAN is ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice'                       => 'Destination account number / IBAN contains..',
    'rule_trigger_destination_account_nr_contains'                              => 'Destination account number / IBAN contains ":trigger_value"',
    'rule_trigger_transaction_type_choice'                                      => 'Giao dịch thuộc loại..',
    'rule_trigger_transaction_type'                                             => 'Giao dịch thuộc loại ":trigger_value"',
    'rule_trigger_category_is_choice'                                           => 'Danh mục là..',
    'rule_trigger_category_is'                                                  => 'Danh mục là ":trigger_value"',
    'rule_trigger_amount_less_choice'                                           => 'Amount is less than or equal to ..',
    'rule_trigger_amount_less'                                                  => 'Amount is less than or equal to :trigger_value',
    'rule_trigger_amount_is_choice'                                             => 'Amount is..',
    'rule_trigger_amount_is'                                                    => 'Amount is :trigger_value',
    'rule_trigger_amount_more_choice'                                           => 'Amount is more than or equal to..',
    'rule_trigger_amount_more'                                                  => 'Amount is more than or equal to :trigger_value',
    'rule_trigger_description_starts_choice'                                    => 'Mô tả bắt đầu bằng..',
    'rule_trigger_description_starts'                                           => 'Mô tả bắt đầu bằng ":trigger_value"',
    'rule_trigger_description_ends_choice'                                      => 'Mô tả kết thúc bằng..',
    'rule_trigger_description_ends'                                             => 'Mô tả kết thúc bằng ":trigger_value"',
    'rule_trigger_description_contains_choice'                                  => 'Mô tả có chứa..',
    'rule_trigger_description_contains'                                         => 'Mô tả có chứa ":trigger_value"',
    'rule_trigger_description_is_choice'                                        => 'Mô tả là..',
    'rule_trigger_description_is'                                               => 'Mô tả là ":trigger_value"',
    'rule_trigger_date_on_choice'                                               => 'Transaction date is..',
    'rule_trigger_date_on'                                                      => 'Transaction date is ":trigger_value"',
    'rule_trigger_date_before_choice'                                           => 'Ngày giao dịch trước..',
    'rule_trigger_date_before'                                                  => 'Ngày giao dịch là trước: ":trigger_value"',
    'rule_trigger_date_after_choice'                                            => 'Ngày giao dịch sau..',
    'rule_trigger_date_after'                                                   => 'Ngày giao dịch sau: ":trigger_value"',
    'rule_trigger_created_at_on_choice'                                         => 'Transaction was made on..',
    'rule_trigger_created_at_on'                                                => 'Transaction was made on ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                                         => 'Transaction was last edited on..',
    'rule_trigger_updated_at_on'                                                => 'Transaction was last edited on ":trigger_value"',
    'rule_trigger_budget_is_choice'                                             => 'Ngân sách là..',
    'rule_trigger_budget_is'                                                    => 'Ngân sách là ":trigger_value"',
    'rule_trigger_tag_is_choice'                                                => 'Any tag is..',
    'rule_trigger_tag_is'                                                       => 'Any tag is ":trigger_value"',
    'rule_trigger_tag_contains_choice'                                          => 'Any tag contains..',
    'rule_trigger_tag_contains'                                                 => 'Any tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                                              => 'Any tag ends with..',
    'rule_trigger_tag_ends'                                                     => 'Any tag ends with ":trigger_value"',
    'rule_trigger_tag_starts_choice'                                            => 'Any tag starts with..',
    'rule_trigger_tag_starts'                                                   => 'Any tag starts with ":trigger_value"',
    'rule_trigger_currency_is_choice'                                           => 'Tiền tệ giao dịch là..',
    'rule_trigger_currency_is'                                                  => 'Tiền tệ giao dịch là ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'                                   => 'Giao dịch ngoại tệ là..',
    'rule_trigger_foreign_currency_is'                                          => 'Giao dịch ngoại tệ là ":trigger_value"',
    'rule_trigger_has_attachments_choice'                                       => 'Has any attachments',
    'rule_trigger_has_attachments'                                              => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                                       => 'Không có danh mục',
    'rule_trigger_has_no_category'                                              => 'Giao dịch không có danh mục',
    'rule_trigger_has_any_category_choice'                                      => 'Có một danh mục (bất kỳ)',
    'rule_trigger_has_any_category'                                             => 'Giao dịch có một danh mục (bất kỳ)',
    'rule_trigger_has_no_budget_choice'                                         => 'Không có ngân sách',
    'rule_trigger_has_no_budget'                                                => 'Giao dịch không có ngân sách',
    'rule_trigger_has_any_budget_choice'                                        => 'Có ngân sách (bất kỳ)',
    'rule_trigger_has_any_budget'                                               => 'Giao dịch có ngân sách (bất kỳ)',
    'rule_trigger_has_no_bill_choice'                                           => 'Has no subscription',
    'rule_trigger_has_no_bill'                                                  => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                                          => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                                                 => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                                            => 'Không có nhãn',
    'rule_trigger_has_no_tag'                                                   => 'Giao dịch không có nhãn',
    'rule_trigger_has_any_tag_choice'                                           => 'Có một hoặc nhiều nhãn(bất kỳ)',
    'rule_trigger_has_any_tag'                                                  => 'Giao dịch có một hoặc nhiều nhãn(bất kỳ)',
    'rule_trigger_any_notes_choice'                                             => 'Có (bất kỳ) ghi chú',
    'rule_trigger_any_notes'                                                    => 'Giao dịch có (bất kỳ) ghi chú',
    'rule_trigger_no_notes_choice'                                              => 'Không có ghi chú',
    'rule_trigger_no_notes'                                                     => 'Giao dịch không có ghi chú',
    'rule_trigger_notes_is_choice'                                              => 'Notes are..',
    'rule_trigger_notes_is'                                                     => 'Notes are ":trigger_value"',
    'rule_trigger_notes_contains_choice'                                        => 'Notes contain..',
    'rule_trigger_notes_contains'                                               => 'Notes contain ":trigger_value"',
    'rule_trigger_notes_starts_choice'                                          => 'Notes start with..',
    'rule_trigger_notes_starts'                                                 => 'Notes start with ":trigger_value"',
    'rule_trigger_notes_ends_choice'                                            => 'Notes end with..',
    'rule_trigger_notes_ends'                                                   => 'Notes end with ":trigger_value"',
    'rule_trigger_bill_is_choice'                                               => 'Subscription is..',
    'rule_trigger_bill_is'                                                      => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                                        => 'External ID is..',
    'rule_trigger_external_id_is'                                               => 'External ID is ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'                                 => 'Internal reference is..',
    'rule_trigger_internal_reference_is'                                        => 'Internal reference is ":trigger_value"',
    'rule_trigger_journal_id_choice'                                            => 'Transaction journal ID is..',
    'rule_trigger_journal_id'                                                   => 'Transaction journal ID is ":trigger_value"',
    'rule_trigger_any_external_url'                                             => 'Transaction has an (any) external URL',
    'rule_trigger_any_external_url_choice'                                      => 'Transaction has an (any) external URL',
    'rule_trigger_any_external_id'                                              => 'Transaction has an (any) external ID',
    'rule_trigger_any_external_id_choice'                                       => 'Transaction has an (any) external ID',
    'rule_trigger_no_external_url_choice'                                       => 'Transaction has no external URL',
    'rule_trigger_no_external_url'                                              => 'Transaction has no external URL',
    'rule_trigger_no_external_id_choice'                                        => 'Transaction has no external ID',
    'rule_trigger_no_external_id'                                               => 'Transaction has no external ID',
    'rule_trigger_id_choice'                                                    => 'Transaction ID is..',
    'rule_trigger_id'                                                           => 'Transaction ID is ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                                            => 'SEPA CT is..',
    'rule_trigger_sepa_ct_is'                                                   => 'SEPA CT is ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                                           => 'User action is ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                                            => 'No tag is..',
    'rule_trigger_tag_is_not'                                                   => 'No tag is ":trigger_value"',
    'rule_trigger_account_is_choice'                                            => 'Either account is exactly..',
    'rule_trigger_account_is'                                                   => 'Either account is exactly ":trigger_value"',
    'rule_trigger_account_contains_choice'                                      => 'Either account contains..',
    'rule_trigger_account_contains'                                             => 'Either account contains ":trigger_value"',
    'rule_trigger_account_ends_choice'                                          => 'Either account ends with..',
    'rule_trigger_account_ends'                                                 => 'Either account ends with ":trigger_value"',
    'rule_trigger_account_starts_choice'                                        => 'Either account starts with..',
    'rule_trigger_account_starts'                                               => 'Either account starts with ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                                         => 'Either account number / IBAN is..',
    'rule_trigger_account_nr_is'                                                => 'Either account number / IBAN is ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'                                   => 'Either account number / IBAN contains..',
    'rule_trigger_account_nr_contains'                                          => 'Either account number / IBAN contains ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                                       => 'Either account number / IBAN ends with..',
    'rule_trigger_account_nr_ends'                                              => 'Either account number / IBAN ends with ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'                                     => 'Either account number / IBAN starts with..',
    'rule_trigger_account_nr_starts'                                            => 'Either account number / IBAN starts with ":trigger_value"',
    'rule_trigger_category_contains_choice'                                     => 'Category contains..',
    'rule_trigger_category_contains'                                            => 'Category contains ":trigger_value"',
    'rule_trigger_category_ends_choice'                                         => 'Category ends with..',
    'rule_trigger_category_ends'                                                => 'Category ends with ":trigger_value"',
    'rule_trigger_category_starts_choice'                                       => 'Category starts with..',
    'rule_trigger_category_starts'                                              => 'Category starts with ":trigger_value"',
    'rule_trigger_budget_contains_choice'                                       => 'Budget contains..',
    'rule_trigger_budget_contains'                                              => 'Budget contains ":trigger_value"',
    'rule_trigger_budget_ends_choice'                                           => 'Budget ends with..',
    'rule_trigger_budget_ends'                                                  => 'Budget ends with ":trigger_value"',
    'rule_trigger_budget_starts_choice'                                         => 'Budget starts with..',
    'rule_trigger_budget_starts'                                                => 'Budget starts with ":trigger_value"',
    'rule_trigger_bill_contains_choice'                                         => 'Subscription contains..',
    'rule_trigger_bill_contains'                                                => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                                             => 'Subscription ends with..',
    'rule_trigger_bill_ends'                                                    => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                                           => 'Subscription starts with..',
    'rule_trigger_bill_starts'                                                  => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'                                  => 'External ID contains..',
    'rule_trigger_external_id_contains'                                         => 'External ID contains ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                                      => 'External ID ends with..',
    'rule_trigger_external_id_ends'                                             => 'External ID ends with ":trigger_value"',
    'rule_trigger_external_id_starts_choice'                                    => 'External ID starts with..',
    'rule_trigger_external_id_starts'                                           => 'External ID starts with ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'                           => 'Internal reference contains..',
    'rule_trigger_internal_reference_contains'                                  => 'Internal reference contains ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'                               => 'Internal reference ends with..',
    'rule_trigger_internal_reference_ends'                                      => 'Internal reference ends with ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'                             => 'Internal reference starts with..',
    'rule_trigger_internal_reference_starts'                                    => 'Internal reference starts with ":trigger_value"',
    'rule_trigger_external_url_is_choice'                                       => 'External URL is..',
    'rule_trigger_external_url_is'                                              => 'External URL is ":trigger_value"',
    'rule_trigger_external_url_contains_choice'                                 => 'External URL contains..',
    'rule_trigger_external_url_contains'                                        => 'External URL contains ":trigger_value"',
    'rule_trigger_external_url_ends_choice'                                     => 'External URL ends with..',
    'rule_trigger_external_url_ends'                                            => 'External URL ends with ":trigger_value"',
    'rule_trigger_external_url_starts_choice'                                   => 'External URL starts with..',
    'rule_trigger_external_url_starts'                                          => 'External URL starts with ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'                                    => 'Has no attachments',
    'rule_trigger_has_no_attachments'                                           => 'Transaction has no attachments',
    'rule_trigger_recurrence_id_choice'                                         => 'Recurring transaction ID is..',
    'rule_trigger_recurrence_id'                                                => 'Recurring transaction ID is ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                                      => 'Interest date is on..',
    'rule_trigger_interest_date_on'                                             => 'Interest date is on ":trigger_value"',
    'rule_trigger_interest_date_before_choice'                                  => 'Interest date is before..',
    'rule_trigger_interest_date_before'                                         => 'Interest date is before ":trigger_value"',
    'rule_trigger_interest_date_after_choice'                                   => 'Interest date is after..',
    'rule_trigger_interest_date_after'                                          => 'Interest date is after ":trigger_value"',
    'rule_trigger_book_date_on_choice'                                          => 'Book date is on..',
    'rule_trigger_book_date_on'                                                 => 'Book date is on ":trigger_value"',
    'rule_trigger_book_date_before_choice'                                      => 'Book date is before..',
    'rule_trigger_book_date_before'                                             => 'Book date is before ":trigger_value"',
    'rule_trigger_book_date_after_choice'                                       => 'Book date is after..',
    'rule_trigger_book_date_after'                                              => 'Book date is after ":trigger_value"',
    'rule_trigger_process_date_on_choice'                                       => 'Process date is on..',
    'rule_trigger_process_date_on'                                              => 'Process date is ":trigger_value"',
    'rule_trigger_process_date_before_choice'                                   => 'Process date is before..',
    'rule_trigger_process_date_before'                                          => 'Process date is before ":trigger_value"',
    'rule_trigger_process_date_after_choice'                                    => 'Process date is after..',
    'rule_trigger_process_date_after'                                           => 'Process date is after ":trigger_value"',
    'rule_trigger_due_date_on_choice'                                           => 'Due date is on..',
    'rule_trigger_due_date_on'                                                  => 'Due date is on ":trigger_value"',
    'rule_trigger_due_date_before_choice'                                       => 'Due date is before..',
    'rule_trigger_due_date_before'                                              => 'Due date is before ":trigger_value"',
    'rule_trigger_due_date_after_choice'                                        => 'Due date is after..',
    'rule_trigger_due_date_after'                                               => 'Due date is after ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                                       => 'Payment date is on..',
    'rule_trigger_payment_date_on'                                              => 'Payment date is on ":trigger_value"',
    'rule_trigger_payment_date_before_choice'                                   => 'Payment date is before..',
    'rule_trigger_payment_date_before'                                          => 'Payment date is before ":trigger_value"',
    'rule_trigger_payment_date_after_choice'                                    => 'Payment date is after..',
    'rule_trigger_payment_date_after'                                           => 'Payment date is after ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                                       => 'Invoice date is on..',
    'rule_trigger_invoice_date_on'                                              => 'Invoice date is on ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'                                   => 'Invoice date is before..',
    'rule_trigger_invoice_date_before'                                          => 'Invoice date is before ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'                                    => 'Invoice date is after..',
    'rule_trigger_invoice_date_after'                                           => 'Invoice date is after ":trigger_value"',
    'rule_trigger_created_at_before_choice'                                     => 'Transaction was created before..',
    'rule_trigger_created_at_before'                                            => 'Transaction was created before ":trigger_value"',
    'rule_trigger_created_at_after_choice'                                      => 'Transaction was created after..',
    'rule_trigger_created_at_after'                                             => 'Transaction was created after ":trigger_value"',
    'rule_trigger_updated_at_before_choice'                                     => 'Transaction was last updated before..',
    'rule_trigger_updated_at_before'                                            => 'Transaction was last updated before ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                                      => 'Transaction was last updated after..',
    'rule_trigger_updated_at_after'                                             => 'Transaction was last updated after ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'                                     => 'Foreign amount is exactly..',
    'rule_trigger_foreign_amount_is'                                            => 'Foreign amount is exactly ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'                                   => 'Foreign amount is less than..',
    'rule_trigger_foreign_amount_less'                                          => 'Foreign amount is less than ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'                                   => 'Foreign amount is more than..',
    'rule_trigger_foreign_amount_more'                                          => 'Foreign amount is more than ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'                                    => 'Any attachment\'s name is..',
    'rule_trigger_attachment_name_is'                                           => 'Any attachment\'s name is ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'                              => 'Any attachment\'s name contains..',
    'rule_trigger_attachment_name_contains'                                     => 'Any attachment\'s name contains ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'                                => 'Any attachment\'s name starts with..',
    'rule_trigger_attachment_name_starts'                                       => 'Any attachment\'s name starts with ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'                                  => 'Any attachment\'s name ends with..',
    'rule_trigger_attachment_name_ends'                                         => 'Any attachment\'s name ends with ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'                                  => 'Any attachment\'s notes are..',
    'rule_trigger_attachment_notes_are'                                         => 'Any attachment\'s notes are ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'                             => 'Any attachment\'s notes contain..',
    'rule_trigger_attachment_notes_contains'                                    => 'Any attachment\'s notes contain ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'                               => 'Any attachment\'s notes start with..',
    'rule_trigger_attachment_notes_starts'                                      => 'Any attachment\'s notes start with ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'                                 => 'Any attachment\'s notes end with..',
    'rule_trigger_attachment_notes_ends'                                        => 'Any attachment\'s notes end with ":trigger_value"',
    'rule_trigger_reconciled_choice'                                            => 'Transaction is reconciled',
    'rule_trigger_reconciled'                                                   => 'Transaction is reconciled',
    'rule_trigger_exists_choice'                                                => 'Any transaction matches(!)',
    'rule_trigger_exists'                                                       => 'Any transaction matches',

    // more values for new types:
    'rule_trigger_not_account_id'                                               => 'Account ID is not ":trigger_value"',
    'rule_trigger_not_source_account_id'                                        => 'Source account ID is not ":trigger_value"',
    'rule_trigger_not_destination_account_id'                                   => 'Destination account ID is not ":trigger_value"',
    'rule_trigger_not_transaction_type'                                         => 'Transaction type is not ":trigger_value"',
    'rule_trigger_not_tag_is'                                                   => 'Tag is not ":trigger_value"',
    'rule_trigger_not_tag_is_not'                                               => 'Tag is ":trigger_value"',
    'rule_trigger_not_description_is'                                           => 'Description is not ":trigger_value"',
    'rule_trigger_not_description_contains'                                     => 'Description does not contain',
    'rule_trigger_not_description_ends'                                         => 'Description does not end with ":trigger_value"',
    'rule_trigger_not_description_starts'                                       => 'Description does not start with ":trigger_value"',
    'rule_trigger_not_notes_is'                                                 => 'Notes are not ":trigger_value"',
    'rule_trigger_not_notes_contains'                                           => 'Notes do not contain ":trigger_value"',
    'rule_trigger_not_notes_ends'                                               => 'Notes do not end on ":trigger_value"',
    'rule_trigger_not_notes_starts'                                             => 'Notes do not start with ":trigger_value"',
    'rule_trigger_not_source_account_is'                                        => 'Source account is not ":trigger_value"',
    'rule_trigger_not_source_account_contains'                                  => 'Source account does not contain ":trigger_value"',
    'rule_trigger_not_source_account_ends'                                      => 'Source account does not end on ":trigger_value"',
    'rule_trigger_not_source_account_starts'                                    => 'Source account does not start with ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'                                     => 'Source account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'                               => 'Source account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'                                   => 'Source account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'                                 => 'Source account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_is'                                   => 'Destination account is not ":trigger_value"',
    'rule_trigger_not_destination_account_contains'                             => 'Destination account does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_ends'                                 => 'Destination account does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_starts'                               => 'Destination account does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'                                => 'Destination account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'                          => 'Destination account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'                              => 'Destination account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'                            => 'Destination account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_account_is'                                               => 'Neither account is ":trigger_value"',
    'rule_trigger_not_account_contains'                                         => 'Neither account contains ":trigger_value"',
    'rule_trigger_not_account_ends'                                             => 'Neither account ends on ":trigger_value"',
    'rule_trigger_not_account_starts'                                           => 'Neither account starts with ":trigger_value"',
    'rule_trigger_not_account_nr_is'                                            => 'Neither account number / IBAN is ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                                      => 'Neither account number / IBAN contains ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                                          => 'Neither account number / IBAN ends on ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                                        => 'Neither account number / IBAN starts with ":trigger_value"',
    'rule_trigger_not_category_is'                                              => 'Category is not ":trigger_value"',
    'rule_trigger_not_category_contains'                                        => 'Category does not contain ":trigger_value"',
    'rule_trigger_not_category_ends'                                            => 'Category does not end on ":trigger_value"',
    'rule_trigger_not_category_starts'                                          => 'Category does not start with ":trigger_value"',
    'rule_trigger_not_budget_is'                                                => 'Budget is not ":trigger_value"',
    'rule_trigger_not_budget_contains'                                          => 'Budget does not contain ":trigger_value"',
    'rule_trigger_not_budget_ends'                                              => 'Budget does not end on ":trigger_value"',
    'rule_trigger_not_budget_starts'                                            => 'Budget does not start with ":trigger_value"',
    'rule_trigger_not_bill_is'                                                  => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                                            => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                                                => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                                              => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                                           => 'External ID is not ":trigger_value"',
    'rule_trigger_not_external_id_contains'                                     => 'External ID does not contain ":trigger_value"',
    'rule_trigger_not_external_id_ends'                                         => 'External ID does not end on ":trigger_value"',
    'rule_trigger_not_external_id_starts'                                       => 'External ID does not start with ":trigger_value"',
    'rule_trigger_not_internal_reference_is'                                    => 'Internal reference is not ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'                              => 'Internal reference does not contain ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'                                  => 'Internal reference does not end on ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'                                => 'Internal reference does not start with ":trigger_value"',
    'rule_trigger_not_external_url_is'                                          => 'External URL is not ":trigger_value"',
    'rule_trigger_not_external_url_contains'                                    => 'External URL does not contain ":trigger_value"',
    'rule_trigger_not_external_url_ends'                                        => 'External URL does not end on ":trigger_value"',
    'rule_trigger_not_external_url_starts'                                      => 'External URL does not start with ":trigger_value"',
    'rule_trigger_not_currency_is'                                              => 'Currency is not ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                                      => 'Foreign currency is not ":trigger_value"',
    'rule_trigger_not_id'                                                       => 'Transaction ID is not ":trigger_value"',
    'rule_trigger_not_journal_id'                                               => 'Transaction journal ID is not ":trigger_value"',
    'rule_trigger_not_recurrence_id'                                            => 'Recurrence ID is not ":trigger_value"',
    'rule_trigger_not_date_on'                                                  => 'Date is not on ":trigger_value"',
    'rule_trigger_not_date_before'                                              => 'Date is not before ":trigger_value"',
    'rule_trigger_not_date_after'                                               => 'Date is not after ":trigger_value"',
    'rule_trigger_not_interest_date_on'                                         => 'Interest date is not on ":trigger_value"',
    'rule_trigger_not_interest_date_before'                                     => 'Interest date is not before ":trigger_value"',
    'rule_trigger_not_interest_date_after'                                      => 'Interest date is not after ":trigger_value"',
    'rule_trigger_not_book_date_on'                                             => 'Book date is not on ":trigger_value"',
    'rule_trigger_not_book_date_before'                                         => 'Book date is not before ":trigger_value"',
    'rule_trigger_not_book_date_after'                                          => 'Book date is not after ":trigger_value"',
    'rule_trigger_not_process_date_on'                                          => 'Process date is not on ":trigger_value"',
    'rule_trigger_not_process_date_before'                                      => 'Process date is not before ":trigger_value"',
    'rule_trigger_not_process_date_after'                                       => 'Process date is not after ":trigger_value"',
    'rule_trigger_not_due_date_on'                                              => 'Due date is not on ":trigger_value"',
    'rule_trigger_not_due_date_before'                                          => 'Due date is not before ":trigger_value"',
    'rule_trigger_not_due_date_after'                                           => 'Due date is not after ":trigger_value"',
    'rule_trigger_not_payment_date_on'                                          => 'Payment date is not on ":trigger_value"',
    'rule_trigger_not_payment_date_before'                                      => 'Payment date is not before ":trigger_value"',
    'rule_trigger_not_payment_date_after'                                       => 'Payment date is not after ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                                          => 'Invoice date is not on ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                                      => 'Invoice date is not before ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                                       => 'Invoice date is not after ":trigger_value"',
    'rule_trigger_not_created_at_on'                                            => 'Transaction is not created on ":trigger_value"',
    'rule_trigger_not_created_at_before'                                        => 'Transaction is not created before ":trigger_value"',
    'rule_trigger_not_created_at_after'                                         => 'Transaction is not created after ":trigger_value"',
    'rule_trigger_not_updated_at_on'                                            => 'Transaction is not updated on ":trigger_value"',
    'rule_trigger_not_updated_at_before'                                        => 'Transaction is not updated before ":trigger_value"',
    'rule_trigger_not_updated_at_after'                                         => 'Transaction is not updated after ":trigger_value"',
    'rule_trigger_not_amount_is'                                                => 'Transaction amount is not ":trigger_value"',
    'rule_trigger_not_amount_less'                                              => 'Transaction amount is more than ":trigger_value"',
    'rule_trigger_not_amount_more'                                              => 'Transaction amount is less than ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                                        => 'Foreign transaction amount is not ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                                      => 'Foreign transaction amount is more than ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                                      => 'Foreign transaction amount is less than ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                                       => 'No attachment is named ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'                                 => 'No attachment name contains ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'                                   => 'No attachment name starts with ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'                                     => 'No attachment name ends on ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'                                     => 'No attachment notes are ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'                                => 'No attachment notes contain ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'                                  => 'No attachment notes start with ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'                                    => 'No attachment notes end on ":trigger_value"',
    'rule_trigger_not_reconciled'                                               => 'Transaction is not reconciled',
    'rule_trigger_not_exists'                                                   => 'Transaction does not exist',
    'rule_trigger_not_has_attachments'                                          => 'Transaction has no attachments',
    'rule_trigger_not_has_any_category'                                         => 'Transaction has no category',
    'rule_trigger_not_has_any_budget'                                           => 'Transaction has no budget',
    'rule_trigger_not_has_any_bill'                                             => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                                              => 'Transaction has no tags',
    'rule_trigger_not_any_notes'                                                => 'Transaction has no notes',
    'rule_trigger_not_any_external_url'                                         => 'Transaction has no external URL',
    'rule_trigger_not_has_no_attachments'                                       => 'Transaction has a (any) attachment(s)',
    'rule_trigger_not_has_no_category'                                          => 'Transaction has a (any) category',
    'rule_trigger_not_has_no_budget'                                            => 'Transaction has a (any) budget',
    'rule_trigger_not_has_no_bill'                                              => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                                               => 'Transaction has a (any) tag',
    'rule_trigger_not_no_notes'                                                 => 'Transaction has any notes',
    'rule_trigger_not_no_external_url'                                          => 'Transaction has an external URL',
    'rule_trigger_not_source_is_cash'                                           => 'Source account is not a cash account',
    'rule_trigger_not_destination_is_cash'                                      => 'Destination account is not a cash account',
    'rule_trigger_not_account_is_cash'                                          => 'Neither account is a cash account',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'                                => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'                               => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'                                => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'                                => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'                               => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'                                     => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice'                                    => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'                                     => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'                                     => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice'                                    => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'                                       => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte'                                      => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'                                       => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'                                       => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte'                                      => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'                                            => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'                                           => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'                                            => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'                                            => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'                                           => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'                                   => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte'                                  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'                                   => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'                                   => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte'                                  => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'                                        => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'                                       => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'                                        => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'                                        => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'                                       => 'Source account balance is more than :trigger_value',



    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'                                     => 'DELETE transaction(!)',
    'rule_action_delete_transaction'                                            => 'DELETE transaction(!)',
    'rule_action_set_category'                                                  => 'Đặt danh mục thành ":action_value"',
    'rule_action_clear_category'                                                => 'Xóa danh mục',
    'rule_action_set_budget'                                                    => 'Đặt ngân sách thành ":action_value"',
    'rule_action_clear_budget'                                                  => 'Xóa ngân sách',
    'rule_action_add_tag'                                                       => 'Thêm nhãn ":action_value"',
    'rule_action_remove_tag'                                                    => 'Xóa nhãn ":action_value"',
    'rule_action_remove_all_tags'                                               => 'Xóa tất cả các nhãn',
    'rule_action_set_description'                                               => 'Đặt mô tả thành ":action_value"',
    'rule_action_append_description'                                            => 'Nối mô tả với ":action_value"',
    'rule_action_prepend_description'                                           => 'Chuẩn bị mô tả với":action_value"',
    'rule_action_set_category_choice'                                           => 'Set category to ..',
    'rule_action_clear_category_choice'                                         => 'Xóa mọi danh mục',
    'rule_action_set_budget_choice'                                             => 'Set budget to ..',
    'rule_action_clear_budget_choice'                                           => 'Xóa mọi ngân sách',
    'rule_action_add_tag_choice'                                                => 'Add tag ..',
    'rule_action_remove_tag_choice'                                             => 'Remove tag ..',
    'rule_action_remove_all_tags_choice'                                        => 'Xóa tất cả các nhãn',
    'rule_action_set_description_choice'                                        => 'Set description to ..',
    'rule_action_update_piggy_choice'                                           => 'Add / remove transaction amount in piggy bank ..',
    'rule_action_update_piggy'                                                  => 'Add / remove transaction amount in piggy bank ":action_value"',
    'rule_action_append_description_choice'                                     => 'Append description with ..',
    'rule_action_prepend_description_choice'                                    => 'Prepend description with ..',
    'rule_action_set_source_account_choice'                                     => 'Set source account to ..',
    'rule_action_set_source_account'                                            => 'Đặt tài khoản nguồn thành :action_value',
    'rule_action_set_destination_account_choice'                                => 'Set destination account to ..',
    'rule_action_set_destination_account'                                       => 'Đặt tài khoản đích thành :action_value',
    'rule_action_append_notes_choice'                                           => 'Append notes with ..',
    'rule_action_append_notes'                                                  => 'Nối ghi chú với ":action_value"',
    'rule_action_prepend_notes_choice'                                          => 'Prepend notes with ..',
    'rule_action_prepend_notes'                                                 => 'Chuẩn bị ghi chú với ":action_value"',
    'rule_action_clear_notes_choice'                                            => 'Xóa mọi ghi chú',
    'rule_action_clear_notes'                                                   => 'Xóa mọi ghi chú',
    'rule_action_set_notes_choice'                                              => 'Set notes to ..',
    'rule_action_link_to_bill_choice'                                           => 'Link to a subscription ..',
    'rule_action_link_to_bill'                                                  => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'                                        => 'Switch source and destination accounts (transfers only!)',
    'rule_action_switch_accounts'                                               => 'Switch source and destination',
    'rule_action_set_notes'                                                     => 'Đặt ghi chú cho ":action_value"',
    'rule_action_convert_deposit_choice'                                        => 'Chuyển đổi giao dịch thành tiền gửi',
    'rule_action_convert_deposit'                                               => 'Chuyển đổi giao dịch thành tiền gửi từ ":action_value"',
    'rule_action_convert_withdrawal_choice'                                     => 'Chuyển đổi giao dịch sang rút tiền',
    'rule_action_convert_withdrawal'                                            => 'Chuyển đổi giao dịch thành rút tiền sang ":action_value"',
    'rule_action_convert_transfer_choice'                                       => 'Chuyển đổi giao dịch sang chuyển khoản',
    'rule_action_convert_transfer'                                              => 'Chuyển đổi giao dịch sang chuyển khoản với ":action_value"',
    'rule_action_append_descr_to_notes_choice'                                  => 'Append the description to the transaction notes',
    'rule_action_append_notes_to_descr_choice'                                  => 'Append the transaction notes to the description',
    'rule_action_move_descr_to_notes_choice'                                    => 'Replace the current transaction notes with the description',
    'rule_action_move_notes_to_descr_choice'                                    => 'Replace the current description with the transaction notes',
    'rule_action_append_descr_to_notes'                                         => 'Append description to notes',
    'rule_action_append_notes_to_descr'                                         => 'Append notes to description',
    'rule_action_move_descr_to_notes'                                           => 'Replace notes with description',
    'rule_action_move_notes_to_descr'                                           => 'Replace description with notes',
    'rule_action_set_amount_choice'                                             => 'Set amount to ..',
    'rule_action_set_amount'                                                    => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice'                                => 'Set destination account to (cash)',
    'rule_action_set_source_to_cash_choice'                                     => 'Set source account to (cash)',
    'rulegroup_for_bills_title'                                                 => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'                                           => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                                                       => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                                                 => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                                                      => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                                                  => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                                                   => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'                                             => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                                                => 'Quy tắc dựa trên giao dich ":description"',
    'new_rule_for_journal_description'                                          => 'Quy tắc này dựa trên giao dịch ":description".',

    // tags
    'store_new_tag'                                                             => 'Lưu trữ nhãn mới',
    'update_tag'                                                                => 'Cập nhật nhãn',
    'no_location_set'                                                           => 'Không có vị trí được đặt.',
    'meta_data'                                                                 => 'Meta data',
    'location'                                                                  => 'Vị trí',
    'location_first_split'                                                      => 'The location for this transaction can be set on the first split of this transaction.',
    'without_date'                                                              => 'Không có ngày',
    'result'                                                                    => 'Kết quả',
    'sums_apply_to_range'                                                       => 'Tất cả các khoản tiền áp dụng cho phạm vi đã chọn',
    'mapbox_api_key'                                                            => 'Để sử dụng bản đồ, hãy lấy khóa API từ <a href="https://www.mapbox.com/">Mapbox</a>. Open your <code>.env</code> tập tin và nhập mã này sau <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                                                     => 'Nhấp chuột phải hoặc nhấn lâu để đặt vị trí của đối tượng.',
    'click_tap_location'                                                        => 'Click or tap the map to add a location',
    'clear_location'                                                            => 'Xóa vị trí',
    'delete_all_selected_tags'                                                  => 'Xóa tất cả các nhãn đã chọn',
    'select_tags_to_delete'                                                     => 'Đừng quên chọn một số nhãn.',
    'deleted_x_tags'                                                            => 'Xóa nhãn :count.',
    'create_rule_from_transaction'                                              => 'Tạo quy tắc dựa trên giao dịch',
    'create_recurring_from_transaction'                                         => 'Create recurring transaction based on transaction',

    // preferences
    'test_notifications_buttons'                                                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                                                  => 'Let your browser decide',
    'dark_mode_option_light'                                                    => 'Always light',
    'dark_mode_option_dark'                                                     => 'Always dark',
    'equal_to_language'                                                         => '(bằng ngôn ngữ)',
    'dark_mode_preference'                                                      => 'Dark mode',
    'dark_mode_preference_help'                                                 => 'Tell Firefly III when to use dark mode.',
    'pref_home_screen_accounts'                                                 => 'Tài khoản màn hình chính',
    'pref_home_screen_accounts_help'                                            => 'Những tài khoản nào sẽ được hiển thị trên trang chủ?',
    'pref_view_range'                                                           => 'Xem nhiều',
    'pref_view_range_help'                                                      => 'Một số biểu đồ được tự động nhóm trong các giai đoạn. Ngân sách của bạn cũng sẽ được nhóm theo thời gian. Bạn thích thời gian nào?',
    'pref_1D'                                                                   => 'Một ngày',
    'pref_1W'                                                                   => 'Một tuần',
    'pref_1M'                                                                   => 'Một tháng',
    'pref_3M'                                                                   => 'Ba tháng (quý)',
    'pref_6M'                                                                   => 'Sáu tháng',
    'pref_1Y'                                                                   => 'Một năm',
    'pref_last365'                                                              => 'Năm trước',
    'pref_last90'                                                               => '90 ngày cuối',
    'pref_last30'                                                               => '30 ngày cuối',
    'pref_last7'                                                                => '7 ngày trước',
    'pref_YTD'                                                                  => 'Year to date',
    'pref_QTD'                                                                  => 'Quarter to date',
    'pref_MTD'                                                                  => 'Month to date',
    'pref_languages'                                                            => 'Ngôn ngữ',
    'pref_locale'                                                               => 'Thiết lập địa phương',
    'pref_languages_help'                                                       => 'Firefly III hỗ trợ một số ngôn ngữ. Bạn thích cái nào hơn?',
    'pref_locale_help'                                                          => 'Firefly III cho phép bạn đặt các cài đặt cục bộ khác, như cách định dạng tiền tệ, số và ngày. Các mục trong danh sách này có thể không được hệ thống của bạn hỗ trợ. Firefly III không có cài đặt ngày chính xác cho mọi miền; liên hệ với tôi để cải thiện.',
    'pref_locale_no_demo'                                                       => 'Tính năng này sẽ không hoạt động cho người dùng demo.',
    'pref_convert_to_native'                                                    => 'Display amounts in your native currency',
    'pref_convert_to_native_help'                                               => 'This option will make Firefly III try to display and show your native currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_native_help'                                                  => 'Display native amounts',
    'pref_custom_fiscal_year'                                                   => 'Cài đặt năm tài chính',
    'pref_custom_fiscal_year_label'                                             => 'Đã bật',
    'pref_custom_fiscal_year_help'                                              => 'Ở các quốc gia sử dụng năm tài chính khác từ ngày 1 tháng 1 đến ngày 31 tháng 12, bạn có thể bật tính năng này và chỉ định ngày bắt đầu / ngày kết thúc của năm tài chính',
    'pref_fiscal_year_start_label'                                              => 'Ngày bắt đầu năm tài chính',
    'pref_two_factor_auth'                                                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                                                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'                                               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'                                             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'                                            => 'Đừng quên xóa tài khoản khỏi ứng dụng xác thực của bạn!',
    'pref_two_factor_auth_code'                                                 => 'Mã xác minh',
    'pref_two_factor_auth_code_help'                                            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'                                           => 'Đặt lại mã xác minh',
    'pref_two_factor_auth_disable_2fa'                                          => 'Disable MFA',
    '2fa_use_secret_instead'                                                    => 'Nếu bạn không thể quét mã QR, thay vào đó hãy sử dụng bí mật: <code>:secret</code>.',
    '2fa_backup_codes'                                                          => 'Lưu trữ các mã dự phòng này để truy cập trong trường hợp bạn mất thiết bị.',
    '2fa_already_enabled'                                                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                                                            => 'Mã MFA này không hợp lệ.',
    'pref_save_settings'                                                        => 'Lưu các thiết lập',
    'saved_preferences'                                                         => 'Đã lưu tùy chọn!',
    'preferences_general'                                                       => 'Chung',
    'preferences_frontpage'                                                     => 'Màn hình chính',
    'preferences_security'                                                      => 'Bảo mật',
    'preferences_layout'                                                        => 'Bố trí',
    'preferences_notifications'                                                 => 'Notifications',
    'pref_home_show_deposits'                                                   => 'Hiển thị tiền gửi trên màn hình chính',
    'pref_home_show_deposits_info'                                              => 'Màn hình chính đã hiển thị các tài khoản chi phí của bạn. Nó cũng sẽ hiển thị tài khoản doanh thu của bạn?',
    'pref_home_do_show_deposits'                                                => 'Vâng, hiện chúng',
    'successful_count'                                                          => 'trong :count thành công',
    'list_page_size_title'                                                      => 'Kích thước trang',
    'list_page_size_help'                                                       => 'Bất kỳ danh sách các thứ (tài khoản, giao dịch, v.v.) đều hiển thị nhiều nhất trên mỗi trang.',
    'list_page_size_label'                                                      => 'Kích thước trang',
    'between_dates'                                                             => '(:start và :end)',
    'pref_optional_fields_transaction'                                          => 'Các trường tùy chọn cho giao dịch',
    'pref_optional_fields_transaction_help'                                     => 'Theo mặc định, không phải tất cả các trường đều được bật khi tạo giao dịch mới (vì sự lộn xộn). Dưới đây, bạn có thể kích hoạt các trường này nếu bạn nghĩ rằng chúng có thể hữu ích cho bạn. Tất nhiên, bất kỳ trường nào bị vô hiệu hóa, nhưng đã được điền vào, sẽ hiển thị bất kể cài đặt.',
    'optional_tj_date_fields'                                                   => 'Trường ngày',
    'optional_tj_other_fields'                                                  => 'Các dữ liệu khác',
    'optional_tj_attachment_fields'                                             => 'Trường đính kèm',
    'pref_optional_tj_interest_date'                                            => 'Ngày lãi',
    'pref_optional_tj_book_date'                                                => 'Ngày đặt sách',
    'pref_optional_tj_process_date'                                             => 'Ngày xử lý',
    'pref_optional_tj_due_date'                                                 => 'Ngày đáo hạn',
    'pref_optional_tj_payment_date'                                             => 'Ngày thanh toán',
    'pref_optional_tj_invoice_date'                                             => 'Ngày hóa đơn',
    'pref_optional_tj_internal_reference'                                       => 'Tài liệu tham khảo nội bộ',
    'pref_optional_tj_notes'                                                    => 'Ghi chú',
    'pref_optional_tj_attachments'                                              => 'Tài liệu đính kèm',
    'pref_optional_tj_external_url'                                             => 'URL bên ngoài',
    'pref_optional_tj_location'                                                 => 'Vị trí',
    'pref_optional_tj_links'                                                    => 'Liên kết giao dịch',
    'optional_field_meta_dates'                                                 => 'Ngày',
    'optional_field_meta_business'                                              => 'Kinh doanh',
    'optional_field_attachments'                                                => 'Tài liệu đính kèm',
    'optional_field_meta_data'                                                  => 'Dữ liệu meta tùy chọn',
    'external_url'                                                              => 'URL bên ngoài',
    'pref_notification_login_failure'                                           => 'Login failure',
    'pref_notification_bill_reminder'                                           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'                                        => 'Alert when a new API access token is created',
    'pref_notification_transaction_creation'                                    => 'Alert when a transaction is created automatically',
    'pref_notification_user_login'                                              => 'Alert when you login from a new location',
    'pref_notification_rule_action_failures'                                    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'                                            => 'Your password changed',
    'pref_notification_enabled_mfa'                                             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'                                            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'                                            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'                                             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'                                         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'                                        => 'New backup codes have been generated',
    'pref_notifications'                                                        => 'Notifications',
    'pref_notifications_help'                                                   => 'Indicate if these are notifications you would like to get. Some notifications may contain sensitive financial information.',
    'pref_notifications_settings'                                               => 'Notifications settings',
    'pref_notifications_settings_help'                                          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                                                           => 'Slack "incoming webhook" URL',
    'discord_url_label'                                                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                                                 => 'Exchange rates',
    'header_exchange_rates'                                                     => 'Exchange rates',
    'exchange_rates_intro'                                                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                                                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'                                               => 'Exchange rates',
    'exchange_rates_intro_rates'                                                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'                                               => 'Table with exchange rates',
    'help_rate_form'                                                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                                                             => 'Save new rate',
    'add_new_rate'                                                              => 'Add a new exchange rate',
    'not_enough_currencies'                                                     => 'Not enough currencies',
    'not_enough_currencies_enabled'                                             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                                                      => 'Financial administration',
    'administrations_breadcrumb'                                                => 'Financial administrations',
    'administrations_page_title'                                                => 'Financial administrations',
    'administrations_index_menu'                                                => 'Financial administrations',
    'administrations_page_sub_title'                                            => 'Overview',
    'create_administration'                                                     => 'Create new administration',
    'administration_owner'                                                      => 'Administration owner: {{email}}',
    'administration_you'                                                        => 'Your role: {{role}}',
    'other_users_in_admin'                                                      => 'Other users in this administration',
    'administrations_create_breadcrumb'                                         => 'Create new financial administration',
    'administrations_page_create_sub_title'                                     => 'Create new financial administration',
    'basic_administration_information'                                          => 'Basic administration information',
    'new_administration_created'                                                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'                                            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'                                       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'                                    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'                                         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its native currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'                                    => 'Currently, you can only set the "native currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'                                         => 'It may take a long time for the page to load if you change the native currency because transaction may need to be converted to your (new) native currency.',
    'flash_administration_updated'                                              => 'Administration ":title" has been updated',
    'flash_administration_created'                                              => 'Administration ":title" has been created',
    'flash_administration_deleted'                                              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                                                 => 'Owner',
    'administration_role_ro'                                                    => 'Read-only',
    'administration_role_mng_trx'                                               => 'Manage transactions',
    'administration_role_mng_meta'                                              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'                                           => 'Manage budgets',
    'administration_role_mng_piggies'                                           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'                                     => 'Manage subscriptions',
    'administration_role_mng_rules'                                             => 'Manage rules',
    'administration_role_mng_recurring'                                         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'                                          => 'Manage webhooks',
    'administration_role_mng_currencies'                                        => 'Manage currencies',
    'administration_role_view_reports'                                          => 'View reports',
    'administration_role_full'                                                  => 'Full access',

    // mfa
    'enable_mfa'                                                                => 'Enable multi-factor authentication',
    'mfa_index_title'                                                           => 'Multi-factor authentication',
    'mfa_index_intro'                                                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                                                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                                                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                                                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'                                              => 'Enter your current password',
    'mfa_warning_code_changes'                                                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                                                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                                                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                                                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                                                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                                                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                                                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                                                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                                                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'                                               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                                                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                                                          => 'Purge data from Firefly III',
    'purge_data_expl'                                                           => '"Purging" means "deleting that which is already deleted". In normal circumstances, Firefly III deletes nothing permanently. It just hides it. The button below deletes all of these previously "deleted" records FOREVER.',
    'delete_stuff_header'                                                       => 'Delete and purge data',
    'purge_all_data'                                                            => 'Purge all deleted records',
    'purge_data'                                                                => 'Purge data',
    'purged_all_records'                                                        => 'All deleted records have been purged.',
    'delete_data_title'                                                         => 'Delete data from Firefly III',
    'permanent_delete_stuff'                                                    => 'You can delete stuff from Firefly III. Using the buttons below means that your items will be removed from view and hidden. There is no undo-button for this, but the items may remain in the database where you can salvage them if necessary.',
    'other_sessions_logged_out'                                                 => 'All your other sessions have been logged out.',
    'delete_unused_accounts'                                                    => 'Deleting unused accounts will clean your auto-complete lists.',
    'delete_all_unused_accounts'                                                => 'Delete unused accounts',
    'deleted_all_unused_accounts'                                               => 'All unused accounts are deleted',
    'delete_all_budgets'                                                        => 'Xóa TẤT CẢ ngân sách của bạn',
    'delete_all_categories'                                                     => 'Xóa TẤT CẢ danh mục của bạn',
    'delete_all_tags'                                                           => 'Xóa TẤT CẢ các nhãn của bạn',
    'delete_all_bills'                                                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                                                    => 'Xóa TẤT CẢ các ống heo của bạn',
    'delete_all_rules'                                                          => 'Xóa TẤT CẢ các luật của bạn',
    'delete_all_recurring'                                                      => 'Xóa TẤT CẢ các giao dịch định kỳ của bạn',
    'delete_all_object_groups'                                                  => 'Xóa TẤT CẢ các nhóm đối tượng của bạn',
    'delete_all_accounts'                                                       => 'Xóa TẤT CẢ các tài khoản của bạn',
    'delete_all_asset_accounts'                                                 => 'Xóa TẤT CẢ các tài khoản của bạn',
    'delete_all_expense_accounts'                                               => 'Delete ALL your expense accounts',
    'delete_all_revenue_accounts'                                               => 'Delete ALL your revenue accounts',
    'delete_all_liabilities'                                                    => 'Delete ALL your liabilities',
    'delete_all_transactions'                                                   => 'Xóa TẤT CẢ giao dịch của bạn',
    'delete_all_withdrawals'                                                    => 'Delete ALL your withdrawals',
    'delete_all_deposits'                                                       => 'Delete ALL your deposits',
    'delete_all_transfers'                                                      => 'Delete ALL your transfers',
    'also_delete_transactions'                                                  => 'Deleting accounts will also delete ALL associated withdrawals, deposits and transfers!',
    'deleted_all_budgets'                                                       => 'Tất cả ngân sách đã bị xóa',
    'deleted_all_categories'                                                    => 'Tất cả các danh mục đã bị xóa',
    'deleted_all_tags'                                                          => 'Tất cả các nhãn bị xóa',
    'deleted_all_bills'                                                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                                                   => 'Tất cả heo đất đã bị xóa',
    'deleted_all_rules'                                                         => 'Tất cả các quy tắc và nhóm quy tắc đã bị xóa',
    'deleted_all_object_groups'                                                 => 'Tất cả các nhóm đã bị xóa',
    'deleted_all_accounts'                                                      => 'Tất cả các tài khoản đã bị xóa',
    'deleted_all_asset_accounts'                                                => 'Tất cả các tài khoản đã bị xóa',
    'deleted_all_expense_accounts'                                              => 'Tất cả các tài khoản chi phí đã bị xóa',
    'deleted_all_revenue_accounts'                                              => 'Tất cả các tài khoản doanh thu đã bị xóa',
    'deleted_all_liabilities'                                                   => 'Tất cả các khoản nợ đã được xóa',
    'deleted_all_transactions'                                                  => 'Tất cả các giao dịch đã bị xóa',
    'deleted_all_withdrawals'                                                   => 'Tất cả các lần rút tiền đã bị xóa',
    'deleted_all_deposits'                                                      => 'Tất cả các khoản tiền gửi đã bị xóa',
    'deleted_all_transfers'                                                     => 'Tất cả các chuyển khoản đã bị xóa',
    'deleted_all_recurring'                                                     => 'Tất cả các giao dịch định kỳ đã bị xóa',
    'change_your_password'                                                      => 'Thay đổi mật khẩu của bạn',
    'delete_account'                                                            => 'Xóa tài khoản',
    'current_password'                                                          => 'Mật khẩu hiện tại',
    'new_password'                                                              => 'Mật khẩu mới',
    'new_password_again'                                                        => 'Mật khẩu mới (một lần nữa)',
    'delete_your_account'                                                       => 'Xóa tài khoản của bạn',
    'delete_your_account_help'                                                  => 'Xóa tài khoản của bạn cũng sẽ xóa mọi tài khoản, giao dịch, <em>anything</em> bạn đã lưu vào Firefly III.',
    'delete_your_account_password'                                              => 'Nhập mật khẩu của bạn để tiếp tục.',
    'password'                                                                  => 'Mật khẩu',
    'are_you_sure'                                                              => 'Bạn có chắc không? Bạn không thể hoàn tác điều này.',
    'are_you_sure_confirm'                                                      => 'Are you sure?',
    'delete_account_button'                                                     => 'Xóa tài khoản của bạn',
    'invalid_current_password'                                                  => 'Mật khẩu hiện tại không hợp lệ!',
    'password_changed'                                                          => 'Mật khẩu đã được thay đổi!',
    'should_change'                                                             => 'Ý tưởng là thay đổi mật khẩu của bạn.',
    'invalid_password'                                                          => 'Mật khẩu không hợp lệ!',
    'what_is_pw_security'                                                       => '"Xác minh bảo mật mật khẩu" là gì?',
    'secure_pw_title'                                                           => 'Cách chọn mật khẩu an toàn',
    'forgot_password_response'                                                  => 'Cảm ơn bạn. Nếu tài khoản tồn tại với địa chỉ email này, bạn sẽ tìm thấy hướng dẫn trong hộp thư đến của mình.',
    'secure_pw_history'                                                         => 'Không có một tuần trôi qua mà bạn đọc trong tin tức về một trang web bị mất mật khẩu của người dùng. Tin tặc và kẻ trộm sử dụng các mật khẩu này để cố lấy cắp thông tin cá nhân của bạn. Thông tin này có giá trị.',
    'secure_pw_ff'                                                              => 'Bạn có sử dụng cùng một mật khẩu trên internet không? Nếu một trang web mất mật khẩu, tin tặc có quyền truy cập vào tất cả dữ liệu của bạn. Firefly III dựa vào bạn để chọn một mật khẩu mạnh và duy nhất để bảo vệ hồ sơ tài chính của bạn.',
    'secure_pw_check_box'                                                       => 'Để giúp bạn làm điều đó, Firefly III có thể kiểm tra xem mật khẩu bạn muốn sử dụng có bị đánh cắp trong quá khứ không. Nếu đây là trường hợp, Firefly III khuyên bạn KHÔNG nên sử dụng mật khẩu đó.',
    'secure_pw_working_title'                                                   => 'Làm thế nào nó hoạt động?',
    'secure_pw_working'                                                         => 'Bằng cách chọn hộp, Firefly III sẽ gửi năm ký tự đầu tiên của hàm băm SHA1 của mật khẩu của bạn tới <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">trang web của Troy Hunt </a> để xem nó có trong danh sách không. Điều này sẽ ngăn bạn sử dụng mật khẩu không an toàn như được khuyến nghị trong phần mới nhất <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">Ấn phẩm đặc biệt của NIST</a> về chủ đề này.',
    'secure_pw_should'                                                          => 'Tôi có nên check vào hộp không?',
    'secure_pw_long_password'                                                   => 'Đúng. Luôn xác minh mật khẩu của bạn an toàn.',
    'command_line_token'                                                        => 'Mã thông báo dòng lệnh',
    'explain_command_line_token'                                                => 'Bạn cần token này để thực hiện các tùy chọn dòng lệnh, chẳng hạn như xuất dữ liệu. Không có nó, lệnh nhạy cảm đó sẽ không hoạt động. Không chia sẻ mã thông báo dòng lệnh của bạn. Không ai sẽ yêu cầu bạn cho mã thông báo này, ngay cả tôi. Nếu bạn sợ bạn mất thứ này, hãy tạo lại mã thông báo này bằng nút.',
    'regenerate_command_line_token'                                             => 'Tạo lại mã thông báo dòng lệnh',
    'token_regenerated'                                                         => 'Một mã thông báo dòng lệnh mới đã được tạo',
    'change_your_email'                                                         => 'Thay đổi địa chỉ email của bạn',
    'email_verification'                                                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                                                      => 'Cho đến khi bạn xác minh địa chỉ email của mình, bạn không thể đăng nhập.',
    'login_with_new_email'                                                      => 'Bây giờ bạn có thể đăng nhập bằng địa chỉ email mới của bạn.',
    'login_with_old_email'                                                      => 'Bây giờ bạn có thể đăng nhập lại với địa chỉ email cũ của bạn.',
    'login_provider_local_only'                                                 => 'Hành động này không khả dụng khi xác thực thông qua ": login_provider".',
    'external_user_mgt_disabled'                                                => 'Hành động này không khả dụng khi Firefly III không chịu trách nhiệm quản lý người dùng hoặc xử lý xác thực.',
    'external_auth_disabled'                                                    => 'This action is not available when Firefly III isn\'t responsible for authentication handling.',
    'delete_local_info_only'                                                    => "Vì Firefly III không chịu trách nhiệm quản lý người dùng hoặc xử lý xác thực, nên chức năng này sẽ chỉ xóa thông tin Firefly III cục bộ.",
    'oauth'                                                                     => 'OAuth',
    'profile_oauth_clients'                                                     => 'OAuth Clients',
    'profile_oauth_no_clients'                                                  => 'Bạn đã không tạo ra bất kỳ OAuth clients nào.',
    'profile_oauth_clients_external_auth'                                       => 'If you\'re using an external authentication provider like Authelia, OAuth Clients will not work. You can use Personal Access Tokens only.',
    'profile_oauth_clients_header'                                              => 'Clients',
    'profile_oauth_client_id'                                                   => 'Client ID',
    'profile_oauth_client_name'                                                 => 'Tên',
    'profile_oauth_client_secret'                                               => 'Mã bí mật',
    'profile_oauth_create_new_client'                                           => 'Tạo mới Client',
    'profile_oauth_create_client'                                               => 'Tạo Client',
    'profile_oauth_edit_client'                                                 => 'Sửa Client',
    'profile_oauth_name_help'                                                   => 'Một cái gì đó người dùng của bạn sẽ nhận ra và tin tưởng.',
    'profile_oauth_redirect_url'                                                => 'URL chuyển tiếp',
    'profile_oauth_redirect_url_help'                                           => 'URL gọi lại ủy quyền của ứng dụng của bạn.',
    'profile_authorized_apps'                                                   => 'Uỷ quyền ứng dụng',
    'profile_authorized_clients'                                                => 'Client ủy quyền',
    'profile_scopes'                                                            => 'Phạm vi',
    'profile_revoke'                                                            => 'Thu hồi',
    'profile_oauth_client_secret_title'                                         => 'Client Secret',
    'profile_oauth_client_secret_expl'                                          => 'Here is your new client secret. This is the only time it will be shown so don\'t lose it! You may now use this secret to make API requests.',
    'profile_personal_access_tokens'                                            => 'Mã truy cập cá nhân',
    'profile_personal_access_token'                                             => 'Mã truy cập cá nhân',
    'profile_oauth_confidential'                                                => 'Confidential',
    'profile_oauth_confidential_help'                                           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation'                                 => 'Đây là mã thông báo truy cập cá nhân mới của bạn. Đây là lần duy nhất nó sẽ được hiển thị vì vậy đừng đánh mất nó! Bây giờ bạn có thể sử dụng mã thông báo này để thực hiện API.',
    'profile_no_personal_access_token'                                          => 'Bạn chưa tạo bất kỳ mã thông báo truy cập cá nhân nào.',
    'profile_create_new_token'                                                  => 'Tạo mã mới',
    'profile_create_token'                                                      => 'Tạo mã',
    'profile_create'                                                            => 'Tạo',
    'profile_save_changes'                                                      => 'Lưu thay đổi',
    'profile_whoops'                                                            => 'Rất tiếc!',
    'profile_something_wrong'                                                   => 'Có lỗi xảy ra!',
    'profile_try_again'                                                         => 'Xảy ra lỗi. Vui lòng thử lại.',
    'amounts'                                                                   => 'Amounts',
    'multi_account_warning_unknown'                                             => 'Depending on the type of transaction you create, the source and/or destination account of subsequent splits may be overruled by whatever is defined in the first split of the transaction.',
    'multi_account_warning_withdrawal'                                          => 'Keep in mind that the source account of subsequent splits will be overruled by whatever is defined in the first split of the withdrawal.',
    'multi_account_warning_deposit'                                             => 'Keep in mind that the destination account of subsequent splits will be overruled by whatever is defined in the first split of the deposit.',
    'multi_account_warning_transfer'                                            => 'Keep in mind that the source + destination account of subsequent splits will be overruled by whatever is defined in the first split of the transfer.',



    // export data:
    'export_data_title'                                                         => 'Xuất dữ liệu từ Firefly III',
    'export_data_menu'                                                          => 'Xuất dữ liệu',
    'export_data_bc'                                                            => 'Xuất dữ liệu từ Firefly III',
    'export_data_main_title'                                                    => 'Xuất dữ liệu từ Firefly III',
    'export_data_expl'                                                          => 'Liên kết này cho phép bạn xuất tất cả các giao dịch + dữ liệu meta từ Firefly III. Vui lòng tham khảo trợ giúp (trên cùng bên phải (?) - biểu tượng) để biết thêm thông tin về quy trình.',
    'export_data_all_transactions'                                              => 'Xuất tất cả các giao dịch',
    'export_data_advanced_expl'                                                 => 'Nếu bạn cần một kiểu xuất nâng cao hoặc cụ thể hơn, hãy đọc trợ giúp về cách sử dụng lệnh console <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                                                         => 'Một tệp đính kèm |: đếm tệp đính kèm',
    'attachments'                                                               => 'Tệp đính kèm',
    'edit_attachment'                                                           => 'Chỉnh sửa tập tin đính kèm ":name"',
    'update_attachment'                                                         => 'Cập nhật tệp đính kèm',
    'delete_attachment'                                                         => 'Xóa tệp đính kèm ":name"',
    'attachment_deleted'                                                        => 'Đã xóa tệp đính kèm ":name"',
    'liabilities_deleted'                                                       => 'Xóa nợ ":name"',
    'attachment_updated'                                                        => 'Cập nhật tệp đính kèm ":name"',
    'upload_max_file_size'                                                      => 'Kích thước tệp tối đa: :size',
    'list_all_attachments'                                                      => 'Danh sách tất cả các tệp đính kèm',

    // transaction index
    'is_reconciled_fields_dropped'                                              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                                                             => 'Is reconciled',
    'title_expenses'                                                            => 'Chi phí',
    'title_withdrawal'                                                          => 'Chi phí',
    'title_revenue'                                                             => 'Thu nhập doanh thu',
    'title_deposit'                                                             => 'Thu nhập doanh thu',
    'title_transfer'                                                            => 'Chuyển',
    'title_transfers'                                                           => 'Chuyển',
    'submission_options'                                                        => 'Submission options',
    'apply_rules_checkbox'                                                      => 'Apply rules',
    'fire_webhooks_checkbox'                                                    => 'Fire webhooks',
    'select_source_account'                                                     => 'Please select or type a valid source account name',
    'select_dest_account'                                                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'                                        => 'Giao dịch này đã được rút tiền',
    'convert_is_already_type_Deposit'                                           => 'Giao dịch này đã là một khoản tiền gửi',
    'convert_is_already_type_Transfer'                                          => 'Giao dịch này đã được chuyển',
    'convert_to_Withdrawal'                                                     => 'Chuyển đôi ":description" thành rút tiền',
    'convert_to_Deposit'                                                        => 'Chuyển đôi ":description" thành gửi tiền',
    'convert_to_Transfer'                                                       => 'Chuyển đôi ":description" thành chuyển khoản',
    'convert_options_WithdrawalDeposit'                                         => 'Chuyển đổi rút tiền thành tiền gửi',
    'convert_options_WithdrawalTransfer'                                        => 'chuyển đổi rút tiền thành chuyển khoản',
    'convert_options_DepositTransfer'                                           => 'Chuyển đôi tiền gửi thành chuyển khoản',
    'convert_options_DepositWithdrawal'                                         => 'Chuyển đổi một khoản tiền gửi thành một khoản rút tiền',
    'convert_options_TransferWithdrawal'                                        => 'Chuyển đổi chuyển khoản thành rút tiền',
    'convert_options_TransferDeposit'                                           => 'Chuyển đổi chuyển khoản thành tiền gửi',
    'convert_Withdrawal_to_deposit'                                             => 'Chuyển đổi khoản rút tiền thành tiền gửi',
    'convert_Withdrawal_to_transfer'                                            => 'Chuyển đổi khoản rút tiền thành chuyển khoản',
    'convert_Deposit_to_withdrawal'                                             => 'Chuyển đổi khoản tiền gửi thành một khoản rút tiền',
    'convert_Deposit_to_transfer'                                               => 'Chuyển đổi khoản ký gửi thành chuyển khoản',
    'convert_Transfer_to_deposit'                                               => 'Chuyển đổi chuyển khoản thành một khoản tiền gửi',
    'convert_Transfer_to_withdrawal'                                            => 'Chuyển đổi chuyển khoản thành rút tiền',
    'convert_please_set_revenue_source'                                         => 'Vui lòng chọn tài khoản doanh thu nơi tiền sẽ đến.',
    'convert_please_set_asset_destination'                                      => 'Vui lòng chọn tài khoản nơi tiền sẽ đến.',
    'convert_please_set_expense_destination'                                    => 'Vui lòng chọn tài khoản chi phí nơi tiền sẽ được chuyển đến.',
    'convert_please_set_asset_source'                                           => 'Vui lòng chọn tài khoản nơi tiền sẽ đến.',
    'convert_expl_w_d'                                                          => 'Khi chuyển đổi từ rút tiền sang tiền gửi, tiền sẽ được gửi vào tài khoản đích được hiển thị, thay vì được rút từ đó. | Khi chuyển đổi từ rút tiền sang tiền gửi, tiền sẽ được gửi vào tài khoản đích được hiển thị, thay vì được rút từ họ.',
    'convert_expl_w_t'                                                          => 'Khi chuyển đổi rút tiền thành chuyển khoản, tiền sẽ được chuyển từ tài khoản nguồn sang tài khoản nợ hoặc tài khoản nợ khác thay vì được sử dụng cho tài khoản chi phí ban đầu. Khi chuyển đổi rút tiền thành chuyển khoản, tiền sẽ được chuyển đi từ các tài khoản nguồn vào các tài khoản tài sản hoặc nợ khác thay vì được sử dụng cho các tài khoản chi phí ban đầu.',
    'convert_expl_d_w'                                                          => 'Khi chuyển đổi một khoản tiền gửi thành một khoản rút tiền, tiền sẽ được rút từ tài khoản nguồn được hiển thị, thay vì được gửi vào đó. Khi chuyển đổi một khoản tiền gửi thành một khoản rút tiền, tiền sẽ được rút từ các tài khoản nguồn được hiển thị, thay vì được gửi vào chúng.',
    'convert_expl_d_t'                                                          => 'Khi bạn chuyển đổi tiền gửi thành chuyển khoản, tiền sẽ được gửi vào tài khoản đích được liệt kê từ bất kỳ tài khoản hoặc tài khoản nợ nào của bạn. Khi bạn chuyển đổi tiền gửi thành chuyển khoản, tiền sẽ được gửi vào tài khoản đích được liệt kê từ bất kỳ tài sản hoặc tài khoản nợ của bạn.',
    'convert_expl_t_w'                                                          => 'Khi bạn chuyển đổi chuyển khoản thành rút tiền, tiền sẽ được sử dụng cho tài khoản đích bạn đặt ở đây, thay vì được chuyển đi. Khi bạn chuyển đổi chuyển khoản thành rút tiền, tiền sẽ được sử dụng cho các tài khoản đích bạn đặt tại đây, thay vì bị chuyển đi.',
    'convert_expl_t_d'                                                          => 'Khi bạn chuyển đổi chuyển khoản thành tiền gửi, tiền sẽ được gửi vào tài khoản đích bạn thấy ở đây, thay vì được chuyển vào đó. Khi bạn chuyển đổi chuyển khoản thành tiền gửi, tiền sẽ được gửi vào tài khoản đích bạn thấy ở đây, thay vì được chuyển vào chúng.',
    'convert_select_sources'                                                    => 'Để hoàn thành chuyển đổi, vui lòng đặt tài khoản nguồn mới bên dưới. Để hoàn thành chuyển đổi, vui lòng đặt các tài khoản nguồn mới bên dưới.',
    'convert_select_destinations'                                               => 'Để hoàn thành chuyển đổi, vui lòng chọn tài khoản đích mới bên dưới. Để hoàn thành chuyển đổi, vui lòng chọn các tài khoản đích mới bên dưới.',
    'converted_to_Withdrawal'                                                   => 'Giao dịch đã được chuyển đổi thành rút tiền',
    'converted_to_Deposit'                                                      => 'Giao dịch đã được chuyển đổi thành tiền gửi',
    'converted_to_Transfer'                                                     => 'Giao dịch đã được chuyển đổi thành chuyển khoản',
    'invalid_convert_selection'                                                 => 'Tài khoản bạn đã chọn đã được sử dụng trong giao dịch này hoặc không tồn tại.',
    'source_or_dest_invalid'                                                    => 'Không thể tìm thấy các chi tiết giao dịch chính xác. Chuyển đổi là không thể.',
    'convert_to_withdrawal'                                                     => 'Chuyển đổi thành rút tiền',
    'convert_to_deposit'                                                        => 'Chuyển đổi thành tiền gửi',
    'convert_to_transfer'                                                       => 'Chuyển đổi sang chuyển khoản',

    // create new stuff:
    'create_new_withdrawal'                                                     => 'Tạo rút tiền mới',
    'create_new_deposit'                                                        => 'Tạo tiền gửi mới',
    'create_new_transfer'                                                       => 'Tạo chuyển khoản mới',
    'create_new_asset'                                                          => 'Tạo tài khoản mới',
    'create_new_liabilities'                                                    => 'Create new liability',
    'create_new_expense'                                                        => 'Tạo tài khoản chi phí mới',
    'create_new_revenue'                                                        => 'Tạo tài khoản doanh thu mới',
    'create_new_piggy_bank'                                                     => 'Tạo heo đất mới',
    'create_new_bill'                                                           => 'Create new subscription',
    'create_new_subscription'                                                   => 'Create new subscription',
    'create_new_rule'                                                           => 'Create new rule',

    // currencies:
    'create_currency'                                                           => 'Tạo một loại tiền tệ mới',
    'store_currency'                                                            => 'Lưu trữ tiền tệ mới',
    'update_currency'                                                           => 'Cập nhật tiền tệ',
    'new_default_currency'                                                      => '":name" is now the default currency.',
    'default_currency_failed'                                                   => 'Could not make ":name" the default currency. Please check the logs.',
    'cannot_delete_currency'                                                    => 'Không thể xóa: vì nó vẫn đang được sử dụng.',
    'cannot_delete_fallback_currency'                                           => ':name là loại tiền dự phòng hệ thống và không thể xóa.',
    'cannot_disable_currency_journals'                                          => 'Không thể tắt: vì các giao dịch vẫn đang sử dụng nó.',
    'cannot_disable_currency_last_left'                                         => 'Không thể tắt: vì đây là loại tiền được kích hoạt lần cuối.',
    'cannot_disable_currency_account_meta'                                      => 'Không thể tắt: vì nó được sử dụng trong tài khoản.',
    'cannot_disable_currency_bills'                                             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'                                         => 'Không thể tắt: vì nó được sử dụng trong các giao dịch định kỳ.',
    'cannot_disable_currency_available_budgets'                                 => 'Không thể tắt: vì nó được sử dụng trong ngân sách có sẵn.',
    'cannot_disable_currency_budget_limits'                                     => 'Không thể tắt: vì nó được sử dụng trong giới hạn ngân sách.',
    'cannot_disable_currency_current_default'                                   => 'Không thể tắt: vì đây là loại tiền mặc định hiện tại.',
    'cannot_disable_currency_system_fallback'                                   => 'Không thể tắt: vì đây là loại tiền mặc định của hệ thống.',
    'disable_EUR_side_effects'                                                  => 'Euro là tiền tệ dự phòng khẩn cấp của hệ thống. Vô hiệu hóa nó có thể có tác dụng phụ ngoài ý muốn và có thể làm mất hiệu lực bảo hành của bạn.',
    'deleted_currency'                                                          => 'Tiền tệ :name đã xóa',
    'created_currency'                                                          => 'Tiền tệ :name được tạo',
    'could_not_store_currency'                                                  => 'Không thể lưu trữ tiền tệ mới.',
    'updated_currency'                                                          => 'Tiền tệ :name được cập nhật',
    'ask_site_owner'                                                            => 'Vui lòng hỏi :owner để thêm, xóa hoặc chỉnh sửa tiền tệ.',
    'currencies_intro'                                                          => 'Firefly III hỗ trợ nhiều loại tiền tệ khác nhau mà bạn có thể đặt và kích hoạt tại đây.',
    'currencies_switch_default'                                                 => 'You can switch the native currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                                                     => 'Đặt làm mặc định',
    'default_currency'                                                          => 'mặc định',
    'native_currency_button'                                                    => 'native',
    'currency_is_disabled'                                                      => 'Tắt',
    'enable_currency'                                                           => 'Kích hoạt',
    'disable_currency'                                                          => 'Tắt',
    'currencies_default_disabled'                                               => 'Hầu hết các loại tiền tệ này bị tắt theo mặc định. Để sử dụng chúng, bạn phải kích hoạt chúng trước.',
    'currency_is_now_enabled'                                                   => 'Tiền tệ ":name" đã được kích hoạt',
    'could_not_enable_currency'                                                 => 'Could not enable currency ":name". Please review the logs.',
    'currency_is_now_disabled'                                                  => 'Tiền tệ ":name" đã được tắt',
    'could_not_disable_currency'                                                => 'Could not disable currency ":name". Perhaps it is still in use?',

    // forms:
    'mandatoryFields'                                                           => 'Các trường bắt buộc',
    'optionalFields'                                                            => 'Các trường tùy chọn',
    'options'                                                                   => 'Tùy chọn',

    // budgets:
    'daily_budgets'                                                             => 'Ngân sách hàng ngày',
    'weekly_budgets'                                                            => 'Ngân sách hàng tuần',
    'monthly_budgets'                                                           => 'Ngân sách hàng tháng',
    'quarterly_budgets'                                                         => 'Ngân sách hàng quý',
    'half_year_budgets'                                                         => 'Ngân sách nửa năm',
    'yearly_budgets'                                                            => 'Ngân sách hàng năm',
    'other_budgets'                                                             => 'Ngân sách theo thời gian tùy chỉnh',
    'budget_limit_not_in_range'                                                 => 'Số tiền này áp dụng từ :start đến :end:',
    'total_available_budget'                                                    => 'Tổng ngân sách có sẵn (giữa :start và :end)',
    'total_available_budget_in_currency'                                        => 'Tổng ngân sách có sẵn bằng: tiền tệ',
    'see_below'                                                                 => 'xem bên dưới',
    'create_new_budget'                                                         => 'Tạo ngân sách mới',
    'store_new_budget'                                                          => 'Lưu trữ ngân sách mới',
    'stored_new_budget'                                                         => 'Lưu trữ ngân sách mới... ":name"',
    'available_between'                                                         => 'Có sẵn giữa: bắt đầu và: kết thúc',
    'transactionsWithoutBudget'                                                 => 'Chi phí không có ngân sách',
    'transactions_no_budget'                                                    => 'Chi phí không có ngân sách giữa :start và :end',
    'spent_between'                                                             => 'Đã dành giữa :start và :end',
    'spent_between_left'                                                        => 'Spent :spent between :start and :end, leaving :left.',
    'set_available_amount'                                                      => 'Đặt số lượng có sẵn',
    'update_available_amount'                                                   => 'Cập nhật số tiền hiện có',
    'ab_basic_modal_explain'                                                    => 'Sử dụng biểu mẫu này để cho biết số tiền bạn mong đợi có thể dự trù ngân sách (tổng cộng, bằng :currency) trong khoảng thời gian được chỉ định.',
    'createBudget'                                                              => 'Ngân sách mới',
    'invalid_currency'                                                          => 'Đây là một loại tiền tệ không hợp lệ',
    'invalid_amount'                                                            => 'Xin hãy nhập một số tiền',
    'set_ab'                                                                    => 'Số tiền ngân sách có sẵn đã được đặt',
    'updated_ab'                                                                => 'Số tiền ngân sách có sẵn đã được cập nhật',
    'deleted_ab'                                                                => 'Số tiền ngân sách có sẵn đã bị xóa',
    'deleted_bl'                                                                => 'Số tiền ngân sách đã bị xóa',
    'alt_currency_ab_create'                                                    => 'Đặt ngân sách có sẵn bằng loại tiền khác',
    'bl_create_btn'                                                             => 'Đặt ngân sách bằng loại tiền khác',
    'inactiveBudgets'                                                           => 'Ngân sách không hoạt động',
    'without_budget_between'                                                    => 'Giao dịch không có ngân sách giữa: bắt đầu và: kết thúc',
    'delete_budget'                                                             => 'Xóa ngân sách ":name"',
    'deleted_budget'                                                            => 'Đã xóa ngân sách ":name"',
    'edit_budget'                                                               => 'Chỉnh sửa ngân sách ":name"',
    'updated_budget'                                                            => 'Đã cập nhật ngân sách ":name"',
    'update_amount'                                                             => 'Cập nhật số tiền',
    'update_budget'                                                             => 'Cập nhật ngân sách',
    'update_budget_amount_range'                                                => 'Cập nhật (dự kiến) số tiền khả dụng giữa: bắt đầu và: kết thúc',
    'set_budget_limit_title'                                                    => 'Đặt số tiền được dự toán cho ngân sách: ngân sách giữa: bắt đầu và: kết thúc',
    'set_budget_limit'                                                          => 'Đặt số tiền ngân sách',
    'budget_period_navigator'                                                   => 'Điều hướng thời gian',
    'info_on_available_amount'                                                  => 'Tôi có sẵn cái gì?',
    'available_amount_indication'                                               => 'Sử dụng những số tiền này để có được một dấu hiệu về tổng ngân sách của bạn có thể là bao nhiêu.',
    'suggested'                                                                 => 'Đề xuất',
    'average_between'                                                           => 'Trung bình giữa :start và :end',
    'transferred_in'                                                            => 'Đã chuyển (vào)',
    'transferred_away'                                                          => 'Đã chuyển (ra)',
    'auto_budget_none'                                                          => ' Không có ngân sách tự động',
    'auto_budget_reset'                                                         => 'Đặt số tiền cố định mỗi kỳ',
    'auto_budget_rollover'                                                      => 'Thêm một số tiền mỗi kỳ',
    'auto_budget_adjusted'                                                      => 'Add an amount every period and correct for overspending',
    'auto_budget_period_daily'                                                  => 'Hàng ngày',
    'auto_budget_period_weekly'                                                 => 'Hàng tuần',
    'auto_budget_period_monthly'                                                => 'Hàng tháng',
    'auto_budget_period_quarterly'                                              => 'Hàng quý',
    'auto_budget_period_half_year'                                              => 'Mỗi nửa năm',
    'auto_budget_period_yearly'                                                 => 'Hàng năm',
    'auto_budget_help'                                                          => 'Bạn có thể đọc thêm về tính năng này trong trợ giúp. Nhấp vào biểu tượng trên cùng bên phải (?).',
    'auto_budget_reset_icon'                                                    => 'Ngân sách này sẽ được đặt định kỳ',
    'auto_budget_rollover_icon'                                                 => 'Số tiền ngân sách sẽ tăng theo định kỳ',
    'auto_budget_adjusted_icon'                                                 => 'The budget amount will increase periodically and will correct for overspending',
    'remove_budgeted_amount'                                                    => 'Xóa số tiền ngân sách trong :currency',

    // bills:
    'skip_help_text'                                                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                                                              => 'Subscription',
    'not_expected_period'                                                       => 'Không mong đợi ở giai đoạn này',
    'subscriptions_in_group'                                                    => 'Subscriptions in group "%{title}"',
    'subscr_expected_x_times'                                                   => 'Expect to pay %{amount} %{times} times this period',
    'not_or_not_yet'                                                            => 'Không (chưa)',
    'visit_bill'                                                                => 'Visit subscription ":name" at Firefly III',
    'match_between_amounts'                                                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                                                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                                                        => 'Rules related to this subscription',
    'repeats'                                                                   => 'Lặp lại',
    'bill_end_date_help'                                                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                                                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                                                       => 'This subscription ends on :date',
    'bill_extension_index_line'                                                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                                                        => 'Giao dịch được kết nối',
    'auto_match_on'                                                             => 'Tự động khớp với Firefly III',
    'auto_match_off'                                                            => 'Không tự động khớp với Firefly III',
    'next_expected_match'                                                       => 'Trận đấu dự kiến tiếp theo',
    'delete_bill'                                                               => 'Delete subscription ":name"',
    'deleted_bill'                                                              => 'Deleted subscription ":name"',
    'edit_bill'                                                                 => 'Edit subscription ":name"',
    'more'                                                                      => 'Nhiều hơn',
    'rescan_old'                                                                => 'Chạy lại quy tắc, trên tất cả các giao dịch',
    'update_bill'                                                               => 'Update subscription',
    'updated_bill'                                                              => 'Updated subscription ":name"',
    'store_new_bill'                                                            => 'Store new subscription',
    'stored_new_bill'                                                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                                                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                                                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                                                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'                                               => 'Average subscription amount (overall)',
    'bill_is_active'                                                            => 'Subscription is active',
    'bill_expected_between'                                                     => 'Dự kiến giữa :start và :end',
    'bill_will_automatch'                                                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                                                => 'bỏ qua',
    'bill_store_error'                                                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                                                        => 'quy tắc không hoạt động',
    'bill_edit_rules'                                                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                                                        => 'Ngày đáo hạn :date',
    'bill_expected_date_js'                                                     => 'Expected {date}',
    'expected_amount'                                                           => '(Expected) amount',
    'bill_paid_on'                                                              => 'Paid on {date}',
    'bill_repeats_weekly'                                                       => 'Lặp lại hàng tuần',
    'bill_repeats_monthly'                                                      => 'Lặp lại hàng tháng',
    'bill_repeats_quarterly'                                                    => 'Lặp lại hàng quý',
    'bill_repeats_half-year'                                                    => 'Lặp lại mỗi nửa năm',
    'bill_repeats_yearly'                                                       => 'Lặp lại hàng năm',
    'bill_repeats_weekly_other'                                                 => 'Lặp lại các tuần một lần',
    'bill_repeats_monthly_other'                                                => 'Repeats every other month',
    'bill_repeats_quarterly_other'                                              => 'Repeats every other quarter',
    'bill_repeats_half-year_other'                                              => 'Repeats yearly',
    'bill_repeats_yearly_other'                                                 => 'Repeats every other year',
    'bill_repeats_weekly_skip'                                                  => 'Repeats every {skip} weeks',
    'bill_repeats_monthly_skip'                                                 => 'Repeats every {skip} months',
    'bill_repeats_quarterly_skip'                                               => 'Repeats every {skip} quarters',
    'bill_repeats_half-year_skip'                                               => 'Repeats every {skip} half years',
    'bill_repeats_yearly_skip'                                                  => 'Repeats every {skip} years',
    'subscriptions'                                                             => 'Subscriptions',
    'go_to_subscriptions'                                                       => 'Go to your subscriptions',
    'forever'                                                                   => 'Forever',
    'extension_date_is'                                                         => 'Extension date is {date}',

    // accounts:
    'account_locked_currency'                                                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                                                          => 'Tôi đang nợ số tiền',
    'i_owe_amount'                                                              => 'Tôi nợ số tiền',
    'inactive_account_link'                                                     => 'Bạn có :count tài khoản không hoạt động (được lưu trữ) mà bạn có thể xem trên trang này. Bạn có :count tài khoản không hoạt động (đã lưu trữ) mà bạn có thể xem trên trang này.',
    'all_accounts_inactive'                                                     => 'Đây là những tài khoản không hoạt động của bạn.',
    'active_account_link'                                                       => 'Liên kết này quay lại tài khoản đang hoạt động của bạn.',
    'account_missing_transaction'                                               => 'Tài khoản #: id (": name") không thể được xem trực tiếp, nhưng Firefly thiếu thông tin chuyển hướng.',
    'cc_monthly_payment_date_help'                                              => 'Select any year and any month, it will be ignored anyway. Only the day of the month is relevant.',
    'details_for_asset'                                                         => 'Chi tiết cho tài khoản ":name"',
    'details_for_expense'                                                       => 'Chi tiết tài khoản chi phí ":name"',
    'details_for_revenue'                                                       => 'Chi tiết cho tài khoản doanh thu ":name"',
    'details_for_cash'                                                          => 'Chi tiết cho tài khoản tiền mặt ":name"',
    'store_new_asset_account'                                                   => 'Lưu trữ tài khoản mới',
    'store_new_expense_account'                                                 => 'Lưu trữ tài khoản chi phí mới',
    'store_new_revenue_account'                                                 => 'Lưu trữ tài khoản doanh thu mới',
    'edit_asset_account'                                                        => 'Chỉnh sửa tài khoản ":name"',
    'edit_expense_account'                                                      => 'Chỉnh sửa tài khoản chi phí ":name"',
    'edit_revenue_account'                                                      => 'Chỉnh sửa tài khoản doanh thu ":name"',
    'delete_asset_account'                                                      => 'Xóa tài khoản ":name"',
    'delete_expense_account'                                                    => 'Xóa tài khoản chi phí ":name"',
    'delete_revenue_account'                                                    => 'Xóa tài khoản doanh thu ":name"',
    'delete_liabilities_account'                                                => 'Xóa tài khoản nợ ":name"',
    'asset_deleted'                                                             => 'Thành công tài khoản bị xóa ":name"',
    'account_deleted'                                                           => 'Successfully deleted account ":name"',
    'expense_deleted'                                                           => 'Thành công xóa tài khoản chi phí ":name"',
    'revenue_deleted'                                                           => 'Thành công xóa tài khoản doanh thu ":name"',
    'update_asset_account'                                                      => 'Cập nhật tài khoản',
    'update_undefined_account'                                                  => 'Update account',
    'update_liabilities_account'                                                => 'Cập nhật nợ',
    'update_expense_account'                                                    => 'Cập nhật tài khoản chi phí',
    'update_revenue_account'                                                    => 'Cập nhật tài khoản doanh thu',
    'make_new_asset_account'                                                    => 'Tạo một tài khoản mới',
    'make_new_expense_account'                                                  => 'Tạo một tài khoản chi phí mới',
    'make_new_revenue_account'                                                  => 'Tạo một tài khoản doanh thu mới',
    'make_new_liabilities_account'                                              => 'Tạo một nợ mới',
    'asset_accounts'                                                            => 'tài khoản',
    'undefined_accounts'                                                        => 'Accounts',
    'asset_accounts_inactive'                                                   => 'tài khoản (không hoạt động)',
    'expense_account'                                                           => 'Expense account',
    'expense_accounts'                                                          => 'Tài khoản chi phí',
    'expense_accounts_inactive'                                                 => 'Tài khoản chi tiêu (không hoạt động)',
    'revenue_account'                                                           => 'Revenue account',
    'revenue_accounts'                                                          => 'Tài khoản doanh thu',
    'revenue_accounts_inactive'                                                 => 'Revenue accounts (inactive)',
    'cash_accounts'                                                             => 'Tài khoản tiền mặt',
    'Cash account'                                                              => 'Tài khoản tiền mặt',
    'liabilities_accounts'                                                      => 'Nợ',
    'liabilities_accounts_inactive'                                             => 'Liabilities (inactive)',
    'reconcile_account'                                                         => 'Tài khoản đối chiếu ":account"',
    'overview_of_reconcile_modal'                                               => 'Tổng quan về tài khoản đối chiếu',
    'delete_reconciliation'                                                     => 'Xóa tài khoản đối chiếu',
    'update_reconciliation'                                                     => 'Cập nhật tài khoản đối chiếu',
    'amount_cannot_be_zero'                                                     => 'Số lượng không thể bằng không',
    'end_of_reconcile_period'                                                   => 'Kết thúc chu kỳ đối chiếu: :period',
    'start_of_reconcile_period'                                                 => 'Bắt đầu chu kỳ đối chiếu::period',
    'start_balance'                                                             => 'Số dư bắt đầu',
    'end_balance'                                                               => 'Số dư cuối kỳ',
    'update_balance_dates_instruction'                                          => 'Khớp số tiền và ngày ở trên với bảng sao kê ngân hàng của bạn và nhấn "Start reconciling"',
    'select_transactions_instruction'                                           => 'Chọn các giao dịch xuất hiện trên bảng sao kê ngân hàng của bạn.',
    'select_range_and_balance'                                                  => 'Đầu tiên xác minh phạm vi ngày và số dư. Sau đó nhấn "Start reconciling"',
    'date_change_instruction'                                                   => 'Nếu bạn thay đổi phạm vi ngày bây giờ, mọi tiến trình sẽ bị mất.',
    'update_selection'                                                          => 'Cập nhật lựa chọn',
    'store_reconcile'                                                           => 'Lưu trữ đối chiếu',
    'reconciliation_transaction'                                                => 'Giao dịch đối chiếu',
    'Reconciliation'                                                            => 'Đối chiếu',
    'reconciliation'                                                            => 'Đối chiếu',
    'reconcile_options'                                                         => 'Tùy chọn đối chiếu',
    'reconcile_range'                                                           => 'Vùng đối chiếu',
    'start_reconcile'                                                           => 'Bắt đầu đối chiếu',
    'cash_account_type'                                                         => 'Tiền mặt',
    'cash'                                                                      => 'Tiền mặt',
    'cant_find_redirect_account'                                                => 'Firefly III đã cố gắng chuyển hướng bạn nhưng không thể. Xin lỗi vì điều đó. Quay lại chỉ mục.',
    'account_type'                                                              => 'Loại tài khoản',
    'save_transactions_by_moving'                                               => 'Lưu giao dịch này bằng cách di chuyển nó sang tài khoản khác: | Lưu các giao dịch này bằng cách chuyển chúng sang tài khoản khác:',
    'save_transactions_by_moving_js'                                            => 'No transactions|Save this transaction by moving it to another account. |Save these transactions by moving them to another account.',
    'stored_new_account'                                                        => 'Tài khoản mới ":name" đã được lưu trữ!',
    'stored_new_account_js'                                                     => 'New account "<a href="accounts/show/{ID}">{name}</a>" stored!',
    'updated_account'                                                           => 'Đã cập nhật tài khoản ":name"',
    'updated_account_js'                                                        => 'Updated account "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                                                       => 'Tùy chọn thẻ tín dụng',
    'no_transactions_account'                                                   => 'Không có giao dịch (trong giai đoạn này) cho tài khoản ":name".',
    'no_transactions_period'                                                    => 'Không có giao dịch (trong giai đoạn này).',
    'no_data_for_chart'                                                         => 'Không có đủ thông tin (chưa) để tạo biểu đồ này.',
    'select_at_least_one_account'                                               => 'Vui lòng chọn ít nhất một tài khoản',
    'select_at_least_one_category'                                              => 'Vui lòng chọn ít nhất một danh mục',
    'select_at_least_one_budget'                                                => 'Vui lòng chọn ít nhất một ngân sách',
    'select_at_least_one_tag'                                                   => 'Vui lòng chọn ít nhất một nhãn',
    'select_at_least_one_expense'                                               => 'Vui lòng chọn ít nhất một sự kết hợp của các tài khoản chi phí / doanh thu. Nếu bạn không có (danh sách trống) thì báo cáo này không có sẵn.',
    'account_default_currency'                                                  => 'Đây sẽ là loại tiền mặc định được liên kết với tài khoản này.',
    'piggy_default_currency'                                                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'                                              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                                                        => 'Sổ cái Firefly III của bạn có nhiều tiền hơn số tiền mà ngân hàng của bạn yêu cầu. Có một số lựa chọn. Hãy chọn những gì để làm. Sau đó, nhấn "Xác nhận đối chiếu".',
    'reconcile_has_less'                                                        => 'Sổ cái Firefly III của bạn có ít tiền hơn so với yêu cầu ngân hàng của bạn. Có một số lựa chọn. Hãy chọn những gì để làm. Sau đó, nhấn "Xác nhận đối chiếu".',
    'reconcile_is_equal'                                                        => 'Sổ cái Firefly III của bạn và báo cáo ngân hàng của bạn phù hợp. Không có gì phải làm. Vui lòng nhấn "Xác nhận đối chiếu" để xác nhận đầu vào của bạn.',
    'create_pos_reconcile_transaction'                                          => 'Xóa các giao dịch đã chọn và tạo một hiệu chỉnh thêm: số tiền vào tài khoản này.',
    'create_neg_reconcile_transaction'                                          => 'Xóa các giao dịch đã chọn và tạo một chỉnh sửa xóa: số tiền từ tài khoản này.',
    'reconcile_do_nothing'                                                      => 'Xóa các giao dịch đã chọn, nhưng không sửa.',
    'reconcile_go_back'                                                         => 'Bạn luôn có thể chỉnh sửa hoặc xóa một chỉnh sửa sau.',
    'must_be_asset_account'                                                     => 'Bạn chỉ có thể đối chiếu tài khoản',
    'reconciliation_stored'                                                     => 'Đối chiếu được lưu trữ',
    'reconciliation_error'                                                      => 'Do lỗi, các giao dịch được đánh dấu là đã được đối chiếu nhưng việc sửa lỗi chưa được lưu trữ :: lỗi.',
    'reconciliation_transaction_title'                                          => 'Đối chiếu (:from đến :to)',
    'sum_of_reconciliation'                                                     => 'Tổng đối chiếu',
    'reconcile_this_account'                                                    => 'Điều chỉnh tài khoản này',
    'reconcile'                                                                 => 'Đối chiếu',
    'show'                                                                      => 'Hiển thị',
    'confirm_reconciliation'                                                    => 'Xác nhận đối chiếu',
    'submitted_start_balance'                                                   => 'Gửi số dư bắt đầu',
    'selected_transactions'                                                     => 'Giao dịch được chọn (:count)',
    'already_cleared_transactions'                                              => 'Đã xóa giao dịch (:count)',
    'submitted_end_balance'                                                     => 'Gửi số dư cuối kỳ',
    'initial_balance_description'                                               => 'Số dư ban đầu cho ":account"',
    'liability_credit_description'                                              => 'Liability credit for ":account"',
    'interest_calc_'                                                            => 'không xác định',
    'interest_calc_daily'                                                       => 'Mỗi ngày',
    'interest_calc_monthly'                                                     => 'Mỗi tháng',
    'interest_calc_yearly'                                                      => 'Mỗi năm',
    'interest_calc_weekly'                                                      => 'Per week',
    'interest_calc_half-year'                                                   => 'Per half year',
    'interest_calc_quarterly'                                                   => 'Per quarter',
    'initial_balance_account'                                                   => 'Tài khoản số dư ban đầu của: tài khoản',
    'list_options'                                                              => 'List options',
    'account_column_opt_drag_and_drop'                                          => 'Drag and drop',
    'account_column_opt_active'                                                 => 'Active',
    'account_column_opt_name'                                                   => 'Name',
    'account_column_opt_type'                                                   => 'Type',
    'account_column_opt_liability_type'                                         => 'Liability type',
    'account_column_opt_liability_direction'                                    => 'Liability direction',
    'account_column_opt_liability_interest'                                     => 'Liability interest',
    'account_column_opt_number'                                                 => 'Account number',
    'account_column_opt_current_balance'                                        => 'Current balance',
    'account_column_opt_amount_due'                                             => 'Amount due',
    'account_column_opt_last_activity'                                          => 'Last activity',
    'account_column_opt_balance_difference'                                     => 'Balance difference',
    'account_column_opt_menu'                                                   => 'Menu',

    // categories:
    'new_category'                                                              => 'Danh muc mới',
    'create_new_category'                                                       => 'Tạo một danh mục mới',
    'without_category'                                                          => 'Không có danh mục',
    'update_category'                                                           => 'Cập nhật danh mục',
    'updated_category'                                                          => 'Đã cập nhật danh mục ":name"',
    'categories'                                                                => 'Danh mục',
    'edit_category'                                                             => 'Sửa danh mục ":name"',
    'no_category'                                                               => '(không danh mục)',
    'unknown_category_plain'                                                    => 'No category',
    'category'                                                                  => 'Danh mục',
    'delete_category'                                                           => 'Xóa danh mục ":name"',
    'deleted_category'                                                          => 'Đã xóa danh mục ":name"',
    'store_category'                                                            => 'Lưu trữ danh mục mới',
    'stored_category'                                                           => 'Đã lưu trữ danh mục mới ":name"',
    'without_category_between'                                                  => 'Không có danh mục giữa :start và :end',



    // transactions:
    'wait_loading_transaction'                                                  => 'Please wait for the form to load',
    'wait_loading_data'                                                         => 'Please wait for your information to load...',
    'wait_attachments'                                                          => 'Please wait for the attachments to upload.',
    'errors_upload'                                                             => 'The upload has failed. Please check your browser console for the error.',
    'amount_foreign_if'                                                         => 'Amount in foreign currency, if any',
    'amount_destination_account'                                                => 'Amount in the currency of the destination account',
    'edit_transaction_title'                                                    => 'Edit transaction ":description"',
    'unreconcile'                                                               => 'Undo reconciliation',
    'update_withdrawal'                                                         => 'Cập nhật rút tiền',
    'update_deposit'                                                            => 'Cập nhật tiền gửi',
    'update_transaction'                                                        => 'Cập nhật giao dịch',
    'update_transfer'                                                           => 'Cập nhật chuyển',
    'updated_withdrawal'                                                        => 'Cập nhật rút tiền ":description"',
    'updated_deposit'                                                           => 'Tiền gửi cập nhật ":description"',
    'updated_transfer'                                                          => 'Chuyển khoản cập nhật ":description"',
    'no_changes_withdrawal'                                                     => 'Withdrawal ":description" was not changed.',
    'no_changes_deposit'                                                        => 'Deposit ":description" was not changed.',
    'no_changes_transfer'                                                       => 'Transfer ":description" was not changed.',
    'delete_withdrawal'                                                         => 'Xóa rút tiền ":description"',
    'delete_deposit'                                                            => 'Xóa tiền gửi ":description"',
    'delete_transfer'                                                           => 'Xóa chuyển ":description"',
    'deleted_withdrawal'                                                        => 'Đã xóa thành công rút tiền ":description"',
    'deleted_deposit'                                                           => 'Đã gửi thành công tiền gửi ":description"',
    'deleted_transfer'                                                          => 'Xóa thành công chuyển khoản ":description"',
    'deleted_reconciliation'                                                    => 'Tạo thành công giao dịch mới ":description"',
    'stored_journal'                                                            => 'Tạo thành công giao dịch mới ":description"',
    'stored_journal_js'                                                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                                                   => 'Tạo thành công giao dịch mới của bạn',
    'updated_journal_no_descr'                                                  => 'Cập nhật thành công giao dịch của bạn',
    'select_transactions'                                                       => 'Chọn giao dịch',
    'rule_group_select_transactions'                                            => 'Áp dụng ":title" vào giao dịch',
    'rule_select_transactions'                                                  => 'Áp dụng ":title" vào giao dịch',
    'stop_selection'                                                            => 'Dừng chọn giao dịch',
    'reconcile_selected'                                                        => 'Đối chiếu',
    'mass_delete_journals'                                                      => 'Xóa một số giao dịch',
    'mass_edit_journals'                                                        => 'Chỉnh sửa một số giao dịch',
    'mass_bulk_journals'                                                        => 'Chỉnh sửa hàng loạt một số giao dịch',
    'mass_bulk_journals_explain'                                                => 'Biểu mẫu này cho phép bạn thay đổi thuộc tính của các giao dịch được liệt kê bên dưới trong một bản cập nhật quét. Tất cả các giao dịch trong bảng sẽ được cập nhật khi bạn thay đổi các tham số bạn thấy ở đây.',
    'part_of_split'                                                             => 'Giao dịch này là một phần của giao dịch phân chia. Nếu bạn chưa chọn tất cả các phần tách, bạn có thể chỉ thay đổi một nửa giao dịch.',
    'bulk_set_new_values'                                                       => 'Sử dụng các đầu vào bên dưới để đặt giá trị mới. Nếu bạn để trống, chúng sẽ được làm trống cho tất cả. Ngoài ra, lưu ý rằng chỉ rút tiền sẽ được cấp ngân sách.',
    'no_bulk_category'                                                          => 'Đừng cập nhật danh mục',
    'no_bulk_budget'                                                            => 'Đừng cập nhật ngân sách',
    'no_bulk_tags'                                                              => 'Đừng cập nhật nhãn',
    'replace_with_these_tags'                                                   => 'Replace with these tags',
    'append_these_tags'                                                         => 'Add these tags',
    'mass_edit'                                                                 => 'Chỉnh sửa được chọn riêng',
    'bulk_edit'                                                                 => 'Chỉnh sửa được chọn hàng loạt',
    'mass_delete'                                                               => 'Xóa đã chọn',
    'cannot_edit_other_fields'                                                  => 'Bạn không thể chỉnh sửa hàng loạt các trường khác ngoài các trường ở đây, vì không có chỗ để hiển thị chúng. Vui lòng theo liên kết và chỉnh sửa từng cái một, nếu bạn cần chỉnh sửa các trường này.',
    'cannot_change_amount_reconciled'                                           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                                                 => '(không có ngân sách)',
    'no_bill'                                                                   => '(no subscription)',
    'account_per_budget'                                                        => 'Tài khoản trên mỗi ngân sách',
    'account_per_category'                                                      => 'Tài khoản mỗi danh mục',
    'create_new_object'                                                         => 'Tạo',
    'empty'                                                                     => '(trống)',
    'all_other_budgets'                                                         => '(tất cả các ngân sách khác)',
    'all_other_accounts'                                                        => '(tất cả các tài khoản khác)',
    'expense_per_source_account'                                                => 'Chi phí cho mỗi tài khoản nguồn',
    'expense_per_destination_account'                                           => 'Chi phí cho mỗi tài khoản đích',
    'income_per_destination_account'                                            => 'Thu nhập trên tài khoản đích',
    'spent_in_specific_category'                                                => 'Chi tiêu trong danh mục ":category"',
    'earned_in_specific_category'                                               => 'Kiếm được trong danh mục ":category"',
    'spent_in_specific_tag'                                                     => 'Chi tiêu trong nhãn ":tag"',
    'earned_in_specific_tag'                                                    => 'Kiếm được trong nhãn ":tag"',
    'income_per_source_account'                                                 => 'Thu nhập trên mỗi tài khoản nguồn',
    'average_spending_per_destination'                                          => 'Chi phí trung bình cho mỗi tài khoản nguồn tài khoản đích',
    'average_spending_per_source'                                               => 'Chi phí trung bình trên mỗi tài khoản nguồn',
    'average_earning_per_source'                                                => 'Thu nhập trung bình trên mỗi tài khoản nguồn',
    'average_earning_per_destination'                                           => 'Thu nhập trung bình trên mỗi tài khoản đích',
    'account_per_tag'                                                           => 'Tài khoản trên mỗi nhãn',
    'tag_report_expenses_listed_once'                                           => 'Chi phí và thu nhập không bao giờ được liệt kê hai lần. Nếu một giao dịch có nhiều nhãn, nó chỉ có thể hiển thị dưới một trong các nhãn của nó. Danh sách này có thể bị thiếu dữ liệu, nhưng số tiền sẽ chính xác.',
    'double_report_expenses_charted_once'                                       => 'Chi phí và thu nhập không bao giờ được hiển thị hai lần. Nếu một giao dịch có nhiều nhãn, nó chỉ có thể hiển thị dưới một trong các nhãn của nó. Biểu đồ này có thể thiếu dữ liệu, nhưng số tiền sẽ chính xác.',
    'tag_report_chart_single_tag'                                               => 'Biểu đồ này áp dụng cho một nhãn duy nhất. Nếu một giao dịch có nhiều nhãn, những gì bạn thấy ở đây cũng có thể được phản ánh trong biểu đồ của các nhãn khác.',
    'tag'                                                                       => 'Nhãn',
    'no_budget_squared'                                                         => '(không có ngân sách)',
    'perm-delete-many'                                                          => 'Xóa nhiều mục trong một lần có thể rất khó chịu. Hãy thận trọng. Bạn có thể xóa một phần của giao dịch tách khỏi trang này, vì vậy hãy cẩn thận.',
    'mass_deleted_transactions_success'                                         => 'Đã xóa :count giao dịch. | Đã xóa :count giao dịch.',
    'mass_edited_transactions_success'                                          => 'Cập nhật :count giao dịch. | Cập nhật :count giao dịch.',
    'opt_group_'                                                                => '(không có loại tài khoản)',
    'opt_group_no_account_type'                                                 => '(không có loại tài khoản)',
    'opt_group_defaultAsset'                                                    => 'tài khoản mặc định',
    'opt_group_savingAsset'                                                     => 'Tài khoản tiết kiệm',
    'opt_group_sharedAsset'                                                     => 'tài khoản dùng chung',
    'opt_group_ccAsset'                                                         => 'Thẻ tín dụng',
    'opt_group_cashWalletAsset'                                                 => 'Ví tiền mặt',
    'opt_group_expense_account'                                                 => 'Tài khoản chi phí',
    'opt_group_revenue_account'                                                 => 'Tài khoản doanh thu',
    'opt_group_l_Loan'                                                          => 'Nợ: Cho vay',
    'opt_group_cash_account'                                                    => 'Tài khoản tiền mặt',
    'opt_group_l_Debt'                                                          => 'Nợ: Nợ',
    'opt_group_l_Mortgage'                                                      => 'Nợ: Thế chấp',
    'opt_group_l_Credit card'                                                   => 'Nợ: Thẻ tín dụng',
    'notes'                                                                     => 'Ghi chú',
    'view_notes'                                                                => 'View notes',
    'set_budget_limit_notes'                                                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                                                             => 'Edit notes',
    'update_bl_notes'                                                           => 'Update notes',
    'unknown_journal_error'                                                     => 'Không thể lưu trữ giao dịch. Vui lòng kiểm tra các tệp nhật ký.',
    'attachment_not_found'                                                      => 'Không thể tìm thấy tệp đính kèm này.',
    'journal_link_bill'                                                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                                                   => '<a href="transactions/show/{ID}">Giao dịch #{ID} ("{title}")</a> đã được lưu trữ.',
    'transaction_new_stored_link'                                               => '<a href="transactions/show/{ID}"> Giao dịch #{ID}</a> đã được lưu trữ.',
    'transaction_updated_link'                                                  => '<a href="transactions/show/{ID}">Transaction #{ID}</a> ("{title}") has been updated.',
    'transaction_updated_no_changes'                                            => '<a href="transactions/show/{ID}">Transaction #{ID}</a> ("{title}") did not receive any changes.',
    'first_split_decides'                                                       => 'The first split determines the value of this field',
    'first_split_overrules_source'                                              => 'The first split may overrule the source account',
    'first_split_overrules_destination'                                         => 'The first split may overrule the destination account',
    'spent_x_of_y'                                                              => 'Spent {amount} of {total}',

    // new user:
    'welcome'                                                                   => 'Chào mừng đến với Firefly III!',
    'submit'                                                                    => 'Gửi',
    'submission'                                                                => 'Gửi',
    'submit_yes_really'                                                         => 'Gửi (Tôi biết những gì tôi đang làm)',
    'getting_started'                                                           => 'Bắt đầu',
    'to_get_started'                                                            => 'Thật tốt khi thấy bạn đã cài đặt thành công Firefly III. Để bắt đầu với công cụ này, vui lòng nhập tên ngân hàng của bạn và số dư tài khoản của bạn. Đừng lo lắng nếu bạn có nhiều tài khoản. Bạn có thể thêm chúng sau. Chỉ là Firefly III cần một cái gì đó để bắt đầu.',
    'savings_balance_text'                                                      => 'Firefly III sẽ tự động tạo một tài khoản tiết kiệm cho bạn. Theo mặc định, sẽ không có tiền trong tài khoản tiết kiệm của bạn, nhưng nếu bạn nói với Firefly III, số dư sẽ được lưu trữ như vậy.',
    'finish_up_new_user'                                                        => 'Đó là nó! Bạn có thể tiếp tục bằng cách nhấn <strong>Submit</strong>. Ybạn sẽ được đưa đến chỉ số của Firefly III.',
    'stored_new_accounts_new_user'                                              => 'Yeah! Tài khoản mới của bạn đã được lưu trữ.',
    'set_preferred_language'                                                    => 'Nếu bạn thích sử dụng Firefly III trong một ngôn ngữ khác, vui lòng cho biết tại đây.',
    'language'                                                                  => 'Ngôn ngữ',
    'new_savings_account'                                                       => ':bank_name tài khoản tiết kiệm',
    'cash_wallet'                                                               => 'Ví tiền mặt',
    'currency_not_present'                                                      => 'Nếu loại tiền bạn thường sử dụng không được liệt kê, đừng lo lắng. Bạn có thể tạo tiền tệ của riêng bạn trong Tùy chọn > Tiền tệ.',

    // home page:
    'transaction_table_description'                                             => 'A table containing your transactions',
    'opposing_account'                                                          => 'Opposing account',
    'yourAccounts'                                                              => 'Tài khoản của bạn',
    'your_accounts'                                                             => 'Tổng quan về tài khoản của bạn',
    'category_overview'                                                         => 'Tổng quan về danh mục',
    'expense_overview'                                                          => 'Tổng quan về tài khoản',
    'revenue_overview'                                                          => 'Tổng quan về tài khoản doanh thu',
    'budgetsAndSpending'                                                        => 'Ngân sách và chi tiêu',
    'budgets_and_spending'                                                      => 'Ngân sách và chi tiêu',
    'go_to_budget'                                                              => 'Đến ngân sách "{budget}"',
    'go_to_deposits'                                                            => 'Go to deposits',
    'go_to_expenses'                                                            => 'Go to expenses',
    'savings'                                                                   => 'Tiết kiệm',
    'newWithdrawal'                                                             => 'Chi phí mới',
    'newDeposit'                                                                => 'Tiền gửi mới',
    'newTransfer'                                                               => 'Chuyển khoản mới',
    'bills_to_pay'                                                              => 'Subscriptions to pay',
    'per_day'                                                                   => 'Mỗi ngày',
    'left_to_spend_per_day'                                                     => 'Còn lại để chi tiêu mỗi ngày',
    'bills_paid'                                                                => 'Subscriptions paid',
    'custom_period'                                                             => 'Custom period',
    'reset_to_current'                                                          => 'Reset to current period',
    'select_period'                                                             => 'Select a period',

    // menu and titles, should be recycled as often as possible:
    'currency'                                                                  => 'Tiền tệ',
    'preferences'                                                               => 'Cá nhân',
    'logout'                                                                    => 'Đăng xuất',
    'logout_other_sessions'                                                     => 'Logout all other sessions',
    'toggleNavigation'                                                          => 'Chuyển đổi đổigle navigation',
    'toggle_dropdown'                                                           => 'Toggle dropdown',
    'searchPlaceholder'                                                         => 'Tìm kiếm...',
    'version'                                                                   => 'Phiên bản',
    'dashboard'                                                                 => 'Bảng điều khiển',
    'income_and_expense'                                                        => 'Income and expense',
    'all_money'                                                                 => 'All your money',
    'unknown_source_plain'                                                      => 'Unknown source account',
    'unknown_dest_plain'                                                        => 'Unknown destination account',
    'unknown_any_plain'                                                         => 'Unknown account',
    'unknown_budget_plain'                                                      => 'No budget',
    'available_budget'                                                          => 'Ngân sách có sẵn ({currency})',
    'currencies'                                                                => 'Tiền tệ',
    'activity'                                                                  => 'Hoạt động',
    'usage'                                                                     => 'Sử dụng',
    'accounts'                                                                  => 'Tài khoản',
    'Asset account'                                                             => 'tài khoản',
    'Default account'                                                           => 'tài khoản',
    'Expense account'                                                           => 'Tài khoản chi phí',
    'Revenue account'                                                           => 'Tài khoản thu nhập',
    'Initial balance account'                                                   => 'Tài khoản số dư ban đầu',
    'account_type_Asset account'                                                => 'Asset account',
    'account_type_Expense account'                                              => 'Expense account',
    'account_type_Revenue account'                                              => 'Revenue account',
    'account_type_Debt'                                                         => 'Món nợ',
    'account_type_Loan'                                                         => 'Tiền vay',
    'account_type_Mortgage'                                                     => 'Thế chấp',
    'account_type_debt'                                                         => 'Debt',
    'account_type_loan'                                                         => 'Loan',
    'account_type_mortgage'                                                     => 'Mortgage',
    'account_type_Credit card'                                                  => 'Thẻ tín dụng',
    'credit_card_type_monthlyFull'                                              => 'Full payment every month',
    'liability_direction_credit'                                                => 'I am owed this debt',
    'liability_direction_debit'                                                 => 'I owe this debt to somebody else',
    'liability_direction_credit_short'                                          => 'Owed this debt',
    'liability_direction_debit_short'                                           => 'Owe this debt',
    'liability_direction__short'                                                => 'Unknown',
    'liability_direction_null_short'                                            => 'Unknown',
    'Liability credit'                                                          => 'Liability credit',
    'budgets'                                                                   => 'Ngân sách',
    'tags'                                                                      => 'Nhãn',
    'reports'                                                                   => 'Báo cáo',
    'transactions'                                                              => 'Giao dịch',
    'expenses'                                                                  => 'Chi phí',
    'income'                                                                    => 'Thu nhập doanh thu',
    'transfers'                                                                 => 'Chuyển',
    'moneyManagement'                                                           => 'Quản lý tiền bạc',
    'money_management'                                                          => 'Quản lý tiền bạc',
    'tools'                                                                     => 'Công cụ',
    'piggyBanks'                                                                => 'Heo đất',
    'piggy_banks'                                                               => 'Heo đất',
    'amount_x_of_y'                                                             => '{current} của {total}',
    'bills'                                                                     => 'Subscriptions',
    'withdrawal'                                                                => 'Rút tiền',
    'opening_balance'                                                           => 'Số dư đầu kỳ',
    'deposit'                                                                   => 'Tiền gửi',
    'account'                                                                   => 'Tài khoản',
    'transfer'                                                                  => 'Chuyển khoản',
    'Withdrawal'                                                                => 'Rút tiền',
    'Deposit'                                                                   => 'Tiền gửi',
    'Transfer'                                                                  => 'Chuyển khoản',
    'bill'                                                                      => 'Subscription',
    'yes'                                                                       => 'Đúng',
    'no'                                                                        => 'Không',
    'amount'                                                                    => 'Số tiền',
    'overview'                                                                  => 'Tổng quát',
    'saveOnAccount'                                                             => 'Lưu vào tài khoản',
    'saveOnAccounts'                                                            => 'Save on account(s)',
    'unknown'                                                                   => 'không xác định',
    'monthly'                                                                   => 'Hàng tháng',
    'profile'                                                                   => 'Hồ sơ',
    'errors'                                                                    => 'Lỗi',
    'debt_start_date'                                                           => 'Ngày bắt đầu nợ',
    'debt_start_amount'                                                         => 'Số tiền bắt đầu nợ',
    'debt_start_amount_help'                                                    => 'Nếu bạn nợ một khoản tiền tốt nhất để nhập số tiền âm, vì nó ảnh hưởng đến giá trị ròng của bạn. Nếu bạn nợ một khoản tiền tương tự. Kiểm tra các trang trợ giúp để biết thêm thông tin.',
    'interest_period_help'                                                      => 'Trường này sẽ không được tính cho bạn.',
    'store_new_liabilities_account'                                             => 'Lưu trữ nợ mới',
    'edit_liabilities_account'                                                  => 'Sửa nợ ":name"',
    'financial_control'                                                         => 'Kiểm soát tài chính',
    'accounting'                                                                => 'Tài khoản',
    'automation'                                                                => 'Tự động',
    'others'                                                                    => 'Khác',
    'classification'                                                            => 'Phân loại',
    'store_transaction'                                                         => 'Store transaction',



    // reports:
    'report_default'                                                            => 'Báo cáo tài chính mặc định giữa: start và: end',
    'report_audit'                                                              => 'Tổng quan về lịch sử giao dịch giữa: start và: end',
    'report_category'                                                           => 'Báo cáo danh mục giữa: bắt đầu và: kết thúc',
    'report_double'                                                             => 'Báo cáo tài khoản chi phí / doanh thu giữa: bắt đầu và: kết thúc',
    'report_budget'                                                             => 'Báo cáo ngân sách giữa: bắt đầu và: kết thúc',
    'report_tag'                                                                => 'Nhãn báo cáo giữa: :start và :end',
    'quick_link_reports'                                                        => 'Đường dẫn nhanh',
    'quick_link_examples'                                                       => 'Đây chỉ là một số liên kết ví dụ để giúp bạn bắt đầu. Kiểm tra các trang trợ giúp dưới nút (?) - để biết thông tin về tất cả các báo cáo và các từ ma thuật bạn có thể sử dụng.',
    'quick_link_default_report'                                                 => 'Báo cáo tài chính mặc định',
    'quick_link_audit_report'                                                   => 'Tổng quan về lịch sử giao dịch',
    'report_this_month_quick'                                                   => 'Tháng hiện tại, tất cả các tài khoản',
    'report_last_month_quick'                                                   => 'Tháng trước, tất cả tài khoản, tất cả tài khoản',
    'report_this_year_quick'                                                    => 'Năm hiện tại, tất cả các tài khoản',
    'report_this_fiscal_year_quick'                                             => 'Năm tài chính hiện tại, tất cả các tài khoản',
    'report_all_time_quick'                                                     => 'Mọi lúc, mọi tài khoản',
    'reports_can_bookmark'                                                      => 'Hãy nhớ rằng các báo cáo có thể được đánh dấu.',
    'incomeVsExpenses'                                                          => 'Thu nhập so với chi phí',
    'accountBalances'                                                           => 'Số dư tài khoản',
    'balanceStart'                                                              => 'Số dư đầu kỳ',
    'balanceEnd'                                                                => 'Số dư cuối kỳ',
    'splitByAccount'                                                            => 'Chia theo tài khoản',
    'coveredWithTags'                                                           => 'Được bao phủ bởi các nhãn',
    'leftInBudget'                                                              => 'Còn lại trong ngân sách',
    'left_in_debt'                                                              => 'Amount due',
    'sumOfSums'                                                                 => 'Tổng số tiền',
    'noCategory'                                                                => '(không danh mục)',
    'notCharged'                                                                => 'Không tính phí (chưa)',
    'inactive'                                                                  => 'Không hoạt động',
    'active'                                                                    => 'Hoạt động',
    'difference'                                                                => 'Sự khác biệt',
    'money_flowing_in'                                                          => 'Vào',
    'money_flowing_out'                                                         => 'Ra',
    'topX'                                                                      => 'đầu: số',
    'show_full_list'                                                            => 'Hiển thị toàn bộ danh sách',
    'show_only_top'                                                             => 'Chỉ hiển thị đầu: số',
    'report_type'                                                               => 'Loại báo cáo',
    'report_type_default'                                                       => 'Báo cáo tài chính mặc định',
    'report_type_audit'                                                         => 'Tổng quan về lịch sử giao dịch (kiểm toán)',
    'report_type_category'                                                      => 'Báo cáo danh mục',
    'report_type_budget'                                                        => 'Báo cáo ngân sách',
    'report_type_tag'                                                           => 'Báo cáo nhãn',
    'report_type_double'                                                        => 'Báo cáo tài khoản chi phí / doanh thu',
    'more_info_help'                                                            => 'Thông tin thêm về các loại báo cáo này có thể được tìm thấy trong các trang trợ giúp. Nhấn biểu tượng (?) Ở góc trên bên phải.',
    'report_included_accounts'                                                  => 'Bao gồm các tài khoản',
    'report_date_range'                                                         => 'Phạm vi ngày',
    'report_preset_ranges'                                                      => 'Phạm vi đặt trước',
    'shared'                                                                    => 'Đã chia sẻ',
    'fiscal_year'                                                               => 'Năm tài chính',
    'income_entry'                                                              => 'Thu nhập từ tài khoản ": name" giữa: start và: end',
    'expense_entry'                                                             => 'Chi phí cho tài khoản ": name" giữa: start và: end',
    'category_entry'                                                            => 'Chi phí và thu nhập trong danh mục ":name" giữa :start và :end',
    'budget_spent_amount'                                                       => 'Chi phí trong ngân sách ": ngân sách" giữa: bắt đầu và: kết thúc',
    'balance_amount'                                                            => 'Chi phí trong ngân sách ": ngân sách" được thanh toán từ tài khoản ": tài khoản" giữa: bắt đầu và: kết thúc',
    'no_audit_activity'                                                         => 'Không có hoạt động nào được ghi lại trên tài khoản <a href=":url" title=":account_name">:account_name</a> giữa: bắt đầu và: kết thúc.',
    'audit_end_balance'                                                         => 'Số dư tài khoản của <a href=":url" title=":account_name">:account_name</a> ở cuối: kết thúc là :: sự cân bằng',
    'reports_extra_options'                                                     => 'Tùy chọn bổ sung',
    'report_has_no_extra_options'                                               => 'Báo cáo này không có tùy chọn bổ sung',
    'reports_submit'                                                            => 'Xem báo cáo',
    'end_after_start_date'                                                      => 'Ngày kết thúc báo cáo phải sau ngày bắt đầu.',
    'select_category'                                                           => 'Chọn danh mục',
    'select_budget'                                                             => 'Chọn ngân sách.',
    'select_tag'                                                                => 'Chọn nhãn.',
    'income_per_category'                                                       => 'Thu nhập trên mỗi danh mục',
    'expense_per_category'                                                      => 'Chi phí cho mỗi loại',
    'expense_per_budget'                                                        => 'Chi phí cho mỗi ngân sách',
    'income_per_account'                                                        => 'Thu nhập trên mỗi tài khoản',
    'expense_per_account'                                                       => 'Chi phí cho mỗi tài khoản',
    'expense_per_tag'                                                           => 'Chi phí cho mỗi nhãn',
    'income_per_tag'                                                            => 'Thu nhập trên mỗi nhãn',
    'include_expense_not_in_budget'                                             => 'Bao gồm các chi phí không có trong ngân sách đã chọn',
    'include_expense_not_in_account'                                            => 'Bao gồm các chi phí không có trong tài khoản đã chọn',
    'include_expense_not_in_category'                                           => 'Bao gồm các chi phí không thuộc danh mục đã chọn',
    'include_income_not_in_category'                                            => 'Thu nhập đã bao gồm không thuộc danh mục đã chọn',
    'include_income_not_in_account'                                             => 'Thu nhập đã bao gồm không có trong tài khoản đã chọn',
    'include_income_not_in_tags'                                                => 'Thu nhập đã bao gồm không có trong nhãn đã chọn',
    'include_expense_not_in_tags'                                               => 'Bao gồm các chi phí không có trong (các) nhãn đã chọn',
    'everything_else'                                                           => 'Mọi thứ khác',
    'income_and_expenses'                                                       => 'Thu nhập và chi tiêu',
    'spent_average'                                                             => 'Chi tiêu (trung bình)',
    'income_average'                                                            => 'Thu nhập (trung bình)',
    'transaction_count'                                                         => 'Số lượng giao dịch',
    'average_spending_per_account'                                              => 'Chi tiêu trung bình cho mỗi tài khoản',
    'average_income_per_account'                                                => 'Thu nhập trung bình trên mỗi tài khoản',
    'total'                                                                     => 'Toàn bộ',
    'description'                                                               => 'Sự miêu tả',
    'sum_of_period'                                                             => 'Tổng chu kỳ',
    'average_in_period'                                                         => 'Trung bình trong kỳ',
    'no_account_role'                                                           => '(no role)',
    'account_role_defaultAsset'                                                 => 'tài khoản mặc định',
    'account_role_sharedAsset'                                                  => 'tài khoản dùng chung',
    'account_role_savingAsset'                                                  => 'Tài khoản tiết kiệm',
    'account_role_ccAsset'                                                      => 'Thẻ tín dụng',
    'account_role_cashWalletAsset'                                              => 'Ví tiền mặt',
    'budget_chart_click'                                                        => 'Vui lòng nhấp vào tên ngân sách trong bảng trên để xem biểu đồ.',
    'category_chart_click'                                                      => 'Vui lòng nhấp vào tên danh mục trong bảng trên để xem biểu đồ.',
    'in_out_accounts'                                                           => 'Kiếm được và chi tiêu cho mỗi kết hợp',
    'in_out_accounts_per_asset'                                                 => 'Kiếm được và chi tiêu (trên mỗi tài khoản)',
    'in_out_per_category'                                                       => 'Kiếm được và chi tiêu cho mỗi danh mục',
    'out_per_budget'                                                            => 'Chi tiêu cho mỗi ngân sách',
    'select_expense_revenue'                                                    => 'Chọn tài khoản chi phí / doanh thu',
    'multi_currency_report_sum'                                                 => 'Vì danh sách này chứa các tài khoản có nhiều loại tiền tệ, nên số tiền bạn nhìn thấy có thể không có ý nghĩa. Báo cáo sẽ luôn trở về loại tiền mặc định của bạn.',
    'sum_in_default_currency'                                                   => 'Tổng tiền sẽ luôn bằng tiền tệ mặc định của bạn.',
    'net_filtered_prefs'                                                        => 'Biểu đồ này sẽ không bao giờ bao gồm các tài khoản có phần "Bao gồm giá trị ròng" không được chọn.',



    // charts:
    'chart'                                                                     => 'Đồ thị',
    'month'                                                                     => 'Tháng',
    'budget'                                                                    => 'Ngân sách',
    'spent'                                                                     => 'Đã chi',
    'spent_capped'                                                              => 'Spent (capped)',
    'spent_in_budget'                                                           => 'Đã chi trong ngân sách',
    'left_to_spend'                                                             => 'Còn lại để chi tiêu',
    'earned'                                                                    => 'Kiếm được',
    'overspent'                                                                 => 'Quá hạn',
    'left'                                                                      => 'Còn lại',
    'max-amount'                                                                => 'Số lượng tối đa',
    'min-amount'                                                                => 'Số lượng tối thiểu',
    'journal-amount'                                                            => 'Current subscription entry',
    'name'                                                                      => 'Tên',
    'expires_at'                                                                => 'Expires at',
    'date'                                                                      => 'Ngày',
    'date_and_time'                                                             => 'Date and time',
    'time'                                                                      => 'Time',
    'paid'                                                                      => 'Đã thanh toán',
    'unpaid'                                                                    => 'Chưa thanh toán',
    'day'                                                                       => 'Ngày',
    'budgeted'                                                                  => 'Ngân sách',
    'period'                                                                    => 'Chu kỳ',
    'balance'                                                                   => 'Tiền còn lại',
    'in_out_period'                                                             => 'In + out this period',
    'sum'                                                                       => 'Tổng',
    'summary'                                                                   => 'Tóm lược',
    'average'                                                                   => 'Trung bình',
    'balanceFor'                                                                => 'Số dư cho: tên',
    'no_tags'                                                                   => '(không có nhãn)',
    'nothing_found'                                                             => '(nothing found)',

    // page settings and wizard dialogs

    'page_settings_header'                                                      => 'Page settings',
    'visible_columns'                                                           => 'Visible columns',
    'accounts_to_show'                                                          => 'Accounts to show',
    'active_accounts_only'                                                      => 'Active accounts only',
    'in_active_accounts_only'                                                   => 'Inactive accounts only',
    'show_all_accounts'                                                         => 'Show all accounts',
    'group_accounts'                                                            => 'Group accounts',

    // piggy banks:
    'event_history'                                                             => 'Event history',
    'add_money_to_piggy'                                                        => 'Thêm tiền vào heo đất ":name"',
    'piggy_bank'                                                                => 'Heo đất',
    'new_piggy_bank'                                                            => 'Tạo heo đất mới',
    'store_piggy_bank'                                                          => 'Lưu trữ heo đất mới',
    'stored_piggy_bank'                                                         => 'Lưu trữ heo đất mới ":name"',
    'account_status'                                                            => 'Tình trạng tài khoản',
    'left_for_piggy_banks'                                                      => 'Còn lại cho heo đất',
    'sum_of_piggy_banks'                                                        => 'Tổng số heo đất',
    'saved_so_far'                                                              => 'Tiết kiệm cho đến nay',
    'saved_so_far_total'                                                        => 'Saved so far in total',
    'reset_history'                                                             => 'reset history',
    'reset_history_confirm'                                                     => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'                                                       => 'The piggy bank history has been reset',
    'left_to_save'                                                              => 'Còn lại để tiết kiệm',
    'suggested_amount'                                                          => 'Số tiền đề xuất hàng tháng để tiết kiệm',
    'add_money_to_piggy_title'                                                  => 'Thêm tiền vào heo đất ":name"',
    'remove_money_from_piggy_title'                                             => 'Xóa tiền từ heo đất ":name"',
    'add'                                                                       => 'Thêm vào',
    'no_money_for_piggy'                                                        => 'Bạn không có tiền để đặt vào heo đất.',
    'suggested_savings_per_month'                                               => 'Đề xuất mỗi tháng',

    'remove'                                                                    => 'Xóa',
    'max_amount_add'                                                            => 'Số tiền tối đa bạn có thể thêm là',
    'max_amount_remove'                                                         => 'Số tiền tối đa bạn có thể loại bỏ là',
    'update_piggy_button'                                                       => 'Cập nhật heo đất',
    'update_piggy_title'                                                        => 'Cập nhật heo đất ":name"',
    'updated_piggy_bank'                                                        => 'Đã cập nhật heo đất ":name"',
    'details'                                                                   => 'Chi tiết',
    'events'                                                                    => 'Sự kiện',
    'target_amount'                                                             => 'Số lượng mục tiêu',
    'start_date'                                                                => 'Ngày bắt đầu',
    'no_start_date'                                                             => 'Không có ngày bắt đầu',
    'target_date'                                                               => 'Ngày mục tiêu',
    'no_target_date'                                                            => 'Không có ngày mục tiêu',
    'table'                                                                     => 'Bàn',
    'delete_piggy_bank'                                                         => 'Xóa heo đất ":name"',
    'cannot_add_amount_piggy'                                                   => 'Không thể thêm: số tiền vào ":name".',
    'cannot_remove_from_piggy'                                                  => 'Không thể xóa :amount từ ":name".',
    'deleted_piggy_bank'                                                        => 'Xóa heo đất ":name"',
    'added_amount_to_piggy'                                                     => 'Đã thêm :amount vào ":name"',
    'removed_amount_from_piggy'                                                 => 'Đã xóa :amount từ ":name"',
    'piggy_events'                                                              => 'Liên quan heo đất ',

    // tags
    'delete_tag'                                                                => 'Xóa nhãn ":tag"',
    'deleted_tag'                                                               => 'Đã xóa nhãn ":tag"',
    'new_tag'                                                                   => 'Tạo nhãn mới',
    'edit_tag'                                                                  => 'Chỉnh sửa nhãn ":tag"',
    'updated_tag'                                                               => 'Đã cập nhật nhãn ":tag"',
    'created_tag'                                                               => 'Nhãn ":tag" đã được tạo!',

    'transaction_journal_information'                                           => 'Thông tin giao dịch',
    'transaction_journal_amount'                                                => 'Amount information',
    'transaction_journal_meta'                                                  => 'Thông tin tổng hợp',
    'transaction_journal_more'                                                  => 'Thêm thông tin',
    'basic_journal_information'                                                 => 'Basic transaction information',
    'transaction_journal_extra'                                                 => 'Extra information',
    'att_part_of_journal'                                                       => 'Được lưu trữ dưới ":journal"',
    'total_amount'                                                              => 'Tổng cộng',
    'number_of_decimals'                                                        => 'Số thập phân',



    // administration
    'invite_is_already_redeemed'                                                => 'The invite to ":address" has already been redeemed.',
    'invite_is_deleted'                                                         => 'The invite to ":address" has been deleted.',
    'invite_new_user_title'                                                     => 'Invite new user',
    'invite_new_user_text'                                                      => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                                                         => 'Email address',
    'invite_user'                                                               => 'Invite user',
    'user_is_invited'                                                           => 'Email address ":address" was invited to Firefly III',
    'administration'                                                            => 'Quản trị',
    'system_settings'                                                           => 'System settings',
    'code_already_used'                                                         => 'Invite code has been used',
    'user_administration'                                                       => 'Quản lý người dùng',
    'list_all_users'                                                            => 'Tất cả người dùng',
    'all_users'                                                                 => 'Tất cả người dùng',
    'instance_configuration'                                                    => 'Cấu hình',
    'firefly_instance_configuration'                                            => 'Firefly III configuration',
    'setting_single_user_mode'                                                  => 'Chế độ người dùng đơn',
    'setting_single_user_mode_explain'                                          => 'Theo mặc định, Firefly III chỉ cho phép một (1) người đăng ký là bạn. Đây là một biện pháp bảo mật, ngăn người khác sử dụng trừ khi bạn cho phép họ sử dụng. Đăng ký bị chặn. Khi bạn bỏ chọn hộp này, những người khác cũng có thể sử dụng.',
    'store_configuration'                                                       => 'Lưu trữ cấu hình',
    'single_user_administration'                                                => 'Người dùng quản lý :email',
    'edit_user'                                                                 => 'Chỉnh sửa người dùng :email',
    'hidden_fields_preferences'                                                 => 'You can enable more transaction options in your <a href="preferences">preferences</a>.',
    'user_data_information'                                                     => 'Dữ liệu người dùng',
    'user_information'                                                          => 'Thông tin người dùng',
    'total_size'                                                                => 'tổng kích thước',
    'budget_or_budgets'                                                         => ':count ngân sách',
    'budgets_with_limits'                                                       => ':count ngân sách với số tiền được định cấu hình',
    'nr_of_rules_in_total_groups'                                               => ':count_rules quy tắc trong :count_groups nhóm quy tắc',
    'tag_or_tags'                                                               => ':count nhãn',
    'configuration_updated'                                                     => 'Cấu hình đã được cập nhật',
    'setting_is_demo_site'                                                      => 'Trang web demo',
    'setting_is_demo_site_explain'                                              => 'Nếu bạn chọn hộp này, cài đặt này sẽ hoạt động như trang demo, có thể có tác dụng phụ kỳ lạ.',
    'block_code_bounced'                                                        => 'Email (s) bị trả về',
    'block_code_expired'                                                        => 'Tài khoản demo đã hết hạn',
    'no_block_code'                                                             => 'Không có lý do chặn hoặc người dùng không bị chặn',
    'demo_user_export'                                                          => 'The demo user cannot export data',
    'block_code_email_changed'                                                  => 'Người dùng chưa xác nhận địa chỉ email mới',
    'admin_update_email'                                                        => 'Trái với trang hồ sơ, người dùng sẽ KHÔNG được thông báo địa chỉ email của họ đã thay đổi!',
    'update_user'                                                               => 'Cập nhật người dùng',
    'updated_user'                                                              => 'Dữ liệu người dùng đã được thay đổi.',
    'delete_user'                                                               => 'Xóa người dùng :email',
    'user_deleted'                                                              => 'Người dùng đã bị xóa',
    'send_test_email'                                                           => 'Gửi tin nhắn email kiểm tra',
    'send_test_email_text'                                                      => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                                              => 'Gửi tin nhắn',
    'send_test_triggered'                                                       => 'Kiểm tra đã được kích hoạt. Kiểm tra hộp thư đến của bạn và các tệp nhật ký.',
    'give_admin_careful'                                                        => 'Người dùng được trao quyền quản trị có thể lấy đi của bạn. Hãy cẩn thận.',
    'admin_maintanance_title'                                                   => 'Bảo trì',
    'admin_maintanance_expl'                                                    => 'Some nifty buttons for Firefly III maintenance',
    'admin_maintenance_clear_cache'                                             => 'Xóa bộ nhớ đệm',
    'owner_notifications'                                                       => 'Admin notifications',
    'owner_notifications_expl'                                                  => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                                                          => 'Settings for notification channels',
    'notification_test_failed'                                                  => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                                                => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                                                    => 'Settings for notifications',
    'title_owner_notifications'                                                 => 'Owner notifications',
    'owner_notification_check_user_new_reg'                                     => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'                                    => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'                                      => 'A new version is available',
    'owner_notification_check_invite_created'                                   => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'                                  => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt'                             => 'An unknown user tries to login',
    'all_invited_users'                                                         => 'All invited users',
    'save_notification_settings'                                                => 'Save settings',
    'notification_settings'                                                     => 'Settings for notifications',
    'notification_settings_saved'                                               => 'The notification settings have been saved',
    'available_channels_title'                                                  => 'Available channels',
    'available_channels_expl'                                                   => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'                                           => 'Email',
    'slack_discord_double'                                                      => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'                                           => 'Slack',
    'notification_channel_name_ntfy'                                            => 'Ntfy.sh',
    'notification_channel_name_pushover'                                        => 'Pushover',
    'notification_channel_name_gotify'                                          => 'Gotify',
    'notification_channel_name_pushbullet'                                      => 'Pushbullet',
    'channel_not_available'                                                     => 'not available',
    'configure_channel_in_env'                                                  => 'needs environment variables',
    'test_notification_channel_name_email'                                      => 'Test email',
    'test_notification_channel_name_slack'                                      => 'Test Slack',
    'test_notification_channel_name_ntfy'                                       => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'                                   => 'Test Pushover',
    'test_notification_channel_name_gotify'                                     => 'Test Gotify',
    'test_notification_channel_name_pushbullet'                                 => 'Test Pushbullet',

    'split_transaction_title'                                                   => 'Mô tả giao dịch tách',
    'split_transaction_title_help'                                              => 'Nếu bạn tạo một giao dịch phân tách, phải có một mô tả toàn cầu cho tất cả các phân chia của giao dịch.',
    'split_title_help'                                                          => 'Nếu bạn tạo một giao dịch phân tách, phải có một mô tả toàn cầu cho tất cả các phân chia của giao dịch.',
    'you_create_transfer'                                                       => 'Bạn đang tạo một <strong>chuyển khoản</strong>.',
    'you_create_withdrawal'                                                     => 'Bạn đang tạo một <strong>rút tiền</strong>.',
    'you_create_deposit'                                                        => 'Bạn đang tạo một <strong>tiền gửi</strong>.',

    // links
    'journal_link_configuration'                                                => 'Cấu hình liên kết giao dịch',
    'create_new_link_type'                                                      => 'Tạo loại liên kết mới',
    'store_new_link_type'                                                       => 'Lưu trữ loại liên kết mới',
    'update_link_type'                                                          => 'Cập nhật loại liên kết',
    'edit_link_type'                                                            => 'Chỉnh sửa loại liên kết ":name"',
    'updated_link_type'                                                         => 'Cập nhật loại liên kết ":name"',
    'delete_link_type'                                                          => 'Xóa loại liên kết ":name"',
    'deleted_link_type'                                                         => 'Đã xóa loại liên kết ":name"',
    'stored_new_link_type'                                                      => 'Lưu trữ loại liên kết mới ":name"',
    'cannot_edit_link_type'                                                     => 'Không thể chỉnh sửa loại liên kết ":name"',
    'link_type_help_name'                                                       => 'Ie. "Bản sao"',
    'link_type_help_inward'                                                     => 'Ie. "bản sao"',
    'link_type_help_outward'                                                    => 'Ie. "được nhân đôi bởi"',
    'save_connections_by_moving'                                                => 'Lưu liên kết giữa các giao dịch này bằng cách di chuyển chúng sang loại liên kết khác:',
    'do_not_save_connection'                                                    => '(không lưu kết nối)',
    'link_transaction'                                                          => 'Liên kết giao dịch',
    'link_to_other_transaction'                                                 => 'Liên kết giao dịch này với giao dịch khác',
    'select_transaction_to_link'                                                => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                                                          => 'Giao dịch này',
    'transaction'                                                               => 'Giao dịch',
    'comments'                                                                  => 'Bình luận',
    'link_notes'                                                                => 'Bất kỳ ghi chú bạn muốn lưu trữ với các liên kết.',
    'invalid_link_selection'                                                    => 'Không thể liên kết các giao dịch này',
    'selected_transaction'                                                      => 'Giao dịch được chọn',
    'journals_linked'                                                           => 'Giao dịch được liên kết.',
    'journals_error_linked'                                                     => 'Các giao dịch này đã được liên kết.',
    'journals_link_to_self'                                                     => 'Bạn không thể liên kết một giao dịch với chính nó',
    'journal_links'                                                             => 'Liên kết giao dịch',
    'this_withdrawal'                                                           => 'Rút tiền này',
    'this_deposit'                                                              => 'Khoản tiền gửi này',
    'this_transfer'                                                             => 'Chuyển khoản này',
    'overview_for_link'                                                         => 'Tổng quan về loại liên kết ":name"',
    'source_transaction'                                                        => 'Giao dịch nguồn',
    'link_description'                                                          => 'Mô tả liên kết',
    'destination_transaction'                                                   => 'Giao dịch đích',
    'delete_journal_link'                                                       => 'Xóa liên kết giữa <a href=":source_link">:source</a> và <a href=":destination_link">:destination</a>',
    'deleted_link'                                                              => 'Xóa liên kết',

    // link translations:
    'Paid_name'                                                                 => 'Đã thanh toán',
    'Refund_name'                                                               => 'Hoàn tiền',
    'Reimbursement_name'                                                        => 'Hoàn trả',
    'Related_name'                                                              => 'Liên quan',
    'relates to_inward'                                                         => 'liên quan tới',
    'is (partially) refunded by_inward'                                         => 'được (một phần) hoàn lại tiền bởi',
    'is (partially) paid for by_inward'                                         => 'được (một phần) thanh toán cho',
    'is (partially) reimbursed by_inward'                                       => 'được (một phần) hoàn trả bởi',
    'inward_transaction'                                                        => 'Giao dịch trong',
    'outward_transaction'                                                       => 'Giao dịch bên ngoài',
    'relates to_outward'                                                        => 'liên quan tới',
    '(partially) refunds_outward'                                               => '(một phần) hoàn tiền',
    '(partially) pays for_outward'                                              => '(một phần) trả tiền cho',
    '(partially) reimburses_outward'                                            => '(một phần) hoàn trả',
    'is (partially) refunded by'                                                => 'được hoàn tiền bởi',
    'is (partially) paid for by'                                                => 'được thanh toán cho',
    'is (partially) reimbursed by'                                              => 'được hoàn trả bởi',
    'relates to'                                                                => 'liên quan tới',
    '(partially) refunds'                                                       => 'hoàn tiền *một phần(',
    '(partially) pays for'                                                      => 'thanh toán cho *một phần(',
    '(partially) reimburses'                                                    => 'hoàn trả *một phần)',

    // split a transaction:
    'splits'                                                                    => 'Tách',
    'add_another_split'                                                         => 'Thêm một phân chia khác',
    'cannot_edit_opening_balance'                                               => 'Bạn không thể chỉnh sửa số dư mở của tài khoản.',
    'no_edit_multiple_left'                                                     => 'Bạn đã chọn không có giao dịch hợp lệ để chỉnh sửa.',
    'breadcrumb_convert_group'                                                  => 'Chuyển đổi giao dịch',
    'convert_invalid_source'                                                    => 'Thông tin nguồn không hợp lệ cho giao dịch #%d.',
    'convert_invalid_destination'                                               => 'Thông tin đích không hợp lệ cho giao dịch #%d.',
    'create_another'                                                            => 'Sau khi lưu trữ, quay trở lại đây để tạo một cái khác.',
    'after_update_create_another'                                               => 'Sau khi cập nhật, quay lại đây để tiếp tục chỉnh sửa.',
    'store_as_new'                                                              => 'Lưu trữ như một giao dịch mới thay vì cập nhật.',
    'reset_after'                                                               => 'Đặt lại mẫu sau khi gửi',
    'errors_submission'                                                         => 'There was something wrong with your submission. Please check out the errors below.',
    'errors_submission_v2'                                                      => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'                                                  => 'Expand split',
    'transaction_remove_split'                                                  => 'Remove split',
    'transaction_collapse_split'                                                => 'Collapse split',

    // object groups
    'default_group_title_name'                                                  => '(chưa nhóm)',
    'default_group_title_name_plain'                                            => 'ungrouped',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'                                                   => 'Hãy tạo một tài khoản!',
    'no_accounts_intro_asset'                                                   => 'Bạn chưa có tài khoản tài khoản là tài khoản chính của bạn: tài khoản kiểm tra, tài khoản tiết kiệm, tài khoản dùng chung hoặc thậm chí thẻ tín dụng của bạn.',
    'no_accounts_imperative_asset'                                              => 'Để bắt đầu sử dụng Firefly III, bạn phải tạo ít nhất một tài khoản. Hãy làm như vậy ngay bây giờ:',
    'no_accounts_create_asset'                                                  => 'Tạo một tài khoản',
    'no_accounts_title_expense'                                                 => 'Hãy tạo một tài khoản chi phí!',
    'no_accounts_intro_expense'                                                 => 'Bạn chưa có tài khoản chi phí. Tài khoản chi tiêu là nơi bạn tiêu tiền, chẳng hạn như cửa hàng và siêu thị.',
    'no_accounts_imperative_expense'                                            => 'Tài khoản chi phí được tạo tự động khi bạn tạo giao dịch, nhưng bạn cũng có thể tạo một tài khoản theo cách thủ công, nếu bạn muốn. Hãy tạo ngay bây giờ:',
    'no_accounts_create_expense'                                                => 'Tạo một tài khoản chi phí',
    'no_accounts_title_revenue'                                                 => 'Hãy tạo một tài khoản doanh thu!',
    'no_accounts_intro_revenue'                                                 => 'Bạn chưa có tài khoản doanh thu. Tài khoản doanh thu là nơi bạn nhận được tiền, chẳng hạn như chủ nhân của bạn.',
    'no_accounts_imperative_revenue'                                            => 'Tài khoản doanh thu được tạo tự động khi bạn tạo giao dịch, nhưng bạn cũng có thể tạo một giao dịch theo cách thủ công, nếu bạn muốn. Hãy tạo ngay bây giờ:',
    'no_accounts_create_revenue'                                                => 'Tạo một tài khoản doanh thu',
    'no_accounts_title_liabilities'                                             => 'Hãy tạo một tài khoản nợ!',
    'no_accounts_intro_liabilities'                                             => 'Bạn chưa có tài khoản nợ. Nợ phải trả là các tài khoản đăng ký khoản vay (sinh viên) của bạn và các khoản nợ khác.',
    'no_accounts_imperative_liabilities'                                        => 'Bạn không phải sử dụng tính năng này, nhưng nó có thể hữu ích nếu bạn muốn theo dõi những điều này.',
    'no_accounts_create_liabilities'                                            => 'Tạo một tài khoản nợ',
    'no_budgets_title_default'                                                  => 'Hãy tạo một ngân sách',
    'no_rules_title_default'                                                    => 'Let\'s create a rule',
    'no_budgets_intro_default'                                                  => 'Bạn chưa có ngân sách. Ngân sách được sử dụng để sắp xếp chi tiêu của bạn thành các nhóm hợp lý, bạn có thể cung cấp giới hạn mềm để giới hạn chi phí của mình.',
    'no_rules_intro_default'                                                    => 'You have no rules yet. Rules are powerful automations that can handle transactions for you.',
    'no_rules_imperative_default'                                               => 'Rules can be very useful when you\'re managing transactions. Let\'s create one now:',
    'no_budgets_imperative_default'                                             => 'Ngân sách là công cụ cơ bản của quản lý tài chính. Hãy tạo ngay bây giờ:',
    'no_budgets_create_default'                                                 => 'Tạo ngân sách',
    'no_rules_create_default'                                                   => 'Create a rule',
    'no_categories_title_default'                                               => 'Hãy tạo một danh mục!',
    'no_categories_intro_default'                                               => 'Bạn chưa có danh mục nào. Danh mục được sử dụng để tinh chỉnh các giao dịch của bạn và gắn nhãn chúng với danh mục được chỉ định của chúng.',
    'no_categories_imperative_default'                                          => 'Danh mục được tạo tự động khi bạn tạo giao dịch, nhưng bạn cũng có thể tạo một giao dịch theo cách thủ công. Hãy tạo ngay bây giờ:',
    'no_categories_create_default'                                              => 'Tạo một danh mục',
    'no_tags_title_default'                                                     => 'Hãy tạo một nhãn!',
    'no_tags_intro_default'                                                     => 'Bạn chưa có nhãn nào. Các nhãn được sử dụng để tinh chỉnh các giao dịch của bạn và gắn nhãn chúng với các từ khóa cụ thể.',
    'no_tags_imperative_default'                                                => 'Nhãn được tạo tự động khi bạn tạo giao dịch, nhưng bạn cũng có thể tạo một nhãn theo cách thủ công. Hãy tạo ngay bây giờ:',
    'no_tags_create_default'                                                    => 'Tạo một nhãn',
    'no_transactions_title_withdrawal'                                          => 'Hãy tạo ra một chi phí!',
    'no_transactions_intro_withdrawal'                                          => 'Bạn chưa có chi phí nào. Bạn nên tạo chi phí để bắt đầu quản lý tài chính của mình.',
    'no_transactions_imperative_withdrawal'                                     => 'Bạn đã tiêu một số tiền? Sau đó, bạn nên thêm nó vào:',
    'no_transactions_create_withdrawal'                                         => 'Tạo một chi phí',
    'no_transactions_title_deposit'                                             => 'Hãy tạo thu nhập!',
    'no_transactions_intro_deposit'                                             => 'Bạn chưa có thu nhập được ghi nhận. Bạn nên tạo các mục thu nhập để bắt đầu quản lý tài chính của mình để tạo một số thu nhập.',
    'no_transactions_imperative_deposit'                                        => 'Bạn đã nhận được một số tiền? Sau đó, bạn nên thêm nó vào:',
    'no_transactions_create_deposit'                                            => 'Tạo một khoản tiền gửi',
    'no_transactions_title_transfers'                                           => 'Hãy tạo một chuyển khoản!',
    'no_transactions_intro_transfers'                                           => 'Bạn chưa có chuyển khoản nào. Khi bạn chuyển tiền giữa các tài khoản, nó được ghi lại dưới dạng chuyển khoản.',
    'no_transactions_imperative_transfers'                                      => 'Bạn đã chuyển một số tiền xung quanh? Sau đó, bạn nên thêm nó vào:',
    'no_transactions_create_transfers'                                          => 'Tạo chuyển khoản',
    'no_piggies_title_default'                                                  => 'Hãy tạo ra một con heo đất!',
    'no_piggies_intro_default'                                                  => 'Bạn chưa có con heo đất nào. Bạn có thể tạo con heo đất để chia tiền tiết kiệm của mình và theo dõi những gì bạn đang tiết kiệm.',
    'no_piggies_imperative_default'                                             => 'Bạn có những thứ bạn đang tiết kiệm tiền không? Tạo một con heo đất và theo dõi:',
    'no_piggies_create_default'                                                 => 'Tạo một con heo đất mới',
    'no_bills_title_default'                                                    => 'Let\'s create a subscription!',
    'no_bills_intro_default'                                                    => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'                                               => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'                                                   => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                                                      => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                                                          => 'Create right now',
    'no_new_transaction_in_recurrence'                                          => 'No new transaction was created. Perhaps it was already fired for this date?',
    'recurrences'                                                               => 'Giao dịch định kỳ',
    'repeat_until_in_past'                                                      => 'Giao dịch định kỳ này đã dừng lặp lại vào :date.',
    'recurring_calendar_view'                                                   => 'Lịch',
    'no_recurring_title_default'                                                => 'Hãy tạo một giao dịch định kỳ!',
    'no_recurring_intro_default'                                                => 'Bạn chưa có giao dịch định kỳ. Bạn có thể sử dụng những thứ này để Firefly III tự động tạo giao dịch cho bạn.',
    'no_recurring_imperative_default'                                           => 'Đây là một tính năng khá tiên tiến nhưng nó có thể cực kỳ hữu ích. Hãy chắc chắn rằng bạn đã đọc tài liệu (?) - biểu tượng ở góc trên bên phải) trước khi bạn tiếp tục.',
    'no_recurring_create_default'                                               => 'Tạo giao dịch định kỳ',
    'make_new_recurring'                                                        => 'Tạo giao dịch định kỳ',
    'recurring_daily'                                                           => 'Hằng ngày',
    'recurring_weekly'                                                          => 'Mỗi tuần vào: ngày trong tuần',
    'recurring_weekly_skip'                                                     => 'Mỗi ngày: bỏ qua (st / nd / nd / th) tuần vào: ngày trong tuần',
    'recurring_monthly'                                                         => 'Hàng tháng vào ngày: dayOfMonth (st / nd / rd / th) ngày',
    'recurring_monthly_skip'                                                    => 'Mỗi: bỏ qua (st / nd / nd / th) tháng vào: dayOfMonth (st / nd / rd / th) ngày',
    'recurring_ndom'                                                            => 'Hàng tháng vào: dayOfMonth (st / nd / rd / th): ngày trong tuần',
    'recurring_yearly'                                                          => 'Hàng năm vào: ngày',
    'overview_for_recurrence'                                                   => 'Tổng quan về giao dịch định kỳ ":title"',
    'warning_duplicates_repetitions'                                            => 'Trong các trường hợp hiếm hoi, ngày xuất hiện hai lần trong danh sách này. Điều này có thể xảy ra khi nhiều lần lặp lại va chạm. Firefly III sẽ luôn tạo một giao dịch mỗi ngày.',
    'created_transactions'                                                      => 'Giao dịch liên quan',
    'expected_withdrawals'                                                      => 'Rút tiền dự kiến',
    'expected_deposits'                                                         => 'Tiền gửi dự kiến',
    'expected_transfers'                                                        => 'Chuyển khoản dự kiến',
    'created_withdrawals'                                                       => 'Tạo rút tiền',
    'created_deposits'                                                          => 'Tạo tiền gửi',
    'created_transfers'                                                         => 'Tạo chuyển khoản',
    'recurring_info'                                                            => 'Recurring transaction :count / :total',
    'created_from_recurrence'                                                   => 'Được tạo từ giao dịch định kỳ ":title" (#:id)',
    'recurring_never_cron'                                                      => 'Có vẻ như công việc định kỳ cần thiết để hỗ trợ các giao dịch định kỳ chưa bao giờ chạy. Điều này là tất nhiên bình thường khi bạn vừa cài đặt Firefly III, nhưng đây sẽ là thứ cần thiết lập càng sớm càng tốt. Vui lòng kiểm tra các trang trợ giúp bằng biểu tượng (?) - ở góc trên cùng bên phải của trang.',
    'recurring_cron_long_ago'                                                   => 'Có vẻ như đã hơn 36 giờ kể từ khi công việc định kỳ hỗ trợ các giao dịch định kỳ được thực hiện lần cuối. Bạn có chắc chắn rằng nó đã được thiết lập chính xác? Vui lòng kiểm tra các trang trợ giúp bằng biểu tượng (?) - ở góc trên cùng bên phải của trang.',

    'create_new_recurrence'                                                     => 'Tạo giao dịch định kỳ mới',
    'help_first_date'                                                           => 'Cho biết sự tái phát dự kiến đầu tiên. Điều này phải trong tương lai.',
    'help_first_date_no_past'                                                   => 'Cho biết sự tái phát dự kiến đầu tiên. Firefly III sẽ không tạo giao dịch trong quá khứ.',
    'no_currency'                                                               => '(không có tiền tệ)',
    'mandatory_for_recurring'                                                   => 'Thông tin tái phát bắt buộc',
    'mandatory_for_transaction'                                                 => 'Thông tin giao dịch bắt buộc',
    'optional_for_recurring'                                                    => 'Thông tin tái phát tùy chọn',
    'optional_for_transaction'                                                  => 'Thông tin giao dịch tùy chọn',
    'change_date_other_options'                                                 => 'Thay đổi "ngày đầu tiên" để xem thêm tùy chọn.',
    'mandatory_fields_for_tranaction'                                           => 'Các giá trị ở đây sẽ kết thúc trong (các) giao dịch được tạo',
    'click_for_calendar'                                                        => 'Bấm vào đây để xem lịch cho bạn biết khi nào giao dịch sẽ lặp lại.',
    'repeat_forever'                                                            => 'Lặp lại mãi mãi',
    'repeat_until_date'                                                         => 'Lặp lại cho đến ngày',
    'repeat_times'                                                              => 'Lặp lại một số lần',
    'recurring_skips_one'                                                       => 'Mỗi cái khác',
    'recurring_skips_more'                                                      => 'Bỏ qua: số lần xuất hiện',
    'store_new_recurrence'                                                      => 'Lưu trữ giao dịch định kỳ',
    'stored_new_recurrence'                                                     => 'Giao dịch định kỳ ": title" được lưu trữ thành công.',
    'edit_recurrence'                                                           => 'Chỉnh sửa giao dịch định kỳ ":title"',
    'recurring_repeats_until'                                                   => 'Lặp lại cho đến: ngày',
    'recurring_repeats_forever'                                                 => 'Lặp lại mãi mãi',
    'recurring_repeats_x_times'                                                 => 'Lặp lại: :count lần',
    'update_recurrence'                                                         => 'Cập nhật giao dịch định kỳ',
    'updated_recurrence'                                                        => 'Cập nhật giao dịch định kỳ ":title"',
    'recurrence_is_inactive'                                                    => 'Giao dịch định kỳ này không hoạt động và sẽ không tạo giao dịch mới.',
    'delete_recurring'                                                          => 'Xóa giao dịch định kỳ ":title"',
    'new_recurring_transaction'                                                 => 'Giao dịch định kỳ mới',
    'help_weekend'                                                              => 'Firefly III nên làm gì khi giao dịch định kỳ rơi vào Thứ Bảy hoặc Chủ Nhật?',
    'do_nothing'                                                                => 'Chỉ cần tạo giao dịch',
    'skip_transaction'                                                          => 'Bỏ qua sự xuất hiện',
    'jump_to_friday'                                                            => 'Tạo giao dịch vào thứ Sáu trước đó thay thế',
    'jump_to_monday'                                                            => 'Tạo giao dịch vào thứ Hai tuần sau',
    'will_jump_friday'                                                          => 'Sẽ được tạo vào thứ Sáu thay vì cuối tuần.',
    'will_jump_monday'                                                          => 'Sẽ được tạo vào thứ Hai thay vì cuối tuần.',
    'except_weekends'                                                           => 'Trừ những ngày cuối tuần',
    'recurrence_deleted'                                                        => 'Đã xóa giao dịch định kỳ ":title"',



    // new lines for summary controller.
    'box_balance_in_currency'                                                   => 'Số dư (: tiền tệ)',
    'box_spent_in_currency'                                                     => 'Đã chi (: tiền tệ)',
    'box_earned_in_currency'                                                    => 'Kiếm được (: tiền tệ)',
    'box_budgeted_in_currency'                                                  => 'Ngân sách (: tiền tệ)',
    'box_bill_paid_in_currency'                                                 => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'                                               => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'                                             => 'Còn lại để chi tiêu (: tiền tệ)',
    'box_net_worth_in_currency'                                                 => 'Giá trị ròng (: tiền tệ)',
    'box_spend_per_day'                                                         => 'Còn lại để chi tiêu mỗi ngày: :amount',

    // debug page
    'debug_page'                                                                => 'Trang debug',
    'debug_submit_instructions'                                                 => 'Nếu bạn đang gặp vấn đề, bạn có thể sử dụng thông tin trong hộp này làm thông tin gỡ lỗi. Vui lòng sao chép và dán vào một <a href="https://github.com/firefly-iii/firefly-iii/issues"> vấn đề GitHub mới hoặc hiện có </a>. Nó sẽ tạo ra một bảng có thể được sử dụng để chẩn đoán nhanh vấn đề của bạn.',
    'debug_pretty_table'                                                        => 'Nếu bạn sao chép / dán hộp bên dưới vào GitHub, nó sẽ tạo ra một bảng. Xin vui lòng không bao quanh văn bản này với backticks hoặc dấu ngoặc kép.',
    'debug_additional_data'                                                     => 'Bạn cũng có thể chia sẻ nội dung của hộp bên dưới. Bạn cũng có thể sao chép và dán phần này vào một <a href="https://github.com/firefly-iii/firefly-iii/issues"> vấn đề GitHub mới hoặc hiện có </a>. Tuy nhiên, nội dung của hộp này có thể chứa thông tin cá nhân như tên tài khoản, chi tiết giao dịch hoặc địa chỉ email.',

    // object groups
    'object_groups_menu_bar'                                                    => 'Các Nhóm',
    'object_groups_page_title'                                                  => 'Các Nhóm',
    'object_groups_breadcrumb'                                                  => 'Các Nhóm',
    'object_groups_index'                                                       => 'Tổng quan',
    'object_groups'                                                             => 'Các Nhóm',
    'object_groups_empty_explain'                                               => 'Một số điều trong Firefly III có thể được chia thành các nhóm. Ví dụ, các ống heo, có trường "Nhóm" trong chỉnh sửa và tạo. Khi bạn đặt trường này, bạn có thể chỉnh sửa tên và thứ tự của các nhóm trên trang này. Để biết thêm thông tin, hãy xem các trang trợ giúp ở góc trên bên phải, dưới biểu tượng (?) -.',
    'object_group_title'                                                        => 'Tiêu đề',
    'edit_object_group'                                                         => 'Chỉnh sửa nhóm ":title"',
    'delete_object_group'                                                       => 'Delete group ":title"',
    'update_object_group'                                                       => 'Cập nhật nhóm',
    'updated_object_group'                                                      => 'Successfully updated group ":title"',
    'deleted_object_group'                                                      => 'Successfully deleted group ":title"',
    'object_group'                                                              => 'Nhóm',

    // other stuff
    'placeholder'                                                               => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                                                         => 'Audit log entries',
    'ale_action_log_add'                                                        => 'Added :amount to piggy bank ":name"',
    'ale_action_log_remove'                                                     => 'Removed :amount from piggy bank ":name"',
    'ale_action_clear_budget'                                                   => 'Removed from budget',
    'ale_action_update_group_title'                                             => 'Updated transaction group title',
    'ale_action_update_date'                                                    => 'Updated transaction date',
    'ale_action_update_order'                                                   => 'Updated transaction order',
    'ale_action_clear_category'                                                 => 'Removed from category',
    'ale_action_clear_notes'                                                    => 'Removed notes',
    'ale_action_clear_tag'                                                      => 'Cleared tag',
    'ale_action_clear_all_tags'                                                 => 'Cleared all tags',
    'ale_action_set_bill'                                                       => 'Linked to subscription',
    'ale_action_switch_accounts'                                                => 'Switched source and destination account',
    'ale_action_set_budget'                                                     => 'Set budget',
    'ale_action_set_category'                                                   => 'Set category',
    'ale_action_set_source'                                                     => 'Set source account',
    'ale_action_set_destination'                                                => 'Set destination account',
    'ale_action_update_transaction_type'                                        => 'Changed transaction type',
    'ale_action_update_notes'                                                   => 'Changed notes',
    'ale_action_update_description'                                             => 'Changed description',
    'ale_action_add_to_piggy'                                                   => 'Piggy bank',
    'ale_action_remove_from_piggy'                                              => 'Piggy bank',
    'ale_action_add_tag'                                                        => 'Added tag',
    'ale_action_update_amount'                                                  => 'Updated amount',

    // dashboard
    'enable_auto_convert'                                                       => 'Enable currency conversion',
    'disable_auto_convert'                                                      => 'Disable currency conversion',
];
