<?php

/**
 * form.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // new user:
    'administration_currency'      => '原生貨幣',
    'bank_name'                    => '銀行名稱',
    'bank_balance'                 => '餘額',
    'current_balance'              => '目前餘額',
    'savings_balance'              => '儲蓄餘額',
    'credit_card_limit'            => '信用卡額度',
    'automatch'                    => '自動配對',
    'skip'                         => '略過',
    'enabled'                      => '已啟用',
    'name'                         => '名稱',
    'active'                       => '啟用',
    'amount_min'                   => '最小金額',
    'amount_max'                   => '最大金額',
    'match'                        => '配對於',
    'strict'                       => '嚴謹模式',
    'repeat_freq'                  => '重複',
    'object_group'                 => '群組',
    'location'                     => '地點',
    'update_channel'               => '更新頻道',
    'currency_id'                  => '貨幣',
    'transaction_currency_id'      => '貨幣',
    'auto_budget_currency_id'      => '貨幣',
    'external_ip'                  => '您的伺服器外部IP',
    'attachments'                  => '附加檔案',
    'BIC'                          => 'BIC',
    'verify_password'              => '驗證密碼安全性',
    'source_account'               => '來源帳戶',
    'destination_account'          => '目標帳戶',
    'asset_destination_account'    => '目標帳戶',
    'include_net_worth'            => '包括淨值',
    'asset_source_account'         => '來源帳戶',
    'journal_description'          => '說明',
    'note'                         => '備註',
    'currency'                     => '貨幣',
    'account_id'                   => '資產帳戶',
    'budget_id'                    => '預算',
    'bill_id'                      => 'Subscription',
    'opening_balance'              => '初始餘額',
    'tagMode'                      => '標籤模式',
    'virtual_balance'              => '虛擬餘額',



    'targetamount'                 => '目標金額',
    'target_amount'                => '目標金額',
    'account_role'                 => '帳戶角色',
    'opening_balance_date'         => '初始餘額日期',
    'cc_type'                      => '信用卡付款計劃',
    'cc_monthly_payment_date'      => '信用卡每月付款日期',
    'piggy_bank_id'                => '存錢筒',
    'returnHere'                   => '返回此處',
    'returnHereExplanation'        => '儲存後，返回這裡建立另一筆記錄。',
    'returnHereUpdateExplanation'  => '更新後，返回此處。',
    'description'                  => '描述',
    'expense_account'              => '支出帳戶',
    'revenue_account'              => '收入帳戶',
    'decimal_places'               => '小數位數',
    'destination_amount'           => '金額 (目標)',
    'new_email_address'            => '新電子郵件地址',
    'verification'                 => '驗證',
    'api_key'                      => 'API 金鑰',
    'remember_me'                  => '記住我',
    'liability_type_id'            => '負債類型',
    'liability_type'               => 'Liability type',
    'interest'                     => '利率',
    'interest_period'              => '利率期',
    'extension_date'               => 'Extension date',
    'type'                         => '類型',
    'convert_Withdrawal'           => '轉換提款',
    'convert_Deposit'              => '轉換存款',
    'convert_Transfer'             => '轉換轉帳',
    'amount'                       => '金額',
    'foreign_amount'               => '外幣金額',
    'date'                         => '日期',
    'interest_date'                => '利率日期',
    'book_date'                    => '登記日期',
    'process_date'                 => '處理日期',
    'category'                     => '分類',
    'tags'                         => '標籤',
    'deletePermanently'            => '永久刪除',
    'cancel'                       => '取消',
    'targetdate'                   => '目標日期',
    'target_date'                  => 'Target date',
    'startdate'                    => '開始日期',
    'start_date'                   => 'Start date',
    'tag'                          => '標籤',

    // exchange rates
    'from_currency_to_currency'    => '{from} &rarr; {to}',
    'to_currency_from_currency'    => '{to} &rarr; {from}',
    'rate'                         => 'Rate',

    'under'                        => '低於',
    'symbol'                       => '符號',
    'code'                         => '代碼',
    'iban'                         => '國際銀行帳戶號碼 (IBAN)',
    'account_number'               => '帳戶號碼',
    'creditCardNumber'             => '信用卡卡號',
    'has_headers'                  => '標題',
    'date_format'                  => '日期格式',
    'attachments[]'                => '附加檔案',
    'title'                        => '標題',
    'notes'                        => '備註',
    'filename'                     => '檔案名稱',
    'mime'                         => 'Mime 類型',
    'size'                         => '尺寸',
    'trigger'                      => '觸發器',
    'stop_processing'              => '停止處理',
    'end_date'                     => 'End date',
    'enddate'                      => 'End date',
    'move_rules_before_delete'     => 'Rule group',
    'start'                        => 'Start of range',
    'end'                          => 'End of range',
    'delete_account'               => '刪除帳戶 ":name"',
    'delete_webhook'               => '刪除 webhook ":title"',
    'delete_bill'                  => '刪除訂閱 ":name"',
    'delete_budget'                => '刪除預算 ":name"',
    'delete_category'              => '刪除分類 ":name"',
    'delete_currency'              => '刪除貨幣 ":name"',
    'delete_journal'               => '刪除包含描述 ":description" 的交易',
    'delete_attachment'            => '刪除附加檔案 ":name"',
    'delete_rule'                  => '刪除規則 ":title"',
    'delete_rule_group'            => '刪除規則群組 ":title"',
    'delete_link_type'             => '刪除連結類型 ":name"',
    'delete_user'                  => '刪除使用者 ":email"',
    'delete_recurring'             => '刪除定期交易 ":title"',
    'user_areYouSure'              => '如果您刪除使用者 ":email"，該名使用者的任何資訊均會消失，無法復原。如果您刪除自己，將無法進入此 Firefly III 版本。',
    'attachment_areYouSure'        => '你確定你想要刪除附加檔案 ":name"?',
    'account_areYouSure'           => '你確定你想要刪除名為 ":name" 的帳戶?',
    'account_areYouSure_js'        => 'Are you sure you want to delete the account named "{name}"?',
    'bill_areYouSure'              => '您確定要刪除名為 ":name" 的訂閱嗎？',
    'rule_areYouSure'              => '你確定你想要刪除名為 ":title" 的規則?',
    'object_group_areYouSure'      => '您確定要刪除標題為 ":title" 的群組嗎？',
    'ruleGroup_areYouSure'         => '你確定你想要刪除名為 ":title" 的規則群組?',
    'budget_areYouSure'            => '你確定你想要刪除名為 ":name" 的預算?',
    'webhook_areYouSure'           => '您確定要刪除名為 ":title" 的 webhook 嗎？',
    'category_areYouSure'          => '你確定你想要刪除名為 ":name" 的分類?',
    'recurring_areYouSure'         => '你確定你想要刪除名為 ":title" 的定期交易?',
    'currency_areYouSure'          => '你確定你想要刪除名為 ":name" 的貨幣?',
    'piggyBank_areYouSure'         => '你確定你想要刪除名為 ":name" 的小豬撲滿?',
    'journal_areYouSure'           => '你真的要刪除這個描述為 ":description" 的交易嗎？',
    'mass_journal_are_you_sure'    => '您確定要刪除這些交易嗎？',



    'tag_areYouSure'               => '你真的要要刪除標籤 ":tag" 嗎？',
    'journal_link_areYouSure'      => '您確定您要刪除 <a href=":source_link">:source</a> 與 <a href=":destination_link">:destination</a> 間的連結嗎？',
    'linkType_areYouSure'          => '您確定您要刪除連結類型 ":name" (":inward" / ":outward")?',
    'permDeleteWarning'            => '自 Firefly III 刪除項目是永久且不可撤銷的。',
    'mass_make_selection'          => '您還可以取消核取方塊的勾選，以避免刪除項目。',
    'delete_all_permanently'       => '永久刪除已選項目',
    'update_all_journals'          => '更新這些交易',
    'also_delete_transactions'     => '與此帳戶連接的唯一一筆交易也會被刪除。|與此帳戶連接的 :count 筆交易也會被刪除。',
    'also_delete_transactions_js'  => '沒有交易|與此帳戶連結的唯一交易也會被刪除|與此帳戶連結的全部 {count} 筆交易也會被刪除',
    'also_delete_connections'      => '與此連結類型連接的唯一一筆交易會遺失連接。|與此連結類型連接的 :count 筆交易會遺失連接。',
    'also_delete_rules'            => '與此規則群組連接的唯一一則規則也會被刪除。|與此規則群組連接的 :count 則規則也會被刪除。',
    'also_delete_piggyBanks'       => '與此帳戶連接的唯一一個小豬撲滿也會被刪除。|與此帳戶連接的 :count 個小豬撲滿也會被刪除。',
    'also_delete_piggyBanks_js'    => 'No piggy banks|The only piggy bank connected to this account will be deleted as well.|All {count} piggy banks connected to this account will be deleted as well.',
    'not_delete_piggy_banks'       => '與此群組連結的小豬撲滿不會被刪除。|與此群組連結的 :count 個小豬撲滿不會被刪除。',
    'bill_keep_transactions'       => '與此訂閱連結的唯一交易不會被刪除。|與此訂閱連結的 :count 筆交易不會被刪除。',
    'budget_keep_transactions'     => '與此預算連接的唯一一筆交易不會被刪除。|與此預算連接的 :count 筆交易不會被刪除。',
    'category_keep_transactions'   => '與此分類連接的唯一一筆交易不會被刪除。|與此分類連接的 :count 筆交易不會被刪除。',
    'recurring_keep_transactions'  => '由此定期交易建立的唯一一筆交易不會被刪除。|由此定期交易建立的 :count 筆交易不會被刪除。',
    'tag_keep_transactions'        => '與此標籤連接的唯一一筆交易不會被刪除。|與此標籤連接的 :count 筆交易不會被刪除。',
    'check_for_updates'            => '檢查更新',
    'liability_direction'          => '負債流向',
    'delete_object_group'          => '刪除群組 ":title"',
    'email'                        => '電子郵件地址',
    'password'                     => '密碼',
    'password_confirmation'        => '密碼 (再輸入一次)',
    'blocked'                      => '被封鎖了？',
    'blocked_code'                 => '封鎖的原因',
    'login_name'                   => '登入',
    'is_owner'                     => 'Is admin?',
    'url'                          => 'URL',
    'bill_end_date'                => 'End date',

    // import
    'apply_rules'                  => '套用規則',
    'artist'                       => '演出者',
    'album'                        => '專輯',
    'song'                         => '歌曲',

    // admin
    'domain'                       => '網域',
    'single_user_mode'             => '關閉使用者註冊',
    'is_demo_site'                 => '這是示範網站',

    // import
    'configuration_file'           => '組態檔案',
    'csv_comma'                    => '逗號 (,)',
    'csv_semicolon'                => '分號 (;)',
    'csv_tab'                      => 'TAB鍵 (不可見)',
    'csv_delimiter'                => 'CSV 欄位分隔符號',
    'client_id'                    => '客戶端 ID',
    'app_id'                       => 'App ID',
    'secret'                       => '金鑰',
    'public_key'                   => '公共金鑰',
    'country_code'                 => '國家代碼',
    'provider_code'                => '銀行或資料提供者',
    'fints_url'                    => 'FinTS API URL',
    'fints_port'                   => '埠',
    'fints_bank_code'              => '銀行代碼',
    'fints_username'               => '使用者名稱',
    'fints_password'               => 'PIN/密碼',
    'fints_account'                => 'FinTS 帳戶',
    'local_account'                => 'Firefly III 帳戶',



    'from_date'                    => '開始自',
    'to_date'                      => '日期至',
    'due_date'                     => '到期日',
    'payment_date'                 => '付款日期',
    'invoice_date'                 => '發票日期',
    'internal_reference'           => '內部參考',
    'inward'                       => '向內描述',
    'outward'                      => '外向描述',
    'rule_group_id'                => '規則群組',
    'transaction_description'      => '交易描述',
    'first_date'                   => '初次日期',
    'transaction_type'             => '交易類型',
    'repeat_until'                 => '重複直到',
    'recurring_description'        => '定期交易描述',
    'repetition_type'              => '重複類型',
    'foreign_currency_id'          => '外幣',
    'repetition_end'               => '重複結束',
    'repetitions'                  => '重複',
    'calendar'                     => '日曆',
    'weekend'                      => '週末',
    'client_secret'                => '客戶端金鑰',
    'withdrawal_destination_id'    => 'Destination account',
    'deposit_source_id'            => 'Source account',
    'expected_on'                  => 'Expected on',
    'paid'                         => 'Paid',
    'auto_budget_type'             => 'Auto-budget',
    'auto_budget_amount'           => 'Auto-budget amount',
    'auto_budget_period'           => 'Auto-budget period',
    'collected'                    => 'Collected',
    'submitted'                    => 'Submitted',
    'key'                          => 'Key',
    'value'                        => 'Content of record',
    'webhook_delivery'             => 'Delivery',
    'webhook_response'             => 'Response',
    'webhook_trigger'              => 'Trigger',
    'pushover_app_token'           => 'Pushover app token',
    'pushover_user_token'          => 'Pushover user token',
    'ntfy_server'                  => 'Ntfy server',
    'ntfy_topic'                   => 'Ntfy topic',
    'ntfy_auth'                    => 'Ntfy authentication enabled',
    'ntfy_user'                    => 'Ntfy 使用者名稱',
    'ntfy_pass'                    => 'Ntfy 密碼',
];
