<?php

/**
 * validation.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    'invalid_account_type'             => '小豬撲滿只能與資產帳戶和負債帳戶連結',
    'invalid_account_currency'         => '此帳戶並未使用您所選擇的貨幣',
    'current_amount_too_much'          => '「current_amount」中的合併金額不可超過「target_amount」。',
    'filter_must_be_in'                => '篩選器「:filter」必須是以下其中之一：:values',
    'filter_not_string'                => '篩選器「:filter」應為文字字串',
    'bad_api_filter'                   => '此 API 端點不支援將「:filter」作為篩選器。',
    'nog_logged_in'                    => '您尚未登入。',
    'bad_type_source'                  => 'Firefly III 無法根據此來源帳戶判定交易類型。',
    'bad_type_destination'             => 'Firefly III 無法根據此目標帳戶判定交易類型。',
    'missing_where'                    => '陣列缺少 "where" 子句',
    'missing_update'                   => '陣列缺少 "update" 子句',
    'invalid_where_key'                => 'JSON 在 "where" 子句中包含無效的鍵',
    'invalid_update_key'               => 'JSON 在 "update" 子句中包含無效的鍵',
    'invalid_query_data'               => '您的查詢在 %s:%s 欄位中含有無效資料。',
    'invalid_query_account_type'       => '您的查詢包含不同類型的帳戶，這是不允許的。',
    'invalid_query_currency'           => '您的查詢包含具有不同貨幣設定的帳戶，這是不允許的。',
    'iban'                             => '這不是有效的 IBAN。',
    'zero_or_more'                     => '此數值不能為負數。',
    'more_than_zero'                   => '此數值必須大於零。',
    'more_than_zero_correct'           => '此數值必須為零或更大。',
    'no_asset_account'                 => '這並不是資產帳戶。',
    'date_or_time'                     => '此數值須為有效的日期或時間值 (ISO 8601)。',
    'source_equals_destination'        => '來源帳戶與目標帳戶相同。',
    'unique_account_number_for_user'   => '此帳戶號碼似乎已在使用。',
    'unique_user_group_for_user'       => '此財務管理標題似乎已在使用。',
    'unique_iban_for_user'             => '此 IBAN 似乎已在使用。',
    'reconciled_forbidden_field'       => '此交易已對帳，無法變更「:field」。',
    'deleted_user'                     => '受安全限制，您無法使用此電子郵件地址註冊。',
    'rule_trigger_value'               => '此值不適用於選取的觸發器。',
    'rule_action_expression'           => '無效的運算式。:error',
    'rule_action_value'                => '此值不適用於選取的動作。',
    'file_already_attached'            => '上傳的檔案 ":name" 已附加到該物件上。',
    'file_attached'                    => '已成功上傳檔案 ":name"。',
    'file_zero'                        => '此檔案大小為零位元組。',
    'must_exist'                       => '欄位 :attribute 的 ID 不存在於資料庫。',
    'all_accounts_equal'               => '此欄位中的所有帳戶必須相等。',
    'group_title_mandatory'            => '多於一筆交易時，須要群組標題。',
    'transaction_types_equal'          => '所有拆分須為同一類型。',
    'invalid_transaction_type'         => '交易類型無效。',
    'invalid_selection'                => '您的選擇無效。',
    'belongs_user'                     => '此值連結到一個似乎不存在的物件。',
    'belongs_user_or_user_group'       => '此值連結到您目前的財務管理中似乎不存在的物件。',
    'no_access_group'                  => '使用者無權存取此財務管理。',
    'no_accepted_roles_defined'        => '此端點尚未定義任何存取角色，存取被拒絕。',
    'at_least_one_transaction'         => '至少需要一個交易。',
    'recurring_transaction_id'         => '至少需要一個交易。',
    'need_id_to_match'                 => '您需要使用 ID 提交此項目，以便 API 能夠對應它。',
    'too_many_unmatched'               => '提交的交易中有太多無法與資料庫中的對應記錄吻合。請確保現有的記錄具有有效 ID。',
    'id_does_not_match'                => '提交的 ID #:id 與預期的 ID 不符。請確保兩者一致或省略此欄位。',
    'at_least_one_repetition'          => '至少需要一次重複。',
    'require_repeat_until'             => '要嘛重複次數，要嘛結束日期 (repeat_until)，須二擇其一。',
    'require_currency_info'            => '此欄位內容須要貨幣資訊。',
    'not_transfer_account'             => '此帳戶無法用於轉帳。',
    'require_currency_amount'          => '此欄位內容須要外幣資訊。',
    'require_foreign_currency'         => '此欄位需要一個數字',
    'require_foreign_dest'             => '此欄位的貨幣必須與目標帳戶相同。',
    'require_foreign_src'              => '此欄位的貨幣必須與來源帳戶相同。',
    'equal_description'                => '交易描述不應等同全域描述。',
    'file_invalid_mime'                => '檔案 ":name" 類型為 ":mime"，不允許上載。',
    'file_too_large'                   => '檔案 ":name" 過大。',
    'belongs_to_user'                  => ':attribute 的值未知。',
    'accepted'                         => ':attribute 必須被接受。',
    'bic'                              => '這不是有效的 BIC。',
    'at_least_one_trigger'             => '規則必須至少有一個觸發器。',
    'at_least_one_active_trigger'      => '規則必須至少有一個啟用的觸發器。',
    'at_least_one_action'              => '規則必須至少有一個動作。',
    'at_least_one_active_action'       => '規則必須至少有一個啟用的動作。',
    'base64'                           => '這不是有效的 base64 編碼資料。',
    'model_id_invalid'                 => '指定的 ID 對於此模型似乎無效。',
    'less'                             => ':attribute 必須小於 10,000,000。',
    'active_url'                       => ':attribute 不是有效的 URL。',
    'after'                            => ':attribute 必須是一個在 :date 之後的日期。',
    'date_after'                       => '開始日期必須在結束日期之前。',
    'alpha'                            => ':attribute 只能包含字母。',
    'alpha_dash'                       => ':attribute 只能包含字母、數字和破折號。',
    'alpha_num'                        => ':attribute 只能包含數字和字母。',
    'array'                            => ':attribute 必須是一個陣列。',
    'unique_for_user'                  => '包括 :attribute 的紀錄已存在。',
    'before'                           => ':attribute 必須是一個在 :date 之前的日期。',
    'unique_object_for_user'           => '這個名稱已被使用。',
    'unique_account_for_user'          => '這個帳戶名稱已被使用。',



    'between.numeric'                  => ':attribute 必須介於 :min 和 :max 之間。',
    'between.file'                     => ':attribute 必須介於 :min kB 到 :max kB 之間。',
    'between.string'                   => ':attribute 必須介於 :min 到 :max 個字元之間。',
    'between.array'                    => ':attribute 必須介於 :min 到 :max 個項目之間。',
    'boolean'                          => ':attribute 欄位必須為 true 或 false。',
    'confirmed'                        => ':attribute 的確認並不相符。',
    'date'                             => ':attribute 不是一個有效的日期。',
    'date_format'                      => ':attribute 不符合 :format 格式。',
    'different'                        => ':attribute 和 :other 不能相同。',
    'digits'                           => ':attribute 必須是 :digits 位數字。',
    'digits_between'                   => ':attribute 必須介於 :min 和 :max 位數字之間。',
    'email'                            => ':attribute 必須是一個有效的電子郵件地址。',
    'filled'                           => ':attribute 欄位是必填的。',
    'exists'                           => '所選的 :attribute 無效。',
    'image'                            => ':attribute 必須是圖片。',
    'in'                               => '所選的 :attribute 無效。',
    'integer'                          => ':attribute 必須是整數。',
    'ip'                               => ':attribute 必須是一個有效的 IP 位址。',
    'json'                             => ':attribute 必須是一個有效的 JSON 字串。',
    'max.numeric'                      => ':attribute 不能大於 :max。',
    'max.file'                         => ':attribute 不能大於 :max kB。',
    'max.string'                       => ':attribute 不能大於 :max 個字元。',
    'max.array'                        => ':attribute 不能多於 :max 個項目。',
    'mimes'                            => ':attribute 的檔案類型必須是 :values 。',
    'min.numeric'                      => ':attribute 至少需要 :min。',
    'lte.numeric'                      => ':attribute 必須小於或等於 :value。',
    'min.file'                         => ':attribute 必須至少為 :min kB。',
    'min.string'                       => ':attribute 最少需要有 :min 個字元。',
    'min.array'                        => ':attribute 至少需要有 :min 個項目。',
    'not_in'                           => '所選的 :attribute 無效。',
    'numeric'                          => ':attribute 必須是數字。',
    'scientific_notation'              => ':attribute 無法使用科學記號。',
    'numeric_native'                   => '本地金額必須是數字。',
    'numeric_destination'              => '目標金額必須是數字。',
    'numeric_source'                   => '來源金額必須是數字。',
    'generic_invalid'                  => '此值無效。',
    'transaction_type_changed'         => '若您變更了交易類型，請確保已設定正確的來源／目標帳戶。',
    'regex'                            => ':attribute 格式無效。',
    'required'                         => ':attribute 欄位是必填的。',
    'required_if'                      => '當 :other 為 :value 時，欄位 :attribute 是必填的。',
    'required_unless'                  => '除非 :other 為 :values，否則欄位 :attribute 是必填的。',
    'required_with'                    => '當 :values​​ 存在時，欄位 :attribute 是必填的。',
    'required_with_all'                => '當 :values​​ 存在時，欄位 :attribute 是必填的。',
    'required_without'                 => '當 :values​​ 不存在時，欄位 :attribute 是必填的。',
    'required_without_all'             => '當沒有任何 :values​​ 存在時，欄位 :attribute 是必填的。',
    'same'                             => ':attribute 和 :other 必須相符。',
    'size.numeric'                     => ':attribute 必須是 :size。',
    'amount_min_over_max'              => '最小金額不能大於最大金額。',
    'size.file'                        => ':attribute 必須為 :size kB。',
    'size.string'                      => ':attribute 必須為 :size 個字元。',
    'size.array'                       => ':attribute 必須包含 :size 個項目。',
    'unique'                           => ':attribute 已被使用。',
    'string'                           => ':attribute 必須是字串。',
    'url'                              => ':attribute 格式無效。',
    'timezone'                         => ':attribute 必須是有效的時區。',
    '2fa_code'                         => '欄位 :attribute 無效。',
    'dimensions'                       => ':attribute 圖片尺寸無效。',
    'distinct'                         => '欄位 :attribute 有重複值。',
    'file'                             => ':attribute 必須是檔案。',
    'in_array'                         => '欄位 :attribute 不存在於 :other。',
    'present'                          => ':attribute 欄位必須存在。',
    'amount_zero'                      => '總金額不能為零。',
    'current_target_amount'            => '當前金額必須小於目標金額。',
    'unique_piggy_bank_for_user'       => '小豬撲滿的名稱必須是獨一無二的。',
    'unique_object_group'              => '此群組名稱必須是唯一的',
    'starts_with'                      => '此值必須以 :values 開頭。',
    'unique_webhook'                   => '您已擁有一個使用此 URL、觸發器、回應與傳遞方式的 webhook。',
    'unique_existing_webhook'          => '您已擁有另一個使用此 URL、觸發器、回應與傳遞方式的 webhook。',
    'same_account_type'                => '這兩個帳戶必須是相同的帳戶類型',
    'same_account_currency'            => '這兩個帳戶必須擁有相同的貨幣設定',
    'piggy_no_change_currency'         => '由於此帳戶已連結了小豬撲滿，無法更改此帳戶的貨幣設定。',



    'secure_password'                  => '這不是安全的密碼。請再試一次。如需更多資訊，請造訪 https://bit.ly/FF3-password',
    'valid_recurrence_rep_type'        => '定期重複交易的重複類型無效。',
    'valid_recurrence_rep_moment'      => '重複時刻在此重複類型無效。',
    'invalid_account_info'             => '無效的帳戶資訊。',
    'attributes'                       => [
        'email'                   => '電子郵件地址',
        'description'             => '描述',
        'amount'                  => '金額',
        'transactions.*.amount'   => '交易金額',
        'name'                    => '名稱',
        'piggy_bank_id'           => '小豬撲滿 ID',
        'targetamount'            => '目標金額',
        'opening_balance_date'    => '初始餘額日期',
        'opening_balance'         => '初始餘額',
        'match'                   => '符合',
        'amount_min'              => '最小金額',
        'amount_max'              => '最大金額',
        'title'                   => '標題',
        'tag'                     => '標籤',
        'transaction_description' => '交易描述',
        'rule-action-value.1'     => '規則動作值 #1',
        'rule-action-value.2'     => '規則動作值 #2',
        'rule-action-value.3'     => '規則動作值 #3',
        'rule-action-value.4'     => '規則動作值 #4',
        'rule-action-value.5'     => '規則動作值 #5',
        'rule-action.1'           => '規則動作 #1',
        'rule-action.2'           => '規則動作 #2',
        'rule-action.3'           => '規則動作 #3',
        'rule-action.4'           => '規則動作 #4',
        'rule-action.5'           => '規則動作 #5',
        'rule-trigger-value.1'    => '規則觸發器值 #1',
        'rule-trigger-value.2'    => '規則觸發器值 #2',
        'rule-trigger-value.3'    => '規則觸發器值 #3',
        'rule-trigger-value.4'    => '規則觸發器值 #4',
        'rule-trigger-value.5'    => '規則觸發器值 #5',
        'rule-trigger.1'          => '規則觸發器 #1',
        'rule-trigger.2'          => '規則觸發器 #2',
        'rule-trigger.3'          => '規則觸發器 #3',
        'rule-trigger.4'          => '規則觸發器 #4',
        'rule-trigger.5'          => '規則觸發器 #5',
    ],

    // validation of accounts:
    'withdrawal_source_need_data'      => '需要有效的來源帳戶 ID 及/或有效的來源帳戶名稱才能繼續。',
    'withdrawal_source_bad_data'       => '[a] 無法在搜尋 ID「:id」或名稱「:name」時找到有效的來源帳戶。',
    'withdrawal_dest_need_data'        => '[a] 需要有效的目標帳戶 ID 及/或有效的目標帳戶名稱才能繼續。',
    'withdrawal_dest_bad_data'         => '搜尋 ID ":id" 或名稱 ":name" 都找不到有效的目標帳戶。',

    'withdrawal_dest_iban_exists'      => '此目標帳戶的 IBAN 已被資產帳戶或負債帳戶使用，無法作為提領目標。',
    'deposit_src_iban_exists'          => '此來源帳戶的 IBAN 已被資產帳戶或負債帳戶使用，無法作為存款來源。',

    'reconciliation_source_bad_data'   => '搜尋 ID「:id」或名稱「:name」時無法找到有效的對帳帳戶。',

    'generic_source_bad_data'          => '[e] 在搜尋 ID「:id」或名稱「:name」時無法找到有效的來源帳戶。',

    'deposit_source_need_data'         => '需要有效的來源帳戶 ID 及/或有效的來源帳戶名稱才能繼續。',
    'deposit_source_bad_data'          => '[b] 在搜尋 ID「:id」或名稱「:name」時無法找到有效的來源帳戶。',
    'deposit_dest_need_data'           => '[b] 需要有效的目標帳戶 ID 及/或有效的目標帳戶名稱才能繼續。',
    'deposit_dest_bad_data'            => '搜尋 ID ":id" 或名稱 ":name" 都找不到有效的目標帳戶。',
    'deposit_dest_wrong_type'          => '提交的目標帳戶類型不正確。',



    'transfer_source_need_data'        => '需要有效的來源帳戶 ID 及/或有效的來源帳戶名稱才能繼續。',
    'transfer_source_bad_data'         => '[c] 在搜尋 ID「:id」或名稱「:name」時無法找到有效的來源帳戶。',
    'transfer_dest_need_data'          => '[c] 需要有效的目標帳戶 ID 及/或有效的目標帳戶名稱才能繼續。',
    'transfer_dest_bad_data'           => '搜尋 ID ":id" 或名稱 ":name" 都找不到有效的目標帳戶。',
    'need_id_in_edit'                  => '每筆拆分須有 transaction_journal_id (為有效的 ID 或是 0)。',

    'ob_source_need_data'              => '需要有效的來源帳戶 ID 及/或有效的來源帳戶名稱才能繼續。',
    'lc_source_need_data'              => '需要有效的來源帳戶 ID 才能繼續。',
    'ob_dest_need_data'                => '[d] 需要有效的目標帳戶 ID 及/或有效的目標帳戶名稱才能繼續。',
    'ob_dest_bad_data'                 => '搜尋 ID ":id" 或名稱 ":name" 都找不到有效的目標帳戶。',
    'reconciliation_either_account'    => '若要提交對帳，您必須提交來源帳戶或目標帳戶其中之一，不能同時提交或都不提交。',

    'generic_invalid_source'           => '您無法使用此帳戶作為來源帳戶。',
    'generic_invalid_destination'      => '您無法使用此帳戶作為目標帳戶。',

    'generic_no_source'                => '您必須提交來源帳戶資訊或提供交易日誌 ID。',
    'generic_no_destination'           => '您必須提交目標帳戶資訊或提供交易日誌 ID。',

    'gte.numeric'                      => ':attribute 必須大於或等於 :value。',
    'gt.numeric'                       => ':attribute 必須大於 :value。',
    'gte.file'                         => ':attribute 必須大於或等於 :value KB。',
    'gte.string'                       => ':attribute 必須大於或等於 :value 個字元。',
    'gte.array'                        => ':attribute 必須包含 :value 個或更多項目。',
    'missing_with'                     => ':attribute 無法與其他欄位同時使用。',

    'amount_required_for_auto_budget'  => '此金額為必填。',
    'auto_budget_amount_positive'      => '此金額必須大於零。',

    'auto_budget_period_mandatory'     => '自動預算週期為必填欄位。',

    // no access to administration:
    'no_auth_user_group'               => '您必須登入才能存取此財務管理。',
    'no_access_user_group'             => '您沒有存取此財務管理的正確權限。',
    'administration_owner_rename'      => '您無法重新命名您的預設財務管理。',
    'existing_mfa_code'                => '請輸入有效的驗證碼',
];
