<?php

/**
 * validation.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


declare(strict_types=1);

return [
    'webhook_budget_info'            => 'Cannot deliver budget information for transaction related webhooks.',
    'webhook_account_info'           => 'Cannot deliver account information for budget related webhooks.',
    'webhook_transaction_info'       => 'Cannot deliver transaction information for budget related webhooks.',
    'invalid_account_type'           => 'Скарбничка може бути зв\'язана лише з рахунками активів та боргами',
    'invalid_account_currency'       => 'Цей рахунок не використовує обрану вами валюту',
    'current_amount_too_much'        => 'Загальна сума в "current_amount" не може перевищувати "target_amount".',
    'filter_must_be_in'              => 'Фільтр ":filter" повинен бути одним з: :values',
    'filter_not_string'              => 'Фільтр ":filter" очікується рядком тексту',
    'bad_api_filter'                 => 'Ця API кінцева точка не підтримує ":filter" як фільтр.',
    'nog_logged_in'                  => 'Ви не ввійшли в систему.',
    'bad_type_source'                => 'Firefly III не може визначити тип транзакції, заснований на цьому вихідному обліковому записі.',
    'bad_type_destination'           => 'Firefly III не може визначити тип транзакції відповідно до цього облікового запису призначення.',
    'missing_where'                  => 'Масив не вистачає "where"-пункт',
    'missing_update'                 => 'Масив відсутній "update"-clause',
    'invalid_where_key'              => 'JSON містить неприпустимий ключ для "where"-речення',
    'invalid_update_key'             => 'JSON містить неприпустимий ключ для "update"-clause',
    'invalid_query_data'             => 'Неприпустимі дані в %s: поле%s вашого запиту.',
    'invalid_query_account_type'     => 'Ваш запит містить облікові записи різних типів, що не допускаються.',
    'invalid_query_currency'         => 'Ваш запит містить рахунки з різними параметрами валюти, що не допускаються.',
    'iban'                           => 'Це не коректний IBAN.',
    'zero_or_more'                   => 'Це значення не може бути від’ємним.',
    'more_than_zero'                 => 'Значення має бути більше нуля.',
    'more_than_zero_correct'         => 'Значення має бути нулем або більше.',
    'no_asset_account'               => 'Це не рахунок активів.',
    'date_or_time'                   => 'Значення має бути правильним датою або часом (ISO 8601).',
    'source_equals_destination'      => 'Початковий рахунок дорівнює рахунку призначення.',
    'unique_account_number_for_user' => 'Схоже, цей номер рахунку вже використовується.',
    'unique_user_group_for_user'     => 'Схоже, ця назва адміністрації вже використовується.',
    'unique_iban_for_user'           => 'Схоже, цей номер рахунку (IBAN) вже використовується.',
    'reconciled_forbidden_field'     => 'Ця операція вже виконана, ви не можете змінити:field"',
    'deleted_user'                   => 'Через обмеження безпеки ви не можете зареєструвати цю електронну адресу.',
    'rule_trigger_value'             => 'Це значення неправильне для вибраного тригера.',
    'rule_action_expression'         => 'Недопустимий вираз. :error',
    'rule_action_value'              => 'Це значення є неприпустимим для вибраної дії.',
    'file_already_attached'          => 'Файл ":name" вже прикріплено до цього об\'єкта.',
    'file_attached'                  => 'Успішно завантажено файл ":name".',
    'file_zero'                      => 'Розмір файлу дорівнює нуль байтів.',
    'must_exist'                     => 'ID в полі :attribute не існує в базі даних.',
    'all_accounts_equal'             => 'Всі рахунки в цьому полі повинні бути рівні.',
    'group_title_mandatory'          => 'Назва групи є обов\'язковою при наявності більше однієї транзакції.',
    'transaction_types_equal'        => 'Всі розділи повинні мати однаковий тип.',
    'invalid_transaction_type'       => 'Некоректний тип транзакції.',
    'invalid_selection'              => 'Ваш вибір є неприпустимим.',
    'belongs_user'                   => 'Це значення пов\'язане з об\'єктом, який, схоже, не існує.',
    'belongs_user_or_user_group'     => 'Це значення пов\'язане з об\'єктом, який, здається, не існує в поточній фінансовій адміністрації.',
    'no_access_group'                => 'Користувач не має доступу до цієї адміністрації.',
    'no_accepted_roles_defined'      => 'Для цієї кінцевої точки не визначено жодної ролі доступу, доступ заборонено.',
    'at_least_one_transaction'       => 'Потрібна хоча б одна транзакція.',
    'recurring_transaction_id'       => 'Потрібна хоча б одна транзакція.',
    'need_id_to_match'               => 'Вам потрібно відправити цей запис з ID щоб API міг мати можливість його співпадати.',
    'too_many_unmatched'             => 'Занадто багато сабмічених транзакцій не можна співставити зі своїми відповідними записами в базі даних. Переконайтеся, що існуючі записи мають правильний ID.',
    'id_does_not_match'              => 'Представлений ідентифікатор #:id не відповідає очікуваному ID. Переконайтеся, що він відповідає або пропустити це поле.',
    'at_least_one_repetition'        => 'Потрібно принаймні одне повторення.',
    'require_repeat_until'           => 'Потрібно вказати або кількість повторювань, або кінцеву дату (repeat_until). Але не обидва параметри разом.',
    'require_currency_info'          => 'Вміст цього поля є недійсним без інформації про валюту.',
    'require_currency_id_code'       => 'Please set either "transaction_currency_id" or "transaction_currency_code".',
    'not_transfer_account'           => 'Цей рахунок не є рахунком, який може бути використаний для переказу.',
    'require_currency_amount'        => 'Вміст цього поля є недійсним без інформації про валюту.',
    'require_foreign_currency'       => 'Це поле має бути числом',
    'require_foreign_dest'           => 'Це значення поля повинне відповідати валюті рахунку призначення.',
    'require_foreign_src'            => 'Це значення поля повинне відповідати валюті вихідного рахунку.',
    'equal_description'              => 'Опис транзакції має відрізнятися від глобального опису.',
    'file_invalid_mime'              => 'Файл ":name" має заборонений для завантаження тип ":mime".',
    'file_too_large'                 => 'Файл ":name" надто великий.',
    'belongs_to_user'                => 'Значення поля :attribute невідоме.',
    'accepted'                       => ':attribute має бути прийнятий.',
    'bic'                            => 'Це не коректний BIC.',
    'at_least_one_trigger'           => 'Правило має мати принаймні одну умову.',
    'at_least_one_active_trigger'    => 'Правило має мати принаймні одну умову.',
    'at_least_one_action'            => 'Правило має мати принаймні одну дію.',
    'at_least_one_active_action'     => 'Правило має мати принаймні одну дію.',
    'base64'                         => 'Base64 будьласка! Помилка розпізнавання.',
    'model_id_invalid'               => 'Вказаний ID здається недійсним для цієї моделі.',
    'less'                           => 'Поле :attribute має бути менше 10,000,000',
    'active_url'                     => ':attribute є не допустимою URL-адресою.',
    'after'                          => ':attribute має бути після :date.',
    'date_after'                     => 'Дата початку має бути раніше дати завершення.',
    'alpha'                          => ':attribute має містити лише літери.',
    'alpha_dash'                     => ':attribute має містити лише букви, цифри та тире.',
    'alpha_num'                      => ':attribute має містити лише літери та цифри.',
    'array'                          => ':attribute має бути масивом.',
    'unique_for_user'                => 'Запис :attribute уже існує.',
    'before'                         => ':attribute має бути датою до :date.',
    'unique_object_for_user'         => 'Ім\'я вже використовується.',
    'unique_account_for_user'        => 'Така назва рахунку вже існує.',


    'between.numeric'            => ':attribute повинен бути між :min і :max.',
    'between.file'               => 'Розмір :attribute має бути в межах між :min і :max кілобайтів.',
    'between.string'             => 'Довжина :attribute має бути в межах від :min до :max символів.',
    'between.array'              => ':attribute має містити від :min до :max елементів.',
    'boolean'                    => 'Поле :attribute має бути true або false.',
    'confirmed'                  => 'Підтвердження для :attribute не збігається.',
    'date'                       => ':attribute не є коректною датою.',
    'date_format'                => 'Значення :attribute не відповідає формату :format.',
    'different'                  => ':attribute має відрізнятися від :other.',
    'digits'                     => 'Довжина цифрового поля :attribute повинна бути :digits.',
    'digits_between'             => ':attribute має містити від :min до :max цифр.',
    'email'                      => ':attribute має бути дійсною адресою e-mail.',
    'filled'                     => 'Поле :attribute обов\'язкове.',
    'exists'                     => 'Обраний :attribute недійсний.',
    'image'                      => ':attribute має бути зображенням.',
    'in'                         => 'Обраний :attribute недійсний.',
    'integer'                    => ':attribute має бути цілим числом.',
    'ip'                         => 'Значення :attribute повинно бути дійсною IP-адресою.',
    'json'                       => 'Значення поля :attribute має бути коректним JSON рядком.',
    'max.numeric'                => 'Значення :attribute не може перевищувати :max.',
    'max.file'                   => 'Значення :attribute не може перевищувати :max кілобайт.',
    'max.string'                 => 'Значення :attribute не може перевищувати :max символів.',
    'max.array'                  => 'Поле :attribute повинне містити не більше :max елементів.',
    'mimes'                      => 'Поле :attribute повинне містити файл одного з типів: :values.',
    'min.numeric'                => 'Поле :attribute має бути принаймні :min.',
    'lte.numeric'                => 'Поле :attribute повинно бути меньше або дорівнювати :value.',
    'min.file'                   => ':attribute має становити щонайменше :min кілобайт.',
    'min.string'                 => 'Поле :attribute має бути принаймні :min символів.',
    'min.array'                  => 'Поле :attribute має містити принаймні :min елементів.',
    'not_in'                     => 'Обраний :attribute недійсний.',
    'numeric'                    => ':attribute має бути числом.',
    'convert_to_itself'          => 'Cannot store currency exchange rate for ":code", because from and to currency are the same.',
    'invalid_currency_code'      => 'Currency code ":code" is invalid',
    'scientific_notation'        => 'The :attribute не може використовувати наукову нотацію.',
    'numeric_primary'            => 'The primary currency amount must be a number.',
    'numeric_destination'        => 'Сума призначення повинна бути числом.',
    'numeric_source'             => 'Вихідна сума повинна бути числом.',
    'generic_invalid'            => 'Це значення недійсне.',
    'transaction_type_changed'   => 'Якщо ви змінюєте тип транзакції, переконайтеся, що встановлено правильні рахунки джерела/призначення.',
    'regex'                      => 'Неприпустимий формат поля :attribute.',
    'required'                   => 'Поле :attribute обов\'язкове.',
    'required_if'                => 'Поле :attribute є обов\'язковим для заповнення, коли :other є рівним :value.',
    'required_unless'            => 'Поле :attribute є обов\'язковим для заповнення, коли :other відрізняється від :values.',
    'required_with'              => 'Поле :attribute є обов\'язковим для заповнення, коли є :values.',
    'required_with_all'          => 'Поле :attribute є обов\'язковим для заповнення, коли є :values.',
    'required_without'           => 'Поле :attribute обов\'язкове коли :values відсутнє.',
    'required_without_all'       => 'Поле :attribute обов\'язкове коли жодне зі значень :values не існує.',
    'same'                       => ':attribute i :other мають спiвпадати.',
    'size.numeric'               => ':attribute має бути довжиною :size.',
    'amount_min_over_max'        => 'Мінімальна сума не може бути більшою за максимальну суму.',
    'size.file'                  => ':attribute має бути :size кілобайт.',
    'size.string'                => ':attribute має бути довжиною :size символів.',
    'size.array'                 => 'Поле :attribute повинно мати :size елементів.',
    'unique'                     => ':attribute вже зайнятий.',
    'string'                     => 'Поле :attribute повинне містити текст.',
    'url'                        => 'Неприпустимий формат поля :attribute.',
    'timezone'                   => ':attribute має знаходитися у відповідних межах.',
    '2fa_code'                   => 'Поле :attribute неправильне.',
    'dimensions'                 => ':attribute містить неприпустимі розміри зображення.',
    'distinct'                   => ':attribute містить дубльоване значення.',
    'file'                       => ':attribute повинен бути файлом.',
    'in_array'                   => 'Поле :attribute не існує в :other.',
    'present'                    => ':attribute обов\'язкоове.',
    'amount_zero'                => 'Загальна сума не може бути нульовою.',
    'current_target_amount'      => 'Поточна сума повинна бути меншою, ніж цільова сума.',
    'unique_piggy_bank_for_user' => 'Назва скарбнички має бути унікальною.',
    'unique_object_group'        => 'Назва групи повинна бути унікальною',
    'starts_with'                => 'Значення має починатися з :values.',
    'unique_webhook'             => 'У вас вже є веб хук з цією комбінацією URL, тригера, відповіді та доставкою.',
    'unique_existing_webhook'    => 'У вас вже є інший веб хук з цією комбінацією URL, тригера, відповіді та доставкою.',
    'same_account_type'          => 'Обидва рахунки повинні бути того самого типу',
    'same_account_currency'      => 'Обидва рахунки повинні мати однакові налаштування валюти',
    'piggy_no_change_currency'   => 'Оскільки до цього рахунку прив\'язані скарбнички, ви не можете змінити валюту рахунку.',


    'secure_password'             => 'Це не надійний пароль. Будь ласка, спробуйте ще раз. Для отримання додаткової інформації, перейдіть за посиланням https://bit.ly/FF3-password',
    'valid_recurrence_rep_type'   => 'Неприпустимий тип для повторюваних транзакцій.',
    'valid_recurrence_rep_moment' => 'Невірний період повторення для цого типу повторення.',
    'invalid_account_info'        => 'Невірні дані рахунка.',
    'attributes'                  => [
        'email'                   => 'eлектронна адреса',
        'description'             => 'опис',
        'amount'                  => 'сума',
        'transactions.*.amount'   => 'сума платежу',
        'name'                    => 'назва',
        'piggy_bank_id'           => 'iD скарбнички',
        'targetamount'            => 'сума накопичення',
        'opening_balance_date'    => 'дата початкового балансу',
        'opening_balance'         => 'початковий баланс',
        'match'                   => 'відповідає',
        'amount_min'              => 'мінімальна сума',
        'amount_max'              => 'максимальна сума',
        'title'                   => 'назва',
        'tag'                     => 'тег',
        'transaction_description' => 'опис транзакції',
        'rule-action-value.1'     => '"Значення дії #1"',
        'rule-action-value.2'     => '"Значення дії #2"',
        'rule-action-value.3'     => '"Значення дії #3"',
        'rule-action-value.4'     => '"Значення дії #4"',
        'rule-action-value.5'     => '"Значення дії #5"',
        'rule-action.1'           => '"Дія #1"',
        'rule-action.2'           => '"Дія #2"',
        'rule-action.3'           => '"Дія #3"',
        'rule-action.4'           => '"Дія #4"',
        'rule-action.5'           => '"Дія #5"',
        'rule-trigger-value.1'    => '"значення умови #1"',
        'rule-trigger-value.2'    => '"значення умови #2"',
        'rule-trigger-value.3'    => '"значення умови #3"',
        'rule-trigger-value.4'    => 'значення умови #4',
        'rule-trigger-value.5'    => 'значення умови #5',
        'rule-trigger.1'          => 'умова #1',
        'rule-trigger.2'          => 'умова #2',
        'rule-trigger.3'          => 'умова #3',
        'rule-trigger.4'          => 'умова #4',
        'rule-trigger.5'          => 'умова #5',
    ],

    // validation of accounts:
    'withdrawal_source_need_data' => 'Щоб продовжити, необхідно вказати дійсний ID рахунку і/або його назву.',
    'withdrawal_source_bad_data'  => '[a] Не вдалося знайти дійсний вихідний акаунт при пошуку з ID ":id" або ім\'я ":name".',
    'withdrawal_dest_need_data'   => '[a] Необхідно отримати дійсний ідентифікатор облікового запису або або правильне ім\'я облікового запису, щоб продовжити.',
    'withdrawal_dest_bad_data'    => 'Не вдалося знайти дійсний рахунок з ID ":id" або іменем ":name".',

    'withdrawal_dest_iban_exists' => 'Цей цільовий рахунок IBAN вже використовується активами рахунку або відповідальністю, і не можна використовувати в якості пункту призначення для зняття.',
    'deposit_src_iban_exists'     => 'Цей вихідний рахунок IBAN вже використовується в якості джерела депозиту або відповідальності й не може використовуватися в якості джерела поповнення.',

    'reconciliation_source_bad_data' => 'Не вдалося знайти дійсний рахунок призначення з ID ":id" або іменем ":name".',

    'generic_source_bad_data' => '[e] Не вдалося знайти дійсний вихідний акаунт при пошуку з ID ":id" або ім\'я ":name".',

    'deposit_source_need_data' => 'Щоб продовжити, необхідно вказати дійсний ID вихідного рахунку і/або його назву.',
    'deposit_source_bad_data'  => '[b] Не вдалося знайти дійсний вихідний акаунт при пошуку з ID ":id" або ім\'я ":name".',
    'deposit_dest_need_data'   => '[b] Необхідно отримати дійсний ідентифікатор облікового запису або або правильне ім\'я облікового запису, щоб продовжити.',
    'deposit_dest_bad_data'    => 'Не вдалося знайти дійсний рахунок призначення з ID ":id" або іменем ":name".',
    'deposit_dest_wrong_type'  => 'Збережений рахунок призначення - некоректний.',


    'transfer_source_need_data' => 'Щоб продовжити, необхідно вказати дійсний ID вихідного рахунку і/або його назву.',
    'transfer_source_bad_data'  => '[c] Не вдалося знайти дійсний вихідний акаунт при пошуку з ID ":id" або ім\'я ":name".',
    'transfer_dest_need_data'   => '[c] Необхідно отримати дійсний ідентифікатор облікового запису або або правильне ім\'я облікового запису, щоб продовжити.',
    'transfer_dest_bad_data'    => 'Не вдалося знайти дійсний рахунок призначення з ID ":id" або іменем ":name".',
    'need_id_in_edit'           => 'Кожна розділена транзакція повинна мати transaction_journal_id (дійсний ID або 0).',

    'ob_source_need_data'           => 'Щоб продовжити, необхідно вказати дійсний ID вихідного рахунку і/або його назву.',
    'lc_source_need_data'           => 'Необхідно отримати дійсний ID вихідного облікового запису, щоб продовжити.',
    'ob_dest_need_data'             => '[d] Необхідно отримати дійсний ідентифікатор облікового запису або або правильне ім\'я облікового запису, щоб продовжити.',
    'ob_dest_bad_data'              => 'Не вдалося знайти дійсний рахунок призначення з ID ":id" або іменем ":name".',
    'reconciliation_either_account' => 'Щоб підтвердити погодження, ви повинні надіслати або вихідний або цільовий обліковий запис. Не обидві, а не ніколи.',

    'generic_invalid_source'      => 'Ви не можете використовувати цей рахунок як вихідний.',
    'generic_invalid_destination' => 'Ви не можете використовувати цей рахунок як призначення.',

    'generic_no_source'      => 'Ви повинні надіслати інформацію про вихідний рахунок або надіслати ідентифікатор транзакції.',
    'generic_no_destination' => 'Ви повинні відправити інформацію про рахунок призначення або відправити журнал транзакції.',

    'gte.numeric'  => 'Поле :attribute має дорівнювати чи бути більше ніж :value.',
    'gt.numeric'   => 'Значення :attribute має бути більше за :value.',
    'gte.file'     => 'Поле :attribute має дорівнювати чи бути більше ніж :value кілобайт.',
    'gte.string'   => 'Кількість символів поля :attribute повинно бути більше або дорівнювати :value.',
    'gte.array'    => 'Поле :attribute має містити :value чи більше елементів.',
    'missing_with' => ':attribute не можна поєднувати з іншим полем.',

    'amount_required_for_auto_budget' => 'Необхідно вказати суму.',
    'auto_budget_amount_positive'     => 'Сума має бути більше нуля.',

    'auto_budget_period_mandatory' => 'Автоматичний період бюджета - обов\'язкове поле.',

    // no access to administration:
    'no_auth_user_group'           => 'Ви повинні увійти, щоб отримати доступ до цієї адміністрації.',
    'no_access_user_group'         => 'У Вас немає необхідних прав доступу для цих налаштувань.',
    'administration_owner_rename'  => 'Ви не можете перейменувати вашу стандартну адміністрацію.',
    'existing_mfa_code'            => 'Будь ласка, введіть дійсний код',
];
