<?php

/**
 * form.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // new user:
    'administration_currency'      => 'Primary currency',
    'bank_name'                    => 'Назва банку',
    'bank_balance'                 => 'Баланс',
    'current_balance'              => 'Поточний баланс',
    'savings_balance'              => 'Баланс заощаджень',
    'credit_card_limit'            => 'Ліміт кредитної картки',
    'automatch'                    => 'Визначати автоматично',
    'skip'                         => 'Пропустити',
    'enabled'                      => 'Увiмкнено',
    'name'                         => 'Назва',
    'active'                       => 'Активно',
    'amount_min'                   => 'Мінімальна сума',
    'amount_max'                   => 'Максимальна сума',
    'match'                        => 'Збігається з',
    'strict'                       => 'Суворий режим',
    'repeat_freq'                  => 'Повторюється',
    'object_group'                 => 'Група',
    'location'                     => 'Місцезнаходження',
    'update_channel'               => 'Канал оновлень',
    'currency_id'                  => 'Валюта',
    'transaction_currency_id'      => 'Валюта',
    'auto_budget_currency_id'      => 'Валюта',
    'external_ip'                  => 'Зовнішній IP Вашого сервера',
    'attachments'                  => 'Вкладення',
    'BIC'                          => 'Код ідентифікатора банку',
    'verify_password'              => 'Перевірка надійності пароля',
    'source_account'               => 'Вихідний рахунок',
    'destination_account'          => 'Рахунок-одержувач',
    'asset_destination_account'    => 'Рахунок-одержувач',
    'include_net_worth'            => 'Включати в капітал',
    'asset_source_account'         => 'Вихідний рахунок',
    'journal_description'          => 'Опис',
    'note'                         => 'Коментар',
    'currency'                     => 'Валюта',
    'account_id'                   => 'Рахунок активів',
    'budget_id'                    => 'Бюджет',
    'bill_id'                      => 'Підписка',
    'opening_balance'              => 'Початковий баланс',
    'tag_mode'                      => 'Tag mode',
    'virtual_balance'              => 'Віртуальний баланс',



    'targetamount'                 => 'Сума накопичення',
    'target_amount'                => 'Сума накопичення',
    'account_role'                 => 'Тип рахунку',
    'opening_balance_date'         => 'Дата початкового балансу',
    'cc_type'                      => 'План оплати банківською картою',
    'cc_monthly_payment_date'      => 'Дата оплати місячних платежів банківською карткою',
    'piggy_bank_id'                => 'Скарбничка',
    'returnHere'                   => 'Повернутися сюди',
    'returnHereExplanation'        => 'Після збереження, повернутися сюди.',
    'returnHereUpdateExplanation'  => 'Після оновлення, повернутись сюди.',
    'description'                  => 'Опис',
    'expense_account'              => 'Рахунок витрат',
    'revenue_account'              => 'Рахунок доходів',
    'decimal_places'               => 'Десяткові розряди',
    'destination_amount'           => 'Сума (призначення)',
    'new_email_address'            => 'Нова адреса електронної пошти',
    'verification'                 => 'Перевірка',
    'api_key'                      => 'Ключ API',
    'remember_me'                  => 'Запам\'ятати мене',
    'liability_type_id'            => 'Тип відповідальності',
    'liability_type'               => 'Тип відповідальності',
    'interest'                     => 'Відсотки',
    'interest_period'              => 'Період нарахування відсотків',
    'extension_date'               => 'Дата продовження',
    'type'                         => 'Тип',
    'convert_Withdrawal'           => 'Конвертувати виплату',
    'convert_Deposit'              => 'Конвертувати депозит',
    'convert_Transfer'             => 'Конвертувати переказ',
    'amount'                       => 'Сума',
    'foreign_amount'               => 'Іноземна сума',
    'date'                         => 'Дата',
    'interest_date'                => 'Дата нарахування відсотків',
    'book_date'                    => 'Дата бронювання',
    'process_date'                 => 'Дата опрацювання',
    'category'                     => 'Категорія',
    'tags'                         => 'Теги',
    'deletePermanently'            => 'Видалити остаточно',
    'cancel'                       => 'Скасувати',
    'targetdate'                   => 'Кінцева дата',
    'target_date'                  => 'Кінцева дата',
    'startdate'                    => 'Початкова дата',
    'start_date'                   => 'Дата початку',
    'tag'                          => 'Тег',

    // exchange rates
    'from_currency_to_currency'    => '{from} &rarr; {to}',
    'to_currency_from_currency'    => '{to} &rarr; {from}',
    'rate'                         => 'Rate',

    'under'                        => 'Під',
    'symbol'                       => 'Знак',
    'code'                         => 'Код',
    'iban'                         => 'IBAN',
    'account_number'               => 'Номер рахунку',
    'creditCardNumber'             => 'Номер кредитної картки',
    'has_headers'                  => 'Заголовки',
    'date_format'                  => 'Формат дати',
    'attachments[]'                => 'Вкладення',
    'title'                        => 'Назва',
    'notes'                        => 'Примітки',
    'filename'                     => 'Ім\'я файлу',
    'mime'                         => 'Тип MIME',
    'size'                         => 'Розмір',
    'trigger'                      => 'Тригер',
    'stop_processing'              => 'Зупинити обробку',
    'end_date'                     => 'End date',
    'enddate'                      => 'Кінцева дата',
    'move_rules_before_delete'     => 'Група правил',
    'start'                        => 'Початок діапазону',
    'end'                          => 'Кінець діапазону',
    'delete_account'               => 'Видалити акаунт ":name"',
    'delete_webhook'               => 'Видалити вебхук ":title"',
    'delete_bill'                  => 'Видалити підписку ":name"',
    'delete_budget'                => 'Видалити бюджет ":name"',
    'delete_category'              => 'Видалити категорію ":name"',
    'delete_currency'              => 'Видалити валюту ":name"',
    'delete_journal'               => 'Видалити транзакцію з описом ":description"',
    'delete_attachment'            => 'Видалити вкладення ":name"',
    'delete_rule'                  => 'Видалити правило ":title"',
    'delete_rule_group'            => 'Видалити групу правил ":title"',
    'delete_link_type'             => 'Видалити тип посилання ":name"',
    'delete_user'                  => 'Видалити користувача ":email"',
    'delete_recurring'             => 'Видалити повторювану транзакцію ":title"',
    'user_areYouSure'              => 'Якщо ви видалите користувача ":email", усе зникне. Не існує операції відміни. Якщо видалите себе, ви втратите доступ до цього екземпяру Firefly III.',
    'attachment_areYouSure'        => 'Ви впевнені, що хочете видалити вкладення під назвою ":name"?',
    'account_areYouSure'           => 'Ви впевнені, що хочете видалити обліковий запис під назвою ":name"?',
    'account_areYouSure_js'        => 'Ви впевнені, що хочете видалити рахунок "{name}"?',
    'bill_areYouSure'              => 'Ви впевнені, що хочете видалити підписку під назвою ":name"?',
    'rule_areYouSure'              => 'Ви впевнені, що хочете видалити правило під назвою ":title"?',
    'object_group_areYouSure'      => 'Ви впевнені, що хочете видалити групу під назвою ":title"?',
    'ruleGroup_areYouSure'         => 'Ви впевнені, що бажаєте видалити групу правил під назвою ":title"?',
    'budget_areYouSure'            => 'Ви впевнені, що бажаєте видалити бюджет під назвою ":name"?',
    'webhook_areYouSure'           => 'Ви впевнені, що хочете видалити вебхук під назвою ":title"?',
    'category_areYouSure'          => 'Ви впевнені, що хочете видалити категорію під назвою ":name"?',
    'recurring_areYouSure'         => 'Ви впевнені, що хочете видалити повторювану транзакцію під назвою ":title"?',
    'currency_areYouSure'          => 'Ви впевнені, що хочете видалити валюту під назвою ":name"?',
    'piggyBank_areYouSure'         => 'Ви впевнені, що хочете видалити скарбничку під назвою ":name"?',
    'journal_areYouSure'           => 'Ви впевнені, що бажаєте видалити транзакцію з описом ":description"?',
    'mass_journal_are_you_sure'    => 'Ви впевнені, що хочете видалити ці транзакції?',



    'tag_areYouSure'               => 'Ви впевнені, що хочете видалити мітку ":tag"?',
    'journal_link_areYouSure'      => 'Ви впевнені, що хочете видалити посилання між <a href=":source_link">:source</a> і <a href=":destination_link">:destination</a>?',
    'linkType_areYouSure'          => 'Ви впевнені, що хочете видалити тип посилання ":name" (":inward" / ":outward")?',
    'permDeleteWarning'            => 'Видалення елементів із Firefly III є остаточним і не може бути скасовано.',
    'mass_make_selection'          => 'Ви все ще можете запобігти видаленню елементів, скасувавши їх вибір.',
    'delete_all_permanently'       => 'Видалити вибране назавжди',
    'update_all_journals'          => 'Оновити ці транзакції',
    'also_delete_transactions'     => 'Єдина транзакція, пов’язана з цим обліковим записом, також буде видалена.|Усі :count транзакції, пов’язані з цим обліковим записом, також буде видалено.',
    'also_delete_transactions_js'  => 'Жодних транзакцій|Єдину транзакцію, пов’язану з цим обліковим записом, також буде видалено.|Усі {count} транзакції, пов’язані з цим обліковим записом, також буде видалено.',
    'also_delete_connections'      => 'Єдина транзакція, пов’язана з цим типом посилання, втрачає зв’язок.|Усі :count транзакції, пов’язані з цим типом посилання, втратять зв’язок.',
    'also_delete_rules'            => 'Єдине правило, пов’язане з цією групою правил, також буде видалено.|Усі :count правила, пов’язані з цією групою правил, також буде видалено.',
    'also_delete_piggyBanks'       => 'Єдина скарбничка, пов’язана з цим обліковим записом, також буде видалена.|Усі :count скарбнички, пов’язані з цим обліковим записом, також буде видалено.',
    'also_delete_piggyBanks_js'    => 'Жодних скарбничок|Єдину скарбничку, пов’язану з цим обліковим записом, також буде видалено.|Усі {count} скарбнички, пов’язані з цим обліковим записом, також буде видалено.',
    'not_delete_piggy_banks'       => 'Скарбничка, що пов\'язана з цією групою не буде видалена.| Усі :count скарбнички, що пов\'язані з цією групою не будуть видалені.',
    'bill_keep_transactions'       => 'Єдина транзакція, пов’язана з цією підпискою, не буде видалена.|Усі :count транзакцій, пов’язані з цим бюджетом, буде збережено.',
    'budget_keep_transactions'     => 'Єдина трансакція, пов’язана з цим бюджетом, не буде видалена.|Усі :count транзакції, пов’язані з цим бюджетом, буде збережено.',
    'category_keep_transactions'   => 'Єдина транзакція, пов’язана з цією категорією, не буде видалена.|Усі :count транзакції, пов’язані з цією категорією, будуть збережені.',
    'recurring_keep_transactions'  => 'Єдина транзакція, створена цією повторюваною транзакцією, не буде видалена.|Усі :count транзакції, створені цією повторюваною транзакцією, буде збережено.',
    'tag_keep_transactions'        => 'Єдина транзакція, пов’язана з цією міткою, не буде видалена.|Усі :count транзакції, пов’язані з цим тегом, не буде видалено.',
    'check_for_updates'            => 'Перевірити наявність оновлень',
    'liability_direction'          => 'Вхідні/вихідні зобов\'язання',
    'delete_object_group'          => 'Видалити групу ":title"',
    'email'                        => 'Адреса електронної пошти',
    'password'                     => 'Пароль',
    'password_confirmation'        => 'Пароль (ще раз)',
    'blocked'                      => 'Заблоковано?',
    'blocked_code'                 => 'Причина блокування',
    'login_name'                   => 'Логін',
    'is_owner'                     => 'Адміністратор?',
    'url'                          => 'URL-адреса',
    'bill_end_date'                => 'Кінцева дата',

    // import
    'apply_rules'                  => 'Застосувати правила',
    'artist'                       => 'Виконавець',
    'album'                        => 'Альбом',
    'song'                         => 'Пісня',

    // admin
    'domain'                       => 'Домен',
    'single_user_mode'             => 'Вимкнути реєстрацію користувачів',
    'is_demo_site'                 => 'Це демонстраційний сайт',

    // import
    'configuration_file'           => 'Файл конфігурації',
    'csv_comma'                    => 'Кома (,)',
    'csv_semicolon'                => 'Крапка з комою (;)',
    'csv_tab'                      => 'Вкладка (невидима)',
    'csv_delimiter'                => 'Роздільник поля CSV',
    'client_id'                    => 'ID клієнта',
    'app_id'                       => 'ID додатку',
    'secret'                       => 'Таємний ключ',
    'public_key'                   => 'Публічний ключ',
    'country_code'                 => 'Код країни',
    'provider_code'                => 'Банк або постачальник даних',
    'fints_url'                    => 'URL-адреса FinTS API',
    'fints_port'                   => 'Порт',
    'fints_bank_code'              => 'Код банку',
    'fints_username'               => 'Ім\'я користувача',
    'fints_password'               => 'PIN-код / Пароль',
    'fints_account'                => 'Обліковий запис FinTS',
    'local_account'                => 'Обліковий запис Firefly III',



    'from_date'                    => 'Дата від',
    'to_date'                      => 'Дата до',
    'due_date'                     => 'Дата закінчення',
    'payment_date'                 => 'Дата оплати',
    'invoice_date'                 => 'Дата рахунку-фактури',
    'internal_reference'           => 'Внутрішнє посилання',
    'inward'                       => 'Внутрішній опис',
    'outward'                      => 'Зовнішній опис',
    'rule_group_id'                => 'Група правил',
    'transaction_description'      => 'Опис транзакції',
    'first_date'                   => 'Початкова дата',
    'transaction_type'             => 'Тип транзакції',
    'repeat_until'                 => 'Повторювати до',
    'recurring_description'        => 'Опис повторюваної операції',
    'repetition_type'              => 'Тип повторення',
    'foreign_currency_id'          => 'Іноземна валюта',
    'repetition_end'               => 'Повторення закінчується',
    'repetitions'                  => 'Повторення',
    'calendar'                     => 'Календар',
    'weekend'                      => 'Вихідні',
    'client_secret'                => 'Секретний ключ',
    'withdrawal_destination_id'    => 'Рахунок-одержувач',
    'deposit_source_id'            => 'Вихідний рахунок',
    'expected_on'                  => 'Очікується на',
    'paid'                         => 'Сплачено',
    'auto_budget_type'             => 'Автоматичний бюджет',
    'auto_budget_amount'           => 'Сума автоматичного бюджету',
    'auto_budget_period'           => 'Період автоматичного бюджету',
    'collected'                    => 'Зібрано',
    'submitted'                    => 'Надіслано',
    'key'                          => 'Ключ',
    'value'                        => 'Вміст запису',
    'webhook_delivery'             => 'Доставка',
    'webhook_response'             => 'Відповідь',
    'webhook_trigger'              => 'Тригер',
    'pushover_app_token'           => 'Токен додатку Pushover',
    'pushover_user_token'          => 'Токен користувача Pushover',
    'ntfy_server'                  => 'Сервер Ntfy',
    'ntfy_topic'                   => 'Тема Ntfy',
    'ntfy_auth'                    => 'Увімкнено автентифікацію Ntfy',
    'ntfy_user'                    => 'Ім\'я користувача Ntfy',
    'ntfy_pass'                    => 'Пароль Ntfy',
];
