<?php
/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * All Flatboard code is released under the MIT license.
 */

$out['self'] = 'feed';
require_once __DIR__ . '/' . 'header.php';

# FILS SUR TOUTES LES DISCUSSIONS GLOBALE
if (Util::isGET('topic')) {
    $out['subtitle'] = $lang['topic'];
    $out['type'] = 'topic';

    $topics = flatDB::listEntry('topic');
    $nb = $config['ItemByPage'];
    $total = Paginate::countPage($topics, $nb);
    $p = Paginate::pid($total);
    arsort($topics, SORT_NATURAL | SORT_FLAG_CASE);

    if ($topics) {
        foreach (Paginate::viewPage($topics, $p, $nb) as $topic) {
            $topicEntry = flatDB::readEntry('topic', $topic);
            $url = 'view.php' . DS . 'topic' . DS . $topic;
            $out['content'] .= '
            <entry>
                <title>' . htmlspecialchars($topicEntry['trip']) . ': ' . htmlspecialchars($topicEntry['title']) . '</title>
                <link href="' . htmlspecialchars($url) . '"/>
                <id>' . htmlspecialchars($out['baseURL'] . $url) . '</id>
                <updated>' . Util::toDate($topic, 'c') . '</updated>
                <summary type="html">' . htmlspecialchars(Parser::summary(Parser::content($topicEntry['content'], true)), ENT_QUOTES) . '</summary>
            </entry>';
        }
    }
}
# FILS SUR TOUTES LES RÉPONSES
else if (Util::isGET('reply')) {
    $out['subtitle'] = $lang['reply'];
    $out['type'] = 'reply';

    $replies = flatDB::listEntry('reply');
    $nb = $config['ItemByPage'];
    $total = Paginate::countPage($replies, $nb);
    $p = Paginate::pid($total);
    arsort($replies, SORT_NATURAL | SORT_FLAG_CASE);

    if ($replies) {
        foreach (Paginate::viewPage($replies, $p, $nb) as $reply) {
            $replyEntry = flatDB::readEntry('reply', $reply);
            $topicEntry = flatDB::readEntry('topic', $replyEntry['topic']);
            $url = 'view.php' . DS . 'topic' . DS . $replyEntry['topic'] . DS . 'p' . DS . Util::onPage($reply, $topicEntry['reply']) . '#' . $reply;
            $out['content'] .= '
            <entry>
                <id>' . htmlspecialchars($out['baseURL'] . $url) . '</id>
                <title>' . htmlspecialchars($replyEntry['trip']) . ': ' . htmlspecialchars($topicEntry['title']) . '</title>
                <updated>' . Util::toDate($reply, 'c') . '</updated>
                <link href="' . htmlspecialchars($url) . '"/>
                <summary type="html">' . htmlspecialchars(Parser::summary(Parser::content($replyEntry['content'], true)), ENT_QUOTES) . '</summary>
            </entry>';
        }
    }
}
# FILS SUR TOUTES LES DISCUSSIONS D'UN FORUM
else if (Util::isGETValidEntry('forum', 'forum')) {
    $forumEntry = flatDB::readEntry('forum', $_GET['forum']);
    $out['subtitle'] = htmlspecialchars($forumEntry['name']);
    $out['type'] = 'forum';

    $topics = $forumEntry['topic'];

    $nb = $config['ItemByPage'];
    $total = Paginate::countPage($topics, $nb);
    $p = Paginate::pid($total);
    arsort($topics, SORT_NATURAL | SORT_FLAG_CASE);

    if ($topics) {
        foreach (Paginate::viewPage($topics, $p, $nb) as $topic) {
            $topicEntry = flatDB::readEntry('topic', $topic);
            $url = 'view.php' . DS . 'topic' . DS . $topic;
            $out['content'] .= '
            <entry>
                <id>' . htmlspecialchars($out['baseURL'] . $url) . '</id>
                <title>' . htmlspecialchars($topicEntry['trip']) . ': ' . htmlspecialchars($topicEntry['title']) . '</title>
                <updated>' . Util::toDate($topic, 'c') . '</updated>
                <link href="' . htmlspecialchars($url) . '"/>
                <summary type="html">' . htmlspecialchars(Parser::summary(Parser::content($topicEntry['content'], true)), ENT_QUOTES) . '</summary>
            </entry>';
        }
    }
}
# FILS D'UNE DISCUSSION
else if (Util::isGETValidEntry('topic', 'topic')) {
    $topicEntry = flatDB::readEntry('topic', $_GET['topic']);
    $forumEntry = flatDB::readEntry('forum', $topicEntry['forum']);

    $out['subtitle'] = htmlspecialchars($topicEntry['title']);
    $out['type'] = 'thread';

    $url = 'view.php' . DS . 'topic' . DS . $_GET['topic'];
    $out['content'] .= '
    <entry>
        <id>' . htmlspecialchars($out['baseURL'] . $url) . '</id>
        <title>' . htmlspecialchars($topicEntry['trip']) . ': ' . htmlspecialchars($topicEntry['title']) . '</title>
        <updated>' . Util::toDate($topic, 'c') . '</updated>
        <link href="' . htmlspecialchars($url) . '"/>
        <summary type="html">' . htmlspecialchars(Parser::summary(Parser::content($topicEntry['content'], true)), ENT_QUOTES) . '</summary>
    </entry>';
}
else {
    Util::redirect('index.php' . DS . '404');
}

require PATH_ROOT . DS . 'footer.php';
?>