<?php
/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * All Flatboard code is released under the MIT license.
*/
if (!isset($out)) {
    exit;
}

// Timestamp en millisecondes de la fin du script
$fin = microtime(true);

// Traitement du thème
$ThemeDir = THEME_DIR . $config['theme'];
if ($config['theme'] == '' || !is_dir($ThemeDir)) {
    header('Content-Type: text/plain; charset=' . CHARSET);
    echo $lang['theme_not_found'] . ' <pre>' . htmlspecialchars($ThemeDir) . '</pre>';
    exit;
}

// Template pour les flux RSS
if ($out['self'] === 'feed') {
    require $ThemeDir . DS . 'feed.tpl.php';
    exit;
}

// Template de la page de connexion
if ($out['self'] === 'auth') {
    require $ThemeDir . DS . 'login.tpl.php';
    exit;       
}

// Template du tableau de bord
if ($out['self'] === 'config') {
    require $ThemeDir . DS . 'dashboard.tpl.php';   
    exit;    
}

// Sinon, on intègre le thème principal
require $ThemeDir . DS . 'main.tpl.php';
exit;

?>