<?php defined('FLATBOARD') or die('Flatboard Community.');
/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * All Flatboard code is released under the MIT license.
 */

/*
 *---------------------------------------------------------------
 * DEFINITION DE CONSTANTES
 *---------------------------------------------------------------
 */
# Version de FlatBoard
const VERSION = '3.5';
# Nom de code de la version de Flatboard 
const CODENAME = 'AKITA'; // mb_strtoupper('tromsø', 'UTF-8') for uppercase
# Date de la build
const BUILD = '250213';
# Formatage du timestamp
const TIMESTAMP = TRUE;
// Mots clés à filtrer dans plusieurs langues
const CONTENT_FILTER = '/viagra|cialis|poker|casino|medicines|gambling|adult|' .
                       '药|赌博|成人|药品|' .         // Chinois
                       '바이아그라|카지노|성인|도박|의약품|' . // Coréen
                       'виагра|казино|взрослые|азартные игры|медицина|' . // Russe
                       'viagra|casino|adultes|jeux d\'argent|médicaments|' . // Français
                       'viagra|casinò|adulti|giochi d\'azzardo|medicinali|' . // Italien
                       'viagra|casino|adultos|juegos de azar|medicamentos/'; // Espagnol
# Nombre d'éléments à afficher sur la liste des plugins
const PLUGS_PAGINATION = 12; 
# Charset par défaut
const CHARSET = 'UTF-8';
# Les différents dossiers
const UPLOADS_DIR = PATH_ROOT . DS . 'uploads' . DS;
const DATA_DIR = PATH_ROOT . DS . 'data' . DS;
const DATA_PLUGIN = DATA_DIR . 'plugin' . DS;
const BAN_DIR = PATH_ROOT . DS . 'data' . DS . 'ban' . DS;
const BAN_FILE = BAN_DIR . 'blocklist.txt';
const LANG_DIR = PATH_ROOT . DS . 'lang' . DS;
const LIB_DIR = PATH_ROOT . DS . 'lib' . DS;
const PLUGIN_DIR = PATH_ROOT . DS . 'plugin' . DS;
const THEME_DIR = BASEPATH . DS . 'theme' . DS;
# JSON pretty print
if (!defined('JSON_PRETTY_PRINT')) define('JSON_PRETTY_PRINT', 128);
# Mode de débogage: NULL, FALSE & TRUE
const DEBUG_MODE = FALSE;
if (DEBUG_MODE) {
    ini_set('error_log', PATH_ROOT . DS . 'error.log');
    if (DEBUG_MODE === true) {
        error_reporting(E_ALL | E_STRICT | E_NOTICE);
        ini_set('display_errors', true);
        ini_set('display_startup_errors', true);
        ini_set("track_errors", 1);
        ini_set('html_errors', 1);
    } else if (DEBUG_MODE === false) {
        error_reporting(0);
        ini_set('display_errors', false);
        ini_set('display_startup_errors', false);
    }
}
# Multibyte string extension loaded.
mb_internal_encoding(CHARSET);
mb_http_output(CHARSET);

/*
 *---------------------------------------------------------------
 * INCLUSION DES LIBS NÉCESSAIRES
 *---------------------------------------------------------------
 */
require_once LIB_DIR . 'Flatdb.lib.php';
require_once LIB_DIR . 'Asset.lib.php';
require_once LIB_DIR . 'Utils.lib.php';
require_once LIB_DIR . 'CSRF.lib.php';

/*
 *---------------------------------------------------------------
 * FICHIER CONTENANT LA CLÉ ENCRYPTÉE POUR LE MOT DE PASSE
 *---------------------------------------------------------------
 */
if (file_exists(DATA_DIR . 'key.php')) include(DATA_DIR . 'key.php');

/*
 *---------------------------------------------------------------
 * RETOURNE LA LISTE DES LANGUES DISPONIBLES
 *---------------------------------------------------------------
 */
function langpack() {
    global $lang;
    return array(
        'en-US' => $lang['en-US'],
        'fr-FR' => $lang['fr-FR'],
        'ru-RU' => $lang['ru-RU'],
        'de-DE' => $lang['de-DE'],
        'it-IT' => $lang['it-IT'],
        'es-ES' => $lang['es-ES'],
        'zh-CN' => $lang['zh-CN']
    );
}
?>