<?php defined('FLATBOARD') or die('Flatboard Community.');

/*
 * Classe de token CSRF
 * Nom du projet : Flatboard
 * URL du projet : https://flatboard.org
 * Auteur : Frédéric Kaplon et contributeurs
 * Tout le code de Flatboard est publié sous la licence MIT.
 */

class CSRF
{
    /**
     * Constructeur protégé car il s'agit d'une classe statique.
     *
     * @access protected
     */
    protected function __construct()
    {
        // Rien ici
    }

    /**
     * Générer un nouveau token CSRF basé sur l'adresse IP et une chaîne aléatoire.
     *
     * @return string Le token CSRF généré
     */
    public static function generate()
    {
        // Générer un token CSRF en utilisant l'adresse IP et une chaîne unique
        return $_SESSION['token'] = base64_encode(implode('|', [md5($_SERVER['REMOTE_ADDR']), uniqid('', true)]));
    }

    /**
     * Vérifier si le token donné et l'adresse IP sont valides.
     *
     * @param string $token Le token CSRF à vérifier
     * @return bool Vrai si le token est valide, faux sinon
     */
    public static function check($token)
    {
        if (isset($_SESSION['token']) && $token === $_SESSION['token']) {
            $ex = explode('|', base64_decode($token));
            if ($ex[0] !== md5($_SERVER['REMOTE_ADDR'])) {
                return false; // L'adresse IP ne correspond pas
            }
            unset($_SESSION['token']); // Supprimer le token après vérification
            return true; // Token valide
        }
        
        $_SESSION['ErrToken'] = 1; // Enregistrer une erreur de token
        return false; // Token invalide
    }
}