<?php defined('FLATBOARD') or die('Flatboard Community.');
/*
 * Nom du projet : Flatboard
 * URL du projet : https://flatboard.org
 * Auteur : Frédéric Kaplon et contributeurs
 * Tout le code de Flatboard est publié sous la licence MIT.
 */

class Plugin
{
    // (string) Nom du plugin, juste le nom du répertoire
    // Ex : core
    public $pluginName;

    // (string) Nom de fichier de base de données absolu et chemin
    // Ex : /www/flatboard/data/plugin/core.dat.php
    public $pluginDB;	

    /**
     * Constructeur protégé car il s'agit d'une classe statique.
     *
     * @access protected
     */
    protected function __construct()
    {
        // Initialiser le nom du plugin
        $this->pluginName = basename(dirname(get_class($this)));
        // Initialiser la base de données avec des valeurs par défaut
        $this->pluginDB = DATA_PLUGIN . $this->pluginName . '.dat.php';        
    }	
	
    /**
     * Exécute les hooks pour les plugins.
     *
     * @param string $name Nom du hook
     * @param mixed $param Paramètre optionnel à passer au hook
     * @return string Résultat des hooks
     */
    public static function hook($name, $param = null)
    {
        global $plugins;
        $out = '';
        foreach ($plugins as $plugin) {
            if (self::isValidHook($name, $plugin)) {					
                $out .= self::myHook($name, $plugin, $param);
            }
        }
        return $out;
    }
	
    /**
     * Vérifie si le hook est valide pour le plugin donné.
     *
     * @param string $hook Nom du hook
     * @param string $plugin Nom du plugin
     * @return bool Vrai si le hook est valide, faux sinon
     */
    public static function isValidHook($hook, $plugin)
    {
        return function_exists($plugin . '_' . $hook);
    }
	
    /**
     * Exécute le hook pour le plugin donné.
     *
     * @param string $hook Nom du hook
     * @param string $plugin Nom du plugin
     * @param mixed $param Paramètre optionnel à passer au hook
     * @return mixed Résultat de l'exécution du hook
     */
    public static function myHook($hook, $plugin, $param = null)
    {
        $hookFunc = $plugin . '_' . $hook;
        return $hookFunc($param);
    }

    /**
     * Méthode qui affiche une notification.
     *
     * @param string $title Titre de la notification
     * @param string $url URL de redirection
     * @param string $destination Destination de redirection
     * @param string $class Classe CSS pour la notification
     * @param bool $autoredirect Indique si la redirection automatique est activée
     * @return string HTML de la notification
     */
    public static function redirectMsg($title, $url, $destination, $class = '', $autoredirect = true)
    {
        global $lang; 
        $class = !empty($class) ? ' class="' . $class . '"' : ' class="alert alert-success"';
        
        $alertHtml = '<div id="alert"' . $class . '>
                        <div class="text-center">
                            <strong>' . ($autoredirect ? '<i class="fa fa-spinner fa-pulse fa-lg fa-fw"></i> ' : '') . $title . '</strong>
                            <p><a href="' . $url . '">' . $lang['redirect'] . '&nbsp;' . $destination . '</a></p>';
        
        if ($autoredirect) {
            $alertHtml .= '<script>setTimeout(function(){window.location.href = "' . $url . '"; }, 1000);</script>';
        }
        
        $alertHtml .= '  </div>             	
                        <span class="close small"></span>
                    </div>';
        
        return $alertHtml;
    }
}