<?php defined('FLATBOARD') or die('Flatboard Community.');
/**
 * Online
 *
 * @author 		Frédéric K.
 * @copyright	(c) 2015-2025
 * @license		http://opensource.org/licenses/MIT
 * @package		FlatBoard
 * @version		3.5.0
 * @update		2025-02-08
 */	
 
/**
 * Pré-installe les paramètres par défaut.
 */
function online_install()
{
    $plugin = 'online';
    
    // Vérifier si le plugin est déjà installé
    if (flatDB::isValidEntry('plugin', $plugin)) {
        return; // Si le plugin est déjà installé, ne rien faire
    }

    // Initialiser les données par défaut
    $data = [
        $plugin . 'state' => false,
        'color' => '',
        $plugin . '_display' => 'icon'
    ];

    // Sauvegarder les données du plugin
    flatDB::saveEntry('plugin', $plugin, $data);

    // Créer le fichier pour stocker les statistiques
    $online[$_SERVER['REMOTE_ADDR']] = time();
    flatDB::saveEntry('plugin', $plugin . '_hits', $online);
}

/**
 * Configuration de l'admin pour le plugin.
 */
function online_config()
{
    global $lang, $token;
    $plugin = 'online';
    $out = '';

    // Options de sélection pour la couleur et l'affichage
    $color_select = [
        'primary' => $lang['blue'],
        'secondary' => $lang['grey'],
        'success' => $lang['green'],
        'danger' => $lang['red'],
        'warning' => $lang['yellow'],
        'info' => $lang['cyan'],
        'light' => $lang['white'],
        'dark' => $lang['dark']
    ];
    $display = [
        'icon' => $lang['icon'],
        'text' => $lang['text']
    ];

    // Traitement des données POST
    if (!empty($_POST) && CSRF::check($token)) {
        $data[$plugin . 'state'] = Util::isPOST('state') ? $_POST['state'] : '';
        $data['color'] = HTMLForm::clean($_POST['color']);
        $data[$plugin . '_display'] = HTMLForm::clean($_POST[$plugin . '_display']);
        
        // Sauvegarder les données du plugin
        flatDB::saveEntry('plugin', $plugin, $data);
        
        // Afficher un message de succès
        $out .= Plugin::redirectMsg(
            $lang['data_save'],
            'config.php' . DS . 'plugin' . DS . $plugin,
            $lang['plugin'] . '&nbsp;<b>' . $lang[$plugin . 'name'] . '</b>'
        );
    } else {
        // Lire les données du plugin si elles existent
        if (flatDB::isValidEntry('plugin', $plugin)) {
            $data = flatDB::readEntry('plugin', $plugin);
        }

        // Générer le formulaire de configuration
        $out .= HTMLForm::form(
            'config.php' . DS . 'plugin' . DS . $plugin,
            HTMLForm::checkBox('state', $data[$plugin . 'state']) . '
            <div class="form-row">
                <div class="col-3">
                    ' . HTMLForm::select('color', $color_select, $data['color']) . '
                </div>
                <div class="col-3">
                    ' . HTMLForm::select($plugin . '_display', $display, $data[$plugin . '_display']) . '			        
                </div>
            </div>' .
            HTMLForm::simple_submit()
        );
    }

    return $out; // Retourner le contenu généré
}

/**
 * Affichage en pied de page
 */
function online_footer()
{
    $plugin = 'online';
    global $lang;
    $out = '';

    // Lecture des données du plugin
    $data = flatDB::readEntry('plugin', $plugin);   
    if ($data[$plugin . 'state']) { 
        $crawlers = smart_ip_detect_crawler($_SERVER['HTTP_USER_AGENT']);  
        $online = flatDB::readEntry('plugin', $plugin . '_hits');

        // Nettoyer les IPs inactives (1 minute)
		foreach ((array)$online as $ip => $time) {
		    if (time() - $time > 60) {
		        #error_log("IP removed due to inactivity: " . $ip); // Ajoutez cette ligne pour vérifier les IPs supprimées
		        unset($online[$ip]);
		    }
		}

        // Enregistrer l'IP de l'utilisateur actuel
		$ip = User::getRealIpAddr();
		$online[$ip] = time();
		flatDB::saveEntry('plugin', $plugin . '_hits', $online);
		#error_log("IP saved: " . $ip); // Ajoutez cette ligne pour vérifier l'IP sauvegardée
        
        // Afficher les robots s'il y en a
        if (!empty($crawlers)) {
            $botNames = implode(', ', $crawlers); // Joindre les noms des bots détectés
            return ' - <a data-toggle="tooltip" data-placement="top" title="Bots détectés : ' . $botNames . '"><i class="fa fa-android"></i></a>';		
        }

        // Affichage de tous les visiteurs
        $out .= '&nbsp;<span class="badge badge-' . $data['color'] . '">' . 
                ($data[$plugin . '_display'] == 'icon' ? '<i class="fa fa-user"></i> ' : $lang['online']) . 
                count($online);
                #error_log(print_r($online, true)); // Ajoutez cette ligne pour afficher le contenu du tableau

        // Vérifier s'il y a des sessions admin et modérateur
        $sessionRoleCount = 0;

        // Vérification si $_SESSION['role'] est un tableau ou une chaîne
        if (isset($_SESSION['role'])) {
            if (is_array($_SESSION['role'])) {
                $sessionRoleCount = count($_SESSION['role']); // Compter les rôles si c'est un tableau
            } elseif (is_string($_SESSION['role']) && !empty($_SESSION['role'])) {
                $sessionRoleCount = 1; // Si c'est une chaîne non vide, on compte comme un rôle
            }
        }

        if ($sessionRoleCount > 0) {
            // Afficher le nombre de l'équipe connectée
            $out .= ' - <a data-toggle="tooltip" data-placement="top" title="' . $lang['staff_online'] . ': ' . intval($sessionRoleCount) . '"><i class="fa fa-user-plus"></i></a>';			  		
        }
        $out .= '</span>';
    } 

    return $out; // Retourner le contenu généré
}

/**
 * Vérifie si la chaîne d'agent utilisateur donnée est celle d'un crawler, spider ou bot.
 *
 * @param string $user_agent
 *   Une chaîne d'agent utilisateur (ex. Googlebot/2.1 (+http://www.google.com/bot.html))
 *
 * @return array
 *   Un tableau contenant les noms des bots détectés, ou un tableau vide si aucun bot n'est détecté.
 */
function smart_ip_detect_crawler($user_agent) {
	$crawlers = [
	    ['Googlebot', 'Google'],
	    ['msnbot', 'MSN'],
	    ['Rambler', 'Rambler'],
	    ['Yahoo', 'Yahoo'],
	    ['AbachoBOT', 'AbachoBOT'],
	    ['accoona', 'Accoona'],
	    ['AcoiRobot', 'AcoiRobot'],
	    ['ASPSeek', 'ASPSeek'],
	    ['CrocCrawler', 'CrocCrawler'],
	    ['Dumbot', 'Dumbot'],
	    ['FAST-WebCrawler', 'FAST-WebCrawler'],
	    ['GeonaBot', 'GeonaBot'],
	    ['Gigabot', 'Gigabot'],
	    ['Lycos', 'Lycos spider'],
	    ['MSRBOT', 'MSRBOT'],
	    ['Scooter', 'Altavista robot'],
	    ['AltaVista', 'Altavista robot'],
	    ['IDBot', 'ID-Search Bot'],
	    ['eStyle', 'eStyle Bot'],
	    ['Scrubby', 'Scrubby robot'],
	    ['Bingbot', 'Bing'],
	    ['Slurp', 'Yahoo! Slurp'],
	    ['DuckDuckBot', 'DuckDuckGo'],
	    ['Sogou', 'Sogou Spider'],
	    ['Exabot', 'Exabot'],
	    ['facebot', 'Facebook'],
	    ['ia_archiver', 'Alexa'],
	    ['YandexBot', 'Yandex'],
	    ['AhrefsBot', 'Ahrefs'],
	    ['SemrushBot', 'Semrush'],
	    ['Baiduspider', 'Baidu'],
	    ['Majestic12', 'Majestic'],
	    ['seznambot', 'Seznam'],
	    ['petalbot', 'Petal'],
	    ['DotBot', 'DotBot'],
	    ['MJ12bot', 'Majestic'],
	    ['MegaIndex', 'MegaIndex'],
	    ['BLEXBot', 'BLEXBot'],
	    ['PiplBot', 'Pipl'],
	    ['UptimeRobot', 'Uptime'],
	    ['Archive.org', 'Archive'],
	    ['LinkedInBot', 'LinkedIn'],
	    ['Slackbot', 'Slack'],
	    ['Pinterest', 'Pinterest'],
	    ['TelegramBot', 'Telegram'],
	    ['ViberBot', 'Viber'],
	    ['W3C_Validator', 'W3C Validator'],
	    ['Discordbot', 'Discord'],
	    ['BingPreview', 'Bing Preview'],
	    ['Twitterbot', 'Twitter'],
	    ['WhatsApp', 'WhatsApp'],
	    ['Feedly', 'Feedly'],
	    ['Mail.RU', 'Mail.RU Bot'],
	    ['NaverBot', 'Naver'],
	    ['CoccocBot', 'Coc Coc'],
	    ['Screaming Frog SEO Spider', 'Screaming Frog'],
	    ['Grapeshot', 'Grapeshot'],
	    ['Yeti', 'Yeti'],
	    ['BaiduSpider', 'Baidu'],
	    ['BingImageBot', 'Bing Image'],
	    ['BingVideo', 'Bing Video'],
	    ['BingNews', 'Bing News'],
	    ['Sogou Spider', 'Sogou'],
	    ['Baidu Baike', 'Baidu Baike'],
	    ['Baidu Tieba', 'Baidu Tieba'],
	    ['Baidu Wenku', 'Baidu Wenku'],
	    ['Baidu Zhidao', 'Baidu Zhidao'],
	    ['Baidu App', 'Baidu App'],
	    ['YandexImages', 'Yandex Images'],
	    ['YandexVideo', 'Yandex Video'],
	    ['YandexNews', 'Yandex News'],
	    ['YandexMetrica', 'Yandex Metrica'],
	    ['YandexDirect', 'Yandex Direct'],
	    ['Googlebot-Image', 'Google Image'],
	    ['Googlebot-Video', 'Google Video'],
	    ['Googlebot-News', 'Google News'],
	    ['Googlebot-Ads', 'Google Ads'],
	    ['AhrefsBot', 'Ahrefs'],
	    ['SemrushBot', 'Semrush'],
	    ['MajesticSEO', 'Majestic SEO'],
	    ['Netcraft', 'Netcraft'],
	    ['SiteAnalyzer', 'Site Analyzer'],
	    ['SEO Spider', 'SEO Spider'],
	    ['CrawlBot', 'Crawl Bot'],
	    // Ajoutez d'autres bots ici
	];

    $detectedBots = [];

    foreach ($crawlers as $c) {
        if (stripos($user_agent, $c[0]) !== false) {
            $detectedBots[] = $c[1]; // Ajouter le nom du bot détecté au tableau
        }
    }

    return $detectedBots; // Retourner le tableau des bots détectés
}
?>
