<?php
/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * Last update: 2025.07.18
 * All Flatboard code is released under the MIT license.
 * See COPYRIGHT.txt and LICENSE.txt.
*/

// Paramètres régionaux
setlocale(LC_TIME, 'fr_FR', 'fra');
date_default_timezone_set("Europe/Paris");
mb_internal_encoding("UTF-8");

$lang = [
    // Langues disponibles
    'fr-FR' => 'Français',
    'en-US' => 'Anglais',
    'ru-RU' => 'Russe',
    'de-DE' => 'Allemand',
    'it-IT' => 'Italien',
    'es-ES' => 'Espagnol',
    'zh-CN' => 'Chinois',

    // Symboles et icônes
    'in' => ' <i class="fa fa-clock-o"></i>',

    // Messages d'installation
    'php_version' => 'Vous devez disposer d’un serveur équipé de <b>PHP 5.2</b> ou plus pour installer <b>Flatboard</b> !',
    'flatBoard_installer' => 'Installation de Flatboard',
    'welcome_installer' => 'Bienvenue dans l’assistant d’installation de Flatboard',
    'site_title' => 'Votre titre du site',
    'site_slogan' => 'Slogan / Description du site',
    'your_admin_psw' => 'Doit être du type: user@motdepasse',
    'site_mail' => 'Adresse de couriel pour votre compte administrateur',
    'install' => 'Installer',
    'installed_title' => '<i class="fa fa-bullhorn"></i> Génial, Flatboard est désormais installé !',
    'installed_msg' => 'Maintenant, créez des forums et commencez à discuter avec le monde ! Besoin d’aide ? Veuillez lire la <a href="https://flatboard.org/view.php/plugin/page/p/docs">documentation</a>.',

    // Configuration
    'homepage' => 'Page d’accueil',
    'footer_text' => 'Texte en pied de page',
    'announcement' => 'Annonce',
    'announcement_desc' => 'Laisser vide pour ne pas afficher d’annonce (code HTML autorisé).',
    'ItemByPage' => 'Nombre de discussions/Réponses par page',
    'date_format' => 'Format de la date',
    'date_format_desc' => 'Formate une date/heure locale => <a href="https://www.php.net/manual/fr/function.strftime.php">Documentation PHP</a>.',
    'date_format_placeholder' => '%d/%m/%Y, %T',
    'default_date_format' => '%A %d %B %Y, %T',
    'short_date_format' => 'Format réduit de la date',
    'maintenance' => 'Maintenance',
    'maintenance_desc' => 'Site en maintenance, merci de revenir plus tard.',
    'ban_list' => 'Liste d’IP bannies',
    'ban_ok' => 'Cette adresse est désormais non-autorisée.',
    'ban_fail' => 'Cette adresse est déjà bannie.',
    'dashboard' => 'Tableau de bord',
    'add_worker' => 'Ajouter un modérateur',
    'save' => 'Enregistrer',
    'update' => 'Mis à jour le ',
    'theme' => 'Thème',
    'theme_desc' => '<a href="config.php/deletecache" class="btn btn-primary btn-sm"><i class="fa fa-trash" aria-hidden="true"></i> Vider le cache</a>',
    'cache_clean' => 'Cache vidé',
    'folder_deleted' => 'Dossier supprimé avec succès',
    'folder_error' => 'Erreur pendant la suppression du dossier',
    'lang' => 'Langage',
    'editor' => 'Éditeur',
    'bbcode' => 'BBcode',
    'markdown' => 'Markdown',
    'editor_desc' => 'Formatage BBcode ou Markdown.',
    'style' => 'Schéma de couleur ' . Util::Help('Permet de personnaliser la couleur du bandeau de navigation.'),
    'style_placeholder' => 'slateblue, #000000…',
    'nb_page_scroll_infinite' => 'Combien de pages à scroller automatiquement',
    'nb_page_scroll_desc' => 'Mettre 1 pour désactiver le scroll automatique.',
    'salt' => 'Clé de sécurité',
    'salt_desc' => 'Laissez vide pour générer une clé automatiquement',
    'manage_tags' => 'Gestionnaire de mots-clés',
    'tags' => 'Mots-clés',
    'tags_help' => 'Les mots-clés vous permettent de "marquer" les titres de vos discussions. Ils rendent ainsi le titre plus attrayant et par la suite servir de filtre dans vos recherches sur le forum.<br />Pour les afficher, il faut en insérer au minimum un dans la liste ci-dessous.<br />Au formulaire d’une nouvelle discussion, vous verrez apparaître le sélecteur de mots clés.<div class="divider"></div>Lorsque la case est cochée, le mot-clé reste invisible de la liste, lors de la publication d’une discussion. Ce mot-clé joue donc le rôle de filtrage sur les noms d’utilisateurs, pour devenir une identité vérifiée. Un exemple de code est fourni, mais libre à vous de le modifier.',
    'tags_empty' => 'Aucun mots-clés pour le moment.',
    'replace' => 'Remplacement',
    'tags_result' => 'Résultat',
    'blog' => 'Blog',
    'blog_new' => 'Sélectionnez un forum qui diffusera les nouvelles sur votre blog.',
    'disable_blog' => 'Désactiver le blog',
    'post_summary' => 'Nombre de mots dans les articles pour un résumé.',
    'hidden_tag' => 'Masquer le mot-clé de la sélection',
    'title_tag' => '[Mon Mot Clé]',
    'user' => 'Utilisateur',
    'username_check' => 'Nom d’utilisateur à vérifier',
    'user_checked' => 'Utilisateur vérifié',
    'back_to_site' => 'Retour au site',
    'good-morning' => 'Bonjour',
    'good-afternoon' => 'Bonne après-midi',
    'good-evening' => 'Bonsoir',
    'good-night' => 'Bonne nuit',
    'hello' => 'Salut',
    'note' => 'Note',

    // Messages du tableau de bord
    'pro_edition' => 'PRO - Merci de supporter Flatboard',
    'standard_edition' => 'Standard - <a class="btn btn-link" href="https://flatboard.org/download.php" onclick="window.open(this.href); return false;">Mettre à niveau vers Flatboard PRO</a>',

    // Messages système de configuration
    'warning_installation_file' => 'Le fichier install.php est présent à la racine de Flatboard.<br />Pour des raisons de sécurité, il est fortement conseillé de le <a class="badge badge-danger" href="config.php/delinstallfile" title="Supprimer maintenant ?">supprimer</a>.',
    'new_version' => 'Nouvelle version disponible',
    'theme_not_found' => 'Le thème principal de Flatboard est introuvable',

    // Messages d'ajout
    'topic_added' => 'Discussion ajoutée !',
    'reply_added' => 'Réponse ajoutée !',
    'forum_added' => 'Forum ajouté avec succès !',
    'write_post' => 'Écrivez un message…',
    'modo_added' => 'Nouveau modérateur ajouté !',
    'trip' => 'Pseudo ' . Util::Help('Il n’est pas nécessaire de “s’inscrire”, il suffit d’insérer le même Nom@MotDePasse de votre choix à chaque fois, pour avoir votre propre identité. Votre mot de passe sera affiché en crypté et haché aux visiteurs pour des raisons de sécurité !'),
    'badge_color' => 'Couleur du badge',
    'badge_color_desc' => 'Insérez une couleur hexadécimale ou son nom',
    'font_icon' => 'Icône catégorie',
    'font_icon_placeholder' => 'fa-folder',
    'font_icon_desc' => 'Allez sur le site <a href="http://fontawesome.io/icons/">Font Awesome</a> pour choisir une icône',
    'email_sent' => 'E-mail envoyé avec succès.',
    'email_nosent' => 'Une erreur est survenue, l’email n’a pu être envoyé.',
    'report_desc' => 'Veuillez noter : les modérateurs seront avertis avec un lien vers la page que vous signalez.<br />Ce formulaire est UNIQUEMENT pour signaler du contenu répréhensible et ne doit pas être utilisé comme moyen de communication avec les modérateurs pour toute autre raison.',
    'your_email' => 'Votre mail au cas où...',
    'click_to_view_post' => 'Cliquez ici pour voir le message',
    'order' => 'Ordre',
    'flood_start' => 'Au moins 60 secondes doivent s’écouler entre deux messages, attendez %s minutes puis essayez à nouveau.',
    'private' => 'Rendre privé l’accès au site.',
    'restrict_access' => 'Restreindre l’accès au site à l’équipe du forum.',
    'unauthorized_access' => 'Accès non autorisé.',
    'private_msg' => 'Désolé, vous n’avez pas les autorisations pour ouvrir cette page.',
    'no_tag' => 'AUCUN TAG',
    'more_info' => 'Cliquez ici pour plus de détails',
    'cancel' => 'Fermer',
    'choose_pic' => 'Sélectionnez une image',
    'upload' => 'Téléverser',
    'private_forum' => 'Accès restreint',
    'private_forum_desc' => 'Forum accessible uniquement à l’équipe du site.',
    'the_specified_color_is_not_valid' => 'Erreur : La couleur spécifiée n’est pas valide.',

    // Messages de suppression
    'topic_deleted' => 'Discussion supprimée !',
    'reply_deleted' => 'Réponse supprimée !',
    'forum_deleted' => 'Forum supprimé !',
    'worker_deleted' => 'Modérateur supprimé !',
    'ip_not_banned' => 'Cette adresse IP n’était pas bannie.',
    'ip_removed' => 'L’adresse IP a été retirée.',

    // Messages d'édition
    'topic_edited' => 'Discussion éditée !',
    'reply_edited' => 'Réponse éditée !',
    'forum_edited' => 'Forum édité !',
    'pinned_homepage' => 'Épinglé en page d’accueil',
    'pick_font' => 'Choisissez une icône',
    'useSpace' => true,
    'home' => 'Accueil',
    'thread_sug' => 'Suggestion de sujets',
    'change_pwd' => 'Modifier mon mot de passe',
    'topic' => 'Sujet',
    'newthread' => 'Démarrer une discussion',
    'reply' => 'Réponse',
    'replies' => 'Réponses',
    'newreply' => 'Répondre à cette discussion',
    'quote_reply' => 'Répondre en citant',
    'quote_by' => 'Cité par',
    'add_forum' => 'Ajouter un Forum',
    'plugin' => 'Plugin',
    'config' => 'Configuration',
    'logout' => 'Déconnexion',
    'login' => 'Connexion',
    'redirect' => 'Redirection vers',
    'add' => 'Ajouter',
    'edit' => 'Éditer',
    'delete' => 'Supprimer',
    'title' => 'Titre',
    'content' => 'Message',
    'name' => 'Nom',
    'mail' => 'Email',
    'mail_desc' => 'Il ne sera jamais dévoilé publiquement.',
    'not_required' => '(non obligatoire)',
    'search' => 'Rechercher',
    'forum' => 'Forum',
    'password' => 'Mot de Passe',
    'confirm_password' => 'Confirmer',
    'powered' => 'Créé avec <a href="https://flatboard.org" onclick="window.open(this.href); return false;">Flatboard' . (defined('FLATBOARD_PRO') ? ' Pro' : '') . '</a> et avec <i class="fa fa-heart"></i>.',
    'feed' => 'Flux',
    'none' => 'Aucune donnée actuellement',
    'info' => 'Information',
    'date' => 'Date',
    'activity' => 'Activité',
    'view' => 'Vue',
    'count' => 'Message',
    'new' => 'Derniers Messages',
    'more' => 'Lire la suite',
    'submit' => 'Valider',
    'admin' => 'Administrateur',
    'worker' => 'Modérateur',
    'sort_forums' => 'Trier les forums',
    'yes' => 'Oui',
    'no' => 'Non',
    'locked' => 'Fermé',
    'no_reply' => 'Vous ne pouvez pas répondre',
    'locked_discussion' => 'a verrouillé la discussion.',
    'report' => 'Signaler un abus',
    'day' => 'jour',
    'hour' => 'heure',
    'minute' => 'minute',
    'second' => 'seconde',
    'plural' => 's',
    'ago' => 'plus tôt.',
    'errLen' => ' est trop court ou trop long',
    'errBot' => 'Code Anti Spam incorrect!',
    'errNb' => 'Le nombre doit être entier et positif.',
    'ErrContentFilter' => 'Vous avez inséré au moins un mot censuré, veuillez rester courtois.',
    'pinned' => 'Épinglé',
    'stickied_discussion' => 'a épinglé la discussion.',
    'replied' => '<i class="fa fa-share-square"></i> a répondu',
    'started' => '<i class="fa fa-bolt"></i> a débuté',
    'notFound' => 'Oops ! Cette page n’existe plus :(',
    'errNotMatch' => 'Les Mots de Passe ne correspondent pas',
    'captcha' => 'Code de sécurité',
    'enter_code' => 'Insérez le code',
    'math_result' => 'Répondez à ce simple calcul mathématique',
    'math_captcha' => 'Utilisez le captcha mathématique ?',
    'r_captcha' => 'Recharger l’image',
    'quickNav' => 'Navigation rapide',
    'invalid_token' => 'Mauvais hachage CSRF !',
    'mail_available' => 'Fonction d’envoi de mail disponible',
    'mail_not_available' => 'Fonction d’envoi de mail non disponible',
    'statistics' => 'Statistiques',
    'start' => '<div class="alert alert-primary" role="alert"><h6>Félicitation ! Flatboard est désormais correctement installé.</h6>Pour commencer, vous devez ajouter un forum. <a href="add.php/forum" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i></a></div>',
    'no-forum' => 'Aucun forum à afficher.',

    // Messages de vue
    'permalink' => 'Lien permanent',
    'solved' => 'Résolu',
    'original_message' => 'DISCUSSION D’ORIGINE',
    'last_modified' => 'Dernière modification par %s le ',
    'last_post' => 'Dernier message',
    'user_activity' => 'Afficher son activité.',
    'error' => 'ERREUR',
    'no_plugin' => 'Ce plugin n’existe pas OU n’est pas activé !',
    'want_more' => 'Vous souhaitez en lire davantage ? <a href="index.php' . DS . 'forum">Parcourir toutes nos catégories</a> ou <a href="' . HTML_BASEPATH . '">consulter les dernières discussions</a>.',
    'close_del_content' => 'En fermant cette fenêtre avec ce bouton, vous en effacer le contenu.',
    'reply_this_topic' => 'Participez à la conversation',

    // Messages de recherche
    'search_term_found' => 'Terme recherché trouvé.',
    'search_desc' => 'La recherche se fait sur : l’auteur, le titre, les tags et le contenu d’un sujet.',
    'search_holder' => 'Auteur, titre, tag ou contenu.',
    'click_tag_search' => 'Cliquez sur un mot-clé à insérer dans la recherche.',

    // Messages de plugin
    'state' => 'Statut actuel du plugin',
    'state_on' => 'Activé',
    'state_off' => 'Désactivé',
    'data_save' => 'Données sauvegardées !',
    'description' => 'Description',
    'author' => 'Auteur',
    'check_all' => 'Tout cocher',
    'plugin_help' => '<i class="fa fa-warning"></i> Aide',
    'manage_plugin' => 'Gestionnaire de plugin',
    'cantDisable' => 'Ce plugin ne peut être désactivé.',
    'click_to_active' => 'Activer le plugin.',
    'click_to_disable' => 'Désactiver le plugin.',

    // Messages d'authentification
    'password_changed' => 'Votre mot de passe a bien été modifié!',
    'edit_password' => 'Modification du mot de passe',
    'login_confirm' => 'Vous êtes à présent identifié(e).',
    'logout_confirm' => 'Vous êtes à présent déconnecté(e).',
    'incorrect_password' => 'Mot de passe incorrect.',
    'error_maxlogin' => 'Nombre de tentatives atteint. Réessayez dans %s minutes.',
    'already_logged' => 'Vous êtes déjà connecté !',
    'already_logged_msg' => 'Vous êtes déjà connecté en tant que <b>%s</b>, vous devez quitter votre session en cours avant de pouvoir vous reconnecter en tant qu’un autre utilisateur.',
    'bad_user_syntax' => 'Votre nom d’utilisateur doit avoir la syntaxe suivante: <b>nom@motdepasse</b>',

    // Messages de services
    'ban_user' => 'Bannir cette IP',
    'unban_user' => 'Débannir cette IP',
    'banned' => 'Vous avez été banni !',
    'your_banned' => 'Vous avez été banni définitivement de ce forum.<br />Contactez l’Administrateur du forum pour plus d’informations.<br />Raison du bannissement: dans le cadre de notre politique active contre le spam<br />Votre IP: ',
    'has_banned' => ' a été bannie !',
    'ban' => 'IP/plages d’adresses IP',
    'previous_page' => 'la page précédente.'
];