<?php
/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * Translation: Paul Bid — https://paul.bid (Last update: 2025.05.02)
 * All Flatboard code is released under the MIT license.
 * See COPYRIGHT.txt and LICENSE.txt.
*/
# Установка кодов локали
setlocale(LC_ALL, 'ru_RU', 'ru', 'rus');
# Установка часового пояса по умолчанию для всех функций даты/времени  
date_default_timezone_set('Europe/Moscow');
# Определение внутренней кодировки текста
mb_internal_encoding('UTF-8');

$lang = array(
'en-US'	=> 'Английский',
'fr-FR'	=> 'Французский',
'ru-RU'	=> 'Русский',
'de-DE'	=> 'Немецкий',
'it-IT'	=> 'Итальянский',
'es-ES'	=> 'Испанский',
'zh-CN'	=> 'Китайский',

'in'  => ' <i class="fa fa-clock-o"></i>',
/************* install.php ***************/
'php_version'		=> 'Для установки <b>Flatboard</b> требуется <b>PHP v5.3</b> и выше!',
'flatBoard_installer' => 'Установка FlatBoard',
'welcome_installer'	=> 'Добро пожаловать!',
'site_title'		=> 'Название сайта',
'site_slogan'		=> 'Описание сайта',
'your_admin_psw'	=> 'Данные учётной записи администратора должны быть в таком виде: username@mypassword',
'site_mail'			=> 'Ваш email',
'install'			=> 'Установить',
'installed_title'	=> '<i class="fa fa-bullhorn"></i> Flatboard успешно установлен',
'installed_msg'		=> 'Теперь можно содавать форумы! Если нужна помощь, обратитесь к <a href="https://flatboard.org/view.php/plugin/page/p/docs">документации (она на английском языке)</a>.',

/************* config.php ***************/
'homepage'			=> 'Главная страница',
'footer_text'		=> 'Текст в подвале сайта',
'announcement'		=> 'Объявление',
'announcement_desc'	=> 'Оставьте поле пустым, чтобы не показывать объявления (разрешено использование HTML).',
'ItemByPage'		=> 'Количество тем на странице',
'date_format'		=> 'Формат даты',
'date_format_desc'	=> 'Форматирование местного времени / даты => <a href="http://php.net/manual/en/function.date.php">Документация по дате и времени для PHP</a>.',
'date_format_placeholder' => 'Год/месяц/день Часы:минуты',
'default_date_format' => 'l jS F o, H:i:s',
'short_date_format'	=> 'Котороткий формат даты',
'maintenance'		=> 'Обслуживание',
'maintenance_desc'	=> 'Сайт на техническом обслуживании, пожалуйста, зайдите позже.',
'ban_list'			=> 'Чёрный список',
'ban_ok'			=> 'IP-адрес заблокирован.',
'ban_fail'			=> 'IP-адрес уже заблокирован.',
'dashboard'			=> 'О системе',
'add_worker'		=> 'Добавить модератора',
'save'				=> 'Сохранить',
'update'			=> 'Обновить ',
'theme'				=> 'Тема',
'theme_desc'		=> '<a href="config.php/deletecache" class="btn btn-primary btn-sm"><i class="fa fa-trash" aria-hidden="true"></i>Очистить кэш</a>',
'cache_clean'		=> 'Кэш был очищен',
'folder_deleted'	=> 'Папка успешно удалена',
'folder_error'		=> 'Ошибка во время удаления папки',
'lang'				=> 'Язык',
'editor'			=> 'Редактор',
'bbcode'			=> 'BBcode',
'markdown'			=> 'Markdown',
'editor_desc'		=> 'BBcode или Markdown',
'style'				=> 'Цветовая схема ' .Util::Help('Изменение цвета фона и персонализация блока навигации на сайте'),
'style_placeholder'	=> 'Укажите цвет, например: #000000…',
'nb_page_scroll_infinite' => 'Укажите число страниц для автоматической прокрутки',
'nb_page_scroll_desc' => 'Установите 1, чтобы отключить автоматическую прокрутку.',
'salt'				=> 'Секретный ключ',
'salt_desc'			=> 'Оставьте поле пустым, чтобы сгенрировать ключ',
'manage_tags'		=> 'Управление тегами',
'tags'				=> 'Теги',
'tags_help'			=> 'Теги позволяют «пометить» заголовки ваших обсуждений. Они делают заголовок более привлекательным, а также служат фильтром при поиске по форуму.<br />Чтобы отобразить их, введите хотя бы один из них в списке ниже.<br />При создании нового обсуждения вы увидите появившийся селектор тегов.<div class="divider"></div>Если флажок установлен, ключевое слово остаётся невидимым в списке при публикации обсуждения. Это ключевое слово играет роль фильтра по именам пользователей, таким образом пользователи могут подтверждать личность. Также предоставляется пример кода, но вы можете изменить его по своему усмотрению.',
'tags_empty'		=> 'Список тегов пуст!',
'replace'			=> 'Замена',
'tags_result'		=> 'Результат',
'blog'				=> 'Блог',
'blog_new'			=> 'Выберите раздел форума, который будет использоваться как источник новостей для вашего блога.',
'disable_blog'		=> 'Отключить блог',
'post_summary'		=> 'Число слов сообщения для отображение на странице со списком тем.',
'hidden_tag'		=> 'Скрыть этот тег',
'title_tag'			=> '[Мой тег]',
'user'				=> 'Пользователь',
'username_check'	=> 'Имя пользователя для проверки',
'user_checked'		=> 'Проверенный пользователь',
'back_to_site'		=> 'Назад к сайту',
'good-morning'		=> 'Доброе утро',
'good-afternoon'	=> 'Добрый день',
'good-evening'		=> 'Добрый вечер',
'good-night'		=> 'Доброй ночи',
'hello'				=> 'Здраствуйте',
'note'				=> 'примечание',

/************* О Flatboard PRO ***************/
'pro_edition'		=> 'PRO — спасибо за поддержку Flatboard',
'standard_edition'	=> 'Стандартный Flatboard — <a class="btn btn-link" href="https://flatboard.org/download.php" onclick="window.open(this.href); return false;">Перейти на Flatboard PRO</a>',

/************* Системные сообщения ***************/
'warning_installation_file' => 'Файл <code>install.php</code> все ещё находится в корневом каталоге Flatboard.<br />Из соображений безопасности, настоятельно рекомендуется удалить этот файл. <a class="badge badge-danger" href="config.php/delinstallfile" title="Удалить этот файл сейчас?">Удалить</a>.',
'new_version'		=> 'Доступна новая версия',
'theme_not_found'	=> 'Основная тема Flatboard не найдена',

/************* add.php ***************/
'topic_added'		=> 'Тема добавлена!',
'reply_added'		=> 'Ответ добавлен!',
'forum_added'		=> 'Раздел форума добавлен!',
'write_post'		=> 'Написать сообщение…',
'modo_added'		=> 'Новый модератор добавлен!',
'trip'				=> 'Подсказка ' .Util::Help('Нет необходимости «регистрироваться», просто каждый раз вводите одно и то же имя@пароль которое вы выбрали. Ваш пароль конечно же будет отображаться в зашифрованном виде, он хеширован для всех из соображений безопасности!'),
'badge_color'		=> 'Цвет иконки',
'badge_color_desc'	=> 'Введите шестнадцатеричный код цвета или название цвета',
'font_icon'			=> 'Иконка раздела форума',
'font_icon_placeholder' => 'fa-folder',
'font_icon_desc'	=> 'Перейдите на сайт <a href="http://fontawesome.io/icons/">Font Awesome</a> чтобы подобрать нужную иконку',
'email_sent'		=> 'Письмо успешно отправлено',
'email_nosent'		=> 'Не удалось отправить письмо на электронную почту',
'report_desc'		=> 'Примечание: Модератор получит уведомление — ссылку на страницу, о которой вы сообщите.<br />Эта форма предназначена только для сообщений о нарушениях и не используется в качестве средств общения с модераторами.',
'your_email'		=> 'Ваш адрес электронной почты',
'click_to_view_post'=> 'Нажмите здесь, чтобы просмотреть запись',
'order'				=> 'Сортировать',
'flood_start'		=> 'Между сообщениями должно пройти не менее 60 секунд. Пожалуйста, подождите %s минут(ы) и попробуйте опубликовать сообщение снова.',
'private'			=> 'Сделать сайт закрытым (будет требоваться специальный доступ к сайту).',
'restrict_access'	=> 'Ограничить доступ к сайту для команды форума.',
'private_msg'		=> 'Извините, у вас нет прав для открытия этой страницы.',
'unauthorized_access'=> 'Неавторизованный доступ',
'no_tag'			=> 'НЕТ ТЕГА',
'more_info'			=> 'Нажмите здесь для получения более подробной информации',
'cancel'			=> 'Отмена',
'choose_pic'		=> 'Выберите изображение',
'upload'			=> 'Загрузуть',
'private_forum'		=> 'Закрытый форум',
'private_forum_desc'=> 'Форум доступен только команде сайта.',
'the_specified_color_is_not_valid' => 'Ошибка: указанный цвет недопустим.',

/************* delete.php ***************/
'topic_deleted'		=> 'Тема удалена!',
'reply_deleted'		=> 'Ответ удалён!',
'forum_deleted'		=> 'Раздел форума удалён!',
'worker_deleted'	=> 'Модератор удалён!',
'ip_not_banned'		=> 'IP-адрес не был заблокирован.',
'ip_removed'		=> 'IP-адрес был удалён.',

/************* edit.php ***************/
'topic_edited'		=> 'Тема отредактирована!',
'reply_edited'		=> 'Ответ отредактирован!',
'forum_edited'		=> 'Раздел форума отредактирован!',
'pinned_homepage'	=> 'Закреплено на главной странице',
'pick_font'			=> 'Выберите значок',
'useSpace'			=> true,
'home'				=> 'Главная',
'thread_sug'		=> 'Предложенные темы',
'change_pwd'		=> 'Изменить пароль',
'topic'				=> 'Тема',
'newthread'			=> 'Создать тему',
'reply'				=> 'Ответить',
'replies'			=> 'Ответы',
'newreply'			=> 'Новый ответ',
'quote_reply'		=> 'Цитировать',
'quote_by'			=> 'Цитата от пользователя ',
'add_forum'			=> 'Добавить раздел форума',
'plugin'			=> 'Плагины',
'config'			=> 'Настройки',
'logout'			=> 'Выход',
'login'				=> 'Вход',
'redirect'			=> 'Перенаправление',
'add'				=> 'Добавить',
'edit'				=> 'Редактировать',
'delete'			=> 'Удалить',
'title'				=> 'Заголовок',
'content'			=> 'Содержание',
'name'				=> 'Имя',
'mail'				=> 'Email',
'mail_desc'			=> 'Ваш email никогда не отображается на сайте',
'not_required'		=> 'Необязательное поле',
'search'			=> 'Поиск',
'forum'				=> 'Форум',
'password'			=> 'Пароль',
'confirm_password'	=> 'Подтвердить пароль',
'powered'			=> 'Создано на <a href="https://flatboard.org" onclick="window.open(this.href); return false;">Flatboard' .(defined('FLATBOARD_PRO')?' PRO':''). '</a> с <i class="fa fa-heart"></i>',
'feed'				=> 'RSS-лента',
'none'				=> 'Ничего нет',
'info'				=> 'Информация',
'date'				=> 'Дата',
'activity'			=> 'Мероприятия',
'view'				=> 'Просмотр',
'count'				=> 'Сообщений',
'new'				=> 'Новое',
'more'				=> 'Подробнее',
'submit'			=> 'Отправить',
'admin'				=> 'Администратор',
'worker'			=> 'Модераторы',
'sort_forums'		=> 'Сортировать разделы форума',
'yes'				=> 'Да',
'no'				=> 'Нет',
'locked'			=> 'Заблокирован',
'no_reply'			=> 'Вы не можете ответить',
'locked_discussion'	=> 'заблокировал обсуждение.',
'report'			=> 'Пожаловаться',
'day'				=> 'день',
'hour'				=> 'час(ов)',
'minute'			=> 'минут(ы)',
'second'			=> 'секунд(ы)',
'plural'			=> '',
'ago'				=> 'тому назад',
'errLen'			=> 'Слишком короткий или слишком длинный текст',
'errBot'			=> 'Неправильный код',
'errNb'				=> 'Не является положительным целым числом',
'ErrContentFilter'	=> 'Вы ввели как минимум одно нецензурное слово, будьте вежливы.',
'pinned'			=> 'Закрепить',
'stickied_discussion' => 'Закреплённая тема.',
'replied'			=> '<i class="fa fa-share-square"></i> ответил ',
'started'			=> '<i class="fa fa-bolt"></i> создал ',
'notFound'			=> 'Страница не существует!',
'errNotMatch'		=> 'Неправильный пароль',
'captcha'			=> 'Капча',
'enter_code'		=> 'Введите код с картинки',
'math_result'		=> 'Ответьте на этот простой математический вопрос',
'math_captcha'		=> 'Использовать математическую капчу?',
'r_captcha'			=> 'Показать другой код',
'quickNav'			=> 'Быстрая навигация',
'invalid_token'		=> 'Недействительный символ!',
'mail_available'	=> 'Функция отправки электронной почты доступна',
'mail_not_available' => 'Функция отправки электронной почты не доступна',
'statistics'		=> 'Статистика',
'start'				=> '<div class="alert alert-primary" role="alert"><h6>Поздравляем! Установка успешно закончена.</h6>Для начала, вы должны добавить разделы для форума. <a href="add.php/forum" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i></a></div>',
'no-forum' => 'Нет сообщений для отображения.',

/************* view.php ***************/
'permalink'			=> 'Постоянная ссылка',
'solved'			=> 'Решена',
'original_message'	=> 'НАЧАЛО ОБСУЖДЕНИЯ',
'last_modified'		=> 'Последнее изменение %s ',
'last_post'			=> 'Последнее сообщение',
'user_activity'		=> 'Посмотреть их активность',
'error'				=> 'ОШИБКА',
'no_plugin'			=> 'Этот плагин не существует ИЛИ не активирован!',
'want_more'			=> 'Хотите прочесть больше? <a href="index.php' . DS . 'forum">Просмотрите все категории</a> или <a href="' .HTML_BASEPATH. '">просмотрите последние темы</a>.',
'close_del_content'	=> 'Если закрыть это окно, содержимое будет удалено.',
'reply_this_topic'	=> 'Присоединиться к обсуждению',

/************* search.php ***************/
'search_term_found'	=> 'Вот что удалось найти:',
'search_desc'		=> ' Поиск по: авторам, названиям и содержанию тем.',
'search_holder'		=> 'Автор, название или содержание темы.',
'click_tag_search'	=> 'Нажмите на тег, чтобы включить его в поиск.',

/************* Плагины ***************/
'state'				=> 'Вкл./Выкл. плагин',
'state_on'			=> 'Вкл.',
'state_off'			=> 'Выкл.',
'data_save'			=> 'Защищённые данные!',
'description'		=> 'Описание',
'author'			=> 'Автор:',
'check_all'			=> 'Проверить все',
'plugin_help'		=> '<i class="fa fa-warning"></i> Помощь',
'manage_plugin'		=> 'Управление плагинами',
'cantDisable'		=> 'Этот плагин нельзя отключить.',
'click_to_active'	=>'Включить плагин',
'click_to_disable'	=>'Отключить плагин',

/************* auth.php ***************/
'password_changed'	=> 'Ваш пароль был успешно изменён!',
'edit_password'		=> 'Изменить пароль',
'login_confirm'		=> 'Вы успешно вошли!',
'logout_confirm'	=> 'Вы вышли!',
'incorrect_password'=> 'Неправильный пароль.',
'error_maxlogin'	=> 'Слишком много неудачных попыток входа. Повторите попытку через %s минут(ы).',
'already_logged'	=> 'Вы уже вошли!',
'already_logged_msg'=> 'Вы уже вошли как <b>%s</b>, Вам необходимо выйти из системы перед тем, как войти в систему как другой пользователь.',
'bad_user_syntax'	=> 'Ваше имя пользователя должно иметь следующий формат: <b>имя@пароль</b>.',
'previous_page'		=> 'на предыдущую страницу.',

/************* services.php ***************/
'ban_user'			=> 'Забанить этот IP',
'unban_user'		=> 'Восстановить этот IP',
'banned'			=> 'Вы были заблокированы!',
'your_banned'		=> 'Вы были удалены с форума.<br />Если хотите, свяжитесь с администратором форума для получения более подробной информации.<br />Ваш ip: ',
'has_banned'		=> ' был забанен!',
'ban'				=> 'IP-адрес / диапазоны IP-адресов'

);
?>