<?php defined('FLATBOARD') or die('Flatboard Community.');
/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * All Flatboard code is released under the MIT license.
 * 
 * Classe légère pour la gestion des tokens CSRF dans Flatboard.
 *
 * Fournit des méthodes statiques pour générer et vérifier des tokens CSRF
 * afin de protéger contre les attaques Cross-Site Request Forgery.
 */
class CSRF
{
    /** @var string Clé de session pour le token CSRF */
    private const SESSION_TOKEN_KEY = 'csrf_token';

    /** @var string Sel secret pour la génération du token */
    private const SECRET_SALT = 'flatboard_csrf_2025';

    /**
     * Constructeur protégé pour empêcher l'instanciation.
     */
    protected function __construct()
    {
        // Classe statique
    }

    /**
     * Génère un token CSRF basé sur l'adresse IP et une chaîne unique.
     *
     * @return string Token CSRF encodé en base64.
     */
    public static function generate(): string
    {
        $remoteAddr = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
        $token = hash_hmac('sha256', $remoteAddr . uniqid('', true), self::SECRET_SALT);
        return $_SESSION[self::SESSION_TOKEN_KEY] = base64_encode($token);
    }

    /**
     * Vérifie la validité d'un token CSRF.
     *
     * @param string $token Token CSRF à vérifier.
     * @return bool True si le token est valide, false sinon.
     */
    public static function check(string $token): bool
    {
        if (!isset($_SESSION[self::SESSION_TOKEN_KEY]) || $token !== $_SESSION[self::SESSION_TOKEN_KEY]) {
            return false;
        }

        unset($_SESSION[self::SESSION_TOKEN_KEY]); // Supprime le token après vérification
        return true;
    }
}