<?php
/*
 * Nom du projet : Flatboard
 * URL du projet : https://flatboard.org
 * Auteur : Frédéric Kaplon et contributeurs
 * Tout le code de Flatboard est publié sous la licence MIT.
 */

// Démarrer la session
session_start();

// Générer un code CAPTCHA
$random_num = md5(random_bytes(64));
$captcha_code = substr($random_num, 0, 6);

// Stocker le code CAPTCHA dans la session
$_SESSION['captcha'] = $captcha_code;

// Créer une image pour le CAPTCHA
$layer = imagecreatetruecolor(110, 30);

// Attribution de la couleur de fond
$captcha_bg = imagecolorallocate($layer, 233, 236, 237);
imagefill($layer, 0, 0, $captcha_bg);

// Attribution de la couleur du texte
$captcha_text_color = imagecolorallocate($layer, 0, 123, 255);

// Écriture du texte dans l'image
imagestring($layer, 5, 55, 10, $captcha_code, $captcha_text_color);

// Définir l'en-tête pour le type d'image
header('Content-Type: image/png');

// Afficher l'image PNG
imagepng($layer);

// Libérer la mémoire
imagedestroy($layer);
?>