
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES [[utf8]] */;

--
-- Database: `formalms4011`
--

-- --------------------------------------------------------

--
-- Table structure for table `conference_booking`
--

CREATE TABLE `conference_booking` (
  `booking_id` int(11) NOT NULL AUTO_INCREMENT,
  `room_id` int(11) NOT NULL,
  `platform` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_idst` int(11) NOT NULL,
  `approved` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`booking_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `conference_menu`
--

CREATE TABLE `conference_menu` (
  `idMenu` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `collapse` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'false',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idMenu`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `conference_menu`
--

INSERT INTO `conference_menu` VALUES
(1, '_MAIN_CONFERENCE_MANAGMENT', '', 1, 'true', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `conference_menu_under`
--

CREATE TABLE `conference_menu_under` (
  `idUnder` int(11) NOT NULL AUTO_INCREMENT,
  `idMenu` int(11) NOT NULL,
  `module_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_op` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `associated_token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `of_platform` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sequence` int(11) NOT NULL,
  `class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idUnder`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `conference_menu_under`
--

INSERT INTO `conference_menu_under` VALUES
(2, 1, 'room', '_ROOM', 'room', 'view', NULL, 2, 'class.room.php', 'Module_Room', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `conference_room`
--

CREATE TABLE `conference_room` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `idCal` bigint(20) NOT NULL,
  `idCourse` bigint(20) NOT NULL,
  `idSt` bigint(20) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `room_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `starttime` bigint(20) DEFAULT NULL,
  `endtime` bigint(20) DEFAULT NULL,
  `meetinghours` int(11) DEFAULT NULL,
  `maxparticipants` int(11) DEFAULT NULL,
  `bookable` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idCourse` (`idCourse`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `conference_rules_admin`
--

CREATE TABLE `conference_rules_admin` (
  `server_status` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `enable_recording_function` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_advice_insert` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_write` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_chat_recording` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_private_subroom` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_public_subroom` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_drawboard_watch` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_drawboard_write` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_audio` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_webcam` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_stream_watch` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_strem_write` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_remote_desktop` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `server_status_idx` (`server_status`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `conference_rules_room`
--

CREATE TABLE `conference_rules_room` (
  `id_room` int(11) NOT NULL AUTO_INCREMENT,
  `enable_recording_function` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_advice_insert` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_write` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_chat_recording` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_private_subroom` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_public_subroom` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_drawboard_watch` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_drawboard_write` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_audio` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_webcam` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_stream_watch` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_strem_write` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `enable_remote_desktop` enum('admin','alluser','noone') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'noone',
  `room_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `room_type` enum('course','private','public') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'course',
  `id_source` int(11) NOT NULL,
  `room_parent` int(11) NOT NULL,
  `advice_one` mediumtext COLLATE utf8mb4_unicode_ci,
  `advice_two` mediumtext COLLATE utf8mb4_unicode_ci,
  `advice_three` mediumtext COLLATE utf8mb4_unicode_ci,
  `room_logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `room_sponsor` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_room`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `conference_rules_root`
--

CREATE TABLE `conference_rules_root` (
  `system_type` enum('p2p','server') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'p2p',
  `server_ip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `server_port` int(5) unsigned DEFAULT NULL,
  `server_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max_user_at_time` int(10) unsigned NOT NULL,
  `max_room_at_time` int(10) unsigned NOT NULL,
  `max_subroom_for_room` int(10) unsigned NOT NULL,
  `enable_drawboard` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `enable_livestream` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `enable_remote_desktop` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `enable_webcam` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `enable_audio` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `system_type_idx` (`system_type`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `conference_rules_user`
--

CREATE TABLE `conference_rules_user` (
  `id_user` int(11) NOT NULL AUTO_INCREMENT,
  `last_hit` int(11) NOT NULL,
  `id_room` int(11) NOT NULL,
  `userid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_ip` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `level` int(11) NOT NULL,
  `auto_reload` tinyint(1) NOT NULL,
  `banned_until` datetime DEFAULT NULL,
  `chat_record` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `advice_insert` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `write_in_chat` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `request_to_chat` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `create_public_subroom` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `enable_webcam` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `enable_audio` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `enable_drawboard_watch` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `enable_drawboard_draw` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `enable_livestream_watch` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `enable_livestream_publish` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `accept_private_message` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `picture` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_admin_course`
--

CREATE TABLE `core_admin_course` (
  `idst_user` int(11) NOT NULL,
  `type_of_entry` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_entry` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idst_user_idx` (`idst_user`),
  KEY `type_of_entry_idx` (`type_of_entry`),
  KEY `id_entry_idx` (`id_entry`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_admin_tree`
--

CREATE TABLE `core_admin_tree` (
  `idst` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idstAdmin` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idst_idx` (`idst`),
  KEY `idstAdmin_idx` (`idstAdmin`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_calendar`
--

CREATE TABLE `core_calendar` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `class` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `create_date` date DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `private` varchar(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` bigint(20) DEFAULT NULL,
  `visibility_rules` text COLLATE utf8mb4_unicode_ci,
  `_owner` int(11) DEFAULT NULL,
  `_day` smallint(2) DEFAULT NULL,
  `_month` smallint(2) DEFAULT NULL,
  `_year` smallint(4) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_code`
--

CREATE TABLE `core_code` (
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idCodeGroup` int(11) NOT NULL,
  `used` tinyint(1) NOT NULL,
  `idUser` int(11) DEFAULT NULL,
  `unlimitedUse` tinyint(1) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `code_idx` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_code_association`
--

CREATE TABLE `core_code_association` (
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idUser` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `code_idx` (`code`),
  KEY `id_user_idx` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_code_course`
--

CREATE TABLE `core_code_course` (
  `idCodeGroup` int(11) NOT NULL,
  `idCourse` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_code_groups`
--

CREATE TABLE `core_code_groups` (
  `idCodeGroup` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idCodeGroup`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_code_org`
--

CREATE TABLE `core_code_org` (
  `idCodeGroup` int(11) NOT NULL,
  `idOrg` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_codegroup_idx` (`idCodeGroup`),
  KEY `id_org_idx` (`idOrg`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_connection`
--

CREATE TABLE `core_connection` (
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `name_idx` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_connector`
--

CREATE TABLE `core_connector` (
  `type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_country`
--

CREATE TABLE `core_country` (
  `id_country` int(11) NOT NULL AUTO_INCREMENT,
  `name_country` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `iso_code_country` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_zone` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_country`),
  KEY `IDX_COUNTRIES_NAME` (`name_country`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=245 ;

--
-- Dumping data for table `core_country`
--

INSERT INTO `core_country` VALUES
(1, 'AFGHANISTAN', 'AF', 0, '[[regtime]]', '[[regtime]]'),
(2, 'ALAND ISLANDS', 'AX', 0, '[[regtime]]', '[[regtime]]'),
(3, 'ALBANIA', 'AL', 0, '[[regtime]]', '[[regtime]]'),
(4, 'ALGERIA', 'DZ', 0, '[[regtime]]', '[[regtime]]'),
(5, 'AMERICAN SAMOA', 'AS', 0, '[[regtime]]', '[[regtime]]'),
(6, 'ANDORRA', 'AD', 0, '[[regtime]]', '[[regtime]]'),
(7, 'ANGOLA', 'AO', 0, '[[regtime]]', '[[regtime]]'),
(8, 'ANGUILLA', 'AI', 0, '[[regtime]]', '[[regtime]]'),
(9, 'ANTARCTICA', 'AQ', 0, '[[regtime]]', '[[regtime]]'),
(10, 'ANTIGUA AND BARBUDA', 'AG', 0, '[[regtime]]', '[[regtime]]'),
(11, 'ARGENTINA', 'AR', 0, '[[regtime]]', '[[regtime]]'),
(12, 'ARMENIA', 'AM', 0, '[[regtime]]', '[[regtime]]'),
(13, 'ARUBA', 'AW', 0, '[[regtime]]', '[[regtime]]'),
(14, 'AUSTRALIA', 'AU', 0, '[[regtime]]', '[[regtime]]'),
(15, 'AUSTRIA', 'AT', 0, '[[regtime]]', '[[regtime]]'),
(16, 'AZERBAIJAN', 'AZ', 0, '[[regtime]]', '[[regtime]]'),
(17, 'BAHAMAS', 'BS', 0, '[[regtime]]', '[[regtime]]'),
(18, 'BAHRAIN', 'BH', 0, '[[regtime]]', '[[regtime]]'),
(19, 'BANGLADESH', 'BD', 0, '[[regtime]]', '[[regtime]]'),
(20, 'BARBADOS', 'BB', 0, '[[regtime]]', '[[regtime]]'),
(21, 'BELARUS', 'BY', 0, '[[regtime]]', '[[regtime]]'),
(22, 'BELGIUM', 'BE', 0, '[[regtime]]', '[[regtime]]'),
(23, 'BELIZE', 'BZ', 0, '[[regtime]]', '[[regtime]]'),
(24, 'BENIN', 'BJ', 0, '[[regtime]]', '[[regtime]]'),
(25, 'BERMUDA', 'BM', 0, '[[regtime]]', '[[regtime]]'),
(26, 'BHUTAN', 'BT', 0, '[[regtime]]', '[[regtime]]'),
(27, 'BOLIVIA', 'BO', 0, '[[regtime]]', '[[regtime]]'),
(28, 'BOSNIA AND HERZEGOVINA', 'BA', 0, '[[regtime]]', '[[regtime]]'),
(29, 'BOTSWANA', 'BW', 0, '[[regtime]]', '[[regtime]]'),
(30, 'BOUVET ISLAND', 'BV', 0, '[[regtime]]', '[[regtime]]'),
(31, 'BRAZIL', 'BR', 0, '[[regtime]]', '[[regtime]]'),
(32, 'BRITISH INDIAN OCEAN TERRITORY', 'IO', 0, '[[regtime]]', '[[regtime]]'),
(33, 'BRUNEI DARUSSALAM', 'BN', 0, '[[regtime]]', '[[regtime]]'),
(34, 'BULGARIA', 'BG', 0, '[[regtime]]', '[[regtime]]'),
(35, 'BURKINA FASO', 'BF', 0, '[[regtime]]', '[[regtime]]'),
(36, 'BURUNDI', 'BI', 0, '[[regtime]]', '[[regtime]]'),
(37, 'CAMBODIA', 'KH', 0, '[[regtime]]', '[[regtime]]'),
(38, 'CAMEROON', 'CM', 0, '[[regtime]]', '[[regtime]]'),
(39, 'CANADA', 'CA', 0, '[[regtime]]', '[[regtime]]'),
(40, 'CAPE VERDE', 'CV', 0, '[[regtime]]', '[[regtime]]'),
(41, 'CAYMAN ISLANDS', 'KY', 0, '[[regtime]]', '[[regtime]]'),
(42, 'CENTRAL AFRICAN REPUBLIC', 'CF', 0, '[[regtime]]', '[[regtime]]'),
(43, 'CHAD', 'TD', 0, '[[regtime]]', '[[regtime]]'),
(44, 'CHILE', 'CL', 0, '[[regtime]]', '[[regtime]]'),
(45, 'CHINA', 'CN', 0, '[[regtime]]', '[[regtime]]'),
(46, 'CHRISTMAS ISLAND', 'CX', 0, '[[regtime]]', '[[regtime]]'),
(47, 'COCOS (KEELING) ISLANDS', 'CC', 0, '[[regtime]]', '[[regtime]]'),
(48, 'COLOMBIA', 'CO', 0, '[[regtime]]', '[[regtime]]'),
(49, 'COMOROS', 'KM', 0, '[[regtime]]', '[[regtime]]'),
(50, 'CONGO', 'CG', 0, '[[regtime]]', '[[regtime]]'),
(51, 'CONGO, THE DEMOCRATIC REPUBLIC OF THE', 'CD', 0, '[[regtime]]', '[[regtime]]'),
(52, 'COOK ISLANDS', 'CK', 0, '[[regtime]]', '[[regtime]]'),
(53, 'COSTA RICA', 'CR', 0, '[[regtime]]', '[[regtime]]'),
(54, 'IVORY COAST', 'CI', 0, '[[regtime]]', '[[regtime]]'),
(55, 'CROATIA', 'HR', 0, '[[regtime]]', '[[regtime]]'),
(56, 'CUBA', 'CU', 0, '[[regtime]]', '[[regtime]]'),
(57, 'CYPRUS', 'CY', 0, '[[regtime]]', '[[regtime]]'),
(58, 'CZECH REPUBLIC', 'CZ', 0, '[[regtime]]', '[[regtime]]'),
(59, 'DENMARK', 'DK', 0, '[[regtime]]', '[[regtime]]'),
(60, 'DJIBOUTI', 'DJ', 0, '[[regtime]]', '[[regtime]]'),
(61, 'DOMINICA', 'DM', 0, '[[regtime]]', '[[regtime]]'),
(62, 'DOMINICAN REPUBLIC', 'DO', 0, '[[regtime]]', '[[regtime]]'),
(63, 'ECUADOR', 'EC', 0, '[[regtime]]', '[[regtime]]'),
(64, 'EGYPT', 'EG', 0, '[[regtime]]', '[[regtime]]'),
(65, 'EL SALVADOR', 'SV', 0, '[[regtime]]', '[[regtime]]'),
(66, 'EQUATORIAL GUINEA', 'GQ', 0, '[[regtime]]', '[[regtime]]'),
(67, 'ERITREA', 'ER', 0, '[[regtime]]', '[[regtime]]'),
(68, 'ESTONIA', 'EE', 0, '[[regtime]]', '[[regtime]]'),
(69, 'ETHIOPIA', 'ET', 0, '[[regtime]]', '[[regtime]]'),
(70, 'FALKLAND ISLANDS (MALVINAS)', 'FK', 0, '[[regtime]]', '[[regtime]]'),
(71, 'FAROE ISLANDS', 'FO', 0, '[[regtime]]', '[[regtime]]'),
(72, 'FIJI', 'FJ', 0, '[[regtime]]', '[[regtime]]'),
(73, 'FINLAND', 'FI', 0, '[[regtime]]', '[[regtime]]'),
(74, 'FRANCE', 'FR', 0, '[[regtime]]', '[[regtime]]'),
(75, 'FRENCH GUIANA', 'GF', 0, '[[regtime]]', '[[regtime]]'),
(76, 'FRENCH POLYNESIA', 'PF', 0, '[[regtime]]', '[[regtime]]'),
(77, 'FRENCH SOUTHERN TERRITORIES', 'TF', 0, '[[regtime]]', '[[regtime]]'),
(78, 'GABON', 'GA', 0, '[[regtime]]', '[[regtime]]'),
(79, 'GAMBIA', 'GM', 0, '[[regtime]]', '[[regtime]]'),
(80, 'GEORGIA', 'GE', 0, '[[regtime]]', '[[regtime]]'),
(81, 'GERMANY', 'DE', 0, '[[regtime]]', '[[regtime]]'),
(82, 'GHANA', 'GH', 0, '[[regtime]]', '[[regtime]]'),
(83, 'GIBRALTAR', 'GI', 0, '[[regtime]]', '[[regtime]]'),
(84, 'GREECE', 'GR', 0, '[[regtime]]', '[[regtime]]'),
(85, 'GREENLAND', 'GL', 0, '[[regtime]]', '[[regtime]]'),
(86, 'GRENADA', 'GD', 0, '[[regtime]]', '[[regtime]]'),
(87, 'GUADELOUPE', 'GP', 0, '[[regtime]]', '[[regtime]]'),
(88, 'GUAM', 'GU', 0, '[[regtime]]', '[[regtime]]'),
(89, 'GUATEMALA', 'GT', 0, '[[regtime]]', '[[regtime]]'),
(90, 'GUERNSEY', 'GG', 0, '[[regtime]]', '[[regtime]]'),
(91, 'GUINEA', 'GN', 0, '[[regtime]]', '[[regtime]]'),
(92, 'GUINEA-BISSAU', 'GW', 0, '[[regtime]]', '[[regtime]]'),
(93, 'GUYANA', 'GY', 0, '[[regtime]]', '[[regtime]]'),
(94, 'HAITI', 'HT', 0, '[[regtime]]', '[[regtime]]'),
(95, 'HEARD ISLAND AND MCDONALD ISLANDS', 'HM', 0, '[[regtime]]', '[[regtime]]'),
(96, 'HONDURAS', 'HN', 0, '[[regtime]]', '[[regtime]]'),
(97, 'HONG KONG', 'HK', 0, '[[regtime]]', '[[regtime]]'),
(98, 'HUNGARY', 'HU', 0, '[[regtime]]', '[[regtime]]'),
(99, 'ICELAND', 'IS', 0, '[[regtime]]', '[[regtime]]'),
(100, 'INDIA', 'IN', 0, '[[regtime]]', '[[regtime]]'),
(101, 'INDONESIA', 'ID', 0, '[[regtime]]', '[[regtime]]'),
(102, 'IRAN', 'IR', 0, '[[regtime]]', '[[regtime]]'),
(103, 'IRAQ', 'IQ', 0, '[[regtime]]', '[[regtime]]'),
(104, 'IRELAND', 'IE', 0, '[[regtime]]', '[[regtime]]'),
(105, 'ISLE OF MAN', 'IM', 0, '[[regtime]]', '[[regtime]]'),
(106, 'ISRAEL', 'IL', 0, '[[regtime]]', '[[regtime]]'),
(107, 'ITALY', 'IT', 0, '[[regtime]]', '[[regtime]]'),
(108, 'JAMAICA', 'JM', 0, '[[regtime]]', '[[regtime]]'),
(109, 'JAPAN', 'JP', 0, '[[regtime]]', '[[regtime]]'),
(110, 'JERSEY', 'JE', 0, '[[regtime]]', '[[regtime]]'),
(111, 'JORDAN', 'JO', 0, '[[regtime]]', '[[regtime]]'),
(112, 'KAZAKHSTAN', 'KZ', 0, '[[regtime]]', '[[regtime]]'),
(113, 'KENYA', 'KE', 0, '[[regtime]]', '[[regtime]]'),
(114, 'KIRIBATI', 'KI', 0, '[[regtime]]', '[[regtime]]'),
(115, 'KOREA, DEMOCRATIC PEOPLE''S REPUBLIC OF', 'KP', 0, '[[regtime]]', '[[regtime]]'),
(116, 'KOREA, REPUBLIC OF', 'KR', 0, '[[regtime]]', '[[regtime]]'),
(117, 'KUWAIT', 'KW', 0, '[[regtime]]', '[[regtime]]'),
(118, 'KYRGYZSTAN', 'KG', 0, '[[regtime]]', '[[regtime]]'),
(119, 'LAO PEOPLE''S DEMOCRATIC REPUBLIC', 'LA', 0, '[[regtime]]', '[[regtime]]'),
(120, 'LATVIA', 'LV', 0, '[[regtime]]', '[[regtime]]'),
(121, 'LEBANON', 'LB', 0, '[[regtime]]', '[[regtime]]'),
(122, 'LESOTHO', 'LS', 0, '[[regtime]]', '[[regtime]]'),
(123, 'LIBERIA', 'LR', 0, '[[regtime]]', '[[regtime]]'),
(124, 'LIBYAN ARAB JAMAHIRIYA', 'LY', 0, '[[regtime]]', '[[regtime]]'),
(125, 'LIECHTENSTEIN', 'LI', 0, '[[regtime]]', '[[regtime]]'),
(126, 'LITHUANIA', 'LT', 0, '[[regtime]]', '[[regtime]]'),
(127, 'LUXEMBOURG', 'LU', 0, '[[regtime]]', '[[regtime]]'),
(128, 'MACAO', 'MO', 0, '[[regtime]]', '[[regtime]]'),
(129, 'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF', 'MK', 0, '[[regtime]]', '[[regtime]]'),
(130, 'MADAGASCAR', 'MG', 0, '[[regtime]]', '[[regtime]]'),
(131, 'MALAWI', 'MW', 0, '[[regtime]]', '[[regtime]]'),
(132, 'MALAYSIA', 'MY', 0, '[[regtime]]', '[[regtime]]'),
(133, 'MALDIVES', 'MV', 0, '[[regtime]]', '[[regtime]]'),
(134, 'MALI', 'ML', 0, '[[regtime]]', '[[regtime]]'),
(135, 'MALTA', 'MT', 0, '[[regtime]]', '[[regtime]]'),
(136, 'MARSHALL ISLANDS', 'MH', 0, '[[regtime]]', '[[regtime]]'),
(137, 'MARTINIQUE', 'MQ', 0, '[[regtime]]', '[[regtime]]'),
(138, 'MAURITANIA', 'MR', 0, '[[regtime]]', '[[regtime]]'),
(139, 'MAURITIUS', 'MU', 0, '[[regtime]]', '[[regtime]]'),
(140, 'MAYOTTE', 'YT', 0, '[[regtime]]', '[[regtime]]'),
(141, 'MEXICO', 'MX', 0, '[[regtime]]', '[[regtime]]'),
(142, 'MICRONESIA, FEDERATED STATES OF', 'FM', 0, '[[regtime]]', '[[regtime]]'),
(143, 'MOLDOVA, REPUBLIC OF', 'MD', 0, '[[regtime]]', '[[regtime]]'),
(144, 'MONACO', 'MC', 0, '[[regtime]]', '[[regtime]]'),
(145, 'MONGOLIA', 'MN', 0, '[[regtime]]', '[[regtime]]'),
(146, 'MONTENEGRO', 'ME', 0, '[[regtime]]', '[[regtime]]'),
(147, 'MONTSERRAT', 'MS', 0, '[[regtime]]', '[[regtime]]'),
(148, 'MOROCCO', 'MA', 0, '[[regtime]]', '[[regtime]]'),
(149, 'MOZAMBIQUE', 'MZ', 0, '[[regtime]]', '[[regtime]]'),
(150, 'MYANMAR', 'MM', 0, '[[regtime]]', '[[regtime]]'),
(151, 'NAMIBIA', 'NA', 0, '[[regtime]]', '[[regtime]]'),
(152, 'NAURU', 'NR', 0, '[[regtime]]', '[[regtime]]'),
(153, 'NEPAL', 'NP', 0, '[[regtime]]', '[[regtime]]'),
(154, 'NETHERLANDS', 'NL', 0, '[[regtime]]', '[[regtime]]'),
(155, 'NETHERLANDS ANTILLES', 'AN', 0, '[[regtime]]', '[[regtime]]'),
(156, 'NEW CALEDONIA', 'NC', 0, '[[regtime]]', '[[regtime]]'),
(157, 'NEW ZEALAND', 'NZ', 0, '[[regtime]]', '[[regtime]]'),
(158, 'NICARAGUA', 'NI', 0, '[[regtime]]', '[[regtime]]'),
(159, 'NIGER', 'NE', 0, '[[regtime]]', '[[regtime]]'),
(160, 'NIGERIA', 'NG', 0, '[[regtime]]', '[[regtime]]'),
(161, 'NIUE', 'NU', 0, '[[regtime]]', '[[regtime]]'),
(162, 'NORFOLK ISLAND', 'NF', 0, '[[regtime]]', '[[regtime]]'),
(163, 'NORTHERN MARIANA ISLANDS', 'MP', 0, '[[regtime]]', '[[regtime]]'),
(164, 'NORWAY', 'NO', 0, '[[regtime]]', '[[regtime]]'),
(165, 'OMAN', 'OM', 0, '[[regtime]]', '[[regtime]]'),
(166, 'PAKISTAN', 'PK', 0, '[[regtime]]', '[[regtime]]'),
(167, 'PALAU', 'PW', 0, '[[regtime]]', '[[regtime]]'),
(168, 'PALESTINIAN TERRITORY, OCCUPIED', 'PS', 0, '[[regtime]]', '[[regtime]]'),
(169, 'PANAMA', 'PA', 0, '[[regtime]]', '[[regtime]]'),
(170, 'PAPUA NEW GUINEA', 'PG', 0, '[[regtime]]', '[[regtime]]'),
(171, 'PARAGUAY', 'PY', 0, '[[regtime]]', '[[regtime]]'),
(172, 'PERU', 'PE', 0, '[[regtime]]', '[[regtime]]'),
(173, 'PHILIPPINES', 'PH', 0, '[[regtime]]', '[[regtime]]'),
(174, 'PITCAIRN', 'PN', 0, '[[regtime]]', '[[regtime]]'),
(175, 'POLAND', 'PL', 0, '[[regtime]]', '[[regtime]]'),
(176, 'PORTUGAL', 'PT', 0, '[[regtime]]', '[[regtime]]'),
(177, 'PUERTO RICO', 'PR', 0, '[[regtime]]', '[[regtime]]'),
(178, 'QATAR', 'QA', 0, '[[regtime]]', '[[regtime]]'),
(179, 'Reunion', 'RE', 0, '[[regtime]]', '[[regtime]]'),
(180, 'ROMANIA', 'RO', 0, '[[regtime]]', '[[regtime]]'),
(181, 'RUSSIAN FEDERATION', 'RU', 0, '[[regtime]]', '[[regtime]]'),
(182, 'RWANDA', 'RW', 0, '[[regtime]]', '[[regtime]]'),
(183, 'SAINT HELENA', 'SH', 0, '[[regtime]]', '[[regtime]]'),
(184, 'SAINT KITTS AND NEVIS', 'KN', 0, '[[regtime]]', '[[regtime]]'),
(185, 'SAINT LUCIA', 'LC', 0, '[[regtime]]', '[[regtime]]'),
(186, 'SAINT PIERRE AND MIQUELON', 'PM', 0, '[[regtime]]', '[[regtime]]'),
(187, 'SAINT VINCENT AND THE GRENADINES', 'VC', 0, '[[regtime]]', '[[regtime]]'),
(188, 'SAMOA', 'WS', 0, '[[regtime]]', '[[regtime]]'),
(189, 'SAN MARINO', 'SM', 0, '[[regtime]]', '[[regtime]]'),
(190, 'SAO TOME AND PRINCIPE', 'ST', 0, '[[regtime]]', '[[regtime]]'),
(191, 'SAUDI ARABIA', 'SA', 0, '[[regtime]]', '[[regtime]]'),
(192, 'SENEGAL', 'SN', 0, '[[regtime]]', '[[regtime]]'),
(193, 'SERBIA', 'RS', 0, '[[regtime]]', '[[regtime]]'),
(194, 'SEYCHELLES', 'SC', 0, '[[regtime]]', '[[regtime]]'),
(195, 'SIERRA LEONE', 'SL', 0, '[[regtime]]', '[[regtime]]'),
(196, 'SINGAPORE', 'SG', 0, '[[regtime]]', '[[regtime]]'),
(197, 'SLOVAKIA', 'SK', 0, '[[regtime]]', '[[regtime]]'),
(198, 'SLOVENIA', 'SI', 0, '[[regtime]]', '[[regtime]]'),
(199, 'SOLOMON ISLANDS', 'SB', 0, '[[regtime]]', '[[regtime]]'),
(200, 'SOMALIA', 'SO', 0, '[[regtime]]', '[[regtime]]'),
(201, 'SOUTH AFRICA', 'ZA', 0, '[[regtime]]', '[[regtime]]'),
(202, 'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS', 'GS', 0, '[[regtime]]', '[[regtime]]'),
(203, 'SPAIN', 'ES', 0, '[[regtime]]', '[[regtime]]'),
(204, 'SRI LANKA', 'LK', 0, '[[regtime]]', '[[regtime]]'),
(205, 'SUDAN', 'SD', 0, '[[regtime]]', '[[regtime]]'),
(206, 'SURINAME', 'SR', 0, '[[regtime]]', '[[regtime]]'),
(207, 'SVALBARD AND JAN MAYEN', 'SJ', 0, '[[regtime]]', '[[regtime]]'),
(208, 'SWAZILAND', 'SZ', 0, '[[regtime]]', '[[regtime]]'),
(209, 'SWEDEN', 'SE', 0, '[[regtime]]', '[[regtime]]'),
(210, 'SWITZERLAND', 'CH', 0, '[[regtime]]', '[[regtime]]'),
(211, 'SYRIAN ARAB REPUBLIC', 'SY', 0, '[[regtime]]', '[[regtime]]'),
(212, 'TAIWAN, PROVINCE OF CHINA', 'TW', 0, '[[regtime]]', '[[regtime]]'),
(213, 'TAJIKISTAN', 'TJ', 0, '[[regtime]]', '[[regtime]]'),
(214, 'TANZANIA, UNITED REPUBLIC OF', 'TZ', 0, '[[regtime]]', '[[regtime]]'),
(215, 'THAILAND', 'TH', 0, '[[regtime]]', '[[regtime]]'),
(216, 'TIMOR-LESTE', 'TL', 0, '[[regtime]]', '[[regtime]]'),
(217, 'TOGO', 'TG', 0, '[[regtime]]', '[[regtime]]'),
(218, 'TOKELAU', 'TK', 0, '[[regtime]]', '[[regtime]]'),
(219, 'TONGA', 'TO', 0, '[[regtime]]', '[[regtime]]'),
(220, 'TRINIDAD AND TOBAGO', 'TT', 0, '[[regtime]]', '[[regtime]]'),
(221, 'TUNISIA', 'TN', 0, '[[regtime]]', '[[regtime]]'),
(222, 'TURKEY', 'TR', 0, '[[regtime]]', '[[regtime]]'),
(223, 'TURKMENISTAN', 'TM', 0, '[[regtime]]', '[[regtime]]'),
(224, 'TURKS AND CAICOS ISLANDS', 'TC', 0, '[[regtime]]', '[[regtime]]'),
(225, 'TUVALU', 'TV', 0, '[[regtime]]', '[[regtime]]'),
(226, 'UGANDA', 'UG', 0, '[[regtime]]', '[[regtime]]'),
(227, 'UKRAINE', 'UA', 0, '[[regtime]]', '[[regtime]]'),
(228, 'UNITED ARAB EMIRATES', 'AE', 0, '[[regtime]]', '[[regtime]]'),
(229, 'UNITED KINGDOM', 'GB', 0, '[[regtime]]', '[[regtime]]'),
(230, 'UNITED STATES', 'US', 0, '[[regtime]]', '[[regtime]]'),
(231, 'UNITED STATES MINOR OUTLYING ISLANDS', 'UM', 0, '[[regtime]]', '[[regtime]]'),
(232, 'URUGUAY', 'UY', 0, '[[regtime]]', '[[regtime]]'),
(233, 'UZBEKISTAN', 'UZ', 0, '[[regtime]]', '[[regtime]]'),
(234, 'VANUATU', 'VU', 0, '[[regtime]]', '[[regtime]]'),
(235, 'VATICAN CITY STATE', 'VA', 0, '[[regtime]]', '[[regtime]]'),
(236, 'VENEZUELA', 'VE', 0, '[[regtime]]', '[[regtime]]'),
(237, 'VIET NAM', 'VN', 0, '[[regtime]]', '[[regtime]]'),
(238, 'VIRGIN ISLANDS, BRITISH', 'VG', 0, '[[regtime]]', '[[regtime]]'),
(239, 'VIRGIN ISLANDS, U.S.', 'VI', 0, '[[regtime]]', '[[regtime]]'),
(240, 'WALLIS AND FUTUNA', 'WF', 0, '[[regtime]]', '[[regtime]]'),
(241, 'WESTERN SAHARA', 'EH', 0, '[[regtime]]', '[[regtime]]'),
(242, 'YEMEN', 'YE', 0, '[[regtime]]', '[[regtime]]'),
(243, 'ZAMBIA', 'ZM', 0, '[[regtime]]', '[[regtime]]'),
(244, 'ZIMBABWE', 'ZW', 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_customfield`
--

CREATE TABLE `core_customfield` (
  `id_field` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `show_on_platform` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'framework,',
  `use_multilang` tinyint(1) NOT NULL,
  `area_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_field`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_customfield_area`
--

CREATE TABLE `core_customfield_area` (
  `area_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `area_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `area_table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `area_field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `core_customfield_area`
--

INSERT INTO `core_customfield_area` VALUES
('LO_TEST', 'Learning Object Test', '%lms_testquest', 'idQuest', 1, '[[regtime]]', '[[regtime]]'),
('COURSE', 'Course', '%lms_course', 'idCourse', 2, '[[regtime]]', '[[regtime]]'),
('COURSE_EDITION', 'Course Edition', '%lms_course_editions', 'id_edition', 3, '[[regtime]]', '[[regtime]]'),
('ORG_CHART', 'Org Chart Tree', 'core_org_chart_tree', 'idOrg', 4, '[[regtime]]', '[[regtime]]'),
('LO_OBJECT', 'Learning Object', 'learning_organization', 'idOrg', 5, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_customfield_entry`
--

CREATE TABLE `core_customfield_entry` (
  `id_field` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_obj` int(11) NOT NULL,
  `obj_entry` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_customfield_lang`
--

CREATE TABLE `core_customfield_lang` (
  `id_field` int(11) NOT NULL,
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_customfield_son`
--

CREATE TABLE `core_customfield_son` (
  `id_field_son` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_field` int(11) NOT NULL,
  `sequence` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_field_son`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_customfield_son_lang`
--

CREATE TABLE `core_customfield_son_lang` (
  `id_field_son` int(11) NOT NULL,
  `lang_code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_customfield_type`
--

CREATE TABLE `core_customfield_type` (
  `type_field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_category` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'standard',
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_field_idx` (`type_field`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `core_customfield_type`
--

INSERT INTO `core_customfield_type` VALUES
('dropdown', 'class.dropdown.php', 'Field_Dropdown', 'standard', 1, '[[regtime]]', '[[regtime]]'),
('textfield', 'class.textfield.php', 'Field_Textfield', 'standard', 2, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_deleted_user`
--

CREATE TABLE `core_deleted_user` (
  `id_deletion` int(11) NOT NULL AUTO_INCREMENT,
  `idst` int(11) NOT NULL,
  `userid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `firstname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pass` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `photo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `signature` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `level` int(11) NOT NULL,
  `lastenter` datetime DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `pwd_expire_at` datetime DEFAULT NULL,
  `register_date` datetime DEFAULT NULL,
  `deletion_date` datetime DEFAULT NULL,
  `deleted_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_deletion`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_domain_configs`
--

CREATE TABLE `core_domain_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `parentId` int(11) DEFAULT NULL,
  `template` varchar(255) DEFAULT NULL,
  `orgId` int(11) DEFAULT NULL,
  `mailConfigId` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_event`
--

CREATE TABLE `core_event` (
  `idEvent` int(11) NOT NULL AUTO_INCREMENT,
  `idClass` int(11) NOT NULL,
  `module` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `section` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` smallint(1) unsigned NOT NULL DEFAULT '1289',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idEvent`),
  KEY `idClass` (`idClass`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_event_class`
--

CREATE TABLE `core_event_class` (
  `idClass` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `platform` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idClass`),
  UNIQUE KEY `class_2` (`class`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=52 ;

--
-- Dumping data for table `core_event_class`
--

INSERT INTO `core_event_class` VALUES
(1, 'UserNew', 'framework', '', '[[regtime]]', '[[regtime]]'),
(2, 'UserMod', 'framework', '', '[[regtime]]', '[[regtime]]'),
(3, 'UserDel', 'framework', '', '[[regtime]]', '[[regtime]]'),
(4, 'UserNewModerated', 'framework', '', '[[regtime]]', '[[regtime]]'),
(5, 'UserGroupModerated', 'framework', '', '[[regtime]]', '[[regtime]]'),
(6, 'UserGroupInsert', 'framework', '', '[[regtime]]', '[[regtime]]'),
(7, 'UserGroupRemove', 'framework', '', '[[regtime]]', '[[regtime]]'),
(8, 'UserCourseInsertModerate', 'lms-a', '', '[[regtime]]', '[[regtime]]'),
(9, 'UserCourseInserted', 'lms-a', '', '[[regtime]]', '[[regtime]]'),
(10, 'UserCourseRemoved', 'lms-a', '', '[[regtime]]', '[[regtime]]'),
(11, 'UserCourseLevelChanged', 'lms-a', '', '[[regtime]]', '[[regtime]]'),
(12, 'UserCourseEnded', 'lms-a', '', '[[regtime]]', '[[regtime]]'),
(13, 'CoursePorpModified', 'lms-a', '', '[[regtime]]', '[[regtime]]'),
(14, 'AdviceNew', 'lms', '', '[[regtime]]', '[[regtime]]'),
(15, 'MsgNewReceived', 'lms', '', '[[regtime]]', '[[regtime]]'),
(16, 'ForumNewCategory', 'lms', '', '[[regtime]]', '[[regtime]]'),
(17, 'ForumNewThread', 'lms', '', '[[regtime]]', '[[regtime]]'),
(18, 'ForumNewResponse', 'lms', '', '[[regtime]]', '[[regtime]]'),
(19, 'UserCourseRemovedModerate', 'lms-a', '', '[[regtime]]', '[[regtime]]'),
(38, 'UserApproved', 'framework', '', '[[regtime]]', '[[regtime]]'),
(39, 'UserCourseBuy', 'lms', '', '[[regtime]]', '[[regtime]]'),
(40, 'SettingUpdate', 'framework', '', '[[regtime]]', '[[regtime]]'),
(41, 'UserNewWaiting', 'framework', '', '[[regtime]]', '[[regtime]]'),
(42, 'UserNewApi', 'framework', '', '[[regtime]]', '[[regtime]]'),
(43, 'UserCourseInsertedApi', 'lms-a', '', '[[regtime]]', '[[regtime]]'),
(44, 'UserCourseInsertedModerators', 'lms-a', '', '[[regtime]]', '[[regtime]]'),
(45, 'UserCourseSuspendedSuperAdmin', 'framework', '', '[[regtime]]', '[[regtime]]'),
(46, 'UserRegistrationSuperadmins', 'lms-a', '', '[[regtime]]', '[[regtime]]'),
(50, 'UserCourseInsertOverbooking', 'lms-a', '', '[[regtime]]', '[[regtime]]'),
(51, 'PurchaseCourse', 'lms', '', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_event_consumer`
--

CREATE TABLE `core_event_consumer` (
  `idConsumer` int(11) NOT NULL AUTO_INCREMENT,
  `consumer_class` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idConsumer`),
  UNIQUE KEY `consumer_class` (`consumer_class`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci COMMENT='Table of consumer with PHP classes and files' AUTO_INCREMENT=6 ;

--
-- Dumping data for table `core_event_consumer`
--

INSERT INTO `core_event_consumer` VALUES
(1, 'FormaUserNotifier', '/lib/lib.usernotifier.php', '[[regtime]]', '[[regtime]]'),
(2, 'FormaCourseNotifier', '/lib/lib.coursenotifier.php', '[[regtime]]', '[[regtime]]'),
(3, 'FormaOrgchartNotifier', '/lib/lib.orgchartnotifier.php', '[[regtime]]', '[[regtime]]'),
(5, 'FormaSettingNotifier', '/lib/lib.settingnotifier.php', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_event_consumer_class`
--

CREATE TABLE `core_event_consumer_class` (
  `idConsumer` int(11) NOT NULL,
  `idClass` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_consumer_idx` (`idConsumer`),
  KEY `id_class_idx` (`idClass`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci COMMENT='n:m relation from consumers and event''s classes' AUTO_INCREMENT=33 ;

--
-- Dumping data for table `core_event_consumer_class`
--

INSERT INTO `core_event_consumer_class` VALUES
(1, 1, 1, '[[regtime]]', '[[regtime]]'),
(1, 2, 2, '[[regtime]]', '[[regtime]]'),
(1, 3, 3, '[[regtime]]', '[[regtime]]'),
(1, 4, 4, '[[regtime]]', '[[regtime]]'),
(1, 5, 5, '[[regtime]]', '[[regtime]]'),
(1, 6, 6, '[[regtime]]', '[[regtime]]'),
(1, 7, 7, '[[regtime]]', '[[regtime]]'),
(1, 8, 8, '[[regtime]]', '[[regtime]]'),
(1, 9, 9, '[[regtime]]', '[[regtime]]'),
(1, 10, 10, '[[regtime]]', '[[regtime]]'),
(1, 11, 11, '[[regtime]]', '[[regtime]]'),
(1, 12, 12, '[[regtime]]', '[[regtime]]'),
(1, 13, 13, '[[regtime]]', '[[regtime]]'),
(1, 14, 14, '[[regtime]]', '[[regtime]]'),
(1, 15, 15, '[[regtime]]', '[[regtime]]'),
(1, 16, 16, '[[regtime]]', '[[regtime]]'),
(1, 17, 17, '[[regtime]]', '[[regtime]]'),
(1, 18, 18, '[[regtime]]', '[[regtime]]'),
(1, 19, 19, '[[regtime]]', '[[regtime]]'),
(1, 38, 20, '[[regtime]]', '[[regtime]]'),
(1, 39, 21, '[[regtime]]', '[[regtime]]'),
(1, 41, 22, '[[regtime]]', '[[regtime]]'),
(1, 42, 23, '[[regtime]]', '[[regtime]]'),
(1, 43, 24, '[[regtime]]', '[[regtime]]'),
(1, 44, 25, '[[regtime]]', '[[regtime]]'),
(1, 45, 26, '[[regtime]]', '[[regtime]]'),
(1, 46, 27, '[[regtime]]', '[[regtime]]'),
(1, 50, 28, '[[regtime]]', '[[regtime]]'),
(1, 51, 29, '[[regtime]]', '[[regtime]]'),
(2, 3, 30, '[[regtime]]', '[[regtime]]'),
(3, 3, 31, '[[regtime]]', '[[regtime]]'),
(5, 40, 32, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_event_manager`
--

CREATE TABLE `core_event_manager` (
  `idEventMgr` int(11) NOT NULL AUTO_INCREMENT,
  `idClass` int(11) NOT NULL,
  `permission` enum('not_used','mandatory') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'not_used',
  `channel` set('email','sms') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'email',
  `recipients` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_level` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:simple_array)',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idEventMgr`),
  UNIQUE KEY `idClass` (`idClass`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=52 ;

--
-- Dumping data for table `core_event_manager`
--

INSERT INTO `core_event_manager` VALUES
(1, 1, 'mandatory', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(2, 2, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(3, 3, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(4, 4, 'not_used', 'email', '_EVENT_RECIPIENTS_MODERATORS_GOD', 'godadmin,admin', '[[regtime]]', '[[regtime]]'),
(5, 5, 'not_used', 'email', '_EVENT_RECIPIENTS_MODERATORS_GOD', 'godadmin,admin', '[[regtime]]', '[[regtime]]'),
(6, 6, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(7, 7, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(8, 8, 'not_used', 'email', '_EVENT_RECIPIENTS_MODERATORS_GOD', 'godadmin,admin', '[[regtime]]', '[[regtime]]'),
(9, 9, 'not_used', 'email', '_EVENT_RECIPIENTS_TEACHER', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(10, 10, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(11, 11, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(12, 12, 'mandatory', 'email', '_EVENT_RECIPIENTS_TEACHER', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(13, 13, 'not_used', 'email', '_EVENT_RECIPIENTS_TEACHER_GOD', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(14, 14, 'not_used', 'email', '_ALL', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(15, 15, 'not_used', 'email', '_ALL', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(16, 16, 'not_used', 'email', '_ALL', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(17, 17, 'not_used', 'email', '_ALL', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(18, 18, 'not_used', 'email', '_ALL', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(19, 19, 'not_used', 'email', '_EVENT_RECIPIENTS_MODERATORS_GOD', 'godadmin,admin', '[[regtime]]', '[[regtime]]'),
(38, 38, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(39, 39, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(41, 41, 'mandatory', 'email', '_EVENT_RECIPIENTS_MODERATORS_GOD', 'godadmin,admin', '[[regtime]]', '[[regtime]]'),
(42, 42, 'mandatory', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(43, 43, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(44, 44, 'not_used', 'email', '_EVENT_RECIPIENTS_TEACHER', 'admin', '[[regtime]]', '[[regtime]]'),
(45, 45, 'not_used', 'email', '_EVENT_RECIPIENTS_TEACHER_GOD', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]'),
(46, 46, 'not_used', 'email', '_EVENT_RECIPIENTS_MODERATORS_GOD', 'admin', '[[regtime]]', '[[regtime]]'),
(50, 50, 'mandatory', 'email', '_EVENT_RECIPIENTS_MODERATORS_GOD', 'admin', '[[regtime]]', '[[regtime]]'),
(51, 51, 'mandatory', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_event_property`
--

CREATE TABLE `core_event_property` (
  `idEvent` int(11) NOT NULL,
  `property_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `property_value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `property_date` date DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `property_name_idx` (`property_name`),
  KEY `id_event_idx` (`idEvent`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_event_user`
--

CREATE TABLE `core_event_user` (
  `idEventMgr` int(11) NOT NULL,
  `idst` int(11) NOT NULL,
  `channel` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:simple_array)',
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idst_idx` (`idst`),
  KEY `id_event_mgr_idx` (`idEventMgr`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_field`
--

CREATE TABLE `core_field` (
  `idField` int(11) NOT NULL AUTO_INCREMENT,
  `id_common` int(11) NOT NULL,
  `type_field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `show_on_platform` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'framework,',
  `use_multilang` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idField`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_field_son`
--

CREATE TABLE `core_field_son` (
  `idSon` int(11) NOT NULL AUTO_INCREMENT,
  `idField` int(11) NOT NULL,
  `id_common_son` int(11) NOT NULL,
  `lang_code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `selected` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idSon`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_field_type`
--

CREATE TABLE `core_field_type` (
  `type_field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_category` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'standard',
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_field_idx` (`type_field`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=10 ;

--
-- Dumping data for table `core_field_type`
--

INSERT INTO `core_field_type` VALUES
('codicefiscale', 'class.cf.php', 'Field_Cf', 'standard', 1, '[[regtime]]', '[[regtime]]'),
('country', 'class.country.php', 'Field_Country', 'standard', 2, '[[regtime]]', '[[regtime]]'),
('date', 'class.date.php', 'Field_Date', 'standard', 3, '[[regtime]]', '[[regtime]]'),
('dropdown', 'class.dropdown.php', 'Field_Dropdown', 'standard', 4, '[[regtime]]', '[[regtime]]'),
('freetext', 'class.freetext.php', 'Field_Freetext', 'standard', 5, '[[regtime]]', '[[regtime]]'),
('textfield', 'class.textfield.php', 'Field_Textfield', 'standard', 6, '[[regtime]]', '[[regtime]]'),
('textlabel', 'class.label.php', 'Field_Textlabel', 'standard', 7, '[[regtime]]', '[[regtime]]'),
('upload', 'class.upload.php', 'Field_Upload', 'standard', 8, '[[regtime]]', '[[regtime]]'),
('yesno', 'class.yesno.php', 'Field_Yesno', 'standard', 9, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_field_userentry`
--

CREATE TABLE `core_field_userentry` (
  `id_common` int(11) NOT NULL,
  `id_common_son` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `user_entry` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_common_idx` (`id_common`),
  KEY `id_common_son_idx` (`id_common_son`),
  KEY `id_user_idx` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_fncrole`
--

CREATE TABLE `core_fncrole` (
  `id_fncrole` int(10) unsigned NOT NULL,
  `id_group` int(10) unsigned NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_fncrole_idx` (`id_fncrole`),
  KEY `id_group_idx` (`id_group`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_fncrole_competence`
--

CREATE TABLE `core_fncrole_competence` (
  `id_fncrole` int(10) unsigned NOT NULL,
  `id_competence` int(10) unsigned NOT NULL,
  `score` int(10) unsigned NOT NULL,
  `expiration` int(10) unsigned NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_fncrole_idx` (`id_fncrole`),
  KEY `id_competence_idx` (`id_competence`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_fncrole_group`
--

CREATE TABLE `core_fncrole_group` (
  `id_group` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_group`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_fncrole_group_lang`
--	

CREATE TABLE `core_fncrole_group_lang` (
  `id_group` int(10) unsigned NOT NULL,
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_fncrole_lang`
--

CREATE TABLE `core_fncrole_lang` (
  `id_fncrole` int(10) unsigned NOT NULL,
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_fncrole_idx` (`id_fncrole`),
  KEY `lang_code_idx` (`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_group`
--

CREATE TABLE `core_group` (
  `idst` int(11) NOT NULL,
  `groupid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `hidden` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'false',
  `type` enum('free','moderate','private','invisible','course','company') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'free',
  `show_on_platform` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `groupid` (`groupid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=13 ;

--
-- Dumping data for table `core_group`
--

INSERT INTO `core_group` VALUES
(4, '/framework/level/admin', 'Group of administrators', 'true', 'free', '', 1, '[[regtime]]', '[[regtime]]'),
(3, '/framework/level/godadmin', 'Group of godadmins', 'true', 'free', '', 2, '[[regtime]]', '[[regtime]]'),
(6, '/framework/level/user', 'Group of normal users', 'true', 'free', '', 3, '[[regtime]]', '[[regtime]]'),
(307, '/lms/custom/1/1', 'for custom lms menu', 'true', 'free', '', 4, '[[regtime]]', '[[regtime]]'),
(306, '/lms/custom/1/2', 'for custom lms menu', 'true', 'free', '', 5, '[[regtime]]', '[[regtime]]'),
(305, '/lms/custom/1/3', 'for custom lms menu', 'true', 'free', '', 6, '[[regtime]]', '[[regtime]]'),
(304, '/lms/custom/1/4', 'for custom lms menu', 'true', 'free', '', 7, '[[regtime]]', '[[regtime]]'),
(303, '/lms/custom/1/5', 'for custom lms menu', 'true', 'free', '', 8, '[[regtime]]', '[[regtime]]'),
(302, '/lms/custom/1/6', 'for custom lms menu', 'true', 'free', '', 9, '[[regtime]]', '[[regtime]]'),
(301, '/lms/custom/1/7', 'for custom lms menu', 'true', 'free', '', 10, '[[regtime]]', '[[regtime]]'),
(1, '/oc_0', 'Root of organization chart', 'true', 'free', '', 11, '[[regtime]]', '[[regtime]]'),
(2, '/ocd_0', 'Root of organization chart and descendants', 'true', 'free', '', 12, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_group_fields`
--

CREATE TABLE `core_group_fields` (
  `idst` int(11) NOT NULL,
  `id_field` int(11) NOT NULL,
  `mandatory` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'false',
  `useraccess` enum('noaccess','readonly','readwrite') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'readonly',
  `user_inherit` tinyint(1) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idst_idx` (`idst`),
  KEY `id_field_idx` (`id_field`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_group_members`
--

CREATE TABLE `core_group_members` (
  `idst` int(11) NOT NULL,
  `idstMember` int(11) NOT NULL,
  `filter` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_relation_idx` (`idst`,`idstMember`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `core_group_members`
--

INSERT INTO `core_group_members` VALUES
(1, 11840, '', 1, '[[regtime]]', '[[regtime]]'),
(3, 11840, '', 2, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_group_user_waiting`
--

CREATE TABLE `core_group_user_waiting` (
  `idst_group` int(11) NOT NULL,
  `idst_user` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idst_group_idx` (`idst_group`),
  KEY `idst_user_idx` (`idst_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_hteditor`
--

CREATE TABLE `core_hteditor` (
  `hteditor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hteditorname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `hteditor_idx` (`hteditor`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `core_hteditor`
--

INSERT INTO `core_hteditor` VALUES
('textarea', '_TEXTAREA', 1, '[[regtime]]', '[[regtime]]'),
('tinymce', '_TINYMCE', 2, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_lang_language`
--

CREATE TABLE `core_lang_language` (
  `lang_code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_browsercode` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_direction` enum('ltr','rtl') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ltr',
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `lang_code_idx` (`lang_code`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `core_lang_language`
--

INSERT INTO `core_lang_language` VALUES
('english', 'English', 'en', 'ltr', 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_lang_text`
--

CREATE TABLE `core_lang_text` (
  `id_text` int(11) NOT NULL AUTO_INCREMENT,
  `text_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text_module` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text_attributes` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:simple_array)',
  `plugin_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_text`),
  UNIQUE KEY `text_key` (`text_key`,`text_module`,`plugin_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3088 ;

--
-- Dumping data for table `core_lang_text`
--

INSERT INTO `core_lang_text` VALUES
(1, '_DASHBOARD', 'middlearea', '', 0, '[[regtime]]', '[[regtime]]'),
(2, '_NEW_USER_SUBSCRIBED_TEXT_MODERATORS', '', '', 0, '[[regtime]]', '[[regtime]]'),
(3, '_ADMIN_ASSIGNTREEDESCR', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(4, '_ADMIN_MANAGMENT', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(5, '_ADMIN_MANAGMENT_CAPTION', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(6, '_ADMIN_MANAGMENT_SUMMARY', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(7, '_ADMIN_MENU', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(8, '_ADMIN_PREFERENCES_TITLE', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(9, '_ADMIN_RULES', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(10, '_ADMIN_SPECIAL_SETTING', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(11, '_DIRECT_COURSE_SUBSCRIBE', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(12, '_DIRECT_USER_INSERT', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(13, '_LANG_SETTING', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(14, '_LIMIT_COURSE_SUBSCRIBE', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(15, '_LIMIT_USER_INSERT', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(16, '_MANAGE_SUBSCRIPTION', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(17, '_MAX_COURSE_SUBSCRIBE', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(18, '_MAX_USER_INSERT', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(19, '_SELECT_LANG_TO_ASSIGN', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(20, '_SPECIAL_SETTING', 'adminrules', '', 0, '[[regtime]]', '[[regtime]]'),
(21, '_PAPER_TEST', 'admin_date', '', 0, '[[regtime]]', '[[regtime]]'),
(22, '_WEB_TEST', 'admin_date', '', 0, '[[regtime]]', '[[regtime]]'),
(23, '_ACCEPT', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(24, '_APPROVED_USER_SBJ', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(25, '_ASSIGNED_EXTRAFIELD', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(26, '_DECLINE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(27, '_DIRECOTRY_SELFREGISTERED', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(28, '_DIRECTORY_/framework/level/admin', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(29, '_DIRECTORY_/framework/level/godadmin', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(30, '_DIRECTORY_/framework/level/publicadmin', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(31, '_DIRECTORY_/framework/level/user', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(32, '_DIRECTORY_ASSIGNFIELDGROUP', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(33, '_DIRECTORY_FILTER_email', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(34, '_DIRECTORY_FILTER_firstname', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(35, '_DIRECTORY_FILTER_FLATMODE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(36, '_DIRECTORY_FILTER_language', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(37, '_DIRECTORY_FILTER_lastname', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(38, '_DIRECTORY_FILTER_pass', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(39, '_DIRECTORY_FILTER_register_date', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(40, '_DIRECTORY_FILTER_templatename', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(41, '_DIRECTORY_FILTER_userid', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(42, '_DIRECTORY_FULLNAME', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(43, '_DIRECTORY_GROUPID', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(44, '_DIRECTORY_GROUPTYPE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(45, '_DIRECTORY_GROUPTYPE_FREE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(46, '_DIRECTORY_GROUPTYPE_INVISIBLE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(47, '_DIRECTORY_GROUPTYPE_INVISIBLE_ALT', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(48, '_DIRECTORY_GROUPTYPE_MODERATE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(49, '_DIRECTORY_GROUPTYPE_MODERATE_ALT', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(50, '_DIRECTORY_GROUPTYPE_PRIVATE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(51, '_DIRECTORY_GROUPTYPE_PRIVATE_ALT', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(52, '_DIRECTORY_GROUPWAIT_ACCORDECLINE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(53, '_DIRECTORY_GROUP_FIELD_WRITE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(54, '_DIRECTORY_ITEMID', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(55, '_DIRECTORY_MEMBERTYPE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(56, '_DIRECTORY_MEMBERTYPETREE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(57, '_DIRECTORY_MEMBERTYPEUSER', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(58, '_DIRECTORY_ORGVIEWTITLE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(59, '_FORCE_PASSWORD_CHANGE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(60, '_GROUP_FIELD_NORMAL', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(61, '_GROUP_USER_IMPORT_CHARSET', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(62, '_GROUP_USER_IMPORT_FILE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(63, '_GROUP_USER_IMPORT_HEADER', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(64, '_GROUP_USER_IMPORT_SEPARATOR', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(65, '_LASTNAME_FIRSTNAME', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(66, '_REFUSED_USER_TEXT_SMS', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(67, '_REFUSE_USER', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(68, '_REFUSE_USER_TITLE', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(69, '_SIMPLE_FILTER', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(70, '_WAITING_USER_SUMMARY', 'admin_directory', '', 0, '[[regtime]]', '[[regtime]]'),
(71, '_BLANKLANG_CODE', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(72, '_CLEAN_LANG', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(73, '_CLEAR', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(74, '_DIRECTION_LTR', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(75, '_DIRECTION_RTL', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(76, '_DO_NOT_ADD_MISS', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(77, '_EXPORTG', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(78, '_EXPORT_DIFF', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(79, '_LANG_ACCESSIBILITY', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(80, '_LANG_ADDKEY', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(81, '_LANG_ALL', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(82, '_LANG_ALLMODULES', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(83, '_LANG_ATTRIBUTES', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(84, '_LANG_BROWSERCODE', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(85, '_LANG_CHARSET', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(86, '_LANG_CODE', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(87, '_LANG_COMPARE', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(88, '_LANG_DIRECTION', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(89, '_LANG_KEY', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(90, '_LANG_MODULE', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(91, '_LANG_NEWMODULE', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(92, '_LANG_TRANSLATION', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(93, '_LANG_TRAN_COMPARE', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(94, '_MODULES_UPDATED', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(95, '_NOIMPORT', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(96, '_NUM_TRAD', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(97, '_ONLY_EMPTY', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(98, '_ORIENTATION', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(99, '_OVERWRITE_EXISTENT', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(100, '_PERC_TRAD', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(101, '_PLUGIN', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(102, '_PLUGIN_NAME', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(103, '_TOTAL_LANGUAGE_UPDATED', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(104, '_TRANSALTIONTABLEFOR', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(105, '_TRANSLATELANG', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(106, '_TRANSLATELANGG', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(107, '_TRANSLATION_COTAINS', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(108, '_YESIMPORT', 'admin_lang', '', 0, '[[regtime]]', '[[regtime]]'),
(109, '_CHOOSE_WHO_CAN_SEE', 'admin_news', '', 0, '[[regtime]]', '[[regtime]]'),
(110, '_LONG_DESCR', 'admin_news', '', 0, '[[regtime]]', '[[regtime]]'),
(111, '_NEWSINHOMEPAGE', 'admin_news', '', 0, '[[regtime]]', '[[regtime]]'),
(112, '_NEWS_SUMMARY', 'admin_news', '', 0, '[[regtime]]', '[[regtime]]'),
(113, '_TITLE_IMPORTANT', 'admin_news', '', 0, '[[regtime]]', '[[regtime]]'),
(114, '_ANY', 'admin_newsletter', '', 0, '[[regtime]]', '[[regtime]]'),
(115, '_NEWSLETTER_WILL_BE_SENT_TO', 'admin_newsletter', '', 0, '[[regtime]]', '[[regtime]]'),
(116, '_SEC_OF_PAUSE', 'admin_newsletter', '', 0, '[[regtime]]', '[[regtime]]'),
(117, '_SEND_SMS', 'admin_newsletter', '', 0, '[[regtime]]', '[[regtime]]'),
(118, '_ADD_WEBPAGES', 'admin_webpages', '', 0, '[[regtime]]', '[[regtime]]'),
(119, '_ALT_HOME', 'admin_webpages', '', 0, '[[regtime]]', '[[regtime]]'),
(120, '_TITLE_HOME', 'admin_webpages', '', 0, '[[regtime]]', '[[regtime]]'),
(121, '_TITLE_WEBPAGES', 'admin_webpages', '', 0, '[[regtime]]', '[[regtime]]'),
(122, '_WEBPAGES_CAPTION', 'admin_webpages', '', 0, '[[regtime]]', '[[regtime]]'),
(123, '_ADD_ADVICE', 'advice', '', 0, '[[regtime]]', '[[regtime]]'),
(124, '_ADVICE', 'advice', '', 0, '[[regtime]]', '[[regtime]]'),
(125, '_ALT_ARCHIVE', 'advice', '', 0, '[[regtime]]', '[[regtime]]'),
(126, '_ARCHIVE_THIS_ADVICE', 'advice', '', 0, '[[regtime]]', '[[regtime]]'),
(127, '_CHOOSE_READER', 'advice', '', 0, '[[regtime]]', '[[regtime]]'),
(128, '_MANUAL_USER_SEL', 'advice', '', 0, '[[regtime]]', '[[regtime]]'),
(129, '_YOUONLY', 'advice', '', 0, '[[regtime]]', '[[regtime]]'),
(130, '_APR', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(131, '_APRIL', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(132, '_AUG', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(133, '_AUGUST', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(134, '_CAL_TITLE', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(135, '_DAY_FIRST', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(136, '_DEC', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(137, '_DECEMBER', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(138, '_DEF_DATE_FORMAT', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(139, '_FEB', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(140, '_FEBRUARY', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(141, '_FRI', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(142, '_FRIDAY', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(143, '_GENERIC', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(144, '_GO_TODAY', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(145, '_JAN', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(146, '_JANUARY', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(147, '_JUL', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(148, '_JULY', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(149, '_JUN', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(150, '_JUNE', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(151, '_MAR', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(152, '_MARCH', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(153, '_MAY', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(154, '_MEETING', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(155, '_MON', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(156, '_MONDAY', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(157, '_NEXT_MONTH', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(158, '_NEXT_YEAR', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(159, '_NOV', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(160, '_NOVEMBER', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(161, '_OCT', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(162, '_OCTOBER', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(163, '_PART_TODAY', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(164, '_PLS_WAIT', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(165, '_PREV_MONTH', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(166, '_PREV_YEAR', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(167, '_PRIVATE', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(168, '_PUBLIC', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(169, '_PUBLISHING', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(170, '_SAT', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(171, '_SATURDAY', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(172, '_SEP', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(173, '_SEPTEMBER', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(174, '_SUN', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(175, '_SUNDAY', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(176, '_THU', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(177, '_THURSDAY', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(178, '_TIME', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(179, '_TODAY', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(180, '_TT_DATE_FORMAT', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(181, '_TUE', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(182, '_TUESDAY', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(183, '_WED', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(184, '_WEDNESDAY', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(185, '_WEEKEND', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(186, '_WK', 'calendar', '', 0, '[[regtime]]', '[[regtime]]'),
(187, '_CART', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(188, '_CLASSROOM_COURSE', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(189, '_CODE', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(190, '_COURSE_PRIZE', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(191, '_COURSE_TYPE', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(192, '_DATE_BEGIN', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(193, '_DATE_END', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(194, '_DEL_SELECTED_ELEMENT', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(195, '_EMPTY_CART', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(196, '_LEARNING_COURSE', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(197, '_NAME', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(198, '_ORDER_NOW', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(199, '_ORDER_NUMBER', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(200, '_PAYMENT_SELECT', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(201, '_PAY_WITH_PAYPAL', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(202, '_TOTAL', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(203, '_TRANS_CREATED', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(204, '_WIRE_INFO', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(205, '_WIRE_PAYMENT', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(206, '_WIRE_PAYMENT_DETAILS', 'cart', '', 0, '[[regtime]]', '[[regtime]]'),
(207, '_ADD_TO_CART', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(208, '_ALL_EDITION_BUYED', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(209, '_CALENDAR', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(210, '_CAREER', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(211, '_CATALOGUE_SELECTION', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(212, '_CATALOGUE_SUMMARY', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(213, '_CERT_RELESABLE', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(214, '_CLASSROOM_IN_CART', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(215, '_CLASSROOM_LOCATION', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(216, '_CONFIRM_ADD_TO_CART', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(217, '_CONFIRM_SUBSCRIPTION', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(218, '_COURSEPATH_INTRO', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(219, '_COURSEPATH_LIST', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(220, '_COURSEPATH_SUBSCRIBE_WIN_TIT', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(221, '_COURSEPATH_SUBSCRIBE_WIN_TXT', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(222, '_COURSE_ADDED_IN_CART', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(223, '_COURSE_AS', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(224, '_COURSE_BEGIN', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(225, '_COURSE_END', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(226, '_COURSE_EXPIRING', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(227, '_COURSE_IN_CART', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(228, '_COURSE_LIST_SUMMARY', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(229, '_COURSE_SUBSCRIPTION', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(230, '_COURSE_S_GODADMIN', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(231, '_COURSE_S_MODERATE', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(232, '_COURSE_TYPE', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(233, '_COURSE_YOU_CAN_ACCESS', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(234, '_ELEARNING', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(235, '_ENTRY_CAPTION', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(236, '_ENTRY_SUMMARY', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(237, '_FILTER_DATE_BEGIN', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(238, '_FILTER_FOR_COURSE_TYPE', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(239, '_FILTER_FOR_SALE', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(240, '_IMPORT_NEW_ENTRY', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(241, '_METHOD_MANUAL', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(242, '_MOD_ENTRY_CATALOGUE', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(243, '_NEW_CATALOGUE', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(244, '_NO_AVAILABLE_EDITIONS', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(245, '_NO_CATEGORY_TODISPLAY', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(246, '_NO_COURSE', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(247, '_NO_COURSE_FOUND', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(248, '_NO_EDITIONS', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(249, '_NO_PERIODS', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(250, '_PREASSESSMENT_SUGGESTION', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(251, '_REMOVE_ENTRY', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(252, '_RESERVE_COURSE', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(253, '_SHOPPING_CART', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(254, '_SHOW_EDITIONS', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(255, '_SUBSCRIBE_COURSE_T', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(256, '_TAB_VIEW_CATEGORY', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(257, '_TAB_VIEW_MOSTPOPULAR', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(258, '_TAB_VIEW_RECENT', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(259, '_TIT_SUBSCRIPTION_BY_CODE', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(260, '_TOTAL_COURSE', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(261, '_TXT_SUBSCRIPTION_BY_CODE', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(262, '_USER_STATUS_ENTER', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(263, '_WAITING_APPROVAL', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(264, '_WORD_TO_SEARCH', 'catalogue', '', 0, '[[regtime]]', '[[regtime]]'),
(265, '_ALT_REM_META_CERT', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(266, '_ALT_TAKE_A_COPY', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(267, '_BACK_IMAGE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(268, '_BASE_LANGUAGE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(269, '_CERTIFICATES_GENERATION', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(270, '_CERTIFICATE_AGGREGATE_ASSOCIATION', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(271, '_CERTIFICATE_ASSIGN', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(272, '_CERTIFICATE_CAPTION', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(273, '_CERTIFICATE_LIST', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(274, '_CERTIFICATE_REPORT', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(275, '_CERTIFICATE_SUMMARY', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(276, '_CERTIFICATE_VIEW_CAPTION', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(277, '_CERTIFICATE_WARNING', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(278, '_CHOOSE_CERTIFICATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(279, '_CHOOSE_COURSE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(280, '_COURSE_BEGIN', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(281, '_COURSE_DESCRIPTION', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(282, '_COURSE_END', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(283, '_COURSE_SCORE_FINAL_MAX', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(284, '_COURSE_TODAY', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(285, '_COURSE_YEAR', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(286, '_DATE_COMPLETE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(287, '_DATE_ENROLL', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(288, '_DISPLAY_NAME', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(289, '_EX_CERT_POINT_REQUIRED', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(290, '_GENERATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(291, '_GENERATE_ALL_SELECTED', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(292, '_LANDSCAPE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(293, '_META_CERTIFICATE_ASSIGN_CAPTION', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(294, '_META_CERTIFICATE_CAPTION', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(295, '_META_CERTIFICATE_CREATE_CAPTION', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(296, '_META_CERTIFICATE_DETAILS_CAPTION', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(297, '_META_CERTIFICATE_NEW_ASSIGN_CAPTION', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(298, '_META_CERTIFICATE_NEW_ASSIGN_SUMMARY', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(299, '_META_CERTIFICATE_PROGRESS', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(300, '_META_CERTIFICATE_SUMMARY', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(301, '_MY_CERTIFICATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(302, '_NEW_ASSING_META_CERTIFICATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(303, '_NEW_CERTIFICATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(304, '_NOT_ENDED', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(305, '_NO_CERT_AVAILABLE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(306, '_NO_USER_FOR_CERTIFICATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(307, '_NO_USER_FOUND', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(308, '_NUMBER_OF_CERTIFICATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(309, '_ORIENTATION', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(310, '_PORTRAIT', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(311, '_RELASE_DATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(312, '_RELEASED', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(313, '_SCORM_SCORE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(314, '_SCORM_TITLE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(315, '_STOP', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(316, '_STRUCTURE_CERTIFICATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(317, '_STRUCTURE_META_CERTIFICATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(318, '_TABLE_COURSE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(319, '_TAG_CODE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(320, '_TAG_DESCRIPTION', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(321, '_TAG_LIST_CAPTION', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(322, '_TAG_LIST_SUMMARY', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(323, '_TAKE_A_COPY', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(324, '_TEMPLATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(325, '_TEST_SCORE_FINAL', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(326, '_TEST_SCORE_FINAL_MAX', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(327, '_TEST_SCORE_START', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(328, '_TEST_SCORE_START_MAX', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(329, '_TITLE_ASSIGN_META_CERTIFICATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(330, '_TITLE_CERTIFICATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(331, '_TITLE_CREATE_META_CERTIFICATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(332, '_TITLE_META_CERTIFICATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(333, '_TITLE_META_CERTIFICATE_ASSIGN', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(334, '_TITLE_META_CERTIFICATE_CREATE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(335, '_TITLE_META_CERTIFICATE_DELETING', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(336, '_TITLE_VIEW_CERT', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(337, '_TOTAL_TIME', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(338, '_TOTAL_TIME_HOUR', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(339, '_TOTAL_TIME_MINUTE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(340, '_TOTAL_TIME_SECOND', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(341, '_TO_RELEASE', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(342, '_USER_FOR_META_CERTIFICATE_ASSIGN', 'certificate', '', 0, '[[regtime]]', '[[regtime]]'),
(343, '_CHAT_DESCRIPTION', 'chat', '', 0, '[[regtime]]', '[[regtime]]'),
(344, '_OPENCHAT', 'chat', '', 0, '[[regtime]]', '[[regtime]]'),
(345, '_OPENCHAT_WA', 'chat', '', 0, '[[regtime]]', '[[regtime]]'),
(346, '_AVAILABLE_INSTRUMENT', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(347, '_BUILDING_ROOM', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(348, '_CAPACITY', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(349, '_CITY', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(350, '_CLASSROOM', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(351, '_CLASSROOM_CAPTION', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(352, '_DEL_CLASSROOM', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(353, '_DISPOSITION', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(354, '_FAX', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(355, '_INSTRUMENT', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(356, '_LOCATION_INFO', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(357, '_MOD_CLASSROOM', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(358, '_NEW_CLASSROOM', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(359, '_PHONE', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(360, '_PHOTO', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(361, '_RESERVATION_INFO_LOCATION', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(362, '_RESPONSABLE', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(363, '_STATE', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(364, '_STREET', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(365, '_ZIP_CODE', 'classroom', '', 0, '[[regtime]]', '[[regtime]]'),
(366, '_CODE_LIST', 'code', '', 0, '[[regtime]]', '[[regtime]]'),
(367, '_CODE_USED_NUMBER', 'code', '', 0, '[[regtime]]', '[[regtime]]'),
(368, '_UNLIMITED_USE', 'code', '', 0, '[[regtime]]', '[[regtime]]'),
(369, '_USED', 'code', '', 0, '[[regtime]]', '[[regtime]]'),
(370, '_ADD_COMPETENCE', 'competences', '', 0, '[[regtime]]', '[[regtime]]'),
(371, '_ASSIGN_USER_TITLE', 'competences', '', 0, '[[regtime]]', '[[regtime]]'),
(372, '_COMPETENCES_REQUIRED', 'competences', '', 0, '[[regtime]]', '[[regtime]]'),
(373, '_COMPETENCES_TYPOLOGY_ATTITUDE', 'competences', '', 0, '[[regtime]]', '[[regtime]]'),
(374, '_COMPETENCES_TYPOLOGY_KNOWLEDGE', 'competences', '', 0, '[[regtime]]', '[[regtime]]'),
(375, '_COMPETENCES_TYPOLOGY_SKILL', 'competences', '', 0, '[[regtime]]', '[[regtime]]'),
(376, '_COMPETENCES_USER_TAB_CAPTION', 'competences', '', 0, '[[regtime]]', '[[regtime]]'),
(377, '_COMPETENCE_OBTAINED', 'competences', '', 0, '[[regtime]]', '[[regtime]]'),
(378, '_DATE_OBTAINED', 'competences', '', 0, '[[regtime]]', '[[regtime]]'),
(379, '_EXPIRATION_DAYS', 'competences', '', 0, '[[regtime]]', '[[regtime]]'),
(380, '_TYPE_FLAG', 'competences', '', 0, '[[regtime]]', '[[regtime]]'),
(381, '_WITH_COURSE_ASSOCIATIONS', 'competences', '', 0, '[[regtime]]', '[[regtime]]'),
(382, '_WITH_FNCROLE_ASSOCIATIONS', 'competences', '', 0, '[[regtime]]', '[[regtime]]'),
(383, '_WITH_USER_ASSOCIATIONS', 'competences', '', 0, '[[regtime]]', '[[regtime]]'),
(384, '_AT_HOUR', 'conference', '', 0, '[[regtime]]', '[[regtime]]'),
(385, '_CONFERENCE_NAME', 'conference', '', 0, '[[regtime]]', '[[regtime]]'),
(386, '_CONFERENCE_SYSTEM', 'conference', '', 0, '[[regtime]]', '[[regtime]]'),
(387, '_MAX_PARTICIPANTS', 'conference', '', 0, '[[regtime]]', '[[regtime]]'),
(388, '_MEETING_HOURS', 'conference', '', 0, '[[regtime]]', '[[regtime]]'),
(389, '_NO_MORE_ROOM', 'conference', '', 0, '[[regtime]]', '[[regtime]]'),
(390, '_NO_ROOM_AVAILABLE', 'conference', '', 0, '[[regtime]]', '[[regtime]]'),
(391, '_ROOMS_AVAILABLE', 'conference', '', 0, '[[regtime]]', '[[regtime]]'),
(392, '_SUMMARY_ROOM_AVAILABLE', 'conference', '', 0, '[[regtime]]', '[[regtime]]'),
(393, 'MAIN_SET_1', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(394, 'MAIN_SET_11', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(395, 'MAIN_SET_3', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(396, 'MAIN_SET_4', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(397, 'MAIN_SET_6', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(398, 'MAIN_SET_8', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(399, 'MAIN_SET_9', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(400, 'PASSWORD_BCRYPT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(401, 'PASSWORD_MD5', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(402, '_ACCESSIBILITY', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(403, '_ALLOW_URL_FOPEN', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(404, '_ALLOW_URL_INCLUDE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(405, '_ALREADY_ASSIGNED', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(406, '_API', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(407, '_API_SSO', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(408, '_ASK_FOR_CODE_MODULE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(409, '_ASK_FOR_DROPDOWN_TREE_CODE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(410, '_ASK_FOR_MANUAL_TREE_CODE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(411, '_ASK_FOR_TREE_COURSE_CODE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(412, '_BBB_MAX_MIKES', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(413, '_BBB_MAX_PARTICIPANT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(414, '_BBB_MAX_ROOM', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(415, '_BBB_PASSWORD_MODERATOR', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(416, '_BBB_PASSWORD_VIEWER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(417, '_BBB_PORT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(418, '_BBB_SALT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(419, '_BBB_SERVER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(420, '_BBB_USER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(421, '_CLEAR_TWIG_CACHE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(422, '_CODE_TELESKILL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(423, '_COMMON_ADMIN_SESSION', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(424, '_CONFERENCE_CREATION_LIMIT_PER_USER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(425, '_CONFIGURATION', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(426, '_CONFIRM_REGISTER_TYPE_SELF', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(427, '_CONF_GLOBAL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(428, '_CONF_LMS', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(429, '_COURSE_BLOCK', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(430, '_COURSE_QUOTA', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(431, '_CURRENCY_SYMBOL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(432, '_CUSTOMER_HELP_EMAIL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(433, '_CUSTOMER_HELP_NAME_FROM', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(434, '_CUSTOMER_HELP_SUBJ_PFX', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(435, '_CUSTOMER_HELP_SUBJ_PLACEHOLDER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(436, '_CUSTOM_FIELDS_MANDATORY_FOR_ADMIN', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(437, '_DEBUG', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(438, '_DEFAULTTEMPLATE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(439, '_DIMDIM_MAX_MIKES', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(440, '_DIMDIM_MAX_PARTICIPANT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(441, '_DIMDIM_MAX_ROOM', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(442, '_DIMDIM_PASSWORD', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(443, '_DIMDIM_PORT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(444, '_DIMDIM_SERVER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(445, '_DIMDIM_USER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(446, '_DOMXML', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(447, '_DONT_SHOW', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(448, '_DO_DEBUG', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(449, '_ECOMMERCE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(450, '_EMAIL_SETTINGS', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(451, '_FILE_UPLOAD_WHITELIST', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(452, '_FIRST_CATALOGUE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(453, '_FORUM_AS_TABLE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(454, '_FTPERR', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(455, '_FTPOK', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(456, '_GOOGLE_STAT_CODE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(457, '_GOOGLE_STAT_IN_LMS', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(458, '_HELPDESK_SUBJ', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(459, '_HELPDESK_SUBJ_PLACEHOLDER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(460, '_HIDE_EMPTY_CATEGORY', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(461, '_HOME_PAGE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(462, '_HOUR_REQUEST_LIMIT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(463, '_HTEDITOR', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(464, '_HTMLEDIT_IMAGE_ADMIN', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(465, '_HTMLEDIT_IMAGE_GODADMIN', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(466, '_HTMLEDIT_IMAGE_USER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(467, '_IGNORE_SCORE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(468, '_IMPORT_UCFIRST', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(469, '_KB_FILTER_BY_USER_ACCESS', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(470, '_KB_SHOW_UNCATEGORIZED', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(471, '_LANG_CHECK', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(472, '_LANG_EXPORT_TIME', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(473, '_LASTFIRST_MANDATORY', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(474, '_LDAP', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(475, '_LDAP_PORT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(476, '_LDAP_SERVER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(477, '_LDAP_USED', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(478, '_LDAP_USER_STRING', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(479, '_LIST_DB_UPGRADES', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(480, '_MAGIC_QUOTES_GPC', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(481, '_MAIL_SENDER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(482, '_MAIL_SENDER_NAME_FROM', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(483, '_MAINTENANCE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(484, '_MAINTENANCE_PW', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(485, '_MAIN_OPTIONS', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(486, '_MANDATORY_CODE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(487, '_MAX_EXECUTION_TIME', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(488, '_MAX_LOG_ATTEMPT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(489, '_MYSQL_COLLATION', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(490, '_MYSQL_ENCODING', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(491, '_MYSQL_MODE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(492, '_MYSQL_TIMEZONE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(493, '_MYSQL_VERS', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(494, '_MY_COURSES', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(495, '_NL_SENDPAUSE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(496, '_NL_SENDPERCYCLE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(497, '_NOTSCORM', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(498, '_NO_ANSWER_IN_POLL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(499, '_NO_ANSWER_IN_TEST', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(500, '_ON_CATALOGUE_EMPTY', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(501, '_ON_PATH_IN_MYCOURSES', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(502, '_ON_USERCOURSE_EMPTY', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(503, '_OPENSSL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(504, '_ORGCHART_SINGLENODE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(505, '_ORG_NAME_TELESKILL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(506, '_OWNED_BY', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(507, '_PAGE_TITLE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(508, '_PASS_ALFANUMERIC', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(509, '_PASS_ALGORITHM', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(510, '_PASS_CHANGE_FIRST_LOGIN', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(511, '_PASS_MAX_TIME_VALID', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(512, '_PASS_MIN_CHAR', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(513, '_PATH', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(514, '_PATHCHAT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(515, '_PATHCOURSE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(516, '_PATHFIELD', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(517, '_PATHFORUM', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(518, '_PATHLESSON', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(519, '_PATHMESSAGE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(520, '_PATHPHOTO', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(521, '_PATHPRJ', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(522, '_PATHSCORM', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(523, '_PATHSPONSOR', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(524, '_PATHTEST', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(525, '_PAYPAL_CURRENCY', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(526, '_PAYPAL_MAIL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(527, '_PAYPAL_SANDBOX', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(528, '_PHPINFO', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(529, '_PHPVERSION', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(530, '_PHP_TIMEZONE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(531, '_PLUGIN_ACTIVATE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(532, '_PLUGIN_AUTHOR', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(533, '_PLUGIN_CATEGORY', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(534, '_PLUGIN_DEACTIVATE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(535, '_PLUGIN_DESCRIPTION', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(536, '_PLUGIN_ERROR_CORE_DEACTIVATE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(537, '_PLUGIN_ERROR_CORE_UNINSTALL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(538, '_PLUGIN_ERROR_DEACTIVATE_DEPENDENCE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(539, '_PLUGIN_ERROR_NOT_ONLINE_UPDATE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(540, '_PLUGIN_ERROR_NO_DEPENDENCIES', 'configuration', '', 0, '[[regtime]]', '[[regtime]]');
INSERT INTO `core_lang_text` VALUES
(541, '_PLUGIN_ERROR_OLD_VERSION', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(542, '_PLUGIN_ERROR_UNINSTALL_DEPENDENCE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(543, '_PLUGIN_INSTALL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(544, '_PLUGIN_NAME', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(545, '_PLUGIN_SETTINGS', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(546, '_PLUGIN_UNINSTALL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(547, '_PLUGIN_UNINSTALL_CONFIRMATION', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(548, '_PLUGIN_UPDATE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(549, '_PLUGIN_VERSION', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(550, '_POST_MAX_SIZE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(551, '_PRIVACY_POLICY', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(552, '_PROFILE_ONLY_PWD', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(553, '_REGISTER_DELETED_USER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(554, '_REGISTER_GLOBAL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(555, '_REGISTER_TYPE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(556, '_REGISTER_TYPE_ADMIN', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(557, '_REGISTER_TYPE_MODERATE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(558, '_REGISTER_TYPE_SELF', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(559, '_REGISTER_TYPE_SELF_OPTIN', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(560, '_REGISTRATION_CODE_TYPE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(561, '_REPORT_MAX_EMAIL_SIZE_MB', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(562, '_REPORT_PERSISTENCE_DAYS', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(563, '_REPORT_STORAGE_FOLDER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(564, '_REQUEST_MANDATORY_FIELDS_COMPILATION', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(565, '_REST_AUTH_API_KEY', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(566, '_REST_AUTH_API_SECRET', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(567, '_REST_AUTH_CODE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(568, '_REST_AUTH_LIFETIME', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(569, '_REST_AUTH_METHOD', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(570, '_REST_AUTH_SECRET_KEY', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(571, '_REST_AUTH_TOKEN', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(572, '_REST_AUTH_UPDATE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(573, '_SAFEMODE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(574, '_SAVE_LA_AFTER_MAX', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(575, '_SAVE_LA_ALL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(576, '_SAVE_LOG_ATTEMPT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(577, '_SCO_DIRECT_PLAY', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(578, '_SECURITY', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(579, '_SENDER_EVENT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(580, '_SEND_CCN_FOR_SYSTEM_EMAILS', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(581, '_SEND_CC_FOR_SYSTEM_EMAILS', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(582, '_SERVERINFO', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(583, '_SERVER_ADDR', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(584, '_SERVER_ADMIN', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(585, '_SERVER_MYSQL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(586, '_SERVER_NAME', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(587, '_SERVER_PORT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(588, '_SERVER_SOFTWARE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(589, '_SESSION_IP_CONTROL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(590, '_SHOW_AS_BLOCK', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(591, '_SHOW_AS_LINK', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(592, '_SMS', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(593, '_SMSMARKET_LOGO', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(594, '_SMS_BUY_RECHARGE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(595, '_SMS_CELL_NUM_FIELD', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(596, '_SMS_CREDIT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(597, '_SMS_CREDIT_UPDATE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(598, '_SMS_GATEWAY_1', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(599, '_SMS_GATEWAY_2', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(600, '_SMS_GATEWAY_3', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(601, '_SMS_GATEWAY_4', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(602, '_SMS_GATEWAY_AUTO', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(603, '_SMS_GATEWAY_HOST', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(604, '_SMS_GATEWAY_ID', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(605, '_SMS_GATEWAY_PASS', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(606, '_SMS_GATEWAY_PORT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(607, '_SMS_GATEWAY_USER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(608, '_SMS_INTERNATIONAL_PREFIX', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(609, '_SMS_SENT_FROM', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(610, '_SOCIAL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(611, '_SOCIAL_FB_ACTIVE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(612, '_SOCIAL_FB_API', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(613, '_SOCIAL_FB_SECRET', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(614, '_SOCIAL_GOOGLE_ACTIVE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(615, '_SOCIAL_GOOGLE_CLIENT_ID', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(616, '_SOCIAL_GOOGLE_SECRET', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(617, '_SOCIAL_LINKEDIN_ACCESS', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(618, '_SOCIAL_LINKEDIN_ACTIVE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(619, '_SOCIAL_LINKEDIN_SECRET', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(620, '_SOCIAL_TWITTER_ACTIVE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(621, '_SOCIAL_TWITTER_CONSUMER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(622, '_SOCIAL_TWITTER_SECRET', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(623, '_SSO_SECRET', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(624, '_SSO_TOKEN', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(625, '_STOP_CONCURRENT_USER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(626, '_TABLIST_MYCOURSES', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(627, '_TELESKILL_MAX_PARTICIPANT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(628, '_TELESKILL_MAX_ROOM', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(629, '_TEMPLATEDOMAIN', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(630, '_TEMPLATE_DOMAIN', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(631, '_TRACKING', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(632, '_TTLSESSION', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(633, '_TWIG_CACHE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(634, '_UPLOADFTP', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(635, '_UPLOAD_MAX_FILESIZE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(636, '_URL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(637, '_URL_CHECKIN_TELESKILL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(638, '_URL_VIDEOCONFERENCE_TELESKILL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(639, '_USEFULL_ONLY_IF', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(640, '_USERS_ALREADY_ASSIGNED', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(641, '_USER_PWD_HISTORY_LENGTH', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(642, '_USER_QUOTA', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(643, '_USE_ADVANCED_FORM', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(644, '_USE_COURSE_LABEL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(645, '_USE_DIMDIM_API', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(646, '_USE_IMMEDIATE_REPORT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(647, '_USE_REST_API', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(648, '_USE_SENDER_ACLNAME', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(649, '_USE_TAG', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(650, '_WARINNG_SOCIAL', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(651, '_PURCHASE_USER', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(652, '_FORCE_SCORM_FINISH', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(653, '_EXCLUDE_COMPLETED_COURSES', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(654, '_PASS_SPECIAL_CHAR', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(655, '_PASS_MIN_UPPERCASE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(656, '_PASS_MIN_LOWERCASE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(657, '_PASS_MIN_DIGIT', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(658, '_PASS_SEND_REMIND', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(659, '_PASS_ADMIN_RULE', 'configuration', '', 0, '[[regtime]]', '[[regtime]]'),
(660, '_YEAR_SELECTION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(661, '_COURSE_TYPE_SELECTION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(662, '_ADDFILE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(663, '_ADDFILES', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(664, '_ADD_SUBSCRIBE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(665, '_ADVERT_ADVICE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(666, '_ADVERT_FORUM', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(667, '_ADVERT_LOBJ', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(668, '_ALLOW_OVERBOOKING', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(669, '_ALL_COURSE_TYPE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(670, '_ALL_OPEN', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(671, '_ALL_YEARS', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(672, '_ASSIGN_FOR_ALL_STATUS', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(673, '_ASSIGN_FOR_AT_LEAST_MINUTES', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(674, '_ASSIGN_FOR_STATUS_COMPLETED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(675, '_ASSIGN_FOR_STATUS_INCOURSE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(676, '_ASSIGN_MENU', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(677, '_AUTOREGISTRATION_CODE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(678, '_BACK_TO_ADMINISTRATION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(679, '_BUY_COURSE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(680, '_CALENDAR_CLASSROOM_EDITION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(681, '_CAN_SUBSCRIBE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(682, '_CASCADE_MOD_ON_EDITION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(683, '_CATEGORY_PATH', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(684, '_CATEGORY_SELECTED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(685, '_CERTIFICATE_ASSIGN_STATUS', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(686, '_CERTIFICATE_EX_ASSIGN_STATUS', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(687, '_CERTIFICATE_LANGUAGE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(688, '_CERTIFICATE_NAME', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(689, '_CERTIFICATE_RELEASE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(690, '_CERTIFICATE_RELEASED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(691, '_CLASSROOMTOCOURSE_CAPTION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(692, '_CLASSROOM_EDITION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(693, '_CLASSROOM_OCCUPATED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(694, '_CLASSROOM_OCCUPATED_YES', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(695, '_CLOSING_DATA', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(696, '_CONFIRM_EXIT', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(697, '_COPY_SUBSCRIPTION_TO_COURSE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(698, '_COURSE_ADVANCE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(699, '_COURSE_AUTOREGISTRATION_CODE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(700, '_COURSE_CONTENT', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(701, '_COURSE_DATE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(702, '_COURSE_DEMO', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(703, '_COURSE_DISPLAY_MODE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(704, '_COURSE_EDITION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(705, '_COURSE_EM_LO', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(706, '_COURSE_EM_TEACHER', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(707, '_COURSE_END_MODE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(708, '_COURSE_INTRO', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(709, '_COURSE_INTRO_WITH_MAX', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(710, '_COURSE_LANG_METHOD', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(711, '_COURSE_LIST_SUMMARY', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(712, '_COURSE_LOGO', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(713, '_COURSE_MENU_TO_ASSIGN', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(714, '_COURSE_PRIZE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(715, '_COURSE_QUOTA', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(716, '_COURSE_SELECTION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(717, '_COURSE_SELL', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(718, '_COURSE_SPECIAL_OPTION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(719, '_COURSE_STATUS_CANNOT_ENTER', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(720, '_COURSE_SUBSCRIPTION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(721, '_COURSE_SUBSRIBE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(722, '_COURSE_S_GODADMIN', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(723, '_COURSE_S_MODERATE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(724, '_COURSE_S_SECURITY_CODE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(725, '_COURSE_TEACHERS', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(726, '_COURSE_TIME_OPTION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(727, '_COURSE_TYPE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(728, '_COURSE_TYPE_BLENDED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(729, '_COURSE_TYPE_EDITION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(730, '_COURSE_TYPE_ELEARNING', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(731, '_COURSE_USERISCR', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(732, '_CREATION_DATE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(733, '_CST_AVAILABLE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(734, '_CST_CANCELLED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(735, '_CST_CONCLUDED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(736, '_CST_CONFIRMED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(737, '_CST_PREPARATION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(738, '_CUSTOM_OPTIONS', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(739, '_DATE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(740, '_DATE_END', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(741, '_DATE_START', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(742, '_DAY', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(743, '_DAYS', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(744, '_DAY_OF_VALIDITY', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(745, '_DEMO', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(746, '_DIRECT_PLAY', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(747, '_DISABLED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(748, '_DOCUMENT_UPLOAD', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(749, '_DONT_SHOW', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(750, '_DOWNLOAD_MATERIALS', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(751, '_DURATION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(752, '_EDTION_TIME', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(753, '_ENDOBJECT', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(754, '_EXPIRED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(755, '_EXPIRING_IN', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(756, '_FILEUNSPECIFIED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(757, '_FILTER_FLATVIEW', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(758, '_FIRSTACOURSE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(759, '_GENERATE_CODE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(760, '_GOTO_COURSE_T', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(761, '_HOUR_BEGIN', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(762, '_HOUR_END', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(763, '_IF_NEW_FILE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(764, '_IMPORT_FROM_COURSE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(765, '_IMPORT_SUBSCRIBE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(766, '_INFO', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(767, '_INHERIT_QUOTA', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(768, '_IN_COURSE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(769, '_IN_THE_CLASSROOM', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(770, '_LESS_INFO', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(771, '_MAIN_CATEGORY', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(772, '_MANUALACTION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(773, '_MATERIALS', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(774, '_MATERIALS_TABLE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(775, '_MAX_NUM_SUBSCRIBE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(776, '_MAX_SMS_BUDGET', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(777, '_MEDIUM', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(778, '_MEDIUMTIME', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(779, '_MEDIUM_TIME', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(780, '_MIN_NUM_SUBSCRIBE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(781, '_MIN_SCORE_NOT_SET', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(782, '_MIN_SUBSCRIBE_FOR_COURSE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(783, '_MULTIPLE_SUBSCRIPTION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(784, '_MY_CERTIFICATE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(785, '_NEW_USER_SUBS_WAITING_TEXT', 'course', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(786, '_NEXT_LESSON', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(787, '_NOACTIVE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(788, '_NOENTER', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(789, '_NO_COURSE_DATA', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(790, '_NO_COURSE_FOUND', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(791, '_OTHER_OPTION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(792, '_OTHER_USER_MATERIAL', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(793, '_OVERVIEW', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(794, '_PARTIAL_TIME', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(795, '_PAUSE_BEGIN', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(796, '_PAUSE_END', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(797, '_PERMCLOSE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(798, '_PROGRESS_ALL', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(799, '_PROGRESS_BAR_TEXT', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(800, '_PROGRESS_COMPLETED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(801, '_PROGRESS_FAILED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(802, '_PROGRESS_INCOMPLETE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(803, '_PROGRESS_PASSED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(804, '_PROGRESS_TITLE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(805, '_QUOTA_EXCEDED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(806, '_RANDOM_COURSE_AUTOREGISTRATION_CODE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(807, '_RESERVE_COURSE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(808, '_RESULT', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(809, '_SC_EVERYWHERE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(810, '_SC_ONLYINSC_USER', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(811, '_SC_ONLY_IN', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(812, '_SELECT_DAYS_COURSE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(813, '_SELF_UNSUBSCRIBE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(814, '_SHOW_ADVANCED_INFO', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(815, '_SHOW_ALL_DATES', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(816, '_SHOW_COUNT', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(817, '_SHOW_DEMO', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(818, '_SHOW_INSTMSG', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(819, '_SHOW_PROGRESS', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(820, '_SHOW_TIME', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(821, '_SHOW_USER_OF_LEVEL', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(822, '_SHOW_WHOISONLINE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(823, '_SPONSORED_BY', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(824, '_SPONSOR_LINK', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(825, '_SPONSOR_LOGO', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(826, '_STATCANNOTENTER', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(827, '_SUBSCRIBED_T', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(828, '_SUBSCRIBE_METHOD', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(829, '_SUBSCRIPTION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(830, '_SUBSCRIPTION_CLOSED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(831, '_SUBSCRIPTION_CORRECT', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(832, '_SUBSCRIPTION_DATE_BEGIN', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(833, '_SUBSCRIPTION_DATE_BEGIN_FROM', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(834, '_SUBSCRIPTION_DATE_END', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(835, '_SUBSCRIPTION_ERROR', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(836, '_SUBSCRIPTION_IN_PERIOD', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(837, '_SUBSCRIPTION_OPEN', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(838, '_THANKS_LOGIN_OR_REGISTER', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(839, '_THEACER_LIST', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(840, '_TITLE_CATEGORY_JUMP', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(841, '_TITLE_CERTIFICATE_TO_COURSE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(842, '_TOTAL_ACCESS_TIME', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(843, '_T_USER_STATUS_BEGIN', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(844, '_T_USER_STATUS_CONFIRMED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(845, '_T_USER_STATUS_END', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(846, '_T_USER_STATUS_RESERVED', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(847, '_T_USER_STATUS_SUBS', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(848, '_UNLIMITED_QUOTA', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(849, '_UNSUBSCRIBE_DATE_LIMIT', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(850, '_UNSUBSCRIBE_REQUESTS', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(851, '_UNSUBSCRIBE_REQUEST_WAITING_FOR_MODERATION', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(852, '_USED_DISK', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(853, '_USERWAITING', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(854, '_USER_CAN_SUBSCRIBE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(855, '_USER_CAN_UNSUBSCRIBE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(856, '_USER_EDITION_SUBSCRIBE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(857, '_USER_LVL', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(858, '_USER_MATERIAL', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(859, '_USETHIS', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(860, '_USE_LOGO_IN_COURSELIST', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(861, '_VOTE_BAD_ALT', 'course', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(862, '_VOTE_BAD_TITLE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(863, '_VOTE_GOOD_ALT', 'course', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(864, '_VOTE_GOOD_TITLE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(865, '_WAITING_PAYMENT', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(866, '_WELCOME', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(867, '_WHAT_SHOW', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(868, '_WHERE_SHOW_COURSE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(869, '_WHOIS_ONLINE', 'course', '', 0, '[[regtime]]', '[[regtime]]'),
(870, '_ALT_REM_SUB', 'coursepath', '', 0, '[[regtime]]', '[[regtime]]'),
(871, '_AREE_YOU_SURE_TO_REMOVE_COURSE_FROM_PATH', 'coursepath', '', 0, '[[regtime]]', '[[regtime]]'),
(872, '_COURSE_PATH_CAPTION', 'coursepath', '', 0, '[[regtime]]', '[[regtime]]'),
(873, '_COURSE_PATH_COURSES_CAPTION', 'coursepath', '', 0, '[[regtime]]', '[[regtime]]'),
(874, '_COURSE_PATH_SUBSCRIBE', 'coursepath', '', 0, '[[regtime]]', '[[regtime]]'),
(875, '_COURSE_S_GODADMIN', 'coursepath', '', 0, '[[regtime]]', '[[regtime]]'),
(876, '_COURSE_S_MODERATE', 'coursepath', '', 0, '[[regtime]]', '[[regtime]]'),
(877, '_CURRENT_ACTIVITY', 'coursepath', '', 0, '[[regtime]]', '[[regtime]]'),
(878, '_IMPORT_COURSE', 'coursepath', '', 0, '[[regtime]]', '[[regtime]]'),
(879, '_SUBSCRIBED_CAPTION', 'coursepath', '', 0, '[[regtime]]', '[[regtime]]'),
(880, '_ACTIVITY_INFO', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(881, '_ADD_ACTIVITY', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(882, '_ADD_ACTIVITY_TITLE', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(883, '_ADD_SCORM_RESULTS', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(884, '_ANSWER_CORRECT', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(885, '_COURSE_REPORT_CAPTION', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(886, '_COURSE_REPORT_SUMMARY', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(887, '_DETAILS', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(888, '_EXPORT_STATS', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(889, '_LEFT', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(890, '_MOVE_LEFT', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(891, '_MOVE_RIGHT', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(892, '_NOT_CHECKED', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(893, '_NOT_PASSED', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(894, '_OF_USER', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(895, '_OVERVIEW', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(896, '_PASSED', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(897, '_PERCENTAGE_CORRECT', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(898, '_QUESTION_ANSWERED', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(899, '_REDO_FINAL_VOTE', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(900, '_REDO_FINAL_VOTE_TITLE', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(901, '_REQUIRED_MUST_BE_LESS_THEN_MAX', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(902, '_RESET_TRACK', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(903, '_RIGHT', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(904, '_ROUND_FINAL_VOTE_TITLE', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(905, '_ROUND_TEST_VOTE', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(906, '_ROUND_VOTE', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(907, '_SHOW_ANSWER', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(908, '_SHOW_TO_USER', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(909, '_STANDARD_DEVIATION', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(910, '_STUDENTS', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(911, '_STUDENTS_VOTE', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(912, '_SUMMARY_VOTE', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(913, '_TABLE_QUEST', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(914, '_TABLE_QUEST_CORRECT_ASS', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(915, '_TABLE_QUEST_CORRECT_TXT', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(916, '_TABLE_QUEST_LIST', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(917, '_TEST_INFO', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(918, '_TH_TEST_REPORT', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(919, '_TITLE_ACT', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(920, '_TOT_QUESTION', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(921, '_TQ_LINK', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(922, '_USE_FOR_FINAL', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(923, '_WEIGHT', 'coursereport', '', 0, '[[regtime]]', '[[regtime]]'),
(924, '_ADDITIONAL_FIELDS_COURSES', 'courses', '', 0, '[[regtime]]', '[[regtime]]'),
(925, '_AUTOREGISTRATION', 'course_autoregistration', '', 0, '[[regtime]]', '[[regtime]]'),
(926, '_BACK_TO_COURSE', 'course_autoregistration', '', 0, '[[regtime]]', '[[regtime]]'),
(927, '_CODE_ALREDY_USED', 'course_autoregistration', '', 0, '[[regtime]]', '[[regtime]]'),
(928, '_CODE_NOT_VALID', 'course_autoregistration', '', 0, '[[regtime]]', '[[regtime]]'),
(929, '_COURSE_AUTOREGISTRATION_CODE', 'course_autoregistration', '', 0, '[[regtime]]', '[[regtime]]'),
(930, '_ACTIVITY_CHART_DESCRIPTION', 'course_charts', '', 0, '[[regtime]]', '[[regtime]]'),
(931, '_CHAPTER_CHART_DESCRIPTION', 'course_charts', '', 0, '[[regtime]]', '[[regtime]]'),
(932, '_COMPLETED_CHART_DESCRIPTION', 'course_charts', '', 0, '[[regtime]]', '[[regtime]]'),
(933, '_NO_SCORM_IN_COURSE', 'course_charts', '', 0, '[[regtime]]', '[[regtime]]'),
(934, '_PASSED_CHART_TITLE', 'course_charts', '', 0, '[[regtime]]', '[[regtime]]'),
(935, '_SCORE_CHART_DESCRIPTION', 'course_charts', '', 0, '[[regtime]]', '[[regtime]]'),
(936, '_TIME_CHART_DESCRIPTION', 'course_charts', '', 0, '[[regtime]]', '[[regtime]]'),
(937, '_TIME_CHART_TITLE', 'course_charts', '', 0, '[[regtime]]', '[[regtime]]'),
(938, '_SEL_COURSE', 'course_selector', '', 0, '[[regtime]]', '[[regtime]]'),
(939, '_OBJ_MISSING', 'customer_help', '', 0, '[[regtime]]', '[[regtime]]'),
(940, '_MSG_MISSING', 'customer_help', '', 0, '[[regtime]]', '[[regtime]]'),
(941, '_NO_HELP_DESK', 'customer_help', '', 0, '[[regtime]]', '[[regtime]]'),
(942, ' 	 _CUSTOMER_HELP_DISCLAIMER_TITLE', 'customer_help', '', 0, '[[regtime]]', '[[regtime]]'),
(943, '_CUSTOMER_HELP', 'customer_help', '', 0, '[[regtime]]', '[[regtime]]'),
(944, '_CUSTOMER_HELP_DISCLAIMER', 'customer_help', '', 0, '[[regtime]]', '[[regtime]]'),
(945, '_CUSTOMER_HELP_DISCLAIMER_TITLE', 'customer_help', '', 0, '[[regtime]]', '[[regtime]]'),
(946, '_README_HELP', 'customer_help', '', 0, '[[regtime]]', '[[regtime]]'),
(947, '_ACTIVE_COURSE', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(948, '_ACTIVE_SEVEN_COURSE', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(949, '_ADMIN_USER', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(950, '_CHOOSE_EXPORT_FORMAT', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(951, '_CORE_VERSION', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(952, '_COURSES_PANEL', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(953, '_DASHBOARD', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(954, '_DASHBOARDBLOCKANNOUNCEMENTSLMS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(955, '_DASHBOARDBLOCKBANNERLMS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(956, '_DASHBOARDBLOCKCALENDARLMS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(957, '_DASHBOARDBLOCKCERTIFICATELMS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(958, '_DASHBOARDBLOCKCOMMUNICATIONLMS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(959, '_DASHBOARDBLOCKCOURSESLMS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(960, '_DASHBOARDBLOCKMESSAGELMS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(961, '_DASHBOARDBLOCKNEWSLMS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(962, '_DASHBOARDBLOCKWELCOMELMS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(963, '_DASHBOARDBLOCKCOURSEATTENDANCEGRAPHLMS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(964, '_DASHBOARD_BLOCKCERTIFICATES_NO_RECORDS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(965, '_DASHBOARD_BLOCKMESSAGES_NO_RECORDS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(966, '_DB_UPGRADES', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(967, '_DEACTIVE_SEVEN_COURSE', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(968, '_FOLLOW_US', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(969, '_INACTIVE_USER', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(970, '_LAST_RELEASED', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(971, '_LIBRARY', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(972, '_MONITOR_PRINT_CERTIFICATE_STATUS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(973, '_NEW_RELEASE_AVAILABLE', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(974, '_ONLINE_USER', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(975, '_OPEN_IN_NEW_WINDOW', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(976, '_QUICK_LINKS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(977, '_REG_LASTSEVENDAYS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(978, '_REG_TODAY', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(979, '_REG_YESTERDAY', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(980, '_SUPERADMIN_USER', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(981, '_SUPPORT_SITE', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(982, '_SUSPENDED_USER', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(983, '_TITLE_URL_COMPANY', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(984, '_TITLE_URL_SUPPORTLMS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(985, '_TOTAL_COURSE', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(986, '_TOTAL_SUBSCRIPTION', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(987, '_TOTAL_USER', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(988, '_UNKNOWN_RELEASE', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(989, '_URL_COMPANY', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(990, '_URL_SUPPORTLMS', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(991, '_USERS_PANEL', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(992, '_WAITING_SUBSCRIPTION', 'dashboard', '', 0, '[[regtime]]', '[[regtime]]'),
(993, '_CHECKBOX_DASHBOARDBLOCKCERTIFICATESLMS_SHOW_BUTTO', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(994, '_CHECKBOX_DASHBOARDBLOCKCERTIFICATESLMS_SHOW_BUTTON', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(995, '_CHECKBOX_DASHBOARDBLOCKCOMMUNICATIONLMS_SHOWREAD', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(996, '_CHECKBOX_DASHBOARDBLOCKCOMMUNICATIONLMS_SHOW_BUTTON', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(997, '_CHECKBOX_DASHBOARDBLOCKCOURSESLMS_SHOW_BUTTON', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(998, '_CHECKBOX_DASHBOARDBLOCKMESSAGESLMS_SHOW_BUTTON', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(999, '_DASHBOARDBLOCKANNOUNCEMENTSLMS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1000, '_DASHBOARDBLOCKANNOUNCEMENTSLMS_DESCRIPTION', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1001, '_DASHBOARDBLOCKBANNERLMS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1002, '_DASHBOARDBLOCKBANNERLMS_DESCRIPTION', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1003, '_DASHBOARDBLOCKCALENDARLMS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1004, '_DASHBOARDBLOCKCALENDARLMS_DESCRIPTION', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1005, '_DASHBOARDBLOCKCALENDARLMS_GETCLASSROOMCALENDAR', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1006, '_DASHBOARDBLOCKCALENDARLMS_GETELEARNINGCALENDAR', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1007, '_DASHBOARDBLOCKCALENDARLMS_GETRESERVATIONCALENDAR', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1008, '_DASHBOARDBLOCKCERTIFICATESLMS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1009, '_DASHBOARDBLOCKCERTIFICATESLMS_DESCRIPTION', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1010, '_DASHBOARDBLOCKCOMMUNICATIONLMS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1011, '_DASHBOARDBLOCKCOMMUNICATIONLMS_DESCRIPTION', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1012, '_DASHBOARDBLOCKCOURSESLMS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1013, '_DASHBOARDBLOCKCOURSESLMS_DESCRIPTION', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1014, '_DASHBOARDBLOCKMESSAGESLMS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1015, '_DASHBOARDBLOCKMESSAGESLMS_DESCRIPTION', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1016, '_DASHBOARDBLOCKNEWSLMS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1017, '_DASHBOARDBLOCKNEWSLMS_DESCRIPTION', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1018, '_DASHBOARDBLOCKWELCOMELMS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1019, '_DASHBOARDBLOCKWELCOMELMS_DESCRIPTION', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1020, '_DASHBOARDBLOCKCOURSEATTENDANCEGRAPHLMS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1021, '_DASHBOARDBLOCKCOURSEATTENDANCEGRAPHLMS_DESCRIPTION', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1022, '_DASHBOARD_DELETE_LAYOUT', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1023, '_DASHBOARD_LAYOUT', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1024, '_DASHBOARD_LAYOUT_DEFAULT', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1025, '_DASHBOARD_LAYOUT_SAVE_MESSAGE_KO', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1026, '_DASHBOARD_LAYOUT_SAVE_MESSAGE_OK', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1027, '_DASHBOARD_LAYOUT_STATUS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1028, '_DASHBOARD_LAYOUT_SURE_DEL', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1029, '_DASHBOARD_NO_LAYOUTS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1030, '_DASHBOARD_SETTING_ADD_NEW_BLOCK', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1031, '_DASHBOARD_SETTING_ADD_NEW_LAYOUT', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1032, '_DASHBOARD_SETTING_BLOCK_REQUIRED', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1033, '_DASHBOARD_SETTING_CREATE_NEW_LAYOUT', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1034, '_DASHBOARD_SETTING_DRAFT_STATUS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1035, '_DASHBOARD_SETTING_FILE_ALLOWED_TYPES', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1036, '_DASHBOARD_SETTING_FILE_TYPE_ERROR', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1037, '_DASHBOARD_SETTING_IMAGE_ALLOWED_TYPES', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1038, '_DASHBOARD_SETTING_IMAGE_TYPE_ERROR', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1039, '_DASHBOARD_SETTING_INSERT_NEW_LAYOUT', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1040, '_DASHBOARD_SETTING_LAYOUT_NAME', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1041, '_DASHBOARD_SETTING_PUBLISH_STATUS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1042, '_DASHBOARD_SETTING_SAVE', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1043, '_DASHBOARD_SETTING_SAVE_MESSAGE_KO', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1044, '_DASHBOARD_SETTING_SAVE_MESSAGE_OK', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1045, '_DASHBOARD_SETTING_SELECT_BLOCK', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1046, '_DASHBOARD_SETTING_SELECT_STATUS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1047, '_DASHBOARD_STATUS_DRAFT', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1048, '_DASHBOARD_STATUS_PUBLISH', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1049, '_DASHBOARD_WELCOME_MESSAGE', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1050, '_ENABLED_ACTIONS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1051, '_IMAGE_DASHBOARDBLOCKBANNERLMS_COVER', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1052, '_INPUT_DASHBOARDBLOCKANNOUNCEMENTSLMS_TITLE', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1053, '_INPUT_DASHBOARDBLOCKBANNERLMS_TITLE', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1054, '_INPUT_DASHBOARDBLOCKBANNERLMS_VIDEO', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1055, '_INPUT_DASHBOARDBLOCKCALENDARLMS_TITLE', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1056, '_INPUT_DASHBOARDBLOCKCERTIFICATESLMS_ALTERNATIVE_T', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1057, '_INPUT_DASHBOARDBLOCKCERTIFICATESLMS_ALTERNATIVE_TEXT', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1058, '_INPUT_DASHBOARDBLOCKCERTIFICATESLMS_MAX_LAST_RECO', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1059, '_INPUT_DASHBOARDBLOCKCERTIFICATESLMS_MAX_LAST_RECORDS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1060, '_INPUT_DASHBOARDBLOCKCERTIFICATESLMS_TITLE', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1061, '_INPUT_DASHBOARDBLOCKCOMMUNICATIONLMS_MAX_LAST_RECORDS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]');
INSERT INTO `core_lang_text` VALUES
(1062, '_INPUT_DASHBOARDBLOCKCOMMUNICATIONLMS_TITLE', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1063, '_INPUT_DASHBOARDBLOCKCOURSESLMS_MAX_COURSES_NUMBER', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1064, '_INPUT_DASHBOARDBLOCKCOURSESLMS_TITLE', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1065, '_INPUT_DASHBOARDBLOCKMESSAGESLMS_ALTERNATIVE_TEXT', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1066, '_INPUT_DASHBOARDBLOCKMESSAGESLMS_MAX_LAST_RECORDS', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1067, '_INPUT_DASHBOARDBLOCKMESSAGESLMS_TITLE', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1068, '_INPUT_DASHBOARDBLOCKNEWSLMS_TITLE', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1069, '_INPUT_DASHBOARDBLOCKWELCOMELMS_TITLE', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1070, '_INPUT_DASHBOARDBLOCKWELCOMELMS_WELCOME_TEXT', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1071, '_SELECT_DASHBOARDBLOCKCOURSESLMS_COURSE_TYPE', 'dashboardsetting', '', 0, '[[regtime]]', '[[regtime]]'),
(1072, '_BROWSE_OR_DROP_HERE', 'dropzone', '', 0, '[[regtime]]', '[[regtime]]'),
(1073, '_DESCRIPTION', 'dropzone', '', 0, '[[regtime]]', '[[regtime]]'),
(1074, '_ERRORS_OCCURRED', 'dropzone', '', 0, '[[regtime]]', '[[regtime]]'),
(1075, '_OBJECT_CONTAINS_ERROR', 'dropzone', '', 0, '[[regtime]]', '[[regtime]]'),
(1076, '_TITLE', 'dropzone', '', 0, '[[regtime]]', '[[regtime]]'),
(1077, '_UPLOAD_FILES', 'dropzone', '', 0, '[[regtime]]', '[[regtime]]'),
(1078, '_ALERT_SUBJECT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1079, '_ALERT_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1080, '_APPROVED_SUBSCRIBED_SUBJECT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1081, '_APPROVED_SUBSCRIBED_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1082, '_APPROVED_USER_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1083, '_DELETED_USER_SBJ', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1084, '_DELETED_USER_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1085, '_DENY_SUBSCRIBED_SUBJECT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1086, '_DENY_SUBSCRIBED_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1087, '_EVENT_CHANGE_NODE_USER_SBJ', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1088, '_EVENT_CHANGE_NODE_USER_TEXT', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1089, '_EVENT_CLASS_UserCourseBuy', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1090, '_EVENT_COURSE_EVENT_SUSPENDED_USER_SBJ', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1091, '_EVENT_COURSE_EVENT_SUSPENDED_USER_TEXT', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1092, '_EVENT_SUSPENDED_USER_SBJ', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1093, '_EVENT_SUSPENDED_USER_TEXT', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1094, '_MODIFIED_USER_SBJ', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1095, '_MODIFIED_USER_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1096, '_MOD_USER_SUBSCRIPTION_SUBJECT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1097, '_MOD_USER_SUBSCRIPTION_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1098, '_NEW_FORUM', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1099, '_NEW_FORUM_BODY', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1100, '_NEW_MESSAGE_INSERT_IN_THREAD', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1101, '_NEW_THREAD_INSERT_IN_FORUM', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1102, '_NEW_USER_OVERBOOKING_SUBSCRIBED_SUBJECT', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1103, '_NEW_USER_OVERBOOKING_SUBSCRIBED_TEXT', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1104, '_NEW_USER_SUBSCRIBED_SUBJECT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1105, '_NEW_USER_SUBSCRIBED_SUBJECT_MODERATORS', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1106, '_NEW_USER_SUBSCRIBED_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1107, '_NEW_USER_SUBSCRIBED_TEXT_MODERATORS', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1108, '_NEW_USER_SUBSCRIBED_TEXT_SMS', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1109, '_NEW_USER_SUBS_WAITING_SUBJECT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1110, '_NEW_USER_SUBS_WAITING_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1111, '_NEW_USER_UNSUBS_WAITING_SUBJECT', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1112, '_NEW_USER_UNSUBS_WAITING_SUBJECT_SMS', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1113, '_NEW_USER_UNSUBS_WAITING_TEXT', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1114, '_NEW_USER_UNSUBS_WAITING_TEXT_SMS', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1115, '_PASSWORD_CHANGED', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1116, '_REFUSED_USER_SBJ', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1117, '_REFUSED_USER_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1118, '_REGISTERED_USER_SBJ', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1119, '_REGISTERED_USER_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1120, '_SUBJECT_NOTIFY_MESSAGE', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1121, '_SUBJECT_NOTIFY_THREAD', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1122, '_TO_APPROVE_GROUP_USER_SBJ', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1123, '_TO_APPROVE_GROUP_USER_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1124, '_TO_APPROVE_GROUP_USER_TEXT_SMS', 'email', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(1125, '_TO_APPROVE_USER_SBJ', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1126, '_TO_APPROVE_USER_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1127, '_TO_NEW_USER_SBJ', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1128, '_TO_NEW_USER_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1129, '_USER_END_COURSE_SBJ', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1130, '_USER_END_COURSE_TEXT', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1131, '_USER_END_COURSE_TEXT_SMS', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1132, '_WAITING_USER_SBJ', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1133, '_WAITING_USER_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1134, '_YOU_RECIVE_MSG_SUBJECT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1135, '_YOU_RECIVE_MSG_TEXT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1136, '_YOU_RECIVE_MSG_TEXT_COURSE', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1137, '_EVENT_CLASSROOM_COURSE_DATE_EVENT_UNSUBSCRIBE_USER_SBJ', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1138, '_EVENT_CLASSROOM_COURSE_DATE_EVENT_UNSUBSCRIBE_USER_TEXT', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1139, '_SCHEDULED_REPORT_BODY', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1140, '_SCHEDULED_REPORT_SUBJECT', 'email', 'email', 0, '[[regtime]]', '[[regtime]]'),
(1141, '_EVENT_EDITION_COURSE_EVENT_UNSUBSCRIBE_USER_SBJ', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1142, '_EVENT_EDITION_COURSE_EVENT_UNSUBSCRIBE_USER_TEXT', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1143, '_EVENT_COURSE_EVENT_UNSUBSCRIBE_USER_SBJ', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1144, '_EVENT_COURSE_EVENT_UNSUBSCRIBE_USER_TEXT', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1145, '_PURCHASE_COURSE_MAIL_SBJ', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1146, '_PURCHASE_COURSE_MAIL_TEXT', 'email', '', 0, '[[regtime]]', '[[regtime]]'),
(1147, '_APPLY_RULE', 'enrollrules', '', 0, '[[regtime]]', '[[regtime]]'),
(1148, '_BASE', 'enrollrules', '', 0, '[[regtime]]', '[[regtime]]'),
(1149, '_ENTITY', 'enrollrules', '', 0, '[[regtime]]', '[[regtime]]'),
(1150, '_SHOW_LOGS', 'enrollrules', '', 0, '[[regtime]]', '[[regtime]]'),
(1151, '_EVENT_CHANGE_NODE_USER_SBJ', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1152, '_EVENT_CHANGE_NODE_USER_SBJ_SMS', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1153, '_EVENT_CHANNEL_SMS', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1154, '_EVENT_CLASS_AdviceNew', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1155, '_EVENT_CLASS_CoursePorpModified', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1156, '_EVENT_CLASS_ForumNewCategory', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1157, '_EVENT_CLASS_ForumNewResponse', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1158, '_EVENT_CLASS_ForumNewThread', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1159, '_EVENT_CLASS_MsgNewReceived', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1160, '_EVENT_CLASS_UserApproved', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1161, '_EVENT_CLASS_UserCourseBuy', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1162, '_EVENT_CLASS_UserCourseEnded', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1163, '_EVENT_CLASS_UserCourseInserted', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1164, '_EVENT_CLASS_UserCourseInsertedApi', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1165, '_EVENT_CLASS_UserCourseInsertedModerators', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1166, '_EVENT_CLASS_UserCourseInsertModerate', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1167, '_EVENT_CLASS_UserCourseInsertOverbooking', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1168, '_EVENT_CLASS_UserCourseLevelChanged', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1169, '_EVENT_CLASS_UserCourseRemoved', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1170, '_EVENT_CLASS_UserCourseRemovedModerate', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1171, '_EVENT_CLASS_UserCourseSuspendedSuperAdmin', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1172, '_EVENT_CLASS_UserDel', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1173, '_EVENT_CLASS_UserGroupInsert', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1174, '_EVENT_CLASS_UserGroupModerated', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1175, '_EVENT_CLASS_UserGroupRemove', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1176, '_EVENT_CLASS_UserMod', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1177, '_EVENT_CLASS_UserModNodeSuperAdmin', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1178, '_EVENT_CLASS_UserModSuperAdmin', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1179, '_EVENT_CLASS_UserNew', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1180, '_EVENT_CLASS_UserNew2', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1181, '_EVENT_CLASS_UserNewModerated', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1182, '_EVENT_CLASS_UserNewWaiting', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1183, '_EVENT_CLASS_UserRegistrationSuperadmins', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1184, '_EVENT_CLASS_UserSuspendedSuperAdmin', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1185, '_EVENT_COURSE_EVENT_SUSPENDED_USER_SBJ', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1186, '_EVENT_COURSE_EVENT_SUSPENDED_USER_TEXT', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1187, '_EVENT_COURSE_EVENT_SUSPENDED_USER_TEXT_SMS', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1188, '_EVENT_MANAGER', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1189, '_EVENT_MOD_USER_SBJ', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1190, '_EVENT_MOD_USER_TEXT', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1191, '_EVENT_MOD_USER_TEXT_SMS', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1192, '_EVENT_PERM_NOTUSED', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1193, '_EVENT_PLATFORM', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1194, '_EVENT_PLATFORM_framework', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1195, '_EVENT_PLATFORM_lms', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1196, '_EVENT_PLATFORM_lms-a', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1197, '_EVENT_RECIPIENTS_GOD', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1198, '_EVENT_RECIPIENTS_GODS', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1199, '_EVENT_RECIPIENTS_MODERATORS_GOD', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1200, '_EVENT_RECIPIENTS_TEACHER', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1201, '_EVENT_RECIPIENTS_TEACHER_GOD', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1202, '_EVENT_RECIPIENTS_USER', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1203, '_EVENT_SETTINGS', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1204, '_EVENT_SUSPENDED_USER_SBJ', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1205, '_EVENT_SUSPENDED_USER_TEXT', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1206, '_EVENT_SUSPENDED_USER_TEXT_SMS', 'event_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1207, '_ADDFAQ', 'faq', '', 0, '[[regtime]]', '[[regtime]]'),
(1208, '_BACKTOTOP', 'faq', '', 0, '[[regtime]]', '[[regtime]]'),
(1209, '_KEYWORD', 'faq', '', 0, '[[regtime]]', '[[regtime]]'),
(1210, '_SECT_FAQ', 'faq', '', 0, '[[regtime]]', '[[regtime]]'),
(1211, '_SESLECTTERM', 'faq', '', 0, '[[regtime]]', '[[regtime]]'),
(1212, '_SUMMARY_FAQ', 'faq', '', 0, '[[regtime]]', '[[regtime]]'),
(1213, '_SWITCH_TO_FAQ', 'faq', '', 0, '[[regtime]]', '[[regtime]]'),
(1214, '_SWITCH_TO_HELP', 'faq', '', 0, '[[regtime]]', '[[regtime]]'),
(1215, '_TERM', 'faq', '', 0, '[[regtime]]', '[[regtime]]'),
(1216, '_ADD_NEW_CUSTOMFIELD', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1217, '_ADD_NEW_FIELD', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1218, '_ALL_FIELD_TYPE', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1219, '_CODICEFISCALE', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1220, '_COPY', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1221, '_COUNTRY', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1222, '_DROPDOWN', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1223, '_DROPDOWN_ELEMENT', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1224, '_DROPDOWN_NOVALUE', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1225, '_DROPDOWN_SON_ADD', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1226, '_DROPDOWN_SON_CAPTION', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1227, '_DROPDOWN_SON_NEW', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1228, '_FIELD_MANAGER', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1229, '_FIELD_TYPE', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1230, '_FILTER_NAME', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1231, '_FREETEXT', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1232, '_GMAIL', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1233, '_ICQ', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1234, '_LABEL_ALERT', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1235, '_LABEL_ALERT_MESSAGE', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1236, '_MSN', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1237, '_NEW_DATEFIELD', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1238, '_NEW_DROPDOWN', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1239, '_NEW_FREETEXT', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1240, '_NEW_ICQ', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1241, '_NEW_MSN', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1242, '_NEW_SKYPE', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1243, '_NEW_TEXTFIELD', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1244, '_NEW_UPLOAD', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1245, '_NEW_YAHOO', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1246, '_NEW_YESNO', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1247, '_NOT_DO', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1248, '_NO_FILE_UPLOADED', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1249, '_SHOW_ON_PLATFORM', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1250, '_SKYPE', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1251, '_TEXTFIELD', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1252, '_USE_MULTI_LANG_WHEN_AVAILABLE', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1253, '_YAHOO', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1254, '_YESNO', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1255, '_NOT_TRANSLATED_FIELD', 'field', '', 0, '[[regtime]]', '[[regtime]]'),
(1256, '_GAP_ANALYSIS', 'fncroles', '', 0, '[[regtime]]', '[[regtime]]'),
(1257, '_GAP_ONLY', 'fncroles', '', 0, '[[regtime]]', '[[regtime]]'),
(1258, '_NO_GAP_ONLY', 'fncroles', '', 0, '[[regtime]]', '[[regtime]]'),
(1259, '_ADDFORUM', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1260, '_ADDTHREAD', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1261, '_ALL_THREAD_READ', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1262, '_AREYOUSURE_MOVE_THREAD', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1263, '_CANNOTENTER', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1264, '_CAPTION_FORUM_MESSAGE', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1265, '_CAPTION_FORUM_MESSAGE_ADD', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1266, '_CHOOSE_FORUM_ACCESS', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1267, '_DELETE', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1268, '_ELEFORUM', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1269, '_EMOTICONS', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1270, '_FORUMCLOSED', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1271, '_FORUMOPEN', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1272, '_FORUM_ACCESS', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1273, '_FORUM_INFORMATION', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1274, '_FREE', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1275, '_FREET', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1276, '_FREETHREAD', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1277, '_FROM_FORUM', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1278, '_IMPORTANT_THREAD', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1279, '_LASTPOST', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1280, '_LOCKED', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1281, '_LOCKEDMESS', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1282, '_LOCKFORUM', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1283, '_LOCKFORUMALT', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1284, '_LOCKTHREAD', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1285, '_MODIFY_BY', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1286, '_MOD_MESSAGE', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1287, '_MOVE_TO_FORUM', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1288, '_NEW_MESSAGE', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1289, '_NEW_THREAD', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1290, '_NOACCESS', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1291, '_NOTIFY', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1292, '_NOTIFY_CHANGE_STATUS_CORRECT', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1293, '_NOTIFY_ME_FORUM', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1294, '_NOTIFY_ME_FORUM_TITLE', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1295, '_NOTIFY_ME_THREAD', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1296, '_NOTIFY_ME_THREAD_TITLE', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1297, '_NUMPOST', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1298, '_NUMREPLY', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1299, '_NUMTHREAD', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1300, '_NUMVIEW', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1301, '_OPERATIONS', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1302, '_QUOTE', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1303, '_RESTOREINSERT', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1304, '_SEARCH_LABEL', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1305, '_SEARCH_RESULT_FOR', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1306, '_SET_NOT_IMPORTANT_THREAD', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1307, '_THRAD_SUMMARY', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1308, '_THREAD', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1309, '_THREAD_CAPTION', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1310, '_TO_FORUM', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1311, '_UNERASE', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1312, '_UNLOCKFORUM', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1313, '_UNLOCKFORUMALT', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1314, '_UNNOTIFY', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1315, '_UNNOTIFY_ME_FORUM', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1316, '_UNNOTIFY_ME_FORUM_TITLE', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1317, '_UNNOTIFY_ME_THREAD', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1318, '_UNNOTIFY_ME_THREAD_TITLE', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1319, '_USERFORUMPARAM', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1320, '_USERPARAM', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1321, '_VIEW_PROFILE', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1322, '_WRITTED_BY', 'forum', '', 0, '[[regtime]]', '[[regtime]]'),
(1323, '_ADDTERM', 'glossary', '', 0, '[[regtime]]', '[[regtime]]'),
(1324, '_GLOSSARY', 'glossary', '', 0, '[[regtime]]', '[[regtime]]'),
(1325, '_GLOSSARY_SUMMARY', 'glossary', '', 0, '[[regtime]]', '[[regtime]]'),
(1326, '_PRIVATE_THREAD', 'glossary', '', 0, '[[regtime]]', '[[regtime]]'),
(1327, '_TERM', 'glossary', '', 0, '[[regtime]]', '[[regtime]]'),
(1328, '_TERMDESCR', 'glossary', '', 0, '[[regtime]]', '[[regtime]]'),
(1329, '_TERMS', 'glossary', '', 0, '[[regtime]]', '[[regtime]]'),
(1330, '_GRADEBOOK_AREATITLE', 'gradebook', '', 0, '[[regtime]]', '[[regtime]]'),
(1331, '_GRADEBOOK_CAPTION', 'gradebook', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(1332, '_GRADEBOOK_SUMMARY', 'gradebook', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(1333, '_MAX_DIVISOR', 'gradebook', '', 0, '[[regtime]]', '[[regtime]]'),
(1334, '_NOT_CHECKED', 'gradebook', '', 0, '[[regtime]]', '[[regtime]]'),
(1335, '_NO_SCORE', 'gradebook', '', 0, '[[regtime]]', '[[regtime]]'),
(1336, '_TEST_N', 'gradebook', '', 0, '[[regtime]]', '[[regtime]]'),
(1337, '_ALT_SUBSCRIBE', 'groups', '', 0, '[[regtime]]', '[[regtime]]'),
(1338, '_GROUP_CAPTION', 'groups', '', 0, '[[regtime]]', '[[regtime]]'),
(1339, '_MANAGE_GROUP_SUBSCRIPTION', 'groups', '', 0, '[[regtime]]', '[[regtime]]'),
(1340, '_SUBSCRIBE_USER', 'groups', '', 0, '[[regtime]]', '[[regtime]]'),
(1341, '_REPOSELECTDESTINATION', 'homerepo', '', 0, '[[regtime]]', '[[regtime]]'),
(1342, '_TARGETMOVEFOLDER', 'homerepo', '', 0, '[[regtime]]', '[[regtime]]'),
(1343, '_AUTOREFRESH', 'htmlframechat', '', 0, '[[regtime]]', '[[regtime]]'),
(1344, '_EMOTICONS', 'htmlframechat', '', 0, '[[regtime]]', '[[regtime]]'),
(1345, '_MSGTXT', 'htmlframechat', '', 0, '[[regtime]]', '[[regtime]]'),
(1346, '_REFRESH', 'htmlframechat', '', 0, '[[regtime]]', '[[regtime]]'),
(1347, '_ROOMS_LIST', 'htmlframechat', '', 0, '[[regtime]]', '[[regtime]]'),
(1348, '_USERS_LIST', 'htmlframechat', '', 0, '[[regtime]]', '[[regtime]]'),
(1349, '_USER_HAS_QUIT', 'htmlframechat', '', 0, '[[regtime]]', '[[regtime]]'),
(1350, '_USER_LOGGED_IN', 'htmlframechat', '', 0, '[[regtime]]', '[[regtime]]'),
(1351, '_HTMLFRONT', 'htmlfront', '', 0, '[[regtime]]', '[[regtime]]'),
(1352, '_ATTACH_TITLE', 'htmlpage', '', 0, '[[regtime]]', '[[regtime]]'),
(1353, '_BACKTOTOP', 'htmlpage', '', 0, '[[regtime]]', '[[regtime]]'),
(1354, '_SECT_PAGE', 'htmlpage', '', 0, '[[regtime]]', '[[regtime]]'),
(1355, '_TYPE_VIDEO_HIGH', 'htmlpage', '', 0, '[[regtime]]', '[[regtime]]'),
(1356, '_TYPE_VIDEO_LOW', 'htmlpage', '', 0, '[[regtime]]', '[[regtime]]'),
(1357, '_ACCESSTYPE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1358, '_ADD_NEW_CONNECTION', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1359, '_ADD_NEW_CONNECTOR', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1360, '_ADD_NEW_TASK', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1361, '_BYEXAMPLE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1362, '_CANCELED_COURSES', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1363, '_CANCELED_COURSEUSER', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1364, '_CANCELED_FOLDER', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1365, '_CANCELED_USERS', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1366, '_CLASS', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1367, '_CONFIRM_DELETION', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1368, '_CONNECTION', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1369, '_CONNECTIONS', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1370, '_CONNECTOR', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1371, '_CONNECTORS', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1372, '_CONNECTORS_TITLE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1373, '_CONN_NAME_EXAMPLE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1374, '_CONN_TITLE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1375, '_DESTINATION', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1376, '_DONTDELETE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1377, '_DONTSEND', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1378, '_FIELD_DEF', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1379, '_FIELD_DEFINITION_TYPE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1380, '_FIELD_DELIMITER', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1381, '_FIELD_ENCLOSURE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1382, '_FIELD_SUBPATTERN', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1383, '_FILEPATTERN', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1384, '_FILEPATTERN_EXAMPLE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1385, '_FILE_ANALYZED', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1386, '_FINISH', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1387, '_FIRST_ROW_HEADER', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1388, '_GROUP_FILTER', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1389, '_HOUR', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1390, '_IMPORT_NOTHINGTOPROCESS', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1391, '_IMPORT_TYPE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1392, '_IMPORT_TYPE_INSERTONLY', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1393, '_IMPORT_TYPE_INSERTREMOVE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1394, '_LAST_EXECUTION', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1395, '_MAP_NOT_REQUIRED', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1396, '_NO_NEW_CONNECTORS', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1397, '_PREG_MATCH_FOLDER', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1398, '_READ', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1399, '_READWRITE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1400, '_SCHEDULE_TYPE_AT', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1401, '_SCHEDULE_TYPE_AT_DATA', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1402, '_SCHEDULE_TYPE_INTERVAL', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1403, '_SCHEDULE_TYPE_INTERVAL_DATA', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1404, '_SENDNOTIFY', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1405, '_SOURCE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1406, '_STANDARD_MENU', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1407, '_TASKS', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1408, '_TASK_DEL', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1409, '_TASK_INSERTED', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1410, '_TASK_NAME_EXAMPLE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1411, '_TASK_RUN', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1412, '_TASK_RUNNED', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1413, '_TREE_INSERT', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1414, '_TREE_INSERT_FOLDER', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1415, '_WRITE', 'iotask', '', 0, '[[regtime]]', '[[regtime]]'),
(1416, '_FILEUNSPECIFIED', 'item', '', 0, '[[regtime]]', '[[regtime]]'),
(1417, '_FILE_MOD', 'item', '', 0, '[[regtime]]', '[[regtime]]'),
(1418, '_MIME', 'item', '', 0, '[[regtime]]', '[[regtime]]'),
(1419, '_SECTIONNAME_ITEM', 'item', '', 0, '[[regtime]]', '[[regtime]]'),
(1420, '_BY_INSTRUCTOR', 'kb', '', 0, '[[regtime]]', '[[regtime]]'),
(1421, '_BY_STUDENT', 'kb', '', 0, '[[regtime]]', '[[regtime]]'),
(1422, '_CATEGORIZED_AND_UNCATEGORIZED', 'kb', '', 0, '[[regtime]]', '[[regtime]]'),
(1423, '_CATEGORIZED_ONLY', 'kb', '', 0, '[[regtime]]', '[[regtime]]'),
(1424, '_CATEGORIZE_OBJECT_ITEMS', 'kb', '', 0, '[[regtime]]', '[[regtime]]'),
(1425, '_CONTAINED_IN', 'kb', '', 0, '[[regtime]]', '[[regtime]]'),
(1426, '_IS_MOBILE', 'kb', '', 0, '[[regtime]]', '[[regtime]]'),
(1427, '_RESOURCE_ORIGINAL_NAME', 'kb', '', 0, '[[regtime]]', '[[regtime]]'),
(1428, '_SELECTED_DROP_DOWN', 'kb', '', 0, '[[regtime]]', '[[regtime]]'),
(1429, '_SET_AS_NORMAL', 'kb', '', 0, '[[regtime]]', '[[regtime]]'),
(1430, '_SET_VISIBLE_TO_EVERYONE', 'kb', '', 0, '[[regtime]]', '[[regtime]]'),
(1431, '_UNCATEGORIZED_ONLY', 'kb', '', 0, '[[regtime]]', '[[regtime]]'),
(1432, '_VISIBLE_BY_EVERYONE', 'kb', '', 0, '[[regtime]]', '[[regtime]]'),
(1433, '_YOU_WILL_LOSE_PREVIOUS_CATEGORIZATION', 'kb', '', 0, '[[regtime]]', '[[regtime]]'),
(1434, '_ALL_DESCRIPTION', 'label', '', 0, '[[regtime]]', '[[regtime]]'),
(1435, '_LEVEL_1', 'levels', '', 0, '[[regtime]]', '[[regtime]]'),
(1436, '_LEVEL_2', 'levels', '', 0, '[[regtime]]', '[[regtime]]'),
(1437, '_LEVEL_3', 'levels', '', 0, '[[regtime]]', '[[regtime]]'),
(1438, '_LEVEL_4', 'levels', '', 0, '[[regtime]]', '[[regtime]]'),
(1439, '_LEVEL_5', 'levels', '', 0, '[[regtime]]', '[[regtime]]'),
(1440, '_LEVEL_6', 'levels', '', 0, '[[regtime]]', '[[regtime]]'),
(1441, '_LEVEL_7', 'levels', '', 0, '[[regtime]]', '[[regtime]]'),
(1442, '_ADD_FILE', 'light_repo', '', 0, '[[regtime]]', '[[regtime]]'),
(1443, '_CAPTION_USER_FILE_LIST', 'light_repo', '', 0, '[[regtime]]', '[[regtime]]'),
(1444, '_FILE_COUNT', 'light_repo', '', 0, '[[regtime]]', '[[regtime]]'),
(1445, '_NEW_REPOSITORY', 'light_repo', '', 0, '[[regtime]]', '[[regtime]]'),
(1446, '_NO_REPOSITORY_FOUND', 'light_repo', '', 0, '[[regtime]]', '[[regtime]]'),
(1447, '_REPO_NEW_FILE', 'light_repo', '', 0, '[[regtime]]', '[[regtime]]'),
(1448, '_TEACHER_ALERT', 'light_repo', '', 0, '[[regtime]]', '[[regtime]]'),
(1449, '_TEACHER_ALERT_BODY', 'light_repo', '', 0, '[[regtime]]', '[[regtime]]'),
(1450, '_TEACHER_ALERT_SUBJECT', 'light_repo', '', 0, '[[regtime]]', '[[regtime]]'),
(1451, '_TITLE_LIGHT_REPO', 'light_repo', '', 0, '[[regtime]]', '[[regtime]]'),
(1452, '_VIEW_USER_FILE_LIST', 'light_repo', '', 0, '[[regtime]]', '[[regtime]]'),
(1453, '_ADDLINK', 'link', '', 0, '[[regtime]]', '[[regtime]]'),
(1454, '_ADDLINKT', 'link', '', 0, '[[regtime]]', '[[regtime]]'),
(1455, '_BACKTOTOP', 'link', '', 0, '[[regtime]]', '[[regtime]]'),
(1456, '_KEYWORD', 'link', '', 0, '[[regtime]]', '[[regtime]]'),
(1457, '_LINKIUNNEWWINDOW', 'link', '', 0, '[[regtime]]', '[[regtime]]'),
(1458, '_LINK_ADDRESS', 'link', '', 0, '[[regtime]]', '[[regtime]]'),
(1459, '_SECT_LINK', 'link', '', 0, '[[regtime]]', '[[regtime]]'),
(1460, '_SESLECTTERM', 'link', '', 0, '[[regtime]]', '[[regtime]]'),
(1461, '_SUMMARY_LINK', 'link', '', 0, '[[regtime]]', '[[regtime]]'),
(1462, '_SWITCH_TO_KEYWORD', 'link', '', 0, '[[regtime]]', '[[regtime]]'),
(1463, '_SWITCH_TO_LIST', 'link', '', 0, '[[regtime]]', '[[regtime]]'),
(1464, '_TERM', 'link', '', 0, '[[regtime]]', '[[regtime]]'),
(1465, '_ACCESS_LOCK', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1466, '_CANCELSOCIALLOGIN', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1467, '_EMPTYSOCIALID', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1468, '_HOMEPAGE', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1469, '_INTRO_STD_TEXT', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1470, '_INTRO_STD_TEXT_TITLE', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1471, '_JUMP_TO_LOGIN', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1472, '_LDAPACTIVE', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1473, '_LOGIN', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1474, '_LOGIN_ACCESSIBILITY', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1475, '_LOGIN_LEGEND', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1476, '_LOGIN_WITH', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1477, '_LOG_IN', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1478, '_LOG_LOSTPWD', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1479, '_LOST_INSTRUCTION_PWD', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1480, '_LOST_INSTRUCTION_USER', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1481, '_LOST_TITLE_USER', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1482, '_MAINTENANCE_TEXT', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1483, '_NOACCESS', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1484, '_PASSNOMATCH', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1485, '_READ_ALL', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1486, '_REGISTER_FOR_COURSE', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1487, '_REGISTER_FOR_COURSE_NO_REG', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1488, '_REGISTER_WITH_FACEBOOK', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1489, '_REG_ELAPSEDREQUEST', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1490, '_REG_PRIVACY_POLICY', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1491, '_SESSION_EXPIRED', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1492, '_SIGN_IN', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1493, '_SOCIALCONNECTKO', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1494, '_SOCIALCONNECTOK', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1495, '_TWO_USERS_LOGGED_WITH_SAME_USERNAME', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1496, '_UNKNOWNGOOGLERROR', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1497, '_UNKNOWNSOCIALERROR', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1498, '_UNLOGGED', 'login', '', 0, '[[regtime]]', '[[regtime]]'),
(1499, '_ADDCUSTOM', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1500, '_CHECKALL', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1501, '_DEFAULT_MY_NAME', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1502, '_FROM_CUSTOM', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1503, '_LEVELS', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1504, '_MODMODULE', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1505, '_MY_NAME', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1506, '_ORDER', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1507, '_SYMBOL', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1508, '_SYMBOL_TITLE', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1509, '_TB_CM_CAPTION', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1510, '_TB_CM_SUMMARY', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1511, '_TB_FREE_MANMODULE_CAPTION', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1512, '_TB_MANMENU_CAPTION', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1513, '_TB_MANMENU_SUMMARY', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1514, '_TB_MANMODULE_CAPTION', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1515, '_TB_MANMODULE_SUMMARY', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1516, '_TITLE_ADDCUSTOM', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1517, '_TITLE_GRABMODULE', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1518, '_TITLE_MANMENU', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1519, '_TITLE_MENUVOICE', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1520, '_TITLE_MODULE', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1521, '_UNCHECKALL', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1522, '_YOURE_IMPORTING', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1523, '_YOURE_WORKING_ON_MODULE', 'manmenu', '', 0, '[[regtime]]', '[[regtime]]'),
(1524, '_ADMIN_CONFIGURATION', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1525, '_ADMIN_MANAGER', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1526, '_ADMIN_RULES', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1527, '_ASSOCIATE_USER', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1528, '_BLIND_MAIN_MENU', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1529, '_BLIND_MENU_MODULES', 'menu', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(1530, '_CERTIFICATE', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1531, '_COMMUNICATION_MAN', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1532, '_MANAGEMENT_COMMUNICATION', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1533, '_CATEGORIES', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1534, '_MAIL_CONFIG', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1535, '_DOMAIN_CONFIG', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1536, '_CONFIGURATION', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1537, '_CONFIG_ELEARNING', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1538, '_CONFIG_SYS', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1539, '_CUSTOMFIELD_MANAGER', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1540, '_DASHBOARD', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1541, '_DASHBOARD_CONFIGURATION', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1542, '_EVENTMANAGER', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1543, '_EVENTS', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1544, '_FIELD_MANAGER', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1545, '_FIRST_LINE_framework', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1546, '_FIRST_LINE_lms', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1547, '_IOTASK', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1548, '_JUMP_TO_PLATFORM', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1549, '_LANG', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1550, '_LISTUSER', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1551, '_MANAGEMENT_COURSE', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1552, '_MANAGEMENT_RESERVATION', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1553, '_MAN_CERTIFICATE', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1554, '_META_CERTIFICATE', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1555, '_MIDDLE_AREA', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1556, '_MODULE_NAME', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1557, '_NEWS_INTERNAL', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1558, '_PLAYERTEMPLATE', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1559, '_PLUGIN_MANAGER', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1560, '_PRIVACYPOLICIES', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1561, '_PUBLIC_ADMIN_MANAGER', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1562, '_PUBLIC_ADMIN_RULES', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1563, '_QUESTCATEGORY', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1564, '_QUEST_CATEGORY', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1565, '_REPORT_CERTIFICATE', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1566, '_RESERVATION', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1567, '_SUBSCRIBE_USER_TO_COURSE', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1568, '_TRASV_MANAGMENT', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1569, '_USER_MANAGMENT', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1570, '_WEBPAGES', 'menu', '', 0, '[[regtime]]', '[[regtime]]'),
(1571, '_COURSE_SEARCH_BAR', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1572, '_SEARCH_COURSE', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1573, 'Area social', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1574, 'Area studenti', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1575, 'Collaborative Area', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1576, 'Gestione', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1577, 'Stat Area', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1578, 'Statistiche', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1579, 'Student Area', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1580, 'Teacher Area', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1581, '_ADVICE', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1582, '_COURSECHART', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1583, '_COURSEREPORT', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1584, '_COURSESTATS', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1585, '_EPORTFOLIO', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1586, '_GRADEBOOK', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1587, '_GROUPS', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1588, '_HTMLFRONT', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1589, '_INFCOURSE', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1590, '_LIGHT_REPO', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1591, '_ORGANIZATION', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1592, '_PROFILE', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1593, '_PROJECT', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1594, '_QUEST_BANK', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1595, '_RESERVATION', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1596, '_STAT', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1597, '_STATCOURSE', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1598, '_STATUSER', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1599, '_STORAGE', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1600, '_TELESKILL_ROOM', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1601, '_WIKI', 'menu_course', '', 0, '[[regtime]]', '[[regtime]]'),
(1602, '_AUTHORING', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1603, '_BLIND_MENU_LAT', 'menu_over', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(1604, '_BLIND_YOUR_INFO', 'menu_over', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(1605, '_CERTIFICATE_DOWNLOAD', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1606, '_COMMUNITY', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]');
INSERT INTO `core_lang_text` VALUES
(1607, '_COURSE_AUTOREGISTRATION', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1608, '_GO_TO_FRAMEWORK', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1609, '_HELPDESK', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1610, '_LIBRARY', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1611, '_MENUCOURSE', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1612, '_MENUGEN', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1613, '_MYCOMPETENCES', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1614, '_MYCOURSES', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1615, '_MY_AREA', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1616, '_MY_CERTIFICATE', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1617, '_PUBLIC_ADMIN_AREA', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1618, '_PUBLIC_CERTIFICATE_ADMIN', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1619, '_PUBLIC_COURSE_ADMIN', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1620, '_PUBLIC_FORUM', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1621, '_PUBLIC_NEWSLETTER_ADMIN', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1622, '_PUBLIC_REPORT_ADMIN', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1623, '_PUBLIC_SUBSCRIBE_ADMIN', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1624, '_PUBLIC_USER_ADMIN', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1625, '_SUPPORT_FORUM', 'menu_over', '', 0, '[[regtime]]', '[[regtime]]'),
(1626, '_ATTACH_TITLE', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1627, '_CUSTOMER_HELP_DISCLAIMER', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1628, '_CUSTOMER_HELP_DISCLAIMER_TITLE', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1629, '_FILTER_MESSAGE_FOR', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1630, '_HIGH', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1631, '_INBOX', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1632, '_LOW', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1633, '_MIME', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1634, '_MUST_INS_SUBJECT', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1635, '_NORMAL', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1636, '_OUTBOX', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1637, '_PRIORITY', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1638, '_REFRESH', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1639, '_SEND_MESSAGE_COPY', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1640, '_TITLE_READ', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1641, '_VERYHIGH', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1642, '_VERYLOW', 'message', '', 0, '[[regtime]]', '[[regtime]]'),
(1643, '_BLOCKS', 'middlearea', '', 0, '[[regtime]]', '[[regtime]]'),
(1644, '_CHOOSE_WHO_CAN_SEE', 'middlearea', '', 0, '[[regtime]]', '[[regtime]]'),
(1645, '_COMPLETE_USER_PROFILE', 'middlearea', '', 0, '[[regtime]]', '[[regtime]]'),
(1646, '_ENABLE_AREA', 'middlearea', '', 0, '[[regtime]]', '[[regtime]]'),
(1647, '_HOME', 'middlearea', '', 0, '[[regtime]]', '[[regtime]]'),
(1648, '_MIDDLE_AREA', 'middlearea', '', 0, '[[regtime]]', '[[regtime]]'),
(1649, '_SIMPLE_USER_PROFILE', 'middlearea', '', 0, '[[regtime]]', '[[regtime]]'),
(1650, '_ADD_NOTES', 'notes', '', 0, '[[regtime]]', '[[regtime]]'),
(1651, '_MORET', 'notes', '', 0, '[[regtime]]', '[[regtime]]'),
(1652, '_NOTES', 'notes', '', 0, '[[regtime]]', '[[regtime]]'),
(1653, '_ALT_BRANCH_INTER', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1654, '_ALT_EMPTY', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1655, '_ALT_VERT_INTER', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1656, '_ATTEMPT', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1657, '_ATTEMPTS', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1658, '_AUTOPLAY', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1659, '_CONFIRM_EXIT', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1660, '_HIDETREE', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1661, '_IGNORE_SCORE', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1662, '_LOCKED', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1663, '_NO_TEST_STATS', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1664, '_OBJECTIVE', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1665, '_ORGANIZATION', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1666, '_ORGISTERMINATOR', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1667, '_ORGLOCKEDTITLE', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1668, '_ORGMILESTONE', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1669, '_ORGMILESTONE_END', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1670, '_ORGMILESTONE_START', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1671, '_ORGPLAYTITLE', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1672, '_ORGROOTNAME', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1673, '_ORG_ACCESS', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1674, '_PROFILE', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1675, '_PUBLISH_FROM', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1676, '_PUBLISH_TO', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1677, '_REPOSELECTDESTINATION', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1678, '_RESOURCE', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1679, '_SHOW_INTERACTIONS', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1680, '_TIME', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1681, '_VIEWTREE', 'organization', '', 0, '[[regtime]]', '[[regtime]]'),
(1682, '_ASSIGNED_EXTRAFIELD', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1683, '_DIRECTORY', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1684, '_GROUPUSER_groupid', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1685, '_IMPORT_IGNORE', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1686, '_IMPORT_MAP', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1687, '_INSERTED_WAIT_FOR_ADMIN', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1688, '_ORGCHART_FOLDER_FIELD_ALT', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1689, '_ORGCHART_USER_FIELD', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1690, '_ORG_CHART', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1691, '_ORG_CHART_FIELD_DESCEND', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1692, '_ORG_CHART_FIELD_INHERIT', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1693, '_ORG_CHART_FIELD_WRITE', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1694, '_ORG_CHART_FIELD_WRITE_ABBR', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1695, '_ORG_CHART_IMPORT_CHARSET', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1696, '_ORG_CHART_IMPORT_FILE', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1697, '_ORG_CHART_IMPORT_HEADER', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1698, '_ORG_CHART_IMPORT_SEPARATOR', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1699, '_ORG_CHART_IMPORT_USERS', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1700, '_ORG_CHART_INHERIT', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1701, '_ORG_CHART_LIST_FIELDS', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1702, '_ROOT_RENAME', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1703, '_SHOW_SUSPENDED', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1704, '_USERID_DUPLICATE', 'organization_chart', '', 0, '[[regtime]]', '[[regtime]]'),
(1705, '_ASSOCIATEUSERTOGROUP', 'permission', '', 0, '[[regtime]]', '[[regtime]]'),
(1706, '_DELUSER_ORG_CHART', 'permission', '', 0, '[[regtime]]', '[[regtime]]'),
(1707, '_HOME', 'permission', '', 0, '[[regtime]]', '[[regtime]]'),
(1708, '_LESSON', 'permission', '', 0, '[[regtime]]', '[[regtime]]'),
(1709, '_PUBLIC', 'permission', '', 0, '[[regtime]]', '[[regtime]]'),
(1710, '_SEND_ALL', 'permission', '', 0, '[[regtime]]', '[[regtime]]'),
(1711, '_SEND_UPPER', 'permission', '', 0, '[[regtime]]', '[[regtime]]'),
(1712, '_UPPLOAD', 'permission', '', 0, '[[regtime]]', '[[regtime]]'),
(1713, '_LMS', 'platform', '', 0, '[[regtime]]', '[[regtime]]'),
(1714, '_ANSWER_NUMBER', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1715, '_ANSWER_TEXT', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1716, '_CAPTION_ANSWER', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1717, '_INSERT_POLL', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1718, '_NO_QUESTION_IN_POLL', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1719, '_POLL_ADDQUEST', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1720, '_POLL_ADD_FORM', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1721, '_POLL_ADD_ONE_ANSWER', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1722, '_POLL_AFTER_QUEST', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1723, '_POLL_ALREDY_VOTED', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1724, '_POLL_ANSWER_SUMMARY', 'poll', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(1725, '_POLL_BEGIN', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1726, '_POLL_CAPTION', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1727, '_POLL_COMPLETED', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1728, '_POLL_END_BACKTOLESSON', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1729, '_POLL_END_PAGE', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1730, '_POLL_FIRST_QUEST', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1731, '_POLL_LABEL_AFTER_QUEST', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1732, '_POLL_LAST_QUEST', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1733, '_POLL_PREV_PAGE', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1734, '_POLL_QUEST_ORDER', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1735, '_POLL_QUEST_TITLE', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1736, '_POLL_REMPOLL', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1737, '_POLL_SECTION', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1738, '_POLL_SUB_ONE_ANSWER', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1739, '_POLL_SUMMARY', 'poll', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(1740, '_QUEST', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1741, '_QUEST_ACRN_BREAK_PAGE', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1742, '_QUEST_ACRN_CHOICE', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1743, '_QUEST_ACRN_CHOICE_MULTIPLE', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1744, '_QUEST_ACRN_COURSE_VALUTATION', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1745, '_QUEST_ACRN_DOC_VALUTATION', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1746, '_QUEST_ACRN_EXTENDED_TEXT', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1747, '_QUEST_ACRN_TITLE', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1748, '_QUEST_ANSWER', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1749, '_QUEST_BREAK_PAGE', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1750, '_QUEST_CHOICE', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1751, '_QUEST_CHOICE_MULTIPLE', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1752, '_QUEST_CHOICE_MULTIPLE_NOTE', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1753, '_QUEST_CHOICE_NOTE', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1754, '_QUEST_COURSE_VALUTATION', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1755, '_QUEST_DOC_VALUTATION', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1756, '_QUEST_EXTENDED_TEXT', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1757, '_QUEST_TITLE', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1758, '_QUEST_TITLE_NOTE', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1759, '_SUMMARY_ANSWER', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1760, '_TEST_SECTION', 'poll', '', 0, '[[regtime]]', '[[regtime]]'),
(1761, '_ADD_ASSESSMENT', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1762, '_ADD_EFFECT', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1763, '_ADD_RULE', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1764, '_ALT_ADD_EFFECT', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1765, '_ASSIGN_ADMIN', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1766, '_ASSIGN_ADMIN_TITLE', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1767, '_ASSIGN_COURSE', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1768, '_ASSIGN_COURSE_TITLE', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1769, '_CAPTION_PREASSESSMENT', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1770, '_CAPTION_PREASSESSMENT_RULE', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1771, '_DO_NOTHING', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1772, '_RULES', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1773, '_RULE_ACTION', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1774, '_RULE_DEFAULT', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1775, '_RULE_OVERLAPPED', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1776, '_RULE_TEXT', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1777, '_SUMMARY_PREASSESSMENT_RULE', 'preassessment', '', 0, '[[regtime]]', '[[regtime]]'),
(1778, '_TEMPLATE', 'preferences', '', 0, '[[regtime]]', '[[regtime]]'),
(1779, '_PRIVACYPOLICIES', 'privacypolicies', '', 0, '[[regtime]]', '[[regtime]]'),
(1780, '_ACCESS_COUNT', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1781, '_ACCESS_TIME', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1782, '_ACTIVITY_OF', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1783, '_AVATAR_PHOTO_INSTRUCTION', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1784, '_CAREER', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1785, '_CERT_RELESABLE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1786, '_CHANGEPASSWORD', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1787, '_CHANGEPOLICY', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1788, '_COMMUNITY', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1789, '_COMPETENCE_NAME', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1790, '_COMPETENCE_SCORE_GOT', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1791, '_CONTACTS', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1792, '_COURSE_AS', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1793, '_COURSE_AS_MENTOR', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1794, '_COURSE_AS_TEACHER', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1795, '_COURSE_AS_TUTOR', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1796, '_COURSE_END', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1797, '_COURSE_EXPIRING', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1798, '_DELETED_USER_LIST', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1799, '_DELETION_DATE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1800, '_FIELD_VALUE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1801, '_FIRSTNAME_DELETER', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1802, '_FIRST_ACCESS', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1803, '_FORUM_MESSAGE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1804, '_GOTO_BLOG', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1805, '_GOTO_BLOG_TITLE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1806, '_GO_TO_PROFILE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1807, '_IDST_DELETED_USER', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1808, '_LASTNAME_DELETER', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1809, '_LAST_PROFILE_VIEW', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1810, '_MESSAGE_TEXT', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1811, '_NEWPWDVALID', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1812, '_NEW_VISIT', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1813, '_NOAVATAR', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1814, '_NO_AUDIO_FOUND', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1815, '_NO_IMAGE_FOUND', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1816, '_NO_OTHER_FOUND', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1817, '_NO_PROFILE_VIEW', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1818, '_NO_VIDEO_FOUND', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1819, '_OLDPASSWRONG', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1820, '_OLD_PWD', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1821, '_OTHER_POLICY', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1822, '_PFL_POLICY_NOONE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1823, '_PFL_POLICY_TEACHER', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1824, '_POLICY_ASSIGNED', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1825, '_PRIVATE_MESSAGE_FROM', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1826, '_PROFILE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1827, '_REGISTER_DATE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1828, '_REG_PASS_MUST_DIFF', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1829, '_SCORE_FINAL', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1830, '_SCORE_INIT', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1831, '_SHARED_FILE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1832, '_SHOWME_ONLINE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1833, '_TEACHER_CURRICULUM', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1834, '_TEACHER_PROFILE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1835, '_TEACHER_PUBLICATIONS', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1836, '_TITLE_CHANGE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1837, '_TOTAL_COURSE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1838, '_UNLIMITED_QUOTA', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1839, '_UP_OFFLINE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1840, '_USERCOMPETENCES_CAPTION', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1841, '_USERCOURSE_CAPTION', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1842, '_USERCOURSE_STATS_SUMMARY', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1843, '_USERCOURSE_STATS_TITLE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1844, '_USERCOURSE_STATUS', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1845, '_USERFORUMPARAM', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1846, '_USERID_DELETER', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1847, '_USEROFFLINE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1848, '_USERONLINE', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1849, '_USERPARAM', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1850, '_USERPROFILE_SUMMARY', 'profile', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(1851, '_USER_AUDIO', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1852, '_USER_OTHER', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1853, '_USER_QUOTA', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1854, '_USER_STATUS', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1855, '_USER_VIDEO', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1856, '_USER_VIDEOS', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1857, '_WELCOME', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1858, '_WRITE_ASK_A_FRIEND', 'profile', '', 0, '[[regtime]]', '[[regtime]]'),
(1859, '_MODPROJECTADMIN', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1860, '_MYPRJ', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1861, '_NEW_PROJECT', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1862, '_NOTHINGTOSEE', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1863, '_PADMINS', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1864, '_PGROUP', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1865, '_POPTIONS', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1866, '_PRJFILES', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1867, '_PRJNOTITLE', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1868, '_PRJNOVALIDGROUP', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1869, '_PRJPROGTOT', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1870, '_PRJTASKS', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1871, '_PRJTODO', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1872, '_PROJECT_MANAGER', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1873, '_PROJECT_SUMMARY', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1874, '_PSFILES', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1875, '_PSMSG', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1876, '_PSNEWS', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1877, '_PSTASKS', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1878, '_PSTODO', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1879, '_PTITLE', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1880, '_TASKDESC', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1881, '_TASKNAME', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1882, '_TASKPROGRESS', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1883, '_YOUONLY', 'project', '', 0, '[[regtime]]', '[[regtime]]'),
(1884, '_ACTION', 'public_admin_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1885, '_ADMIN_SPECIAL_SETTING', 'public_admin_manager', '', 0, '[[regtime]]', '[[regtime]]'),
(1886, '_CATEGORY_IN_USE', 'questcategory', '', 0, '[[regtime]]', '[[regtime]]'),
(1887, '_TITLE_QCAT', 'questcategory', '', 0, '[[regtime]]', '[[regtime]]'),
(1888, '_ACCEPT', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1889, '_CHANGELANG', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1890, '_CHOOSE_NEW_PASSWORD', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1891, '_ERR_DUPLICATE_MAIL', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1892, '_ERR_DUPLICATE_USER', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1893, '_ERR_INVALID_MAIL', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1894, '_ERR_INVALID_USER', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1895, '_ERR_PASSWORD_MIN_LENGTH', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1896, '_ERR_PASSWORD_MUSTBE_ALPHA', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1897, '_ERR_PASSWORD_MUSTBE_TEXT', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1898, '_ERR_PASSWORD_NO_MATCH', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1899, '_ERR_POLICY_NOT_CHECKED', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1900, '_ERR_PWD_OLD', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1901, '_ERR_PWD_SAME_OLD', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1902, '_FIRST_ACCESS', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1903, '_FORCE_CHANGE', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1904, '_GOTO_LOGIN', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1905, '_GROUPS_FIELDS', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1906, '_IMGSECTION', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1907, '_INEXISTENT_USER', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1908, '_INVALID_CODE', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1909, '_INVALID_RANDOM_CODE', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1910, '_LOGIN', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1911, '_LOST_INSTRUCTION_PWD', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1912, '_LOST_INSTRUCTION_USER', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1913, '_LOST_PWD_MAILTEXT', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1914, '_LOST_PWD_TITLE', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1915, '_LOST_TITLE_PWD', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1916, '_LOST_TITLE_USER', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1917, '_LOST_USERID_MAILTEXT', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1918, '_LOST_USERID_TITLE', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1919, '_MAIL_OBJECT', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1920, '_MAIL_OBJECT_SELF', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1921, '_MAIL_SEND_SUCCESSFUL', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1922, '_MAIL_SEND_SUCCESSFUL_PWD', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1923, '_NEWPWDVALID', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1924, '_NEW_PASSWORD', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1925, '_NOTE', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1926, '_OLD_PWD', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1927, '_PASSWORD_MUST_CONTAIN', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1928, '_PASSWORD_TOO_SHORT', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1929, '_REG_CONFIRM_FAILED', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1930, '_REG_ELAPSEDREQUEST', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1931, '_REG_HOUR_REQUEST_LIMIT', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1932, '_REG_MAIL_TEXT', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1933, '_REG_MAIL_TEXT_SELF', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1934, '_REG_MANDATORY', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1935, '_REG_NOTE', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1936, '_REG_NOT_ACTIVE', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1937, '_REG_PASS_ALFANUMERIC', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1938, '_REG_PASS_MIN_CHAR', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1939, '_REG_PASS_MIN_DIGITS', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1940, '_REG_PASS_MIN_LOWER', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1941, '_REG_PASS_MIN_NONALPHANUM', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1942, '_REG_PASS_MIN_UPPER', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1943, '_REG_PASS_MUST_BE_ALPNUM', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1944, '_REG_PASS_MUST_DIFF', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1945, '_PASS_DIFFERENT_USERNAME', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1946, '_REG_PRESONAL_CODE', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1947, '_REG_PRIVACY_ACCEPT', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1948, '_REG_PASS_MUST_DIFF_1', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1949, '_REG_PASS_MIN_CHAR_1', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1950, '_REG_PASS_MIN_DIGITS_1', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1951, '_REG_PASS_MIN_LOWER_1', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1952, '_REG_PASS_MIN_NONALPHANUM_1', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1953, '_REG_PASS_MIN_UPPER_1', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1954, '_REG_PRIVACY_POLICY', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1955, '_REG_PRIVACY_POLICY_TILTE', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1956, '_REG_REMEMBER_PRIVACY', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1957, '_REG_SUCCESS', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1958, '_REG_SUCCESS_SELF', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1959, '_REG_USERID_DEF', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1960, '_REG_WAIT_FOR_ADMIN_OK', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1961, '_REG_YOUR_ABI_TO_ACCESS', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1962, '_RETYPE_PASSWORD', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1963, '_SELECT_GROUP', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1964, '_SELECT_GROUP_SUMMARY', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1965, '_SEND_LINK_RESET_PASSWORD', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1966, '_SOME_MANDATORY_EMPTY', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1967, '_WHYCHANGEPWD', 'register', '', 0, '[[regtime]]', '[[regtime]]'),
(1968, 'aggregate_report', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1969, 'courses_report', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1970, 'course_report', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1971, 'ORG_CHART_SUBDIVISION', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1972, 'REPORT_SHOW_RESULTS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1973, 'user_report', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1974, '_AGGREGATE_ON', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1975, '_BACK_TO_LIST', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1976, '_CHOOSE_TIME', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1977, '_CHOOSE_USER_FOR_REPORT', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1978, '_COMPETENCESFILTER_TITLE', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1979, '_COMPETENCESFILTER_TITLE_DESC', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1980, '_COMPETENCES_DROPDOWN_NULL_SELECT', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1981, '_COURSES_DROPDOWN_NULL_SELECT', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1982, '_COURSES_FILTER_END_DATE', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1983, '_COURSES_FILTER_INSCRIPTION_DATE', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1984, '_COURSES_FILTER_SCORE_COURSE', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1985, '_COURSES_FILTER_SCORE_INIT', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1986, '_COURSES_FILTER_SESSION_NUMBER', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1987, '_COURSES_SELECTION_TITLE', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1988, '_COURSE_COMPLETED', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1989, '_COURSE_FIELDS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1990, '_COURSE_FIELDS_INFO', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1991, '_COURSE_STARTED', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1992, '_CREATION_DATE', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1993, '_CRON_REPORT_MAIL_BODY', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1994, '_CRON_REPORT_MAIL_SUBJECT', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1995, '_CURRENT_SELECTION', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1996, '_CUSTOM_BELT', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1997, '_DATE_COURSE_COMPLETED', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1998, '_DATE_INSCR', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(1999, '_DATE_UNTIL_COURSE_END', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2000, '_DAY_FROM_SUBSCRIPTION', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2001, '_DAY_UNTIL_COURSE_END', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2002, '_EXPORT_REPORT_DETAIL_CSV', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2003, '_EXPORT_REPORT_DETAIL_XLS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2004, '_FILTER_ALL_CONDS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2005, '_FILTER_ONE_COND', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2006, '_FILTER_RESET', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2007, '_INSCR', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2008, '_LAST_MONTH', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2009, '_LAST_SIX_MONTH', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2010, '_LAST_THREE_MONTH', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2011, '_LAST_WEEK', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2012, '_LAST_YEAR', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2013, '_LO_COL_FIRSTATT', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2014, '_LO_COL_LASTATT', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2015, '_LO_COL_MILESTONE', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2016, '_LO_COL_TYPE', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2017, '_MAIL_BODY', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2018, '_MUSTBEGIN', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2019, '_NOACTIVE', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2020, '_NO_USER_FOUND', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2021, '_NULL_COURSE_SELECTION', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2022, '_NULL_REPORT_RESULT', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2023, '_NULL_SELECTION', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2024, '_NUM', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2025, '_PERC', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2026, '_RA_CAT_COURSECATS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2027, '_RA_CAT_TIME', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2028, '_RCS_CAT_COURSE_VAL', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2029, '_RCS_CAT_DOC_VAL', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2030, '_RCS_CAT_USER', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2031, '_RC_CAPTION', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2032, '_REPORT_COLUMNS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2033, '_REPORT_COURSE_CONDITIONS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2034, '_REPORT_COURSE_SELECTION', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2035, '_REPORT_DAILY', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2036, '_REPORT_FOR_ALL', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2037, '_REPORT_MOD_COLUMNS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2038, '_REPORT_MOD_ROWS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2039, '_REPORT_MONTHLY', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2040, '_REPORT_SEL_COLUMNS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2041, '_REPORT_SEL_ROWS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2042, '_REPORT_USER_TITLE_TIMEBELT', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2043, '_REPORT_USER_TITLE_TIMEBELT_DESC', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2044, '_REPORT_WEEKLY', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2045, '_RG_SUMMAMRY_MANAGMENT', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2046, '_RU_CAPTION', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2047, '_RU_CAT_COMMUNICATIONS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2048, '_RU_CAT_COMPETENCES', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2049, '_RU_CAT_COURSES', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2050, '_RU_CAT_DELAY', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2051, '_RU_CAT_GAMES', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2052, '_RU_CAT_LO', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2053, '_RU_CAT_TESTSTAT', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2054, '_RU_LO_MILESTONES', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2055, '_RU_LO_TYPES', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2056, '_SAVE_AND_BACK_TO_LIST', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2057, '_SAVE_BACK', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2058, '_SAVE_SCHED_NAME', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2059, '_SAVE_SHOW', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2060, '_SCHED_TEXT_WEEK', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2061, '_SELECT_LO_OPTIONS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2062, '_SELECT_REPORT_CATEGORY', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2063, '_SELECT_THE_DATA_COL_NEEDED', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2064, '_SEL_COURSES', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2065, '_SEND_MAIL', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2066, '_SHOWED_COLUMNS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2067, '_SHOW_NOSAVE', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2068, '_STATS_FIELDS_INFO', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2069, '_TAB_REP_CREATOR', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2070, '_TAB_REP_PUBLIC', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2071, '_TH_COURSELABEL', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2072, '_TH_COURSEPATH', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2073, '_TH_ESTIMATED_TIME', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2074, '_TH_USER_COURSE_SCORE', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2075, '_TH_USER_INSCRIPTION_DATE', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2076, '_TH_USER_NUMBER_SESSION', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2077, '_TH_USER_START_SCORE', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2078, '_TIME_BELT', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2079, '_TIME_BELT_2', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2080, '_TIME_PERIOD_FILTER', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2081, '_TOTAL_SESSION', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2082, '_USER_CUSTOM_FIELDS', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2083, '_WARNING_REPORT', 'report', '', 0, '[[regtime]]', '[[regtime]]'),
(2084, '_ADD_USER', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2085, '_ALT_ADD_USER', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2086, '_AREYOUSURE_ADD_SUBSCRIPTION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2087, '_AREYOUSURE_DEL_SUBSCRIPTION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2088, '_AVAILABLE_PLACES', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2089, '_BODY_DELSUBSCRIPTION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2090, '_CANCEL_REGISTRATION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2091, '_CATEGORY_CAPTION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2092, '_CATEGORY_GESTION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2093, '_CATEGORY_MAX_SUBSCRIPTION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2094, '_CHOOSE_SUBSCRIBE', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2095, '_CONFIRM_DATA', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2096, '_DEADLINE', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2097, '_DEL_EVENT_REGISTRATION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2098, '_DEL_SUBSCRIPTION_TITLE', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2099, '_EVENT_CAPTION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2100, '_FROM_TIME', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2101, '_LOCATION_GESTION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2102, '_MAX_SUBSCRIPTION_FOR_CATEGORY', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2103, '_MAX_USER', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2104, '_NO_RESERVATION_FOUND', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2105, '_NO_USERS_FOUND', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2106, '_NUMBER_SUBSCRIBED', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2107, '_REGISTRATION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2108, '_RESERVATION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2109, '_RESERVATION_CAPTION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2110, '_RESERVATION_EVENTS', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2111, '_RESERVATION_MAIL_SEND', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2112, '_RESERVATION_MY_EVENTS', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2113, '_RESERVATION_PAST_EVENTS', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2114, '_RESERVATION_PROFILE_MODIFY', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2115, '_RESERVATION_SUBSCRIBED_USER', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2116, '_RESERVATION_SUMMARY', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2117, '_ROOM_FULL', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2118, '_SAVE', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2119, '_SET_ROOM_VIEW_PERM', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2120, '_SUBJECT_DELSUBSCRIPTION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2121, '_SUBSCRIBE_EVENT', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2122, '_SWITCH_REGISTRATION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2123, '_TO_TIME', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2124, '_UNDEFINITED', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2125, '_UNLIMITED_SUBSCRIPTION', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2126, '_VIEW_EVENT_USER', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2127, '_VIEW_USER_SUBSCRIBED', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2128, '_WRONG_DATE', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2129, '_WRONG_TIME', 'reservation', '', 0, '[[regtime]]', '[[regtime]]'),
(2130, '_BACK_TOLIST', 'scorm', '', 0, '[[regtime]]', '[[regtime]]'),
(2131, '_CONTENTPACKAGE', 'scorm', '', 0, '[[regtime]]', '[[regtime]]'),
(2132, '_FILEUNSPECIFIED', 'scorm', '', 0, '[[regtime]]', '[[regtime]]'),
(2133, '_SCORMIMGSECTION', 'scorm', '', 0, '[[regtime]]', '[[regtime]]'),
(2134, '_SCORMIMPORTRESOURCES', 'scorm', '', 0, '[[regtime]]', '[[regtime]]'),
(2135, '_SCORMLOAD', 'scorm', '', 0, '[[regtime]]', '[[regtime]]'),
(2136, '_SCORMSECTIONNAME', 'scorm', '', 0, '[[regtime]]', '[[regtime]]'),
(2137, '_SCORM_ADD_FORM', 'scorm', '', 0, '[[regtime]]', '[[regtime]]'),
(2138, '_MANUAL_SEL', 'simplesel', '', 0, '[[regtime]]', '[[regtime]]'),
(2139, '_MSG_HASMANUAL_1', 'simplesel', '', 0, '[[regtime]]', '[[regtime]]'),
(2140, '_MSG_HASMANUAL_2', 'simplesel', '', 0, '[[regtime]]', '[[regtime]]'),
(2141, '_SIMPLESEL_SUMMARY', 'simplesel', '', 0, '[[regtime]]', '[[regtime]]'),
(2142, '_SIMPLESEL_TITLE', 'simplesel', '', 0, '[[regtime]]', '[[regtime]]'),
(2143, '_ALERT_TEXT_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2144, '_APPROVED_SUBSCRIBED_TEXT_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2145, '_APPROVED_USER_TEXT_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2146, '_DELETED_USER_TEXT_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2147, '_EVENT_CHANGE_NODE_USER_SBJ_SMS', 'sms', '', 0, '[[regtime]]', '[[regtime]]'),
(2148, '_EVENT_COURSE_EVENT_SUSPENDED_USER_TEXT_SMS', 'sms', '', 0, '[[regtime]]', '[[regtime]]'),
(2149, '_EVENT_SUSPENDED_USER_TEXT_SMS', 'sms', '', 0, '[[regtime]]', '[[regtime]]'),
(2150, '_MODIFIED_USER_TEXT_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2151, '_NEW_FORUM_BODY_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2152, '_NEW_FORUM_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2153, '_NEW_MESSAGE_INSERT_IN_THREAD_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]');
INSERT INTO `core_lang_text` VALUES
(2154, '_NEW_THREAD_INSERT_IN_FORUM_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2155, '_NEW_USER_SUBSCRIBED_TEXT_SMS', 'sms', '', 0, '[[regtime]]', '[[regtime]]'),
(2156, '_NEW_USER_SUBSCRIBED_TEXT_SMS_MODERATORS', 'sms', '', 0, '[[regtime]]', '[[regtime]]'),
(2157, '_PASSWORD_CHANGED_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2158, '_REGISTERED_USER_TEXT_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2159, '_TO_APPROVE_GROUP_USER_TEXT_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2160, '_TO_APPROVE_USER_TEXT_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2161, '_TO_NEW_USER_TEXT_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2162, '_WAITING_USER_TEXT_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2163, '_YOU_RECIVE_MSG_TEXT_SMS', 'sms', 'sms', 0, '[[regtime]]', '[[regtime]]'),
(2164, '_YOU_RECIVE_MSG_TEXT_SMS_COURSE', 'sms', '', 0, '[[regtime]]', '[[regtime]]'),
(2165, '_EVENT_CLASSROOM_COURSE_DATE_EVENT_UNSUBSCRIBE_USER_TEXT_SMS', 'sms', '', 0, '[[regtime]]', '[[regtime]]'),
(2166, '_EVENT_EDITION_COURSE_EVENT_UNSUBSCRIBE_USER_TEXT_SMS', 'sms', '', 0, '[[regtime]]', '[[regtime]]'),
(2167, '_EVENT_COURSE_EVENT_UNSUBSCRIBE_USER_TEXT_SMS', 'sms', '', 0, '[[regtime]]', '[[regtime]]'),
(2168, '_CONNECTED_ACCOUNTS', 'social', '', 0, '[[regtime]]', '[[regtime]]'),
(2169, '_CONNECT_YOUR_ACCOUNT_WITH', 'social', '', 0, '[[regtime]]', '[[regtime]]'),
(2170, 'ab-initio', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2171, 'attempted', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2172, 'completed', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2173, 'failed', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2174, 'incomplete', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2175, 'not attempted', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2176, 'not_attempted', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2177, 'passed', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2178, 'PREV_B_', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2179, '_ACCESSES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2180, '_ACCESS_DETAIL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2181, '_ACCESS_IN_DETAIL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2182, '_ACCESS_TOTAL_TIME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2183, '_ACTIVATE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2184, '_ACTIVE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2185, '_ACTIVE_TAB', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2186, '_ACTIVITY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2187, '_ADD', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2188, '_ADD_TAGS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2189, '_ADMINISTRATOR', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2190, '_ADMINISTRATORS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2191, '_ADVANCED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2192, '_ADVANCED_SEARCH', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2193, '_ALL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2194, '_ALLOW_FULL_EDIT_PROFILE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2195, '_ALL_CATEGORIES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2196, '_ALL_COURSES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2197, '_ALL_PAGES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2198, '_ALT_CHECK', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2199, '_ALT_LESS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2200, '_ALT_MORE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2201, '_ALT_ROOT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2202, '_ANSWER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2203, '_APPROVE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2204, '_APPROVE_WAITING_USER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2205, '_AREYOUSURE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2206, '_ASSESSMENT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2207, '_ASSIGN', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2208, '_ASSIGN_ADMIN', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2209, '_ASSIGN_USERS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2210, '_ATTACHMENT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2211, '_ATTENDANCE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2212, '_AUTHOR', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2213, '_AUTOCREATE_CATEGORIES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2214, '_AUTODETECT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2215, '_AUTO_SUBSCRIPTION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2216, '_AVATAR', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2217, '_AVERANGE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2218, '_BACK', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2219, '_BACK_TO_LABEL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2220, '_BASIC_SEARCH', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2221, '_BBB', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2222, '_BY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2223, '_CALENDAR', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2224, '_CANCEL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2225, '_CAREER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2226, '_CATALOGUE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2227, '_CATALOGUE2', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2228, '_CATALOGUE_NEW', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2229, '_CATEGORIZATION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2230, '_CATEGORIZE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2231, '_CATEGORY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2232, '_CHAPTERS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2233, '_CHAT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2234, '_CLASSROOM', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2235, '_CLOSE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2236, '_CODE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2237, '_COLLAPSE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2238, '_COMMENTS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2239, '_COMMUNICATIONS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2240, '_COMMUNITY_BLOG', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2241, '_COMPANY_BLOG', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2242, '_COMPETENCE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2243, '_COMPETENCES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2244, '_COMPLETED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2245, '_CONFIRM', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2246, '_CONNECT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2247, '_CONNECTION_ERROR', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2248, '_CONTAINS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2249, '_CONTENTS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2250, '_CONTENT_FILE_MANAGER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2251, '_CONTENT_LIBRARY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2252, '_CONTEST', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2253, '_CONTINUE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2254, '_CORE_VERSION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2255, '_COURSE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2256, '_COURSECATEGORY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2257, '_COURSEPATH', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2258, '_COURSES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2259, '_COURSE_CODE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2260, '_COURSE_LIST', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2261, '_COURSE_NAME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2262, '_COURSE_STATUS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2263, '_COURSE_S_FREE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2264, '_COURSE_VALID_TIME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2265, '_CREATE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2266, '_CREATE_NEW', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2267, '_CREATION_DATE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2268, '_CREDITS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2269, '_CURRENT_FILE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2270, '_DATE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2271, '_DATE_BEGIN', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2272, '_DATE_END', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2273, '_DATE_FIRST_ACCESS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2274, '_DATE_FORMAT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2275, '_DATE_LAST_ACCESS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2276, '_DATE_LAST_TEST', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2277, '_DAY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2278, '_DAYS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2279, '_DEACTIVATE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2280, '_DEFAULT_LANGUAGE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2281, '_DEL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2282, '_DELETE_FILE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2283, '_DEL_SELECTED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2284, '_DEMODERATE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2285, '_DENY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2286, '_DESCRIPTION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2287, '_DETAILS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2288, '_DIFFICULTY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2289, '_DIFFICULT_DIFFICULT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2290, '_DIFFICULT_EASY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2291, '_DIFFICULT_MEDIUM', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2292, '_DIFFICULT_VERYDIFFICULT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2293, '_DIFFICULT_VERYEASY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2294, '_DIMDIM', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2295, '_DISALLOW_EDIT_PROFILE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2296, '_DISCONNECT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2297, '_DOWN', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2298, '_DOWNLOAD', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2299, '_EDITION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2300, '_EDITIONS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2301, '_EDIT_SCORE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2302, '_EDIT_SETTINGS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2303, '_ELEARNING', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2304, '_EMAIL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2305, '_EMPTY_SELECTION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2306, '_END', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2307, '_ENDELEM', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2308, '_ENDS_WITH', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2309, '_ENROLLRULES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2310, '_ENROL_COUNT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2311, '_ENTER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2312, '_ENVIRONMENT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2313, '_EQUAL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2314, '_ERRORS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2315, '_ERROR_MOVEONDESCENDANT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2316, '_ERROR_NONAME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2317, '_ERROR_UPLOAD', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2318, '_EVENT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2319, '_EXECUTION_DATE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2320, '_EXPAND', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2321, '_EXPIRATION_DATE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2322, '_EXPORT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2323, '_EXPORT_CSV', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2324, '_EXPORT_HTML', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2325, '_EXPORT_XLS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2326, '_EXPORT_XML', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2327, '_FACEBOOK', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2328, '_FIELD_NAME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2329, '_FILE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2330, '_FILEMIME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2331, '_FILENAME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2332, '_FILESIZE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2333, '_FILE_MANAGER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2334, '_FILE_SURE_DEL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2335, '_FILTER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2336, '_FILTER_ALL_CONDS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2337, '_FILTER_APPLY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2338, '_FILTER_ONE_COND', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2339, '_FILTER_RESET', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2340, '_FILTER_TAB_CLOSE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2341, '_FILTER_TAB_OPEN', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2342, '_FINAL_SCORE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2343, '_FIRSTNAME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2344, '_FIX_SEQUENCE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2345, '_FORUM', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2346, '_FROM', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2347, '_FULLNAME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2348, '_FUNCTIONAL_ROLE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2349, '_GAP', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2350, '_GOOGLE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2351, '_GO_TO_HOME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2352, '_GRADIMENTO', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2353, '_GROUPS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2354, '_HEIGHT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2355, '_HELP', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2356, '_HIDDEN', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2357, '_HISTORY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2358, '_HOME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2359, '_HOME_TAB', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2360, '_HOURS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2361, '_IMAGE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2362, '_IMAGES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2363, '_IMPORT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2364, '_IMPORTANT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2365, '_IMPORT_FROM_XML', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2366, '_INHERIT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2367, '_INSERT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2368, '_INSTRUCTION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2369, '_INVALID_EXTENSION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2370, '_JUMP', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2371, '_JUMP_TO', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2372, '_LABEL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2373, '_LABELS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2374, '_LANGUAGE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2375, '_LASTNAME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2376, '_LBL_CODE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2377, '_LBL_SEND', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2378, '_LEARNING_OBJECTS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2379, '_LEVEL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2380, '_LIBRARY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2381, '_LINK', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2382, '_LINKEDIN', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2383, '_LOADED_FILE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2384, '_LOADING', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2385, '_LOCATION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2386, '_LOGOUT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2387, '_LOG_USERS_TO_FNCROLE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2388, '_LOG_USERS_TO_GROUP', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2389, '_MAKE_A_COPY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2390, '_MANAGE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2391, '_MANAGE_GROUPS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2392, '_MANDATORY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2393, '_MANUAL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2394, '_MAN_MENU', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2395, '_MARK_AS_IMPORTANT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2396, '_MAX_SCORE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2397, '_MEDIA_URL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2398, '_MEET', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2399, '_MESSAGES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2400, '_MIME_TYPE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2401, '_MINUTES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2402, '_MIN_SCORE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2403, '_MOD', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2404, '_MODERATE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2405, '_MOD_LIMIT_PROFILE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2406, '_MOD_SELECTED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2407, '_MOD_TITLE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2408, '_MONTH_01', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2409, '_MONTH_02', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2410, '_MONTH_03', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2411, '_MONTH_04', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2412, '_MONTH_05', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2413, '_MONTH_06', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2414, '_MONTH_07', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2415, '_MONTH_08', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2416, '_MONTH_09', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2417, '_MONTH_10', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2418, '_MONTH_11', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2419, '_MONTH_12', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2420, '_MORE_ACTIONS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2421, '_MORE_ATTACHMENT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2422, '_MORE_INFO', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2423, '_MOVE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2424, '_MOVE_DOWN', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2425, '_MOVE_UP', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2426, '_MSG_CHANGE_TEMPLATE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2427, '_NAME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2428, '_NEVER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2429, '_NEW', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2430, '_NEWS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2431, '_NEWSLETTER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2432, '_NEW_CATEGORY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2433, '_NEW_COURSE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2434, '_NEW_EVENT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2435, '_NEW_FILTER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2436, '_NEW_FOLDER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2437, '_NEW_USER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2438, '_NEXT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2439, '_NEXT_B', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2440, '_NEXT_COURSES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2441, '_NO', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2442, '_NONE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2443, '_NOTES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2444, '_NOTITLE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2445, '_NOT_ASSIGNED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2446, '_NOT_CONTAINS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2447, '_NOT_EQUAL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2448, '_NOT_SATISFIED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2449, '_NOT_STARTED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2450, '_NOT_TRANSLATED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2451, '_NO_ANSWER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2452, '_NO_BACK', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2453, '_NO_CATEGORY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2454, '_NO_CONTENT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2455, '_OF', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2456, '_OFF', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2457, '_ON', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2458, '_ONEMONTH', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2459, '_ONLY_ONCE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2460, '_OPEN', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2461, '_OPERATION_FAILURE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2462, '_OPERATION_SUCCESSFUL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2463, '_OPERATION_SUCCESSFULPWD', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2464, '_ORDER_BY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2465, '_ORD_ASC', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2466, '_ORD_ASC_TITLE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2467, '_ORD_DESC', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2468, '_ORD_DESC_ALT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2469, '_ORD_DESC_TITLE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2470, '_ORGCHART', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2471, '_ORGCHART_ADDNODE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2472, '_PAGES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2473, '_PARTICIPANT_DATA', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2474, '_PASSWORD', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2475, '_PERCENTAGE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2476, '_PLANNED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2477, '_PLAY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2478, '_PLAY_CHANCE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2479, '_PRECOMPILE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2480, '_PREREQUISITES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2481, '_PRESENCE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2482, '_PREV', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2483, '_PREVELEM', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2484, '_PREVIEW', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2485, '_PREV_B', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2486, '_PREV_STEP', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2487, '_PROFILE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2488, '_PROFILE_MODIFY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2489, '_PROFILE_MODIFY_URL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2490, '_PROGRESS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2491, '_PROGRESS_FAILED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2492, '_PROPERTIES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2493, '_PUBLIC_ADMIN_USER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2494, '_PUBLISH', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2495, '_QUESTION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2496, '_RE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2497, '_REACTIVATE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2498, '_READ', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2499, '_RECIPIENTS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2500, '_REDIRECT_URL_PROFILE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2501, '_REGISTER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2502, '_REGISTER_DATE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2503, '_REMEMBER_ME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2504, '_REMOVE_FROM_NODE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2505, '_REPLY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2506, '_REPOPASTELO', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2507, '_REPORT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2508, '_REQUIRED_SCORE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2509, '_RESET', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2510, '_RESET_POLICY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2511, '_ROLLBACK', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2512, '_ROOT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2513, '_ROW', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2514, '_SAVE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2515, '_SCHEDULE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2516, '_SCORE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2517, '_SCORE_LAST_TEST', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2518, '_SCRIPT_DESCRIPTION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2519, '_SCRIPT_ID', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2520, '_SCRIPT_NAME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2521, '_SCRIPT_VERSION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2522, '_SEARCH', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2523, '_SECONDS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2524, '_SELECT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2525, '_SELECTED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2526, '_SELECT_ALL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2527, '_SELECT_LIBRARY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2528, '_SELECT_VIDEO_TYPE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2529, '_SEND', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2530, '_SENDER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2531, '_SEND_CC', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2532, '_SEND_TO', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2533, '_SET', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2534, '_SET_AS_DEFAULT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2535, '_SHORTDESC', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2536, '_SHOW', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2537, '_SHOW_RESULTS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2538, '_SHOW_STATISTICS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2539, '_SIGNATURE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2540, '_SORT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2541, '_STANDINGS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2542, '_START', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2543, '_STARTED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2544, '_STARTS_WITH', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2545, '_START_DATE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2546, '_START_PAGE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2547, '_START_TIME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2548, '_STATISTICS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2549, '_STATUS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2550, '_SUBJECT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2551, '_SUBJECT_NAME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2552, '_SUBSCRIBE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2553, '_SUBSCRIBED_BY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2554, '_SUBSCRIBE_COURSE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2555, '_SUSPEND', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2556, '_SUSPENDED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2557, '_TABS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2558, '_TAGS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2559, '_TELESKILL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2560, '_TEXTOF', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2561, '_TIMEPERIODS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2562, '_TIME_PERIODS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2563, '_TITLE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2564, '_TO', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2565, '_TOTAL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2566, '_TOTAL_HOURS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2567, '_TOTAL_TIME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2568, '_TRANSACTION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2569, '_TWITTER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2570, '_TYPE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2571, '_TYPOLOGY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2572, '_UNASSIGN', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2573, '_UNDO', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2574, '_UNLIMITED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2575, '_UNPUBLISH', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2576, '_UNREAD', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2577, '_UNSELECT_ALL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2578, '_UNTIL_COMPLETED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2579, '_UP', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2580, '_UPLOAD', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2581, '_URL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2582, '_USER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2583, '_USERNAME', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2584, '_USERS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2585, '_USER_ALREADY_EXISTS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2586, '_USER_RELEASE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2587, '_USER_STATUS_BEGIN', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2588, '_USER_STATUS_CANCELLED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2589, '_USER_STATUS_CONFIRMED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2590, '_USER_STATUS_END', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2591, '_USER_STATUS_ENTER', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2592, '_USER_STATUS_RESERVED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2593, '_USER_STATUS_SUBS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2594, '_USER_STATUS_SUSPEND', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2595, '_VERSION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2596, '_VIDEOCONFERENCE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2597, '_VIEW', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2598, '_VIEW_ALL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2599, '_VIEW_PERMISSION', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2600, '_WAITING', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2601, '_WAITING_USERS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2602, '_WARNING', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2603, '_WIDTH', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2604, '_YEAR', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2605, '_YES', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2606, '_ACTIONS', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2607, '_DEFAULT', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2608, '_USER_TAB', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2609, '_ROLE_TAB', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2610, '_ORG_TAB', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2611, '_GROUP_TAB', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2612, '_SHOW_INSTANCE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2613, '_SHOW_INSTANCE_ALL', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2614, '_SHOW_INSTANCE_ONLY', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2615, '_MULTIUSERSELECTOR_TITLE', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2616, '_SMTP_CONFIG_DISABLED', 'standard', '', 0, '[[regtime]]', '[[regtime]]'),
(2617, '_AT_HOUR', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2618, '_FOR_day', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2619, '_FOR_month', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2620, '_FOR_TITLE_day', 'statistic', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(2621, '_FOR_TITLE_month', 'statistic', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(2622, '_FOR_TITLE_week', 'statistic', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(2623, '_FOR_TITLE_year', 'statistic', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(2624, '_FOR_week', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2625, '_FOR_year', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2626, '_HOW_MUCH_TIME', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2627, '_LAST_ACTION_AT', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2628, '_LAST_OP', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2629, '_NUMBER_OF_OP', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2630, '_ORD_FOR_HM', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2631, '_ORD_FOR_NOP', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2632, '_ORD_FOR_SST', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2633, '_PAGE_VIEW', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2634, '_SESSION_STARTED', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2635, '_TIME_IN', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2636, '_TYPE_OF_OPERATION', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2637, '_USERS_LIST_CAPTION', 'statistic', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(2638, '_USERS_LIST_DETAILS_CAPTION', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2639, '_USERS_LIST_DETAILS_SUMMARY', 'statistic', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(2640, '_USERS_LIST_SUMMARY', 'statistic', 'accessibility', 0, '[[regtime]]', '[[regtime]]'),
(2641, '_USER_TOTAL_TIME', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2642, '_VIEW_SESSION_DETAILS', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2643, '_VIEW_SESSION_DETAILS_ALT', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2644, '_WEEK_DAY_0_SHORT', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2645, '_WEEK_DAY_1_SHORT', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2646, '_WEEK_DAY_2_SHORT', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2647, '_WEEK_DAY_3_SHORT', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2648, '_WEEK_DAY_4_SHORT', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2649, '_WEEK_DAY_5_SHORT', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2650, '_WEEK_DAY_6_SHORT', 'statistic', '', 0, '[[regtime]]', '[[regtime]]'),
(2651, '_FILTEREDITIONSELECTONEOPTION', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2652, '_FILTEREDITIONSELECTTITLE', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2653, '_FILTEROBJECTFINISHED', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2654, '_FILTERSTATUSSELECTONEOPTION', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2655, '_ORGPLAYTITLE', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2656, '_PROGRESS', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2657, '_SHOW_STATISTICS', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2658, '_STATFORUSER', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2659, '_STATISTIC', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2660, '_STATNOTRACKFORUSER', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2661, '_STATSFORITEM', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2662, '_STATSITEM', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2663, '_STATSUSERITEM', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2664, '_STATS_FULLNAME', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2665, '_STATS_USERS', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2666, '_VIEW_OPEN_QUEST', 'stats', '', 0, '[[regtime]]', '[[regtime]]'),
(2667, '_EXPORT_QUESTIONS', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2668, '_HELP', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2669, '_HOMEREPOROOTNAME', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2670, '_LOCKED', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2671, '_LONAME_faq', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2672, '_LONAME_glossary', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2673, '_LONAME_htmlpage', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2674, '_LONAME_item', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2675, '_LONAME_link', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2676, '_LONAME_poll', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2677, '_LONAME_scoitem', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2678, '_LONAME_scormorg', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2679, '_LONAME_test', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2680, '_NAME_REQUIRED', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2681, '_ORGFOLDERNAME', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2682, '_ORGISTERMINATOR', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2683, '_ORGLOCKEDTITLE', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2684, '_ORGPLAYTITLE', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2685, '_ORGROOTNAME', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2686, '_PUBREPOROOTNAME', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2687, '_REMEMBER_ME', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2688, '_RENAMEFOLDER', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2689, '_REPOCOPYLO', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2690, '_REPOCREATELO', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2691, '_REPOSELECTDESTINATION', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2692, '_RULES', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2693, '_SELECTLO', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2694, '_SELECTTEST', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2695, '_SELECT_VIDEO_TYPE', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2696, '_TARGETMOVEFOLDER', 'storage', '', 0, '[[regtime]]', '[[regtime]]'),
(2697, '_ABSENT', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2698, '_BEFORE_THIS_APPROVE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2699, '_CAPTION_SELECT_LEVELS', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2700, '_CHOOSE_SUBSCRIBE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2701, '_COPY', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2702, '_COPY_TO_COURSE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2703, '_CORRECT', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2704, '_DATE_BEGIN_VALIDITY', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2705, '_DATE_COMPLETE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2706, '_DATE_EXPIRE_VALIDITY', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2707, '_DATE_FIRST_COMPLETE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2708, '_DATE_LAST_COMPLETE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2709, '_DENY_SUBSCRIBED_TEXT_SMS', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2710, '_EMPTYSPACE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2711, '_IMPORT_FILE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2712, '_IMPORT_FROM_COURSE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2713, '_IMPORT_HEADER', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2714, '_IMPORT_INFO', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2715, '_INSERT_CORRECT', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2716, '_INSERT_NOT_NEEDED', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2717, '_INSER_STATUS', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2718, '_JUSTIFIED', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2719, '_LEVEL_TO_IMPORT', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2720, '_MOVE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2721, '_MOVE_TO_COURSE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2722, '_NOT_EXPIRED_WITHOUT_DATE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2723, '_NOT_EXPIRED_WITH_DATE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2724, '_NOT_JUSTIFIED', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2725, '_NOT_NEEDED', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2726, '_ONLY_EXPIRED', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2727, '_RESET_VALIDITY_DATES', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]');
INSERT INTO `core_lang_text` VALUES
(2728, '_SELECT_WHO_CONFIRM', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2729, '_SEND_ALERT', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2730, '_SHOW_ONLY', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2731, '_STATUS_TO_IMPORT', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2732, '_SUBSCRIBE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2733, '_SUBSCRIBE_ACCEPT', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2734, '_SUBSCRIBE_REFUSE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2735, '_SUMMARY_SELECT_LEVEL', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2736, '_SUMMARY_SELECT_WHO_CONFIRM', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2737, '_USER_IS_BUSY', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2738, '_USER_STATUS_OVERBOOKING', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2739, '_USER_SUBSCRIBED', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2740, '_VALID_AT_DATE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2741, '_WAIT', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2742, '_YOUCANSUBSCRIBE', 'subscribe', '', 0, '[[regtime]]', '[[regtime]]'),
(2743, '_CONFIRM_SUBSCRIPTION', 'subscription', '', 0, '[[regtime]]', '[[regtime]]'),
(2744, '_IMPORT_FILE', 'subscription', '', 0, '[[regtime]]', '[[regtime]]'),
(2745, '_IMPORT_HEADER', 'subscription', '', 0, '[[regtime]]', '[[regtime]]'),
(2746, '_ADDMESSAGE', 'sysforum', '', 0, '[[regtime]]', '[[regtime]]'),
(2747, '_LOCKEDMESS', 'sysforum', '', 0, '[[regtime]]', '[[regtime]]'),
(2748, '_LOCKMESS', 'sysforum', '', 0, '[[regtime]]', '[[regtime]]'),
(2749, '_POPULAR', 'tags', '', 0, '[[regtime]]', '[[regtime]]'),
(2750, '_TAGS_TIPS', 'tags', '', 0, '[[regtime]]', '[[regtime]]'),
(2751, '_YOURS', 'tags', '', 0, '[[regtime]]', '[[regtime]]'),
(2752, '_CANCEL', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2753, '_CATALOGUE', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2754, '_CHANGE_COVER', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2755, '_CHANGE_FAVICON_ICO', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2756, '_CHANGE_FAVICON_PNG', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2757, '_CHANGE_LOGO', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2758, '_CHANGE_LOGO_ADMIN', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2759, '_COLOR_0', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2760, '_COLOR_1', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2761, '_COLOR_2', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2762, '_COLOR_3', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2763, '_COLOR_4', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2764, '_COLOR_5', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2765, '_COLOR_6', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2766, '_COLOR_COLOR_CLASSROOM', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2767, '_COLOR_COLOR_DASHBOARD_POPUP_BG', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2768, '_COLOR_COLOR_DASHBOARD_POPUP_DESC', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2769, '_COLOR_COLOR_DASHBOARD_POPUP_TITLE', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2770, '_COLOR_COLOR_ELEARNING', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2771, '_CONFIRM_DELETION', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2772, '_DELETE', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2773, '_DETAILS', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2774, '_DONT_OVERWRITE_IMAGES', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2775, '_EDIT_CUSTOM_CSS', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2776, '_SAVE', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2777, '_SELECT_CATALOGUE', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2778, '_UPGRADE', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2779, '_UPGRADE_CONFIRM', 'templedit', '', 0, '[[regtime]]', '[[regtime]]'),
(2780, '_ALL_DIFFICULT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2781, '_ALL_QUEST_CATEGORY', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2782, '_ALL_QUEST_TYPE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2783, '_ATTEMPTS_REMAINING_BEFORE_SUSPENSION', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2784, '_BONUS_SCORE_FOR_TEST', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2785, '_COURSEREPORT_MANAGEMENT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2786, '_CURRENT_SELECTION_COUNT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2787, '_DESELECT_PAGE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2788, '_EMPTY_ANSWER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2789, '_EXISTING_TEST', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2790, '_FEEDBACK_MANAGEMENT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2791, '_FEEDBACK_TEXT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2792, '_GIFT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2793, '_HARD', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2794, '_MANDATORY_ANSWER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2795, '_MAX_ATTEMPT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2796, '_MAX_ATTEMPT_REACH', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2797, '_NEED_ANSWER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2798, '_NEW_SCORE_FOR_QUESTION', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2799, '_NEW_TEST', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2800, '_NUMBER_OF_ATTEMPT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2801, '_ORDER_TYPE_CATEGORY', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2802, '_ORDER_TYPE_RANDOM', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2803, '_QUEST', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2804, '_QUEST_ACRN_ASSOCIATE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2805, '_QUEST_ACRN_BREAK_PAGE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2806, '_QUEST_ACRN_CHOICE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2807, '_QUEST_ACRN_CHOICE_MULTIPLE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2808, '_QUEST_ACRN_EXTENDED_TEXT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2809, '_QUEST_ACRN_HOT_TEXT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2810, '_QUEST_ACRN_INLINE_CHOICE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2811, '_QUEST_ACRN_TEXT_ENTRY', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2812, '_QUEST_ACRN_TITLE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2813, '_QUEST_ACRN_UPLOAD', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2814, '_QUEST_ANSWER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2815, '_QUEST_ASSOCIATE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2816, '_QUEST_BREAK_PAGE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2817, '_QUEST_CHOICE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2818, '_QUEST_CHOICE_MULTIPLE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2819, '_QUEST_EXTENDED_TEXT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2820, '_QUEST_FREEANSWER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2821, '_QUEST_HOT_TEXT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2822, '_QUEST_HOT_TEXT_ISTRUCTION', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2823, '_QUEST_INLINE_CHOICE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2824, '_QUEST_INLINE_CHOICE_NOTE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2825, '_QUEST_NONE_ANSWER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2826, '_QUEST_REFER_TAG', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2827, '_QUEST_TEXT_ENTRY', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2828, '_QUEST_TE_ANSWERHERE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2829, '_QUEST_TITLE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2830, '_QUEST_TM2_DIFFERENCE_FROM_PREVIOUS', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2831, '_QUEST_TM2_SCORE_DIFFERENCE_FROM_PREVIOUS', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2832, '_QUEST_TM2_SETDIFFICULT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2833, '_QUEST_TM2_SETSCORE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2834, '_QUEST_TM2_SETTIME', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2835, '_QUEST_UPLOAD', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2836, '_RESTART_INFO', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2837, '_SELECT_PAGE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2838, '_SHOW_IN_COURSEREPORT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2839, '_SHOW_IN_DETAIL', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2840, '_SUSPENSION_NUM_ATTEMPTS', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2841, '_SUSPENSION_NUM_HOURS', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2842, '_SUSPENSION_PREREQUISITES', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2843, '_TEST_ADDQUEST', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2844, '_TEST_ADD_FORM', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2845, '_TEST_ADD_ONE_ANSWER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2846, '_TEST_AFTER_QUEST', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2847, '_TEST_ANSWER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2848, '_TEST_ANSWER_CHECK', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2849, '_TEST_ANSWER_NOTCHECK', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2850, '_TEST_ASSOCIATE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2851, '_TEST_BACK_TO_SETTIME', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2852, '_TEST_BEGIN', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2853, '_TEST_CAN_TRAVEL', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2854, '_TEST_CAN_TRAVEL_NO', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2855, '_TEST_CAPTION', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2856, '_TEST_COMPILE_TIME', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2857, '_TEST_COMPLETED', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2858, '_TEST_CONTINUE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2859, '_TEST_CORRECT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2860, '_TEST_END_BACKTOLESSON', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2861, '_TEST_END_PAGE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2862, '_TEST_FAILED', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2863, '_TEST_FILE_NOT_ATTACH', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2864, '_TEST_FIRST_QUEST', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2865, '_TEST_IC_TITLE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2866, '_TEST_IFCORRECT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2867, '_TEST_IFINCORRECT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2868, '_TEST_INCORRECT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2869, '_TEST_INFO', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2870, '_TEST_INSERT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2871, '_TEST_ISCORRECT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2872, '_TEST_ISNOT_THECORRECT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2873, '_TEST_IS_THECORRECT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2874, '_TEST_LAST_QUEST', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2875, '_TEST_MANUAL_SCORE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2876, '_TEST_MAXSCORE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2877, '_TEST_MM1_ANSWER_ORDER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2878, '_TEST_MM1_ANSWER_RANDOM', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2879, '_TEST_MM1_ANSWER_SEQUENCE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2880, '_TEST_MM1_GROUPING', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2881, '_TEST_MM1_ONEFORPAGE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2882, '_TEST_MM1_QUESTION_RANDOM_NUMBER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2883, '_TEST_MM1_RANDOM', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2884, '_TEST_MM1_SEQUENCE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2885, '_TEST_MM2_CANTRAVEL', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2886, '_TEST_MM2_HIDE_INFO', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2887, '_TEST_MM2_MODANSWER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2888, '_TEST_MM2_SAVEKEEP', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2889, '_TEST_MM4_SHOWCAT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2890, '_TEST_MM4_SHOWDOANSWER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2891, '_TEST_MM4_SHOWSOL', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2892, '_TEST_MM4_SHOWTOT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2893, '_TEST_MM_FIVE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2894, '_TEST_MM_FOUR', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2895, '_TEST_MM_ONE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2896, '_TEST_MM_TWO', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2897, '_TEST_MODALITY', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2898, '_TEST_MOD_DOANSWER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2899, '_TEST_MOD_DOANSWER_NO', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2900, '_TEST_MOVEQUEST', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2901, '_TEST_NEXT_PAGE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2902, '_TEST_NOT_AS_THECORRECT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2903, '_TEST_NOT_HT_THECORRECT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2904, '_TEST_NOT_MC_THECORRECT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2905, '_TEST_NOT_THECORRECT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2906, '_TEST_PAGES', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2907, '_TEST_PM1_PERC', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2908, '_TEST_PM1_POINT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2909, '_TEST_PMM_REQUIREDSCORE_POINT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2910, '_TEST_PM_DIFFICULT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2911, '_TEST_PM_EQUALTOALL', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2912, '_TEST_PM_MANUAL', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2913, '_TEST_PM_ONE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2914, '_TEST_PM_SETPOINT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2915, '_TEST_PM_SUBD_BY', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2916, '_TEST_PM_TWO', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2917, '_TEST_POINT_ASSIGNEMENT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2918, '_TEST_POINT_MANAGEMENT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2919, '_TEST_PREV_PAGE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2920, '_TEST_QUESTION_NUMBER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2921, '_TEST_QUEST_CATEGORY', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2922, '_TEST_QUEST_ELEM', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2923, '_TEST_QUEST_ELEMENTS_A', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2924, '_TEST_QUEST_ELEMENTS_B', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2925, '_TEST_QUEST_ELEM_NUM', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2926, '_TEST_QUEST_MAXTESTSCORE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2927, '_TEST_QUEST_NEWMAXTESTSCORE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2928, '_TEST_QUEST_ORDER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2929, '_TEST_QUEST_SEL_ASSOCIATION', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2930, '_TEST_QUEST_TIMEASS', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2931, '_TEST_QUEST_TIME_ASSIGNED', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2932, '_TEST_REQUIREDSCORE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2933, '_TEST_REQUIREDSCORE_RESULT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2934, '_TEST_RESTART', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2935, '_TEST_REVIEW_ANSWER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2936, '_TEST_SAVED', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2937, '_TEST_SAVEKEEP', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2938, '_TEST_SAVEKEEP_BACK', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2939, '_TEST_SAVEKEEP_FAILURE_BACK', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2940, '_TEST_SAVEKEEP_NO', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2941, '_TEST_SAVE_KEEP', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2942, '_TEST_SCORES', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2943, '_TEST_SECTION', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2944, '_TEST_SEL_LIBRARIES', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2945, '_TEST_SHOW_REVIEW', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2946, '_TEST_SHOW_SCORE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2947, '_TEST_SHOW_SCORE_NO', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2948, '_TEST_SHOW_SOLUTION', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2949, '_TEST_SHOW_SOLUTION_NO', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2950, '_TEST_SUB_ONE_ANSWER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2951, '_TEST_SUMMARY', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2952, '_TEST_SUSPENDED', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2953, '_TEST_SUSPENDED_UNTIL', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2954, '_TEST_TEXT_ANSWER', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2955, '_TEST_TE_TITLE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2956, '_TEST_TIME_ASSIGNED', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2957, '_TEST_TIME_ASSIGNED_NO', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2958, '_TEST_TIME_ASSIGNED_QUEST', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2959, '_TEST_TIME_MANAGEMENT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2960, '_TEST_TIME_NO', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2961, '_TEST_TIME_YES', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2962, '_TEST_TIME_YES_QUEST', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2963, '_TEST_TM1_LIMIT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2964, '_TEST_TM2_CAPTIONSETTIME', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2965, '_TEST_TM2_EQUALTOALL', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2966, '_TEST_TM2_MANUAL', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2967, '_TEST_TM2_NEWTIME', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2968, '_TEST_TM2_NEWTIMETOTAL', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2969, '_TEST_TM2_PENALITY_QUEST', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2970, '_TEST_TM2_PENALITY_TEST', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2971, '_TEST_TM2_SETSCORE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2972, '_TEST_TM2_SETTIME', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2973, '_TEST_TM2_SUBD_BY', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2974, '_TEST_TM_FOUR', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2975, '_TEST_TM_ONE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2976, '_TEST_TM_THREE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2977, '_TEST_TM_TWO', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2978, '_TEST_TOTAL_SCORE', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2979, '_TEST_YOUCANNOT_SAVEKEEP', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2980, '_TIME_ELAPSED', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2981, '_TIME_LEFT', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2982, '_UNREACHED_PREREQUISITES', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2983, '_USE_SUSPENSION', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2984, '_VERY_HARD', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2985, '_YES_IF_PASSED', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2986, '_YOU_HAVE_PASS_THIS_TEST', 'test', '', 0, '[[regtime]]', '[[regtime]]'),
(2987, '_MARK_AS_PAID', 'transaction', '', 0, '[[regtime]]', '[[regtime]]'),
(2988, '_PRICE', 'transaction', '', 0, '[[regtime]]', '[[regtime]]'),
(2989, '_SET_NOT_PAID', 'transaction', '', 0, '[[regtime]]', '[[regtime]]'),
(2990, '_ALT_EMPTY', 'treeview', '', 0, '[[regtime]]', '[[regtime]]'),
(2991, '_REG_BUTTON', 'user_management', '', 0, '[[regtime]]', '[[regtime]]'),
(2992, '_ACTION_ON_USERS', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(2993, '_AUTOMATIC_PASSWORD', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(2994, '_CREATE_ALL', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(2995, '_CREATE_AND_UPDATE', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(2996, '_DONT_USE_TREE_REGISTRATION', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(2997, '_FIELD_REPEATED', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(2998, '_FROM_FILE', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(2999, '_GENERATE_PASSWORD', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3000, '_INSERT_ALL', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3001, '_INSERT_EMPTY', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3002, '_LOG_OPTION', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3003, '_MANUAL_PASSWORD', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3004, '_NEED_TO_ALERT', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3005, '_NO_FILE', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3006, '_NO_VALUE', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3007, '_ONLY_CREATE', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3008, '_ONLY_UPDATE', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3009, '_PASSWORD_TO_INSERT', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3010, '_REACH_NUMBERS_OF_ATTEMPT', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3011, '_REGISTER_TYPE_ADMIN', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3012, '_REGISTER_TYPE_MODERATE', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3013, '_REGISTER_TYPE_SELF', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3014, '_SEND_NEW_CREDENTIALS_ALERT', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3015, '_SET_PASSWORD', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3016, '_USERID_NEEDED', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3017, '_USE_WITH_MANUALEINSERT', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3018, '_USE_WITH_SELECTION', 'user_managment', '', 0, '[[regtime]]', '[[regtime]]'),
(3019, '_ADD_WIKI', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3020, '_ALT_GOTO_PAGE', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3021, '_ALT_VIEW_REVISION', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3022, '_COMPARE_SEL_VER', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3023, '_EXPORT_WIKI', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3024, '_GUIDE', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3025, '_HOME', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3026, '_LEVEL_UP', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3027, '_MAP', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3028, '_OTHER_LANGUAGE', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3029, '_PAGE', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3030, '_PROVIDE_SEARCH_QUERY', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3031, '_REVISIONS', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3032, '_SELECT_WIKI', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3033, '_TABLE_SELECT_WIKI_CAP', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3034, '_WIKI', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3035, '_WIKI_HOME', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3036, '_WIKI_INSTRUCTION', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3037, '_WIKI_LANGUAGE', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3038, '_WIKI_LEVEL_UP', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3039, '_WIKI_OTHER_LANGUAGES', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3040, '_WIKI_PREV', 'wiki', '', 0, '[[regtime]]', '[[regtime]]'),
(3041, '_LABEL', 'communication', '', 0, '[[regtime]]', '[[regtime]]'),
(3042, '_PARENT', 'communication', '', 0, '[[regtime]]', '[[regtime]]'),
(3043, '_FILTER', 'communication', '', 0, '[[regtime]]', '[[regtime]]'),
(3044, '_COUNT', 'communication', '', 0, '[[regtime]]', '[[regtime]]'),
(3045, '_NO_OPTION', 'communication', '', 0, '[[regtime]]', '[[regtime]]'),
(3046, '_CATEGORY_WITH_POSTS', 'communication', '', 0, '[[regtime]]', '[[regtime]]'),
(3047, '_ERROR', 'communication', '', 0, '[[regtime]]', '[[regtime]]'),
(3048, '_CATEGORY_FATHER', 'communication', '', 0, '[[regtime]]', '[[regtime]]'),
(3049, '_CATEGORY_MISSING', 'communication', '', 0, '[[regtime]]', '[[regtime]]'),
(3050, '_MARK_AS_READ', 'communication', '', 0, '[[regtime]]', '[[regtime]]'),
(3051, '_MARK_AS_UNREAD', 'communication', '', 0, '[[regtime]]', '[[regtime]]'),
(3052, '_AUTO_TLS', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3053, '_HOST', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3054, '_PORT', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3055, '_DEBUG', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3056, '_SECURE', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3057, '_SENDER_MAIL_NOTIFICATION', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3058, '_SENDER_NAME_NOTIFICATION', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3059, '_SENDER_MAIL_SYSTEM', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3060, '_SENDER_NAME_SYSTEM', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3061, '_HELPER_DESK_MAIL', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3062, '_HELPER_DESK_SUBJECT', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3063, '_HELPER_DESK_NAME', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3064, '_REPLYTO_NAME', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3065, '_REPLYTO_MAIL', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3066, '_SENDER_CC_MAILS', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3067, '_SENDER_CCN_MAILS', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3068, '_BLANK_FIELDS', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3069, '_MISSING_FIELDS', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3070, '_TESTMAIL_OK', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3071, '_TESTMAIL_KO', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3072, '_TESTMAIL_SUBJECT', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3073, '_TESTMAIL_BODY', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3074, '_TEST', 'mailconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3075, '_DOMAIN', 'domainconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3076, '_TEMPLATE', 'domainconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3077, '_ORG', 'domainconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3078, '_MAIL_CONFIG', 'domainconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3079, '_SUBS', 'domainconfig', '', 0, '[[regtime]]', '[[regtime]]'),
(3080, '_INPUT_FORGOT_USERNAME', 'screen_reader', '', 0, '[[regtime]]', '[[regtime]]'),
(3081, '_INPUT_FORGOT_PASSWORD', 'screen_reader', '', 0, '[[regtime]]', '[[regtime]]'),
(3082, '_PROFILE', 'screen_reader', '', 0, '[[regtime]]', '[[regtime]]'),
(3083, '_CREATE_FOLDER', 'screen_reader', '', 0, '[[regtime]]', '[[regtime]]'),
(3084, '_RENAME_FOLDER_LABEL', 'screen_reader', '', 0, '[[regtime]]', '[[regtime]]'),
(3085, '_RENAME_FOLDER_BUTTON', 'screen_reader', '', 0, '[[regtime]]', '[[regtime]]'),
(3086, '_DISABLE_HIGH_CONTRAST', 'screen_reader', '', 0, '[[regtime]]', '[[regtime]]'),
(3087, '_ENABLE_HIGH_CONTRAST', 'screen_reader', '', 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_lang_translation`
--

CREATE TABLE `core_lang_translation` (
  `id_text` int(11) NOT NULL,
  `lang_code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation_text` mediumtext COLLATE utf8mb4_unicode_ci,
  `save_date` datetime DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_text_idx` (`id_text`),
  KEY `lang_code_idx` (`lang_code`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3088 ;

--
-- Dumping data for table `core_lang_translation`
--

INSERT INTO `core_lang_translation` VALUES
(2, 'english', '[url] [firstname] [lastname] [course] [username]', '2020-09-15 14:47:12', 1, '[[regtime]]', '[[regtime]]'),
(3, 'english', 'Select folders for administrator user visibility', '2020-09-15 14:47:12', 2, '[[regtime]]', '[[regtime]]'),
(4, 'english', 'Administrators manager', '2020-09-15 14:47:12', 3, '[[regtime]]', '[[regtime]]'),
(5, 'english', 'Administrator user', '2020-09-15 14:47:12', 4, '[[regtime]]', '[[regtime]]'),
(6, 'english', 'List of all platform administrators', '2020-09-15 14:47:12', 5, '[[regtime]]', '[[regtime]]'),
(7, 'english', 'Menu', '2020-09-15 14:47:12', 6, '[[regtime]]', '[[regtime]]'),
(8, 'english', 'Special settings', '2020-09-15 14:47:12', 7, '[[regtime]]', '[[regtime]]'),
(9, 'english', 'Administrator Profile', '2020-09-15 14:47:12', 8, '[[regtime]]', '[[regtime]]'),
(10, 'english', 'Special settings for:', '2020-09-15 14:47:12', 9, '[[regtime]]', '[[regtime]]'),
(11, 'english', 'Activate directly the enrollments made by this administrator', '2020-09-15 14:47:12', 10, '[[regtime]]', '[[regtime]]'),
(12, 'english', 'Activate directly the users created by this administrator', '2020-09-15 14:47:12', 11, '[[regtime]]', '[[regtime]]'),
(13, 'english', 'Languages settings', '2020-09-15 14:47:12', 12, '[[regtime]]', '[[regtime]]'),
(14, 'english', 'Limit the maximum number of enrollments this administrator can make', '2020-09-15 14:47:12', 13, '[[regtime]]', '[[regtime]]'),
(15, 'english', 'Limit the maximum number of users this administrator can create', '2020-09-15 14:47:12', 14, '[[regtime]]', '[[regtime]]'),
(16, 'english', 'Manage subscriptions', '2020-09-15 14:47:12', 15, '[[regtime]]', '[[regtime]]'),
(17, 'english', 'The maximum number of enrollments this administrator can make', '2020-09-15 14:47:12', 16, '[[regtime]]', '[[regtime]]'),
(18, 'english', 'Max number of users this administrator can create', '2020-09-15 14:47:12', 17, '[[regtime]]', '[[regtime]]'),
(19, 'english', 'Select the languages to assign', '2020-09-15 14:47:12', 18, '[[regtime]]', '[[regtime]]'),
(20, 'english', 'Special settings', '2020-09-15 14:47:12', 19, '[[regtime]]', '[[regtime]]'),
(21, 'english', 'Paper test', '2020-09-15 14:47:12', 20, '[[regtime]]', '[[regtime]]'),
(22, 'english', 'Web test', '2020-09-15 14:47:12', 21, '[[regtime]]', '[[regtime]]'),
(23, 'english', 'Accept', '2020-09-15 14:47:12', 22, '[[regtime]]', '[[regtime]]'),
(24, 'english', 'User accepted', '2020-09-15 14:47:12', 23, '[[regtime]]', '[[regtime]]'),
(25, 'english', 'Additional fields assigned', '2020-09-15 14:47:12', 24, '[[regtime]]', '[[regtime]]'),
(26, 'english', 'Decline', '2020-09-15 14:47:12', 25, '[[regtime]]', '[[regtime]]'),
(27, 'english', 'Self registration', '2020-09-15 14:47:12', 26, '[[regtime]]', '[[regtime]]'),
(28, 'english', 'Administrator', '2020-09-15 14:47:12', 27, '[[regtime]]', '[[regtime]]'),
(29, 'english', 'Super-administrator', '2020-09-15 14:47:12', 28, '[[regtime]]', '[[regtime]]'),
(30, 'english', 'Public administrator', '2020-09-15 14:47:12', 29, '[[regtime]]', '[[regtime]]'),
(31, 'english', 'User', '2020-09-15 14:47:12', 30, '[[regtime]]', '[[regtime]]'),
(32, 'english', 'Assign field', '2020-09-15 14:47:12', 31, '[[regtime]]', '[[regtime]]'),
(33, 'english', 'Email', '2020-09-15 14:47:12', 32, '[[regtime]]', '[[regtime]]'),
(34, 'english', 'Firstname', '2020-09-15 14:47:12', 33, '[[regtime]]', '[[regtime]]'),
(35, 'english', 'Show also children node content', '2020-09-15 14:47:12', 34, '[[regtime]]', '[[regtime]]'),
(36, 'english', 'Language', '2020-09-15 14:47:12', 35, '[[regtime]]', '[[regtime]]'),
(37, 'english', 'Last Name', '2020-09-15 14:47:12', 36, '[[regtime]]', '[[regtime]]'),
(38, 'english', 'Password', '2020-09-15 14:47:12', 37, '[[regtime]]', '[[regtime]]'),
(39, 'english', 'Registration date', '2020-09-15 14:47:12', 38, '[[regtime]]', '[[regtime]]'),
(40, 'english', 'Template name', '2020-09-15 14:47:12', 39, '[[regtime]]', '[[regtime]]'),
(41, 'english', 'User name', '2020-09-15 14:47:12', 40, '[[regtime]]', '[[regtime]]'),
(42, 'english', 'Full name', '2020-09-15 14:47:12', 41, '[[regtime]]', '[[regtime]]'),
(43, 'english', 'ID', '2020-09-15 14:47:12', 42, '[[regtime]]', '[[regtime]]'),
(44, 'english', 'Group type', '2020-09-15 14:47:12', 43, '[[regtime]]', '[[regtime]]'),
(45, 'english', 'Open group', '2020-09-15 14:47:12', 44, '[[regtime]]', '[[regtime]]'),
(46, 'english', 'Invisible group', '2020-09-15 14:47:12', 45, '[[regtime]]', '[[regtime]]'),
(47, 'english', 'Invisible', '2020-09-15 14:47:12', 46, '[[regtime]]', '[[regtime]]'),
(48, 'english', 'Moderated group', '2020-09-15 14:47:12', 47, '[[regtime]]', '[[regtime]]'),
(49, 'english', 'Moderated', '2020-09-15 14:47:12', 48, '[[regtime]]', '[[regtime]]'),
(50, 'english', 'Private group', '2020-09-15 14:47:12', 49, '[[regtime]]', '[[regtime]]'),
(51, 'english', 'Admin', '2020-09-15 14:47:12', 50, '[[regtime]]', '[[regtime]]'),
(52, 'english', 'Users waiting for subscription confirmation', '2020-09-15 14:47:12', 51, '[[regtime]]', '[[regtime]]'),
(53, 'english', 'User field', '2020-09-15 14:47:12', 52, '[[regtime]]', '[[regtime]]'),
(54, 'english', 'Member ID', '2020-09-15 14:47:12', 53, '[[regtime]]', '[[regtime]]'),
(55, 'english', 'Member type', '2020-09-15 14:47:12', 54, '[[regtime]]', '[[regtime]]'),
(56, 'english', 'Node', '2020-09-15 14:47:12', 55, '[[regtime]]', '[[regtime]]'),
(57, 'english', 'User member', '2020-09-15 14:47:12', 56, '[[regtime]]', '[[regtime]]'),
(58, 'english', 'Organization chart', '2020-09-15 14:47:12', 57, '[[regtime]]', '[[regtime]]'),
(59, 'english', 'Require password change upon next login', '2020-09-15 14:47:12', 58, '[[regtime]]', '[[regtime]]'),
(60, 'english', 'Yes', '2020-09-15 14:47:12', 59, '[[regtime]]', '[[regtime]]'),
(61, 'english', 'File charset', '2020-09-15 14:47:12', 60, '[[regtime]]', '[[regtime]]'),
(62, 'english', 'CSV file', '2020-09-15 14:47:12', 61, '[[regtime]]', '[[regtime]]'),
(63, 'english', 'Consider first row as header', '2020-09-15 14:47:12', 62, '[[regtime]]', '[[regtime]]'),
(64, 'english', 'Fields separator', '2020-09-15 14:47:12', 63, '[[regtime]]', '[[regtime]]'),
(65, 'english', 'Last Name First Name', '2020-09-15 14:47:12', 64, '[[regtime]]', '[[regtime]]'),
(66, 'english', 'User has not been approved', '2020-09-15 14:47:12', 65, '[[regtime]]', '[[regtime]]'),
(67, 'english', 'Refuse', '2020-09-15 14:47:12', 66, '[[regtime]]', '[[regtime]]'),
(68, 'english', 'Refuse user registration request', '2020-09-15 14:47:12', 67, '[[regtime]]', '[[regtime]]'),
(69, 'english', 'Search in fields: username, First Name or Last Name', '2020-09-15 14:47:12', 68, '[[regtime]]', '[[regtime]]'),
(70, 'english', 'Users list with confirmed registration request and waiting for approval', '2020-09-15 14:47:12', 69, '[[regtime]]', '[[regtime]]'),
(71, 'english', 'Language code not specified', '2020-09-15 14:47:12', 70, '[[regtime]]', '[[regtime]]'),
(72, 'english', 'Clean languages', '2020-09-15 14:47:12', 71, '[[regtime]]', '[[regtime]]'),
(73, 'english', 'Clean', '2020-09-15 14:47:12', 72, '[[regtime]]', '[[regtime]]'),
(74, 'english', 'From left to right (ltr)', '2020-09-15 14:47:12', 73, '[[regtime]]', '[[regtime]]'),
(75, 'english', 'From right to left (rtl)', '2020-09-15 14:47:12', 74, '[[regtime]]', '[[regtime]]'),
(76, 'english', 'Do not add missing labels', '2020-09-15 14:47:12', 75, '[[regtime]]', '[[regtime]]'),
(77, 'english', 'Export this language', '2020-09-15 14:47:12', 76, '[[regtime]]', '[[regtime]]'),
(78, 'english', 'Only export words that have not been translated yet (these keys will be shown in English)', '2020-09-15 14:47:12', 77, '[[regtime]]', '[[regtime]]'),
(79, 'english', 'Accessibility', '2020-09-15 14:47:12', 78, '[[regtime]]', '[[regtime]]'),
(80, 'english', 'Add key', '2020-09-15 14:47:12', 79, '[[regtime]]', '[[regtime]]'),
(81, 'english', 'All languages', '2020-09-15 14:47:12', 80, '[[regtime]]', '[[regtime]]'),
(82, 'english', 'All modules', '2020-09-15 14:47:12', 81, '[[regtime]]', '[[regtime]]'),
(83, 'english', 'Attributes', '2020-09-15 14:47:12', 82, '[[regtime]]', '[[regtime]]'),
(84, 'english', 'Web Browser language code', '2020-09-15 14:47:12', 83, '[[regtime]]', '[[regtime]]'),
(85, 'english', 'Charset', '2020-09-15 14:47:12', 84, '[[regtime]]', '[[regtime]]'),
(86, 'english', 'Language code', '2020-09-15 14:47:12', 85, '[[regtime]]', '[[regtime]]'),
(87, 'english', 'Comparison', '2020-09-15 14:47:12', 86, '[[regtime]]', '[[regtime]]'),
(88, 'english', 'Language direction', '2020-09-15 14:47:12', 87, '[[regtime]]', '[[regtime]]'),
(89, 'english', 'Key', '2020-09-15 14:47:12', 88, '[[regtime]]', '[[regtime]]'),
(90, 'english', 'Module', '2020-09-15 14:47:12', 89, '[[regtime]]', '[[regtime]]'),
(91, 'english', 'New module', '2020-09-15 14:47:12', 90, '[[regtime]]', '[[regtime]]'),
(92, 'english', 'Translation', '2020-09-15 14:47:12', 91, '[[regtime]]', '[[regtime]]'),
(93, 'english', 'Comparison', '2020-09-15 14:47:12', 92, '[[regtime]]', '[[regtime]]'),
(94, 'english', 'Updated modules', '2020-09-15 14:47:12', 93, '[[regtime]]', '[[regtime]]'),
(95, 'english', 'No, cancel import', '2020-09-15 14:47:12', 94, '[[regtime]]', '[[regtime]]'),
(96, 'english', 'Phrases', '2020-09-15 14:47:12', 95, '[[regtime]]', '[[regtime]]'),
(97, 'english', 'Only untranslated phrases', '2020-09-15 14:47:12', 96, '[[regtime]]', '[[regtime]]'),
(98, 'english', 'Reading orientation', '2020-09-15 14:47:12', 97, '[[regtime]]', '[[regtime]]'),
(99, 'english', 'Overwrite existing words', '2020-09-15 14:47:12', 98, '[[regtime]]', '[[regtime]]'),
(100, 'english', 'Translate %', '2020-09-15 14:47:12', 99, '[[regtime]]', '[[regtime]]'),
(101, 'english', 'Plugin', '2020-09-15 14:47:12', 100, '[[regtime]]', '[[regtime]]'),
(102, 'english', 'Plugin name', '2020-09-15 14:47:12', 101, '[[regtime]]', '[[regtime]]'),
(103, 'english', 'Language definition updated', '2020-09-15 14:47:12', 102, '[[regtime]]', '[[regtime]]'),
(104, 'english', 'Translation table for %module%', '2020-09-15 14:47:12', 103, '[[regtime]]', '[[regtime]]'),
(105, 'english', 'Translate', '2020-09-15 14:47:12', 104, '[[regtime]]', '[[regtime]]'),
(106, 'english', 'Translate language', '2020-09-15 14:47:12', 105, '[[regtime]]', '[[regtime]]'),
(107, 'english', 'Translation contains', '2020-09-15 14:47:12', 106, '[[regtime]]', '[[regtime]]'),
(108, 'english', 'Yes, import', '2020-09-15 14:47:12', 107, '[[regtime]]', '[[regtime]]'),
(109, 'english', 'Choose who can see this', '2020-09-15 14:47:12', 108, '[[regtime]]', '[[regtime]]'),
(110, 'english', 'Long description', '2020-09-15 14:47:12', 109, '[[regtime]]', '[[regtime]]'),
(111, 'english', 'News in home page', '2020-09-15 14:47:12', 110, '[[regtime]]', '[[regtime]]'),
(112, 'english', 'News summary', '2020-09-15 14:47:12', 111, '[[regtime]]', '[[regtime]]'),
(113, 'english', 'Important Title', '2020-09-15 14:47:12', 112, '[[regtime]]', '[[regtime]]'),
(114, 'english', 'every language', '2020-09-15 14:47:12', 113, '[[regtime]]', '[[regtime]]'),
(115, 'english', 'Newsletter will reach [tot] users.', '2020-09-15 14:47:12', 114, '[[regtime]]', '[[regtime]]'),
(116, 'english', 'Pause for 20 seconds', '2020-09-15 14:47:12', 115, '[[regtime]]', '[[regtime]]'),
(117, 'english', 'SMS', '2020-09-15 14:47:12', 116, '[[regtime]]', '[[regtime]]'),
(118, 'english', 'New web page', '2020-09-15 14:47:12', 117, '[[regtime]]', '[[regtime]]'),
(119, 'english', 'Home', '2020-09-15 14:47:12', 118, '[[regtime]]', '[[regtime]]'),
(120, 'english', 'This is the default page', '2020-09-15 14:47:12', 119, '[[regtime]]', '[[regtime]]'),
(121, 'english', 'Web pages', '2020-09-15 14:47:12', 120, '[[regtime]]', '[[regtime]]'),
(122, 'english', 'List of web pages', '2020-09-15 14:47:12', 121, '[[regtime]]', '[[regtime]]'),
(123, 'english', 'Add announcement', '2020-09-15 14:47:12', 122, '[[regtime]]', '[[regtime]]'),
(124, 'english', 'Announcements', '2020-09-15 14:47:12', 123, '[[regtime]]', '[[regtime]]'),
(125, 'english', 'Move to archive', '2020-09-15 14:47:12', 124, '[[regtime]]', '[[regtime]]'),
(126, 'english', 'Move into read announcements', '2020-09-15 14:47:12', 125, '[[regtime]]', '[[regtime]]'),
(127, 'english', 'Choose who can read this announcement', '2020-09-15 14:47:12', 126, '[[regtime]]', '[[regtime]]'),
(128, 'english', 'Select users', '2020-09-15 14:47:12', 127, '[[regtime]]', '[[regtime]]'),
(129, 'english', 'Only me', '2020-09-15 14:47:12', 128, '[[regtime]]', '[[regtime]]'),
(130, 'english', 'Apr', '2020-09-15 14:47:12', 129, '[[regtime]]', '[[regtime]]'),
(131, 'english', 'April', '2020-09-15 14:47:12', 130, '[[regtime]]', '[[regtime]]'),
(132, 'english', 'Aug', '2020-09-15 14:47:12', 131, '[[regtime]]', '[[regtime]]'),
(133, 'english', 'August', '2020-09-15 14:47:12', 132, '[[regtime]]', '[[regtime]]'),
(134, 'english', 'Event calendar', '2020-09-15 14:47:12', 133, '[[regtime]]', '[[regtime]]'),
(135, 'english', 'Show before %s', '2020-09-15 14:47:12', 134, '[[regtime]]', '[[regtime]]'),
(136, 'english', 'Dec', '2020-09-15 14:47:12', 135, '[[regtime]]', '[[regtime]]'),
(137, 'english', 'December', '2020-09-15 14:47:12', 136, '[[regtime]]', '[[regtime]]'),
(138, 'english', '%d-%m-%Y', '2020-09-15 14:47:12', 137, '[[regtime]]', '[[regtime]]'),
(139, 'english', 'Feb', '2020-09-15 14:47:12', 138, '[[regtime]]', '[[regtime]]'),
(140, 'english', 'February', '2020-09-15 14:47:12', 139, '[[regtime]]', '[[regtime]]'),
(141, 'english', 'Fri', '2020-09-15 14:47:12', 140, '[[regtime]]', '[[regtime]]'),
(142, 'english', 'Friday', '2020-09-15 14:47:12', 141, '[[regtime]]', '[[regtime]]'),
(143, 'english', 'Generic', '2020-09-15 14:47:12', 142, '[[regtime]]', '[[regtime]]'),
(144, 'english', 'Today', '2020-09-15 14:47:12', 143, '[[regtime]]', '[[regtime]]'),
(145, 'english', 'Jan', '2020-09-15 14:47:12', 144, '[[regtime]]', '[[regtime]]'),
(146, 'english', 'January', '2020-09-15 14:47:12', 145, '[[regtime]]', '[[regtime]]'),
(147, 'english', 'Jul', '2020-09-15 14:47:12', 146, '[[regtime]]', '[[regtime]]'),
(148, 'english', 'July', '2020-09-15 14:47:12', 147, '[[regtime]]', '[[regtime]]'),
(149, 'english', 'Jun', '2020-09-15 14:47:12', 148, '[[regtime]]', '[[regtime]]'),
(150, 'english', 'June', '2020-09-15 14:47:12', 149, '[[regtime]]', '[[regtime]]'),
(151, 'english', 'Mar', '2020-09-15 14:47:12', 150, '[[regtime]]', '[[regtime]]'),
(152, 'english', 'March', '2020-09-15 14:47:12', 151, '[[regtime]]', '[[regtime]]'),
(153, 'english', 'May', '2020-09-15 14:47:12', 152, '[[regtime]]', '[[regtime]]'),
(154, 'english', 'Meeting', '2020-09-15 14:47:12', 153, '[[regtime]]', '[[regtime]]'),
(155, 'english', 'Mon', '2020-09-15 14:47:12', 154, '[[regtime]]', '[[regtime]]'),
(156, 'english', 'Monday', '2020-09-15 14:47:12', 155, '[[regtime]]', '[[regtime]]'),
(157, 'english', 'Next Month', '2020-09-15 14:47:12', 156, '[[regtime]]', '[[regtime]]'),
(158, 'english', 'Next Year', '2020-09-15 14:47:12', 157, '[[regtime]]', '[[regtime]]'),
(159, 'english', 'Nov', '2020-09-15 14:47:12', 158, '[[regtime]]', '[[regtime]]'),
(160, 'english', 'November', '2020-09-15 14:47:12', 159, '[[regtime]]', '[[regtime]]'),
(161, 'english', 'Oct', '2020-09-15 14:47:12', 160, '[[regtime]]', '[[regtime]]'),
(162, 'english', 'October', '2020-09-15 14:47:12', 161, '[[regtime]]', '[[regtime]]'),
(163, 'english', '(today)', '2020-09-15 14:47:12', 162, '[[regtime]]', '[[regtime]]'),
(164, 'english', 'please wait...', '2020-09-15 14:47:12', 163, '[[regtime]]', '[[regtime]]'),
(165, 'english', 'Previous month', '2020-09-15 14:47:12', 164, '[[regtime]]', '[[regtime]]'),
(166, 'english', 'Previous year', '2020-09-15 14:47:12', 165, '[[regtime]]', '[[regtime]]'),
(167, 'english', 'Private', '2020-09-15 14:47:12', 166, '[[regtime]]', '[[regtime]]'),
(168, 'english', 'Public', '2020-09-15 14:47:12', 167, '[[regtime]]', '[[regtime]]'),
(169, 'english', 'Publishing', '2020-09-15 14:47:12', 168, '[[regtime]]', '[[regtime]]'),
(170, 'english', 'Sat', '2020-09-15 14:47:12', 169, '[[regtime]]', '[[regtime]]'),
(171, 'english', 'Saturday', '2020-09-15 14:47:12', 170, '[[regtime]]', '[[regtime]]'),
(172, 'english', 'Sep', '2020-09-15 14:47:12', 171, '[[regtime]]', '[[regtime]]'),
(173, 'english', 'September', '2020-09-15 14:47:12', 172, '[[regtime]]', '[[regtime]]'),
(174, 'english', 'Sun', '2020-09-15 14:47:12', 173, '[[regtime]]', '[[regtime]]'),
(175, 'english', 'Sunday', '2020-09-15 14:47:12', 174, '[[regtime]]', '[[regtime]]'),
(176, 'english', 'Thu', '2020-09-15 14:47:12', 175, '[[regtime]]', '[[regtime]]'),
(177, 'english', 'Thursday', '2020-09-15 14:47:12', 176, '[[regtime]]', '[[regtime]]'),
(178, 'english', 'Hour:', '2020-09-15 14:47:12', 177, '[[regtime]]', '[[regtime]]'),
(179, 'english', 'Today', '2020-09-15 14:47:12', 178, '[[regtime]]', '[[regtime]]'),
(180, 'english', '%a:%b:%e', '2020-09-15 14:47:12', 179, '[[regtime]]', '[[regtime]]'),
(181, 'english', 'Tue', '2020-09-15 14:47:12', 180, '[[regtime]]', '[[regtime]]'),
(182, 'english', 'Tuesday', '2020-09-15 14:47:12', 181, '[[regtime]]', '[[regtime]]'),
(183, 'english', 'Wed', '2020-09-15 14:47:12', 182, '[[regtime]]', '[[regtime]]'),
(184, 'english', 'Wednesday', '2020-09-15 14:47:12', 183, '[[regtime]]', '[[regtime]]'),
(185, 'english', '0,6', '2020-09-15 14:47:12', 184, '[[regtime]]', '[[regtime]]'),
(186, 'english', 'week', '2020-09-15 14:47:12', 185, '[[regtime]]', '[[regtime]]'),
(187, 'english', 'Cart', '2020-09-15 14:47:12', 186, '[[regtime]]', '[[regtime]]'),
(188, 'english', 'Classroom course', '2020-09-15 14:47:12', 187, '[[regtime]]', '[[regtime]]'),
(189, 'english', 'Code', '2020-09-15 14:47:12', 188, '[[regtime]]', '[[regtime]]'),
(190, 'english', 'Course price', '2020-09-15 14:47:12', 189, '[[regtime]]', '[[regtime]]'),
(191, 'english', 'Course type', '2020-09-15 14:47:12', 190, '[[regtime]]', '[[regtime]]'),
(192, 'english', 'Date begin', '2020-09-15 14:47:12', 191, '[[regtime]]', '[[regtime]]'),
(193, 'english', 'Date end', '2020-09-15 14:47:12', 192, '[[regtime]]', '[[regtime]]'),
(194, 'english', 'Delete the selected item', '2020-09-15 14:47:12', 193, '[[regtime]]', '[[regtime]]'),
(195, 'english', 'Empty your cart', '2020-09-15 14:47:12', 194, '[[regtime]]', '[[regtime]]'),
(196, 'english', 'E-learning course', '2020-09-15 14:47:12', 195, '[[regtime]]', '[[regtime]]'),
(197, 'english', 'Name', '2020-09-15 14:47:12', 196, '[[regtime]]', '[[regtime]]'),
(198, 'english', 'Order now', '2020-09-15 14:47:12', 197, '[[regtime]]', '[[regtime]]'),
(199, 'english', 'Order number', '2020-09-15 14:47:12', 198, '[[regtime]]', '[[regtime]]'),
(200, 'english', 'Select your preferred payment', '2020-09-15 14:47:12', 199, '[[regtime]]', '[[regtime]]'),
(201, 'english', 'Pay with PayPal', '2020-09-15 14:47:12', 200, '[[regtime]]', '[[regtime]]'),
(202, 'english', 'Total', '2020-09-15 14:47:12', 201, '[[regtime]]', '[[regtime]]'),
(203, 'english', 'Transaction created', '2020-09-15 14:47:12', 202, '[[regtime]]', '[[regtime]]'),
(204, 'english', 'Payment information', '2020-09-15 14:47:12', 203, '[[regtime]]', '[[regtime]]'),
(205, 'english', 'Wire Payment', '2020-09-15 14:47:12', 204, '[[regtime]]', '[[regtime]]'),
(206, 'english', 'Payment details', '2020-09-15 14:47:12', 205, '[[regtime]]', '[[regtime]]'),
(207, 'english', 'Add to cart', '2020-09-15 14:47:12', 206, '[[regtime]]', '[[regtime]]'),
(208, 'english', 'You have purchased all the available editions', '2020-09-15 14:47:12', 207, '[[regtime]]', '[[regtime]]'),
(209, 'english', 'Catalogue', '2020-09-15 14:47:12', 208, '[[regtime]]', '[[regtime]]'),
(210, 'english', 'Career', '2020-09-15 14:47:12', 209, '[[regtime]]', '[[regtime]]'),
(211, 'english', 'Select catalogs', '2020-09-15 14:47:12', 210, '[[regtime]]', '[[regtime]]'),
(212, 'english', 'List all the available catalogs', '2020-09-15 14:47:12', 211, '[[regtime]]', '[[regtime]]'),
(213, 'english', 'Certificates available for download', '2020-09-15 14:47:12', 212, '[[regtime]]', '[[regtime]]'),
(214, 'english', 'Classroom in cart', '2020-09-15 14:47:12', 213, '[[regtime]]', '[[regtime]]'),
(215, 'english', 'Building', '2020-09-15 14:47:12', 214, '[[regtime]]', '[[regtime]]'),
(216, 'english', 'Confirm: add to cart?', '2020-09-15 14:47:12', 215, '[[regtime]]', '[[regtime]]'),
(217, 'english', 'Confirm Subscription', '2020-09-15 14:47:12', 216, '[[regtime]]', '[[regtime]]'),
(218, 'english', 'This curriculum has <b>[enrolled]</b> subscribed users', '2020-09-15 14:47:12', 217, '[[regtime]]', '[[regtime]]'),
(219, 'english', 'Your curriculum', '2020-09-15 14:47:12', 218, '[[regtime]]', '[[regtime]]'),
(220, 'english', 'Subscribe Curriculum', '2020-09-15 14:47:12', 219, '[[regtime]]', '[[regtime]]'),
(221, 'english', 'Confirm your subscription to this Course Path:', '2020-09-15 14:47:12', 220, '[[regtime]]', '[[regtime]]'),
(222, 'english', 'Course added to cart', '2020-09-15 14:47:12', 221, '[[regtime]]', '[[regtime]]'),
(223, 'english', 'Courses where you are [level]', '2020-09-15 14:47:12', 222, '[[regtime]]', '[[regtime]]'),
(224, 'english', 'Courses you are subscribed to', '2020-09-15 14:47:12', 223, '[[regtime]]', '[[regtime]]'),
(225, 'english', 'Courses you have completed', '2020-09-15 14:47:12', 224, '[[regtime]]', '[[regtime]]'),
(226, 'english', 'Courses expiring in one week', '2020-09-15 14:47:12', 225, '[[regtime]]', '[[regtime]]'),
(227, 'english', 'Course in cart', '2020-09-15 14:47:12', 226, '[[regtime]]', '[[regtime]]'),
(228, 'english', 'List of available courses', '2020-09-15 14:47:12', 227, '[[regtime]]', '[[regtime]]'),
(229, 'english', 'Course subscription', '2020-09-15 14:47:12', 228, '[[regtime]]', '[[regtime]]'),
(230, 'english', 'Only admin can subscribe', '2020-09-15 14:47:12', 229, '[[regtime]]', '[[regtime]]'),
(231, 'english', 'Your subscription to this course needs to be approved by administrator', '2020-09-15 14:47:12', 230, '[[regtime]]', '[[regtime]]'),
(232, 'english', 'Course type', '2020-09-15 14:47:12', 231, '[[regtime]]', '[[regtime]]'),
(233, 'english', 'Enabled courses', '2020-09-15 14:47:12', 232, '[[regtime]]', '[[regtime]]'),
(234, 'english', 'E-learning', '2020-09-15 14:47:12', 233, '[[regtime]]', '[[regtime]]'),
(235, 'english', 'Courses and curricula', '2020-09-15 14:47:12', 234, '[[regtime]]', '[[regtime]]'),
(236, 'english', 'Courses and curricula assigned to this catalog', '2020-09-15 14:47:12', 235, '[[regtime]]', '[[regtime]]'),
(237, 'english', 'Courses which start from', '2020-09-15 14:47:12', 236, '[[regtime]]', '[[regtime]]'),
(238, 'english', 'Show only courses', '2020-09-15 14:47:12', 237, '[[regtime]]', '[[regtime]]'),
(239, 'english', 'selling', '2020-09-15 14:47:12', 238, '[[regtime]]', '[[regtime]]'),
(240, 'english', 'Import new', '2020-09-15 14:47:12', 239, '[[regtime]]', '[[regtime]]'),
(241, 'english', 'Manual subscription', '2020-09-15 14:47:12', 240, '[[regtime]]', '[[regtime]]'),
(242, 'english', 'Show elements of the catalog', '2020-09-15 14:47:12', 241, '[[regtime]]', '[[regtime]]'),
(243, 'english', 'New catalog', '2020-09-15 14:47:12', 242, '[[regtime]]', '[[regtime]]'),
(244, 'english', 'No editions available', '2020-09-15 14:47:12', 243, '[[regtime]]', '[[regtime]]'),
(245, 'english', 'No category to display', '2020-09-15 14:47:12', 244, '[[regtime]]', '[[regtime]]'),
(246, 'english', 'No courses available', '2020-09-15 14:47:12', 245, '[[regtime]]', '[[regtime]]'),
(247, 'english', 'Course not found', '2020-09-15 14:47:12', 246, '[[regtime]]', '[[regtime]]'),
(248, 'english', 'There are no editions in this course.', '2020-09-15 14:47:12', 247, '[[regtime]]', '[[regtime]]'),
(249, 'english', 'No time periods', '2020-09-15 14:47:12', 248, '[[regtime]]', '[[regtime]]'),
(250, 'english', 'Suggested curriculum', '2020-09-15 14:47:12', 249, '[[regtime]]', '[[regtime]]'),
(251, 'english', 'Remove from the catalog', '2020-09-15 14:47:12', 250, '[[regtime]]', '[[regtime]]'),
(252, 'english', 'Reserve', '2020-09-15 14:47:12', 251, '[[regtime]]', '[[regtime]]'),
(253, 'english', 'Shopping cart', '2020-09-15 14:47:12', 252, '[[regtime]]', '[[regtime]]'),
(254, 'english', 'Show Editions', '2020-09-15 14:47:12', 253, '[[regtime]]', '[[regtime]]'),
(255, 'english', 'Subscribe to this course', '2020-09-15 14:47:12', 254, '[[regtime]]', '[[regtime]]'),
(256, 'english', 'By category', '2020-09-15 14:47:12', 255, '[[regtime]]', '[[regtime]]'),
(257, 'english', 'Most popular', '2020-09-15 14:47:12', 256, '[[regtime]]', '[[regtime]]'),
(258, 'english', 'Most recent', '2020-09-15 14:47:12', 257, '[[regtime]]', '[[regtime]]'),
(259, 'english', 'Insert Subscription Code', '2020-09-15 14:47:12', 258, '[[regtime]]', '[[regtime]]'),
(260, 'english', 'Total number of courses you are subscribed to', '2020-09-15 14:47:12', 259, '[[regtime]]', '[[regtime]]'),
(261, 'english', 'If you received a subscription code, use this form to be automatically added to the course:', '2020-09-15 14:47:12', 260, '[[regtime]]', '[[regtime]]'),
(262, 'english', 'Enter', '2020-09-15 14:47:12', 261, '[[regtime]]', '[[regtime]]'),
(263, 'english', 'Waiting for approval', '2020-09-15 14:47:12', 262, '[[regtime]]', '[[regtime]]'),
(264, 'english', 'Search by word', '2020-09-15 14:47:12', 263, '[[regtime]]', '[[regtime]]'),
(265, 'english', 'Remove meta-certificate already published', '2020-09-15 14:47:12', 264, '[[regtime]]', '[[regtime]]'),
(266, 'english', 'Publish a meta-certificate copy', '2020-09-15 14:47:12', 265, '[[regtime]]', '[[regtime]]'),
(267, 'english', 'Background image', '2020-09-15 14:47:12', 266, '[[regtime]]', '[[regtime]]'),
(268, 'english', 'Certificate language', '2020-09-15 14:47:12', 267, '[[regtime]]', '[[regtime]]'),
(269, 'english', 'Certificates generation', '2020-09-15 14:47:12', 268, '[[regtime]]', '[[regtime]]'),
(270, 'english', 'Associate aggregate certificate', '2020-09-15 14:47:12', 269, '[[regtime]]', '[[regtime]]'),
(271, 'english', 'Certificate assignment', '2020-09-15 14:47:12', 270, '[[regtime]]', '[[regtime]]'),
(272, 'english', 'Certificate template list', '2020-09-15 14:47:12', 271, '[[regtime]]', '[[regtime]]'),
(273, 'english', 'Certificates list', '2020-09-15 14:47:12', 272, '[[regtime]]', '[[regtime]]'),
(274, 'english', 'Released certificate', '2020-09-15 14:47:12', 273, '[[regtime]]', '[[regtime]]'),
(275, 'english', 'Certificate template list', '2020-09-15 14:47:12', 274, '[[regtime]]', '[[regtime]]'),
(276, 'english', 'Released certificates', '2020-09-15 14:47:12', 275, '[[regtime]]', '[[regtime]]'),
(277, 'english', 'IMPORTANT: Due to a limitation of the PDF class which will be fixed in a future version, we suggest using ONLY background images and not embedded images in HTML code inside tags like < p >, < div >, < center > etc., as this can cause errors.', '2020-09-15 14:47:12', 276, '[[regtime]]', '[[regtime]]'),
(278, 'english', 'Choose the certificate', '2020-09-15 14:47:12', 277, '[[regtime]]', '[[regtime]]'),
(279, 'english', 'Choose the course', '2020-09-15 14:47:12', 278, '[[regtime]]', '[[regtime]]'),
(280, 'english', 'Course starting date', '2020-09-15 14:47:12', 279, '[[regtime]]', '[[regtime]]'),
(281, 'english', 'Course description', '2020-09-15 14:47:12', 280, '[[regtime]]', '[[regtime]]'),
(282, 'english', 'Course end date', '2020-09-15 14:47:12', 281, '[[regtime]]', '[[regtime]]'),
(283, 'english', 'Max final score', '2020-09-15 14:47:12', 282, '[[regtime]]', '[[regtime]]'),
(284, 'english', 'Certificate date', '2020-09-15 14:47:12', 283, '[[regtime]]', '[[regtime]]'),
(285, 'english', 'Certificate year', '2020-09-15 14:47:12', 284, '[[regtime]]', '[[regtime]]'),
(286, 'english', 'Date of course completion', '2020-09-15 14:47:12', 285, '[[regtime]]', '[[regtime]]'),
(287, 'english', 'Course subscription date', '2020-09-15 14:47:12', 286, '[[regtime]]', '[[regtime]]'),
(288, 'english', 'if the First and Last Name are not available, username will be shown', '2020-09-15 14:47:12', 287, '[[regtime]]', '[[regtime]]'),
(289, 'english', 'Score required for Excellence certificate', '2020-09-15 14:47:12', 288, '[[regtime]]', '[[regtime]]'),
(290, 'english', 'Generate', '2020-09-15 14:47:12', 289, '[[regtime]]', '[[regtime]]'),
(291, 'english', 'Generate all the selected certificates', '2020-09-15 14:47:12', 290, '[[regtime]]', '[[regtime]]'),
(292, 'english', 'Landscape', '2020-09-15 14:47:12', 291, '[[regtime]]', '[[regtime]]'),
(293, 'english', 'Association list', '2020-09-15 14:47:12', 292, '[[regtime]]', '[[regtime]]'),
(294, 'english', 'Meta-certificate list', '2020-09-15 14:47:12', 293, '[[regtime]]', '[[regtime]]'),
(295, 'english', 'Meta-certificates ready to be created', '2020-09-15 14:47:12', 294, '[[regtime]]', '[[regtime]]'),
(296, 'english', 'Status of meta-certificates linked to users', '2020-09-15 14:47:12', 295, '[[regtime]]', '[[regtime]]'),
(297, 'english', 'Association table', '2020-09-15 14:47:12', 296, '[[regtime]]', '[[regtime]]'),
(298, 'english', 'Table to link users and courses to the meta-certificate', '2020-09-15 14:47:12', 297, '[[regtime]]', '[[regtime]]'),
(299, 'english', 'Completed / Total', '2020-09-15 14:47:12', 298, '[[regtime]]', '[[regtime]]'),
(300, 'english', 'Meta-certificate list', '2020-09-15 14:47:12', 299, '[[regtime]]', '[[regtime]]'),
(301, 'english', 'My certificates', '2020-09-15 14:47:12', 300, '[[regtime]]', '[[regtime]]'),
(302, 'english', 'New association', '2020-09-15 14:47:12', 301, '[[regtime]]', '[[regtime]]'),
(303, 'english', 'New certificate', '2020-09-15 14:47:12', 302, '[[regtime]]', '[[regtime]]'),
(304, 'english', 'Not ended', '2020-09-15 14:47:12', 303, '[[regtime]]', '[[regtime]]'),
(305, 'english', 'No available certificates', '2020-09-15 14:47:12', 304, '[[regtime]]', '[[regtime]]'),
(306, 'english', 'No one has accessed this certificate yet', '2020-09-15 14:47:12', 305, '[[regtime]]', '[[regtime]]'),
(307, 'english', 'No meta-certificates ready to be published', '2020-09-15 14:47:12', 306, '[[regtime]]', '[[regtime]]'),
(308, 'english', 'Certificates:', '2020-09-15 14:47:12', 307, '[[regtime]]', '[[regtime]]'),
(309, 'english', 'Orientation', '2020-09-15 14:47:12', 308, '[[regtime]]', '[[regtime]]'),
(310, 'english', 'Portrait', '2020-09-15 14:47:12', 309, '[[regtime]]', '[[regtime]]'),
(311, 'english', 'Released on', '2020-09-15 14:47:12', 310, '[[regtime]]', '[[regtime]]'),
(312, 'english', 'Released', '2020-09-15 14:47:12', 311, '[[regtime]]', '[[regtime]]'),
(313, 'english', 'Score', '2022-03-10 11:47:16', 312, '[[regtime]]', '[[regtime]]'),
(314, 'english', 'Scorm Title', '2022-03-10 11:47:16', 313, '[[regtime]]', '[[regtime]]'),
(315, 'english', 'Stop', '2020-09-15 14:47:12', 314, '[[regtime]]', '[[regtime]]'),
(316, 'english', 'Certificate template', '2020-09-15 14:47:12', 315, '[[regtime]]', '[[regtime]]'),
(317, 'english', 'Structure of meta-certificate', '2020-09-15 14:47:12', 316, '[[regtime]]', '[[regtime]]'),
(318, 'english', 'Table of courses completed toward the meta-certificate', '2020-09-15 14:47:12', 317, '[[regtime]]', '[[regtime]]'),
(319, 'english', 'Tag codes', '2020-09-15 14:47:12', 318, '[[regtime]]', '[[regtime]]'),
(320, 'english', 'Description tag', '2020-09-15 14:47:12', 319, '[[regtime]]', '[[regtime]]'),
(321, 'english', 'Tags available for certificate template building', '2020-09-15 14:47:12', 320, '[[regtime]]', '[[regtime]]'),
(322, 'english', 'Tags available for certificate template building', '2020-09-15 14:47:12', 321, '[[regtime]]', '[[regtime]]'),
(323, 'english', 'Download copy of certificate', '2020-09-15 14:47:12', 322, '[[regtime]]', '[[regtime]]'),
(324, 'english', 'Template', '2020-09-15 14:47:12', 323, '[[regtime]]', '[[regtime]]'),
(325, 'english', 'Final Learning Object score', '2020-09-15 14:47:12', 324, '[[regtime]]', '[[regtime]]'),
(326, 'english', 'Maximum final Learning Object score', '2020-09-15 14:47:12', 325, '[[regtime]]', '[[regtime]]'),
(327, 'english', 'Initial Learning Object score', '2020-09-15 14:47:12', 326, '[[regtime]]', '[[regtime]]'),
(328, 'english', 'Maximum initial Learning Object score', '2020-09-15 14:47:12', 327, '[[regtime]]', '[[regtime]]'),
(329, 'english', 'Assign certificate aggregate', '2020-09-15 14:47:12', 328, '[[regtime]]', '[[regtime]]'),
(330, 'english', 'Certificate management', '2020-09-15 14:47:12', 329, '[[regtime]]', '[[regtime]]'),
(331, 'english', 'Meta-certificates available to be published', '2020-09-15 14:47:12', 330, '[[regtime]]', '[[regtime]]'),
(332, 'english', 'Meta-certificate', '2020-09-15 14:47:12', 331, '[[regtime]]', '[[regtime]]'),
(333, 'english', 'Meta-certificate assignment', '2020-09-15 14:47:12', 332, '[[regtime]]', '[[regtime]]'),
(334, 'english', 'Meta-certificates emission', '2020-09-15 14:47:12', 333, '[[regtime]]', '[[regtime]]'),
(335, 'english', 'Deleting association', '2020-09-15 14:47:12', 334, '[[regtime]]', '[[regtime]]'),
(336, 'english', 'View copy', '2020-09-15 14:47:12', 335, '[[regtime]]', '[[regtime]]'),
(337, 'english', 'Total time spent in the course', '2020-09-15 14:47:12', 336, '[[regtime]]', '[[regtime]]'),
(338, 'english', 'Total time spent in the course (just hours)', '2020-09-15 14:47:12', 337, '[[regtime]]', '[[regtime]]'),
(339, 'english', 'Total time spent in the course (just minutes)', '2020-09-15 14:47:12', 338, '[[regtime]]', '[[regtime]]'),
(340, 'english', 'Total time spent in the course (just seconds)', '2020-09-15 14:47:12', 339, '[[regtime]]', '[[regtime]]'),
(341, 'english', 'To be released', '2020-09-15 14:47:12', 340, '[[regtime]]', '[[regtime]]'),
(342, 'english', 'Select users to be linked to this meta-certificate', '2020-09-15 14:47:12', 341, '[[regtime]]', '[[regtime]]'),
(343, 'english', 'Chat with other users in this course, click on the link below to open the chatroom in a pop-up window', '2020-09-15 14:47:12', 342, '[[regtime]]', '[[regtime]]'),
(344, 'english', 'Open chatroom (new window)', '2020-09-15 14:47:12', 343, '[[regtime]]', '[[regtime]]'),
(345, 'english', 'Open chatroom (accessibility version) (pop-up)', '2020-09-15 14:47:12', 344, '[[regtime]]', '[[regtime]]'),
(346, 'english', 'Available Hardware', '2020-09-15 14:47:12', 345, '[[regtime]]', '[[regtime]]'),
(347, 'english', 'Room', '2020-09-15 14:47:12', 346, '[[regtime]]', '[[regtime]]'),
(348, 'english', 'Capacity', '2020-09-15 14:47:12', 347, '[[regtime]]', '[[regtime]]'),
(349, 'english', 'City', '2020-09-15 14:47:12', 348, '[[regtime]]', '[[regtime]]'),
(350, 'english', 'Classroom', '2020-09-15 14:47:12', 349, '[[regtime]]', '[[regtime]]'),
(351, 'english', 'Classroom caption', '2020-09-15 14:47:12', 350, '[[regtime]]', '[[regtime]]'),
(352, 'english', 'Delete classroom', '2020-09-15 14:47:12', 351, '[[regtime]]', '[[regtime]]'),
(353, 'english', 'Layout', '2020-09-15 14:47:12', 352, '[[regtime]]', '[[regtime]]'),
(354, 'english', 'Fax', '2020-09-15 14:47:12', 353, '[[regtime]]', '[[regtime]]'),
(355, 'english', 'Classroom hardware', '2020-09-15 14:47:12', 354, '[[regtime]]', '[[regtime]]'),
(356, 'english', 'Location info', '2020-09-15 14:47:12', 355, '[[regtime]]', '[[regtime]]'),
(357, 'english', 'Edit classroom', '2020-09-15 14:47:12', 356, '[[regtime]]', '[[regtime]]'),
(358, 'english', 'New classroom', '2020-09-15 14:47:12', 357, '[[regtime]]', '[[regtime]]'),
(359, 'english', 'Phone number', '2020-09-15 14:47:12', 358, '[[regtime]]', '[[regtime]]'),
(360, 'english', 'Photo', '2020-09-15 14:47:12', 359, '[[regtime]]', '[[regtime]]'),
(361, 'english', 'Event location info', '2020-09-15 14:47:12', 360, '[[regtime]]', '[[regtime]]'),
(362, 'english', 'Refer(s) to', '2020-09-15 14:47:12', 361, '[[regtime]]', '[[regtime]]'),
(363, 'english', 'State', '2020-09-15 14:47:12', 362, '[[regtime]]', '[[regtime]]'),
(364, 'english', 'Street', '2020-09-15 14:47:12', 363, '[[regtime]]', '[[regtime]]'),
(365, 'english', 'Zipcode', '2020-09-15 14:47:12', 364, '[[regtime]]', '[[regtime]]'),
(366, 'english', 'Code list', '2020-09-15 14:47:12', 365, '[[regtime]]', '[[regtime]]'),
(367, 'english', 'Number of uses', '2020-09-15 14:47:12', 366, '[[regtime]]', '[[regtime]]'),
(368, 'english', 'Unlimited use', '2020-09-15 14:47:12', 367, '[[regtime]]', '[[regtime]]'),
(369, 'english', 'Used', '2020-09-15 14:47:12', 368, '[[regtime]]', '[[regtime]]'),
(370, 'english', 'Add new competence', '2020-09-15 14:47:12', 369, '[[regtime]]', '[[regtime]]'),
(371, 'english', 'Assign competence requirements to users', '2020-09-15 14:47:12', 370, '[[regtime]]', '[[regtime]]'),
(372, 'english', 'Required', '2020-09-15 14:47:12', 371, '[[regtime]]', '[[regtime]]'),
(373, 'english', 'Attitude', '2020-09-15 14:47:12', 372, '[[regtime]]', '[[regtime]]'),
(374, 'english', 'Knowledge', '2020-09-15 14:47:12', 373, '[[regtime]]', '[[regtime]]'),
(375, 'english', 'Skill', '2020-09-15 14:47:12', 374, '[[regtime]]', '[[regtime]]'),
(376, 'english', 'Competence''s related users list', '2020-09-15 14:47:12', 375, '[[regtime]]', '[[regtime]]'),
(377, 'english', 'Obtained', '2020-09-15 14:47:12', 376, '[[regtime]]', '[[regtime]]'),
(378, 'english', 'Obtained on', '2020-09-15 14:47:12', 377, '[[regtime]]', '[[regtime]]'),
(379, 'english', 'Expire after (days)', '2020-09-15 14:47:12', 378, '[[regtime]]', '[[regtime]]'),
(380, 'english', 'Flag', '2020-09-15 14:47:12', 379, '[[regtime]]', '[[regtime]]'),
(381, 'english', 'Competence with courses associated', '2020-09-15 14:47:12', 380, '[[regtime]]', '[[regtime]]'),
(382, 'english', 'Competence with roles associated', '2020-09-15 14:47:12', 381, '[[regtime]]', '[[regtime]]'),
(383, 'english', 'Competence with users associated', '2020-09-15 14:47:12', 382, '[[regtime]]', '[[regtime]]'),
(384, 'english', 'Hour:', '2020-09-15 14:47:12', 383, '[[regtime]]', '[[regtime]]'),
(385, 'english', 'Room name', '2020-09-15 14:47:12', 384, '[[regtime]]', '[[regtime]]'),
(386, 'english', 'System', '2020-09-15 14:47:12', 385, '[[regtime]]', '[[regtime]]'),
(387, 'english', 'Max users allowed', '2020-09-15 14:47:12', 386, '[[regtime]]', '[[regtime]]'),
(388, 'english', 'Meeting duration', '2020-09-15 14:47:12', 387, '[[regtime]]', '[[regtime]]'),
(389, 'english', 'You can''t create any more rooms', '2020-09-15 14:47:12', 388, '[[regtime]]', '[[regtime]]'),
(390, 'english', 'No available rooms', '2020-09-15 14:47:12', 389, '[[regtime]]', '[[regtime]]'),
(391, 'english', 'Videoconference available rooms', '2020-09-15 14:47:12', 390, '[[regtime]]', '[[regtime]]'),
(392, 'english', 'Available rooms list', '2020-09-15 14:47:12', 391, '[[regtime]]', '[[regtime]]'),
(393, 'english', 'General settings', '2020-09-15 14:47:12', 392, '[[regtime]]', '[[regtime]]'),
(394, 'english', 'Skebby Settings', '2020-09-15 14:47:12', 393, '[[regtime]]', '[[regtime]]'),
(395, 'english', 'General settings', '2020-09-15 14:47:12', 394, '[[regtime]]', '[[regtime]]'),
(396, 'english', 'General settings', '2020-09-15 14:47:12', 395, '[[regtime]]', '[[regtime]]'),
(397, 'english', 'General settings', '2020-09-15 14:47:12', 396, '[[regtime]]', '[[regtime]]'),
(398, 'english', 'General settings', '2020-09-15 14:47:12', 397, '[[regtime]]', '[[regtime]]'),
(399, 'english', 'LDAP', '2020-09-15 14:47:12', 398, '[[regtime]]', '[[regtime]]'),
(400, 'english', 'BYCRYPT Password', '2020-09-15 14:47:12', 399, '[[regtime]]', '[[regtime]]'),
(401, 'english', 'MD5 Password', '2020-09-15 14:47:12', 400, '[[regtime]]', '[[regtime]]'),
(402, 'english', 'Use high contrast colors', '2020-09-15 14:47:12', 401, '[[regtime]]', '[[regtime]]'),
(403, 'english', 'Configuration of "allow_url_fopen"', '2020-09-15 14:47:12', 402, '[[regtime]]', '[[regtime]]'),
(404, 'english', 'Configuration of "allow_url_include"', '2020-09-15 14:47:12', 403, '[[regtime]]', '[[regtime]]'),
(405, 'english', 'already assigned', '2020-09-15 14:47:12', 404, '[[regtime]]', '[[regtime]]'),
(406, 'english', 'forma.lms <abbr title="Application Programming Interface">API</abbr>', '2020-09-15 14:47:12', 405, '[[regtime]]', '[[regtime]]'),
(407, 'english', 'API and Authentication', '2020-09-15 14:47:12', 406, '[[regtime]]', '[[regtime]]'),
(408, 'english', 'Ask for a code created through the code module', '2020-09-15 14:47:12', 407, '[[regtime]]', '[[regtime]]'),
(409, 'english', 'Ask for a tree code chosen by the user from a list in a dropdown menu', '2020-09-15 14:47:12', 408, '[[regtime]]', '[[regtime]]'),
(410, 'english', 'Ask for a tree code that must be entered manually by the user', '2020-09-15 14:47:12', 409, '[[regtime]]', '[[regtime]]'),
(411, 'english', 'Ask for a code from the course tree', '2020-09-15 14:47:12', 410, '[[regtime]]', '[[regtime]]'),
(412, 'english', 'Max Audio users', '2020-09-15 14:47:12', 411, '[[regtime]]', '[[regtime]]'),
(413, 'english', 'Max users per room', '2020-09-15 14:47:12', 412, '[[regtime]]', '[[regtime]]'),
(414, 'english', 'Max rooms', '2020-09-15 14:47:12', 413, '[[regtime]]', '[[regtime]]'),
(415, 'english', 'BigBlueButton Moderator Password', '2020-09-15 14:47:12', 414, '[[regtime]]', '[[regtime]]'),
(416, 'english', 'BigBlueButton Viewer Password', '2020-09-15 14:47:12', 415, '[[regtime]]', '[[regtime]]'),
(417, 'english', 'BigBlueButton Port', '2020-09-15 14:47:12', 416, '[[regtime]]', '[[regtime]]'),
(418, 'english', 'Salt BigBlueButton', '2020-09-15 14:47:12', 417, '[[regtime]]', '[[regtime]]'),
(419, 'english', 'BigBlueButton server address', '2020-09-15 14:47:12', 418, '[[regtime]]', '[[regtime]]'),
(420, 'english', 'Username BigBlueButton', '2020-09-15 14:47:12', 419, '[[regtime]]', '[[regtime]]'),
(421, 'english', 'Clear twig cache', '2020-09-15 14:47:12', 420, '[[regtime]]', '[[regtime]]'),
(422, 'english', 'Customer code', '2020-09-15 14:47:12', 421, '[[regtime]]', '[[regtime]]'),
(423, 'english', 'Unify admin and public sessions', '2020-09-15 14:47:12', 422, '[[regtime]]', '[[regtime]]'),
(424, 'english', 'Limit for the number of conferences that can be planned by a single user', '2020-09-15 14:47:12', 423, '[[regtime]]', '[[regtime]]'),
(425, 'english', 'Configurations', '2020-09-15 14:47:12', 424, '[[regtime]]', '[[regtime]]'),
(426, 'english', 'ATTENTION: without double opt-in user''s email won''t be checked. You may be subject to spam registrations.', '2020-09-15 14:47:12', 425, '[[regtime]]', '[[regtime]]'),
(427, 'english', 'Common', '2020-09-15 14:47:12', 426, '[[regtime]]', '[[regtime]]'),
(428, 'english', 'E-learning', '2020-09-15 14:47:12', 427, '[[regtime]]', '[[regtime]]'),
(429, 'english', 'Show catalogue in login page', '2020-09-15 14:47:12', 428, '[[regtime]]', '[[regtime]]'),
(430, 'english', 'Limit for the maximum total size of contents uploaded into the course (MB)', '2020-09-15 14:47:12', 429, '[[regtime]]', '[[regtime]]'),
(431, 'english', 'Currency symbol (will be displayed at user side)', '2020-09-15 14:47:12', 430, '[[regtime]]', '[[regtime]]'),
(432, 'english', 'Help Desk email', '2020-09-15 14:47:12', 431, '[[regtime]]', '[[regtime]]'),
(433, 'english', 'Name from Help Desk', '2022-03-10 11:47:16', 432, '[[regtime]]', '[[regtime]]'),
(434, 'english', 'Prefix for help email subject', '2020-09-15 14:47:12', 433, '[[regtime]]', '[[regtime]]'),
(435, 'english', 'Help Desk subject prefix', '2020-09-15 14:47:12', 434, '[[regtime]]', '[[regtime]]'),
(436, 'english', 'Mandatory customfields', '2020-09-15 14:47:12', 435, '[[regtime]]', '[[regtime]]'),
(437, 'english', 'Debug options', '2020-09-15 14:47:12', 436, '[[regtime]]', '[[regtime]]'),
(438, 'english', 'Default template', '2020-09-15 14:47:12', 437, '[[regtime]]', '[[regtime]]'),
(439, 'english', 'Max Audio users', '2020-09-15 14:47:12', 438, '[[regtime]]', '[[regtime]]'),
(440, 'english', 'Max users per room', '2020-09-15 14:47:12', 439, '[[regtime]]', '[[regtime]]'),
(441, 'english', 'Max rooms', '2020-09-15 14:47:12', 440, '[[regtime]]', '[[regtime]]'),
(442, 'english', 'Password', '2020-09-15 14:47:12', 441, '[[regtime]]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES
(443, 'english', 'DimDim Port', '2020-09-15 14:47:12', 442, '[[regtime]]', '[[regtime]]'),
(444, 'english', 'DimDim server address', '2020-09-15 14:47:12', 443, '[[regtime]]', '[[regtime]]'),
(445, 'english', 'DimDim username', '2020-09-15 14:47:12', 444, '[[regtime]]', '[[regtime]]'),
(446, 'english', 'DOM XML status', '2020-09-15 14:47:12', 445, '[[regtime]]', '[[regtime]]'),
(447, 'english', 'Don''t show', '2020-09-15 14:47:12', 446, '[[regtime]]', '[[regtime]]'),
(448, 'english', 'Enable debug information', '2020-09-15 14:47:12', 447, '[[regtime]]', '[[regtime]]'),
(449, 'english', 'E-commerce', '2020-09-15 14:47:12', 448, '[[regtime]]', '[[regtime]]'),
(450, 'english', 'Email settings', '2020-09-15 14:47:12', 449, '[[regtime]]', '[[regtime]]'),
(451, 'english', 'Whitelist permitted file extensions', '2020-09-15 14:47:12', 450, '[[regtime]]', '[[regtime]]'),
(452, 'english', 'Show "course catalog" as user main page', '2020-09-15 14:47:12', 451, '[[regtime]]', '[[regtime]]'),
(453, 'english', 'Show forum list in a table', '2020-09-15 14:47:12', 452, '[[regtime]]', '[[regtime]]'),
(454, 'english', 'Error in FTP', '2020-09-15 14:47:12', 453, '[[regtime]]', '[[regtime]]'),
(455, 'english', 'FTP OK', '2020-09-15 14:47:12', 454, '[[regtime]]', '[[regtime]]'),
(456, 'english', 'Code provided by Google', '2020-09-15 14:47:12', 455, '[[regtime]]', '[[regtime]]'),
(457, 'english', 'Enable Google Analytics', '2020-09-15 14:47:12', 456, '[[regtime]]', '[[regtime]]'),
(458, 'english', 'Helpdesk Subject', '2020-09-15 14:47:12', 457, '[[regtime]]', '[[regtime]]'),
(459, 'english', 'Helpdesk Subject Placeholder', '2020-09-15 14:47:12', 458, '[[regtime]]', '[[regtime]]'),
(460, 'english', 'Hide empty category', '2020-09-15 14:47:12', 459, '[[regtime]]', '[[regtime]]'),
(461, 'english', 'Home page', '2020-09-15 14:47:12', 460, '[[regtime]]', '[[regtime]]'),
(462, 'english', 'Limit, in hours, for the expiration of the subscription request', '2020-09-15 14:47:12', 461, '[[regtime]]', '[[regtime]]'),
(463, 'english', 'Visual HTML text editor', '2020-09-15 14:47:12', 462, '[[regtime]]', '[[regtime]]'),
(464, 'english', 'Allow administrator media management in the editor', '2020-09-15 14:47:12', 463, '[[regtime]]', '[[regtime]]'),
(465, 'english', 'Allow super-administrator media management in the editor', '2020-09-15 14:47:12', 464, '[[regtime]]', '[[regtime]]'),
(466, 'english', 'Allow user media management in the editor', '2020-09-15 14:47:12', 465, '[[regtime]]', '[[regtime]]'),
(467, 'english', 'Ignore mastery score', '2022-03-10 11:47:16', 466, '[[regtime]]', '[[regtime]]'),
(468, 'english', 'Import user with function ucfirst()', '2020-09-15 14:47:12', 467, '[[regtime]]', '[[regtime]]'),
(469, 'english', 'In the result area of the content library searches, show also objects not directly available to the user', '2020-09-15 14:47:12', 468, '[[regtime]]', '[[regtime]]'),
(470, 'english', 'In the result area of the content library searches, show also objects that aren''t fully categorized', '2020-09-15 14:47:12', 469, '[[regtime]]', '[[regtime]]'),
(471, 'english', 'Activate language editing (used for debugging)', '2020-09-15 14:47:12', 470, '[[regtime]]', '[[regtime]]'),
(472, 'english', 'Time of language export', '2020-09-15 14:47:12', 471, '[[regtime]]', '[[regtime]]'),
(473, 'english', 'First Name and Last Name are required in order to register', '2020-09-15 14:47:12', 472, '[[regtime]]', '[[regtime]]'),
(474, 'english', 'LDAP', '2020-09-15 14:47:12', 473, '[[regtime]]', '[[regtime]]'),
(475, 'english', 'LDAP port (usually 389)', '2020-09-15 14:47:12', 474, '[[regtime]]', '[[regtime]]'),
(476, 'english', 'LDAP server address', '2020-09-15 14:47:12', 475, '[[regtime]]', '[[regtime]]'),
(477, 'english', 'Activate LDAP authentication', '2020-09-15 14:47:12', 476, '[[regtime]]', '[[regtime]]'),
(478, 'english', 'Username for LDAP users, use $user for the username.<br />Ex. $user@domain2.domain1 (for: W2k3)', '2020-09-15 14:47:12', 477, '[[regtime]]', '[[regtime]]'),
(479, 'english', 'DB SQL scripts log', '2020-09-15 14:47:12', 478, '[[regtime]]', '[[regtime]]'),
(480, 'english', 'Configuration of "magic_quotes_gpc"', '2020-09-15 14:47:12', 479, '[[regtime]]', '[[regtime]]'),
(481, 'english', 'Registrations and Lost passwords email sender', '2020-09-15 14:47:12', 480, '[[regtime]]', '[[regtime]]'),
(482, 'english', 'Sender name of registration emails and automatic password recovery procedure', '2022-03-10 11:47:16', 481, '[[regtime]]', '[[regtime]]'),
(483, 'english', 'Maintenance mode', '2020-09-15 14:47:12', 482, '[[regtime]]', '[[regtime]]'),
(484, 'english', 'Maintenance Password', '2020-09-15 14:47:12', 483, '[[regtime]]', '[[regtime]]'),
(485, 'english', 'Main options', '2020-09-15 14:47:12', 484, '[[regtime]]', '[[regtime]]'),
(486, 'english', 'If one of the registration code options above are enabled, users are forced to enter the registration code (the code field must be filled in)', '2020-09-15 14:47:12', 485, '[[regtime]]', '[[regtime]]'),
(487, 'english', 'Configuration of "max_execution_time"', '2020-09-15 14:47:12', 486, '[[regtime]]', '[[regtime]]'),
(488, 'english', 'Maximum number of consecutively failed login attempts (0 = no limit)', '2020-09-15 14:47:12', 487, '[[regtime]]', '[[regtime]]'),
(489, 'english', 'MySQL Collation', '2020-09-15 14:47:12', 488, '[[regtime]]', '[[regtime]]'),
(490, 'english', 'MySQL Encoding', '2020-09-15 14:47:12', 489, '[[regtime]]', '[[regtime]]'),
(491, 'english', 'SQL mode', '2020-09-15 14:47:12', 490, '[[regtime]]', '[[regtime]]'),
(492, 'english', 'MySQL Timezone', '2020-09-15 14:47:12', 491, '[[regtime]]', '[[regtime]]'),
(493, 'english', 'MySQL version', '2020-09-15 14:47:12', 492, '[[regtime]]', '[[regtime]]'),
(494, 'english', 'My courses', '2020-09-15 14:47:12', 493, '[[regtime]]', '[[regtime]]'),
(495, 'english', 'Pause between blocks (seconds)', '2020-09-15 14:47:12', 494, '[[regtime]]', '[[regtime]]'),
(496, 'english', 'Send newsletter messages in blocks of', '2020-09-15 14:47:12', 495, '[[regtime]]', '[[regtime]]'),
(497, 'english', 'With domxml OFF, the SCORM module, language management and videoconferencing will not work', '2020-09-15 14:47:12', 496, '[[regtime]]', '[[regtime]]'),
(498, 'english', 'Use "no answer" option in poll questions', '2020-09-15 14:47:12', 497, '[[regtime]]', '[[regtime]]'),
(499, 'english', 'Use "no answer" option in test questions', '2020-09-15 14:47:12', 498, '[[regtime]]', '[[regtime]]'),
(500, 'english', 'If not a single course catalog is assigned to a user, show all the courses and curricula', '2020-09-15 14:47:12', 499, '[[regtime]]', '[[regtime]]'),
(501, 'english', 'Show learning courses belonging to learning path in "My courses tab"', '2020-09-15 14:47:12', 500, '[[regtime]]', '[[regtime]]'),
(502, 'english', 'Send user to catalog if not enrolled in any course', '2020-09-15 14:47:12', 501, '[[regtime]]', '[[regtime]]'),
(503, 'english', 'PHP extension php_openssl', '2020-09-15 14:47:12', 502, '[[regtime]]', '[[regtime]]'),
(504, 'english', 'Limit the user to only one node of the organization chart', '2020-09-15 14:47:12', 503, '[[regtime]]', '[[regtime]]'),
(505, 'english', 'Organization name for the conference', '2020-09-15 14:47:12', 504, '[[regtime]]', '[[regtime]]'),
(506, 'english', 'Site owner', '2020-09-15 14:47:12', 505, '[[regtime]]', '[[regtime]]'),
(507, 'english', 'Page title (will appear in the user''s browser)', '2020-09-15 14:47:12', 506, '[[regtime]]', '[[regtime]]'),
(508, 'english', 'Password must be composed of letters and numbers', '2020-09-15 14:47:12', 507, '[[regtime]]', '[[regtime]]'),
(509, 'english', 'Password Algorithm', '2020-09-15 14:47:12', 508, '[[regtime]]', '[[regtime]]'),
(510, 'english', 'Force users to change their password at the first login', '2020-09-15 14:47:12', 509, '[[regtime]]', '[[regtime]]'),
(511, 'english', 'Password validity, max number of days the password will be valid (0 for unlimited)', '2020-09-15 14:47:12', 510, '[[regtime]]', '[[regtime]]'),
(512, 'english', 'Password length, minimum number of characters', '2020-09-15 14:47:12', 511, '[[regtime]]', '[[regtime]]'),
(513, 'english', 'File uploads path', '2020-09-15 14:47:12', 512, '[[regtime]]', '[[regtime]]'),
(514, 'english', 'Save Path for the files uploaded in the chat shared files', '2020-09-15 14:47:12', 513, '[[regtime]]', '[[regtime]]'),
(515, 'english', 'Save Path for the files uploaded in the course info', '2020-09-15 14:47:12', 514, '[[regtime]]', '[[regtime]]'),
(516, 'english', 'Save path for additional fields', '2020-09-15 14:47:12', 515, '[[regtime]]', '[[regtime]]'),
(517, 'english', 'Save Path for the files uploaded as forum attachment', '2020-09-15 14:47:12', 516, '[[regtime]]', '[[regtime]]'),
(518, 'english', 'Save Path for the files uploaded in the upload files', '2020-09-15 14:47:12', 517, '[[regtime]]', '[[regtime]]'),
(519, 'english', 'Save Path for files uploaded as message attachments', '2020-09-15 14:47:12', 518, '[[regtime]]', '[[regtime]]'),
(520, 'english', 'Users photos and avatars', '2020-09-15 14:47:12', 519, '[[regtime]]', '[[regtime]]'),
(521, 'english', 'Save Path for files uploaded in project manager', '2020-09-15 14:47:12', 520, '[[regtime]]', '[[regtime]]'),
(522, 'english', 'Save Path for files uploaded as SCORM Learning Object', '2020-09-15 14:47:12', 521, '[[regtime]]', '[[regtime]]'),
(523, 'english', 'Sponsor banners', '2020-09-15 14:47:12', 522, '[[regtime]]', '[[regtime]]'),
(524, 'english', 'Question "file upload"', '2020-09-15 14:47:12', 523, '[[regtime]]', '[[regtime]]'),
(525, 'english', 'PayPal currency code', '2020-09-15 14:47:12', 524, '[[regtime]]', '[[regtime]]'),
(526, 'english', 'PayPal Account', '2020-09-15 14:47:12', 525, '[[regtime]]', '[[regtime]]'),
(527, 'english', 'Use PayPal sandbox instead of the real environment (this is a debug and testing option)', '2020-09-15 14:47:12', 526, '[[regtime]]', '[[regtime]]'),
(528, 'english', 'Info about PHP', '2020-09-15 14:47:12', 527, '[[regtime]]', '[[regtime]]'),
(529, 'english', 'PHP version', '2020-09-15 14:47:12', 528, '[[regtime]]', '[[regtime]]'),
(530, 'english', 'Site Timezone', '2020-09-15 14:47:12', 529, '[[regtime]]', '[[regtime]]'),
(531, 'english', 'Activate', '2020-09-15 14:47:12', 530, '[[regtime]]', '[[regtime]]'),
(532, 'english', 'Author', '2020-09-15 14:47:12', 531, '[[regtime]]', '[[regtime]]'),
(533, 'english', 'Category', '2020-09-15 14:47:12', 532, '[[regtime]]', '[[regtime]]'),
(534, 'english', 'Deactivate', '2020-09-15 14:47:12', 533, '[[regtime]]', '[[regtime]]'),
(535, 'english', 'Description', '2020-09-15 14:47:12', 534, '[[regtime]]', '[[regtime]]'),
(536, 'english', 'Plugin cannot be deactivated because it belongs to core', '2020-09-15 14:47:12', 535, '[[regtime]]', '[[regtime]]'),
(537, 'english', 'Plugin cannot be uninstalled because it belongs to core', '2020-09-15 14:47:12', 536, '[[regtime]]', '[[regtime]]'),
(538, 'english', 'Plugin cannot be deactivated because of dependent plugins', '2020-09-15 14:47:12', 537, '[[regtime]]', '[[regtime]]'),
(539, 'english', 'Plugin update online is not available', '2020-09-15 14:47:12', 538, '[[regtime]]', '[[regtime]]'),
(540, 'english', 'Plugin cannot be installed because of missing dependencies', '2020-09-15 14:47:12', 539, '[[regtime]]', '[[regtime]]'),
(541, 'english', 'Plugin files version does not match with forma.lms', '2020-09-15 14:47:12', 540, '[[regtime]]', '[[regtime]]'),
(542, 'english', 'Plugin cannot be uninstalled because of dependent plugins', '2020-09-15 14:47:12', 541, '[[regtime]]', '[[regtime]]'),
(543, 'english', 'Install', '2020-09-15 14:47:12', 542, '[[regtime]]', '[[regtime]]'),
(544, 'english', 'Name', '2020-09-15 14:47:12', 543, '[[regtime]]', '[[regtime]]'),
(545, 'english', 'Settings', '2020-09-15 14:47:12', 544, '[[regtime]]', '[[regtime]]'),
(546, 'english', 'Uninstall', '2020-09-15 14:47:12', 545, '[[regtime]]', '[[regtime]]'),
(547, 'english', 'Confirm: plugin uninstallation?', '2020-09-15 14:47:12', 546, '[[regtime]]', '[[regtime]]'),
(548, 'english', 'Update', '2020-09-15 14:47:12', 547, '[[regtime]]', '[[regtime]]'),
(549, 'english', 'Version', '2020-09-15 14:47:12', 548, '[[regtime]]', '[[regtime]]'),
(550, 'english', 'Configuration of "post_max_size"', '2020-09-15 14:47:12', 549, '[[regtime]]', '[[regtime]]'),
(551, 'english', 'Privacy policy MUST be accepted', '2020-09-15 14:47:12', 550, '[[regtime]]', '[[regtime]]'),
(552, 'english', 'Limit user to change just his password (deactivate extended profile)', '2020-09-15 14:47:12', 551, '[[regtime]]', '[[regtime]]'),
(553, 'english', 'Keep a record of all the deleted users', '2020-09-15 14:47:12', 552, '[[regtime]]', '[[regtime]]'),
(554, 'english', 'Configuration of "register_global"', '2020-09-15 14:47:12', 553, '[[regtime]]', '[[regtime]]'),
(555, 'english', 'Registration type', '2020-09-15 14:47:12', 554, '[[regtime]]', '[[regtime]]'),
(556, 'english', 'Only by administrator', '2020-09-15 14:47:12', 555, '[[regtime]]', '[[regtime]]'),
(557, 'english', 'Moderated self registration', '2020-09-15 14:47:12', 556, '[[regtime]]', '[[regtime]]'),
(558, 'english', 'Free self registration', '2020-09-15 14:47:12', 557, '[[regtime]]', '[[regtime]]'),
(559, 'english', 'Free registration with double opt-in', '2020-09-15 14:47:12', 558, '[[regtime]]', '[[regtime]]'),
(560, 'english', 'Registration code usage', '2020-09-15 14:47:12', 559, '[[regtime]]', '[[regtime]]'),
(561, 'english', 'Max attached report size (MB)', '2020-09-15 14:47:12', 560, '[[regtime]]', '[[regtime]]'),
(562, 'english', 'Report download availability  (number of days)', '2020-09-15 14:47:12', 561, '[[regtime]]', '[[regtime]]'),
(563, 'english', 'saving path for  report recording', '2020-09-15 14:47:12', 562, '[[regtime]]', '[[regtime]]'),
(564, 'english', 'At the login the user is prompted to fill in the mandatory fields related to his profile', '2020-09-15 14:47:12', 563, '[[regtime]]', '[[regtime]]'),
(565, 'english', 'Authorization API Key', '2020-09-15 14:47:12', 564, '[[regtime]]', '[[regtime]]'),
(566, 'english', 'Authorization API Secret key', '2020-09-15 14:47:12', 565, '[[regtime]]', '[[regtime]]'),
(567, 'english', 'Single code for platform', '2020-09-15 14:47:12', 566, '[[regtime]]', '[[regtime]]'),
(568, 'english', 'Generated token will expire after (minutes)', '2020-09-15 14:47:12', 567, '[[regtime]]', '[[regtime]]'),
(569, 'english', 'Authentication method:', '2020-09-15 14:47:12', 568, '[[regtime]]', '[[regtime]]'),
(570, 'english', 'Authorization Secret Key', '2020-09-15 14:47:12', 569, '[[regtime]]', '[[regtime]]'),
(571, 'english', 'Token generation at every connection', '2020-09-15 14:47:12', 570, '[[regtime]]', '[[regtime]]'),
(572, 'english', 'Refresh token lifetime at every API call', '2020-09-15 14:47:12', 571, '[[regtime]]', '[[regtime]]'),
(573, 'english', '"safe_mode" configuration', '2020-09-15 14:47:12', 572, '[[regtime]]', '[[regtime]]'),
(574, 'english', 'Yes, only if the max number is reached', '2020-09-15 14:47:12', 573, '[[regtime]]', '[[regtime]]'),
(575, 'english', 'Yes, for all', '2020-09-15 14:47:12', 574, '[[regtime]]', '[[regtime]]'),
(576, 'english', 'Save info about failed login attempts', '2020-09-15 14:47:12', 575, '[[regtime]]', '[[regtime]]'),
(577, 'english', 'Allow the usage of direct links from external sources to SCORM chapters (sco and asset)', '2020-09-15 14:47:12', 576, '[[regtime]]', '[[regtime]]'),
(578, 'english', 'Security related', '2020-09-15 14:47:12', 577, '[[regtime]]', '[[regtime]]'),
(579, 'english', 'Sender email address for alert messages', '2020-09-15 14:47:12', 578, '[[regtime]]', '[[regtime]]'),
(580, 'english', 'Add the following address as CCN for all the email sent by the platform', '2022-03-10 11:47:16', 579, '[[regtime]]', '[[regtime]]'),
(581, 'english', 'Add the following address as CC for all the email sent by the platform', '2020-09-15 14:47:12', 580, '[[regtime]]', '[[regtime]]'),
(582, 'english', 'Server configuration', '2020-09-15 14:47:12', 581, '[[regtime]]', '[[regtime]]'),
(583, 'english', 'Server address', '2020-09-15 14:47:12', 582, '[[regtime]]', '[[regtime]]'),
(584, 'english', 'Server admin email', '2020-09-15 14:47:12', 583, '[[regtime]]', '[[regtime]]'),
(585, 'english', 'MySQL information', '2020-09-15 14:47:12', 584, '[[regtime]]', '[[regtime]]'),
(586, 'english', 'Server name', '2020-09-15 14:47:12', 585, '[[regtime]]', '[[regtime]]'),
(587, 'english', 'Server port', '2020-09-15 14:47:12', 586, '[[regtime]]', '[[regtime]]'),
(588, 'english', 'Server software', '2020-09-15 14:47:12', 587, '[[regtime]]', '[[regtime]]'),
(589, 'english', 'Enable IP control within sessions (user can''t change IP after login)', '2020-09-15 14:47:12', 588, '[[regtime]]', '[[regtime]]'),
(590, 'english', 'Show in block', '2020-09-15 14:47:12', 589, '[[regtime]]', '[[regtime]]'),
(591, 'english', 'Show as link list', '2020-09-15 14:47:12', 590, '[[regtime]]', '[[regtime]]'),
(592, 'english', 'SMS', '2020-09-15 14:47:12', 591, '[[regtime]]', '[[regtime]]'),
(593, 'english', 'In association with smsmarket.it', '2020-09-15 14:47:12', 592, '[[regtime]]', '[[regtime]]'),
(594, 'english', 'Buy more SMS''s', '2020-09-15 14:47:12', 593, '[[regtime]]', '[[regtime]]'),
(595, 'english', 'Cell phone number field', '2020-09-15 14:47:12', 594, '[[regtime]]', '[[regtime]]'),
(596, 'english', 'Credit left', '2020-09-15 14:47:12', 595, '[[regtime]]', '[[regtime]]'),
(597, 'english', 'Credit will be updated when you will send a further SMS.', '2020-09-15 14:47:12', 596, '[[regtime]]', '[[regtime]]'),
(598, 'english', 'Gateway 1', '2020-09-15 14:47:12', 597, '[[regtime]]', '[[regtime]]'),
(599, 'english', 'Gateway 2', '2020-09-15 14:47:12', 598, '[[regtime]]', '[[regtime]]'),
(600, 'english', 'Gateway 3', '2020-09-15 14:47:12', 599, '[[regtime]]', '[[regtime]]'),
(601, 'english', 'Gateway 4', '2020-09-15 14:47:12', 600, '[[regtime]]', '[[regtime]]'),
(602, 'english', 'Automatic', '2020-09-15 14:47:12', 601, '[[regtime]]', '[[regtime]]'),
(603, 'english', 'Gateway host address', '2020-09-15 14:47:12', 602, '[[regtime]]', '[[regtime]]'),
(604, 'english', 'Select gateway', '2020-09-15 14:47:12', 603, '[[regtime]]', '[[regtime]]'),
(605, 'english', 'Gateway password', '2020-09-15 14:47:12', 604, '[[regtime]]', '[[regtime]]'),
(606, 'english', 'Port number', '2020-09-15 14:47:12', 605, '[[regtime]]', '[[regtime]]'),
(607, 'english', 'Gateway username', '2020-09-15 14:47:12', 606, '[[regtime]]', '[[regtime]]'),
(608, 'english', 'Default international prefix', '2020-09-15 14:47:12', 607, '[[regtime]]', '[[regtime]]'),
(609, 'english', 'SMS sender', '2020-09-15 14:47:12', 608, '[[regtime]]', '[[regtime]]'),
(610, 'english', 'Social functions', '2020-09-15 14:47:12', 609, '[[regtime]]', '[[regtime]]'),
(611, 'english', 'Use Facebook interfacing and Single Sign On', '2020-09-15 14:47:12', 610, '[[regtime]]', '[[regtime]]'),
(612, 'english', 'Facebook API code', '2020-09-15 14:47:12', 611, '[[regtime]]', '[[regtime]]'),
(613, 'english', 'Facebook secret code', '2020-09-15 14:47:12', 612, '[[regtime]]', '[[regtime]]'),
(614, 'english', 'Use Google interfacing and Single Sign On <br/>(use redirect uri: http://server/path/index.php?modname=login&op=google_login)', '2020-09-15 14:47:12', 613, '[[regtime]]', '[[regtime]]'),
(615, 'english', 'Google Client ID', '2020-09-15 14:47:12', 614, '[[regtime]]', '[[regtime]]'),
(616, 'english', 'Google secret code', '2020-09-15 14:47:12', 615, '[[regtime]]', '[[regtime]]'),
(617, 'english', 'Linkedin API access code', '2020-09-15 14:47:12', 616, '[[regtime]]', '[[regtime]]'),
(618, 'english', 'Use Linkedin interfacing and Single Sign On', '2020-09-15 14:47:12', 617, '[[regtime]]', '[[regtime]]'),
(619, 'english', 'Linkedin secret code', '2020-09-15 14:47:12', 618, '[[regtime]]', '[[regtime]]'),
(620, 'english', 'Use Twitter interfacing and Single Sign On', '2020-09-15 14:47:12', 619, '[[regtime]]', '[[regtime]]'),
(621, 'english', 'Twitter consumer code', '2020-09-15 14:47:12', 620, '[[regtime]]', '[[regtime]]'),
(622, 'english', 'Twitter secret code', '2020-09-15 14:47:12', 621, '[[regtime]]', '[[regtime]]'),
(623, 'english', '<abbr title="Single Sign On">SSO</abbr> secret for the token hash', '2020-09-15 14:47:12', 622, '[[regtime]]', '[[regtime]]'),
(624, 'english', 'Enable <abbr title="Single Sign On">SSO</abbr> with a third party software through a token', '2020-09-15 14:47:12', 623, '[[regtime]]', '[[regtime]]'),
(625, 'english', 'Disable simultaneous access with the same username', '2020-09-15 14:47:12', 624, '[[regtime]]', '[[regtime]]'),
(626, 'english', 'Courses sorting order in "My courses"', '2020-09-15 14:47:12', 625, '[[regtime]]', '[[regtime]]'),
(627, 'english', 'Max users per room', '2020-09-15 14:47:12', 626, '[[regtime]]', '[[regtime]]'),
(628, 'english', 'Max rooms', '2020-09-15 14:47:12', 627, '[[regtime]]', '[[regtime]]'),
(629, 'english', 'Domain Template', '2020-09-15 14:47:12', 628, '[[regtime]]', '[[regtime]]'),
(630, 'english', 'Domain Template assignment', '2020-09-15 14:47:12', 629, '[[regtime]]', '[[regtime]]'),
(631, 'english', 'Allow user tracking (Recommended: yes)', '2020-09-15 14:47:12', 630, '[[regtime]]', '[[regtime]]'),
(632, 'english', 'Session lifetime', '2020-09-15 14:47:12', 631, '[[regtime]]', '[[regtime]]'),
(633, 'english', 'Twig Cache', '2020-09-15 14:47:12', 632, '[[regtime]]', '[[regtime]]'),
(634, 'english', 'FTP connection', '2020-09-15 14:47:12', 633, '[[regtime]]', '[[regtime]]'),
(635, 'english', 'Configuration of "upload_max_filesize"', '2020-09-15 14:47:12', 634, '[[regtime]]', '[[regtime]]'),
(636, 'english', 'Website URL with final /', '2020-09-15 14:47:12', 635, '[[regtime]]', '[[regtime]]'),
(637, 'english', 'URL for check-in', '2020-09-15 14:47:12', 636, '[[regtime]]', '[[regtime]]'),
(638, 'english', 'URL for videoconference', '2020-09-15 14:47:12', 637, '[[regtime]]', '[[regtime]]'),
(639, 'english', 'Consider this parameter only if you need to authenticate through LDAP', '2020-09-15 14:47:12', 638, '[[regtime]]', '[[regtime]]'),
(640, 'english', 'already assigned users', '2020-09-15 14:47:12', 639, '[[regtime]]', '[[regtime]]'),
(641, 'english', 'Ask the user to choose a password different from the last X used passwords', '2020-09-15 14:47:12', 640, '[[regtime]]', '[[regtime]]'),
(642, 'english', 'Disk quota (in MB) for each user''s My Files area', '2020-09-15 14:47:12', 641, '[[regtime]]', '[[regtime]]'),
(643, 'english', 'Use advanced registration form', '2020-09-15 14:47:12', 642, '[[regtime]]', '[[regtime]]'),
(644, 'english', 'Use label for courses', '2020-09-15 14:47:12', 643, '[[regtime]]', '[[regtime]]'),
(645, 'english', 'Use DimDim API instead of URL interfacing', '2020-09-15 14:47:12', 644, '[[regtime]]', '[[regtime]]'),
(646, 'english', 'Create report and send it by email as soon as it is ready (report execution must be enabled in crontab)', '2020-09-15 14:47:12', 645, '[[regtime]]', '[[regtime]]'),
(647, 'english', 'Enable the API functionality', '2020-09-15 14:47:12', 646, '[[regtime]]', '[[regtime]]'),
(648, 'english', 'Sender name from for alert messages', '2022-03-10 11:47:16', 647, '[[regtime]]', '[[regtime]]'),
(649, 'english', 'Enable tags feature inside forums', '2020-09-15 14:47:12', 648, '[[regtime]]', '[[regtime]]'),
(650, 'english', 'Attention without these settings the social login will not work', '2020-09-15 14:47:12', 649, '[[regtime]]', '[[regtime]]'),
(651, 'english', 'Purchase User (Username or idst)', '2020-09-15 14:47:12', 650, '[[regtime]]', '[[regtime]]'),
(652, 'english', 'Force SCORM finish', '2024-01-15 14:47:12', 651, '[[regtime]]', '[[regtime]]'),
(653, 'english', 'Exclude completed course from the view "All open"', '2024-01-15 14:47:12', 652, '[[regtime]]', '[[regtime]]'),
(654, 'english', 'Minimum number of special characters<br>( 0 = special characters not mandatory )', '2024-01-15 14:47:12', 653, '[[regtime]]', '[[regtime]]'),
(655, 'english', 'Minimum number of uppercase characters<br>( 0 = uppercase characters not mandatory)', '2024-01-15 14:47:12', 654, '[[regtime]]', '[[regtime]]'),
(656, 'english', 'Minimum number of lowercase characters<br>( 0 = lowercase characters not mandatory )', '2024-01-15 14:47:12', 655, '[[regtime]]', '[[regtime]]'),
(657, 'english', 'Minimum number of digit characters<br>( 0 = digit characters not mandatory )', '2024-01-15 14:47:12', 656, '[[regtime]]', '[[regtime]]'),
(658, 'english', '<br>Send an email one day before password expiration<br>(enable cron job)', '2024-01-15 14:47:12', 657, '[[regtime]]', '[[regtime]]'),
(659, 'english', '<br>Apply password control policies to admins', '2024-01-15 14:47:12', 658, '[[regtime]]', '[[regtime]]'),
(660, 'english', 'Year selection', '2023-10-12 15:32:39', 659, '[[regtime]]', '[[regtime]]'),
(661, 'english', 'Course type selection', '2023-10-12 15:32:39', 660, '[[regtime]]', '[[regtime]]'),
(662, 'english', 'Add file', '2020-09-15 14:47:12', 661, '[[regtime]]', '[[regtime]]'),
(663, 'english', 'Add new file', '2020-09-15 14:47:12', 662, '[[regtime]]', '[[regtime]]'),
(664, 'english', 'Enroll users in this course', '2020-09-15 14:47:12', 663, '[[regtime]]', '[[regtime]]'),
(665, 'english', 'There is [advice] new advice', '2020-09-15 14:47:12', 664, '[[regtime]]', '[[regtime]]'),
(666, 'english', 'There are [forum] new messages in the forum', '2020-09-15 14:47:12', 665, '[[regtime]]', '[[regtime]]'),
(667, 'english', 'There are [lobj] new learning objects', '2020-09-15 14:47:12', 666, '[[regtime]]', '[[regtime]]'),
(668, 'english', 'Allow overbooking', '2020-09-15 14:47:12', 667, '[[regtime]]', '[[regtime]]'),
(669, 'english', 'All types of course', '2020-09-15 14:47:12', 668, '[[regtime]]', '[[regtime]]'),
(670, 'english', 'All open', '2020-09-15 14:47:12', 669, '[[regtime]]', '[[regtime]]'),
(671, 'english', 'All years', '2020-09-15 14:47:12', 670, '[[regtime]]', '[[regtime]]'),
(672, 'english', 'Assign for any user''s status', '2020-09-15 14:47:12', 671, '[[regtime]]', '[[regtime]]'),
(673, 'english', 'Minimum time of fruition for the assignment (min.)', '2020-09-15 14:47:12', 672, '[[regtime]]', '[[regtime]]'),
(674, 'english', 'Assign for users that have  completed the course', '2020-09-15 14:47:12', 673, '[[regtime]]', '[[regtime]]'),
(675, 'english', 'Assign for users that are attending the course', '2020-09-15 14:47:12', 674, '[[regtime]]', '[[regtime]]'),
(676, 'english', 'Assign a new menu to the course', '2020-09-15 14:47:12', 675, '[[regtime]]', '[[regtime]]'),
(677, 'english', 'Registration code', '2020-09-15 14:47:12', 676, '[[regtime]]', '[[regtime]]'),
(678, 'english', 'Back to the admin area', '2020-09-15 14:47:12', 677, '[[regtime]]', '[[regtime]]'),
(679, 'english', 'Allowed to buy this course', '2020-09-15 14:47:12', 678, '[[regtime]]', '[[regtime]]'),
(680, 'english', 'Calendar classroom edition', '2020-09-15 14:47:12', 679, '[[regtime]]', '[[regtime]]'),
(681, 'english', 'Subscribe', '2020-09-15 14:47:12', 680, '[[regtime]]', '[[regtime]]'),
(682, 'english', 'Copy changes also to editions', '2020-09-15 14:47:12', 681, '[[regtime]]', '[[regtime]]'),
(683, 'english', 'You are in', '2020-09-15 14:47:12', 682, '[[regtime]]', '[[regtime]]'),
(684, 'english', 'Selected category', '2020-09-15 14:47:12', 683, '[[regtime]]', '[[regtime]]'),
(685, 'english', 'Certificate release', '2020-09-15 14:47:12', 684, '[[regtime]]', '[[regtime]]'),
(686, 'english', 'Certificate assignment for Excellence', '2020-09-15 14:47:12', 685, '[[regtime]]', '[[regtime]]'),
(687, 'english', 'Certificate language', '2020-09-15 14:47:12', 686, '[[regtime]]', '[[regtime]]'),
(688, 'english', 'Certificate', '2020-09-15 14:47:12', 687, '[[regtime]]', '[[regtime]]'),
(689, 'english', 'Certificates release', '2020-09-15 14:47:12', 688, '[[regtime]]', '[[regtime]]'),
(690, 'english', 'Number of released certificates', '2020-09-15 14:47:12', 689, '[[regtime]]', '[[regtime]]'),
(691, 'english', 'Classroom -> Course association', '2020-09-15 14:47:12', 690, '[[regtime]]', '[[regtime]]'),
(692, 'english', 'Classrooms/Editions', '2020-09-15 14:47:12', 691, '[[regtime]]', '[[regtime]]'),
(693, 'english', 'Warning: some classrooms are already occupied by other courses', '2020-09-15 14:47:12', 692, '[[regtime]]', '[[regtime]]'),
(694, 'english', 'Class occupied', '2020-09-15 14:47:12', 693, '[[regtime]]', '[[regtime]]'),
(695, 'english', 'Closing date', '2020-09-15 14:47:12', 694, '[[regtime]]', '[[regtime]]'),
(696, 'english', 'Your data will be saved.', '2020-09-15 14:47:12', 695, '[[regtime]]', '[[regtime]]'),
(697, 'english', 'Copy subscriptions to course', '2020-09-15 14:47:12', 696, '[[regtime]]', '[[regtime]]'),
(698, 'english', 'Advance payment', '2020-09-15 14:47:12', 697, '[[regtime]]', '[[regtime]]'),
(699, 'english', 'Code for the automatic subscription to a course', '2020-09-15 14:47:12', 698, '[[regtime]]', '[[regtime]]'),
(700, 'english', 'Available courses', '2020-09-15 14:47:12', 699, '[[regtime]]', '[[regtime]]'),
(701, 'english', 'Course duration: from <b>[date_begin]</b> to <b>[date_end]</b>.', '2020-09-15 14:47:12', 700, '[[regtime]]', '[[regtime]]'),
(702, 'english', 'Demo material', '2020-09-15 14:47:12', 701, '[[regtime]]', '[[regtime]]'),
(703, 'english', 'Display mode options', '2020-09-15 14:47:12', 702, '[[regtime]]', '[[regtime]]'),
(704, 'english', 'Does the course contain editions?', '2020-09-15 14:47:12', 703, '[[regtime]]', '[[regtime]]'),
(705, 'english', 'Automatic after completing the end course LO', '2020-09-15 14:47:12', 704, '[[regtime]]', '[[regtime]]'),
(706, 'english', 'Manual teacher action', '2020-09-15 14:47:12', 705, '[[regtime]]', '[[regtime]]'),
(707, 'english', 'Completion mode', '2020-09-15 14:47:12', 706, '[[regtime]]', '[[regtime]]'),
(708, 'english', 'Course is: <b>[course_type]</b> with: <b>[enrolled]</b> users subscribed', '2020-09-15 14:47:12', 707, '[[regtime]]', '[[regtime]]'),
(709, 'english', 'Course is: <b>[course_type]</b> with: <b>[enrolled]</b> out of a maximum of: <b>[max_subscribe]</b> subscribed users. Course is: <b>[course_status]</b>', '2020-09-15 14:47:12', 708, '[[regtime]]', '[[regtime]]'),
(710, 'english', 'Course language', '2020-09-15 14:47:12', 709, '[[regtime]]', '[[regtime]]'),
(711, 'english', 'This is a list with all the courses to which the user subscribed and other relevant information', '2020-09-15 14:47:12', 710, '[[regtime]]', '[[regtime]]'),
(712, 'english', 'Course logo', '2020-09-15 14:47:12', 711, '[[regtime]]', '[[regtime]]'),
(713, 'english', 'Assign the menu', '2020-09-15 14:47:12', 712, '[[regtime]]', '[[regtime]]'),
(714, 'english', 'Price', '2020-09-15 14:47:12', 713, '[[regtime]]', '[[regtime]]'),
(715, 'english', 'Assign disk space limit to this course (MB)', '2020-09-15 14:47:12', 714, '[[regtime]]', '[[regtime]]'),
(716, 'english', 'Select course', '2020-09-15 14:47:12', 715, '[[regtime]]', '[[regtime]]'),
(717, 'english', 'Sell course', '2020-09-15 14:47:12', 716, '[[regtime]]', '[[regtime]]'),
(718, 'english', 'Special options', '2020-09-15 14:47:12', 717, '[[regtime]]', '[[regtime]]'),
(719, 'english', 'Deny access to this course if the user status is', '2020-09-15 14:47:12', 718, '[[regtime]]', '[[regtime]]'),
(720, 'english', 'Course subscription', '2020-09-15 14:47:12', 719, '[[regtime]]', '[[regtime]]'),
(721, 'english', 'Enrollment policy', '2020-09-15 14:47:12', 720, '[[regtime]]', '[[regtime]]'),
(722, 'english', 'Only admin', '2020-09-15 14:47:12', 721, '[[regtime]]', '[[regtime]]'),
(723, 'english', 'On approval', '2020-09-15 14:47:12', 722, '[[regtime]]', '[[regtime]]'),
(724, 'english', 'Subscription through secret code', '2020-09-15 14:47:12', 723, '[[regtime]]', '[[regtime]]'),
(725, 'english', 'Course instructors', '2020-09-15 14:47:12', 724, '[[regtime]]', '[[regtime]]'),
(726, 'english', 'Time options', '2020-09-15 14:47:12', 725, '[[regtime]]', '[[regtime]]'),
(727, 'english', 'Course type', '2020-09-15 14:47:12', 726, '[[regtime]]', '[[regtime]]'),
(728, 'english', 'Blended', '2020-09-15 14:47:12', 727, '[[regtime]]', '[[regtime]]'),
(729, 'english', 'E-learning with editions', '2020-09-15 14:47:12', 728, '[[regtime]]', '[[regtime]]'),
(730, 'english', 'E-learning', '2020-09-15 14:47:12', 729, '[[regtime]]', '[[regtime]]'),
(731, 'english', 'Subscribed users', '2020-09-15 14:47:12', 730, '[[regtime]]', '[[regtime]]'),
(732, 'english', 'Active since', '2020-09-15 14:47:12', 731, '[[regtime]]', '[[regtime]]'),
(733, 'english', 'Available', '2020-09-15 14:47:12', 732, '[[regtime]]', '[[regtime]]'),
(734, 'english', 'Cancelled', '2020-09-15 14:47:12', 733, '[[regtime]]', '[[regtime]]'),
(735, 'english', 'Concluded', '2020-09-15 14:47:12', 734, '[[regtime]]', '[[regtime]]'),
(736, 'english', 'Confirmed', '2020-09-15 14:47:12', 735, '[[regtime]]', '[[regtime]]'),
(737, 'english', 'Under construction', '2020-09-15 14:47:12', 736, '[[regtime]]', '[[regtime]]'),
(738, 'english', 'Custom Options', '2020-09-15 14:47:12', 737, '[[regtime]]', '[[regtime]]'),
(739, 'english', 'Date', '2020-09-15 14:47:12', 738, '[[regtime]]', '[[regtime]]'),
(740, 'english', 'Date end', '2020-09-15 14:47:12', 739, '[[regtime]]', '[[regtime]]'),
(741, 'english', 'Date start', '2020-09-15 14:47:12', 740, '[[regtime]]', '[[regtime]]'),
(742, 'english', 'Day', '2020-09-15 14:47:12', 741, '[[regtime]]', '[[regtime]]'),
(743, 'english', 'Days', '2020-09-15 14:47:12', 742, '[[regtime]]', '[[regtime]]'),
(744, 'english', 'Days of validity', '2020-09-15 14:47:12', 743, '[[regtime]]', '[[regtime]]'),
(745, 'english', 'Show demo', '2020-09-15 14:47:12', 744, '[[regtime]]', '[[regtime]]'),
(746, 'english', 'Directly play the first Learning Object in the player', '2020-09-15 14:47:12', 745, '[[regtime]]', '[[regtime]]'),
(747, 'english', 'Disabled', '2020-09-15 14:47:12', 746, '[[regtime]]', '[[regtime]]'),
(748, 'english', 'Documents upload', '2020-09-15 14:47:12', 747, '[[regtime]]', '[[regtime]]'),
(749, 'english', 'Don''t show', '2020-09-15 14:47:12', 748, '[[regtime]]', '[[regtime]]'),
(750, 'english', 'Show material', '2020-09-15 14:47:12', 749, '[[regtime]]', '[[regtime]]'),
(751, 'english', 'Duration', '2020-09-15 14:47:12', 750, '[[regtime]]', '[[regtime]]'),
(752, 'english', 'start on <b>[date_begin]</b> and end on <b>[date_end]</b>', '2020-09-15 14:47:12', 751, '[[regtime]]', '[[regtime]]'),
(753, 'english', 'Object marked as final', '2020-09-15 14:47:12', 752, '[[regtime]]', '[[regtime]]'),
(754, 'english', 'Access to this course has expired', '2020-09-15 14:47:12', 753, '[[regtime]]', '[[regtime]]'),
(755, 'english', 'This course will expire in <b>[expiring_in]</b> days', '2020-09-15 14:47:12', 754, '[[regtime]]', '[[regtime]]'),
(756, 'english', 'No files have been specified', '2020-09-15 14:47:12', 755, '[[regtime]]', '[[regtime]]'),
(757, 'english', 'Flat view', '2020-09-15 14:47:12', 756, '[[regtime]]', '[[regtime]]'),
(758, 'english', 'Choose a course', '2020-09-15 14:47:12', 757, '[[regtime]]', '[[regtime]]'),
(759, 'english', 'Generate new codes', '2020-09-15 14:47:12', 758, '[[regtime]]', '[[regtime]]'),
(760, 'english', 'Subscription OK', '2020-09-15 14:47:12', 759, '[[regtime]]', '[[regtime]]'),
(761, 'english', 'Starting hour', '2020-09-15 14:47:12', 760, '[[regtime]]', '[[regtime]]'),
(762, 'english', 'Ending hour', '2020-09-15 14:47:12', 761, '[[regtime]]', '[[regtime]]'),
(763, 'english', 'If you specify a new file, the previous one will be overwritten', '2020-09-15 14:47:12', 762, '[[regtime]]', '[[regtime]]'),
(764, 'english', 'Import subscriptions from a course', '2020-09-15 14:47:12', 763, '[[regtime]]', '[[regtime]]'),
(765, 'english', 'Subscribe users imported from file', '2020-09-15 14:47:12', 764, '[[regtime]]', '[[regtime]]'),
(766, 'english', 'Course', '2020-09-15 14:47:12', 765, '[[regtime]]', '[[regtime]]'),
(767, 'english', 'Inherit disk quota from standard settings', '2020-09-15 14:47:12', 766, '[[regtime]]', '[[regtime]]'),
(768, 'english', 'You are in', '2020-09-15 14:47:12', 767, '[[regtime]]', '[[regtime]]'),
(769, 'english', 'in classroom <b>[classrooms_name]</b> in building <b>[classrooms_location]</b>.', '2020-09-15 14:47:12', 768, '[[regtime]]', '[[regtime]]'),
(770, 'english', 'Hide info', '2020-09-15 14:47:12', 769, '[[regtime]]', '[[regtime]]'),
(771, 'english', 'Main category', '2020-09-15 14:47:12', 770, '[[regtime]]', '[[regtime]]'),
(772, 'english', 'Selected by instructor', '2020-09-15 14:47:12', 771, '[[regtime]]', '[[regtime]]'),
(773, 'english', 'Course material', '2020-09-15 14:47:12', 772, '[[regtime]]', '[[regtime]]'),
(774, 'english', 'Course file', '2020-09-15 14:47:12', 773, '[[regtime]]', '[[regtime]]'),
(775, 'english', 'Max number of subscriptions', '2020-09-15 14:47:12', 774, '[[regtime]]', '[[regtime]]'),
(776, 'english', 'Max budget for SMS', '2020-09-15 14:47:12', 775, '[[regtime]]', '[[regtime]]'),
(777, 'english', 'Average', '2020-09-15 14:47:12', 776, '[[regtime]]', '[[regtime]]'),
(778, 'english', 'Average completion time', '2020-09-15 14:47:12', 777, '[[regtime]]', '[[regtime]]'),
(779, 'english', 'Average time for course', '2020-09-15 14:47:12', 778, '[[regtime]]', '[[regtime]]'),
(780, 'english', 'Minimum number of subscription (0 = unlimited)', '2020-09-15 14:47:12', 779, '[[regtime]]', '[[regtime]]'),
(781, 'english', 'Please enter a valid min score', '2020-09-15 14:47:12', 780, '[[regtime]]', '[[regtime]]'),
(782, 'english', 'Minimum number of subscribed students allowed is <b>[min_subscribe]</b>', '2020-09-15 14:47:12', 781, '[[regtime]]', '[[regtime]]'),
(783, 'english', 'Multiple subscriptions', '2020-09-15 14:47:12', 782, '[[regtime]]', '[[regtime]]'),
(784, 'english', 'My certificates', '2020-09-15 14:47:12', 783, '[[regtime]]', '[[regtime]]'),
(785, 'english', 'User is waiting at [url]', '2020-09-15 14:47:12', 784, '[[regtime]]', '[[regtime]]'),
(786, 'english', 'Next lesson', '2020-09-15 14:47:12', 785, '[[regtime]]', '[[regtime]]'),
(787, 'english', 'Waiting for activation', '2020-09-15 14:47:12', 786, '[[regtime]]', '[[regtime]]'),
(788, 'english', 'Access denied', '2020-09-15 14:47:12', 787, '[[regtime]]', '[[regtime]]'),
(789, 'english', 'Course with no start date', '2020-09-15 14:47:12', 788, '[[regtime]]', '[[regtime]]'),
(790, 'english', 'No course found', '2020-09-15 14:47:12', 789, '[[regtime]]', '[[regtime]]'),
(791, 'english', 'Other options', '2020-09-15 14:47:12', 790, '[[regtime]]', '[[regtime]]'),
(792, 'english', 'Material for other roles', '2020-09-15 14:47:12', 791, '[[regtime]]', '[[regtime]]'),
(793, 'english', 'Overview', '2022-03-10 11:47:16', 792, '[[regtime]]', '[[regtime]]'),
(794, 'english', 'Session time', '2020-09-15 14:47:12', 793, '[[regtime]]', '[[regtime]]'),
(795, 'english', 'Pause start', '2020-09-15 14:47:12', 794, '[[regtime]]', '[[regtime]]'),
(796, 'english', 'Pause end', '2020-09-15 14:47:12', 795, '[[regtime]]', '[[regtime]]'),
(797, 'english', 'Complete course method', '2020-09-15 14:47:12', 796, '[[regtime]]', '[[regtime]]'),
(798, 'english', 'Objects', '2020-09-15 14:47:12', 797, '[[regtime]]', '[[regtime]]'),
(799, 'english', 'progress', '2020-09-15 14:47:12', 798, '[[regtime]]', '[[regtime]]'),
(800, 'english', 'Completed', '2020-09-15 14:47:12', 799, '[[regtime]]', '[[regtime]]'),
(801, 'english', 'Failed', '2020-09-15 14:47:12', 800, '[[regtime]]', '[[regtime]]'),
(802, 'english', 'Not completed', '2020-09-15 14:47:12', 801, '[[regtime]]', '[[regtime]]'),
(803, 'english', 'Passed', '2020-09-15 14:47:12', 802, '[[regtime]]', '[[regtime]]'),
(804, 'english', 'Objects: [total], passed: [complete], failed: [failed]', '2020-09-15 14:47:12', 803, '[[regtime]]', '[[regtime]]'),
(805, 'english', 'You can''t upload any further files because the disk space for this course is full', '2020-09-15 14:47:12', 804, '[[regtime]]', '[[regtime]]'),
(806, 'english', 'Generate random code for self-registration', '2020-09-15 14:47:12', 805, '[[regtime]]', '[[regtime]]'),
(807, 'english', 'Reserve course', '2020-09-15 14:47:12', 806, '[[regtime]]', '[[regtime]]'),
(808, 'english', 'Result', '2020-09-15 14:47:12', 807, '[[regtime]]', '[[regtime]]'),
(809, 'english', 'Everyone, and show on home page', '2020-09-15 14:47:12', 808, '[[regtime]]', '[[regtime]]'),
(810, 'english', 'Only users subscribed to the course', '2020-09-15 14:47:12', 809, '[[regtime]]', '[[regtime]]'),
(811, 'english', 'Only for logged in users', '2020-09-15 14:47:12', 810, '[[regtime]]', '[[regtime]]'),
(812, 'english', 'Select course''s days', '2020-09-15 14:47:12', 811, '[[regtime]]', '[[regtime]]'),
(813, 'english', 'Unsubscribe from the course', '2020-09-15 14:47:12', 812, '[[regtime]]', '[[regtime]]'),
(814, 'english', 'Advanced course info', '2020-09-15 14:47:12', 813, '[[regtime]]', '[[regtime]]'),
(815, 'english', 'Show all dates', '2020-09-15 14:47:12', 814, '[[regtime]]', '[[regtime]]'),
(816, 'english', 'Show only number of connected users, but don''t use Instant Messenger', '2020-09-15 14:47:12', 815, '[[regtime]]', '[[regtime]]'),
(817, 'english', 'Demo', '2020-09-15 14:47:12', 816, '[[regtime]]', '[[regtime]]'),
(818, 'english', 'Show Instant Messenger', '2020-09-15 14:47:12', 817, '[[regtime]]', '[[regtime]]'),
(819, 'english', 'Show progress', '2020-09-15 14:47:12', 818, '[[regtime]]', '[[regtime]]'),
(820, 'english', 'Show time', '2020-09-15 14:47:12', 819, '[[regtime]]', '[[regtime]]'),
(821, 'english', 'Select levels of users shown on information course page', '2020-09-15 14:47:12', 820, '[[regtime]]', '[[regtime]]'),
(822, 'english', 'Users online in this course', '2020-09-15 14:47:12', 821, '[[regtime]]', '[[regtime]]'),
(823, 'english', 'Sponsored by', '2020-09-15 14:47:12', 822, '[[regtime]]', '[[regtime]]'),
(824, 'english', 'Link to the sponsor', '2020-09-15 14:47:12', 823, '[[regtime]]', '[[regtime]]'),
(825, 'english', 'Logo', '2020-09-15 14:47:12', 824, '[[regtime]]', '[[regtime]]'),
(826, 'english', 'Status not allowed to enter the course', '2020-09-15 14:47:12', 825, '[[regtime]]', '[[regtime]]'),
(827, 'english', 'Already subscribed to the course', '2020-09-15 14:47:12', 826, '[[regtime]]', '[[regtime]]'),
(828, 'english', 'Subscribe method', '2020-09-15 14:47:12', 827, '[[regtime]]', '[[regtime]]'),
(829, 'english', 'Subscription', '2020-09-15 14:47:12', 828, '[[regtime]]', '[[regtime]]'),
(830, 'english', 'Subscriptions are closed', '2020-09-15 14:47:12', 829, '[[regtime]]', '[[regtime]]'),
(831, 'english', 'Subscription successfull', '2020-09-15 14:47:12', 830, '[[regtime]]', '[[regtime]]'),
(832, 'english', 'From', '2020-09-15 14:47:12', 831, '[[regtime]]', '[[regtime]]'),
(833, 'english', 'Registration is open from', '2020-09-15 14:47:12', 832, '[[regtime]]', '[[regtime]]'),
(834, 'english', 'To', '2020-09-15 14:47:12', 833, '[[regtime]]', '[[regtime]]'),
(835, 'english', 'Error during subscription', '2020-09-15 14:47:12', 834, '[[regtime]]', '[[regtime]]'),
(836, 'english', 'Subscription is available during the following period', '2020-09-15 14:47:12', 835, '[[regtime]]', '[[regtime]]'),
(837, 'english', 'Subscriptions are open', '2020-09-15 14:47:12', 836, '[[regtime]]', '[[regtime]]'),
(838, 'english', 'You have asked to buy the course: <b>[name]</b><br />\nIn order to proceed, you must log in to the platform if you are already registered.<br />\nOtherwise, you must register in our system, following this link: <br />\n<br />\n<a href="[link_register]">Register me</a>', '2020-09-15 14:47:12', 837, '[[regtime]]', '[[regtime]]'),
(839, 'english', 'Teachers:', '2020-09-15 14:47:12', 838, '[[regtime]]', '[[regtime]]'),
(840, 'english', 'Go to the content of', '2020-09-15 14:47:12', 839, '[[regtime]]', '[[regtime]]'),
(841, 'english', 'Association of certificates to course', '2020-09-15 14:47:12', 840, '[[regtime]]', '[[regtime]]'),
(842, 'english', 'Total access time', '2020-09-15 14:47:12', 841, '[[regtime]]', '[[regtime]]'),
(843, 'english', 'You are attending this course', '2020-09-15 14:47:12', 842, '[[regtime]]', '[[regtime]]'),
(844, 'english', 'Confirmed', '2020-09-15 14:47:12', 843, '[[regtime]]', '[[regtime]]'),
(845, 'english', 'You have completed this course', '2020-09-15 14:47:12', 844, '[[regtime]]', '[[regtime]]'),
(846, 'english', 'Reserved', '2020-09-15 14:47:12', 845, '[[regtime]]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES
(847, 'english', 'You haven’t started to attend this course yet', '2020-09-15 14:47:12', 846, '[[regtime]]', '[[regtime]]'),
(848, 'english', 'No disk space limit', '2020-09-15 14:47:12', 847, '[[regtime]]', '[[regtime]]'),
(849, 'english', 'Unsubscribe date limit', '2020-09-15 14:47:12', 848, '[[regtime]]', '[[regtime]]'),
(850, 'english', 'Unsubscribe requests', '2020-09-15 14:47:12', 849, '[[regtime]]', '[[regtime]]'),
(851, 'english', 'Unsubscribe request waiting for approval', '2020-09-15 14:47:12', 850, '[[regtime]]', '[[regtime]]'),
(852, 'english', 'Disk space used for this course', '2020-09-15 14:47:12', 851, '[[regtime]]', '[[regtime]]'),
(853, 'english', 'User waiting for approval', '2020-09-15 14:47:12', 852, '[[regtime]]', '[[regtime]]'),
(854, 'english', 'Can the user subscribe?', '2020-09-15 14:47:12', 853, '[[regtime]]', '[[regtime]]'),
(855, 'english', 'Auto - unsubscribe', '2020-09-15 14:47:12', 854, '[[regtime]]', '[[regtime]]'),
(856, 'english', 'There are now <b>[user_count]</b> users subscribed and <b>[waiting_count]</b> waiting.', '2020-09-15 14:47:12', 855, '[[regtime]]', '[[regtime]]'),
(857, 'english', ', your level is <b>[level]</b>', '2020-09-15 14:47:12', 856, '[[regtime]]', '[[regtime]]'),
(858, 'english', 'Material for users', '2020-09-15 14:47:12', 857, '[[regtime]]', '[[regtime]]'),
(859, 'english', 'Select', '2020-09-15 14:47:12', 858, '[[regtime]]', '[[regtime]]'),
(860, 'english', 'Show course logo in course list', '2020-09-15 14:47:12', 859, '[[regtime]]', '[[regtime]]'),
(861, 'english', 'Bad', '2020-09-15 14:47:12', 860, '[[regtime]]', '[[regtime]]'),
(862, 'english', 'Give to this course a negative evaluation', '2020-09-15 14:47:12', 861, '[[regtime]]', '[[regtime]]'),
(863, 'english', 'Good', '2020-09-15 14:47:12', 862, '[[regtime]]', '[[regtime]]'),
(864, 'english', 'Give to this course a positive evaluation', '2020-09-15 14:47:12', 863, '[[regtime]]', '[[regtime]]'),
(865, 'english', 'In progress', '2020-09-15 14:47:12', 864, '[[regtime]]', '[[regtime]]'),
(866, 'english', 'Welcome', '2020-09-15 14:47:12', 865, '[[regtime]]', '[[regtime]]'),
(867, 'english', 'Show on course interface', '2020-09-15 14:47:12', 866, '[[regtime]]', '[[regtime]]'),
(868, 'english', 'Show course to:', '2020-09-15 14:47:12', 867, '[[regtime]]', '[[regtime]]'),
(869, 'english', 'Online users', '2020-09-15 14:47:12', 868, '[[regtime]]', '[[regtime]]'),
(870, 'english', 'Del. subscr.', '2020-09-15 14:47:12', 869, '[[regtime]]', '[[regtime]]'),
(871, 'english', 'Do you really want to remove the course from this curriculum?', '2020-09-15 14:47:12', 870, '[[regtime]]', '[[regtime]]'),
(872, 'english', 'Available curricula', '2020-09-15 14:47:12', 871, '[[regtime]]', '[[regtime]]'),
(873, 'english', 'Courses included in this curricula', '2020-09-15 14:47:12', 872, '[[regtime]]', '[[regtime]]'),
(874, 'english', 'Subscription method', '2020-09-15 14:47:12', 873, '[[regtime]]', '[[regtime]]'),
(875, 'english', 'Only admin', '2020-09-15 14:47:12', 874, '[[regtime]]', '[[regtime]]'),
(876, 'english', 'Moderate', '2020-09-15 14:47:12', 875, '[[regtime]]', '[[regtime]]'),
(877, 'english', 'Current Activity', '2020-09-15 14:47:12', 876, '[[regtime]]', '[[regtime]]'),
(878, 'english', 'Import courses in curricula', '2020-09-15 14:47:12', 877, '[[regtime]]', '[[regtime]]'),
(879, 'english', 'User currently subscribed', '2020-09-15 14:47:12', 878, '[[regtime]]', '[[regtime]]'),
(880, 'english', 'Information about the selected activities', '2020-09-15 14:47:12', 879, '[[regtime]]', '[[regtime]]'),
(881, 'english', 'New activity', '2020-09-15 14:47:12', 880, '[[regtime]]', '[[regtime]]'),
(882, 'english', 'Add new activity', '2020-09-15 14:47:12', 881, '[[regtime]]', '[[regtime]]'),
(883, 'english', 'Add SCORM Results', '2020-09-15 14:47:12', 882, '[[regtime]]', '[[regtime]]'),
(884, 'english', 'Right answer', '2020-09-15 14:47:12', 883, '[[regtime]]', '[[regtime]]'),
(885, 'english', 'Test for this course', '2020-09-15 14:47:12', 884, '[[regtime]]', '[[regtime]]'),
(886, 'english', 'This is the list of all the tests for this course and the results for the students', '2020-09-15 14:47:12', 885, '[[regtime]]', '[[regtime]]'),
(887, 'english', 'Detail', '2020-09-15 14:47:12', 886, '[[regtime]]', '[[regtime]]'),
(888, 'english', 'Save stats', '2020-09-15 14:47:12', 887, '[[regtime]]', '[[regtime]]'),
(889, 'english', 'Left', '2020-09-15 14:47:12', 888, '[[regtime]]', '[[regtime]]'),
(890, 'english', 'Move left', '2020-09-15 14:47:12', 889, '[[regtime]]', '[[regtime]]'),
(891, 'english', 'Move right', '2020-09-15 14:47:12', 890, '[[regtime]]', '[[regtime]]'),
(892, 'english', 'Not checked', '2020-09-15 14:47:12', 891, '[[regtime]]', '[[regtime]]'),
(893, 'english', 'Not passed', '2020-09-15 14:47:12', 892, '[[regtime]]', '[[regtime]]'),
(894, 'english', 'of the user', '2020-09-15 14:47:12', 893, '[[regtime]]', '[[regtime]]'),
(895, 'english', 'Overview', '2020-09-15 14:47:12', 894, '[[regtime]]', '[[regtime]]'),
(896, 'english', 'Passed', '2020-09-15 14:47:12', 895, '[[regtime]]', '[[regtime]]'),
(897, 'english', 'Percentage of correct answers', '2020-09-15 14:47:12', 896, '[[regtime]]', '[[regtime]]'),
(898, 'english', 'Answered questions', '2020-09-15 14:47:12', 897, '[[regtime]]', '[[regtime]]'),
(899, 'english', 'Re-calculate', '2020-09-15 14:47:12', 898, '[[regtime]]', '[[regtime]]'),
(900, 'english', 'Re-calculate score', '2020-09-15 14:47:12', 899, '[[regtime]]', '[[regtime]]'),
(901, 'english', 'The required score must be smaller than the max score', '2020-09-15 14:47:12', 900, '[[regtime]]', '[[regtime]]'),
(902, 'english', 'Delete test track', '2020-09-15 14:47:12', 901, '[[regtime]]', '[[regtime]]'),
(903, 'english', 'Right', '2020-09-15 14:47:12', 902, '[[regtime]]', '[[regtime]]'),
(904, 'english', 'Round final score', '2020-09-15 14:47:12', 903, '[[regtime]]', '[[regtime]]'),
(905, 'english', 'Round', '2020-09-15 14:47:12', 904, '[[regtime]]', '[[regtime]]'),
(906, 'english', 'Round', '2020-09-15 14:47:12', 905, '[[regtime]]', '[[regtime]]'),
(907, 'english', 'Show answer', '2020-09-15 14:47:12', 906, '[[regtime]]', '[[regtime]]'),
(908, 'english', 'Show to user', '2020-09-15 14:47:12', 907, '[[regtime]]', '[[regtime]]'),
(909, 'english', 'Standard deviation', '2020-09-15 14:47:12', 908, '[[regtime]]', '[[regtime]]'),
(910, 'english', 'Students', '2020-09-15 14:47:12', 909, '[[regtime]]', '[[regtime]]'),
(911, 'english', 'Student''s scores', '2020-09-15 14:47:12', 910, '[[regtime]]', '[[regtime]]'),
(912, 'english', 'Evaluation summary', '2020-09-15 14:47:12', 911, '[[regtime]]', '[[regtime]]'),
(913, 'english', 'Stats for question "[title]"', '2020-09-15 14:47:12', 912, '[[regtime]]', '[[regtime]]'),
(914, 'english', 'Percentage of correct answers for link "[title]"', '2020-09-15 14:47:12', 913, '[[regtime]]', '[[regtime]]'),
(915, 'english', 'Percentage of correct answers after inserting text in phrase "[title]"', '2020-09-15 14:47:12', 914, '[[regtime]]', '[[regtime]]'),
(916, 'english', 'Insert list for question "[title]"', '2020-09-15 14:47:12', 915, '[[regtime]]', '[[regtime]]'),
(917, 'english', 'Information about the test', '2020-09-15 14:47:12', 916, '[[regtime]]', '[[regtime]]'),
(918, 'english', 'Test report', '2020-09-15 14:47:12', 917, '[[regtime]]', '[[regtime]]'),
(919, 'english', 'Activity title', '2020-09-15 14:47:12', 918, '[[regtime]]', '[[regtime]]'),
(920, 'english', 'Total questions', '2020-09-15 14:47:12', 919, '[[regtime]]', '[[regtime]]'),
(921, 'english', 'Stats for test "[test]"', '2020-09-15 14:47:12', 920, '[[regtime]]', '[[regtime]]'),
(922, 'english', 'Use for final score', '2020-09-15 14:47:12', 921, '[[regtime]]', '[[regtime]]'),
(923, 'english', 'Weight', '2020-09-15 14:47:12', 922, '[[regtime]]', '[[regtime]]'),
(924, 'english', 'additional fields for courses', '2020-09-15 14:47:12', 923, '[[regtime]]', '[[regtime]]'),
(925, 'english', 'Add new course', '2020-09-15 14:47:12', 924, '[[regtime]]', '[[regtime]]'),
(926, 'english', '&gt;&gt; Back to "My course area"', '2020-09-15 14:47:12', 925, '[[regtime]]', '[[regtime]]'),
(927, 'english', 'You have already used this code', '2020-09-15 14:47:12', 926, '[[regtime]]', '[[regtime]]'),
(928, 'english', 'Code not correct', '2020-09-15 14:47:12', 927, '[[regtime]]', '[[regtime]]'),
(929, 'english', 'Code', '2020-09-15 14:47:12', 928, '[[regtime]]', '[[regtime]]'),
(930, 'english', 'This chart allows you to check the numbers of chapter seen by the users through the days.', '2020-09-15 14:47:12', 929, '[[regtime]]', '[[regtime]]'),
(931, 'english', 'This chart gives you a view of all the chapters completed or passed per user.', '2020-09-15 14:47:12', 930, '[[regtime]]', '[[regtime]]'),
(932, 'english', 'This chart gives you a view of all the chapters completed by the users in this course.', '2020-09-15 14:47:12', 931, '[[regtime]]', '[[regtime]]'),
(933, 'english', 'There are no SCORM packages in this course', '2020-09-15 14:47:12', 932, '[[regtime]]', '[[regtime]]'),
(934, 'english', 'Object successfully completed', '2020-09-15 14:47:12', 933, '[[regtime]]', '[[regtime]]'),
(935, 'english', 'This chart allows you to check the score acquired by the users in each SCORM chapter.', '2020-09-15 14:47:12', 934, '[[regtime]]', '[[regtime]]'),
(936, 'english', 'This chart allows you to check the time spent by the users inside each SCORM chapter.', '2020-09-15 14:47:12', 935, '[[regtime]]', '[[regtime]]'),
(937, 'english', 'Time', '2020-09-15 14:47:12', 936, '[[regtime]]', '[[regtime]]'),
(938, 'english', 'Courses', '2020-09-15 14:47:12', 937, '[[regtime]]', '[[regtime]]'),
(939, 'english', 'Please add the email object', '2023-10-12 10:29:58', 938, '[[regtime]]', '[[regtime]]'),
(940, 'english', 'Please add the email content', '2023-10-12 10:29:58', 939, '[[regtime]]', '[[regtime]]'),
(941, 'english', 'No email configuration configured', '2023-10-12 10:29:58', 940, '[[regtime]]', '[[regtime]]'),
(942, 'english', 'Disclaimer - assistenza utenti', '2020-09-15 14:47:12', 941, '[[regtime]]', '[[regtime]]'),
(943, 'english', 'Help Desk', '2020-09-15 14:47:12', 942, '[[regtime]]', '[[regtime]]'),
(944, 'english', 'Autorizzo l''invio di informazioni tecniche all''assistenza utili per risolvere la mia richiesta', '2020-09-15 14:47:12', 943, '[[regtime]]', '[[regtime]]'),
(945, 'english', 'Privacy', '2020-09-15 14:47:12', 944, '[[regtime]]', '[[regtime]]'),
(946, 'english', '<!-- here you can put some help text -->', '2020-09-15 14:47:12', 945, '[[regtime]]', '[[regtime]]'),
(947, 'english', 'Active courses', '2020-09-15 14:47:12', 946, '[[regtime]]', '[[regtime]]'),
(948, 'english', 'Courses that will be activated within 7 days', '2020-09-15 14:47:12', 947, '[[regtime]]', '[[regtime]]'),
(949, 'english', 'Administrator users', '2020-09-15 14:47:12', 948, '[[regtime]]', '[[regtime]]'),
(950, 'english', 'Select export format', '2020-09-15 14:47:12', 949, '[[regtime]]', '[[regtime]]'),
(951, 'english', 'Installed version', '2020-09-15 14:47:12', 950, '[[regtime]]', '[[regtime]]'),
(952, 'english', 'Info about courses', '2020-09-15 14:47:12', 951, '[[regtime]]', '[[regtime]]'),
(953, 'english', 'Welcome Page', '2020-09-15 14:47:12', 952, '[[regtime]]', '[[regtime]]'),
(954, 'english', 'Announcements', '2022-03-10 11:47:16', 953, '[[regtime]]', '[[regtime]]'),
(955, 'english', 'Image / video banner', '2022-03-10 11:47:16', 954, '[[regtime]]', '[[regtime]]'),
(956, 'english', 'Calendar', '2022-03-10 11:47:16', 955, '[[regtime]]', '[[regtime]]'),
(957, 'english', 'Certificates', '2022-03-10 11:47:16', 956, '[[regtime]]', '[[regtime]]'),
(958, 'english', 'Communications', '2022-03-22 11:20:20', 957, '[[regtime]]', '[[regtime]]'),
(959, 'english', 'Courses', '2022-03-10 11:47:16', 958, '[[regtime]]', '[[regtime]]'),
(960, 'english', 'Messages', '2022-03-10 11:47:16', 959, '[[regtime]]', '[[regtime]]'),
(961, 'english', 'News', '2022-03-22 11:23:28', 960, '[[regtime]]', '[[regtime]]'),
(962, 'english', 'Welcome message', '2022-03-10 11:47:16', 961, '[[regtime]]', '[[regtime]]'),
(963, 'english', 'Courses Attendance Graph', '2022-03-10 11:47:19', 962, '[[regtime]]', '[[regtime]]'),
(964, 'english', 'There are no certificates', '2022-03-10 11:47:16', 963, '[[regtime]]', '[[regtime]]'),
(965, 'english', 'There are no messages', '2022-03-10 11:47:16', 964, '[[regtime]]', '[[regtime]]'),
(966, 'english', 'SQL scripts log', '2020-09-15 14:47:12', 965, '[[regtime]]', '[[regtime]]'),
(967, 'english', 'Courses that will be deactivated within 7 days', '2020-09-15 14:47:12', 966, '[[regtime]]', '[[regtime]]'),
(968, 'english', 'Follow Us', '2020-09-15 14:47:12', 967, '[[regtime]]', '[[regtime]]'),
(969, 'english', 'Inactive users (for at least one month)', '2020-09-15 14:47:12', 968, '[[regtime]]', '[[regtime]]'),
(970, 'english', 'Last released version', '2020-09-15 14:47:12', 969, '[[regtime]]', '[[regtime]]'),
(971, 'english', 'Library', '2020-09-15 14:47:12', 970, '[[regtime]]', '[[regtime]]'),
(972, 'english', 'Download or generate certificate', '2020-09-15 14:47:12', 971, '[[regtime]]', '[[regtime]]'),
(973, 'english', 'A new version is available for download', '2020-09-15 14:47:12', 972, '[[regtime]]', '[[regtime]]'),
(974, 'english', 'Online users', '2020-09-15 14:47:12', 973, '[[regtime]]', '[[regtime]]'),
(975, 'english', '(New window)', '2020-09-15 14:47:12', 974, '[[regtime]]', '[[regtime]]'),
(976, 'english', 'Quick <span>links</span>', '2020-09-15 14:47:12', 975, '[[regtime]]', '[[regtime]]'),
(977, 'english', 'Users registered in the last 7 days', '2020-09-15 14:47:12', 976, '[[regtime]]', '[[regtime]]'),
(978, 'english', 'Users registered today', '2020-09-15 14:47:12', 977, '[[regtime]]', '[[regtime]]'),
(979, 'english', 'User registered yesterday', '2020-09-15 14:47:12', 978, '[[regtime]]', '[[regtime]]'),
(980, 'english', 'Super-admin users', '2020-09-15 14:47:12', 979, '[[regtime]]', '[[regtime]]'),
(981, 'english', 'forma.lms Online', '2020-09-15 14:47:12', 980, '[[regtime]]', '[[regtime]]'),
(982, 'english', 'Suspended users', '2020-09-15 14:47:12', 981, '[[regtime]]', '[[regtime]]'),
(983, 'english', 'Consulting site', '2020-09-15 14:47:12', 982, '[[regtime]]', '[[regtime]]'),
(984, 'english', 'forma.lms support site', '2020-09-15 14:47:12', 983, '[[regtime]]', '[[regtime]]'),
(985, 'english', 'Number of courses', '2020-09-15 14:47:12', 984, '[[regtime]]', '[[regtime]]'),
(986, 'english', 'Number of subscriptions', '2020-09-15 14:47:12', 985, '[[regtime]]', '[[regtime]]'),
(987, 'english', 'Registered users', '2020-09-15 14:47:12', 986, '[[regtime]]', '[[regtime]]'),
(988, 'english', 'Error, while retrieving the last available version', '2020-09-15 14:47:12', 987, '[[regtime]]', '[[regtime]]'),
(989, 'english', 'forma.lms Official Website', '2020-09-15 14:47:12', 988, '[[regtime]]', '[[regtime]]'),
(990, 'english', 'forma.lms open source community', '2020-09-15 14:47:12', 989, '[[regtime]]', '[[regtime]]'),
(991, 'english', 'Users info', '2020-09-15 14:47:12', 990, '[[regtime]]', '[[regtime]]'),
(992, 'english', 'Waiting subscription', '2020-09-15 14:47:12', 991, '[[regtime]]', '[[regtime]]'),
(993, 'english', 'Show buttons', '2022-03-28 10:07:54', 992, '[[regtime]]', '[[regtime]]'),
(994, 'english', 'Show button', '2022-03-10 11:47:16', 993, '[[regtime]]', '[[regtime]]'),
(995, 'english', 'Show only not read communications', '2022-03-22 11:20:56', 994, '[[regtime]]', '[[regtime]]'),
(996, 'english', 'Show button "All courses"', '2022-03-22 11:21:12', 995, '[[regtime]]', '[[regtime]]'),
(997, 'english', 'Show button "All courses"', '2022-03-22 11:23:20', 996, '[[regtime]]', '[[regtime]]'),
(998, 'english', 'Show button', '2022-03-10 11:47:16', 997, '[[regtime]]', '[[regtime]]'),
(999, 'english', 'Announcements', '2022-03-10 11:47:16', 998, '[[regtime]]', '[[regtime]]'),
(1000, 'english', 'Description Announcement', '2022-03-10 11:47:16', 999, '[[regtime]]', '[[regtime]]'),
(1001, 'english', 'Image / video banner', '2022-03-10 11:47:16', 1000, '[[regtime]]', '[[regtime]]'),
(1002, 'english', 'Description Banner', '2022-03-10 11:47:16', 1001, '[[regtime]]', '[[regtime]]'),
(1003, 'english', 'Calendar', '2022-03-10 11:47:16', 1002, '[[regtime]]', '[[regtime]]'),
(1004, 'english', 'Description Calendar', '2022-03-10 11:47:16', 1003, '[[regtime]]', '[[regtime]]'),
(1005, 'english', 'Classes Courses', '2022-03-10 11:47:16', 1004, '[[regtime]]', '[[regtime]]'),
(1006, 'english', 'E-Learning Courses', '2022-03-10 11:47:16', 1005, '[[regtime]]', '[[regtime]]'),
(1007, 'english', 'Reservations', '2022-03-10 11:47:16', 1006, '[[regtime]]', '[[regtime]]'),
(1008, 'english', 'Certificates', '2022-03-10 11:47:16', 1007, '[[regtime]]', '[[regtime]]'),
(1009, 'english', 'Description Certificates', '2022-03-10 11:47:16', 1008, '[[regtime]]', '[[regtime]]'),
(1010, 'english', 'Communications', '2022-03-22 11:20:27', 1009, '[[regtime]]', '[[regtime]]'),
(1011, 'english', 'Shows classroom courses that are going to start or e-learning courses that are near to closing date, or both', '2022-03-22 11:22:30', 1010, '[[regtime]]', '[[regtime]]'),
(1012, 'english', 'Courses', '2022-03-10 11:47:16', 1011, '[[regtime]]', '[[regtime]]'),
(1013, 'english', 'Shows classroom courses that are going to start or e-learning courses that are near to closing date, or both', '2022-03-22 11:13:57', 1012, '[[regtime]]', '[[regtime]]'),
(1014, 'english', 'Messages', '2022-03-10 11:47:16', 1013, '[[regtime]]', '[[regtime]]'),
(1015, 'english', 'Description Message', '2022-03-10 11:47:16', 1014, '[[regtime]]', '[[regtime]]'),
(1016, 'english', 'News', '2022-03-22 11:23:40', 1015, '[[regtime]]', '[[regtime]]'),
(1017, 'english', 'Shows published and news shared with the user', '2022-03-22 11:23:54', 1016, '[[regtime]]', '[[regtime]]'),
(1018, 'english', 'Welcome message', '2022-03-10 11:47:16', 1017, '[[regtime]]', '[[regtime]]'),
(1019, 'english', 'Description Welcome', '2022-03-10 11:47:16', 1018, '[[regtime]]', '[[regtime]]'),
(1020, 'english', 'Courses Attendance Graph', '2022-03-10 11:47:19', 1019, '[[regtime]]', '[[regtime]]'),
(1021, 'english', 'Courses Attendance Graph Description', '2022-03-10 11:47:19', 1020, '[[regtime]]', '[[regtime]]'),
(1022, 'english', 'Dashboard', '2022-03-10 11:47:16', 1021, '[[regtime]]', '[[regtime]]'),
(1023, 'english', 'Dashboard', '2022-03-10 11:47:16', 1022, '[[regtime]]', '[[regtime]]'),
(1024, 'english', 'Default', '2022-03-10 11:47:16', 1023, '[[regtime]]', '[[regtime]]'),
(1025, 'english', 'The dashboard could not be created, please check the data entered', '2022-03-10 11:47:16', 1024, '[[regtime]]', '[[regtime]]'),
(1026, 'english', 'Dashboard created successfully', '2022-03-10 11:47:16', 1025, '[[regtime]]', '[[regtime]]'),
(1027, 'english', 'Dashboard status', '2022-03-10 11:47:16', 1026, '[[regtime]]', '[[regtime]]'),
(1028, 'english', 'Are you sure you want to delete this dashboard?', '2022-03-10 11:47:16', 1027, '[[regtime]]', '[[regtime]]'),
(1029, 'english', 'There is no layout', '2022-03-10 11:47:16', 1028, '[[regtime]]', '[[regtime]]'),
(1030, 'english', 'Insert a new block', '2022-03-10 11:47:16', 1029, '[[regtime]]', '[[regtime]]'),
(1031, 'english', 'Create a new dashboard', '2022-03-10 11:47:16', 1030, '[[regtime]]', '[[regtime]]'),
(1032, 'english', 'Block required', '2022-03-10 11:47:16', 1031, '[[regtime]]', '[[regtime]]'),
(1033, 'english', 'Create new dashboard', '2022-03-10 11:47:16', 1032, '[[regtime]]', '[[regtime]]'),
(1034, 'english', 'Draft', '2022-03-10 11:47:16', 1033, '[[regtime]]', '[[regtime]]'),
(1035, 'english', 'No file selected', '2022-03-10 11:47:16', 1034, '[[regtime]]', '[[regtime]]'),
(1036, 'english', 'Error: no file selected', '2022-03-10 11:47:16', 1035, '[[regtime]]', '[[regtime]]'),
(1037, 'english', 'Accepted images', '2022-03-10 11:47:16', 1036, '[[regtime]]', '[[regtime]]'),
(1038, 'english', 'Error: accepted images', '2022-03-10 11:47:16', 1037, '[[regtime]]', '[[regtime]]'),
(1039, 'english', 'Insert new dashboard', '2022-03-10 11:47:16', 1038, '[[regtime]]', '[[regtime]]'),
(1040, 'english', 'Dashboard name', '2022-03-10 11:47:16', 1039, '[[regtime]]', '[[regtime]]'),
(1041, 'english', 'Published', '2022-03-10 11:47:16', 1040, '[[regtime]]', '[[regtime]]'),
(1042, 'english', 'Save', '2022-03-10 11:47:16', 1041, '[[regtime]]', '[[regtime]]'),
(1043, 'english', 'The dashboard could not be saved, please check the data entered', '2022-03-10 11:47:16', 1042, '[[regtime]]', '[[regtime]]'),
(1044, 'english', 'Dashboard saved successfully', '2022-03-10 11:47:16', 1043, '[[regtime]]', '[[regtime]]'),
(1045, 'english', 'Select block', '2022-03-10 11:47:16', 1044, '[[regtime]]', '[[regtime]]'),
(1046, 'english', 'Select a status', '2022-03-10 11:47:16', 1045, '[[regtime]]', '[[regtime]]'),
(1047, 'english', 'Draft', '2022-03-10 11:47:16', 1046, '[[regtime]]', '[[regtime]]'),
(1048, 'english', 'Pubblished', '2022-03-10 11:47:16', 1047, '[[regtime]]', '[[regtime]]'),
(1049, 'english', 'Hi <strong>[firstname] [lastname]</strong>, welcome to the platform <strong>[platform]</strong>', '2022-03-10 11:47:16', 1048, '[[regtime]]', '[[regtime]]'),
(1050, 'english', 'Actions enabled', '2022-03-10 11:47:16', 1049, '[[regtime]]', '[[regtime]]'),
(1051, 'english', 'Cover image', '2022-03-10 11:47:16', 1050, '[[regtime]]', '[[regtime]]'),
(1052, 'english', 'Title', '2022-03-10 11:47:16', 1051, '[[regtime]]', '[[regtime]]'),
(1053, 'english', 'Title', '2022-03-10 11:47:16', 1052, '[[regtime]]', '[[regtime]]'),
(1054, 'english', 'Youtube / vimeo video url', '2022-03-10 11:47:16', 1053, '[[regtime]]', '[[regtime]]'),
(1055, 'english', 'Title', '2022-03-10 11:47:16', 1054, '[[regtime]]', '[[regtime]]'),
(1056, 'english', 'Alternative text', '2022-03-28 10:09:01', 1055, '[[regtime]]', '[[regtime]]'),
(1057, 'english', 'Alternative text', '2022-03-10 11:47:16', 1056, '[[regtime]]', '[[regtime]]'),
(1058, 'english', 'Maximum number of certificates', '2022-03-28 10:13:04', 1057, '[[regtime]]', '[[regtime]]'),
(1059, 'english', 'Maximum number of visible certificates', '2022-03-10 11:47:16', 1058, '[[regtime]]', '[[regtime]]'),
(1060, 'english', 'Title', '2022-03-10 11:47:16', 1059, '[[regtime]]', '[[regtime]]'),
(1061, 'english', 'Communications number to display', '2022-03-22 11:21:30', 1060, '[[regtime]]', '[[regtime]]'),
(1062, 'english', 'Title', '2022-03-22 11:21:55', 1061, '[[regtime]]', '[[regtime]]'),
(1063, 'english', 'Max number courses to show', '2022-03-22 11:24:10', 1062, '[[regtime]]', '[[regtime]]'),
(1064, 'english', 'Title', '2022-03-10 11:47:16', 1063, '[[regtime]]', '[[regtime]]'),
(1065, 'english', 'Alternative text', '2022-03-10 11:47:16', 1064, '[[regtime]]', '[[regtime]]'),
(1066, 'english', 'Maximum number of visible messages', '2022-03-10 11:47:16', 1065, '[[regtime]]', '[[regtime]]'),
(1067, 'english', 'Title', '2022-03-10 11:47:16', 1066, '[[regtime]]', '[[regtime]]'),
(1068, 'english', 'Title', '2022-03-22 11:24:19', 1067, '[[regtime]]', '[[regtime]]'),
(1069, 'english', 'Title', '2022-03-10 11:47:16', 1068, '[[regtime]]', '[[regtime]]'),
(1070, 'english', 'Welcome message (translation key)', '2022-03-10 11:47:16', 1069, '[[regtime]]', '[[regtime]]'),
(1071, 'english', 'Select which course type to show', '2022-03-22 11:24:31', 1070, '[[regtime]]', '[[regtime]]'),
(1072, 'english', 'Drag and drop files here', '2022-03-10 11:47:16', 1071, '[[regtime]]', '[[regtime]]'),
(1073, 'english', 'Description', '2022-03-10 11:47:16', 1072, '[[regtime]]', '[[regtime]]'),
(1074, 'english', 'An error has occurred', '2022-03-10 11:47:16', 1073, '[[regtime]]', '[[regtime]]'),
(1075, 'english', 'This file contains an error', '2022-03-10 11:47:16', 1074, '[[regtime]]', '[[regtime]]'),
(1076, 'english', 'Title', '2022-03-10 11:47:16', 1075, '[[regtime]]', '[[regtime]]'),
(1077, 'english', 'Upload files', '2022-03-28 10:15:16', 1076, '[[regtime]]', '[[regtime]]'),
(1078, 'english', 'New announcement', '2020-09-15 14:47:12', 1077, '[[regtime]]', '[[regtime]]'),
(1079, 'english', 'A new announcement was published in the course "[course]"\n\nTitle: ''[title]''\n\n[text]\n\nYou can read it on forma.lms at URL <a href="[url]">[url]</a>', '2020-09-15 14:47:12', 1078, '[[regtime]]', '[[regtime]]'),
(1080, 'english', 'Subscription request approved', '2020-09-15 14:47:12', 1079, '[[regtime]]', '[[regtime]]'),
(1081, 'english', 'Your course subscription request to [course] has been approved by the administrator. You can enter the course clicking the URL located in <a href="[url]">[url]</a>', '2020-09-15 14:47:12', 1080, '[[regtime]]', '[[regtime]]'),
(1082, 'english', 'The administrator has confirmed your subscription request to <a href="[url]">[url]</a>', '2020-09-15 14:47:12', 1081, '[[regtime]]', '[[regtime]]'),
(1083, 'english', 'Your account has been deleted', '2020-09-15 14:47:12', 1082, '[[regtime]]', '[[regtime]]'),
(1084, 'english', 'Your account at <a href="[url]">[url]</a> with the username [userid] has been deleted', '2020-09-15 14:47:12', 1083, '[[regtime]]', '[[regtime]]'),
(1085, 'english', 'Subscription request refused', '2020-09-15 14:47:12', 1084, '[[regtime]]', '[[regtime]]'),
(1086, 'english', 'Your subscription to the course [course] has been refused by the administrator at the address <a href="[url]">[url]</a>', '2020-09-15 14:47:12', 1085, '[[regtime]]', '[[regtime]]'),
(1087, 'english', 'User node change', '2020-09-15 14:47:12', 1086, '[[regtime]]', '[[regtime]]'),
(1088, 'english', '[url] [firstname] [lastname] [username]', '2020-09-15 14:47:12', 1087, '[[regtime]]', '[[regtime]]'),
(1089, 'english', 'User purchased a course', '2020-09-15 14:47:12', 1088, '[[regtime]]', '[[regtime]]'),
(1090, 'english', 'User suspended from course', '2020-09-15 14:47:12', 1089, '[[regtime]]', '[[regtime]]'),
(1091, 'english', '[url] [firstname] [lastname] [course] [username]', '2020-09-15 14:47:12', 1090, '[[regtime]]', '[[regtime]]'),
(1092, 'english', 'User suspended', '2020-09-15 14:47:12', 1091, '[[regtime]]', '[[regtime]]'),
(1093, 'english', '[url] [firstname] [lastname] [username]', '2020-09-15 14:47:12', 1092, '[[regtime]]', '[[regtime]]'),
(1094, 'english', 'The user account has been modified', '2020-09-15 14:47:12', 1093, '[[regtime]]', '[[regtime]]'),
(1095, 'english', 'Your account at the site <a href="[url]">[url]</a>  has been modified:\n\nUsername: [userid]', '2020-09-15 14:47:12', 1094, '[[regtime]]', '[[regtime]]'),
(1096, 'english', 'Your subscription has been changed', '2020-09-15 14:47:12', 1095, '[[regtime]]', '[[regtime]]'),
(1097, 'english', 'Your subscription at the course [course] at the address <a href="[url]">[url]</a> has been changed', '2020-09-15 14:47:12', 1096, '[[regtime]]', '[[regtime]]'),
(1098, 'english', 'New forum', '2020-09-15 14:47:12', 1097, '[[regtime]]', '[[regtime]]'),
(1099, 'english', 'New forum added to the course ''[course]'' at the address [url] Title: [title] [text]', '2020-09-15 14:47:12', 1098, '[[regtime]]', '[[regtime]]'),
(1100, 'english', 'There is a new message in a thread that you are following\n [url] > [course] > [forum_title] > [thread_title]', '2020-09-15 14:47:12', 1099, '[[regtime]]', '[[regtime]]'),
(1101, 'english', 'There is a new thread in\n\n<a href="[url]">[url]</a> > [course] > [forum_title]\n\n Title: [thread_title]', '2020-09-15 14:47:12', 1100, '[[regtime]]', '[[regtime]]'),
(1102, 'english', 'User enrolled in overbooking', '2021-08-02 13:31:37', 1101, '[[regtime]]', '[[regtime]]'),
(1103, 'english', 'The user [firstname] [lastname], has been enrolled in course [course] with overbooking state on platform [url]', '2021-08-02 13:27:47', 1102, '[[regtime]]', '[[regtime]]'),
(1104, 'english', 'You have been enrolled in course', '2021-01-07 12:01:19', 1103, '[[regtime]]', '[[regtime]]'),
(1105, 'english', 'A new user has been enrolled in a course', '2020-09-21 12:58:38', 1104, '[[regtime]]', '[[regtime]]'),
(1106, 'english', 'You have been enrolled in the course : [course] at URL: <a href="[url]">[url]</a>', '2021-01-07 12:05:39', 1105, '[[regtime]]', '[[regtime]]'),
(1107, 'english', 'A new user, [firstname] [lastname] [username] has been enrolled in course [course]', '2020-09-15 14:47:12', 1106, '[[regtime]]', '[[regtime]]'),
(1108, 'english', 'You have been enrolled in the course : [course] at URL: [url]', '2021-01-07 12:06:12', 1107, '[[regtime]]', '[[regtime]]'),
(1109, 'english', 'User is waiting for course subscription approval', '2020-09-15 14:47:12', 1108, '[[regtime]]', '[[regtime]]'),
(1110, 'english', 'New user subscribed to the ''[course]'' course and is waiting to be approved.\n\n<a href="[url]">[url]</a>', '2020-09-15 14:47:12', 1109, '[[regtime]]', '[[regtime]]'),
(1111, 'english', 'User is waiting for course unsubscription approval', '2020-09-15 14:47:12', 1110, '[[regtime]]', '[[regtime]]'),
(1112, 'english', 'Unsubscription request from a course', '2020-09-15 14:47:12', 1111, '[[regtime]]', '[[regtime]]'),
(1113, 'english', 'New user unsubscribed to the ''[course]'' course and is waiting to be approved.\n\n<a href="[url]">[url]</a>', '2020-09-15 14:47:12', 1112, '[[regtime]]', '[[regtime]]'),
(1114, 'english', 'A user has asked to be unsubscribed from a course', '2020-09-15 14:47:12', 1113, '[[regtime]]', '[[regtime]]'),
(1115, 'english', 'and your password has been changed to: [password]', '2020-09-15 14:47:12', 1114, '[[regtime]]', '[[regtime]]'),
(1116, 'english', 'User not approved', '2020-09-15 14:47:12', 1115, '[[regtime]]', '[[regtime]]'),
(1117, 'english', 'The administrator of [url] has not approved your subscription request', '2020-09-15 14:47:12', 1116, '[[regtime]]', '[[regtime]]'),
(1118, 'english', 'You are now registered in our system', '2020-09-15 14:47:12', 1117, '[[regtime]]', '[[regtime]]'),
(1119, 'english', 'You are now registered in our system at <a href="[url]">[url]</a>\nwith this account:\n\nUsername: [userid]\nPassword: [password]', '2020-09-15 14:47:12', 1118, '[[regtime]]', '[[regtime]]'),
(1120, 'english', 'Alert: New message in a thread', '2020-09-15 14:47:12', 1119, '[[regtime]]', '[[regtime]]'),
(1121, 'english', 'Alert: new thread', '2020-09-15 14:47:12', 1120, '[[regtime]]', '[[regtime]]'),
(1122, 'english', 'New user group subscription waiting for approval', '2020-09-15 14:47:12', 1121, '[[regtime]]', '[[regtime]]'),
(1123, 'english', 'There is a new user subscription to a moderated group waiting for approval at <a href="[url]">[url]</a>', '2020-09-15 14:47:12', 1122, '[[regtime]]', '[[regtime]]'),
(1124, 'english', 'There is a new user subscription to a moderated group waiting for approval', '2020-09-15 14:47:12', 1123, '[[regtime]]', '[[regtime]]'),
(1125, 'english', 'New user waiting for the approval', '2020-09-15 14:47:12', 1124, '[[regtime]]', '[[regtime]]'),
(1126, 'english', 'New user is registered at [url] and awaiting your approval', '2020-09-15 14:47:12', 1125, '[[regtime]]', '[[regtime]]'),
(1127, 'english', 'New user subscribed', '2020-09-15 14:47:12', 1126, '[[regtime]]', '[[regtime]]'),
(1128, 'english', 'New user subscribed', '2020-09-15 14:47:12', 1127, '[[regtime]]', '[[regtime]]'),
(1129, 'english', 'A user has completed the course on forma.lms', '2020-09-15 14:47:12', 1128, '[[regtime]]', '[[regtime]]'),
(1130, 'english', 'The user [user] completed the course on forma.lms', '2020-09-15 14:47:12', 1129, '[[regtime]]', '[[regtime]]'),
(1131, 'english', 'A user has completed the course on forma.lms', '2020-09-15 14:47:12', 1130, '[[regtime]]', '[[regtime]]'),
(1132, 'english', 'User is registered and waiting for your approval', '2020-09-15 14:47:12', 1131, '[[regtime]]', '[[regtime]]'),
(1133, 'english', 'There is a new user at <a href="[url]">[url]</a> waiting for the approval', '2020-09-15 14:47:12', 1132, '[[regtime]]', '[[regtime]]'),
(1134, 'english', 'You have received a new message', '2020-09-15 14:47:12', 1133, '[[regtime]]', '[[regtime]]'),
(1135, 'english', 'You have received a new message in the e-learning system at <a href="[url]">[url]</a> in the course [course] from the user [from]', '2020-09-15 14:47:12', 1134, '[[regtime]]', '[[regtime]]'),
(1136, 'english', 'You received a new message from the e-learning system at <a href="[url]">[url]</a> in the course<b> [course] </b>from the user [from]', '2020-09-15 14:47:12', 1135, '[[regtime]]', '[[regtime]]'),
(1137, 'english', 'You have been unsubscribed from the course', '2015-09-30 15:32:39', 1136, '[[regtime]]', '[[regtime]]'),
(1138, 'english', 'Dear [firstname] [lastname],\nyou have been unsubscribed from the classroom course ([classroom_code]) - [classroom_date]', '2015-09-30 15:32:39', 1137, '[[regtime]]', '[[regtime]]'),
(1139, 'english', 'Below the report link [report_url] will last [report_persistence_days].', '2015-09-30 15:32:39', 1138, '[[regtime]]', '[[regtime]]'),
(1140, 'english', 'Report: [name]', '2015-09-30 15:32:39', 1139, '[[regtime]]', '[[regtime]]'),
(1141, 'english', 'You have been unsubscribed from the course', '2015-09-30 15:32:39', 1140, '[[regtime]]', '[[regtime]]'),
(1142, 'english', 'Dear [firstname] [lastname],\nyou have been unsubscribed from the edition ([edition_code]) - [edition]', '2015-09-30 15:32:39', 1141, '[[regtime]]', '[[regtime]]'),
(1143, 'english', 'You have been unsubscribed from the course', '2015-09-30 15:32:39', 1142, '[[regtime]]', '[[regtime]]'),
(1144, 'english', 'Dear [firstname] [lastname],\nyou have been unsubscribed from the course ([course_code]) - [course]', '2015-09-30 15:32:39', 1143, '[[regtime]]', '[[regtime]]'),
(1145, 'english', 'A user purchased a course', '2015-09-30 15:32:39', 1144, '[[regtime]]', '[[regtime]]'),
(1146, 'english', 'The user [firstname] [lastname] ([username] - [email])<br>\n          purchased the course [course] on platform [url]<br><br>\n\n          [fields]\n\n          ORDER #[id_transaction]<br>\n          on: [date_transaction]<br>\n          Total: [price] €<br>\n          Method: [method]', '2015-09-30 15:32:39', 1145, '[[regtime]]', '[[regtime]]'),
(1147, 'english', 'Apply rule', '2020-09-15 14:47:12', 1146, '[[regtime]]', '[[regtime]]'),
(1148, 'english', 'Base', '2020-09-15 14:47:12', 1147, '[[regtime]]', '[[regtime]]'),
(1149, 'english', 'Entity', '2020-09-15 14:47:12', 1148, '[[regtime]]', '[[regtime]]'),
(1150, 'english', 'Show logs', '2020-09-15 14:47:12', 1149, '[[regtime]]', '[[regtime]]'),
(1151, 'english', 'User has been change node', '2020-09-15 14:47:12', 1150, '[[regtime]]', '[[regtime]]'),
(1152, 'english', 'User with [firstname] [lastname] and userId : [username] has been change node in platform : [url]', '2020-09-15 14:47:12', 1151, '[[regtime]]', '[[regtime]]'),
(1153, 'english', 'SMS', '2020-09-15 14:47:12', 1152, '[[regtime]]', '[[regtime]]'),
(1154, 'english', 'New Announcement', '2020-09-15 14:47:12', 1153, '[[regtime]]', '[[regtime]]'),
(1155, 'english', 'Course properties have been changed', '2020-09-15 14:47:12', 1154, '[[regtime]]', '[[regtime]]'),
(1156, 'english', 'New category', '2020-09-15 14:47:12', 1155, '[[regtime]]', '[[regtime]]'),
(1157, 'english', 'New reply', '2020-09-15 14:47:12', 1156, '[[regtime]]', '[[regtime]]'),
(1158, 'english', 'New thread', '2020-09-15 14:47:12', 1157, '[[regtime]]', '[[regtime]]'),
(1159, 'english', 'New message received', '2020-09-15 14:47:12', 1158, '[[regtime]]', '[[regtime]]'),
(1160, 'english', 'User approval', '2020-09-15 14:47:12', 1159, '[[regtime]]', '[[regtime]]'),
(1161, 'english', 'User purchased a course', '2020-09-15 14:47:12', 1160, '[[regtime]]', '[[regtime]]'),
(1162, 'english', 'Student completed a course', '2020-09-15 14:47:12', 1161, '[[regtime]]', '[[regtime]]'),
(1163, 'english', 'User subscribed to a course', '2020-09-15 14:47:12', 1162, '[[regtime]]', '[[regtime]]'),
(1164, 'english', 'Subsribe a user to a course with the API', '2021-01-28 12:01:19', 1163, '[[regtime]]', '[[regtime]]'),
(1165, 'english', 'User subscription - this is sent to the moderators', '2021-01-28 12:01:42', 1164, '[[regtime]]', '[[regtime]]'),
(1166, 'english', 'User waiting to be subscribed to a course', '2020-09-15 14:47:12', 1165, '[[regtime]]', '[[regtime]]'),
(1167, 'english', 'Overbooking user who needs to be approved', '2021-08-02 13:19:09', 1166, '[[regtime]]', '[[regtime]]'),
(1168, 'english', 'User level has been changed in a course', '2020-09-15 14:47:12', 1167, '[[regtime]]', '[[regtime]]'),
(1169, 'english', 'User unsubscribed from a course', '2020-09-15 14:47:12', 1168, '[[regtime]]', '[[regtime]]'),
(1170, 'english', 'User waiting to be unsubscribed from a course', '2020-09-15 14:47:12', 1169, '[[regtime]]', '[[regtime]]'),
(1171, 'english', 'User has been suspended', '2020-09-15 14:47:12', 1170, '[[regtime]]', '[[regtime]]'),
(1172, 'english', 'User has been deleted', '2020-09-15 14:47:12', 1171, '[[regtime]]', '[[regtime]]'),
(1173, 'english', 'User subscribed to a group', '2020-09-15 14:47:12', 1172, '[[regtime]]', '[[regtime]]'),
(1174, 'english', 'User waiting to be subscribed in a group', '2020-09-15 14:47:12', 1173, '[[regtime]]', '[[regtime]]'),
(1175, 'english', 'User has been removed from a group', '2020-09-15 14:47:12', 1174, '[[regtime]]', '[[regtime]]'),
(1176, 'english', 'User has been modified', '2020-09-15 14:47:12', 1175, '[[regtime]]', '[[regtime]]'),
(1177, 'english', 'User Node is changes', '2020-09-15 14:47:12', 1176, '[[regtime]]', '[[regtime]]'),
(1178, 'english', 'User status is change in modified', '2020-09-15 14:47:12', 1177, '[[regtime]]', '[[regtime]]'),
(1179, 'english', 'User has been created', '2020-09-15 14:47:12', 1178, '[[regtime]]', '[[regtime]]'),
(1180, 'english', 'A new user is registered via "free automatic registration" or "free automatic registration with double opt-in "', '2020-09-15 14:47:12', 1179, '[[regtime]]', '[[regtime]]'),
(1181, 'english', 'User subscription waiting to be approved in platform', '2020-09-15 14:47:12', 1180, '[[regtime]]', '[[regtime]]'),
(1182, 'english', 'New user waiting to be approved', '2020-09-15 14:47:12', 1181, '[[regtime]]', '[[regtime]]'),
(1183, 'english', 'User registered - superadmins', '2020-09-15 14:47:12', 1182, '[[regtime]]', '[[regtime]]'),
(1184, 'english', 'User has been suspended', '2020-09-15 14:47:12', 1183, '[[regtime]]', '[[regtime]]'),
(1185, 'english', 'User has been suspended', '2020-09-15 14:47:12', 1184, '[[regtime]]', '[[regtime]]'),
(1186, 'english', 'User with [firstname] [lastname] and userId : [username] has been suspended from course : [course] in platform : [url]', '2020-09-15 14:47:12', 1185, '[[regtime]]', '[[regtime]]'),
(1187, 'english', 'User with [firstname] [lastname] and userId : [username] has been suspended from course : [course] in platform : [url]', '2020-09-15 14:47:12', 1186, '[[regtime]]', '[[regtime]]'),
(1188, 'english', 'Event manager', '2020-09-15 14:47:12', 1187, '[[regtime]]', '[[regtime]]'),
(1189, 'english', 'User has been modified', '2020-09-15 14:47:12', 1188, '[[regtime]]', '[[regtime]]'),
(1190, 'english', 'User with [firstname] [lastname] and userId : [username] has been modified in platform : [url]', '2020-09-15 14:47:12', 1189, '[[regtime]]', '[[regtime]]'),
(1191, 'english', 'User with [firstname] [lastname] and userId : [username] has been modified in platform : [url]', '2020-09-15 14:47:12', 1190, '[[regtime]]', '[[regtime]]'),
(1192, 'english', 'Not used', '2020-09-15 14:47:12', 1191, '[[regtime]]', '[[regtime]]'),
(1193, 'english', 'Platform', '2020-09-15 14:47:12', 1192, '[[regtime]]', '[[regtime]]'),
(1194, 'english', 'appCore', '2020-09-15 14:47:12', 1193, '[[regtime]]', '[[regtime]]'),
(1195, 'english', 'appLMS', '2020-09-15 14:47:12', 1194, '[[regtime]]', '[[regtime]]'),
(1196, 'english', 'appLMS-A', '2020-09-15 14:47:12', 1195, '[[regtime]]', '[[regtime]]'),
(1197, 'english', 'Super-Administrators', '2020-09-15 14:47:12', 1196, '[[regtime]]', '[[regtime]]'),
(1198, 'english', 'Super-Administrators', '2020-09-15 14:47:12', 1197, '[[regtime]]', '[[regtime]]'),
(1199, 'english', 'Moderators and Super-Administrators', '2020-09-15 14:47:12', 1198, '[[regtime]]', '[[regtime]]'),
(1200, 'english', 'Instructors', '2020-09-15 14:47:12', 1199, '[[regtime]]', '[[regtime]]'),
(1201, 'english', 'Instructors and Super-Administrators', '2020-09-15 14:47:12', 1200, '[[regtime]]', '[[regtime]]'),
(1202, 'english', 'User', '2020-09-15 14:47:12', 1201, '[[regtime]]', '[[regtime]]'),
(1203, 'english', 'Event settings', '2020-09-15 14:47:12', 1202, '[[regtime]]', '[[regtime]]'),
(1204, 'english', 'User has been suspended', '2020-09-15 14:47:12', 1203, '[[regtime]]', '[[regtime]]'),
(1205, 'english', 'User with [firstname] [lastname] and userId : [username] has been suspended in platform : [url]', '2020-09-15 14:47:12', 1204, '[[regtime]]', '[[regtime]]'),
(1206, 'english', 'User with [firstname] [lastname] and userId : [username] has been suspended in platform : [url]', '2020-09-15 14:47:12', 1205, '[[regtime]]', '[[regtime]]'),
(1207, 'english', 'Add FAQ', '2020-09-15 14:47:12', 1206, '[[regtime]]', '[[regtime]]'),
(1208, 'english', 'Back to top', '2020-09-15 14:47:12', 1207, '[[regtime]]', '[[regtime]]'),
(1209, 'english', 'Keywords (separated by comma please)', '2020-09-15 14:47:12', 1208, '[[regtime]]', '[[regtime]]'),
(1210, 'english', 'FAQ & Help', '2020-09-15 14:47:12', 1209, '[[regtime]]', '[[regtime]]'),
(1211, 'english', 'Select a word', '2020-09-15 14:47:12', 1210, '[[regtime]]', '[[regtime]]'),
(1212, 'english', 'FAQ list for this category', '2020-09-15 14:47:12', 1211, '[[regtime]]', '[[regtime]]'),
(1213, 'english', 'FAQ view', '2020-09-15 14:47:12', 1212, '[[regtime]]', '[[regtime]]'),
(1214, 'english', 'Help view', '2020-09-15 14:47:12', 1213, '[[regtime]]', '[[regtime]]'),
(1215, 'english', 'Word', '2020-09-15 14:47:12', 1214, '[[regtime]]', '[[regtime]]'),
(1216, 'english', 'Add a new custom field', '2020-09-15 14:47:12', 1215, '[[regtime]]', '[[regtime]]'),
(1217, 'english', 'Add new custom field', '2020-09-15 14:47:12', 1216, '[[regtime]]', '[[regtime]]'),
(1218, 'english', 'All kind of fields', '2020-09-15 14:47:12', 1217, '[[regtime]]', '[[regtime]]'),
(1219, 'english', 'Fiscal code', '2020-09-15 14:47:12', 1218, '[[regtime]]', '[[regtime]]'),
(1220, 'english', 'Copy', '2020-09-15 14:47:12', 1219, '[[regtime]]', '[[regtime]]'),
(1221, 'english', 'Country', '2020-09-15 14:47:12', 1220, '[[regtime]]', '[[regtime]]'),
(1222, 'english', 'Dropdown field', '2020-09-15 14:47:12', 1221, '[[regtime]]', '[[regtime]]'),
(1223, 'english', 'Element name', '2020-09-15 14:47:12', 1222, '[[regtime]]', '[[regtime]]'),
(1224, 'english', '- No value -', '2020-09-15 14:47:12', 1223, '[[regtime]]', '[[regtime]]'),
(1225, 'english', 'New element', '2020-09-15 14:47:12', 1224, '[[regtime]]', '[[regtime]]'),
(1226, 'english', 'Value assigned', '2020-09-15 14:47:12', 1225, '[[regtime]]', '[[regtime]]'),
(1227, 'english', 'Insert new element', '2020-09-15 14:47:12', 1226, '[[regtime]]', '[[regtime]]'),
(1228, 'english', 'Field manager', '2020-09-15 14:47:12', 1227, '[[regtime]]', '[[regtime]]'),
(1229, 'english', 'Field category', '2020-09-15 14:47:12', 1228, '[[regtime]]', '[[regtime]]'),
(1230, 'english', 'Keyword', '2020-09-15 14:47:12', 1229, '[[regtime]]', '[[regtime]]'),
(1231, 'english', 'Free text field', '2020-09-15 14:47:12', 1230, '[[regtime]]', '[[regtime]]'),
(1232, 'english', 'Gmail account', '2020-09-15 14:47:12', 1231, '[[regtime]]', '[[regtime]]'),
(1233, 'english', 'ICQ account', '2020-09-15 14:47:12', 1232, '[[regtime]]', '[[regtime]]'),
(1234, 'english', 'Attention:', '2020-09-15 14:47:12', 1233, '[[regtime]]', '[[regtime]]'),
(1235, 'english', 'It''s not possible to insert quotes. To insert a link please use < href=site target=_blank>', '2020-09-15 14:47:12', 1234, '[[regtime]]', '[[regtime]]'),
(1236, 'english', 'MSN account', '2020-09-15 14:47:12', 1235, '[[regtime]]', '[[regtime]]'),
(1237, 'english', 'New date field', '2020-09-15 14:47:12', 1236, '[[regtime]]', '[[regtime]]'),
(1238, 'english', 'New dropdown field', '2020-09-15 14:47:12', 1237, '[[regtime]]', '[[regtime]]'),
(1239, 'english', 'New free text field (big)', '2020-09-15 14:47:12', 1238, '[[regtime]]', '[[regtime]]'),
(1240, 'english', 'New ICQ account filed', '2020-09-15 14:47:12', 1239, '[[regtime]]', '[[regtime]]'),
(1241, 'english', 'New field MSN account', '2020-09-15 14:47:12', 1240, '[[regtime]]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES
(1242, 'english', 'New field Skype account', '2020-09-15 14:47:12', 1241, '[[regtime]]', '[[regtime]]'),
(1243, 'english', 'New text field', '2020-09-15 14:47:12', 1242, '[[regtime]]', '[[regtime]]'),
(1244, 'english', 'New file field', '2020-09-15 14:47:12', 1243, '[[regtime]]', '[[regtime]]'),
(1245, 'english', 'New field Yahoo account', '2020-09-15 14:47:12', 1244, '[[regtime]]', '[[regtime]]'),
(1246, 'english', 'New Yes/No field', '2020-09-15 14:47:12', 1245, '[[regtime]]', '[[regtime]]'),
(1247, 'english', 'Not done', '2020-09-15 14:47:12', 1246, '[[regtime]]', '[[regtime]]'),
(1248, 'english', 'No file loaded', '2020-09-15 14:47:12', 1247, '[[regtime]]', '[[regtime]]'),
(1249, 'english', 'Show on platforms', '2020-09-15 14:47:12', 1248, '[[regtime]]', '[[regtime]]'),
(1250, 'english', 'Skype account', '2020-09-15 14:47:12', 1249, '[[regtime]]', '[[regtime]]'),
(1251, 'english', 'Text field', '2020-09-15 14:47:12', 1250, '[[regtime]]', '[[regtime]]'),
(1252, 'english', 'Use multi-language field if available', '2020-09-15 14:47:12', 1251, '[[regtime]]', '[[regtime]]'),
(1253, 'english', 'Yahoo account', '2020-09-15 14:47:12', 1252, '[[regtime]]', '[[regtime]]'),
(1254, 'english', 'Field yes/no', '2020-09-15 14:47:12', 1253, '[[regtime]]', '[[regtime]]'),
(1255, 'english', 'Not Translated Field', '2020-09-15 14:47:12', 1254, '[[regtime]]', '[[regtime]]'),
(1256, 'english', 'Gap analysis', '2020-09-15 14:47:12', 1255, '[[regtime]]', '[[regtime]]'),
(1257, 'english', 'With a gap', '2020-09-15 14:47:12', 1256, '[[regtime]]', '[[regtime]]'),
(1258, 'english', 'Without a gap', '2020-09-15 14:47:12', 1257, '[[regtime]]', '[[regtime]]'),
(1259, 'english', 'Add new forum', '2020-09-15 14:47:12', 1258, '[[regtime]]', '[[regtime]]'),
(1260, 'english', 'Start a new discussion', '2020-09-15 14:47:12', 1259, '[[regtime]]', '[[regtime]]'),
(1261, 'english', 'Mark all threads as read', '2020-09-15 14:47:12', 1260, '[[regtime]]', '[[regtime]]'),
(1262, 'english', 'Are you sure you want to move the thread?', '2020-09-15 14:47:12', 1261, '[[regtime]]', '[[regtime]]'),
(1263, 'english', 'You can''t access this discussion', '2020-09-15 14:47:12', 1262, '[[regtime]]', '[[regtime]]'),
(1264, 'english', 'Messages for this thread', '2020-09-15 14:47:12', 1263, '[[regtime]]', '[[regtime]]'),
(1265, 'english', 'Last messages in this thread', '2020-09-15 14:47:12', 1264, '[[regtime]]', '[[regtime]]'),
(1266, 'english', 'Choose who can see this forum (if nobody is selected, the forum will be seen by everyone)', '2020-09-15 14:47:12', 1265, '[[regtime]]', '[[regtime]]'),
(1267, 'english', 'Moderate', '2020-09-15 14:47:12', 1266, '[[regtime]]', '[[regtime]]'),
(1268, 'english', 'Forum list', '2020-09-15 14:47:12', 1267, '[[regtime]]', '[[regtime]]'),
(1269, 'english', 'Emoticons', '2020-09-15 14:47:12', 1268, '[[regtime]]', '[[regtime]]'),
(1270, 'english', 'Forum closed', '2020-09-15 14:47:12', 1269, '[[regtime]]', '[[regtime]]'),
(1271, 'english', 'Forum open', '2020-09-15 14:47:12', 1270, '[[regtime]]', '[[regtime]]'),
(1272, 'english', 'Show this forum to', '2020-09-15 14:47:12', 1271, '[[regtime]]', '[[regtime]]'),
(1273, 'english', 'This is a forum with all information regarding it', '2020-09-15 14:47:12', 1272, '[[regtime]]', '[[regtime]]'),
(1274, 'english', 'Unlock', '2020-09-15 14:47:12', 1273, '[[regtime]]', '[[regtime]]'),
(1275, 'english', 'Manage forum moderation', '2020-09-15 14:47:12', 1274, '[[regtime]]', '[[regtime]]'),
(1276, 'english', 'Re-Open answers', '2020-09-15 14:47:12', 1275, '[[regtime]]', '[[regtime]]'),
(1277, 'english', 'from forum', '2020-09-15 14:47:12', 1276, '[[regtime]]', '[[regtime]]'),
(1278, 'english', 'Mark thread as important', '2020-09-15 14:47:12', 1277, '[[regtime]]', '[[regtime]]'),
(1279, 'english', 'Last message.', '2020-09-15 14:47:12', 1278, '[[regtime]]', '[[regtime]]'),
(1280, 'english', 'Locked', '2020-09-15 14:47:12', 1279, '[[regtime]]', '[[regtime]]'),
(1281, 'english', 'Message blocked by moderator', '2020-09-15 14:47:12', 1280, '[[regtime]]', '[[regtime]]'),
(1282, 'english', 'Lock forum', '2020-09-15 14:47:12', 1281, '[[regtime]]', '[[regtime]]'),
(1283, 'english', 'Lock forum', '2020-09-15 14:47:12', 1282, '[[regtime]]', '[[regtime]]'),
(1284, 'english', 'Lock answers', '2020-09-15 14:47:12', 1283, '[[regtime]]', '[[regtime]]'),
(1285, 'english', 'Message modified by', '2020-09-15 14:47:12', 1284, '[[regtime]]', '[[regtime]]'),
(1286, 'english', 'Mod. message', '2020-09-15 14:47:12', 1285, '[[regtime]]', '[[regtime]]'),
(1287, 'english', 'Move to forum:', '2020-09-15 14:47:12', 1286, '[[regtime]]', '[[regtime]]'),
(1288, 'english', 'New message', '2020-09-15 14:47:12', 1287, '[[regtime]]', '[[regtime]]'),
(1289, 'english', 'New thread', '2020-09-15 14:47:12', 1288, '[[regtime]]', '[[regtime]]'),
(1290, 'english', 'You are not allowed to view this forum', '2020-09-15 14:47:12', 1289, '[[regtime]]', '[[regtime]]'),
(1291, 'english', 'Notify', '2020-09-15 14:47:12', 1290, '[[regtime]]', '[[regtime]]'),
(1292, 'english', 'Notify request registered', '2020-09-15 14:47:12', 1291, '[[regtime]]', '[[regtime]]'),
(1293, 'english', 'Follow this forum', '2020-09-15 14:47:12', 1292, '[[regtime]]', '[[regtime]]'),
(1294, 'english', 'Notify me about new threads in this forum', '2020-09-15 14:47:12', 1293, '[[regtime]]', '[[regtime]]'),
(1295, 'english', 'Follow this thread', '2020-09-15 14:47:12', 1294, '[[regtime]]', '[[regtime]]'),
(1296, 'english', 'Follow this thread (notify me of new messages)', '2020-09-15 14:47:12', 1295, '[[regtime]]', '[[regtime]]'),
(1297, 'english', 'Posts', '2020-09-15 14:47:12', 1296, '[[regtime]]', '[[regtime]]'),
(1298, 'english', 'Replies', '2020-09-15 14:47:12', 1297, '[[regtime]]', '[[regtime]]'),
(1299, 'english', 'Threads', '2020-09-15 14:47:12', 1298, '[[regtime]]', '[[regtime]]'),
(1300, 'english', 'Watchers', '2020-09-15 14:47:12', 1299, '[[regtime]]', '[[regtime]]'),
(1301, 'english', 'Operations', '2020-09-15 14:47:12', 1300, '[[regtime]]', '[[regtime]]'),
(1302, 'english', 'Quote', '2020-09-15 14:47:12', 1301, '[[regtime]]', '[[regtime]]'),
(1303, 'english', 'Re-Open thread', '2020-09-15 14:47:12', 1302, '[[regtime]]', '[[regtime]]'),
(1304, 'english', 'Find topic', '2020-09-15 14:47:12', 1303, '[[regtime]]', '[[regtime]]'),
(1305, 'english', 'Search result for', '2020-09-15 14:47:12', 1304, '[[regtime]]', '[[regtime]]'),
(1306, 'english', 'Remove important flag from thread', '2020-09-15 14:47:12', 1305, '[[regtime]]', '[[regtime]]'),
(1307, 'english', 'list with the thread present for the forum selected', '2020-09-15 14:47:12', 1306, '[[regtime]]', '[[regtime]]'),
(1308, 'english', 'Discussions available in forum', '2020-09-15 14:47:12', 1307, '[[regtime]]', '[[regtime]]'),
(1309, 'english', 'List of threads', '2020-09-15 14:47:12', 1308, '[[regtime]]', '[[regtime]]'),
(1310, 'english', 'to forum', '2020-09-15 14:47:12', 1309, '[[regtime]]', '[[regtime]]'),
(1311, 'english', 'Make accessible', '2020-09-15 14:47:12', 1310, '[[regtime]]', '[[regtime]]'),
(1312, 'english', 'Re-Open forum', '2020-09-15 14:47:12', 1311, '[[regtime]]', '[[regtime]]'),
(1313, 'english', 'Open', '2020-09-15 14:47:12', 1312, '[[regtime]]', '[[regtime]]'),
(1314, 'english', 'Stop', '2020-09-15 14:47:12', 1313, '[[regtime]]', '[[regtime]]'),
(1315, 'english', 'Stop notifications for this forum', '2020-09-15 14:47:12', 1314, '[[regtime]]', '[[regtime]]'),
(1316, 'english', 'Stop alerting me when threads are created in this forum', '2020-09-15 14:47:12', 1315, '[[regtime]]', '[[regtime]]'),
(1317, 'english', 'Activate notifications', '2020-09-15 14:47:12', 1316, '[[regtime]]', '[[regtime]]'),
(1318, 'english', 'Stop notifications (stop annoying me)', '2020-09-15 14:47:12', 1317, '[[regtime]]', '[[regtime]]'),
(1319, 'english', 'Picture, avatar and signature', '2020-09-15 14:47:12', 1318, '[[regtime]]', '[[regtime]]'),
(1320, 'english', 'User info', '2020-09-15 14:47:12', 1319, '[[regtime]]', '[[regtime]]'),
(1321, 'english', 'Show profile', '2020-09-15 14:47:12', 1320, '[[regtime]]', '[[regtime]]'),
(1322, 'english', 'Written by', '2020-09-15 14:47:12', 1321, '[[regtime]]', '[[regtime]]'),
(1323, 'english', 'Add word', '2020-09-15 14:47:12', 1322, '[[regtime]]', '[[regtime]]'),
(1324, 'english', 'Glossary', '2020-09-15 14:47:12', 1323, '[[regtime]]', '[[regtime]]'),
(1325, 'english', 'Terms list in the glossary', '2020-09-15 14:47:12', 1324, '[[regtime]]', '[[regtime]]'),
(1326, 'english', 'Private Thread', '2020-09-15 14:47:12', 1325, '[[regtime]]', '[[regtime]]'),
(1327, 'english', 'Word', '2020-09-15 14:47:12', 1326, '[[regtime]]', '[[regtime]]'),
(1328, 'english', 'Word description', '2020-09-15 14:47:12', 1327, '[[regtime]]', '[[regtime]]'),
(1329, 'english', 'Terms', '2020-09-15 14:47:12', 1328, '[[regtime]]', '[[regtime]]'),
(1330, 'english', 'Grade book', '2020-09-15 14:47:12', 1329, '[[regtime]]', '[[regtime]]'),
(1331, 'english', 'This is your score for the activities of this course', '2020-09-15 14:47:12', 1330, '[[regtime]]', '[[regtime]]'),
(1332, 'english', 'This is a detailed list of the scores collected in this course', '2020-09-15 14:47:12', 1331, '[[regtime]]', '[[regtime]]'),
(1333, 'english', 'of', '2020-09-15 14:47:12', 1332, '[[regtime]]', '[[regtime]]'),
(1334, 'english', 'not graded yet', '2020-09-15 14:47:12', 1333, '[[regtime]]', '[[regtime]]'),
(1335, 'english', 'No score', '2020-09-15 14:47:12', 1334, '[[regtime]]', '[[regtime]]'),
(1336, 'english', 'N.', '2020-09-15 14:47:12', 1335, '[[regtime]]', '[[regtime]]'),
(1337, 'english', 'Sub.', '2020-09-15 14:47:12', 1336, '[[regtime]]', '[[regtime]]'),
(1338, 'english', 'Groups for this course', '2020-09-15 14:47:12', 1337, '[[regtime]]', '[[regtime]]'),
(1339, 'english', 'Manage the users subscribed to this group', '2020-09-15 14:47:12', 1338, '[[regtime]]', '[[regtime]]'),
(1340, 'english', 'Subscribe users', '2020-09-15 14:47:12', 1339, '[[regtime]]', '[[regtime]]'),
(1341, 'english', 'Select the destination for the copy operation', '2020-09-15 14:47:12', 1340, '[[regtime]]', '[[regtime]]'),
(1342, 'english', 'Choose destination folder', '2020-09-15 14:47:12', 1341, '[[regtime]]', '[[regtime]]'),
(1343, 'english', 'Auto-refresh', '2020-09-15 14:47:12', 1342, '[[regtime]]', '[[regtime]]'),
(1344, 'english', 'Emoticons', '2020-09-15 14:47:12', 1343, '[[regtime]]', '[[regtime]]'),
(1345, 'english', 'Message', '2020-09-15 14:47:12', 1344, '[[regtime]]', '[[regtime]]'),
(1346, 'english', 'Refresh', '2020-09-15 14:47:12', 1345, '[[regtime]]', '[[regtime]]'),
(1347, 'english', 'Rooms list', '2020-09-15 14:47:12', 1346, '[[regtime]]', '[[regtime]]'),
(1348, 'english', 'Users list', '2020-09-15 14:47:12', 1347, '[[regtime]]', '[[regtime]]'),
(1349, 'english', 'logged out.', '2020-09-15 14:47:12', 1348, '[[regtime]]', '[[regtime]]'),
(1350, 'english', 'logged in.', '2020-09-15 14:47:12', 1349, '[[regtime]]', '[[regtime]]'),
(1351, 'english', 'Introduction', '2020-09-15 14:47:12', 1350, '[[regtime]]', '[[regtime]]'),
(1352, 'english', 'Attachments', '2020-09-15 14:47:12', 1351, '[[regtime]]', '[[regtime]]'),
(1353, 'english', 'Back to top', '2020-09-15 14:47:12', 1352, '[[regtime]]', '[[regtime]]'),
(1354, 'english', 'HTML page', '2020-09-15 14:47:12', 1353, '[[regtime]]', '[[regtime]]'),
(1355, 'english', 'High', '2020-09-15 14:47:12', 1354, '[[regtime]]', '[[regtime]]'),
(1356, 'english', 'Low', '2020-09-15 14:47:12', 1355, '[[regtime]]', '[[regtime]]'),
(1357, 'english', 'Access', '2020-09-15 14:47:12', 1356, '[[regtime]]', '[[regtime]]'),
(1358, 'english', 'New connection', '2020-09-15 14:47:12', 1357, '[[regtime]]', '[[regtime]]'),
(1359, 'english', 'New connector', '2020-09-15 14:47:12', 1358, '[[regtime]]', '[[regtime]]'),
(1360, 'english', 'New task', '2020-09-15 14:47:12', 1359, '[[regtime]]', '[[regtime]]'),
(1361, 'english', 'From example (through the analysis of the first file matching File pattern)', '2020-09-15 14:47:12', 1360, '[[regtime]]', '[[regtime]]'),
(1362, 'english', 'If a course has been deleted', '2020-09-15 14:47:12', 1361, '[[regtime]]', '[[regtime]]'),
(1363, 'english', 'If a user has not been subscribed', '2020-09-15 14:47:12', 1362, '[[regtime]]', '[[regtime]]'),
(1364, 'english', 'Removed folders', '2020-09-15 14:47:12', 1363, '[[regtime]]', '[[regtime]]'),
(1365, 'english', 'Canceled users', '2020-09-15 14:47:12', 1364, '[[regtime]]', '[[regtime]]'),
(1366, 'english', 'Class', '2020-09-15 14:47:12', 1365, '[[regtime]]', '[[regtime]]'),
(1367, 'english', 'Confirm deletion', '2020-09-15 14:47:12', 1366, '[[regtime]]', '[[regtime]]'),
(1368, 'english', 'Connection', '2020-09-15 14:47:12', 1367, '[[regtime]]', '[[regtime]]'),
(1369, 'english', 'Connections', '2020-09-15 14:47:12', 1368, '[[regtime]]', '[[regtime]]'),
(1370, 'english', 'Connector', '2020-09-15 14:47:12', 1369, '[[regtime]]', '[[regtime]]'),
(1371, 'english', 'Connectors', '2020-09-15 14:47:12', 1370, '[[regtime]]', '[[regtime]]'),
(1372, 'english', 'Connectors', '2020-09-15 14:47:12', 1371, '[[regtime]]', '[[regtime]]'),
(1373, 'english', 'New connection', '2020-09-15 14:47:12', 1372, '[[regtime]]', '[[regtime]]'),
(1374, 'english', 'Connections', '2020-09-15 14:47:12', 1373, '[[regtime]]', '[[regtime]]'),
(1375, 'english', 'Destination', '2020-09-15 14:47:12', 1374, '[[regtime]]', '[[regtime]]'),
(1376, 'english', 'Don''t delete', '2020-09-15 14:47:12', 1375, '[[regtime]]', '[[regtime]]'),
(1377, 'english', 'Don''t send', '2020-09-15 14:47:12', 1376, '[[regtime]]', '[[regtime]]'),
(1378, 'english', 'Fields definition', '2020-09-15 14:47:12', 1377, '[[regtime]]', '[[regtime]]'),
(1379, 'english', 'Fields definition mode', '2020-09-15 14:47:12', 1378, '[[regtime]]', '[[regtime]]'),
(1380, 'english', 'Field delimiter', '2020-09-15 14:47:12', 1379, '[[regtime]]', '[[regtime]]'),
(1381, 'english', 'Enclosure character', '2020-09-15 14:47:12', 1380, '[[regtime]]', '[[regtime]]'),
(1382, 'english', 'Sub-folder', '2020-09-15 14:47:12', 1381, '[[regtime]]', '[[regtime]]'),
(1383, 'english', 'File pattern', '2020-09-15 14:47:12', 1382, '[[regtime]]', '[[regtime]]'),
(1384, 'english', 'filename*', '2020-09-15 14:47:12', 1383, '[[regtime]]', '[[regtime]]'),
(1385, 'english', 'Analyzed file', '2020-09-15 14:47:12', 1384, '[[regtime]]', '[[regtime]]'),
(1386, 'english', 'Finish', '2020-09-15 14:47:12', 1385, '[[regtime]]', '[[regtime]]'),
(1387, 'english', 'First row header', '2020-09-15 14:47:12', 1386, '[[regtime]]', '[[regtime]]'),
(1388, 'english', 'Group filter', '2020-09-15 14:47:12', 1387, '[[regtime]]', '[[regtime]]'),
(1389, 'english', 'Hour', '2020-09-15 14:47:12', 1388, '[[regtime]]', '[[regtime]]'),
(1390, 'english', 'No input to process', '2020-09-15 14:47:12', 1389, '[[regtime]]', '[[regtime]]'),
(1391, 'english', 'Import type', '2020-09-15 14:47:12', 1390, '[[regtime]]', '[[regtime]]'),
(1392, 'english', 'Insert only', '2020-09-15 14:47:12', 1391, '[[regtime]]', '[[regtime]]'),
(1393, 'english', 'Insert and remove', '2020-09-15 14:47:12', 1392, '[[regtime]]', '[[regtime]]'),
(1394, 'english', 'Last execution', '2020-09-15 14:47:12', 1393, '[[regtime]]', '[[regtime]]'),
(1395, 'english', 'Field''s map not required', '2020-09-15 14:47:12', 1394, '[[regtime]]', '[[regtime]]'),
(1396, 'english', 'There aren''t new connectors to insert', '2020-09-15 14:47:12', 1395, '[[regtime]]', '[[regtime]]'),
(1397, 'english', 'File pattern', '2020-09-15 14:47:12', 1396, '[[regtime]]', '[[regtime]]'),
(1398, 'english', 'Read', '2020-09-15 14:47:12', 1397, '[[regtime]]', '[[regtime]]'),
(1399, 'english', 'Read/Write', '2020-09-15 14:47:12', 1398, '[[regtime]]', '[[regtime]]'),
(1400, 'english', 'At', '2020-09-15 14:47:12', 1399, '[[regtime]]', '[[regtime]]'),
(1401, 'english', 'at %time%', '2020-09-15 14:47:12', 1400, '[[regtime]]', '[[regtime]]'),
(1402, 'english', 'Interval', '2020-09-15 14:47:12', 1401, '[[regtime]]', '[[regtime]]'),
(1403, 'english', 'any %interval% %unit%', '2020-09-15 14:47:12', 1402, '[[regtime]]', '[[regtime]]'),
(1404, 'english', 'Send notify', '2020-09-15 14:47:12', 1403, '[[regtime]]', '[[regtime]]'),
(1405, 'english', 'Source', '2020-09-15 14:47:12', 1404, '[[regtime]]', '[[regtime]]'),
(1406, 'english', 'Menu to assign to new courses', '2020-09-15 14:47:12', 1405, '[[regtime]]', '[[regtime]]'),
(1407, 'english', 'Tasks', '2020-09-15 14:47:12', 1406, '[[regtime]]', '[[regtime]]'),
(1408, 'english', 'Del task', '2020-09-15 14:47:12', 1407, '[[regtime]]', '[[regtime]]'),
(1409, 'english', 'Insert/update', '2020-09-15 14:47:12', 1408, '[[regtime]]', '[[regtime]]'),
(1410, 'english', 'New task', '2020-09-15 14:47:12', 1409, '[[regtime]]', '[[regtime]]'),
(1411, 'english', 'Run', '2020-09-15 14:47:12', 1410, '[[regtime]]', '[[regtime]]'),
(1412, 'english', 'Executed task', '2020-09-15 14:47:12', 1411, '[[regtime]]', '[[regtime]]'),
(1413, 'english', 'Destination folder for users', '2020-09-15 14:47:12', 1412, '[[regtime]]', '[[regtime]]'),
(1414, 'english', 'Select the folder containing the imported tree', '2020-09-15 14:47:12', 1413, '[[regtime]]', '[[regtime]]'),
(1415, 'english', 'Write', '2020-09-15 14:47:12', 1414, '[[regtime]]', '[[regtime]]'),
(1416, 'english', 'File not specified', '2020-09-15 14:47:12', 1415, '[[regtime]]', '[[regtime]]'),
(1417, 'english', 'File to upload<br />(this will overwrite the old one)', '2020-09-15 14:47:12', 1416, '[[regtime]]', '[[regtime]]'),
(1418, 'english', 'File type', '2020-09-15 14:47:12', 1417, '[[regtime]]', '[[regtime]]'),
(1419, 'english', 'Upload files', '2020-09-15 14:47:12', 1418, '[[regtime]]', '[[regtime]]'),
(1420, 'english', 'By instructor', '2020-09-15 14:47:12', 1419, '[[regtime]]', '[[regtime]]'),
(1421, 'english', 'By student', '2020-09-15 14:47:12', 1420, '[[regtime]]', '[[regtime]]'),
(1422, 'english', 'Show all', '2020-09-15 14:47:12', 1421, '[[regtime]]', '[[regtime]]'),
(1423, 'english', 'Categorized only', '2020-09-15 14:47:12', 1422, '[[regtime]]', '[[regtime]]'),
(1424, 'english', 'Switch from SCORM categorization to chapters categorization', '2020-09-15 14:47:12', 1423, '[[regtime]]', '[[regtime]]'),
(1425, 'english', 'Contained in', '2020-09-15 14:47:12', 1424, '[[regtime]]', '[[regtime]]'),
(1426, 'english', 'This resource is mobile compliant.', '2020-09-15 14:47:12', 1425, '[[regtime]]', '[[regtime]]'),
(1427, 'english', 'Original name stored in the platform', '2020-09-15 14:47:12', 1426, '[[regtime]]', '[[regtime]]'),
(1428, 'english', 'Select from the dropdown menu', '2020-09-15 14:47:12', 1427, '[[regtime]]', '[[regtime]]'),
(1429, 'english', 'Only related users can see this object', '2020-09-15 14:47:12', 1428, '[[regtime]]', '[[regtime]]'),
(1430, 'english', 'Everyone can access this object', '2020-09-15 14:47:12', 1429, '[[regtime]]', '[[regtime]]'),
(1431, 'english', 'Uncategorized only', '2020-09-15 14:47:12', 1430, '[[regtime]]', '[[regtime]]'),
(1432, 'english', 'Make this resource playable also by people that cannot access it.', '2020-09-15 14:47:12', 1431, '[[regtime]]', '[[regtime]]'),
(1433, 'english', 'Switching between categorization mode will delete the current categorization.', '2020-09-15 14:47:12', 1432, '[[regtime]]', '[[regtime]]'),
(1434, 'english', 'All the courses you are enrolled in.', '2020-09-15 14:47:12', 1433, '[[regtime]]', '[[regtime]]'),
(1435, 'english', 'Guest', '2020-09-15 14:47:12', 1434, '[[regtime]]', '[[regtime]]'),
(1436, 'english', 'Ghost', '2020-09-15 14:47:12', 1435, '[[regtime]]', '[[regtime]]'),
(1437, 'english', 'Student', '2020-09-15 14:47:12', 1436, '[[regtime]]', '[[regtime]]'),
(1438, 'english', 'Tutor', '2020-09-15 14:47:12', 1437, '[[regtime]]', '[[regtime]]'),
(1439, 'english', 'Mentor', '2020-09-15 14:47:12', 1438, '[[regtime]]', '[[regtime]]'),
(1440, 'english', 'Instructor', '2020-09-15 14:47:12', 1439, '[[regtime]]', '[[regtime]]'),
(1441, 'english', 'Administrator', '2020-09-15 14:47:12', 1440, '[[regtime]]', '[[regtime]]'),
(1442, 'english', 'Add file to repository', '2020-09-15 14:47:12', 1441, '[[regtime]]', '[[regtime]]'),
(1443, 'english', 'Files uploaded', '2020-09-15 14:47:12', 1442, '[[regtime]]', '[[regtime]]'),
(1444, 'english', 'Uploaded files', '2020-09-15 14:47:12', 1443, '[[regtime]]', '[[regtime]]'),
(1445, 'english', 'New repository', '2020-09-15 14:47:12', 1444, '[[regtime]]', '[[regtime]]'),
(1446, 'english', 'No repositories available', '2020-09-15 14:47:12', 1445, '[[regtime]]', '[[regtime]]'),
(1447, 'english', 'new files', '2020-09-15 14:47:12', 1446, '[[regtime]]', '[[regtime]]'),
(1448, 'english', 'Send notifications to Teachers', '2022-03-10 11:47:16', 1447, '[[regtime]]', '[[regtime]]'),
(1449, 'english', 'The user [user_id] uploaded a file in the repo [repo_name] of the course [course_name]', '2022-03-10 11:47:16', 1448, '[[regtime]]', '[[regtime]]'),
(1450, 'english', 'New upload in the repo [repo_name]', '2022-03-10 11:47:16', 1449, '[[regtime]]', '[[regtime]]'),
(1451, 'english', 'Repository', '2020-09-15 14:47:12', 1450, '[[regtime]]', '[[regtime]]'),
(1452, 'english', 'View student files', '2020-09-15 14:47:12', 1451, '[[regtime]]', '[[regtime]]'),
(1453, 'english', 'Add link', '2020-09-15 14:47:12', 1452, '[[regtime]]', '[[regtime]]'),
(1454, 'english', 'Allow to add a new link', '2020-09-15 14:47:12', 1453, '[[regtime]]', '[[regtime]]'),
(1455, 'english', 'Back to top', '2020-09-15 14:47:12', 1454, '[[regtime]]', '[[regtime]]'),
(1456, 'english', 'Keywords (separate by comma please)', '2020-09-15 14:47:12', 1455, '[[regtime]]', '[[regtime]]'),
(1457, 'english', 'All the links will be opened in a new window', '2020-09-15 14:47:12', 1456, '[[regtime]]', '[[regtime]]'),
(1458, 'english', 'URL (Ex. http://www.website.com)', '2020-09-15 14:47:12', 1457, '[[regtime]]', '[[regtime]]'),
(1459, 'english', 'Link', '2020-09-15 14:47:12', 1458, '[[regtime]]', '[[regtime]]'),
(1460, 'english', 'Select a word', '2020-09-15 14:47:12', 1459, '[[regtime]]', '[[regtime]]'),
(1461, 'english', 'Link list in category', '2020-09-15 14:47:12', 1460, '[[regtime]]', '[[regtime]]'),
(1462, 'english', 'Keywords view', '2020-09-15 14:47:12', 1461, '[[regtime]]', '[[regtime]]'),
(1463, 'english', 'List view', '2020-09-15 14:47:12', 1462, '[[regtime]]', '[[regtime]]'),
(1464, 'english', 'Words', '2020-09-15 14:47:12', 1463, '[[regtime]]', '[[regtime]]'),
(1465, 'english', 'Locked access', '2020-09-15 14:47:12', 1464, '[[regtime]]', '[[regtime]]'),
(1466, 'english', 'Access request from social canceled by the user', '2020-09-15 14:47:12', 1465, '[[regtime]]', '[[regtime]]'),
(1467, 'english', 'Unable to find social ID account', '2020-09-15 14:47:12', 1466, '[[regtime]]', '[[regtime]]'),
(1468, 'english', 'Home page', '2020-09-15 14:47:12', 1467, '[[regtime]]', '[[regtime]]'),
(1469, 'english', 'The Platform supports 26 languages, it''s compliant with the SCORM 1.2 and 2004 standards, and supports different didactic models, including: Blended, Self-Directed, Collaborative and even Social Learning through Chat, Wiki, Forums and other different functions.<br/>\n<br/>\n<br/>\nTo change these words please go to Admin/Language management, search for <b>login</b>, and edit the keys <b>_INTRO_STD_TEXT_TITLE</b> and <b>_INTRO_STD_TEXT</b>', '2020-09-15 14:47:12', 1468, '[[regtime]]', '[[regtime]]'),
(1470, 'english', 'forma.lms is an open source e-learning platform (LMS and LCMS) used in corporate and higher education markets', '2020-09-15 14:47:12', 1469, '[[regtime]]', '[[regtime]]'),
(1471, 'english', 'Jump to login form', '2020-09-15 14:47:12', 1470, '[[regtime]]', '[[regtime]]'),
(1472, 'english', 'LDAP authentication is active, functionality unavailable please call your administrator', '2020-09-15 14:47:12', 1471, '[[regtime]]', '[[regtime]]'),
(1473, 'english', 'Login', '2020-09-15 14:47:12', 1472, '[[regtime]]', '[[regtime]]'),
(1474, 'english', 'Accessible Login', '2020-09-15 14:47:12', 1473, '[[regtime]]', '[[regtime]]'),
(1475, 'english', 'Login', '2020-09-15 14:47:12', 1474, '[[regtime]]', '[[regtime]]'),
(1476, 'english', 'Login with', '2020-09-15 14:47:12', 1475, '[[regtime]]', '[[regtime]]'),
(1477, 'english', 'Login', '2020-09-15 14:47:12', 1476, '[[regtime]]', '[[regtime]]'),
(1478, 'english', 'Lost password', '2020-09-15 14:47:12', 1477, '[[regtime]]', '[[regtime]]'),
(1479, 'english', 'Fill this field with your username and you will receive an email (at your registration address) with instructions to generate a new password.', '2020-09-15 14:47:12', 1478, '[[regtime]]', '[[regtime]]'),
(1480, 'english', 'Fill this field with the email given in your registration process and you will receive an email that contains your username for this site.', '2020-09-15 14:47:12', 1479, '[[regtime]]', '[[regtime]]'),
(1481, 'english', 'I lost my username', '2020-09-15 14:47:12', 1480, '[[regtime]]', '[[regtime]]'),
(1482, 'english', 'System in maintenance mode.<br/><br/>To change this text please go to Admin/Language management, search for login and edit the key _MAINTENANCE_TEXT', '2020-09-15 14:47:12', 1481, '[[regtime]]', '[[regtime]]'),
(1483, 'english', 'Access denied, please check your password', '2020-09-15 14:47:12', 1482, '[[regtime]]', '[[regtime]]'),
(1484, 'english', 'The two provided passwords are not equal or password field is empty.', '2020-09-15 14:47:12', 1483, '[[regtime]]', '[[regtime]]'),
(1485, 'english', 'Read All', '2020-09-15 14:47:12', 1484, '[[regtime]]', '[[regtime]]'),
(1486, 'english', 'Please [login] or [signin] to buy or proceed with this course', '2020-09-15 14:47:12', 1485, '[[regtime]]', '[[regtime]]'),
(1487, 'english', 'Please [login] to buy or proceed with this course', '2020-09-15 14:47:12', 1486, '[[regtime]]', '[[regtime]]'),
(1488, 'english', 'register with Facebook', '2020-09-15 14:47:12', 1487, '[[regtime]]', '[[regtime]]'),
(1489, 'english', 'This request has expired.', '2020-09-15 14:47:12', 1488, '[[regtime]]', '[[regtime]]'),
(1490, 'english', 'Any information collected by us, relating to an identifiable person, shall be used only in accordance with the procedures and for the purposes that are here acknowledged to the data subject and where the latter, as required by law, has expressely consented. <br><br>\n\n- User login and private area<br>\n- User newsletter<br>\n- User custom content purpose<br><br>\n\nIn handling this information, accuracy and precision shall be met to ensure the integrity and quality of the processed personal data, if you have any question please contact us.', '2020-09-15 14:47:12', 1489, '[[regtime]]', '[[regtime]]'),
(1491, 'english', 'Session expired', '2020-09-15 14:47:12', 1490, '[[regtime]]', '[[regtime]]'),
(1492, 'english', 'Register', '2020-09-15 14:47:12', 1491, '[[regtime]]', '[[regtime]]'),
(1493, 'english', 'Social ID connection failed', '2020-09-15 14:47:12', 1492, '[[regtime]]', '[[regtime]]'),
(1494, 'english', 'Successful social ID connection', '2020-09-15 14:47:12', 1493, '[[regtime]]', '[[regtime]]'),
(1495, 'english', 'Another user has logged in with your username', '2020-09-15 14:47:12', 1494, '[[regtime]]', '[[regtime]]'),
(1496, 'english', 'Unknown error during Google login', '2020-09-15 14:47:12', 1495, '[[regtime]]', '[[regtime]]'),
(1497, 'english', 'Unknown error in social login', '2020-09-15 14:47:12', 1496, '[[regtime]]', '[[regtime]]'),
(1498, 'english', 'You are logged out', '2020-09-15 14:47:12', 1497, '[[regtime]]', '[[regtime]]'),
(1499, 'english', 'Add new custom menu', '2020-09-15 14:47:12', 1498, '[[regtime]]', '[[regtime]]'),
(1500, 'english', 'Check all', '2020-09-15 14:47:12', 1499, '[[regtime]]', '[[regtime]]'),
(1501, 'english', 'Personalized name', '2020-09-15 14:47:12', 1500, '[[regtime]]', '[[regtime]]'),
(1502, 'english', 'Create as a copy of', '2020-09-15 14:47:12', 1501, '[[regtime]]', '[[regtime]]'),
(1503, 'english', 'Levels', '2020-09-15 14:47:12', 1502, '[[regtime]]', '[[regtime]]'),
(1504, 'english', 'Assign modules to menu item', '2020-09-15 14:47:12', 1503, '[[regtime]]', '[[regtime]]'),
(1505, 'english', 'Customized name', '2020-09-15 14:47:12', 1504, '[[regtime]]', '[[regtime]]'),
(1506, 'english', 'Sequence', '2020-09-15 14:47:12', 1505, '[[regtime]]', '[[regtime]]'),
(1507, 'english', 'Icons', '2020-09-15 14:47:12', 1506, '[[regtime]]', '[[regtime]]'),
(1508, 'english', 'Choose an icon for this menu', '2020-09-15 14:47:12', 1507, '[[regtime]]', '[[regtime]]'),
(1509, 'english', 'Custom Menu', '2020-09-15 14:47:12', 1508, '[[regtime]]', '[[regtime]]'),
(1510, 'english', 'List of custom menus created', '2020-09-15 14:47:12', 1509, '[[regtime]]', '[[regtime]]'),
(1511, 'english', 'Available modules for import', '2020-09-15 14:47:12', 1510, '[[regtime]]', '[[regtime]]'),
(1512, 'english', 'Main menu', '2020-09-15 14:47:12', 1511, '[[regtime]]', '[[regtime]]'),
(1513, 'english', 'Main items of the current custom menu', '2020-09-15 14:47:12', 1512, '[[regtime]]', '[[regtime]]'),
(1514, 'english', 'Modules assigned to this menu', '2020-09-15 14:47:12', 1513, '[[regtime]]', '[[regtime]]'),
(1515, 'english', 'Modules assigned to this menu', '2020-09-15 14:47:12', 1514, '[[regtime]]', '[[regtime]]'),
(1516, 'english', 'Add custom menu', '2020-09-15 14:47:12', 1515, '[[regtime]]', '[[regtime]]'),
(1517, 'english', 'Assign this module to this menu', '2020-09-15 14:47:12', 1516, '[[regtime]]', '[[regtime]]'),
(1518, 'english', 'Menu management', '2020-09-15 14:47:12', 1517, '[[regtime]]', '[[regtime]]'),
(1519, 'english', 'Menu items', '2020-09-15 14:47:12', 1518, '[[regtime]]', '[[regtime]]'),
(1520, 'english', 'Module', '2020-09-15 14:47:12', 1519, '[[regtime]]', '[[regtime]]'),
(1521, 'english', 'Uncheck all', '2020-09-15 14:47:12', 1520, '[[regtime]]', '[[regtime]]'),
(1522, 'english', 'You are importing the module to this menu', '2020-09-15 14:47:12', 1521, '[[regtime]]', '[[regtime]]'),
(1523, 'english', 'You are working on this module', '2020-09-15 14:47:12', 1522, '[[regtime]]', '[[regtime]]'),
(1524, 'english', 'Main preferences', '2020-09-15 14:47:12', 1523, '[[regtime]]', '[[regtime]]'),
(1525, 'english', 'Administrators management', '2020-09-15 14:47:12', 1524, '[[regtime]]', '[[regtime]]'),
(1526, 'english', 'Administrator profile', '2020-09-15 14:47:12', 1525, '[[regtime]]', '[[regtime]]'),
(1527, 'english', 'Associate Users', '2020-09-15 14:47:12', 1526, '[[regtime]]', '[[regtime]]'),
(1528, 'english', 'Jump to the main menu', '2020-09-15 14:47:12', 1527, '[[regtime]]', '[[regtime]]'),
(1529, 'english', 'Jump to the modules list', '2020-09-15 14:47:12', 1528, '[[regtime]]', '[[regtime]]'),
(1530, 'english', 'Certificates', '2020-09-15 14:47:12', 1529, '[[regtime]]', '[[regtime]]'),
(1531, 'english', 'Communications', '2020-09-15 14:47:12', 1530, '[[regtime]]', '[[regtime]]'),
(1532, 'english', 'Manage Communications', '2015-09-30 15:32:39', 1531, '[[regtime]]', '[[regtime]]'),
(1533, 'english', 'Categories', '2015-09-30 15:32:39', 1532, '[[regtime]]', '[[regtime]]'),
(1534, 'english', 'Mail Settings', '2015-09-30 15:32:39', 1533, '[[regtime]]', '[[regtime]]'),
(1535, 'english', 'Domains settings', '2015-09-30 15:32:39', 1534, '[[regtime]]', '[[regtime]]'),
(1536, 'english', 'Settings', '2020-09-15 14:47:12', 1535, '[[regtime]]', '[[regtime]]'),
(1537, 'english', 'E-learning configuration', '2020-09-15 14:47:12', 1536, '[[regtime]]', '[[regtime]]'),
(1538, 'english', 'System configuration', '2020-09-15 14:47:12', 1537, '[[regtime]]', '[[regtime]]'),
(1539, 'english', 'Customfield manager', '2020-09-15 14:47:12', 1538, '[[regtime]]', '[[regtime]]'),
(1540, 'english', 'Welcome Page', '2020-09-15 14:47:12', 1539, '[[regtime]]', '[[regtime]]'),
(1541, 'english', 'Dashboard Settings', '2022-03-28 10:15:50', 1540, '[[regtime]]', '[[regtime]]'),
(1542, 'english', 'Event manager', '2020-09-15 14:47:12', 1541, '[[regtime]]', '[[regtime]]'),
(1543, 'english', 'Events', '2020-09-15 14:47:12', 1542, '[[regtime]]', '[[regtime]]'),
(1544, 'english', 'Additional fields', '2020-09-15 14:47:12', 1543, '[[regtime]]', '[[regtime]]'),
(1545, 'english', 'Main', '2020-09-15 14:47:12', 1544, '[[regtime]]', '[[regtime]]'),
(1546, 'english', 'E-learning', '2020-09-15 14:47:12', 1545, '[[regtime]]', '[[regtime]]'),
(1547, 'english', 'I/O Task', '2020-09-15 14:47:12', 1546, '[[regtime]]', '[[regtime]]'),
(1548, 'english', 'Jump to:', '2020-09-15 14:47:12', 1547, '[[regtime]]', '[[regtime]]'),
(1549, 'english', 'Language management', '2020-09-15 14:47:12', 1548, '[[regtime]]', '[[regtime]]'),
(1550, 'english', 'User management', '2020-09-15 14:47:12', 1549, '[[regtime]]', '[[regtime]]'),
(1551, 'english', 'E-learning', '2020-09-15 14:47:12', 1550, '[[regtime]]', '[[regtime]]'),
(1552, 'english', 'Reservation management', '2020-09-15 14:47:12', 1551, '[[regtime]]', '[[regtime]]'),
(1553, 'english', 'Certificates management', '2020-09-15 14:47:12', 1552, '[[regtime]]', '[[regtime]]'),
(1554, 'english', 'Aggregated certificates', '2020-09-15 14:47:12', 1553, '[[regtime]]', '[[regtime]]'),
(1555, 'english', 'User area in LMS', '2020-09-15 14:47:12', 1554, '[[regtime]]', '[[regtime]]'),
(1556, 'english', 'Module name', '2020-09-15 14:47:12', 1555, '[[regtime]]', '[[regtime]]'),
(1557, 'english', 'Manage news in users area', '2020-09-15 14:47:12', 1556, '[[regtime]]', '[[regtime]]'),
(1558, 'english', 'Template player', '2020-09-15 14:47:12', 1557, '[[regtime]]', '[[regtime]]'),
(1559, 'english', 'Plugin manager', '2020-09-15 14:47:12', 1558, '[[regtime]]', '[[regtime]]'),
(1560, 'english', 'Privacy policies', '2020-09-15 14:47:12', 1559, '[[regtime]]', '[[regtime]]'),
(1561, 'english', 'Public Administrators management', '2020-09-15 14:47:12', 1560, '[[regtime]]', '[[regtime]]'),
(1562, 'english', 'Public Administrator profile', '2020-09-15 14:47:12', 1561, '[[regtime]]', '[[regtime]]'),
(1563, 'english', 'Question category', '2020-09-15 14:47:12', 1562, '[[regtime]]', '[[regtime]]'),
(1564, 'english', 'Question Category', '2020-09-15 14:47:12', 1563, '[[regtime]]', '[[regtime]]'),
(1565, 'english', 'Issued Certificates', '2020-09-15 14:47:12', 1564, '[[regtime]]', '[[regtime]]'),
(1566, 'english', 'Reservations', '2020-09-15 14:47:12', 1565, '[[regtime]]', '[[regtime]]'),
(1567, 'english', 'Subscribe to course', '2020-09-15 14:47:12', 1566, '[[regtime]]', '[[regtime]]'),
(1568, 'english', 'Configuration', '2020-09-15 14:47:12', 1567, '[[regtime]]', '[[regtime]]'),
(1569, 'english', 'Users', '2020-09-15 14:47:12', 1568, '[[regtime]]', '[[regtime]]'),
(1570, 'english', 'Web pages', '2020-09-15 14:47:12', 1569, '[[regtime]]', '[[regtime]]'),
(1571, 'english', 'Course search bar', '2015-09-30 15:32:39', 1570, '[[regtime]]', '[[regtime]]'),
(1572, 'english', 'Look for a course', '2015-09-30 15:32:39', 1571, '[[regtime]]', '[[regtime]]'),
(1573, 'english', 'Social area', '2020-09-15 14:47:12', 1572, '[[regtime]]', '[[regtime]]'),
(1574, 'english', 'Student area', '2020-09-15 14:47:12', 1573, '[[regtime]]', '[[regtime]]'),
(1575, 'english', 'Collaborative Area', '2020-09-15 14:47:12', 1574, '[[regtime]]', '[[regtime]]'),
(1576, 'english', 'Management', '2020-09-15 14:47:12', 1575, '[[regtime]]', '[[regtime]]'),
(1577, 'english', 'Stat Area', '2020-09-15 14:47:12', 1576, '[[regtime]]', '[[regtime]]'),
(1578, 'english', 'Statistics', '2020-09-15 14:47:12', 1577, '[[regtime]]', '[[regtime]]'),
(1579, 'english', 'Student Area', '2020-09-15 14:47:12', 1578, '[[regtime]]', '[[regtime]]'),
(1580, 'english', 'Teacher Area', '2020-09-15 14:47:12', 1579, '[[regtime]]', '[[regtime]]'),
(1581, 'english', 'Announcements', '2020-09-15 14:47:12', 1580, '[[regtime]]', '[[regtime]]'),
(1582, 'english', 'Course charts', '2020-09-15 14:47:12', 1581, '[[regtime]]', '[[regtime]]'),
(1583, 'english', 'Grade book', '2020-09-15 14:47:12', 1582, '[[regtime]]', '[[regtime]]'),
(1584, 'english', 'Users/objects grid', '2020-09-15 14:47:12', 1583, '[[regtime]]', '[[regtime]]'),
(1585, 'english', 'E-Portfolio', '2020-09-15 14:47:12', 1584, '[[regtime]]', '[[regtime]]'),
(1586, 'english', 'Report card', '2020-09-15 14:47:12', 1585, '[[regtime]]', '[[regtime]]'),
(1587, 'english', 'Group management', '2020-09-15 14:47:12', 1586, '[[regtime]]', '[[regtime]]'),
(1588, 'english', 'Introduction', '2020-09-15 14:47:12', 1587, '[[regtime]]', '[[regtime]]'),
(1589, 'english', 'Course Info', '2020-09-15 14:47:12', 1588, '[[regtime]]', '[[regtime]]'),
(1590, 'english', 'Repository', '2020-09-15 14:47:12', 1589, '[[regtime]]', '[[regtime]]'),
(1591, 'english', 'Course documents', '2020-09-15 14:47:12', 1590, '[[regtime]]', '[[regtime]]'),
(1592, 'english', 'My Profile', '2020-09-15 14:47:12', 1591, '[[regtime]]', '[[regtime]]'),
(1593, 'english', 'Project management', '2020-09-15 14:47:12', 1592, '[[regtime]]', '[[regtime]]'),
(1594, 'english', 'Quest bank', '2020-09-15 14:47:12', 1593, '[[regtime]]', '[[regtime]]'),
(1595, 'english', 'Reservation module', '2020-09-15 14:47:12', 1594, '[[regtime]]', '[[regtime]]'),
(1596, 'english', 'Usage stats', '2020-09-15 14:47:12', 1595, '[[regtime]]', '[[regtime]]'),
(1597, 'english', 'Learning object stats', '2020-09-15 14:47:12', 1596, '[[regtime]]', '[[regtime]]'),
(1598, 'english', 'User stats', '2020-09-15 14:47:12', 1597, '[[regtime]]', '[[regtime]]'),
(1599, 'english', 'Learning object management', '2020-09-15 14:47:12', 1598, '[[regtime]]', '[[regtime]]'),
(1600, 'english', 'Video conference', '2020-09-15 14:47:12', 1599, '[[regtime]]', '[[regtime]]'),
(1601, 'english', 'Wiki', '2020-09-15 14:47:12', 1600, '[[regtime]]', '[[regtime]]'),
(1602, 'english', 'Authoring', '2020-09-15 14:47:12', 1601, '[[regtime]]', '[[regtime]]'),
(1603, 'english', 'Jump to the main menu', '2020-09-15 14:47:12', 1602, '[[regtime]]', '[[regtime]]'),
(1604, 'english', 'Jump to your information related to this course', '2020-09-15 14:47:12', 1603, '[[regtime]]', '[[regtime]]'),
(1605, 'english', 'Certificate download', '2020-09-15 14:47:12', 1604, '[[regtime]]', '[[regtime]]'),
(1606, 'english', 'Community', '2020-09-15 14:47:12', 1605, '[[regtime]]', '[[regtime]]'),
(1607, 'english', 'Add course', '2020-09-15 14:47:12', 1606, '[[regtime]]', '[[regtime]]'),
(1608, 'english', 'Admin area', '2020-09-15 14:47:12', 1607, '[[regtime]]', '[[regtime]]'),
(1609, 'english', 'Request help', '2020-09-15 14:47:12', 1608, '[[regtime]]', '[[regtime]]'),
(1610, 'english', 'Authoring', '2020-09-15 14:47:12', 1609, '[[regtime]]', '[[regtime]]'),
(1611, 'english', 'Campus', '2020-09-15 14:47:12', 1610, '[[regtime]]', '[[regtime]]'),
(1612, 'english', 'General menu', '2020-09-15 14:47:12', 1611, '[[regtime]]', '[[regtime]]'),
(1613, 'english', 'Competences', '2020-09-15 14:47:12', 1612, '[[regtime]]', '[[regtime]]'),
(1614, 'english', 'My Courses', '2020-09-15 14:47:12', 1613, '[[regtime]]', '[[regtime]]'),
(1615, 'english', 'My area', '2020-09-15 14:47:12', 1614, '[[regtime]]', '[[regtime]]'),
(1616, 'english', 'Certificates', '2020-09-15 14:47:12', 1615, '[[regtime]]', '[[regtime]]'),
(1617, 'english', 'Manage', '2020-09-15 14:47:12', 1616, '[[regtime]]', '[[regtime]]'),
(1618, 'english', 'Certificates', '2020-09-15 14:47:12', 1617, '[[regtime]]', '[[regtime]]'),
(1619, 'english', 'Course management', '2020-09-15 14:47:12', 1618, '[[regtime]]', '[[regtime]]'),
(1620, 'english', 'Community', '2020-09-15 14:47:12', 1619, '[[regtime]]', '[[regtime]]'),
(1621, 'english', 'Newsletter', '2020-09-15 14:47:12', 1620, '[[regtime]]', '[[regtime]]'),
(1622, 'english', 'Reports', '2020-09-15 14:47:12', 1621, '[[regtime]]', '[[regtime]]'),
(1623, 'english', 'Course subscriptions management', '2020-09-15 14:47:12', 1622, '[[regtime]]', '[[regtime]]'),
(1624, 'english', 'Users management', '2020-09-15 14:47:12', 1623, '[[regtime]]', '[[regtime]]'),
(1625, 'english', 'Support', '2020-09-15 14:47:12', 1624, '[[regtime]]', '[[regtime]]'),
(1626, 'english', 'The message has attachments', '2020-09-15 14:47:12', 1625, '[[regtime]]', '[[regtime]]'),
(1627, 'english', 'Autorizzo l''invio di informazioni tecniche all''assistenza utili per risolvere la mia richiesta', '2020-09-15 14:47:12', 1626, '[[regtime]]', '[[regtime]]'),
(1628, 'english', 'Your personal informations required to provide support will be sent to system administrators', '2020-09-15 14:47:12', 1627, '[[regtime]]', '[[regtime]]'),
(1629, 'english', 'Send a message to users of the course:', '2020-09-15 14:47:12', 1628, '[[regtime]]', '[[regtime]]'),
(1630, 'english', 'High', '2020-09-15 14:47:12', 1629, '[[regtime]]', '[[regtime]]'),
(1631, 'english', 'Received', '2020-09-15 14:47:12', 1630, '[[regtime]]', '[[regtime]]'),
(1632, 'english', 'Low', '2020-09-15 14:47:12', 1631, '[[regtime]]', '[[regtime]]'),
(1633, 'english', 'Mime type', '2020-09-15 14:47:12', 1632, '[[regtime]]', '[[regtime]]'),
(1634, 'english', 'You have inserted a blank subject', '2020-09-15 14:47:12', 1633, '[[regtime]]', '[[regtime]]'),
(1635, 'english', 'Normal', '2020-09-15 14:47:12', 1634, '[[regtime]]', '[[regtime]]'),
(1636, 'english', 'Sent', '2020-09-15 14:47:12', 1635, '[[regtime]]', '[[regtime]]'),
(1637, 'english', 'Priority', '2020-09-15 14:47:12', 1636, '[[regtime]]', '[[regtime]]'),
(1638, 'english', 'Refresh', '2020-09-15 14:47:12', 1637, '[[regtime]]', '[[regtime]]'),
(1639, 'english', 'Send a CC message', '2020-09-15 14:47:12', 1638, '[[regtime]]', '[[regtime]]'),
(1640, 'english', 'Message read', '2020-09-15 14:47:12', 1639, '[[regtime]]', '[[regtime]]'),
(1641, 'english', 'Very high', '2020-09-15 14:47:12', 1640, '[[regtime]]', '[[regtime]]'),
(1642, 'english', 'Very low', '2020-09-15 14:47:12', 1641, '[[regtime]]', '[[regtime]]'),
(1643, 'english', 'Blocks', '2020-09-15 14:47:12', 1642, '[[regtime]]', '[[regtime]]'),
(1644, 'english', 'Select who can view this block', '2020-09-15 14:47:12', 1643, '[[regtime]]', '[[regtime]]'),
(1645, 'english', 'Complete user profile', '2020-09-15 14:47:12', 1644, '[[regtime]]', '[[regtime]]'),
(1, 'english', 'Dashboard', '2022-03-10 11:47:09', 1645, '[[regtime]]', '[[regtime]]'),
(1646, 'english', 'Make block visible', '2020-09-15 14:47:12', 1646, '[[regtime]]', '[[regtime]]'),
(1647, 'english', 'Home', '2020-09-15 14:47:12', 1647, '[[regtime]]', '[[regtime]]'),
(1648, 'english', 'Internal area', '2020-09-15 14:47:12', 1648, '[[regtime]]', '[[regtime]]'),
(1649, 'english', 'Simplified user profile', '2020-09-15 14:47:12', 1649, '[[regtime]]', '[[regtime]]'),
(1650, 'english', 'New notes', '2020-09-15 14:47:12', 1650, '[[regtime]]', '[[regtime]]'),
(1651, 'english', 'Show note', '2020-09-15 14:47:12', 1651, '[[regtime]]', '[[regtime]]'),
(1652, 'english', 'Notes', '2020-09-15 14:47:12', 1652, '[[regtime]]', '[[regtime]]'),
(1653, 'english', 'Vertical menu bar', '2020-09-15 14:47:12', 1653, '[[regtime]]', '[[regtime]]'),
(1654, 'english', 'Empty menu', '2020-09-15 14:47:12', 1654, '[[regtime]]', '[[regtime]]'),
(1655, 'english', 'Vertical menu', '2020-09-15 14:47:12', 1655, '[[regtime]]', '[[regtime]]'),
(1656, 'english', 'Attempt', '2020-09-15 14:47:12', 1656, '[[regtime]]', '[[regtime]]'),
(1657, 'english', 'Attempts', '2020-09-15 14:47:12', 1657, '[[regtime]]', '[[regtime]]'),
(1658, 'english', 'Autoplay', '2020-09-15 14:47:12', 1658, '[[regtime]]', '[[regtime]]'),
(1659, 'english', 'Your progress will be saved.', '2020-09-15 14:47:12', 1659, '[[regtime]]', '[[regtime]]'),
(1660, 'english', 'Hide menu', '2020-09-15 14:47:12', 1660, '[[regtime]]', '[[regtime]]'),
(1661, 'english', 'Ignore score', '2022-03-10 11:47:16', 1661, '[[regtime]]', '[[regtime]]'),
(1662, 'english', 'Blocked', '2020-09-15 14:47:12', 1662, '[[regtime]]', '[[regtime]]'),
(1663, 'english', 'Statistics not available', '2020-09-15 14:47:12', 1663, '[[regtime]]', '[[regtime]]'),
(1664, 'english', 'Objective', '2020-09-15 14:47:12', 1664, '[[regtime]]', '[[regtime]]'),
(1665, 'english', 'Lectures', '2020-09-15 14:47:12', 1665, '[[regtime]]', '[[regtime]]'),
(1666, 'english', 'End object marker', '2020-09-15 14:47:12', 1666, '[[regtime]]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES
(1667, 'english', 'Prerequisites not satisfied', '2020-09-15 14:47:12', 1667, '[[regtime]]', '[[regtime]]'),
(1668, 'english', 'Bookmark', '2020-09-15 14:47:12', 1668, '[[regtime]]', '[[regtime]]'),
(1669, 'english', 'Final', '2020-09-15 14:47:12', 1669, '[[regtime]]', '[[regtime]]'),
(1670, 'english', 'Begin', '2020-09-15 14:47:12', 1670, '[[regtime]]', '[[regtime]]'),
(1671, 'english', 'Execute object', '2020-09-15 14:47:12', 1671, '[[regtime]]', '[[regtime]]'),
(1672, 'english', 'Lectures', '2020-09-15 14:47:12', 1672, '[[regtime]]', '[[regtime]]'),
(1673, 'english', 'Access', '2020-09-15 14:47:12', 1673, '[[regtime]]', '[[regtime]]'),
(1674, 'english', 'Profile', '2020-09-15 14:47:12', 1674, '[[regtime]]', '[[regtime]]'),
(1675, 'english', 'Publish from', '2020-09-15 14:47:12', 1675, '[[regtime]]', '[[regtime]]'),
(1676, 'english', 'Publish until', '2020-09-15 14:47:12', 1676, '[[regtime]]', '[[regtime]]'),
(1677, 'english', 'Select the destination folder for the copy operation', '2020-09-15 14:47:12', 1677, '[[regtime]]', '[[regtime]]'),
(1678, 'english', 'Resource', '2020-09-15 14:47:12', 1678, '[[regtime]]', '[[regtime]]'),
(1679, 'english', 'Interactions', '2020-09-15 14:47:12', 1679, '[[regtime]]', '[[regtime]]'),
(1680, 'english', 'Elapsed time', '2020-09-15 14:47:12', 1680, '[[regtime]]', '[[regtime]]'),
(1681, 'english', 'Show menu', '2020-09-15 14:47:12', 1681, '[[regtime]]', '[[regtime]]'),
(1682, 'english', 'Node Fields', '2020-09-15 14:47:12', 1682, '[[regtime]]', '[[regtime]]'),
(1683, 'english', 'Directory', '2022-03-28 10:08:26', 1683, '[[regtime]]', '[[regtime]]'),
(1684, 'english', 'Group name', '2020-09-15 14:47:12', 1684, '[[regtime]]', '[[regtime]]'),
(1685, 'english', 'Do not import', '2020-09-15 14:47:12', 1685, '[[regtime]]', '[[regtime]]'),
(1686, 'english', 'Import schema', '2020-09-15 14:47:12', 1686, '[[regtime]]', '[[regtime]]'),
(1687, 'english', 'User inserted, wait for Admin approval', '2020-09-15 14:47:12', 1687, '[[regtime]]', '[[regtime]]'),
(1688, 'english', 'Assign node fields', '2020-09-15 14:47:12', 1688, '[[regtime]]', '[[regtime]]'),
(1689, 'english', 'Associate extra fields to user', '2020-09-15 14:47:12', 1689, '[[regtime]]', '[[regtime]]'),
(1690, 'english', 'Organization chart', '2020-09-15 14:47:12', 1690, '[[regtime]]', '[[regtime]]'),
(1691, 'english', 'Cascade', '2020-09-15 14:47:12', 1691, '[[regtime]]', '[[regtime]]'),
(1692, 'english', 'Inherited', '2020-09-15 14:47:12', 1692, '[[regtime]]', '[[regtime]]'),
(1693, 'english', 'Invisible to the user', '2020-09-15 14:47:12', 1693, '[[regtime]]', '[[regtime]]'),
(1694, 'english', 'Invisible', '2020-09-15 14:47:12', 1694, '[[regtime]]', '[[regtime]]'),
(1695, 'english', 'File charset', '2020-09-15 14:47:12', 1695, '[[regtime]]', '[[regtime]]'),
(1696, 'english', 'Choose file to import', '2020-09-15 14:47:12', 1696, '[[regtime]]', '[[regtime]]'),
(1697, 'english', 'Manage the first line as header', '2020-09-15 14:47:12', 1697, '[[regtime]]', '[[regtime]]'),
(1698, 'english', 'Choose separator (; or ,)', '2020-09-15 14:47:12', 1698, '[[regtime]]', '[[regtime]]'),
(1699, 'english', 'Import users', '2020-09-15 14:47:12', 1699, '[[regtime]]', '[[regtime]]'),
(1700, 'english', 'Descendants', '2020-09-15 14:47:12', 1700, '[[regtime]]', '[[regtime]]'),
(1701, 'english', 'List fields for the folder', '2020-09-15 14:47:12', 1701, '[[regtime]]', '[[regtime]]'),
(1702, 'english', 'Rename', '2020-09-15 14:47:12', 1702, '[[regtime]]', '[[regtime]]'),
(1703, 'english', 'Show also suspended users', '2020-09-15 14:47:12', 1703, '[[regtime]]', '[[regtime]]'),
(1704, 'english', 'This username already exists, please choose a different one.', '2020-09-15 14:47:12', 1704, '[[regtime]]', '[[regtime]]'),
(1705, 'english', 'Ass. user to group', '2020-09-15 14:47:12', 1705, '[[regtime]]', '[[regtime]]'),
(1706, 'english', 'Delete user', '2020-09-15 14:47:12', 1706, '[[regtime]]', '[[regtime]]'),
(1707, 'english', 'Personal learning objects', '2020-09-15 14:47:12', 1707, '[[regtime]]', '[[regtime]]'),
(1708, 'english', 'LO available in the course', '2020-09-15 14:47:12', 1708, '[[regtime]]', '[[regtime]]'),
(1709, 'english', 'Shared learning object with other instructors', '2020-09-15 14:47:12', 1709, '[[regtime]]', '[[regtime]]'),
(1710, 'english', 'send to all', '2020-09-15 14:47:12', 1710, '[[regtime]]', '[[regtime]]'),
(1711, 'english', 'allow to send messages only to instructors', '2020-09-15 14:47:12', 1711, '[[regtime]]', '[[regtime]]'),
(1712, 'english', 'Allow file upload', '2020-09-15 14:47:12', 1712, '[[regtime]]', '[[regtime]]'),
(1713, 'english', 'LMS', '2020-09-15 14:47:12', 1713, '[[regtime]]', '[[regtime]]'),
(1714, 'english', 'Selected by', '2020-09-15 14:47:12', 1714, '[[regtime]]', '[[regtime]]'),
(1715, 'english', 'Answer text', '2020-09-15 14:47:12', 1715, '[[regtime]]', '[[regtime]]'),
(1716, 'english', 'Stat question', '2020-09-15 14:47:12', 1716, '[[regtime]]', '[[regtime]]'),
(1717, 'english', 'insert new question', '2020-09-15 14:47:12', 1717, '[[regtime]]', '[[regtime]]'),
(1718, 'english', 'no questions in this survey, please verify.', '2020-09-15 14:47:12', 1718, '[[regtime]]', '[[regtime]]'),
(1719, 'english', 'Add question', '2020-09-15 14:47:12', 1719, '[[regtime]]', '[[regtime]]'),
(1720, 'english', 'New survey', '2020-09-15 14:47:12', 1720, '[[regtime]]', '[[regtime]]'),
(1721, 'english', 'Add answer', '2020-09-15 14:47:12', 1721, '[[regtime]]', '[[regtime]]'),
(1722, 'english', 'After the quest', '2020-09-15 14:47:12', 1722, '[[regtime]]', '[[regtime]]'),
(1723, 'english', 'You have already completed this survey', '2020-09-15 14:47:12', 1723, '[[regtime]]', '[[regtime]]'),
(1724, 'english', 'List of the available answers for this question', '2020-09-15 14:47:12', 1724, '[[regtime]]', '[[regtime]]'),
(1725, 'english', 'Begin the survey', '2020-09-15 14:47:12', 1725, '[[regtime]]', '[[regtime]]'),
(1726, 'english', 'Question list of the survey ([tot_element] elements in [tot_page] pages)', '2020-09-15 14:47:12', 1726, '[[regtime]]', '[[regtime]]'),
(1727, 'english', 'Survey completed, thanks for your contribution.', '2020-09-15 14:47:12', 1727, '[[regtime]]', '[[regtime]]'),
(1728, 'english', 'Back to the lesson', '2020-09-15 14:47:12', 1728, '[[regtime]]', '[[regtime]]'),
(1729, 'english', 'Submit survey', '2020-09-15 14:47:12', 1729, '[[regtime]]', '[[regtime]]'),
(1730, 'english', 'As the first', '2020-09-15 14:47:12', 1730, '[[regtime]]', '[[regtime]]'),
(1731, 'english', 'and put it after', '2020-09-15 14:47:12', 1731, '[[regtime]]', '[[regtime]]'),
(1732, 'english', 'As the last', '2020-09-15 14:47:12', 1732, '[[regtime]]', '[[regtime]]'),
(1733, 'english', 'Previous page', '2020-09-15 14:47:12', 1733, '[[regtime]]', '[[regtime]]'),
(1734, 'english', 'Order', '2020-09-15 14:47:12', 1734, '[[regtime]]', '[[regtime]]'),
(1735, 'english', 'Question''s title', '2020-09-15 14:47:12', 1735, '[[regtime]]', '[[regtime]]'),
(1736, 'english', 'Remove question', '2020-09-15 14:47:12', 1736, '[[regtime]]', '[[regtime]]'),
(1737, 'english', 'Survey', '2020-09-15 14:47:12', 1737, '[[regtime]]', '[[regtime]]'),
(1738, 'english', 'Remove answer', '2020-09-15 14:47:12', 1738, '[[regtime]]', '[[regtime]]'),
(1739, 'english', 'List of all the questions created in this survey', '2020-09-15 14:47:12', 1739, '[[regtime]]', '[[regtime]]'),
(1740, 'english', 'Question', '2020-09-15 14:47:12', 1740, '[[regtime]]', '[[regtime]]'),
(1741, 'english', 'BP', '2020-09-15 14:47:12', 1741, '[[regtime]]', '[[regtime]]'),
(1742, 'english', 'CH', '2020-09-15 14:47:12', 1742, '[[regtime]]', '[[regtime]]'),
(1743, 'english', 'MC', '2020-09-15 14:47:12', 1743, '[[regtime]]', '[[regtime]]'),
(1744, 'english', 'CV', '2020-09-15 14:47:12', 1744, '[[regtime]]', '[[regtime]]'),
(1745, 'english', 'DV', '2020-09-15 14:47:12', 1745, '[[regtime]]', '[[regtime]]'),
(1746, 'english', 'ET', '2020-09-15 14:47:12', 1746, '[[regtime]]', '[[regtime]]'),
(1747, 'english', 'TI', '2020-09-15 14:47:12', 1747, '[[regtime]]', '[[regtime]]'),
(1748, 'english', 'Answer text', '2020-09-15 14:47:12', 1748, '[[regtime]]', '[[regtime]]'),
(1749, 'english', 'Break page', '2020-09-15 14:47:12', 1749, '[[regtime]]', '[[regtime]]'),
(1750, 'english', 'Single choice', '2020-09-15 14:47:12', 1750, '[[regtime]]', '[[regtime]]'),
(1751, 'english', 'Multiple choice', '2020-09-15 14:47:12', 1751, '[[regtime]]', '[[regtime]]'),
(1752, 'english', 'user can choose more than one answer', '2020-09-15 14:47:12', 1752, '[[regtime]]', '[[regtime]]'),
(1753, 'english', 'Single choice - only one answer can be selected', '2020-09-15 14:47:12', 1753, '[[regtime]]', '[[regtime]]'),
(1754, 'english', 'Course evaluation', '2020-09-15 14:47:12', 1754, '[[regtime]]', '[[regtime]]'),
(1755, 'english', 'Teacher evaluation', '2020-09-15 14:47:12', 1755, '[[regtime]]', '[[regtime]]'),
(1756, 'english', 'Text answer', '2020-09-15 14:47:12', 1756, '[[regtime]]', '[[regtime]]'),
(1757, 'english', 'Title', '2020-09-15 14:47:12', 1757, '[[regtime]]', '[[regtime]]'),
(1758, 'english', 'Title - a free text', '2020-09-15 14:47:12', 1758, '[[regtime]]', '[[regtime]]'),
(1759, 'english', 'List of the answers to this question with the relative statistics', '2020-09-15 14:47:12', 1759, '[[regtime]]', '[[regtime]]'),
(1760, 'english', 'Survey', '2020-09-15 14:47:12', 1760, '[[regtime]]', '[[regtime]]'),
(1761, 'english', 'Create new assessment', '2020-09-15 14:47:12', 1761, '[[regtime]]', '[[regtime]]'),
(1762, 'english', 'Add effects', '2020-09-15 14:47:12', 1762, '[[regtime]]', '[[regtime]]'),
(1763, 'english', 'New rule', '2020-09-15 14:47:12', 1763, '[[regtime]]', '[[regtime]]'),
(1764, 'english', 'Effects', '2020-09-15 14:47:12', 1764, '[[regtime]]', '[[regtime]]'),
(1765, 'english', 'Assign teacher to the assessment', '2020-09-15 14:47:12', 1765, '[[regtime]]', '[[regtime]]'),
(1766, 'english', 'Assign teacher that can manage assessment', '2020-09-15 14:47:12', 1766, '[[regtime]]', '[[regtime]]'),
(1767, 'english', 'Assign rule to the assessment', '2020-09-15 14:47:12', 1767, '[[regtime]]', '[[regtime]]'),
(1768, 'english', 'Assign courses where the user will be subscribed after completing assessment', '2020-09-15 14:47:12', 1768, '[[regtime]]', '[[regtime]]'),
(1769, 'english', 'Assessment list', '2020-09-15 14:47:12', 1769, '[[regtime]]', '[[regtime]]'),
(1770, 'english', 'Rules list', '2020-09-15 14:47:12', 1770, '[[regtime]]', '[[regtime]]'),
(1771, 'english', 'Do nothing', '2020-09-15 14:47:12', 1771, '[[regtime]]', '[[regtime]]'),
(1772, 'english', 'Completing rules', '2020-09-15 14:47:12', 1772, '[[regtime]]', '[[regtime]]'),
(1773, 'english', 'Courses where the user will be subscribed', '2020-09-15 14:47:12', 1773, '[[regtime]]', '[[regtime]]'),
(1774, 'english', 'If no rules has been applied', '2020-09-15 14:47:12', 1774, '[[regtime]]', '[[regtime]]'),
(1775, 'english', 'If two rules are in conflict, both of them will be applied', '2020-09-15 14:47:12', 1775, '[[regtime]]', '[[regtime]]'),
(1776, 'english', 'Rule description', '2020-09-15 14:47:12', 1776, '[[regtime]]', '[[regtime]]'),
(1777, 'english', 'Rules list to apply when assessment is completed', '2020-09-15 14:47:12', 1777, '[[regtime]]', '[[regtime]]'),
(1778, 'english', 'Template', '2020-09-15 14:47:12', 1778, '[[regtime]]', '[[regtime]]'),
(1779, 'english', 'Privacy Policies', '2020-09-15 14:47:12', 1779, '[[regtime]]', '[[regtime]]'),
(1780, 'english', 'Number of log in', '2020-09-15 14:47:12', 1780, '[[regtime]]', '[[regtime]]'),
(1781, 'english', 'Time in course', '2020-09-15 14:47:12', 1781, '[[regtime]]', '[[regtime]]'),
(1782, 'english', '[firstname]''s activity', '2020-09-15 14:47:12', 1782, '[[regtime]]', '[[regtime]]'),
(1783, 'english', 'Just png, gif and jpg image formats are allowed for the upload. If size exceeds [max_px] pixel it will be automatically resized.<br />\nPlease don''t upload offensive images.', '2020-09-15 14:47:12', 1783, '[[regtime]]', '[[regtime]]'),
(1784, 'english', 'Career', '2020-09-15 14:47:12', 1784, '[[regtime]]', '[[regtime]]'),
(1785, 'english', 'Available Certificates', '2020-09-15 14:47:12', 1785, '[[regtime]]', '[[regtime]]'),
(1786, 'english', 'Change password', '2020-09-15 14:47:12', 1786, '[[regtime]]', '[[regtime]]'),
(1787, 'english', 'Fields visibility', '2020-09-15 14:47:12', 1787, '[[regtime]]', '[[regtime]]'),
(1788, 'english', 'Community', '2020-09-15 14:47:12', 1788, '[[regtime]]', '[[regtime]]'),
(1789, 'english', 'Skill name', '2020-09-15 14:47:12', 1789, '[[regtime]]', '[[regtime]]'),
(1790, 'english', 'Acquired score', '2020-09-15 14:47:12', 1790, '[[regtime]]', '[[regtime]]'),
(1791, 'english', 'Contacts', '2020-09-15 14:47:12', 1791, '[[regtime]]', '[[regtime]]'),
(1792, 'english', 'Courses subscribed', '2020-09-15 14:47:12', 1792, '[[regtime]]', '[[regtime]]'),
(1793, 'english', 'Course enrolled as mentor', '2020-09-15 14:47:12', 1793, '[[regtime]]', '[[regtime]]'),
(1794, 'english', 'Course enrolled as instructor', '2020-09-15 14:47:12', 1794, '[[regtime]]', '[[regtime]]'),
(1795, 'english', 'Course enrolled as tutor', '2020-09-15 14:47:12', 1795, '[[regtime]]', '[[regtime]]'),
(1796, 'english', 'Completed Courses', '2020-09-15 14:47:12', 1796, '[[regtime]]', '[[regtime]]'),
(1797, 'english', 'Closed Courses', '2020-09-15 14:47:12', 1797, '[[regtime]]', '[[regtime]]'),
(1798, 'english', 'Deleted users list', '2020-09-15 14:47:12', 1798, '[[regtime]]', '[[regtime]]'),
(1799, 'english', 'Delete date', '2020-09-15 14:47:12', 1799, '[[regtime]]', '[[regtime]]'),
(1800, 'english', 'Field content', '2020-09-15 14:47:12', 1800, '[[regtime]]', '[[regtime]]'),
(1801, 'english', 'Operator first name', '2020-09-15 14:47:12', 1801, '[[regtime]]', '[[regtime]]'),
(1802, 'english', 'Welcome to the e-learning platform', '2020-09-15 14:47:12', 1802, '[[regtime]]', '[[regtime]]'),
(1803, 'english', 'Forum post', '2020-09-15 14:47:12', 1803, '[[regtime]]', '[[regtime]]'),
(1804, 'english', 'Goto [firstname]''s blog', '2020-09-15 14:47:12', 1804, '[[regtime]]', '[[regtime]]'),
(1805, 'english', 'Go to user blog', '2020-09-15 14:47:12', 1805, '[[regtime]]', '[[regtime]]'),
(1806, 'english', 'Go to [firstname]''s profile', '2020-09-15 14:47:12', 1806, '[[regtime]]', '[[regtime]]'),
(1807, 'english', 'Database ID', '2020-09-15 14:47:12', 1807, '[[regtime]]', '[[regtime]]'),
(1808, 'english', 'Operator last name', '2020-09-15 14:47:12', 1808, '[[regtime]]', '[[regtime]]'),
(1809, 'english', 'Who have seen this profile', '2020-09-15 14:47:12', 1809, '[[regtime]]', '[[regtime]]'),
(1810, 'english', 'Message text', '2020-09-15 14:47:12', 1810, '[[regtime]]', '[[regtime]]'),
(1811, 'english', 'The new password is valid for', '2020-09-15 14:47:12', 1811, '[[regtime]]', '[[regtime]]'),
(1812, 'english', '(Visit in the last [days] days)', '2020-09-15 14:47:12', 1812, '[[regtime]]', '[[regtime]]'),
(1813, 'english', 'No avatar', '2020-09-15 14:47:12', 1813, '[[regtime]]', '[[regtime]]'),
(1814, 'english', 'No audio found', '2020-09-15 14:47:12', 1814, '[[regtime]]', '[[regtime]]'),
(1815, 'english', 'No images found', '2020-09-15 14:47:12', 1815, '[[regtime]]', '[[regtime]]'),
(1816, 'english', 'No files found', '2020-09-15 14:47:12', 1816, '[[regtime]]', '[[regtime]]'),
(1817, 'english', 'This profile has not received visits yet', '2020-09-15 14:47:12', 1817, '[[regtime]]', '[[regtime]]'),
(1818, 'english', 'No videos found', '2020-09-15 14:47:12', 1818, '[[regtime]]', '[[regtime]]'),
(1819, 'english', 'The inserted password is not yours', '2020-09-15 14:47:12', 1819, '[[regtime]]', '[[regtime]]'),
(1820, 'english', 'Old password', '2020-09-15 14:47:12', 1820, '[[regtime]]', '[[regtime]]'),
(1821, 'english', 'Other options', '2020-09-15 14:47:12', 1821, '[[regtime]]', '[[regtime]]'),
(1822, 'english', 'No one', '2020-09-15 14:47:12', 1822, '[[regtime]]', '[[regtime]]'),
(1823, 'english', 'Teachers', '2020-09-15 14:47:12', 1823, '[[regtime]]', '[[regtime]]'),
(1824, 'english', 'Rule assigned to the field', '2020-09-15 14:47:12', 1824, '[[regtime]]', '[[regtime]]'),
(1825, 'english', 'Accept private messages from', '2020-09-15 14:47:12', 1825, '[[regtime]]', '[[regtime]]'),
(1826, 'english', 'User Profile', '2020-09-15 14:47:12', 1826, '[[regtime]]', '[[regtime]]'),
(1827, 'english', 'Member since', '2020-09-15 14:47:12', 1827, '[[regtime]]', '[[regtime]]'),
(1828, 'english', 'The new password must differ from the used ones', '2020-09-15 14:47:12', 1828, '[[regtime]]', '[[regtime]]'),
(1829, 'english', 'Final test score', '2020-09-15 14:47:12', 1829, '[[regtime]]', '[[regtime]]'),
(1830, 'english', 'Starting test score', '2020-09-15 14:47:12', 1830, '[[regtime]]', '[[regtime]]'),
(1831, 'english', 'Shared files', '2020-09-15 14:47:12', 1831, '[[regtime]]', '[[regtime]]'),
(1832, 'english', 'Show my online status (teacher can view it anyway)', '2020-09-15 14:47:12', 1832, '[[regtime]]', '[[regtime]]'),
(1833, 'english', 'Curriculum', '2020-09-15 14:47:12', 1833, '[[regtime]]', '[[regtime]]'),
(1834, 'english', 'Teacher profile', '2020-09-15 14:47:12', 1834, '[[regtime]]', '[[regtime]]'),
(1835, 'english', 'Publications', '2020-09-15 14:47:12', 1835, '[[regtime]]', '[[regtime]]'),
(1836, 'english', 'Your password is expired', '2020-09-15 14:47:12', 1836, '[[regtime]]', '[[regtime]]'),
(1837, 'english', 'Courses not completed', '2020-09-15 14:47:12', 1837, '[[regtime]]', '[[regtime]]'),
(1838, 'english', 'No limits configured', '2020-09-15 14:47:12', 1838, '[[regtime]]', '[[regtime]]'),
(1839, 'english', 'The user is offline', '2020-09-15 14:47:12', 1839, '[[regtime]]', '[[regtime]]'),
(1840, 'english', 'Skills', '2020-09-15 14:47:12', 1840, '[[regtime]]', '[[regtime]]'),
(1841, 'english', 'User''s courses', '2020-09-15 14:47:12', 1841, '[[regtime]]', '[[regtime]]'),
(1842, 'english', 'User''s courses', '2020-09-15 14:47:12', 1842, '[[regtime]]', '[[regtime]]'),
(1843, 'english', 'User statistics', '2020-09-15 14:47:12', 1843, '[[regtime]]', '[[regtime]]'),
(1844, 'english', 'User status', '2020-09-15 14:47:12', 1844, '[[regtime]]', '[[regtime]]'),
(1845, 'english', 'Picture, avatar and signature', '2020-09-15 14:47:12', 1845, '[[regtime]]', '[[regtime]]'),
(1846, 'english', 'Operator ID', '2020-09-15 14:47:12', 1846, '[[regtime]]', '[[regtime]]'),
(1847, 'english', 'Offline', '2020-09-15 14:47:12', 1847, '[[regtime]]', '[[regtime]]'),
(1848, 'english', 'Online', '2020-09-15 14:47:12', 1848, '[[regtime]]', '[[regtime]]'),
(1849, 'english', 'User parameters', '2020-09-15 14:47:12', 1849, '[[regtime]]', '[[regtime]]'),
(1850, 'english', 'Your details stored in the system', '2020-09-15 14:47:12', 1850, '[[regtime]]', '[[regtime]]'),
(1851, 'english', 'Audio', '2020-09-15 14:47:12', 1851, '[[regtime]]', '[[regtime]]'),
(1852, 'english', 'Other files', '2020-09-15 14:47:12', 1852, '[[regtime]]', '[[regtime]]'),
(1853, 'english', 'Used disk space', '2020-09-15 14:47:12', 1853, '[[regtime]]', '[[regtime]]'),
(1854, 'english', 'Now the user is', '2020-09-15 14:47:12', 1854, '[[regtime]]', '[[regtime]]'),
(1855, 'english', 'Video', '2020-09-15 14:47:12', 1855, '[[regtime]]', '[[regtime]]'),
(1856, 'english', 'Video', '2020-09-15 14:47:12', 1856, '[[regtime]]', '[[regtime]]'),
(1857, 'english', 'Welcome!', '2020-09-15 14:47:12', 1857, '[[regtime]]', '[[regtime]]'),
(1858, 'english', 'Write a message for your request', '2020-09-15 14:47:12', 1858, '[[regtime]]', '[[regtime]]'),
(1859, 'english', 'Manage administrators', '2020-09-15 14:47:12', 1859, '[[regtime]]', '[[regtime]]'),
(1860, 'english', 'Projects you are attending', '2020-09-15 14:47:12', 1860, '[[regtime]]', '[[regtime]]'),
(1861, 'english', 'New project', '2020-09-15 14:47:12', 1861, '[[regtime]]', '[[regtime]]'),
(1862, 'english', 'This project has no active features at this time.', '2020-09-15 14:47:12', 1862, '[[regtime]]', '[[regtime]]'),
(1863, 'english', 'Project administrators', '2020-09-15 14:47:12', 1863, '[[regtime]]', '[[regtime]]'),
(1864, 'english', 'Project group', '2020-09-15 14:47:12', 1864, '[[regtime]]', '[[regtime]]'),
(1865, 'english', 'Project options', '2020-09-15 14:47:12', 1865, '[[regtime]]', '[[regtime]]'),
(1866, 'english', 'Files', '2020-09-15 14:47:12', 1866, '[[regtime]]', '[[regtime]]'),
(1867, 'english', 'You must specify a title', '2020-09-15 14:47:12', 1867, '[[regtime]]', '[[regtime]]'),
(1868, 'english', 'You selected an invalid group and/or you''re not a member of it.', '2020-09-15 14:47:12', 1868, '[[regtime]]', '[[regtime]]'),
(1869, 'english', 'Total progress', '2020-09-15 14:47:12', 1869, '[[regtime]]', '[[regtime]]'),
(1870, 'english', 'Tasks', '2020-09-15 14:47:12', 1870, '[[regtime]]', '[[regtime]]'),
(1871, 'english', 'To do', '2020-09-15 14:47:12', 1871, '[[regtime]]', '[[regtime]]'),
(1872, 'english', 'Project manager', '2020-09-15 14:47:12', 1872, '[[regtime]]', '[[regtime]]'),
(1873, 'english', 'List of all the projects that you are following', '2020-09-15 14:47:12', 1873, '[[regtime]]', '[[regtime]]'),
(1874, 'english', 'Show files area', '2020-09-15 14:47:12', 1874, '[[regtime]]', '[[regtime]]'),
(1875, 'english', 'Enable internal messages', '2020-09-15 14:47:12', 1875, '[[regtime]]', '[[regtime]]'),
(1876, 'english', 'Show news area', '2020-09-15 14:47:12', 1876, '[[regtime]]', '[[regtime]]'),
(1877, 'english', 'Show tasks area', '2020-09-15 14:47:12', 1877, '[[regtime]]', '[[regtime]]'),
(1878, 'english', 'Show To Do area', '2020-09-15 14:47:12', 1878, '[[regtime]]', '[[regtime]]'),
(1879, 'english', 'Project title', '2020-09-15 14:47:12', 1879, '[[regtime]]', '[[regtime]]'),
(1880, 'english', 'Task description', '2020-09-15 14:47:12', 1880, '[[regtime]]', '[[regtime]]'),
(1881, 'english', 'Task name', '2020-09-15 14:47:12', 1881, '[[regtime]]', '[[regtime]]'),
(1882, 'english', 'Task progress (%)', '2020-09-15 14:47:12', 1882, '[[regtime]]', '[[regtime]]'),
(1883, 'english', 'Just yourself', '2020-09-15 14:47:12', 1883, '[[regtime]]', '[[regtime]]'),
(1884, 'english', 'Activity', '2020-09-15 14:47:12', 1884, '[[regtime]]', '[[regtime]]'),
(1885, 'english', 'Special settings for:', '2020-09-15 14:47:12', 1885, '[[regtime]]', '[[regtime]]'),
(1886, 'english', 'Category in use, you can''t delete it', '2020-09-15 14:47:12', 1886, '[[regtime]]', '[[regtime]]'),
(1887, 'english', 'Question categories', '2020-09-15 14:47:12', 1887, '[[regtime]]', '[[regtime]]'),
(1888, 'english', 'I agree', '2020-09-15 14:47:12', 1888, '[[regtime]]', '[[regtime]]'),
(1889, 'english', 'Change language', '2020-09-15 14:47:12', 1889, '[[regtime]]', '[[regtime]]'),
(1890, 'english', 'Choose a new password', '2020-09-15 14:47:12', 1890, '[[regtime]]', '[[regtime]]'),
(1891, 'english', 'This email is already used by another user.', '2020-09-15 14:47:12', 1891, '[[regtime]]', '[[regtime]]'),
(1892, 'english', 'This username is not available, choose another one', '2020-09-15 14:47:12', 1892, '[[regtime]]', '[[regtime]]'),
(1893, 'english', 'You must enter a valid email address', '2020-09-15 14:47:12', 1893, '[[regtime]]', '[[regtime]]'),
(1894, 'english', 'Username is blank or invalid', '2020-09-15 14:47:12', 1894, '[[regtime]]', '[[regtime]]'),
(1895, 'english', 'Password must contain a minimum number of characters', '2020-09-15 14:47:12', 1895, '[[regtime]]', '[[regtime]]'),
(1896, 'english', 'Password must contain numbers and characters', '2020-09-15 14:47:12', 1896, '[[regtime]]', '[[regtime]]'),
(1897, 'english', 'Password must only contain characters', '2020-09-15 14:47:12', 1897, '[[regtime]]', '[[regtime]]'),
(1898, 'english', 'The password does not match with the second one typed', '2020-09-15 14:47:12', 1898, '[[regtime]]', '[[regtime]]'),
(1899, 'english', 'You must accept the privacy policy in order to register', '2020-09-15 14:47:12', 1899, '[[regtime]]', '[[regtime]]'),
(1900, 'english', 'The old password is wrong', '2020-09-15 14:47:12', 1900, '[[regtime]]', '[[regtime]]'),
(1901, 'english', 'New same old password', '2020-09-15 14:47:12', 1901, '[[regtime]]', '[[regtime]]'),
(1902, 'english', 'This is the first time you log in to the system. Please change your temporary password', '2020-09-15 14:47:12', 1902, '[[regtime]]', '[[regtime]]'),
(1903, 'english', 'Please select a new password', '2020-09-15 14:47:12', 1903, '[[regtime]]', '[[regtime]]'),
(1904, 'english', 'Back to login page', '2020-09-15 14:47:12', 1904, '[[regtime]]', '[[regtime]]'),
(1905, 'english', 'This is the field associated with the group selected', '2020-09-15 14:47:12', 1905, '[[regtime]]', '[[regtime]]'),
(1906, 'english', 'Registration', '2020-09-15 14:47:12', 1906, '[[regtime]]', '[[regtime]]'),
(1907, 'english', 'The username you''ve inserted doesn''t exist. Please check and retry', '2020-09-15 14:47:12', 1907, '[[regtime]]', '[[regtime]]'),
(1908, 'english', 'Activation code not valid', '2020-09-15 14:47:12', 1908, '[[regtime]]', '[[regtime]]'),
(1909, 'english', 'The security code is invalid', '2020-09-15 14:47:12', 1909, '[[regtime]]', '[[regtime]]'),
(1910, 'english', 'Back to login', '2020-09-15 14:47:12', 1910, '[[regtime]]', '[[regtime]]'),
(1911, 'english', 'If you have lost your password, insert your username in the field below, you will receive an email with instructions', '2020-09-15 14:47:12', 1911, '[[regtime]]', '[[regtime]]'),
(1912, 'english', 'If you have lost your username insert your registration email address in the field below, you will receive an email', '2020-09-15 14:47:12', 1912, '[[regtime]]', '[[regtime]]'),
(1913, 'english', 'This is the process to generate a new password for the user associated to this email address. Click the link below to generate a new password.<br/>\n<br/>\n<a href="[link]">[link]</a>', '2020-09-15 14:47:12', 1913, '[[regtime]]', '[[regtime]]'),
(1914, 'english', 'New password', '2020-09-15 14:47:12', 1914, '[[regtime]]', '[[regtime]]'),
(1915, 'english', 'I lost my password', '2020-09-15 14:47:12', 1915, '[[regtime]]', '[[regtime]]'),
(1916, 'english', 'I lost my username', '2020-09-15 14:47:12', 1916, '[[regtime]]', '[[regtime]]'),
(1917, 'english', 'Your username for the [url] website community is [userid]', '2020-09-15 14:47:12', 1917, '[[regtime]]', '[[regtime]]'),
(1918, 'english', 'Recover username', '2020-09-15 14:47:12', 1918, '[[regtime]]', '[[regtime]]'),
(1919, 'english', 'Please confirm your registration request', '2020-09-15 14:47:12', 1919, '[[regtime]]', '[[regtime]]'),
(1920, 'english', 'Congratulations! You just registered', '2020-09-15 14:47:12', 1920, '[[regtime]]', '[[regtime]]'),
(1921, 'english', 'Thank you! We have sent you an email with your username.', '2020-09-15 14:47:12', 1921, '[[regtime]]', '[[regtime]]'),
(1922, 'english', 'Thank you! We have sent you an email with the link to reset your password.', '2020-09-15 14:47:12', 1922, '[[regtime]]', '[[regtime]]'),
(1923, 'english', 'Your new password is valid for [valid_for_day] days.', '2020-09-15 14:47:12', 1923, '[[regtime]]', '[[regtime]]'),
(1924, 'english', 'New password', '2020-09-15 14:47:12', 1924, '[[regtime]]', '[[regtime]]'),
(1925, 'english', 'Blank space before and after username fields are not valid and will be erased', '2020-09-15 14:47:12', 1925, '[[regtime]]', '[[regtime]]'),
(1926, 'english', 'Your old password', '2020-09-15 14:47:12', 1926, '[[regtime]]', '[[regtime]]'),
(1927, 'english', 'The password has to include:', '2021-01-28 12:01:55', 1927, '[[regtime]]', '[[regtime]]'),
(1928, 'english', 'Password too short', '2020-09-15 14:47:12', 1928, '[[regtime]]', '[[regtime]]'),
(1929, 'english', 'The confirmation of your account is failed', '2020-09-15 14:47:12', 1929, '[[regtime]]', '[[regtime]]'),
(1930, 'english', 'The request is not valid because the validity period is elapsed', '2020-09-15 14:47:12', 1930, '[[regtime]]', '[[regtime]]'),
(1931, 'english', 'This request will expire after <b>[hour] hours</b>', '2020-09-15 14:47:12', 1931, '[[regtime]]', '[[regtime]]'),
(1932, 'english', 'We have received your subscription request with the following information:<br />\n<br />\nUsername : [userid]<br />\n<br />\nTo complete  the registration process, please click on the link below, (or copy it in your web browser address bar)<br />\n<br />\n<a href="[link]">[link]</a><br />\n<br />\nThis request will be valid for the next [hour] hours', '2020-09-15 14:47:12', 1932, '[[regtime]]', '[[regtime]]'),
(1933, 'english', 'We received your registration request with the following data:<br/>\n<br/>\n\nUsername: [userid]<br/>', '2020-09-15 14:47:12', 1933, '[[regtime]]', '[[regtime]]'),
(1934, 'english', 'You must fill the mandatory fields, marked with the symbol [mandatory]', '2020-09-15 14:47:12', 1934, '[[regtime]]', '[[regtime]]'),
(1935, 'english', 'From this page you can register to the platform; follow the instructions below and fill in the fields properly.', '2020-09-15 14:47:12', 1935, '[[regtime]]', '[[regtime]]'),
(1936, 'english', 'Registration is not active', '2020-09-15 14:47:12', 1936, '[[regtime]]', '[[regtime]]'),
(1937, 'english', '<b>characters</b> and <b>numbers</b>', '2021-01-28 12:02:31', 1937, '[[regtime]]', '[[regtime]]'),
(1938, 'english', 'The password must contain at least <b>[min_char] chars</b>', '2020-09-15 14:47:12', 1938, '[[regtime]]', '[[regtime]]'),
(1939, 'english', '<b>The password must contain at least [min_char]</b> numbers', '2021-01-28 12:03:17', 1939, '[[regtime]]', '[[regtime]]'),
(1940, 'english', 'The password must contain at least <b>[min_char]</b> lowercase characters', '2021-01-28 12:04:08', 1940, '[[regtime]]', '[[regtime]]'),
(1941, 'english', 'The password must contain at least <b>[min_char]</b> special characters', '2021-01-28 12:03:44', 1941, '[[regtime]]', '[[regtime]]'),
(1942, 'english', '<b>The password must contain at least [min_char]</b> uppercase letters', '2021-01-28 12:04:16', 1942, '[[regtime]]', '[[regtime]]'),
(1943, 'english', 'The password must contain <b>characters</b> and <b>numbers</b>', '2020-09-15 14:47:12', 1943, '[[regtime]]', '[[regtime]]'),
(1944, 'english', 'The new password must be different', '2020-09-15 14:47:12', 1944, '[[regtime]]', '[[regtime]]'),
(1945, 'english', 'The new password must be different from own username', '2015-09-30 15:32:40', 1945, '[[regtime]]', '[[regtime]]'),
(1946, 'english', 'Activation code', '2020-09-15 14:47:12', 1946, '[[regtime]]', '[[regtime]]'),
(1947, 'english', 'I accept the terms of the privacy policy', '2020-09-15 14:47:12', 1947, '[[regtime]]', '[[regtime]]'),
(1948, 'english', 'The new password must be different from the last one you ued', '2015-09-30 15:32:40', 1948, '[[regtime]]', '[[regtime]]'),
(1949, 'english', 'The password must contain at least <b>[min_char]</b> character', '2020-09-28 10:39:36', 1949, '[[regtime]]', '[[regtime]]'),
(1950, 'english', 'The password must contain at least  <b>[min_char]</b> number', '2020-09-28 10:31:10', 1950, '[[regtime]]', '[[regtime]]'),
(1951, 'english', 'The password must contain at least <b>[min_char]</b> lowercase character', '2020-09-28 10:30:53', 1951, '[[regtime]]', '[[regtime]]'),
(1952, 'english', 'The password must contain at least <b>[min_char]</b> special character', '2020-09-28 10:38:01', 1952, '[[regtime]]', '[[regtime]]'),
(1953, 'english', 'The password must contain at least <b>[min_char]</b> uppercase character', '2020-09-28 10:37:24', 1953, '[[regtime]]', '[[regtime]]'),
(1954, 'english', 'Any information collected by us, relating to an identifiable person, shall be used only in accordance with the procedures and for the purposes that are here acknowledged to the data subject and where the latter, as required by law, has expressely consented. <br><br>\n\n- User login and private area<br>\n- User newsletter<br>\n- User custom content purpose<br><br>\n\nIn handling this information, accuracy and precision shall be met to ensure the integrity and quality of the processed personal data, if you have any question please contact us.', '2020-09-15 14:47:12', 1954, '[[regtime]]', '[[regtime]]'),
(1955, 'english', 'Privacy policy', '2020-09-15 14:47:12', 1955, '[[regtime]]', '[[regtime]]'),
(1956, 'english', 'You must accept the privacy policy', '2020-09-15 14:47:12', 1956, '[[regtime]]', '[[regtime]]'),
(1957, 'english', 'Thank you for the request of registration to our community.\nIn order to protect your privacy you will receive an email with the confirmation link.\nYou have to confirm your account before using it.', '2020-09-15 14:47:12', 1957, '[[regtime]]', '[[regtime]]'),
(1958, 'english', 'Thanks for registering, you will receive a confirmation email with your data.', '2020-09-15 14:47:12', 1958, '[[regtime]]', '[[regtime]]'),
(1959, 'english', 'your username', '2020-09-15 14:47:12', 1959, '[[regtime]]', '[[regtime]]'),
(1960, 'english', 'Your registration has been confirmed, you will receive an email as soon as the administrator approves it', '2020-09-15 14:47:12', 1960, '[[regtime]]', '[[regtime]]'),
(1961, 'english', 'Registration confirmed', '2020-09-15 14:47:12', 1961, '[[regtime]]', '[[regtime]]'),
(1962, 'english', 'Retype the password', '2020-09-15 14:47:12', 1962, '[[regtime]]', '[[regtime]]'),
(1963, 'english', 'Select the group you want to subscribe', '2020-09-15 14:47:12', 1963, '[[regtime]]', '[[regtime]]'),
(1964, 'english', 'List of groups available for subscription', '2020-09-15 14:47:12', 1964, '[[regtime]]', '[[regtime]]'),
(1965, 'english', 'Send an email with the link to reset password', '2020-09-15 14:47:12', 1965, '[[regtime]]', '[[regtime]]'),
(1966, 'english', 'You haven''t filled in some mandatory fields', '2020-09-15 14:47:12', 1966, '[[regtime]]', '[[regtime]]'),
(1967, 'english', 'This procedure is required for security or legal reason by the website administrator and consists in changing password periodically.', '2020-09-15 14:47:12', 1967, '[[regtime]]', '[[regtime]]'),
(1968, 'english', 'Data aggregation on users and course', '2020-09-15 14:47:12', 1968, '[[regtime]]', '[[regtime]]'),
(1969, 'english', 'Courses report', '2020-09-15 14:47:12', 1969, '[[regtime]]', '[[regtime]]'),
(1970, 'english', 'Courses', '2020-09-15 14:47:12', 1970, '[[regtime]]', '[[regtime]]'),
(1971, 'english', 'Subdivide data according to the organization chart', '2020-09-15 14:47:12', 1971, '[[regtime]]', '[[regtime]]'),
(1972, 'english', 'Show results', '2020-09-15 14:47:12', 1972, '[[regtime]]', '[[regtime]]'),
(1973, 'english', 'Users', '2020-09-15 14:47:12', 1973, '[[regtime]]', '[[regtime]]'),
(1974, 'english', 'Aggregate data on', '2020-09-15 14:47:12', 1974, '[[regtime]]', '[[regtime]]'),
(1975, 'english', '<< Back to report list', '2020-09-15 14:47:12', 1975, '[[regtime]]', '[[regtime]]'),
(1976, 'english', 'Choose time range to show', '2020-09-15 14:47:12', 1976, '[[regtime]]', '[[regtime]]'),
(1977, 'english', 'Choose users that you want to analyse', '2020-09-15 14:47:12', 1977, '[[regtime]]', '[[regtime]]'),
(1978, 'english', 'Competences filters settings', '2020-09-15 14:47:12', 1978, '[[regtime]]', '[[regtime]]'),
(1979, 'english', 'You can set filters about selected users competences.', '2020-09-15 14:47:12', 1979, '[[regtime]]', '[[regtime]]'),
(1980, 'english', '(select a competence)', '2020-09-15 14:47:12', 1980, '[[regtime]]', '[[regtime]]'),
(1981, 'english', '(select a condition)', '2020-09-15 14:47:12', 1981, '[[regtime]]', '[[regtime]]'),
(1982, 'english', 'Course''s end date', '2020-09-15 14:47:12', 1982, '[[regtime]]', '[[regtime]]'),
(1983, 'english', 'Inscription date', '2020-09-15 14:47:12', 1983, '[[regtime]]', '[[regtime]]'),
(1984, 'english', 'Score in course', '2020-09-15 14:47:12', 1984, '[[regtime]]', '[[regtime]]'),
(1985, 'english', 'Initial score', '2020-09-15 14:47:12', 1985, '[[regtime]]', '[[regtime]]'),
(1986, 'english', 'Session count', '2020-09-15 14:47:12', 1986, '[[regtime]]', '[[regtime]]'),
(1987, 'english', 'Courses selection', '2020-09-15 14:47:12', 1987, '[[regtime]]', '[[regtime]]'),
(1988, 'english', 'Users that haven''t completed the course', '2020-09-15 14:47:12', 1988, '[[regtime]]', '[[regtime]]'),
(1989, 'english', 'Display courses information', '2020-09-15 14:47:12', 1989, '[[regtime]]', '[[regtime]]'),
(1990, 'english', 'Display user''s information about courses', '2020-09-15 14:47:12', 1990, '[[regtime]]', '[[regtime]]'),
(1991, 'english', 'Users who haven''t started the course', '2020-09-15 14:47:12', 1991, '[[regtime]]', '[[regtime]]'),
(1992, 'english', 'Creation date', '2020-09-15 14:47:12', 1992, '[[regtime]]', '[[regtime]]'),
(1993, 'english', 'CRON report email body', '2020-09-15 14:47:12', 1993, '[[regtime]]', '[[regtime]]'),
(1994, 'english', 'CRON report email subject', '2020-09-15 14:47:12', 1994, '[[regtime]]', '[[regtime]]'),
(1995, 'english', 'Current selection', '2020-09-15 14:47:12', 1995, '[[regtime]]', '[[regtime]]'),
(1996, 'english', 'User defined time range', '2020-09-15 14:47:12', 1996, '[[regtime]]', '[[regtime]]'),
(1997, 'english', 'Completion date', '2020-09-15 14:47:12', 1997, '[[regtime]]', '[[regtime]]'),
(1998, 'english', 'Subscription date', '2020-09-15 14:47:12', 1998, '[[regtime]]', '[[regtime]]'),
(1999, 'english', 'Course expiring on (specify date)', '2020-09-15 14:47:12', 1999, '[[regtime]]', '[[regtime]]'),
(2000, 'english', 'After (specify number) days from their subscription', '2020-09-15 14:47:12', 2000, '[[regtime]]', '[[regtime]]'),
(2001, 'english', 'Course expiring in (specify number) days', '2020-09-15 14:47:12', 2001, '[[regtime]]', '[[regtime]]'),
(2002, 'english', 'Export detailed report as CSV', '2020-09-15 14:47:12', 2002, '[[regtime]]', '[[regtime]]'),
(2003, 'english', 'Export detailed report as XLS', '2020-09-15 14:47:12', 2003, '[[regtime]]', '[[regtime]]'),
(2004, 'english', 'All conditions must be satisfied', '2020-09-15 14:47:12', 2004, '[[regtime]]', '[[regtime]]'),
(2005, 'english', 'At least one condition must be satisfied', '2020-09-15 14:47:12', 2005, '[[regtime]]', '[[regtime]]'),
(2006, 'english', 'Reset filters', '2020-09-15 14:47:12', 2006, '[[regtime]]', '[[regtime]]'),
(2007, 'english', 'Subscribed', '2020-09-15 14:47:12', 2007, '[[regtime]]', '[[regtime]]'),
(2008, 'english', 'Last 30 days', '2020-09-15 14:47:12', 2008, '[[regtime]]', '[[regtime]]'),
(2009, 'english', 'Last 6 months', '2020-09-15 14:47:12', 2009, '[[regtime]]', '[[regtime]]'),
(2010, 'english', 'Last 3 months', '2020-09-15 14:47:12', 2010, '[[regtime]]', '[[regtime]]'),
(2011, 'english', 'Last seven days', '2020-09-15 14:47:12', 2011, '[[regtime]]', '[[regtime]]'),
(2012, 'english', 'Last year', '2020-09-15 14:47:12', 2012, '[[regtime]]', '[[regtime]]'),
(2013, 'english', 'First attempt', '2020-09-15 14:47:12', 2013, '[[regtime]]', '[[regtime]]'),
(2014, 'english', 'Last attempt', '2020-09-15 14:47:12', 2014, '[[regtime]]', '[[regtime]]'),
(2015, 'english', 'Milestone', '2020-09-15 14:47:12', 2015, '[[regtime]]', '[[regtime]]'),
(2016, 'english', 'L.O. type', '2020-09-15 14:47:12', 2016, '[[regtime]]', '[[regtime]]'),
(2017, 'english', 'Email body', '2020-09-15 14:47:12', 2017, '[[regtime]]', '[[regtime]]'),
(2018, 'english', 'To begin', '2020-09-15 14:47:12', 2018, '[[regtime]]', '[[regtime]]'),
(2019, 'english', 'Not activated', '2020-09-15 14:47:12', 2019, '[[regtime]]', '[[regtime]]'),
(2020, 'english', 'No user found', '2020-09-15 14:47:12', 2020, '[[regtime]]', '[[regtime]]'),
(2021, 'english', 'No courses have been selected', '2020-09-15 14:47:12', 2021, '[[regtime]]', '[[regtime]]'),
(2022, 'english', 'No results found.', '2020-09-15 14:47:12', 2022, '[[regtime]]', '[[regtime]]'),
(2023, 'english', 'No values have been selected', '2020-09-15 14:47:12', 2023, '[[regtime]]', '[[regtime]]'),
(2024, 'english', 'Num.', '2020-09-15 14:47:12', 2024, '[[regtime]]', '[[regtime]]'),
(2025, 'english', 'Perc.', '2020-09-15 14:47:12', 2025, '[[regtime]]', '[[regtime]]'),
(2026, 'english', 'Course categories', '2020-09-15 14:47:12', 2026, '[[regtime]]', '[[regtime]]'),
(2027, 'english', 'Years', '2020-09-15 14:47:12', 2027, '[[regtime]]', '[[regtime]]'),
(2028, 'english', 'Relates courses with users votes (from poll)', '2020-09-15 14:47:12', 2028, '[[regtime]]', '[[regtime]]'),
(2029, 'english', 'Relates courses with the teachers votes (from poll)', '2020-09-15 14:47:12', 2029, '[[regtime]]', '[[regtime]]'),
(2030, 'english', 'Relates courses to users.', '2020-09-15 14:47:12', 2030, '[[regtime]]', '[[regtime]]'),
(2031, 'english', 'Users competences details', '2020-09-15 14:47:12', 2031, '[[regtime]]', '[[regtime]]'),
(2032, 'english', 'Columns filter''s setting', '2020-09-15 14:47:12', 2032, '[[regtime]]', '[[regtime]]'),
(2033, 'english', 'Conditions on selected courses', '2020-09-15 14:47:12', 2033, '[[regtime]]', '[[regtime]]'),
(2034, 'english', 'Select Courses', '2020-09-15 14:47:12', 2034, '[[regtime]]', '[[regtime]]'),
(2035, 'english', 'Everyday', '2020-09-15 14:47:12', 2035, '[[regtime]]', '[[regtime]]'),
(2036, 'english', 'Report for all the users', '2020-09-15 14:47:12', 2036, '[[regtime]]', '[[regtime]]'),
(2037, 'english', 'Edit columns filters', '2020-09-15 14:47:12', 2037, '[[regtime]]', '[[regtime]]'),
(2038, 'english', 'Edit rows filters', '2020-09-15 14:47:12', 2038, '[[regtime]]', '[[regtime]]'),
(2039, 'english', 'Every month, on the day:', '2020-09-15 14:47:12', 2039, '[[regtime]]', '[[regtime]]'),
(2040, 'english', 'Columns data', '2020-09-15 14:47:12', 2040, '[[regtime]]', '[[regtime]]'),
(2041, 'english', 'Rows filter''s settings', '2020-09-15 14:47:12', 2041, '[[regtime]]', '[[regtime]]'),
(2042, 'english', 'Time period', '2020-09-15 14:47:12', 2042, '[[regtime]]', '[[regtime]]'),
(2043, 'english', 'Define time period and options to consider for delay analysis', '2020-09-15 14:47:12', 2043, '[[regtime]]', '[[regtime]]'),
(2044, 'english', 'Every week, on the day:', '2020-09-15 14:47:12', 2044, '[[regtime]]', '[[regtime]]'),
(2045, 'english', 'This table contains the statistic about the selected users in the courses in the platform', '2020-09-15 14:47:12', 2045, '[[regtime]]', '[[regtime]]'),
(2046, 'english', 'User courses details', '2020-09-15 14:47:12', 2046, '[[regtime]]', '[[regtime]]'),
(2047, 'english', 'Relates users to communications', '2020-09-15 14:47:12', 2047, '[[regtime]]', '[[regtime]]'),
(2048, 'english', 'Relates users to competences', '2020-09-15 14:47:12', 2048, '[[regtime]]', '[[regtime]]'),
(2049, 'english', 'Relates users to courses', '2020-09-15 14:47:12', 2049, '[[regtime]]', '[[regtime]]'),
(2050, 'english', 'Make delay analysis', '2020-09-15 14:47:12', 2050, '[[regtime]]', '[[regtime]]'),
(2051, 'english', 'Relates users to corporate contests', '2020-09-15 14:47:12', 2051, '[[regtime]]', '[[regtime]]'),
(2052, 'english', 'Relates users to Learning Objects', '2020-09-15 14:47:12', 2052, '[[regtime]]', '[[regtime]]'),
(2053, 'english', 'Relates users to tests', '2020-09-15 14:47:12', 2053, '[[regtime]]', '[[regtime]]'),
(2054, 'english', 'Select milestones', '2020-09-15 14:47:12', 2054, '[[regtime]]', '[[regtime]]'),
(2055, 'english', 'Learning Objects types', '2020-09-15 14:47:12', 2055, '[[regtime]]', '[[regtime]]'),
(2056, 'english', '<< SAVE and back to report list', '2020-09-15 14:47:12', 2056, '[[regtime]]', '[[regtime]]'),
(2057, 'english', 'Save and back to list', '2020-09-15 14:47:12', 2057, '[[regtime]]', '[[regtime]]'),
(2058, 'english', 'Description:', '2020-09-15 14:47:12', 2058, '[[regtime]]', '[[regtime]]'),
(2059, 'english', 'Save and show', '2020-09-15 14:47:12', 2059, '[[regtime]]', '[[regtime]]'),
(2060, 'english', 'Every week,', '2020-09-15 14:47:12', 2060, '[[regtime]]', '[[regtime]]'),
(2061, 'english', 'Learning Objects options', '2020-09-15 14:47:12', 2061, '[[regtime]]', '[[regtime]]'),
(2062, 'english', 'Select report category:', '2020-09-15 14:47:12', 2062, '[[regtime]]', '[[regtime]]'),
(2063, 'english', 'Check the columns you want to view in the report table', '2020-09-15 14:47:12', 2063, '[[regtime]]', '[[regtime]]'),
(2064, 'english', 'Courses manual selection', '2020-09-15 14:47:12', 2064, '[[regtime]]', '[[regtime]]'),
(2065, 'english', 'Send email', '2020-09-15 14:47:12', 2065, '[[regtime]]', '[[regtime]]'),
(2066, 'english', 'Shown columns', '2020-09-15 14:47:12', 2066, '[[regtime]]', '[[regtime]]'),
(2067, 'english', 'Show but do not save', '2020-09-15 14:47:12', 2067, '[[regtime]]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES
(2068, 'english', 'Show statistics about courses', '2020-09-15 14:47:12', 2068, '[[regtime]]', '[[regtime]]'),
(2069, 'english', 'Created by', '2020-09-15 14:47:12', 2069, '[[regtime]]', '[[regtime]]'),
(2070, 'english', 'Public', '2020-09-15 14:47:12', 2070, '[[regtime]]', '[[regtime]]'),
(2071, 'english', 'Label', '2020-09-15 14:47:12', 2071, '[[regtime]]', '[[regtime]]'),
(2072, 'english', 'Path', '2020-09-15 14:47:12', 2072, '[[regtime]]', '[[regtime]]'),
(2073, 'english', 'Estimated time', '2020-09-15 14:47:12', 2073, '[[regtime]]', '[[regtime]]'),
(2074, 'english', 'Course score', '2020-09-15 14:47:12', 2074, '[[regtime]]', '[[regtime]]'),
(2075, 'english', 'Subscribed date', '2020-09-15 14:47:12', 2075, '[[regtime]]', '[[regtime]]'),
(2076, 'english', 'Number of sessions', '2020-09-15 14:47:12', 2076, '[[regtime]]', '[[regtime]]'),
(2077, 'english', 'Start score', '2020-09-15 14:47:12', 2077, '[[regtime]]', '[[regtime]]'),
(2078, 'english', 'Date range', '2020-09-15 14:47:12', 2078, '[[regtime]]', '[[regtime]]'),
(2079, 'english', 'Range', '2020-09-15 14:47:12', 2079, '[[regtime]]', '[[regtime]]'),
(2080, 'english', 'Filter for time periods', '2020-09-15 14:47:12', 2080, '[[regtime]]', '[[regtime]]'),
(2081, 'english', 'Time', '2020-09-15 14:47:12', 2081, '[[regtime]]', '[[regtime]]'),
(2082, 'english', 'Show users fields', '2020-09-15 14:47:12', 2082, '[[regtime]]', '[[regtime]]'),
(2083, 'english', 'Beware, users will see the report as well as the user who generated it', '2020-09-15 14:47:12', 2083, '[[regtime]]', '[[regtime]]'),
(2084, 'english', 'Add users', '2020-09-15 14:47:12', 2084, '[[regtime]]', '[[regtime]]'),
(2085, 'english', 'assign', '2020-09-15 14:47:12', 2085, '[[regtime]]', '[[regtime]]'),
(2086, 'english', 'Are you sure you want to subscribe?', '2020-09-15 14:47:12', 2086, '[[regtime]]', '[[regtime]]'),
(2087, 'english', 'Are you sure you want to cancel this subscription?', '2020-09-15 14:47:12', 2087, '[[regtime]]', '[[regtime]]'),
(2088, 'english', 'Available', '2020-09-15 14:47:12', 2088, '[[regtime]]', '[[regtime]]'),
(2089, 'english', 'Event subscription canceled', '2020-09-15 14:47:12', 2089, '[[regtime]]', '[[regtime]]'),
(2090, 'english', 'Cancel registration', '2020-09-15 14:47:12', 2090, '[[regtime]]', '[[regtime]]'),
(2091, 'english', 'Categories', '2020-09-15 14:47:12', 2091, '[[regtime]]', '[[regtime]]'),
(2092, 'english', 'Manage category', '2020-09-15 14:47:12', 2092, '[[regtime]]', '[[regtime]]'),
(2093, 'english', 'Max event for category', '2020-09-15 14:47:12', 2093, '[[regtime]]', '[[regtime]]'),
(2094, 'english', 'Subscribe users', '2020-09-15 14:47:12', 2094, '[[regtime]]', '[[regtime]]'),
(2095, 'english', 'Please confirm your data', '2020-09-15 14:47:12', 2095, '[[regtime]]', '[[regtime]]'),
(2096, 'english', 'Deadline', '2020-09-15 14:47:12', 2096, '[[regtime]]', '[[regtime]]'),
(2097, 'english', 'Register this event instead of', '2020-09-15 14:47:12', 2097, '[[regtime]]', '[[regtime]]'),
(2098, 'english', 'Cancel reservation', '2020-09-15 14:47:12', 2098, '[[regtime]]', '[[regtime]]'),
(2099, 'english', 'Event list', '2020-09-15 14:47:12', 2099, '[[regtime]]', '[[regtime]]'),
(2100, 'english', 'From time', '2020-09-15 14:47:12', 2100, '[[regtime]]', '[[regtime]]'),
(2101, 'english', 'Laboratory management', '2020-09-15 14:47:12', 2101, '[[regtime]]', '[[regtime]]'),
(2102, 'english', 'Max number of subscriptions for this category', '2020-09-15 14:47:12', 2102, '[[regtime]]', '[[regtime]]'),
(2103, 'english', 'Max user', '2020-09-15 14:47:12', 2103, '[[regtime]]', '[[regtime]]'),
(2104, 'english', 'No reservations found', '2020-09-15 14:47:12', 2104, '[[regtime]]', '[[regtime]]'),
(2105, 'english', 'No user subscribed', '2020-09-15 14:47:12', 2105, '[[regtime]]', '[[regtime]]'),
(2106, 'english', 'Num. of users subscribed', '2020-09-15 14:47:12', 2106, '[[regtime]]', '[[regtime]]'),
(2107, 'english', 'Registration', '2020-09-15 14:47:12', 2107, '[[regtime]]', '[[regtime]]'),
(2108, 'english', 'Reservation', '2020-09-15 14:47:12', 2108, '[[regtime]]', '[[regtime]]'),
(2109, 'english', 'Category management', '2020-09-15 14:47:12', 2109, '[[regtime]]', '[[regtime]]'),
(2110, 'english', 'Available events', '2020-09-15 14:47:12', 2110, '[[regtime]]', '[[regtime]]'),
(2111, 'english', 'Email Send', '2020-09-15 14:47:12', 2111, '[[regtime]]', '[[regtime]]'),
(2112, 'english', 'My registration', '2020-09-15 14:47:12', 2112, '[[regtime]]', '[[regtime]]'),
(2113, 'english', 'Past events', '2020-09-15 14:47:12', 2113, '[[regtime]]', '[[regtime]]'),
(2114, 'english', 'Reservation', '2020-09-15 14:47:12', 2114, '[[regtime]]', '[[regtime]]'),
(2115, 'english', 'Manage events', '2020-09-15 14:47:12', 2115, '[[regtime]]', '[[regtime]]'),
(2116, 'english', 'List of current reservations', '2020-09-15 14:47:12', 2116, '[[regtime]]', '[[regtime]]'),
(2117, 'english', 'FULL', '2020-09-15 14:47:12', 2117, '[[regtime]]', '[[regtime]]'),
(2118, 'english', 'Modify event', '2020-09-15 14:47:12', 2118, '[[regtime]]', '[[regtime]]'),
(2119, 'english', 'Who can reserve this event', '2020-09-15 14:47:12', 2119, '[[regtime]]', '[[regtime]]'),
(2120, 'english', 'Unsubscribe from event', '2020-09-15 14:47:12', 2120, '[[regtime]]', '[[regtime]]'),
(2121, 'english', 'Subscribe users', '2020-09-15 14:47:12', 2121, '[[regtime]]', '[[regtime]]'),
(2122, 'english', 'Switch (choose this event instead of another)', '2020-09-15 14:47:12', 2122, '[[regtime]]', '[[regtime]]'),
(2123, 'english', 'End time', '2020-09-15 14:47:12', 2123, '[[regtime]]', '[[regtime]]'),
(2124, 'english', 'Undefined', '2020-09-15 14:47:12', 2124, '[[regtime]]', '[[regtime]]'),
(2125, 'english', 'Unlimited', '2020-09-15 14:47:12', 2125, '[[regtime]]', '[[regtime]]'),
(2126, 'english', 'Users subscribed', '2020-09-15 14:47:12', 2126, '[[regtime]]', '[[regtime]]'),
(2127, 'english', 'View subscribed user', '2020-09-15 14:47:12', 2127, '[[regtime]]', '[[regtime]]'),
(2128, 'english', 'Wrong date', '2020-09-15 14:47:12', 2128, '[[regtime]]', '[[regtime]]'),
(2129, 'english', 'Wrong time range', '2020-09-15 14:47:12', 2129, '[[regtime]]', '[[regtime]]'),
(2130, 'english', 'Back to list', '2020-09-15 14:47:12', 2130, '[[regtime]]', '[[regtime]]'),
(2131, 'english', 'Select a content package with .zip or .pif extension', '2020-09-15 14:47:12', 2131, '[[regtime]]', '[[regtime]]'),
(2132, 'english', 'You have to specify the file to upload', '2020-09-15 14:47:12', 2132, '[[regtime]]', '[[regtime]]'),
(2133, 'english', 'SCORM 1.2 and 2004 importer', '2020-09-15 14:47:12', 2133, '[[regtime]]', '[[regtime]]'),
(2134, 'english', 'Create complete objects list', '2020-09-15 14:47:12', 2134, '[[regtime]]', '[[regtime]]'),
(2135, 'english', 'Upload SCORM package', '2020-09-15 14:47:12', 2135, '[[regtime]]', '[[regtime]]'),
(2136, 'english', 'SCORM', '2020-09-15 14:47:12', 2136, '[[regtime]]', '[[regtime]]'),
(2137, 'english', 'Load SCORM package', '2020-09-15 14:47:12', 2137, '[[regtime]]', '[[regtime]]'),
(2138, 'english', 'Advanced selection', '2020-09-15 14:47:12', 2138, '[[regtime]]', '[[regtime]]'),
(2139, 'english', 'WARNING: Watch additional details', '2020-09-15 14:47:12', 2139, '[[regtime]]', '[[regtime]]'),
(2140, 'english', 'to edit them.', '2020-09-15 14:47:12', 2140, '[[regtime]]', '[[regtime]]'),
(2141, 'english', 'Simplified selection', '2020-09-15 14:47:12', 2141, '[[regtime]]', '[[regtime]]'),
(2142, 'english', 'Simplified selection', '2020-09-15 14:47:12', 2142, '[[regtime]]', '[[regtime]]'),
(2143, 'english', 'E-learning: course ''[course]'', new announcement: [title]', '2020-09-15 14:47:12', 2143, '[[regtime]]', '[[regtime]]'),
(2144, 'english', 'Your subscription request at course [course] has been approved by the administrator', '2020-09-15 14:47:12', 2144, '[[regtime]]', '[[regtime]]'),
(2145, 'english', 'Your subscription request has been approved', '2020-09-15 14:47:12', 2145, '[[regtime]]', '[[regtime]]'),
(2146, 'english', 'E-learning: Your account with the username [userid] has been deleted', '2020-09-15 14:47:12', 2146, '[[regtime]]', '[[regtime]]'),
(2147, 'english', '[url] [firstname] [lastname] [username]', '2020-09-15 14:47:12', 2147, '[[regtime]]', '[[regtime]]'),
(2148, 'english', '[url] [firstname] [lastname] [course] [username]', '2020-09-15 14:47:12', 2148, '[[regtime]]', '[[regtime]]'),
(2149, 'english', '[url] [firstname] [lastname] [username]', '2020-09-15 14:47:12', 2149, '[[regtime]]', '[[regtime]]'),
(2150, 'english', 'Your account at the site <a href="[url]">[url]</a>   has been modified:\n\nUsername: [userid]', '2020-09-15 14:47:12', 2150, '[[regtime]]', '[[regtime]]'),
(2151, 'english', 'E-learning: course ''[course]'' new forum ''[title]''', '2020-09-15 14:47:12', 2151, '[[regtime]]', '[[regtime]]'),
(2152, 'english', 'New forum', '2020-09-15 14:47:12', 2152, '[[regtime]]', '[[regtime]]'),
(2153, 'english', 'E-learning: in the course ''[course]'', there is a new message in ''[forum_title]'' > ''[thread_title]''', '2020-09-15 14:47:12', 2153, '[[regtime]]', '[[regtime]]'),
(2154, 'english', 'E-learning: course ''[course]'' there''s a new thread in ''[forum_title]'': [thread_title]', '2020-09-15 14:47:12', 2154, '[[regtime]]', '[[regtime]]'),
(2155, 'english', 'You have been enrolled in the course : [course] at URL: [url]', '2022-03-10 11:47:16', 2155, '[[regtime]]', '[[regtime]]'),
(2156, 'english', '[url] [firstname] [lastname] [course] [username]', '2020-09-15 14:47:12', 2156, '[[regtime]]', '[[regtime]]'),
(2157, 'english', 'and your password has been changed', '2020-09-15 14:47:12', 2157, '[[regtime]]', '[[regtime]]'),
(2158, 'english', 'You are now registered in our system with this account:\n\nUsername: [userid]', '2020-09-15 14:47:12', 2158, '[[regtime]]', '[[regtime]]'),
(2159, 'english', 'There is a new user subscription to a moderated group waiting for approval', '2020-09-15 14:47:12', 2159, '[[regtime]]', '[[regtime]]'),
(2160, 'english', 'New user is registered and awaiting your approval', '2020-09-15 14:47:12', 2160, '[[regtime]]', '[[regtime]]'),
(2161, 'english', 'New user registered', '2020-09-15 14:47:12', 2161, '[[regtime]]', '[[regtime]]'),
(2162, 'english', 'There is a new user waiting for the approval', '2020-09-15 14:47:12', 2162, '[[regtime]]', '[[regtime]]'),
(2163, 'english', 'You have received a new message in the e-learning system in the course [course] from the user [from]', '2020-09-15 14:47:12', 2163, '[[regtime]]', '[[regtime]]'),
(2164, 'english', 'You received a new message on the  e-learning platform in course [course] from the user [from]', '2020-09-15 14:47:12', 2164, '[[regtime]]', '[[regtime]]'),
(2165, 'english', 'Dear [firstname] [lastname],\nyou have been unsubscribed from the classroom course ([classroom_code]) - [classroom_date]', '2015-09-30 15:32:39', 2165, '[[regtime]]', '[[regtime]]'),
(2166, 'english', 'Dear [firstname] [lastname],\nyou have been unsubscribed from the edition ([edition_code]) - [edition]', '2015-09-30 15:32:39', 2166, '[[regtime]]', '[[regtime]]'),
(2167, 'english', 'Dear [firstname] [lastname],\nyou have been unsubscribed from the course ([course_code]) - [course]', '2015-09-30 15:32:39', 2167, '[[regtime]]', '[[regtime]]'),
(2168, 'english', 'Accounts connected:', '2020-09-15 14:47:12', 2168, '[[regtime]]', '[[regtime]]'),
(2169, 'english', 'Link your forma.lms account with:', '2020-09-15 14:47:12', 2169, '[[regtime]]', '[[regtime]]'),
(2170, 'english', 'Started', '2020-09-15 14:47:12', 2170, '[[regtime]]', '[[regtime]]'),
(2171, 'english', 'Started', '2020-09-15 14:47:12', 2171, '[[regtime]]', '[[regtime]]'),
(2172, 'english', 'Completed', '2020-09-15 14:47:12', 2172, '[[regtime]]', '[[regtime]]'),
(2173, 'english', 'Failed', '2020-09-15 14:47:12', 2173, '[[regtime]]', '[[regtime]]'),
(2174, 'english', 'Not completed', '2020-09-15 14:47:12', 2174, '[[regtime]]', '[[regtime]]'),
(2175, 'english', 'Not attempted', '2020-09-15 14:47:12', 2175, '[[regtime]]', '[[regtime]]'),
(2176, 'english', 'Not attempted', '2020-09-15 14:47:12', 2176, '[[regtime]]', '[[regtime]]'),
(2177, 'english', 'Passed', '2020-09-15 14:47:12', 2177, '[[regtime]]', '[[regtime]]'),
(2178, 'english', 'Previous', '2020-09-15 14:47:12', 2178, '[[regtime]]', '[[regtime]]'),
(2179, 'english', 'Accesses', '2020-09-15 14:47:12', 2179, '[[regtime]]', '[[regtime]]'),
(2180, 'english', 'Access detail', '2020-09-15 14:47:12', 2180, '[[regtime]]', '[[regtime]]'),
(2181, 'english', 'Access in detail', '2020-09-15 14:47:12', 2181, '[[regtime]]', '[[regtime]]'),
(2182, 'english', 'Total access time', '2020-09-15 14:47:12', 2182, '[[regtime]]', '[[regtime]]'),
(2183, 'english', 'Activate', '2020-09-15 14:47:12', 2183, '[[regtime]]', '[[regtime]]'),
(2184, 'english', 'Active', '2020-09-15 14:47:12', 2184, '[[regtime]]', '[[regtime]]'),
(2185, 'english', '(Current area)', '2020-09-15 14:47:12', 2185, '[[regtime]]', '[[regtime]]'),
(2186, 'english', 'Activity', '2020-09-15 14:47:12', 2186, '[[regtime]]', '[[regtime]]'),
(2187, 'english', 'Add', '2020-09-15 14:47:12', 2187, '[[regtime]]', '[[regtime]]'),
(2188, 'english', 'Add tags', '2020-09-15 14:47:12', 2188, '[[regtime]]', '[[regtime]]'),
(2189, 'english', 'Administrator', '2020-09-15 14:47:12', 2189, '[[regtime]]', '[[regtime]]'),
(2190, 'english', 'Administrators', '2020-09-15 14:47:12', 2190, '[[regtime]]', '[[regtime]]'),
(2191, 'english', 'Advanced', '2020-09-15 14:47:12', 2191, '[[regtime]]', '[[regtime]]'),
(2192, 'english', 'Advanced search', '2020-09-15 14:47:12', 2192, '[[regtime]]', '[[regtime]]'),
(2193, 'english', 'All', '2020-09-15 14:47:12', 2193, '[[regtime]]', '[[regtime]]'),
(2194, 'english', 'Allow full editing of user profile', '2020-09-15 14:47:12', 2194, '[[regtime]]', '[[regtime]]'),
(2195, 'english', 'All categories', '2020-09-15 14:47:12', 2195, '[[regtime]]', '[[regtime]]'),
(2196, 'english', 'All courses', '2020-09-15 14:47:12', 2196, '[[regtime]]', '[[regtime]]'),
(2197, 'english', 'All pages', '2020-09-15 14:47:12', 2197, '[[regtime]]', '[[regtime]]'),
(2198, 'english', 'Check', '2020-09-15 14:47:12', 2198, '[[regtime]]', '[[regtime]]'),
(2199, 'english', '-', '2020-09-15 14:47:12', 2199, '[[regtime]]', '[[regtime]]'),
(2200, 'english', 'Alternative text', '2020-09-15 14:47:12', 2200, '[[regtime]]', '[[regtime]]'),
(2201, 'english', 'Root', '2020-09-15 14:47:12', 2201, '[[regtime]]', '[[regtime]]'),
(2202, 'english', 'Answer', '2020-09-15 14:47:12', 2202, '[[regtime]]', '[[regtime]]'),
(2203, 'english', 'Approve', '2020-09-15 14:47:12', 2203, '[[regtime]]', '[[regtime]]'),
(2204, 'english', 'Waiting for users approval', '2020-09-15 14:47:12', 2204, '[[regtime]]', '[[regtime]]'),
(2205, 'english', 'Are you sure?', '2020-09-15 14:47:12', 2205, '[[regtime]]', '[[regtime]]'),
(2206, 'english', 'Assessments', '2020-09-15 14:47:12', 2206, '[[regtime]]', '[[regtime]]'),
(2207, 'english', 'Assign', '2020-09-15 14:47:12', 2207, '[[regtime]]', '[[regtime]]'),
(2208, 'english', 'Assign administrators', '2020-09-15 14:47:12', 2208, '[[regtime]]', '[[regtime]]'),
(2209, 'english', 'Assign users', '2020-09-15 14:47:12', 2209, '[[regtime]]', '[[regtime]]'),
(2210, 'english', 'Attachment', '2020-09-15 14:47:12', 2210, '[[regtime]]', '[[regtime]]'),
(2211, 'english', 'Attendance', '2020-09-15 14:47:12', 2211, '[[regtime]]', '[[regtime]]'),
(2212, 'english', 'Author', '2020-09-15 14:47:12', 2212, '[[regtime]]', '[[regtime]]'),
(2213, 'english', 'Autocreate categories', '2020-09-15 14:47:12', 2213, '[[regtime]]', '[[regtime]]'),
(2214, 'english', 'Auto-detect', '2020-09-15 14:47:12', 2214, '[[regtime]]', '[[regtime]]'),
(2215, 'english', 'Automatic subscription', '2020-09-15 14:47:12', 2215, '[[regtime]]', '[[regtime]]'),
(2216, 'english', 'Avatar', '2020-09-15 14:47:12', 2216, '[[regtime]]', '[[regtime]]'),
(2217, 'english', 'Average', '2020-09-15 14:47:12', 2217, '[[regtime]]', '[[regtime]]'),
(2218, 'english', '&lt;&lt; Back', '2020-09-15 14:47:12', 2218, '[[regtime]]', '[[regtime]]'),
(2219, 'english', 'Back to label', '2020-09-15 14:47:12', 2219, '[[regtime]]', '[[regtime]]'),
(2220, 'english', 'Basic search', '2020-09-15 14:47:12', 2220, '[[regtime]]', '[[regtime]]'),
(2221, 'english', 'BigBlueButton', '2020-09-15 14:47:12', 2221, '[[regtime]]', '[[regtime]]'),
(2222, 'english', 'by', '2020-09-15 14:47:12', 2222, '[[regtime]]', '[[regtime]]'),
(2223, 'english', 'Calendar', '2020-09-15 14:47:12', 2223, '[[regtime]]', '[[regtime]]'),
(2224, 'english', 'Cancel', '2020-09-15 14:47:12', 2224, '[[regtime]]', '[[regtime]]'),
(2225, 'english', 'Career', '2020-09-15 14:47:12', 2225, '[[regtime]]', '[[regtime]]'),
(2226, 'english', 'Course catalog', '2020-09-15 14:47:12', 2226, '[[regtime]]', '[[regtime]]'),
(2227, 'english', 'Course catalog', '2020-09-15 14:47:12', 2227, '[[regtime]]', '[[regtime]]'),
(2228, 'english', 'Calendar', '2020-09-15 14:47:12', 2228, '[[regtime]]', '[[regtime]]'),
(2229, 'english', 'Categorization', '2020-09-15 14:47:12', 2229, '[[regtime]]', '[[regtime]]'),
(2230, 'english', 'Categorize', '2020-09-15 14:47:12', 2230, '[[regtime]]', '[[regtime]]'),
(2231, 'english', 'Category', '2020-09-15 14:47:12', 2231, '[[regtime]]', '[[regtime]]'),
(2232, 'english', 'Chapters', '2020-09-15 14:47:12', 2232, '[[regtime]]', '[[regtime]]'),
(2233, 'english', 'Chat', '2020-09-15 14:47:12', 2233, '[[regtime]]', '[[regtime]]'),
(2234, 'english', 'Classroom', '2020-09-15 14:47:12', 2234, '[[regtime]]', '[[regtime]]'),
(2235, 'english', 'Close', '2020-09-15 14:47:12', 2235, '[[regtime]]', '[[regtime]]'),
(2236, 'english', 'Code', '2020-09-15 14:47:12', 2236, '[[regtime]]', '[[regtime]]'),
(2237, 'english', 'Collapse', '2020-09-15 14:47:12', 2237, '[[regtime]]', '[[regtime]]'),
(2238, 'english', 'Comments', '2020-09-15 14:47:12', 2238, '[[regtime]]', '[[regtime]]'),
(2239, 'english', 'Communications', '2020-09-15 14:47:12', 2239, '[[regtime]]', '[[regtime]]'),
(2240, 'english', 'Community blog', '2020-09-15 14:47:12', 2240, '[[regtime]]', '[[regtime]]'),
(2241, 'english', 'Company blog', '2020-09-15 14:47:12', 2241, '[[regtime]]', '[[regtime]]'),
(2242, 'english', 'Competence', '2020-09-15 14:47:12', 2242, '[[regtime]]', '[[regtime]]'),
(2243, 'english', 'Competences', '2020-09-15 14:47:12', 2243, '[[regtime]]', '[[regtime]]'),
(2244, 'english', 'Completed', '2020-09-15 14:47:12', 2244, '[[regtime]]', '[[regtime]]'),
(2245, 'english', 'Submit', '2020-09-15 14:47:12', 2245, '[[regtime]]', '[[regtime]]'),
(2246, 'english', 'Connect', '2020-09-15 14:47:12', 2246, '[[regtime]]', '[[regtime]]'),
(2247, 'english', 'Connection error', '2020-09-15 14:47:12', 2247, '[[regtime]]', '[[regtime]]'),
(2248, 'english', 'Contains', '2020-09-15 14:47:12', 2248, '[[regtime]]', '[[regtime]]'),
(2249, 'english', 'Contents', '2020-09-15 14:47:12', 2249, '[[regtime]]', '[[regtime]]'),
(2250, 'english', 'Content File Manager', '2020-09-15 14:47:12', 2250, '[[regtime]]', '[[regtime]]'),
(2251, 'english', 'Content library', '2020-09-15 14:47:12', 2251, '[[regtime]]', '[[regtime]]'),
(2252, 'english', 'Contests', '2020-09-15 14:47:12', 2252, '[[regtime]]', '[[regtime]]'),
(2253, 'english', 'Continue', '2020-09-15 14:47:12', 2253, '[[regtime]]', '[[regtime]]'),
(2254, 'english', 'Core version', '2020-09-15 14:47:12', 2254, '[[regtime]]', '[[regtime]]'),
(2255, 'english', 'Course', '2020-09-15 14:47:12', 2255, '[[regtime]]', '[[regtime]]'),
(2256, 'english', 'Course categories', '2020-09-15 14:47:12', 2256, '[[regtime]]', '[[regtime]]'),
(2257, 'english', 'Curricula', '2020-09-15 14:47:12', 2257, '[[regtime]]', '[[regtime]]'),
(2258, 'english', 'Courses', '2020-09-15 14:47:12', 2258, '[[regtime]]', '[[regtime]]'),
(2259, 'english', 'Course code', '2020-09-15 14:47:12', 2259, '[[regtime]]', '[[regtime]]'),
(2260, 'english', 'Courses list', '2020-09-15 14:47:12', 2260, '[[regtime]]', '[[regtime]]'),
(2261, 'english', 'Course name', '2020-09-15 14:47:12', 2261, '[[regtime]]', '[[regtime]]'),
(2262, 'english', 'The course is closed', '2020-09-15 14:47:12', 2262, '[[regtime]]', '[[regtime]]'),
(2263, 'english', 'Free', '2020-09-15 14:47:12', 2263, '[[regtime]]', '[[regtime]]'),
(2264, 'english', 'Time limit exceeded', '2020-09-15 14:47:12', 2264, '[[regtime]]', '[[regtime]]'),
(2265, 'english', 'Create', '2020-09-15 14:47:12', 2265, '[[regtime]]', '[[regtime]]'),
(2266, 'english', 'Create new', '2022-03-28 10:13:12', 2266, '[[regtime]]', '[[regtime]]'),
(2267, 'english', 'Creation date', '2020-09-15 14:47:12', 2267, '[[regtime]]', '[[regtime]]'),
(2268, 'english', 'Credits', '2020-09-15 14:47:12', 2268, '[[regtime]]', '[[regtime]]'),
(2269, 'english', 'Current file', '2020-09-15 14:47:12', 2269, '[[regtime]]', '[[regtime]]'),
(2270, 'english', 'Date', '2020-09-15 14:47:12', 2270, '[[regtime]]', '[[regtime]]'),
(2271, 'english', 'Date begin', '2020-09-15 14:47:12', 2271, '[[regtime]]', '[[regtime]]'),
(2272, 'english', 'Date end', '2020-09-15 14:47:12', 2272, '[[regtime]]', '[[regtime]]'),
(2273, 'english', 'First access date', '2020-09-15 14:47:12', 2273, '[[regtime]]', '[[regtime]]'),
(2274, 'english', 'Date format', '2020-09-15 14:47:12', 2274, '[[regtime]]', '[[regtime]]'),
(2275, 'english', 'Last access date', '2020-09-15 14:47:12', 2275, '[[regtime]]', '[[regtime]]'),
(2276, 'english', 'Date last test', '2020-09-15 14:47:12', 2276, '[[regtime]]', '[[regtime]]'),
(2277, 'english', 'Day', '2020-09-15 14:47:12', 2277, '[[regtime]]', '[[regtime]]'),
(2278, 'english', 'Day(s)', '2020-09-15 14:47:12', 2278, '[[regtime]]', '[[regtime]]'),
(2279, 'english', 'Deactivate', '2020-09-15 14:47:12', 2279, '[[regtime]]', '[[regtime]]'),
(2280, 'english', 'Default language', '2020-09-15 14:47:12', 2280, '[[regtime]]', '[[regtime]]'),
(2281, 'english', 'Delete', '2020-09-15 14:47:12', 2281, '[[regtime]]', '[[regtime]]'),
(2282, 'english', 'Delete file', '2020-09-15 14:47:12', 2282, '[[regtime]]', '[[regtime]]'),
(2283, 'english', 'Delete selected', '2020-09-15 14:47:12', 2283, '[[regtime]]', '[[regtime]]'),
(2284, 'english', 'Recover', '2020-09-15 14:47:12', 2284, '[[regtime]]', '[[regtime]]'),
(2285, 'english', 'Reject', '2020-09-15 14:47:12', 2285, '[[regtime]]', '[[regtime]]'),
(2286, 'english', 'Description', '2020-09-15 14:47:12', 2286, '[[regtime]]', '[[regtime]]'),
(2287, 'english', 'Details', '2020-09-15 14:47:12', 2287, '[[regtime]]', '[[regtime]]'),
(2288, 'english', 'Difficulty', '2020-09-15 14:47:12', 2288, '[[regtime]]', '[[regtime]]'),
(2289, 'english', 'Hard', '2020-09-15 14:47:12', 2289, '[[regtime]]', '[[regtime]]'),
(2290, 'english', 'Easy', '2020-09-15 14:47:12', 2290, '[[regtime]]', '[[regtime]]'),
(2291, 'english', 'Medium', '2020-09-15 14:47:12', 2291, '[[regtime]]', '[[regtime]]'),
(2292, 'english', 'Very hard', '2020-09-15 14:47:12', 2292, '[[regtime]]', '[[regtime]]'),
(2293, 'english', 'Very easy', '2020-09-15 14:47:12', 2293, '[[regtime]]', '[[regtime]]'),
(2294, 'english', 'DimDim', '2020-09-15 14:47:12', 2294, '[[regtime]]', '[[regtime]]'),
(2295, 'english', 'Disallow editing of user profile', '2020-09-15 14:47:12', 2295, '[[regtime]]', '[[regtime]]'),
(2296, 'english', 'Disconnect', '2020-09-15 14:47:12', 2296, '[[regtime]]', '[[regtime]]'),
(2297, 'english', 'Down', '2020-09-15 14:47:12', 2297, '[[regtime]]', '[[regtime]]'),
(2298, 'english', 'Download', '2020-09-15 14:47:12', 2298, '[[regtime]]', '[[regtime]]'),
(2299, 'english', 'Edition', '2020-09-15 14:47:12', 2299, '[[regtime]]', '[[regtime]]'),
(2300, 'english', 'Editions', '2020-09-15 14:47:12', 2300, '[[regtime]]', '[[regtime]]'),
(2301, 'english', 'Edit score', '2020-09-15 14:47:12', 2301, '[[regtime]]', '[[regtime]]'),
(2302, 'english', 'Edit setting', '2020-09-15 14:47:12', 2302, '[[regtime]]', '[[regtime]]'),
(2303, 'english', 'E-learning', '2020-09-15 14:47:12', 2303, '[[regtime]]', '[[regtime]]'),
(2304, 'english', 'Email', '2020-09-15 14:47:12', 2304, '[[regtime]]', '[[regtime]]'),
(2305, 'english', 'Empty selection', '2020-09-15 14:47:12', 2305, '[[regtime]]', '[[regtime]]'),
(2306, 'english', 'End', '2020-09-15 14:47:12', 2306, '[[regtime]]', '[[regtime]]'),
(2307, 'english', 'Last element', '2020-09-15 14:47:12', 2307, '[[regtime]]', '[[regtime]]'),
(2308, 'english', 'End with', '2020-09-15 14:47:12', 2308, '[[regtime]]', '[[regtime]]'),
(2309, 'english', 'Enrollment rules', '2020-09-15 14:47:12', 2309, '[[regtime]]', '[[regtime]]'),
(2310, 'english', 'Enrolled', '2020-09-15 14:47:12', 2310, '[[regtime]]', '[[regtime]]'),
(2311, 'english', 'Enter', '2020-09-15 14:47:12', 2311, '[[regtime]]', '[[regtime]]'),
(2312, 'english', 'Environment', '2020-09-15 14:47:12', 2312, '[[regtime]]', '[[regtime]]'),
(2313, 'english', 'Equal to', '2020-09-15 14:47:12', 2313, '[[regtime]]', '[[regtime]]'),
(2314, 'english', 'Errors', '2020-09-15 14:47:12', 2314, '[[regtime]]', '[[regtime]]'),
(2315, 'english', 'You can''t move a folder into a descendant', '2020-09-15 14:47:12', 2315, '[[regtime]]', '[[regtime]]'),
(2316, 'english', 'You are required to fill in the name', '2020-09-15 14:47:12', 2316, '[[regtime]]', '[[regtime]]'),
(2317, 'english', 'Error while uploading the object, object not uploaded', '2020-09-15 14:47:12', 2317, '[[regtime]]', '[[regtime]]'),
(2318, 'english', 'Event', '2020-09-15 14:47:12', 2318, '[[regtime]]', '[[regtime]]'),
(2319, 'english', 'Last execution date', '2020-09-15 14:47:12', 2319, '[[regtime]]', '[[regtime]]'),
(2320, 'english', 'Expand', '2020-09-15 14:47:12', 2320, '[[regtime]]', '[[regtime]]'),
(2321, 'english', 'Expire on', '2020-09-15 14:47:12', 2321, '[[regtime]]', '[[regtime]]'),
(2322, 'english', 'Export', '2020-09-15 14:47:12', 2322, '[[regtime]]', '[[regtime]]'),
(2323, 'english', 'Export as CSV', '2020-09-15 14:47:12', 2323, '[[regtime]]', '[[regtime]]'),
(2324, 'english', 'Export as HTML', '2020-09-15 14:47:12', 2324, '[[regtime]]', '[[regtime]]'),
(2325, 'english', 'Export as XLS', '2020-09-15 14:47:12', 2325, '[[regtime]]', '[[regtime]]'),
(2326, 'english', 'Export as XML', '2020-09-15 14:47:12', 2326, '[[regtime]]', '[[regtime]]'),
(2327, 'english', 'Facebook', '2020-09-15 14:47:12', 2327, '[[regtime]]', '[[regtime]]'),
(2328, 'english', 'Field name', '2020-09-15 14:47:12', 2328, '[[regtime]]', '[[regtime]]'),
(2329, 'english', 'File', '2020-09-15 14:47:12', 2329, '[[regtime]]', '[[regtime]]'),
(2330, 'english', 'File type', '2022-03-10 11:47:16', 2330, '[[regtime]]', '[[regtime]]'),
(2331, 'english', 'File name', '2020-09-15 14:47:12', 2331, '[[regtime]]', '[[regtime]]'),
(2332, 'english', 'File size', '2022-03-28 10:08:36', 2332, '[[regtime]]', '[[regtime]]'),
(2333, 'english', 'File manager', '2020-09-15 14:47:12', 2333, '[[regtime]]', '[[regtime]]'),
(2334, 'english', 'Are you sure you want to delete this file?', '2022-03-28 10:08:50', 2334, '[[regtime]]', '[[regtime]]'),
(2335, 'english', 'Filter by', '2020-09-15 14:47:12', 2335, '[[regtime]]', '[[regtime]]'),
(2336, 'english', 'All conditions must be satisfied', '2020-09-15 14:47:12', 2336, '[[regtime]]', '[[regtime]]'),
(2337, 'english', 'Apply filter', '2020-09-15 14:47:12', 2337, '[[regtime]]', '[[regtime]]'),
(2338, 'english', 'At least one condition must be satisfied', '2020-09-15 14:47:12', 2338, '[[regtime]]', '[[regtime]]'),
(2339, 'english', 'Filter reset', '2020-09-15 14:47:12', 2339, '[[regtime]]', '[[regtime]]'),
(2340, 'english', 'Filter tab close', '2020-09-15 14:47:12', 2340, '[[regtime]]', '[[regtime]]'),
(2341, 'english', 'Filter tab open', '2020-09-15 14:47:12', 2341, '[[regtime]]', '[[regtime]]'),
(2342, 'english', 'Final score', '2020-09-15 14:47:12', 2342, '[[regtime]]', '[[regtime]]'),
(2343, 'english', 'First name', '2020-09-15 14:47:12', 2343, '[[regtime]]', '[[regtime]]'),
(2344, 'english', 'Fix sequence error', '2020-09-15 14:47:12', 2344, '[[regtime]]', '[[regtime]]'),
(2345, 'english', 'Forum', '2020-09-15 14:47:12', 2345, '[[regtime]]', '[[regtime]]'),
(2346, 'english', 'from', '2020-09-15 14:47:12', 2346, '[[regtime]]', '[[regtime]]'),
(2347, 'english', 'Fullname', '2020-09-15 14:47:12', 2347, '[[regtime]]', '[[regtime]]'),
(2348, 'english', 'Company roles', '2020-09-15 14:47:12', 2348, '[[regtime]]', '[[regtime]]'),
(2349, 'english', 'Gap', '2020-09-15 14:47:12', 2349, '[[regtime]]', '[[regtime]]'),
(2350, 'english', 'Google', '2020-09-15 14:47:12', 2350, '[[regtime]]', '[[regtime]]'),
(2351, 'english', 'Go to homepage', '2020-09-15 14:47:12', 2351, '[[regtime]]', '[[regtime]]'),
(2352, 'english', 'Satisfaction', '2020-09-15 14:47:12', 2352, '[[regtime]]', '[[regtime]]'),
(2353, 'english', 'Groups', '2020-09-15 14:47:12', 2353, '[[regtime]]', '[[regtime]]'),
(2354, 'english', 'Height', '2020-09-15 14:47:12', 2354, '[[regtime]]', '[[regtime]]'),
(2355, 'english', 'Help', '2020-09-15 14:47:12', 2355, '[[regtime]]', '[[regtime]]'),
(2356, 'english', 'Hidden', '2020-09-15 14:47:12', 2356, '[[regtime]]', '[[regtime]]'),
(2357, 'english', 'History', '2020-09-15 14:47:12', 2357, '[[regtime]]', '[[regtime]]'),
(2358, 'english', 'Home tab', '2020-09-15 14:47:12', 2358, '[[regtime]]', '[[regtime]]'),
(2359, 'english', 'Homescreen', '2020-09-15 14:47:12', 2359, '[[regtime]]', '[[regtime]]'),
(2360, 'english', 'Hours', '2020-09-15 14:47:12', 2360, '[[regtime]]', '[[regtime]]'),
(2361, 'english', 'Image', '2020-09-15 14:47:12', 2361, '[[regtime]]', '[[regtime]]'),
(2362, 'english', 'Images', '2020-09-15 14:47:12', 2362, '[[regtime]]', '[[regtime]]'),
(2363, 'english', 'Import', '2020-09-15 14:47:12', 2363, '[[regtime]]', '[[regtime]]'),
(2364, 'english', 'Important', '2020-09-15 14:47:12', 2364, '[[regtime]]', '[[regtime]]'),
(2365, 'english', 'Import XML', '2020-09-15 14:47:12', 2365, '[[regtime]]', '[[regtime]]'),
(2366, 'english', 'Descendants', '2020-09-15 14:47:12', 2366, '[[regtime]]', '[[regtime]]'),
(2367, 'english', 'Insert', '2020-09-15 14:47:12', 2367, '[[regtime]]', '[[regtime]]'),
(2368, 'english', 'Instructions', '2020-09-15 14:47:12', 2368, '[[regtime]]', '[[regtime]]'),
(2369, 'english', 'Invalid extension', '2020-09-15 14:47:12', 2369, '[[regtime]]', '[[regtime]]'),
(2370, 'english', 'Jump to', '2020-09-15 14:47:12', 2370, '[[regtime]]', '[[regtime]]'),
(2371, 'english', 'Jump to module content', '2020-09-15 14:47:12', 2371, '[[regtime]]', '[[regtime]]'),
(2372, 'english', 'Label', '2020-09-15 14:47:12', 2372, '[[regtime]]', '[[regtime]]'),
(2373, 'english', 'Labels', '2020-09-15 14:47:12', 2373, '[[regtime]]', '[[regtime]]'),
(2374, 'english', 'Language', '2020-09-15 14:47:12', 2374, '[[regtime]]', '[[regtime]]'),
(2375, 'english', 'Last name', '2020-09-15 14:47:12', 2375, '[[regtime]]', '[[regtime]]'),
(2376, 'english', 'Insert your code', '2020-09-15 14:47:12', 2376, '[[regtime]]', '[[regtime]]'),
(2377, 'english', 'Subscribe', '2020-09-15 14:47:12', 2377, '[[regtime]]', '[[regtime]]'),
(2378, 'english', 'Learning Objects info', '2020-09-15 14:47:12', 2378, '[[regtime]]', '[[regtime]]'),
(2379, 'english', 'Level', '2020-09-15 14:47:12', 2379, '[[regtime]]', '[[regtime]]'),
(2380, 'english', 'Library', '2020-09-15 14:47:12', 2380, '[[regtime]]', '[[regtime]]'),
(2381, 'english', 'Link', '2020-09-15 14:47:12', 2381, '[[regtime]]', '[[regtime]]'),
(2382, 'english', 'Linkedin', '2020-09-15 14:47:12', 2382, '[[regtime]]', '[[regtime]]'),
(2383, 'english', 'Uploaded files', '2020-09-15 14:47:12', 2383, '[[regtime]]', '[[regtime]]'),
(2384, 'english', 'Loading', '2020-09-15 14:47:12', 2384, '[[regtime]]', '[[regtime]]'),
(2385, 'english', 'Locations', '2020-09-15 14:47:12', 2385, '[[regtime]]', '[[regtime]]'),
(2386, 'english', 'Logout', '2020-09-15 14:47:12', 2386, '[[regtime]]', '[[regtime]]'),
(2387, 'english', 'Assignment of users to a functional role', '2020-09-15 14:47:12', 2387, '[[regtime]]', '[[regtime]]'),
(2388, 'english', 'Assignment of users to a group', '2020-09-15 14:47:12', 2388, '[[regtime]]', '[[regtime]]'),
(2389, 'english', 'Make a copy', '2020-09-15 14:47:12', 2389, '[[regtime]]', '[[regtime]]'),
(2390, 'english', 'Manage', '2020-09-15 14:47:12', 2390, '[[regtime]]', '[[regtime]]'),
(2391, 'english', 'Groups management', '2020-09-15 14:47:12', 2391, '[[regtime]]', '[[regtime]]'),
(2392, 'english', 'Mandatory', '2020-09-15 14:47:12', 2392, '[[regtime]]', '[[regtime]]'),
(2393, 'english', 'Manual', '2020-09-15 14:47:12', 2393, '[[regtime]]', '[[regtime]]'),
(2394, 'english', 'Manage menu', '2020-09-15 14:47:12', 2394, '[[regtime]]', '[[regtime]]'),
(2395, 'english', 'Mark as important', '2020-09-15 14:47:12', 2395, '[[regtime]]', '[[regtime]]'),
(2396, 'english', 'Max score', '2020-09-15 14:47:12', 2396, '[[regtime]]', '[[regtime]]'),
(2397, 'english', 'Media URL', '2022-03-10 11:47:16', 2397, '[[regtime]]', '[[regtime]]'),
(2398, 'english', 'Meet', '2020-09-15 14:47:12', 2398, '[[regtime]]', '[[regtime]]'),
(2399, 'english', 'Messages', '2020-09-15 14:47:12', 2399, '[[regtime]]', '[[regtime]]'),
(2400, 'english', 'Mime type', '2020-09-15 14:47:12', 2400, '[[regtime]]', '[[regtime]]'),
(2401, 'english', 'Minutes', '2020-09-15 14:47:12', 2401, '[[regtime]]', '[[regtime]]'),
(2402, 'english', 'Min score', '2020-09-15 14:47:12', 2402, '[[regtime]]', '[[regtime]]'),
(2403, 'english', 'Edit', '2020-09-15 14:47:12', 2403, '[[regtime]]', '[[regtime]]'),
(2404, 'english', 'Moderate', '2020-09-15 14:47:12', 2404, '[[regtime]]', '[[regtime]]'),
(2405, 'english', 'Allow only password edit', '2020-09-15 14:47:12', 2405, '[[regtime]]', '[[regtime]]'),
(2406, 'english', 'Edit selected', '2020-09-15 14:47:12', 2406, '[[regtime]]', '[[regtime]]'),
(2407, 'english', 'Edit title', '2020-09-15 14:47:12', 2407, '[[regtime]]', '[[regtime]]'),
(2408, 'english', 'January', '2020-09-15 14:47:12', 2408, '[[regtime]]', '[[regtime]]'),
(2409, 'english', 'February', '2020-09-15 14:47:12', 2409, '[[regtime]]', '[[regtime]]'),
(2410, 'english', 'March', '2020-09-15 14:47:12', 2410, '[[regtime]]', '[[regtime]]'),
(2411, 'english', 'April', '2020-09-15 14:47:12', 2411, '[[regtime]]', '[[regtime]]'),
(2412, 'english', 'May', '2020-09-15 14:47:12', 2412, '[[regtime]]', '[[regtime]]'),
(2413, 'english', 'June', '2020-09-15 14:47:12', 2413, '[[regtime]]', '[[regtime]]'),
(2414, 'english', 'July', '2020-09-15 14:47:12', 2414, '[[regtime]]', '[[regtime]]'),
(2415, 'english', 'August', '2020-09-15 14:47:12', 2415, '[[regtime]]', '[[regtime]]'),
(2416, 'english', 'September', '2020-09-15 14:47:12', 2416, '[[regtime]]', '[[regtime]]'),
(2417, 'english', 'October', '2020-09-15 14:47:12', 2417, '[[regtime]]', '[[regtime]]'),
(2418, 'english', 'November', '2020-09-15 14:47:12', 2418, '[[regtime]]', '[[regtime]]'),
(2419, 'english', 'December', '2020-09-15 14:47:12', 2419, '[[regtime]]', '[[regtime]]'),
(2420, 'english', 'More actions', '2020-09-15 14:47:12', 2420, '[[regtime]]', '[[regtime]]'),
(2421, 'english', 'Add further attachments', '2020-09-15 14:47:12', 2421, '[[regtime]]', '[[regtime]]'),
(2422, 'english', 'More info', '2020-09-15 14:47:12', 2422, '[[regtime]]', '[[regtime]]'),
(2423, 'english', 'Move', '2020-09-15 14:47:12', 2423, '[[regtime]]', '[[regtime]]'),
(2424, 'english', 'Move down', '2020-09-15 14:47:12', 2424, '[[regtime]]', '[[regtime]]'),
(2425, 'english', 'Move up', '2020-09-15 14:47:12', 2425, '[[regtime]]', '[[regtime]]'),
(2426, 'english', 'Template "[template_name]" not used because not compatible, I''m using standard templates\n<br/><hr/>\n<br/>NOTE: <b> update the "manifest.xml" file in the templates folder by updating the form_version to "[template_min_version]"</b>', '2020-09-15 14:47:12', 2426, '[[regtime]]', '[[regtime]]'),
(2427, 'english', 'Name', '2020-09-15 14:47:12', 2427, '[[regtime]]', '[[regtime]]'),
(2428, 'english', 'Never', '2020-09-15 14:47:12', 2428, '[[regtime]]', '[[regtime]]'),
(2429, 'english', 'New', '2020-09-15 14:47:12', 2429, '[[regtime]]', '[[regtime]]'),
(2430, 'english', 'News', '2020-09-15 14:47:12', 2430, '[[regtime]]', '[[regtime]]'),
(2431, 'english', 'Newsletter', '2020-09-15 14:47:12', 2431, '[[regtime]]', '[[regtime]]'),
(2432, 'english', 'New category', '2020-09-15 14:47:12', 2432, '[[regtime]]', '[[regtime]]'),
(2433, 'english', 'New course', '2020-09-15 14:47:12', 2433, '[[regtime]]', '[[regtime]]'),
(2434, 'english', 'New event', '2020-09-15 14:47:12', 2434, '[[regtime]]', '[[regtime]]'),
(2435, 'english', 'New filter', '2020-09-15 14:47:12', 2435, '[[regtime]]', '[[regtime]]'),
(2436, 'english', 'New folder', '2020-09-15 14:47:12', 2436, '[[regtime]]', '[[regtime]]'),
(2437, 'english', 'New user', '2020-09-15 14:47:12', 2437, '[[regtime]]', '[[regtime]]'),
(2438, 'english', 'Next', '2020-09-15 14:47:12', 2438, '[[regtime]]', '[[regtime]]'),
(2439, 'english', 'Next >>', '2020-09-15 14:47:12', 2439, '[[regtime]]', '[[regtime]]'),
(2440, 'english', 'Next courses', '2020-09-15 14:47:12', 2440, '[[regtime]]', '[[regtime]]'),
(2441, 'english', 'No', '2020-09-15 14:47:12', 2441, '[[regtime]]', '[[regtime]]'),
(2442, 'english', 'None', '2020-09-15 14:47:12', 2442, '[[regtime]]', '[[regtime]]'),
(2443, 'english', 'Notes', '2020-09-15 14:47:12', 2443, '[[regtime]]', '[[regtime]]'),
(2444, 'english', 'No title', '2020-09-15 14:47:12', 2444, '[[regtime]]', '[[regtime]]'),
(2445, 'english', 'Not assigned', '2020-09-15 14:47:12', 2445, '[[regtime]]', '[[regtime]]'),
(2446, 'english', 'Does not contain', '2020-09-15 14:47:12', 2446, '[[regtime]]', '[[regtime]]'),
(2447, 'english', 'Is not equal to', '2020-09-15 14:47:12', 2447, '[[regtime]]', '[[regtime]]'),
(2448, 'english', 'Not satisfied', '2020-09-15 14:47:12', 2448, '[[regtime]]', '[[regtime]]'),
(2449, 'english', 'Not started', '2020-09-15 14:47:12', 2449, '[[regtime]]', '[[regtime]]'),
(2450, 'english', 'Untranslated languages, click here to expand', '2020-09-15 14:47:12', 2450, '[[regtime]]', '[[regtime]]'),
(2451, 'english', 'No answers', '2020-09-15 14:47:12', 2451, '[[regtime]]', '[[regtime]]'),
(2452, 'english', 'No, please get back', '2020-09-15 14:47:12', 2452, '[[regtime]]', '[[regtime]]'),
(2453, 'english', 'No categories', '2020-09-15 14:47:12', 2453, '[[regtime]]', '[[regtime]]'),
(2454, 'english', 'No content available', '2020-09-15 14:47:12', 2454, '[[regtime]]', '[[regtime]]'),
(2455, 'english', 'of', '2020-09-15 14:47:12', 2455, '[[regtime]]', '[[regtime]]'),
(2456, 'english', 'Off', '2020-09-15 14:47:12', 2456, '[[regtime]]', '[[regtime]]'),
(2457, 'english', 'On', '2020-09-15 14:47:12', 2457, '[[regtime]]', '[[regtime]]'),
(2458, 'english', 'One month', '2020-09-15 14:47:12', 2458, '[[regtime]]', '[[regtime]]'),
(2459, 'english', 'Only one time', '2020-09-15 14:47:12', 2459, '[[regtime]]', '[[regtime]]'),
(2460, 'english', 'Open', '2020-09-15 14:47:12', 2460, '[[regtime]]', '[[regtime]]'),
(2461, 'english', 'Error while processing the requested operation', '2020-09-15 14:47:12', 2461, '[[regtime]]', '[[regtime]]'),
(2462, 'english', 'Operation successfully completed', '2020-09-15 14:47:12', 2462, '[[regtime]]', '[[regtime]]'),
(2463, 'english', 'Successful password change', '2020-09-15 14:47:12', 2463, '[[regtime]]', '[[regtime]]'),
(2464, 'english', 'Order by', '2020-09-15 14:47:12', 2464, '[[regtime]]', '[[regtime]]'),
(2465, 'english', 'Order asc', '2020-09-15 14:47:12', 2465, '[[regtime]]', '[[regtime]]'),
(2466, 'english', 'Ascending order', '2020-09-15 14:47:12', 2466, '[[regtime]]', '[[regtime]]'),
(2467, 'english', 'Order desc', '2020-09-15 14:47:12', 2467, '[[regtime]]', '[[regtime]]'),
(2468, 'english', 'Desc', '2020-09-15 14:47:12', 2468, '[[regtime]]', '[[regtime]]'),
(2469, 'english', 'Descending order', '2020-09-15 14:47:12', 2469, '[[regtime]]', '[[regtime]]'),
(2470, 'english', 'Organization chart', '2020-09-15 14:47:12', 2470, '[[regtime]]', '[[regtime]]'),
(2471, 'english', 'Add node', '2020-09-15 14:47:12', 2471, '[[regtime]]', '[[regtime]]'),
(2472, 'english', 'Pages', '2020-09-15 14:47:12', 2472, '[[regtime]]', '[[regtime]]'),
(2473, 'english', 'Participant data', '2020-09-15 14:47:12', 2473, '[[regtime]]', '[[regtime]]'),
(2474, 'english', 'Password', '2020-09-15 14:47:12', 2474, '[[regtime]]', '[[regtime]]'),
(2475, 'english', 'Percentage', '2020-09-15 14:47:12', 2475, '[[regtime]]', '[[regtime]]'),
(2476, 'english', 'Planned', '2020-09-15 14:47:12', 2476, '[[regtime]]', '[[regtime]]'),
(2477, 'english', 'Play', '2020-09-15 14:47:12', 2477, '[[regtime]]', '[[regtime]]'),
(2478, 'english', 'Number of views', '2020-09-15 14:47:12', 2478, '[[regtime]]', '[[regtime]]'),
(2479, 'english', 'Complete the missing fields', '2020-09-15 14:47:12', 2479, '[[regtime]]', '[[regtime]]'),
(2480, 'english', 'Prerequisites', '2020-09-15 14:47:12', 2480, '[[regtime]]', '[[regtime]]'),
(2481, 'english', 'Presence', '2020-09-15 14:47:12', 2481, '[[regtime]]', '[[regtime]]'),
(2482, 'english', 'Previous', '2020-09-15 14:47:12', 2482, '[[regtime]]', '[[regtime]]'),
(2483, 'english', 'Previous element', '2020-09-15 14:47:12', 2483, '[[regtime]]', '[[regtime]]'),
(2484, 'english', 'Preview', '2020-09-15 14:47:12', 2484, '[[regtime]]', '[[regtime]]'),
(2485, 'english', 'Previous', '2020-09-15 14:47:12', 2485, '[[regtime]]', '[[regtime]]'),
(2486, 'english', 'Previous', '2020-09-15 14:47:12', 2486, '[[regtime]]', '[[regtime]]'),
(2487, 'english', 'Profile', '2020-09-15 14:47:12', 2487, '[[regtime]]', '[[regtime]]'),
(2488, 'english', 'Profile Edit', '2020-09-15 14:47:12', 2488, '[[regtime]]', '[[regtime]]'),
(2489, 'english', 'Profile edit page:', '2020-09-15 14:47:12', 2489, '[[regtime]]', '[[regtime]]'),
(2490, 'english', 'Progress', '2020-09-15 14:47:12', 2490, '[[regtime]]', '[[regtime]]'),
(2491, 'english', 'Failed objects', '2020-10-30 15:37:53', 2491, '[[regtime]]', '[[regtime]]'),
(2492, 'english', 'Properties', '2020-09-15 14:47:12', 2492, '[[regtime]]', '[[regtime]]'),
(2493, 'english', 'Public Administrator', '2020-09-15 14:47:12', 2493, '[[regtime]]', '[[regtime]]'),
(2494, 'english', 'Publish', '2020-09-15 14:47:12', 2494, '[[regtime]]', '[[regtime]]'),
(2495, 'english', 'Question', '2020-09-15 14:47:12', 2495, '[[regtime]]', '[[regtime]]'),
(2496, 'english', 'Elements:', '2020-09-15 14:47:12', 2496, '[[regtime]]', '[[regtime]]'),
(2497, 'english', 'Reactivate', '2020-09-15 14:47:12', 2497, '[[regtime]]', '[[regtime]]'),
(2498, 'english', 'Read', '2020-09-15 14:47:12', 2498, '[[regtime]]', '[[regtime]]'),
(2499, 'english', 'Recipients', '2020-09-15 14:47:12', 2499, '[[regtime]]', '[[regtime]]'),
(2500, 'english', 'Redirect to external url', '2020-09-15 14:47:12', 2500, '[[regtime]]', '[[regtime]]'),
(2501, 'english', 'Register', '2020-09-15 14:47:12', 2501, '[[regtime]]', '[[regtime]]'),
(2502, 'english', 'Join date', '2020-09-15 14:47:12', 2502, '[[regtime]]', '[[regtime]]'),
(2503, 'english', 'Remember me', '2020-09-15 14:47:12', 2503, '[[regtime]]', '[[regtime]]'),
(2504, 'english', 'Remove from node', '2020-09-15 14:47:12', 2504, '[[regtime]]', '[[regtime]]'),
(2505, 'english', 'Reply', '2020-09-15 14:47:12', 2505, '[[regtime]]', '[[regtime]]'),
(2506, 'english', 'Paste Learning Object', '2020-09-15 14:47:12', 2506, '[[regtime]]', '[[regtime]]'),
(2507, 'english', 'Reports', '2020-09-15 14:47:12', 2507, '[[regtime]]', '[[regtime]]'),
(2508, 'english', 'Required score', '2020-09-15 14:47:12', 2508, '[[regtime]]', '[[regtime]]'),
(2509, 'english', 'Reset', '2020-09-15 14:47:12', 2509, '[[regtime]]', '[[regtime]]'),
(2510, 'english', 'Reset Policy', '2020-09-15 14:47:12', 2510, '[[regtime]]', '[[regtime]]'),
(2511, 'english', 'Rollback', '2020-09-15 14:47:12', 2511, '[[regtime]]', '[[regtime]]'),
(2512, 'english', 'root', '2020-09-15 14:47:12', 2512, '[[regtime]]', '[[regtime]]'),
(2513, 'english', 'Row', '2020-09-15 14:47:12', 2513, '[[regtime]]', '[[regtime]]'),
(2514, 'english', 'Save changes', '2020-09-15 14:47:12', 2514, '[[regtime]]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES
(2515, 'english', 'Schedule', '2020-09-15 14:47:12', 2515, '[[regtime]]', '[[regtime]]'),
(2516, 'english', 'Score', '2020-09-15 14:47:12', 2516, '[[regtime]]', '[[regtime]]'),
(2517, 'english', 'Score of the last test', '2020-09-15 14:47:12', 2517, '[[regtime]]', '[[regtime]]'),
(2518, 'english', 'Script description', '2020-09-15 14:47:12', 2518, '[[regtime]]', '[[regtime]]'),
(2519, 'english', 'Script ID', '2020-09-15 14:47:12', 2519, '[[regtime]]', '[[regtime]]'),
(2520, 'english', 'Script name', '2020-09-15 14:47:12', 2520, '[[regtime]]', '[[regtime]]'),
(2521, 'english', 'Script version', '2020-09-15 14:47:12', 2521, '[[regtime]]', '[[regtime]]'),
(2522, 'english', 'Search', '2020-09-15 14:47:12', 2522, '[[regtime]]', '[[regtime]]'),
(2523, 'english', 'seconds', '2020-09-15 14:47:12', 2523, '[[regtime]]', '[[regtime]]'),
(2524, 'english', 'Select', '2020-09-15 14:47:12', 2524, '[[regtime]]', '[[regtime]]'),
(2525, 'english', 'Selected elements', '2020-09-15 14:47:12', 2525, '[[regtime]]', '[[regtime]]'),
(2526, 'english', 'Select all', '2020-09-15 14:47:12', 2526, '[[regtime]]', '[[regtime]]'),
(2527, 'english', 'Select a library to view', '2020-09-15 14:47:12', 2527, '[[regtime]]', '[[regtime]]'),
(2528, 'english', 'Select the bandwidth', '2020-09-15 14:47:12', 2528, '[[regtime]]', '[[regtime]]'),
(2529, 'english', 'Send', '2020-09-15 14:47:12', 2529, '[[regtime]]', '[[regtime]]'),
(2530, 'english', 'Sender', '2020-09-15 14:47:12', 2530, '[[regtime]]', '[[regtime]]'),
(2531, 'english', 'Metti in cc', '2020-09-15 14:47:12', 2531, '[[regtime]]', '[[regtime]]'),
(2532, 'english', 'Send to', '2020-09-15 14:47:12', 2532, '[[regtime]]', '[[regtime]]'),
(2533, 'english', 'Set', '2020-09-15 14:47:12', 2533, '[[regtime]]', '[[regtime]]'),
(2534, 'english', 'Set as Default', '2020-09-15 14:47:12', 2534, '[[regtime]]', '[[regtime]]'),
(2535, 'english', 'Short description', '2020-09-15 14:47:12', 2535, '[[regtime]]', '[[regtime]]'),
(2536, 'english', 'Show', '2020-09-15 14:47:12', 2536, '[[regtime]]', '[[regtime]]'),
(2537, 'english', 'Results', '2020-09-15 14:47:12', 2537, '[[regtime]]', '[[regtime]]'),
(2538, 'english', 'View graphics', '2020-09-15 14:47:12', 2538, '[[regtime]]', '[[regtime]]'),
(2539, 'english', 'Signature', '2020-09-15 14:47:12', 2539, '[[regtime]]', '[[regtime]]'),
(2540, 'english', 'Order by', '2020-09-15 14:47:12', 2540, '[[regtime]]', '[[regtime]]'),
(2541, 'english', 'Standings', '2020-09-15 14:47:12', 2541, '[[regtime]]', '[[regtime]]'),
(2542, 'english', 'Start', '2020-09-15 14:47:12', 2542, '[[regtime]]', '[[regtime]]'),
(2543, 'english', 'Started', '2020-09-15 14:47:12', 2543, '[[regtime]]', '[[regtime]]'),
(2544, 'english', 'Start with', '2020-09-15 14:47:12', 2544, '[[regtime]]', '[[regtime]]'),
(2545, 'english', 'Start date', '2020-09-15 14:47:12', 2545, '[[regtime]]', '[[regtime]]'),
(2546, 'english', 'Start page', '2020-09-15 14:47:12', 2546, '[[regtime]]', '[[regtime]]'),
(2547, 'english', 'Start', '2020-09-15 14:47:12', 2547, '[[regtime]]', '[[regtime]]'),
(2548, 'english', 'Statistics', '2020-09-15 14:47:12', 2548, '[[regtime]]', '[[regtime]]'),
(2549, 'english', 'Status', '2020-09-15 14:47:12', 2549, '[[regtime]]', '[[regtime]]'),
(2550, 'english', 'Subject', '2020-09-15 14:47:12', 2550, '[[regtime]]', '[[regtime]]'),
(2551, 'english', 'Subject name', '2020-09-15 14:47:12', 2551, '[[regtime]]', '[[regtime]]'),
(2552, 'english', 'Subscribe', '2020-09-15 14:47:12', 2552, '[[regtime]]', '[[regtime]]'),
(2553, 'english', 'Subscribed by', '2020-09-15 14:47:12', 2553, '[[regtime]]', '[[regtime]]'),
(2554, 'english', 'Course subscription', '2020-09-15 14:47:12', 2554, '[[regtime]]', '[[regtime]]'),
(2555, 'english', 'Suspend', '2020-09-15 14:47:12', 2555, '[[regtime]]', '[[regtime]]'),
(2556, 'english', 'Suspended', '2020-09-15 14:47:12', 2556, '[[regtime]]', '[[regtime]]'),
(2557, 'english', 'Tabs', '2020-09-15 14:47:12', 2557, '[[regtime]]', '[[regtime]]'),
(2558, 'english', 'Tags', '2020-09-15 14:47:12', 2558, '[[regtime]]', '[[regtime]]'),
(2559, 'english', 'Teleskill', '2020-09-15 14:47:12', 2559, '[[regtime]]', '[[regtime]]'),
(2560, 'english', 'Text', '2020-09-15 14:47:12', 2560, '[[regtime]]', '[[regtime]]'),
(2561, 'english', 'Time periods', '2020-09-15 14:47:12', 2561, '[[regtime]]', '[[regtime]]'),
(2562, 'english', 'Time periods', '2020-09-15 14:47:12', 2562, '[[regtime]]', '[[regtime]]'),
(2563, 'english', 'Title', '2020-09-15 14:47:12', 2563, '[[regtime]]', '[[regtime]]'),
(2564, 'english', 'to', '2020-09-15 14:47:12', 2564, '[[regtime]]', '[[regtime]]'),
(2565, 'english', 'Total', '2020-09-15 14:47:12', 2565, '[[regtime]]', '[[regtime]]'),
(2566, 'english', 'Total hours', '2020-09-15 14:47:12', 2566, '[[regtime]]', '[[regtime]]'),
(2567, 'english', 'Total time', '2020-09-15 14:47:12', 2567, '[[regtime]]', '[[regtime]]'),
(2568, 'english', 'Transactions', '2020-09-15 14:47:12', 2568, '[[regtime]]', '[[regtime]]'),
(2569, 'english', 'Twitter', '2020-09-15 14:47:12', 2569, '[[regtime]]', '[[regtime]]'),
(2570, 'english', 'Type', '2020-09-15 14:47:12', 2570, '[[regtime]]', '[[regtime]]'),
(2571, 'english', 'Typology', '2020-09-15 14:47:12', 2571, '[[regtime]]', '[[regtime]]'),
(2572, 'english', 'Unassign', '2020-09-15 14:47:12', 2572, '[[regtime]]', '[[regtime]]'),
(2573, 'english', 'Undo', '2020-09-15 14:47:12', 2573, '[[regtime]]', '[[regtime]]'),
(2574, 'english', 'Infinite', '2020-09-15 14:47:12', 2574, '[[regtime]]', '[[regtime]]'),
(2575, 'english', 'Unpublish', '2020-09-15 14:47:12', 2575, '[[regtime]]', '[[regtime]]'),
(2576, 'english', 'Not read', '2020-09-15 14:47:12', 2576, '[[regtime]]', '[[regtime]]'),
(2577, 'english', 'Unselect all', '2020-09-15 14:47:12', 2577, '[[regtime]]', '[[regtime]]'),
(2578, 'english', 'Until not completed/passed', '2020-09-15 14:47:12', 2578, '[[regtime]]', '[[regtime]]'),
(2579, 'english', 'Up', '2020-09-15 14:47:12', 2579, '[[regtime]]', '[[regtime]]'),
(2580, 'english', 'Upload file(s)', '2020-09-15 14:47:12', 2580, '[[regtime]]', '[[regtime]]'),
(2581, 'english', 'URL', '2020-09-15 14:47:12', 2581, '[[regtime]]', '[[regtime]]'),
(2582, 'english', 'User', '2020-09-15 14:47:12', 2582, '[[regtime]]', '[[regtime]]'),
(2583, 'english', 'Username', '2020-09-15 14:47:12', 2583, '[[regtime]]', '[[regtime]]'),
(2584, 'english', 'Users', '2020-09-15 14:47:12', 2584, '[[regtime]]', '[[regtime]]'),
(2585, 'english', 'User already exists', '2020-09-15 14:47:12', 2585, '[[regtime]]', '[[regtime]]'),
(2586, 'english', 'User release', '2020-09-15 14:47:12', 2586, '[[regtime]]', '[[regtime]]'),
(2587, 'english', 'In progress', '2020-09-15 14:47:12', 2587, '[[regtime]]', '[[regtime]]'),
(2588, 'english', 'Deleted', '2020-09-15 14:47:12', 2588, '[[regtime]]', '[[regtime]]'),
(2589, 'english', 'Subscriptions to confirm', '2020-09-15 14:47:12', 2589, '[[regtime]]', '[[regtime]]'),
(2590, 'english', 'Completed', '2020-09-15 14:47:12', 2590, '[[regtime]]', '[[regtime]]'),
(2591, 'english', 'Enter', '2020-09-15 14:47:12', 2591, '[[regtime]]', '[[regtime]]'),
(2592, 'english', 'Reserved', '2020-09-15 14:47:12', 2592, '[[regtime]]', '[[regtime]]'),
(2593, 'english', 'Subscribed', '2020-09-15 14:47:12', 2593, '[[regtime]]', '[[regtime]]'),
(2594, 'english', 'Suspended', '2020-09-15 14:47:12', 2594, '[[regtime]]', '[[regtime]]'),
(2595, 'english', 'Version', '2020-09-15 14:47:12', 2595, '[[regtime]]', '[[regtime]]'),
(2596, 'english', 'Video conference', '2020-09-15 14:47:12', 2596, '[[regtime]]', '[[regtime]]'),
(2597, 'english', 'View', '2020-09-15 14:47:12', 2597, '[[regtime]]', '[[regtime]]'),
(2598, 'english', 'View All', '2020-09-15 14:47:12', 2598, '[[regtime]]', '[[regtime]]'),
(2599, 'english', 'Edit view rights', '2020-09-15 14:47:12', 2599, '[[regtime]]', '[[regtime]]'),
(2600, 'english', 'Waiting', '2020-09-15 14:47:12', 2600, '[[regtime]]', '[[regtime]]'),
(2601, 'english', 'Waiting users', '2020-09-15 14:47:12', 2601, '[[regtime]]', '[[regtime]]'),
(2602, 'english', 'Warning', '2020-09-15 14:47:12', 2602, '[[regtime]]', '[[regtime]]'),
(2603, 'english', 'Width', '2020-09-15 14:47:12', 2603, '[[regtime]]', '[[regtime]]'),
(2604, 'english', 'Year', '2020-09-15 14:47:12', 2604, '[[regtime]]', '[[regtime]]'),
(2605, 'english', 'Yes', '2020-09-15 14:47:12', 2605, '[[regtime]]', '[[regtime]]'),
(2606, 'english', 'Azioni', '2015-09-30 15:32:40', 2606, '[[regtime]]', '[[regtime]]'),
(2607, 'english', 'Default', '2015-09-30 15:32:40', 2607, '[[regtime]]', '[[regtime]]'),
(2608, 'english', 'Users', '2015-09-30 15:32:40', 2608, '[[regtime]]', '[[regtime]]'),
(2609, 'english', 'Roles', '2015-09-30 15:32:40', 2609, '[[regtime]]', '[[regtime]]'),
(2610, 'english', 'Organization Chart', '2015-09-30 15:32:40', 2610, '[[regtime]]', '[[regtime]]'),
(2611, 'english', 'Groups', '2015-09-30 15:32:40', 2611, '[[regtime]]', '[[regtime]]'),
(2612, 'english', 'Show to:', '2015-09-30 15:32:40', 2612, '[[regtime]]', '[[regtime]]'),
(2613, 'english', 'Everyone', '2015-09-30 15:32:40', 2613, '[[regtime]]', '[[regtime]]'),
(2614, 'english', 'Only selected users', '2015-09-30 15:32:40', 2614, '[[regtime]]', '[[regtime]]'),
(2615, 'english', 'Select users to join:', '2015-09-30 15:32:40', 2615, '[[regtime]]', '[[regtime]]'),
(2616, 'english', 'Smtp disabled in config file', '2015-09-30 15:32:40', 2616, '[[regtime]]', '[[regtime]]'),
(2617, 'english', 'At hour', '2020-09-15 14:47:12', 2617, '[[regtime]]', '[[regtime]]'),
(2618, 'english', 'day', '2020-09-15 14:47:12', 2618, '[[regtime]]', '[[regtime]]'),
(2619, 'english', 'month', '2020-09-15 14:47:12', 2619, '[[regtime]]', '[[regtime]]'),
(2620, 'english', 'Show page views in the last 24 hours', '2020-09-15 14:47:12', 2620, '[[regtime]]', '[[regtime]]'),
(2621, 'english', 'Show page views in the last 30 days', '2020-09-15 14:47:12', 2621, '[[regtime]]', '[[regtime]]'),
(2622, 'english', 'Show page views in the last 7 days', '2020-09-15 14:47:12', 2622, '[[regtime]]', '[[regtime]]'),
(2623, 'english', 'Show page views in the last 12 months', '2020-09-15 14:47:12', 2623, '[[regtime]]', '[[regtime]]'),
(2624, 'english', 'week', '2020-09-15 14:47:12', 2624, '[[regtime]]', '[[regtime]]'),
(2625, 'english', 'year', '2020-09-15 14:47:12', 2625, '[[regtime]]', '[[regtime]]'),
(2626, 'english', 'Duration', '2020-09-15 14:47:12', 2626, '[[regtime]]', '[[regtime]]'),
(2627, 'english', 'Session ends at', '2020-09-15 14:47:12', 2627, '[[regtime]]', '[[regtime]]'),
(2628, 'english', 'Last op.', '2020-09-15 14:47:12', 2628, '[[regtime]]', '[[regtime]]'),
(2629, 'english', 'Number of op.', '2020-09-15 14:47:12', 2629, '[[regtime]]', '[[regtime]]'),
(2630, 'english', 'Order by duration', '2020-09-15 14:47:12', 2630, '[[regtime]]', '[[regtime]]'),
(2631, 'english', 'Order by number of operations', '2020-09-15 14:47:12', 2631, '[[regtime]]', '[[regtime]]'),
(2632, 'english', 'Order by session start', '2020-09-15 14:47:12', 2632, '[[regtime]]', '[[regtime]]'),
(2633, 'english', 'Page view', '2020-09-15 14:47:12', 2633, '[[regtime]]', '[[regtime]]'),
(2634, 'english', 'Session started at', '2020-09-15 14:47:12', 2634, '[[regtime]]', '[[regtime]]'),
(2635, 'english', 'Duration', '2020-09-15 14:47:12', 2635, '[[regtime]]', '[[regtime]]'),
(2636, 'english', 'Operation', '2020-09-15 14:47:12', 2636, '[[regtime]]', '[[regtime]]'),
(2637, 'english', 'User list', '2020-09-15 14:47:12', 2637, '[[regtime]]', '[[regtime]]'),
(2638, 'english', 'User sessions list', '2020-09-15 14:47:12', 2638, '[[regtime]]', '[[regtime]]'),
(2639, 'english', 'User session list', '2020-09-15 14:47:12', 2639, '[[regtime]]', '[[regtime]]'),
(2640, 'english', 'User list', '2020-09-15 14:47:12', 2640, '[[regtime]]', '[[regtime]]'),
(2641, 'english', 'User total time in this course', '2020-09-15 14:47:12', 2641, '[[regtime]]', '[[regtime]]'),
(2642, 'english', 'Session details', '2020-09-15 14:47:12', 2642, '[[regtime]]', '[[regtime]]'),
(2643, 'english', 'Show', '2020-09-15 14:47:12', 2643, '[[regtime]]', '[[regtime]]'),
(2644, 'english', 'Sun', '2020-09-15 14:47:12', 2644, '[[regtime]]', '[[regtime]]'),
(2645, 'english', 'Mon', '2020-09-15 14:47:12', 2645, '[[regtime]]', '[[regtime]]'),
(2646, 'english', 'Tue', '2020-09-15 14:47:12', 2646, '[[regtime]]', '[[regtime]]'),
(2647, 'english', 'Wed', '2020-09-15 14:47:12', 2647, '[[regtime]]', '[[regtime]]'),
(2648, 'english', 'Thu', '2020-09-15 14:47:12', 2648, '[[regtime]]', '[[regtime]]'),
(2649, 'english', 'Fri', '2020-09-15 14:47:12', 2649, '[[regtime]]', '[[regtime]]'),
(2650, 'english', 'Sat', '2020-09-15 14:47:12', 2650, '[[regtime]]', '[[regtime]]'),
(2651, 'english', 'Choose one option', '2020-09-15 14:47:12', 2651, '[[regtime]]', '[[regtime]]'),
(2652, 'english', 'Filter by edition', '2020-09-15 14:47:12', 2652, '[[regtime]]', '[[regtime]]'),
(2653, 'english', 'Show only users that have seen at least one Learning Object', '2020-09-15 14:47:12', 2653, '[[regtime]]', '[[regtime]]'),
(2654, 'english', 'All status', '2020-09-15 14:47:12', 2654, '[[regtime]]', '[[regtime]]'),
(2655, 'english', 'Stats by object', '2020-09-15 14:47:12', 2655, '[[regtime]]', '[[regtime]]'),
(2656, 'english', 'Objects', '2020-09-15 14:47:12', 2656, '[[regtime]]', '[[regtime]]'),
(2657, 'english', 'View graphics', '2020-09-15 14:47:12', 2657, '[[regtime]]', '[[regtime]]'),
(2658, 'english', 'User stats', '2020-09-15 14:47:12', 2658, '[[regtime]]', '[[regtime]]'),
(2659, 'english', 'Statistics', '2020-09-15 14:47:12', 2659, '[[regtime]]', '[[regtime]]'),
(2660, 'english', 'No data for user/lesson', '2020-09-15 14:47:12', 2660, '[[regtime]]', '[[regtime]]'),
(2661, 'english', 'for lesson', '2020-09-15 14:47:12', 2661, '[[regtime]]', '[[regtime]]'),
(2662, 'english', 'Stats by object:', '2020-09-15 14:47:12', 2662, '[[regtime]]', '[[regtime]]'),
(2663, 'english', 'Stats by Student/Object', '2020-09-15 14:47:12', 2663, '[[regtime]]', '[[regtime]]'),
(2664, 'english', 'Fullname', '2020-09-15 14:47:12', 2664, '[[regtime]]', '[[regtime]]'),
(2665, 'english', 'User Stats', '2020-09-15 14:47:12', 2665, '[[regtime]]', '[[regtime]]'),
(2666, 'english', 'View the answers to the open questions', '2020-09-15 14:47:12', 2666, '[[regtime]]', '[[regtime]]'),
(2667, 'english', 'Export questions', '2020-09-15 14:47:12', 2667, '[[regtime]]', '[[regtime]]'),
(2668, 'english', 'Help', '2020-09-15 14:47:12', 2668, '[[regtime]]', '[[regtime]]'),
(2669, 'english', 'My objects', '2020-09-15 14:47:12', 2669, '[[regtime]]', '[[regtime]]'),
(2670, 'english', 'Locked', '2020-09-15 14:47:12', 2670, '[[regtime]]', '[[regtime]]'),
(2671, 'english', 'FAQ', '2020-09-15 14:47:12', 2671, '[[regtime]]', '[[regtime]]'),
(2672, 'english', 'Glossary', '2020-09-15 14:47:12', 2672, '[[regtime]]', '[[regtime]]'),
(2673, 'english', 'HTML page', '2020-09-15 14:47:12', 2673, '[[regtime]]', '[[regtime]]'),
(2674, 'english', 'Upload file', '2020-09-15 14:47:12', 2674, '[[regtime]]', '[[regtime]]'),
(2675, 'english', 'Links', '2020-09-15 14:47:12', 2675, '[[regtime]]', '[[regtime]]'),
(2676, 'english', 'Survey', '2020-09-15 14:47:12', 2676, '[[regtime]]', '[[regtime]]'),
(2677, 'english', 'SCORM chapter', '2020-09-15 14:47:12', 2677, '[[regtime]]', '[[regtime]]'),
(2678, 'english', 'SCORM', '2020-09-15 14:47:12', 2678, '[[regtime]]', '[[regtime]]'),
(2679, 'english', 'Test', '2020-09-15 14:47:12', 2679, '[[regtime]]', '[[regtime]]'),
(2680, 'english', 'Insert a name', '2022-03-10 11:47:16', 2680, '[[regtime]]', '[[regtime]]'),
(2681, 'english', 'Folder name', '2020-09-15 14:47:12', 2681, '[[regtime]]', '[[regtime]]'),
(2682, 'english', 'End course marker', '2020-09-15 14:47:12', 2682, '[[regtime]]', '[[regtime]]'),
(2683, 'english', 'Requisites not satisfied', '2020-09-15 14:47:12', 2683, '[[regtime]]', '[[regtime]]'),
(2684, 'english', 'Play object', '2020-09-15 14:47:12', 2684, '[[regtime]]', '[[regtime]]'),
(2685, 'english', 'Course objects', '2020-09-15 14:47:12', 2685, '[[regtime]]', '[[regtime]]'),
(2686, 'english', 'Shared objects', '2020-09-15 14:47:12', 2686, '[[regtime]]', '[[regtime]]'),
(2687, 'english', 'Remember me', '2020-09-15 14:47:12', 2687, '[[regtime]]', '[[regtime]]'),
(2688, 'english', 'Rename', '2020-09-15 14:47:12', 2688, '[[regtime]]', '[[regtime]]'),
(2689, 'english', 'Copy Learning Object', '2020-09-15 14:47:12', 2689, '[[regtime]]', '[[regtime]]'),
(2690, 'english', 'New Learning Object', '2020-09-15 14:47:12', 2690, '[[regtime]]', '[[regtime]]'),
(2691, 'english', 'Select destination for :', '2020-09-15 14:47:12', 2691, '[[regtime]]', '[[regtime]]'),
(2692, 'english', 'Watching rules', '2020-09-15 14:47:12', 2692, '[[regtime]]', '[[regtime]]'),
(2693, 'english', 'Select Learning Object', '2020-09-15 14:47:12', 2693, '[[regtime]]', '[[regtime]]'),
(2694, 'english', 'Select the test:', '2020-09-15 14:47:12', 2694, '[[regtime]]', '[[regtime]]'),
(2695, 'english', 'Select the bandwidth', '2020-09-15 14:47:12', 2695, '[[regtime]]', '[[regtime]]'),
(2696, 'english', 'Select destination folder', '2020-09-15 14:47:12', 2696, '[[regtime]]', '[[regtime]]'),
(2697, 'english', 'Absence', '2020-09-15 14:47:12', 2697, '[[regtime]]', '[[regtime]]'),
(2698, 'english', 'The users subscription to this course will be confirmed only after the administrator approval', '2020-09-15 14:47:12', 2698, '[[regtime]]', '[[regtime]]'),
(2699, 'english', 'Select the level for the user selected', '2020-09-15 14:47:12', 2699, '[[regtime]]', '[[regtime]]'),
(2700, 'english', 'Select the students to be subscribed to the course', '2020-09-15 14:47:12', 2700, '[[regtime]]', '[[regtime]]'),
(2701, 'english', 'Copy', '2020-09-15 14:47:12', 2701, '[[regtime]]', '[[regtime]]'),
(2702, 'english', 'Copy Subscriptions', '2020-09-15 14:47:12', 2702, '[[regtime]]', '[[regtime]]'),
(2703, 'english', 'Correct subscription', '2020-09-15 14:47:12', 2703, '[[regtime]]', '[[regtime]]'),
(2704, 'english', 'Active from', '2020-09-15 14:47:12', 2704, '[[regtime]]', '[[regtime]]'),
(2705, 'english', 'Completion date', '2020-09-15 14:47:12', 2705, '[[regtime]]', '[[regtime]]'),
(2706, 'english', 'Active until', '2020-09-15 14:47:12', 2706, '[[regtime]]', '[[regtime]]'),
(2707, 'english', 'Date of first completion', '2020-09-15 14:47:12', 2707, '[[regtime]]', '[[regtime]]'),
(2708, 'english', 'Date of last completion', '2020-09-15 14:47:12', 2708, '[[regtime]]', '[[regtime]]'),
(2709, 'english', 'Your subscription request at course [course] has been refused by the administrator', '2020-09-15 14:47:12', 2709, '[[regtime]]', '[[regtime]]'),
(2710, 'english', 'For this course you must select only [max_subscribe] users to subscribe', '2020-09-15 14:47:12', 2710, '[[regtime]]', '[[regtime]]'),
(2711, 'english', 'Select file(s) to import', '2020-09-15 14:47:12', 2711, '[[regtime]]', '[[regtime]]'),
(2712, 'english', 'Import users from course', '2020-09-15 14:47:12', 2712, '[[regtime]]', '[[regtime]]'),
(2713, 'english', 'Do you want to include the header?', '2020-09-15 14:47:12', 2713, '[[regtime]]', '[[regtime]]'),
(2714, 'english', 'For import use a file with a users list (one per row)', '2020-09-15 14:47:12', 2714, '[[regtime]]', '[[regtime]]'),
(2715, 'english', 'Correct insertions', '2020-09-15 14:47:12', 2715, '[[regtime]]', '[[regtime]]'),
(2716, 'english', 'Insertions not necessary', '2020-09-15 14:47:12', 2716, '[[regtime]]', '[[regtime]]'),
(2717, 'english', 'Insertion status', '2020-09-15 14:47:12', 2717, '[[regtime]]', '[[regtime]]'),
(2718, 'english', 'Yes, justified', '2020-09-15 14:47:12', 2718, '[[regtime]]', '[[regtime]]'),
(2719, 'english', 'Level of users to import', '2020-09-15 14:47:12', 2719, '[[regtime]]', '[[regtime]]'),
(2720, 'english', 'Move', '2020-09-15 14:47:12', 2720, '[[regtime]]', '[[regtime]]'),
(2721, 'english', 'Move Subscriptions', '2020-09-15 14:47:12', 2721, '[[regtime]]', '[[regtime]]'),
(2722, 'english', 'Without expiration', '2020-09-15 14:47:12', 2722, '[[regtime]]', '[[regtime]]'),
(2723, 'english', 'Not expired', '2020-09-15 14:47:12', 2723, '[[regtime]]', '[[regtime]]'),
(2724, 'english', 'Yes, not justified', '2020-09-15 14:47:12', 2724, '[[regtime]]', '[[regtime]]'),
(2725, 'english', 'Not necessary, already subscribed to course', '2020-09-15 14:47:12', 2725, '[[regtime]]', '[[regtime]]'),
(2726, 'english', 'Only expired', '2020-09-15 14:47:12', 2726, '[[regtime]]', '[[regtime]]'),
(2727, 'english', 'Remove validity dates', '2020-09-15 14:47:12', 2727, '[[regtime]]', '[[regtime]]'),
(2728, 'english', 'Select who wants to confirm', '2020-09-15 14:47:12', 2728, '[[regtime]]', '[[regtime]]'),
(2729, 'english', 'Send an alert to subscribed users', '2020-09-15 14:47:12', 2729, '[[regtime]]', '[[regtime]]'),
(2730, 'english', 'Show only', '2020-09-15 14:47:12', 2730, '[[regtime]]', '[[regtime]]'),
(2731, 'english', 'Status of users to import', '2020-09-15 14:47:12', 2731, '[[regtime]]', '[[regtime]]'),
(2732, 'english', 'Subscribe', '2020-09-15 14:47:12', 2732, '[[regtime]]', '[[regtime]]'),
(2733, 'english', 'Confirmation text (will be sent to the user)', '2020-09-15 14:47:12', 2733, '[[regtime]]', '[[regtime]]'),
(2734, 'english', 'Not acceptance text (will be sent to the user)', '2020-09-15 14:47:12', 2734, '[[regtime]]', '[[regtime]]'),
(2735, 'english', 'List of selected user, choose a level', '2020-09-15 14:47:12', 2735, '[[regtime]]', '[[regtime]]'),
(2736, 'english', 'List of users waiting for the approval', '2020-09-15 14:47:12', 2736, '[[regtime]]', '[[regtime]]'),
(2737, 'english', 'User is busy in the same period', '2020-09-15 14:47:12', 2737, '[[regtime]]', '[[regtime]]'),
(2738, 'english', 'Overbooking', '2020-09-15 14:47:12', 2738, '[[regtime]]', '[[regtime]]'),
(2739, 'english', 'Details of subscriptions', '2020-09-15 14:47:12', 2739, '[[regtime]]', '[[regtime]]'),
(2740, 'english', 'Valid at date', '2020-09-15 14:47:12', 2740, '[[regtime]]', '[[regtime]]'),
(2741, 'english', 'Do nothing', '2020-09-15 14:47:12', 2741, '[[regtime]]', '[[regtime]]'),
(2742, 'english', 'You can subscribe only [user_subscribe_limit] before reach your subscription limit', '2020-09-15 14:47:12', 2742, '[[regtime]]', '[[regtime]]'),
(2743, 'english', 'Confirm Subscription', '2020-09-15 14:47:12', 2743, '[[regtime]]', '[[regtime]]'),
(2744, 'english', 'CSV file import', '2020-09-15 14:47:12', 2744, '[[regtime]]', '[[regtime]]'),
(2745, 'english', 'Do you want to include the header?', '2020-09-15 14:47:12', 2745, '[[regtime]]', '[[regtime]]'),
(2746, 'english', 'New message', '2020-09-15 14:47:12', 2746, '[[regtime]]', '[[regtime]]'),
(2747, 'english', 'This message has been locked', '2020-09-15 14:47:12', 2747, '[[regtime]]', '[[regtime]]'),
(2748, 'english', 'Lock message', '2020-09-15 14:47:12', 2748, '[[regtime]]', '[[regtime]]'),
(2749, 'english', 'Popular', '2020-09-15 14:47:12', 2749, '[[regtime]]', '[[regtime]]'),
(2750, 'english', 'Use commas to separate tags.', '2020-09-15 14:47:12', 2750, '[[regtime]]', '[[regtime]]'),
(2751, 'english', 'Yours', '2020-09-15 14:47:12', 2751, '[[regtime]]', '[[regtime]]'),
(2752, 'english', 'Cancel', '2022-03-28 10:08:12', 2752, '[[regtime]]', '[[regtime]]'),
(2753, 'english', 'Catalog', '2022-03-28 10:10:57', 2753, '[[regtime]]', '[[regtime]]'),
(2754, 'english', 'Change cover', '2022-03-28 10:11:05', 2754, '[[regtime]]', '[[regtime]]'),
(2755, 'english', 'Change favicon (ico)', '2022-03-28 10:25:02', 2755, '[[regtime]]', '[[regtime]]'),
(2756, 'english', 'Change favicon (png)', '2022-03-28 10:11:27', 2756, '[[regtime]]', '[[regtime]]'),
(2757, 'english', 'Change logo - front page', '2022-03-28 10:11:48', 2757, '[[regtime]]', '[[regtime]]'),
(2758, 'english', 'Change logo - admin area', '2022-03-28 10:11:57', 2758, '[[regtime]]', '[[regtime]]'),
(2759, 'english', 'Color 0', '2022-03-28 10:12:05', 2759, '[[regtime]]', '[[regtime]]'),
(2760, 'english', 'Color 1', '2022-03-28 10:12:11', 2760, '[[regtime]]', '[[regtime]]'),
(2761, 'english', 'Color 2', '2022-03-28 10:12:17', 2761, '[[regtime]]', '[[regtime]]'),
(2762, 'english', 'Color 3', '2022-03-28 10:12:23', 2762, '[[regtime]]', '[[regtime]]'),
(2763, 'english', 'Color 4', '2022-03-28 10:12:31', 2763, '[[regtime]]', '[[regtime]]'),
(2764, 'english', 'Color 5', '2022-03-28 10:12:38', 2764, '[[regtime]]', '[[regtime]]'),
(2765, 'english', 'Color 6', '2022-03-28 10:12:45', 2765, '[[regtime]]', '[[regtime]]'),
(2766, 'english', 'Classroom color', '2022-03-28 10:13:20', 2766, '[[regtime]]', '[[regtime]]'),
(2767, 'english', 'Dashboard popup background', '2022-03-28 10:13:38', 2767, '[[regtime]]', '[[regtime]]'),
(2768, 'english', 'Popup description', '2022-03-28 10:13:49', 2768, '[[regtime]]', '[[regtime]]'),
(2769, 'english', 'Popup title', '2022-03-28 10:13:56', 2769, '[[regtime]]', '[[regtime]]'),
(2770, 'english', 'Elearning - color', '2022-03-28 10:14:05', 2770, '[[regtime]]', '[[regtime]]'),
(2771, 'english', 'Confirm deletion', '2022-03-28 10:14:12', 2771, '[[regtime]]', '[[regtime]]'),
(2772, 'english', 'Delete', '2022-03-28 10:14:17', 2772, '[[regtime]]', '[[regtime]]'),
(2773, 'english', 'Details', '2022-03-28 10:14:22', 2773, '[[regtime]]', '[[regtime]]'),
(2774, 'english', 'Don''t overwrite images', '2022-03-28 10:14:33', 2774, '[[regtime]]', '[[regtime]]'),
(2775, 'english', 'Edit custom CSS', '2022-03-28 10:14:42', 2775, '[[regtime]]', '[[regtime]]'),
(2776, 'english', 'Save', '2022-03-28 10:14:47', 2776, '[[regtime]]', '[[regtime]]'),
(2777, 'english', 'Select catalog', '2022-03-28 10:14:54', 2777, '[[regtime]]', '[[regtime]]'),
(2778, 'english', 'Upgrade', '2022-03-28 10:15:00', 2778, '[[regtime]]', '[[regtime]]'),
(2779, 'english', 'Confirm upgrade', '2022-03-28 10:15:08', 2779, '[[regtime]]', '[[regtime]]'),
(2780, 'english', 'Any difficulty', '2020-09-15 14:47:12', 2780, '[[regtime]]', '[[regtime]]'),
(2781, 'english', 'Any category', '2020-09-15 14:47:12', 2781, '[[regtime]]', '[[regtime]]'),
(2782, 'english', 'Any type', '2020-09-15 14:47:12', 2782, '[[regtime]]', '[[regtime]]'),
(2783, 'english', 'Attempts remaining before suspension', '2020-09-15 14:47:12', 2783, '[[regtime]]', '[[regtime]]'),
(2784, 'english', 'Bonus assigned for this test (with round or manual modification)', '2020-09-15 14:47:12', 2784, '[[regtime]]', '[[regtime]]'),
(2785, 'english', 'Gradebook management settings', '2020-09-15 14:47:12', 2785, '[[regtime]]', '[[regtime]]'),
(2786, 'english', 'Selected answer', '2020-09-15 14:47:12', 2786, '[[regtime]]', '[[regtime]]'),
(2787, 'english', 'Deselect page', '2020-09-15 14:47:12', 2787, '[[regtime]]', '[[regtime]]'),
(2788, 'english', 'Empty answer', '2020-09-15 14:47:12', 2788, '[[regtime]]', '[[regtime]]'),
(2789, 'english', 'Into an existing test', '2020-09-15 14:47:12', 2789, '[[regtime]]', '[[regtime]]'),
(2790, 'english', 'Feedback management', '2020-09-15 14:47:12', 2790, '[[regtime]]', '[[regtime]]'),
(2791, 'english', 'Textual feedback', '2020-09-15 14:47:12', 2791, '[[regtime]]', '[[regtime]]'),
(2792, 'english', 'GIFT', '2020-09-15 14:47:12', 2792, '[[regtime]]', '[[regtime]]'),
(2793, 'english', 'Hard', '2020-09-15 14:47:12', 2793, '[[regtime]]', '[[regtime]]'),
(2794, 'english', 'Ask the user to answer all questions', '2020-09-15 14:47:12', 2794, '[[regtime]]', '[[regtime]]'),
(2795, 'english', 'Maximum number of attempts to answer the test (set 0 for no limits)', '2020-09-15 14:47:12', 2795, '[[regtime]]', '[[regtime]]'),
(2796, 'english', 'The maximum number of attempts has been reached', '2020-09-15 14:47:12', 2796, '[[regtime]]', '[[regtime]]'),
(2797, 'english', 'You must answer all questions to proceed with the test.', '2020-09-15 14:47:12', 2797, '[[regtime]]', '[[regtime]]'),
(2798, 'english', 'Assign a new score for this question', '2020-09-15 14:47:12', 2798, '[[regtime]]', '[[regtime]]'),
(2799, 'english', 'As a new test', '2020-09-15 14:47:12', 2799, '[[regtime]]', '[[regtime]]'),
(2800, 'english', 'Number of remaining attempts <b>[remaining_attempt]</b>', '2020-09-15 14:47:12', 2800, '[[regtime]]', '[[regtime]]'),
(2801, 'english', 'Random choice per category', '2020-09-15 14:47:12', 2801, '[[regtime]]', '[[regtime]]'),
(2802, 'english', '(Sub-group of question)', '2020-09-15 14:47:12', 2802, '[[regtime]]', '[[regtime]]'),
(2803, 'english', 'Question', '2020-09-15 14:47:12', 2803, '[[regtime]]', '[[regtime]]'),
(2804, 'english', 'AS', '2020-09-15 14:47:12', 2804, '[[regtime]]', '[[regtime]]'),
(2805, 'english', 'BR', '2020-09-15 14:47:12', 2805, '[[regtime]]', '[[regtime]]'),
(2806, 'english', 'SC', '2020-09-15 14:47:12', 2806, '[[regtime]]', '[[regtime]]'),
(2807, 'english', 'MC', '2020-09-15 14:47:12', 2807, '[[regtime]]', '[[regtime]]'),
(2808, 'english', 'ET', '2020-09-15 14:47:12', 2808, '[[regtime]]', '[[regtime]]'),
(2809, 'english', 'HT', '2020-09-15 14:47:12', 2809, '[[regtime]]', '[[regtime]]'),
(2810, 'english', 'IC', '2020-09-15 14:47:12', 2810, '[[regtime]]', '[[regtime]]'),
(2811, 'english', 'TE', '2020-09-15 14:47:12', 2811, '[[regtime]]', '[[regtime]]'),
(2812, 'english', 'TL', '2020-09-15 14:47:12', 2812, '[[regtime]]', '[[regtime]]'),
(2813, 'english', 'UP', '2020-09-15 14:47:12', 2813, '[[regtime]]', '[[regtime]]'),
(2814, 'english', 'Answer...', '2020-09-15 14:47:12', 2814, '[[regtime]]', '[[regtime]]'),
(2815, 'english', 'Association', '2020-09-15 14:47:12', 2815, '[[regtime]]', '[[regtime]]'),
(2816, 'english', 'Page break', '2020-09-15 14:47:12', 2816, '[[regtime]]', '[[regtime]]'),
(2817, 'english', 'Single Choice', '2020-09-15 14:47:12', 2817, '[[regtime]]', '[[regtime]]'),
(2818, 'english', 'Multiple Choice', '2020-09-15 14:47:12', 2818, '[[regtime]]', '[[regtime]]'),
(2819, 'english', 'Extended Text', '2020-09-15 14:47:12', 2819, '[[regtime]]', '[[regtime]]'),
(2820, 'english', 'Write here...', '2020-09-15 14:47:12', 2820, '[[regtime]]', '[[regtime]]'),
(2821, 'english', 'Hot Text (find the wrong word)', '2020-09-15 14:47:12', 2821, '[[regtime]]', '[[regtime]]'),
(2822, 'english', 'write [answerN]', '2020-09-15 14:47:12', 2822, '[[regtime]]', '[[regtime]]'),
(2823, 'english', 'Inline Choice', '2020-09-15 14:47:12', 2823, '[[regtime]]', '[[regtime]]'),
(2824, 'english', 'Students can anwser using a select menu that appears in the position of [anwser] tag', '2020-09-15 14:47:12', 2824, '[[regtime]]', '[[regtime]]'),
(2825, 'english', 'No errors', '2020-09-15 14:47:12', 2825, '[[regtime]]', '[[regtime]]'),
(2826, 'english', 'Reference tag', '2020-09-15 14:47:12', 2826, '[[regtime]]', '[[regtime]]'),
(2827, 'english', 'Text Entry', '2020-09-15 14:47:12', 2827, '[[regtime]]', '[[regtime]]'),
(2828, 'english', 'Answer Here', '2020-09-15 14:47:12', 2828, '[[regtime]]', '[[regtime]]'),
(2829, 'english', 'Title (no answer)', '2020-09-15 14:47:12', 2829, '[[regtime]]', '[[regtime]]'),
(2830, 'english', 'Difference with previous time: [time_difference]', '2020-09-15 14:47:12', 2830, '[[regtime]]', '[[regtime]]'),
(2831, 'english', 'Difference with previous total score:', '2020-09-15 14:47:12', 2831, '[[regtime]]', '[[regtime]]'),
(2832, 'english', 'Set difficulty', '2020-09-15 14:47:12', 2832, '[[regtime]]', '[[regtime]]'),
(2833, 'english', 'Set score', '2020-09-15 14:47:12', 2833, '[[regtime]]', '[[regtime]]'),
(2834, 'english', 'Set time:', '2020-09-15 14:47:12', 2834, '[[regtime]]', '[[regtime]]'),
(2835, 'english', 'Upload file', '2020-09-15 14:47:12', 2835, '[[regtime]]', '[[regtime]]'),
(2836, 'english', 'Restart test execution from beginning', '2020-09-15 14:47:12', 2836, '[[regtime]]', '[[regtime]]'),
(2837, 'english', 'Select page', '2020-09-15 14:47:12', 2837, '[[regtime]]', '[[regtime]]'),
(2838, 'english', 'Show in Gradebook Management', '2020-09-15 14:47:12', 2838, '[[regtime]]', '[[regtime]]'),
(2839, 'english', 'Show in detail tab', '2020-09-15 14:47:12', 2839, '[[regtime]]', '[[regtime]]'),
(2840, 'english', 'Suspend the test after the following number of failed attempts', '2020-09-15 14:47:12', 2840, '[[regtime]]', '[[regtime]]'),
(2841, 'english', 'Suspend the test for the following number of hours', '2020-09-15 14:47:12', 2841, '[[regtime]]', '[[regtime]]'),
(2842, 'english', 'After the test suspension, require a new completion of all the test prerequisites', '2020-09-15 14:47:12', 2842, '[[regtime]]', '[[regtime]]'),
(2843, 'english', 'Add question', '2020-09-15 14:47:12', 2843, '[[regtime]]', '[[regtime]]'),
(2844, 'english', 'Description is shown to students before attempting the test', '2020-09-15 14:47:12', 2844, '[[regtime]]', '[[regtime]]'),
(2845, 'english', 'Add one more answer', '2020-09-15 14:47:12', 2845, '[[regtime]]', '[[regtime]]'),
(2846, 'english', 'after row', '2020-09-15 14:47:12', 2846, '[[regtime]]', '[[regtime]]'),
(2847, 'english', 'Answers:', '2020-09-15 14:47:12', 2847, '[[regtime]]', '[[regtime]]'),
(2848, 'english', 'Selected', '2020-09-15 14:47:12', 2848, '[[regtime]]', '[[regtime]]'),
(2849, 'english', 'Not selected', '2020-09-15 14:47:12', 2849, '[[regtime]]', '[[regtime]]'),
(2850, 'english', 'Correct associations', '2020-09-15 14:47:12', 2850, '[[regtime]]', '[[regtime]]'),
(2851, 'english', 'Back to score administration page', '2020-09-15 14:47:12', 2851, '[[regtime]]', '[[regtime]]'),
(2852, 'english', 'Click to begin', '2020-09-15 14:47:12', 2852, '[[regtime]]', '[[regtime]]'),
(2853, 'english', 'You can jump to the next or previous page (if the test has multiple pages)', '2020-09-15 14:47:12', 2853, '[[regtime]]', '[[regtime]]'),
(2854, 'english', 'You can <b>not</b> jump to the next or previous page (if the test has multiple pages)', '2020-09-15 14:47:12', 2854, '[[regtime]]', '[[regtime]]'),
(2855, 'english', 'Complete list of questions available in the test ( %tot_element% elements in %tot_page% pages)', '2020-09-15 14:47:12', 2855, '[[regtime]]', '[[regtime]]'),
(2856, 'english', 'Time management', '2020-09-15 14:47:12', 2856, '[[regtime]]', '[[regtime]]'),
(2857, 'english', 'Test completed', '2020-09-15 14:47:12', 2857, '[[regtime]]', '[[regtime]]'),
(2858, 'english', 'Resume the test', '2020-09-15 14:47:12', 2858, '[[regtime]]', '[[regtime]]'),
(2859, 'english', 'Correct', '2020-09-15 14:47:12', 2859, '[[regtime]]', '[[regtime]]'),
(2860, 'english', 'OK', '2020-09-15 14:47:12', 2860, '[[regtime]]', '[[regtime]]'),
(2861, 'english', 'Submit (test completed)', '2020-09-15 14:47:12', 2861, '[[regtime]]', '[[regtime]]'),
(2862, 'english', 'Not passed', '2020-09-15 14:47:12', 2862, '[[regtime]]', '[[regtime]]'),
(2863, 'english', 'You didn''t upload any file', '2020-09-15 14:47:12', 2863, '[[regtime]]', '[[regtime]]'),
(2864, 'english', 'as first', '2020-09-15 14:47:12', 2864, '[[regtime]]', '[[regtime]]'),
(2865, 'english', 'Select answer', '2020-09-15 14:47:12', 2865, '[[regtime]]', '[[regtime]]'),
(2866, 'english', 'If correct', '2020-09-15 14:47:12', 2866, '[[regtime]]', '[[regtime]]'),
(2867, 'english', 'If wrong', '2020-09-15 14:47:12', 2867, '[[regtime]]', '[[regtime]]'),
(2868, 'english', 'Wrong', '2020-09-15 14:47:12', 2868, '[[regtime]]', '[[regtime]]'),
(2869, 'english', 'Information about the test', '2020-09-15 14:47:12', 2869, '[[regtime]]', '[[regtime]]'),
(2870, 'english', 'New Test', '2020-09-15 14:47:12', 2870, '[[regtime]]', '[[regtime]]'),
(2871, 'english', 'Correct answer', '2020-09-15 14:47:12', 2871, '[[regtime]]', '[[regtime]]'),
(2872, 'english', 'The right answer is', '2020-09-15 14:47:12', 2872, '[[regtime]]', '[[regtime]]'),
(2873, 'english', ', was the right choice', '2020-09-15 14:47:12', 2873, '[[regtime]]', '[[regtime]]'),
(2874, 'english', 'as last', '2020-09-15 14:47:12', 2874, '[[regtime]]', '[[regtime]]'),
(2875, 'english', 'Some questions need instructor''s grading. Your score could increase of:', '2020-09-15 14:47:12', 2875, '[[regtime]]', '[[regtime]]'),
(2876, 'english', 'Max Score: <b>[max_score]</b>', '2020-09-15 14:47:12', 2876, '[[regtime]]', '[[regtime]]'),
(2877, 'english', 'Answers view', '2020-09-15 14:47:12', 2877, '[[regtime]]', '[[regtime]]'),
(2878, 'english', 'Random (if allowed by question type)', '2020-09-15 14:47:12', 2878, '[[regtime]]', '[[regtime]]'),
(2879, 'english', 'Arrange in sequence', '2020-09-15 14:47:12', 2879, '[[regtime]]', '[[regtime]]'),
(2880, 'english', 'Show questions grouped in one or more pages (clustering by break pages)', '2020-09-15 14:47:12', 2880, '[[regtime]]', '[[regtime]]'),
(2881, 'english', 'Show one question per page', '2020-09-15 14:47:12', 2881, '[[regtime]]', '[[regtime]]'),
(2882, 'english', 'Random choice of [random_quest] questions on  <b>[tot_quest]</b> available.', '2020-09-15 14:47:12', 2882, '[[regtime]]', '[[regtime]]'),
(2883, 'english', '(All questions) Random (clustering by break page)', '2020-09-15 14:47:12', 2883, '[[regtime]]', '[[regtime]]'),
(2884, 'english', '(All questions) Arranged in sequence', '2020-09-15 14:47:12', 2884, '[[regtime]]', '[[regtime]]'),
(2885, 'english', 'Allow backtracking (button Previous Page active)', '2020-09-15 14:47:12', 2885, '[[regtime]]', '[[regtime]]'),
(2886, 'english', 'Hide info for test in use', '2020-09-15 14:47:12', 2886, '[[regtime]]', '[[regtime]]'),
(2887, 'english', 'Allow answers edit', '2020-09-15 14:47:12', 2887, '[[regtime]]', '[[regtime]]'),
(2888, 'english', 'Allow attempts in more sessions (saving answered questions)', '2020-09-15 14:47:12', 2888, '[[regtime]]', '[[regtime]]'),
(2889, 'english', 'Show score grouped by question category (if it''s calculable)', '2020-09-15 14:47:12', 2889, '[[regtime]]', '[[regtime]]'),
(2890, 'english', 'Show all the answers inserted by user', '2020-09-15 14:47:12', 2890, '[[regtime]]', '[[regtime]]'),
(2891, 'english', 'Show correct answers', '2020-09-15 14:47:12', 2891, '[[regtime]]', '[[regtime]]'),
(2892, 'english', 'Show final score (if it''s calculable)', '2020-09-15 14:47:12', 2892, '[[regtime]]', '[[regtime]]'),
(2893, 'english', 'Manage your test in Gradebook Management', '2020-09-15 14:47:12', 2893, '[[regtime]]', '[[regtime]]'),
(2894, 'english', '3 - Details shown at the end of attempt', '2020-09-15 14:47:12', 2894, '[[regtime]]', '[[regtime]]'),
(2895, 'english', '1 - Set questions visualization', '2020-09-15 14:47:12', 2895, '[[regtime]]', '[[regtime]]'),
(2896, 'english', '2 - Set attempts options', '2020-09-15 14:47:12', 2896, '[[regtime]]', '[[regtime]]'),
(2897, 'english', 'Test options', '2020-09-15 14:47:12', 2897, '[[regtime]]', '[[regtime]]'),
(2898, 'english', 'You can edit your answers', '2020-09-15 14:47:12', 2898, '[[regtime]]', '[[regtime]]'),
(2899, 'english', 'You <span class="text_bold">can''t</span>  edit your answers', '2020-09-15 14:47:12', 2899, '[[regtime]]', '[[regtime]]'),
(2900, 'english', 'row', '2020-09-15 14:47:12', 2900, '[[regtime]]', '[[regtime]]'),
(2901, 'english', 'Next page', '2020-09-15 14:47:12', 2901, '[[regtime]]', '[[regtime]]'),
(2902, 'english', 'the correct answer is', '2020-09-15 14:47:12', 2902, '[[regtime]]', '[[regtime]]'),
(2903, 'english', 'is wrong', '2020-09-15 14:47:12', 2903, '[[regtime]]', '[[regtime]]'),
(2904, 'english', 'is wrong', '2020-09-15 14:47:12', 2904, '[[regtime]]', '[[regtime]]'),
(2905, 'english', 'Right answer', '2020-09-15 14:47:12', 2905, '[[regtime]]', '[[regtime]]'),
(2906, 'english', 'Page', '2020-09-15 14:47:12', 2906, '[[regtime]]', '[[regtime]]'),
(2907, 'english', 'Express score as percentage', '2020-09-15 14:47:12', 2907, '[[regtime]]', '[[regtime]]'),
(2908, 'english', 'Express score as points', '2020-09-15 14:47:12', 2908, '[[regtime]]', '[[regtime]]'),
(2909, 'english', 'Min score required to pass the test', '2020-09-15 14:47:12', 2909, '[[regtime]]', '[[regtime]]'),
(2910, 'english', 'Different amount based on question difficulty', '2020-09-15 14:47:12', 2910, '[[regtime]]', '[[regtime]]'),
(2911, 'english', 'Same score for each question (total score/number of questions)', '2020-09-15 14:47:12', 2911, '[[regtime]]', '[[regtime]]'),
(2912, 'english', 'Choose score for every question', '2020-09-15 14:47:12', 2912, '[[regtime]]', '[[regtime]]'),
(2913, 'english', '1 - Set final score calculation', '2020-09-15 14:47:12', 2913, '[[regtime]]', '[[regtime]]'),
(2914, 'english', 'Set score preferences', '2020-09-15 14:47:12', 2914, '[[regtime]]', '[[regtime]]'),
(2915, 'english', 'Distributed by:', '2020-09-15 14:47:12', 2915, '[[regtime]]', '[[regtime]]'),
(2916, 'english', '2 - Set score for each question', '2020-09-15 14:47:12', 2916, '[[regtime]]', '[[regtime]]'),
(2917, 'english', 'Scores management', '2020-09-15 14:47:12', 2917, '[[regtime]]', '[[regtime]]'),
(2918, 'english', 'Scores management', '2020-09-15 14:47:12', 2918, '[[regtime]]', '[[regtime]]'),
(2919, 'english', 'Previous page', '2020-09-15 14:47:12', 2919, '[[regtime]]', '[[regtime]]'),
(2920, 'english', 'The test has <b>[question_number]</b> questions', '2020-09-15 14:47:12', 2920, '[[regtime]]', '[[regtime]]'),
(2921, 'english', 'Question category', '2020-09-15 14:47:12', 2921, '[[regtime]]', '[[regtime]]'),
(2922, 'english', 'element', '2020-09-15 14:47:12', 2922, '[[regtime]]', '[[regtime]]'),
(2923, 'english', 'Group A elements', '2020-09-15 14:47:12', 2923, '[[regtime]]', '[[regtime]]'),
(2924, 'english', 'Group B elements', '2020-09-15 14:47:12', 2924, '[[regtime]]', '[[regtime]]'),
(2925, 'english', 'Num. elements', '2020-09-15 14:47:12', 2925, '[[regtime]]', '[[regtime]]'),
(2926, 'english', 'Maximum test score', '2020-09-15 14:47:12', 2926, '[[regtime]]', '[[regtime]]'),
(2927, 'english', 'New max score', '2020-09-15 14:47:12', 2927, '[[regtime]]', '[[regtime]]'),
(2928, 'english', 'Order', '2020-09-15 14:47:12', 2928, '[[regtime]]', '[[regtime]]'),
(2929, 'english', 'Next (set right associations)', '2020-09-15 14:47:12', 2929, '[[regtime]]', '[[regtime]]'),
(2930, 'english', 'Max answer time', '2020-09-15 14:47:12', 2930, '[[regtime]]', '[[regtime]]'),
(2931, 'english', 'Time assigned', '2020-09-15 14:47:12', 2931, '[[regtime]]', '[[regtime]]'),
(2932, 'english', 'Pass mark: <b>[score_req]</b>', '2020-09-15 14:47:12', 2932, '[[regtime]]', '[[regtime]]'),
(2933, 'english', 'Pass Mark:', '2020-09-15 14:47:12', 2933, '[[regtime]]', '[[regtime]]'),
(2934, 'english', 'Restart test', '2020-09-15 14:47:12', 2934, '[[regtime]]', '[[regtime]]'),
(2935, 'english', 'Show your answers', '2020-09-15 14:47:12', 2935, '[[regtime]]', '[[regtime]]'),
(2936, 'english', 'For this test there is a pending compilation: do you want to resume or to do it again?', '2020-09-15 14:47:12', 2936, '[[regtime]]', '[[regtime]]'),
(2937, 'english', 'You can save and resume test later', '2020-09-15 14:47:12', 2937, '[[regtime]]', '[[regtime]]'),
(2938, 'english', 'Back to course', '2020-09-15 14:47:12', 2938, '[[regtime]]', '[[regtime]]'),
(2939, 'english', 'Back to test', '2020-09-15 14:47:12', 2939, '[[regtime]]', '[[regtime]]'),
(2940, 'english', 'Test must be completed now. It <span class="text_bold">cannot</span> be resumed later', '2020-09-15 14:47:12', 2940, '[[regtime]]', '[[regtime]]'),
(2941, 'english', 'Save test, you can resume it later', '2020-09-15 14:47:12', 2941, '[[regtime]]', '[[regtime]]'),
(2942, 'english', 'Points', '2020-09-15 14:47:12', 2942, '[[regtime]]', '[[regtime]]'),
(2943, 'english', 'Test', '2020-09-15 14:47:12', 2943, '[[regtime]]', '[[regtime]]'),
(2944, 'english', 'Choose answers from library', '2020-09-15 14:47:12', 2944, '[[regtime]]', '[[regtime]]'),
(2945, 'english', 'Show last results', '2020-09-15 14:47:12', 2945, '[[regtime]]', '[[regtime]]'),
(2946, 'english', 'Final score will be shown after test completion', '2020-09-15 14:47:12', 2946, '[[regtime]]', '[[regtime]]'),
(2947, 'english', 'Final score will not be shown after test completion', '2020-09-15 14:47:12', 2947, '[[regtime]]', '[[regtime]]'),
(2948, 'english', 'Answers will be shown after test completion', '2020-09-15 14:47:12', 2948, '[[regtime]]', '[[regtime]]'),
(2949, 'english', 'You <span class="text_bold">can''t</span> know the right answer to questions after completing the test', '2020-09-15 14:47:12', 2949, '[[regtime]]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES
(2950, 'english', 'Remove last answer', '2020-09-15 14:47:12', 2950, '[[regtime]]', '[[regtime]]'),
(2951, 'english', 'Test question list', '2020-09-15 14:47:12', 2951, '[[regtime]]', '[[regtime]]'),
(2952, 'english', 'Test has been suspended', '2020-09-15 14:47:12', 2952, '[[regtime]]', '[[regtime]]'),
(2953, 'english', 'The test has been suspended until', '2020-09-15 14:47:12', 2953, '[[regtime]]', '[[regtime]]'),
(2954, 'english', 'answer text', '2020-09-15 14:47:12', 2954, '[[regtime]]', '[[regtime]]'),
(2955, 'english', 'Choose the right word', '2020-09-15 14:47:12', 2955, '[[regtime]]', '[[regtime]]'),
(2956, 'english', 'Test time limit: <b>[time_assigned] minutes</b>', '2020-09-15 14:47:12', 2956, '[[regtime]]', '[[regtime]]'),
(2957, 'english', '<span class="text_bold">No</span> time limits', '2020-09-15 14:47:12', 2957, '[[regtime]]', '[[regtime]]'),
(2958, 'english', 'A time limit is defined for each question', '2020-09-15 14:47:12', 2958, '[[regtime]]', '[[regtime]]'),
(2959, 'english', 'Time management', '2020-09-15 14:47:12', 2959, '[[regtime]]', '[[regtime]]'),
(2960, 'english', 'No time limit', '2020-09-15 14:47:12', 2960, '[[regtime]]', '[[regtime]]'),
(2961, 'english', 'Time limit, test based', '2020-09-15 14:47:12', 2961, '[[regtime]]', '[[regtime]]'),
(2962, 'english', 'Time limit question based; every question has a specific time limit', '2020-09-15 14:47:12', 2962, '[[regtime]]', '[[regtime]]'),
(2963, 'english', 'Test with time limit', '2020-09-15 14:47:12', 2963, '[[regtime]]', '[[regtime]]'),
(2964, 'english', 'Set difficulty and score for each question', '2020-09-15 14:47:12', 2964, '[[regtime]]', '[[regtime]]'),
(2965, 'english', 'Same time for each question (total time/number of questions)', '2020-09-15 14:47:12', 2965, '[[regtime]]', '[[regtime]]'),
(2966, 'english', 'Choose a time limit for the answer to each question', '2020-09-15 14:47:12', 2966, '[[regtime]]', '[[regtime]]'),
(2967, 'english', 'New total time', '2020-09-15 14:47:12', 2967, '[[regtime]]', '[[regtime]]'),
(2968, 'english', 'New total time:', '2020-09-15 14:47:12', 2968, '[[regtime]]', '[[regtime]]'),
(2969, 'english', 'Penalty if question time limit has been exceeded', '2020-09-15 14:47:12', 2969, '[[regtime]]', '[[regtime]]'),
(2970, 'english', 'Penalty if total time limit has been exceeded', '2020-09-15 14:47:12', 2970, '[[regtime]]', '[[regtime]]'),
(2971, 'english', 'Apply changes', '2020-09-15 14:47:12', 2971, '[[regtime]]', '[[regtime]]'),
(2972, 'english', 'Apply and Set time', '2020-09-15 14:47:12', 2972, '[[regtime]]', '[[regtime]]'),
(2973, 'english', 'Distributed by:', '2020-09-15 14:47:12', 2973, '[[regtime]]', '[[regtime]]'),
(2974, 'english', 'Set time assigned to the questions', '2020-09-15 14:47:12', 2974, '[[regtime]]', '[[regtime]]'),
(2975, 'english', '1 - Set test time', '2020-09-15 14:47:12', 2975, '[[regtime]]', '[[regtime]]'),
(2976, 'english', 'Set time for each question', '2020-09-15 14:47:12', 2976, '[[regtime]]', '[[regtime]]'),
(2977, 'english', '2 - Set total time for attempting', '2020-09-15 14:47:12', 2977, '[[regtime]]', '[[regtime]]'),
(2978, 'english', 'Total score:', '2020-09-15 14:47:12', 2978, '[[regtime]]', '[[regtime]]'),
(2979, 'english', 'This test does not support the action required', '2020-09-15 14:47:12', 2979, '[[regtime]]', '[[regtime]]'),
(2980, 'english', 'Time elapsed', '2020-09-15 14:47:12', 2980, '[[regtime]]', '[[regtime]]'),
(2981, 'english', 'Time left', '2020-09-15 14:47:12', 2981, '[[regtime]]', '[[regtime]]'),
(2982, 'english', 'You didn''t complete the prerequisites', '2020-09-15 14:47:12', 2982, '[[regtime]]', '[[regtime]]'),
(2983, 'english', 'Use test suspension', '2020-09-15 14:47:12', 2983, '[[regtime]]', '[[regtime]]'),
(2984, 'english', 'Very hard', '2020-09-15 14:47:12', 2984, '[[regtime]]', '[[regtime]]'),
(2985, 'english', 'Yes, if the test has been passed', '2020-09-15 14:47:12', 2985, '[[regtime]]', '[[regtime]]'),
(2986, 'english', 'You passed this test', '2020-09-15 14:47:12', 2986, '[[regtime]]', '[[regtime]]'),
(2987, 'english', 'Mark as paid', '2020-09-15 14:47:12', 2987, '[[regtime]]', '[[regtime]]'),
(2988, 'english', 'Price', '2020-09-15 14:47:12', 2988, '[[regtime]]', '[[regtime]]'),
(2989, 'english', 'Set as not paid', '2020-09-15 14:47:12', 2989, '[[regtime]]', '[[regtime]]'),
(2990, 'english', 'Empty', '2020-09-15 14:47:12', 2990, '[[regtime]]', '[[regtime]]'),
(2991, 'english', 'Which', '2020-09-15 14:47:12', 2991, '[[regtime]]', '[[regtime]]'),
(2992, 'english', 'Action on users', '2020-09-15 14:47:12', 2992, '[[regtime]]', '[[regtime]]'),
(2993, 'english', 'Automatic password', '2020-09-15 14:47:12', 2993, '[[regtime]]', '[[regtime]]'),
(2994, 'english', 'Create all', '2020-09-15 14:47:12', 2994, '[[regtime]]', '[[regtime]]'),
(2995, 'english', 'Create and update', '2020-09-15 14:47:12', 2995, '[[regtime]]', '[[regtime]]'),
(2996, 'english', 'Don''t use self registration in the organizational tree', '2020-09-15 14:47:12', 2996, '[[regtime]]', '[[regtime]]'),
(2997, 'english', 'You can''t import more times the same column', '2020-09-15 14:47:12', 2997, '[[regtime]]', '[[regtime]]'),
(2998, 'english', 'Load password from file', '2020-09-15 14:47:12', 2998, '[[regtime]]', '[[regtime]]'),
(2999, 'english', 'Generate password', '2020-09-15 14:47:12', 2999, '[[regtime]]', '[[regtime]]'),
(3000, 'english', 'Insert for all', '2020-09-15 14:47:12', 3000, '[[regtime]]', '[[regtime]]'),
(3001, 'english', 'Insert password where the field is empty', '2020-09-15 14:47:12', 3001, '[[regtime]]', '[[regtime]]'),
(3002, 'english', 'Login/registration options', '2020-09-15 14:47:12', 3002, '[[regtime]]', '[[regtime]]'),
(3003, 'english', 'Manual password', '2020-09-15 14:47:12', 3003, '[[regtime]]', '[[regtime]]'),
(3004, 'english', 'You must enable the sending of the alert to users if the password entry is selected', '2020-09-15 14:47:12', 3004, '[[regtime]]', '[[regtime]]'),
(3005, 'english', 'No file loaded', '2020-09-15 14:47:12', 3005, '[[regtime]]', '[[regtime]]'),
(3006, 'english', 'No selections have been made', '2020-09-15 14:47:12', 3006, '[[regtime]]', '[[regtime]]'),
(3007, 'english', 'Create only', '2020-09-15 14:47:12', 3007, '[[regtime]]', '[[regtime]]'),
(3008, 'english', 'Update only', '2020-09-15 14:47:12', 3008, '[[regtime]]', '[[regtime]]'),
(3009, 'english', 'Password create', '2020-09-15 14:47:12', 3009, '[[regtime]]', '[[regtime]]'),
(3010, 'english', 'You have failed to log in for [attempt] times, for security reasons wait [time] minutes before trying again', '2020-09-15 14:47:12', 3010, '[[regtime]]', '[[regtime]]'),
(3011, 'english', 'Only by administrator', '2020-09-15 14:47:12', 3011, '[[regtime]]', '[[regtime]]'),
(3012, 'english', 'Moderated self registration', '2020-09-15 14:47:12', 3012, '[[regtime]]', '[[regtime]]'),
(3013, 'english', 'Free self registration', '2020-09-15 14:47:12', 3013, '[[regtime]]', '[[regtime]]'),
(3014, 'english', 'Send new login credentials to users', '2020-09-15 14:47:12', 3014, '[[regtime]]', '[[regtime]]'),
(3015, 'english', 'Set password', '2020-09-15 14:47:12', 3015, '[[regtime]]', '[[regtime]]'),
(3016, 'english', 'Username necessary in the import and to be selected for the comparison', '2020-09-15 14:47:12', 3016, '[[regtime]]', '[[regtime]]'),
(3017, 'english', 'Subscription code inserted manually', '2020-09-15 14:47:12', 3017, '[[regtime]]', '[[regtime]]'),
(3018, 'english', 'Subscription code chosen from a dropdown menu', '2020-09-15 14:47:12', 3018, '[[regtime]]', '[[regtime]]'),
(3019, 'english', 'Add wiki', '2020-09-15 14:47:12', 3019, '[[regtime]]', '[[regtime]]'),
(3020, 'english', 'Go to this page', '2020-09-15 14:47:12', 3020, '[[regtime]]', '[[regtime]]'),
(3021, 'english', 'View page revision', '2020-09-15 14:47:12', 3021, '[[regtime]]', '[[regtime]]'),
(3022, 'english', 'Compare selected versions', '2020-09-15 14:47:12', 3022, '[[regtime]]', '[[regtime]]'),
(3023, 'english', 'Export selected pages', '2020-09-15 14:47:12', 3023, '[[regtime]]', '[[regtime]]'),
(3024, 'english', 'To create a new page and link write  [[page|title]] or only [[page]] if title and name are the same', '2020-09-15 14:47:12', 3024, '[[regtime]]', '[[regtime]]'),
(3025, 'english', 'Index', '2020-09-15 14:47:12', 3025, '[[regtime]]', '[[regtime]]'),
(3026, 'english', 'Level up', '2020-09-15 14:47:12', 3026, '[[regtime]]', '[[regtime]]'),
(3027, 'english', 'Map', '2020-09-15 14:47:12', 3027, '[[regtime]]', '[[regtime]]'),
(3028, 'english', 'Other language', '2020-09-15 14:47:12', 3028, '[[regtime]]', '[[regtime]]'),
(3029, 'english', 'Page', '2020-09-15 14:47:12', 3029, '[[regtime]]', '[[regtime]]'),
(3030, 'english', 'Please specify some text to search (at least 3 characters)', '2020-09-15 14:47:12', 3030, '[[regtime]]', '[[regtime]]'),
(3031, 'english', 'Revisions', '2020-09-15 14:47:12', 3031, '[[regtime]]', '[[regtime]]'),
(3032, 'english', 'Select a wiki', '2020-09-15 14:47:12', 3032, '[[regtime]]', '[[regtime]]'),
(3033, 'english', 'choose a wiki', '2020-09-15 14:47:12', 3033, '[[regtime]]', '[[regtime]]'),
(3034, 'english', 'Wiki', '2020-09-15 14:47:12', 3034, '[[regtime]]', '[[regtime]]'),
(3035, 'english', 'Index', '2020-09-15 14:47:12', 3035, '[[regtime]]', '[[regtime]]'),
(3036, 'english', 'WARNING: if you proceed with SAVE, this page will become the last version', '2020-09-15 14:47:12', 3036, '[[regtime]]', '[[regtime]]'),
(3037, 'english', 'default language', '2020-09-15 14:47:12', 3037, '[[regtime]]', '[[regtime]]'),
(3038, 'english', 'Level up', '2020-09-15 14:47:12', 3038, '[[regtime]]', '[[regtime]]'),
(3039, 'english', 'select other languages for pages', '2020-09-15 14:47:12', 3039, '[[regtime]]', '[[regtime]]'),
(3040, 'english', 'Prev.', '2020-09-15 14:47:12', 3040, '[[regtime]]', '[[regtime]]'),
(3041, 'english', 'Name', '2015-09-30 15:32:39', 3041, '[[regtime]]', '[[regtime]]'),
(3042, 'english', 'Upper Category', '2015-09-30 15:32:39', 3042, '[[regtime]]', '[[regtime]]'),
(3043, 'english', 'Filter communications by category', '2015-09-30 15:32:39', 3043, '[[regtime]]', '[[regtime]]'),
(3044, 'english', 'Count', '2015-09-30 15:32:39', 3044, '[[regtime]]', '[[regtime]]'),
(3045, 'english', 'No Selection', '2015-09-30 15:32:39', 3045, '[[regtime]]', '[[regtime]]'),
(3046, 'english', 'Impossiible deleting categories with published posts', '2015-09-30 15:32:39', 3046, '[[regtime]]', '[[regtime]]'),
(3047, 'english', 'Generic Error', '2015-09-30 15:32:39', 3047, '[[regtime]]', '[[regtime]]'),
(3048, 'english', 'Impossible deleting a father category', '2015-09-30 15:32:39', 3048, '[[regtime]]', '[[regtime]]'),
(3049, 'english', 'You must set at least one category', '2015-09-30 15:32:39', 3049, '[[regtime]]', '[[regtime]]'),
(3050, 'english', 'Mark as read', '2015-09-30 15:32:39', 3050, '[[regtime]]', '[[regtime]]'),
(3051, 'english', 'Mark as unread', '2015-09-30 15:32:39', 3051, '[[regtime]]', '[[regtime]]'),
(3052, 'english', 'Auto Tls', '2015-09-30 15:32:39', 3052, '[[regtime]]', '[[regtime]]'),
(3053, 'english', 'Host', '2015-09-30 15:32:39', 3053, '[[regtime]]', '[[regtime]]'),
(3054, 'english', 'Port', '2015-09-30 15:32:39', 3054, '[[regtime]]', '[[regtime]]'),
(3055, 'english', 'Debug', '2015-09-30 15:32:39', 3055, '[[regtime]]', '[[regtime]]'),
(3056, 'english', 'Secure', '2015-09-30 15:32:39', 3056, '[[regtime]]', '[[regtime]]'),
(3057, 'english', 'Sender mail notifications', '2015-09-30 15:32:39', 3057, '[[regtime]]', '[[regtime]]'),
(3058, 'english', 'Sender name notifications', '2015-09-30 15:32:39', 3058, '[[regtime]]', '[[regtime]]'),
(3059, 'english', 'Sender mail system', '2015-09-30 15:32:39', 3059, '[[regtime]]', '[[regtime]]'),
(3060, 'english', 'Sender name system', '2015-09-30 15:32:39', 3060, '[[regtime]]', '[[regtime]]'),
(3061, 'english', 'Mail Help Desk', '2015-09-30 15:32:39', 3061, '[[regtime]]', '[[regtime]]'),
(3062, 'english', 'Name Help Desk', '2015-09-30 15:32:39', 3062, '[[regtime]]', '[[regtime]]'),
(3063, 'english', 'Subject Help Desk', '2015-09-30 15:32:39', 3063, '[[regtime]]', '[[regtime]]'),
(3064, 'english', 'Reply to sender name', '2015-09-30 15:32:39', 3064, '[[regtime]]', '[[regtime]]'),
(3065, 'english', 'Reply to sender mail', '2015-09-30 15:32:39', 3065, '[[regtime]]', '[[regtime]]'),
(3066, 'english', 'Mail CC', '2015-09-30 15:32:39', 3066, '[[regtime]]', '[[regtime]]'),
(3067, 'english', 'Mail CCN', '2015-09-30 15:32:39', 3067, '[[regtime]]', '[[regtime]]'),
(3068, 'english', 'The fields: [fields] cannot be blank', '2015-09-30 15:32:39', 3068, '[[regtime]]', '[[regtime]]'),
(3069, 'english', 'The fields: [fields] are required', '2015-09-30 15:32:39', 3069, '[[regtime]]', '[[regtime]]'),
(3070, 'english', 'TEST mail sent successfully', '2015-09-30 15:32:39', 3070, '[[regtime]]', '[[regtime]]'),
(3071, 'english', 'TEST mail failed with errors', '2015-09-30 15:32:39', 3071, '[[regtime]]', '[[regtime]]'),
(3072, 'english', 'TEST Mail', '2015-09-30 15:32:39', 3072, '[[regtime]]', '[[regtime]]'),
(3073, 'english', 'You sent a Test mail to this address', '2015-09-30 15:32:39', 3073, '[[regtime]]', '[[regtime]]'),
(3074, 'english', 'Send a Test Mail', '2015-09-30 15:32:39', 3074, '[[regtime]]', '[[regtime]]'),
(3075, 'english', 'Domain', '2015-09-30 15:32:39', 3075, '[[regtime]]', '[[regtime]]'),
(3076, 'english', 'Template', '2015-09-30 15:32:39', 3076, '[[regtime]]', '[[regtime]]'),
(3077, 'english', 'Organization node', '2015-09-30 15:32:39', 3077, '[[regtime]]', '[[regtime]]'),
(3078, 'english', 'Mail setting', '2015-09-30 15:32:39', 3078, '[[regtime]]', '[[regtime]]'),
(3079, 'english', 'Sublevels', '2015-09-30 15:32:39', 3079, '[[regtime]]', '[[regtime]]'),
(3080, 'english', 'Input field for username recovering', '2023-10-12 10:29:58', 3080, '[[regtime]]', '[[regtime]]'),
(3081, 'english', 'Input field for password recovering', '2023-10-12 10:29:58', 3081, '[[regtime]]', '[[regtime]]'),
(3082, 'english', 'Close profile slider', '2023-10-12 10:29:58', 3082, '[[regtime]]', '[[regtime]]'),
(3083, 'english', 'Create a folder', '2023-10-12 10:29:58', 3083, '[[regtime]]', '[[regtime]]'),
(3084, 'english', 'Rename folder', '2023-10-12 10:29:58', 3084, '[[regtime]]', '[[regtime]]'),
(3085, 'english', 'Rename folder', '2023-10-12 10:29:58', 3085, '[[regtime]]', '[[regtime]]'),
(3086, 'english', 'Disable high contrast colors', '2023-10-12 10:29:58', 3086, '[[regtime]]', '[[regtime]]'),
(3087, 'english', 'Enable high contrast colors', '2023-10-12 10:29:58', 3087, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_mail_configs`
--

CREATE TABLE `core_mail_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `system` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `core_mail_configs`
--

INSERT INTO `core_mail_configs` VALUES
(1, 'DEFAULT', 1);

-- --------------------------------------------------------

--
-- Table structure for table `core_mail_configs_fields`
--

CREATE TABLE `core_mail_configs_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mailConfigId` int(11) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `core_mail_configs_fields`
--

INSERT INTO `core_mail_configs_fields` VALUES
(1, 1, 'helper_desk_mail', ''),
(2, 1, 'helper_desk_name', ''),
(3, 1, 'helper_desk_subject', ''),
(4, 1, 'sender_mail_system', 'sample@localhost.localdomain'),
(5, 1, 'sender_name_system', ''),
(6, 1, 'sender_cc_mails', ''),
(7, 1, 'sender_ccn_mails', ''),
(8, 1, 'sender_mail_notification', 'sample@localhost.localdomain'),
(9, 1, 'sender_name_notification', '');

-- --------------------------------------------------------

--
-- Table structure for table `core_menu`
--

CREATE TABLE `core_menu` (
  `idMenu` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `is_active` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'true',
  `collapse` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'true',
  `idParent` int(11) DEFAULT NULL,
  `idPlugin` int(11) DEFAULT NULL,
  `of_platform` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'framework',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idMenu`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=608 ;

--
-- Dumping data for table `core_menu`
--

INSERT INTO `core_menu` VALUES
(1, '_USER_MANAGMENT', '<i class="fa fa-users fa-fw"></i>', 1, 'true', 'true', NULL, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(2, '_FIRST_LINE_lms', ' <i class="fa fa-graduation-cap" aria-hidden="true"></i>', 2, 'true', 'true', NULL, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(3, '_CONTENTS', '<i class="fa fa-clipboard fa-fw"></i>', 3, 'true', 'true', NULL, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(4, '_REPORT', '<i class="fa fa-bar-chart-o fa-fw"></i>', 4, 'true', 'true', NULL, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(5, '_CONFIGURATION', '<i class="fa fa-cogs fa-fw"></i>', 5, 'true', 'true', NULL, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(11, '_LISTUSER', '', 1, 'true', 'true', 1, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(12, '_MANAGE_GROUPS', '', 2, 'true', 'true', 1, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(13, '_COMPETENCES', '', 3, 'true', 'true', 1, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(14, '_FUNCTIONAL_ROLE', '', 4, 'true', 'true', 1, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(15, '_ADMINISTRATORS', '', 5, 'true', 'true', 1, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(21, '_COURSES', '', 1, 'true', 'true', 2, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(22, '_LOCATION', '', 2, 'true', 'true', 2, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(23, '_CONTEST', '', 3, 'true', 'true', 2, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(24, '_MAN_CERTIFICATE', '', 4, 'true', 'true', 2, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(25, '_MANAGEMENT_RESERVATION', '', 5, 'true', 'true', 2, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(26, '_CONTENT_LIBRARY', '', 6, 'true', 'true', 2, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(27, '_ENROLLRULES', '', 7, 'true', 'true', 2, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(28, '_TRANSACTION', '', 8, 'true', 'true', 2, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(31, '_WEBPAGES', '', 1, 'true', 'true', 3, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(33, '_NEWS_INTERNAL', '', 3, 'true', 'true', 3, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(34, '_MANAGEMENT_COMMUNICATION', '', 4, 'true', 'true', 3, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(35, '_NEWSLETTER', '', 5, 'true', 'true', 3, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(40, '_REPORT', '', 1, 'true', 'true', 4, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(50, '_FIELD_MANAGER', '', 4, 'true', 'true', 5, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(51, '_DASHBOARD', '', 1, 'true', 'true', 5, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(52, '_CONFIG_SYS', '', 2, 'true', 'true', 5, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(54, '_PLUGIN_MANAGER', '', 4, 'true', 'true', 5, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(55, '_LANG', '', 5, 'true', 'true', 5, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(59, '_CONFIG_ELEARNING', '', 3, 'true', 'true', 5, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(151, '_ADMIN_RULES', '', 1, 'true', 'true', 15, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(152, '_ADMIN_MANAGER', '', 2, 'true', 'true', 15, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(211, '_COURSES', '', 1, 'true', 'true', 21, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(212, '_COURSEPATH', '', 2, 'true', 'true', 21, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(213, '_CATALOGUE', '', 3, 'true', 'true', 21, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(241, '_CERTIFICATE', '', 1, 'true', 'true', 24, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(242, '_META_CERTIFICATE', '', 2, 'true', 'true', 24, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(251, '_EVENTS', '', 1, 'true', 'true', 25, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(252, '_CATEGORY', '', 2, 'true', 'true', 25, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(253, '_RESERVATION', '', 3, 'true', 'true', 25, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(501, '_FIELD_MANAGER', '', 1, 'true', 'true', 50, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(502, '_CUSTOMFIELD_MANAGER', '', 2, 'true', 'true', 50, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(521, '_CONFIGURATION', '', 1, 'true', 'true', 52, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(523, '_EVENTMANAGER', '', 3, 'true', 'true', 52, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(524, '_IOTASK', '', 4, 'true', 'true', 52, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(526, '_PRIVACYPOLICIES', '', 6, 'true', 'true', 52, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(528, '_CODE', '', 8, 'true', 'true', 52, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(591, '_MAN_MENU', '', 1, 'true', 'true', 59, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(592, '_MIDDLE_AREA', '', 2, 'true', 'true', 59, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(593, '_QUESTCATEGORY', '', 3, 'true', 'true', 59, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(594, '_TIME_PERIODS', '', 4, 'true', 'true', 59, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(595, '_LABEL', '', 5, 'true', 'true', 59, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(596, '_MYCOURSES', '', 1, 'true', 'true', NULL, NULL, 'lms', '[[regtime]]', '[[regtime]]'),
(597, '_CATALOGUE', '', 2, 'false', 'true', NULL, NULL, 'lms', '[[regtime]]', '[[regtime]]'),
(598, '_PUBLIC_FORUM', '', 3, 'true', 'true', NULL, NULL, 'lms', '[[regtime]]', '[[regtime]]'),
(599, '_HELPDESK', '<span class="glyphicon glyphicon-question-sign top-menu__label"></span>', 1000, 'false', 'true', NULL, NULL, 'lms', '[[regtime]]', '[[regtime]]'),
(602, '_CATEGORIES', '', 1, 'true', 'true', 34, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(603, '_COMMUNICATION_MAN', '', 4, 'true', 'true', 34, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(604, '_DASHBOARD', '', 4, 'true', 'true', NULL, NULL, 'lms', '[[regtime]]', '[[regtime]]'),
(605, '_DASHBOARD_CONFIGURATION', '', 4, 'true', 'true', 5, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(606, '_MAIL_CONFIG', '', 1, 'true', 'true', 52, NULL, 'framework', '[[regtime]]', '[[regtime]]'),
(607, '_DOMAIN_CONFIG', '', 1, 'true', 'true', 52, NULL, 'framework', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_menu_under`
--

CREATE TABLE `core_menu_under` (
  `idUnder` int(11) NOT NULL AUTO_INCREMENT,
  `idMenu` int(11) NOT NULL,
  `module_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_op` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `associated_token` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `of_platform` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sequence` int(11) NOT NULL,
  `class_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `class_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mvc_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idUnder`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=608 ;

--
-- Dumping data for table `core_menu_under`
--

INSERT INTO `core_menu_under` VALUES
(11, 11, 'usermanagement', '_LISTUSER', '', 'view', 'framework', 1, '', '', 'adm/usermanagement/show', '[[regtime]]', '[[regtime]]'),
(12, 12, 'groupmanagement', '_MANAGE_GROUPS', '', 'view', 'framework', 1, '', '', 'adm/groupmanagement/show', '[[regtime]]', '[[regtime]]'),
(13, 13, 'competences', '_COMPETENCES', '', 'view', 'framework', 1, '', '', 'adm/competences/show', '[[regtime]]', '[[regtime]]'),
(14, 14, 'functionalroles', '_FUNCTIONAL_ROLE', '', 'view', 'framework', 4, '', '', 'adm/functionalroles/show', '[[regtime]]', '[[regtime]]'),
(22, 22, 'location', '_LOCATION', '', 'view', 'alms', 2, '', '', 'alms/location/show', '[[regtime]]', '[[regtime]]'),
(23, 23, 'games', '_CONTEST', '', 'view', 'alms', 3, '', '', 'alms/games/show', '[[regtime]]', '[[regtime]]'),
(26, 26, 'kb', '_CONTENT_LIBRARY', '', 'view', 'alms', 6, '', '', 'alms/kb/show', '[[regtime]]', '[[regtime]]'),
(27, 27, 'enrollrules', '_ENROLLRULES', '', 'view', 'alms', 7, '', '', 'alms/enrollrules/show', '[[regtime]]', '[[regtime]]'),
(28, 28, 'transaction', '_TRANSACTION', '', 'view', 'alms', 8, '', '', 'alms/transaction/show', '[[regtime]]', '[[regtime]]'),
(31, 31, 'webpages', '_WEBPAGES', 'webpages', 'view', 'alms', 1, 'class.webpages.php', 'Module_Webpages', '', '[[regtime]]', '[[regtime]]'),
(32, 32, 'news', '_NEWS', 'news', 'view', 'alms', 2, 'class.news.php', 'Module_News', '', '[[regtime]]', '[[regtime]]'),
(33, 33, 'internal_news', '_NEWS_INTERNAL', 'news', 'view', 'alms', 3, 'class.internal_news.php', 'Module_Internal_News', '', '[[regtime]]', '[[regtime]]'),
(34, 603, 'communication', '_COMMUNICATION_MAN', '', 'view', 'alms', 1, '', '', 'alms/communication/show', '[[regtime]]', '[[regtime]]'),
(35, 35, 'newsletter', '_NEWSLETTER', 'newsletter', 'view', 'framework', 1, 'class.newsletter.php', 'Module_Newsletter', '', '[[regtime]]', '[[regtime]]'),
(40, 40, 'report', '_REPORT', 'reportlist', 'view', 'alms', 1, 'class.report.php', 'Module_Report', '', '[[regtime]]', '[[regtime]]'),
(51, 51, 'dashboard', '_DASHBOARD', '', 'view', 'framework', 1, '', '', 'adm/dashboard/show', '[[regtime]]', '[[regtime]]'),
(54, 54, 'pluginmanager', '_PLUGIN_MANAGER', '', 'view', 'framework', 4, '', '', 'adm/pluginmanager/show', '[[regtime]]', '[[regtime]]'),
(55, 55, 'lang', '_LANG', '', 'view', 'framework', 5, '', '', 'adm/lang/show', '[[regtime]]', '[[regtime]]'),
(151, 151, 'adminrules', '_ADMIN_RULES', '', 'view', 'framework', 1, '', '', 'adm/adminrules/show', '[[regtime]]', '[[regtime]]'),
(152, 152, 'adminmanager', '_ADMIN_MANAGER', '', 'view', 'framework', 1, '', '', 'adm/adminmanager/show', '[[regtime]]', '[[regtime]]'),
(211, 211, 'course', '_COURSES', '', 'view', 'alms', 1, '', '', 'alms/course/show', '[[regtime]]', '[[regtime]]'),
(212, 212, 'coursepath', '_COURSEPATH', 'pathlist', 'view', 'alms', 2, 'class.coursepath.php', 'Module_Coursepath', '', '[[regtime]]', '[[regtime]]'),
(213, 213, 'catalogue', '_CATALOGUE', 'catlist', 'view', 'alms', 3, 'class.catalogue.php', 'Module_Catalogue', '', '[[regtime]]', '[[regtime]]'),
(241, 241, 'certificate', '_CERTIFICATE', 'certificate', 'mod', 'alms', 1, 'class.certificate.php', 'Module_Certificate', '', '[[regtime]]', '[[regtime]]'),
(242, 242, 'aggregated_certificate', '_AGGREGATED_CERTIFICATE', '', 'view', 'alms', 2, '', '', 'alms/aggregatedcertificate/show', '[[regtime]]', '[[regtime]]'),
(251, 251, 'reservation', '_EVENTS', 'view_event', 'view', 'alms', 1, 'class.reservation.php', 'Module_Reservation', '', '[[regtime]]', '[[regtime]]'),
(252, 252, 'reservation', '_CATEGORY', 'view_category', 'view', 'alms', 2, 'class.reservation.php', 'Module_Reservation', '', '[[regtime]]', '[[regtime]]'),
(253, 253, 'reservation', '_RESERVATION', 'view_registration', 'view', 'alms', 3, 'class.reservation.php', 'Module_Reservation', '', '[[regtime]]', '[[regtime]]'),
(501, 501, 'field_manager', '_FIELD_MANAGER', 'field_list', 'view', 'framework', 1, 'class.field_manager.php', 'Module_Field_Manager', '', '[[regtime]]', '[[regtime]]'),
(502, 502, 'customfield_manager', '_CUSTOMFIELD_MANAGER', 'field_list', 'view', 'framework', 2, 'class.customfield_manager.php', 'Module_Customfield_Manager', '', '[[regtime]]', '[[regtime]]'),
(521, 521, 'setting', '_CONFIGURATION', '', 'view', 'framework', 1, 'class.configuration.php', 'Module_Configuration', 'adm/setting/show', '[[regtime]]', '[[regtime]]'),
(523, 523, 'event_manager', '_EVENTMANAGER', 'display', 'view_event_manager', 'framework', 3, 'class.event_manager.php', 'Module_Event_Manager', '', '[[regtime]]', '[[regtime]]'),
(524, 524, 'iotask', '_IOTASK', 'iotask', 'view', 'framework', 4, 'class.iotask.php', 'Module_IOTask', '', '[[regtime]]', '[[regtime]]'),
(526, 526, 'privacypolicy', '_PRIVACYPOLICIES', '', 'view', 'framework', 6, '', '', 'adm/privacypolicy/show', '[[regtime]]', '[[regtime]]'),
(528, 528, 'code', '_CODE', 'list', 'view', 'framework', 8, 'class.code.php', 'Module_Code', '', '[[regtime]]', '[[regtime]]'),
(591, 591, 'amanmenu', '_MAN_MENU', 'mancustom', 'view', 'alms', 1, 'class.amanmenu.php', 'Module_AManmenu', '', '[[regtime]]', '[[regtime]]'),
(592, 592, 'middlearea', '_MIDDLE_AREA', 'view_area', 'view', 'alms', 2, 'class.middlearea.php', 'Module_MiddleArea', '', '[[regtime]]', '[[regtime]]'),
(593, 593, 'questcategory', '_QUESTCATEGORY', '', 'view', 'alms', 3, '', '', 'alms/questcategory/show', '[[regtime]]', '[[regtime]]'),
(594, 594, 'timeperiods', '_TIME_PERIODS', '', 'view', 'alms', 4, '', '', 'alms/timeperiods/show', '[[regtime]]', '[[regtime]]'),
(595, 595, 'label', '_LABEL', '', 'view', 'alms', 5, '', '', 'alms/label/show', '[[regtime]]', '[[regtime]]'),
(596, 596, 'course', '_MYCOURSES', NULL, 'view', 'lms', 1, NULL, NULL, 'lms/mycourses/show', '[[regtime]]', '[[regtime]]'),
(597, 597, 'coursecatalogue', '_CATALOGUE', NULL, 'view', 'lms', 2, NULL, NULL, 'lms/catalog/show', '[[regtime]]', '[[regtime]]'),
(598, 598, 'public_forum', '_PUBLIC_FORUM', 'forum', 'view', 'lms', 3, NULL, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(599, 599, 'helpdesk', '_HELPDESK', 'popup', 'view', 'lms', 1000, NULL, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(602, 602, 'communication', '_CATEGORIES', NULL, 'view', 'framework', 1, NULL, NULL, 'alms/communication/showCategories', '[[regtime]]', '[[regtime]]'),
(604, 604, 'dashboard', '_DASHBOARD', NULL, 'view', 'lms', 4, NULL, NULL, 'lms/dashboard/show', '[[regtime]]', '[[regtime]]'),
(605, 605, 'dashboardsettings', '_DASHBOARD_CONFIGURATION', '', 'view', 'framework', 1, '', '', 'adm/dashboardsettings/show', '[[regtime]]', '[[regtime]]'),
(606, 606, 'mailconfig', '_MAIL_CONFIG', NULL, 'view', 'framework', 1, NULL, NULL, 'adm/mailconfig/show', '[[regtime]]', '[[regtime]]'),
(607, 607, 'domainconfig', '_DOMAIN_CONFIG', NULL, 'view', 'framework', 1, NULL, NULL, 'adm/domainconfig/show', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_message`
--

CREATE TABLE `core_message` (
  `idMessage` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL,
  `sender` int(11) NOT NULL,
  `posted` datetime DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `textof` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attach` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idMessage`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_message_user`
--

CREATE TABLE `core_message_user` (
  `idMessage` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `idCourse` int(11) NOT NULL,
  `read` tinyint(1) NOT NULL,
  `deleted` tinyint(1) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_message_idx` (`idMessage`),
  KEY `id_user_idx` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_migration_versions`
--

CREATE TABLE `core_migration_versions` (
  `version` varchar(767) COLLATE utf8_unicode_ci NOT NULL,
  `executed_at` datetime DEFAULT NULL,
  `execution_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `core_migration_versions`
--

INSERT INTO `core_migration_versions` VALUES
('Formalms\\Migrations\\Version20220815000001', '[[regtime]]', 3379),
('Formalms\\Migrations\\Version20220815000002', '[[regtime]]', 1238),
('Formalms\\Migrations\\Version20220815000003', '[[regtime]]', 53),
('Formalms\\Migrations\\Version20221012000004', '[[regtime]]', 0),
('Formalms\\Migrations\\Version20221012000014', '[[regtime]]', 4949),
('Formalms\\Migrations\\Version20221012000024', '[[regtime]]', 2327),
('Formalms\\Migrations\\Version20221012000034', '[[regtime]]', 19),
('Formalms\\Migrations\\Version20221012000044', '[[regtime]]', 218),
('Formalms\\Migrations\\Version20221012000054', '[[regtime]]', 3229),
('Formalms\\Migrations\\Version20221012000064', '[[regtime]]', 1364),
('Formalms\\Migrations\\Version20221012000074', '[[regtime]]', 2152),
('Formalms\\Migrations\\Version20221012000084', '[[regtime]]', 6212),
('Formalms\\Migrations\\Version20230518000005', '[[regtime]]', 159),
('Formalms\\Migrations\\Version20230726000006', '[[regtime]]', 5658),
('Formalms\\Migrations\\Version20231013000007', '[[regtime]]', 598),
('Formalms\\Migrations\\Version20231023000008', '[[regtime]]', 0),
('Formalms\\Migrations\\Version20231024000009', '[[regtime]]', 1),
('Formalms\\Migrations\\Version20231117000010', '[[regtime]]', 0),
('Formalms\\Migrations\\Version20240115000011', '[[regtime]]', 0),
('Formalms\\Migrations\\Version20240212000012', '[[regtime]]', 1),
('Formalms\\Migrations\\Version20240215000013', '[[regtime]]', 136),
('Formalms\\Migrations\\Version20240228000014', '[[regtime]]', 2),
('Formalms\\Migrations\\Version20240301000015', '[[regtime]]', 0),
('Formalms\\Migrations\\Version20240305000016', '[[regtime]]', 9),
('Formalms\\Migrations\\Version20240416000017', '[[regtime]]', 2),
('Formalms\\Migrations\\Version20240502000019', '[[regtime]]', 0),
('Formalms\\Migrations\\Version20240521000020', '[[regtime]]', 6),
('Formalms\\Migrations\\Version20240522162433', '[[regtime]]', 158),
('Formalms\\Migrations\\Version20240923151023', '[[regtime]]', 0);

-- --------------------------------------------------------

--
-- Table structure for table `core_newsletter`
--

CREATE TABLE `core_newsletter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_send` int(11) NOT NULL,
  `sub` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `msg` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fromemail` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tot` int(11) NOT NULL,
  `send_type` enum('email','sms') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'email',
  `stime` datetime DEFAULT NULL,
  `file` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_newsletter_sendto`
--

CREATE TABLE `core_newsletter_sendto` (
  `id_send` int(11) NOT NULL,
  `idst` int(11) NOT NULL,
  `stime` datetime DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_send_idx` (`id_send`),
  KEY `idst_idx` (`idst`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_org_chart`
--

CREATE TABLE `core_org_chart` (
  `id_dir` int(11) NOT NULL,
  `lang_code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_dir_idx` (`id_dir`),
  KEY `lang_code_idx` (`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_org_chart_field`
--

CREATE TABLE `core_org_chart_field` (
  `idst` int(11) NOT NULL,
  `id_field` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mandatory` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'false',
  `useraccess` enum('readonly','readwrite','noaccess') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'readonly',
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idst_idx` (`idst`),
  KEY `id_field_idx` (`id_field`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_org_chart_fieldentry`
--

CREATE TABLE `core_org_chart_fieldentry` (
  `id_common` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_common_son` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `user_entry` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_common_idx` (`id_common`),
  KEY `id_common_son_idx` (`id_common_son`),
  KEY `id_user_idx` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_org_chart_tree`
--

CREATE TABLE `core_org_chart_tree` (
  `idOrg` int(11) NOT NULL AUTO_INCREMENT,
  `idParent` int(11) NOT NULL,
  `path` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `lev` int(11) NOT NULL,
  `iLeft` int(11) NOT NULL,
  `iRight` int(11) NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idst_oc` int(11) NOT NULL,
  `idst_ocd` int(11) NOT NULL,
  `associated_policy` int(11) unsigned DEFAULT NULL,
  `associated_template` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idOrg`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_password_history`
--

CREATE TABLE `core_password_history` (
  `idst_user` int(11) NOT NULL,
  `pwd_date` datetime DEFAULT NULL,
  `passw` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `changed_by` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `pwd_date` (`pwd_date`),
  KEY `idst_user_idx` (`idst_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_platform`
--

CREATE TABLE `core_platform` (
  `platform` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_file_menu` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name_menu` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name_menu_managment` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_class_config` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name_config` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `var_default_template` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_default_admin` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `is_active` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'true',
  `mandatory` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'true',
  `dependencies` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `main` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'true',
  `hidden_in_config` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'false',
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `platform_idx` (`platform`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `core_platform`
--

INSERT INTO `core_platform` VALUES
('framework', '', '', 'class.admin_menu_fw.php', 'Admin_Framework', 'Admin_Managment_Framework', 'class.conf_fw.php', 'Config_Framework', 'defaultTemplate', 'Module', 1, 'true', 'true', '', 'false', 'false', 1, '[[regtime]]', '[[regtime]]'),
('lms', '', '', 'class.admin_menu_lms.php', 'Admin_Lms', 'Admin_Managment_Lms', 'class.conf_lms.php', 'Config_Lms', 'defaultTemplate', 'LmsAdminModule', 2, 'true', 'false', '', 'true', 'false', 2, '[[regtime]]', '[[regtime]]'),
('scs', '', '', 'class.admin_menu_scs.php', 'Admin_Scs', '', 'class.conf_scs.php', 'Config_Scs', 'defaultTemplate', 'ScsAdminModule', 4, 'true', 'false', '', 'false', 'false', 3, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_plugin`
--

CREATE TABLE `core_plugin` (
  `plugin_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int(5) NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `regroup` int(11) NOT NULL,
  `active` int(1) NOT NULL,
  `core` int(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`plugin_id`),
  UNIQUE KEY `name` (`name`),
  KEY `active_idx` (`active`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `core_plugin`
--

INSERT INTO `core_plugin` VALUES
(1, 'FormaAuth', 'Forma Auth', '', '1.0', 'Joint Technologies', '', 0, 'forma auth', 0, 1, 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_privacypolicy`
--

CREATE TABLE `core_privacypolicy` (
  `id_policy` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` int(11) NOT NULL,
  `lastedit_date` datetime DEFAULT NULL,
  `validity_date` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_policy`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `core_privacypolicy`
--

INSERT INTO `core_privacypolicy` VALUES
(1, 'Default Privacy Policy', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_privacypolicy_lang`
--

CREATE TABLE `core_privacypolicy_lang` (
  `id_policy` int(10) unsigned NOT NULL,
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_policy_idx` (`id_policy`),
  KEY `lang_code_idx` (`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_privacypolicy_user`
--

CREATE TABLE `core_privacypolicy_user` (
  `id_policy` int(11) NOT NULL,
  `idst` int(11) NOT NULL,
  `accept_date` datetime DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `reject_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_pwd_recover`
--

CREATE TABLE `core_pwd_recover` (
  `idst_user` int(11) NOT NULL,
  `random_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request_date` datetime DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idst_user_idx` (`idst_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_reg_list`
--

CREATE TABLE `core_reg_list` (
  `region_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `region_desc` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_region` tinyint(1) NOT NULL,
  `browsercode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `region_id_idx` (`region_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `core_reg_list`
--

INSERT INTO `core_reg_list` VALUES
('england', 'english', 'england, usa, ...', 0, 'en-EN, en-US', 1, '[[regtime]]', '[[regtime]]'),
('italy', 'italian', 'Italia', 1, 'it', 2, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_reg_setting`
--

CREATE TABLE `core_reg_setting` (
  `region_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `val_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `region_id_idx` (`region_id`),
  KEY `val_name_idx` (`val_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `core_reg_setting`
--

INSERT INTO `core_reg_setting` VALUES
('england', 'custom_date_format', '', 1, '[[regtime]]', '[[regtime]]'),
('england', 'custom_time_format', '', 2, '[[regtime]]', '[[regtime]]'),
('england', 'date_format', 'd_m_Y', 3, '[[regtime]]', '[[regtime]]'),
('england', 'date_sep', '-', 4, '[[regtime]]', '[[regtime]]'),
('england', 'time_format', 'H_i', 5, '[[regtime]]', '[[regtime]]'),
('italy', 'custom_date_format', '', 6, '[[regtime]]', '[[regtime]]'),
('italy', 'custom_time_format', '', 7, '[[regtime]]', '[[regtime]]'),
('italy', 'date_format', 'd_m_Y', 8, '[[regtime]]', '[[regtime]]'),
('italy', 'date_sep', '-', 9, '[[regtime]]', '[[regtime]]'),
('italy', 'time_format', 'H_i', 10, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_requests`
--

CREATE TABLE `core_requests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `controller` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `plugin` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `app_name_idx` (`app`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_rest_authentication`
--

CREATE TABLE `core_rest_authentication` (
  `id_user` int(11) NOT NULL,
  `user_level` int(11) NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `generation_date` datetime DEFAULT NULL,
  `last_enter_date` datetime DEFAULT NULL,
  `expiry_date` datetime DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `token_idx` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_revision`
--

CREATE TABLE `core_revision` (
  `type` enum('wiki','faq') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'faq',
  `parent_id` int(11) NOT NULL,
  `version` int(11) NOT NULL,
  `sub_key` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` int(11) NOT NULL,
  `rev_date` datetime DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `parent_id_idx` (`parent_id`),
  KEY `version_idx` (`version`),
  KEY `sub_key_idx` (`sub_key`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_role`
--

CREATE TABLE `core_role` (
  `idst` int(11) NOT NULL,
  `roleid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `idPlugin` int(10) DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idPlugin_idx` (`idPlugin`),
  KEY `idst_idx` (`idst`),
  KEY `roleid_idx` (`roleid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci PACK_KEYS=0 AUTO_INCREMENT=180 ;

--
-- Dumping data for table `core_role`
--

INSERT INTO `core_role` VALUES
(7, '/framework/admin/adminmanager/mod', NULL, NULL, 1, '[[regtime]]', '[[regtime]]'),
(8, '/framework/admin/adminmanager/view', NULL, NULL, 2, '[[regtime]]', '[[regtime]]'),
(9, '/framework/admin/adminrules/view', NULL, NULL, 3, '[[regtime]]', '[[regtime]]'),
(10, '/framework/admin/dashboard/view', NULL, NULL, 4, '[[regtime]]', '[[regtime]]'),
(12, '/framework/admin/directory/approve_waiting_user', NULL, NULL, 5, '[[regtime]]', '[[regtime]]'),
(13, '/framework/admin/event_manager/view_event_manager', NULL, NULL, 6, '[[regtime]]', '[[regtime]]'),
(14, '/framework/admin/field_manager/add', NULL, NULL, 7, '[[regtime]]', '[[regtime]]'),
(15, '/framework/admin/field_manager/del', NULL, NULL, 8, '[[regtime]]', '[[regtime]]'),
(16, '/framework/admin/field_manager/mod', NULL, NULL, 9, '[[regtime]]', '[[regtime]]'),
(17, '/framework/admin/field_manager/view', NULL, NULL, 10, '[[regtime]]', '[[regtime]]'),
(18, '/framework/admin/groupmanagement/add', NULL, NULL, 11, '[[regtime]]', '[[regtime]]'),
(19, '/framework/admin/groupmanagement/associate_user', NULL, NULL, 12, '[[regtime]]', '[[regtime]]'),
(20, '/framework/admin/groupmanagement/del', NULL, NULL, 13, '[[regtime]]', '[[regtime]]'),
(21, '/framework/admin/groupmanagement/mod', NULL, NULL, 14, '[[regtime]]', '[[regtime]]'),
(22, '/framework/admin/groupmanagement/view', NULL, NULL, 15, '[[regtime]]', '[[regtime]]'),
(23, '/framework/admin/iotask/view', NULL, NULL, 16, '[[regtime]]', '[[regtime]]'),
(24, '/framework/admin/kb/mod', NULL, NULL, 17, '[[regtime]]', '[[regtime]]'),
(25, '/framework/admin/kb/view', NULL, NULL, 18, '[[regtime]]', '[[regtime]]'),
(26, '/framework/admin/lang/mod', NULL, NULL, 19, '[[regtime]]', '[[regtime]]'),
(27, '/framework/admin/lang/view', NULL, NULL, 20, '[[regtime]]', '[[regtime]]'),
(28, '/framework/admin/newsletter/view', NULL, NULL, 21, '[[regtime]]', '[[regtime]]'),
(31, '/framework/admin/usermanagement/add', NULL, NULL, 22, '[[regtime]]', '[[regtime]]'),
(32, '/framework/admin/usermanagement/approve_waiting_user', NULL, NULL, 23, '[[regtime]]', '[[regtime]]'),
(33, '/framework/admin/usermanagement/del', NULL, NULL, 24, '[[regtime]]', '[[regtime]]'),
(34, '/framework/admin/usermanagement/mod', NULL, NULL, 25, '[[regtime]]', '[[regtime]]'),
(35, '/framework/admin/usermanagement/view', NULL, NULL, 26, '[[regtime]]', '[[regtime]]'),
(36, '/lms/admin/amanmenu/mod', NULL, NULL, 27, '[[regtime]]', '[[regtime]]'),
(37, '/lms/admin/amanmenu/view', NULL, NULL, 28, '[[regtime]]', '[[regtime]]'),
(38, '/lms/admin/catalogue/mod', NULL, NULL, 29, '[[regtime]]', '[[regtime]]'),
(39, '/lms/admin/catalogue/view', NULL, NULL, 30, '[[regtime]]', '[[regtime]]'),
(40, '/lms/admin/certificate/mod', NULL, NULL, 31, '[[regtime]]', '[[regtime]]'),
(41, '/lms/admin/certificate/view', NULL, NULL, 32, '[[regtime]]', '[[regtime]]'),
(42, '/lms/admin/classroom/view', NULL, NULL, 33, '[[regtime]]', '[[regtime]]'),
(43, '/lms/admin/communication/mod', NULL, NULL, 34, '[[regtime]]', '[[regtime]]'),
(44, '/lms/admin/communication/view', NULL, NULL, 35, '[[regtime]]', '[[regtime]]'),
(45, '/lms/admin/course/add', NULL, NULL, 36, '[[regtime]]', '[[regtime]]'),
(46, '/lms/admin/course/del', NULL, NULL, 37, '[[regtime]]', '[[regtime]]'),
(47, '/lms/admin/course/mod', NULL, NULL, 38, '[[regtime]]', '[[regtime]]'),
(48, '/lms/admin/course/moderate', NULL, NULL, 39, '[[regtime]]', '[[regtime]]'),
(49, '/lms/admin/course/subscribe', NULL, NULL, 40, '[[regtime]]', '[[regtime]]'),
(50, '/lms/admin/course/view', NULL, NULL, 41, '[[regtime]]', '[[regtime]]'),
(51, '/lms/admin/coursepath/mod', NULL, NULL, 42, '[[regtime]]', '[[regtime]]'),
(52, '/lms/admin/coursepath/moderate', NULL, NULL, 43, '[[regtime]]', '[[regtime]]'),
(53, '/lms/admin/coursepath/subscribe', NULL, NULL, 44, '[[regtime]]', '[[regtime]]'),
(54, '/lms/admin/coursepath/view', NULL, NULL, 45, '[[regtime]]', '[[regtime]]'),
(55, '/lms/admin/enrollrules/view', NULL, NULL, 46, '[[regtime]]', '[[regtime]]'),
(56, '/lms/admin/games/mod', NULL, NULL, 47, '[[regtime]]', '[[regtime]]'),
(57, '/lms/admin/games/subscribe', NULL, NULL, 48, '[[regtime]]', '[[regtime]]'),
(58, '/lms/admin/games/view', NULL, NULL, 49, '[[regtime]]', '[[regtime]]'),
(59, '/lms/admin/internal_news/mod', NULL, NULL, 50, '[[regtime]]', '[[regtime]]'),
(60, '/lms/admin/internal_news/view', NULL, NULL, 51, '[[regtime]]', '[[regtime]]'),
(61, '/lms/admin/kb/view', NULL, NULL, 52, '[[regtime]]', '[[regtime]]'),
(62, '/lms/admin/label/view', NULL, NULL, 53, '[[regtime]]', '[[regtime]]'),
(63, '/lms/admin/middlearea/view', NULL, NULL, 54, '[[regtime]]', '[[regtime]]'),
(64, '/lms/admin/news/mod', NULL, NULL, 55, '[[regtime]]', '[[regtime]]'),
(65, '/lms/admin/news/view', NULL, NULL, 56, '[[regtime]]', '[[regtime]]'),
(66, '/lms/admin/preassessment/mod', NULL, NULL, 57, '[[regtime]]', '[[regtime]]'),
(67, '/lms/admin/preassessment/subscribe', NULL, NULL, 58, '[[regtime]]', '[[regtime]]'),
(68, '/lms/admin/preassessment/view', NULL, NULL, 59, '[[regtime]]', '[[regtime]]'),
(69, '/lms/admin/questcategory/mod', NULL, NULL, 60, '[[regtime]]', '[[regtime]]'),
(70, '/lms/admin/questcategory/view', NULL, NULL, 61, '[[regtime]]', '[[regtime]]'),
(71, '/lms/admin/report/mod', NULL, NULL, 62, '[[regtime]]', '[[regtime]]'),
(72, '/lms/admin/report/view', NULL, NULL, 63, '[[regtime]]', '[[regtime]]'),
(73, '/lms/admin/reservation/mod', NULL, NULL, 64, '[[regtime]]', '[[regtime]]'),
(74, '/lms/admin/reservation/view', NULL, NULL, 65, '[[regtime]]', '[[regtime]]'),
(75, '/lms/admin/timeperiods/mod', NULL, NULL, 66, '[[regtime]]', '[[regtime]]'),
(76, '/lms/admin/timeperiods/view', NULL, NULL, 67, '[[regtime]]', '[[regtime]]'),
(77, '/lms/admin/transaction/view', NULL, NULL, 68, '[[regtime]]', '[[regtime]]'),
(78, '/lms/admin/webpages/mod', NULL, NULL, 69, '[[regtime]]', '[[regtime]]'),
(79, '/lms/admin/webpages/view', NULL, NULL, 70, '[[regtime]]', '[[regtime]]'),
(80, '/lms/course/public/course/view', NULL, NULL, 71, '[[regtime]]', '[[regtime]]'),
(81, '/lms/course/public/course_autoregistration/view', NULL, NULL, 72, '[[regtime]]', '[[regtime]]'),
(82, '/lms/course/public/coursecatalogue/view', NULL, NULL, 73, '[[regtime]]', '[[regtime]]'),
(83, '/lms/course/public/message/send_all', NULL, NULL, 74, '[[regtime]]', '[[regtime]]'),
(84, '/lms/course/public/message/view', NULL, NULL, 75, '[[regtime]]', '[[regtime]]'),
(85, '/lms/course/public/mycertificate/view', NULL, NULL, 76, '[[regtime]]', '[[regtime]]'),
(86, '/lms/course/public/mycompetences/view', NULL, NULL, 77, '[[regtime]]', '[[regtime]]'),
(87, '/lms/course/public/mygroup/view', NULL, NULL, 78, '[[regtime]]', '[[regtime]]'),
(88, '/lms/course/public/profile/mod', NULL, NULL, 79, '[[regtime]]', '[[regtime]]'),
(89, '/lms/course/public/profile/view', NULL, NULL, 80, '[[regtime]]', '[[regtime]]'),
(90, '/lms/course/public/tprofile/view', NULL, NULL, 81, '[[regtime]]', '[[regtime]]'),
(91, '/lms/course/public/public_forum/view', NULL, NULL, 82, '[[regtime]]', '[[regtime]]'),
(92, '/lms/course/public/public_forum/add', NULL, NULL, 83, '[[regtime]]', '[[regtime]]'),
(93, '/lms/course/public/public_forum/del', NULL, NULL, 84, '[[regtime]]', '[[regtime]]'),
(94, '/lms/course/public/public_forum/mod', NULL, NULL, 85, '[[regtime]]', '[[regtime]]'),
(95, '/lms/course/public/public_forum/moderate', NULL, NULL, 86, '[[regtime]]', '[[regtime]]'),
(96, '/lms/course/public/public_forum/upload', NULL, NULL, 87, '[[regtime]]', '[[regtime]]'),
(97, '/lms/course/public/public_forum/write', NULL, NULL, 88, '[[regtime]]', '[[regtime]]'),
(111, '/framework/admin/functionalroles/view', NULL, NULL, 89, '[[regtime]]', '[[regtime]]'),
(112, '/framework/admin/functionalroles/mod', NULL, NULL, 90, '[[regtime]]', '[[regtime]]'),
(113, '/framework/admin/functionalroles/associate_user', NULL, NULL, 91, '[[regtime]]', '[[regtime]]'),
(114, '/framework/admin/competences/view', NULL, NULL, 92, '[[regtime]]', '[[regtime]]'),
(115, '/framework/admin/competences/mod', NULL, NULL, 93, '[[regtime]]', '[[regtime]]'),
(116, '/framework/admin/competences/associate_user', NULL, NULL, 94, '[[regtime]]', '[[regtime]]'),
(118, '/framework/admin/code/view', NULL, NULL, 95, '[[regtime]]', '[[regtime]]'),
(119, '/framework/admin/setting/view', NULL, NULL, 96, '[[regtime]]', '[[regtime]]'),
(120, '/lms/admin/meta_certificate/view', NULL, NULL, 97, '[[regtime]]', '[[regtime]]'),
(121, '/lms/admin/meta_certificate/mod', NULL, NULL, 98, '[[regtime]]', '[[regtime]]'),
(122, '/framework/admin/usermanagement/mod_org', NULL, NULL, 99, '[[regtime]]', '[[regtime]]'),
(175, '/lms/course/private/advice/mod', NULL, NULL, 100, '[[regtime]]', '[[regtime]]'),
(176, '/lms/course/private/advice/view', NULL, NULL, 101, '[[regtime]]', '[[regtime]]'),
(177, '/lms/course/private/calendar/mod', NULL, NULL, 102, '[[regtime]]', '[[regtime]]'),
(178, '/lms/course/private/calendar/personal', NULL, NULL, 103, '[[regtime]]', '[[regtime]]'),
(179, '/lms/course/private/calendar/view', NULL, NULL, 104, '[[regtime]]', '[[regtime]]'),
(181, '/lms/course/private/conference/mod', NULL, NULL, 105, '[[regtime]]', '[[regtime]]'),
(182, '/lms/course/private/conference/view', NULL, NULL, 106, '[[regtime]]', '[[regtime]]'),
(183, '/lms/course/private/course/mod', NULL, NULL, 107, '[[regtime]]', '[[regtime]]'),
(184, '/lms/course/private/course/view', NULL, NULL, 108, '[[regtime]]', '[[regtime]]'),
(185, '/lms/course/private/course/view_info', NULL, NULL, 109, '[[regtime]]', '[[regtime]]'),
(186, '/lms/course/private/coursereport/mod', NULL, NULL, 110, '[[regtime]]', '[[regtime]]'),
(187, '/lms/course/private/coursereport/view', NULL, NULL, 111, '[[regtime]]', '[[regtime]]'),
(188, '/lms/course/private/forum/add', NULL, NULL, 112, '[[regtime]]', '[[regtime]]'),
(189, '/lms/course/private/forum/del', NULL, NULL, 113, '[[regtime]]', '[[regtime]]'),
(190, '/lms/course/private/forum/mod', NULL, NULL, 114, '[[regtime]]', '[[regtime]]'),
(191, '/lms/course/private/forum/moderate', NULL, NULL, 115, '[[regtime]]', '[[regtime]]'),
(192, '/lms/course/private/forum/upload', NULL, NULL, 116, '[[regtime]]', '[[regtime]]'),
(193, '/lms/course/private/forum/view', NULL, NULL, 117, '[[regtime]]', '[[regtime]]'),
(194, '/lms/course/private/forum/write', NULL, NULL, 118, '[[regtime]]', '[[regtime]]'),
(195, '/lms/course/private/gradebook/view', NULL, NULL, 119, '[[regtime]]', '[[regtime]]'),
(196, '/lms/course/private/groups/mod', NULL, NULL, 120, '[[regtime]]', '[[regtime]]'),
(197, '/lms/course/private/groups/subscribe', NULL, NULL, 121, '[[regtime]]', '[[regtime]]'),
(198, '/lms/course/private/groups/view', NULL, NULL, 122, '[[regtime]]', '[[regtime]]'),
(199, '/lms/course/private/htmlfront/mod', NULL, NULL, 123, '[[regtime]]', '[[regtime]]'),
(200, '/lms/course/private/htmlfront/view', NULL, NULL, 124, '[[regtime]]', '[[regtime]]'),
(201, '/lms/course/private/light_repo/mod', NULL, NULL, 125, '[[regtime]]', '[[regtime]]'),
(202, '/lms/course/private/light_repo/view', NULL, NULL, 126, '[[regtime]]', '[[regtime]]'),
(203, '/lms/course/private/manmenu/mod', NULL, NULL, 127, '[[regtime]]', '[[regtime]]'),
(204, '/lms/course/private/manmenu/view', NULL, NULL, 128, '[[regtime]]', '[[regtime]]'),
(205, '/lms/course/private/newsletter/view', NULL, NULL, 129, '[[regtime]]', '[[regtime]]'),
(206, '/lms/course/private/notes/view', NULL, NULL, 130, '[[regtime]]', '[[regtime]]'),
(207, '/lms/course/private/organization/view', NULL, NULL, 131, '[[regtime]]', '[[regtime]]'),
(208, '/lms/course/private/project/add', NULL, NULL, 132, '[[regtime]]', '[[regtime]]'),
(209, '/lms/course/private/project/del', NULL, NULL, 133, '[[regtime]]', '[[regtime]]'),
(210, '/lms/course/private/project/mod', NULL, NULL, 134, '[[regtime]]', '[[regtime]]'),
(211, '/lms/course/private/project/view', NULL, NULL, 135, '[[regtime]]', '[[regtime]]'),
(212, '/lms/course/private/quest_bank/mod', NULL, NULL, 136, '[[regtime]]', '[[regtime]]'),
(213, '/lms/course/private/quest_bank/view', NULL, NULL, 137, '[[regtime]]', '[[regtime]]'),
(214, '/lms/course/private/reservation/mod', NULL, NULL, 138, '[[regtime]]', '[[regtime]]'),
(215, '/lms/course/private/reservation/view', NULL, NULL, 139, '[[regtime]]', '[[regtime]]'),
(216, '/lms/course/private/statistic/view', NULL, NULL, 140, '[[regtime]]', '[[regtime]]'),
(217, '/lms/course/private/stats/view_course', NULL, NULL, 141, '[[regtime]]', '[[regtime]]'),
(218, '/lms/course/private/stats/view_user', NULL, NULL, 142, '[[regtime]]', '[[regtime]]'),
(219, '/lms/course/private/storage/home', NULL, NULL, 143, '[[regtime]]', '[[regtime]]'),
(220, '/lms/course/private/storage/lesson', NULL, NULL, 144, '[[regtime]]', '[[regtime]]'),
(221, '/lms/course/private/storage/public', NULL, NULL, 145, '[[regtime]]', '[[regtime]]'),
(222, '/lms/course/private/storage/view', NULL, NULL, 146, '[[regtime]]', '[[regtime]]'),
(223, '/lms/course/private/wiki/admin', NULL, NULL, 147, '[[regtime]]', '[[regtime]]'),
(224, '/lms/course/private/wiki/edit', NULL, NULL, 148, '[[regtime]]', '[[regtime]]'),
(225, '/lms/course/private/wiki/view', NULL, NULL, 149, '[[regtime]]', '[[regtime]]'),
(226, '/lms/admin/location/view', NULL, NULL, 150, '[[regtime]]', '[[regtime]]'),
(227, '/lms/admin/location/mod', NULL, NULL, 151, '[[regtime]]', '[[regtime]]'),
(228, '/lms/admin/coursecategory/add', NULL, NULL, 152, '[[regtime]]', '[[regtime]]'),
(229, '/lms/admin/coursecategory/mod', NULL, NULL, 153, '[[regtime]]', '[[regtime]]'),
(230, '/lms/admin/coursecategory/del', NULL, NULL, 154, '[[regtime]]', '[[regtime]]'),
(231, '/framework/admin/usermanagement/add_org', NULL, NULL, 155, '[[regtime]]', '[[regtime]]'),
(232, '/framework/admin/usermanagement/mod_org', NULL, NULL, 156, '[[regtime]]', '[[regtime]]'),
(233, '/framework/admin/usermanagement/del_org', NULL, NULL, 157, '[[regtime]]', '[[regtime]]'),
(234, '/lms/course/private/light_repo/view_all', NULL, NULL, 158, '[[regtime]]', '[[regtime]]'),
(235, '/framework/admin/customfield_manager/view', NULL, NULL, 159, '[[regtime]]', '[[regtime]]'),
(236, '/framework/admin/customfield_manager/add', NULL, NULL, 160, '[[regtime]]', '[[regtime]]'),
(237, '/framework/admin/customfield_manager/mod', NULL, NULL, 161, '[[regtime]]', '[[regtime]]'),
(238, '/framework/admin/customfield_manager/del', NULL, NULL, 162, '[[regtime]]', '[[regtime]]'),
(280, '/framework/admin/pluginmanager/view', NULL, NULL, 163, '[[regtime]]', '[[regtime]]'),
(295, '/lms/course/private/statistic/view_all', NULL, NULL, 164, '[[regtime]]', '[[regtime]]'),
(296, '/lms/course/private/stats/view_all_statuser', NULL, NULL, 165, '[[regtime]]', '[[regtime]]'),
(297, '/lms/course/private/stats/view_all_statcourse', NULL, NULL, 166, '[[regtime]]', '[[regtime]]'),
(298, '/lms/course/private/coursestats/view_all', NULL, NULL, 167, '[[regtime]]', '[[regtime]]'),
(299, '/lms/course/private/coursereport/view_all', NULL, NULL, 168, '[[regtime]]', '[[regtime]]'),
(300, '/lms/course/public/helpdesk/view', NULL, NULL, 169, '[[regtime]]', '[[regtime]]'),
(11553, '/framework/admin/usermanagement/associate_user', NULL, NULL, 170, '[[regtime]]', '[[regtime]]'),
(11757, '/lms/course/private/coursestats/view', '', NULL, 171, '[[regtime]]', '[[regtime]]'),
(11835, '/lms/course/private/presence/view', '', NULL, 172, '[[regtime]]', '[[regtime]]'),
(11836, '/lms/admin/certificate/assign', NULL, NULL, 173, '[[regtime]]', '[[regtime]]'),
(11837, '/lms/admin/certificate/release', NULL, NULL, 174, '[[regtime]]', '[[regtime]]'),
(11838, '/lms/admin/report/schedule', NULL, NULL, 175, '[[regtime]]', '[[regtime]]'),
(11839, '/lms/course/public/dashboard/view', NULL, NULL, 176, '[[regtime]]', '[[regtime]]'),
(11840, '/framework/admin/privacypolicy/view', NULL, NULL, 177, '[[regtime]]', '[[regtime]]'),
(11841, '/framework/admin/privacypolicy/mod', NULL, NULL, 178, '[[regtime]]', '[[regtime]]'),
(11842, '/framework/admin/privacypolicy/del', NULL, NULL, 179, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_role_members`
--

CREATE TABLE `core_role_members` (
  `idst` int(11) NOT NULL,
  `idstMember` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idst_idx` (`idst`,`idstMember`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=459 ;

--
-- Dumping data for table `core_role_members`
--

INSERT INTO `core_role_members` VALUES
(7, 3, 1, '[[regtime]]', '[[regtime]]'),
(8, 3, 2, '[[regtime]]', '[[regtime]]'),
(9, 3, 3, '[[regtime]]', '[[regtime]]'),
(10, 3, 4, '[[regtime]]', '[[regtime]]'),
(12, 3, 5, '[[regtime]]', '[[regtime]]'),
(13, 3, 6, '[[regtime]]', '[[regtime]]'),
(14, 3, 7, '[[regtime]]', '[[regtime]]'),
(15, 3, 8, '[[regtime]]', '[[regtime]]'),
(16, 3, 9, '[[regtime]]', '[[regtime]]'),
(17, 3, 10, '[[regtime]]', '[[regtime]]'),
(18, 3, 11, '[[regtime]]', '[[regtime]]'),
(19, 3, 12, '[[regtime]]', '[[regtime]]'),
(20, 3, 13, '[[regtime]]', '[[regtime]]'),
(21, 3, 14, '[[regtime]]', '[[regtime]]'),
(22, 3, 15, '[[regtime]]', '[[regtime]]'),
(23, 3, 16, '[[regtime]]', '[[regtime]]'),
(24, 3, 17, '[[regtime]]', '[[regtime]]'),
(25, 3, 18, '[[regtime]]', '[[regtime]]'),
(26, 3, 19, '[[regtime]]', '[[regtime]]'),
(27, 3, 20, '[[regtime]]', '[[regtime]]'),
(28, 3, 21, '[[regtime]]', '[[regtime]]'),
(31, 3, 22, '[[regtime]]', '[[regtime]]'),
(32, 3, 23, '[[regtime]]', '[[regtime]]'),
(33, 3, 24, '[[regtime]]', '[[regtime]]'),
(34, 3, 25, '[[regtime]]', '[[regtime]]'),
(35, 3, 26, '[[regtime]]', '[[regtime]]'),
(36, 3, 27, '[[regtime]]', '[[regtime]]'),
(37, 3, 28, '[[regtime]]', '[[regtime]]'),
(38, 3, 29, '[[regtime]]', '[[regtime]]'),
(39, 3, 30, '[[regtime]]', '[[regtime]]'),
(40, 3, 31, '[[regtime]]', '[[regtime]]'),
(41, 3, 32, '[[regtime]]', '[[regtime]]'),
(42, 3, 33, '[[regtime]]', '[[regtime]]'),
(43, 3, 34, '[[regtime]]', '[[regtime]]'),
(44, 3, 35, '[[regtime]]', '[[regtime]]'),
(45, 3, 36, '[[regtime]]', '[[regtime]]'),
(46, 3, 37, '[[regtime]]', '[[regtime]]'),
(47, 3, 38, '[[regtime]]', '[[regtime]]'),
(48, 3, 39, '[[regtime]]', '[[regtime]]'),
(49, 3, 40, '[[regtime]]', '[[regtime]]'),
(50, 3, 41, '[[regtime]]', '[[regtime]]'),
(51, 3, 42, '[[regtime]]', '[[regtime]]'),
(52, 3, 43, '[[regtime]]', '[[regtime]]'),
(53, 3, 44, '[[regtime]]', '[[regtime]]'),
(54, 3, 45, '[[regtime]]', '[[regtime]]'),
(55, 3, 46, '[[regtime]]', '[[regtime]]'),
(56, 3, 47, '[[regtime]]', '[[regtime]]'),
(57, 3, 48, '[[regtime]]', '[[regtime]]'),
(58, 3, 49, '[[regtime]]', '[[regtime]]'),
(59, 3, 50, '[[regtime]]', '[[regtime]]'),
(60, 3, 51, '[[regtime]]', '[[regtime]]'),
(61, 3, 52, '[[regtime]]', '[[regtime]]'),
(62, 3, 53, '[[regtime]]', '[[regtime]]'),
(63, 3, 54, '[[regtime]]', '[[regtime]]'),
(64, 3, 55, '[[regtime]]', '[[regtime]]'),
(65, 3, 56, '[[regtime]]', '[[regtime]]'),
(66, 3, 57, '[[regtime]]', '[[regtime]]'),
(67, 3, 58, '[[regtime]]', '[[regtime]]'),
(68, 3, 59, '[[regtime]]', '[[regtime]]'),
(69, 3, 60, '[[regtime]]', '[[regtime]]'),
(70, 3, 61, '[[regtime]]', '[[regtime]]'),
(71, 3, 62, '[[regtime]]', '[[regtime]]'),
(72, 3, 63, '[[regtime]]', '[[regtime]]'),
(73, 3, 64, '[[regtime]]', '[[regtime]]'),
(74, 3, 65, '[[regtime]]', '[[regtime]]'),
(75, 3, 66, '[[regtime]]', '[[regtime]]'),
(76, 3, 67, '[[regtime]]', '[[regtime]]'),
(77, 3, 68, '[[regtime]]', '[[regtime]]'),
(78, 3, 69, '[[regtime]]', '[[regtime]]'),
(79, 3, 70, '[[regtime]]', '[[regtime]]'),
(80, 1, 71, '[[regtime]]', '[[regtime]]'),
(81, 1, 72, '[[regtime]]', '[[regtime]]'),
(82, 1, 73, '[[regtime]]', '[[regtime]]'),
(83, 1, 74, '[[regtime]]', '[[regtime]]'),
(84, 1, 75, '[[regtime]]', '[[regtime]]'),
(85, 1, 76, '[[regtime]]', '[[regtime]]'),
(86, 1, 77, '[[regtime]]', '[[regtime]]'),
(87, 1, 78, '[[regtime]]', '[[regtime]]'),
(88, 1, 79, '[[regtime]]', '[[regtime]]'),
(89, 1, 80, '[[regtime]]', '[[regtime]]'),
(90, 1, 81, '[[regtime]]', '[[regtime]]'),
(91, 1, 82, '[[regtime]]', '[[regtime]]'),
(92, 3, 83, '[[regtime]]', '[[regtime]]'),
(93, 3, 84, '[[regtime]]', '[[regtime]]'),
(94, 3, 85, '[[regtime]]', '[[regtime]]'),
(95, 3, 86, '[[regtime]]', '[[regtime]]'),
(96, 1, 87, '[[regtime]]', '[[regtime]]'),
(96, 3, 88, '[[regtime]]', '[[regtime]]'),
(97, 1, 89, '[[regtime]]', '[[regtime]]'),
(97, 3, 90, '[[regtime]]', '[[regtime]]'),
(111, 3, 91, '[[regtime]]', '[[regtime]]'),
(112, 3, 92, '[[regtime]]', '[[regtime]]'),
(113, 3, 93, '[[regtime]]', '[[regtime]]'),
(114, 3, 94, '[[regtime]]', '[[regtime]]'),
(115, 3, 95, '[[regtime]]', '[[regtime]]'),
(116, 3, 96, '[[regtime]]', '[[regtime]]'),
(118, 3, 97, '[[regtime]]', '[[regtime]]'),
(119, 3, 98, '[[regtime]]', '[[regtime]]'),
(120, 3, 99, '[[regtime]]', '[[regtime]]'),
(121, 3, 100, '[[regtime]]', '[[regtime]]'),
(122, 3, 101, '[[regtime]]', '[[regtime]]'),
(175, 301, 102, '[[regtime]]', '[[regtime]]'),
(175, 302, 103, '[[regtime]]', '[[regtime]]'),
(175, 303, 104, '[[regtime]]', '[[regtime]]'),
(175, 304, 105, '[[regtime]]', '[[regtime]]'),
(176, 301, 106, '[[regtime]]', '[[regtime]]'),
(176, 302, 107, '[[regtime]]', '[[regtime]]'),
(176, 303, 108, '[[regtime]]', '[[regtime]]'),
(176, 304, 109, '[[regtime]]', '[[regtime]]'),
(176, 305, 110, '[[regtime]]', '[[regtime]]'),
(176, 306, 111, '[[regtime]]', '[[regtime]]'),
(176, 307, 112, '[[regtime]]', '[[regtime]]'),
(177, 301, 113, '[[regtime]]', '[[regtime]]'),
(177, 302, 114, '[[regtime]]', '[[regtime]]'),
(177, 303, 115, '[[regtime]]', '[[regtime]]'),
(177, 304, 116, '[[regtime]]', '[[regtime]]'),
(178, 301, 117, '[[regtime]]', '[[regtime]]'),
(178, 302, 118, '[[regtime]]', '[[regtime]]'),
(178, 303, 119, '[[regtime]]', '[[regtime]]'),
(178, 304, 120, '[[regtime]]', '[[regtime]]'),
(179, 301, 121, '[[regtime]]', '[[regtime]]'),
(179, 302, 122, '[[regtime]]', '[[regtime]]'),
(179, 303, 123, '[[regtime]]', '[[regtime]]'),
(179, 304, 124, '[[regtime]]', '[[regtime]]'),
(179, 305, 125, '[[regtime]]', '[[regtime]]'),
(179, 306, 126, '[[regtime]]', '[[regtime]]'),
(179, 307, 127, '[[regtime]]', '[[regtime]]'),
(181, 301, 128, '[[regtime]]', '[[regtime]]'),
(181, 302, 129, '[[regtime]]', '[[regtime]]'),
(181, 303, 130, '[[regtime]]', '[[regtime]]'),
(181, 304, 131, '[[regtime]]', '[[regtime]]'),
(182, 301, 132, '[[regtime]]', '[[regtime]]'),
(182, 302, 133, '[[regtime]]', '[[regtime]]'),
(182, 303, 134, '[[regtime]]', '[[regtime]]'),
(182, 304, 135, '[[regtime]]', '[[regtime]]'),
(182, 305, 136, '[[regtime]]', '[[regtime]]'),
(182, 306, 137, '[[regtime]]', '[[regtime]]'),
(182, 307, 138, '[[regtime]]', '[[regtime]]'),
(183, 301, 139, '[[regtime]]', '[[regtime]]'),
(183, 302, 140, '[[regtime]]', '[[regtime]]'),
(183, 303, 141, '[[regtime]]', '[[regtime]]'),
(183, 304, 142, '[[regtime]]', '[[regtime]]'),
(185, 301, 143, '[[regtime]]', '[[regtime]]'),
(185, 302, 144, '[[regtime]]', '[[regtime]]'),
(185, 303, 145, '[[regtime]]', '[[regtime]]'),
(185, 304, 146, '[[regtime]]', '[[regtime]]'),
(185, 305, 147, '[[regtime]]', '[[regtime]]'),
(185, 306, 148, '[[regtime]]', '[[regtime]]'),
(185, 307, 149, '[[regtime]]', '[[regtime]]'),
(186, 301, 150, '[[regtime]]', '[[regtime]]'),
(186, 302, 151, '[[regtime]]', '[[regtime]]'),
(186, 303, 152, '[[regtime]]', '[[regtime]]'),
(186, 304, 153, '[[regtime]]', '[[regtime]]'),
(186, 10893, 154, '[[regtime]]', '[[regtime]]'),
(186, 10894, 155, '[[regtime]]', '[[regtime]]'),
(186, 10895, 156, '[[regtime]]', '[[regtime]]'),
(187, 301, 157, '[[regtime]]', '[[regtime]]'),
(187, 302, 158, '[[regtime]]', '[[regtime]]'),
(187, 303, 159, '[[regtime]]', '[[regtime]]'),
(187, 304, 160, '[[regtime]]', '[[regtime]]'),
(187, 10893, 161, '[[regtime]]', '[[regtime]]'),
(187, 10894, 162, '[[regtime]]', '[[regtime]]'),
(187, 10895, 163, '[[regtime]]', '[[regtime]]'),
(187, 10896, 164, '[[regtime]]', '[[regtime]]'),
(187, 10897, 165, '[[regtime]]', '[[regtime]]'),
(187, 10898, 166, '[[regtime]]', '[[regtime]]'),
(187, 10899, 167, '[[regtime]]', '[[regtime]]'),
(188, 301, 168, '[[regtime]]', '[[regtime]]'),
(188, 302, 169, '[[regtime]]', '[[regtime]]'),
(188, 303, 170, '[[regtime]]', '[[regtime]]'),
(188, 304, 171, '[[regtime]]', '[[regtime]]'),
(189, 301, 172, '[[regtime]]', '[[regtime]]'),
(189, 302, 173, '[[regtime]]', '[[regtime]]'),
(189, 303, 174, '[[regtime]]', '[[regtime]]'),
(189, 304, 175, '[[regtime]]', '[[regtime]]'),
(190, 301, 176, '[[regtime]]', '[[regtime]]'),
(190, 302, 177, '[[regtime]]', '[[regtime]]'),
(190, 303, 178, '[[regtime]]', '[[regtime]]'),
(190, 304, 179, '[[regtime]]', '[[regtime]]'),
(191, 301, 180, '[[regtime]]', '[[regtime]]'),
(191, 302, 181, '[[regtime]]', '[[regtime]]'),
(191, 303, 182, '[[regtime]]', '[[regtime]]'),
(191, 304, 183, '[[regtime]]', '[[regtime]]'),
(192, 301, 184, '[[regtime]]', '[[regtime]]'),
(192, 302, 185, '[[regtime]]', '[[regtime]]'),
(192, 303, 186, '[[regtime]]', '[[regtime]]'),
(192, 304, 187, '[[regtime]]', '[[regtime]]'),
(192, 305, 188, '[[regtime]]', '[[regtime]]'),
(193, 301, 189, '[[regtime]]', '[[regtime]]'),
(193, 302, 190, '[[regtime]]', '[[regtime]]'),
(193, 303, 191, '[[regtime]]', '[[regtime]]'),
(193, 304, 192, '[[regtime]]', '[[regtime]]'),
(193, 305, 193, '[[regtime]]', '[[regtime]]'),
(193, 306, 194, '[[regtime]]', '[[regtime]]'),
(193, 307, 195, '[[regtime]]', '[[regtime]]'),
(194, 301, 196, '[[regtime]]', '[[regtime]]'),
(194, 302, 197, '[[regtime]]', '[[regtime]]'),
(194, 303, 198, '[[regtime]]', '[[regtime]]'),
(194, 304, 199, '[[regtime]]', '[[regtime]]'),
(194, 305, 200, '[[regtime]]', '[[regtime]]'),
(195, 301, 201, '[[regtime]]', '[[regtime]]'),
(195, 302, 202, '[[regtime]]', '[[regtime]]'),
(195, 303, 203, '[[regtime]]', '[[regtime]]'),
(195, 304, 204, '[[regtime]]', '[[regtime]]'),
(195, 305, 205, '[[regtime]]', '[[regtime]]'),
(195, 306, 206, '[[regtime]]', '[[regtime]]'),
(195, 307, 207, '[[regtime]]', '[[regtime]]'),
(195, 10893, 208, '[[regtime]]', '[[regtime]]'),
(195, 10894, 209, '[[regtime]]', '[[regtime]]'),
(195, 10895, 210, '[[regtime]]', '[[regtime]]'),
(195, 10896, 211, '[[regtime]]', '[[regtime]]'),
(195, 10897, 212, '[[regtime]]', '[[regtime]]'),
(195, 10898, 213, '[[regtime]]', '[[regtime]]'),
(195, 10899, 214, '[[regtime]]', '[[regtime]]'),
(196, 301, 215, '[[regtime]]', '[[regtime]]'),
(196, 302, 216, '[[regtime]]', '[[regtime]]'),
(196, 303, 217, '[[regtime]]', '[[regtime]]'),
(196, 304, 218, '[[regtime]]', '[[regtime]]'),
(197, 301, 219, '[[regtime]]', '[[regtime]]'),
(197, 302, 220, '[[regtime]]', '[[regtime]]'),
(197, 303, 221, '[[regtime]]', '[[regtime]]'),
(197, 304, 222, '[[regtime]]', '[[regtime]]'),
(198, 301, 223, '[[regtime]]', '[[regtime]]'),
(198, 302, 224, '[[regtime]]', '[[regtime]]'),
(198, 303, 225, '[[regtime]]', '[[regtime]]'),
(198, 304, 226, '[[regtime]]', '[[regtime]]'),
(199, 301, 227, '[[regtime]]', '[[regtime]]'),
(199, 302, 228, '[[regtime]]', '[[regtime]]'),
(199, 303, 229, '[[regtime]]', '[[regtime]]'),
(200, 301, 230, '[[regtime]]', '[[regtime]]'),
(200, 302, 231, '[[regtime]]', '[[regtime]]'),
(200, 303, 232, '[[regtime]]', '[[regtime]]'),
(200, 304, 233, '[[regtime]]', '[[regtime]]'),
(200, 305, 234, '[[regtime]]', '[[regtime]]'),
(200, 306, 235, '[[regtime]]', '[[regtime]]'),
(200, 307, 236, '[[regtime]]', '[[regtime]]'),
(201, 301, 237, '[[regtime]]', '[[regtime]]'),
(201, 302, 238, '[[regtime]]', '[[regtime]]'),
(201, 303, 239, '[[regtime]]', '[[regtime]]'),
(201, 304, 240, '[[regtime]]', '[[regtime]]'),
(202, 301, 241, '[[regtime]]', '[[regtime]]'),
(202, 302, 242, '[[regtime]]', '[[regtime]]'),
(202, 303, 243, '[[regtime]]', '[[regtime]]'),
(202, 304, 244, '[[regtime]]', '[[regtime]]'),
(202, 305, 245, '[[regtime]]', '[[regtime]]'),
(203, 301, 246, '[[regtime]]', '[[regtime]]'),
(204, 301, 247, '[[regtime]]', '[[regtime]]'),
(205, 301, 248, '[[regtime]]', '[[regtime]]'),
(205, 302, 249, '[[regtime]]', '[[regtime]]'),
(205, 303, 250, '[[regtime]]', '[[regtime]]'),
(205, 304, 251, '[[regtime]]', '[[regtime]]'),
(207, 301, 252, '[[regtime]]', '[[regtime]]'),
(207, 302, 253, '[[regtime]]', '[[regtime]]'),
(207, 303, 254, '[[regtime]]', '[[regtime]]'),
(207, 304, 255, '[[regtime]]', '[[regtime]]'),
(207, 305, 256, '[[regtime]]', '[[regtime]]'),
(207, 306, 257, '[[regtime]]', '[[regtime]]'),
(207, 307, 258, '[[regtime]]', '[[regtime]]'),
(207, 10893, 259, '[[regtime]]', '[[regtime]]'),
(207, 10894, 260, '[[regtime]]', '[[regtime]]'),
(207, 10895, 261, '[[regtime]]', '[[regtime]]'),
(207, 10896, 262, '[[regtime]]', '[[regtime]]'),
(207, 10897, 263, '[[regtime]]', '[[regtime]]'),
(207, 10898, 264, '[[regtime]]', '[[regtime]]'),
(216, 301, 265, '[[regtime]]', '[[regtime]]'),
(216, 302, 266, '[[regtime]]', '[[regtime]]'),
(216, 303, 267, '[[regtime]]', '[[regtime]]'),
(216, 304, 268, '[[regtime]]', '[[regtime]]'),
(216, 10893, 269, '[[regtime]]', '[[regtime]]'),
(216, 10894, 270, '[[regtime]]', '[[regtime]]'),
(216, 10895, 271, '[[regtime]]', '[[regtime]]'),
(216, 10896, 272, '[[regtime]]', '[[regtime]]'),
(217, 301, 273, '[[regtime]]', '[[regtime]]'),
(217, 302, 274, '[[regtime]]', '[[regtime]]'),
(217, 303, 275, '[[regtime]]', '[[regtime]]'),
(217, 304, 276, '[[regtime]]', '[[regtime]]'),
(217, 10893, 277, '[[regtime]]', '[[regtime]]'),
(217, 10894, 278, '[[regtime]]', '[[regtime]]'),
(217, 10895, 279, '[[regtime]]', '[[regtime]]'),
(217, 10896, 280, '[[regtime]]', '[[regtime]]'),
(218, 301, 281, '[[regtime]]', '[[regtime]]'),
(218, 302, 282, '[[regtime]]', '[[regtime]]'),
(218, 303, 283, '[[regtime]]', '[[regtime]]'),
(218, 304, 284, '[[regtime]]', '[[regtime]]'),
(218, 10893, 285, '[[regtime]]', '[[regtime]]'),
(218, 10894, 286, '[[regtime]]', '[[regtime]]'),
(218, 10895, 287, '[[regtime]]', '[[regtime]]'),
(218, 10896, 288, '[[regtime]]', '[[regtime]]'),
(219, 301, 289, '[[regtime]]', '[[regtime]]'),
(219, 302, 290, '[[regtime]]', '[[regtime]]'),
(219, 10893, 291, '[[regtime]]', '[[regtime]]'),
(219, 10894, 292, '[[regtime]]', '[[regtime]]'),
(220, 301, 293, '[[regtime]]', '[[regtime]]'),
(220, 302, 294, '[[regtime]]', '[[regtime]]'),
(220, 303, 295, '[[regtime]]', '[[regtime]]'),
(220, 304, 296, '[[regtime]]', '[[regtime]]'),
(220, 10893, 297, '[[regtime]]', '[[regtime]]'),
(220, 10894, 298, '[[regtime]]', '[[regtime]]'),
(220, 10895, 299, '[[regtime]]', '[[regtime]]'),
(221, 301, 300, '[[regtime]]', '[[regtime]]'),
(221, 302, 301, '[[regtime]]', '[[regtime]]'),
(221, 10893, 302, '[[regtime]]', '[[regtime]]'),
(221, 10894, 303, '[[regtime]]', '[[regtime]]'),
(222, 301, 304, '[[regtime]]', '[[regtime]]'),
(222, 302, 305, '[[regtime]]', '[[regtime]]'),
(222, 303, 306, '[[regtime]]', '[[regtime]]'),
(222, 304, 307, '[[regtime]]', '[[regtime]]'),
(222, 10893, 308, '[[regtime]]', '[[regtime]]'),
(222, 10894, 309, '[[regtime]]', '[[regtime]]'),
(222, 10895, 310, '[[regtime]]', '[[regtime]]'),
(226, 3, 311, '[[regtime]]', '[[regtime]]'),
(227, 3, 312, '[[regtime]]', '[[regtime]]'),
(228, 3, 313, '[[regtime]]', '[[regtime]]'),
(229, 3, 314, '[[regtime]]', '[[regtime]]'),
(230, 3, 315, '[[regtime]]', '[[regtime]]'),
(235, 3, 316, '[[regtime]]', '[[regtime]]'),
(236, 3, 317, '[[regtime]]', '[[regtime]]'),
(237, 3, 318, '[[regtime]]', '[[regtime]]'),
(238, 3, 319, '[[regtime]]', '[[regtime]]'),
(280, 3, 320, '[[regtime]]', '[[regtime]]'),
(296, 301, 321, '[[regtime]]', '[[regtime]]'),
(297, 301, 322, '[[regtime]]', '[[regtime]]'),
(297, 302, 323, '[[regtime]]', '[[regtime]]'),
(297, 303, 324, '[[regtime]]', '[[regtime]]'),
(297, 304, 325, '[[regtime]]', '[[regtime]]'),
(11553, 3, 326, '[[regtime]]', '[[regtime]]'),
(11757, 301, 327, '[[regtime]]', '[[regtime]]'),
(11757, 302, 328, '[[regtime]]', '[[regtime]]'),
(11757, 303, 329, '[[regtime]]', '[[regtime]]'),
(11757, 304, 330, '[[regtime]]', '[[regtime]]'),
(11757, 10893, 331, '[[regtime]]', '[[regtime]]'),
(11757, 10894, 332, '[[regtime]]', '[[regtime]]'),
(11757, 10895, 333, '[[regtime]]', '[[regtime]]'),
(11757, 10896, 334, '[[regtime]]', '[[regtime]]'),
(11835, 301, 335, '[[regtime]]', '[[regtime]]'),
(11835, 302, 336, '[[regtime]]', '[[regtime]]'),
(11835, 303, 337, '[[regtime]]', '[[regtime]]'),
(11835, 304, 338, '[[regtime]]', '[[regtime]]'),
(11840, 3, 339, '[[regtime]]', '[[regtime]]'),
(11841, 3, 340, '[[regtime]]', '[[regtime]]'),
(11842, 3, 341, '[[regtime]]', '[[regtime]]'),
(11839, 3, 345, '[[regtime]]', '[[regtime]]'),
(80, 3, 346, '[[regtime]]', '[[regtime]]'),
(82, 3, 347, '[[regtime]]', '[[regtime]]'),
(91, 3, 348, '[[regtime]]', '[[regtime]]'),
(300, 3, 349, '[[regtime]]', '[[regtime]]'),
(300, 1, 458, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_rules`
--

CREATE TABLE `core_rules` (
  `id_rule` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rule_type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `creation_date` datetime DEFAULT NULL,
  `rule_active` tinyint(1) NOT NULL,
  `course_list` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_rule`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_rules`
--

INSERT INTO `core_rules` VALUES
(0, '', 'all', 'base', NULL, 1, '', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_rules_entity`
--

CREATE TABLE `core_rules_entity` (
  `id_rule` int(11) NOT NULL,
  `id_entity` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `course_list` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_rule_idx` (`id_rule`),
  KEY `id_entity_idx` (`id_entity`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_rules_log`
--

CREATE TABLE `core_rules_log` (
  `id_log` int(11) NOT NULL AUTO_INCREMENT,
  `log_action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_time` datetime DEFAULT NULL,
  `applied` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_log`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_setting`
--

CREATE TABLE `core_setting` (
  `param_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `param_value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `value_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'string',
  `max_size` int(3) NOT NULL DEFAULT '255',
  `pack` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'main',
  `regroup` int(11) NOT NULL,
  `sequence` int(11) NOT NULL,
  `param_load` tinyint(1) NOT NULL DEFAULT '1',
  `hide_in_modify` tinyint(1) NOT NULL,
  `extra_info` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `param_name_idx` (`param_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=130 ;

--
-- Dumping data for table `core_setting`
--

INSERT INTO `core_setting` VALUES
('accessibility', 'off', 'enum', 255, '0', 8, 5, 1, 0, '', 1, '[[regtime]]', '[[regtime]]'),
('Clear_Twig_Cache', 'index.php?r=adm/setting/clearTwigCache', 'button', 2, 'twig_cache', 8, 27, 0, 0, '', 2, '[[regtime]]', '[[regtime]]'),
('common_admin_session', 'on', 'enum', 3, 'security', 8, 24, 1, 0, '', 3, '[[regtime]]', '[[regtime]]'),
('conference_creation_limit_per_user', '99999999999', 'string', 255, '0', 6, 0, 1, 0, '', 4, '[[regtime]]', '[[regtime]]'),
('course_block', 'off', 'enum', 3, '0', 4, 15, 1, 0, '', 5, '[[regtime]]', '[[regtime]]'),
('course_quota', '500', 'string', 255, '0', 4, 9, 1, 0, '', 6, '[[regtime]]', '[[regtime]]'),
('currency_symbol', 'â‚¬', 'string', 10, 'ecommerce', 4, 16, 1, 0, '', 7, '[[regtime]]', '[[regtime]]'),
('custom_fields_mandatory_for_admin', 'off', 'enum', 3, 'register', 3, 21, 1, 0, '', 8, '[[regtime]]', '[[regtime]]'),
('default_language', 'english', 'language', 255, '0', 1, 3, 1, 0, '', 12, '[[regtime]]', '[[regtime]]'),
('defaultTemplate', 'standard', 'template', 255, '0', 1, 4, 1, 0, '', 13, '[[regtime]]', '[[regtime]]'),
('do_debug', 'off', 'enum', 3, 'debug', 8, 8, 1, 0, '', 14, '[[regtime]]', '[[regtime]]'),
('file_upload_whitelist', 'rar,exe,zip,jpg,gif,png,txt,csv,rtf,xml,doc,docx,xls,xlsx,ppt,pptx,odt,ods,odp,pdf,xps,mp4,mp3,flv,swf,mov,wav,ogg,flac,wma,wmv,jpeg,m4v,mkv', 'string', 65535, 'security', 8, 27, 1, 0, '', 15, '[[regtime]]', '[[regtime]]'),
('google_stat_code', '', 'textarea', 65535, 'google', 8, 28, 1, 0, '', 16, '[[regtime]]', '[[regtime]]'),
('google_stat_in_lms', '0', 'check', 1, 'google', 8, 29, 1, 0, '', 17, '[[regtime]]', '[[regtime]]'),
('hide_empty_category', 'on', 'enum', 3, '0', 4, 6, 1, 0, '', 18, '[[regtime]]', '[[regtime]]'),
('home_page_option', 'my_courses', 'home_page_option', 255, '0', 4, 1, 1, 0, '', 19, '[[regtime]]', '[[regtime]]'),
('hour_request_limit', '48', 'int', 2, 'register', 3, 13, 0, 0, '', 20, '[[regtime]]', '[[regtime]]'),
('hteditor', 'tinymce', 'hteditor', 255, '0', 1, 6, 1, 0, '', 21, '[[regtime]]', '[[regtime]]'),
('htmledit_image_admin', '1', 'check', 255, '0', 8, 1, 1, 0, '', 22, '[[regtime]]', '[[regtime]]'),
('htmledit_image_godadmin', '1', 'check', 255, '0', 8, 0, 1, 0, '', 23, '[[regtime]]', '[[regtime]]'),
('htmledit_image_user', '1', 'check', 255, '0', 8, 2, 1, 0, '', 24, '[[regtime]]', '[[regtime]]'),
('ignore_score', 'off', 'enum', 3, '0', 4, 16, 1, 0, '', 25, '[[regtime]]', '[[regtime]]'),
('kb_filter_by_user_access', 'on', 'enum', 3, '0', 4, 14, 1, 0, '', 26, '[[regtime]]', '[[regtime]]'),
('kb_show_uncategorized', 'on', 'enum', 3, '0', 4, 13, 1, 0, '', 27, '[[regtime]]', '[[regtime]]'),
('lang_check', 'off', 'enum', 3, 'debug', 8, 7, 1, 0, '', 28, '[[regtime]]', '[[regtime]]'),
('lastfirst_mandatory', 'off', 'enum', 3, 'register', 3, 14, 2, 0, '', 29, '[[regtime]]', '[[regtime]]'),
('ldap_port', '389', 'string', 5, '0', 9, 1, 1, 0, '', 30, '[[regtime]]', '[[regtime]]'),
('ldap_server', '192.168.0.1', 'string', 255, '0', 9, 3, 1, 0, '', 31, '[[regtime]]', '[[regtime]]'),
('ldap_used', 'off', 'enum', 3, '0', 9, 2, 1, 0, '', 32, '[[regtime]]', '[[regtime]]'),
('ldap_user_string', 'user@domain2.domain1', 'string', 255, 'email_settings', 9, 4, 1, 0, '', 33, '[[regtime]]', '[[regtime]]'),
('maintenance', 'off', 'enum', 3, 'security', 8, 25, 0, 0, '', 36, '[[regtime]]', '[[regtime]]'),
('maintenance_pw', 'manutenzione', 'string', 16, 'security', 8, 26, 0, 0, '', 37, '[[regtime]]', '[[regtime]]'),
('mandatory_code', 'off', 'enum', 3, 'register', 3, 18, 1, 0, '', 38, '[[regtime]]', '[[regtime]]'),
('max_log_attempt', '0', 'int', 3, 'security', 14, 4, 0, 0, '', 39, '[[regtime]]', '[[regtime]]'),
('nl_sendpause', '20', 'int', 3, 'newsletter', 8, 10, 1, 0, '', 40, '[[regtime]]', '[[regtime]]'),
('nl_sendpercycle', '200', 'int', 4, 'newsletter', 8, 9, 1, 0, '', 41, '[[regtime]]', '[[regtime]]'),
('no_answer_in_poll', 'off', 'enum', 3, '0', 4, 11, 1, 0, '', 42, '[[regtime]]', '[[regtime]]'),
('no_answer_in_test', 'off', 'enum', 3, '0', 4, 10, 1, 0, '', 43, '[[regtime]]', '[[regtime]]'),
('on_catalogue_empty', 'on', 'enum', 3, '0', 4, 5, 1, 0, '', 44, '[[regtime]]', '[[regtime]]'),
('on_path_in_mycourses', 'off', 'enum', 3, '0', 4, 3, 1, 0, '', 45, '[[regtime]]', '[[regtime]]'),
('on_usercourse_empty', 'off', 'on_usercourse_empty', 3, '0', 4, 2, 1, 0, '', 46, '[[regtime]]', '[[regtime]]'),
('orgchart_singlenode', 'off', 'enum', 3, 'register', 3, 21, 1, 0, '', 47, '[[regtime]]', '[[regtime]]'),
('owned_by', 'Copyright (c) forma.lms', 'html', 255, '0', 1, 7, 1, 0, '', 48, '[[regtime]]', '[[regtime]]'),
('page_title', 'Forma E-learning', 'string', 255, '0', 1, 1, 1, 0, '', 49, '[[regtime]]', '[[regtime]]'),
('pass_alfanumeric', 'off', 'enum', 3, 'password', 14, 6, 1, 0, '', 50, '[[regtime]]', '[[regtime]]'),
('pass_algorithm', '1', 'password_algorithms', 255, 'password', 14, 6, 1, 0, '', 51, '[[regtime]]', '[[regtime]]'),
('pass_change_first_login', 'on', 'enum', 3, 'password', 14, 8, 1, 0, '', 52, '[[regtime]]', '[[regtime]]'),
('pass_max_time_valid', '0', 'int', 4, 'password', 14, 9, 1, 0, '', 53, '[[regtime]]', '[[regtime]]'),
('pass_min_char', '8', 'int', 2, 'password', 14, 7, 0, 0, '', 54, '[[regtime]]', '[[regtime]]'),
('pathcourse', 'course/', 'string', 255, 'path', 8, 11, 1, 0, '', 55, '[[regtime]]', '[[regtime]]'),
('pathfield', 'field/', 'string', 255, 'path', 8, 12, 1, 0, '', 56, '[[regtime]]', '[[regtime]]'),
('pathforum', 'forum/', 'string', 255, 'path', 8, 14, 1, 0, '', 57, '[[regtime]]', '[[regtime]]'),
('pathlesson', 'item/', 'string', 255, 'path', 8, 15, 1, 0, '', 58, '[[regtime]]', '[[regtime]]'),
('pathmessage', 'message/', 'string', 255, 'path', 8, 16, 1, 0, '', 59, '[[regtime]]', '[[regtime]]'),
('pathphoto', 'photo/', 'string', 255, 'path', 8, 13, 1, 0, '', 60, '[[regtime]]', '[[regtime]]'),
('pathprj', 'project/', 'string', 255, 'path', 8, 20, 1, 1, '', 61, '[[regtime]]', '[[regtime]]'),
('pathscorm', 'scorm/', 'string', 255, 'path', 8, 17, 1, 0, '', 62, '[[regtime]]', '[[regtime]]'),
('pathsponsor', 'sponsor/', 'string', 255, 'path', 8, 18, 1, 0, '', 63, '[[regtime]]', '[[regtime]]'),
('pathtest', 'test/', 'string', 255, 'path', 8, 19, 1, 0, '', 64, '[[regtime]]', '[[regtime]]'),
('paypal_currency', 'EUR', 'string', 255, 'ecommerce', 4, 15, 1, 0, '', 65, '[[regtime]]', '[[regtime]]'),
('paypal_mail', '', 'string', 255, 'ecommerce', 4, 14, 1, 0, '', 66, '[[regtime]]', '[[regtime]]'),
('paypal_sandbox', 'on', 'enum', 3, 'ecommerce', 4, 17, 1, 0, '', 67, '[[regtime]]', '[[regtime]]'),
('privacy_policy', 'on', 'enum', 3, 'register', 3, 15, 0, 0, '', 68, '[[regtime]]', '[[regtime]]'),
('profile_modify', 'allow', 'profile_modify', 16, '0', 3, 1, 1, 0, '', 69, '[[regtime]]', '[[regtime]]'),
('profile_modify_url', '', 'string', 255, '0', 3, 2, 1, 0, '', 70, '[[regtime]]', '[[regtime]]'),
('purchase_user', '', 'string', 255, 'ecommerce', 4, 18, 1, 0, '', 71, '[[regtime]]', '[[regtime]]'),
('register_deleted_user', 'off', 'enum', 3, 'security', 14, 3, 1, 0, '', 72, '[[regtime]]', '[[regtime]]'),
('register_type', 'admin', 'register_type', 10, 'register', 3, 11, 0, 0, '', 73, '[[regtime]]', '[[regtime]]'),
('registration_code_type', '0', 'registration_code_type', 3, 'register', 3, 17, 1, 0, '', 74, '[[regtime]]', '[[regtime]]'),
('report_max_email_size_MB', '0', 'int', 4, 'report_settings', 8, 991, 1, 0, '', 75, '[[regtime]]', '[[regtime]]'),
('report_persistence_days', '30', 'int', 4, 'report_settings', 8, 990, 1, 0, '', 76, '[[regtime]]', '[[regtime]]'),
('report_storage_folder', '/files/common/report/', 'string', 255, 'report_settings', 8, 992, 1, 0, '', 77, '[[regtime]]', '[[regtime]]'),
('request_mandatory_fields_compilation', 'on', 'enum', 3, '0', 3, 2, 1, 0, '', 78, '[[regtime]]', '[[regtime]]'),
('rest_auth_api_key', '', 'string', 255, 'api', 9, 11, 1, 0, '', 79, '[[regtime]]', '[[regtime]]'),
('rest_auth_api_secret', '', 'string', 255, 'api', 9, 13, 1, 0, '', 80, '[[regtime]]', '[[regtime]]'),
('rest_auth_code', '', 'string', 255, 'api', 9, 8, 1, 0, '', 81, '[[regtime]]', '[[regtime]]'),
('rest_auth_lifetime', '60', 'int', 3, 'api', 9, 12, 1, 0, '', 82, '[[regtime]]', '[[regtime]]'),
('rest_auth_method', '1', 'rest_auth_sel_method', 3, 'api', 9, 9, 1, 0, '', 83, '[[regtime]]', '[[regtime]]'),
('rest_auth_update', 'off', 'enum', 3, 'api', 9, 10, 1, 0, '', 84, '[[regtime]]', '[[regtime]]'),
('save_log_attempt', 'no', 'save_log_attempt', 255, 'security', 14, 5, 0, 0, '', 85, '[[regtime]]', '[[regtime]]'),
('sco_direct_play', 'on', 'enum', 3, '0', 8, 3, 1, 0, '', 86, '[[regtime]]', '[[regtime]]'),
('session_ip_control', 'off', 'enum', 3, 'security', 8, 22, 1, 0, '', 90, '[[regtime]]', '[[regtime]]'),
('sms_cell_num_field', '1', 'field_select', 5, '0', 11, 6, 1, 0, '', 91, '[[regtime]]', '[[regtime]]'),
('sms_credit', '0', 'string', 20, '0', 1, 0, 1, 1, '', 92, '[[regtime]]', '[[regtime]]'),
('sms_gateway', 'smsmarket', 'string', 50, '0', 11, 0, 1, 1, '', 93, '[[regtime]]', '[[regtime]]'),
('sms_gateway_host', '193.254.241.47', 'string', 15, '0', 11, 8, 1, 0, '', 94, '[[regtime]]', '[[regtime]]'),
('sms_gateway_id', '3', 'sel_sms_gateway', 1, '0', 11, 7, 1, 0, '', 95, '[[regtime]]', '[[regtime]]'),
('sms_gateway_pass', '', 'string', 255, '0', 11, 5, 1, 0, '', 96, '[[regtime]]', '[[regtime]]'),
('sms_gateway_port', '26', 'int', 5, '0', 11, 9, 1, 0, '', 97, '[[regtime]]', '[[regtime]]'),
('sms_gateway_user', '', 'string', 50, '0', 11, 4, 1, 0, '', 98, '[[regtime]]', '[[regtime]]'),
('sms_international_prefix', '+39', 'string', 3, '0', 11, 1, 1, 0, '', 99, '[[regtime]]', '[[regtime]]'),
('sms_sent_from', '0', 'string', 25, '0', 11, 2, 1, 0, '', 100, '[[regtime]]', '[[regtime]]'),
('sso_secret', '', 'text', 255, '0', 9, 6, 1, 0, '', 101, '[[regtime]]', '[[regtime]]'),
('sso_token', 'off', 'enum', 3, '0', 9, 5, 1, 0, '', 102, '[[regtime]]', '[[regtime]]'),
('stop_concurrent_user', 'on', 'enum', 3, 'security', 8, 23, 1, 0, '', 103, '[[regtime]]', '[[regtime]]'),
('tablist_mycourses', 'name,code,status', 'tablist_mycourses', 255, '0', 4, 4, 1, 0, '', 104, '[[regtime]]', '[[regtime]]'),
('templ_use_field', '0', 'id_field', 11, '0', 1, 0, 1, 1, '', 105, '[[regtime]]', '[[regtime]]'),
('title_organigram_chart', 'Forma', 'string', 255, '0', 1, 0, 1, 1, '', 107, '[[regtime]]', '[[regtime]]'),
('tracking', 'off', 'enum', 3, '0', 4, 12, 1, 0, '', 108, '[[regtime]]', '[[regtime]]'),
('ttlSession', '4000', 'int', 5, '0', 8, 6, 1, 0, '', 109, '[[regtime]]', '[[regtime]]'),
('url', '[[softurl]]/', 'string', 255, '0', 1, 2, 1, 0, '', 110, '[[regtime]]', '[[regtime]]'),
('use_advanced_form', 'off', 'enum', 3, 'register', 3, 16, 1, 0, '', 111, '[[regtime]]', '[[regtime]]'),
('use_course_label', 'off', 'enum', 3, '0', 4, 7, 1, 0, '', 112, '[[regtime]]', '[[regtime]]'),
('use_immediate_report', 'off', 'enum', 3, 'report_settings', 8, 993, 1, 0, '', 113, '[[regtime]]', '[[regtime]]'),
('use_rest_api', 'off', 'enum', 3, 'api', 9, 7, 1, 0, '', 114, '[[regtime]]', '[[regtime]]'),
('use_tag', 'on', 'enum', 3, '0', 4, 8, 1, 0, '', 116, '[[regtime]]', '[[regtime]]'),
('user_pwd_history_length', '3', 'int', 3, 'password', 14, 10, 1, 0, '', 117, '[[regtime]]', '[[regtime]]'),
('user_quota', '50', 'string', 255, '0', 8, 6, 1, 0, '', 118, '[[regtime]]', '[[regtime]]'),
('visuItem', '25', 'int', 3, '0', 2, 1, 1, 1, '', 119, '[[regtime]]', '[[regtime]]'),
('visuNewsHomePage', '3', 'int', 5, '0', 1, 0, 1, 1, '', 120, '[[regtime]]', '[[regtime]]'),
('welcome_use_feed', 'on', 'enum', 3, '0', 1, 0, 1, 1, '', 121, '[[regtime]]', '[[regtime]]'),
('force_scorm_finish', 'on', 'enum', 3, '0', 4, 17, 1, 0, '', 122, '[[regtime]]', '[[regtime]]'),
('pass_min_uppercase', '0', 'int', 1, 'password', 14, 11, 1, 0, '', 123, '[[regtime]]', '[[regtime]]'),
('pass_min_lowercase', '0', 'int', 1, 'password', 14, 12, 1, 0, '', 124, '[[regtime]]', '[[regtime]]'),
('pass_min_digit', '0', 'int', 1, 'password', 14, 13, 1, 0, '', 125, '[[regtime]]', '[[regtime]]'),
('pass_special_char', '0', 'int', 1, 'password', 14, 14, 1, 0, '', 126, '[[regtime]]', '[[regtime]]'),
('pass_send_remind', 'off', 'enum', 3, 'password', 14, 15, 1, 0, '', 127, '[[regtime]]', '[[regtime]]'),
('exclude_completed_courses', 'off', 'enum', 3, '0', 4, 18, 1, 0, '', 128, '[[regtime]]', '[[regtime]]'),
('core_version', '4.0.11', 'string', 255, '0', 1, 0, 1, 1, '', 129, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_setting_group`
--

CREATE TABLE `core_setting_group` (
  `path_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idst` int(11) NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `path_name_idx` (`path_name`),
  KEY `idst_idx` (`idst`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_setting_list`
--

CREATE TABLE `core_setting_list` (
  `path_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL,
  `load_at_startup` tinyint(1) NOT NULL,
  `sequence` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `path_name_idx` (`path_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=14 ;

--
-- Dumping data for table `core_setting_list`
--

INSERT INTO `core_setting_list` VALUES
('admin_rules.course_presence_admin', '_COURSE_PRESENCE_ADMIN', 'off', 'enum', 1, 1, 7, 1, '[[regtime]]', '[[regtime]]'),
('admin_rules.direct_course_subscribe', '_DIRECT_COURSE_SUBSCRIBE', 'off', 'enum', 1, 1, 6, 2, '[[regtime]]', '[[regtime]]'),
('admin_rules.direct_user_insert', '_DIRECT_USER_INSERT', 'off', 'enum', 1, 1, 3, 3, '[[regtime]]', '[[regtime]]'),
('admin_rules.limit_course_subscribe', '_LIMIT_COURSE_SUBSCRIBE', 'off', 'enum', 1, 1, 4, 4, '[[regtime]]', '[[regtime]]'),
('admin_rules.limit_user_insert', '_LIMIT_USER_INSERT', 'off', 'enum', 1, 1, 1, 5, '[[regtime]]', '[[regtime]]'),
('admin_rules.max_course_subscribe', '_MAX_COURSE_SUBSCRIBE', '0', 'integer', 1, 1, 5, 6, '[[regtime]]', '[[regtime]]'),
('admin_rules.max_user_insert', '_MAX_USER_INSERT', '0', 'integer', 1, 1, 2, 7, '[[regtime]]', '[[regtime]]'),
('admin_rules.user_lang_assigned', '', '', 'string', 0, 1, 0, 8, '[[regtime]]', '[[regtime]]'),
('ui.directory.custom_columns', '_CUSTOM_COLUMS', '', 'hidden', 0, 1, 0, 9, '[[regtime]]', '[[regtime]]'),
('ui.language', '_LANGUAGE', '', 'language', 1, 1, 0, 10, '[[regtime]]', '[[regtime]]'),
('user_rules.field_policy', '', '', 'serialized', 0, 1, 0, 11, '[[regtime]]', '[[regtime]]'),
('user_rules.user_quota', '', '-1', 'int', 0, 1, 0, 12, '[[regtime]]', '[[regtime]]'),
('user_rules.user_quota_used', '', '0', 'int', 0, 1, 0, 13, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_setting_user`
--

CREATE TABLE `core_setting_user` (
  `path_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_user` int(11) NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `path_name_idx` (`path_name`),
  KEY `id_user_idx` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_st`
--

CREATE TABLE `core_st` (
  `idst` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idst`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci COMMENT='Security Tokens' AUTO_INCREMENT=11841 ;

--
-- Dumping data for table `core_st`
--

INSERT INTO `core_st` VALUES
(11831, '[[regtime]]', '[[regtime]]'),
(11832, '[[regtime]]', '[[regtime]]'),
(11833, '[[regtime]]', '[[regtime]]'),
(11834, '[[regtime]]', '[[regtime]]'),
(11835, '[[regtime]]', '[[regtime]]'),
(11836, '[[regtime]]', '[[regtime]]'),
(11837, '[[regtime]]', '[[regtime]]'),
(11838, '[[regtime]]', '[[regtime]]'),
(11839, '[[regtime]]', '[[regtime]]'),
(11840, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_tag`
--

CREATE TABLE `core_tag` (
  `id_tag` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_parent` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_tag`),
  KEY `tag_name` (`tag_name`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_tag_relation`
--

CREATE TABLE `core_tag_relation` (
  `id_tag` int(11) NOT NULL,
  `id_resource` int(11) NOT NULL,
  `resource_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_user` int(11) NOT NULL,
  `private` tinyint(1) NOT NULL,
  `id_course` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_tag_idx` (`id_tag`),
  KEY `id_resource_idx` (`id_resource`),
  KEY `resource_type_idx` (`resource_type`),
  KEY `id_user_idx` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_tag_resource`
--

CREATE TABLE `core_tag_resource` (
  `id_resource` int(11) NOT NULL,
  `resource_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sample_text` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `permalink` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_resource_idx` (`id_resource`),
  KEY `resource_type_idx` (`resource_type`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_task`
--

CREATE TABLE `core_task` (
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `conn_source` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `conn_destination` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `schedule_type` enum('at','any') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'at',
  `schedule` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `import_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `map` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_execution` datetime DEFAULT NULL,
  `sequence` int(3) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_transaction`
--

CREATE TABLE `core_transaction` (
  `id_trans` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `location` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_creation` datetime DEFAULT NULL,
  `date_activated` datetime DEFAULT NULL,
  `paid` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_trans`),
  KEY `id_user` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_transaction_info`
--

CREATE TABLE `core_transaction_info` (
  `id_trans` int(11) NOT NULL,
  `id_course` int(11) NOT NULL,
  `id_date` int(11) NOT NULL,
  `id_edition` int(11) NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `activated` tinyint(1) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_trans_idx` (`id_trans`),
  KEY `id_course_idx` (`id_course`),
  KEY `id_date_idx` (`id_date`),
  KEY `id_edition_idx` (`id_edition`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_user`
--

CREATE TABLE `core_user` (
  `idst` int(11) NOT NULL DEFAULT '0',
  `userid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `firstname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `signature` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `level` int(11) NOT NULL,
  `lastenter` datetime DEFAULT NULL,
  `valid` tinyint(1) NOT NULL DEFAULT '1',
  `pwd_expire_at` datetime DEFAULT NULL,
  `force_change` tinyint(1) NOT NULL,
  `register_date` datetime DEFAULT NULL,
  `facebook_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkedin_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `privacy_policy` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idst`),
  UNIQUE KEY `userid` (`userid`),
  UNIQUE KEY `facebook_id` (`facebook_id`),
  UNIQUE KEY `twitter_id` (`twitter_id`),
  UNIQUE KEY `linkedin_id` (`linkedin_id`),
  UNIQUE KEY `google_id` (`google_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `core_user`
--

INSERT INTO `core_user` VALUES
(270, '/Anonymous', '', '', '', '', '', '', 0, NULL, 0, NULL, 1, NULL, NULL, NULL, NULL, NULL, 0, '[[regtime]]', '[[regtime]]'),
(11840, '/[[admin_username]]', '[[admin_fname]]', '[[admin_lname]]', '[[admin_pass]]', '[[admin_email]]', '', '', 0, NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_user_file`
--

CREATE TABLE `core_user_file` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_idst` int(11) NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `real_fname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `media_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(11) NOT NULL,
  `uldate` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_user_log_attempt`
--

CREATE TABLE `core_user_log_attempt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempt_at` datetime DEFAULT NULL,
  `attempt_number` int(11) NOT NULL,
  `user_ip` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_user_profileview`
--

CREATE TABLE `core_user_profileview` (
  `id_owner` int(11) NOT NULL,
  `id_viewer` int(11) NOT NULL,
  `date_view` datetime DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_owner_idx` (`id_owner`),
  KEY `id_viewer_idx` (`id_viewer`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_user_temp`
--

CREATE TABLE `core_user_temp` (
  `idst` int(11) NOT NULL AUTO_INCREMENT,
  `userid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `firstname` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastname` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request_on` datetime DEFAULT NULL,
  `random_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `create_by_admin` int(11) NOT NULL,
  `confirmed` tinyint(1) NOT NULL,
  `facebook_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkedin_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idst`),
  UNIQUE KEY `userid` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_wiki`
--

CREATE TABLE `core_wiki` (
  `wiki_id` int(11) NOT NULL AUTO_INCREMENT,
  `source_platform` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `public` tinyint(1) NOT NULL,
  `language` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `other_lang` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `creation_date` datetime DEFAULT NULL,
  `page_count` int(11) NOT NULL,
  `revision_count` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`wiki_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_wiki_page`
--

CREATE TABLE `core_wiki_page` (
  `page_id` int(11) NOT NULL AUTO_INCREMENT,
  `page_code` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` int(11) NOT NULL,
  `page_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lev` int(11) NOT NULL,
  `wiki_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci PACK_KEYS=1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_wiki_page_info`
--

CREATE TABLE `core_wiki_page_info` (
  `page_id` int(11) NOT NULL,
  `language` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(11) NOT NULL,
  `last_update` datetime DEFAULT NULL,
  `wiki_id` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `page_id_idx` (`page_id`),
  KEY `language_idx` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `core_wiki_revision`
--

CREATE TABLE `core_wiki_revision` (
  `wiki_id` int(11) NOT NULL,
  `page_id` int(11) NOT NULL,
  `version` int(11) NOT NULL,
  `language` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` int(11) NOT NULL,
  `rev_date` datetime DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `wiki_id_idx` (`wiki_id`),
  KEY `page_id_idx` (`page_id`),
  KEY `version_idx` (`version`),
  KEY `language_idx` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dashboard_blocks`
--

CREATE TABLE `dashboard_blocks` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `block_class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `block_class_unique` (`block_class`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `dashboard_blocks`
--

INSERT INTO `dashboard_blocks` VALUES
(1, 'DashboardBlockCalendarLms', '[[regtime]]', '0000-00-00 00:00:00'),
(2, 'DashboardBlockCertificatesLms', '[[regtime]]', '0000-00-00 00:00:00'),
(3, 'DashboardBlockAnnouncementsLms', '[[regtime]]', '0000-00-00 00:00:00'),
(4, 'DashboardBlockCoursesLms', '[[regtime]]', '0000-00-00 00:00:00'),
(5, 'DashboardBlockMessagesLms', '[[regtime]]', '0000-00-00 00:00:00'),
(6, 'DashboardBlockWelcomeLms', '[[regtime]]', '0000-00-00 00:00:00'),
(7, 'DashboardBlockBannerLms', '[[regtime]]', '0000-00-00 00:00:00'),
(8, 'DashboardBlockCommunicationLms', '[[regtime]]', '0000-00-00 00:00:00'),
(9, 'DashboardBlockNewsLms', '[[regtime]]', '0000-00-00 00:00:00'),
(10, 'DashboardBlockCourseAttendanceGraphLms', '[[regtime]]', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `dashboard_block_config`
--

CREATE TABLE `dashboard_block_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `block_class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `block_config` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` bigint(20) NOT NULL DEFAULT '999',
  `dashboard_id` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `block_class_idx` (`block_class`),
  KEY `dashboard_id_idx` (`dashboard_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dashboard_layouts`
--

CREATE TABLE `dashboard_layouts` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_idx` (`name`) USING BTREE,
  KEY `status_idx` (`status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dashboard_permission`
--

CREATE TABLE `dashboard_permission` (
  `id_dashboard` int(11) NOT NULL,
  `idst_list` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_advice`
--

CREATE TABLE `learning_advice` (
  `idAdvice` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL,
  `posted` datetime DEFAULT NULL,
  `author` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `important` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idAdvice`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_adviceuser`
--

CREATE TABLE `learning_adviceuser` (
  `idAdvice` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `archivied` tinyint(1) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idAdvice_idx` (`idAdvice`),
  KEY `idUser_idx` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_aggregated_cert_assign`
--

CREATE TABLE `learning_aggregated_cert_assign` (
  `idUser` int(11) NOT NULL,
  `idCertificate` int(11) NOT NULL,
  `idAssociation` int(11) NOT NULL,
  `on_date` datetime DEFAULT NULL,
  `cert_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_user_idx` (`idUser`),
  KEY `id_certificate_idx` (`idCertificate`),
  KEY `id_association_idx` (`idAssociation`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_aggregated_cert_course`
--

CREATE TABLE `learning_aggregated_cert_course` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAssociation` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `idCourse` int(11) NOT NULL,
  `idCourseEdition` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idAssociation` (`idAssociation`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_aggregated_cert_coursepath`
--

CREATE TABLE `learning_aggregated_cert_coursepath` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAssociation` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `idCoursePath` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idAssociation` (`idAssociation`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_aggregated_cert_metadata`
--

CREATE TABLE `learning_aggregated_cert_metadata` (
  `idAssociation` int(11) NOT NULL AUTO_INCREMENT,
  `idCertificate` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idAssociation`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_assessment_rule`
--

CREATE TABLE `learning_assessment_rule` (
  `rule_id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `from_score` double NOT NULL,
  `to_score` double NOT NULL,
  `competences_list` mediumtext COLLATE utf8mb4_unicode_ci,
  `courses_list` mediumtext COLLATE utf8mb4_unicode_ci,
  `feedback_txt` mediumtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_assessment_user`
--

CREATE TABLE `learning_assessment_user` (
  `id_assessment` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `type_of` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_assessment_idx` (`id_assessment`),
  KEY `id_user_idx` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_calendar`
--

CREATE TABLE `learning_calendar` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_catalogue`
--

CREATE TABLE `learning_catalogue` (
  `idCatalogue` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idCatalogue`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_catalogue_entry`
--

CREATE TABLE `learning_catalogue_entry` (
  `idCatalogue` int(11) NOT NULL,
  `idEntry` int(11) NOT NULL,
  `type_of_entry` enum('course','coursepath') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'course',
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_of_entry_idx` (`type_of_entry`),
  KEY `id_catalogue_idx` (`idCatalogue`),
  KEY `id_entry_idx` (`idEntry`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_catalogue_member`
--

CREATE TABLE `learning_catalogue_member` (
  `idCatalogue` int(11) NOT NULL,
  `idst_member` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idst_member_idx` (`idst_member`),
  KEY `id_catalogue_idx` (`idCatalogue`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_category`
--

CREATE TABLE `learning_category` (
  `idCategory` int(11) NOT NULL AUTO_INCREMENT,
  `idParent` int(11) DEFAULT NULL,
  `lev` int(11) NOT NULL,
  `path` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `iLeft` int(11) NOT NULL,
  `iRight` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idCategory`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_certificate`
--

CREATE TABLE `learning_certificate` (
  `id_certificate` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `base_language` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cert_structure` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `orientation` enum('P','L') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'P',
  `bgimage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta` tinyint(1) NOT NULL,
  `user_release` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_certificate`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `learning_certificate`
--

INSERT INTO `learning_certificate` VALUES
(2, '0000', 'Certificate sample', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.<br />', 'english', '<table style="margin-left: auto; margin-right: auto;" border="0">\n<tbody>\n<tr>\n<td>&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</td>\n<td style="text-align: center;" colspan="2"><span style="font-size: 65px;"><br /><br /><br /><br /><br /><br /><br />This certificate is awarded to<strong><strong><br />[display_name]<br /></strong><br /><br /><br /></strong>In recognition of your completion of the training course<strong><br />[course_name]<br /><br /><br /><br /><br /><br /></strong></span></td>\n<td>&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</td>\n</tr>\n<tr>\n<td>&nbsp;</td>\n<td>&nbsp;</td>\n<td style="text-align: right;"><span style="line-height: 19px; font-size: small;"><strong><br /></strong></span></td>\n<td><span style="font-size: x-large;"><strong>[theacher_list]</strong></span><br /><span style="font-size: x-large;">The Instructor/s</span></td>\n</tr>\n</tbody>\n</table>\n<br />', 'L', 'certificate_sample.jpg', 0, 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `learning_certificate_assign`
--

CREATE TABLE `learning_certificate_assign` (
  `id_certificate` int(11) NOT NULL,
  `id_course` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `on_date` datetime DEFAULT NULL,
  `cert_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_certificate_idx` (`id_certificate`),
  KEY `id_course_idx` (`id_course`),
  KEY `id_user_idx` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_certificate_course`
--

CREATE TABLE `learning_certificate_course` (
  `id_certificate` int(11) NOT NULL,
  `id_course` int(11) NOT NULL,
  `available_for_status` tinyint(1) NOT NULL,
  `point_required` int(11) NOT NULL,
  `minutes_required` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_certificate_idx` (`id_certificate`),
  KEY `id_course_idx` (`id_course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_certificate_tags`
--

CREATE TABLE `learning_certificate_tags` (
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `file_name_idx` (`file_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `learning_certificate_tags`
--

INSERT INTO `learning_certificate_tags` VALUES
('certificate.course.php', 'CertificateSubs_Course', 1, '[[regtime]]', '[[regtime]]'),
('certificate.misc.php', 'CertificateSubs_Misc', 2, '[[regtime]]', '[[regtime]]'),
('certificate.user.php', 'CertificateSubs_User', 3, '[[regtime]]', '[[regtime]]'),
('certificate.userstat.php', 'CertificateSubs_UserStat', 4, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `learning_classroom`
--

CREATE TABLE `learning_classroom` (
  `idClassroom` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_id` int(11) NOT NULL,
  `room` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `street` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `capacity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `disposition` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `instrument` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `available_instrument` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `responsable` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idClassroom`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_classroom_calendar`
--

CREATE TABLE `learning_classroom_calendar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `classroom_id` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` int(11) NOT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_class_location`
--

CREATE TABLE `learning_class_location` (
  `location_id` int(11) NOT NULL AUTO_INCREMENT,
  `location` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_comment_ajax`
--

CREATE TABLE `learning_comment_ajax` (
  `id_comment` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `external_key` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_author` int(11) NOT NULL,
  `posted_on` datetime DEFAULT NULL,
  `textof` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `history_tree` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_parent` int(11) NOT NULL,
  `moderated` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_comment`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_commontrack`
--

CREATE TABLE `learning_commontrack` (
  `idReference` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `idTrack` int(11) NOT NULL,
  `objectType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dateAttempt` datetime DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `firstAttempt` datetime DEFAULT NULL,
  `first_complete` datetime DEFAULT NULL,
  `last_complete` datetime DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idReference` (`idReference`),
  KEY `idUser` (`idUser`),
  KEY `id_track_idx` (`idTrack`),
  KEY `object_type_idx` (`objectType`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_communication`
--

CREATE TABLE `learning_communication` (
  `id_comm` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `publish_date` date DEFAULT NULL,
  `type_of` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_resource` int(11) NOT NULL,
  `id_category` int(10) unsigned NOT NULL,
  `id_course` int(10) unsigned NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_comm`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_communication_access`
--

CREATE TABLE `learning_communication_access` (
  `id_comm` int(11) NOT NULL,
  `idst` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_comm`,`idst`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `learning_communication_category`
--

CREATE TABLE `learning_communication_category` (
  `id_category` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_parent` int(10) unsigned NOT NULL,
  `level` int(10) unsigned NOT NULL,
  `iLeft` int(10) unsigned NOT NULL,
  `iRight` int(10) unsigned NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_category`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_communication_category_lang`
--

CREATE TABLE `learning_communication_category_lang` (
  `id_category` int(10) unsigned NOT NULL,
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_category_idx` (`id_category`),
  KEY `lang_code_idx` (`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_communication_lang`
--

CREATE TABLE `learning_communication_lang` (
  `id_comm` int(11) DEFAULT NULL,
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_communication_track`
--

CREATE TABLE `learning_communication_track` (
  `idReference` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `idTrack` int(11) NOT NULL,
  `objectType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dateAttempt` datetime DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `firstAttempt` datetime DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idReference` (`idReference`),
  KEY `idUser` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_competence`
--

CREATE TABLE `learning_competence` (
  `id_competence` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_category` int(10) unsigned NOT NULL,
  `type` enum('score','flag') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'score',
  `score` double NOT NULL,
  `typology` enum('skill','attitude','knowledge') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'skill',
  `expiration` int(10) unsigned NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_competence`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_competence_category`
--

CREATE TABLE `learning_competence_category` (
  `id_category` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_parent` int(10) unsigned NOT NULL,
  `level` int(10) unsigned NOT NULL,
  `iLeft` int(10) unsigned NOT NULL,
  `iRight` int(10) unsigned NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_category`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_competence_category_lang`
--

CREATE TABLE `learning_competence_category_lang` (
  `id_category` int(10) unsigned NOT NULL,
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_category_idx` (`id_category`),
  KEY `lang_code_idx` (`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_competence_course`
--

CREATE TABLE `learning_competence_course` (
  `id_competence` int(10) unsigned NOT NULL,
  `id_course` int(10) unsigned NOT NULL,
  `score` double NOT NULL,
  `retraining` tinyint(1) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_competence_idx` (`id_competence`),
  KEY `id_course_idx` (`id_course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_competence_lang`
--

CREATE TABLE `learning_competence_lang` (
  `id_competence` int(10) unsigned NOT NULL,
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_competence_idx` (`id_competence`),
  KEY `lang_code_idx` (`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_competence_required`
--

CREATE TABLE `learning_competence_required` (
  `id_competence` int(10) unsigned NOT NULL,
  `idst` int(10) unsigned NOT NULL,
  `type_of` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idst_idx` (`idst`),
  KEY `id_competence_idx` (`id_competence`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_competence_track`
--

CREATE TABLE `learning_competence_track` (
  `id_track` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_competence` int(10) unsigned NOT NULL,
  `id_user` int(10) unsigned NOT NULL,
  `operation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_course` int(11) NOT NULL,
  `assigned_by` int(11) NOT NULL,
  `date_assignment` datetime DEFAULT NULL,
  `score_assigned` double NOT NULL,
  `score_total` double NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_track`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_competence_user`
--

CREATE TABLE `learning_competence_user` (
  `id_competence` int(10) unsigned NOT NULL,
  `id_user` int(10) unsigned NOT NULL,
  `score_got` double NOT NULL,
  `last_assign_date` datetime DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_competence_idx` (`id_competence`),
  KEY `id_user_idx` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_course`
--

CREATE TABLE `learning_course` (
  `idCourse` int(11) NOT NULL AUTO_INCREMENT,
  `idCategory` int(11) NOT NULL,
  `code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `box_description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `level_show_user` int(11) NOT NULL,
  `subscribe_method` tinyint(1) NOT NULL,
  `linkSponsor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `imgSponsor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `img_course` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `img_material` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `img_othermaterial` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `course_demo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mediumTime` int(10) unsigned NOT NULL,
  `permCloseLO` tinyint(1) NOT NULL,
  `userStatusOp` int(11) NOT NULL,
  `difficult` enum('veryeasy','easy','medium','difficult','verydifficult') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'medium',
  `show_progress` tinyint(1) NOT NULL DEFAULT '1',
  `show_time` tinyint(1) NOT NULL,
  `show_who_online` tinyint(1) NOT NULL,
  `show_extra_info` tinyint(1) NOT NULL,
  `show_rules` tinyint(1) NOT NULL,
  `date_begin` date DEFAULT NULL,
  `date_end` date DEFAULT NULL,
  `hour_begin` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hour_end` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `valid_time` int(11) NOT NULL,
  `max_num_subscribe` int(11) NOT NULL,
  `min_num_subscribe` int(11) NOT NULL,
  `max_sms_budget` double NOT NULL,
  `selling` tinyint(1) NOT NULL,
  `prize` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `course_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'elearning',
  `policy_point` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `point_to_all` int(11) NOT NULL,
  `course_edition` tinyint(1) NOT NULL,
  `classrooms` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `certificates` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `security_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `imported_from_connection` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `course_quota` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '-1',
  `used_space` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `course_vote` double NOT NULL,
  `allow_overbooking` tinyint(1) NOT NULL,
  `can_subscribe` tinyint(1) NOT NULL,
  `sub_start_date` date DEFAULT NULL,
  `sub_end_date` date DEFAULT NULL,
  `advance` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoregistration_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `direct_play` tinyint(1) NOT NULL,
  `use_logo_in_courselist` tinyint(1) NOT NULL,
  `show_result` tinyint(1) NOT NULL,
  `credits` double NOT NULL,
  `auto_unsubscribe` tinyint(1) NOT NULL,
  `unsubscribe_date_limit` datetime DEFAULT NULL,
  `id_menucustom` int(11) DEFAULT NULL,
  `sendCalendar` tinyint(1) DEFAULT NULL,
  `calendarId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idCourse`) USING BTREE,
  KEY `fk_menucustom` (`id_menucustom`) USING BTREE
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_coursepath`
--

CREATE TABLE `learning_coursepath` (
  `id_path` int(11) NOT NULL AUTO_INCREMENT,
  `path_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path_descr` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `subscribe_method` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_path`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_coursepath_courses`
--

CREATE TABLE `learning_coursepath_courses` (
  `id_path` int(11) NOT NULL,
  `id_item` int(11) NOT NULL,
  `in_slot` int(11) NOT NULL,
  `prerequisites` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_path_idx` (`id_path`),
  KEY `id_item_idx` (`id_item`),
  KEY `in_slot_idx` (`in_slot`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_coursepath_user`
--

CREATE TABLE `learning_coursepath_user` (
  `id_path` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `waiting` tinyint(1) NOT NULL,
  `course_completed` int(11) NOT NULL,
  `date_assign` datetime DEFAULT NULL,
  `subscribed_by` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_path_idx` (`id_path`),
  KEY `id_user_idx` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_coursereport`
--

CREATE TABLE `learning_coursereport` (
  `id_report` int(11) NOT NULL AUTO_INCREMENT,
  `id_course` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `max_score` double NOT NULL,
  `required_score` double NOT NULL,
  `weight` int(11) NOT NULL,
  `show_to_user` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'true',
  `use_for_final` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'true',
  `sequence` int(11) NOT NULL,
  `source_of` enum('test','activity','scorm','final_vote','scoitem') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'test',
  `id_source` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_in_detail` tinyint(1) DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_report`),
  UNIQUE KEY `unique_coursereport` (`source_of`,`id_course`,`id_source`),
  KEY `id_course_id_report_source_of_idx` (`id_course`,`id_report`,`source_of`),
  KEY `id_course_id_report_source_of_id_source_idx` (`id_course`,`id_report`,`source_of`,`id_source`),
  KEY `id_course_id_report_idx` (`id_course`,`id_report`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_coursereport_score`
--

CREATE TABLE `learning_coursereport_score` (
  `id_report` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `date_attempt` datetime DEFAULT NULL,
  `score` double(5,2) NOT NULL DEFAULT '0.00',
  `score_status` enum('valid','not_checked','not_passed','passed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'valid',
  `comment` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_report_idx` (`id_report`),
  KEY `id_user_idx` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_courseuser`
--

CREATE TABLE `learning_courseuser` (
  `idUser` int(11) NOT NULL,
  `idCourse` int(11) NOT NULL,
  `edition_id` int(11) NOT NULL,
  `level` int(11) NOT NULL,
  `date_inscr` datetime DEFAULT NULL,
  `date_first_access` datetime DEFAULT NULL,
  `date_complete` datetime DEFAULT NULL,
  `status` int(11) NOT NULL,
  `waiting` tinyint(1) NOT NULL,
  `subscribed_by` int(11) NOT NULL,
  `rule_log` int(11) DEFAULT NULL,
  `score_given` int(4) DEFAULT NULL,
  `imported_from_connection` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `absent` tinyint(1) NOT NULL,
  `cancelled_by` int(11) NOT NULL,
  `new_forum_post` int(11) NOT NULL,
  `date_begin_validity` datetime DEFAULT NULL,
  `date_expire_validity` datetime DEFAULT NULL,
  `requesting_unsubscribe` tinyint(1) NOT NULL,
  `requesting_unsubscribe_date` datetime DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `edition_id_idx` (`edition_id`),
  KEY `id_course_idx` (`idCourse`),
  KEY `id_user_idx` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_course_date`
--

CREATE TABLE `learning_course_date` (
  `id_date` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_course` int(10) unsigned NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `max_par` int(11) NOT NULL,
  `price` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `overbooking` tinyint(1) NOT NULL,
  `test_type` tinyint(1) NOT NULL,
  `status` int(10) unsigned NOT NULL,
  `medium_time` int(11) NOT NULL,
  `sub_start_date` datetime DEFAULT NULL,
  `sub_end_date` datetime DEFAULT NULL,
  `unsubscribe_date_limit` datetime DEFAULT NULL,
  `calendarId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_date`),
  KEY `id_course` (`id_course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_course_date_day`
--

CREATE TABLE `learning_course_date_day` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_day` int(11) NOT NULL,
  `id_date` int(11) NOT NULL,
  `classroom` int(10) unsigned NOT NULL,
  `date_begin` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `pause_begin` datetime DEFAULT NULL,
  `pause_end` datetime DEFAULT NULL,
  `calendarId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `id_day_date` (`id_day`,`id_date`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_course_date_presence`
--

CREATE TABLE `learning_course_date_presence` (
  `day` date DEFAULT NULL,
  `id_date` int(10) unsigned NOT NULL,
  `id_user` int(10) unsigned NOT NULL,
  `id_day` int(10) unsigned NOT NULL,
  `presence` tinyint(1) NOT NULL,
  `score` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `day_idx` (`day`),
  KEY `id_date_idx` (`id_date`),
  KEY `id_user_idx` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_course_date_user`
--

CREATE TABLE `learning_course_date_user` (
  `id_date` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `date_subscription` datetime DEFAULT NULL,
  `date_complete` datetime DEFAULT NULL,
  `presence` longtext COLLATE utf8mb4_unicode_ci,
  `subscribed_by` int(10) unsigned NOT NULL,
  `overbooking` int(11) DEFAULT NULL,
  `requesting_unsubscribe` tinyint(1) unsigned DEFAULT NULL,
  `requesting_unsubscribe_date` datetime DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_date_idx` (`id_date`),
  KEY `id_user_idx` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_course_editions`
--

CREATE TABLE `learning_course_editions` (
  `id_edition` int(11) NOT NULL AUTO_INCREMENT,
  `id_course` int(11) NOT NULL,
  `code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `date_begin` date DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `max_num_subscribe` int(11) NOT NULL,
  `min_num_subscribe` int(11) NOT NULL,
  `price` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `overbooking` tinyint(1) NOT NULL,
  `can_subscribe` tinyint(1) NOT NULL,
  `sub_date_begin` date DEFAULT NULL,
  `sub_date_end` date DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `calendarId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id_edition`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_course_editions_user`
--

CREATE TABLE `learning_course_editions_user` (
  `id_edition` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `date_subscription` datetime DEFAULT NULL,
  `date_complete` datetime DEFAULT NULL,
  `subscribed_by` int(10) unsigned NOT NULL,
  `requesting_unsubscribe` tinyint(1) unsigned DEFAULT NULL,
  `requesting_unsubscribe_date` datetime DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_edition_idx` (`id_edition`),
  KEY `id_user_idx` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_course_file`
--

CREATE TABLE `learning_course_file` (
  `id_file` int(11) NOT NULL AUTO_INCREMENT,
  `id_course` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_file`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_faq`
--

CREATE TABLE `learning_faq` (
  `idFaq` int(11) NOT NULL AUTO_INCREMENT,
  `idCategory` int(11) NOT NULL,
  `question` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `keyword` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idFaq`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_faq_cat`
--

CREATE TABLE `learning_faq_cat` (
  `idCategory` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idCategory`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_forum`
--

CREATE TABLE `learning_forum` (
  `idForum` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `num_thread` int(11) NOT NULL,
  `num_post` int(11) NOT NULL,
  `last_post` int(11) NOT NULL,
  `locked` tinyint(1) NOT NULL,
  `sequence` int(11) NOT NULL,
  `emoticons` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `max_threads` int(11) DEFAULT NULL,
  `threads_are_private` tinyint(1) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idForum`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_forummessage`
--

CREATE TABLE `learning_forummessage` (
  `idMessage` int(11) NOT NULL AUTO_INCREMENT,
  `idThread` int(11) NOT NULL,
  `idCourse` int(11) NOT NULL,
  `answer_tree` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `textof` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `posted` datetime DEFAULT NULL,
  `author` int(11) NOT NULL,
  `generator` tinyint(1) NOT NULL,
  `attach` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locked` tinyint(1) NOT NULL,
  `modified_by` int(11) NOT NULL,
  `modified_by_on` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idMessage`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_forumthread`
--

CREATE TABLE `learning_forumthread` (
  `idThread` int(11) NOT NULL AUTO_INCREMENT,
  `id_edition` int(11) NOT NULL,
  `idForum` int(11) NOT NULL,
  `posted` datetime DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` int(11) NOT NULL,
  `num_post` int(11) NOT NULL,
  `num_view` int(11) NOT NULL,
  `last_post` int(11) NOT NULL,
  `locked` tinyint(1) NOT NULL,
  `erased` tinyint(1) NOT NULL,
  `emoticons` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rilevantForum` tinyint(1) NOT NULL,
  `privateThread` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idThread`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_forum_access`
--

CREATE TABLE `learning_forum_access` (
  `idForum` int(11) NOT NULL,
  `idMember` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_forum_idx` (`idForum`),
  KEY `id_member_idx` (`idMember`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_forum_notifier`
--

CREATE TABLE `learning_forum_notifier` (
  `id_notify` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `notify_is_a` enum('forum','thread') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'forum',
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_notify_idx` (`id_notify`),
  KEY `id_user_idx` (`id_user`),
  KEY `notify_is_a_idx` (`notify_is_a`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_forum_timing`
--

CREATE TABLE `learning_forum_timing` (
  `idUser` int(11) NOT NULL,
  `idCourse` int(11) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_user_idx` (`idUser`),
  KEY `id_course_idx` (`idCourse`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_games`
--

CREATE TABLE `learning_games` (
  `id_game` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `type_of` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_resource` int(11) NOT NULL,
  `play_chance` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_game`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_games_access`
--

CREATE TABLE `learning_games_access` (
  `id_game` int(11) NOT NULL,
  `idst` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_game_idx` (`id_game`),
  KEY `idst_idx` (`idst`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_games_track`
--

CREATE TABLE `learning_games_track` (
  `idReference` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `idTrack` int(11) NOT NULL,
  `objectType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dateAttempt` datetime DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `firstAttempt` datetime DEFAULT NULL,
  `current_score` int(11) DEFAULT NULL,
  `max_score` int(11) DEFAULT NULL,
  `num_attempts` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idReference` (`idReference`),
  KEY `idUser` (`idUser`),
  KEY `id_track_idx` (`idTrack`),
  KEY `object_type_idx` (`objectType`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_glossary`
--

CREATE TABLE `learning_glossary` (
  `idGlossary` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idGlossary`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_glossaryterm`
--

CREATE TABLE `learning_glossaryterm` (
  `idTerm` int(11) NOT NULL AUTO_INCREMENT,
  `idGlossary` int(11) NOT NULL,
  `term` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idTerm`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_homerepo`
--

CREATE TABLE `learning_homerepo` (
  `idRepo` int(11) NOT NULL AUTO_INCREMENT,
  `idParent` int(11) NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lev` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `objectType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idResource` int(11) NOT NULL,
  `idCategory` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `idAuthor` int(11) NOT NULL,
  `version` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `difficult` enum('_VERYEASY','_EASY','_MEDIUM','_DIFFICULT','_VERYDIFFICULT') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_VERYEASY',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `resource` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `objective` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dateInsert` datetime DEFAULT NULL,
  `idOwner` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idRepo`),
  KEY `idParent` (`idParent`),
  KEY `path` (`path`),
  KEY `idOwner` (`idOwner`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_htmlfront`
--

CREATE TABLE `learning_htmlfront` (
  `id_course` int(11) NOT NULL,
  `textof` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_course_idx` (`id_course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_htmlpage`
--

CREATE TABLE `learning_htmlpage` (
  `idPage` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `textof` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idPage`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_htmlpage_attachment`
--

CREATE TABLE `learning_htmlpage_attachment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `idpage` int(11) unsigned NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_instmsg`
--

CREATE TABLE `learning_instmsg` (
  `id_msg` bigint(20) NOT NULL AUTO_INCREMENT,
  `id_sender` int(11) NOT NULL,
  `id_receiver` int(11) NOT NULL,
  `msg` mediumtext COLLATE utf8mb4_unicode_ci,
  `status` smallint(6) NOT NULL,
  `data` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_msg`),
  KEY `id_sender` (`id_sender`,`id_receiver`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_kb_rel`
--

CREATE TABLE `learning_kb_rel` (
  `res_id` int(11) NOT NULL,
  `parent_id` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rel_type` enum('tag','folder') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'tag',
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `res_id_idx` (`res_id`),
  KEY `parent_id_idx` (`parent_id`),
  KEY `rel_type_idx` (`rel_type`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_kb_res`
--

CREATE TABLE `learning_kb_res` (
  `res_id` int(11) NOT NULL AUTO_INCREMENT,
  `r_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `r_desc` mediumtext COLLATE utf8mb4_unicode_ci,
  `r_item_id` int(11) NOT NULL,
  `r_type` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `r_env` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `r_env_parent_id` int(11) DEFAULT NULL,
  `r_param` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `r_alt_desc` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `r_lang` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `force_visible` tinyint(1) NOT NULL,
  `is_mobile` tinyint(1) NOT NULL,
  `sub_categorize` tinyint(1) NOT NULL DEFAULT '-1',
  `is_categorized` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`res_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_kb_tag`
--

CREATE TABLE `learning_kb_tag` (
  `tag_id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_kb_tree`
--

CREATE TABLE `learning_kb_tree` (
  `node_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `lev` int(11) NOT NULL,
  `iLeft` int(11) NOT NULL,
  `iRight` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_kb_tree_info`
--

CREATE TABLE `learning_kb_tree_info` (
  `id_dir` int(11) NOT NULL,
  `lang_code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `node_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `node_desc` mediumtext COLLATE utf8mb4_unicode_ci,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_label`
--

CREATE TABLE `learning_label` (
  `id_common_label` int(11) NOT NULL,
  `lang_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(10) unsigned NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_common_label_idx` (`id_common_label`),
  KEY `lang_code_idx` (`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_label_course`
--

CREATE TABLE `learning_label_course` (
  `id_common_label` int(11) NOT NULL,
  `id_course` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_common_label_idx` (`id_common_label`),
  KEY `id_course_idx` (`id_course`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_light_repo`
--

CREATE TABLE `learning_light_repo` (
  `id_repository` int(11) NOT NULL AUTO_INCREMENT,
  `id_course` int(11) NOT NULL,
  `repo_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `repo_descr` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `repo_teacher_alert` tinyint(1) DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_repository`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_light_repo_files`
--

CREATE TABLE `learning_light_repo_files` (
  `id_file` int(11) NOT NULL AUTO_INCREMENT,
  `id_repository` int(11) NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_descr` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_author` int(11) NOT NULL,
  `post_date` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_file`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_light_repo_user`
--

CREATE TABLE `learning_light_repo_user` (
  `id_repo` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `last_enter` datetime DEFAULT NULL,
  `repo_lock` tinyint(1) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_repo_idx` (`id_repo`),
  KEY `id_user_idx` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_link`
--

CREATE TABLE `learning_link` (
  `idLink` int(11) NOT NULL AUTO_INCREMENT,
  `idCategory` int(11) NOT NULL,
  `title` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `keyword` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idLink`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_link_cat`
--

CREATE TABLE `learning_link_cat` (
  `idCategory` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idCategory`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_lo_param`
--

CREATE TABLE `learning_lo_param` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idParam` int(11) NOT NULL,
  `param_name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `param_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idParam_name` (`idParam`,`param_name`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_lo_types`
--

CREATE TABLE `learning_lo_types` (
  `objectType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `className` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileName` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `classNameTrack` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fileNameTrack` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `object_type_idx` (`objectType`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `learning_lo_types`
--

INSERT INTO `learning_lo_types` VALUES
('faq', 'Learning_Faq', 'learning.faq.php', 'Track_Faq', 'track.faq.php', 1, '[[regtime]]', '[[regtime]]'),
('glossary', 'Learning_Glossary', 'learning.glossary.php', 'Track_Glossary', 'track.glossary.php', 2, '[[regtime]]', '[[regtime]]'),
('htmlpage', 'Learning_Htmlpage', 'learning.htmlpage.php', 'Track_Htmlpage', 'track.htmlpage.php', 3, '[[regtime]]', '[[regtime]]'),
('item', 'Learning_Item', 'learning.item.php', 'Track_Item', 'track.item.php', 4, '[[regtime]]', '[[regtime]]'),
('link', 'Learning_Link', 'learning.link.php', 'Track_Link', 'track.link.php', 5, '[[regtime]]', '[[regtime]]'),
('poll', 'Learning_Poll', 'learning.poll.php', 'Track_Poll', 'track.poll.php', 6, '[[regtime]]', '[[regtime]]'),
('scormorg', 'Learning_ScormOrg', 'learning.scorm.php', 'Track_Scormorg', 'track.scorm.php', 7, '[[regtime]]', '[[regtime]]'),
('test', 'Learning_Test', 'learning.test.php', 'Track_Test', 'track.test.php', 8, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `learning_materials_lesson`
--

CREATE TABLE `learning_materials_lesson` (
  `idLesson` int(11) NOT NULL AUTO_INCREMENT,
  `author` int(11) NOT NULL,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idLesson`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_materials_track`
--

CREATE TABLE `learning_materials_track` (
  `idTrack` int(11) NOT NULL AUTO_INCREMENT,
  `idResource` int(11) NOT NULL,
  `idReference` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idTrack`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_menucourse_main`
--

CREATE TABLE `learning_menucourse_main` (
  `idMain` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL,
  `sequence` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idMain`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_menucourse_under`
--

CREATE TABLE `learning_menucourse_under` (
  `idCourse` int(11) NOT NULL,
  `idModule` int(11) NOT NULL,
  `idMain` int(11) NOT NULL,
  `sequence` int(11) NOT NULL,
  `my_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_course_idx` (`idCourse`),
  KEY `id_module_idx` (`idModule`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=19 ;

--
-- Dumping data for table `learning_menucourse_under`
--

INSERT INTO `learning_menucourse_under` VALUES
(0, 1, 0, 1, '', 1, '[[regtime]]', '[[regtime]]'),
(0, 2, 0, 2, '', 2, '[[regtime]]', '[[regtime]]'),
(0, 3, 0, 3, '', 3, '[[regtime]]', '[[regtime]]'),
(0, 4, 0, 4, '', 4, '[[regtime]]', '[[regtime]]'),
(0, 5, 0, 5, '', 5, '[[regtime]]', '[[regtime]]'),
(0, 6, 0, 6, '', 6, '[[regtime]]', '[[regtime]]'),
(0, 7, 0, 2, '', 7, '[[regtime]]', '[[regtime]]'),
(0, 8, 0, 8, '', 8, '[[regtime]]', '[[regtime]]'),
(0, 9, 0, 9, '', 9, '[[regtime]]', '[[regtime]]'),
(0, 32, 0, 4, '', 10, '[[regtime]]', '[[regtime]]'),
(0, 33, 5, 11, '', 11, '[[regtime]]', '[[regtime]]'),
(0, 34, 0, 3, '', 12, '[[regtime]]', '[[regtime]]'),
(0, 35, 1, 1, '', 13, '[[regtime]]', '[[regtime]]'),
(0, 36, 1, 2, '', 14, '[[regtime]]', '[[regtime]]'),
(0, 37, 1, 3, '', 15, '[[regtime]]', '[[regtime]]'),
(0, 38, 1, 4, '', 16, '[[regtime]]', '[[regtime]]'),
(0, 39, 1, 5, '', 17, '[[regtime]]', '[[regtime]]'),
(0, 46, 0, 3, '', 18, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `learning_menucustom`
--

CREATE TABLE `learning_menucustom` (
  `idCustom` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idCustom`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `learning_menucustom`
--

INSERT INTO `learning_menucustom` VALUES
(1, 'Standard menu', 'Menu with standard collaboration features', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `learning_menucustom_main`
--

CREATE TABLE `learning_menucustom_main` (
  `idMain` int(11) NOT NULL AUTO_INCREMENT,
  `idCustom` int(11) NOT NULL,
  `sequence` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idMain`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `learning_menucustom_main`
--

INSERT INTO `learning_menucustom_main` VALUES
(1, 1, 1, 'Student Area', '', '[[regtime]]', '[[regtime]]'),
(2, 1, 2, 'Stat Area', '', '[[regtime]]', '[[regtime]]'),
(3, 1, 3, 'Collaborative Area', '', '[[regtime]]', '[[regtime]]'),
(4, 1, 4, 'Teacher area', '', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `learning_menucustom_under`
--

CREATE TABLE `learning_menucustom_under` (
  `idCustom` int(11) NOT NULL,
  `idModule` int(11) NOT NULL,
  `idMain` int(11) NOT NULL,
  `sequence` int(11) NOT NULL,
  `my_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_custom_idx` (`idCustom`),
  KEY `id_module_idx` (`idModule`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=30 ;

--
-- Dumping data for table `learning_menucustom_under`
--

INSERT INTO `learning_menucustom_under` VALUES
(0, 1, 0, 1, '', 1, '[[regtime]]', '[[regtime]]'),
(0, 2, 0, 2, '', 2, '[[regtime]]', '[[regtime]]'),
(0, 3, 0, 3, '', 3, '[[regtime]]', '[[regtime]]'),
(0, 4, 0, 4, '', 4, '[[regtime]]', '[[regtime]]'),
(0, 5, 0, 5, '', 5, '[[regtime]]', '[[regtime]]'),
(0, 6, 0, 6, '', 6, '[[regtime]]', '[[regtime]]'),
(0, 7, 0, 7, '', 7, '[[regtime]]', '[[regtime]]'),
(0, 8, 0, 8, '', 8, '[[regtime]]', '[[regtime]]'),
(0, 9, 0, 9, '', 9, '[[regtime]]', '[[regtime]]'),
(0, 32, 0, 10, '', 10, '[[regtime]]', '[[regtime]]'),
(0, 33, 0, 11, '', 11, '[[regtime]]', '[[regtime]]'),
(1, 11, 1, 3, '', 12, '[[regtime]]', '[[regtime]]'),
(1, 12, 4, 1, '', 13, '[[regtime]]', '[[regtime]]'),
(1, 13, 1, 4, '', 14, '[[regtime]]', '[[regtime]]'),
(1, 14, 1, 5, '', 15, '[[regtime]]', '[[regtime]]'),
(1, 17, 3, 1, '', 16, '[[regtime]]', '[[regtime]]'),
(1, 18, 1, 2, '', 17, '[[regtime]]', '[[regtime]]'),
(1, 19, 3, 2, '', 18, '[[regtime]]', '[[regtime]]'),
(1, 21, 3, 3, '', 19, '[[regtime]]', '[[regtime]]'),
(1, 22, 3, 4, '', 20, '[[regtime]]', '[[regtime]]'),
(1, 24, 4, 4, '', 21, '[[regtime]]', '[[regtime]]'),
(1, 25, 1, 1, '', 22, '[[regtime]]', '[[regtime]]'),
(1, 26, 4, 2, '', 23, '[[regtime]]', '[[regtime]]'),
(1, 27, 4, 3, '', 24, '[[regtime]]', '[[regtime]]'),
(1, 28, 4, 5, '', 25, '[[regtime]]', '[[regtime]]'),
(1, 29, 2, 1, '', 26, '[[regtime]]', '[[regtime]]'),
(1, 30, 2, 2, '', 27, '[[regtime]]', '[[regtime]]'),
(1, 31, 2, 3, '', 28, '[[regtime]]', '[[regtime]]'),
(1, 42, 2, 4, '', 29, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `learning_middlearea`
--

CREATE TABLE `learning_middlearea` (
  `obj_index` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `disabled` tinyint(1) NOT NULL,
  `idst_list` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(5) NOT NULL,
  `is_home` tinyint(1) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `obj_index_idx` (`obj_index`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=15 ;

--
-- Dumping data for table `learning_middlearea`
--

INSERT INTO `learning_middlearea` VALUES
('credits', 1, 'a:0:{}', 0, 0, 1, '[[regtime]]', '[[regtime]]'),
('mo_32', 1, 'a:0:{}', 0, 0, 2, '[[regtime]]', '[[regtime]]'),
('mo_33', 1, 'a:0:{}', 0, 0, 3, '[[regtime]]', '[[regtime]]'),
('mo_34', 1, 'a:0:{}', 0, 0, 4, '[[regtime]]', '[[regtime]]'),
('mo_46', 0, 'a:0:{}', 0, 0, 5, '[[regtime]]', '[[regtime]]'),
('mo_help', 1, 'a:0:{}', 0, 0, 6, '[[regtime]]', '[[regtime]]'),
('tb_communication', 1, 'a:0:{}', 0, 0, 7, '[[regtime]]', '[[regtime]]'),
('tb_coursepath', 1, 'a:0:{}', 0, 0, 8, '[[regtime]]', '[[regtime]]'),
('tb_dashboard', 1, 'a:0:{}', 0, 0, 9, '[[regtime]]', '[[regtime]]'),
('tb_elearning', 0, 'a:0:{}', 0, 1, 10, '[[regtime]]', '[[regtime]]'),
('tb_games', 1, 'a:0:{}', 0, 0, 11, '[[regtime]]', '[[regtime]]'),
('tb_home', 1, 'a:0:{}', 0, 0, 12, '[[regtime]]', '[[regtime]]'),
('tb_kb', 1, 'a:0:{}', 0, 0, 13, '[[regtime]]', '[[regtime]]'),
('tb_videoconference', 1, 'a:0:{}', 0, 0, 14, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `learning_module`
--

CREATE TABLE `learning_module` (
  `idModule` int(11) NOT NULL AUTO_INCREMENT,
  `module_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_op` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token_associated` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_info` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mvc_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idModule`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=48 ;

--
-- Dumping data for table `learning_module`
--

INSERT INTO `learning_module` VALUES
(1, 'course', '', '_MYCOURSES', 'view', '', '', 'all', 'elearning/show', '[[regtime]]', '[[regtime]]'),
(3, 'profile', 'profile', '_PROFILE', 'view', 'class.profile.php', 'Module_Profile', '_user', '', '[[regtime]]', '[[regtime]]'),
(7, 'mycertificate', 'mycertificate', '_MY_CERTIFICATE', 'view', 'class.mycertificate.php', 'Module_MyCertificate', 'all', '', '[[regtime]]', '[[regtime]]'),
(10, 'course', 'infocourse', '_INFCOURSE', 'view_info', 'class.course.php', 'Module_Course', '', 'lms/course/infocourse', '[[regtime]]', '[[regtime]]'),
(11, 'advice', 'advice', '_ADVICE', 'view', 'class.advice.php', 'Module_Advice', '', '', '[[regtime]]', '[[regtime]]'),
(12, 'storage', 'display', '_STORAGE', 'view', 'class.storage.php', 'Module_Storage', '', 'lms/lomanager/show', '[[regtime]]', '[[regtime]]'),
(13, 'calendar', 'calendar', '_CALENDAR', 'view', 'class.calendar.php', 'Module_Calendar', '', '', '[[regtime]]', '[[regtime]]'),
(14, 'gradebook', 'showgrade', '_GRADEBOOK', 'view', 'class.gradebook.php', 'Module_Gradebook', '', '', '[[regtime]]', '[[regtime]]'),
(15, 'notes', 'notes', '_NOTES', 'view', 'class.notes.php', 'Module_Notes', '', '', '[[regtime]]', '[[regtime]]'),
(16, 'reservation', 'reservation', '_RESERVATION', 'view', 'class.reservation.php', 'Module_Reservation', '', '', '[[regtime]]', '[[regtime]]'),
(17, 'light_repo', 'repolist', '_LIGHT_REPO', 'view', 'class.light_repo.php', 'Module_Light_Repo', '', '', '[[regtime]]', '[[regtime]]'),
(18, 'htmlfront', 'showhtml', '_HTMLFRONT', 'view', 'class.htmlfront.php', 'Module_Htmlfront', '', '', '[[regtime]]', '[[regtime]]'),
(19, 'forum', 'forum', '_FORUM', 'view', 'class.forum.php', 'Module_Forum', '', '', '[[regtime]]', '[[regtime]]'),
(20, 'wiki', 'main', '_WIKI', 'view', 'class.wiki.php', 'Module_Wiki', '', '', '[[regtime]]', '[[regtime]]'),
(22, 'conference', 'list', '_VIDEOCONFERENCE', 'view', 'class.conference.php', 'Module_Conference', '', '', '[[regtime]]', '[[regtime]]'),
(23, 'project', 'project', '_PROJECT', 'view', 'class.project.php', 'Module_Project', '', '', '[[regtime]]', '[[regtime]]'),
(24, 'groups', 'groups', '_GROUPS', 'view', 'class.groups.php', 'Module_Groups', '', '', '[[regtime]]', '[[regtime]]'),
(25, 'organization', 'organization', '_ORGANIZATION', 'view', 'class.organization.php', 'Module_Organization', '', 'lms/lo/show', '[[regtime]]', '[[regtime]]'),
(26, 'coursereport', 'coursereport', '_COURSEREPORT', 'view', 'class.coursereport.php', 'Module_CourseReport', '', 'lms/coursereport/coursereport', '[[regtime]]', '[[regtime]]'),
(27, 'newsletter', 'view', '_NEWSLETTER', 'view', 'class.newsletter.php', 'Module_Newsletter', '', '', '[[regtime]]', '[[regtime]]'),
(28, 'manmenu', 'manmenu', '_MAN_MENU', 'view', 'class.manmenu.php', 'Module_CourseManmenu', '', '', '[[regtime]]', '[[regtime]]'),
(29, 'statistic', 'statistic', '_STAT', 'view', 'class.statistic.php', 'Module_Statistic', '', '', '[[regtime]]', '[[regtime]]'),
(30, 'stats', 'statuser', '_STATUSER', 'view_user', 'class.stats.php', 'Module_Stats', '', '', '[[regtime]]', '[[regtime]]'),
(31, 'stats', 'statcourse', '_STATCOURSE', 'view_course', 'class.stats.php', 'Module_Stats', '', '', '[[regtime]]', '[[regtime]]'),
(32, 'public_forum', 'forum', '_PUBLIC_FORUM', 'view', 'class.public_forum.php', 'Module_Public_Forum', 'all', '', '[[regtime]]', '[[regtime]]'),
(34, 'mycompetences', 'mycompetences', '_MYCOMPETENCES', 'view', 'class.mycompetences.php', 'Module_MyCompetences', 'all', '', '[[regtime]]', '[[regtime]]'),
(40, 'quest_bank', 'main', '_QUEST_BANK', 'view', 'class.quest_bank.php', 'Module_QuestBank', '', '', '[[regtime]]', '[[regtime]]'),
(42, 'coursestats', 'show', '_COURSESTATS', 'view', '', '', '', 'coursestats/show', '[[regtime]]', '[[regtime]]'),
(45, 'presence', '', '_PRESENCE', 'view', '', '', '', 'presence/presence', '[[regtime]]', '[[regtime]]'),
(46, 'course', '', '_CATALOGUE', 'view', '', '', 'all', 'lms/catalog/show', '[[regtime]]', '[[regtime]]'),
(47, 'dashboard', 'show', '_DASHBOARD', 'view', '', '', 'all', 'lms/dashboard/show', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `learning_news_internal`
--

CREATE TABLE `learning_news_internal` (
  `idNews` int(11) NOT NULL AUTO_INCREMENT,
  `publish_date` datetime DEFAULT NULL,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_desc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `long_desc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `important` tinyint(1) NOT NULL,
  `viewer` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idNews`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_notes`
--

CREATE TABLE `learning_notes` (
  `idNotes` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL,
  `owner` int(11) NOT NULL,
  `data` datetime DEFAULT NULL,
  `title` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `textof` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idNotes`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_organization`
--

CREATE TABLE `learning_organization` (
  `idOrg` int(11) NOT NULL AUTO_INCREMENT,
  `idParent` int(11) NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lev` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `objectType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idResource` int(11) NOT NULL,
  `idCategory` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `idAuthor` int(11) NOT NULL,
  `version` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `difficult` enum('_VERYEASY','_EASY','_MEDIUM','_DIFFICULT','_VERYDIFFICULT') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_VERYEASY',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `resource` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `objective` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dateInsert` datetime DEFAULT NULL,
  `idCourse` int(11) NOT NULL,
  `prerequisites` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `isTerminator` tinyint(1) NOT NULL,
  `idParam` int(11) NOT NULL,
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `milestone` enum('start','end','-') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '-',
  `width` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL,
  `height` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publish_from` datetime DEFAULT NULL,
  `publish_to` datetime DEFAULT NULL,
  `access` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publish_for` int(11) NOT NULL,
  `ignoreScore` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idOrg`),
  KEY `idParent` (`idParent`),
  KEY `path` (`path`),
  KEY `objectType_idRTesourse_idx` (`objectType`,`idResource`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_organization_access`
--

CREATE TABLE `learning_organization_access` (
  `idOrgAccess` int(11) NOT NULL,
  `kind` enum('user','group') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` int(11) NOT NULL,
  `params` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `value_idx` (`value`),
  KEY `kind_idx` (`kind`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci COMMENT='Access to items in area lesson (organization)' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_poll`
--

CREATE TABLE `learning_poll` (
  `id_poll` int(11) NOT NULL AUTO_INCREMENT,
  `author` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_poll`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_pollquest`
--

CREATE TABLE `learning_pollquest` (
  `id_quest` int(11) NOT NULL AUTO_INCREMENT,
  `id_poll` int(11) NOT NULL,
  `id_category` int(11) NOT NULL,
  `type_quest` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_quest` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `page` int(11) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_quest`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_pollquestanswer`
--

CREATE TABLE `learning_pollquestanswer` (
  `id_answer` int(11) NOT NULL AUTO_INCREMENT,
  `id_quest` int(11) NOT NULL,
  `sequence` int(11) NOT NULL,
  `answer` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_answer`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_pollquest_extra`
--

CREATE TABLE `learning_pollquest_extra` (
  `id_quest` int(11) NOT NULL,
  `id_answer` int(11) NOT NULL,
  `extra_info` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_quest_idx` (`id_quest`),
  KEY `id_answer_idx` (`id_answer`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_polltrack`
--

CREATE TABLE `learning_polltrack` (
  `id_track` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_reference` int(11) NOT NULL,
  `id_poll` int(11) NOT NULL,
  `date_attempt` datetime DEFAULT NULL,
  `status` enum('valid','not_complete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'not_complete',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_track`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_polltrack_answer`
--

CREATE TABLE `learning_polltrack_answer` (
  `id_track` int(11) NOT NULL,
  `id_quest` int(11) NOT NULL,
  `id_answer` int(11) NOT NULL,
  `more_info` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_track_idx` (`id_track`),
  KEY `id_quest_idx` (`id_quest`),
  KEY `id_answer_idx` (`id_answer`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_prj`
--

CREATE TABLE `learning_prj` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ptitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pgroup` int(11) NOT NULL,
  `pprog` tinyint(1) NOT NULL,
  `psfiles` tinyint(1) NOT NULL,
  `pstasks` tinyint(1) NOT NULL,
  `psnews` tinyint(1) NOT NULL,
  `pstodo` tinyint(1) NOT NULL,
  `psmsg` tinyint(1) NOT NULL,
  `cid` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_prj_files`
--

CREATE TABLE `learning_prj_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `fname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ftitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fver` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fdesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_prj_news`
--

CREATE TABLE `learning_prj_news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `ntitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ndate` date DEFAULT NULL,
  `ntxt` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_prj_tasks`
--

CREATE TABLE `learning_prj_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `tprog` tinyint(1) NOT NULL,
  `tname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tdesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_prj_todo`
--

CREATE TABLE `learning_prj_todo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `ttitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ttxt` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_prj_users`
--

CREATE TABLE `learning_prj_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `flag` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_quest_category`
--

CREATE TABLE `learning_quest_category` (
  `idCategory` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `textof` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idCategory`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_quest_type`
--

CREATE TABLE `learning_quest_type` (
  `type_quest` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_quest_idx` (`type_quest`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=10 ;

--
-- Dumping data for table `learning_quest_type`
--

INSERT INTO `learning_quest_type` VALUES
('associate', 'class.associate.php', 'Associate_Question', 8, 1, '[[regtime]]', '[[regtime]]'),
('break_page', 'class.break_page.php', 'BreakPage_Question', 10, 2, '[[regtime]]', '[[regtime]]'),
('choice', 'class.choice.php', 'Choice_Question', 1, 3, '[[regtime]]', '[[regtime]]'),
('choice_multiple', 'class.choice_multiple.php', 'ChoiceMultiple_Question', 2, 4, '[[regtime]]', '[[regtime]]'),
('extended_text', 'class.extended_text.php', 'ExtendedText_Question', 3, 5, '[[regtime]]', '[[regtime]]'),
('inline_choice', 'class.inline_choice.php', 'InlineChoice_Question', 5, 6, '[[regtime]]', '[[regtime]]'),
('text_entry', 'class.text_entry.php', 'TextEntry_Question', 4, 7, '[[regtime]]', '[[regtime]]'),
('title', 'class.title.php', 'Title_Question', 9, 8, '[[regtime]]', '[[regtime]]'),
('upload', 'class.upload.php', 'Upload_Question', 7, 9, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `learning_quest_type_poll`
--

CREATE TABLE `learning_quest_type_poll` (
  `type_quest` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_quest_idx` (`type_quest`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `learning_quest_type_poll`
--

INSERT INTO `learning_quest_type_poll` VALUES
('break_page', 'class.break_page.php', 'BreakPage_QuestionPoll', 7, 1, '[[regtime]]', '[[regtime]]'),
('choice', 'class.choice.php', 'Choice_QuestionPoll', 1, 2, '[[regtime]]', '[[regtime]]'),
('choice_multiple', 'class.choice_multiple.php', 'ChoiceMultiple_QuestionPoll', 2, 3, '[[regtime]]', '[[regtime]]'),
('course_valutation', 'class.course_valutation.php', 'CourseValutation_QuestionPoll', 5, 4, '[[regtime]]', '[[regtime]]'),
('doc_valutation', 'class.doc_valutation.php', 'DocValutation_QuestionPoll', 4, 5, '[[regtime]]', '[[regtime]]'),
('extended_text', 'class.extended_text.php', 'ExtendedText_QuestionPoll', 3, 6, '[[regtime]]', '[[regtime]]'),
('title', 'class.title.php', 'Title_QuestionPoll', 6, 7, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `learning_repo`
--

CREATE TABLE `learning_repo` (
  `idRepo` int(11) NOT NULL AUTO_INCREMENT,
  `idParent` int(11) NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lev` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `objectType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idResource` int(11) NOT NULL,
  `idCategory` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `idAuthor` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `difficult` enum('_VERYEASY','_EASY','_MEDIUM','_DIFFICULT','_VERYDIFFICULT') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_VERYEASY',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `resource` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `objective` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dateInsert` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idRepo`),
  KEY `idParent` (`idParent`),
  KEY `path` (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_report`
--

CREATE TABLE `learning_report` (
  `id_report` int(11) NOT NULL AUTO_INCREMENT,
  `report_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `use_user_selection` enum('true','false') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'true',
  `enabled` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_report`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `learning_report`
--

INSERT INTO `learning_report` VALUES
(2, 'user_report', 'Report_User', 'class.report_user.php', 'true', 1, '[[regtime]]', '[[regtime]]'),
(4, 'courses_report', 'Report_Courses', 'class.report_courses.php', 'true', 1, '[[regtime]]', '[[regtime]]'),
(5, 'aggregate_report', 'Report_Aggregate', 'class.report_aggregate.php', 'true', 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `learning_report_filter`
--

CREATE TABLE `learning_report_filter` (
  `id_filter` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_report` int(10) unsigned NOT NULL,
  `author` int(10) unsigned NOT NULL,
  `creation_date` datetime DEFAULT NULL,
  `filter_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filter_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_public` tinyint(1) NOT NULL,
  `views` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_filter`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=28 ;

--
-- Dumping data for table `learning_report_filter`
--

INSERT INTO `learning_report_filter` VALUES
(13, 4, 270, NULL, 'Courses - Users', 'a:5:{s:9:"id_report";s:1:"4";s:11:"report_name";s:15:"Courses - Users";s:11:"rows_filter";a:2:{s:11:"all_courses";b:1;s:16:"selected_courses";a:0:{}}s:23:"columns_filter_category";s:5:"users";s:14:"columns_filter";a:6:{s:9:"time_belt";a:3:{s:10:"time_range";s:1:"0";s:10:"start_date";s:0:"";s:8:"end_date";s:0:"";}s:21:"org_chart_subdivision";i:0;s:11:"showed_cols";a:7:{i:0;s:12:"_CODE_COURSE";i:1;s:12:"_NAME_COURSE";i:2;s:6:"_INSCR";i:3;s:10:"_MUSTBEGIN";i:4;s:18:"_USER_STATUS_BEGIN";i:5;s:15:"_COMPLETECOURSE";i:6;s:14:"_TOTAL_SESSION";}s:12:"show_percent";b:1;s:9:"all_users";b:1;s:5:"users";a:0:{}}}', 1, 0, '[[regtime]]', '[[regtime]]'),
(25, 2, 270, NULL, 'Users - Courses', 'a:5:{s:9:"id_report";s:1:"2";s:11:"report_name";s:15:"Users - Courses";s:11:"rows_filter";a:2:{s:5:"users";a:0:{}s:9:"all_users";b:1;}s:23:"columns_filter_category";s:7:"courses";s:14:"columns_filter";a:7:{s:21:"org_chart_subdivision";i:0;s:11:"all_courses";b:1;s:16:"selected_courses";a:0:{}s:11:"sub_filters";a:0:{}s:16:"filter_exclusive";s:1:"1";s:14:"showed_columns";a:12:{i:0;s:8:"_TH_CODE";i:1;s:25:"_TH_USER_INSCRIPTION_DATE";i:2;s:19:"_TH_USER_START_DATE";i:3;s:17:"_TH_USER_END_DATE";i:4;s:20:"_TH_LAST_ACCESS_DATE";i:5;s:15:"_TH_USER_STATUS";i:6;s:20:"_TH_USER_START_SCORE";i:7;s:20:"_TH_USER_FINAL_SCORE";i:8;s:21:"_TH_USER_COURSE_SCORE";i:9;s:23:"_TH_USER_NUMBER_SESSION";i:10;s:21:"_TH_USER_ELAPSED_TIME";i:11;s:18:"_TH_ESTIMATED_TIME";}s:13:"custom_fields";a:0:{}}}', 1, 0, '[[regtime]]', '[[regtime]]'),
(26, 2, 270, NULL, 'Users - Learning Objects', 'a:5:{s:9:"id_report";s:1:"2";s:11:"report_name";s:24:"Users - Learning Objects";s:11:"rows_filter";a:2:{s:5:"users";a:0:{}s:9:"all_users";b:1;}s:23:"columns_filter_category";s:2:"LO";s:14:"columns_filter";a:6:{s:11:"all_courses";b:1;s:16:"selected_courses";a:0:{}s:8:"lo_types";a:8:{s:3:"faq";s:3:"faq";s:8:"glossary";s:8:"glossary";s:8:"htmlpage";s:8:"htmlpage";s:4:"item";s:4:"item";s:4:"link";s:4:"link";s:4:"poll";s:4:"poll";s:8:"scormorg";s:8:"scormorg";s:4:"test";s:4:"test";}s:13:"lo_milestones";a:0:{}s:14:"showed_columns";a:8:{i:0;s:9:"user_name";i:1;s:11:"course_name";i:2;s:13:"course_status";i:3;s:7:"lo_type";i:4;s:7:"lo_name";i:5;s:12:"firstAttempt";i:6;s:11:"lastAttempt";i:7;s:9:"lo_status";}s:13:"custom_fields";a:0:{}}}', 1, 0, '[[regtime]]', '[[regtime]]'),
(27, 2, 270, NULL, 'Users - 30 Days Delay', 'a:5:{s:9:"id_report";s:1:"2";s:11:"report_name";s:21:"Users - 30 Days Delay";s:11:"rows_filter";a:2:{s:5:"users";a:0:{}s:9:"all_users";b:1;}s:23:"columns_filter_category";s:5:"delay";s:14:"columns_filter";a:9:{s:21:"report_type_completed";b:1;s:19:"report_type_started";b:1;s:21:"day_from_subscription";s:2:"30";s:20:"day_until_course_end";s:0:"";s:21:"date_until_course_end";s:0:"";s:21:"org_chart_subdivision";i:0;s:11:"all_courses";b:1;s:16:"selected_courses";a:0:{}s:14:"showed_columns";a:7:{i:0;s:9:"_LASTNAME";i:1;s:5:"_NAME";i:2;s:7:"_STATUS";i:3;s:6:"_EMAIL";i:4;s:11:"_DATE_INSCR";i:5;s:18:"_DATE_FIRST_ACCESS";i:6;s:22:"_DATE_COURSE_COMPLETED";}}}', 1, 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `learning_report_schedule`
--

CREATE TABLE `learning_report_schedule` (
  `id_report_schedule` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_report_filter` int(10) unsigned NOT NULL,
  `id_creator` int(10) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `period` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` time NOT NULL DEFAULT '00:00:00',
  `creation_date` datetime DEFAULT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `last_execution` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_report_schedule`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_report_schedule_recipient`
--

CREATE TABLE `learning_report_schedule_recipient` (
  `id_report_schedule` int(10) unsigned NOT NULL,
  `id_user` int(10) unsigned NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_report_schedule_idx` (`id_report_schedule`),
  KEY `id_user_idx` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_reservation_category`
--

CREATE TABLE `learning_reservation_category` (
  `idCategory` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `maxSubscription` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idCategory`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_reservation_events`
--

CREATE TABLE `learning_reservation_events` (
  `idEvent` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL,
  `idLaboratory` int(11) NOT NULL,
  `idCategory` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `date` date DEFAULT NULL,
  `maxUser` int(11) NOT NULL,
  `deadLine` date DEFAULT NULL,
  `fromTime` time NOT NULL DEFAULT '00:00:00',
  `toTime` time NOT NULL DEFAULT '00:00:00',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idEvent`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_reservation_perm`
--

CREATE TABLE `learning_reservation_perm` (
  `event_id` int(11) NOT NULL,
  `user_idst` int(11) NOT NULL,
  `perm` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `event_id_idx` (`event_id`),
  KEY `user_idst_idx` (`user_idst`),
  KEY `perm_idx` (`perm`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_reservation_subscribed`
--

CREATE TABLE `learning_reservation_subscribed` (
  `idstUser` int(11) NOT NULL,
  `idEvent` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idst_user_idx` (`idstUser`),
  KEY `id_event_idx` (`idEvent`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_scorm_items`
--

CREATE TABLE `learning_scorm_items` (
  `idscorm_item` int(11) NOT NULL AUTO_INCREMENT,
  `idscorm_organization` int(11) NOT NULL,
  `idscorm_parentitem` int(11) DEFAULT NULL,
  `adlcp_prerequisites` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adlcp_maxtimeallowed` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adlcp_timelimitaction` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adlcp_datafromlms` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adlcp_masteryscore` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_identifier` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `identifierref` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `idscorm_resource` int(11) DEFAULT NULL,
  `isvisible` set('true','false') COLLATE utf8mb4_unicode_ci DEFAULT 'true',
  `parameters` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nChild` int(11) NOT NULL,
  `nDescendant` int(11) NOT NULL,
  `adlcp_completionthreshold` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idscorm_item`),
  UNIQUE KEY `idscorm_organization` (`idscorm_organization`,`item_identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_scorm_items_track`
--

CREATE TABLE `learning_scorm_items_track` (
  `idscorm_item_track` int(11) NOT NULL AUTO_INCREMENT,
  `idscorm_organization` int(11) NOT NULL,
  `idscorm_item` int(11) DEFAULT NULL,
  `idReference` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `idscorm_tracking` int(11) DEFAULT NULL,
  `status` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'not attempted',
  `nChild` int(11) NOT NULL,
  `nChildCompleted` int(11) NOT NULL,
  `nDescendant` int(11) NOT NULL,
  `nDescendantCompleted` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idscorm_item_track`),
  KEY `idscorm_organization` (`idscorm_organization`),
  KEY `idscorm_item` (`idscorm_item`),
  KEY `idUser` (`idUser`),
  KEY `idscorm_tracking` (`idscorm_tracking`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci COMMENT='Join table 3 factor' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_scorm_organizations`
--

CREATE TABLE `learning_scorm_organizations` (
  `idscorm_organization` int(11) NOT NULL AUTO_INCREMENT,
  `org_identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idscorm_package` int(11) NOT NULL,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nChild` int(11) NOT NULL,
  `nDescendant` int(11) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idscorm_organization`),
  UNIQUE KEY `idsco_package_unique` (`org_identifier`,`idscorm_package`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_scorm_package`
--

CREATE TABLE `learning_scorm_package` (
  `idscorm_package` int(11) NOT NULL AUTO_INCREMENT,
  `idpackage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idProg` int(11) NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `defaultOrg` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idUser` int(11) NOT NULL,
  `scormVersion` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1.2',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idscorm_package`),
  KEY `idUser` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_scorm_resources`
--

CREATE TABLE `learning_scorm_resources` (
  `idscorm_resource` int(11) NOT NULL AUTO_INCREMENT,
  `idsco` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `idscorm_package` int(11) NOT NULL,
  `scormtype` set('sco','asset') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `href` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idscorm_resource`),
  UNIQUE KEY `idsco_package_unique` (`idsco`,`idscorm_package`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_scorm_tracking`
--

CREATE TABLE `learning_scorm_tracking` (
  `idscorm_tracking` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `idReference` int(11) NOT NULL,
  `idscorm_item` int(11) NOT NULL,
  `user_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lesson_location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lesson_status` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entry` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `score_raw` float DEFAULT NULL,
  `score_max` float DEFAULT NULL,
  `score_min` float DEFAULT NULL,
  `total_time` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT '0000:00:00.00',
  `lesson_mode` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `exit` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `session_time` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `suspend_data` blob,
  `launch_data` blob,
  `comments` blob,
  `comments_from_lms` blob,
  `xmldata` longblob,
  `first_access` datetime DEFAULT NULL,
  `last_access` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idscorm_tracking`),
  UNIQUE KEY `Unique_tracking_usersco` (`idUser`,`idReference`,`idscorm_item`),
  KEY `idUser` (`idUser`),
  KEY `idscorm_resource` (`idReference`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_scorm_tracking_history`
--

CREATE TABLE `learning_scorm_tracking_history` (
  `idscorm_tracking` int(11) NOT NULL,
  `date_action` datetime DEFAULT NULL,
  `score_raw` float DEFAULT NULL,
  `score_max` float DEFAULT NULL,
  `session_time` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lesson_status` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idscorm_tracking_idx` (`idscorm_tracking`),
  KEY `date_action_idx` (`date_action`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_statuschangelog`
--

CREATE TABLE `learning_statuschangelog` (
  `idUser` int(11) NOT NULL,
  `idCourse` int(11) NOT NULL,
  `status_user` tinyint(1) NOT NULL,
  `when_do` datetime DEFAULT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `when_do_idx` (`when_do`),
  KEY `id_user_idx` (`idUser`),
  KEY `id_course_idx` (`idCourse`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_sysforum`
--

CREATE TABLE `learning_sysforum` (
  `idMessage` int(11) NOT NULL AUTO_INCREMENT,
  `key1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key2` int(11) NOT NULL,
  `key3` int(11) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `textof` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `posted` datetime DEFAULT NULL,
  `author` int(11) NOT NULL,
  `attach` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locked` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idMessage`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_teacher_profile`
--

CREATE TABLE `learning_teacher_profile` (
  `id_user` int(11) NOT NULL,
  `curriculum` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `publications` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_user_idx` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_test`
--

CREATE TABLE `learning_test` (
  `idTest` int(11) NOT NULL AUTO_INCREMENT,
  `author` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `point_type` tinyint(1) NOT NULL,
  `point_required` double NOT NULL,
  `display_type` tinyint(1) NOT NULL,
  `order_type` tinyint(1) NOT NULL,
  `shuffle_answer` tinyint(1) NOT NULL,
  `question_random_number` int(11) NOT NULL,
  `save_keep` tinyint(1) NOT NULL,
  `mod_doanswer` tinyint(1) NOT NULL DEFAULT '1',
  `can_travel` tinyint(1) NOT NULL DEFAULT '1',
  `show_only_status` tinyint(1) NOT NULL,
  `show_score` tinyint(1) NOT NULL DEFAULT '1',
  `show_score_cat` tinyint(1) NOT NULL,
  `show_doanswer` tinyint(1) NOT NULL,
  `show_solution` tinyint(1) NOT NULL,
  `time_dependent` tinyint(1) NOT NULL,
  `time_assigned` int(11) NOT NULL,
  `penality_test` tinyint(1) NOT NULL,
  `penality_time_test` double NOT NULL,
  `penality_quest` tinyint(1) NOT NULL,
  `penality_time_quest` double NOT NULL,
  `max_attempt` int(11) NOT NULL,
  `hide_info` tinyint(1) NOT NULL,
  `order_info` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `cf_info` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `use_suspension` tinyint(1) NOT NULL,
  `suspension_num_attempts` int(10) unsigned NOT NULL,
  `suspension_num_hours` int(10) unsigned NOT NULL,
  `suspension_prerequisites` tinyint(1) NOT NULL,
  `chart_options` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `mandatory_answer` tinyint(1) NOT NULL,
  `score_max` int(11) NOT NULL,
  `obj_type` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT 'test',
  `retain_answers_history` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `show_quest_score` tinyint(1) NOT NULL,
  PRIMARY KEY (`idTest`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_testquest`
--

CREATE TABLE `learning_testquest` (
  `idQuest` int(11) NOT NULL AUTO_INCREMENT,
  `idTest` int(11) NOT NULL,
  `idCategory` int(11) NOT NULL,
  `type_quest` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_quest` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `difficult` int(1) NOT NULL DEFAULT '3',
  `time_assigned` int(11) NOT NULL,
  `sequence` int(11) NOT NULL,
  `page` int(11) NOT NULL,
  `shuffle` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idQuest`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_testquestanswer`
--

CREATE TABLE `learning_testquestanswer` (
  `idAnswer` int(11) NOT NULL AUTO_INCREMENT,
  `idQuest` int(11) NOT NULL,
  `sequence` int(11) NOT NULL,
  `is_correct` int(11) NOT NULL,
  `answer` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `score_correct` double NOT NULL,
  `score_incorrect` double NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idAnswer`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_testquestanswer_associate`
--

CREATE TABLE `learning_testquestanswer_associate` (
  `idAnswer` int(11) NOT NULL AUTO_INCREMENT,
  `idQuest` int(11) NOT NULL,
  `answer` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idAnswer`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_testquest_extra`
--

CREATE TABLE `learning_testquest_extra` (
  `idQuest` int(11) NOT NULL,
  `idAnswer` int(11) NOT NULL,
  `extra_info` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_quest_idx` (`idQuest`),
  KEY `id_answer_idx` (`idAnswer`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_testtrack`
--

CREATE TABLE `learning_testtrack` (
  `idTrack` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `idReference` int(11) NOT NULL,
  `idTest` int(11) NOT NULL,
  `date_attempt` datetime DEFAULT NULL,
  `date_attempt_mod` datetime DEFAULT NULL,
  `date_end_attempt` datetime DEFAULT NULL,
  `last_page_seen` int(11) NOT NULL,
  `last_page_saved` int(11) NOT NULL,
  `number_of_save` int(11) NOT NULL,
  `number_of_attempt` int(11) NOT NULL,
  `score` double DEFAULT NULL,
  `bonus_score` double NOT NULL,
  `score_status` enum('valid','not_checked','not_passed','passed','not_complete','doing') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'not_complete',
  `comment` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts_for_suspension` int(10) unsigned NOT NULL,
  `suspended_until` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idTrack`),
  KEY `idTest_idUser_idx` (`idTest`,`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_testtrack_answer`
--

CREATE TABLE `learning_testtrack_answer` (
  `idTrack` int(11) NOT NULL,
  `idQuest` int(11) NOT NULL,
  `idAnswer` int(11) NOT NULL,
  `score_assigned` double NOT NULL,
  `more_info` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `manual_assigned` tinyint(1) NOT NULL,
  `user_answer` tinyint(1) DEFAULT NULL,
  `number_time` tinyint(4) NOT NULL DEFAULT '1',
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `number_time_idx` (`number_time`),
  KEY `id_track_idx` (`idTrack`),
  KEY `id_quest_idx` (`idQuest`),
  KEY `id_answer_idx` (`idAnswer`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_testtrack_page`
--

CREATE TABLE `learning_testtrack_page` (
  `idTrack` int(11) NOT NULL,
  `page` int(11) NOT NULL,
  `display_from` datetime DEFAULT NULL,
  `display_to` datetime DEFAULT NULL,
  `accumulated` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `page_idx` (`page`),
  KEY `id_track_idx` (`idTrack`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_testtrack_quest`
--

CREATE TABLE `learning_testtrack_quest` (
  `idTrack` int(11) NOT NULL,
  `idQuest` int(11) NOT NULL,
  `page` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_track_idx` (`idTrack`),
  KEY `id_quest_idx` (`idQuest`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_testtrack_times`
--

CREATE TABLE `learning_testtrack_times` (
  `idTrack` int(11) NOT NULL,
  `idReference` int(11) NOT NULL,
  `idTest` int(11) NOT NULL,
  `date_attempt` datetime DEFAULT NULL,
  `number_time` tinyint(1) NOT NULL,
  `score` double NOT NULL,
  `score_status` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_begin` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `time` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `number_time_idx` (`number_time`),
  KEY `id_track_idx` (`idTrack`),
  KEY `id_test_idx` (`idTest`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_time_period`
--

CREATE TABLE `learning_time_period` (
  `id_period` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_period`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_trackingeneral`
--

CREATE TABLE `learning_trackingeneral` (
  `idTrack` int(11) NOT NULL AUTO_INCREMENT,
  `idEnter` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `idCourse` int(11) NOT NULL,
  `session_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `function` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timeof` datetime DEFAULT NULL,
  `ip` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idTrack`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_tracksession`
--

CREATE TABLE `learning_tracksession` (
  `idEnter` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL,
  `idUser` int(11) NOT NULL,
  `session_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enterTime` datetime DEFAULT NULL,
  `numOp` int(11) NOT NULL,
  `lastFunction` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastOp` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastTime` datetime DEFAULT NULL,
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idEnter`),
  KEY `idUser_active_idx` (`idUser`,`active`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_transaction`
--

CREATE TABLE `learning_transaction` (
  `id_transaction` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `date` datetime DEFAULT NULL,
  `date_confirm` datetime DEFAULT NULL,
  `price` int(11) NOT NULL,
  `payment_status` tinyint(1) NOT NULL,
  `course_status` tinyint(1) NOT NULL,
  `method` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_note` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `course_note` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_transaction`),
  KEY `id_user` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_transaction_info`
--

CREATE TABLE `learning_transaction_info` (
  `id_transaction` int(11) NOT NULL,
  `id_course` int(11) NOT NULL,
  `id_date` int(11) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_transaction_idx` (`id_transaction`),
  KEY `id_course_idx` (`id_course`),
  KEY `id_date_idx` (`id_date`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_webpages`
--

CREATE TABLE `learning_webpages` (
  `idPages` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sequence` int(11) NOT NULL,
  `publish` tinyint(1) NOT NULL,
  `in_home` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idPages`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `learning_wiki_course`
--

CREATE TABLE `learning_wiki_course` (
  `course_id` int(11) NOT NULL,
  `wiki_id` int(11) NOT NULL,
  `is_owner` tinyint(1) NOT NULL,
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `course_id_idx` (`course_id`),
  KEY `wiki_id_idx` (`wiki_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
