<?php
/*
 * Fusio - Self-Hosted API Management for Builders.
 * For the current version and information visit <https://www.fusio-project.org/>
 *
 * Copyright (c) Christoph Kappestein <christoph.kappestein@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace Fusio\Impl\Tests\Backend\Api\Generator;

use Fusio\Impl\Tests\DbTestCase;

/**
 * GetIndexTest
 *
 * @author  Christoph Kappestein <christoph.kappestein@gmail.com>
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @link    https://www.fusio-project.org
 */
class GetIndexTest extends DbTestCase
{
    public function testGet()
    {
        $response = $this->sendRequest('/backend/generator', 'GET', array(
            'User-Agent'    => 'Fusio TestCase',
            'Authorization' => 'Bearer da250526d583edabca8ac2f99e37ee39aa02a3c076c0edc6929095e20ca18dcf'
        ));

        $body   = (string) $response->getBody();
        $expect = <<<'JSON'
{
    "providers": [
        {
            "name": "File-Directory",
            "class": "Fusio.Adapter.File.Generator.FileDirectory"
        },
        {
            "name": "Import-Insomnia",
            "class": "Fusio.Impl.Provider.Generator.Insomnia"
        },
        {
            "name": "Import-OpenAPI",
            "class": "Fusio.Impl.Provider.Generator.OpenAPI"
        },
        {
            "name": "Import-Postman",
            "class": "Fusio.Impl.Provider.Generator.Postman"
        },
        {
            "name": "Redis-Hash",
            "class": "Fusio.Adapter.Redis.Generator.RedisHash"
        },
        {
            "name": "SQL-Database",
            "class": "Fusio.Adapter.Sql.Generator.SqlDatabase"
        },
        {
            "name": "SQL-Entity",
            "class": "Fusio.Adapter.Sql.Generator.SqlEntity"
        },
        {
            "name": "SQL-Table",
            "class": "Fusio.Adapter.Sql.Generator.SqlTable"
        },
        {
            "name": "Test-Provider",
            "class": "Fusio.Impl.Tests.Service.Generator.TestProvider"
        }
    ]
}
JSON;

        $this->assertEquals(200, $response->getStatusCode(), $body);
        $this->assertJsonStringEqualsJsonString($expect, $body, $body);
    }

    public function testPost()
    {
        $response = $this->sendRequest('/backend/generator', 'POST', array(
            'User-Agent'    => 'Fusio TestCase',
            'Authorization' => 'Bearer da250526d583edabca8ac2f99e37ee39aa02a3c076c0edc6929095e20ca18dcf'
        ), json_encode([
            'foo' => 'bar',
        ]));

        $body = (string) $response->getBody();

        $this->assertEquals(404, $response->getStatusCode(), $body);
    }

    public function testPut()
    {
        $response = $this->sendRequest('/backend/generator', 'PUT', array(
            'User-Agent'    => 'Fusio TestCase',
            'Authorization' => 'Bearer da250526d583edabca8ac2f99e37ee39aa02a3c076c0edc6929095e20ca18dcf'
        ), json_encode([
            'foo' => 'bar',
        ]));

        $body = (string) $response->getBody();

        $this->assertEquals(404, $response->getStatusCode(), $body);
    }

    public function testDelete()
    {
        $response = $this->sendRequest('/backend/generator', 'DELETE', array(
            'User-Agent'    => 'Fusio TestCase',
            'Authorization' => 'Bearer da250526d583edabca8ac2f99e37ee39aa02a3c076c0edc6929095e20ca18dcf'
        ), json_encode([
            'foo' => 'bar',
        ]));

        $body = (string) $response->getBody();

        $this->assertEquals(404, $response->getStatusCode(), $body);
    }
}
