<?php
/*
 * Fusio - Self-Hosted API Management for Builders.
 * For the current version and information visit <https://www.fusio-project.org/>
 *
 * Copyright (c) Christoph Kappestein <christoph.kappestein@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace Fusio\Impl\Tests\Consumer\Api\Identity;

use Fusio\Impl\Tests\DbTestCase;
use PSX\Uri\Url;

/**
 * RedirectTest
 *
 * @author  Christoph Kappestein <christoph.kappestein@gmail.com>
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @link    https://www.fusio-project.org
 */
class RedirectTest extends DbTestCase
{
    public function testGet()
    {
        $response = $this->sendRequest('/consumer/identity/1/redirect', 'GET', array(
            'User-Agent'    => 'Fusio TestCase',
            'Authorization' => 'Bearer b8f6f61bd22b440a3e4be2b7491066682bfcde611dbefa1b15d2e7f6522d77e2'
        ));

        $body = (string) $response->getBody();

        $url = Url::parse($response->getHeader('Location'));
        $parameters = $url->getParameters();

        $this->assertEquals(302, $response->getStatusCode(), $body);
        $this->assertEquals('code', $parameters['response_type']);
        $this->assertEquals('facebook-key', $parameters['client_id']);
        $this->assertNotEmpty($parameters['state']);
        $this->assertEquals('http://127.0.0.1/consumer/identity/1/exchange', $parameters['redirect_uri']);
    }

    public function testGetRedirect()
    {
        $response = $this->sendRequest('/consumer/identity/1/redirect?redirect_uri=' . urlencode('http://127.0.0.1/callback'), 'GET', array(
            'User-Agent'    => 'Fusio TestCase',
            'Authorization' => 'Bearer b8f6f61bd22b440a3e4be2b7491066682bfcde611dbefa1b15d2e7f6522d77e2'
        ));

        $body = (string) $response->getBody();

        $this->assertEquals(302, $response->getStatusCode(), $body);

        $url = Url::parse($response->getHeader('Location'));
        $parameters = $url->getParameters();

        $this->assertEquals('code', $parameters['response_type']);
        $this->assertEquals('facebook-key', $parameters['client_id']);
        $this->assertNotEmpty($parameters['state']);
        $this->assertEquals('http://127.0.0.1/consumer/identity/1/exchange', $parameters['redirect_uri']);
    }

    public function testPost()
    {
        $response = $this->sendRequest('/consumer/identity/1/redirect', 'POST', array(
            'User-Agent'    => 'Fusio TestCase',
            'Authorization' => 'Bearer b8f6f61bd22b440a3e4be2b7491066682bfcde611dbefa1b15d2e7f6522d77e2'
        ), json_encode([
            'foo' => 'bar',
        ]));

        $body = (string) $response->getBody();

        $this->assertEquals(404, $response->getStatusCode(), $body);
    }

    public function testPut()
    {
        $response = $this->sendRequest('/consumer/identity', 'PUT', array(
            'User-Agent'    => 'Fusio TestCase',
            'Authorization' => 'Bearer b8f6f61bd22b440a3e4be2b7491066682bfcde611dbefa1b15d2e7f6522d77e2'
        ), json_encode([
            'foo' => 'bar',
        ]));

        $body = (string) $response->getBody();

        $this->assertEquals(404, $response->getStatusCode(), $body);
    }

    public function testDelete()
    {
        $response = $this->sendRequest('/consumer/identity/1/redirect', 'DELETE', array(
            'User-Agent'    => 'Fusio TestCase',
            'Authorization' => 'Bearer b8f6f61bd22b440a3e4be2b7491066682bfcde611dbefa1b15d2e7f6522d77e2'
        ), json_encode([
            'foo' => 'bar',
        ]));

        $body = (string) $response->getBody();

        $this->assertEquals(404, $response->getStatusCode(), $body);
    }
}
