<?php
/**
 * Client automatically generated by SDKgen please do not edit this file manually
 * @see https://sdkgen.app
 */

namespace Foo\Bar;

use GuzzleHttp\Exception\BadResponseException;
use Sdkgen\Client\ClientAbstract;
use Sdkgen\Client\Credentials;
use Sdkgen\Client\CredentialsInterface;
use Sdkgen\Client\Exception\ClientException;
use Sdkgen\Client\Exception\Payload;
use Sdkgen\Client\Exception\UnknownStatusCodeException;
use Sdkgen\Client\TokenStoreInterface;

class Client extends ClientAbstract
{
    /**
     * @param \Psr\Http\Message\StreamInterface $body
     * @return \Psr\Http\Message\StreamInterface
     * @throws BinaryException
     * @throws ClientException
     */
    public function binary(\Psr\Http\Message\StreamInterface $body): \Psr\Http\Message\StreamInterface
    {
        $url = $this->parser->url('/binary', [
        ]);

        $options = [
            'headers' => [
                'Content-Type' => 'application/octet-stream',
                'Accept' => 'application/octet-stream',
            ],
            'query' => $this->parser->query([
            ], [
            ]),
            'body' => $body,
        ];

        try {
            $response = $this->httpClient->request('POST', $url, $options);
            $body = $response->getBody();

            $data = $body;

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode >= 0 && $statusCode <= 999) {
                $data = $body;

                throw new BinaryException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }

    /**
     * @param array $body
     * @return array
     * @throws FormException
     * @throws ClientException
     */
    public function form(array $body): array
    {
        $url = $this->parser->url('/form', [
        ]);

        $options = [
            'headers' => [
                'Content-Type' => 'application/x-www-form-urlencoded',
                'Accept' => 'application/x-www-form-urlencoded',
            ],
            'query' => $this->parser->query([
            ], [
            ]),
            'form_params' => $body,
        ];

        try {
            $response = $this->httpClient->request('POST', $url, $options);
            $body = $response->getBody();

            $data = [];
            parse_str((string) $body, $data);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode >= 500 && $statusCode <= 599) {
                $data = [];
                parse_str((string) $body, $data);

                throw new FormException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }

    /**
     * @param mixed $body
     * @return mixed
     * @throws JsonException
     * @throws ClientException
     */
    public function json(mixed $body): mixed
    {
        $url = $this->parser->url('/json', [
        ]);

        $options = [
            'headers' => [
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
            ],
            'query' => $this->parser->query([
            ], [
            ]),
            'json' => $body,
        ];

        try {
            $response = $this->httpClient->request('POST', $url, $options);
            $body = $response->getBody();

            $data = \json_decode((string) $body);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode >= 400 && $statusCode <= 499) {
                $data = \json_decode((string) $body);

                throw new JsonException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }

    /**
     * @param \Sdkgen\Client\Multipart $body
     * @return \Sdkgen\Client\Multipart
     * @throws MultipartException
     * @throws ClientException
     */
    public function multipart(\Sdkgen\Client\Multipart $body): \Sdkgen\Client\Multipart
    {
        $url = $this->parser->url('/multipart', [
        ]);

        $options = [
            'headers' => [
                'Accept' => 'multipart/form-data',
            ],
            'query' => $this->parser->query([
            ], [
            ]),
            'multipart' => $body->getParts(),
        ];

        try {
            $response = $this->httpClient->request('POST', $url, $options);
            $body = $response->getBody();

            // @TODO currently not possible, please create an issue at https://github.com/apioo/psx-api if needed
            $data = new \Sdkgen\Client\Multipart();

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode === 500) {
                // @TODO currently not possible, please create an issue at https://github.com/apioo/psx-api if needed
                $data = new \Sdkgen\Client\Multipart();

                throw new MultipartException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }

    /**
     * @param string $body
     * @return string
     * @throws TextException
     * @throws ClientException
     */
    public function text(string $body): string
    {
        $url = $this->parser->url('/text', [
        ]);

        $options = [
            'headers' => [
                'Content-Type' => 'text/plain',
                'Accept' => 'text/plain',
            ],
            'query' => $this->parser->query([
            ], [
            ]),
            'body' => $body,
        ];

        try {
            $response = $this->httpClient->request('POST', $url, $options);
            $body = $response->getBody();

            $data = (string) $body;

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode === 500) {
                $data = (string) $body;

                throw new TextException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }

    /**
     * @param string $body
     * @return string
     * @throws XmlException
     * @throws ClientException
     */
    public function xml(string $body): string
    {
        $url = $this->parser->url('/xml', [
        ]);

        $options = [
            'headers' => [
                'Content-Type' => 'application/xml',
                'Accept' => 'application/xml',
            ],
            'query' => $this->parser->query([
            ], [
            ]),
            'body' => $body,
        ];

        try {
            $response = $this->httpClient->request('POST', $url, $options);
            $body = $response->getBody();

            $data = (string) $body;

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode === 500) {
                $data = (string) $body;

                throw new XmlException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }





    public static function buildAnonymous(): self
    {
        return new self('http://api.foo.com', new Credentials\Anonymous());
    }
}
