/**
 * Client automatically generated by SDKgen please do not edit this file manually
 * {@link https://sdkgen.app}
 */

import {ClientAbstract, CredentialsInterface, TokenStoreInterface, HttpRequest} from "sdkgen-client"
import {Anonymous} from "sdkgen-client"
import {ClientException, UnknownStatusCodeException} from "sdkgen-client";

import {BinaryException} from "./BinaryException";
import {FormException} from "./FormException";
import {JsonException} from "./JsonException";
import {MultipartException} from "./MultipartException";
import {TextException} from "./TextException";
import {XmlException} from "./XmlException";

export class Client extends ClientAbstract {
    /**
     * @returns {Promise<ArrayBuffer>}
     * @throws {BinaryException}
     * @throws {ClientException}
     */
    public async binary(body: ArrayBuffer): Promise<ArrayBuffer> {
        const url = this.parser.url('/binary', {
        });

        let request: HttpRequest = {
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'application/octet-stream',
                'Accept': 'application/octet-stream',
            },
            params: this.parser.query({
            }, [
            ]),
            data: body
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.arrayBuffer();
        }

        const statusCode = response.status;
        if (statusCode >= 0 && statusCode <= 999) {
            throw new BinaryException(await response.arrayBuffer());
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * @returns {Promise<URLSearchParams>}
     * @throws {FormException}
     * @throws {ClientException}
     */
    public async form(body: URLSearchParams): Promise<URLSearchParams> {
        const url = this.parser.url('/form', {
        });

        let request: HttpRequest = {
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
                'Accept': 'application/x-www-form-urlencoded',
            },
            params: this.parser.query({
            }, [
            ]),
            data: body
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return new URLSearchParams(await response.formData() as any);
        }

        const statusCode = response.status;
        if (statusCode >= 500 && statusCode <= 599) {
            throw new FormException(new URLSearchParams(await response.formData() as any));
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * @returns {Promise<any>}
     * @throws {JsonException}
     * @throws {ClientException}
     */
    public async json(body: any): Promise<any> {
        const url = this.parser.url('/json', {
        });

        let request: HttpRequest = {
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
            },
            params: this.parser.query({
            }, [
            ]),
            data: body
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json();
        }

        const statusCode = response.status;
        if (statusCode >= 400 && statusCode <= 499) {
            throw new JsonException(await response.json());
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * @returns {Promise<FormData>}
     * @throws {MultipartException}
     * @throws {ClientException}
     */
    public async multipart(body: FormData): Promise<FormData> {
        const url = this.parser.url('/multipart', {
        });

        let request: HttpRequest = {
            url: url,
            method: 'POST',
            headers: {
                'Accept': 'multipart/form-data',
            },
            params: this.parser.query({
            }, [
            ]),
            data: body
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.formData();
        }

        const statusCode = response.status;
        if (statusCode === 500) {
            throw new MultipartException(await response.formData());
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * @returns {Promise<string>}
     * @throws {TextException}
     * @throws {ClientException}
     */
    public async text(body: string): Promise<string> {
        const url = this.parser.url('/text', {
        });

        let request: HttpRequest = {
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'text/plain',
                'Accept': 'text/plain',
            },
            params: this.parser.query({
            }, [
            ]),
            data: body
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.text();
        }

        const statusCode = response.status;
        if (statusCode === 500) {
            throw new TextException(await response.text());
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * @returns {Promise<string>}
     * @throws {XmlException}
     * @throws {ClientException}
     */
    public async xml(body: string): Promise<string> {
        const url = this.parser.url('/xml', {
        });

        let request: HttpRequest = {
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'application/xml',
                'Accept': 'application/xml',
            },
            params: this.parser.query({
            }, [
            ]),
            data: body
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.text();
        }

        const statusCode = response.status;
        if (statusCode === 500) {
            throw new XmlException(await response.text());
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }





    public static buildAnonymous(): Client
    {
        return new Client('http://api.foo.com', new Anonymous());
    }
}
