<?php
/**
 * CommentsTag automatically generated by SDKgen please do not edit this file manually
 * @see https://sdkgen.app
 */

namespace SdkFabric\Airtable;

use GuzzleHttp\Exception\BadResponseException;
use Sdkgen\Client\Exception\ClientException;
use Sdkgen\Client\Exception\Payload;
use Sdkgen\Client\Exception\UnknownStatusCodeException;
use Sdkgen\Client\TagAbstract;

class CommentsTag extends TagAbstract
{
    /**
     * Returns a list of comments for the record from newest to oldest.
     *
     * @param string $baseId
     * @param string $tableIdOrName
     * @param string $recordId
     * @return CommentCollection
     * @throws ErrorException
     * @throws ClientException
     */
    public function getAll(string $baseId, string $tableIdOrName, string $recordId): CommentCollection
    {
        $url = $this->parser->url('/v0/:baseId/:tableIdOrName/:recordId/comments', [
            'baseId' => $baseId,
            'tableIdOrName' => $tableIdOrName,
            'recordId' => $recordId,
        ]);

        $options = [
            'headers' => [
            ],
            'query' => $this->parser->query([
            ], [
            ]),
        ];

        try {
            $response = $this->httpClient->request('GET', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, CommentCollection::class);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode === 400) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 403) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 404) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 500) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }

    /**
     * Creates a comment on a record. User mentioned is supported.
     *
     * @param string $baseId
     * @param string $tableIdOrName
     * @param string $recordId
     * @param Comment $payload
     * @return Comment
     * @throws ErrorException
     * @throws ClientException
     */
    public function create(string $baseId, string $tableIdOrName, string $recordId, Comment $payload): Comment
    {
        $url = $this->parser->url('/v0/:baseId/:tableIdOrName/:recordId/comments', [
            'baseId' => $baseId,
            'tableIdOrName' => $tableIdOrName,
            'recordId' => $recordId,
        ]);

        $options = [
            'headers' => [
                'Content-Type' => 'application/json',
            ],
            'query' => $this->parser->query([
            ], [
            ]),
            'json' => $payload,
        ];

        try {
            $response = $this->httpClient->request('POST', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, Comment::class);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode === 400) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 403) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 404) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 500) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }

    /**
     * Updates a comment on a record. API users can only update comments they have created. User mentioned is supported.
     *
     * @param string $baseId
     * @param string $tableIdOrName
     * @param string $recordId
     * @param string $rowCommentId
     * @param Comment $payload
     * @return Comment
     * @throws ErrorException
     * @throws ClientException
     */
    public function update(string $baseId, string $tableIdOrName, string $recordId, string $rowCommentId, Comment $payload): Comment
    {
        $url = $this->parser->url('/v0/:baseId/:tableIdOrName/:recordId/comments/:rowCommentId', [
            'baseId' => $baseId,
            'tableIdOrName' => $tableIdOrName,
            'recordId' => $recordId,
            'rowCommentId' => $rowCommentId,
        ]);

        $options = [
            'headers' => [
                'Content-Type' => 'application/json',
            ],
            'query' => $this->parser->query([
            ], [
            ]),
            'json' => $payload,
        ];

        try {
            $response = $this->httpClient->request('PATCH', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, Comment::class);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode === 400) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 403) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 404) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 500) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }

    /**
     * Deletes a comment from a record. Non-admin API users can only delete comments they have created. Enterprise Admins can delete any comment from a record.
     *
     * @param string $baseId
     * @param string $tableIdOrName
     * @param string $recordId
     * @param string $rowCommentId
     * @return DeleteResponse
     * @throws ErrorException
     * @throws ClientException
     */
    public function delete(string $baseId, string $tableIdOrName, string $recordId, string $rowCommentId): DeleteResponse
    {
        $url = $this->parser->url('/v0/:baseId/:tableIdOrName/:recordId/comments/:rowCommentId', [
            'baseId' => $baseId,
            'tableIdOrName' => $tableIdOrName,
            'recordId' => $recordId,
            'rowCommentId' => $rowCommentId,
        ]);

        $options = [
            'headers' => [
            ],
            'query' => $this->parser->query([
            ], [
            ]),
        ];

        try {
            $response = $this->httpClient->request('DELETE', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, DeleteResponse::class);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode === 400) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 403) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 404) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 500) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }



}
