<?php
/**
 * FieldsTag automatically generated by SDKgen please do not edit this file manually
 * @see https://sdkgen.app
 */

namespace SdkFabric\Airtable;

use GuzzleHttp\Exception\BadResponseException;
use Sdkgen\Client\Exception\ClientException;
use Sdkgen\Client\Exception\Payload;
use Sdkgen\Client\Exception\UnknownStatusCodeException;
use Sdkgen\Client\TagAbstract;

class FieldsTag extends TagAbstract
{
    /**
     * Creates a new column and returns the schema for the newly created column.
     *
     * @param string $baseId
     * @param string $tableId
     * @param Field $payload
     * @return Field
     * @throws ErrorException
     * @throws ClientException
     */
    public function create(string $baseId, string $tableId, Field $payload): Field
    {
        $url = $this->parser->url('/v0/meta/bases/:baseId/tables/:tableId/fields', [
            'baseId' => $baseId,
            'tableId' => $tableId,
        ]);

        $options = [
            'headers' => [
                'Content-Type' => 'application/json',
            ],
            'query' => $this->parser->query([
            ], [
            ]),
            'json' => $payload,
        ];

        try {
            $response = $this->httpClient->request('POST', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, Field::class);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode === 400) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 403) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 404) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 500) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }

    /**
     * Updates the name and/or description of a field. At least one of name or description must be specified.
     *
     * @param string $baseId
     * @param string $tableId
     * @param string $columnId
     * @param Field $payload
     * @return Field
     * @throws ErrorException
     * @throws ClientException
     */
    public function update(string $baseId, string $tableId, string $columnId, Field $payload): Field
    {
        $url = $this->parser->url('/v0/meta/bases/:baseId/tables/:tableId/fields/:columnId', [
            'baseId' => $baseId,
            'tableId' => $tableId,
            'columnId' => $columnId,
        ]);

        $options = [
            'headers' => [
                'Content-Type' => 'application/json',
            ],
            'query' => $this->parser->query([
            ], [
            ]),
            'json' => $payload,
        ];

        try {
            $response = $this->httpClient->request('PATCH', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, Field::class);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode === 400) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 403) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 404) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 500) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }



}
