<?php
/**
 * TablesTag automatically generated by SDKgen please do not edit this file manually
 * @see https://sdkgen.app
 */

namespace SdkFabric\Airtable;

use GuzzleHttp\Exception\BadResponseException;
use Sdkgen\Client\Exception\ClientException;
use Sdkgen\Client\Exception\Payload;
use Sdkgen\Client\Exception\UnknownStatusCodeException;
use Sdkgen\Client\TagAbstract;

class TablesTag extends TagAbstract
{
    /**
     * Creates a new table and returns the schema for the newly created table.
     *
     * @param string $baseId
     * @param Table $payload
     * @return Table
     * @throws ErrorException
     * @throws ClientException
     */
    public function create(string $baseId, Table $payload): Table
    {
        $url = $this->parser->url('/v0/meta/bases/:baseId/tables', [
            'baseId' => $baseId,
        ]);

        $options = [
            'headers' => [
                'Content-Type' => 'application/json',
            ],
            'query' => $this->parser->query([
            ], [
            ]),
            'json' => $payload,
        ];

        try {
            $response = $this->httpClient->request('POST', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, Table::class);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode === 400) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 403) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 404) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 500) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }

    /**
     * Updates the name and/or description of a table. At least one of name or description must be specified.
     *
     * @param string $baseId
     * @param string $tableIdOrName
     * @param Table $payload
     * @return Table
     * @throws ErrorException
     * @throws ClientException
     */
    public function update(string $baseId, string $tableIdOrName, Table $payload): Table
    {
        $url = $this->parser->url('/v0/meta/bases/:baseId/tables/:tableIdOrName', [
            'baseId' => $baseId,
            'tableIdOrName' => $tableIdOrName,
        ]);

        $options = [
            'headers' => [
                'Content-Type' => 'application/json',
            ],
            'query' => $this->parser->query([
            ], [
            ]),
            'json' => $payload,
        ];

        try {
            $response = $this->httpClient->request('PATCH', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, Table::class);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            if ($statusCode === 400) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 403) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 404) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            if ($statusCode === 500) {
                $data = $this->parser->parse((string) $body, Error::class);

                throw new ErrorException($data);
            }

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }



}
