<?php
/**
 * Tweet automatically generated by SDKgen please do not edit this file manually
 * @see https://sdkgen.app
 */

namespace SdkFabric\Twitter;

use PSX\Schema\Attribute\Description;
use PSX\Schema\Attribute\Key;

#[Description('')]
class Tweet implements \JsonSerializable, \PSX\Record\RecordableInterface
{
    #[Key('direct_message_deep_link')]
    #[Description('Tweets a link directly to a Direct Message conversation with an account.')]
    protected ?string $directMessageDeepLink = null;
    #[Key('for_super_followers_only')]
    #[Description('Allows you to Tweet exclusively for Super Followers.')]
    protected ?bool $forSuperFollowersOnly = null;
    #[Description('A JSON object that contains location information for a Tweet. You can only add a location to Tweets if you have geo enabled in your profile settings. If you don\'t have geo enabled, you can still add a location parameter in your request body, but it won\'t get attached to your Tweet')]
    protected ?TweetGeo $geo = null;
    #[Description('A JSON object that contains media information being attached to created Tweet. This is mutually exclusive from Quote Tweet ID and Poll.')]
    protected ?TweetMedia $media = null;
    #[Description('A JSON object that contains options for a Tweet with a poll. This is mutually exclusive from Media and Quote Tweet ID.')]
    protected ?TweetPoll $poll = null;
    #[Key('quote_tweet_id')]
    #[Description('Link to the Tweet being quoted.')]
    protected ?string $quoteTweetId = null;
    #[Description('A JSON object that contains information of the Tweet being replied to.')]
    protected ?TweetReply $reply = null;
    #[Key('reply_settings')]
    #[Description('Settings to indicate who can reply to the Tweet. Options include "mentionedUsers" and "following". If the field isn’t specified, it will default to everyone.')]
    protected ?string $replySettings = null;
    #[Description('Text of the Tweet being created. This field is required if media.media_ids is not present.')]
    protected ?string $text = null;
    #[Key('possibly_sensitive')]
    #[Description('Indicates if this Tweet contains URLs marked as sensitive, for example content suitable for mature audiences.')]
    protected ?bool $possiblySensitive = null;
    #[Description('Language of the Tweet, if detected by Twitter. Returned as a BCP47 language tag.')]
    protected ?string $lang = null;
    public function setDirectMessageDeepLink(?string $directMessageDeepLink) : void
    {
        $this->directMessageDeepLink = $directMessageDeepLink;
    }
    public function getDirectMessageDeepLink() : ?string
    {
        return $this->directMessageDeepLink;
    }
    public function setForSuperFollowersOnly(?bool $forSuperFollowersOnly) : void
    {
        $this->forSuperFollowersOnly = $forSuperFollowersOnly;
    }
    public function getForSuperFollowersOnly() : ?bool
    {
        return $this->forSuperFollowersOnly;
    }
    public function setGeo(?TweetGeo $geo) : void
    {
        $this->geo = $geo;
    }
    public function getGeo() : ?TweetGeo
    {
        return $this->geo;
    }
    public function setMedia(?TweetMedia $media) : void
    {
        $this->media = $media;
    }
    public function getMedia() : ?TweetMedia
    {
        return $this->media;
    }
    public function setPoll(?TweetPoll $poll) : void
    {
        $this->poll = $poll;
    }
    public function getPoll() : ?TweetPoll
    {
        return $this->poll;
    }
    public function setQuoteTweetId(?string $quoteTweetId) : void
    {
        $this->quoteTweetId = $quoteTweetId;
    }
    public function getQuoteTweetId() : ?string
    {
        return $this->quoteTweetId;
    }
    public function setReply(?TweetReply $reply) : void
    {
        $this->reply = $reply;
    }
    public function getReply() : ?TweetReply
    {
        return $this->reply;
    }
    public function setReplySettings(?string $replySettings) : void
    {
        $this->replySettings = $replySettings;
    }
    public function getReplySettings() : ?string
    {
        return $this->replySettings;
    }
    public function setText(?string $text) : void
    {
        $this->text = $text;
    }
    public function getText() : ?string
    {
        return $this->text;
    }
    public function setPossiblySensitive(?bool $possiblySensitive) : void
    {
        $this->possiblySensitive = $possiblySensitive;
    }
    public function getPossiblySensitive() : ?bool
    {
        return $this->possiblySensitive;
    }
    public function setLang(?string $lang) : void
    {
        $this->lang = $lang;
    }
    public function getLang() : ?string
    {
        return $this->lang;
    }
    public function toRecord() : \PSX\Record\RecordInterface
    {
        /** @var \PSX\Record\Record<mixed> $record */
        $record = new \PSX\Record\Record();
        $record->put('direct_message_deep_link', $this->directMessageDeepLink);
        $record->put('for_super_followers_only', $this->forSuperFollowersOnly);
        $record->put('geo', $this->geo);
        $record->put('media', $this->media);
        $record->put('poll', $this->poll);
        $record->put('quote_tweet_id', $this->quoteTweetId);
        $record->put('reply', $this->reply);
        $record->put('reply_settings', $this->replySettings);
        $record->put('text', $this->text);
        $record->put('possibly_sensitive', $this->possiblySensitive);
        $record->put('lang', $this->lang);
        return $record;
    }
    public function jsonSerialize() : object
    {
        return (object) $this->toRecord()->getAll();
    }
}
