<?php
/*
 * Fusio - Self-Hosted API Management for Builders.
 * For the current version and information visit <https://www.fusio-project.org/>
 *
 * Copyright (c) Christoph Kappestein <christoph.kappestein@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace Fusio\Impl\Tests\Command\System;

use Fusio\Impl\Tests\DbTestCase;
use PSX\Framework\Test\Environment;
use Symfony\Component\Console\Application;
use Symfony\Component\Console\Tester\CommandTester;
use Symfony\Component\Yaml\Yaml;

/**
 * TokenCommandTest
 *
 * @author  Christoph Kappestein <christoph.kappestein@gmail.com>
 * @license http://www.apache.org/licenses/LICENSE-2.0
 * @link    https://www.fusio-project.org
 */
class TokenCommandTest extends DbTestCase
{
    public function testCommand()
    {
        $command = Environment::getService(Application::class)->find('system:token');

        $commandTester = new CommandTester($command);
        $commandTester->execute([
            'command' => $command->getName(),
            'appId'   => 1,
            'userId'  => 1,
            'scopes'  => 'backend,authorization',
            'expire'  => 'P1M',
        ]);

        $actual = $commandTester->getDisplay();
        $data   = Yaml::parse($actual);

        $this->assertEquals('Backend', $data['App']);
        $this->assertEquals('Administrator', $data['User']);
        $this->assertNotEmpty($data['Token']);
        $this->assertTrue($data['Expires'] > 0);
        $this->assertEquals('backend,authorization', $data['Scope']);
    }
}
