/**
 * ProductTag automatically generated by SDKgen please do not edit this file manually
 * {@link https://sdkgen.app}
 */

import {TagAbstract, HttpRequest} from "sdkgen-client"
import {ClientException, UnknownStatusCodeException} from "sdkgen-client";

import {BinaryException} from "./BinaryException";
import {FormException} from "./FormException";
import {JsonException} from "./JsonException";
import {MultipartException} from "./MultipartException";
import {TestRequest} from "./TestRequest";
import {TestResponse} from "./TestResponse";
import {TestResponseException} from "./TestResponseException";
import {TextException} from "./TextException";
import {XmlException} from "./XmlException";

export class ProductTag extends TagAbstract {
    /**
     * Returns a collection
     *
     * @returns {Promise<TestResponse>}
     * @throws {ClientException}
     */
    public async getAll(startIndex?: number, count?: number, search?: string): Promise<TestResponse> {
        const url = this.parser.url('/anything', {
        });

        let request: HttpRequest = {
            url: url,
            method: 'GET',
            headers: {
            },
            params: this.parser.query({
                'startIndex': startIndex,
                'count': count,
                'search': search,
            }, [
            ]),
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as TestResponse;
        }

        const statusCode = response.status;
        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * Creates a new product
     *
     * @returns {Promise<TestResponse>}
     * @throws {TestResponseException}
     * @throws {ClientException}
     */
    public async create(payload: TestRequest): Promise<TestResponse> {
        const url = this.parser.url('/anything', {
        });

        let request: HttpRequest = {
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            params: this.parser.query({
            }, [
            ]),
            data: payload
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as TestResponse;
        }

        const statusCode = response.status;
        if (statusCode === 500) {
            throw new TestResponseException(await response.json() as TestResponse);
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * Updates an existing product
     *
     * @returns {Promise<TestResponse>}
     * @throws {ClientException}
     */
    public async update(id: number, payload: TestRequest): Promise<TestResponse> {
        const url = this.parser.url('/anything/:id', {
            'id': id,
        });

        let request: HttpRequest = {
            url: url,
            method: 'PUT',
            headers: {
                'Content-Type': 'application/json',
            },
            params: this.parser.query({
            }, [
            ]),
            data: payload
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as TestResponse;
        }

        const statusCode = response.status;
        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * Patches an existing product
     *
     * @returns {Promise<TestResponse>}
     * @throws {ClientException}
     */
    public async patch(id: number, payload: TestRequest): Promise<TestResponse> {
        const url = this.parser.url('/anything/:id', {
            'id': id,
        });

        let request: HttpRequest = {
            url: url,
            method: 'PATCH',
            headers: {
                'Content-Type': 'application/json',
            },
            params: this.parser.query({
            }, [
            ]),
            data: payload
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as TestResponse;
        }

        const statusCode = response.status;
        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * Deletes an existing product
     *
     * @returns {Promise<TestResponse>}
     * @throws {ClientException}
     */
    public async delete(id: number): Promise<TestResponse> {
        const url = this.parser.url('/anything/:id', {
            'id': id,
        });

        let request: HttpRequest = {
            url: url,
            method: 'DELETE',
            headers: {
            },
            params: this.parser.query({
            }, [
            ]),
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as TestResponse;
        }

        const statusCode = response.status;
        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * Test binary content type
     *
     * @returns {Promise<TestResponse>}
     * @throws {BinaryException}
     * @throws {ClientException}
     */
    public async binary(payload: ArrayBuffer): Promise<TestResponse> {
        const url = this.parser.url('/anything/binary', {
        });

        let request: HttpRequest = {
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'application/octet-stream',
            },
            params: this.parser.query({
            }, [
            ]),
            data: payload
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as TestResponse;
        }

        const statusCode = response.status;
        if (statusCode === 500) {
            throw new BinaryException(await response.arrayBuffer());
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * Test form content type
     *
     * @returns {Promise<TestResponse>}
     * @throws {FormException}
     * @throws {ClientException}
     */
    public async form(payload: URLSearchParams): Promise<TestResponse> {
        const url = this.parser.url('/anything/form', {
        });

        let request: HttpRequest = {
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            params: this.parser.query({
            }, [
            ]),
            data: payload
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as TestResponse;
        }

        const statusCode = response.status;
        if (statusCode === 500) {
            throw new FormException(new URLSearchParams(await response.formData() as any));
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * Test json content type
     *
     * @returns {Promise<TestResponse>}
     * @throws {JsonException}
     * @throws {ClientException}
     */
    public async json(payload: any): Promise<TestResponse> {
        const url = this.parser.url('/anything/json', {
        });

        let request: HttpRequest = {
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            params: this.parser.query({
            }, [
            ]),
            data: payload
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as TestResponse;
        }

        const statusCode = response.status;
        if (statusCode === 500) {
            throw new JsonException(await response.json());
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * Test json content type
     *
     * @returns {Promise<TestResponse>}
     * @throws {MultipartException}
     * @throws {ClientException}
     */
    public async multipart(payload: FormData): Promise<TestResponse> {
        const url = this.parser.url('/anything/multipart', {
        });

        let request: HttpRequest = {
            url: url,
            method: 'POST',
            headers: {
            },
            params: this.parser.query({
            }, [
            ]),
            data: payload
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as TestResponse;
        }

        const statusCode = response.status;
        if (statusCode === 500) {
            throw new MultipartException(await response.formData());
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * Test text content type
     *
     * @returns {Promise<TestResponse>}
     * @throws {TextException}
     * @throws {ClientException}
     */
    public async text(payload: string): Promise<TestResponse> {
        const url = this.parser.url('/anything/text', {
        });

        let request: HttpRequest = {
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'text/plain',
            },
            params: this.parser.query({
            }, [
            ]),
            data: payload
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as TestResponse;
        }

        const statusCode = response.status;
        if (statusCode === 500) {
            throw new TextException(await response.text());
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }
    /**
     * Test xml content type
     *
     * @returns {Promise<TestResponse>}
     * @throws {XmlException}
     * @throws {ClientException}
     */
    public async xml(payload: string): Promise<TestResponse> {
        const url = this.parser.url('/anything/xml', {
        });

        let request: HttpRequest = {
            url: url,
            method: 'POST',
            headers: {
                'Content-Type': 'application/xml',
            },
            params: this.parser.query({
            }, [
            ]),
            data: payload
        };

        const response = await this.httpClient.request(request);
        if (response.ok) {
            return await response.json() as TestResponse;
        }

        const statusCode = response.status;
        if (statusCode === 500) {
            throw new XmlException(await response.text());
        }

        throw new UnknownStatusCodeException('The server returned an unknown status code: ' + statusCode);
    }



}
