<?php
/**
 * RetweetTag automatically generated by SDKgen please do not edit this file manually
 * @see https://sdkgen.app
 */

namespace SdkFabric\Twitter;

use GuzzleHttp\Exception\BadResponseException;
use Sdkgen\Client\Exception\ClientException;
use Sdkgen\Client\Exception\Payload;
use Sdkgen\Client\Exception\UnknownStatusCodeException;
use Sdkgen\Client\TagAbstract;

class RetweetTag extends TagAbstract
{
    /**
     * Returns the Retweets for a given Tweet ID.
     *
     * @param string $tweetId
     * @param string|null $expansions
     * @param int|null $maxResults
     * @param Fields|null $fields
     * @return TweetCollection
     * @throws ClientException
     */
    public function getAll(string $tweetId, ?string $expansions = null, ?int $maxResults = null, ?Fields $fields = null): TweetCollection
    {
        $url = $this->parser->url('/2/tweets/:tweet_id/retweets', [
            'tweet_id' => $tweetId,
        ]);

        $options = [
            'headers' => [
            ],
            'query' => $this->parser->query([
                'expansions' => $expansions,
                'max_results' => $maxResults,
                'fields' => $fields,
            ], [
                'fields',
            ]),
        ];

        try {
            $response = $this->httpClient->request('GET', $url, $options);
            $body = $response->getBody();

            $data = $this->parser->parse((string) $body, TweetCollection::class);

            return $data;
        } catch (ClientException $e) {
            throw $e;
        } catch (BadResponseException $e) {
            $body = $e->getResponse()->getBody();
            $statusCode = $e->getResponse()->getStatusCode();

            throw new UnknownStatusCodeException('The server returned an unknown status code: ' . $statusCode);
        } catch (\Throwable $e) {
            throw new ClientException('An unknown error occurred: ' . $e->getMessage());
        }
    }



}
