
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `fusio525`
--

-- --------------------------------------------------------

--
-- Table structure for table `doctrine_migration_versions`
--

CREATE TABLE `doctrine_migration_versions` (
  `version` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `executed_at` datetime DEFAULT NULL,
  `execution_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `doctrine_migration_versions`
--

INSERT INTO `doctrine_migration_versions` VALUES
('Fusio\\Impl\\Migrations\\Version20230508210151', '[[regtime]]', 7561),
('Fusio\\Impl\\Migrations\\Version20230922194158', '[[regtime]]', 36),
('Fusio\\Impl\\Migrations\\Version20240121100724', '[[regtime]]', 193),
('Fusio\\Impl\\Migrations\\Version20240712210005', '[[regtime]]', 148),
('Fusio\\Impl\\Migrations\\Version20240721005146', '[[regtime]]', 147),
('Fusio\\Impl\\Migrations\\Version20240801200434', '[[regtime]]', 163),
('Fusio\\Impl\\Migrations\\Version20240822171833', '[[regtime]]', 31),
('Fusio\\Impl\\Migrations\\Version20250223070312', '[[regtime]]', 138),
('Fusio\\Impl\\Migrations\\Version20250323184048', '[[regtime]]', 149),
('Fusio\\Impl\\Migrations\\Version20250420185911', '[[regtime]]', 133),
('Fusio\\Impl\\Migrations\\Version20250614224242', '[[regtime]]', 91);

-- --------------------------------------------------------

--
-- Table structure for table `fusio_action`
--

CREATE TABLE `fusio_action` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '1',
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `async` tinyint(1) NOT NULL DEFAULT '0',
  `config` longtext COLLATE utf8_unicode_ci,
  `metadata` longtext COLLATE utf8_unicode_ci,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_F429FE2A9033212A5E237E06` (`tenant_id`,`name`),
  KEY `IDX_F429FE2A12469DE2` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_app`
--

CREATE TABLE `fusio_app` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `parameters` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `app_key` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `app_secret` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `metadata` longtext COLLATE utf8_unicode_ci,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_6198B1E59033212AA4E2186E` (`tenant_id`,`app_key`),
  KEY `IDX_6198B1E5A76ED395` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `fusio_app`
--

INSERT INTO `fusio_app` VALUES
(1, 1, NULL, 1, 'fusio', '[[softurl]]/public/apps/fusio', NULL, '[[backendAppKey]]', '[[backendAppSecret]]', NULL, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `fusio_app_code`
--

CREATE TABLE `fusio_app_code` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `redirect_uri` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `scope` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_E02C927D77153098` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_app_scope`
--

CREATE TABLE `fusio_app_scope` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_id` int(11) NOT NULL,
  `scope_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_D0587A867987212D682B5931` (`app_id`,`scope_id`),
  KEY `IDX_D0587A867987212D` (`app_id`),
  KEY `IDX_D0587A86682B5931` (`scope_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `fusio_app_scope`
--

INSERT INTO `fusio_app_scope` VALUES
(3, 1, 1),
(2, 1, 2),
(1, 1, 3);

-- --------------------------------------------------------

--
-- Table structure for table `fusio_audit`
--

CREATE TABLE `fusio_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `app_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `ref_id` int(11) DEFAULT NULL,
  `event` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `message` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8_unicode_ci,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_111069819033212A` (`tenant_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `fusio_audit`
--

INSERT INTO `fusio_audit` VALUES
(1, NULL, 0, 1, 2, 'user.create', '[[clientip]]', 'Created user [[admin_username]]', '{\n    "id": 2,\n    "roleId": 1,\n    "status": 1,\n    "name": "[[admin_username]]",\n    "email": "[[admin_email]]",\n    "password": "******"\n}', '[[regtime]]'),
(2, NULL, 0, 1, 1, 'app.create', '[[clientip]]', 'Created app fusio', '{\n    "id": 1,\n    "userId": 1,\n    "status": 1,\n    "name": "fusio",\n    "url": "[[softurl]]/public/apps/fusio",\n    "scopes": [\n        "backend",\n        "consumer",\n        "authorization"\n    ]\n}', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `fusio_category`
--

CREATE TABLE `fusio_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_945B9E849033212A5E237E06` (`tenant_id`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `fusio_category`
--

INSERT INTO `fusio_category` VALUES
(1, NULL, 1, 'default'),
(2, NULL, 1, 'backend'),
(3, NULL, 1, 'consumer'),
(4, NULL, 1, 'system'),
(5, NULL, 1, 'authorization');

-- --------------------------------------------------------

--
-- Table structure for table `fusio_config`
--

CREATE TABLE `fusio_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` int(11) NOT NULL DEFAULT '1',
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `value` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_676F5DC49033212A5E237E06` (`tenant_id`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=34 ;

--
-- Dumping data for table `fusio_config`
--

INSERT INTO `fusio_config` VALUES
(1, NULL, 2, 'app_approval', 'If true the status of a new app is PENDING so that an administrator has to manually activate the app', '0'),
(2, NULL, 3, 'consumer_max_apps', 'The max amount of apps a consumer can generate', '16'),
(3, NULL, 3, 'consumer_max_tokens', 'The max amount of tokens a consumer can generate', '16'),
(4, NULL, 3, 'consumer_max_webhooks', 'The max amount of webhooks a consumer can register', '8'),
(5, NULL, 1, 'authorization_url', 'Url where the user can authorize for the OAuth2 flow', ''),
(6, NULL, 1, 'info_title', 'The title of the application', 'Fusio'),
(7, NULL, 1, 'info_description', 'A short description of the application. CommonMark syntax MAY be used for rich text representation', 'Self-Hosted API Management for Builders.'),
(8, NULL, 1, 'info_tos', 'A URL to the Terms of Service for the API. MUST be in the format of a URL', ''),
(9, NULL, 1, 'info_contact_name', 'The identifying name of the contact person/organization', ''),
(10, NULL, 1, 'info_contact_url', 'The URL pointing to the contact information. MUST be in the format of a URL', ''),
(11, NULL, 1, 'info_contact_email', 'The email address of the contact person/organization. MUST be in the format of an email address', ''),
(12, NULL, 1, 'info_license_name', 'The license name used for the API', ''),
(13, NULL, 1, 'info_license_url', 'A URL to the license used for the API. MUST be in the format of a URL', ''),
(14, NULL, 1, 'mail_register_subject', 'Subject of the activation mail', 'Fusio registration'),
(15, NULL, 6, 'mail_register_body', 'Body of the activation mail', 'Hello {name},\n\nyou have successful registered at Fusio.\nTo activate you account please visit the following link:\n{apps_url}/developer/register/activate/{token}'),
(16, NULL, 1, 'mail_pw_reset_subject', 'Subject of the password reset mail', 'Fusio password reset'),
(17, NULL, 6, 'mail_pw_reset_body', 'Body of the password reset mail', 'Hello {name},\n\nyou have requested to reset your password.\nTo set a new password please visit the following link:\n{apps_url}/developer/password/confirm/{token}\n\nPlease ignore this email if you have not requested a password reset.'),
(18, NULL, 1, 'mail_points_subject', 'Subject of the points threshold mail', 'Fusio points threshold reached'),
(19, NULL, 6, 'mail_points_body', 'Body of the points threshold mail', 'Hello {name},\n\nyour account has reached the configured threshold of {points} points.\nIf your account reaches 0 points your are not longer able to invoke specific endpoints.\nTo prevent this please go to the developer portal to purchase new points:\n{apps_url}/developer'),
(20, NULL, 1, 'recaptcha_key', 'ReCaptcha key', ''),
(21, NULL, 1, 'recaptcha_secret', 'ReCaptcha secret', ''),
(22, NULL, 1, 'payment_stripe_secret', 'The stripe webhook secret which is needed to verify a webhook request', ''),
(23, NULL, 1, 'payment_stripe_portal_configuration', 'The stripe portal configuration id', ''),
(24, NULL, 1, 'payment_currency', 'The three-character ISO-4217 currency code which is used to process payments', ''),
(25, NULL, 1, 'role_default', 'Default role which a user gets assigned on registration', 'Consumer'),
(26, NULL, 3, 'points_default', 'The default amount of points which a user receives if he registers', '0'),
(27, NULL, 3, 'points_threshold', 'If a user goes below this points threshold we send an information to the user', '0'),
(28, NULL, 1, 'system_mailer', 'Optional the name of an SMTP connection which is used as mailer, by default the system uses the connection configured through the APP_MAILER environment variable', ''),
(29, NULL, 1, 'system_dispatcher', 'Optional the name of an HTTP or Message-Queue connection which is used to dispatch events. By default the system uses simply cron and an internal table to dispatch such events, for better performance you can provide a Message-Queue connection and Fusio will only dispatch the event to the queue, then your worker must execute the actual webhook HTTP request', ''),
(30, NULL, 3, 'user_pw_length', 'Minimal required password length', '8'),
(31, NULL, 2, 'user_approval', 'Whether the user needs to activate the account through an email', '1'),
(32, NULL, 1, 'marketplace_client_id', 'The marketplace client id', ''),
(33, NULL, 1, 'marketplace_client_secret', 'The marketplace client secret', '');

-- --------------------------------------------------------

--
-- Table structure for table `fusio_connection`
--

CREATE TABLE `fusio_connection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `category_id` int(11) NOT NULL DEFAULT '1',
  `status` int(11) NOT NULL DEFAULT '1',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `config` longtext COLLATE utf8_unicode_ci,
  `metadata` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_D7254CB29033212A5E237E06` (`tenant_id`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `fusio_connection`
--

INSERT INTO `fusio_connection` VALUES
(1, NULL, 1, 1, 'System', 'Fusio.Impl.Connection.System', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `fusio_cronjob`
--

CREATE TABLE `fusio_cronjob` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '1',
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `cron` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `execute_date` datetime DEFAULT NULL,
  `exit_code` int(11) DEFAULT NULL,
  `metadata` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_60D3A2469033212A5E237E06` (`tenant_id`,`name`),
  KEY `IDX_60D3A24612469DE2` (`category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `fusio_cronjob`
--

INSERT INTO `fusio_cronjob` VALUES
(1, 2, NULL, 1, 'Renew_Token', '0 * * * *', 'php+class://Fusio.Impl.Backend.Action.Connection.RenewToken', '2015-02-27 19:59:15', 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `fusio_cronjob_error`
--

CREATE TABLE `fusio_cronjob_error` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cronjob_id` int(11) NOT NULL,
  `message` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  `trace` longtext COLLATE utf8_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `line` int(11) NOT NULL,
  `insert_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_event`
--

CREATE TABLE `fusio_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '1',
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `event_schema` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `metadata` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_B8A69C5F9033212A5E237E06` (`tenant_id`,`name`),
  KEY `IDX_B8A69C5F12469DE2` (`category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=62 ;

--
-- Dumping data for table `fusio_event`
--

INSERT INTO `fusio_event` VALUES
(1, 3, NULL, 1, 'fusio.account.update', '', NULL, NULL),
(2, 2, NULL, 1, 'fusio.action.create', '', NULL, NULL),
(3, 2, NULL, 1, 'fusio.action.update', '', NULL, NULL),
(4, 2, NULL, 1, 'fusio.action.delete', '', NULL, NULL),
(5, 3, NULL, 1, 'fusio.app.create', '', NULL, NULL),
(6, 3, NULL, 1, 'fusio.app.update', '', NULL, NULL),
(7, 3, NULL, 1, 'fusio.app.delete', '', NULL, NULL),
(8, 2, NULL, 1, 'fusio.category.create', '', NULL, NULL),
(9, 2, NULL, 1, 'fusio.category.update', '', NULL, NULL),
(10, 2, NULL, 1, 'fusio.category.delete', '', NULL, NULL),
(11, 2, NULL, 1, 'fusio.config.update', '', NULL, NULL),
(12, 2, NULL, 1, 'fusio.connection.create', '', NULL, NULL),
(13, 2, NULL, 1, 'fusio.connection.update', '', NULL, NULL),
(14, 2, NULL, 1, 'fusio.connection.delete', '', NULL, NULL),
(15, 2, NULL, 1, 'fusio.cronjob.create', '', NULL, NULL),
(16, 2, NULL, 1, 'fusio.cronjob.update', '', NULL, NULL),
(17, 2, NULL, 1, 'fusio.cronjob.delete', '', NULL, NULL),
(18, 2, NULL, 1, 'fusio.event.create', '', NULL, NULL),
(19, 2, NULL, 1, 'fusio.event.update', '', NULL, NULL),
(20, 2, NULL, 1, 'fusio.event.delete', '', NULL, NULL),
(21, 2, NULL, 1, 'fusio.firewall.create', '', NULL, NULL),
(22, 2, NULL, 1, 'fusio.firewall.update', '', NULL, NULL),
(23, 2, NULL, 1, 'fusio.firewall.delete', '', NULL, NULL),
(24, 2, NULL, 1, 'fusio.form.create', '', NULL, NULL),
(25, 2, NULL, 1, 'fusio.form.update', '', NULL, NULL),
(26, 2, NULL, 1, 'fusio.form.delete', '', NULL, NULL),
(27, 2, NULL, 1, 'fusio.identity.create', '', NULL, NULL),
(28, 2, NULL, 1, 'fusio.identity.update', '', NULL, NULL),
(29, 2, NULL, 1, 'fusio.identity.delete', '', NULL, NULL),
(30, 2, NULL, 1, 'fusio.page.create', '', NULL, NULL),
(31, 2, NULL, 1, 'fusio.page.update', '', NULL, NULL),
(32, 2, NULL, 1, 'fusio.page.delete', '', NULL, NULL),
(33, 2, NULL, 1, 'fusio.plan.create', '', NULL, NULL),
(34, 2, NULL, 1, 'fusio.plan.update', '', NULL, NULL),
(35, 2, NULL, 1, 'fusio.plan.delete', '', NULL, NULL),
(36, 2, NULL, 1, 'fusio.rate.create', '', NULL, NULL),
(37, 2, NULL, 1, 'fusio.rate.update', '', NULL, NULL),
(38, 2, NULL, 1, 'fusio.rate.delete', '', NULL, NULL),
(39, 2, NULL, 1, 'fusio.role.create', '', NULL, NULL),
(40, 2, NULL, 1, 'fusio.role.update', '', NULL, NULL),
(41, 2, NULL, 1, 'fusio.role.delete', '', NULL, NULL),
(42, 2, NULL, 1, 'fusio.operation.create', '', NULL, NULL),
(43, 2, NULL, 1, 'fusio.operation.update', '', NULL, NULL),
(44, 2, NULL, 1, 'fusio.operation.delete', '', NULL, NULL),
(45, 2, NULL, 1, 'fusio.schema.create', '', NULL, NULL),
(46, 2, NULL, 1, 'fusio.schema.update', '', NULL, NULL),
(47, 2, NULL, 1, 'fusio.schema.delete', '', NULL, NULL),
(48, 2, NULL, 1, 'fusio.scope.create', '', NULL, NULL),
(49, 2, NULL, 1, 'fusio.scope.update', '', NULL, NULL),
(50, 2, NULL, 1, 'fusio.scope.delete', '', NULL, NULL),
(51, 2, NULL, 1, 'fusio.test.update', '', NULL, NULL),
(52, 2, NULL, 1, 'fusio.user.create', '', NULL, NULL),
(53, 2, NULL, 1, 'fusio.user.update', '', NULL, NULL),
(54, 2, NULL, 1, 'fusio.user.delete', '', NULL, NULL),
(55, 3, NULL, 1, 'fusio.webhook.create', '', NULL, NULL),
(56, 3, NULL, 1, 'fusio.webhook.update', '', NULL, NULL),
(57, 3, NULL, 1, 'fusio.webhook.delete', '', NULL, NULL),
(58, 3, NULL, 1, 'fusio.grant.delete', '', NULL, NULL),
(59, 3, NULL, 1, 'fusio.token.create', '', NULL, NULL),
(60, 3, NULL, 1, 'fusio.token.update', '', NULL, NULL),
(61, 3, NULL, 1, 'fusio.token.delete', '', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `fusio_firewall`
--

CREATE TABLE `fusio_firewall` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `type` int(11) NOT NULL,
  `ip` varchar(39) COLLATE utf8_unicode_ci NOT NULL,
  `expire` datetime DEFAULT NULL,
  `metadata` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_DA169C3B9033212A5E237E06` (`tenant_id`,`name`),
  KEY `IDX_DA169C3B9033212A8CDE5729A5E3B32D2CB14AD4` (`tenant_id`,`type`,`ip`,`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_firewall_log`
--

CREATE TABLE `fusio_firewall_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip` varchar(39) COLLATE utf8_unicode_ci NOT NULL,
  `response_code` int(11) NOT NULL,
  `insert_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_6BE9C1169033212AA5E3B32D` (`tenant_id`,`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_form`
--

CREATE TABLE `fusio_form` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `operation_id` int(11) NOT NULL,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `ui_schema` longtext COLLATE utf8_unicode_ci NOT NULL,
  `metadata` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_899BC2589033212A5E237E06` (`tenant_id`,`name`),
  KEY `IDX_899BC25844AC3583` (`operation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_identity`
--

CREATE TABLE `fusio_identity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL,
  `app_id` int(11) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `icon` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `config` longtext COLLATE utf8_unicode_ci,
  `allow_create` tinyint(1) NOT NULL,
  `insert_date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_F8826E819033212A5E237E06` (`tenant_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_identity_request`
--

CREATE TABLE `fusio_identity_request` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `identity_id` int(11) NOT NULL,
  `state` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `redirect_uri` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `insert_date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_20FB7251FF3ED4A8A393D2FB` (`identity_id`,`state`),
  KEY `IDX_20FB7251FF3ED4A8` (`identity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_log`
--

CREATE TABLE `fusio_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `category_id` int(11) NOT NULL DEFAULT '1',
  `operation_id` int(11) DEFAULT NULL,
  `app_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `ip` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `user_agent` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `method` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `path` varchar(1023) COLLATE utf8_unicode_ci NOT NULL,
  `header` longtext COLLATE utf8_unicode_ci NOT NULL,
  `body` longtext COLLATE utf8_unicode_ci,
  `response_code` int(11) DEFAULT NULL,
  `execution_time` int(11) DEFAULT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_LOG_TID` (`tenant_id`,`ip`,`date`),
  KEY `IDX_LOG_TUD` (`tenant_id`,`user_id`,`date`),
  KEY `IDX_LOG_TIRD` (`tenant_id`,`ip`,`response_code`,`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_log_error`
--

CREATE TABLE `fusio_log_error` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `log_id` int(11) NOT NULL,
  `message` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  `trace` longtext COLLATE utf8_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `line` int(11) NOT NULL,
  `insert_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_operation`
--

CREATE TABLE `fusio_operation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '1',
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `active` int(11) NOT NULL DEFAULT '0',
  `public` int(11) NOT NULL DEFAULT '0',
  `stability` int(11) NOT NULL DEFAULT '1',
  `description` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `http_method` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `http_path` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `http_code` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `parameters` longtext COLLATE utf8_unicode_ci,
  `incoming` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `outgoing` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `throws` longtext COLLATE utf8_unicode_ci,
  `action` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `costs` int(11) DEFAULT NULL,
  `metadata` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_1FA504F59033212A5E237E06` (`tenant_id`,`name`),
  UNIQUE KEY `UNIQ_1FA504F59033212A452BE2A7AAFE5D88` (`tenant_id`,`http_method`,`http_path`),
  KEY `IDX_OPERATION_S` (`status`),
  KEY `IDX_OPERATION_CS` (`category_id`,`status`),
  KEY `IDX_1FA504F512469DE2` (`category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=229 ;

--
-- Dumping data for table `fusio_operation`
--

INSERT INTO `fusio_operation` VALUES
(1, 1, NULL, 1, 1, 1, 2, '', 'GET', '/', 200, 'meta.getAbout', '{}', NULL, 'php+class://Fusio.Model.System.About', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.System.Action.Meta.GetAbout', 0, NULL),
(2, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/account', 200, 'backend.account.get', '{}', NULL, 'php+class://Fusio.Model.Backend.User', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Account.Get', 0, NULL),
(3, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/account', 200, 'backend.account.update', '{}', 'php+class://Fusio.Model.Backend.UserUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Account.Update', 0, NULL),
(4, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/account/change_password', 200, 'backend.account.changePassword', '{}', 'php+class://Fusio.Model.Backend.AccountChangePassword', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Account.ChangePassword', 0, NULL),
(5, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/action', 200, 'backend.action.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.ActionCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Action.GetAll', 0, NULL),
(6, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/action', 201, 'backend.action.create', '{}', 'php+class://Fusio.Model.Backend.ActionCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Action.Create', 0, NULL),
(7, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/action/list', 200, 'backend.action.getClasses', '{}', NULL, 'php+class://Fusio.Model.Backend.ActionIndex', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Action.GetIndex', 0, NULL),
(8, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/action/form', 200, 'backend.action.getForm', '{"class":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Common.FormContainer', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Action.GetForm', 0, NULL),
(9, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/action/execute/:action_id', 200, 'backend.action.execute', '{}', 'php+class://Fusio.Model.Backend.ActionExecuteRequest', 'php+class://Fusio.Model.Backend.ActionExecuteResponse', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Action.Execute', 0, NULL),
(10, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/action/$action_id<[0-9]+|^~>', 200, 'backend.action.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Action', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Action.Get', 0, NULL),
(11, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/action/$action_id<[0-9]+|^~>', 200, 'backend.action.update', '{}', 'php+class://Fusio.Model.Backend.ActionUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Action.Update', 0, NULL),
(12, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/action/$action_id<[0-9]+|^~>', 200, 'backend.action.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Action.Delete', 0, NULL),
(13, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/app', 200, 'backend.app.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.AppCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.App.GetAll', 0, NULL),
(14, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/app', 201, 'backend.app.create', '{}', 'php+class://Fusio.Model.Backend.AppCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.App.Create', 0, NULL),
(15, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/app/$app_id<[0-9]+|^~>', 200, 'backend.app.get', '{}', NULL, 'php+class://Fusio.Model.Backend.App', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.App.Get', 0, NULL),
(16, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/app/$app_id<[0-9]+|^~>', 200, 'backend.app.update', '{}', 'php+class://Fusio.Model.Backend.AppUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.App.Update', 0, NULL),
(17, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/app/$app_id<[0-9]+|^~>', 200, 'backend.app.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.App.Delete', 0, NULL),
(18, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/app/$app_id<[0-9]+>/token/:token_id', 200, 'backend.app.deleteToken', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.App.DeleteToken', 0, NULL),
(19, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/audit', 200, 'backend.audit.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"appId":{"type":"integer"},"userId":{"type":"integer"},"event":{"type":"string"},"ip":{"type":"string"},"message":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.AuditCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Audit.GetAll', 0, NULL),
(20, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/audit/$audit_id<[0-9]+>', 200, 'backend.audit.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Audit', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Audit.Get', 0, NULL),
(21, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/category', 200, 'backend.category.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.CategoryCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Category.GetAll', 0, NULL),
(22, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/category', 201, 'backend.category.create', '{}', 'php+class://Fusio.Model.Backend.CategoryCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Category.Create', 0, NULL),
(23, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/category/$category_id<[0-9]+|^~>', 200, 'backend.category.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Category', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Category.Get', 0, NULL),
(24, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/category/$category_id<[0-9]+|^~>', 200, 'backend.category.update', '{}', 'php+class://Fusio.Model.Backend.CategoryUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Category.Update', 0, NULL),
(25, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/category/$category_id<[0-9]+|^~>', 200, 'backend.category.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Category.Delete', 0, NULL),
(26, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/config', 200, 'backend.config.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.ConfigCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Config.GetAll', 0, NULL),
(27, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/config/$config_id<[0-9]+|^~>', 200, 'backend.config.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Config', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Config.Get', 0, NULL),
(28, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/config/$config_id<[0-9]+|^~>', 200, 'backend.config.update', '{}', 'php+class://Fusio.Model.Backend.ConfigUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Config.Update', 0, NULL),
(29, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/connection', 200, 'backend.connection.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"class":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.ConnectionCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Connection.GetAll', 0, NULL),
(30, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/connection', 201, 'backend.connection.create', '{}', 'php+class://Fusio.Model.Backend.ConnectionCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Connection.Create', 0, NULL),
(31, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/connection/list', 200, 'backend.connection.getClasses', '{}', NULL, 'php+class://Fusio.Model.Backend.ConnectionIndex', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Connection.GetIndex', 0, NULL),
(32, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/connection/form', 200, 'backend.connection.getForm', '{"class":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Common.FormContainer', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Connection.GetForm', 0, NULL),
(33, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/connection/$connection_id<[0-9]+|^~>', 200, 'backend.connection.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Connection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Connection.Get', 0, NULL),
(34, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/connection/$connection_id<[0-9]+|^~>', 200, 'backend.connection.update', '{}', 'php+class://Fusio.Model.Backend.ConnectionUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Connection.Update', 0, NULL),
(35, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/connection/$connection_id<[0-9]+|^~>', 200, 'backend.connection.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Connection.Delete', 0, NULL),
(36, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/connection/$connection_id<[0-9]+|^~>/redirect', 200, 'backend.connection.getRedirect', '{}', NULL, 'php+class://Fusio.Model.Backend.ConnectionRedirectResponse', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Connection.GetRedirect', 0, NULL),
(37, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/cronjob', 200, 'backend.cronjob.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.CronjobCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Cronjob.GetAll', 0, NULL),
(38, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/cronjob', 201, 'backend.cronjob.create', '{}', 'php+class://Fusio.Model.Backend.CronjobCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Cronjob.Create', 0, NULL),
(39, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/cronjob/$cronjob_id<[0-9]+|^~>', 200, 'backend.cronjob.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Cronjob', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Cronjob.Get', 0, NULL),
(40, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/cronjob/$cronjob_id<[0-9]+|^~>', 200, 'backend.cronjob.update', '{}', 'php+class://Fusio.Model.Backend.CronjobUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Cronjob.Update', 0, NULL),
(41, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/cronjob/$cronjob_id<[0-9]+|^~>', 200, 'backend.cronjob.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Cronjob.Delete', 0, NULL),
(42, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/dashboard', 200, 'backend.dashboard.getAll', '{}', NULL, 'php+class://Fusio.Model.Backend.Dashboard', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Dashboard.GetAll', 0, NULL),
(43, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/database/:connection_id', 200, 'backend.database.getTables', '{"startIndex":{"type":"integer"},"count":{"type":"integer"}}', NULL, 'php+class://Fusio.Model.Backend.DatabaseTableCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Database.Table.GetAll', 0, NULL),
(44, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/database/:connection_id/:table_name', 200, 'backend.database.getTable', '{}', NULL, 'php+class://Fusio.Model.Backend.DatabaseTable', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Database.Table.Get', 0, NULL),
(45, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/database/:connection_id', 201, 'backend.database.createTable', '{}', 'php+class://Fusio.Model.Backend.DatabaseTable', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Database.Table.Create', 0, NULL),
(46, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/database/:connection_id/:table_name', 200, 'backend.database.updateTable', '{}', 'php+class://Fusio.Model.Backend.DatabaseTable', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Database.Table.Update', 0, NULL),
(47, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/database/:connection_id/:table_name', 200, 'backend.database.deleteTable', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Database.Table.Delete', 0, NULL),
(48, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/database/:connection_id/:table_name/rows', 200, 'backend.database.getRows', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"filterBy":{"type":"string"},"filterOp":{"type":"string"},"filterValue":{"type":"string"},"sortBy":{"type":"string"},"sortOrder":{"type":"string"},"columns":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.DatabaseRowCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Database.Row.GetAll', 0, NULL),
(49, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/database/:connection_id/:table_name/rows/:id', 200, 'backend.database.getRow', '{}', NULL, 'php+class://Fusio.Model.Backend.DatabaseRow', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Database.Row.Get', 0, NULL),
(50, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/database/:connection_id/:table_name/rows', 201, 'backend.database.createRow', '{}', 'php+class://Fusio.Model.Backend.DatabaseRow', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Database.Row.Create', 0, NULL),
(51, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/database/:connection_id/:table_name/rows/:id', 200, 'backend.database.updateRow', '{}', 'php+class://Fusio.Model.Backend.DatabaseRow', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Database.Row.Update', 0, NULL),
(52, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/database/:connection_id/:table_name/rows/:id', 200, 'backend.database.deleteRow', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Database.Row.Delete', 0, NULL),
(53, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/event', 200, 'backend.event.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.EventCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Event.GetAll', 0, NULL),
(54, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/event', 201, 'backend.event.create', '{}', 'php+class://Fusio.Model.Backend.EventCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Event.Create', 0, NULL),
(55, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/event/$event_id<[0-9]+|^~>', 200, 'backend.event.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Event', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Event.Get', 0, NULL),
(56, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/event/$event_id<[0-9]+|^~>', 200, 'backend.event.update', '{}', 'php+class://Fusio.Model.Backend.EventUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Event.Update', 0, NULL),
(57, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/event/$event_id<[0-9]+|^~>', 200, 'backend.event.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Event.Delete', 0, NULL),
(58, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/backup/export', 200, 'backend.backup.export', '{}', NULL, 'php+class://Fusio.Model.Backend.BackupExport', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Backup.Export', 0, NULL),
(59, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/backup/import', 200, 'backend.backup.import', '{}', 'php+class://Fusio.Model.Backend.BackupImport', 'php+class://Fusio.Model.Backend.BackupImportResult', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Backup.Import', 0, NULL),
(60, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/firewall', 200, 'backend.firewall.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.FirewallCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Firewall.GetAll', 0, NULL),
(61, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/firewall', 201, 'backend.firewall.create', '{}', 'php+class://Fusio.Model.Backend.FirewallCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Firewall.Create', 0, NULL),
(62, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/firewall/$firewall_id<[0-9]+|^~>', 200, 'backend.firewall.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Firewall', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Firewall.Get', 0, NULL),
(63, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/firewall/$firewall_id<[0-9]+|^~>', 200, 'backend.firewall.update', '{}', 'php+class://Fusio.Model.Backend.FirewallUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Firewall.Update', 0, NULL),
(64, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/firewall/$firewall_id<[0-9]+|^~>', 200, 'backend.firewall.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Firewall.Delete', 0, NULL),
(65, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/form', 200, 'backend.form.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.FormCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Form.GetAll', 0, NULL),
(66, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/form', 201, 'backend.form.create', '{}', 'php+class://Fusio.Model.Backend.FormCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Form.Create', 0, NULL),
(67, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/form/$form_id<[0-9]+|^~>', 200, 'backend.form.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Form', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Form.Get', 0, NULL),
(68, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/form/$form_id<[0-9]+|^~>', 200, 'backend.form.update', '{}', 'php+class://Fusio.Model.Backend.FormUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Form.Update', 0, NULL),
(69, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/form/$form_id<[0-9]+|^~>', 200, 'backend.form.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Form.Delete', 0, NULL),
(70, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/generator', 200, 'backend.generator.getClasses', '{}', NULL, 'php+class://Fusio.Model.Backend.GeneratorIndexProviders', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Generator.GetIndex', 0, NULL),
(71, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/generator/:provider', 200, 'backend.generator.getForm', '{}', NULL, 'php+class://Fusio.Model.Common.FormContainer', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Generator.GetForm', 0, NULL),
(72, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/generator/:provider', 201, 'backend.generator.executeProvider', '{}', 'php+class://Fusio.Model.Backend.GeneratorProvider', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Generator.Create', 0, NULL),
(73, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/generator/:provider', 200, 'backend.generator.getChangelog', '{}', 'php+class://Fusio.Model.Backend.GeneratorProviderConfig', 'php+class://Fusio.Model.Backend.GeneratorProviderChangelog', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Generator.Changelog', 0, NULL),
(74, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/identity', 200, 'backend.identity.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.IdentityCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Identity.GetAll', 0, NULL),
(75, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/identity', 201, 'backend.identity.create', '{}', 'php+class://Fusio.Model.Backend.IdentityCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Identity.Create', 0, NULL),
(76, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/identity/list', 200, 'backend.identity.getClasses', '{}', NULL, 'php+class://Fusio.Model.Backend.IdentityIndex', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Identity.GetIndex', 0, NULL),
(77, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/identity/form', 200, 'backend.identity.getForm', '{"class":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Common.FormContainer', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Identity.GetForm', 0, NULL),
(78, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/identity/$identity_id<[0-9]+|^~>', 200, 'backend.identity.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Identity', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Identity.Get', 0, NULL),
(79, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/identity/$identity_id<[0-9]+|^~>', 200, 'backend.identity.update', '{}', 'php+class://Fusio.Model.Backend.IdentityUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Identity.Update', 0, NULL),
(80, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/identity/$identity_id<[0-9]+|^~>', 200, 'backend.identity.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Identity.Delete', 0, NULL),
(81, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/log/error', 200, 'backend.log.getAllErrors', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.LogErrorCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Log.Error.GetAll', 0, NULL),
(82, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/log/error/$error_id<[0-9]+>', 200, 'backend.log.getError', '{}', NULL, 'php+class://Fusio.Model.Backend.LogError', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Log.Error.Get', 0, NULL),
(83, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/log', 200, 'backend.log.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"operationId":{"type":"integer"},"appId":{"type":"integer"},"userId":{"type":"integer"},"ip":{"type":"string"},"userAgent":{"type":"string"},"method":{"type":"string"},"path":{"type":"string"},"header":{"type":"string"},"body":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.LogCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Log.GetAll', 0, NULL),
(84, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/log/$log_id<[0-9]+>', 200, 'backend.log.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Log', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Log.Get', 0, NULL),
(85, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/marketplace/action', 200, 'backend.marketplace.action.getAll', '{"startIndex":{"type":"integer"},"query":{"type":"string"}}', NULL, 'php+class://Fusio.Marketplace.MarketplaceActionCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Marketplace.Action.GetAll', 0, NULL),
(86, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/marketplace/action', 201, 'backend.marketplace.action.install', '{}', 'php+class://Fusio.Marketplace.MarketplaceInstall', 'php+class://Fusio.Marketplace.MarketplaceMessage', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Marketplace.Action.Install', 0, NULL),
(87, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/marketplace/action/:user/:name', 200, 'backend.marketplace.action.get', '{}', NULL, 'php+class://Fusio.Marketplace.MarketplaceAction', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Marketplace.Action.Get', 0, NULL),
(88, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/marketplace/action/:user/:name', 200, 'backend.marketplace.action.upgrade', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Marketplace.Action.Upgrade', 0, NULL),
(89, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/marketplace/app', 200, 'backend.marketplace.app.getAll', '{"startIndex":{"type":"integer"},"query":{"type":"string"}}', NULL, 'php+class://Fusio.Marketplace.MarketplaceAppCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Marketplace.App.GetAll', 0, NULL),
(90, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/marketplace/app', 201, 'backend.marketplace.app.install', '{}', 'php+class://Fusio.Marketplace.MarketplaceInstall', 'php+class://Fusio.Marketplace.MarketplaceMessage', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Marketplace.App.Install', 0, NULL),
(91, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/marketplace/app/:user/:name', 200, 'backend.marketplace.app.get', '{}', NULL, 'php+class://Fusio.Marketplace.MarketplaceApp', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Marketplace.App.Get', 0, NULL),
(92, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/marketplace/app/:user/:name', 200, 'backend.marketplace.app.upgrade', '{}', NULL, 'php+class://Fusio.Marketplace.MarketplaceMessage', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Marketplace.App.Upgrade', 0, NULL),
(93, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/page', 200, 'backend.page.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.PageCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Page.GetAll', 0, NULL),
(94, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/page', 201, 'backend.page.create', '{}', 'php+class://Fusio.Model.Backend.PageCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Page.Create', 0, NULL),
(95, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/page/$page_id<[0-9]+|^~>', 200, 'backend.page.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Page', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Page.Get', 0, NULL),
(96, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/page/$page_id<[0-9]+|^~>', 200, 'backend.page.update', '{}', 'php+class://Fusio.Model.Backend.PageUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Page.Update', 0, NULL),
(97, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/page/$page_id<[0-9]+|^~>', 200, 'backend.page.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Page.Delete', 0, NULL),
(98, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/plan', 200, 'backend.plan.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.PlanCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Plan.GetAll', 0, NULL),
(99, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/plan', 201, 'backend.plan.create', '{}', 'php+class://Fusio.Model.Backend.PlanCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Plan.Create', 0, NULL),
(100, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/plan/$plan_id<[0-9]+|^~>', 200, 'backend.plan.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Plan', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Plan.Get', 0, NULL),
(101, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/plan/$plan_id<[0-9]+|^~>', 200, 'backend.plan.update', '{}', 'php+class://Fusio.Model.Backend.PlanUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Plan.Update', 0, NULL),
(102, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/plan/$plan_id<[0-9]+|^~>', 200, 'backend.plan.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Plan.Delete', 0, NULL),
(103, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/rate', 200, 'backend.rate.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.RateCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Rate.GetAll', 0, NULL),
(104, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/rate', 201, 'backend.rate.create', '{}', 'php+class://Fusio.Model.Backend.RateCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Rate.Create', 0, NULL),
(105, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/rate/$rate_id<[0-9]+|^~>', 200, 'backend.rate.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Rate', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Rate.Get', 0, NULL),
(106, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/rate/$rate_id<[0-9]+|^~>', 200, 'backend.rate.update', '{}', 'php+class://Fusio.Model.Backend.RateUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Rate.Update', 0, NULL),
(107, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/rate/$rate_id<[0-9]+|^~>', 200, 'backend.rate.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Rate.Delete', 0, NULL),
(108, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/role', 200, 'backend.role.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.RoleCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Role.GetAll', 0, NULL),
(109, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/role', 201, 'backend.role.create', '{}', 'php+class://Fusio.Model.Backend.RoleCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Role.Create', 0, NULL),
(110, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/role/$role_id<[0-9]+|^~>', 200, 'backend.role.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Role', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Role.Get', 0, NULL),
(111, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/role/$role_id<[0-9]+|^~>', 200, 'backend.role.update', '{}', 'php+class://Fusio.Model.Backend.RoleUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Role.Update', 0, NULL),
(112, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/role/$role_id<[0-9]+|^~>', 200, 'backend.role.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Role.Delete', 0, NULL),
(113, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/operation', 200, 'backend.operation.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.OperationCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Operation.GetAll', 0, NULL),
(114, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/operation', 201, 'backend.operation.create', '{}', 'php+class://Fusio.Model.Backend.OperationCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Operation.Create', 0, NULL),
(115, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/operation/$operation_id<[0-9]+|^~>', 200, 'backend.operation.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Operation', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Operation.Get', 0, NULL),
(116, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/operation/$operation_id<[0-9]+|^~>', 200, 'backend.operation.update', '{}', 'php+class://Fusio.Model.Backend.OperationUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Operation.Update', 0, NULL),
(117, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/operation/$operation_id<[0-9]+|^~>', 200, 'backend.operation.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Operation.Delete', 0, NULL),
(118, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/schema', 200, 'backend.schema.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.SchemaCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Schema.GetAll', 0, NULL),
(119, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/schema', 201, 'backend.schema.create', '{}', 'php+class://Fusio.Model.Backend.SchemaCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Schema.Create', 0, NULL),
(120, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/schema/preview/:schema_id', 200, 'backend.schema.getPreview', '{}', NULL, 'php+class://Fusio.Model.Backend.SchemaPreviewResponse', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Schema.GetPreview', 0, NULL),
(121, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/schema/form/$schema_id<[0-9]+>', 200, 'backend.schema.updateForm', '{}', 'php+class://Fusio.Model.Backend.SchemaForm', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Schema.Form', 0, NULL),
(122, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/schema/$schema_id<[0-9]+|^~>', 200, 'backend.schema.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Schema', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Schema.Get', 0, NULL),
(123, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/schema/$schema_id<[0-9]+|^~>', 200, 'backend.schema.update', '{}', 'php+class://Fusio.Model.Backend.SchemaUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Schema.Update', 0, NULL),
(124, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/schema/$schema_id<[0-9]+|^~>', 200, 'backend.schema.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Schema.Delete', 0, NULL),
(125, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/scope', 200, 'backend.scope.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.ScopeCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Scope.GetAll', 0, NULL),
(126, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/scope', 201, 'backend.scope.create', '{}', 'php+class://Fusio.Model.Backend.ScopeCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Scope.Create', 0, NULL),
(127, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/scope/categories', 200, 'backend.scope.getCategories', '{}', NULL, 'php+class://Fusio.Model.Backend.ScopeCategories', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Scope.GetCategories', 0, NULL),
(128, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/scope/$scope_id<[0-9]+|^~>', 200, 'backend.scope.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Scope', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Scope.Get', 0, NULL),
(129, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/scope/$scope_id<[0-9]+|^~>', 200, 'backend.scope.update', '{}', 'php+class://Fusio.Model.Backend.ScopeUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Scope.Update', 0, NULL),
(130, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/scope/$scope_id<[0-9]+|^~>', 200, 'backend.scope.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Scope.Delete', 0, NULL),
(131, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/sdk', 200, 'backend.sdk.getAll', '{}', NULL, 'php+class://Fusio.Model.Backend.SdkResponse', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Sdk.GetAll', 0, NULL),
(132, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/sdk', 200, 'backend.sdk.generate', '{}', 'php+class://Fusio.Model.Backend.SdkGenerate', 'php+class://Fusio.Model.Backend.SdkMessage', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Sdk.Generate', 0, NULL),
(133, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/statistic/activities_per_user', 200, 'backend.statistic.getActivitiesPerUser', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"operationId":{"type":"integer"},"appId":{"type":"integer"},"userId":{"type":"integer"},"ip":{"type":"string"},"userAgent":{"type":"string"},"method":{"type":"string"},"path":{"type":"string"},"header":{"type":"string"},"body":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.StatisticChart', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Statistic.GetActivitiesPerUser', 0, NULL),
(134, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/statistic/count_requests', 200, 'backend.statistic.getCountRequests', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"operationId":{"type":"integer"},"appId":{"type":"integer"},"userId":{"type":"integer"},"ip":{"type":"string"},"userAgent":{"type":"string"},"method":{"type":"string"},"path":{"type":"string"},"header":{"type":"string"},"body":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.StatisticCount', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Statistic.GetCountRequests', 0, NULL),
(135, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/statistic/errors_per_operation', 200, 'backend.statistic.getErrorsPerOperation', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"operationId":{"type":"integer"},"appId":{"type":"integer"},"userId":{"type":"integer"},"ip":{"type":"string"},"userAgent":{"type":"string"},"method":{"type":"string"},"path":{"type":"string"},"header":{"type":"string"},"body":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.StatisticChart', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Statistic.GetErrorsPerOperation', 0, NULL),
(136, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/statistic/incoming_requests', 200, 'backend.statistic.getIncomingRequests', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"operationId":{"type":"integer"},"appId":{"type":"integer"},"userId":{"type":"integer"},"ip":{"type":"string"},"userAgent":{"type":"string"},"method":{"type":"string"},"path":{"type":"string"},"header":{"type":"string"},"body":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.StatisticChart', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Statistic.GetIncomingRequests', 0, NULL),
(137, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/statistic/incoming_transactions', 200, 'backend.statistic.getIncomingTransactions', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"operationId":{"type":"integer"},"appId":{"type":"integer"},"userId":{"type":"integer"},"ip":{"type":"string"},"userAgent":{"type":"string"},"method":{"type":"string"},"path":{"type":"string"},"header":{"type":"string"},"body":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.StatisticChart', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Statistic.GetIncomingTransactions', 0, NULL),
(138, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/statistic/issued_tokens', 200, 'backend.statistic.getIssuedTokens', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"operationId":{"type":"integer"},"appId":{"type":"integer"},"userId":{"type":"integer"},"ip":{"type":"string"},"userAgent":{"type":"string"},"method":{"type":"string"},"path":{"type":"string"},"header":{"type":"string"},"body":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.StatisticChart', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Statistic.GetIssuedTokens', 0, NULL),
(139, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/statistic/most_used_activities', 200, 'backend.statistic.getMostUsedActivities', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"operationId":{"type":"integer"},"appId":{"type":"integer"},"userId":{"type":"integer"},"ip":{"type":"string"},"userAgent":{"type":"string"},"method":{"type":"string"},"path":{"type":"string"},"header":{"type":"string"},"body":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.StatisticChart', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Statistic.GetMostUsedActivities', 0, NULL),
(140, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/statistic/most_used_apps', 200, 'backend.statistic.getMostUsedApps', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"operationId":{"type":"integer"},"appId":{"type":"integer"},"userId":{"type":"integer"},"ip":{"type":"string"},"userAgent":{"type":"string"},"method":{"type":"string"},"path":{"type":"string"},"header":{"type":"string"},"body":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.StatisticChart', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Statistic.GetMostUsedApps', 0, NULL),
(141, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/statistic/most_used_operations', 200, 'backend.statistic.getMostUsedOperations', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"operationId":{"type":"integer"},"appId":{"type":"integer"},"userId":{"type":"integer"},"ip":{"type":"string"},"userAgent":{"type":"string"},"method":{"type":"string"},"path":{"type":"string"},"header":{"type":"string"},"body":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.StatisticChart', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Statistic.GetMostUsedOperations', 0, NULL),
(142, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/statistic/test_coverage', 200, 'backend.statistic.getTestCoverage', '{}', NULL, 'php+class://Fusio.Model.Backend.StatisticChart', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Statistic.GetTestCoverage', 0, NULL),
(143, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/statistic/time_average', 200, 'backend.statistic.getTimeAverage', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"operationId":{"type":"integer"},"appId":{"type":"integer"},"userId":{"type":"integer"},"ip":{"type":"string"},"userAgent":{"type":"string"},"method":{"type":"string"},"path":{"type":"string"},"header":{"type":"string"},"body":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.StatisticChart', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Statistic.GetTimeAverage', 0, NULL);
INSERT INTO `fusio_operation` VALUES
(144, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/statistic/time_per_operation', 200, 'backend.statistic.getTimePerOperation', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"operationId":{"type":"integer"},"appId":{"type":"integer"},"userId":{"type":"integer"},"ip":{"type":"string"},"userAgent":{"type":"string"},"method":{"type":"string"},"path":{"type":"string"},"header":{"type":"string"},"body":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.StatisticChart', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Statistic.GetTimePerOperation', 0, NULL),
(145, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/statistic/used_points', 200, 'backend.statistic.getUsedPoints', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"operationId":{"type":"integer"},"appId":{"type":"integer"},"userId":{"type":"integer"},"ip":{"type":"string"},"userAgent":{"type":"string"},"method":{"type":"string"},"path":{"type":"string"},"header":{"type":"string"},"body":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.StatisticChart', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Statistic.GetUsedPoints', 0, NULL),
(146, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/statistic/user_registrations', 200, 'backend.statistic.getUserRegistrations', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"operationId":{"type":"integer"},"appId":{"type":"integer"},"userId":{"type":"integer"},"ip":{"type":"string"},"userAgent":{"type":"string"},"method":{"type":"string"},"path":{"type":"string"},"header":{"type":"string"},"body":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.StatisticChart', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Statistic.GetUserRegistrations', 0, NULL),
(147, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/tenant/:tenant_id', 200, 'backend.tenant.setup', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Tenant.Setup', 0, NULL),
(148, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/tenant/:tenant_id', 200, 'backend.tenant.remove', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Tenant.Remove', 0, NULL),
(149, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/test', 200, 'backend.test.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.TestCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Test.GetAll', 0, NULL),
(150, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/test/$test_id<[0-9]+>', 200, 'backend.test.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Test', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Test.Get', 0, NULL),
(151, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/test', 200, 'backend.test.refresh', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Test.Refresh', 0, NULL),
(152, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/test', 200, 'backend.test.run', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Test.Run', 0, NULL),
(153, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/test/$test_id<[0-9]+>', 200, 'backend.test.update', '{}', 'php+class://Fusio.Model.Backend.Test', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Test.Update', 0, NULL),
(154, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/token', 200, 'backend.token.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"appId":{"type":"integer"},"userId":{"type":"integer"},"status":{"type":"integer"},"scope":{"type":"string"},"ip":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.TokenCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Token.GetAll', 0, NULL),
(155, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/token/$token_id<[0-9]+>', 200, 'backend.token.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Token', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Token.Get', 0, NULL),
(156, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/transaction', 200, 'backend.transaction.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"},"from":{"type":"string","format":"date-time"},"to":{"type":"string","format":"date-time"},"planId":{"type":"integer"},"userId":{"type":"integer"},"appId":{"type":"integer"},"status":{"type":"string"},"provider":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.TransactionCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Transaction.GetAll', 0, NULL),
(157, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/transaction/$transaction_id<[0-9]+>', 200, 'backend.transaction.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Transaction', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Transaction.Get', 0, NULL),
(158, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/trash', 200, 'backend.trash.getTypes', '{}', NULL, 'php+class://Fusio.Model.Backend.TrashTypes', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Trash.GetTypes', 0, NULL),
(159, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/trash/:type', 200, 'backend.trash.getAllByType', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.TrashDataCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Trash.GetAll', 0, NULL),
(160, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/trash/:type', 200, 'backend.trash.restore', '{}', 'php+class://Fusio.Model.Backend.TrashRestore', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Trash.Restore', 0, NULL),
(161, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/user', 200, 'backend.user.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.UserCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.User.GetAll', 0, NULL),
(162, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/user', 201, 'backend.user.create', '{}', 'php+class://Fusio.Model.Backend.UserCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.User.Create', 0, NULL),
(163, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/user/$user_id<[0-9]+|^~>', 200, 'backend.user.get', '{}', NULL, 'php+class://Fusio.Model.Backend.User', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.User.Get', 0, NULL),
(164, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/user/$user_id<[0-9]+|^~>', 200, 'backend.user.update', '{}', 'php+class://Fusio.Model.Backend.UserUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.User.Update', 0, NULL),
(165, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/user/$user_id<[0-9]+|^~>', 200, 'backend.user.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.User.Delete', 0, NULL),
(166, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/webhook', 200, 'backend.webhook.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Backend.WebhookCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Webhook.GetAll', 0, NULL),
(167, 2, NULL, 1, 1, 0, 2, '', 'POST', '/backend/webhook', 201, 'backend.webhook.create', '{}', 'php+class://Fusio.Model.Backend.WebhookCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Webhook.Create', 0, NULL),
(168, 2, NULL, 1, 1, 0, 2, '', 'GET', '/backend/webhook/$webhook_id<[0-9]+|^~>', 200, 'backend.webhook.get', '{}', NULL, 'php+class://Fusio.Model.Backend.Webhook', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Webhook.Get', 0, NULL),
(169, 2, NULL, 1, 1, 0, 2, '', 'PUT', '/backend/webhook/$webhook_id<[0-9]+|^~>', 200, 'backend.webhook.update', '{}', 'php+class://Fusio.Model.Backend.WebhookUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Webhook.Update', 0, NULL),
(170, 2, NULL, 1, 1, 0, 2, '', 'DELETE', '/backend/webhook/$webhook_id<[0-9]+|^~>', 200, 'backend.webhook.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Backend.Action.Webhook.Delete', 0, NULL),
(171, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/app', 200, 'consumer.app.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Consumer.AppCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.App.GetAll', 0, NULL),
(172, 3, NULL, 1, 1, 0, 2, '', 'POST', '/consumer/app', 201, 'consumer.app.create', '{}', 'php+class://Fusio.Model.Consumer.AppCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.App.Create', 0, NULL),
(173, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/app/$app_id<[0-9]+|^~>', 200, 'consumer.app.get', '{}', NULL, 'php+class://Fusio.Model.Consumer.App', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.App.Get', 0, NULL),
(174, 3, NULL, 1, 1, 0, 2, '', 'PUT', '/consumer/app/$app_id<[0-9]+|^~>', 200, 'consumer.app.update', '{}', 'php+class://Fusio.Model.Consumer.AppUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.App.Update', 0, NULL),
(175, 3, NULL, 1, 1, 0, 2, '', 'DELETE', '/consumer/app/$app_id<[0-9]+|^~>', 200, 'consumer.app.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.App.Delete', 0, NULL),
(176, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/event', 200, 'consumer.event.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Consumer.EventCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Event.GetAll', 0, NULL),
(177, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/event/$event_id<[0-9]+|^~>', 200, 'consumer.event.get', '{}', NULL, 'php+class://Fusio.Model.Consumer.Event', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Event.Get', 0, NULL),
(178, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/grant', 200, 'consumer.grant.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Consumer.GrantCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Grant.GetAll', 0, NULL),
(179, 3, NULL, 1, 1, 0, 2, '', 'DELETE', '/consumer/grant/$grant_id<[0-9]+>', 200, 'consumer.grant.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Grant.Delete', 0, NULL),
(180, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/log', 200, 'consumer.log.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Consumer.LogCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Log.GetAll', 0, NULL),
(181, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/log/$log_id<[0-9]+>', 200, 'consumer.log.get', '{}', NULL, 'php+class://Fusio.Model.Consumer.Log', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Log.Get', 0, NULL),
(182, 3, NULL, 1, 1, 1, 2, '', 'GET', '/consumer/page', 200, 'consumer.page.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Consumer.PageCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Page.GetAll', 0, NULL),
(183, 3, NULL, 1, 1, 1, 2, '', 'GET', '/consumer/page/:page_id', 200, 'consumer.page.get', '{}', NULL, 'php+class://Fusio.Model.Consumer.Page', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Page.Get', 0, NULL),
(184, 3, NULL, 1, 1, 1, 2, '', 'GET', '/consumer/form', 200, 'consumer.form.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Consumer.FormCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Form.GetAll', 0, NULL),
(185, 3, NULL, 1, 1, 1, 2, '', 'GET', '/consumer/form/:form_id', 200, 'consumer.form.get', '{}', NULL, 'php+class://Fusio.Model.Consumer.Form', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Form.Get', 0, NULL),
(186, 3, NULL, 1, 1, 0, 2, '', 'POST', '/consumer/payment/:provider/portal', 200, 'consumer.payment.portal', '{}', 'php+class://Fusio.Model.Consumer.PaymentPortalRequest', 'php+class://Fusio.Model.Consumer.PaymentPortalResponse', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Payment.Portal', 0, NULL),
(187, 3, NULL, 1, 1, 0, 2, '', 'POST', '/consumer/payment/:provider/checkout', 200, 'consumer.payment.checkout', '{}', 'php+class://Fusio.Model.Consumer.PaymentCheckoutRequest', 'php+class://Fusio.Model.Consumer.PaymentCheckoutResponse', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Payment.Checkout', 0, NULL),
(188, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/plan', 200, 'consumer.plan.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Consumer.PlanCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Plan.GetAll', 0, NULL),
(189, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/plan/$plan_id<[0-9]+|^~>', 200, 'consumer.plan.get', '{}', NULL, 'php+class://Fusio.Model.Consumer.Plan', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Plan.Get', 0, NULL),
(190, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/scope', 200, 'consumer.scope.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Consumer.ScopeCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Scope.GetAll', 0, NULL),
(191, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/scope/categories', 200, 'consumer.scope.getCategories', '{}', NULL, 'php+class://Fusio.Model.Consumer.ScopeCategories', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Scope.GetCategories', 0, NULL),
(192, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/token', 200, 'consumer.token.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Consumer.TokenCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Token.GetAll', 0, NULL),
(193, 3, NULL, 1, 1, 0, 2, '', 'POST', '/consumer/token', 201, 'consumer.token.create', '{}', 'php+class://Fusio.Model.Consumer.TokenCreate', 'php+class://Fusio.Model.Consumer.TokenAccessToken', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Token.Create', 0, NULL),
(194, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/token/$token_id<[0-9]+|^~>', 200, 'consumer.token.get', '{}', NULL, 'php+class://Fusio.Model.Consumer.Token', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Token.Get', 0, NULL),
(195, 3, NULL, 1, 1, 0, 2, '', 'PUT', '/consumer/token/$token_id<[0-9]+|^~>', 200, 'consumer.token.update', '{}', 'php+class://Fusio.Model.Consumer.TokenUpdate', 'php+class://Fusio.Model.Consumer.TokenAccessToken', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Token.Update', 0, NULL),
(196, 3, NULL, 1, 1, 0, 2, '', 'DELETE', '/consumer/token/$token_id<[0-9]+|^~>', 200, 'consumer.token.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Token.Delete', 0, NULL),
(197, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/webhook', 200, 'consumer.webhook.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Consumer.WebhookCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Webhook.GetAll', 0, NULL),
(198, 3, NULL, 1, 1, 0, 2, '', 'POST', '/consumer/webhook', 201, 'consumer.webhook.create', '{}', 'php+class://Fusio.Model.Consumer.WebhookCreate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Webhook.Create', 0, NULL),
(199, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/webhook/$webhook_id<[0-9]+|^~>', 200, 'consumer.webhook.get', '{}', NULL, 'php+class://Fusio.Model.Consumer.Webhook', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Webhook.Get', 0, NULL),
(200, 3, NULL, 1, 1, 0, 2, '', 'PUT', '/consumer/webhook/$webhook_id<[0-9]+|^~>', 200, 'consumer.webhook.update', '{}', 'php+class://Fusio.Model.Consumer.WebhookUpdate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Webhook.Update', 0, NULL),
(201, 3, NULL, 1, 1, 0, 2, '', 'DELETE', '/consumer/webhook/$webhook_id<[0-9]+|^~>', 200, 'consumer.webhook.delete', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Webhook.Delete', 0, NULL),
(202, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/transaction', 200, 'consumer.transaction.getAll', '{"startIndex":{"type":"integer"},"count":{"type":"integer"},"search":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Consumer.TransactionCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Transaction.GetAll', 0, NULL),
(203, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/transaction/$transaction_id<[0-9]+|^~>', 200, 'consumer.transaction.get', '{}', NULL, 'php+class://Fusio.Model.Consumer.Transaction', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Transaction.Get', 0, NULL),
(204, 3, NULL, 1, 1, 0, 2, '', 'GET', '/consumer/account', 200, 'consumer.account.get', '{}', NULL, 'php+class://Fusio.Model.Consumer.UserAccount', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.User.Get', 0, NULL),
(205, 3, NULL, 1, 1, 0, 2, '', 'PUT', '/consumer/account', 200, 'consumer.account.update', '{}', 'php+class://Fusio.Model.Consumer.UserAccount', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.User.Update', 0, NULL),
(206, 3, NULL, 1, 1, 0, 2, '', 'PUT', '/consumer/account/change_password', 200, 'consumer.account.changePassword', '{}', 'php+class://Fusio.Model.Backend.AccountChangePassword', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.User.ChangePassword', 0, NULL),
(207, 3, NULL, 1, 1, 1, 2, '', 'POST', '/consumer/activate', 200, 'consumer.account.activate', '{}', 'php+class://Fusio.Model.Consumer.UserActivate', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.User.Activate', 0, NULL),
(208, 3, NULL, 1, 1, 1, 2, '', 'GET', '/consumer/authorize', 200, 'consumer.account.getApp', '{}', NULL, 'php+class://Fusio.Model.Consumer.AuthorizeMeta', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.User.GetApp', 0, NULL),
(209, 3, NULL, 1, 1, 1, 2, '', 'POST', '/consumer/authorize', 200, 'consumer.account.authorize', '{}', 'php+class://Fusio.Model.Consumer.AuthorizeRequest', 'php+class://Fusio.Model.Consumer.AuthorizeResponse', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.User.Authorize', 0, NULL),
(210, 3, NULL, 1, 1, 1, 2, '', 'POST', '/consumer/login', 200, 'consumer.account.login', '{}', 'php+class://Fusio.Model.Consumer.UserLogin', 'php+class://Fusio.Model.Consumer.UserJWT', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.User.Login', 0, NULL),
(211, 3, NULL, 1, 1, 1, 2, '', 'PUT', '/consumer/login', 200, 'consumer.account.refresh', '{}', 'php+class://Fusio.Model.Consumer.UserRefresh', 'php+class://Fusio.Model.Consumer.UserJWT', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.User.Refresh', 0, NULL),
(212, 3, NULL, 1, 1, 1, 2, '', 'POST', '/consumer/register', 200, 'consumer.account.register', '{}', 'php+class://Fusio.Model.Consumer.UserRegister', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.User.Register', 0, NULL),
(213, 3, NULL, 1, 1, 1, 2, '', 'POST', '/consumer/password_reset', 200, 'consumer.account.requestPasswordReset', '{}', 'php+class://Fusio.Model.Consumer.UserEmail', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.User.ResetPassword.Request', 0, NULL),
(214, 3, NULL, 1, 1, 1, 2, '', 'PUT', '/consumer/password_reset', 200, 'consumer.account.executePasswordReset', '{}', 'php+class://Fusio.Model.Consumer.UserPasswordReset', 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.User.ResetPassword.Execute', 0, NULL),
(215, 3, NULL, 1, 1, 1, 2, '', 'GET', '/consumer/identity', 200, 'consumer.identity.getAll', '{"appId":{"deprecated":true,"type":"integer"},"appKey":{"type":"string"}}', NULL, 'php+class://Fusio.Model.Consumer.IdentityCollection', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Identity.GetAll', 0, NULL),
(216, 3, NULL, 1, 1, 1, 2, '', 'GET', '/consumer/identity/:identity/exchange', 200, 'consumer.identity.exchange', '{}', NULL, 'php+class://PSX.Api.Model.Passthru', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Identity.Exchange', 0, NULL),
(217, 3, NULL, 1, 1, 1, 2, '', 'GET', '/consumer/identity/:identity/redirect', 200, 'consumer.identity.redirect', '{}', NULL, 'php+class://PSX.Api.Model.Passthru', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Consumer.Action.Identity.Redirect', 0, NULL),
(218, 4, NULL, 1, 1, 1, 2, '', 'GET', '/system/connection/:name/callback', 200, 'system.connection.callback', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.System.Action.Connection.Callback', 0, NULL),
(219, 4, NULL, 1, 1, 1, 2, '', 'GET', '/system/about', 200, 'system.meta.getAbout', '{}', NULL, 'php+class://Fusio.Model.System.About', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.System.Action.Meta.GetAbout', 0, NULL),
(220, 4, NULL, 1, 1, 1, 2, '', 'POST', '/system/debug', 200, 'system.meta.getDebug', '{}', 'php+class://PSX.Api.Model.Passthru', 'php+class://PSX.Api.Model.Passthru', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.System.Action.Meta.GetDebug', 0, NULL),
(221, 4, NULL, 1, 1, 1, 2, '', 'GET', '/system/health', 200, 'system.meta.getHealth', '{}', NULL, 'php+class://Fusio.Model.System.HealthCheck', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.System.Action.Meta.GetHealth', 0, NULL),
(222, 4, NULL, 1, 1, 1, 2, '', 'GET', '/system/oauth-authorization-server', 200, 'system.meta.getOAuth2Configuration', '{}', NULL, 'php+class://Fusio.Model.System.OAuthConfiguration', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.System.Action.Meta.GetOAuth2Configuration', 0, NULL),
(223, 4, NULL, 1, 1, 1, 2, '', 'GET', '/system/api-catalog', 200, 'system.meta.getAPICatalog', '{}', NULL, 'php+class://Fusio.Model.System.APICatalog', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.System.Action.Meta.GetAPICatalog', 0, NULL),
(224, 4, NULL, 1, 1, 1, 2, '', 'GET', '/system/route', 200, 'system.meta.getRoutes', '{}', NULL, 'php+class://Fusio.Model.System.Route', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.System.Action.Meta.GetRoutes', 0, NULL),
(225, 4, NULL, 1, 1, 1, 2, '', 'GET', '/system/schema/:name', 200, 'system.meta.getSchema', '{}', NULL, 'php+class://Fusio.Model.System.Schema', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.System.Action.Meta.GetSchema', 0, NULL),
(226, 4, NULL, 1, 1, 1, 2, '', 'POST', '/system/payment/:provider/webhook', 200, 'system.payment.webhook', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.System.Action.Payment.Webhook', 0, NULL),
(227, 5, NULL, 1, 1, 0, 2, '', 'POST', '/authorization/revoke', 200, 'authorization.revoke', '{}', NULL, 'php+class://Fusio.Model.Common.Message', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Authorization.Action.Revoke', 0, NULL),
(228, 5, NULL, 1, 1, 0, 2, '', 'GET', '/authorization/whoami', 200, 'authorization.getWhoami', '{}', NULL, 'php+class://Fusio.Model.Backend.User', '{"999":"php+class:\\/\\/Fusio.Model.Common.Message"}', 'php+class://Fusio.Impl.Authorization.Action.GetWhoami', 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `fusio_page`
--

CREATE TABLE `fusio_page` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8_unicode_ci NOT NULL,
  `metadata` longtext COLLATE utf8_unicode_ci,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_CF1989379033212A989D9B62` (`tenant_id`,`slug`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `fusio_page`
--

INSERT INTO `fusio_page` VALUES
(1, NULL, 2, 'Overview', 'overview', '\n<div class="fusio-intro">\n  <h1>Employ the Acme API<br> to power your app.</h1>\n  <p>Explore the documentation or dive<br>directly into the API reference.</p>\n  <p>\n    <a class="btn btn-primary btn-lg" href="./bootstrap" role="button">Get started</a>\n    <a class="btn btn-secondary btn-lg" href="./api" role="button">REST API</a>\n  </p>\n</div>\n\n<div class="fusio-intro-subline">\n  <h2>Join the developer community.</h2>\n  <p>You can <a href="./register">register</a> a new account or <a href="./login">login</a>.</p>\n</div>\n\n<div class="row">\n  <div class="col-md-4">\n    <div class="fusio-intro-column">\n      <div class="fusio-intro-column-icon text-primary">\n        <i class="bi bi-cloudy-fill"></i>\n      </div>\n      <h3><a href="./bootstrap" class="link-primary">Documentation</a></h3>\n      <p>Explore guides which<br>help you get started quickly.</p>\n    </div>\n  </div>\n  <div class="col-md-4">\n    <div class="fusio-intro-column">\n      <div class="fusio-intro-column-icon text-primary">\n        <i class="bi bi-box-fill"></i>\n      </div>\n      <h3><a href="./api" class="link-primary">API</a></h3>\n      <p>Dive directly into the<br>complete API reference.</p>\n    </div>\n  </div>\n  <div class="col-md-4">\n    <div class="fusio-intro-column">\n      <div class="fusio-intro-column-icon text-primary">\n        <i class="bi bi-chat-fill"></i>\n      </div>\n      <h3><a href="./support" class="link-primary">Support</a></h3>\n      <p>Find all available<br>support options if you get stuck.</p>\n    </div>\n  </div>\n</div>', NULL, '[[regtime]]'),
(2, NULL, 1, 'Getting started', 'getting-started', '\n<p class="lead">Learn how to start using this API. Explore the endpoints, sign up for an account, and connect with the\ncommunity.</p>\n\n<h3>Quickstart</h3>\n\n<p>This is a quick introduction to help you get started using this API.</p>\n\n<ul>\n  <li><a href="./register">Signup for a new account</a></li>\n  <li><a href="./authorization">Learn how to obtain an Access-Token</a></li>\n  <li><a href="./api">Explore the API documentation</a></li>\n  <li><a href="./sdk">Download an SDK</a></li>\n</ul>', NULL, '[[regtime]]'),
(3, NULL, 1, 'API', 'api', '\n<iframe src="{APPS_URL}/redoc/" width="100%" height="1024px" style="border:0"></iframe>', NULL, '[[regtime]]'),
(4, NULL, 1, 'Authorization', 'authorization', '\n<p class="lead">To access protected parts of the API you need to obtain an access token. The following page shows how\nto obtain an access token.</p>\n\n<h3>Basic</h3>\n\n<p>The most basic way to obtain an access token is to use your personal credentials.</p>\n\n<p><b>Request</b></p>\n<pre class="bg-dark text-white p-2">POST /consumer/login\nContent-Type: application/json\n\n{\n  "username": "[username]",\n  "password": "[password]"\n}\n</pre>\n\n<p><b>Response</b></p>\n<pre class="bg-dark text-white p-2">\n{\n  "token": "",\n  "expires_in": "",\n  "refresh_token": ""\n}\n</pre>\n\n<h3>OAuth2</h3>\n\n<p>It is also possible to use the <a href="https://tools.ietf.org/html/rfc6749">OAuth2</a> authorization endpoint.</p>\n\n<h4>Client credentials</h4>\n\n<p><b>Request</b></p>\n<pre class="bg-dark text-white p-2">POST /authorization/token\nAuthorization: Basic czZCaGRSa3F0MzpnWDFmQmF0M2JW\nContent-Type: application/x-www-form-urlencoded\n\ngrant_type=client_credentials\n</pre>\n\n<p>As Basic authorization header you need to provide the <code>[app key] + ":" + [app secret]</code> as <code>base64</code>\nencoded string. It is also possible to provide your username and password but in general it is recommended to use the\napp key and secret since the app access can always be revoked later on.</p>\n\n<p><b>Response</b></p>\n<pre class="bg-dark text-white p-2">\n{\n  "access_token": "",\n  "token_type": "bearer",\n  "expires_in": 3600,\n  "refresh_token": ""\n}\n</pre>\n\n<h4>Refresh token</h4>\n\n<p>Most token responses always include a refresh token. You can use this refresh token to extend an access token before\nit expires.</p>\n\n<p><b>Request</b></p>\n<pre class="bg-dark text-white p-2">POST /authorization/token\nAuthorization: Basic czZCaGRSa3F0MzpnWDFmQmF0M2JW\nContent-Type: application/x-www-form-urlencoded\n\ngrant_type=refresh_token&refresh_token=[refresh_token]\n</pre>\n\n<p>Like at the client credentials call the Basic header must contain the base64 encode app key and secret.</p>\n\n<p><b>Response</b></p>\n<pre class="bg-dark text-white p-2">\n{\n  "access_token": "",\n  "token_type": "bearer",\n  "expires_in": 3600,\n  "refresh_token": ""\n}\n</pre>\n\n<p>As response you will get a new access token.</p>', NULL, '[[regtime]]'),
(5, NULL, 1, 'Support', 'support', '\n<p class="lead">This API was build with <a href="https://www.fusio-project.org">Fusio</a> please visit the website of\nthe API provider to see available support options.</p>', NULL, '[[regtime]]'),
(6, NULL, 1, 'SDK', 'sdk', '\n<p class="lead">At the following page you can download the automatically generated client SDKs which help you to\nintegrate the API into your project.</p>\n\n<div class="card float-start" style="width:14rem;margin-right:1rem;margin-bottom:1rem">\n  <h5 class="card-header">PHP</h5>\n  <img src="assets/sdk/client-php.png" class="card-img-top" style="padding:16px;">\n  <div class="card-body">\n    <div class="btn-group" role="group">\n      <a href="{BASE_URL}/sdk/sdk-client-php-default.zip" class="btn btn-primary">Download</a>\n    </div>\n  </div>\n</div>\n\n<div class="card float-start" style="width:14rem;margin-right:1rem;margin-bottom:1rem">\n  <h5 class="card-header">TypeScript</h5>\n  <img src="assets/sdk/client-typescript.png" class="card-img-top" style="padding:16px;">\n  <div class="card-body">\n    <div class="btn-group" role="group">\n      <a href="{BASE_URL}/sdk/sdk-client-typescript-default.zip" class="btn btn-primary">Download</a>\n    </div>\n  </div>\n</div>\n\n<div class="card float-start" style="width:14rem;margin-right:1rem;margin-bottom:1rem">\n  <h5 class="card-header">OpenAPI</h5>\n  <img src="assets/sdk/spec-openapi.png" class="card-img-top" style="padding:16px;">\n  <div class="card-body">\n    <div class="btn-group" role="group">\n      <a href="{BASE_URL}/sdk/sdk-spec-openapi-default.zip" class="btn btn-primary">Download</a>\n    </div>\n  </div>\n</div>\n\n<div style="clear:both"></div>', NULL, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `fusio_plan`
--

CREATE TABLE `fusio_plan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `price` int(11) NOT NULL,
  `points` int(11) NOT NULL,
  `period_type` int(11) DEFAULT NULL,
  `external_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `metadata` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_649646A9033212A5E237E06` (`tenant_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_plan_scope`
--

CREATE TABLE `fusio_plan_scope` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `plan_id` int(11) NOT NULL,
  `scope_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_ADDB2FFBE899029B682B5931` (`plan_id`,`scope_id`),
  KEY `IDX_ADDB2FFB682B5931` (`scope_id`),
  KEY `IDX_ADDB2FFBE899029B` (`plan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_plan_usage`
--

CREATE TABLE `fusio_plan_usage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `operation_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `app_id` int(11) NOT NULL,
  `points` int(11) NOT NULL,
  `insert_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_rate`
--

CREATE TABLE `fusio_rate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL,
  `priority` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `rate_limit` int(11) NOT NULL,
  `timespan` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `metadata` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_4FF002E9033212A5E237E06` (`tenant_id`,`name`),
  KEY `IDX_RATE_S` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `fusio_rate`
--

INSERT INTO `fusio_rate` VALUES
(1, NULL, 1, 0, 'Default', 3600, 'PT1H', NULL),
(2, NULL, 1, 4, 'Default-Anonymous', 900, 'PT1H', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `fusio_rate_allocation`
--

CREATE TABLE `fusio_rate_allocation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate_id` int(11) NOT NULL,
  `operation_id` int(11) DEFAULT NULL,
  `app_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `plan_id` int(11) DEFAULT NULL,
  `authenticated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_26E07532BC999F9F` (`rate_id`),
  KEY `IDX_26E0753244AC3583` (`operation_id`),
  KEY `IDX_26E075327987212D` (`app_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `fusio_rate_allocation`
--

INSERT INTO `fusio_rate_allocation` VALUES
(1, 1, NULL, NULL, NULL, NULL, NULL),
(2, 2, NULL, NULL, NULL, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `fusio_role`
--

CREATE TABLE `fusio_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_8C7AB57D9033212A5E237E06` (`tenant_id`,`name`),
  KEY `IDX_8C7AB57D12469DE2` (`category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `fusio_role`
--

INSERT INTO `fusio_role` VALUES
(1, 1, NULL, 1, 'Administrator'),
(2, 1, NULL, 1, 'Backend'),
(3, 1, NULL, 1, 'Consumer');

-- --------------------------------------------------------

--
-- Table structure for table `fusio_role_scope`
--

CREATE TABLE `fusio_role_scope` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `scope_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_9A18228D60322AC682B5931` (`role_id`,`scope_id`),
  KEY `IDX_9A18228682B5931` (`scope_id`),
  KEY `IDX_9A18228D60322AC` (`role_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `fusio_role_scope`
--

INSERT INTO `fusio_role_scope` VALUES
(2, 1, 1),
(3, 1, 2),
(1, 1, 3),
(4, 1, 4),
(6, 2, 1),
(5, 2, 3),
(7, 2, 4),
(9, 3, 2),
(8, 3, 3),
(10, 3, 4);

-- --------------------------------------------------------

--
-- Table structure for table `fusio_schema`
--

CREATE TABLE `fusio_schema` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '1',
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `source` longtext COLLATE utf8_unicode_ci NOT NULL,
  `form` longtext COLLATE utf8_unicode_ci,
  `metadata` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_B6B33EA9033212A5E237E06` (`tenant_id`,`name`),
  KEY `IDX_B6B33EA12469DE2` (`category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `fusio_schema`
--

INSERT INTO `fusio_schema` VALUES
(1, 1, NULL, 1, 'Passthru', 'PSX\\Api\\Model\\Passthru', NULL, NULL),
(2, 1, NULL, 1, 'Message', 'Fusio\\Model\\Common\\Message', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `fusio_scope`
--

CREATE TABLE `fusio_scope` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '1',
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `metadata` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_83A7C32B9033212A5E237E06` (`tenant_id`,`name`),
  KEY `IDX_83A7C32B12469DE2` (`category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=54 ;

--
-- Dumping data for table `fusio_scope`
--

INSERT INTO `fusio_scope` VALUES
(1, 2, NULL, 1, 'backend', '', NULL),
(2, 3, NULL, 1, 'consumer', '', NULL),
(3, 5, NULL, 1, 'authorization', '', NULL),
(4, 1, NULL, 1, 'default', '', NULL),
(5, 2, NULL, 1, 'backend.account', '', NULL),
(6, 2, NULL, 1, 'backend.action', '', NULL),
(7, 2, NULL, 1, 'backend.app', '', NULL),
(8, 2, NULL, 1, 'backend.audit', '', NULL),
(9, 2, NULL, 1, 'backend.category', '', NULL),
(10, 2, NULL, 1, 'backend.config', '', NULL),
(11, 2, NULL, 1, 'backend.connection', '', NULL),
(12, 2, NULL, 1, 'backend.cronjob', '', NULL),
(13, 2, NULL, 1, 'backend.dashboard', '', NULL),
(14, 2, NULL, 1, 'backend.database', '', NULL),
(15, 2, NULL, 1, 'backend.event', '', NULL),
(16, 2, NULL, 1, 'backend.backup', '', NULL),
(17, 2, NULL, 1, 'backend.firewall', '', NULL),
(18, 2, NULL, 1, 'backend.form', '', NULL),
(19, 2, NULL, 1, 'backend.generator', '', NULL),
(20, 2, NULL, 1, 'backend.identity', '', NULL),
(21, 2, NULL, 1, 'backend.log', '', NULL),
(22, 2, NULL, 1, 'backend.marketplace', '', NULL),
(23, 2, NULL, 1, 'backend.page', '', NULL),
(24, 2, NULL, 1, 'backend.plan', '', NULL),
(25, 2, NULL, 1, 'backend.rate', '', NULL),
(26, 2, NULL, 1, 'backend.role', '', NULL),
(27, 2, NULL, 1, 'backend.operation', '', NULL),
(28, 2, NULL, 1, 'backend.schema', '', NULL),
(29, 2, NULL, 1, 'backend.scope', '', NULL),
(30, 2, NULL, 1, 'backend.sdk', '', NULL),
(31, 2, NULL, 1, 'backend.statistic', '', NULL),
(32, 2, NULL, 1, 'backend.tenant', '', NULL),
(33, 2, NULL, 1, 'backend.test', '', NULL),
(34, 2, NULL, 1, 'backend.token', '', NULL),
(35, 2, NULL, 1, 'backend.transaction', '', NULL),
(36, 2, NULL, 1, 'backend.trash', '', NULL),
(37, 2, NULL, 1, 'backend.user', '', NULL),
(38, 2, NULL, 1, 'backend.webhook', '', NULL),
(39, 3, NULL, 1, 'consumer.app', '', NULL),
(40, 3, NULL, 1, 'consumer.event', '', NULL),
(41, 3, NULL, 1, 'consumer.grant', '', NULL),
(42, 3, NULL, 1, 'consumer.log', '', NULL),
(43, 3, NULL, 1, 'consumer.page', '', NULL),
(44, 3, NULL, 1, 'consumer.form', '', NULL),
(45, 3, NULL, 1, 'consumer.payment', '', NULL),
(46, 3, NULL, 1, 'consumer.plan', '', NULL),
(47, 3, NULL, 1, 'consumer.scope', '', NULL),
(48, 3, NULL, 1, 'consumer.token', '', NULL),
(49, 3, NULL, 1, 'consumer.webhook', '', NULL),
(50, 3, NULL, 1, 'consumer.transaction', '', NULL),
(51, 3, NULL, 1, 'consumer.account', '', NULL),
(52, 3, NULL, 1, 'consumer.identity', '', NULL),
(53, 4, NULL, 1, 'system', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `fusio_scope_operation`
--

CREATE TABLE `fusio_scope_operation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `scope_id` int(11) NOT NULL,
  `operation_id` int(11) NOT NULL,
  `allow` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `IDX_SCOPE_OPERATION_SO` (`scope_id`,`operation_id`),
  KEY `IDX_7B9CDE20682B5931` (`scope_id`),
  KEY `IDX_7B9CDE2044AC3583` (`operation_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=219 ;

--
-- Dumping data for table `fusio_scope_operation`
--

INSERT INTO `fusio_scope_operation` VALUES
(1, 5, 2, 1),
(2, 5, 3, 1),
(3, 5, 4, 1),
(4, 6, 5, 1),
(5, 6, 6, 1),
(6, 6, 7, 1),
(7, 6, 8, 1),
(8, 6, 9, 1),
(9, 6, 10, 1),
(10, 6, 11, 1),
(11, 6, 12, 1),
(12, 7, 13, 1),
(13, 7, 14, 1),
(14, 7, 15, 1),
(15, 7, 16, 1),
(16, 7, 17, 1),
(17, 7, 18, 1),
(18, 8, 19, 1),
(19, 8, 20, 1),
(20, 9, 21, 1),
(21, 9, 22, 1),
(22, 9, 23, 1),
(23, 9, 24, 1),
(24, 9, 25, 1),
(25, 10, 26, 1),
(26, 10, 27, 1),
(27, 10, 28, 1),
(28, 11, 29, 1),
(29, 11, 30, 1),
(30, 11, 31, 1),
(31, 11, 32, 1),
(32, 11, 33, 1),
(33, 11, 34, 1),
(34, 11, 35, 1),
(35, 11, 36, 1),
(36, 12, 37, 1),
(37, 12, 38, 1),
(38, 12, 39, 1),
(39, 12, 40, 1),
(40, 12, 41, 1),
(41, 13, 42, 1),
(42, 14, 43, 1),
(43, 14, 44, 1),
(44, 14, 45, 1),
(45, 14, 46, 1),
(46, 14, 47, 1),
(47, 14, 48, 1),
(48, 14, 49, 1),
(49, 14, 50, 1),
(50, 14, 51, 1),
(51, 14, 52, 1),
(52, 15, 53, 1),
(53, 15, 54, 1),
(54, 15, 55, 1),
(55, 15, 56, 1),
(56, 15, 57, 1),
(57, 16, 58, 1),
(58, 16, 59, 1),
(59, 17, 60, 1),
(60, 17, 61, 1),
(61, 17, 62, 1),
(62, 17, 63, 1),
(63, 17, 64, 1),
(64, 18, 65, 1),
(65, 18, 66, 1),
(66, 18, 67, 1),
(67, 18, 68, 1),
(68, 18, 69, 1),
(69, 19, 70, 1),
(70, 19, 71, 1),
(71, 19, 72, 1),
(72, 19, 73, 1),
(73, 20, 74, 1),
(74, 20, 75, 1),
(75, 20, 76, 1),
(76, 20, 77, 1),
(77, 20, 78, 1),
(78, 20, 79, 1),
(79, 20, 80, 1),
(80, 21, 81, 1),
(81, 21, 82, 1),
(82, 21, 83, 1),
(83, 21, 84, 1),
(84, 22, 85, 1),
(85, 22, 86, 1),
(86, 22, 87, 1),
(87, 22, 88, 1),
(88, 22, 89, 1),
(89, 22, 90, 1),
(90, 22, 91, 1),
(91, 22, 92, 1),
(92, 23, 93, 1),
(93, 23, 94, 1),
(94, 23, 95, 1),
(95, 23, 96, 1),
(96, 23, 97, 1),
(97, 24, 98, 1),
(98, 24, 99, 1),
(99, 24, 100, 1),
(100, 24, 101, 1),
(101, 24, 102, 1),
(102, 25, 103, 1),
(103, 25, 104, 1),
(104, 25, 105, 1),
(105, 25, 106, 1),
(106, 25, 107, 1),
(107, 26, 108, 1),
(108, 26, 109, 1),
(109, 26, 110, 1),
(110, 26, 111, 1),
(111, 26, 112, 1),
(112, 27, 113, 1),
(113, 27, 114, 1),
(114, 27, 115, 1),
(115, 27, 116, 1),
(116, 27, 117, 1),
(117, 28, 118, 1),
(118, 28, 119, 1),
(119, 28, 120, 1),
(120, 28, 121, 1),
(121, 28, 122, 1),
(122, 28, 123, 1),
(123, 28, 124, 1),
(124, 29, 125, 1),
(125, 29, 126, 1),
(126, 29, 127, 1),
(127, 29, 128, 1),
(128, 29, 129, 1),
(129, 29, 130, 1),
(130, 30, 131, 1),
(131, 30, 132, 1),
(132, 31, 133, 1),
(133, 31, 134, 1),
(134, 31, 135, 1),
(135, 31, 136, 1),
(136, 31, 137, 1),
(137, 31, 138, 1),
(138, 31, 139, 1),
(139, 31, 140, 1),
(140, 31, 141, 1),
(141, 31, 142, 1),
(142, 31, 143, 1),
(143, 31, 144, 1),
(144, 31, 145, 1),
(145, 31, 146, 1),
(146, 32, 147, 1),
(147, 32, 148, 1),
(148, 33, 149, 1),
(149, 33, 150, 1),
(150, 33, 151, 1),
(151, 33, 152, 1),
(152, 33, 153, 1),
(153, 34, 154, 1),
(154, 34, 155, 1),
(155, 35, 156, 1),
(156, 35, 157, 1),
(157, 36, 158, 1),
(158, 36, 159, 1),
(159, 36, 160, 1),
(160, 37, 161, 1),
(161, 37, 162, 1),
(162, 37, 163, 1),
(163, 37, 164, 1),
(164, 37, 165, 1),
(165, 38, 166, 1),
(166, 38, 167, 1),
(167, 38, 168, 1),
(168, 38, 169, 1),
(169, 38, 170, 1),
(170, 39, 171, 1),
(171, 39, 172, 1),
(172, 39, 173, 1),
(173, 39, 174, 1),
(174, 39, 175, 1),
(175, 40, 176, 1),
(176, 40, 177, 1),
(177, 41, 178, 1),
(178, 41, 179, 1),
(179, 42, 180, 1),
(180, 42, 181, 1),
(181, 43, 182, 1),
(182, 43, 183, 1),
(183, 44, 184, 1),
(184, 44, 185, 1),
(185, 45, 186, 1),
(186, 45, 187, 1),
(187, 46, 188, 1),
(188, 46, 189, 1),
(189, 47, 190, 1),
(190, 47, 191, 1),
(191, 48, 192, 1),
(192, 48, 193, 1),
(193, 48, 194, 1),
(194, 48, 195, 1),
(195, 48, 196, 1),
(196, 49, 197, 1),
(197, 49, 198, 1),
(198, 49, 199, 1),
(199, 49, 200, 1),
(200, 49, 201, 1),
(201, 50, 202, 1),
(202, 50, 203, 1),
(203, 51, 204, 1),
(204, 51, 205, 1),
(205, 51, 206, 1),
(206, 51, 207, 1),
(207, 51, 208, 1),
(208, 51, 209, 1),
(209, 51, 210, 1),
(210, 51, 211, 1),
(211, 51, 212, 1),
(212, 51, 213, 1),
(213, 51, 214, 1),
(214, 52, 215, 1),
(215, 52, 216, 1),
(216, 52, 217, 1),
(217, 3, 227, 1),
(218, 3, 228, 1);

-- --------------------------------------------------------

--
-- Table structure for table `fusio_test`
--

CREATE TABLE `fusio_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '1',
  `operation_id` int(11) DEFAULT NULL,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `message` longtext COLLATE utf8_unicode_ci,
  `response` longtext COLLATE utf8_unicode_ci,
  `uri_fragments` varchar(512) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parameters` varchar(512) COLLATE utf8_unicode_ci DEFAULT NULL,
  `headers` varchar(512) COLLATE utf8_unicode_ci DEFAULT NULL,
  `body` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_36C411B44AC3583` (`operation_id`),
  KEY `IDX_36C411B12469DE2` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_token`
--

CREATE TABLE `fusio_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '1',
  `app_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `token` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `refresh` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `scope` varchar(1023) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `expire` datetime DEFAULT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_DC3F37C39033212A7B00651C5F37A13B` (`tenant_id`,`status`,`token`),
  UNIQUE KEY `UNIQ_DC3F37C39033212A6081A0FB` (`tenant_id`,`refresh`),
  KEY `IDX_DC3F37C37987212D` (`app_id`),
  KEY `IDX_DC3F37C3A76ED395` (`user_id`),
  KEY `IDX_DC3F37C312469DE2` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_transaction`
--

CREATE TABLE `fusio_transaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `plan_id` int(11) NOT NULL,
  `transaction_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `amount` int(11) NOT NULL,
  `points` int(11) NOT NULL,
  `period_start` datetime DEFAULT NULL,
  `period_end` datetime DEFAULT NULL,
  `insert_date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_F377C1239033212A2FC0CB0F` (`tenant_id`,`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_user`
--

CREATE TABLE `fusio_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `identity_id` int(11) DEFAULT NULL,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `role_id` int(11) NOT NULL,
  `plan_id` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `remote_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `external_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `points` int(11) DEFAULT NULL,
  `token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `metadata` longtext COLLATE utf8_unicode_ci,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_5680E95E9033212AFF3ED4A82A3E9C94` (`tenant_id`,`identity_id`,`remote_id`),
  UNIQUE KEY `UNIQ_5680E95E9033212A5E237E06` (`tenant_id`,`name`),
  UNIQUE KEY `UNIQ_5680E95E9033212AE7927C74` (`tenant_id`,`email`),
  KEY `IDX_5680E95EFF3ED4A8` (`identity_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `fusio_user`
--

INSERT INTO `fusio_user` VALUES
(1, NULL, NULL, 1, NULL, 1, NULL, NULL, 'Administrator', 'admin@localhost.com', '[[admin_pass]]', NULL, NULL, NULL, '[[regtime]]'),
(2, NULL, NULL, 1, NULL, 1, NULL, NULL, '[[admin_username]]', '[[admin_email]]', '[[admin_pass]]', NULL, NULL, NULL, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `fusio_user_grant`
--

CREATE TABLE `fusio_user_grant` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `app_id` int(11) NOT NULL,
  `allow` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_D515A2C0A76ED3957987212D` (`user_id`,`app_id`),
  KEY `IDX_D515A2C0A76ED395` (`user_id`),
  KEY `IDX_D515A2C07987212D` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_user_scope`
--

CREATE TABLE `fusio_user_scope` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `scope_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_1CBF915FA76ED395682B5931` (`user_id`,`scope_id`),
  KEY `IDX_1CBF915F682B5931` (`scope_id`),
  KEY `IDX_1CBF915FA76ED395` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=57 ;

--
-- Dumping data for table `fusio_user_scope`
--

INSERT INTO `fusio_user_scope` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 1, 3),
(4, 1, 4),
(5, 2, 1),
(40, 2, 2),
(55, 2, 3),
(56, 2, 4),
(6, 2, 5),
(7, 2, 6),
(8, 2, 7),
(9, 2, 8),
(11, 2, 9),
(12, 2, 10),
(13, 2, 11),
(14, 2, 12),
(15, 2, 13),
(16, 2, 14),
(17, 2, 15),
(10, 2, 16),
(18, 2, 17),
(19, 2, 18),
(20, 2, 19),
(21, 2, 20),
(22, 2, 21),
(23, 2, 22),
(25, 2, 23),
(26, 2, 24),
(27, 2, 25),
(28, 2, 26),
(24, 2, 27),
(29, 2, 28),
(30, 2, 29),
(31, 2, 30),
(32, 2, 31),
(33, 2, 32),
(34, 2, 33),
(35, 2, 34),
(36, 2, 35),
(37, 2, 36),
(38, 2, 37),
(39, 2, 38),
(42, 2, 39),
(43, 2, 40),
(45, 2, 41),
(47, 2, 42),
(48, 2, 43),
(44, 2, 44),
(49, 2, 45),
(50, 2, 46),
(51, 2, 47),
(52, 2, 48),
(54, 2, 49),
(53, 2, 50),
(41, 2, 51),
(46, 2, 52);

-- --------------------------------------------------------

--
-- Table structure for table `fusio_webhook`
--

CREATE TABLE `fusio_webhook` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `tenant_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL,
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `endpoint` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_4F7DC99A9033212A` (`tenant_id`),
  KEY `IDX_4F7DC99A71F7E88B` (`event_id`),
  KEY `IDX_4F7DC99AA76ED395` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `fusio_webhook_response`
--

CREATE TABLE `fusio_webhook_response` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `webhook_id` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `attempts` int(11) NOT NULL,
  `code` int(11) DEFAULT NULL,
  `body` longtext COLLATE utf8_unicode_ci,
  `execute_date` datetime DEFAULT NULL,
  `insert_date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_5958D3755C9BA60B` (`webhook_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `messenger_messages`
--

CREATE TABLE `messenger_messages` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `body` longtext COLLATE utf8_unicode_ci NOT NULL,
  `headers` longtext COLLATE utf8_unicode_ci NOT NULL,
  `queue_name` varchar(190) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL COMMENT '(DC2Type:datetime_immutable)',
  `available_at` datetime NOT NULL COMMENT '(DC2Type:datetime_immutable)',
  `delivered_at` datetime DEFAULT NULL COMMENT '(DC2Type:datetime_immutable)',
  PRIMARY KEY (`id`),
  KEY `IDX_75EA56E0FB7336F0` (`queue_name`),
  KEY `IDX_75EA56E0E3BD61CE` (`available_at`),
  KEY `IDX_75EA56E016BA31DB` (`delivered_at`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `messenger_messages`
--

INSERT INTO `messenger_messages` VALUES
(1, 'O:36:\\"Symfony\\\\Component\\\\Messenger\\\\Envelope\\":2:{s:44:\\"\\0Symfony\\\\Component\\\\Messenger\\\\Envelope\\0stamps\\";a:0:{}s:45:\\"\\0Symfony\\\\Component\\\\Messenger\\\\Envelope\\0message\\";O:33:\\"Fusio\\\\Impl\\\\Messenger\\\\TriggerEvent\\":3:{s:43:\\"\\0Fusio\\\\Impl\\\\Messenger\\\\TriggerEvent\\0tenantId\\";N;s:44:\\"\\0Fusio\\\\Impl\\\\Messenger\\\\TriggerEvent\\0eventName\\";s:17:\\"fusio.user.create\\";s:42:\\"\\0Fusio\\\\Impl\\\\Messenger\\\\TriggerEvent\\0payload\\";O:26:\\"PSX\\\\CloudEvents\\\\CloudEvent\\":9:{s:39:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0specVersion\\";s:3:\\"1.0\\";s:32:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0type\\";s:29:\\"org.fusio-project.user.create\\";s:34:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0source\\";s:13:\\"/backend/user\\";s:30:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0id\\";[[ser_messageAppKey]]s:32:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0time\\";N;s:43:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0dataContentType\\";s:16:\\"application/json\\";s:32:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0data\\";O:30:\\"Fusio\\\\Model\\\\Backend\\\\UserCreate\\":12:{s:5:\\"\\0*\\0id\\";i:2;s:9:\\"\\0*\\0roleId\\";i:1;s:9:\\"\\0*\\0planId\\";N;s:9:\\"\\0*\\0status\\";i:1;s:7:\\"\\0*\\0name\\";[[ser_admin_username]]s:8:\\"\\0*\\0email\\";[[ser_admin_email]]s:9:\\"\\0*\\0points\\";N;s:9:\\"\\0*\\0scopes\\";N;s:7:\\"\\0*\\0apps\\";N;s:11:\\"\\0*\\0metadata\\";N;s:7:\\"\\0*\\0date\\";N;s:11:\\"\\0*\\0password\\";s:6:\\"******\\";}s:38:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0dataBase64\\";N;s:38:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0extensions\\";N;}}}', '[]', 'default', '[[regtime]]', '[[regtime]]', NULL),
(2, 'O:36:\\"Symfony\\\\Component\\\\Messenger\\\\Envelope\\":2:{s:44:\\"\\0Symfony\\\\Component\\\\Messenger\\\\Envelope\\0stamps\\";a:0:{}s:45:\\"\\0Symfony\\\\Component\\\\Messenger\\\\Envelope\\0message\\";O:33:\\"Fusio\\\\Impl\\\\Messenger\\\\TriggerEvent\\":3:{s:43:\\"\\0Fusio\\\\Impl\\\\Messenger\\\\TriggerEvent\\0tenantId\\";N;s:44:\\"\\0Fusio\\\\Impl\\\\Messenger\\\\TriggerEvent\\0eventName\\";s:16:\\"fusio.app.create\\";s:42:\\"\\0Fusio\\\\Impl\\\\Messenger\\\\TriggerEvent\\0payload\\";O:26:\\"PSX\\\\CloudEvents\\\\CloudEvent\\":9:{s:39:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0specVersion\\";s:3:\\"1.0\\";s:32:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0type\\";s:28:\\"org.fusio-project.app.create\\";s:34:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0source\\";s:12:\\"/backend/app\\";s:30:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0id\\";[[ser_messageAppKey1]]s:32:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0time\\";N;s:43:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0dataContentType\\";s:16:\\"application/json\\";s:32:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0data\\";O:29:\\"Fusio\\\\Model\\\\Backend\\\\AppCreate\\":12:{s:5:\\"\\0*\\0id\\";i:1;s:9:\\"\\0*\\0userId\\";i:1;s:9:\\"\\0*\\0status\\";i:1;s:7:\\"\\0*\\0name\\";s:5:\\"fusio\\";s:6:\\"\\0*\\0url\\";s:[[fusio_softurl_len]]:\\"[[softurl]]/public/apps/fusio\\";s:13:\\"\\0*\\0parameters\\";N;s:9:\\"\\0*\\0appKey\\";N;s:12:\\"\\0*\\0appSecret\\";N;s:11:\\"\\0*\\0metadata\\";N;s:7:\\"\\0*\\0date\\";N;s:9:\\"\\0*\\0scopes\\";a:3:{i:0;s:7:\\"backend\\";i:1;s:8:\\"consumer\\";i:2;s:13:\\"authorization\\";}s:9:\\"\\0*\\0tokens\\";N;}s:38:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0dataBase64\\";N;s:38:\\"\\0PSX\\\\CloudEvents\\\\CloudEvent\\0extensions\\";N;}}}', '[]', 'default', '[[regtime]]', '[[regtime]]', NULL);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `fusio_action`
--
ALTER TABLE `fusio_action`
  ADD CONSTRAINT `action_category_id` FOREIGN KEY (`category_id`) REFERENCES `fusio_category` (`id`);

--
-- Constraints for table `fusio_app`
--
ALTER TABLE `fusio_app`
  ADD CONSTRAINT `app_user_id` FOREIGN KEY (`user_id`) REFERENCES `fusio_user` (`id`);

--
-- Constraints for table `fusio_app_scope`
--
ALTER TABLE `fusio_app_scope`
  ADD CONSTRAINT `app_scope_app_id` FOREIGN KEY (`app_id`) REFERENCES `fusio_app` (`id`),
  ADD CONSTRAINT `app_scope_scope_id` FOREIGN KEY (`scope_id`) REFERENCES `fusio_scope` (`id`);

--
-- Constraints for table `fusio_cronjob`
--
ALTER TABLE `fusio_cronjob`
  ADD CONSTRAINT `cronjob_category_id` FOREIGN KEY (`category_id`) REFERENCES `fusio_category` (`id`);

--
-- Constraints for table `fusio_event`
--
ALTER TABLE `fusio_event`
  ADD CONSTRAINT `event_category_id` FOREIGN KEY (`category_id`) REFERENCES `fusio_category` (`id`);

--
-- Constraints for table `fusio_form`
--
ALTER TABLE `fusio_form`
  ADD CONSTRAINT `form_operation_id` FOREIGN KEY (`operation_id`) REFERENCES `fusio_operation` (`id`);

--
-- Constraints for table `fusio_identity_request`
--
ALTER TABLE `fusio_identity_request`
  ADD CONSTRAINT `identity_request_identity_id` FOREIGN KEY (`identity_id`) REFERENCES `fusio_identity` (`id`);

--
-- Constraints for table `fusio_operation`
--
ALTER TABLE `fusio_operation`
  ADD CONSTRAINT `operation_category_id` FOREIGN KEY (`category_id`) REFERENCES `fusio_category` (`id`);

--
-- Constraints for table `fusio_plan_scope`
--
ALTER TABLE `fusio_plan_scope`
  ADD CONSTRAINT `plan_scope_scope_id` FOREIGN KEY (`scope_id`) REFERENCES `fusio_scope` (`id`),
  ADD CONSTRAINT `plan_scope_user_id` FOREIGN KEY (`plan_id`) REFERENCES `fusio_plan` (`id`);

--
-- Constraints for table `fusio_rate_allocation`
--
ALTER TABLE `fusio_rate_allocation`
  ADD CONSTRAINT `rate_allocation_app_id` FOREIGN KEY (`app_id`) REFERENCES `fusio_app` (`id`),
  ADD CONSTRAINT `rate_allocation_operation_id` FOREIGN KEY (`operation_id`) REFERENCES `fusio_operation` (`id`),
  ADD CONSTRAINT `rate_allocation_rate_id` FOREIGN KEY (`rate_id`) REFERENCES `fusio_rate` (`id`);

--
-- Constraints for table `fusio_role`
--
ALTER TABLE `fusio_role`
  ADD CONSTRAINT `role_category_id` FOREIGN KEY (`category_id`) REFERENCES `fusio_category` (`id`);

--
-- Constraints for table `fusio_role_scope`
--
ALTER TABLE `fusio_role_scope`
  ADD CONSTRAINT `role_scope_role_id` FOREIGN KEY (`role_id`) REFERENCES `fusio_role` (`id`),
  ADD CONSTRAINT `role_scope_scope_id` FOREIGN KEY (`scope_id`) REFERENCES `fusio_scope` (`id`);

--
-- Constraints for table `fusio_schema`
--
ALTER TABLE `fusio_schema`
  ADD CONSTRAINT `schema_category_id` FOREIGN KEY (`category_id`) REFERENCES `fusio_category` (`id`);

--
-- Constraints for table `fusio_scope`
--
ALTER TABLE `fusio_scope`
  ADD CONSTRAINT `scope_category_id` FOREIGN KEY (`category_id`) REFERENCES `fusio_category` (`id`);

--
-- Constraints for table `fusio_scope_operation`
--
ALTER TABLE `fusio_scope_operation`
  ADD CONSTRAINT `scope_operation_operation_id` FOREIGN KEY (`operation_id`) REFERENCES `fusio_operation` (`id`),
  ADD CONSTRAINT `scope_operation_scope_id` FOREIGN KEY (`scope_id`) REFERENCES `fusio_scope` (`id`);

--
-- Constraints for table `fusio_test`
--
ALTER TABLE `fusio_test`
  ADD CONSTRAINT `test_category_id` FOREIGN KEY (`category_id`) REFERENCES `fusio_category` (`id`),
  ADD CONSTRAINT `test_operation_id` FOREIGN KEY (`operation_id`) REFERENCES `fusio_operation` (`id`);

--
-- Constraints for table `fusio_token`
--
ALTER TABLE `fusio_token`
  ADD CONSTRAINT `token_app_id` FOREIGN KEY (`app_id`) REFERENCES `fusio_app` (`id`),
  ADD CONSTRAINT `token_category_id` FOREIGN KEY (`category_id`) REFERENCES `fusio_category` (`id`),
  ADD CONSTRAINT `token_user_id` FOREIGN KEY (`user_id`) REFERENCES `fusio_user` (`id`);

--
-- Constraints for table `fusio_user`
--
ALTER TABLE `fusio_user`
  ADD CONSTRAINT `user_identity_id` FOREIGN KEY (`identity_id`) REFERENCES `fusio_identity` (`id`);

--
-- Constraints for table `fusio_user_grant`
--
ALTER TABLE `fusio_user_grant`
  ADD CONSTRAINT `user_grant_app_id` FOREIGN KEY (`app_id`) REFERENCES `fusio_app` (`id`),
  ADD CONSTRAINT `user_grant_user_id` FOREIGN KEY (`user_id`) REFERENCES `fusio_user` (`id`);

--
-- Constraints for table `fusio_user_scope`
--
ALTER TABLE `fusio_user_scope`
  ADD CONSTRAINT `user_scope_scope_id` FOREIGN KEY (`scope_id`) REFERENCES `fusio_scope` (`id`),
  ADD CONSTRAINT `user_scope_user_id` FOREIGN KEY (`user_id`) REFERENCES `fusio_user` (`id`);

--
-- Constraints for table `fusio_webhook`
--
ALTER TABLE `fusio_webhook`
  ADD CONSTRAINT `webhook_event_id` FOREIGN KEY (`event_id`) REFERENCES `fusio_event` (`id`),
  ADD CONSTRAINT `webhook_user_id` FOREIGN KEY (`user_id`) REFERENCES `fusio_user` (`id`);

--
-- Constraints for table `fusio_webhook_response`
--
ALTER TABLE `fusio_webhook_response`
  ADD CONSTRAINT `webhook_response_webhook_id` FOREIGN KEY (`webhook_id`) REFERENCES `fusio_webhook` (`id`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
