go.modules.business.automation.AutomationDialog = Ext.extend(go.form.Dialog, {
	stateId: 'automation-AutomationForm',
	title: t("Automation"),
	entityStore: "Automation",
	width: dp(800),
	height: dp(800),
	maximizable: true,
	collapsible: true,
	modal: false,
	showCustomfields: false,
	showLinks: false,

	initButtons :function() {
		go.modules.business.automation.AutomationDialog.superclass.initButtons.call(this);

		this.buttons.splice(0,0, {
			text: "Run now",
			scope: this,
			handler: function() {
				go.Jmap.request({
					method: "business/automation/Automation/run",
					params: {
						id: this.currentId
					}
				})
			}
		})
	},

	initComponent: function () {
		go.modules.business.automation.AutomationDialog.superclass.initComponent.call(this);

		this.formPanel.on("beforesetvalues", (form, v) => {
			this.filterFieldSet.setEntity(v.entity);

			this.filterFieldSet.show();
		})
	},

		initFormItems: function () {

			const options = [];
			go.Entities.getAll().forEach(function (m) {


				if(Object.keys(m.filters).filter(k => k != "text" && k != "subconditions").length)
					options.push([m.name, m.title]);
			});

			this.selectEntity = new go.form.SelectField({
				options: options,
				anchor: "100%",
				fieldLabel: t("Entity"),
				hiddenName: "entity",
				listeners: {
					select: function(combo, record, index) {
						this.filterFieldSet.setEntity(record.id);

						this.filterFieldSet.show();
					},
					scope: this
				}
			});

			this.selectEntity.store.sort('text');

			this.filterFieldSet = new go.filter.FieldSet({
				hidden: true
			});

			return [{
				xtype: "fieldset",
				defaults: {
					anchor: "100%"
				},
				items: [
					{
						xtype: "textfield",
						fieldLabel: t("Name"),
						name: "name"
					}
					,
					{
						name: "cron",
						value: "0 9 * * 1-5",
						xtype: "textfield",
						fieldLabel: t("CRON Expression"),
						hint: `<a target="_blank" href="https://en.wikipedia.org/wiki/Cron">https://en.wikipedia.org/wiki/Cron</a>`
					},

					new go.form.IntervalField({
						fieldLabel: t("Wait interval"),
						name: "waitInterval",
						hint: "Never run this action on an entity more than once within this period"
					}),


					this.selectEntity,
					this.filterFieldSet,

					this.action = new go.form.SelectField({
						xtype: 'selectfield',
						hiddenName: 'actionType',
						fieldLabel: t('Action'),
						options: [['email', 'Send e-mail']],
						value: 'email'
					})

				]
			},
				{
					anchor: "100%",
					hideLabel: true,
					xtype: "formcontainer",
					name: "action",
					items: [{
						xtype: "fieldset",
						defaults: {
							anchor: "100%"
						},
						items:[
							{
								xtype: "textfield",
								name: "recipient",
								fieldLabel: t("Recipient"),
								hint: "todo docs...",
								value: "{{entity.createdBy | Entity:UserDisplay | prop:email}}"
							},
							{
								xtype: "textfield",
								name: "bcc",
								fieldLabel: "BCC",
								value: ""
							},
							new GO.email.SelectAccount({
								hiddenName: "accountId"
							})
						]
					},

						{
							anchor: "100%",
							hideLabel: true,
							xtype: "formcontainer",
							name: "template",
							items: [new go.emailtemplate.TemplateFieldset({
								height: dp(800),
								title: t("Message"),
								anchor: "100%",
								noName: true
							})]
						}
					]
				}];
		},
		onLoad : function(entityValues) {
		this.supr().onLoad.call(this, entityValues);
	}
});
