Ext.define('go.modules.business.business.BusinessGrid',{
	extend: go.grid.GridPanel,

	autoExpandColumn: 'name',
	columns:[{
		header: t('ID'),
		width: dp(80),
		dataIndex: 'id',
		hidden:true,
		align: "right"
	},{
		header: t('Name'),
		dataIndex: 'name',
		id: 'name'
	}],

	initComponent: function() {
		const rights = go.User.capabilities['go:business:business'] || {};

		this.store = new go.data.Store({
			fields: ['name','id'],
			sort: [{property: "name"}],
			entityStore: "Business"
		});
		this.tbar = [{
			xtype: 'tbtitle',
			text: t("Businesses")
		},'->',{
			iconCls: "ic-add",
			handler: () =>  {
				const dlg = new go.modules.business.business.BusinessDialog();
				dlg.show();
			}
		}];
		this.listeners = {
			rowdblclick: function (grid, rowIndex, e) {
				const record = grid.getStore().getAt(rowIndex);
				this.edit(record.id)
			},
			scope:this
		};

		if (rights.mayManage) {
			Ext.apply(this, {
				viewConfig: {
					actionConfig: {
						scope: this,
						menu: this.initMoreMenu()
					}
				}
			});
		}
		this.callParent();
	},

	initMoreMenu : function() {
		this.moreMenu = new Ext.menu.Menu({
			items: [
				{
					itemId: "edit",
					iconCls: 'ic-edit',
					text: t("Edit"),
					handler: (item) => {
						const record = this.store.getAt(item.parentMenu.rowIndex);
						this.edit(record.id);
					},
				},{
					itemId:"delete",
					iconCls: 'ic-delete',
					text: t("Delete"),
					handler: (item) => {
						const record = this.store.getAt(item.parentMenu.rowIndex);

						this.getSelectionModel().selectRecords([record]);
						this.deleteSelected();
					},
				}
			]
		});
		return this.moreMenu;
	},
	edit : function(id) {
		const dlg = new go.modules.business.business.BusinessDialog();
		dlg.load(id).show();
	}
});