/* global go, Ext */

go.modules.business.catalog.CategoryTree = Ext.extend(Ext.tree.TreePanel, {
	
	rootVisible: false,
// autoHeight: true,


	findEntityNode: function (id) {
		var node = this.getRootNode(), found = false;

		node.findChildBy(function (node) {
			if (node.attributes.entity && node.attributes.entity.id === id) {
				found = node;
				return false;
			}
		});

		return found;
	},

	onChanges: function (entityStore, added, changed, destroyed) {

		//reload if added address book is not present in tree yet.
		added.forEach((id) => {
			if (!this.findEntityNode(id)) {
				this.getRootNode().reload();
				return;
			}
		});

		entityStore.get(changed).then((result) => {
			result.entities.forEach((entity) => {
				const nodeId = this.loader.entityStore.entity.name + "-" + entity.id,
					node = this.getNodeById(nodeId);

				if (node) {
					node.attributes.data = entity;

					if (entity.name) {
						node.setText(entity.name);
					}

					if (entity.groups) {
						delete node.attributes.children;
						node.reload();
					}
				}
			});

		});

		destroyed.forEach( (id) => {
			const node = this.getNodeById(this.loader.entityStore.entity.name + "-"  + id);
			if (node) {
				node.destroy();
			}
		});
	},
	
	initComponent: function () {


		this.loader = new go.tree.EntityLoader({
			entityStore: "CatalogCategory",
			secondaryTextTpl: '<button class="icon">more_vert</button>',
			getParams: function(node) {
				return {sort: [{property: "name", isAscending: true }], filter: {parentId: node.attributes.data ? node.attributes.data.id : null}};
			}
		});

		this.loader.entityStore.on("changes", this.onChanges, this);
		
		this.root = {
			nodeType: 'groupoffice',
			draggable: false,
			id: null,
			uiProvider: Ext.tree.RootTreeNodeUI // needed to make "rootVisible" work
		};

		this.selModel = new Ext.tree.MultiSelectionModel();

		go.modules.business.catalog.CategoryTree.superclass.initComponent.call(this);


		this.on("click", function (node, e) {

			if (e.target.tagName === "BUTTON") {

				if(!this.readOnly) {					
					this.showMoreMenu(node, e);					
				}
			}
		}, this);
	},

	
	showMoreMenu: function (node, e) {
		if (!this.moreMenu) {
			this.moreMenu = new Ext.menu.Menu({
				items: [
					{
						itemId: "add",
						iconCls: 'ic-add',
						text: t("Add"),
						handler: function () {

							node.expand();
							var dlg = new go.modules.business.catalog.CategoryDialog();
							dlg.setValues({parentId: this.moreMenu.data.id});
							dlg.show();
						},
						scope: this
					},

					{
						itemId: "edit",
						iconCls: 'ic-edit',
						text: t("Edit"),
						handler: function () {
							var dlg = new go.modules.business.catalog.CategoryDialog();
							dlg.load(this.moreMenu.data.id).show();
						},
						scope: this
					},

					"-",
					{
						itemId: "delete",
						iconCls: 'ic-delete',
						text: t("Delete"),
						handler:  function () {
							Ext.MessageBox.confirm(t("Confirm delete"), t("Are you sure you want to delete this item?"), async function (btn) {
								if (btn !== "yes") {
									return;
								}


								try {
									Ext.getBody().mask(t("Loading..."));
									await go.Db.store("CatalogCategory").set({destroy: [this.moreMenu.data.id]});
								} finally {
									Ext.getBody().unmask();
								}

							}, this);
						},
						scope: this
					},
					
					]
			});
		}
		this.moreMenu.data = node.attributes.data;
		// this.moreMenu.getComponent("edit").setDisabled(this.moreMenu.data.permissionLevel < go.permissionLevels.manage);
		// this.moreMenu.getComponent("delete").setDisabled(!go.Modules.get("community", 'CatalogCategory').userRights.mayChangeCatalogCategorys || this.moreMenu.data.permissionLevel  < go.permissionLevels.manage);
		this.moreMenu.showAt(e.getXY());
	}
});
