go.modules.business.contracts.ReportWindow = Ext.extend(go.Window, {

	title: t("Annual value"),
	layout: "fit",
	width: dp(1200),
	height: dp(600),
	// maximized: true,
	maximizable: true,
	initComponent: function() {
		this.items = [
			this.chart = new go.chart.LineChart({
				options: {
					responsive: true,
					plugins: {
						legend: {
							display: false
						}
					},
					maintainAspectRatio: false, // for height to work
					scales: {
						y: {
							beginAtZero: true
						}
					}
				}

			})
		];

		go.modules.business.contracts.ReportWindow.superclass.initComponent.call(this);
	},

	load: async function(bookId) {
		this.bookId = bookId;
		const book = await go.Db.store("ContractBook").single(bookId);

		this.setTitle(t("Annual value") + " - " + book.name);

		this.updateYearChart();
	},

	updateYearChart: function() {

		this.chartMaxYear = (new Date).getFullYear();
		this.chartMinYear = this.chartMaxYear - 10;
		this.chartSeries = [];

		this.totals = {};
		const promises = [];

		for(let i = this.chartMinYear; i <= this.chartMaxYear; i++) {
			promises.push(this.getYearTotals(i));
		}

		Promise.all(promises).then(() => {

			const data = Object.values(this.chartSeries);
			const labels = Object.keys(this.chartSeries);

			const index = data.findIndex((value) => {
				return value > 0;
			});

			if(index > -1) {
				data.splice(0, index);
				labels.splice(0, index);
			}

			this.chart.update([{data}], labels);
		});

	},

	getYearTotals : function(year) {
		return go.Jmap.request({
			method: "Contract/yearTotals",
			params: {
				bookId: this.bookId,
				date: year + "-12-31"
			}
		}).then((total) => {
			this.chartSeries[year] = total;

		});
	}

});
