-- Custom migration queries for statuses as we can't automatically determine them

-- select o.id,o.order_id,s.name,d.number,from_unixtime(min(sh.ctime)) as sentAt from bs_orders o
--     left join bs_order_status_history sh on (sh.order_id = o.id and notified = 1)
--     inner join bs_status_languages s on s.status_id = o.status_id
--     inner join business_finance_document d on o.order_id=d.number
-- group by o.id order by o.id desc;
--
select d.number, from_unixtime(sh.ctime), s.name from business_finance_document d
    inner join bs_orders o on o.order_id=d.number
    inner join bs_order_status_history sh on sh.order_id = o.id
    inner join bs_status_languages s on sh.status_id = s.status_id
where o.order_id='AG25-5143';



--    Fix acceptedAt
update business_finance_document d
    inner join bs_orders o on o.order_id=d.number
    inner join bs_order_status_history sh on sh.order_id = o.id
    inner join bs_status_languages s on sh.status_id = s.status_id and s.name = 'KV freigegeben'
    set d.acceptedAt = from_unixtime(sh.ctime);


--    Fix acceptedAt
update business_finance_document d
    inner join bs_orders o on o.order_id=d.number
    inner join bs_order_status_history sh on sh.order_id = o.id
    inner join bs_status_languages s on sh.status_id = s.status_id and s.name = 'KV abgerechnet'
    set d.acceptedAt = from_unixtime(sh.ctime) where d.acceptedAt is null;


--  Fix sentAt
update business_finance_document d
    inner join bs_orders o on o.order_id=d.number
    inner join bs_order_status_history sh on sh.order_id = o.id
    inner join bs_status_languages s on sh.status_id = s.status_id and s.name = 'KV offen'
    set d.sentAt = from_unixtime(sh.ctime);


-- Fix completedAt
update business_finance_document d
    inner join bs_orders o on o.order_id=d.number
    set d.completedAt = null;

update business_finance_document d
    inner join bs_orders o on o.order_id=d.number
    inner join bs_order_status_history sh on sh.order_id = o.id
    inner join bs_status_languages s on sh.status_id = s.status_id and (s.name = 'KV abgerechnet' OR s.name='Bezahlt')
    set d.statusId=null, d.completedAt = from_unixtime(sh.ctime);



update business_finance_document d
    inner join bs_orders o on o.order_id=d.number
    inner join bs_order_status_history sh on sh.order_id = o.id
    set statusId = null;

-- # Set custom status
update business_finance_document d
    inner join bs_orders o on o.order_id=d.number
    inner join bs_order_status_history sh on sh.order_id = o.id
    inner join bs_status_languages s on sh.status_id = s.status_id and s.name = 'KV PO vorhanden'
    set d.statusId = (select id from business_finance_status fs where fs.bookId=d.bookId and fs.name='PO ERHALTEN');


update business_finance_document d
    inner join bs_orders o on o.order_id=d.number
    inner join bs_order_status_history sh on sh.order_id = o.id
    inner join bs_status_languages s on sh.status_id = s.status_id and s.name = 'KV Auftrag nicht erteilt'
    set d.statusId = (select id from business_finance_status fs where fs.bookId=d.bookId and fs.name='KV NICHT ERTEILT');


update business_finance_document d
    inner join bs_orders o on o.order_id=d.number
    inner join bs_order_status_history sh on sh.order_id = o.id
    inner join bs_status_languages s on sh.status_id = s.status_id and s.name = 'Storniert'
    set d.statusId = (select id from business_finance_status fs where fs.bookId=d.bookId and fs.name='Storniert');



update business_finance_document d
    set completedAt = now()
        where `date` < '2024-01-01'
    and d.statusId = (select id from business_finance_status fs where fs.bookId=d.bookId and fs.name='PO ERHALTEN');
