/* global Ext, go, GO */

go.modules.business.finance.BusinessesFieldSet.DebtorProfileCombo = Ext.extend(go.form.ComboBox, {
	fieldLabel: t("Profile"),
	hiddenName: 'profileId',
	anchor: '100%',
	emptyText: t("Use default"),
	pageSize: 50,
	valueField: 'id',
	displayField: 'name',
	triggerAction: 'all',
	editable: true,
	selectOnFocus: true,
	forceSelection: true,
	store: {
		xtype: "gostore",
		fields: ['id', 'name'],
		entityStore: "DebtorProfile"
	},
	initComponent: function() {
		go.modules.business.finance.BusinessesFieldSet.DebtorProfileCombo.superclass.initComponent.call(this);

		if(this.businessId) {
			this.store.setFilter("business", {businessId: this.businessId})
		}
	}
});
