go.modules.business.finance.FinanceDocumentDetail = Ext.extend(go.detail.Panel, {
	entityStore: "FinanceDocument",
	stateId: 'no-FinanceDocument-detail',

	relations: ["book"],

	initComponent: function () {


		this.frontendConfig = go.modules.business.finance.ModuleConfig.frontendOptions;

		this.tbar = this.initToolbar();
		this.items = this.createItems();

		go.modules.business.finance.FinanceDocumentDetail.superclass.initComponent.call(this);

		this.addCustomFields();

		if (this.frontendConfig.showLinks) {
			this.addLinks();
		}
		if (this.frontendConfig.showComments) {
			this.addComments();
		}
		if (this.frontendConfig.showFileUploads) {
			this.addFiles();
		}
		if (this.frontendConfig.showModifyPanel) {
			this.add(new go.detail.CreateModifyPanel());
		}

		this.findBy((cmp) => {
			if(cmp instanceof go.modules.business.finance.FinanceDocumentGrid && cmp.type == "salesinvoice") {
				cmp.store.on("load", () => {
					this.findAmountInvoiced();
				}, this)
			}
		})

		this.initStatusMenu();
	},


	initStatusMenu : function() {

		this.statusMenu = new Ext.menu.Menu({

			listeners:{
				scope:this,
				itemclick : function(item, e ) {

					this.getEl().mask(t("Saving..."));

					go.Db.store("FinanceDocument").save({
						status: item.status
					}, this.data.id)
						.finally(() => {
							this.getEl().unmask();
						})
				}
			}
		});

	},

	findAmountInvoiced : function() {

		this.totalAmountInvoiced = 0;

		this.findBy((cmp) => {
			if(cmp instanceof go.modules.business.finance.FinanceDocumentGrid && cmp.type == "salesinvoice") {
				cmp.getStore().getRange().forEach(record => {
					this.totalAmountInvoiced  += record.data.totalPrice;
				});
			}
		})

		const
			total = this.data.totalPrice,
			percentage = (this.totalAmountInvoiced / this.data.totalPrice).toFixed(2),
			text = go.util.Format.valuta(this.totalAmountInvoiced) + " " + t("of") + " " + go.util.Format.valuta(total) + " (" + (percentage * 100) + "%)";

		this.invoicePanel.setVisible(percentage > 0);

		this.invoicePanel.setTitle(t("Invoiced") + " " + text);


		this.invoiceProgress.updateProgress(percentage, text);
	},


	createItems: function () {
		var me = this;
		var tplConfig = Ext.apply({
			currency: function () {
				return me.data.book.currency;
			},

			isA: function (type) {
				return me.data.book.type == type;
			},

			totalsColspan: function () {
				switch (me.data.book.type) {
					default:
						return 2;

					// case 'salesorder':
					// 	return 6;

					case 'purchaseorder':
						return 3;
				}
			}
		}, go.modules.business.finance.util);

		return [{
			title: t("FinanceDocument"),
			listeners : {
				afterrender: (item) => {
					item.getEl().on("click", (e) => {
						if(e.target.tagName != 'div' && !e.target.classList.contains("status")) {
							return;
						}


						this.statusMenu.showAt(e.xy);

					});
				}
			},
			onLoad: function (detailView) {

				var statusBadge = go.modules.business.finance.util.getStatusBadge(detailView.data, "right clickable", detailView.data.book);

				this.setTitle(go.modules.business.finance.util.humanType(detailView.data.book.type) + ": " + (detailView.data.number || "-") + statusBadge + "</div>");
			},
			tbar: {
				items:[
						this.sendButton = new Ext.Button({
							iconCls: "entity LinkedEmail bluegrey",
							text: "E-mail",
							hidden: !go.Modules.isAvailable("legacy", "email"),
							handler: function() {
								this.getEl().mask(t("Loading..."));

								const win = new GO.email.EmailComposer();
								win.closeAction = "close";
								win.createLinkButton.addLink("FinanceDocument", this.currentId);
								this.getEmailComposerConfig(true).then(config => {
									config.keepLinks = true;
									win.show(config);
								}).finally(() => {
									this.getEl().unmask();
								})
							},
							scope:this
						}),
					this.viewPdfItem = new Ext.Button({
						iconCls: 'ic-picture-as-pdf pink',
						text: "PDF",
						handler: function () {
							var url = go.Jmap.pageUrl('business/finance/doc/' + this.data.id + '/' + this.data.token);
							go.util.viewFile(url);
						},
						scope: this
					}),



						// this.convertToSalesOrder = new Ext.Button({
						// 	iconCls: 'ic-change-circle green',
						// 	text: t("Convert to sales order"),
						// 	handler: function () {
						// 		this.convertTo("salesorder");
						// 	},
						// 	scope: this
						// }),

						this.convertToSalesInvoice = new Ext.Button({
							iconCls: 'raised ic-change-circle blue',
							text: t("InvoiceVerb"),
							menu: [
								{
									text:  '10%',
									scope: this,
									handler: function () {
										this.invoicePercentage(10);
									}
								}, {
									text:  '20%',
									scope: this,
									handler: function () {
										this.invoicePercentage(20);
									}
								}, {
									text:  '30%',
									scope: this,
									handler: function () {
										this.invoicePercentage(30);
									}
								}, {
									text:  '40%',
									scope: this,
									handler: function () {
										this.invoicePercentage(40);
									}
								}, {
									text:  '50%',
									scope: this,
									handler: function () {
										this.invoicePercentage(50);
									}
								},
								"-",
								{
									text: t("Open amount"),
									scope: this,
									handler: function () {
										const percentage = 100 - (this.totalAmountInvoiced * 100 / this.data.totalPrice )
										this.invoicePercentage(percentage);
									}
								},
								{
									text: t("Copy order items"),
									scope: this,
									handler: function () {
										this.convertTo("salesinvoice");
									}
								}

							],

							scope: this
						}),

					this.createPurchaseOrders = new Ext.Button({
						iconCls: 'entity ic-add purple',
						text: t("Create purchase orders"),
						handler: async function () {

							const response = await go.Jmap.request({
								method: "FinanceDocument/createPurchaseOrders",
								params: {
									id: this.currentId
								}
							});

							this.reload();

						},
						scope: this
					}),


					// this.addPurchaseOrder = new Ext.Button({
					// 	iconCls: 'entity ic-add purple',
					// 	text: t("Add purchase order"),
					// 	handler: function () {
					// 		this.convertTo("purchaseorder");
					// 	},
					// 	scope: this
					// }),



					this.addPurchaseInvoice = new Ext.Button({
						iconCls: 'entity ic-add yellow',
						text: t("Add purchase invoice"),
						handler: function () {
							this.convertTo("purchaseinvoice");
						},
						scope: this
					}),




					this.emailTplButton = new Ext.Button(
						{
							text: t("E-mail template"),
							iconCls: 'entity LinkedEmail bluegrey',
							scope: this,
							hidden: !go.Modules.isAvailable("legacy", "email"),
							handler: function () {

								const store = new go.data.Store({
									fields: ['id', 'name'],
									entityStore: "EmailTemplate",
									sortInfo: {
										field: "name"
									},
									filters: {
										module: {
											module: {name: "finance", "package":"business"},
											key: "fb-xtr-" + this.data.book.id}
									}
								});

								const win = new go.Window({
									width: dp(400),
									height: dp(400),
									modal: true,
									layout: "fit",
									title: t("Select template"),
									items: [{
										xtype: "navmenu",
										store: store,
										listeners: {
											scope: this,
											click: async function(dv, index, node, e ) {

												const rec = store.getAt(index);
												win.close();

												this.getEl().mask(t("Loading..."));

												const comp = new GO.email.EmailComposer();
												comp.closeAction = "close";
												comp.createLinkButton.addLink("FinanceDocument", this.currentId);
												this.getEmailComposerConfig(true,rec.id).then(config => {
													config.keepLinks = true;
													comp.show(config);
												}).finally(() => {
													this.getEl().unmask();
												})

											}
										}
									}]
								});

								store.load();

								win.show();
							}
						}
					),


					this.docTplButton = new Ext.Button(
						{
							text: t("Document template"),
							// cls: "x-menu-no-icons",
							iconCls: 'ic-picture-as-pdf pink',
							scope: this,
							handler: function () {

								const store = new go.data.Store({
									fields: ['id', 'name'],
									entityStore: "PdfTemplate",
									sortInfo: {
										field: "name"
									},
									filters: {
										module: {
											module: {name: "finance", "package":"business"},
											key: "fb-xtr-" + this.data.book.id
										}
									}
								});

								const win = new go.Window({
									width: dp(400),
									height: dp(400),
									modal: true,
									layout: "fit",
									title: t("Select template"),
									items: [{
										xtype: "navmenu",
										store: store,
										listeners: {
											scope: this,
											click: async function(dv, index, node, e ) {

												const rec = store.getAt(index);

												this.getEl().mask(t("Saving..."));
												const result = await go.Jmap.request({
													method: 'FinanceDocument/savePdf',
													params: {id: this.data.id, templateId: rec.id}
												});
												GO.files.openFile({id: result.id});
												this.getEl().unmask();
												win.close();
											}
										}
									}]
								});

								store.load();

								win.show();
							}
						}
					),

					this.acceptButton = new Ext.Button({
						iconCls: 'ic-check success',
						text: t("Accept"),
						handler: async function() {
							this.getEl().mask(t("Saving..."));
							await go.Db.store("FinanceDocument").save({
								status: "accepted"
							}, this.currentId);
							this.getEl().unmask();
						},
						scope: this
					}),


					this.cancelButton = new Ext.Button({
						iconCls: 'ic-cancel danger',
						text: t("Reject"),
						handler: async function() {
							this.getEl().mask(t("Saving..."));
							await go.Db.store("FinanceDocument").save({
								status: "cancelled"
							}, this.currentId);
							this.getEl().unmask();
						},
						scope: this
					}),

					]

				},

			tpl: new Ext.XTemplate(
				'<div class="icons">' +
				'<p class="s4">' +
				'<i class="icon label">schedule</i>' +
				'<span>{[go.util.Format.date(values.date)]}</span>	' +
				'<label>{[t("Date")]}</label>' +
				'</p>' +

				'<tpl if="reference">' +
				'<p class="s4">' +
				'<i class="icon label">star</i>' +
				'<span>{reference}</span>	' +
				'<label>{[t("Reference")]}</label>' +
				'</p>' +
				'</tpl>' +


				'<div class="x-clear"></div>' +
				'<a class="s4" href="#contact/{customerId}">' +
				'<i class="icon label">business</i>' +
				'<span>{customer}</span>	' +
				'<label>{[t("Customer", "addressbook", "community")]}</label>' +
				'</a>' +
				'<tpl if="contactId">' +
				'<a class="s4" href="#contact/{contactId}">' +
				'<i class="icon label">person</i>' +
				'<span>{contact}</span>	' +
				'<label>{[t("Contact", "addressbook", "community")]}</label>' +
				'</a>' +
				'</tpl>' +

				'</div>',
				tplConfig
			)
		},

			{
				collapsible: true,
				stateId: 'finance-detail-frontpage',
				title: t("Greeting"),
				tpl: '<div class="pad go-html-formatted">{greeting:raw}</div>',
				onLoad: function (detailView) {
					this.setVisible(!go.util.empty(detailView.data.greeting));
				}
			},

			{
				collapsible: true,
				stateId: 'finance-detail-items',
				title: t("Items"),
				tpl: new Ext.XTemplate(
					'<div class="pad">' +
					'<table class="display-panel">' +
					'<tr class="line">' +
					'<th>{[t("Quantity")]}</th>' +

					// '<tpl if="this.isA(\'salesorder\')">' +
					// '<th>{[t("Ordered")]}</th>' +
					// '<th>{[t("Received")]}</th>' +
					// '<th>{[t("Invoiced")]}</th>' +
					// '</tpl>' +

					'<tpl if="this.isA(\'purchaseorder\')">' +
					'<th>{[t("Invoiced")]}</th>' +
					'</tpl>' +

					'<th>{[t("Description")]}</th>' +
					// '<th class="right">{[t("VAT rate")]}</th>' +
					'<th class="right">{[t("Unit cost")]}</th>' +
					'<th class="right">{[t("Price")]}</th>' +
					'</tr>' +
					'<tpl for="itemGroups">' +
						'<tpl if="title">' +
						'<tr><td colspan="99"><h4>{title}</h4></td></tr>' +
						'</tpl>' +
						'<tpl for="items">' +

							'<tpl if="description != \'__PAGEBREAK__\'">' +
								'<tr  class="{[xindex != xcount ? "line" : ""]}">' +
								'<td>{[go.util.Format.number(values.quantity,2)]}</td>' +

								'<tpl if="this.isA(\'purchaseorder\')">' +
								'<td>{[go.util.Format.number(values.invoicedQuantity,2)]}</td>' +
								'</tpl>' +

								'<td>{[Ext.util.Format.nl2br(Ext.util.Format.htmlEncode(values.description))]}</td>' +
								'<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(values.unitCost * values.quantity,go.Modules.get("business", "finance").settings.decimals)]}</td>' +
								'<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(values.unitPrice * values.quantity, go.Modules.get("business", "finance").settings.decimals)]}</td>' +

								'</tr>' +
								'</tpl>' +
							'</tpl>' +

						'<tpl if="parent.itemGroups.length &gt; 1">' +
								'<tr>'+
								'<td colspan="{[this.totalsColspan()]}"></td>' +
								'<td colspan="2" class="bold-line"></td>' +
								'</tr>'+
								'<tr>' +
								'<td colspan="{[this.totalsColspan()]}" class="right">' + t("Total") + ':</td>' +
								'<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(values.subtotalCost,go.Modules.get("business", "finance").settings.decimals)]}</td>' +
								'<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(values.subtotalPrice,go.Modules.get("business", "finance").settings.decimals)]}</></td>' +

								'</tr>' +

								'<tpl if="values.subtotalCost">' +
									'<tr>' +
									'<td colspan="{[this.totalsColspan()]}" class="right">' + t("Margin") + ':</td>' +
									'<td class="right">{[go.util.Format.number(values.subtotalPrice / values.subtotalCost * 100 - 100,0) + "%"]}</td>'+
									'<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(values.subtotalPrice - values.subtotalCost,go.Modules.get("business", "finance").settings.decimals)]}</td>' +
									'</tr>' +

								'</tpl>' +
							'</tpl>' +
					'</tpl>' +

						'<tpl if="itemGroups.length &gt; 1">' +
							'<tr><td colspan="99"><h4>' + t('Totals') + '</h4></td></tr>' +
						'</tpl>' +

					'<tr>'+
					'<td colspan="{[this.totalsColspan()]}"></td>' +
					'<td colspan="2" class="bold-line"></td>' +
					'</tr>'+
							'<tr>' +
							'<td colspan="{[this.totalsColspan()]}" class="right">' + t("Sub total") + ':</td>' +
							'<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(values.subtotalCost,go.Modules.get("business", "finance").settings.decimals)]}</td>' +
							'<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(values.subtotalPrice,go.Modules.get("business", "finance").settings.decimals)]}</td>' +
							'</tr>' +

							'<tpl if="values.subtotalCost">' +
									'<tr>' +
									'<td colspan="{[this.totalsColspan()]}" class="right">' + t("Margin") + ':</td>' +
									'<td class="right">{[go.util.Format.number(values.subtotalPrice / values.subtotalCost * 100 - 100, 0)]}%</td>'+
									'<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(values.subtotalPrice - values.subtotalCost,go.Modules.get("business", "finance").settings.decimals)]}</td>' +
									'</tr>' +

									'<tr><td>&nbsp;</td></tr>'+
							'</tpl>' +
					'</table>' +
					'</div>',
					tplConfig)
			},


			{
				collapsible: true,
				stateId: 'finance-detail-vat',
				title: t("VAT Totals"),
				tpl: new Ext.XTemplate(
					'<div class="pad">' +
					'<table class="display-panel">' +

					'<tpl if="values.vatReverseCharge">' +
					'<tr>' +
					'<td colspan="{[this.totalsColspan()]}" class="right">' + t("VAT Reverse charge") + '  (0%):</td>' +
					'<td></td>'+
					// '<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(0,go.Modules.get("business", "finance").settings.decimals)]}</td>' +
					'<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(0,go.Modules.get("business", "finance").settings.decimals)]}</td>' +
					'</tr>' +
					'</tpl>'+

					'<tpl if="!values.vatReverseCharge">' +



					'<tpl for="values.vatTotals">' +
					'<tr>' +
					'<td colspan="{[this.totalsColspan()]}" class="right">' + t("VAT") + ' {rate}%:</td>' +
					// '<td class="right {[(xindex == xcount) ? "bold-line" : ""]}">{[this.currency()]}&nbsp;{[go.util.Format.number(values.subTotal, 2)]}</td>' +
					'<td class="right {[(xindex == xcount) ? "bold-line" : ""]}">{[this.currency()]}&nbsp;{[go.util.Format.number(values.price, 2)]}</td>' +

					'</tr>' +
					'</tpl>' +


					'</tpl>' +

					'<tpl if="values.vatTotals.length">' +
					'<tr>' +
					'<td colspan="{[this.totalsColspan()]}" class="right">' + t("Total") + ':</td>' +
					// '<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(values.totalCost,go.Modules.get("business", "finance").settings.decimals)]}</td>' +
					'<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(values.totalPrice,go.Modules.get("business", "finance").settings.decimals)]}</td>' +
					'</tr>' +
					'</tpl>' +

					'</tpl>' +

					'</table>' +
					'</div>',

					tplConfig
				)
			},


			{
				collapsible: true,
				stateId: 'finance-detail-categories',
				title: t("Categories"),
				onLoad: function(pnl) {
					this.setVisible(pnl.data.categoryTotals.length > 1);
				},
				tpl: new Ext.XTemplate(
					'<div class="pad">' +
					'<table class="display-panel">' +

					'<tr>' +
					'<th>{[t("Category")]}</th>' +
					'<th class="right">{[t("Costs")]}</th>' +
					'<th class="right">{[t("Price")]}</th>' +
					'<th class="right">{[t("Margin")]} {[this.currency()]}</th>' +
					'<th class="right">%</th>' +
					'</tr>'+

					'<tpl for="values.categoryTotals">' +
					'<tr>' +
					'<td>{category}</td>' +
					'<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(values.cost, 2)]}</td>' +
					'<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(values.price, 2)]}</td>' +
					'<td class="right">{[this.currency()]}&nbsp;{[go.util.Format.number(values.price - values.cost, 2)]}</td>' +
					'<td class="right">{[values.cost ? go.util.Format.number(values.price / values.cost * 100 - 100, 0)+"%" : "-"]}</td>' +

					'</tr>' +
					'</tpl>' +

					'</table>' +
					'</div>',

					tplConfig
				)
			},

			{
				collapsible: true,
				stateId: 'finance-detail-so-items',
				title: t("Purchased items"),
				_tpl: new Ext.XTemplate(
					'<div class="pad">' +
					'<table class="display-panel">' +
					'<tr class="line">' +
					'<th>{[t("Quantity")]}</th>' +

					'<th>{[t("Ordered")]}</th>' +
					'<th>{[t("Received")]}</th>' +
					// '<th>{[t("Invoiced")]}</th>' +


					'<th>{[t("Description")]}</th>' +
					'<tpl for=".">' +

						'<tpl if="title">' +
						'<tr><td colspan="99"><h4>{title}</h4></td></tr>' +
						'</tpl>' +

						'<tpl for="items">' +
							'<tr class="line">' +
							'<td>{[go.util.Format.number(values.quantity, 2)]}</td>' +

							'<td class="{[values.isPurchase && values.orderedQuantity != values.quantity ? "warning" : ""]}">{[values.isPurchase ? go.util.Format.number(values.orderedQuantity, 2) : \'-\']}</td>' +
							'<td class="{[values.isPurchase && values.receivedQuantity != values.quantity ? "warning" : ""]}">{[values.isPurchase ? go.util.Format.number(values.receivedQuantity, 2) : \'-\']}</td>' +
							// '<td class="{[values.isPurchase && values.invoicedQuantity != values.quantity ? "warning" : ""]}">{[values.isPurchase ? go.util.Format.number(values.invoicedQuantity,go.Modules.get("business", "finance").settings.decimals) : \'-\']}</td>' +


							'<td>{description}</td>' +

							'</tr>' +
						'</tpl>' +

					'</tpl>' +

					'</table>' +
					'</div>',
					tplConfig),
					onLoad: function (detailView) {
						// only show if sales order and only show items that are purchased at a supplier.
						let itemGroups = detailView.getPurchaseItems();
						if(itemGroups.length) {
							this._tpl.overwrite(this.body, itemGroups);
							this.show();
						} else {
							this.hide();
						}
					}
			},

			{
				collapsible: true,
				stateId: 'finance-detail-frontpage',
				title: t("Closing"),
				tpl: '<div class="pad go-html-formatted">{closing:raw}</div>',
				onLoad: function (detailView) {
					this.setVisible(!go.util.empty(detailView.data.closing));
				}
			},

			this.invoicePanel = new Ext.Panel({
				hidden: true,
				hideMode: "offsets",
				title: t("Invoiced"),
				bodyCssClass: "pad",
				items: [
					this.invoiceProgress = new Ext.ProgressBar()
				]

			}),

			new go.modules.business.finance.FinanceDocumentDetailPayments(),
		];
	},

	getPurchaseItems : function(orderableOnly = false) {
		// only show if sales order and only show items that are purchased at a supplier.
		let show = (this.data.book.type == "salesorder" || this.data.book.type == "quote") && this.data.acceptedAt != null;
		if(!show) {
			return [];
		}

		let itemGroups = go.util.clone(this.data.itemGroups);

		itemGroups = itemGroups.filter((ig) => {
			ig.items = ig.items.filter(i => {
				return orderableOnly ? i.isPurchase && i.orderedQuantity == 0 : i.isPurchase;
			})

			return ig.items.length > 0;
		});

		console.warn(orderableOnly, itemGroups.length, itemGroups);
		return itemGroups;
	},


	onLoad: async function () {
		this.getTopToolbar().getComponent("edit").setDisabled(this.data.permissionLevel < go.permissionLevels.write);
		this.deleteItem.setDisabled(this.data.permissionLevel < go.permissionLevels.writeAndDelete);

		this.sendButton.setVisible(go.Modules.isAvailable("legacy", "email") && (!(this.data.book.type == 'salesorder' || this.data.book.type == 'quote') || this.data.acceptedAt == null));
		// this.viewPdfItem.setVisible(!(this.data.book.type == 'salesorder' || this.data.book.type == 'quote') || this.data.acceptedAt == null);

		this.acceptButton.setVisible((this.data.book.type == 'salesorder' || this.data.book.type == 'quote') && this.data.acceptedAt == null && this.data.sentAt != null);
		this.convertToSalesInvoice.setVisible((this.data.book.type == 'salesorder' || this.data.book.type == 'quote')  && this.data.acceptedAt != null);

		this.createPurchaseOrders.setVisible(this.getPurchaseItems(true).length);
		this.addPurchaseInvoice.setVisible(this.data.book.type == 'purchaseorder');

		this.creditNote.setVisible(this.data.book.type == 'salesinvoice' && this.data.subtotalPrice > 0);

		this.cancelButton.setVisible((this.data.book.type == "quote" || this.data.book.type == "salesorder") && this.data.sentAt != null && this.data.cancelled == false);
		this.cancelButton.setText(this.data.book.type == "quote" && this.data.acceptedAt == null ? t("Reject") : t("Cancel"));

		this.docTplButton.setVisible(false);
		this.emailTplButton.setVisible(false);

		if(
			((this.data.book.type == 'salesorder' || this.data.book.type == 'quote') && this.data.acceptedAt != null) ||
			(!(this.data.book.type == 'salesorder' || this.data.book.type == 'quote') && this.data.number != null)
		) {
			go.Db.store("PdfTemplate").query({
				filter: {
					module: {name: "finance", "package":"business"},
					key: "fb-xtr-" + this.data.book.id
				},
				limit: 1
			}).then((result) => {
				if(result.ids.length){
					this.docTplButton.setVisible(true);
				}
			})

			if(go.Modules.isAvailable("legacy", "email")) {
				go.Db.store("EmailTemplate").query({
					filter: {
						module: {name: "finance", "package": "business"},
						key: "fb-xtr-" + this.data.book.id

					},
					limit: 1
				}).then((result) => {
					if (result.ids.length) {
						this.emailTplButton.setVisible(true);
					}
				})
			}
		}


		this.loadStatusMenu();

		this.data ['categoryTotals'] = await this.calculateCategoryTotals();


		go.modules.business.finance.FinanceDocumentDetail.superclass.onLoad.call(this);
	},


	calculateCategoryTotals : async function() {

		const totals = {

		};

		const data = this.data;

		const business = await go.Db.store("Business").single(data.book.businessId);

		const catMap = {"__uncategorized__": t("Uncategorized")};
		business.categories.forEach(cat => {
			catMap[cat.id] = cat.name;
		});

		data.itemGroups.forEach((g) => {
			g.items.forEach(i => {
				const k = i.categoryId ?? "__uncategorized__";
				if(!totals[k]) {
					totals[k]={cost: 0, price: 0, category: catMap[k]};
				}
				totals[k].cost += i.unitCost * i.quantity;
				totals[k].price += i.unitPrice * i.quantity;
			})
		})
		
		return Object.values(totals);

	},

	loadStatusMenu : function() {

		if(this.loadedBookId != this.data.book.id) {

			this.statusMenu.removeAll();

			const store = new go.modules.business.finance.StatusStore()
			store.loadStatuses(this.data.book, true);

			store.getRange().forEach((r) => {
				this.statusMenu.add({
					status: r.id,
					text: `<div class="status business-finance-document-status-${r.id}"
												 style="background-color: #${r.data.color}">${r.data.name}</div>`
				})
			});

			this.loadedBookId = this.data.book.id;
		}
	},

	invoicePercentage: async function(percentage) {
		const dlg = await this.convertTo("salesinvoice", false, {itemGroups:[]});

		const items = [], ref = percentage.toFixed(0) + "% "+ t("of") + " " + go.modules.business.finance.util.humanType(this.data.book.type).toLowerCase() + " " +this.data.number + (this.data.reference ? " ("+this.data.reference+")" : "");

		this.data.vatTotals.forEach(vatTotal => {
			items.push({
				quantity: 1,
				description: ref,
				unitPrice: vatTotal.subTotal * (percentage / 100),
				vatRateId: vatTotal.vatRateId
			});
		});


		dlg.setValues({
			reference: this.data.number,
			itemGroups: [{items: items}]
		});

		return dlg;
	},

	convertTo: function (type, invert, override) {

		var dlg = new go.modules.business.finance.FinanceDocumentDialog({
			type: type
		});

		const data = go.util.clone(this.data);

		if(type) {
			delete data.bookId;
		}

		if(override) {
			Object.assign(data, override);
		}

		// this will preload form with the values from the source document
		dlg.setLinkEntity({
			entity: "FinanceDocument",
			data: data,
			entityId: this.data.id,
			invert: invert, //for credit note,
			convertToPurchase: type == "purchaseorder"
		});

		// pass quote number as reference
		if(this.data.book.type == "quote") {
			let ref = t("Quote") + " " + this.data.number;

			if(this.data.reference) {
				ref += " " + this.data.reference;
			}

			dlg.setValues({
				reference: ref
			});
		}

		dlg.on("show", () => {
			dlg.createLinkButton.addLink("FinanceDocument", this.data.id);
		}, this, {single: true})
		dlg.show();

		if(invert) {
			this.addCreditNotePayment(dlg);
		}

		return new Promise((resolve)  => {
			dlg.on("ready", () => {
				resolve(dlg);
			})
		})

	},

	addCreditNotePayment : function(dlg) {
		dlg.on("submit", async (dlg, success, serverId) => {
			const doc = await go.Db.store("FinanceDocument").single(serverId);

			const invoiceId = this.data.id,
				invoiceOrgId = this.data.customerId,
				businessId = this.data.book.businessId;

			Ext.MessageBox.confirm(t("Add payment"), t("Do you want to add {{price}} as payment to invoice {{invoice}}?").replace("{{price}}", go.util.Format.valuta(doc.totalPrice * -1)).replace("{{invoice}}", this.data.number), (btn) => {
				if(btn == "yes") {

					this.getEl().mask(t("Saving..."));
					go.Db.store("Payment").save(
					{
						date: new Date(),
						amount: doc.totalPrice * -1,
						customerId: invoiceOrgId,
						documentId: invoiceId,
						businessId: businessId
					}).finally(() => {
						this.getEl().unmask();
					})
				}
			}, this)
		})
	},

	initToolbar: function () {
		var items = this.tbar || [];
		items = items.concat([


			'->',
			{
				itemId: "edit",
				iconCls: 'ic-edit',
				tooltip: t("Edit"),
				handler: function (btn, e) {
					var editDlg = new go.modules.business.finance.FinanceDocumentDialog();
					editDlg.load(this.data.id).show();
				},
				scope: this
			},

			this.addButton = new go.detail.addButton({
				detailView: this,
				documentTemplates: true
			}),

			{xtype: "linkbrowserbutton"},

			this.moreMenu = {
				iconCls: 'ic-more-vert',
				menu: [ this.savePdfItem = new Ext.menu.Item({
					iconCls: 'filetype filetype-pdf',
					text: t("Save PDF"),
					handler: function () {

						this.getEl().mask(t("Saving..."));
						go.Jmap.request({
							method: 'FinanceDocument/savePdf',
							params: {id: this.data.id}
						}).then( () => {
							this.reload();
						}).finally(() => {
							this.getEl().unmask();
						});
					},
					scope: this
				}), {
					iconCls: "btn-print",
					text: t("Print"),
					handler: function () {
						this.body.print({title: this.data.name});
					},
					scope: this
				},

					"-",

					this.duplicate = new Ext.menu.Item({
						iconCls: 'entity ic-content-copy',
						text: t("Duplicate"),
						handler: function () {
							this.convertTo();
						},
						scope: this
					}),


					this.creditNote = new Ext.menu.Item({
						iconCls: 'entity ic-money-off',
						text: t("Credit note"),
						handler: function () {
							this.convertTo("salesinvoice", true);
						},
						scope: this
					}),

					"-",
					this.deleteItem = new Ext.menu.Item({
						itemId: "delete",
						iconCls: 'ic-delete',
						text: t("Delete"),
						handler: function () {
							Ext.MessageBox.confirm(t("Confirm delete"), t("Are you sure you want to delete this item?"), function (btn) {
								if (btn !== "yes") {
									return;
								}
								this.entityStore.set({destroy: [this.currentId]});
							}, this);
						},
						scope: this
					})
				]
			}]);


		var tbarCfg = {
			disabled: true,
			items: items
		};

		// this.addTemplates();
		// this.addEmailTemplates();

		return new Ext.Toolbar(tbarCfg);
	},

	// addTemplates: function() {
	// 	const tplItem = {
	// 		text: t("Document from template"),
	// 		cls: "x-menu-no-icons",
	// 		iconCls: 'ic-picture-as-pdf',
	// 		scope: this,
	// 		handler: function () {
	//
	// 			const store = new go.data.Store({
	// 				fields: ['id', 'name'],
	// 				entityStore: "PdfTemplate",
	// 				sortInfo: {
	// 					field: "name"
	// 				},
	// 				filters: {
	// 					module: {
	// 						module: {name: "finance", "package":"business"},
	// 						key: "fb-xtr-" + this.data.book.id}
	// 				}
	// 			});
	//
	// 			const win = new go.Window({
	// 				width: dp(400),
	// 				height: dp(400),
	// 				modal: true,
	// 				layout: "fit",
	// 				title: t("Select template"),
	// 				items: [{
	// 					xtype: "navmenu",
	// 					store: store,
	// 					listeners: {
	// 						scope: this,
	// 						click: async function(dv, index, node, e ) {
	//
	// 							const rec = store.getAt(index);
	//
	// 							this.getEl().mask(t("Saving..."));
	// 							const result = await go.Jmap.request({
	// 								method: 'FinanceDocument/savePdf',
	// 								params: {id: this.data.id, templateId: rec.id}
	// 							});
	// 							GO.files.openFile({id: result.id});
	// 							this.getEl().unmask();
	// 							win.close();
	// 						}
	// 					}
	// 				}]
	// 			});
	//
	// 			store.load();
	//
	// 			win.show();
	// 		}
	// 	};
	//
	// 	const index = this.addButton.menu.items.findIndexBy(function (i, k) {
	//
	// 		if( !i.text || i.text == t("Existing item")) {
	// 			return false;
	// 		}
	// 		// console.warn(tplItem.text.localeCompare(i.text + ""));
	// 		return tplItem.text.localeCompare(i.text + "") < 0;
	// 	});
	//
	// 	this.addButton.menu.insert(index, tplItem);
	//
	// },


	// addEmailTemplates: function() {
	// 	const tplItem = {
	// 		text: t("E-mail from template"),
	// 		cls: "x-menu-no-icons",
	// 		iconCls: 'ic-email',
	// 		scope: this,
	// 		handler: function () {
	//
	// 			const store = new go.data.Store({
	// 				fields: ['id', 'name'],
	// 				entityStore: "EmailTemplate",
	// 				sortInfo: {
	// 					field: "name"
	// 				},
	// 				filters: {
	// 					module: {
	// 						module: {name: "finance", "package":"business"},
	// 						key: "fb-xtr-" + this.data.book.id}
	// 				}
	// 			});
	//
	// 			const win = new go.Window({
	// 				width: dp(400),
	// 				height: dp(400),
	// 				modal: true,
	// 				layout: "fit",
	// 				title: t("Select template"),
	// 				items: [{
	// 					xtype: "navmenu",
	// 					store: store,
	// 					listeners: {
	// 						scope: this,
	// 						click: async function(dv, index, node, e ) {
	//
	// 							const rec = store.getAt(index);
	// 							win.close();
	//
	// 							this.getEl().mask(t("Loading..."));
	//
	// 							const comp = new GO.email.EmailComposer();
	// 							comp.closeAction = "close";
	// 							comp.createLinkButton.addLink("FinanceDocument", this.currentId);
	// 							this.getEmailComposerConfig(true,rec.id).then(config => {
	// 								config.keepLinks = true;
	// 								comp.show(config);
	// 							}).finally(() => {
	// 								this.getEl().unmask();
	// 							})
	//
	// 						}
	// 					}
	// 				}]
	// 			});
	//
	// 			store.load();
	//
	// 			win.show();
	// 		}
	// 	};
	//
	// 	const index = this.addButton.menu.items.findIndexBy(function (i, k) {
	//
	// 		if( !i.text || i.text == t("Existing item")) {
	// 			return false;
	// 		}
	// 		// console.warn(tplItem.text.localeCompare(i.text + ""));
	// 		return tplItem.text.localeCompare(i.text + "") < 0;
	// 	});
	//
	// 	this.addButton.menu.insert(index, tplItem);
	//
	// },

	getEmailAddress: function(contact, org) {
		if(this.data.book.type == "quote" && contact && contact.emailAddresses[0]) {
			// prefer contact email for quotes
			return contact.emailAddresses[0].email;
		}

		let emailAddresses = [];

		if (contact) {
			emailAddresses = emailAddresses.concat(contact.emailAddresses);
		} else
		{
			contact = org;
		}

		if (org) {
			emailAddresses = emailAddresses.concat(org.emailAddresses);
		}

		let email = emailAddresses.length ? emailAddresses[0].email : false;

		emailAddresses.forEach(e => {
			if (e.type == 'billing') {
				email = e.email;
			}
		});

		return email;


	},

	getEmailComposerConfig: function (loadDefaults = false, templateId) {

		return Promise.all([
			this.data.contactId ? go.Db.store('Contact').single(this.data.contactId) : Promise.resolve(null),
			this.data.customerId ? go.Db.store('Contact').single(this.data.customerId) : Promise.resolve(null)
		]).then(values => {
			let contact = values[0], org = values[1];

			const email = this.getEmailAddress(contact, org);

			if(!contact) {
				contact = org;
			}

			const to = email ? '"' + contact.name.replace('/"/g', '\\"') + '" <' + email + ">" : "";

			if (!this.data.number) {
				return go.Db.store("FinanceDocument").save({createNumber: true}, this.data.id).then((entity) => {
					this.data.number = entity.number;

					return this.buildEmailComposerConfig(contact, to, loadDefaults, templateId);
				});
			} else {
				return Promise.resolve(this.buildEmailComposerConfig(contact, to, loadDefaults, templateId));
			}
		}).catch(e => {
			GO.errorDialog.show(e);
		});

	},

	buildEmailComposerConfig: async function(contact, to, loadDefaults, templateId) {

		if(!loadDefaults) {
			return {
				entity: "Contact",
				entityId: contact.id,
				values: {to: to}
			}
		}
		const response = await go.Jmap.request({
			method: "FinanceDocument/email",
			params: {
				id: this.data.id,
				templateId: templateId
			}
		});

		response.to = to;

		return {
			entity: "Contact",
			entityId: contact.id,
			template_id: 0,
			values: response,
				// subject: go.modules.business.finance.util.humanType(this.data.book.type) + ' ' + this.data.number,
				// to: to,
				// body: '<div>' + t("You can view your invoice by clicking the button below.") +
				// 	'</div><div><br /></div><div><a style="text-decoration: none; user-select none; -webkit-user-select: none; cursor: pointer; color: white; border-radius: 4px;display:inline-block; padding: 8px; background-color: #009bc9;" href="' + this.data.customerUrl + '">'+
				// 	this.data.number + '</a></div><div><br /></div><div>'+ t("If you have any questions regarding this invoice, don't hesitate to contact us!") +'</div>'
			// },
			blobs: response.blobs
		}
	}
});
