/* global go, Ext */

go.modules.business.onlyoffice.SystemSettingsPanel = Ext.extend(go.systemsettings.Panel, {

    title: t("OnlyOffice", 'onlyoffice', 'business'),
    iconCls: 'ic-description',
    labelWidth: 125,
    layout: "form",
    autoScroll: true,

    initComponent: function () {

        this.items = [
            {
                xtype: "fieldset",
                title: t('Connection Settings', 'onlyoffice', 'business'),
                defaults: {
                    allowBlank: false,
                    anchor: '100%',
                },
                items: [
                    {
                        xtype: 'textfield',
                        name: 'documentServerUrl',
                        fieldLabel: t('Server URL', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'textfield',
                        name: 'documentServerTimeout',
                        fieldLabel: t('Server Timeout', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'textfield',
                        name: 'documentServerSecret',
                        fieldLabel: t('Server Secret', 'onlyoffice', 'business'),
                        inputType: 'password',
                        allowBlank: true,
                    },{
                        xtype: 'textfield',
                        name: 'authorizationHeader',
                        fieldLabel: t('Authorization header', 'onlyoffice', 'business'),
                        value: "Authorization",
                        allowBlank: false,
                    }
                ]
            },
            {
                xtype: "fieldset",
                title: t('Customisation', 'onlyoffice', 'business'),
                defaults: {
                    anchor: '100%',
                },
                items: [
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationChat',
                        boxLabel: t('Chat', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationCommentAuthorOnly',
                        boxLabel: t('Comment Author Only', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationComments',
                        boxLabel: t('Comments', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationCompactHeader',
                        boxLabel: t('Compact Header', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationCompactToolbar',
                        boxLabel: t('Compact Toolbar', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationCompatibleFeatures',
                        boxLabel: t('Compatible Features', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'textfield',
                        name: 'customizationFeedback',
                        fieldLabel: t('Feedback URL', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationAutoSave',
                        boxLabel: t('AutoSave', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationForceSave',
                        boxLabel: t('Force Save', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationHelp',
                        boxLabel: t('Help', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationHideRightMenu',
                        boxLabel: t('Hide Right Menu', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationMacros',
                        boxLabel: t('Macros', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'textfield',
                        name: 'customizationMacrosMode',
                        fieldLabel: t('Macros Mode', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationMentionShare',
                        boxLabel: t('Mention Share', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationPlugins',
                        boxLabel: t('Plugins', 'onlyoffice', 'business'),
                    },{
                        xtype: 'selectfield',
                        name: 'customizationReviewDisplay',
                        fieldLabel: t('Review Display', 'onlyoffice', 'business'),
                        options: [['markup', 'Markup'], ['simple', 'Simple'], ['final', 'Final'], ['original','Original']],
                        value: 'tls'
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationShowReviewChanges',
                        boxLabel: t('Show Review Changes', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationSpellcheck',
                        boxLabel: t('Spellcheck', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationToolbarNoTabs',
                        boxLabel: t('Toolbar No Tabs', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'textfield',
                        name: 'customizationUnit',
                        fieldLabel: t('Unit', 'onlyoffice', 'business'),
                    },
                    {
                        xtype: 'xcheckbox',
                        name: 'customizationZoom',
                        boxLabel: t('Zoom', 'onlyoffice', 'business'),
                    },
                ]
            }
        ];

        this.supr().initComponent.call(this);
    }
});