go.modules.business.studio.MainPanel = Ext.extend(go.modules.ModulePanel, {
	id: "studio",
	title: t("Group Office Studio"),
	layout: 'fit',

	initComponent: function() {
		this.createStudioModuleGrid();

		this.items = [
			this.studioModuleGrid
		]

		go.modules.business.studio.MainPanel.superclass.initComponent.call(this);

		this.on("render", function() {
			this.studioModuleGrid.store.load();
		}, this);
	},

	createFilterPanel: function() {
		return new Ext.Panel({
			minHeight: dp(200),
			autoScroll: true,
			tbar: [
				{
					xtype: 'tbtitle',
					text: t('Filters')
				},
				'->',
				{
					xtype: 'filteraddbutton',
					entity: 'Studio'
				}
			],
			items: [
				// lockFilter,
				{xtype: 'box', autoEl: 'hr'},
				{
					xtype: 'filtergrid',
					filterStore: this.studioModuleGrid.store,
					entity: "Studio"
				},
				{
					xtype: 'variablefilterpanel',
					filterStore: this.studioModuleGrid.store,
					entity: "Studio"
				}
			]
		});
	},

	createStudioModuleGrid: function() {
		this.studioModuleGrid = new go.modules.business.studio.StudioGrid({
			region: 'center',
			tbar: [
				'->',
				{
					xtype: 'tbsearch',
					fiters: [
						'name',
						'package'
					]
				},
				this.addButton = new Ext.Button({
					iconCls: 'ic-add',
					tooltip: t('Add'),
					cls: 'primary',
					handler: function(btn) {
						var wzdForm = new go.modules.business.studio.CreateModuleDialog();
						wzdForm.show();
					},
					scope: this
				})],
			listeners: {
				rowdblclick: this.onGridDblClick,
				scope:this,
				keypress: this.onGridKeyPress
		}
		});
		return this.studioModuleGrid;
	},

	onGridDblClick: function(grid, rowIndex, e) {
		this.preOpenModuleWizard(grid.getStore().getAt(rowIndex));
	},

	onGridKeyPress: function(e) {
		if (e.keyCode != e.ENTER) {
			return;
		}
		this.preOpenModuleWizard(this.studioModuleGrid.getSelectionModel().getSelected());
	},
	preOpenModuleWizard: function (record) {
		if (!record || record.get('permissionLevel') < go.permissionLevels.write) {
			return;
		}

		if (!record.data.module.enabled) {
			Ext.MessageBox.alert(t('Disabled'), t('The module appears to be inactive. Please activate the module in system settings,'),
				function () {
					go.Router.setPath('systemsettings');
					window.location.reload(false);
				});
			return;
		}
		this.openModuleWizard(record);
	},
	openModuleWizard: function (record) {
		const module_id = record.data.module.id;
		go.Db.store("Module").single(module_id).then(function (result) {
			let wzd = new go.modules.business.studio.StudioWizard({
				studio_id: record.id,
				module_id: module_id,
				data: result
			});
			wzd.show();
		});
	}
});
