go.modules.business.support.MigrateWindow = Ext.extend(go.Window, {

	title: t("Migrate"),
	width: dp(500),
	autoHeight: true,
	initComponent: function () {
		this.supr().initComponent.call(this);

		this.formPanel = new Ext.form.FormPanel({
			items: [

				{
				xtype: "fieldset",
				items:[
					{
						xtype: "box",
						cls: "pad",
						html: t("This action will migrate all tickets to the new support module. The new support module requires a " +
							"user for each ticket so they could also login and view their own tickets. Not all tickets may have a user in " +
							"the old module. If you choose not to create users the tickets will be migrated but the user will be unknown.")
					},
					{
						xtype: "xcheckbox",
						boxLabel: t("Create users if not found by ticket email."),
						name: "createUsers",
						checked: true
					},
				]
			}

			],
			buttons: [{
				text: t("GO!"),
				cls: "primary",
				scope: this,
				handler: function() {

					this.getEl().mask(t("Loading..."));

					go.Jmap.request({
						method: "business/support/Migrate/tickets",
						params: this.formPanel.form.getValues()
					})
						.then(() => {
							Ext.MessageBox.alert(t("Success"), t("The process has started in the background. You will receive a notification when it's done."));
							this.close();
						})
						.finally(() => {
							this.getEl().unmask();
						})
				}
			}]
		});


		this.add(this.formPanel);

	}
});