import {client, modules, router} from "@intermesh/groupoffice-core";
import {MainPanel} from "./MainPanel.js";
import {t, translate} from "@intermesh/goui";

modules.register(  {
	package: "business",
	name: "supportclient",
	async init () {

		client.on("authenticated",  (client, session) => {
			if(!session.capabilities["go:business:supportclient"]) {
				// User has no access to this module
				return;
			}

			translate.load(GO.lang.core.core, "core", "core");
			translate.load(GO.lang.community.tasks, "business", "supportclient");
			translate.load(GO.lang.business.supportclient, "business", "supportclient");

			const mainPanel = new MainPanel();

			router.add(/^supportclient\/(\d+)$/, (taskId) => {
				modules.openMainPanel("supportclient");
				mainPanel.setTaskId(taskId);
			});

			router.add(/^supportclient$/, () => {
				modules.openMainPanel("supportclient");
				mainPanel.setTaskId();
			});

			modules.addMainPanel( "business", "supportclient", "supportclient", t("Help"), () => {
				//this will lazy load Notes when module panel is opened.
				return mainPanel;
			});
		});
	}
});