(function(){
const icdList = {
	"version":"8.8",
	"entry-count":96,
	"values":[
		{
			"schemeid":"FR:SIRENE",
			"iso6523":"0002",
			"country":"FR",
			"scheme-name":"System Information et Repertoire des Entreprise et des Etablissements: SIRENE",
			"issuing-agency":"Institut National de la Statistique et des Etudes Economiques, (I.N.S.E.E.)",
			"initial-release":"1.0.0",
			"state":"active",
			"structure":"1) Number of characters: 9 characters (\"SIREN\") 14 \" 9+5 (\"SIRET\"), The 9 character number designates an organization, The 14 character number designates a specific establishment of the organization designated by the first 9 characters.\n2) Check digits: 9th & 14th character respectively",
			"display":"The 9 figure code number (SIREN) is written in groups of 3 characters. Example: 784 301 772\nThe 14 figure code number is written in 3 groups of 3 characters and a single group of 5. Example: 784 301 772 00025",
			"examples":"784301772\n78430177200025",
			"validation-rules":"RegEx: [0-9]{9}([0-9]{5})?\nCheck digits: Luhn Algorithm",
			"usage":"1.1.1 - Changed from FR:SIRET to FR:SIRENE (see ISU Jira ISU-231)",
			"registrable":true
		},
		{
			"schemeid":"SE:ORGNR",
			"iso6523":"0007",
			"country":"SE",
			"scheme-name":"Organisationsnummer",
			"issuing-agency":"The National Tax Board",
			"initial-release":"1.0.0",
			"state":"active",
			"structure":"1) 10 digits. 1st digit = Group number, 2nd - 9th digit = Ordinalnumber; 1st digit, = Group number, 10th digit = Check digit\n2) Last digit.",
			"display":"Single group of 10 digits.",
			"examples":"2120000787",
			"validation-rules":"RegEx: [0-9]{10}\nCheck digits: Luhn Algorithm",
			"registrable":true
		},
		{
			"schemeid":"FR:SIRET",
			"iso6523":"0009",
			"country":"FR",
			"scheme-name":"SIRET-CODE",
			"issuing-agency":"DU PONT DE NEMOURS",
			"initial-release":"1.1.1",
			"state":"active",
			"structure":"1) 14 digits\n2) None",
			"display":"In four groups, Groups 1 - 3 = three digits each, Group 4 = five digits",
			"examples":"78430177200025",
			"validation-rules":"RegEx: [0-9]{14}",
			"registrable":true
		},
		{
			"schemeid":"FI:OVT",
			"iso6523":"0037",
			"country":"FI",
			"scheme-name":"LY-tunnus",
			"issuing-agency":"National Board of Taxes, (Verohallitus)",
			"initial-release":"1.0.0",
			"state":"active",
			"structure":"1) ICD 4 Digits, Organization code (8 digits, 1st-7th digit = number, 8th digit = check number), optional specifier for organisational unit (5 digits)\n- Example: 00371234567800001\n- 0037 Country code for Finland (ISO 6523  International Code Designator (ICD) value)\n- 12345678 Business ID without hyphen \n- 00001 Optional specifier for organisation unit (assigned by the organisation itself)",
			"display":"None",
			"examples":"0037:00371234567800001\n0037:1234567800001",
			"validation-rules":"RegEx: (0037)?[0-9]{7}-?[0-9][0-9A-Z]{0,5}\nCheck Digit: mod11 of 8-digit OrgCode (weights 2, 4, 8, 5, 10, 9, 7 [right to left] or 7, 9, 10, 5, 8, 4, 2, 1 [left to right])",
			"usage":"OVT identifier conforming to standard ISO6523.   \n- Constant 0037 (Finnish tax administration organisation code)\n- Finnish local tax ID, 8 characters with initial zero and no hyphen\n+K4:K5",
			"registrable":true
		},
		{
			"schemeid":"DUNS",
			"iso6523":"0060",
			"country":"international",
			"scheme-name":"Data Universal Numbering System (D-U-N-S Number)",
			"issuing-agency":"Dun and Bradstreet Ltd",
			"initial-release":"1.0.0",
			"state":"active",
			"structure":"1) Eight identification digits and a check digit. A two digit prefix will be added in the future but it will not be used to calculate the check digit.\n2) The Organization name is not part of the D-U-N-S number.",
			"display":"IIIIIIIIC where all characters are the digits 0, to 9, I = an identification digit and C = the check digit. When the prefix (P) is added the display requirement will be eleven digits, PPIIIIIIIIC.",
			"examples":"812810734",
			"validation-rules":"RegEx: [0-9]{9}",
			"usage":"Check digits were removed to get a bigger number area\nUPIK search to validate DUNS numbers\n\"D&B Direct 2.0\" API available",
			"registrable":true
		},
		{
			"schemeid":"GLN",
			"iso6523":"0088",
			"country":"international",
			"scheme-name":"Global Location Number",
			"issuing-agency":"GS1 GLN",
			"initial-release":"1.0.0",
			"state":"active",
			"structure":"1) 13 digits including check digits, 2) None",
			"display":"None",
			"examples":"1548079098355",
			"validation-rules":"RegEx: [0-9]{13}\nCheck Digit: mod10 (weights 1, 3)",
			"usage":"GLN-13 are the only supports supported atm",
			"registrable":true
		},
		{
			"schemeid":"DK:P",
			"iso6523":"0096",
			"country":"DK",
			"scheme-name":"The Danish Business Authority - P-number (DK:P)",
			"issuing-agency":"The Danish Business Authority",
			"initial-release":"1.0.0",
			"state":"active",
			"structure":"XXXXXXXXXX\n10 digits eg. 1234567890",
			"display":"10 characters, no space or other separator",
			"validation-rules":"RegEx: [0-9]{10}",
			"usage":"A P-number that represents a production unit.",
			"registrable":true
		},
		{
			"schemeid":"IT:FTI",
			"iso6523":"0097",
			"country":"IT",
			"scheme-name":"FTI - Ediforum Italia",
			"issuing-agency":"FTI - Ediforum Italia",
			"initial-release":"1.0.0",
			"state":"active",
			"structure":"Character repertoire: The EDI identifier consists of digits only.\nThe identifier has a fixed length.\nNo separators are required.\nStructure: [1234567] [123] [1] [12345], min 11- max 16, < >, A B C D\nA: numerical value (7 digits) assigned by Uffico Provinciale IVA (local branch of Ministry of Finance)\nB: numerical value a (3 digits) identifying the County\nC: numerical check digit (1 digit);\nD: optional numerical value (up to 5 digits used by the registered organization (free part).\nCheck digit computation: The check digit algorithm is the one published in the Gazzetta Ufficiale no 345 of December 29 1976.",
			"display":"None",
			"validation-rules":"RegEx: [0-9]{11,16}\nThe check digit algorithm is the one published in the Gazzetta Ufficiale no 345 of December 29 1976.",
			"usage":"We couldn't find the checksum algorithm in the scanned PDF of 1976\nProposed to deprecate",
			"registrable":true
		},
		{
			"schemeid":"NL:KVK",
			"iso6523":"0106",
			"country":"NL",
			"scheme-name":"Vereniging van Kamers van Koophandel en Fabrieken in Nederland (Association of\nChambers of Commerce and Industry in the Netherlands), Scheme",
			"issuing-agency":"Vereniging van Kamers van Koophandel en Fabrieken in Nederland",
			"initial-release":"1.1.2",
			"state":"active",
			"structure":"Character repertoire: The EDI identifier consists of digits only.\nThe identifier has a fixed length.\nNo separators are required.\nStructure: [123] [123456] [123456] [12], 17, < >, A B C D\nA: numerical value allocated by the RA to the regional subauthority, (3 digits)\nB: numerical value allocated by the sub-authority to the registered, organization (mandatory part of the identifier; 6 digits)\nC: numerical value used by the registered organization (free part; 6 digits)\nD: numerical check digit calculated by the registered organization; (2 digits)\nCheck digit computation, The check digit is modular 97 computed on ABC as one number.",
			"display":"None",
			"validation-rules":"RegEx: [0-9]{17}\nCheck Digits: mod97",
			"usage":"Real numbers seem to be 8 characters",
			"registrable":true
		},
		{
			"schemeid":"EU:NAL",
			"iso6523":"0130",
			"country":"international",
			"scheme-name":"Directorates of the European Commission",
			"issuing-agency":"European Commission, Information Directorate, Data Transmission Service",
			"initial-release":"4",
			"state":"active",
			"structure":"1) ICD 4 digits, 2) None",
			"display":"None",
			"usage":"Requested by TICC-10 and TICC-11;\nin SML since 2019-08-23",
			"registrable":true
		},
		{
			"schemeid":"IT:SIA",
			"iso6523":"0135",
			"country":"IT",
			"scheme-name":"SIA Object Identifiers",
			"issuing-agency":"SIA-SocietÃ  Interbancaria per l'Automazione S.p.A.",
			"initial-release":"1.0.0",
			"state":"active",
			"structure":"First field: ICD: 4 digits, Second field: sequence of digits",
			"display":"None",
			"usage":"Propose to deprecate",
			"registrable":true
		},
		{
			"schemeid":"IT:SECETI",
			"iso6523":"0142",
			"country":"IT",
			"scheme-name":"SECETI Object Identifiers",
			"issuing-agency":"Servizi Centralizzati SECETI S.p.A.",
			"initial-release":"1.0.0",
			"state":"active",
			"structure":"1) First field: ICD: 4 digits, Second field: sequence of digits",
			"display":"None",
			"usage":"Propose to deprecate",
			"registrable":true
		},
		{
			"schemeid":"AU:ABN",
			"iso6523":"0151",
			"country":"AU",
			"scheme-name":"Australian Business Number (ABN) Scheme",
			"issuing-agency":"Australian Taxation Office",
			"initial-release":"5",
			"state":"active",
			"structure":"The ABN is an 11 digit numeric identifier.\nThe first two digits are check digits calculated using a modulus 89 of the weighted digits.\nThe first digit of the number is guaranteed to be non-zero by adding 10 to the modulus (so the first two digits range from 10 through to 99).\nFor companies the last 9 digits are identical to their existing Australian Company Number (CAN) which includes a single trailing check digit.\nFor other entities the digits are randomly allocated but are guaranteed to fail the CAN check. This allows the Australian Securities and Investment Commission (ASIC) to continue allocating CAN during a transition period. The valid characters are numeric digits 0-9.",
			"display":"It is displayed as follows: -, XX XXX XXX XXX",
			"examples":"51 824 753 556",
			"validation-rules":"RegEx: [0-9]{11}\nCheck number: mod 89 (weights)\n* Subtract 1 from the first (left-most) digit of the ABN to give a new 11 digit number\n* Multiply each of the digits in this new number by a \"weighting factor\" based on its position as shown in the table below\n*Sum the resulting 11 products\n* Divide the sum total by 89, noting the remainder\n* If the remainder is zero the number is a valid ABN\nWeight: 10, 1, 3, 5, 7, 9, 11, 13, 15, 17, 19",
			"usage":"https://abr.business.gov.au/Help/AbnFormat",
			"registrable":true
		},
		{
			"schemeid":"CH:UIDB",
			"iso6523":"0183",
			"country":"CH",
			"scheme-name":"Swiss Unique Business Identification Number (UIDB)",
			"issuing-agency":"Swiss Federal Statistical Office (FSO)",
			"initial-release":"5",
			"state":"active",
			"structure":"CHEXXXXXXXXP\nUID number, is composed by 9 digits and is random generated and has no internal means.\n1)\n12 characters\nCHE: Swiss Country Code following ISO 3166-1.\nXXXXXXXX: 8 digits for the number itself\nP: check digit\n2)\nCHEXXXXXXXXP, the last digit",
			"display":"There is no requirements. As suggested in the standards eCH-0097 (http://www.ech.ch) the transmission of the UID is without any separator.\nFor display reason is suggested to use this format CHE-XXX.XXX.XXP minus-character ('-') after 'CHE' and separator dot-character ('.') after 6th and 9th character",
			"validation-rules":"RegEx: CHE[0-9]{9}\nCheck number: mod11 (weights: 5, 4, 3, 2, 7, 6, 5, 4)",
			"usage":"Also called \"NumÃ©ro d'identification suisse des enterprises (IDE)\"",
			"registrable":true
		},
		{
			"schemeid":"DK:DIGST",
			"iso6523":"0184",
			"country":"DK",
			"scheme-name":"The Danish Business Authority - CVR-number (DK:CVR)",
			"issuing-agency":"The Danish Business Authority",
			"initial-release":"1.2.1",
			"state":"active",
			"structure":"XXXXXXXX\n8 digits eg. 12345678",
			"display":"8 characters, no space or other separator",
			"validation-rules":"RegEx: [1-9][0-9]{7}",
			"usage":"A CVR number uniquely identifies a legal entity. CVR stands for â€œCentral Business Registerâ€ and contains information about all registered companies in Denmark.",
			"registrable":true
		},
		{
			"schemeid":"JP:SST",
			"iso6523":"0188",
			"country":"JP",
			"scheme-name":"Corporate Number of The Social Security and Tax Number System",
			"issuing-agency":"National Tax Agency Japan",
			"initial-release":"8.1",
			"state":"active",
			"structure":"12-digit fundamental numbers, and a one-digit check numeral put ahead of them\n1) Figure of 13 digits\n2) Figures from 1 to 9 (Formula to calculate the test number) Formula 9-((n = 1 (Sigma)12( Pn * Qn )) remainder obtained by dividing the 9)\nPn : the numeral of the n-th digit of a fundamental number, when counted from the bottom digit.\nQn : one when the \"n\" is an odd number, two when the \"n\" is an even one",
			"display":"None",
			"registrable":true
		},
		{
			"schemeid":"NL:OINO",
			"iso6523":"0190",
			"country":"NL",
			"scheme-name":"Organisatie-identificatienummer (OIN)",
			"issuing-agency":"Logius",
			"initial-release":"2",
			"state":"active",
			"structure":"20 digits\n1) Structure: prefix(8)- identification number(8 or 9)- suffix(3 or 4)\n- The first 8 digits prefix designates the origin of the identification number\n- The following 8 or 9 digits designates a unique identification number\n- The last 3 or 4 (depending on the length of the identification number are filled with â€œ0â€ digit [note: Up until 2017 numbers are issued where this position contains a serial number.]\n2) No check digit",
			"display":"In one group of 20 digits",
			"examples":"00000001820029336000",
			"validation-rules":"RegEx: [0-9]{20}",
			"usage":"Get all OINs from http://portaal.digikoppeling.nl/registers/",
			"registrable":true
		},
		{
			"schemeid":"EE:CC",
			"iso6523":"0191",
			"country":"EE",
			"scheme-name":"Company code",
			"issuing-agency":"Centre of Registers and Information Systems of the Ministry of Justice",
			"initial-release":"2",
			"state":"active",
			"structure":"Always 8-digit number\n1) First number in code:\n1 â€“ Commercial organisations\n7 -- State agencies and local government institutions\n8 -- Non-profit associations\n9 -- Foundations\n2)",
			"display":"None",
			"examples":"10137025",
			"validation-rules":"RegEx: [1789][0-9]{7}\nCheckDigit as last char.\nPython code to check:\ndef calc_check_digit(number):\n    \"\"\"Calculate the check digit.\"\"\"\n    check = sum(((i % 9) + 1) * int(n)\n                for i, n in enumerate(number[:-1])) % 11\n    if check == 10:\n        check = sum((((i + 2) % 9) + 1) * int(n)\n                    for i, n in enumerate(number[:-1])) % 11\n    return str(check % 10)",
			"usage":"See https://ariregister.rik.ee/index?lang=eng",
			"registrable":true
		},
		{
			"schemeid":"NO:ORG",
			"iso6523":"0192",
			"country":"NO",
			"scheme-name":"Organisasjonsnummer",
			"issuing-agency":"The BrÃ¸nnÃ¸ysund Register Centre",
			"initial-release":"2",
			"state":"active",
			"structure":"9 digits\nThe organization number consists of 9 digits where the last digit is a control digit calculated with standard weights, modulus 11. After this, weights 3, 2, 7, 6, 5, 4, 3 and 2 are calculated from the first digit.",
			"display":"None",
			"examples":"745707327",
			"validation-rules":"RegEx: [0-9]{9}\nCheck digit: mod11 (weights 3, 2, 7, 6, 5, 4, 3)",
			"registrable":true
		},
		{
			"schemeid":"UBLBE",
			"iso6523":"0193",
			"country":"BE",
			"scheme-name":"UBL.BE Party Identifier",
			"issuing-agency":"UBL.BE",
			"initial-release":"3",
			"state":"active",
			"structure":"Maximum 50 characters\n4 Characters fixed length identifying the type \nMaximum 46 characters for the identifier itself",
			"display":"None",
			"validation-rules":"RegEx: .{4,50}",
			"registrable":true
		},
		{
			"schemeid":"SG:UEN",
			"iso6523":"0195",
			"country":"SG",
			"scheme-name":"Singapore Nationwide E-Invoice Framework",
			"issuing-agency":"lnfocomm Media Development Authority",
			"initial-release":"4",
			"state":"active",
			"structure":"The code comprises of 3 fields\n1st field = ICD\n2nd field = Special identifier (e.g. country identifier, test identifier, etc)\n3rd field = Organisation identifrer No check value",
			"display":"None, except all fields are left justified",
			"validation-rules":"RegEx: [a-z]{2}[a-z]{3}([0-9]{8}|[0-9]{9}|[RST][0-9]{2}[a-z]{2}[0-9]{4})[0-9a-z]",
			"usage":"https://www.uen.gov.sg/ueninternet/faces/pages/admin/aboutUEN.jspx?_afrLoop=1018044967911865&_afrWindowMode=0&_adf.ctrl-state=fdr4mq9l0_26",
			"registrable":true
		},
		{
			"schemeid":"IS:KTNR",
			"iso6523":"0196",
			"country":"IS",
			"scheme-name":"Icelandic identifier",
			"issuing-agency":"Icelandic National Registry",
			"initial-release":"4",
			"state":"active",
			"structure":"10 digit string using numerical characters from 0 to 9\nBased on individuals birthdate or legal entities registration date D1D2M1M2Y1Y2R1R2CM D = day, M = month, Y = year, R = random. C = checksum, M = century.\nNinth character \"C\":\nC = 11 - ((3xD1 + 2xD2 + 7xM1 + 6xM2 + 5xY1 + 4xY2 + 3xR1 + 2xR2) mod 11)",
			"display":"Whole string: nnnnnnnnnn\nCommonly displayed with hyphen between Y2 and R1, e.g. nnnnnn-nnnn",
			"validation-rules":"RegEx: [0-9]{10}\nCheck digit: mod11 (weights 3, 2, 7, 6, 5, 4, 3, 2)",
			"registrable":true
		},
		{
			"schemeid":"DK:ERST",
			"iso6523":"0198",
			"country":"DK",
			"scheme-name":"The Danish Business Authority - SE-number (DK:SE)",
			"issuing-agency":"The Danish Business Authority",
			"initial-release":"5",
			"state":"active",
			"structure":"DKXXXXXXXX\nTwo characters (DK) followed by 8 digits eg. DK12345678",
			"display":"10 characters, no space or other separator",
			"validation-rules":"RegEx: DK[0-9]{8}\nCheck digit: mod11 (weights 2, 7, 6, 5, 4, 3, 2, 1)",
			"registrable":true
		},
		{
			"schemeid":"LEI",
			"iso6523":"0199",
			"country":"international",
			"scheme-name":"Legal Entity Identifier (LEI)",
			"issuing-agency":"As of December 2018, there are 33 LEI issuing organizations in the world.",
			"initial-release":"5",
			"state":"active",
			"structure":"The ISO 17442 standard specifies the minimum reference data, which must the format of the organization identifiers, be Supplied for each LEI:\n* The official name of the legal entity as recorded in the official registers.\n* The registered address of that legal entity.\n* The country of formation.\n* The codes for the representation of names of countries and their subdivisions.\n* The date of the first LEI assignment; the date of last update of the\n* LEI information; and the date of expiry, if applicable.\nAdditional information may be registered as agreed between the legal entity and its LEI issuing organization.\nThe number allocation scheme was further specified in Annex 2 of the Financial Stability Board's third progress note on the Global LEI Initiative on 24 October 2012:\nâ€¢ Characters 1 -4: A four character prefix allocated uniquely to each LEI issuer.\nâ€¢ Characters 5-6: Two reserved characters set to zero.\nâ€¢ Characters 7-18: Entity-specific part of the code generated and assigned by LOUs according to transparent, sound and robust allocation policies.\nâ€¢ Characters 19-20: Two check digits as described in the ISO 17442 standards. The check digit scheme follows ISO/IEC 7064 (MOD 97-10) and contributes to avoiding typing errors.\nSee http://www.fsb.org/wp-contenVuploads/r_121024.pdf?page_moved=1\n1:)\n1. a) Character representations:\nâ€¢ n: digits (numeric characters 0 to 9 only);\nâ€¢ a: uppercase letters (alpha character, A-Z only, without \"special\" characters such as blanks, separators or punctuation).\n2. b) Length indications:\nâ€¢ nn!: fixed length;\nâ€¢ nn: maximum length.\nThe format of the LEI shall be\n-18!an2!n.\nThe LEI consists of 20 characters decomposed as follows: characters (18!an) without separators or \"special\" characters; the 19th and 20th characters (2!n) shall be the check digit or digits, as calculated from the scheme defined in this International Standard.\n2:)\nThe check digits shall be calculated based on the scheme defined in ISO/IEC 7064 (MOD 97-10). See Annex A. The check digits are used to verify the LEI.\n1. Convert letters to digits in accordance with the following:\nA=10B=11 C=12D=13E=14\nF=15G=16H=17I=18J=19\nK=20 L = 21 M =22 N =23 0 =24\nP =25Q = 26 R = 27 S = 28 T = 29\nU = 30 V = 31 W = 32 X = 33 Y = 34 Z = 35\n2. Apply the check character system, MOD 97-10, in accordance with ISO/IEC 7064.\n3. If the remainder is 1 (one), the number is valid.\n\nGenerating the check digits\n\n4. Add \"00\" to the right-hand end of the LEI.\n5. Convert alpha characters into numeric characters in accordance with letters in #1.\n6. Apply the check character system, MOD 97-10, in accordance with ISO/IEC 7064.",
			"display":"The entire 20 character code (including the check digits)",
			"validation-rules":"RegEx: [A-Z0-9]{18}[0-9]{2}\nCheck digit: mod97-10",
			"registrable":true
		},
		{
			"schemeid":"LT:LEC",
			"iso6523":"0200",
			"country":"LT",
			"scheme-name":"Legal entity code",
			"issuing-agency":"State Enterprise Centre of Registers",
			"initial-release":"5",
			"state":"active",
			"structure":"9 (nine) digits\nEach legal entity's code number is multiplied by 1, 2, 3, 4, 5, 6, 7, 8\n(weighting) starting from the left-hand side of the code. Calculates the sum of the product, divided by 11. The remainder of the division, which must be less than 10, is the 9th, control, number of the legal entity's code.",
			"display":"None",
			"examples":"111963319",
			"validation-rules":"RegEx: [0-9]{9}\nCheck number: see text",
			"registrable":true
		},
		{
			"schemeid":"IT:CUUO",
			"iso6523":"0201",
			"country":"IT",
			"scheme-name":"Codice Univoco UnitÃ  Organizzativa iPA",
			"issuing-agency":"Agenzia per lâ€™Italia digitale",
			"initial-release":"6",
			"state":"active",
			"structure":"String of 6 alphanumeric characters",
			"display":"None",
			"validation-rules":"RegEx: [0-9a-zA-Z]{6}\nNo checkdigit",
			"usage":"\"Alphanumeric characters\"",
			"registrable":true
		},
		{
			"schemeid":"DE:LWID",
			"iso6523":"0204",
			"country":"DE",
			"scheme-name":"Peppol-Leitweg-ID",
			"issuing-agency":"Koordinierungsstelle fÃ¼r IT-Standards (KoSIT)",
			"initial-release":"6",
			"state":"active",
			"structure":"Up to 46 alphanumeric characters\nFormat: <Up to 12 numeric characters>\"-\"<up to 30 alphanumeric characters>\"â€“\"<2 numeric characters>",
			"display":"Whole string",
			"validation-rules":"RegEx: [0-9]{2,12}(\\-[0-9A-Z]{0,30})?\\-[0-9]{2}",
			"usage":"The fine grained part is optional",
			"registrable":true
		},
		{
			"schemeid":"IT:COD",
			"iso6523":"0205",
			"country":"IT",
			"scheme-name":"CODDEST",
			"issuing-agency":"Agenzia delle Entrate",
			"initial-release":"8.4",
			"state":"active",
			"structure":"The code is 7 alphanumeric characters",
			"usage":"Participants with this ID CAN NOT be registered in the SMP/SML!",
			"registrable":false
		},
		{
			"schemeid":"BE:EN",
			"iso6523":"0208",
			"country":"BE",
			"scheme-name":"Numero d'entreprise / ondernemingsnummer / Unternehmensnummer",
			"issuing-agency":"Banque-Carrefour des Entreprises (BCE) / Kruispuntbank van Ondernemingen (KBO) / Zentrale Datenbank der Unternehmen (ZOU)\nService public fÃ©dÃ©ral Economie, P.M.E. Classes moyennes et Energie",
			"initial-release":"7",
			"state":"active",
			"structure":"10 numeric characters.\n1. Enterprise identification number: the first digit has to be \"0\" or \"1\"",
			"display":"Group of 10 digits",
			"validation-rules":"RegEx: [01][0-9]{9}\nCheck digit: mod97\nSee https://github.com/arthurdejong/python-stdnum/blob/master/stdnum/be/vat.py",
			"registrable":true
		},
		{
			"schemeid":"GS1",
			"iso6523":"0209",
			"country":"international",
			"scheme-name":"GS1 identification keys",
			"issuing-agency":"GS1",
			"initial-release":"7.5",
			"state":"active",
			"structure":"The code will include an application identifier indicating the type of GS1 identification key used for an object, followed by the value of the key. The string can be completed by other application identifiers indicating attributes related to the GS1 ID key and the value of these attributes related to the identified object.",
			"display":"None",
			"examples":"414541000099999325412345678901234567890",
			"validation-rules":"See document \"GS1 Application Standard for usage of ISO/IEC 6523 International Code Designator (ICD) 0209\"",
			"registrable":true
		},
		{
			"schemeid":"IT:CFI",
			"iso6523":"0210",
			"country":"IT",
			"scheme-name":"CODICE FISCALE",
			"issuing-agency":"Agenzia delle Entrate",
			"initial-release":"7.5",
			"state":"active",
			"structure":"The code is 16 alphanumeric digits for natural persons or 11 numeric digits for legal persons.\nThe code is 16 alphanumeric digits for natural persons, with this structure:\n3 digits - Surname according to specific rules\n3 digits - Name according to specific rules\n2 digits - Last two digits of year of birth\n1 digit - Month of birth according to a specific conversion table\n2 digits - Day of birth and gender\n4 digits - Place of birth in a â€œBelfioreâ€ code\n1 digit - CIN â€“ Control Internal Number\nThe code is 11 numeric digits for legal persons, with this structure:\n7 digits - Progressive number\n3 digits - Revenue Office ID\n1 digit - check\nLast digit for natural persons - CIN - Control Internal Number\nLast digit for legal persons - Check",
			"validation-rules":"Character Repertoire : A to Z (upper case) and 0 to 9",
			"registrable":true
		},
		{
			"schemeid":"IT:IVA",
			"iso6523":"0211",
			"country":"IT",
			"scheme-name":"PARTITA IVA",
			"issuing-agency":"Agenzia delle Entrate",
			"initial-release":"7.5",
			"state":"active",
			"structure":"The code is \"IT\" followed by 11 numeric digits\nFirst 7 digits is a progressive number\nThe following 3 digits means the province of residence\nThe last digit is a check number, calculated using Luhn's Algorithm",
			"validation-rules":"RegEx: IT[0-9]{11}\nfirst 7: company identifiers\nnext 3: province of residence (between \"001\" and \"100\"; or \"120\", \"121\", \"888\" \"999\")\nLast: check digit\nCheck digit: Luhn",
			"registrable":true
		},
		{
			"schemeid":"FI:ORG",
			"iso6523":"0212",
			"country":"FI",
			"scheme-name":"Finnish Organization Identifier",
			"issuing-agency":"State Treasury of Finland / Valtiokonttori",
			"initial-release":"7.5",
			"state":"active",
			"structure":"9999999-9\nnine characters\nlast digit after the hyphen is check character",
			"display":"Shall be presented as string so that leading zeros have to be present.\nHyphen shall be present between last two digits.",
			"validation-rules":"Character Repertoire: digits 0-9 and hyphen \"-\"",
			"registrable":true
		},
		{
			"schemeid":"FI:VAT",
			"iso6523":"0213",
			"country":"FI",
			"scheme-name":"Finnish Organization Value Add Tax Identifier",
			"issuing-agency":"State Treasury of Finland / Valtiokonttori",
			"initial-release":"7.5",
			"state":"active",
			"structure":"FI99999999\nten characters",
			"display":"Shall be presented as string so that leading zeros have to be present. Two first characters have always fixed value FI.",
			"validation-rules":"Character Repertoire: digits 0-9 and FI",
			"registrable":true
		},
		{
			"schemeid":"FI:NSI",
			"iso6523":"0215",
			"country":"FI",
			"scheme-name":"Net service ID",
			"issuing-agency":"Tieto Finland Oy",
			"initial-release":"8.1",
			"state":"active",
			"structure":"xxnnnnnnnnnnnnxxxxx\nxx = operator prefix (example TE)\nnnnnnnnnnnnnxxxxx = the organisation identification number of the\nundertaking, which may be a VAT code, or a national organisation\nnumber supplemented by the organisation number with an ICD code in front of the organisation number and may be followed by a\ncompany-specific specification.\n\nmax thirty-five (35) characters",
			"display":"None",
			"validation-rules":"Character Repertoire: Letters A-Z, digits 0-9",
			"usage":"An example of Net Service ID: TE003701011385TEST",
			"registrable":true
		},
		{
			"schemeid":"FI:OVT2",
			"iso6523":"0216",
			"country":"FI",
			"scheme-name":"OVTcode",
			"issuing-agency":"TIEKE- Tietoyhteiskunnan kehittamiskeskus ry",
			"initial-release":"8.1",
			"state":"active",
			"structure":"0037NNNNNNNNXXXXX\nThe code consists of three parts: Prefix 0037, the Business ID and an optional suffix.\nThe 0037 in the beginning is a fixed value. The next eight characters are the organization's Finnish Business ID (Business Identity Code) without a hyphen. An optional suffix up to five characters in the end of OVT code can be used, for example, to refer to a department, profit center or location of an organization unit. The organization can choose the values of the suffix itself and the organization must take care of the uniqueness of each ID it uses.\n\nThe length of the code is thus 12â€¦17 characters.\n0037 = fixed prefix\nNNNNNNNN = Finnish Business ID (numbers only with possible leading zeros)\nXXXXX = optional suffix for organizational part ID [Aâ€¦Z 0â€¦9]",
			"display":"None",
			"validation-rules":"Character Repertoire: Capital letters A-Z, digits 0-9",
			"usage":"An example of OVT code: 003704944842TST01",
			"registrable":true
		},
		{
			"schemeid":"LV:URN",
			"iso6523":"0218",
			"country":"LV",
			"scheme-name":"Unified registration number",
			"issuing-agency":"The Register of Enterprises of the Republic of Latvia",
			"initial-release":"8.8",
			"state":"active",
			"structure":"The unified registration number is an 11-digit code where first\ncharacter can be 4 or 5 or 6 (with the exception of mass media and\npublic-private partnerships whose unified registration number is\nnine digits long)",
			"display":"None",
			"validation-rules":"RegEx: [0-9]{9}([0-9]{2})?",
			"registrable":true
		},
		{
			"schemeid":"JP:IIN",
			"iso6523":"0221",
			"country":"JP",
			"scheme-name":"The registered number of the qualified invoice issuer",
			"issuing-agency":"Name: National Tax Agency Japan",
			"initial-release":"8.5",
			"state":"active",
			"structure":"T + 13-digit integer\n\nFigure of 14 digits\n\nFigures from 1 to 9\n(Formula to calculate the test number)\nFormula 9 - ((n = 1 (Sigma)12( Pn * Qn )) remainder obtained by dividing the 9)\nPn: the numeral of the n-th digit of a fundamental number, when counted from the bottom digit.\nQn: one when the \"n\" is an odd number, two when the \"n\" is an even one",
			"display":"None",
			"usage":"Business entities need to submit application to be registered to issue qualified invoices.",
			"registrable":true
		},
		{
			"schemeid":"MY:EIF",
			"iso6523":"0230",
			"country":"MY",
			"scheme-name":"National e-Invoicing Framework",
			"issuing-agency":"Malaysia Digital Economy Corporation Sdn Bhd (MDEC)",
			"initial-release":"8.5",
			"state":"active",
			"structure":"1st field = ICD\n2nd field = Special Identifier (e.g. country identifier, test identifier, etc)\n3rd field = Organisation identifier\n\nNo check value",
			"display":"None",
			"usage":"For use in electronic messages in accordance to the National e-Invoicing framework on identification of organization",
			"registrable":true
		},
		{
			"schemeid":"DK:CPR",
			"iso6523":"9901",
			"country":"DK",
			"scheme-name":"Danish Ministry of the Interior and Health",
			"issuing-agency":"Danish Ministry of the Interior and Health",
			"initial-release":"1.0.0",
			"state":"removed",
			"deprecation-release":"8.6",
			"removal-date":"2023-11-30",
			"structure":"1) First field: ICD: 4 digits, Second field: sequence of digits",
			"display":"None",
			"usage":"Personal identifier",
			"registrable":false
		},
		{
			"schemeid":"DK:CVR",
			"iso6523":"9902",
			"country":"DK",
			"scheme-name":"The Danish Commerce and Companies Agency",
			"issuing-agency":"The Danish Commerce and Companies Agency",
			"initial-release":"1.0.0",
			"state":"removed",
			"deprecation-release":"8.6",
			"removal-date":"2023-11-30",
			"examples":"13585628",
			"validation-rules":"RegEx: [1-9][0-9]{7}\nCheck digit: mod11 (weights, 2, 7, 6, 5, 4, 3, 2, 1)",
			"registrable":false
		},
		{
			"schemeid":"DK:SE",
			"iso6523":"9904",
			"country":"DK",
			"scheme-name":"Danish Ministry of Taxation, Central Customs and Tax Administration",
			"issuing-agency":"Danish Ministry of Taxation, Central Customs and Tax Administration",
			"initial-release":"1.0.0",
			"state":"removed",
			"deprecation-release":"8.6",
			"removal-date":"2023-11-30",
			"examples":"DK26769388",
			"validation-rules":"RegEx: DK[0-9]{8}\nTaks: validate Check digit: mod11 (weights 2, 7, 6, 5, 4, 3, 2, 1)",
			"registrable":false
		},
		{
			"schemeid":"DK:VANS",
			"iso6523":"9905",
			"country":"DK",
			"scheme-name":"Danish VANS providers",
			"issuing-agency":"Danish VANS providers",
			"initial-release":"1.0.0",
			"state":"removed",
			"deprecation-release":"8.6",
			"removal-date":"2023-11-30",
			"examples":"DK26769388",
			"usage":"Propose to deprecate (only 7 identifiers, only IBM - all look like test)",
			"registrable":false
		},
		{
			"schemeid":"IT:VAT",
			"iso6523":"9906",
			"country":"IT",
			"scheme-name":"Ufficio responsabile gestione partite IVA",
			"initial-release":"1.0.0",
			"state":"removed",
			"deprecation-release":"8.1",
			"removal-date":"2023-05-24",
			"structure":"The code is \"IT\" followed by 11 numeric digits\nFirst 7 digits is a progressive number\nThe following 3 digits means the province of residence\nThe last digit is a check number, calculated using Luhn's Algorithm",
			"examples":"IT06363391001",
			"validation-rules":"RegEx: IT[0-9]{11}\nfirst 7: company identifiers\nnext 3: province of residence (between \"001\" and \"100\"; or \"120\", \"121\", \"888\" \"999\")\nLast: check digit\nCheck digit: Luhn",
			"registrable":false
		},
		{
			"schemeid":"IT:CF",
			"iso6523":"9907",
			"country":"IT",
			"scheme-name":"TAX Authority",
			"issuing-agency":"TAX Authority",
			"initial-release":"1.0.0",
			"state":"removed",
			"deprecation-release":"8.1",
			"removal-date":"2023-05-24",
			"examples":"RSSBBR69C48F839A",
			"validation-rules":"RegEx: [0-9]{11} (company identification)\nfirst 7: company identifiers\nnext 3: province of residence (between \"001\" and \"100\"; or \"120\", \"121\", \"888\" \"999\")\nLast: check digit\nCheck digit: Luhn\n\nRegEx: [A-Z]{6}[0-9LMNPQRSTUV]{2}[ABCDEHLMPRST][0-9LMNPQRSTUV]{2}[A-Z][0-9LMNPQRSTUV]{3}[A-Z] (personal identification)\nCheck digit: https://github.com/arthurdejong/python-stdnum/blob/master/stdnum/it/codicefiscale.py",
			"usage":"NOTE: The \"CF\" is a Fiscal Code that can be \"personal\" or for a \"legal entity\".\nThe CF for legal entities is like the Italian VAT code (IT:VAT)",
			"registrable":false
		},
		{
			"schemeid":"NO:ORGNR",
			"iso6523":"9908",
			"country":"NO",
			"scheme-name":"Enhetsregisteret ved Bronnoysundregisterne",
			"issuing-agency":"The BrÃ¸nnÃ¸ysund Register Centre",
			"initial-release":"1.0.0",
			"state":"removed",
			"deprecation-release":"8.3",
			"removal-date":"2023-05-24",
			"structure":"9 digits\nThe organization number consists of 9 digits where the last digit is a control digit calculated with standard weights, modulus 11. After this, weights 3, 2, 7, 6, 5, 4, 3 and 2 are calculated from the first digit.",
			"validation-rules":"RegEx: [0-9]{9}\nCheck digit: mod11 (weights 3, 2, 7, 6, 5, 4, 3)",
			"usage":"Use 0192 instead",
			"registrable":false
		},
		{
			"schemeid":"NO:VAT",
			"iso6523":"9909",
			"country":"NO",
			"scheme-name":"Norwegian VAT number",
			"issuing-agency":"Enhetsregisteret ved Bronnoysundregisterne",
			"initial-release":"1.0.0",
			"state":"deprecated",
			"deprecation-release":"1.1.0",
			"examples":"990399123MVA",
			"validation-rules":"RegEx: NO[0-9]{9}MVA\nCheck digit: mod11 (weights 3, 2, 7, 6, 5, 4, 3)",
			"usage":"Numerical part is the OrgNumber",
			"registrable":true
		},
		{
			"schemeid":"HU:VAT",
			"iso6523":"9910",
			"country":"HU",
			"scheme-name":"Hungary VAT number",
			"initial-release":"1.0.0",
			"state":"active",
			"validation-rules":"RegEx: HU[0-9]{8}\nCheck digit: https://github.com/arthurdejong/python-stdnum/blob/master/stdnum/hu/anum.py",
			"registrable":true
		},
		{
			"schemeid":"EU:VAT",
			"iso6523":"9912",
			"country":"international",
			"scheme-name":"National ministries of Economy",
			"initial-release":"1.0.0",
			"state":"deprecated",
			"deprecation-release":"1.1.0",
			"structure":"Must start with the country code",
			"validation-rules":"RegEx: [A-Z]{2}[A-Z0-9]{,20}",
			"usage":"Proposed to undeprecate; longest known is 18 chars (incl. country code)\nDeprecated in 1.1.0",
			"registrable":true
		},
		{
			"schemeid":"EU:REID",
			"iso6523":"9913",
			"country":"international",
			"scheme-name":"Business Registers Network",
			"issuing-agency":"Business Registers Network",
			"initial-release":"1.0.0",
			"state":"active",
			"usage":"Proposed to deprecate",
			"registrable":true
		},
		{
			"schemeid":"AT:VAT",
			"iso6523":"9914",
			"country":"AT",
			"scheme-name":"Ã–sterreichische Umsatzsteuer-Identifikationsnummer",
			"initial-release":"1.0.0",
			"state":"active",
			"examples":"ATU12345678",
			"registrable":true
		},
		{
			"schemeid":"AT:GOV",
			"iso6523":"9915",
			"country":"AT",
			"scheme-name":"Ã–sterreichisches Verwaltungs bzw. Organisationskennzeichen",
			"initial-release":"1.0.0",
			"state":"active",
			"examples":"b",
			"validation-rules":"RegEx: [A-Z][A-Z0-9]*",
			"usage":"No entity behind id",
			"registrable":true
		},
		{
			"schemeid":"AT:CID",
			"iso6523":"9916",
			"country":"AT",
			"scheme-name":"Firmenidentifikationsnummer der Statistik Austria",
			"initial-release":"1.0.0",
			"state":"deprecated",
			"deprecation-release":"1.0.2",
			"registrable":true
		},
		{
			"schemeid":"IS:KT",
			"iso6523":"9917",
			"country":"IS",
			"scheme-name":"Icelandic National Registry",
			"initial-release":"1.0.0",
			"state":"deprecated",
			"deprecation-release":"4",
			"structure":"10 digit string using numerical characters from 0 to 9\nBased on individuals birthdate or legal entities registration date D1D2M1M2Y1Y2R1R2CM D = day, M = month, Y = year, R = random. C = checksum, M = century.\nNinth character \"C\":\nC = 11 - ((3xD1 + 2xD2 + 7xM1 + 6xM2 + 5xY1 + 4xY2 + 3xR1 + 2xR2) mod 11)",
			"display":"Whole string: nnnnnnnnnn\nCommonly displayed with hyphen between Y2 and R1, e.g. nnnnnn-nnnn",
			"validation-rules":"RegEx: [0-9]{10}\nCheck digit: mod11 (weights 3, 2, 7, 6, 5, 4, 3, 2)",
			"usage":"In favour of 0196",
			"registrable":true
		},
		{
			"schemeid":"IBAN",
			"iso6523":"9918",
			"country":"international",
			"scheme-name":"SOCIETY FOR WORLDWIDE INTERBANK FINANCIAL, TELECOMMUNICATION S.W.I.F.T",
			"issuing-agency":"SOCIETY FOR WORLDWIDE INTERBANK FINANCIAL, TELECOMMUNICATION S.W.I.F.T",
			"initial-release":"1.0.1",
			"state":"active",
			"structure":"RegEx: [A-Z]{2}[0-9]{2}[A-Z-0-9]{11,30}\nChecking: https://github.com/arthurdejong/python-stdnum/blob/master/stdnum/iban.py\nhttps://github.com/arthurdejong/python-stdnum/blob/master/stdnum/iban.dat",
			"registrable":true
		},
		{
			"schemeid":"AT:KUR",
			"iso6523":"9919",
			"country":"AT",
			"scheme-name":"Kennziffer des Unternehmensregisters",
			"initial-release":"1.0.2",
			"state":"active",
			"structure":"9 characters in total; letter, number x3, letter, number x3, letter",
			"usage":"Propose to deprecated",
			"registrable":true
		},
		{
			"schemeid":"ES:VAT",
			"iso6523":"9920",
			"country":"ES",
			"scheme-name":"Agencia EspaÃ±ola de AdministraciÃ³n Tributaria",
			"issuing-agency":"Agencia EspaÃ±ola de AdministraciÃ³n Tributaria",
			"initial-release":"1.0.2",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"IT:IPA",
			"iso6523":"9921",
			"country":"IT",
			"scheme-name":"Indice delle Pubbliche Amministrazioni",
			"issuing-agency":"Indice delle Pubbliche Amministrazioni",
			"initial-release":"1.1.0",
			"state":"removed",
			"deprecation-release":"6",
			"removal-date":"2023-11-30",
			"usage":"Propose to deprecate; not used in BIS 3",
			"registrable":false
		},
		{
			"schemeid":"AD:VAT",
			"iso6523":"9922",
			"country":"AD",
			"scheme-name":"Andorra VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"AL:VAT",
			"iso6523":"9923",
			"country":"AL",
			"scheme-name":"Albania VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"BA:VAT",
			"iso6523":"9924",
			"country":"BA",
			"scheme-name":"Bosnia and Herzegovina VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"BE:VAT",
			"iso6523":"9925",
			"country":"BE",
			"scheme-name":"Belgium VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"BG:VAT",
			"iso6523":"9926",
			"country":"BG",
			"scheme-name":"Bulgaria VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"CH:VAT",
			"iso6523":"9927",
			"country":"CH",
			"scheme-name":"Switzerland VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"CY:VAT",
			"iso6523":"9928",
			"country":"CY",
			"scheme-name":"Cyprus VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"CZ:VAT",
			"iso6523":"9929",
			"country":"CZ",
			"scheme-name":"Czech Republic VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"DE:VAT",
			"iso6523":"9930",
			"country":"DE",
			"scheme-name":"Germany VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"EE:VAT",
			"iso6523":"9931",
			"country":"EE",
			"scheme-name":"Estonia VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"GB:VAT",
			"iso6523":"9932",
			"country":"GB",
			"scheme-name":"United Kingdom VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"GR:VAT",
			"iso6523":"9933",
			"country":"GR",
			"scheme-name":"Greece VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"HR:VAT",
			"iso6523":"9934",
			"country":"HR",
			"scheme-name":"Croatia VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"IE:VAT",
			"iso6523":"9935",
			"country":"IE",
			"scheme-name":"Ireland VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"LI:VAT",
			"iso6523":"9936",
			"country":"LI",
			"scheme-name":"Liechtenstein VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"LT:VAT",
			"iso6523":"9937",
			"country":"LT",
			"scheme-name":"Lithuania VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"LU:VAT",
			"iso6523":"9938",
			"country":"LU",
			"scheme-name":"Luxemburg VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"LV:VAT",
			"iso6523":"9939",
			"country":"LV",
			"scheme-name":"Latvia VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"MC:VAT",
			"iso6523":"9940",
			"country":"MC",
			"scheme-name":"Monaco VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"ME:VAT",
			"iso6523":"9941",
			"country":"ME",
			"scheme-name":"Montenegro VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"MK:VAT",
			"iso6523":"9942",
			"country":"MK",
			"scheme-name":"Macedonia, the former Yugoslav Republic of VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"MT:VAT",
			"iso6523":"9943",
			"country":"MT",
			"scheme-name":"Malta VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"NL:VAT",
			"iso6523":"9944",
			"country":"NL",
			"scheme-name":"Netherlands VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"PL:VAT",
			"iso6523":"9945",
			"country":"PL",
			"scheme-name":"Poland VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"PT:VAT",
			"iso6523":"9946",
			"country":"PT",
			"scheme-name":"Portugal VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"RO:VAT",
			"iso6523":"9947",
			"country":"RO",
			"scheme-name":"Romania VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"RS:VAT",
			"iso6523":"9948",
			"country":"RS",
			"scheme-name":"Serbia VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"SI:VAT",
			"iso6523":"9949",
			"country":"SI",
			"scheme-name":"Slovenia VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"SK:VAT",
			"iso6523":"9950",
			"country":"SK",
			"scheme-name":"Slovakia VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"SM:VAT",
			"iso6523":"9951",
			"country":"SM",
			"scheme-name":"San Marino VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"TR:VAT",
			"iso6523":"9952",
			"country":"TR",
			"scheme-name":"Turkey VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"VA:VAT",
			"iso6523":"9953",
			"country":"VA",
			"scheme-name":"Holy See (Vatican City State) VAT number",
			"initial-release":"1.1.0",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"NL:OIN",
			"iso6523":"9954",
			"country":"NL",
			"scheme-name":"Dutch Originator's Identification Number",
			"initial-release":"1.1.3",
			"state":"deprecated",
			"deprecation-release":"2",
			"usage":"Deprecated by 0190",
			"registrable":true
		},
		{
			"schemeid":"SE:VAT",
			"iso6523":"9955",
			"country":"SE",
			"scheme-name":"Swedish VAT number",
			"initial-release":"1.2.0",
			"state":"removed",
			"deprecation-release":"8.4",
			"removal-date":"2023-07-31",
			"registrable":false
		},
		{
			"schemeid":"BE:CBE",
			"iso6523":"9956",
			"country":"BE",
			"scheme-name":"Belgian Crossroad Bank of Enterprise number",
			"issuing-agency":"Belgian Crossroad Bank of Enterprises",
			"initial-release":"1.2.1",
			"state":"removed",
			"deprecation-release":"7.4",
			"removal-date":"2023-12-31",
			"structure":"Format: 9.999.999.999 - Check: 99 = 97 - (9.999.999.9 modulo 97)",
			"examples":"0899965307",
			"validation-rules":"RegEx: 0[0-9]{9}\nCheck digit: mod97\nSee https://github.com/arthurdejong/python-stdnum/blob/master/stdnum/be/vat.py",
			"registrable":false
		},
		{
			"schemeid":"FR:VAT",
			"iso6523":"9957",
			"country":"FR",
			"scheme-name":"French VAT number",
			"initial-release":"1.2.1",
			"state":"active",
			"registrable":true
		},
		{
			"schemeid":"DE:LID",
			"iso6523":"9958",
			"country":"DE",
			"scheme-name":"Peppol-Leitweg-ID",
			"initial-release":"3",
			"state":"removed",
			"deprecation-release":"6",
			"removal-date":"2023-07-31",
			"usage":"Replaced by 0204",
			"registrable":false
		},
		{
			"schemeid":"US:EIN",
			"iso6523":"9959",
			"country":"US",
			"scheme-name":"US Employer ID Number",
			"initial-release":"8.3",
			"state":"active",
			"registrable":true
		}
	]
}

const store = Ext.create({
	xtype: 'jsonstore',
	fields: ['iso6523', 'scheme-name'],
	root: 'values',
	idProperty: 'iso6523',
	autoDestroy: false
});


// filter by country

Ext.define('go.modules.community.addressbook.ICDCombo',{
	extend: go.form.ComboBox,

	fieldLabel: t("ICD"),
	hiddenName: 'icd',
	emptyText: t("Please select..."),
	displayField : 'scheme-name',
	valueField: 'iso6523',
	triggerAction: 'all',
	editable: true,
	selectOnFocus: true,
	forceSelection: true,
	allowBlank: true,
	mode: "local",
	store: store,

	loadCountry: (country) => {

		const l = [];
		icdList.values.forEach(i => {
			if(i.country == country) {
				l.push(i);
			}
		})

		store.loadData({values: l}, false);
	}
});

Ext.reg("icdcombo", go.modules.community.addressbook.ICDCombo);
})();