GO.leavedays.MainPanel = function (config) {
	config = config || {};

	config.layout = 'border';
	config.border = false;

	this.yearsGrid = new GO.grid.GridPanel({
		border: false,
		layout: 'fit',
		title: t("Years", "leavedays"),
		region: 'west',
		width: 100,
		split: true,
		store: new GO.data.JsonStore({
			url: GO.url('leavedays/leaveday/yearsStore'),
			fields: ['year'],
			remoteSort: true
		}),
		cls: 'go-grid3-hide-headers',
		columns: [{
				header: t("Year", "leavedays"),
				dataIndex: 'year',
				id: 'year',
				width: 100
			}],
		view: new Ext.grid.GridView({
			forceFit: true,
			autoFill: true
		}),
		sm: new Ext.grid.RowSelectionModel({singleSelect: true})
	});


	if (GO.leavedays.currentUserIsManager) {

		this.yearsGrid.getSelectionModel().on('rowselect', function (rowSelectionModel, rowIndex, event) {
			const record = rowSelectionModel.getSelected();
			this._setYear(record.data['year']);
			this._setUserId(GO.settings.user_id);
			this._setAgreementId(record.data.business_agreement_id); // TODO
			this.userPanel.show({user_name: ''});
		}, this);

		var tbarItems = [
			{
				iconCls: 'ic-event-note',
				text: t("Month", "leavedays"),
				handler: function () {
					if (!this.monthView) {
						this.monthView = new GO.leavedays.MonthWindow();
					}
					this.monthView.show(this.yearsGrid.getSelectionModel().getSelected().data.year);
				},
				scope: this
			},
			{
				iconCls: 'ic-import-export',
				text: t("Export"),
				handler: function () {
					window.open(GO.url('leavedays/report/exportCsv', {'year': GO.leavedays.activeYear}));
				}
			}
		];

		this.yearSummaryGrid = new GO.grid.GridPanel({
			viewConfig: {
				emptyText: t("No items to display")
			},
			stateId: 'leavedays_year_summary_grid',
			border: false,
			layout: 'fit',
			region: 'center',
			paging: true,
			store: new GO.data.JsonStore({
				url: GO.url('leavedays/leaveday/yearSummaryStore'),
				fields: ['id', 'year', 'user_id', 'manager_user_id', 'manager_user_name', 'need_approve', 'user_name', 'leftover', 'year_credit', 'whole_year_credit', 'built_up_credit', 'credits_used', 'n_nat_holiday_hours', 'business_agreement_id'],
				remoteSort: true
			}),
			columns: [
				{
					header: t("Employee", "leavedays"),
					dataIndex: 'user_name',
					id: 'user_name',
					width: 200,
					renderer: function (v, m, record) {
						
						if (record.get('need_approve'))
							return '<b>' + v + '</b>';
						return v;
					},
					sortable: true,
					hideable: false
				}],
			sm: new Ext.grid.RowSelectionModel({singleSelect: true}),
			tbar: {enableOverflow:true,items:tbarItems}
		});

		this.userPanel = new GO.leavedays.UserPanel({region: 'east', split: true});
		config.items = [
			this.yearsGrid,
			this.yearSummaryGrid,
			this.userPanel
		];

		this.yearSummaryGrid.on('delayedrowselect', function (grid, rowIndex, event) {
			const summaryRecord = grid.store.getAt(rowIndex);
			this._setUserId(summaryRecord.data['user_id']);
			this._setAgreementId(summaryRecord.data['business_agreement_id']);
			this.userPanel.show({user_name: summaryRecord.data['user_name']});
			
		}, this);



		this.yearSummaryGrid.on('rowdblclick', function (grid, rowIndex, event) {
			const record = grid.store.getAt(rowIndex);
			let managerUserIds = [];
			if(record.get('manager_user_id')) {
				managerUserIds = record.get('manager_user_id').split(',');
			}

			// if you not the manager you cant edit it
			if(managerUserIds.indexOf(GO.settings.user_id) === -1 && !GO.settings.modules.leavedays.permission_level >= GO.permissionLevels.manage) {
				return false;
			}

			GO.leavedays.yearCreditDialog = new go.modules.business.business.AgreementDialog(); //GO.leavedays.YearCreditDialog();
			GO.leavedays.yearCreditDialog.on('save', function () {
				this.yearSummaryGrid.store.load();
			}, this);

			GO.leavedays.yearCreditDialog.load(record.id).show();

		}, this);


	} else {

		this.yearsGrid.getSelectionModel().on('rowselect', function (rowSelectionModel, rowIndex, event) {
			const record = rowSelectionModel.getSelected();
			this._setUserId(GO.settings.user_id);
			this._setYear(record.data['year']);
			this._setAgreementId(record.data['business_agreement_id']);

			this.userPanel.show({user_name: ''});
		}, this);

		this.userPanel = new GO.leavedays.UserPanel({region: 'center', split: true});
		config.items = [
			this.yearsGrid,
			this.userPanel
		];
	}

	GO.leavedays.MainPanel.superclass.constructor.call(this, config);

	this.on('afterrender', function (panel) {
		this.yearsGrid.store.load();
	}, this);

	this.yearsGrid.store.on('load', function (store, records, options) {
		if (!GO.util.empty(records[1])) {
			this.yearsGrid.getSelectionModel().selectRow(1);
		} else {
			this.yearsGrid.getSelectionModel().selectRow(0);
		}
	}, this);

}

Ext.extend(GO.leavedays.MainPanel, Ext.Panel, {
	
	initComponent: function (userId) {
		GO.leavedays.MainPanel.superclass.initComponent.call(this);
	},
	
	
	_setUserId: function (userId) {
		GO.leavedays.activeUserId = userId;
	},
	_setAgreementId: function (agreementId) {
		agreementId = agreementId || 0; // fall back to anything
		GO.leavedays.activeAgreementId = agreementId;
	},
	_setYear: function (fullYear) {
		GO.leavedays.activeYear = fullYear;
		if (GO.leavedays.currentUserIsManager) {
			this.yearSummaryGrid.store.baseParams['year'] = fullYear;
			this.loadConfig();
		}
	},
	
	
	loadConfig: function() {
		
		GO.request({
			url: 'leavedays/leaveday/gridConfig',
			success: function(options, response, result) {
				
				var fields = ['id','user_id','user_name','need_approve','company_name','manager_user_id','manager_user_name','business_agreement_id'];
				fields.push.apply(fields,result.data.storeFields);

				var columns = [{
					header: t("Employee", "leavedays"),
					dataIndex: 'user_name',
					id: 'user_name',
					width: 200,
					renderer: function (v, m, record) {
						if (record.get('need_approve')) {
							return '<strong>' + v + '</strong>';
						}
						return v;
					},
					sortable: true,
					hideable: false
				},{
					header: t("Manager", "business"),
					dataIndex: 'manager_user_name',
					id: 'manager_user_name',
					width: 200,
					sortable: false,
					hideable: false
				},{
					header: t("Business", "leavedays"),
					dataIndex: 'company_name',
					id: 'company_name',
					width: 200,
					sortable: true,
					hideable: false
				}];
				var cols = result.data.columns;
				for(var col = 0; col < cols.length; col++) {
					var l = cols[col].dataIndex.length;
					if(cols[col].dataIndex.substring(l-7, l) === '_credit'){
						cols[col].renderer = function(v,meta,record) {
							var type = this.dataIndex.slice(0,-7);
							return go.util.Format.number(record.data[type+'_total'] - record.data[type+'_used']);
						}
					} else {
						cols[col].renderer = function(v,meta,record,row,col) {
							return go.util.Format.number(v || 0);
						}
					}
				}

				columns.push.apply(columns,cols);



				const year = this.yearSummaryGrid.store.baseParams['year'];
				let store = this.reconfigureYearSummaryGrid(fields, columns);
				store.baseParams['year'] = year;
				this.yearSummaryGrid.getBottomToolbar().bindStore(store);
				this.yearSummaryGrid.initStateEvents();
				this.yearSummaryGrid.initState();

				store.load();
			},
			scope: this
		});
		
	},
	
	reconfigureYearSummaryGrid: function(storeFields, columns) {
		let store = new GO.data.JsonStore({
			url: GO.url('leavedays/leaveday/yearSummaryStore'),
			fields: storeFields,
			remoteSort: true,
			listeners: {
				load: function() {
					if(this.yearSummaryGrid.getStore().getCount()) {
						this.yearSummaryGrid.getSelectionModel().selectRow(0);
					}
				},
				scope:this
			}
		});
		this.yearSummaryGrid.reconfigure(store, new Ext.grid.ColumnModel(columns));
		return store;
	}

});

GO.mainLayout.onReady(function(){

	//register a new request to the checker. It will poll unseen holiday requests every two minutes

	if(go.Modules.isAvailable("legacy", 'leavedays')) {

		go.Notifier.addStatusIcon('leaveday', 'ic-beach-access');

		GO.checker.registerRequest("leavedays/leaveday/checkOpenRequests",{},function(checker, data){
			const openRequests = data.openRequests || 0;

			GO.mainLayout.setNotification('leavedays', openRequests, 'orange');

			if (!GO.leavedays.openRequests) {
				GO.leavedays.openRequests = openRequests;
			} else if (openRequests == 0 || GO.leavedays.openRequests == openRequests) {
				return;
			}

			if(GO.mainLayout.panelIsVisible('leavedays')) {
				var tp = GO.mainLayout.getModulePanel('leavedays');

				//compare the last unseen valie to the new unseen value
				if (openRequests > 0) {
					// Do the refresh thingy
					if (tp && tp.isVisible()) {
						tp.refresh();
					}
					let text = t('You have {openRequests} open request(s)', 'leavedays');
					go.Notifier.notify({
						description: text.replace('{openRequests}', openRequests),
						title: t('Open requests', 'leavedays'),
						tag: "leavedays"
					}, 'leaveday').catch((e) => {
						console.warn("Notification failed: " + e);
					});
				}
			}
			GO.leavedays.openRequests = openRequests;
		},this);
	}
});


/*
 * This will add the module to the main tabpanel filled with all the modules
 */

GO.moduleManager.addModule('leavedays', GO.leavedays.MainPanel, {
	title: t("Holidays", "leavedays"),
	iconCls: 'go-tab-icon-timeregistration'
});



GO.leavedays.showLeavedayDialog = function (leavedayRecordId, config) {
	if (!GO.leavedays.leavedayDialog) {
		GO.leavedays.leavedayDialog = new GO.leavedays.LeavedayDialog();

	}
	GO.leavedays.leavedayDialog.show(leavedayRecordId, {user_name: this._user_name, loadParams: {user_id: GO.leavedays.activeUserId}});
}

GO.leavedays.showSpecialLeaveDialog = function (id, config) {
	config = config || {user_name: this._user_name, loadParams: {agreement_id: GO.leavedays.activeAgreementId}};
	if (!GO.leavedays.specialLeaveDialog) {
		GO.leavedays.specialLeaveDialog = new GO.leavedays.SpecialLeaveDialog();
		GO.leavedays.specialLeaveDialog.addListener({
			'hide': function(panel) {
				// TODO: refresh currently selected tab. How though?
				GO.mainLayout.getModulePanel("leavedays").userPanel.reload();
			},
			scope: this
		});
	}
	GO.leavedays.specialLeaveDialog.show(id, config);
}

GO.leavedays.deleteSpecialLeaveBudget = function (id) {
	if(go.util.empty(id)) {
		return;
	}

	Ext.MessageBox.confirm(
		t('Confirm delete'),
		t('Are you sure you want to delete this item?'),
		(btn) => {
			if(btn !== 'yes') {
				return;
			}
			GO.request({
				url: 'leavedays/specialleavebudget/delete',
				params: {id: id},
				scope: this,
				success: function () {
					Ext.MessageBox.alert(t('Success'), t('The item was successfully deleted'))
					GO.mainLayout.getModulePanel("leavedays").userPanel.reload();
				}
			});
		}
	);
}
