GO.projects2.SubProjectsGrid = Ext.extend(GO.grid.GridPanel, {

	initComponent: function () {

		this.view = new Ext.grid.GridView({
			emptyText: t("No items to display")
		});

		var subProjectFields = {
			fields: ['id', 'name', 'reference_no', 'status_name', 'user_name', 'type_name', 'template_name', 'responsible_user_name', 'icon', 'start_time', 'due_time', 'customer_name', 'contact', 'ctime', 'mtime'].concat(go.customfields.CustomFields.getFieldDefinitions("Project")),
			columns: [{
					dataIndex: 'icon',
					xtype: 'iconcolumn'
				}, {
					header: 'ID',
					dataIndex: 'id',
					id: 'id',
					width: 50,
					hidden: true
				}, {
					header: t("Name"),
					dataIndex: 'name',
					id: 'name',
					width: dp(200)
				}, {
					header: t("Reference no.", "projects2"),
					dataIndex: 'reference_no',
					id: 'reference_no',
					width: 150,
					hidden: true
				}, {
					header: t("Status", "projects2"),
					dataIndex: 'status_name',
					id: 'status_name',
					width: 100
				}, {
					header: t("Start time", "projects2"),
					dataIndex: 'start_time',
					id: 'start_time',
					width: 100,
					scope: this,
					hidden: true
				}, {
					header: t("Due at", "projects2"),
					dataIndex: 'due_time',
					id: 'due_time',
					width: 100,
					scope: this
				}, {
					xtype: "datecolumn",
				  dataIndex: "ctime",
					header: t("Created at"),
					hidden: true
				}, {
					xtype: "datecolumn",
					dataIndex: "mtime",
					header: t("Modified at"),
					hidden: true
				}, {
					header: t("User"),
					dataIndex: 'user_name',
					id: 'user_name',
					width: 150,
					sortable: false,
					hidden: true
				}, {
					header: t("Permission type", "projects2"),
					dataIndex: 'type_name',
					id: 'type_name',
					width: 80,
					hidden: true
				}, {
					header: t("Template", "projects2"),
					dataIndex: 'template_name',
					id: 'template_name',
					width: 80,
					hidden: true
				}, {
					header: t("Manager", "projects2"),
					dataIndex: 'responsible_user_name',
					id: 'responsible_user_name',
					width: 120,
					sortable: false,
					hidden: true
				}, {
					header: t("Customer", "projects2"),
					dataIndex: 'customer_name',
					id: 'customer_name',
					width: 150,
					sortable: false
				}, {
					header: t("Contact", "projects2"),
					dataIndex: 'contact',
					id: 'contact',
					width: 120,
					sortable: false,
					hidden: true
				}].concat(go.customfields.CustomFields.getColumns("Project"))
		}

		this.store = new GO.data.JsonStore({
			url: GO.url('projects2/project/store'),
			baseParams: {
				parent_project_id: 0
			},
			root: 'results',
			totalProperty: 'total',
			id: 'id',
			fields: subProjectFields.fields,
			remoteSort: true
		});

		Ext.apply(this, {
			border: false,
			enableDragDrop: true,
			ddGroup: 'ProjectsDD',
			split: true,
			autoScroll: true,
			paging: true,
			cm: new Ext.grid.ColumnModel({
				defaultSortable: true,
				columns: subProjectFields.columns

			}),
			scope: this
		});

		GO.projects2.SubProjectsGrid.superclass.initComponent.call(this);
	},

	setParentProjectId: function(id) {
		this.store.baseParams.parent_project_id = id;
		this.store.load();
	}

});
