import { createComponent } from "../Component.js";
import { InputField } from "./InputField";
/**
 * Text Area component
 *
 * @see Form
 */
export class TextAreaField extends InputField {
    constructor() {
        super(...arguments);
        this.baseCls = 'goui-form-field textarea';
        this._autoHeight = false;
    }
    createInput() {
        const control = document.createElement("textarea");
        control.on("change", () => {
            this.fireChange();
        });
        if (this.invalidMsg) {
            this.applyInvalidMsg();
        }
        return control;
    }
    /**
     * Let the textarea grow to it's content
     *
     * @param v
     */
    set autoHeight(v) {
        if (this._autoHeight)
            return;
        this._autoHeight = true;
        const input = this._input;
        input.rows = 1;
        input.style.overflowY = 'hidden';
        input.on('input', (ev) => {
            this.resize(input);
        });
        this.on("render", () => { this.resize(input); });
        this.on('setvalue', () => { this.resize(input); });
    }
    get autoHeight() {
        return this._autoHeight;
    }
    resize(input) {
        input.style.height = "0";
        input.style.height = (input.scrollHeight) + "px";
    }
}
/**
 * Shorthand function to create {@see TextAreaField}
 *
 * @param config
 */
export const textarea = (config) => createComponent(new TextAreaField(), config);
//# sourceMappingURL=TextareaField.js.map