<?php

namespace go\core\customfield;

use go\core\db\Criteria;
use go\core\orm\Entity;
use go\core\orm\Filters;
use go\core\orm\Query;

class Number extends Base {

	/**
	 * Get column definition for SQL
	 *
	 * @return string
	 */
	protected function getFieldSQL(): string
	{
		$d = $this->field->getDefault();
		$d = isset($d) && $d != "" ? number_format($d, 4) : "NULL";
		
		$decimals = ((int)$this->field->getOption('numberDecimals')) + 2;
		
		return "decimal(19,$decimals) DEFAULT " . $d;
	}
	
	/**
	 * Defines an entity filter for this field.
	 * 
	 * @see Entity::defineFilters()
	 * @param Filters $filters
	 */
	public function defineFilter(Filters $filters) {		
		
		$filters->addNumber($this->field->databaseName, function(Criteria $criteria, $comparator, $value, Query $query, array $filter){
			$this->joinCustomFieldsTable($query);						
			$criteria->where('customFields.' . $this->field->databaseName, $comparator, $value);
		});
	}

	public function dbToApi($value, \go\core\orm\CustomFieldsModel $values, $entity)
	{
		return $value;
	}
}
