Ext.define('go.modules.business.business.ActivityCombo',{
	extend: go.form.ComboBoxReset,

	fieldLabel: t("Activity"),
	hiddenName: 'activityId',
	emptyText: t("Please select..."),
	displayField : 'name',
	valueField: 'id',
	triggerAction: 'all',
	editable: true,
	selectOnFocus: true,
	forceSelection: true,
	allowBlank: false,
	activityType: 'work',
	tpl: '<tpl for=".">'+
		'<div ext:qtip="{description}" class="x-combo-list-item">{name} '+
		  '<tpl if="values.billable"><small style=color:gray;> ('+t("Billable")+')</small></tpl>'+
		'</div>'+
		'</tpl>',
	initComponent: function() {

		this.store =  new go.data.Store({
			fields: ['id', 'name', 'description', 'billable','units'],
			entityStore: "Activity"
		});
		this.store.setFilter('active', {disabled: false});
		if(!Ext.isEmpty(this.activityType)) {
			this.store.setFilter('type', {type: this.activityType});
		}

		this.callParent();
	}
});